/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.common;

import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.common.IBudgetView;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class BudgetViewLoaderImpl
implements IBudgetView {
    private static final Logger logger = Logger.getLogger(BudgetViewLoaderImpl.class);
    public static final String demofile = "com/kingdee/eas/ma/view/client/config/dimension.xml";

    public static IBudgetView getIntance() {
        return new BudgetViewLoaderImpl();
    }

    @Override
    public void load(IBgDimensionManager bgDimensionManager, byte[] bytes) throws Exception {
        Element view;
        if (bgDimensionManager == null || bytes == null) {
            return;
        }
        logger.info((Object)"----- begin load bgDimension Info -----");
        bgDimensionManager.clear();
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)new ByteArrayInputStream(bytes));
        if (document != null && document.getRootElement() != null && (view = document.getRootElement()) != null && "view".equalsIgnoreCase(view.getName())) {
            Element config;
            Element dim = view.element("dimension");
            if (dim != null) {
                Iterator itM = dim.elementIterator();
                while (itM.hasNext()) {
                    Element member = (Element)itM.next();
                    String type = BgViewHelper.getElementValue(member, "type");
                    String value = BgViewHelper.getElementValue(member, "value");
                    String attribute = BgViewHelper.getElementValue(member, "attribute");
                    String layout = BgViewHelper.getElementValue(member, "layout");
                    String showType = BgViewHelper.getElementValue(member, "showType");
                    this.addDimension(bgDimensionManager, type, value, attribute, layout, showType);
                }
            }
            if ((config = view.element("config")) != null) {
                String rowAddMember = BgViewHelper.getElementValue(config, "rowAddMember");
                bgDimensionManager.setRowAddMember(Boolean.TRUE.toString().equalsIgnoreCase(rowAddMember));
                String rowShowLevel = BgViewHelper.getElementValue(config, "rowShowLevel");
                bgDimensionManager.setRowShowLevel(Boolean.TRUE.toString().equalsIgnoreCase(rowShowLevel));
            }
        }
        bgDimensionManager.verifyData();
        logger.info((Object)"----- end load bgDimension Info ------");
    }

    @Override
    public void loadStyle(IBgDimensionManager bgDimensionManager, byte[] bytes) throws Exception {
        if (bytes == null) {
            bgDimensionManager.getPageDisplayDimension().addAll(bgDimensionManager.getPageDimension());
            bgDimensionManager.getRowDisplayDimension().addAll(bgDimensionManager.getRowDimension());
            bgDimensionManager.getColDisplayDimension().addAll(bgDimensionManager.getColDimension());
            bgDimensionManager.copyStyleToOld();
            return;
        }
        List dimensionList = bgDimensionManager.getDimension();
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)new ByteArrayInputStream(bytes));
        Element view = document.getRootElement();
        this.loadStyle(bgDimensionManager.getPageDisplayDimension(), dimensionList, "page", view);
        this.loadStyle(bgDimensionManager.getRowDisplayDimension(), dimensionList, "row", view);
        this.loadStyle(bgDimensionManager.getColDisplayDimension(), dimensionList, "col", view);
        bgDimensionManager.copyStyleToOld();
    }

    private void loadStyle(List<BgDimensionInfo> targetDimens, List<BgDimensionInfo> dimensionList, String layoutType, Element view) {
        Element element = view.element(layoutType);
        if (element != null) {
            Iterator iterator = element.elementIterator();
            while (iterator.hasNext()) {
                Element member = (Element)iterator.next();
                String type = BgViewHelper.getElementValue(member, "type");
                String attribute = BgViewHelper.getElementValue(member, "attribute");
                for (BgDimensionInfo dimensionInfo : dimensionList) {
                    if (!"BGITEM".equalsIgnoreCase(type)) {
                        if (!type.equals(dimensionInfo.getType())) continue;
                        targetDimens.add(dimensionInfo);
                        continue;
                    }
                    if (!type.equals(dimensionInfo.getType()) || !attribute.equalsIgnoreCase(dimensionInfo.getAttribute())) continue;
                    targetDimens.add(dimensionInfo);
                }
            }
        }
    }

    public void addDimension(IBgDimensionManager bgDimensionManager, String type, String value, String attribute, String layout, String showType) {
        BgDimensionInfo dimensionInfo = new BgDimensionInfo();
        dimensionInfo.setType(type);
        dimensionInfo.setValue(value);
        dimensionInfo.setAttribute(attribute);
        dimensionInfo.setLayout(layout);
        dimensionInfo.setShowType(showType);
        bgDimensionManager.addDimensionInfo(dimensionInfo);
    }
}

