/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.io.kml.BookToKml;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BookParseHelper;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ActionMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class BgViewHelper {
    private static final Logger logger = Logger.getLogger((String)BgViewHelper.class.getName());
    public static final String PAGELAYOUT = "page";
    public static final String COLLAYOUT = "col";
    public static final String ROWLAYOUT = "row";
    public static final String BGITEM = "BGITEM";
    public static final String CURRENCY = "CURRENCY";
    public static final String BGPERIOD = "BGPERIOD";
    public static final String BGELEMENT = "BGELEMENT";
    public static final String ORGUNIT = "ORGUNIT";
    public static final String ROWSHOWLEVEL = "rowShowLevel";
    public static final String ROWADDMEMBER = "rowAddMember";
    public static final String DIMENSION = "DIMENSION";
    public static final String DIMENSION_ORGUNIT = "orgunit";
    public static final String DIMENSION_BGITEM = "bgitem";
    public static final String DIMENSION_BGPERIOD = "bgperiod";
    public static final String DIMENSION_BGELEMENT = "bgelement";
    public static final String DIMENSION_CURRENCY = "currency";
    public static final String ENCODING = "UTF-8";
    public static final String isDisplayCJ = "displayCJ";
    public static final String isAllowUserAddDimension = "allowUserAddDimension";
    public static final String DOCUMENT_VIEW = "view";
    public static final String DOCUMENT_PAGE = "page";
    public static final String DOCUMENT_ROW = "row";
    public static final String DOCUMENT_COL = "col";
    public static final String DOCUMENT_DIMENSION = "dimension";
    public static final String DOCUMENT_MEMBER = "member";
    public static final String DOCUMENT_CONFIG = "config";
    public static final String DOCUMENT_TYPE = "type";
    public static final String DOCUMENT_VALUE = "value";
    public static final String DOCUMENT_ATTRIBUTE = "attribute";
    public static final String DOCUMENT_LAYOUT = "layout";
    public static final String DOCUMENT_SHOW_TYPE = "showType";
    private static List dimensionList = new ArrayList();
    private static Map paramterMap = new HashMap();

    public static int getSelectedRowIndex(KDTable table) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        int selectIndex = -1;
        if (selectRows != null && selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        return selectIndex;
    }

    public static List getSelectRowIndexes(KDTable table) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        if (table.getRowCount() > 0 && table.getSelectManager().size() != 0) {
            for (int i = 0; i < table.getSelectManager().size(); ++i) {
                KDTSelectBlock block = table.getSelectManager().get(i);
                if (block != null && block.getMode() == 4) {
                    block.setTop(0);
                }
                int beginRow = BgViewHelper.getBeginRow(block, table);
                int endRow = BgViewHelper.getEndRow(block, table);
                for (int r = beginRow; r <= endRow; ++r) {
                    rows.add(new Integer(r));
                }
            }
        }
        return rows;
    }

    public static int getBeginRow(KDTSelectBlock block, KDTable table) {
        if (block == null || table == null) {
            return -1;
        }
        return KDTSelectBlock.change((KDTable)table, (IBlock)block).getTop();
    }

    public static int getEndRow(KDTSelectBlock block, KDTable table) {
        if (block == null || table == null) {
            return -1;
        }
        return KDTSelectBlock.change((KDTable)table, (IBlock)block).getBottom();
    }

    public static void removeRows(KDTable table) {
        List rows = BgViewHelper.getSelectRowIndexes(table);
        if (rows != null && !rows.isEmpty()) {
            Collections.sort((List)rows);
            for (int i = rows.size() - 1; i >= 0; --i) {
                table.removeRow(((Integer)rows.get(i)).intValue());
            }
        }
    }

    public static void removeRows(KDTable table, int notDeletedRowIndex) {
        List rows = BgViewHelper.getSelectRowIndexes(table);
        if (rows != null && !rows.isEmpty()) {
            Collections.sort((List)rows);
            for (int i = rows.size() - 1; i >= 0; --i) {
                if (table.getRowCount() == 1 || notDeletedRowIndex == (Integer)rows.get(i)) continue;
                table.removeRow(((Integer)rows.get(i)).intValue());
            }
        }
    }

    public static void removeEditHelper(KDTable table) {
        if (table != null) {
            ActionMap am = table.getActionMap();
            am.remove("Cut");
            am.remove("Paste");
            am.remove("Copy");
        }
    }

    public static void writeXMLFile(String outfile, List list, Map config) {
        if (StringUtils.isEmpty((String)outfile) || list == null || list.isEmpty()) {
            return;
        }
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outfile));
            BgViewHelper.writeXMLStream(bos, list, config);
            bos.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public static void writeXMLStream(OutputStream os, List list, Map config) {
        if (os == null || list == null || list.isEmpty()) {
            return;
        }
        Document doc = BgViewHelper.buildDocument(list, config);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(ENCODING);
        XMLWriter writer = null;
        try {
            writer = new XMLWriter(os, format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public static void writeStyle(OutputStream os, IBgDimensionManager bm) {
        if (os == null || bm == null) {
            return;
        }
        Document doc = BgViewHelper.buildStyleDocument(bm);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(ENCODING);
        XMLWriter writer = null;
        try {
            writer = new XMLWriter(os, format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private static Document buildStyleDocument(IBgDimensionManager bm) {
        if (bm == null) {
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        Element view = doc.addElement(DOCUMENT_VIEW);
        BgViewHelper.buildStyleDocument(view, "page", bm.getPageDisplayDimension());
        BgViewHelper.buildStyleDocument(view, "col", bm.getColDisplayDimension());
        BgViewHelper.buildStyleDocument(view, "row", bm.getRowDisplayDimension());
        return doc;
    }

    private static void buildStyleDocument(Element parent, String type, List dimens) {
        if (parent == null || StringUtils.isEmpty((String)type) || dimens == null || dimens.isEmpty()) {
            return;
        }
        Element sub = parent.addElement(type);
        for (int i = 0; i < dimens.size(); ++i) {
            BgDimensionInfo dimen = (BgDimensionInfo)dimens.get(i);
            Element dimElement = sub.addElement(DOCUMENT_DIMENSION);
            dimElement.addElement(DOCUMENT_TYPE).setText(dimen.getType());
            dimElement.addElement(DOCUMENT_ATTRIBUTE).setText(dimen.getAttribute());
        }
    }

    private static Document buildDocument(List list, Map config) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        Element view = doc.addElement(DOCUMENT_VIEW);
        Element dimension = view.addElement(DOCUMENT_DIMENSION);
        for (BgDimensionInfo info : list) {
            Element member = dimension.addElement(DOCUMENT_MEMBER);
            member.addElement(DOCUMENT_TYPE).setText(String.valueOf(info.getType()));
            member.addElement(DOCUMENT_VALUE).setText(StringUtils.isEmpty((String)info.getValue()) ? "" : info.getValue());
            member.addElement(DOCUMENT_ATTRIBUTE).setText(info.getAttribute() == null ? "" : info.getAttribute());
            member.addElement(DOCUMENT_LAYOUT).setText(info.getLayout());
            member.addElement(DOCUMENT_SHOW_TYPE).setText(info.getShowType() == null ? "NAME" : info.getShowType());
        }
        if (config != null && !config.isEmpty()) {
            Element cElement = view.addElement(DOCUMENT_CONFIG);
            for (String key : config.keySet()) {
                Object value = config.get(key);
                if (value == null) continue;
                cElement.addElement(key).setText(String.valueOf(value));
            }
        }
        return doc;
    }

    public static void writePreparedStatement(PreparedStatement pstmt, int index, List list, Map config) throws SQLException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BgViewHelper.writeXMLStream(bos, list, config);
        byte[] bytes = bos.toByteArray();
        pstmt.setBinaryStream(index, (InputStream)new SerializableByteArrayInputStream(bytes), bytes.length);
    }

    public static File toExcelFile(Book book) throws Exception {
        if (book != null) {
            ExportManager exportM = new ExportManager();
            String path = null;
            File tempFile = File.createTempFile("eas_temp_report", ".xls");
            path = tempFile.getCanonicalPath();
            try {
                KDSBook kds = BookToKDSBook.traslate((Book)book);
                exportM.exportToExcel(kds, path);
            }
            catch (POIExportException e9) {
                throw new Exception(RptUtil.getResourceSince51((String)"cannotTransExcel"));
            }
            return new File(path);
        }
        return null;
    }

    public static File toXmlFile(Book book, String[] sheetNames, String fileName) throws Exception {
        if (book == null) {
            return null;
        }
        String path = null;
        if (fileName == null) {
            File tempFile = File.createTempFile("eas_temp_report", ".xls");
            path = tempFile.getCanonicalPath();
        } else {
            path = fileName;
        }
        BookIOController bookio = new BookIOController();
        bookio.setForExcel(true);
        bookio.setShouldClone(false);
        bookio.setShouldReplaceSuffix(true);
        BookToKml kml = new BookToKml();
        kml.setBookIOController(bookio);
        kml.export(book, path, sheetNames);
        return new File(path);
    }

    public static File toHTMLFile(Book book) throws Exception {
        if (book != null) {
            ExportManager exportM = new ExportManager();
            String path = null;
            File tempFile = File.createTempFile("eas_temp_report", ".html");
            path = tempFile.getCanonicalPath();
            KDSBook kds = BookToKDSBook.traslate((Book)book);
            PrintableBook prtbook = new PrintableBook(kds);
            exportM.exportToHtmlFile(prtbook, path);
            File file = new File(path);
            return file;
        }
        return null;
    }

    public static Object parseFile(IBgDimensionManager bgDimensionManager, byte[] re) throws Exception {
        if (re == null || re.length == 0) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(re);
        byte[] bytes = new byte[bis.available()];
        bis.read(bytes);
        return new BookParseHelper(bgDimensionManager).getBook(bytes);
    }

    public static byte[] upParse(List list, Map config) throws TransformerFactoryConfigurationError, TransformerException, SAXException, IOException, ParserConfigurationException {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BgViewHelper.writeXMLStream(bos, list, config);
        return bos.toByteArray();
    }

    public static String getElementValue(Element element, String key) {
        if (element != null && !StringUtils.isEmpty((String)key)) {
            return element.elementText(key);
        }
        return null;
    }

    public static List parseData(byte[] re) throws Exception {
        if (re == null || re.length == 0) {
            return null;
        }
        dimensionList.clear();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.push(BgViewHelper.class.newInstance());
        digester.addCallMethod("view/dimension/member", "parseDateToList", 5);
        digester.addCallParam("view/dimension/member/type", 0);
        digester.addCallParam("view/dimension/member/value", 1);
        digester.addCallParam("view/dimension/member/attribute", 2);
        digester.addCallParam("view/dimension/member/layout", 3);
        digester.addCallParam("view/dimension/member/showType", 4);
        try {
            digester.parse((InputStream)new ByteArrayInputStream(re));
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (SAXException ex) {
            throw ex;
        }
        return dimensionList;
    }

    public void parseDateToList(String type, String value, String attribute, String layout, String showType) {
        BgDimensionInfo dimensionInfo = new BgDimensionInfo();
        dimensionInfo.setType(type);
        dimensionInfo.setValue(value);
        dimensionInfo.setAttribute(attribute);
        dimensionInfo.setLayout(layout);
        dimensionInfo.setShowType(showType);
        dimensionList.add(dimensionInfo);
    }

    public static Map parseParamter(byte[] bytes) throws Exception {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        paramterMap.clear();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.push(BgViewHelper.class.newInstance());
        digester.addCallMethod("view/config", "getParamter", 2);
        digester.addCallParam("view/config/rowAddMember", 0);
        digester.addCallParam("view/config/rowShowLevel", 1);
        try {
            digester.parse((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (SAXException ex) {
            throw ex;
        }
        return paramterMap;
    }

    public Map getParamter(String rowAddMember, String rowShowLevel) {
        if (StringUtils.isEmpty((String)rowShowLevel)) {
            paramterMap.put(isDisplayCJ, false);
        } else {
            paramterMap.put(isDisplayCJ, Boolean.parseBoolean(rowShowLevel));
        }
        if (StringUtils.isEmpty((String)rowAddMember)) {
            paramterMap.put(isAllowUserAddDimension, false);
        } else {
            paramterMap.put(isAllowUserAddDimension, Boolean.parseBoolean(rowAddMember));
        }
        return paramterMap;
    }

    public static List getCurrPageMember(List f7List, List pageDimension) {
        ArrayList<BgDimensionMember> list = new ArrayList<BgDimensionMember>();
        if (f7List != null && !f7List.isEmpty() || pageDimension == null || pageDimension.isEmpty()) {
            BgDimensionInfo dimen;
            int i;
            HashMap<String, BgDimensionInfo> dimens = new HashMap<String, BgDimensionInfo>();
            for (i = 0; i < pageDimension.size(); ++i) {
                dimen = (BgDimensionInfo)pageDimension.get(i);
                dimens.put(dimen.getAttributeNumber(), dimen);
            }
            block1: for (i = 0; i < f7List.size(); ++i) {
                Component componet = (Component)f7List.get(i);
                Object data = null;
                if (componet instanceof KDBizPromptBox) {
                    data = ((KDBizPromptBox)componet).getData();
                } else if (componet instanceof KDComboBox) {
                    data = ((KDComboBox)componet).getSelectedItem();
                }
                dimen = (BgDimensionInfo)dimens.get(componet.getName());
                if (dimen == null) continue;
                if (data instanceof BgDimensionMember) {
                    list.add((BgDimensionMember)data);
                    continue;
                }
                String number = BgViewHelper.getNumber(data);
                for (int m = 0; m < dimen.getMember().size(); ++m) {
                    BgDimensionMember member = (BgDimensionMember)dimen.getMember().get(m);
                    if (!member.getNumber().equals(number)) continue;
                    list.add(member);
                    continue block1;
                }
            }
        }
        return list;
    }

    public static String getNumber(Object obj) {
        if (obj instanceof BgDimensionMember) {
            return ((BgDimensionMember)obj).getNumber();
        }
        if (obj instanceof IObjectValue) {
            return String.valueOf(((IObjectValue)obj).get("number"));
        }
        if (obj instanceof BgItemObject) {
            return ((BgItemObject)obj).getResult().get(0).getNumber();
        }
        return null;
    }

    public static BigDecimal getNumeric(Cell cell, BigDecimal defaultValue) {
        if (cell != null && cell.getValue() != Variant.nullVariant) {
            if (cell.getValue().getValue() instanceof BigDecimal) {
                return (BigDecimal)cell.getValue().getValue();
            }
            try {
                return new BigDecimal(String.valueOf(cell.getValue().getValue()).trim().replaceAll(",", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean checkHasRoll(BgFormInfo bgFormInfo) {
        return bgFormInfo.getBgPeriod() != null && bgFormInfo.getBgRollPeriod() != null && !bgFormInfo.getBgPeriod().getNumber().equalsIgnoreCase(bgFormInfo.getBgRollPeriod().getNumber());
    }

    public static List getHasRollForm(List billIds) throws EASBizException, BOSException {
        ArrayList<String> res = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(billIds), CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgPeriod.number");
        sic.add("bgRollPeriod.number");
        view.setSelector(sic);
        BgFormCollection bgFormInfoCol = BgFormFactory.getRemoteInstance().getBgFormCollection(view);
        for (int i = 0; i < bgFormInfoCol.size(); ++i) {
            if (!BgViewHelper.checkHasRoll(bgFormInfoCol.get(i))) continue;
            res.add(bgFormInfoCol.get(i).getId().toString());
        }
        return res;
    }

    public static boolean compareDivValue(BigDecimal newValue, BigDecimal oldValue) {
        boolean re;
        if (newValue != null && oldValue == null) {
            return false;
        }
        if (newValue == null) {
            newValue = BgConstants.BIGZERO;
        }
        if (oldValue == null) {
            oldValue = BgConstants.BIGZERO;
        }
        boolean bl = re = newValue.compareTo(oldValue) == 0;
        if (!re && newValue.subtract(oldValue).abs().compareTo(BgNConstants.DIVVALUE) <= 0) {
            re = true;
        }
        return re;
    }
}

