/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.util;

import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTHead;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.log4j.Logger;

public class UISetting
implements Serializable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.common.util.UISetting");
    private static final long serialVersionUID = 8578048303819236675L;
    private String uiClassName;
    private String fieldName;
    private String colName;
    private transient Field fieldInstance;

    public String getUiClassName() {
        return this.uiClassName;
    }

    public void setUiClassName(String uiClassName) {
        this.uiClassName = uiClassName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getColName() {
        return this.colName;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public UISetting() {
    }

    public UISetting(String uiClassName, String fieldName, String colName) {
        this.uiClassName = uiClassName;
        this.fieldName = fieldName;
        this.colName = colName;
    }

    public void setDisplayName(CoreUIObject ui, String displayName) throws Exception {
        Field fieldInstance = this.getField(ui);
        if (fieldInstance == null) {
            return;
        }
        Class<?> typeClass = fieldInstance.getType();
        if (typeClass.getName().equalsIgnoreCase(KDTable.class.getName())) {
            KDTable kdtable = (KDTable)fieldInstance.get(ui);
            KDTHead tblHead = kdtable.getHead();
            KDTColumns cols = kdtable.getColumns();
            int rowCount = tblHead.size();
            for (int i = 0; i < rowCount; ++i) {
                int colCount = cols.size();
                for (int j = 0; j < colCount; ++j) {
                    if (!cols.getColumnKey(j).equalsIgnoreCase(this.colName)) continue;
                    tblHead.getRow(i).getCell(j).setValue((Object)displayName);
                }
            }
        } else if (typeClass.getName().equalsIgnoreCase(KDLabelContainer.class.getName())) {
            KDLabelContainer lblTrackNum = (KDLabelContainer)fieldInstance.get(ui);
            lblTrackNum.setBoundLabelText(displayName);
        } else if (typeClass.getName().equalsIgnoreCase(KDTabbedPane.class.getName())) {
            KDTabbedPane lblTrackNum = (KDTabbedPane)fieldInstance.get(ui);
            if (lblTrackNum.getComponentCount() < 0) {
                return;
            }
            lblTrackNum.setTitleAt(0, displayName);
        }
    }

    private Field getField(CoreUIObject ui) throws Exception {
        Class<?> uiClazz = ui.getClass();
        Class<?> uiSuperClazz = null;
        while (this.fieldInstance == null) {
            uiSuperClazz = uiClazz.getSuperclass();
            try {
                this.fieldInstance = uiSuperClazz.getDeclaredField(this.fieldName);
            }
            catch (NoSuchFieldException e) {
                uiClazz = uiSuperClazz;
            }
            catch (NullPointerException e) {
                logger.error((Object)("no such field,can not find the attribute " + this.fieldName));
                break;
            }
            if (this.fieldInstance == null) continue;
            this.fieldInstance.setAccessible(true);
        }
        return this.fieldInstance;
    }
}

