/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.common.UISettingFacadeFactory;
import com.kingdee.eas.mm.common.util.UISetting;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;

public class UISettingFactory {
    private static UISettingFactory instance = null;
    private static String trackNumDisplayName;
    private static String trackNumKey;
    private static UISetting[] uiSettings;

    protected UISettingFactory() {
    }

    public static synchronized UISettingFactory getInstance() throws BOSException {
        if (instance == null) {
            UISettingFactory.findUISeting();
            instance = new UISettingFactory();
        }
        return instance;
    }

    public void displayTrackName(CoreUIObject ui) throws Exception {
        for (int i = 0; i < uiSettings.length; ++i) {
            if (!uiSettings[i].getUiClassName().equalsIgnoreCase(ui.getClass().getName())) continue;
            uiSettings[i].setDisplayName(ui, trackNumDisplayName);
        }
    }

    public static void findUISeting() throws BOSException {
        List uiSettingInfoList = UISettingFacadeFactory.getRemoteInstance().findUISettingDetail(trackNumKey);
        IRowSet uiRowset = null;
        if (uiSettingInfoList.size() > 0 && uiSettingInfoList.get(0) instanceof IRowSet) {
            uiRowset = (IRowSet)uiSettingInfoList.get(0);
            trackNumDisplayName = uiSettingInfoList.get(1).toString();
        }
        if (null != uiRowset) {
            uiSettings = new UISetting[uiRowset.size()];
        }
        uiSettings = new UISetting[uiRowset.size()];
        try {
            int i = 0;
            int n = uiRowset.size();
            while (uiRowset.next()) {
                UISettingFactory.uiSettings[i] = new UISetting(uiRowset.getString(1), uiRowset.getString(2), uiRowset.getString(3));
                ++i;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public String getTrackNumDisPlayName() {
        return trackNumDisplayName;
    }

    static {
        trackNumKey = "TRACK_NUMBER_NAME";
    }
}

