/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommonUtils {
    protected static final Logger logger = MMLogger.getLogger();

    public static boolean hasDownstreamBill(Context ctx, String bosType, String billId) throws BOSException {
        if (null == ctx || null == bosType || null == billId) {
            throw new BOSException("The parameter of CommonUtils#hasDownstreamBill method is null");
        }
        boolean has = false;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)bosType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billId, CompareType.EQUALS));
        view.setSelector(sic);
        view.setFilter(filterInfo);
        BOTRelationCollection collection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (null != collection && collection.size() > 0) {
            has = true;
        }
        return has;
    }

    public static BOTRelationCollection getDownstreamBill(Context ctx, String srcId, SCMBillBaseInfo src, SCMBillBaseInfo desc) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String srcEntityid = src.getBOSType().toString();
        String descEntityid = desc.getBOSType().toString();
        if (src != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcEntityid, CompareType.EQUALS));
        }
        if (desc != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)descEntityid, CompareType.EQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        BOTRelationCollection collection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            return collection;
        }
        return null;
    }

    public static BTPTransformResult mapppingToBills(Context ctx, String[] properties, HashMap[] valuesMap, BOSObjectType soruceBOSType, BOSObjectType destBOSType, String botpID, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        BTPTransformResult btpResult = null;
        CoreBillBaseCollection cbc = new CoreBillBaseCollection();
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)soruceBOSType);
        CoreBaseCollection coreBaseCollection = coreBase.getCollection(viewInfo);
        if (properties != null && valuesMap != null) {
            for (int i = 0; i < coreBaseCollection.size(); ++i) {
                CoreBaseInfo coreBaseInfo = coreBaseCollection.get(i);
                for (int j = 0; j < properties.length; ++j) {
                    String field = properties[j];
                    int index = field.indexOf(".");
                    if (index == -1) {
                        String billID = coreBaseInfo.getId().toString();
                        coreBaseInfo.put(field, valuesMap[j].get(billID));
                        continue;
                    }
                    String entryName = field.substring(0, index);
                    IObjectCollection collection = (IObjectCollection)coreBaseInfo.get(entryName);
                    for (int k = 0; k < collection.size(); ++k) {
                        CoreBaseInfo entryInfo = (CoreBaseInfo)collection.getObject(k);
                        String entryID = entryInfo.getId().toString();
                        entryInfo.put(field.substring(index + 1, field.length()), valuesMap[j].get(entryID));
                    }
                }
                CoreBaseInfo ov = coreBaseInfo;
                cbc.addObject((IObjectValue)ov);
            }
        } else {
            for (int j = 0; j < coreBaseCollection.size(); ++j) {
                IObjectValue ov = coreBaseCollection.getObject(j);
                cbc.addObject(ov);
            }
        }
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (botpID == null || botpID.equals("")) {
            IBOTMapping ibt = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingCollection collection = ibt.getMappingCollectionForSelect(cbc, destBOSType.toString(), DefineSysEnum.BTP);
            botpID = collection.get(0).getId().toString();
        }
        btpResult = iBTPManager.transformForBotp(cbc, destBOSType.toString(), (IObjectPK)new ObjectUuidPK(botpID));
        return btpResult;
    }

    public static BTPTransformResult mapppingToBills2(Context ctx, String[] properties, HashMap[] valuesMap, BOSObjectType soruceBOSType, BOSObjectType destBOSType, String botpID, IObjectCollection coreBaseCollection, boolean isSave) throws BOSException, EASBizException {
        IObjectCollection destBillCols = null;
        BTPTransformResult btpResult = null;
        BOTRelationCollection botRelationCols = null;
        CoreBillBaseCollection cbc = new CoreBillBaseCollection();
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"19_CommonUtils", (Locale)ctx.getLocale()));
        if (properties != null && valuesMap != null) {
            for (int i = 0; i < coreBaseCollection.size(); ++i) {
                CoreBaseInfo coreBaseInfo = (CoreBaseInfo)coreBaseCollection.getObject(i);
                for (int j = 0; j < properties.length; ++j) {
                    String field = properties[j];
                    int index = field.indexOf(".");
                    if (index == -1) {
                        String billID = coreBaseInfo.getId().toString();
                        coreBaseInfo.put(field, valuesMap[j].get(billID));
                        continue;
                    }
                    String entryName = field.substring(0, index);
                    IObjectCollection collection = (IObjectCollection)coreBaseInfo.get(entryName);
                    for (int k = 0; k < collection.size(); ++k) {
                        CoreBaseInfo entryInfo = (CoreBaseInfo)collection.getObject(k);
                        String entryID = entryInfo.getId().toString();
                        entryInfo.put(field.substring(index + 1, field.length()), valuesMap[j].get(entryID));
                    }
                }
                CoreBaseInfo ov = coreBaseInfo;
                cbc.addObject((IObjectValue)ov);
            }
        } else {
            for (int j = 0; j < coreBaseCollection.size(); ++j) {
                IObjectValue ov = coreBaseCollection.getObject(j);
                cbc.addObject(ov);
            }
        }
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"20_CommonUtils", (Locale)ctx.getLocale()));
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IBOTMapping ibt = BOTMappingFactory.getLocalInstance((Context)ctx);
        if (botpID == null || botpID.equals("")) {
            BOTMappingCollection collection = ibt.getMappingCollectionForSelect(cbc, destBOSType.toString(), DefineSysEnum.BTP);
            if (collection == null || collection.size() <= 0) {
                throw new MMCommonException(MMCommonException.BOTPERROR);
            }
            botpID = collection.get(0).getId().toString();
        }
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = ibt.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)botpID)));
        }
        catch (Exception e) {
            throw new MMCommonException(MMCommonException.BOTPERROR);
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new MMCommonException(MMCommonException.BOTPERROR);
        }
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"21_CommonUtils", (Locale)ctx.getLocale()));
        btpResult = iBTPManager.transformForBotp(cbc, destBOSType.toString(), (IObjectPK)new ObjectUuidPK(botpID));
        destBillCols = btpResult.getBills();
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.common.COMMONAutoGenerateResource", (String)"22_CommonUtils", (Locale)ctx.getLocale()));
        if (isSave) {
            botRelationCols = btpResult.getBOTRelationCollection();
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                iBTPManager.saveRelations(destBillInfo, botRelationCols);
            }
        }
        return btpResult;
    }

    public static SCMEntryDataVO getDataVO(Context ctx, StorageOrgUnitInfo storageOrgUnit, MaterialInfo[] materialInfos) throws EASBizException, BOSException {
        SCMEntryDataVO vo = new SCMEntryDataVO();
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        vo.setIsLoadingMaterialInventory(true);
        StorageOrgUnitInfo[] storageOrgUnitInfos = new StorageOrgUnitInfo[materialInfos.length];
        for (int i = 0; i < materialInfos.length; ++i) {
            storageOrgUnitInfos[i] = storageOrgUnit;
        }
        vo.setMaterialInfos(materialInfos);
        vo.setIsLoadingMaterialPlan(true);
        vo.setIsLoadingMaterialInventory(true);
        vo.setStorageOrgUnitInfos(storageOrgUnitInfos);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
        Map miInfoMap = voResult.getMaterialInventoryInfos();
        Map mpInfoMap = voResult.getMaterialPlanInfos();
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[materialInfos.length];
        MeasureUnitInfo[] measureBaseUnitInfos = new MeasureUnitInfo[materialInfos.length];
        MeasureUnitInfo[] assistBaseUnitInfos = new MeasureUnitInfo[materialInfos.length];
        for (int i = 0; i < materialInfos.length; ++i) {
            measureBaseUnitInfos[i] = materialInfos[i].getBaseUnit();
            measureUnitInfos[i] = materialInfos[i].getBaseUnit();
            String key = materialInfos[i].getId().toString() + storageOrgUnit.getId().toString();
            MaterialPlanInfo mpInfo = (MaterialPlanInfo)mpInfoMap.get(key);
            if (mpInfo == null || mpInfo.getProductUnit() == null) continue;
            measureUnitInfos[i] = mpInfo.getProductUnit();
        }
        vo.setIsLoadingMou(true);
        vo.setIsLoadingMmuPrecision(true);
        vo.setIsLoadingMaterialPlan(false);
        vo.setIsLoadingMaterialInventory(false);
        vo.setMeasureUnitInfos(measureUnitInfos);
        vo.setBaseMeasureUnitInfos(measureBaseUnitInfos);
        vo.setAssistMeasureUnitInfos(assistBaseUnitInfos);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
        voResult.setMaterialInventoryInfos(miInfoMap);
        voResult.setMaterialPlanInfos(mpInfoMap);
        return voResult;
    }

    public static void batchRecycleNumber(Context ctx, String billSql, IObjectValue billInstance) throws EASBizException, BOSException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        HashMap<String, Boolean> needRecycleMap = new HashMap<String, Boolean>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)billSql);
        String orgId = null;
        boolean isNeedRecycle = false;
        try {
            while (rs != null && rs.next()) {
                orgId = rs.getString("forgid");
                if (needRecycleMap.containsKey(orgId)) {
                    isNeedRecycle = (Boolean)needRecycleMap.get(orgId);
                } else {
                    isNeedRecycle = CommonUtils.isNeedRcycleNumber(ctx, billInstance, orgId);
                    needRecycleMap.put(orgId, isNeedRecycle);
                }
                if (!isNeedRecycle) continue;
                codingRuleManager.recycleNumber(billInstance, orgId, rs.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static boolean isNeedRcycleNumber(Context ctx, IObjectValue billInstance, String mainOrgId) throws EASBizException, BOSException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return codingRuleManager.isExist(billInstance, mainOrgId) && codingRuleManager.isUseIntermitNumber(billInstance, mainOrgId);
    }

    public static boolean existCodingRule(Context ctx, IObjectValue billInstance, String mainOrgId) throws EASBizException, BOSException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus(billInstance, mainOrgId);
        return ruleStatus.isExist();
    }

    public static CompanyOrgUnitInfo getCompanyOrgByStorageOrg(Context ctx, String storageOrgId) {
        if (storageOrgId == null) {
            return null;
        }
        try {
            CompanyOrgUnitInfo ret = null;
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgId, 4, 1);
            if (orgCol != null && orgCol.size() > 0) {
                ret = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static CostCenterOrgUnitInfo getCostOrgByAdminOrg(Context ctx, String adminOrgId) {
        if (adminOrgId == null) {
            return null;
        }
        try {
            CostCenterOrgUnitInfo ret = null;
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(adminOrgId, 0, 5);
            if (orgCol != null && orgCol.size() > 0) {
                ret = (CostCenterOrgUnitInfo)orgCol.get(0);
            }
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }
}

