/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.app.bizprocess.batchExecutor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.bizprocess.batchExecutor.AbstractMMBatchExecutor;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class MMBatchBOTPExecutor
extends AbstractMMBatchExecutor
implements IBatchExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.common.app.bizprocess.batchExecutor.MMBatchBOTPExecutor");

    public MMBatchBOTPExecutor(BatchActionEnum action, BOSObjectType type, String typeID) {
        super(action, type, typeID);
    }

    protected void createTargetBills(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        CoreBillBaseCollection col = this.preTransform(ctx, batchResults);
        if (col.size() == 0) {
            return;
        }
        BOTMappingInfo mappingInfo = (BOTMappingInfo)ctx.get((Object)"BOTPMAPPING");
        BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(col, mappingInfo);
        batchResults.addTransformResult(this.billTypeID, btpResult);
        this.afterTransform(ctx, batchResults);
        btpResult = batchResults.getTransformResult(this.billTypeID);
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection relations = btpResult.getBOTRelationCollection();
        if (destBillCols != null && destBillCols.size() > 0) {
            CoreBillBaseInfo baseinfo = (CoreBillBaseInfo)destBillCols.getObject(0);
            BOSObjectType billBOSType = baseinfo.getBOSType();
            IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billBOSType);
            ICoreBillBase iBillBase = (ICoreBillBase)obj;
            if (this.isHandleAfterTransform()) {
                iBillBase.handleAfterTransform("SAVE", destBillCols);
            }
            this.batchSaveTargetBills(ctx, mappingInfo, destBillCols, billBOSType);
            this.batchSaveRelations(ctx, (IObjectCollection)relations);
        }
    }

    protected void batchSaveTargetBills(Context ctx, BOTMappingInfo mappingInfo, IObjectCollection destBillCols, BOSObjectType billBOSType) throws EASBizException, BOSException {
        if (this.isDisablePermission()) {
            LogControllManager.getInstance().disableLog();
            ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
        }
        if (this.isDisableLog()) {
            LogControllManager.getInstance().disableLog();
            ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
        }
        try {
            IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billBOSType);
            ICoreBillBase iBillBase = (ICoreBillBase)obj;
            for (int i = 0; i < destBillCols.size(); ++i) {
                SCMBillBaseInfo info;
                if (destBillCols.getObject(i) instanceof SCMBillBaseInfo) {
                    info = (SCMBillBaseInfo)destBillCols.getObject(i);
                    info.setBotpCallSave(true);
                    iBillBase.save((CoreBaseInfo)info);
                    continue;
                }
                info = (CoreBillBaseInfo)destBillCols.getObject(i);
                iBillBase.save((CoreBaseInfo)info);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        if (this.isDisablePermission()) {
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
        }
        if (this.isDisableLog()) {
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        }
    }

    protected void batchSaveRelations(Context ctx, IObjectCollection relations) throws BOSException {
        Connection cn = null;
        IORMappingDAO idao = null;
        try {
            cn = this.getConnection(ctx);
            idao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"59302EC6"), (Context)ctx, (Connection)cn);
            for (int i = 0; i < relations.size(); ++i) {
                idao.addNewBatch(relations.getObject(i));
            }
            idao.executeBatch();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected void checkFunctionPermission(Context ctx, BatchActionResults batchResults) throws BOSException {
        try {
            IObjectCollection col = batchResults.getObjCollection();
            if (col == null || col.size() == 0) {
                return;
            }
            IObjectValue info = col.getObject(0);
            OrgUnitInfo orgUnit = (OrgUnitInfo)info.get(this.getBizOrgPropertyName());
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgUnit.getId().toString()), this.getAddNewPermItemName());
        }
        catch (EASBizException e) {
            IObjectCollection objs = batchResults.getObjCollection();
            for (int i = 0; i < objs.size(); ++i) {
                IObjectValue obj = objs.getObject(i);
                batchResults.addError(obj.getBOSUuid(obj.getPKField()).toString(), e.getMessage());
            }
        }
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        this.createTargetBills(ctx, batchResults);
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (this.isCheckFunctionPermission()) {
            this.checkFunctionPermission(ctx, batchResults);
        }
    }

    protected boolean isHandleAfterTransform() {
        return true;
    }

    protected boolean isCheckFunctionPermission() {
        return true;
    }

    protected boolean isDisableLog() {
        return true;
    }

    protected boolean isDisablePermission() {
        return true;
    }

    protected CoreBillBaseCollection preTransform(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        IObjectCollection objs = batchResults.getObjCollection();
        if (objs == null || objs.size() == 0) {
            return col;
        }
        Iterator ite = objs.iterator();
        while (ite.hasNext()) {
            col.add((CoreBillBaseInfo)ite.next());
        }
        return col;
    }

    protected void afterTransform(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
    }

    protected abstract String getAddNewPermItemName();

    protected abstract String getBizOrgPropertyName();
}

