/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.verify.AbstractMMVerifyItem;
import com.kingdee.eas.mm.common.app.verify.IMMVerifyItem;
import com.kingdee.eas.mm.common.app.verify.IMMVerifyManager;
import com.kingdee.eas.mm.common.app.verify.MMXmlParseFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class MMVerifyManager
implements IMMVerifyManager {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.mo.app.verify.MMVerifyManager");
    private Date beginTime;
    private Date endTime;
    private List verifyItems = new ArrayList();
    private BatchActionResults batchResults = null;
    private boolean isSupportBatchAction = true;
    private Map paramMap = null;
    private Context ctx = null;
    private String verifyManagerName = null;
    private String xmlName = null;
    private boolean isCheckAll = true;

    public MMVerifyManager(Context ctx, String xmlName, String verifyManagerName, Map paramMap) {
        this.ctx = ctx;
        this.xmlName = xmlName;
        this.verifyManagerName = verifyManagerName;
        this.paramMap = paramMap;
        this.batchResults = new BatchActionResults();
        this.isSupportBatchAction = false;
    }

    public MMVerifyManager(Context ctx, String xmlName, String verifyManagerName, Map paramMap, BatchActionResults batchResults) {
        this.ctx = ctx;
        this.xmlName = xmlName;
        this.verifyManagerName = verifyManagerName;
        this.paramMap = paramMap;
        this.batchResults = batchResults;
        this.isSupportBatchAction = true;
    }

    public MMVerifyManager(Context ctx, String xmlName, String verifyManagerName, Map paramMap, IObjectCollection col) {
        this.ctx = ctx;
        this.xmlName = xmlName;
        this.verifyManagerName = verifyManagerName;
        this.paramMap = paramMap;
        this.batchResults = BatchActionResults.populateActionResults((IObjectCollection)col);
        this.isSupportBatchAction = true;
    }

    @Override
    public boolean verify() throws EASBizException, BOSException {
        try {
            this.init(this.ctx, this.paramMap);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (IMMVerifyItem verifyItem : this.verifyItems) {
            this.logBegin(verifyItem.getClass().toString());
            if (!this.isCheckAll && this.isSupportBatchAction) {
                if (this.batchResults.hasToDos()) {
                    verifyItem.verify(this.batchResults);
                }
            } else {
                verifyItem.verify(this.batchResults);
            }
            this.logEnd(verifyItem.getClass().toString());
        }
        return !this.batchResults.hasException(null);
    }

    private void init(Context ctx, Map paramMap) throws ClassNotFoundException, InstantiationException, IllegalAccessException, BOSException, EASBizException {
        MMXmlParseFactory mmParse = MMXmlParseFactory.getInstance();
        List items = mmParse.parse(this.xmlName, this.verifyManagerName);
        if (paramMap == null) {
            paramMap = new HashMap<String, Object>();
        }
        paramMap.put("allToDoIdsSet", ((HashSet)this.batchResults.getToDoIdsSet()).clone());
        paramMap.put("allToDoIdsList", ((ArrayList)this.batchResults.getToDoIdsList()).clone());
        for (int i = 0; i < items.size(); ++i) {
            this.logBegin((String)items.get(i) + i);
            AbstractMMVerifyItem item = (AbstractMMVerifyItem)Class.forName(items.get(i).toString()).newInstance();
            item.prepareParam(ctx, paramMap);
            this.logEnd((String)items.get(i) + i);
            this.verifyItems.add(item);
        }
    }

    private void logEnd(String verifyItem) {
        if (logger.isInfoEnabled()) {
            this.endTime = new Date();
            BigDecimal e = new BigDecimal(String.valueOf(this.endTime.getTime()));
            BigDecimal b = new BigDecimal(String.valueOf(this.beginTime.getTime()));
            BigDecimal runSecs = e.subtract(b).divide(new BigDecimal("1000"), 2, 4);
            logger.info((Object)(verifyItem + " run end. Total spend " + String.valueOf(runSecs) + "s."));
        }
    }

    private void logBegin(String verifyItem) {
        if (logger.isInfoEnabled()) {
            this.beginTime = new Date();
            logger.info((Object)(verifyItem + " run begin...."));
        }
    }

    public void setCheckAll(boolean isCheckAll) {
        this.isCheckAll = isCheckAll;
    }

    public boolean isCheckAll() {
        return this.isCheckAll;
    }

    @Override
    public BatchActionResults getBatchResults() {
        return this.batchResults;
    }
}

