/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.backFlush.app.step;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.backFlush.app.BFCalcParam;
import com.kingdee.eas.mm.common.backFlush.app.step.AbstractBFStep;
import com.kingdee.eas.mm.common.backFlush.app.step.IBFStep;
import com.kingdee.eas.mm.common.backFlush.util.BackFlushUtil;
import com.kingdee.eas.scm.im.inv.MaterialReqBillCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.util.BaseException;
import java.util.ArrayList;
import java.util.List;

public class AuditMaterialReqStep
extends AbstractBFStep
implements IBFStep {
    private static final String FAILINFO = BackFlushUtil.getString("BACKFLUSH_REQBILLAUDITFAIL");
    List successList = new ArrayList();
    List failIdList = new ArrayList();

    @Override
    protected void innerExecute(BFCalcParam runParam) throws EASBizException, BOSException {
        List toDoIdsList = (List)runParam.getObject("ReqBillToDoIdList");
        MaterialReqBillCollection billCol = this.getMaterialReqBillCollection(this.ctx, toDoIdsList, this.getMaterialReqBillSelector());
        BOTRelationCollection relations = (BOTRelationCollection)runParam.getObject("RelationColletion");
        if (toDoIdsList.size() == 0) {
            return;
        }
        this.innerAuditBill(this.ctx, billCol, relations);
        runParam.setObject("ReqBillToDoIdList", this.successList);
        runParam.setObject("ReqBillFailIdList", this.failIdList);
    }

    private MaterialReqBillCollection getMaterialReqBillCollection(Context ctx, List toDoIdsList, SelectorItemCollection materialReqBillSelector) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)BackFlushUtil.listToSet(toDoIdsList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(materialReqBillSelector);
        return BackFlushUtil.getMaterialReqBillInterface(ctx).getMaterialReqBillCollection(view);
    }

    private SelectorItemCollection getMaterialReqBillSelector() {
        return SCMSelectorFactory.getInvBillBaseSelector((boolean)true);
    }

    private void innerAuditBill(Context ctx, MaterialReqBillCollection billCol, BOTRelationCollection relations) throws BOSException, EASBizException {
        if (billCol == null || billCol.size() == 0) {
            return;
        }
        MaterialReqBillInfo reqBill = null;
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[billCol.size()];
        Class[] parameTypes = new Class[]{IObjectPK.class, IObjectValue.class};
        int n = billCol.size();
        for (int i = 0; i < n; ++i) {
            reqBill = billCol.get(i);
            entries[i] = new BatchExecuteParamsEntry(parameTypes);
            entries[i].add((Object)new ObjectUuidPK(reqBill.getId()));
            entries[i].add((Object)reqBill);
        }
        try {
            ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
            LogControllManager.getInstance().disableLog();
            ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
            BatchExecuteResult result = BackFlushUtil.getMaterialReqBillInterface(ctx).batchExecute("audit", parameTypes, entries);
            IObjectPK pk = null;
            int n2 = entries.length;
            for (int i = 0; i < n2; ++i) {
                pk = (IObjectPK)entries[i].get(0);
                if (result.getException(i) != null) {
                    this.handleErrorResults(pk.toString(), relations, FAILINFO, result.getException(i).getMessage());
                    this.failIdList.add(pk.toString());
                    continue;
                }
                this.successList.add(pk.toString());
            }
        }
        catch (BaseException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        }
    }
}

