/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;

public class SQLUtil {
    public static String arrayToString(Object[] ids) {
        String idStr = "'null'";
        String id = null;
        if (ids != null && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == null) continue;
                id = ids[i].toString();
                id = id.replaceAll("'", "''");
                idStr = idStr + ",'" + id + "'";
            }
        }
        return idStr;
    }

    public static void batchExecuteSql(Context ctx, String[] sqls) throws BOSException {
        if (sqls == null || sqls.length == 0) {
            return;
        }
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                if (sqls[i] == null) continue;
                statement.executeUpdate(sqls[i]);
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public static ResultSet executeQuery(Context ctx, String selectSql, Object[] params) throws BOSException {
        ResultSet resultSet;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            ResultSet rs;
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(selectSql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            resultSet = rs = ps.executeQuery();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
        return resultSet;
    }

    public static String setToString(Set set) {
        String stringValues = null;
        if (set != null) {
            Object[] values = set.toArray();
            stringValues = SQLUtil.arrayToString(values);
        }
        return stringValues;
    }
}

