/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StoreCommonUtil {
    public static String PLANVERSION_901 = "901";
    public static String PLANVERSION_902 = "902";

    public static ResultSet getPlanVersionSetStoretypeAndStorestate(Context ctx, String number, String storageUnitID) throws BOSException, SQLException {
        StringBuffer strsql = new StringBuffer();
        strsql.append("SELECT a.fnumber, b.FStoreTypeID as fstoretype, c.FStoreStateID as fstorestate ");
        strsql.append(" FROM T_MM_PlanVersionSet a ");
        strsql.append(" inner join T_MM_PlanVersionSetStoreType b on a.FID = b.FParentID and b.FIsMrpRun=1 ");
        strsql.append(" inner join T_MM_PlanVersionSetStoreState c on a.FID = c.FParentID and c.FIsMrpRun=1 ");
        strsql.append(" WHERE ");
        strsql.append(" a.fnumber = '" + number + "' ");
        strsql.append(" and a.FStorageOrgUnitID = '" + storageUnitID + "' ");
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)strsql.toString());
        return rs;
    }

    public static StringBuffer getStoreTypeAndStateWhereSql(String orgUnitId, String planVersionNumber, String preStr) {
        StringBuffer getStoreTypeWhereSql = new StringBuffer();
        String prefix = preStr;
        if (prefix == null) {
            prefix = "";
        }
        StringBuffer selectTypeSql = StoreCommonUtil.getStoreTypeSql(orgUnitId, planVersionNumber);
        StringBuffer selectStateSql = StoreCommonUtil.getStoreStatusSql(orgUnitId, planVersionNumber);
        getStoreTypeWhereSql.append(" ").append(preStr).append("FStoreTypeID in (").append(selectTypeSql).append(") and ").append(preStr).append("FStoreTypeID in (").append(selectStateSql).append(")");
        return getStoreTypeWhereSql;
    }

    public static StringBuffer getStoreTypeSql(String orgUnitId, String planVersionNumber) {
        StringBuffer selectTypeSql = new StringBuffer();
        selectTypeSql.append("SELECT b.FStoreTypeID ");
        selectTypeSql.append(" FROM T_MM_PlanVersionSet a ");
        selectTypeSql.append(" inner join T_MM_PlanVersionSetStoreType b on a.FID = b.FParentID and b.FIsMrpRun=1 ");
        selectTypeSql.append(" WHERE ");
        selectTypeSql.append(" a.fnumber = '" + planVersionNumber + "' ");
        selectTypeSql.append(" and a.FStorageOrgUnitID = '" + orgUnitId + "' ");
        return selectTypeSql;
    }

    public static StringBuffer getStoreStatusSql(String orgUnitId, String planVersionNumber) {
        StringBuffer selectStateSql = new StringBuffer();
        selectStateSql.append("SELECT c.FStoreStateID ");
        selectStateSql.append(" FROM T_MM_PlanVersionSet a ");
        selectStateSql.append(" inner join T_MM_PlanVersionSetStoreState c on a.FID = c.FParentID and c.FIsMrpRun=1 ");
        selectStateSql.append(" WHERE ");
        selectStateSql.append(" a.fnumber = '" + planVersionNumber + "' ");
        selectStateSql.append(" and a.FStorageOrgUnitID = '" + orgUnitId + "' ");
        return selectStateSql;
    }

    public static Object[] getProjectNumberAndTrackNumber(Context ctx, ProjectInfo project, TrackNumberInfo trackNumber, String orgUnitId, String materialId, int billType) throws KScriptException {
        try {
            String strategy;
            MaterialPlanInfo planInfo;
            IMaterialPlan iMaterial;
            if (ctx == null) {
                iMaterial = MaterialPlanFactory.getRemoteInstance();
                planInfo = iMaterial.getPlanInfo(materialId, orgUnitId);
            } else {
                iMaterial = MaterialPlanFactory.getLocalInstance((Context)ctx);
                planInfo = iMaterial.getPlanInfo(materialId, orgUnitId);
            }
            Object[] pAndT = new Object[2];
            if (planInfo == null) {
                pAndT[0] = null;
                pAndT[1] = null;
                return pAndT;
            }
            if (project == null) {
                pAndT[0] = null;
            } else if (planInfo.getManufactureStrategy() != null) {
                strategy = planInfo.getManufactureStrategy().getId().toString();
                pAndT[0] = strategy.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategy.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") ? null : (strategy.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=") ? (planInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM_TRACKNO || planInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM ? project : null) : null);
            }
            if (trackNumber == null) {
                pAndT[1] = null;
            } else if (planInfo.getManufactureStrategy() != null) {
                strategy = planInfo.getManufactureStrategy().getId().toString();
                pAndT[1] = strategy.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategy.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") ? trackNumber : (strategy.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=") ? (planInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM_TRACKNO ? trackNumber : null) : null);
            }
            return pAndT;
        }
        catch (BOSException e) {
            throw new KScriptException(e.toString());
        }
        catch (EASBizException e) {
            throw new KScriptException(e.toString());
        }
    }

    public static String[] getProjectIdAndTrackNumberId(Context ctx, ProjectInfo project, TrackNumberInfo trackNumber, String orgUnitId, String materialId, int billType) throws KScriptException {
        String[] stringValue = new String[2];
        Object[] pAndT = StoreCommonUtil.getProjectNumberAndTrackNumber(ctx, project, trackNumber, orgUnitId, materialId, billType);
        project = (ProjectInfo)pAndT[0];
        trackNumber = (TrackNumberInfo)pAndT[1];
        String projectId = "";
        String trackNumberId = "";
        if (project != null && project.getId() != null && project.getId().toString().length() > 0) {
            projectId = project.getId().toString();
        }
        if (trackNumber != null && trackNumber.getId() != null && trackNumber.getId().toString().length() > 0) {
            trackNumberId = trackNumber.getId().toString();
        }
        stringValue[0] = projectId;
        stringValue[1] = trackNumberId;
        return stringValue;
    }

    public static boolean exists(Context ctx, FilterInfo filter, BOSObjectType bosType) throws BOSException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            boolean bl = StoreCommonUtil.getDAO(ctx, cn, bosType).exists(filter);
            return bl;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public static IORMappingDAO getDAO(Context ctx, Connection cn, BOSObjectType bosType) {
        return ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)ctx, (Connection)cn);
    }

    public static int isProjectRequire(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        ManufactureStrategyInfo strategy = StoreCommonUtil.getManufactureStrategy(ctx, material, orgUnit);
        int isProjectRequire = 0;
        if (strategy == null) {
            return isProjectRequire;
        }
        String strategyId = strategy.getId().toString();
        if (strategyId.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategyId.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyId.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategyId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) {
            isProjectRequire = -1;
        } else if (strategyId.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || strategyId.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
            isProjectRequire = 1;
        }
        return isProjectRequire;
    }

    public static int isTrackNumberRequire(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        MaterialPlanInfo materialPlanInfo = StoreCommonUtil.getMaterialPlanInfo(ctx, material, orgUnit);
        ManufactureStrategyInfo strategy = StoreCommonUtil.getManufactureStrategy(ctx, material, orgUnit);
        int isTrackNumberRequire = 0;
        if (strategy == null) {
            return isTrackNumberRequire;
        }
        String strategyId = strategy.getId().toString();
        if (strategyId.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategyId.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategyId.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategyId.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) {
            isTrackNumberRequire = 1;
        }
        if ((strategyId.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || strategyId.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) && materialPlanInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM_TRACKNO) {
            isTrackNumberRequire = 1;
        }
        return isTrackNumberRequire;
    }

    public static MaterialPlanInfo getMaterialPlanInfo(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        IMaterialPlan iMaterial = null;
        iMaterial = ctx == null ? MaterialPlanFactory.getRemoteInstance() : MaterialPlanFactory.getLocalInstance((Context)ctx);
        MaterialPlanInfo materialPlanInfo = null;
        if (material != null && orgUnit != null) {
            materialPlanInfo = iMaterial.getPlanInfo(material, orgUnit);
        }
        return materialPlanInfo;
    }

    public static ManufactureStrategyInfo getManufactureStrategy(Context ctx, String material, String orgUnit) throws BOSException, EASBizException {
        ManufactureStrategyInfo strategy = null;
        MaterialPlanInfo materialPlanInfo = StoreCommonUtil.getMaterialPlanInfo(ctx, material, orgUnit);
        if (materialPlanInfo == null) {
            return strategy;
        }
        if (materialPlanInfo.getManufactureStrategy() != null) {
            strategy = materialPlanInfo.getManufactureStrategy();
        }
        return strategy;
    }
}

