/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordCollection;
import com.kingdee.eas.mm.common.backFlush.BackFlushRecordInfo;
import com.kingdee.eas.mm.common.backFlush.app.IBFBillHandle;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FinishedRptBFHandle
implements IBFBillHandle {
    private Context ctx;
    private Map calcTypeMap = new HashMap();

    public FinishedRptBFHandle() {
    }

    public FinishedRptBFHandle(Context context) {
        this.ctx = context;
    }

    public BackFlushRecordCollection buildBFRecords(List idList) throws EASBizException, BOSException {
        BackFlushRecordCollection result = new BackFlushRecordCollection();
        String idStr = StringUtil.arrayToString((Object[])idList.toArray(), (String)"','");
        StringBuffer sql = new StringBuffer();
        sql.append("Select t1.FStorageOrgUnitId,t1.FBizDate, t1.FId srcBillId,t1.FNumber srcBillNumber,t1.FStorageOrgUnitId storageOrgUnitId,t1.FBillTypeId srcBillTypeId,");
        sql.append("t2.FId srcBillEntryId,t3.FId orderId,t3.FNumber orderNumber,t3.FBillTypeId orderTypeId,t2.FBaseCommtQty baseCommtQty,");
        sql.append("t3.FBaseQty baseOrderQty,t4.FId orderEntryId,t4.FMaterialId materialId,t4.FUnitId unitId,t4.FBaseUnitId baseUnitId,");
        sql.append("t4.FQty planQty,t4.FBaseQty basePlanQty,t4.FStandardQty standardQty ");
        sql.append("From  T_MM_FinishedRpt t1 ");
        sql.append("LEFT JOIN T_MM_FinishedRptEntry t2 on t1.FId = t2.FParentId ");
        sql.append("LEFT JOIN T_MM_ProductionOrder t3 on t1.FProductionOrderId = t3.FId ");
        sql.append("LEFT JOIN T_MM_ProductionOrderSEntry t4 on t3.FId = t4.FParentId ");
        sql.append("WHERE t2.FId in ('").append(idStr).append("') and t4.FIsBackFlush = 1 and t2.FOutputType = 10710");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rows.next()) {
                this.putParamValue(rows.getString("FStorageOrgUnitId"));
                result.add(this.parseToInfo(rows));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private BackFlushRecordInfo parseToInfo(IRowSet rows) throws BOSException, EASBizException {
        BackFlushRecordInfo info = new BackFlushRecordInfo();
        try {
            info.setSrcBillId(rows.getString("srcBillId"));
            info.setSrcBillNumber(rows.getString("srcBillNumber"));
            info.setSrcBillEntryId(rows.getString("srcBillEntryId"));
            info.setOrderId(rows.getString("orderId"));
            info.setOrderNumber(rows.getString("orderNumber"));
            info.setOrderEntryId(rows.getString("orderEntryId"));
            info.setOrderType(rows.getString("orderTypeId"));
            info.setBackFlushDate((Date)rows.getDate("FBizDate"));
            StorageOrgUnitInfo orgUnit = new StorageOrgUnitInfo();
            orgUnit.setId(BOSUuid.read((String)rows.getString("storageOrgUnitId")));
            info.setStorageOrgUnit(orgUnit);
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)rows.getString("srcBillTypeId")));
            info.setSrcBillType(billType);
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)rows.getString("materialId")));
            info.setMaterial(material);
            MeasureUnitInfo unit = new MeasureUnitInfo();
            unit.setId(BOSUuid.read((String)rows.getString("unitId")));
            info.setUnit(unit);
            MeasureUnitInfo baseUnit = new MeasureUnitInfo();
            baseUnit.setId(BOSUuid.read((String)rows.getString("baseUnitId")));
            info.setBaseUnit(baseUnit);
            String calcType = this.getParamValue(rows.getString("storageOrgUnitId"));
            BigDecimal baseOrderQty = rows.getBigDecimal("baseOrderQty");
            BigDecimal baseCommtQty = rows.getBigDecimal("baseCommtQty");
            BigDecimal planQty = rows.getBigDecimal("planQty");
            BigDecimal basePlanQty = rows.getBigDecimal("basePlanQty");
            BigDecimal standardQty = rows.getBigDecimal("standardQty");
            BigDecimal planBFQty = SCMConstant.BIGDECIMAL_ZERO;
            BigDecimal basePlanBFQty = SCMConstant.BIGDECIMAL_ZERO;
            if ("0".equalsIgnoreCase(calcType)) {
                planBFQty = standardQty.multiply(baseCommtQty).divide(baseOrderQty, 10, 0);
                basePlanBFQty = planBFQty.multiply(basePlanQty).divide(planQty, 10, 0);
            } else {
                planBFQty = planQty.multiply(baseCommtQty).divide(baseOrderQty, 10, 0);
                basePlanBFQty = basePlanQty.multiply(baseCommtQty).divide(baseOrderQty, 10, 0);
            }
            info.setPlanBFQty(planBFQty);
            info.setBasePlanBFQty(basePlanBFQty);
            return info;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getParamValue(String orgUnitId) throws EASBizException, BOSException {
        if (this.calcTypeMap.containsKey(orgUnitId)) {
            return (String)this.calcTypeMap.get(orgUnitId);
        }
        return "1";
    }

    private void putParamValue(String orgUnitId) throws EASBizException, BOSException {
        if (!this.calcTypeMap.containsKey(orgUnitId)) {
            String value = ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(orgUnitId), (String)"BackFlushQtyType");
            this.calcTypeMap.put(orgUnitId, value != null ? value : "1");
        }
    }

    public void setContext(Context context) {
        this.ctx = context;
    }
}

