/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ProductLineWPCollection;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLineWPFactory;
import com.kingdee.eas.mm.basedata.ProductLineWPInfo;
import com.kingdee.eas.mm.control.FinishedRptCRInfo;
import com.kingdee.eas.mm.control.FinishedRptCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryCollection;
import com.kingdee.eas.mm.control.FinishedRptEntryInfo;
import com.kingdee.eas.mm.control.FinishedRptFactory;
import com.kingdee.eas.mm.control.FinishedRptInfo;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.TaskDispBillCollection;
import com.kingdee.eas.mm.control.TaskDispBillFactory;
import com.kingdee.eas.mm.control.TaskDispBillInfo;
import com.kingdee.eas.qm.basedata.QCFlowManuBizEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class FinishedRptDataTransmission
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FinishedRptFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            NumberFormat dtformat = BOSLocaleUtil.getDecimalFormat();
            FinishedRptDataTransmission.putTable(result, "FNumber", rs.getString("number"));
            FinishedRptDataTransmission.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            FinishedRptDataTransmission.putTable(result, "FProductionOrder_number", rs.getString("productionOrder.number"));
            FinishedRptDataTransmission.putTable(result, "FTaskDispBill_number", rs.getString("taskDispBill.number"));
            FinishedRptDataTransmission.putTable(result, "FWorkshop_number", rs.getString("workshop.number"));
            FinishedRptDataTransmission.putTable(result, "FProductLine_number", rs.getString("productLine.number"));
            FinishedRptDataTransmission.putTable(result, "FShift_number", rs.getString("shift.number"));
            FinishedRptDataTransmission.putTable(result, "FClassGroup_number", rs.getString("classGroup.number"));
            FinishedRptDataTransmission.putTable(result, "FPerson_number", rs.getString("person.number"));
            FinishedRptDataTransmission.putTable(result, "FTraceNo", rs.getString("traceNo"));
            FinishedRptDataTransmission.putTable(result, "FSaleOrder_number", rs.getString("saleOrder.number"));
            String isBackFlushed = rs.getString("isBackFlushed");
            if (isBackFlushed != null && !isBackFlushed.trim().equals("") && isBackFlushed.trim().equals("true")) {
                FinishedRptDataTransmission.putTable(result, "FIsBackFlushed", ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"28_FinishedRptDataTransmission", (Locale)ctx.getLocale()));
            } else {
                FinishedRptDataTransmission.putTable(result, "FIsBackFlushed", ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"29_FinishedRptDataTransmission", (Locale)ctx.getLocale()));
            }
            if (rs.getString("baseStatus") != null && !rs.getString("baseStatus").trim().equals("")) {
                int status = Integer.parseInt(rs.getString("baseStatus"));
                BillBaseStatusEnum baseStatus = BillBaseStatusEnum.getEnum((int)status);
                FinishedRptDataTransmission.putTable(result, "FBaseStatus", baseStatus.getAlias());
            } else {
                FinishedRptDataTransmission.putTable(result, "FBaseStatus", "");
            }
            FinishedRptDataTransmission.putTable(result, "FCreateTime", rs.getString("createTime").trim().subSequence(0, 10));
            FinishedRptDataTransmission.putTable(result, "FCreator_number", rs.getString("creator.number"));
            FinishedRptDataTransmission.putTable(result, "FDescription", rs.getString("description"));
            FinishedRptDataTransmission.putTable(result, "FEntrys_seq", rs.getString("entrys.seq"));
            String outputType = rs.getString("entrys.outputType");
            if (outputType != null && !outputType.trim().equals("") && !outputType.trim().equals("0")) {
                MaterialProductEnum output = MaterialProductEnum.getEnum((int)Integer.parseInt(outputType));
                FinishedRptDataTransmission.putTable(result, "FEntrys_outputType", output.getAlias());
            } else {
                FinishedRptDataTransmission.putTable(result, "FEntrys_outputType", "");
            }
            FinishedRptDataTransmission.putTable(result, "FEntrys$material_number", rs.getString("material.number"));
            FinishedRptDataTransmission.putTable(result, "FEntrys$material_name", rs.getString("material.name"));
            FinishedRptDataTransmission.putTable(result, "FEntrys$material_model", rs.getString("material.model"));
            FinishedRptDataTransmission.putTable(result, "FEntrys$unit_number", rs.getString("unit.number"));
            FinishedRptDataTransmission.putTable(result, "FEntrys$productLineWP_number", rs.getString("productLineWP.name"));
            FinishedRptDataTransmission.putTable(result, "FEntrys_finishDate", rs.getString("entrys.finishDate"));
            FinishedRptDataTransmission.putTable(result, "FEntrys_lotNo", rs.getString("entrys.lotNo"));
            FinishedRptDataTransmission.putTable(result, "FEntrys$warehouse_number", rs.getString("warehouse.number"));
            FinishedRptDataTransmission.putTable(result, "FEntrys_commitQty", rs.getString("entrys.commitQty"));
            String isCheck = rs.getString("entrys.isCheck");
            if (isCheck != null && !isCheck.trim().equals("") && isCheck.trim().equals("true")) {
                FinishedRptDataTransmission.putTable(result, "FEntrys_isCheck", ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"28_FinishedRptDataTransmission", (Locale)ctx.getLocale()));
            } else {
                FinishedRptDataTransmission.putTable(result, "FEntrys_isCheck", ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"29_FinishedRptDataTransmission", (Locale)ctx.getLocale()));
            }
            String isDirectDis = rs.getString("entrys.isDirectDis");
            if (isDirectDis != null && !isDirectDis.trim().equals("") && isDirectDis.trim().equals("true")) {
                FinishedRptDataTransmission.putTable(result, "FEntrys_isDirectDis", ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"28_FinishedRptDataTransmission", (Locale)ctx.getLocale()));
            } else {
                FinishedRptDataTransmission.putTable(result, "FEntrys_isDirectDis", ResourceBase.getString((String)"com.kingdee.eas.mm.control.CONTROLAutoGenerateResource", (String)"29_FinishedRptDataTransmission", (Locale)ctx.getLocale()));
            }
            FinishedRptDataTransmission.putTable(result, "FEntrys_rptCheckQty", dtformat.format(Double.parseDouble(rs.getString("entrys.rptCheckQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_totalPassQty", dtformat.format(Double.parseDouble(rs.getString("entrys.totalPassQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_totalRejectQty", dtformat.format(Double.parseDouble(rs.getString("entrys.totalRejectQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_rejectRptTotalQty", dtformat.format(Double.parseDouble(rs.getString("entrys.rejectRptTotalQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_rejectStockTotalQty", dtformat.format(Double.parseDouble(rs.getString("entrys.rejectStockTotalQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_totalReworkQty", dtformat.format(Double.parseDouble(rs.getString("entrys.totalReworkQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_totalRepairQty", dtformat.format(Double.parseDouble(rs.getString("entrys.totalRepairQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_repairRptTotalQty", dtformat.format(Double.parseDouble(rs.getString("entrys.repairRptTotalQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_reworkRptTotalQty", dtformat.format(Double.parseDouble(rs.getString("entrys.reworkRptTotalQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_stockTotalQty", dtformat.format(Double.parseDouble(rs.getString("entrys.stockTotalQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_rptTotalQty", dtformat.format(Double.parseDouble(rs.getString("entrys.rptTotalQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_totalReversePreQty", dtformat.format(Double.parseDouble(rs.getString("entrys.totalReversePreQty"))));
            FinishedRptDataTransmission.putTable(result, "FEntrys_remark", rs.getString("entrys.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public static void putTable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String value = null;
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        Hashtable headData = (Hashtable)hsData.get(new Integer(0));
        FinishedRptInfo destInfo = new FinishedRptInfo();
        value = (String)((DataToken)headData.get((Object)"FNumber")).data;
        FinishedRptInfo sourceInfo = this.getFinishedRptInfo(ctx, value);
        if ((value == null || value.trim().equals("")) && sourceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"existBillNotTemp"));
        }
        destInfo.setNumber(value);
        destInfo = this.buildHead(destInfo, headData, ctx);
        if (mode == 8) {
            return this.getInsertImportInfo(destInfo, hsData, ctx);
        }
        if (mode == 16) {
            return this.getOverrideImportInfo(destInfo, sourceInfo, hsData, ctx);
        }
        return null;
    }

    protected FinishedRptInfo buildHead(FinishedRptInfo destInfo, Hashtable headData, Context ctx) throws TaskExternalException {
        String value = null;
        value = (String)((DataToken)headData.get((Object)"FStorageOrgUnit_number")).data;
        StorageOrgUnitInfo storage = this.getStorageOrgUnitInfo(ctx, value);
        if ((value == null || value.trim().equals("")) && storage == null) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"storageNotExist"));
        }
        destInfo.setStorageOrgUnit(storage);
        value = (String)((DataToken)headData.get((Object)"FProductionOrder_number")).data;
        ProductionOrderInfo productionOrder = this.getProductionOrder(ctx, value);
        if ((value == null || value.trim().equals("")) && productionOrder == null) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"productionorderNotExist"));
        }
        destInfo.setProductionOrder(productionOrder);
        value = (String)((DataToken)headData.get((Object)"FTaskDispBill_number")).data;
        TaskDispBillInfo taskDisp = this.getTaskDispBillInfo(ctx, value);
        if (value != null && !value.trim().equals("") && taskDisp == null) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"taskDispNotExist"));
        }
        destInfo.setTaskDispBill(taskDisp);
        value = (String)((DataToken)headData.get((Object)"FBizDate")).data;
        if (null != value && value.trim().length() > 0) {
            try {
                value = value + " 00:00:00.000";
                destInfo.setBizDate(Timestamp.valueOf(value));
            }
            catch (Exception e) {
                destInfo.setBizDate(null);
            }
        } else {
            destInfo.setBizDate(null);
        }
        destInfo.setIsBackFlushed(false);
        destInfo.setOnceAudit(false);
        return destInfo;
    }

    protected FinishedRptEntryInfo buildEntry(FinishedRptInfo info, Hashtable entryData, Context ctx) throws TaskExternalException {
        String tmpValue = null;
        FinishedRptEntryInfo tempEntry = new FinishedRptEntryInfo();
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys_outputType")).data;
        MaterialProductEnum outPutType = MaterialProductEnum.getEnum((int)Integer.parseInt(tmpValue));
        tempEntry.setOutputType(outPutType);
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys$material_number")).data;
        MaterialInfo material = this.getMaterialInfo(ctx, tmpValue);
        if (material == null) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"Msg_Export_MaterialIsNull"));
        }
        tempEntry.setMaterial(material);
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys$unit_number")).data;
        MeasureUnitInfo unit = this.getMeasureUnitInfo(ctx, tmpValue);
        if (unit == null) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"Msg_Export_UnitIsNull"));
        }
        tempEntry.setUnit(unit);
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys$productLineWP_number")).data;
        ProductLineWPEntryInfo wpEntry = this.getProductlineWp(ctx, info.getStorageOrgUnit().getId().toString(), info.getProductionOrder().getProductLine().getId().toString(), tmpValue);
        if (tmpValue != null && !tmpValue.equals("") && wpEntry == null) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"Msg_Export_WPIsNull"));
        }
        tempEntry.setProductLineWP(wpEntry);
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys_finishDate")).data;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date finishedDate = null;
        try {
            finishedDate = sdf.parse(tmpValue);
        }
        catch (ParseException e) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"Msg_Export_DataFormat"), e.getCause());
        }
        tempEntry.setFinishDate(finishedDate);
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys_lotNo")).data;
        tempEntry.setLotNo(tmpValue);
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys$warehouse_number")).data;
        WarehouseInfo wareHouse = this.getWarehouseInfo(ctx, tmpValue);
        if (wareHouse == null) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"Msg_Export_WarehouseIsNull"));
        }
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys_commitQty")).data;
        BigDecimal commitQty = new BigDecimal(tmpValue);
        tempEntry.setCommitQty(commitQty);
        return tempEntry;
    }

    protected FinishedRptCRInfo buildCheckEntry(FinishedRptInfo info, Hashtable entryData, Context ctx) {
        FinishedRptCRInfo checkEntryInfo = new FinishedRptCRInfo();
        String tmpValue = null;
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys$checkEntry_checkBatch")).data;
        checkEntryInfo.setCheckBatch(tmpValue);
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys$checkEntry_qty")).data;
        BigDecimal qty = null;
        qty = tmpValue == null || tmpValue.trim().equals("") ? new BigDecimal("0") : new BigDecimal(tmpValue);
        checkEntryInfo.setQty(qty);
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys$checkEntry_checkResult")).data;
        QCFlowManuBizEnum checkResult = QCFlowManuBizEnum.getEnum((String)tmpValue);
        checkEntryInfo.setCheckResult(checkResult);
        tmpValue = (String)((DataToken)entryData.get((Object)"FEntrys$checkEntry_ramark")).data;
        checkEntryInfo.setRamark(tmpValue);
        return checkEntryInfo;
    }

    private CoreBaseInfo getInsertImportInfo(FinishedRptInfo info, Hashtable hsData, Context ctx) throws TaskExternalException {
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable entryData = (Hashtable)hsData.get(new Integer(i));
            FinishedRptEntryInfo tempEntry = this.buildEntry(info, entryData, ctx);
            FinishedRptCRInfo checkEntryInfo = this.buildCheckEntry(info, entryData, ctx);
            boolean isExist = false;
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                FinishedRptEntryInfo entryInfo = info.getEntrys().get(j);
                if (!this.isSameEntry(tempEntry, entryInfo)) continue;
                entryInfo.getCheckEntry().add(checkEntryInfo);
                checkEntryInfo.setParent(entryInfo);
                isExist = true;
                break;
            }
            if (isExist) continue;
            tempEntry.getCheckEntry().add(checkEntryInfo);
            checkEntryInfo.setParent(tempEntry);
            tempEntry.setParent(info);
            info.getEntrys().add(tempEntry);
        }
        return info;
    }

    protected boolean isSameEntry(FinishedRptEntryInfo sourceInfo, FinishedRptEntryInfo descInfo) {
        if (sourceInfo.getOutputType() == null && descInfo.getOutputType() != null || sourceInfo.getOutputType() != null && descInfo.getOutputType() == null) {
            return false;
        }
        if (sourceInfo.getMaterial() == null && descInfo.getMaterial() != null || sourceInfo.getMaterial() != null && descInfo.getMaterial() == null) {
            return false;
        }
        if (sourceInfo.getProductLineWP() == null && descInfo.getProductLineWP() != null || sourceInfo.getProductLineWP() != null && descInfo.getProductLineWP() == null) {
            return false;
        }
        if (sourceInfo.getUnit() == null && descInfo.getUnit() != null || sourceInfo.getUnit() != null && descInfo.getUnit() == null) {
            return false;
        }
        if (sourceInfo.getWarehouse() == null && descInfo.getWarehouse() != null || sourceInfo.getWarehouse() != null && descInfo.getWarehouse() == null) {
            return false;
        }
        if (sourceInfo.getCommitQty() == null && descInfo.getCommitQty() != null || sourceInfo.getCommitQty() != null && descInfo.getCommitQty() == null) {
            return false;
        }
        if (sourceInfo.getLotNo() == null && descInfo.getLotNo() != null || sourceInfo.getLotNo() != null && descInfo.getLotNo() == null) {
            return false;
        }
        if (sourceInfo.getFinishDate() == null && descInfo.getFinishDate() != null || sourceInfo.getFinishDate() != null && descInfo.getFinishDate() == null) {
            return false;
        }
        return (sourceInfo.getMaterial() == null && descInfo.getMaterial() == null || sourceInfo.getOutputType().equals((Object)descInfo.getOutputType())) && (sourceInfo.getMaterial() == null && descInfo.getMaterial() == null || sourceInfo.getMaterial().getNumber().equals(descInfo.getMaterial().getNumber())) && (sourceInfo.getProductLineWP() == null && descInfo.getProductLineWP() == null || sourceInfo.getProductLineWP().getNumber().equals(descInfo.getProductLineWP().getNumber())) && (sourceInfo.getUnit() == null && descInfo.getUnit() == null || sourceInfo.getUnit().getNumber().equals(descInfo.getUnit().getNumber())) && (sourceInfo.getWarehouse() == null && descInfo.getWarehouse() == null || sourceInfo.getWarehouse().getNumber().equals(descInfo.getWarehouse().getNumber())) && (sourceInfo.getCommitQty() == null && descInfo.getCommitQty() == null || sourceInfo.getCommitQty().equals(descInfo.getCommitQty())) && (sourceInfo.getLotNo() == null && descInfo.getLotNo() == null || sourceInfo.getLotNo().equals(descInfo.getLotNo())) && (sourceInfo.getFinishDate() == null || descInfo.getFinishDate() == null || sourceInfo.getFinishDate().equals(descInfo.getFinishDate()));
    }

    protected boolean isSameEntry(FinishedRptCRInfo sourceInfo, FinishedRptCRInfo descInfo) {
        if (sourceInfo.getCheckResult() == null && descInfo.getCheckResult() == null) {
            return true;
        }
        return sourceInfo.getCheckResult() == null && descInfo.getCheckResult() == null || sourceInfo.getCheckResult().equals((Object)descInfo.getCheckResult());
    }

    private CoreBaseInfo getOverrideImportInfo(FinishedRptInfo info, FinishedRptInfo oldInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        if (oldInfo == null) {
            return this.getInsertImportInfo(info, hsData, ctx);
        }
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable entryData = (Hashtable)hsData.get(new Integer(i));
            FinishedRptEntryInfo tempEntry = this.buildEntry(info, entryData, ctx);
            FinishedRptCRInfo checkEntryInfo = this.buildCheckEntry(info, entryData, ctx);
            boolean isExist = false;
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                FinishedRptEntryInfo entryInfo = info.getEntrys().get(i);
                if (!this.isSameEntry(tempEntry, entryInfo)) continue;
                boolean isExistCheckEntry = false;
                for (int k = 0; k < entryInfo.getCheckEntry().size(); ++k) {
                    if (!this.isSameEntry(checkEntryInfo, entryInfo.getCheckEntry().get(k))) continue;
                    FinishedRptCRInfo checkInfo = entryInfo.getCheckEntry().get(k);
                    checkEntryInfo.setId(checkInfo.getId());
                    entryInfo.getCheckEntry().remove(checkInfo);
                    entryInfo.getCheckEntry().add(checkEntryInfo);
                    checkEntryInfo.setParent(entryInfo);
                    isExistCheckEntry = true;
                    break;
                }
                if (isExistCheckEntry) break;
                entryInfo.getCheckEntry().add(checkEntryInfo);
                checkEntryInfo.setParent(entryInfo);
                break;
            }
            if (isExist) continue;
            tempEntry.getCheckEntry().add(checkEntryInfo);
            checkEntryInfo.setParent(tempEntry);
            tempEntry.setParent(oldInfo);
            oldInfo.getEntrys().add(tempEntry);
        }
        FinishedRptEntryCollection entry = oldInfo.getEntrys();
        info.setId(oldInfo.getId());
        info.setNumber(oldInfo.getNumber());
        FinishedRptEntryCollection sourceEntry = info.getEntrys();
        sourceEntry.clear();
        for (int i = 0; i < entry.size(); ++i) {
            sourceEntry.add(entry.get(i));
        }
        return info;
    }

    public FinishedRptInfo getFinishedRptInfo(Context ctx, String number) throws TaskExternalException {
        if (null == number || 0 == number.trim().length()) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        try {
            FinishedRptCollection collection = FinishedRptFactory.getLocalInstance(ctx).getFinishedRptCollection(env);
            if (null != collection && collection.size() > 0) {
                return collection.get(0);
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    public StorageOrgUnitInfo getStorageOrgUnitInfo(Context ctx, String number) throws TaskExternalException {
        if (null == number || 0 == number.trim().length()) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        try {
            StorageOrgUnitCollection collection = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(env);
            if (null != collection && collection.size() > 0) {
                return collection.get(0);
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    public ProductionOrderInfo getProductionOrder(Context ctx, String number) throws TaskExternalException {
        if (null == number || 0 == number.trim().length()) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo env = new EntityViewInfo();
        env.getSelector().add(new SelectorItemInfo("*"));
        env.getSelector().add(new SelectorItemInfo("productLine.*"));
        env.getSelector().add(new SelectorItemInfo("entrys.*"));
        env.setFilter(filter);
        try {
            ProductionOrderCollection collection = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderCollection(env);
            if (null != collection && collection.size() > 0) {
                return collection.get(0);
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    public TaskDispBillInfo getTaskDispBillInfo(Context ctx, String number) throws TaskExternalException {
        if (null == number || 0 == number.trim().length()) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        try {
            TaskDispBillCollection collection = TaskDispBillFactory.getLocalInstance(ctx).getTaskDispBillCollection(env);
            if (null != collection && collection.size() > 0) {
                return collection.get(0);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return null;
    }

    public MaterialInfo getMaterialInfo(Context ctx, String number) throws TaskExternalException {
        if (null == number || 0 == number.trim().length()) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        try {
            MaterialCollection collecton = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(env);
            if (null != collecton && collecton.size() > 0) {
                return collecton.get(0);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.mm.control.FinishedRptResource", (String)"Msg_Export_GetMaterialFail"), e.getCause());
        }
        return null;
    }

    public MeasureUnitInfo getMeasureUnitInfo(Context ctx, String number) throws TaskExternalException {
        if (null == number || 0 == number.trim().length()) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        try {
            MeasureUnitCollection collecton = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(env);
            if (null != collecton && collecton.size() > 0) {
                return collecton.get(0);
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    public WarehouseInfo getWarehouseInfo(Context ctx, String number) throws TaskExternalException {
        if (null == number || 0 == number.trim().length()) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        try {
            WarehouseCollection collecton = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(env);
            if (null != collecton && collecton.size() > 0) {
                return collecton.get(0);
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    public ProductLineWPEntryInfo getProductlineWp(Context ctx, String storageOrgUnitId, String productLineId, String entryWpNum) throws TaskExternalException {
        if (null == entryWpNum || 0 == entryWpNum.trim().length()) {
            return null;
        }
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId));
        filter.getFilterItems().add(new FilterItemInfo("productLine.id", (Object)productLineId));
        env.getSelector().add(new SelectorItemInfo("Entry.*"));
        env.setFilter(filter);
        try {
            ProductLineWPCollection collecton = ProductLineWPFactory.getLocalInstance((Context)ctx).getProductLineWPCollection(env);
            if (null != collecton && collecton.size() > 0) {
                ProductLineWPInfo info = collecton.get(0);
                for (int i = 0; i < info.getEntry().size(); ++i) {
                    ProductLineWPEntryInfo entryInfo = info.getEntry().get(i);
                    if (!entryInfo.getNumber().equals(entryWpNum)) continue;
                    return entryInfo;
                }
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    public int getSubmitType() {
        return 1;
    }
}

