/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.DBBatchUtil;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.TransactionTypeHelper;
import com.kingdee.eas.mm.control.IPickingSlipBill;
import com.kingdee.eas.mm.control.PickingModeEnum;
import com.kingdee.eas.mm.control.PickingSlipBillEntryCollection;
import com.kingdee.eas.mm.control.PickingSlipBillEntryInfo;
import com.kingdee.eas.mm.control.PickingSlipBillException;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.control.PickingSlipBillInfo;
import com.kingdee.eas.mm.control.ProductionOrderException;
import com.kingdee.eas.mm.control.ProductionOrderFacadeFactory;
import com.kingdee.eas.mm.control.app.AbstractPickingSlipFacadeControllerBean;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PickingSlipFacadeControllerBean
extends AbstractPickingSlipFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.control.app.PickingSlipFacadeControllerBean");
    private static final String table_name = "T_MM_PickingSlipbill";
    private static final String table_entry_name = "T_MM_PickingSlipbillEntry";
    protected String[] dividingHeadKeys = new String[]{"FStorageOrgUnitID", "FProductionOrderID", "FSaleOrderID", "FTrackNumberID", "FWorkshopID", "FProductLineID"};
    protected String[] dividingEntryKeys = new String[]{"FSupplyStorageOrgUnitID", "FProductLineWPID", "FMaterialID", "FWarehouseID", "FLotNo"};
    protected Boolean[] dividingHeadValues = new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE};
    protected Boolean[] dividingEntryValues = new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE};
    protected boolean dividebyCostCenter = false;
    protected boolean dividebyCostObject = true;
    protected boolean dividebyWorkShop = false;
    protected String[] groupKeys = new String[]{"FMaterialReqBillID", "FStorageOrgUnitID", "FRequirementCompanyUnitID", "FProductLineID", "FProductLineWPID", "FMaterialID", "FSupplyWarehouseID", "FRequirementWarehouseID", "FRequirementLocationID", "FCostObjectID", "FTrackNumberID", "FProductionOrderID", "FSaleOrderID", "FCostCenterID", "FWorkshopID", "FLotNo"};
    protected Boolean[] groupValues = new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE};
    protected String[] groupKeyTypes = new String[]{"VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "VARCHAR(44)", "NVARCHAR(80)"};

    @Override
    protected String _createTempTable(Context ctx) throws BOSException, EASBizException {
        String tableName = "";
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table t_temp_pickingslip (");
        createSql.append("FUUID VARCHAR(44),");
        createSql.append("FID VARCHAR(44),");
        createSql.append("FNumber NVARCHAR(80),");
        createSql.append("FEntryID VARCHAR(44),");
        createSql.append("FSeq INT,");
        createSql.append("FPSLotID VARCHAR(44),");
        createSql.append("FStorageOrgUnitID VARCHAR(44),");
        createSql.append("FCuID VARCHAR(44),");
        createSql.append("FProvideType INT,");
        createSql.append("FSupplyStorageOrgUnitID VARCHAR(44),");
        createSql.append("FSupplyCompanyUnitID VARCHAR(44),");
        createSql.append("FRequirementCompanyUnitID VARCHAR(44),");
        createSql.append("FTransTypeID VARCHAR(44),");
        createSql.append("FBizTypeID VARCHAR(44),");
        createSql.append("FSupplyWarehouseID VARCHAR(44),");
        createSql.append("FRequirementWarehouseID VARCHAR(44),");
        createSql.append("FSupplyLocationID VARCHAR(44),");
        createSql.append("FRequirementLocationID VARCHAR(44),");
        createSql.append("FWorkshopID VARCHAR(44),");
        createSql.append("FClassGroupID VARCHAR(44),");
        createSql.append("FPersonID VARCHAR(44),");
        createSql.append("FProductLineID VARCHAR(44),");
        createSql.append("FCostCenterID VARCHAR(44),");
        createSql.append("FCostObjectID VARCHAR(44),");
        createSql.append("FTraceNo NVARCHAR(80),");
        createSql.append("FProductID VARCHAR(44),");
        createSql.append("FTrackNumberID VARCHAR(44),");
        createSql.append("FProductionOrderID VARCHAR(44),");
        createSql.append("FTASKDISPID VARCHAR(44),");
        createSql.append("FSaleOrderID VARCHAR(44),");
        createSql.append("FMaterialID VARCHAR(44),");
        createSql.append("FLotNo NVARCHAR(80),");
        createSql.append("FWarehouseID VARCHAR(44),");
        createSql.append("FLocationID VARCHAR(44),");
        createSql.append("FStoreAdminID VARCHAR(44),");
        createSql.append("FReqQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FReqDate DateTime,");
        createSql.append("FPriority INT,");
        createSql.append("FIsQuotaControl INT,");
        createSql.append("FUpperLimitQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FBaseUpperLimitQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FExUpperLimitQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FBaseExUpperLimitQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FBaseReqQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FPickingQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FUnitID VARCHAR(44),");
        createSql.append("FBaseUnitID VARCHAR(44),");
        createSql.append("FBasePickingQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FProductLineWPID VARCHAR(44),");
        createSql.append("FPickingDate DateTime,");
        createSql.append("FDividingKey NVARCHAR(500),");
        createSql.append("FMaterialReqBillID VARCHAR(44),");
        createSql.append("FMaterialReqEntryID VARCHAR(44),");
        createSql.append("FRelationID VARCHAR(44),");
        createSql.append("FProductionDpt VARCHAR(44))");
        try {
            tableName = this.createTempTable(ctx, createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String createTempTable_gather(Context ctx) throws BOSException, EASBizException {
        String tableName = "";
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table t_temp_pickingslipgather (");
        createSql.append("FID VARCHAR(44),");
        createSql.append("FParentID VARCHAR(44),");
        createSql.append("FEntryID VARCHAR(44),");
        createSql.append("FNumber NVARCHAR(80),");
        createSql.append("FSeq INT,");
        for (int i = 0; i < this.groupKeys.length; ++i) {
            createSql.append(this.groupKeys[i] + " " + this.groupKeyTypes[i] + ",");
        }
        createSql.append("FUnitID VARCHAR(44),");
        createSql.append("FBaseUnitID VARCHAR(44),");
        createSql.append("FPickingDate DateTime,");
        createSql.append("FPickingQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FBasePickingQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("FIsReWork INT DEFAULT 0,");
        createSql.append("FMaterialReqEntryID VARCHAR(44))");
        try {
            tableName = this.createTempTable(ctx, createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    @Override
    protected IRowSet _getData(Context ctx, FilterInfo filterInfo, String tableName) throws BOSException, EASBizException {
        String curLocaleCode = ctx.getLocale().toString();
        String finalSql = null;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select t1.FUUID, t1.FID,t1.FEntryID,t1.FPSLotID,ISNULL(t1.FReqQty,0) as FReqQty,t1.FLotNo,t1.FUpperLimitQty,t2.FQtyPrecision,t1.FIsQuotaControl,");
        sqlBuffer.append(" t20.fnumber as productOrderNumber, ");
        sqlBuffer.append(" t21.fnumber as TaskDispNumber, ");
        sqlBuffer.append(" t9.fnumber as trackNumber, ");
        sqlBuffer.append(" t3.fnumber as material, ");
        sqlBuffer.append(" t3.");
        sqlBuffer.append(this.getFieldName(ctx));
        sqlBuffer.append(" as materialName,");
        sqlBuffer.append(" t3.fmodel as model, ");
        sqlBuffer.append(" t4.fname_" + curLocaleCode + " as unit, ");
        sqlBuffer.append(" t22.fname_" + curLocaleCode + " as whMan, ");
        sqlBuffer.append(" t5.fname_" + curLocaleCode + " as warehouse, ");
        sqlBuffer.append(" t6.fname_" + curLocaleCode + " as location, ");
        sqlBuffer.append(" t7.fname_" + curLocaleCode + " as workshop, ");
        sqlBuffer.append(" t8.fname_" + curLocaleCode + " as productline, ");
        sqlBuffer.append(" t24.fname_" + curLocaleCode + " as costCenter,");
        sqlBuffer.append(" t1.fCostObjectID as costObject,");
        sqlBuffer.append(" t1.FNumber as pickingSlipNum, ");
        sqlBuffer.append(" t1.FREQDATE as reqDate, ");
        sqlBuffer.append(" t10.FName_" + curLocaleCode + " as processName, ");
        sqlBuffer.append(" t23.FIssuedTotalQty as issuedTotalQty, ");
        sqlBuffer.append(" t23.FReturnedTotalQty as returnedTotalQty, ");
        sqlBuffer.append(" t23.FPickedTotalQty as pickedTotalQty");
        sqlBuffer.append(" from " + tableName + " t1 left join t_mm_productline t8 on t1.FProductLineID= t8.fid ");
        sqlBuffer.append(" left join t_mm_pickingslipbillentry t25 on  t1.fentryid = t25.fid");
        sqlBuffer.append(" left join T_ORG_COSTCENTER t24 on t24.fid = t8.FCostCenterOrgUnitID");
        sqlBuffer.append(" left join T_MM_PickingSlipBillEntry t23 on t23.FID= t1.FEntryID");
        sqlBuffer.append(" left join T_MM_ProductLineWPEntry t10 on t1.FProductLineWPID= t10.fid");
        sqlBuffer.append(" left join T_MM_ProductionOrder t20 on t1.FProductionOrderID= t20.fid");
        sqlBuffer.append(" left join T_MM_TaskDispBill t21 on t1.FTaskDispID= t21.fid");
        sqlBuffer.append(" left join T_BD_Person t22 on t23.FStoreAdminID= t22.fid");
        sqlBuffer.append(" left join t_db_warehouse t5 on t1.FWarehouseID= t5.fid");
        sqlBuffer.append(" left join t_db_location t6 on t1.FLocationID= t6.fid");
        sqlBuffer.append(" left join t_mm_trackNumber t9 on t1.FTrackNumberID= t9.fid,");
        sqlBuffer.append(" t_bd_multimeasureunit  t2,t_bd_material t3, t_bd_measureunit t4,");
        sqlBuffer.append(" T_ORG_Admin t7 ");
        sqlBuffer.append(" where t1.fmaterialid= t2.fmaterialid and t1.funitid = t2.fmeasureunitid");
        sqlBuffer.append(" and t1.fmaterialid= t3.fid ");
        sqlBuffer.append(" and t1.FUnitID= t4.fid ");
        sqlBuffer.append(" and t1.FWorkshopID= t7.fid ");
        finalSql = filterInfo != null && filterInfo.getFilterItems().size() > 0 ? this.filterData(ctx, sqlBuffer, filterInfo) : sqlBuffer.toString();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)finalSql);
        return rs;
    }

    private String filterData(Context ctx, StringBuffer sqlBuffer, FilterInfo filterInfo) {
        for (int index = 0; index < filterInfo.getFilterItems().size(); ++index) {
            sqlBuffer.append(this.getTransformSql(ctx, filterInfo.getFilterItems().get(index)));
        }
        return sqlBuffer.toString();
    }

    private String getTransformSql(Context ctx, FilterItemInfo filterItemInfo) {
        Map relationMap = this.getTblRelateionMap(ctx);
        HashMap resultMap = new HashMap();
        Set keySet = relationMap.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!filterItemInfo.getPropertyName().equals(key)) continue;
            resultMap.put(relationMap.get(key), filterItemInfo.toString().substring(filterItemInfo.toString().indexOf("=")));
        }
        return this.getFilterSql(resultMap);
    }

    private String getFilterSql(Map resultMap) {
        StringBuffer buffer = new StringBuffer();
        Set resultSet = resultMap.keySet();
        Iterator it = resultSet.iterator();
        while (it.hasNext()) {
            buffer.append(" AND ");
            String key = it.next().toString();
            buffer.append(key);
            buffer.append(resultMap.get(key));
        }
        return buffer.toString();
    }

    private Map getTblRelateionMap(Context ctx) {
        String curLocaleCode = ctx.getLocale().toString();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("PickingSlipNum", "t1.FNumber");
        map.put("workshop", "t7.fname_" + curLocaleCode);
        map.put("ProductLine", "t8.fname_" + curLocaleCode);
        map.put("ProcessName", "t10.FName_" + curLocaleCode);
        map.put("MaterialName", "t3.FName_" + ctx.getLocale());
        map.put("Warehouse", "t5.fname_" + curLocaleCode);
        return map;
    }

    private String createTempTable(Context ctx, String createTableSQL) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL);
    }

    @Override
    protected void _releaseTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    private void initReturnUnSuiteData(Context ctx, String tableName, String[] ids) throws BOSException {
        int i;
        String sql = "delete from " + tableName;
        DbUtil.execute((Context)ctx, (String)sql);
        String params = this.arrayToString(ids);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into " + tableName);
        sqlBuffer.append("(FUUID,");
        sqlBuffer.append("FID,");
        sqlBuffer.append("FNumber,");
        sqlBuffer.append("FEntryID,");
        sqlBuffer.append("FSeq,");
        sqlBuffer.append("FPSLotID,");
        sqlBuffer.append("FStorageOrgUnitID,");
        sqlBuffer.append("FCuID,");
        sqlBuffer.append("FProvideType,");
        sqlBuffer.append("FSupplyStorageOrgUnitID,");
        sqlBuffer.append("FSupplyCompanyUnitID,");
        sqlBuffer.append("FRequirementCompanyUnitID,");
        sqlBuffer.append("FWorkshopID,");
        sqlBuffer.append("FClassGroupID,");
        sqlBuffer.append("FPersonID,");
        sqlBuffer.append("FProductLineID,");
        sqlBuffer.append("FTraceNo,");
        sqlBuffer.append("FTrackNumberID,");
        sqlBuffer.append("FCostCenterID,");
        sqlBuffer.append("FCostObjectID,");
        sqlBuffer.append("FProductionOrderID,");
        sqlBuffer.append("FTASKDISPID,");
        sqlBuffer.append("FSaleOrderID,");
        sqlBuffer.append("FMaterialID,");
        sqlBuffer.append("FLotNo,");
        sqlBuffer.append("FWarehouseID,");
        sqlBuffer.append("FLocationID,");
        sqlBuffer.append("FStoreAdminID,");
        sqlBuffer.append("FReqQty,");
        sqlBuffer.append("FBaseReqQty,");
        sqlBuffer.append("FUnitID,");
        sqlBuffer.append("FBaseUnitID,");
        sqlBuffer.append("FProductLineWPID,");
        sqlBuffer.append("FPickingDate,");
        sqlBuffer.append("FDividingKey,");
        sqlBuffer.append("FMaterialReqBillID,");
        sqlBuffer.append("FMaterialReqEntryID,");
        sqlBuffer.append("FRelationID)");
        sqlBuffer.append(" select newbosid('99999999'),result.*,null,newbosid('11774BB4'),null from(");
        sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,'null value' as fpslotid,");
        sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
        sqlBuffer.append("t9.FControlUnitID as cuId,");
        sqlBuffer.append("t2.FProvideType as provideType,");
        sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
        sqlBuffer.append("tourEntry.FToUnitID as supplyCompanyUnitID,");
        sqlBuffer.append("tour.FToUnitID as requirementCompanyUnitID,");
        sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
        sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,t1.ftraceno as traceno,");
        sqlBuffer.append(" case when (t13.FNumber = 'MTO20' or t13.FNumber = 'ATO20') then t1.FTrackNumberID ");
        sqlBuffer.append(" else null end as trackNumberId,");
        sqlBuffer.append("t8.FCostCenterOrgUnitID as costCenterOrgUnitID,");
        sqlBuffer.append(" case when t11.fAccountType = 5 then costLot.fid else cost.fid end as costObjectID,");
        sqlBuffer.append("t1.fproductionorderid as fproductionorderid,");
        sqlBuffer.append("t1.FTASKDISPID as FTASKDISPID,");
        sqlBuffer.append("t1.fsaleorderid  as fsaleorderid,");
        sqlBuffer.append("t2.fmaterialid as materialid,null as lotno,t2.fwarehouseid as warehouseid,");
        sqlBuffer.append("t2.flocationid as locationid,t2.fstoreadminid as storeadminid,");
        sqlBuffer.append("(t2.fissuedtotalqty-t2.freturnedtotalqty) as reqqty,");
        sqlBuffer.append("(t2.fbaseissuedtotalqty-t2.fbasereturnedtotalqty) as basereqqty,");
        sqlBuffer.append("t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
        sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
        sqlBuffer.append("t2.fpickingdate as pickingdate,");
        for (i = 0; i < this.dividingHeadKeys.length; ++i) {
            if (!this.dividingHeadValues[i].booleanValue()) continue;
            if (i > 0) {
                sqlBuffer.append("||");
            }
            sqlBuffer.append("ISNULL(t1." + this.dividingHeadKeys[i] + ", 'XXX')");
        }
        for (i = 0; i < this.dividingEntryKeys.length; ++i) {
            if (!this.dividingEntryValues[i].booleanValue()) continue;
            sqlBuffer.append("||ISNULL(t2." + this.dividingEntryKeys[i] + ", 'XXX')");
        }
        if (this.dividebyCostCenter) {
            sqlBuffer.append("||ISNULL(t8.FCostCenterOrgUnitID,'XXX')");
        }
        if (this.dividebyCostObject) {
            sqlBuffer.append("||ISNULL(case when t11.fAccountType = 5 then costLot.fid else cost.fid end,'XXX')");
        }
        sqlBuffer.append(" as dividingKey ");
        sqlBuffer.append(" from  t_mm_pickingslipbill t1 ");
        sqlBuffer.append(" left join t_mm_pickingslipbillentry t2  on  t1.fid = t2.fparentid ");
        sqlBuffer.append(" left join t_bd_materialinventory t3 on t1.fstorageorgunitid = t3.forgunit ");
        sqlBuffer.append(" and t2.fmaterialid = t3.fmaterialid ");
        sqlBuffer.append(" left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid ");
        sqlBuffer.append(" left join T_MM_Productline t8 on t8.fid = t1.FProductLineID ");
        sqlBuffer.append(" left join T_ORG_Storage t9 on t9.fid = t1.fstorageorgunitid ");
        sqlBuffer.append(" left join T_MM_ProductionOrder t10 on t10.fid = t1.FProductionOrderID");
        sqlBuffer.append(" left join t_bd_materialplan t12 on t1.fstorageorgunitid = t12.forgunit and t1.FMaterialID = t12.fmaterialid ");
        sqlBuffer.append(" left join t_bd_materialplan t15 on t1.fstorageorgunitid = t15.forgunit and t2.fmaterialid = t15.fmaterialid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t13 on t15.FManufactureStrategyID = t15.fid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t14 on t12.FManufactureStrategyID = t14.fid ");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tour on 1 = 1");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tourEntry on 1 = 1");
        sqlBuffer.append(" left join T_BD_MaterialCompanyinfo t11 on t1.fmaterialID = t11.FMaterialID and t11.FCompanyID = tour.FToUnitID");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode != '4'");
        sqlBuffer.append(" ) cost on cost.FCompanyID=tour.FToUnitID and cost.FRelatedID=t1.fmaterialid");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, bill.FBatchNumber,entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode='4'");
        sqlBuffer.append(" ) costLot on costLot.FCompanyID=tour.FToUnitID and costLot.FRelatedID=t1.fmaterialid and t10.FLotNo = costLot.FBatchNumber");
        sqlBuffer.append(" where tour.FFromUnitID = t1.FStorageOrgUnitID and tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID and t2.FProvideType != 10930");
        sqlBuffer.append(" and (t3.fislotnumber = 0 or t3.fislotnumber is null) ");
        sqlBuffer.append(" and t2.FLineStatus != 2");
        if (ids.length == 1) {
            sqlBuffer.append(" and t1.fid = " + params + ")");
        } else {
            sqlBuffer.append(" and t1.fid in(" + params + "))");
        }
        sqlBuffer.append(" union ");
        sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,t3.fid as fpslotid,");
        sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
        sqlBuffer.append("t9.FControlUnitID as cuId,");
        sqlBuffer.append("t2.FProvideType as provideType,");
        sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
        sqlBuffer.append("tourEntry.FToUnitID as supplyCompanyUnitID,");
        sqlBuffer.append("tour.FToUnitID as requirementCompanyUnitID,");
        sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
        sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,t1.ftraceno as traceno,");
        sqlBuffer.append(" case when (t13.FNumber = 'MTO20' or t13.FNumber = 'ATO20') then t1.FTrackNumberID ");
        sqlBuffer.append(" else null end as trackNumberId,");
        sqlBuffer.append("t8.FCostCenterOrgUnitID as costCenterOrgUnitID,");
        sqlBuffer.append(" case when t11.fAccountType = 5 then costLot.fid else cost.fid end as costObjectID,");
        sqlBuffer.append("t1.fproductionorderid as fproductionorderid,");
        sqlBuffer.append("t1.FTASKDISPID as FTASKDISPID,");
        sqlBuffer.append("t1.fsaleorderid  as fsaleorderid,");
        sqlBuffer.append("t2.fmaterialid as materialid,t3.flot as lotno,t3.fwarehouseid as warehouseid,");
        sqlBuffer.append("t3.flocationid as locationid,t3.fstoreadminid as storeadminid,");
        sqlBuffer.append(" t3.factualoutstockqty-t3.freturnedQty as reqqty,");
        sqlBuffer.append(" round(decimal((t3.factualoutstockqty-t3.freturnedQty)*t6.FBaseConvsRate,21,8),t6.FQtyPrecision) as basereqqty,");
        sqlBuffer.append("t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
        sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
        sqlBuffer.append("t2.fpickingdate as pickingdate,");
        for (i = 0; i < this.dividingHeadKeys.length; ++i) {
            if (!this.dividingHeadValues[i].booleanValue()) continue;
            if (i > 0) {
                sqlBuffer.append("||");
            }
            sqlBuffer.append("ISNULL(t1." + this.dividingHeadKeys[i] + ", 'XXX')");
        }
        for (i = 0; i < this.dividingEntryKeys.length; ++i) {
            if (!this.dividingEntryValues[i].booleanValue()) continue;
            sqlBuffer.append("||ISNULL(t2." + this.dividingEntryKeys[i] + ", 'XXX')");
        }
        if (this.dividebyCostCenter) {
            sqlBuffer.append("||ISNULL(t8.FCostCenterOrgUnitID,'XXX')");
        }
        if (this.dividebyCostObject) {
            sqlBuffer.append("||ISNULL(case when t11.fAccountType = 5 then costLot.fid else cost.fid end, 'XXX')");
        }
        sqlBuffer.append(" as dividingKey ");
        sqlBuffer.append(" from  t_mm_pickingslipbill t1 ");
        sqlBuffer.append(" left join t_mm_pickingslipbillentry t2  on  t1.fid = t2.fparentid ");
        sqlBuffer.append(" left join t_mm_pickingsliplot t3 on t2.fid = t3.fpickingslipentryid ");
        sqlBuffer.append(" left join t_bd_materialinventory t5 on t1.fstorageorgunitid = t5.forgunit ");
        sqlBuffer.append(" and t2.fmaterialid = t5.fmaterialid ");
        sqlBuffer.append(" left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid ");
        sqlBuffer.append(" left join t_bd_multimeasureunit t6 on 1=1 ");
        sqlBuffer.append(" left join T_MM_Productline t8 on t8.fid = t1.FProductLineID ");
        sqlBuffer.append(" left join T_ORG_Storage t9 on t9.fid = t1.fstorageorgunitid ");
        sqlBuffer.append(" left join T_MM_ProductionOrder t10 on t10.fid = t1.FProductionOrderID");
        sqlBuffer.append(" left join t_bd_materialplan t12 on t1.fstorageorgunitid = t12.forgunit and t1.FMaterialID = t12.fmaterialid ");
        sqlBuffer.append(" left join t_bd_materialplan t15 on t1.fstorageorgunitid = t15.forgunit and t2.fmaterialid = t15.fmaterialid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t13 on t15.FManufactureStrategyID = t15.fid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t14 on t12.FManufactureStrategyID = t14.fid ");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tour on 1 = 1");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tourEntry on 1 = 1");
        sqlBuffer.append(" left join T_BD_MaterialCompanyinfo t11 on t1.fmaterialID = t11.FMaterialID and t11.FCompanyID = tour.FToUnitID");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode != '4'");
        sqlBuffer.append(" ) cost on cost.FCompanyID=tour.FToUnitID and cost.FRelatedID=t1.fmaterialid");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, bill.FBatchNumber,entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode='4'");
        sqlBuffer.append(" ) costLot on costLot.FCompanyID=tour.FToUnitID and costLot.FRelatedID=t1.fmaterialid and t10.FLotNo = costLot.FBatchNumber");
        sqlBuffer.append(" where tour.FFromUnitID = t1.FStorageOrgUnitID and tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID and t2.FProvideType != 10930");
        sqlBuffer.append(" and t2.FMaterialID = t6.FMaterialID and t2.FUnitID = t6.fmeasureunitid ");
        sqlBuffer.append(" and t5.fislotnumber = 1 ");
        sqlBuffer.append(" and t2.FLineStatus != 2");
        if (ids.length == 1) {
            sqlBuffer.append(" and t1.fid = " + params + ")");
        } else {
            sqlBuffer.append(" and t1.fid in(" + params + "))");
        }
        sqlBuffer.append(" ) as result");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    @Override
    protected void _fillTempTable_returnSlip(Context ctx, String tableName, String[] ids, Vector pickingSlipVec, PickingModeEnum mode, FilterInfo dividingGroupCondition) throws BOSException, EASBizException {
        this.setDividingGroupCondition(ctx, mode, dividingGroupCondition);
        if (mode.equals((Object)PickingModeEnum.returnSlipUnSuite)) {
            this.initReturnUnSuiteData(ctx, tableName, ids);
        } else {
            this.initReturnSuiteData(ctx, tableName, pickingSlipVec);
        }
        this.updateSupplyOrgInfo(ctx, tableName);
    }

    private void initReturnSuiteData(Context ctx, String tableName, Vector pickingSlipVec) throws BOSException {
        for (HashMap psb : pickingSlipVec) {
            String pickingSlipid = psb.get("ID").toString();
            BigDecimal suite = (BigDecimal)psb.get("returningSuite");
            this.insertDataIntoTempTable_byReSuite(ctx, tableName, pickingSlipid, suite);
        }
    }

    @Override
    protected void _fillTempTable_pickingSlip(Context ctx, String tableName, String[] ids, Vector pickingSlipVec, PickingModeEnum mode, FilterInfo dividingGroupCondition, String[] entryIds) throws BOSException, EASBizException {
        this.setDividingGroupCondition(ctx, mode, dividingGroupCondition);
        if (!"1".equals(ctx.get((Object)"isEntryFilter") == null ? "0" : ctx.get((Object)"isEntryFilter").toString())) {
            entryIds = new String[]{};
        }
        if (mode.equals((Object)PickingModeEnum.pickingSlipUnSuite)) {
            this.initPickingUnSuiteData(ctx, tableName, ids, entryIds);
        } else {
            this.initPickingSuiteData(ctx, tableName, pickingSlipVec);
        }
        this.updateSupplyOrgInfo(ctx, tableName);
    }

    protected void updateSupplyOrgInfo(Context ctx, String tableName) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("update ").append(tableName).append(" set FSupplyStorageOrgUnitID = FStorageOrgUnitID,FSupplyCompanyUnitID = FRequirementCompanyUnitID where FProvideType <>").append(10930);
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void setDividingGroupCondition(Context ctx, PickingModeEnum mode, FilterInfo dividingGroupCondition) throws BOSException, EASBizException {
        FilterInfo filterInfo = null;
        if (dividingGroupCondition != null) {
            filterInfo = dividingGroupCondition;
        } else {
            filterInfo = new FilterInfo();
            String parentUIName = null;
            parentUIName = mode.equals((Object)PickingModeEnum.pickingSlipUnSuite) ? "com.kingdee.eas.mm.control.client.PickingSlip_UnSuiteUI" : (mode.equals((Object)PickingModeEnum.pickingSlipSuite) ? "com.kingdee.eas.mm.control.client.PickingSlip_SuiteUI" : (mode.equals((Object)PickingModeEnum.returnSlipUnSuite) ? "com.kingdee.eas.mm.control.client.PickingSlip_ReSuiteUI" : "com.kingdee.eas.mm.control.client.PickingSlip_ReUnSuiteUI"));
            String queryName = "com.kingdee.eas.base.message.MsgQuery";
            IQuerySolutionFacade query = QuerySolutionFacadeFactory.getLocalInstance((Context)ctx);
            QuerySolutionInfo info = query.getDefaultSolution(parentUIName, queryName);
            if (info != null && info.getEntityViewInfo() != null && !info.getEntityViewInfo().trim().equals("")) {
                EntityViewInfo view = null;
                try {
                    view = new EntityViewInfo(info.getEntityViewInfo());
                }
                catch (Exception e) {
                    throw new BOSException();
                }
                filterInfo = view.getFilter();
            }
        }
        if (filterInfo.getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                if (filterItemInfo.getPropertyName().equals("isProductOrderNumDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividingHeadValues[1] = Boolean.TRUE;
                        continue;
                    }
                    this.dividingHeadValues[1] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isSaleOrderNumDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividingHeadValues[2] = Boolean.TRUE;
                        continue;
                    }
                    this.dividingHeadValues[2] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isTrackingNumDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividingHeadValues[3] = Boolean.TRUE;
                        continue;
                    }
                    this.dividingHeadValues[3] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isProductDptDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividingHeadValues[4] = Boolean.TRUE;
                        this.dividebyWorkShop = true;
                        continue;
                    }
                    this.dividingHeadValues[4] = Boolean.FALSE;
                    this.dividebyWorkShop = false;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isProductLineDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividingHeadValues[5] = Boolean.TRUE;
                        continue;
                    }
                    this.dividingHeadValues[5] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isProcessDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividingEntryValues[1] = Boolean.TRUE;
                        continue;
                    }
                    this.dividingEntryValues[1] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isMaterialDivide")) {
                    this.dividingEntryValues[2] = (Integer)filterItemInfo.getCompareValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
                }
                if (filterItemInfo.getPropertyName().equals("isWarehouseDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividingEntryValues[3] = Boolean.TRUE;
                        continue;
                    }
                    this.dividingEntryValues[3] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isWarehouseDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividingEntryValues[3] = Boolean.TRUE;
                        continue;
                    }
                    this.dividingEntryValues[3] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isLotDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividingEntryValues[4] = Boolean.TRUE;
                        continue;
                    }
                    this.dividingEntryValues[4] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isCostObjectDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividebyCostObject = true;
                        continue;
                    }
                    this.dividebyCostObject = false;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isCostCenterDivide")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.dividebyCostCenter = true;
                        continue;
                    }
                    this.dividebyCostCenter = false;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isProductLineGroup")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.groupValues[3] = Boolean.TRUE;
                        continue;
                    }
                    this.groupValues[3] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isProcessGroup")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.groupValues[4] = Boolean.TRUE;
                        continue;
                    }
                    this.groupValues[4] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isMaterialGroup")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.groupValues[5] = Boolean.TRUE;
                        continue;
                    }
                    this.groupValues[5] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isWarehouseGroup")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.groupValues[6] = Boolean.TRUE;
                        this.groupValues[7] = Boolean.TRUE;
                        continue;
                    }
                    this.groupValues[6] = Boolean.FALSE;
                    this.groupValues[7] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isCostObjectGroup")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.groupValues[8] = Boolean.TRUE;
                        continue;
                    }
                    this.groupValues[8] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isTrackingNumGroup")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.groupValues[9] = Boolean.TRUE;
                        continue;
                    }
                    this.groupValues[9] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isProductOrderNumGroup")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.groupValues[10] = Boolean.TRUE;
                        continue;
                    }
                    this.groupValues[10] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isSaleOrderNumGroup")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.groupValues[11] = Boolean.TRUE;
                        continue;
                    }
                    this.groupValues[11] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isCostCenterGroup")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.groupValues[12] = Boolean.TRUE;
                        continue;
                    }
                    this.groupValues[12] = Boolean.FALSE;
                    continue;
                }
                if (filterItemInfo.getPropertyName().equals("isProductDptGroup")) {
                    if ((Integer)filterItemInfo.getCompareValue() == 1) {
                        this.groupValues[13] = Boolean.TRUE;
                        continue;
                    }
                    this.groupValues[13] = Boolean.FALSE;
                    continue;
                }
                if (!filterItemInfo.getPropertyName().equals("isLotGroup")) continue;
                this.groupValues[14] = (Integer)filterItemInfo.getCompareValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
    }

    private void initPickingSuiteData(Context ctx, String tableName, Vector pickingSlipVec) throws BOSException {
        for (HashMap psb : pickingSlipVec) {
            String pickingSlipid = psb.get("ID").toString();
            BigDecimal pickingSuite = (BigDecimal)psb.get("pickingSuite");
            this.insertDataIntoTempTable_bysuite(ctx, tableName, pickingSlipid, pickingSuite);
        }
    }

    private void insertDataIntoTempTable_byReSuite(Context ctx, String tableName, String id, BigDecimal suite) throws BOSException {
        int i;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into " + tableName);
        sqlBuffer.append("(FID ,");
        sqlBuffer.append("FNumber,");
        sqlBuffer.append("FEntryID,");
        sqlBuffer.append("FSeq,");
        sqlBuffer.append("FStorageOrgUnitID,");
        sqlBuffer.append("FCuID,");
        sqlBuffer.append("FProvideType,");
        sqlBuffer.append("FSupplyStorageOrgUnitID,");
        sqlBuffer.append("FSupplyCompanyUnitID,");
        sqlBuffer.append("FRequirementCompanyUnitID,");
        sqlBuffer.append("FWorkshopID,");
        sqlBuffer.append("FClassGroupID,");
        sqlBuffer.append("FPersonID,");
        sqlBuffer.append("FProductLineID,");
        sqlBuffer.append("FCostCenterID,");
        sqlBuffer.append("FCostObjectID,");
        sqlBuffer.append("FTraceNo,");
        sqlBuffer.append("FTrackNumberID,");
        sqlBuffer.append("FProductionOrderID,");
        sqlBuffer.append("FSaleOrderID,");
        sqlBuffer.append("FMaterialID,");
        sqlBuffer.append("FLotNo,");
        sqlBuffer.append("FWarehouseID,");
        sqlBuffer.append("FLocationID,");
        sqlBuffer.append("FStoreAdminID,");
        sqlBuffer.append("FReqQty,");
        sqlBuffer.append("FPickingQty,");
        sqlBuffer.append("FUnitID,");
        sqlBuffer.append("FBaseUnitID,");
        sqlBuffer.append("FBasePickingQty,");
        sqlBuffer.append("FProductLineWPID,");
        sqlBuffer.append("FPickingDate,");
        sqlBuffer.append("FDividingKey,");
        sqlBuffer.append("FMaterialReqBillID,");
        sqlBuffer.append("FMaterialReqEntryID,");
        sqlBuffer.append("FRelationID)");
        sqlBuffer.append(" select result.*,null,newbosid('11774BB4'),null from(");
        sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,");
        sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
        sqlBuffer.append("t9.fControlUnitID as cuID,");
        sqlBuffer.append("t2.FProvideType as provideType,");
        sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
        sqlBuffer.append("tourEntry.FToUnitID as supplyCompanyUnitID,");
        sqlBuffer.append("tour.FToUnitID as requirementCompanyUnitID,");
        sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
        sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,");
        sqlBuffer.append("t8.FCostCenterOrgUnitID as costCenterOrgUnitID,");
        sqlBuffer.append("case when t11.fAccountType = 5 then costLot.fid else cost.fid end as costObjectID,");
        sqlBuffer.append("t1.ftraceno as traceno,");
        sqlBuffer.append(" case when (t13.FNumber = 'MTO20' or t13.FNumber = 'ATO20') then t1.FTrackNumberID ");
        sqlBuffer.append(" else null end as trackNumberId,");
        sqlBuffer.append("t1.fproductionorderid as fproductionorderid,t1.fsaleorderid  as fsaleorderid,");
        sqlBuffer.append("t2.fmaterialid as materialid,null as lotno,t2.fwarehouseid as warehouseid,");
        sqlBuffer.append("t2.flocationid as locationid,t2.fstoreadminid as storeadminid,");
        sqlBuffer.append("t2.freqqty-t2.fpickedtotalqty+t2.freturnedtotalqty as reqqty,");
        sqlBuffer.append("round(decimal(t2.freqqty*(" + suite + "/to_number(t1.freqSuite)),21,8),t6.FQtyPrecision) as pickingQty,");
        sqlBuffer.append("t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
        sqlBuffer.append("round(decimal(t2.fbasereqqty*(" + suite + "/to_number(t1.freqSuite)),21,8),t7.FQtyPrecision) as basepickingQty,");
        sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
        sqlBuffer.append("t2.fpickingdate as pickingdate,");
        for (i = 0; i < this.dividingHeadKeys.length; ++i) {
            if (!this.dividingHeadValues[i].booleanValue()) continue;
            if (i > 0) {
                sqlBuffer.append("||");
            }
            sqlBuffer.append("ISNULL(t1." + this.dividingHeadKeys[i] + ", 'XXX')");
        }
        for (i = 0; i < this.dividingEntryKeys.length; ++i) {
            if (!this.dividingEntryValues[i].booleanValue()) continue;
            sqlBuffer.append("||ISNULL(t2." + this.dividingEntryKeys[i] + ", 'XXX')");
        }
        if (this.dividebyCostCenter) {
            sqlBuffer.append("||ISNULL(t8.FCostCenterOrgUnitID,'XXX')");
        }
        if (this.dividebyCostObject) {
            sqlBuffer.append("||ISNULL(case when t11.fAccountType = 5 then costLot.fid else cost.fid end,'XXX')");
        }
        sqlBuffer.append(" as dividingKey ");
        sqlBuffer.append(" from t_mm_pickingslipbill t1 left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid ");
        sqlBuffer.append(" left join t_mm_pickingslipbillentry t2 on t1.fid = t2.fparentid ");
        sqlBuffer.append(" left join t_bd_materialinventory t3 on t2.fmaterialid = t3.fmaterialid and t1.fstorageorgunitid = t3.forgunit");
        sqlBuffer.append(" left join t_bd_multimeasureunit  t6 on 1=1 left join t_bd_multimeasureunit t7 on 1=1");
        sqlBuffer.append(" left join T_MM_Productline t8 on t8.fid = t1.FProductLineID");
        sqlBuffer.append(" left join T_ORG_Storage t9 on t9.fid = t1.fstorageorgunitid");
        sqlBuffer.append(" left join T_MM_ProductionOrder t10 on t10.fid = t1.FProductionOrderID");
        sqlBuffer.append(" left join t_bd_materialplan t12 on t1.fstorageorgunitid = t12.forgunit and t1.FMaterialID = t12.fmaterialid ");
        sqlBuffer.append(" left join t_bd_materialplan t15 on t1.fstorageorgunitid = t15.forgunit and t2.fmaterialid = t15.fmaterialid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t13 on t15.FManufactureStrategyID = t15.fid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t14 on t12.FManufactureStrategyID = t14.fid ");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tour on 1 = 1");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tourEntry on 1 = 1");
        sqlBuffer.append(" left join T_BD_MaterialCompanyinfo t11 on t11.fmaterialID = t1.FMaterialID and t11.FCompanyID = tour.FToUnitID");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode != '4'");
        sqlBuffer.append(" ) cost on cost.FCompanyID=tour.FToUnitID and cost.FRelatedID=t1.fmaterialid");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, bill.FBatchNumber,entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode='4'");
        sqlBuffer.append(" ) costLot on costLot.FCompanyID=tour.FToUnitID and costLot.FRelatedID=t1.fmaterialid and t10.FLotNo = costLot.FBatchNumber");
        sqlBuffer.append(" where tour.FFromUnitID = t1.FStorageOrgUnitID and tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID and t2.FProvideType != 10930");
        sqlBuffer.append(" and t1.fid = '" + id + "' and t1.fReqSuite>0");
        sqlBuffer.append(" and  t2.FLineStatus != 2");
        sqlBuffer.append(" and (t3.fislotnumber = 0 or t3.fislotnumber is null)");
        sqlBuffer.append(" and t2.FMaterialID = t6.FMaterialID and t2.FUnitID = t6.fmeasureunitid ");
        sqlBuffer.append(" and t2.FMaterialID = t7.FMaterialID and t2.FBaseUnitID = t7.fmeasureunitid )");
        sqlBuffer.append(" union all ");
        sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,");
        sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
        sqlBuffer.append("t9.fControlUnitID as cuID,");
        sqlBuffer.append("t2.FProvideType as provideType,");
        sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
        sqlBuffer.append("tourEntry.FToUnitID as supplyCompanyUnitID,");
        sqlBuffer.append("tour.FToUnitID as requirementCompanyUnitID,");
        sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
        sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,");
        sqlBuffer.append("t8.FCostCenterOrgUnitID as costCenterOrgUnitID,");
        sqlBuffer.append("case when t11.fAccountType = 5 then costLot.fid else cost.fid end as costObjectID,");
        sqlBuffer.append("t1.ftraceno as traceno,");
        sqlBuffer.append(" case when (t13.FNumber = 'MTO20' or t13.FNumber = 'ATO20') then t1.FTrackNumberID ");
        sqlBuffer.append(" else null end as trackNumberId,");
        sqlBuffer.append("t1.fproductionorderid as fproductionorderid,t1.fsaleorderid  as fsaleorderid,");
        sqlBuffer.append("t2.fmaterialid as materialid,t3.flot as lotno,t3.fwarehouseid as warehouseid,");
        sqlBuffer.append("t3.flocationid as locationid,t3.fstoreadminid as storeadminid,t3.fselectQty-t3.fpickedQty as reqqty,");
        sqlBuffer.append("round(decimal(t2.freqqty*(" + suite + "/to_number(t1.freqSuite))*((t3.FACTUALOUTSTOCKQTY-t3.FRETURNEDQTY)/to_number(t2.FISSUEDTOTALQTY-t2.FRETURNEDTOTALQTY)),21,8),t6.FQtyPrecision) as pickingQty,");
        sqlBuffer.append("t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
        sqlBuffer.append("round(decimal(t2.fbasereqqty*(" + suite + "/to_number(t1.freqSuite))*((t3.FACTUALOUTSTOCKQTY-t3.FRETURNEDQTY)/to_number(t2.FISSUEDTOTALQTY-t2.FRETURNEDTOTALQTY)),21,8),t7.FQtyPrecision) as basepickingQty,");
        sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
        sqlBuffer.append("t2.fpickingdate as pickingdate,");
        for (i = 0; i < this.dividingHeadKeys.length; ++i) {
            if (!this.dividingHeadValues[i].booleanValue()) continue;
            if (i > 0) {
                sqlBuffer.append("||");
            }
            sqlBuffer.append("ISNULL(t1." + this.dividingHeadKeys[i] + ", 'XXX')");
        }
        for (i = 0; i < this.dividingEntryKeys.length; ++i) {
            if (!this.dividingEntryValues[i].booleanValue()) continue;
            sqlBuffer.append("||ISNULL(t2." + this.dividingEntryKeys[i] + ", 'XXX')");
        }
        if (this.dividebyCostCenter) {
            sqlBuffer.append("||ISNULL(t8.FCostCenterOrgUnitID,'XXX')");
        }
        if (this.dividebyCostObject) {
            sqlBuffer.append("||ISNULL(case when t11.fAccountType = 5 then costLot.fid else cost.fid end,'XXX')");
        }
        sqlBuffer.append(" as dividingKey ");
        sqlBuffer.append(" from t_mm_pickingslipbill t1  left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid");
        sqlBuffer.append(" left join t_mm_pickingslipbillentry t2 on 1=1 left join t_mm_pickingsliplot t3 on 1=1");
        sqlBuffer.append(" left join t_bd_multimeasureunit t6 on 1=1 left join t_bd_multimeasureunit t7 on 1=1");
        sqlBuffer.append(" left join T_MM_Productline t8 on t8.fid = t1.FProductLineID");
        sqlBuffer.append(" left join T_ORG_Storage t9 on t9.fid = t1.fstorageorgunitid");
        sqlBuffer.append(" left join T_MM_ProductionOrder t10 on t10.fid = t1.FProductionOrderID");
        sqlBuffer.append(" left join t_bd_materialplan t12 on t1.fstorageorgunitid = t12.forgunit and t1.FMaterialID = t12.fmaterialid ");
        sqlBuffer.append(" left join t_bd_materialplan t15 on t1.fstorageorgunitid = t15.forgunit and t2.fmaterialid = t15.fmaterialid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t13 on t15.FManufactureStrategyID = t15.fid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t14 on t12.FManufactureStrategyID = t14.fid ");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tour on 1 = 1");
        sqlBuffer.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" )tourEntry on 1 = 1");
        sqlBuffer.append(" left join T_BD_MaterialCompanyinfo t11 on t11.fmaterialID = t1.FMaterialID and t11.FCompanyID = tour.FToUnitID");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode != '4'");
        sqlBuffer.append(" ) cost on cost.FCompanyID=tour.FToUnitID and cost.FRelatedID=t1.fmaterialid");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, bill.FBatchNumber,entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode='4'");
        sqlBuffer.append(" ) costLot on costLot.FCompanyID=tour.FToUnitID and costLot.FRelatedID=t1.fmaterialid and t10.FLotNo = costLot.FBatchNumber");
        sqlBuffer.append(" where tour.FFromUnitID = t1.FStorageOrgUnitID and tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID and t2.FProvideType != 10930");
        sqlBuffer.append(" and t1.fid = t2.fparentid  and t2.fid = t3.fpickingslipentryid  and t2.FISSUEDTOTALQTY-t2.FRETURNEDTOTALQTY>0 ");
        sqlBuffer.append(" and t2.FLineStatus != 2");
        sqlBuffer.append(" and t2.FMaterialID = t6.FMaterialID and t2.FUnitID = t6.fmeasureunitid ");
        sqlBuffer.append(" and t2.FMaterialID = t7.FMaterialID and t2.FBaseUnitID = t7.fmeasureunitid  ");
        sqlBuffer.append(" and t1.fid = '" + id + "' and t1.fReqSuite>0");
        sqlBuffer.append(")) as result");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
        String sql_delete = "delete from " + tableName + " where FBasePickingQty <=0 ";
        DbUtil.execute((Context)ctx, (String)sql_delete);
    }

    private void insertDataIntoTempTable_bysuite(Context ctx, String tableName, String id, BigDecimal suite) throws BOSException {
        int i;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into " + tableName);
        sqlBuffer.append("(FID ,");
        sqlBuffer.append("FNumber,");
        sqlBuffer.append("FEntryID,");
        sqlBuffer.append("FSeq,");
        sqlBuffer.append("FStorageOrgUnitID,");
        sqlBuffer.append("FCuID,");
        sqlBuffer.append("FProvideType,");
        sqlBuffer.append("FSupplyStorageOrgUnitID,");
        sqlBuffer.append("FSupplyCompanyUnitID,");
        sqlBuffer.append("FRequirementCompanyUnitID,");
        sqlBuffer.append("FWorkshopID,");
        sqlBuffer.append("FClassGroupID,");
        sqlBuffer.append("FPersonID,");
        sqlBuffer.append("FProductLineID,");
        sqlBuffer.append("FCostCenterID,");
        sqlBuffer.append("FCostObjectID,");
        sqlBuffer.append("FTraceNo,");
        sqlBuffer.append("FTrackNumberID,");
        sqlBuffer.append("FProductionOrderID,");
        sqlBuffer.append("FSaleOrderID,");
        sqlBuffer.append("FMaterialID,");
        sqlBuffer.append("FLotNo,");
        sqlBuffer.append("FWarehouseID,");
        sqlBuffer.append("FLocationID,");
        sqlBuffer.append("FStoreAdminID,");
        sqlBuffer.append("FReqQty,");
        sqlBuffer.append("FPickingQty,");
        sqlBuffer.append("FUnitID,");
        sqlBuffer.append("FBaseUnitID,");
        sqlBuffer.append("FBasePickingQty,");
        sqlBuffer.append("FProductLineWPID,");
        sqlBuffer.append("FPickingDate,");
        sqlBuffer.append("FDividingKey,");
        sqlBuffer.append("FMaterialReqBillID,");
        sqlBuffer.append("FMaterialReqEntryID,");
        sqlBuffer.append("FRelationID)");
        sqlBuffer.append(" select result.*,null,null,null from(");
        sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,");
        sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
        sqlBuffer.append("t9.FControlUnitID as cuId,");
        sqlBuffer.append("t2.FProvideType as provideType,");
        sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
        sqlBuffer.append("tourEntry.FToUnitID as supplyCompanyUnitID,");
        sqlBuffer.append("tour.FToUnitID as requirementCompanyUnitID,");
        sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
        sqlBuffer.append("t4.fpersonid as personid,t1.fproductlineid  as productlineid,");
        sqlBuffer.append("t8.FCostCenterOrgUnitID as costCenterOrgUnitID,");
        sqlBuffer.append(" case when t11.fAccountType = 5 then costLot.fid else cost.fid end as costObjectID,");
        sqlBuffer.append(" t1.ftraceno as traceno,");
        sqlBuffer.append(" case when (t13.FNumber = 'MTO20' or t13.FNumber = 'ATO20') then t1.FTrackNumberID ");
        sqlBuffer.append(" else null end as trackNumberId,");
        sqlBuffer.append("t1.fproductionorderid as fproductionorderid,t1.fsaleorderid  as fsaleorderid,");
        sqlBuffer.append("t2.fmaterialid as materialid,t2.flotno as lotno,t2.fwarehouseid as warehouseid,");
        sqlBuffer.append("t2.flocationid as locationid,t2.fstoreadminid as storeadminid,");
        sqlBuffer.append("t2.freqqty as reqqty,");
        sqlBuffer.append("round(decimal(t2.freqqty*(" + suite + "/to_number(t1.freqSuite)),21,8),t6.FQtyPrecision) as pickingQty,");
        sqlBuffer.append("t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
        sqlBuffer.append("round(decimal(t2.fbasereqqty*(" + suite + "/to_number(t1.freqSuite)),21,8),t7.FQtyPrecision) as basepickingQty,");
        sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
        sqlBuffer.append("t2.fpickingdate as pickingdate,");
        for (i = 0; i < this.dividingHeadKeys.length; ++i) {
            if (!this.dividingHeadValues[i].booleanValue()) continue;
            if (i > 0) {
                sqlBuffer.append("||");
            }
            sqlBuffer.append("ISNULL(t1." + this.dividingHeadKeys[i] + ", 'XXX')");
        }
        for (i = 0; i < this.dividingEntryKeys.length; ++i) {
            if (!this.dividingEntryValues[i].booleanValue()) continue;
            sqlBuffer.append("||ISNULL(t2." + this.dividingEntryKeys[i] + ", 'XXX')");
        }
        if (this.dividebyCostCenter) {
            sqlBuffer.append("||ISNULL(t8.FCostCenterOrgUnitID, 'XXX')");
        }
        if (this.dividebyCostObject) {
            sqlBuffer.append("||ISNULL(case when t11.fAccountType = 5 then costLot.fid else cost.fid end,'XXX')");
        }
        sqlBuffer.append(" as dividingKey ");
        sqlBuffer.append(" from t_mm_pickingslipbill t1 left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid");
        sqlBuffer.append(" left join t_mm_pickingslipbillentry t2 on t1.fid = t2.FParentID left join t_bd_multimeasureunit t6 on 1=1 left join t_bd_multimeasureunit t7 on 1=1 ");
        sqlBuffer.append(" left join T_MM_Productline t8 on t8.fid = t1.FProductLineID");
        sqlBuffer.append(" left join T_ORG_Storage t9 on t9.fid = t1.fstorageorgunitid");
        sqlBuffer.append(" left join T_MM_ProductionOrder t10 on t10.fid = t1.FProductionOrderID");
        sqlBuffer.append(" left join t_bd_materialplan t12 on t1.fstorageorgunitid = t12.forgunit and t1.FMaterialID = t12.fmaterialid ");
        sqlBuffer.append(" left join t_bd_materialplan t15 on t1.fstorageorgunitid = t15.forgunit and t2.fmaterialid = t15.fmaterialid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t13 on t15.FManufactureStrategyID = t13.fid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t14 on t12.FManufactureStrategyID = t14.fid ");
        sqlBuffer.append(" left join (select distinct tou.FFromUnitID as FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID ");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" ) tour on 1=1");
        sqlBuffer.append(" left join (select distinct tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" ) tourEntry on 1=1");
        sqlBuffer.append(" left join T_BD_MaterialCompanyinfo t11 on t11.fmaterialID = t1.FMaterialID and t11.FCompanyID = tour.FToUnitID");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode != '4'");
        sqlBuffer.append(" ) cost on cost.FCompanyID=tour.FToUnitID and cost.FRelatedID=t1.fmaterialid");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, bill.FBatchNumber,entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode='4'");
        sqlBuffer.append(" ) costLot on costLot.FCompanyID=tour.FToUnitID and costLot.FRelatedID=t1.fmaterialid and t10.FLotNo = costLot.FBatchNumber");
        sqlBuffer.append(" where tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID and tour.FFromUnitID = t1.FStorageOrgUnitID ");
        sqlBuffer.append("and t1.fid = '" + id + "' and t1.fReqSuite > 0 ");
        sqlBuffer.append("and t2.FLineStatus != 2 ");
        sqlBuffer.append("and t2.FMaterialID = t6.FMaterialID and t2.FUnitID = t6.fmeasureunitid  ");
        sqlBuffer.append("and t2.FMaterialID = t7.FMaterialID and t2.FBaseUnitID = t7.fmeasureunitid )");
        sqlBuffer.append(") as result");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    private void initPickingUnSuiteData(Context ctx, String tableName, String[] ids, String[] entryIds) throws BOSException {
        int i;
        String sql = "delete from " + tableName;
        DbUtil.execute((Context)ctx, (String)sql);
        String params = this.arrayToString(ids);
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into " + tableName);
        sqlBuffer.append("(FID,");
        sqlBuffer.append("FNumber,");
        sqlBuffer.append("FEntryID,");
        sqlBuffer.append("FSeq,");
        sqlBuffer.append("FStorageOrgUnitID,");
        sqlBuffer.append("FCuID,");
        sqlBuffer.append("FProvideType,");
        sqlBuffer.append("FSupplyStorageOrgUnitID,");
        sqlBuffer.append("FSupplyCompanyUnitID,");
        sqlBuffer.append("FRequirementCompanyUnitID,");
        sqlBuffer.append("FWorkshopID,");
        sqlBuffer.append("FClassGroupID,");
        sqlBuffer.append("FPersonID,");
        sqlBuffer.append("FProductLineID,");
        sqlBuffer.append("FCostCenterID,");
        sqlBuffer.append("FCostObjectID,");
        sqlBuffer.append("FTraceNo,");
        sqlBuffer.append("FProductID,");
        sqlBuffer.append("FTrackNumberID,");
        sqlBuffer.append("FProductionOrderID,");
        sqlBuffer.append("FTASKDISPID,");
        sqlBuffer.append("FSaleOrderID,");
        sqlBuffer.append("FMaterialID,");
        sqlBuffer.append("FWarehouseID,");
        sqlBuffer.append("FLocationID,");
        sqlBuffer.append("FStoreAdminID,");
        sqlBuffer.append("FReqQty,");
        sqlBuffer.append("FBaseReqQty,");
        sqlBuffer.append("FUpperLimitQty,");
        sqlBuffer.append("FBaseUpperLimitQty,");
        sqlBuffer.append("FExUpperLimitQty,");
        sqlBuffer.append("FBaseExUpperLimitQty,");
        sqlBuffer.append("FIsQuotaControl,");
        sqlBuffer.append("FReqDate,");
        sqlBuffer.append("FLotNo,");
        sqlBuffer.append("FUnitID,");
        sqlBuffer.append("FBaseUnitID,");
        sqlBuffer.append("FProductLineWPID,");
        sqlBuffer.append("FPickingDate,");
        sqlBuffer.append("FDividingKey)");
        sqlBuffer.append("(select t1.fid as fid,t1.fnumber as fnumber,t2.fid as fentryid,t2.fseq as fseq,");
        sqlBuffer.append("t1.fstorageorgunitid as storageorgunitid,");
        sqlBuffer.append("t9.FControlUnitID as cuId,");
        sqlBuffer.append("t2.FProvideType as provideType,");
        sqlBuffer.append("t2.FSupplyStorageOrgUnitID as supplyStorageOrgUnitID,");
        sqlBuffer.append("tourEntry.FToUnitID as supplyCompanyUnitID,");
        sqlBuffer.append("tour.FToUnitID as requirementCompanyUnitID,");
        sqlBuffer.append("t1.fworkshopid as workshopid,t1.fclassgroupid as classgroupid,");
        sqlBuffer.append("t4.fpersonid as personid, t1.fproductlineid  as productlineid,t8.FCostCenterOrgUnitID as costCenterOrgUnitID,");
        sqlBuffer.append(" case when t11.fAccountType = 5 then costLot.fid else cost.fid end as costObjectID,");
        sqlBuffer.append("t1.ftraceno as traceno,t1.FMaterialID as productid,");
        sqlBuffer.append(" case when (t13.FNumber = 'MTO20' or t13.FNumber = 'ATO20') then t1.FTrackNumberID ");
        sqlBuffer.append(" else null end as trackNumberId,");
        sqlBuffer.append("t1.fproductionorderid as fproductionorderid,");
        sqlBuffer.append("t1.FTASKDISPID as FTASKDISPID,");
        sqlBuffer.append("t1.fsaleorderid  as fsaleorderid,");
        sqlBuffer.append("t2.fmaterialid as materialid,t2.fwarehouseid as warehouseid,");
        sqlBuffer.append("t2.flocationid as locationid,t2.fstoreadminid as storeadminid,");
        sqlBuffer.append(" t2.freqqty-t2.fsupplementtotalqty-t2.fpickedtotalqty-t2.fissuedtotalqty+t2.freturnedtotalqty  as reqqty,");
        sqlBuffer.append(" t2.fbasereqqty-t2.fbasesupplementtotalqty-t2.fbasepickedtotalqty-t2.fbaseissuedtotalqty+t2.fbasereturnedtotalqty as basereqqty,");
        sqlBuffer.append(" case when t3.FIsQuotaControl = 1");
        sqlBuffer.append(" then round(decimal((t2.freqqty-t2.fsupplementtotalqty)*(1+t3.FISSInHightLimit/100)-t2.fpickedtotalqty-t2.fissuedtotalqty+t2.freturnedtotalqty,21,8),t6.FQtyPrecision) ");
        sqlBuffer.append(" else 0 end as FUpperLimitQty,");
        sqlBuffer.append(" case when t3.FIsQuotaControl = 1");
        sqlBuffer.append(" then round(decimal((t2.fbasereqqty-t2.fbasesupplementtotalqty)*(1+t3.FISSInHightLimit/100)-t2.fbasepickedtotalqty-t2.fbaseissuedtotalqty+t2.fbasereturnedtotalqty,21,8),t7.FQtyPrecision) ");
        sqlBuffer.append(" else 0 end as FBaseUpperLimitQty,");
        sqlBuffer.append(" case when t3.FIsQuotaControl = 1");
        sqlBuffer.append(" then decimal((t2.freqqty-t2.fsupplementtotalqty)*(1+t3.FISSInHightLimit/100)-t2.fpickedtotalqty-t2.fissuedtotalqty+t2.freturnedtotalqty,21,8) ");
        sqlBuffer.append(" else 0 end as FExUpperLimitQty,");
        sqlBuffer.append(" case when t3.FIsQuotaControl = 1");
        sqlBuffer.append(" then decimal((t2.fbasereqqty-t2.fbasesupplementtotalqty)*(1+t3.FISSInHightLimit/100)-t2.fpickedtotalqty-t2.fissuedtotalqty+t2.freturnedtotalqty,21,8) ");
        sqlBuffer.append(" else 0 end as FBaseExUpperLimitQty,");
        sqlBuffer.append("t3.FIsQuotaControl,t2.freqdate, t2.FLotNo, t2.funitid as unitid,t2.fbaseunitid as  baseunitid,");
        sqlBuffer.append("t2.fproductlinewpid as productlinewpid,");
        sqlBuffer.append("t2.fpickingdate as pickingdate,");
        for (i = 0; i < this.dividingHeadKeys.length; ++i) {
            if (!this.dividingHeadValues[i].booleanValue()) continue;
            if (i > 0) {
                sqlBuffer.append("||");
            }
            sqlBuffer.append("ISNULL(t1." + this.dividingHeadKeys[i] + ", 'XXX')");
        }
        for (i = 0; i < this.dividingEntryKeys.length; ++i) {
            if (this.dividingEntryValues[i] != Boolean.TRUE) continue;
            sqlBuffer.append("||ISNULL(t2." + this.dividingEntryKeys[i] + ", 'XXX')");
        }
        if (this.dividebyCostCenter) {
            sqlBuffer.append("||ISNULL(t8.FCostCenterOrgUnitID,'XXX')");
        }
        if (this.dividebyCostObject) {
            sqlBuffer.append("||ISNULL(case when t11.fAccountType = 5 then costLot.fid else cost.fid end,'XXX')");
        }
        sqlBuffer.append(" as dividingKey ");
        sqlBuffer.append(" from t_mm_pickingslipbill t1 ");
        sqlBuffer.append(" left join t_mm_pickingslipbillentry t2  on  t1.fid = t2.fparentid ");
        sqlBuffer.append(" left join t_bd_materialplan t3 on t1.fstorageorgunitid = t3.forgunit and t2.fmaterialid = t3.fmaterialid ");
        sqlBuffer.append(" left join t_mm_classgroup t4 on t1.fclassgroupid = t4.fid ");
        sqlBuffer.append(" left join t_bd_multimeasureunit  t6  on  1=1 ");
        sqlBuffer.append(" left join t_bd_multimeasureunit t7  on  1=1 ");
        sqlBuffer.append(" left join T_MM_Productline t8 on t8.fid = t1.FProductLineID ");
        sqlBuffer.append(" left join T_ORG_Storage t9 on t9.fid = t1.fstorageorgunitid ");
        sqlBuffer.append(" left join T_MM_ProductionOrder t10 on t10.fid = t1.FProductionOrderID");
        sqlBuffer.append(" left join t_bd_materialplan t12 on t1.fstorageorgunitid = t12.forgunit and t1.FMaterialID = t12.fmaterialid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t13 on t3.FManufactureStrategyID = t13.fid ");
        sqlBuffer.append(" left join T_BD_ManufactureStrategy t14 on t12.FManufactureStrategyID = t14.fid ");
        sqlBuffer.append(" left join (select distinct tou.FFromUnitID as FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" ) tour on 1=1");
        sqlBuffer.append(" left join T_BD_MaterialCompanyinfo t11 on t1.fmaterialID = t11.FMaterialID and t11.FCompanyID = tour.FToUnitID");
        sqlBuffer.append(" left join (select distinct tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where tot.FFromType = 4 and tot.FToType = 1");
        sqlBuffer.append(" ) tourEntry on 1=1");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode != '4'");
        sqlBuffer.append(" ) cost on cost.FCompanyID=tour.FToUnitID and cost.FRelatedID=t1.fmaterialid");
        sqlBuffer.append(" left join (");
        sqlBuffer.append(" select bill.fid,bill.FCompanyID, bill.FBatchNumber,entry.FRelatedID from T_BD_CostObject bill inner join T_BD_CostObjectEntry entry");
        sqlBuffer.append(" on bill.fid=entry.fparentid where bill.FIsForbiden =0 and bill.FCalculateMode='4'");
        sqlBuffer.append(" ) costLot on costLot.FCompanyID=tour.FToUnitID and costLot.FRelatedID=t1.fmaterialid and t10.FLotNo = costLot.FBatchNumber");
        sqlBuffer.append(" where tourEntry.FFromUnitID = t2.FSupplyStorageOrgUnitID and tour.FFromUnitID = t1.FStorageOrgUnitID ");
        sqlBuffer.append(" and t2.FMaterialID = t6.FMaterialID and t2.FUnitID = t6.fmeasureunitid ");
        sqlBuffer.append(" and t2.FMaterialID = t7.FMaterialID and t2.FBaseUnitID = t7.fmeasureunitid ");
        sqlBuffer.append(" and t2.FLineStatus != 2");
        if (ids.length == 1) {
            sqlBuffer.append(" and t1.fid = " + params);
        } else {
            sqlBuffer.append(" and t1.fid in (" + params + ")");
        }
        if (entryIds != null && entryIds.length > 0) {
            String entryParams = this.arrayToString(entryIds);
            if (entryIds.length == 1) {
                sqlBuffer.append(" and t2.fid = " + entryParams + "");
            } else {
                sqlBuffer.append(" and t2.fid in (" + entryParams + ")");
            }
        }
        sqlBuffer.append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    private String getFieldName(Context ctx) {
        return "FName_" + ctx.getLocale();
    }

    @Override
    protected Map _getUnsuiteInitData(Context ctx, String tableName) throws BOSException, EASBizException {
        HashMap resultData = new HashMap();
        try {
            resultData.putAll(this.getFilterData(ctx, tableName));
        }
        catch (SQLException e) {
            throw new BOSException();
        }
        return resultData;
    }

    private Map getFilterData(Context ctx, String tableName) throws BOSException, SQLException {
        HashMap<String, Vector> filterResultMap = new HashMap<String, Vector>();
        String curLocaleCode = ctx.getLocale().toString();
        String PSNumFilterItemSQL = "SELECT DISTINCT FNUMBER as pickingSlipNum FROM " + tableName;
        filterResultMap.put("PSNumFilterItem", this.transformRS2Vector(DbUtil.executeQuery((Context)ctx, (String)PSNumFilterItemSQL), "pickingSlipNum", ctx));
        String productDptFilterItemSQL = "SELECT DISTINCT orgAdmin.FNAME_" + curLocaleCode + " AS productionDpt FROM " + tableName + " tempTbl LEFT JOIN T_ORG_Admin orgAdmin ON tempTbl.FWorkshopID = orgAdmin.fid";
        filterResultMap.put("productDptFilterItem", this.transformRS2Vector(DbUtil.executeQuery((Context)ctx, (String)productDptFilterItemSQL), "productionDpt", ctx));
        String productLineFilterItemSQL = "SELECT DISTINCT productLine.FNAME_" + curLocaleCode + " AS productLine FROM " + tableName + " tempTbl LEFT JOIN t_mm_productline productLine on tempTbl.FProductLineID = productLine.fid";
        filterResultMap.put("productLineFilterItem", this.transformRS2Vector(DbUtil.executeQuery((Context)ctx, (String)productLineFilterItemSQL), "productLine", ctx));
        String processFilterItemSQL = "SELECT DISTINCT process.FName_" + curLocaleCode + " AS processName FROM " + tableName + " tempTbl LEFT JOIN T_MM_ProductLineWPEntry process on tempTbl.FProductLineWPID= process.fid";
        filterResultMap.put("processFilterItem", this.transformRS2Vector(DbUtil.executeQuery((Context)ctx, (String)processFilterItemSQL), "processName", ctx));
        String materialFilterItemSQL = "SELECT DISTINCT material.FName_" + curLocaleCode + " AS materialName FROM " + tableName + " tempTbl LEFT JOIN t_bd_material material on tempTbl.fmaterialid= material.fid";
        filterResultMap.put("materialFilterItem", this.transformRS2Vector(DbUtil.executeQuery((Context)ctx, (String)materialFilterItemSQL), "materialName", ctx));
        String warehouseFilterItemSQL = "SELECT DISTINCT warehouse.FName_" + curLocaleCode + " AS warehouseName FROM " + tableName + " tempTbl LEFT JOIN t_db_warehouse warehouse on tempTbl.FWarehouseID= warehouse.fid";
        filterResultMap.put("warehouseFilterItem", this.transformRS2Vector(DbUtil.executeQuery((Context)ctx, (String)warehouseFilterItemSQL), "warehouseName", ctx));
        return filterResultMap;
    }

    private Vector transformRS2Vector(IRowSet rowSet, String key, Context ctx) throws SQLException {
        Vector<String> filterItems = new Vector<String>();
        filterItems.add(this.getPSResource(ctx, "Search_Full"));
        while (rowSet.next()) {
            filterItems.add(rowSet.getString(key));
        }
        return filterItems;
    }

    @Override
    protected IRowSet _getSuiteData(Context ctx, String[] ids) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select round(to_decimal(min(to_decimal((t2.fReqQty-t2.FIssuedTotalQty-t2.FPickedTotalQty+t2.FReturnedTotalQty-t2.FSupplementTotalQty)/t2.fReqQty,21,11)*t1.FReqSuite),21,8),t8.FQtyPrecision) as suite,");
        sql.append(" t1.fid, t1.fnumber as pickNum, t3.fnumber as orderNum, t3.fstartdate, t4.fnumber as taskNum,");
        sql.append(" t5.fnumber as mNumber,");
        sql.append(" t5.");
        sql.append(this.getFieldName(ctx));
        sql.append(" as mName,");
        sql.append(" t5.fModel as model,");
        sql.append(" t7.");
        sql.append(this.getFieldName(ctx));
        sql.append(" as uName,");
        sql.append(" t9.");
        sql.append(this.getFieldName(ctx));
        sql.append(" as pName,");
        sql.append(" t6.");
        sql.append(this.getFieldName(ctx));
        sql.append(" as wName,");
        sql.append(" t8.FQtyPrecision as pis ");
        sql.append(" from T_MM_PickingSlipbill as t1 inner join T_MM_PickingSlipbillEntry as t2");
        sql.append(" on t1.fid = t2.fParentid");
        sql.append(" inner join T_BD_Material t5 on t1.FMaterialID = t5.fid");
        sql.append(" inner join t_bd_MeasureUnit t7 on t1.funitid = t7.fid");
        sql.append(" inner join t_bd_multiMeasureUnit t8 on t8.fMaterialid = t1.FMaterialID and t8.fMeasureUnitID = t1.funitid");
        sql.append(" left join T_MM_ProductionOrder t3 on t1.FProductionOrderID = t3.fid");
        sql.append(" left join T_MM_TaskDispBill t4 on t1.FTaskDispID = t4.fid");
        sql.append(" left join T_MM_ProductLine t9 on t1.FProductLineID = t9.fid");
        sql.append(" left join T_ORG_Admin t6 on t1.FWorkshopID = t6.fid");
        if (ids.length == 1) {
            sql.append(" where t1.fid = '" + ids[0] + "' and t1.FReqSuite > 0");
        } else {
            sql.append(" where t1.fid in (" + this.arrayToString(ids) + ") and t1.FReqSuite > 0");
        }
        sql.append(" and t2.FLineStatus != 2");
        sql.append(" group by t1.fid,t1.fnumber,t1.FReqSuite,t3.fnumber,t3.fstartdate,t4.fnumber, t5.fnumber,");
        sql.append(" t5.");
        sql.append(this.getFieldName(ctx) + ",");
        sql.append(" t5.fModel,");
        sql.append(" t7.");
        sql.append(this.getFieldName(ctx) + ",");
        sql.append(" t9.");
        sql.append(this.getFieldName(ctx) + ",");
        sql.append(" t6.");
        sql.append(this.getFieldName(ctx) + ",");
        sql.append(" t8.FQtyPrecision");
        sql.append(" order by t1.fnumber, t3.fstartdate");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return result;
    }

    @Override
    protected IRowSet _getReSuiteData(Context ctx, String[] picingIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select round(to_decimal(min(to_decimal((t2.FIssuedTotalQty-t2.FReturnedTotalQty+t2.FSupplementTotalQty)/t2.fReqQty,21,11)*t1.FReqSuite),21,8),t8.FQtyPrecision) as suite,");
        sql.append(" t1.fid, t1.fnumber as pickNum,t3.fnumber as orderNum, t3.fstartdate, t4.fnumber as taskNum,");
        sql.append(" t5.fnumber as mNumber,");
        sql.append(" t5.");
        sql.append(this.getFieldName(ctx));
        sql.append(" as mName,");
        sql.append(" t5.fModel as model,");
        sql.append(" t7.");
        sql.append(this.getFieldName(ctx));
        sql.append(" as uName,");
        sql.append(" t9.");
        sql.append(this.getFieldName(ctx));
        sql.append(" as pName,");
        sql.append(" t6.");
        sql.append(this.getFieldName(ctx));
        sql.append(" as wName,");
        sql.append(" t8.FQtyPrecision as pis ");
        sql.append(" from T_MM_PickingSlipbill as t1 inner join T_MM_PickingSlipbillEntry as t2");
        sql.append(" on t1.fid = t2.fParentid");
        sql.append(" inner join T_BD_Material t5 on t1.FMaterialID = t5.fid");
        sql.append(" inner join t_bd_MeasureUnit t7 on t1.funitid = t7.fid");
        sql.append(" inner join t_bd_multiMeasureUnit t8 on t8.fMaterialid = t1.FMaterialID and t8.fMeasureUnitID = t1.funitid");
        sql.append(" left join T_MM_ProductionOrder t3 on t1.FProductionOrderID = t3.fid");
        sql.append(" left join T_MM_TaskDispBill t4 on t1.FTaskDispID = t4.fid");
        sql.append(" left join T_MM_ProductLine t9 on t1.FProductLineID = t9.fid");
        sql.append(" left join T_ORG_Admin t6 on t1.FWorkshopID = t6.fid");
        if (picingIds.length == 1) {
            sql.append(" where t1.fid = '" + picingIds[0] + "' and t1.FReqSuite > 0");
        } else {
            sql.append(" where t1.fid in (" + this.arrayToString(picingIds) + ") and t1.FReqSuite > 0");
        }
        sql.append(" and t2.FLineStatus != 2");
        sql.append(" group by t1.fid,t1.fnumber,t1.FReqSuite,t3.fnumber,t3.fstartdate,t4.fnumber, t5.fnumber,");
        sql.append(" t5.");
        sql.append(this.getFieldName(ctx) + ",");
        sql.append(" t5.fModel,");
        sql.append(" t7.");
        sql.append(this.getFieldName(ctx) + ",");
        sql.append(" t9.");
        sql.append(this.getFieldName(ctx) + ",");
        sql.append(" t6.");
        sql.append(this.getFieldName(ctx) + ",");
        sql.append(" t8.FQtyPrecision");
        sql.append(" order by t1.fnumber, t3.fstartdate");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return result;
    }

    protected HashMap _getUnsuiteData(Context ctx, String tableName) throws BOSException, EASBizException {
        return null;
    }

    private String arrayToString(Object[] prdPks) {
        String ids = StringUtils.arrayToString((Object[])prdPks, (String)"','");
        ids = "'" + ids + "'";
        return ids;
    }

    @Override
    protected void _canPickingSlip(Context ctx, String[] pks) throws BOSException, EASBizException {
        if (pks.length >= 1) {
            StringBuffer checkSql = new StringBuffer();
            checkSql.append("select t1.fnumber,t1.fbasestatus pstatus,t2.fbasestatus ostatus, t1.fstorageOrgUnitid from  T_MM_PickingSlipBill t1 left join T_MM_ProductionOrder t2 on t1.fproductionorderid = t2.fid  ");
            checkSql.append(" where t1.fid");
            if (pks.length == 1) {
                checkSql.append(" = '").append(pks[0].toString()).append("'");
            } else {
                checkSql.append(" in (").append(this.arrayToString(pks)).append(")");
            }
            IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
            String orgInit = "";
            try {
                while (rowStatus.next()) {
                    String pickNum = rowStatus.getString("fnumber");
                    int pickStatus = rowStatus.getInt("pstatus");
                    String storageID = rowStatus.getString("fstorageOrgUnitid");
                    int orderStatus = rowStatus.getInt("ostatus");
                    if (!orgInit.equals(storageID) && !StringUtils.isEmpty((String)orgInit)) {
                        throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{this.getPSResource(ctx, "Msg_GatherOnlyOneORG")});
                    }
                    orgInit = storageID;
                    if (4 != pickStatus && 90 != pickStatus) {
                        throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{this.getPSResource(ctx, "Msg_bill") + (pickNum == null ? "" : pickNum) + this.getPSResource(ctx, "NotAudited_CannotPickingSlip")});
                    }
                    if (7 != orderStatus) continue;
                    throw new ProductionOrderException(ProductionOrderException.SRCPOCLOSED, new Object[]{""});
                }
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
            StringBuffer entryCheckSql = new StringBuffer();
            entryCheckSql.append("select FSupplyStorageOrgUnitID from  T_MM_PickingSlipBillEntry   ");
            entryCheckSql.append(" where fparentid");
            if (pks.length == 1) {
                entryCheckSql.append(" = '").append(pks[0].toString()).append("'");
            } else {
                entryCheckSql.append(" in (").append(this.arrayToString(pks)).append(")");
            }
            IRowSet entryRows = DbUtil.executeQuery((Context)ctx, (String)entryCheckSql.toString());
            HashSet<String> supplyOrgs = new HashSet<String>();
            try {
                while (entryRows.next()) {
                    String supplyOrgId = entryRows.getString("FSupplyStorageOrgUnitID");
                    supplyOrgs.add(supplyOrgId);
                }
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
            StringBuffer checkCompany = new StringBuffer();
            checkCompany.append(" select count(*) t from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
            checkCompany.append(" where tot.FFromType = 4 and tot.FToType = 1");
            checkCompany.append(" and tou.FFromUnitID ='").append(orgInit).append("'");
            IRowSet checkResult = DbUtil.executeQuery((Context)ctx, (String)checkCompany.toString());
            try {
                while (checkResult.next()) {
                    int num = checkResult.getInt("t");
                    if (num != 0) continue;
                    throw new PickingSlipBillException(PickingSlipBillException.STORAGEORGNOTHASCOMPANYORG);
                }
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
            if (supplyOrgs.size() > 0) {
                checkCompany = new StringBuffer();
                checkCompany.append(" select count(*) t from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
                checkCompany.append(" where tot.FFromType = 4 and tot.FToType = 1");
                if (supplyOrgs.size() == 1) {
                    checkCompany.append(" and tou.FFromUnitID ='").append(((String)supplyOrgs.iterator().next()).toString()).append("'");
                } else {
                    checkCompany.append(" and tou.FFromUnitID in (");
                    Iterator it = supplyOrgs.iterator();
                    while (it.hasNext()) {
                        checkCompany.append("'");
                        String materialOrg = (String)it.next();
                        checkCompany.append(materialOrg);
                        checkCompany.append("'");
                        checkCompany.append(",");
                    }
                    checkCompany.append("'t')");
                }
                checkResult = DbUtil.executeQuery((Context)ctx, (String)checkCompany.toString());
                try {
                    while (checkResult.next()) {
                        int num = checkResult.getInt("t");
                        if (num == supplyOrgs.size()) continue;
                        throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new Object[]{this.getPSResource(ctx, "PartNotExistsCompany")});
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected void _canReturnSlip(Context ctx, String[] pks) throws BOSException, EASBizException {
        IPickingSlipBill ipsb = PickingSlipBillFactory.getLocalInstance(ctx);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("storageOrgUnit.id"));
        selectors.add(new SelectorItemInfo("baseStatus"));
        selectors.add(new SelectorItemInfo("productionOrder.id"));
        selectors.add(new SelectorItemInfo("productionOrder.lotNo"));
        selectors.add(new SelectorItemInfo("productionOrder.number"));
        selectors.add(new SelectorItemInfo("entries.supplyOrgUnit.id"));
        selectors.add(new SelectorItemInfo("entries.supplyOrgUnit.name"));
        PickingSlipBillInfo psbInfo = (PickingSlipBillInfo)ipsb.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)pks[0])), selectors);
        PickingSlipBillEntryCollection entryCol = new PickingSlipBillEntryCollection();
        if (!psbInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) && !psbInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.FINISH)) {
            throw new PickingSlipBillException(PickingSlipBillException.BASEPSEXCEPTION, new String[]{this.getPSResource(ctx, "Msg_bill") + psbInfo.getNumber() + this.getPSResource(ctx, "NotAuditOrFinish_CannotReturnSlip")});
        }
        if (psbInfo.getProductionOrder() != null && psbInfo.getProductionOrder().getId() != null) {
            ArrayList<String> orderIds = new ArrayList<String>();
            orderIds.add(psbInfo.getProductionOrder().getId().toString());
            ProductionOrderFacadeFactory.getLocalInstance(ctx).isClosed(orderIds);
        }
        entryCol.addCollection(psbInfo.getEntries());
        this.validateSpanStorageForCompanyOrg(ctx, psbInfo, entryCol);
    }

    private void validateSpanStorageForCompanyOrg(Context ctx, PickingSlipBillInfo psbInfo, PickingSlipBillEntryCollection entryCol) throws BOSException, EASBizException, PickingSlipBillException {
        PickingSlipBillEntryInfo entryInfo = null;
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyOriUnitInfo = iSCMBillCommonFacade.getCompanyInfo(psbInfo.getStorageOrgUnit().getId());
        if (companyOriUnitInfo == null) {
            throw new PickingSlipBillException(PickingSlipBillException.STORAGEORGNOTHASCOMPANYORG);
        }
        for (int i = 0; i <= entryCol.size() - 1; ++i) {
            entryInfo = entryCol.get(i);
            StorageOrgUnitInfo suppluOrg = entryInfo.getSupplyOrgUnit();
            companyOriUnitInfo = iSCMBillCommonFacade.getCompanyInfo(suppluOrg.getId());
            if (companyOriUnitInfo != null) continue;
            throw new PickingSlipBillException(PickingSlipBillException.SUPPLYSTORAGEORGNOTHASCOMPANYORG, new Object[]{suppluOrg.getName()});
        }
    }

    @Override
    protected boolean _isNeedPriceMethodChoose(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql_isNeedChoose = new StringBuffer();
        sql_isNeedChoose.append(" select count(*) as num from " + tempTable);
        sql_isNeedChoose.append(" where FStorageOrgUnitID != FSupplyStorageOrgUnitID and FSupplyCompanyUnitID = FRequirementCompanyUnitID and FProvideType = 10930");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_isNeedChoose.toString());
        try {
            return rs.next() && rs.getInt("num") > 0;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getPSResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.mm.control.PickingSlipBillResource", (String)key, (Locale)ctx.getLocale());
    }

    @Override
    protected void _refreshTbaleByFilter(Context ctx, String tableName, String[] ids, Vector vct) throws BOSException, EASBizException {
        this.removeUnfilteredData(ctx, tableName, ids);
        try {
            this.updateQty(ctx, tableName, vct);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateDividingKey(Context ctx, String tableName) throws BOSException {
        int i;
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("UPDATE " + tableName);
        updateSql.append(" SET FDividingKey = ");
        for (i = 0; i < this.dividingHeadKeys.length; ++i) {
            if (!this.dividingHeadValues[i].booleanValue()) continue;
            if (i > 0) {
                updateSql.append(" || ");
            }
            updateSql.append("ISNULL(" + this.dividingHeadKeys[i] + ", 'XXX')");
        }
        for (i = 0; i < this.dividingEntryKeys.length; ++i) {
            if (this.dividingEntryValues[i] != Boolean.TRUE) continue;
            updateSql.append(" || ISNULL(" + this.dividingEntryKeys[i] + ", 'XXX')");
        }
        if (this.dividebyCostCenter) {
            updateSql.append("|| ISNULL(FCostCenterID, 'XXX')");
        }
        if (this.dividebyCostObject) {
            updateSql.append("|| ISNULL(FCostObjectID, 'XXX')");
        }
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    private void updateQty(Context ctx, String tableName, Vector vct) throws BOSException, SQLException {
        for (int index = 0; index < vct.size(); ++index) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("UPDATE " + tableName);
            updateSql.append(" set FPickingQty = " + ((Map)vct.get(index)).get("pickingQty") + ",FBASEPICKINGQTY = ");
            updateSql.append(this.getBasePickingQty(ctx, tableName, ((Map)vct.get(index)).get("pickingQty").toString(), ((Map)vct.get(index)).get("entryId").toString()));
            updateSql.append(" where FEntryId = '" + ((Map)vct.get(index)).get("entryId") + "'");
            if (((Map)vct.get(index)).get("psLotID") != null) {
                updateSql.append(" and FPSLotID = '" + ((Map)vct.get(index)).get("psLotID") + "'");
            }
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
    }

    private String getBasePickingQty(Context ctx, String tableName, String pickingQty, String entryId) throws BOSException, SQLException {
        String result = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT round(decimal(");
        sql.append(pickingQty);
        sql.append("*t7.fbaseconvsrate,21,8),t7.FQtyPrecision) as basepickingQty FROM ");
        sql.append("t_mm_pickingslipbillentry t2 inner join ");
        sql.append(" t_bd_multimeasureunit t7 on t2.FMaterialID = t7.FMaterialID and t2.FUnitID = t7.fmeasureunitid ");
        sql.append("WHERE t2.fid = '");
        sql.append(entryId);
        sql.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            result = rs.getString("basepickingQty");
        }
        return result;
    }

    private void removeUnfilteredData(Context ctx, String tableName, String[] ids) throws BOSException {
        StringBuffer refreshSql = new StringBuffer();
        String entryId = "";
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            entryId = ids[i];
            break;
        }
        BOSObjectType bosObjectType = new ObjectUuidPK(entryId).getObjectType();
        PickingSlipBillEntryInfo entry = new PickingSlipBillEntryInfo();
        if (bosObjectType.toString().equals(entry.getBOSType().toString())) {
            refreshSql.append("DELETE FROM " + tableName + " WHERE FEntryID NOT IN (" + this.arrayToString(ids) + ")");
        } else {
            refreshSql.append("DELETE FROM " + tableName + " WHERE FUUID NOT IN (" + this.arrayToString(ids) + ")");
        }
        DbUtil.execute((Context)ctx, (String)refreshSql.toString());
    }

    private void updateSpanOrgInfo(Context ctx, String tableName, PickingModeEnum mode, Map otherParam) throws BOSException, EASBizException {
        StringBuffer update_transType_spanOrg = new StringBuffer();
        StringBuffer update_transType_spanCompany = new StringBuffer();
        StringBuffer update_transType_curOrg = new StringBuffer();
        StringBuffer update_supplyWarehouse = new StringBuffer();
        StringBuffer update_RequirementWarehouse = new StringBuffer();
        if (otherParam.get("priceMethod") != null) {
            if ("0".equals(otherParam.get("priceMethod"))) {
                this.getUpdateTransAndBiz(ctx, tableName, update_transType_spanOrg, "YJN9V65PSkutQxeUH6F72SQHQ1w=", -1, 1);
            } else {
                this.getUpdateTransAndBiz(ctx, tableName, update_transType_spanOrg, "i6DbShN4SLaNlFkX90UXOiQHQ1w=", -1, 1);
            }
        }
        this.getUpdateTransAndBiz(ctx, tableName, update_transType_spanCompany, "nhvcdx82RzuTw48FSlV79CQHQ1w=", -1, 1);
        if (mode.equals((Object)PickingModeEnum.pickingSlipUnSuite) || mode.equals((Object)PickingModeEnum.pickingSlipSuite)) {
            this.getUpdateTransAndBiz(ctx, tableName, update_transType_curOrg, "0rSFjAEeEADgAAyMwKgSQiQHQ1w=", -1, 1);
            update_supplyWarehouse.append(" update " + tableName + " as  a set FSupplyWarehouseID = FWarehouseID, FSupplyLocationID= FLocationId where FProvideType = " + 10930);
            update_RequirementWarehouse.append(" update " + tableName + " as  a set FRequirementWarehouseID = FWarehouseID,FRequirementLocationID = FLocationId where FProvideType != " + 10930);
        } else {
            this.getUpdateTransAndBiz(ctx, tableName, update_transType_curOrg, "0rSFjAEeEADgAAyMwKgSQiQHQ1w=", -1, -1);
            update_RequirementWarehouse.append(" update " + tableName + " as  a set FRequirementWarehouseID = FWarehouseID, FRequirementLocationID = FLocationId where FProvideType != " + 10930);
        }
        ArrayList<String> updateSqlList = new ArrayList<String>();
        if (update_transType_spanOrg.length() > 0) {
            updateSqlList.add(update_transType_spanOrg.toString());
        }
        if (update_transType_spanCompany.length() > 0) {
            updateSqlList.add(update_transType_spanCompany.toString());
        }
        if (update_transType_curOrg.length() > 0) {
            updateSqlList.add(update_transType_curOrg.toString());
        }
        if (update_supplyWarehouse.length() > 0) {
            updateSqlList.add(update_supplyWarehouse.toString());
        }
        if (update_RequirementWarehouse.length() > 0) {
            updateSqlList.add(update_RequirementWarehouse.toString());
        }
        DBBatchUtil.executeBatch((Context)ctx, updateSqlList);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select * from " + tableName));
        try {
            while (rs.next()) {
                try {
                    rs.getString("FRequirementWarehouseID");
                    rs.getString("FRequirementLocationID");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void getUpdateTransAndBiz(Context ctx, String tableName, StringBuffer update_transAndBizType, String bizType, int ri, int bizDirection) throws BOSException, EASBizException {
        TransactionTypeCollection transactions = TransactionTypeHelper.getTransactionTypeByBizType((Context)ctx, (String)bizType, (String)"50957179-0105-1000-e000-0163c0a812fd463ED552", (int)ri, (int)bizDirection);
        String transactionID = null;
        int type = 1;
        if ("YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(bizType)) {
            transactionID = "rxoJSqctQT6C/udSvXyTRLAI3Kc=";
        } else if ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(bizType)) {
            transactionID = "DOp01ZuATqiQBKX+FuKsHbAI3Kc=";
        } else if ("nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizType)) {
            transactionID = "vLScvt+3RVSYhfatgNOK67AI3Kc=";
            type = 2;
        } else if ("0rSFjAEeEADgAAyMwKgSQiQHQ1w=".equals(bizType)) {
            if (ri == -1 && bizDirection == -1) {
                transactionID = "35ee5c70-2239-4c64-a58a-a1c06b9a6435B008DCA7";
            } else if (ri == -1 && bizDirection == 1) {
                transactionID = "36ee5c70-2239-4c64-a58a-a1c06b9a6436B008DCA7";
            }
            type = 3;
        }
        if (transactions != null && transactions.size() == 1) {
            transactionID = transactions.get(0).getId().toString();
        }
        switch (type) {
            case 1: {
                update_transAndBizType.append(" update " + tableName + " as a set FTransTypeID = '" + transactionID + "',FBizTypeID='" + bizType + "' where FStorageOrgUnitID != FSupplyStorageOrgUnitID and FSupplyCompanyUnitID = FRequirementCompanyUnitID and FProvideType = " + 10930);
                break;
            }
            case 2: {
                update_transAndBizType.append(" update " + tableName + " as a set FTransTypeID = '" + transactionID + "',FBizTypeID='" + bizType + "' where FSupplyCompanyUnitID != FRequirementCompanyUnitID and FProvideType = " + 10930);
                break;
            }
            case 3: {
                update_transAndBizType.append(" update " + tableName + " as a set FTransTypeID = '" + transactionID + "',FBizTypeID='" + bizType + "' where FProvideType != " + 10930);
                break;
            }
        }
    }

    @Override
    protected List _doPicking_suite(Context ctx, String tempTable, Map otherParam, PickingModeEnum mode, FilterInfo dividingGroupCondition) throws BOSException, EASBizException {
        return this.doSuiteAction(ctx, tempTable, otherParam, mode, dividingGroupCondition);
    }

    private List doSuiteAction(Context ctx, String tempTable, Map otherParam, PickingModeEnum mode, FilterInfo dividingGroupCondition) throws BOSException, EASBizException {
        this.checkPerssion(ctx, tempTable, mode);
        List objectIds = new ArrayList();
        try {
            this.setDividingGroupCondition(ctx, mode, dividingGroupCondition);
            this.updateSpanOrgInfo(ctx, tempTable, mode, otherParam);
            this.updateDividingKey(ctx, tempTable);
            objectIds = this.dealHeadOperation(ctx, tempTable, mode);
            this.dealEntryOperation(ctx, tempTable, mode);
            this.dealEntryInvUpdateType(ctx, objectIds);
            PickingSlipBillFactory.getLocalInstance(ctx).afterCreateMaterialReqBill(objectIds);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this._releaseTempTable(ctx, tempTable);
        }
        return objectIds;
    }

    private void dealEntryInvUpdateType(Context ctx, List objectIds) throws BOSException {
        try {
            StringBuffer updateInvUpdateTypeSql = new StringBuffer();
            updateInvUpdateTypeSql.append("update T_IM_MaterialReqBillEntry as mrbEntry  set FInvUpdateTypeID =  (select invUp.FInvUpdateTypeID from T_IM_TransactionInvUpdateType invUp   inner join T_IM_MaterialReqBill mrb on mrb.FTransactionTypeID = invUp.FTransactionTypeID    where invUp.FDefaults = 1 and mrb.FID = mrbEntry.FParentID)   where mrbEntry.FParentID in (" + MMUtils.listToString((List)objectIds) + ")");
            DbUtil.execute((Context)ctx, (String)updateInvUpdateTypeSql.toString());
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkPerssion(Context ctx, String tempTable, PickingModeEnum mode) throws BOSException, PickingSlipBillException, EASBizException {
        StringBuffer checkPerssion = new StringBuffer();
        checkPerssion.append("select top 1 FStorageOrgUnitID from " + tempTable);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkPerssion.toString());
        try {
            while (rs.next()) {
                String orgId = rs.getString("FStorageOrgUnitID");
                ObjectUuidPK orgIdPk = new ObjectUuidPK(orgId);
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                ObjectUuidPK userId = new ObjectUuidPK(userInfo.getId());
                iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgIdPk, "materialreq_new");
            }
        }
        catch (SQLException e) {
            if (mode.equals((Object)PickingModeEnum.pickingSlipSuite) || mode.equals((Object)PickingModeEnum.returnSlipSuite)) {
                this._releaseTempTable(ctx, tempTable);
            }
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e1) {
            if (mode.equals((Object)PickingModeEnum.pickingSlipSuite) || mode.equals((Object)PickingModeEnum.returnSlipSuite)) {
                this._releaseTempTable(ctx, tempTable);
            }
            throw new PickingSlipBillException(PickingSlipBillException.PERM_MATERIALREQ_NEW);
        }
    }

    private void resetOtherInfobyDividingCondtion(Context ctx, String tempTable) throws BOSException {
        StringBuffer updateReturnFlag = new StringBuffer();
        updateReturnFlag.append("update ").append(tempTable);
        updateReturnFlag.append(" as t set FIsReWork = 1 where exists");
        updateReturnFlag.append(" (select t1.fid from T_MM_productionorder t1 where t1.fid = t.fProductionorderid ");
        updateReturnFlag.append(" and t1.fMaterialID = t.FMaterialID ");
        updateReturnFlag.append(" and (t1.FMmBizType = 30");
        updateReturnFlag.append(" or t1.FMmBizType = 20))");
        DbUtil.execute((Context)ctx, (String)updateReturnFlag.toString());
    }

    @Override
    protected List _doPicking_unSuite(Context ctx, String tempTable, Map otherParam, PickingModeEnum mode, FilterInfo dividingGroupCondition) throws BOSException, EASBizException {
        return this.doUnSuiteAction(ctx, tempTable, otherParam, mode, dividingGroupCondition);
    }

    private List doUnSuiteAction(Context ctx, String tempTable, Map otherParam, PickingModeEnum mode, FilterInfo dividingGroupCondition) throws BOSException, PickingSlipBillException, EASBizException {
        this.checkPerssion(ctx, tempTable, mode);
        List objectIds = new ArrayList();
        try {
            this.setDividingGroupCondition(ctx, mode, dividingGroupCondition);
            this.updateSpanOrgInfo(ctx, tempTable, mode, otherParam);
            this.updateDividingKey(ctx, tempTable);
            objectIds = this.dealHeadOperation(ctx, tempTable, mode);
            this.dealEntryOperation(ctx, tempTable, mode);
            this.dealEntryInvUpdateType(ctx, objectIds);
            PickingSlipBillFactory.getLocalInstance(ctx).afterCreateMaterialReqBill(objectIds);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this._releaseTempTable(ctx, tempTable);
        }
        return objectIds;
    }

    private List dealHeadOperation(Context ctx, String tableName, PickingModeEnum mode) throws BOSException, EASBizException {
        List objectIds = this.createMaterialReqBill(ctx, tableName);
        this.createRelation(ctx, tableName);
        return objectIds;
    }

    private void createRelation(Context ctx, String tableName) throws BOSException {
        String creatorID = ctx.getCaller().toString();
        String sql_updateTempTable = "update " + tableName + " set FRelationID =? where FMaterialReqBillID = ? and fid = ?";
        StringBuffer sql = new StringBuffer();
        sql.append("select fid, FMaterialReqBillID from " + tableName);
        sql.append(" group by fid,FMaterialReqBillID");
        Connection conn = null;
        IRowSet rs = null;
        PreparedStatement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(sql_updateTempTable);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String toID = rs.getString("FMaterialReqBillID");
                String fromID = rs.getString("fid");
                BOSUuid relationID = BOSUuid.create((String)"59302EC6");
                batchStatement.setString(1, relationID.toString());
                batchStatement.setString(2, toID);
                batchStatement.setString(3, fromID);
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)batchStatement, (Connection)conn);
        StringBuffer sql_addRelation = new StringBuffer();
        sql_addRelation.append("insert into t_bot_relation(FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,");
        sql_addRelation.append("FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE)");
        sql_addRelation.append("select distinct FRelationID,'A06DF1E1','500AB75E',FID,FMaterialReqBillID,now(),'" + creatorID + "',1,null,0 from " + tableName);
        DbUtil.execute((Context)ctx, (String)sql_addRelation.toString());
    }

    private List createMaterialReqBill(Context ctx, String tableName) throws BOSException, EASBizException {
        String creatorID = ctx.getCaller().toString();
        Connection conn = null;
        PreparedStatement batchStatement = null;
        PreparedStatement batchStatement2 = null;
        IRowSet rs = null;
        StringBuffer sql_addMaterialReq = new StringBuffer();
        sql_addMaterialReq.append("insert into T_IM_MaterialReqBill(FID,FNUMBER,FSTORAGEORGUNITID,");
        if (this.dividebyWorkShop) {
            sql_addMaterialReq.append(" FADMINORGUNITID,");
        }
        sql_addMaterialReq.append(" FTRANSACTIONTYPEID,");
        sql_addMaterialReq.append(" FBIZTYPEID,");
        sql_addMaterialReq.append(" FDemandCompanyOrgUnitID,");
        sql_addMaterialReq.append(" FSupplyStoreOrgUnitID,");
        sql_addMaterialReq.append(" FSupplyCompanyOrgUnitID,");
        if (this.dividebyCostCenter) {
            sql_addMaterialReq.append(" fcostCenterOrgUnitid,");
        }
        sql_addMaterialReq.append(" FCONTROLUNITID,");
        sql_addMaterialReq.append(" FBILLTYPEID,");
        sql_addMaterialReq.append(" FISREVERSED,");
        sql_addMaterialReq.append(" FSOURCEBILLTYPEID,FBASESTATUS,FCREATETIME,FBIZDATE,FCREATORID)");
        sql_addMaterialReq.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,");
        if (this.dividebyWorkShop) {
            sql_addMaterialReq.append("?,");
        }
        if (this.dividebyCostCenter) {
            sql_addMaterialReq.append("?,");
        }
        sql_addMaterialReq.append("now(),now(),?)");
        String sql_updateTempTable = "update " + tableName + " set FMaterialReqBillID =? where FDividingKey = ?";
        StringBuffer sql = new StringBuffer();
        sql.append("select FStorageOrgUnitID,FCuID,");
        if (this.dividebyCostCenter) {
            sql.append("FCostCenterID,");
        }
        if (this.dividebyWorkShop) {
            sql.append("FWorkshopID,");
        }
        sql.append("FTransTypeID, FBizTypeID,FSupplyStorageOrgUnitID,FSupplyCompanyUnitID ,FRequirementCompanyUnitID,");
        sql.append("FDividingKey as dividingKey from " + tableName);
        sql.append(" group by FStorageOrgUnitID,FCuID,");
        if (this.dividebyCostCenter) {
            sql.append("FCostCenterID,");
        }
        if (this.dividebyWorkShop) {
            sql.append("FWorkshopID,");
        }
        sql.append(" FTransTypeID, FBizTypeID,FSupplyStorageOrgUnitID,FSupplyCompanyUnitID ,FRequirementCompanyUnitID,FDividingKey");
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        StringBuffer select2CodeNumber = new StringBuffer();
        select2CodeNumber.append("select count(*) num, FStorageOrgUnitID,FCuID from ").append(tableName).append(" group by FStorageOrgUnitID,FCuID");
        ArrayList<String> objectIds = new ArrayList<String>();
        try {
            HashMap codeCach = new HashMap();
            IRowSet rs4Code = DbUtil.executeQuery((Context)ctx, (String)select2CodeNumber.toString());
            while (rs4Code.next()) {
                String orgid = rs4Code.getString("FStorageOrgUnitID");
                String cuid = rs4Code.getString("FCuID");
                int num = rs4Code.getInt("num");
                MaterialReqBillInfo mrbInfo = new MaterialReqBillInfo();
                StorageOrgUnitInfo orgUnitInfo = new StorageOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)orgid));
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)cuid));
                mrbInfo.setStorageOrgUnit(orgUnitInfo);
                mrbInfo.setCU(cu);
                Object[] numbers = codingRuleManager.getBatchNumber((IObjectValue)mrbInfo, orgid, num);
                codeCach.put(orgid + cuid, new ArrayList(Arrays.asList((Object[])numbers)));
            }
            MaterialReqBillInfo mrbInfo = new MaterialReqBillInfo();
            mrbInfo.setBizDate(new Date());
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(sql_addMaterialReq.toString());
            batchStatement2 = conn.prepareStatement(sql_updateTempTable);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashMap<String, BOSUuid> materialReqIDS = new HashMap<String, BOSUuid>();
            while (rs.next()) {
                String dividingKey = rs.getString("dividingKey");
                BOSUuid materialReqID = BOSUuid.create((String)"500AB75E");
                materialReqIDS.put(dividingKey, materialReqID);
                int index = 1;
                batchStatement.setString(index++, materialReqID.toString());
                String storageOrgUnitID = rs.getString("FStorageOrgUnitID");
                String cuID = rs.getString("FCuID");
                StorageOrgUnitInfo orgUnitInfo = new StorageOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)storageOrgUnitID));
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)cuID));
                mrbInfo.setStorageOrgUnit(orgUnitInfo);
                mrbInfo.setCU(cu);
                List codeList = (List)codeCach.get(storageOrgUnitID + cuID);
                if (codeList != null && codeList.size() > 0) {
                    String number = (String)codeList.get(0);
                    batchStatement.setString(index++, number);
                    codeList.remove(0);
                } else {
                    batchStatement.setString(index++, codingRuleManager.getNumber((IObjectValue)mrbInfo, storageOrgUnitID));
                }
                batchStatement.setString(index++, storageOrgUnitID);
                if (this.dividebyWorkShop) {
                    batchStatement.setString(index++, rs.getString("FWorkshopID"));
                }
                objectIds.add(materialReqID.toString());
                batchStatement.setString(index++, rs.getString("FTransTypeID"));
                batchStatement.setString(index++, rs.getString("FBizTypeID"));
                batchStatement.setString(index++, rs.getString("FRequirementCompanyUnitID"));
                batchStatement.setString(index++, rs.getString("FSupplyStorageOrgUnitID"));
                batchStatement.setString(index++, rs.getString("FSupplyCompanyUnitID"));
                if (this.dividebyCostCenter) {
                    batchStatement.setString(index++, rs.getString("FCostCenterID"));
                }
                batchStatement.setString(index++, rs.getString("FCuID"));
                batchStatement.setString(index++, "50957179-0105-1000-e000-0163c0a812fd463ED552");
                batchStatement.setInt(index++, 0);
                batchStatement.setString(index++, "3fY8szOQTQmfaNi+Tm5SJUY+1VI=");
                batchStatement.setInt(index++, 1);
                batchStatement.setString(index++, creatorID);
                batchStatement.addBatch();
                batchStatement2.setString(1, materialReqID.toString());
                batchStatement2.setString(2, dividingKey);
                batchStatement2.addBatch();
            }
            batchStatement.executeBatch();
            batchStatement2.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement2);
                SQLUtils.cleanup(rs, batchStatement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement2);
        SQLUtils.cleanup((ResultSet)rs, (Statement)batchStatement, (Connection)conn);
        return objectIds;
    }

    private void insertDataIntoTempTable_gather(Context ctx, String gatherTableName, String srcDataTempTable) throws BOSException {
        String sql = "delete from " + gatherTableName;
        DbUtil.execute((Context)ctx, (String)sql);
        StringBuffer sqlBuffer = new StringBuffer();
        if (!this.isNeedGroup()) {
            int i;
            sqlBuffer.append(" insert into " + gatherTableName);
            sqlBuffer.append(" (FID,FMaterialReqEntryID,");
            for (i = 0; i < this.groupKeys.length; ++i) {
                sqlBuffer.append(this.groupKeys[i] + ",");
            }
            sqlBuffer.append("FParentID,");
            sqlBuffer.append("FSeq,");
            sqlBuffer.append("FNumber,");
            sqlBuffer.append("FEntryID,");
            sqlBuffer.append("FUnitID,");
            sqlBuffer.append("FBaseUnitID,");
            sqlBuffer.append("FPickingDate,");
            sqlBuffer.append("FPickingQty,");
            sqlBuffer.append("FBasePickingQty)");
            sqlBuffer.append("select newbosid('99999999'),newbosid('11774BB4'),");
            sqlBuffer.append("result.* from (select ");
            for (i = 0; i < this.groupKeys.length; ++i) {
                sqlBuffer.append(this.groupKeys[i] + ",");
            }
            sqlBuffer.append("FID,");
            sqlBuffer.append("FSeq,");
            sqlBuffer.append("FNumber,");
            sqlBuffer.append("FEntryID,");
            sqlBuffer.append("FUnitID,");
            sqlBuffer.append("FBaseUnitID,");
            sqlBuffer.append("FPickingDate,");
            sqlBuffer.append("FPickingQty,");
            sqlBuffer.append("FBasePickingQty");
            sqlBuffer.append(" from ");
            sqlBuffer.append(srcDataTempTable);
            sqlBuffer.append(") as result");
        } else {
            sqlBuffer.append(" insert into " + gatherTableName);
            sqlBuffer.append(" (FID,FMaterialReqEntryID,");
            sqlBuffer.append(this.genareteGroupKey());
            sqlBuffer.append(",FUnitID,");
            sqlBuffer.append("FParentID,");
            sqlBuffer.append("FBaseUnitID,");
            sqlBuffer.append("FPickingDate,");
            sqlBuffer.append("FPickingQty,");
            sqlBuffer.append("FBasePickingQty)");
            sqlBuffer.append("select newbosid('99999999'),newbosid('11774BB4'),");
            sqlBuffer.append("result.* from (select ");
            sqlBuffer.append("distinct ");
            sqlBuffer.append(this.genareteSelectGroupKey("src"));
            sqlBuffer.append(" ,case when gather.count > 1 then src.FBaseUnitID else src.FUnitID end as FUnitID,");
            sqlBuffer.append(" src.FID,");
            sqlBuffer.append(" src.FBaseUnitID,");
            sqlBuffer.append(" gather.pickDate,");
            sqlBuffer.append(" case when gather.count > 1 then gather.basePickingQty else gather.pickingQty end as pickingQty,");
            sqlBuffer.append(" gather.basePickingQty");
            sqlBuffer.append(" from " + srcDataTempTable + " as src");
            sqlBuffer.append(" inner join ");
            sqlBuffer.append("(select ");
            sqlBuffer.append(this.genareteGroupKey());
            sqlBuffer.append(",count(distinct funitid) as count,");
            sqlBuffer.append("min(FPickingDate) as pickDate,");
            sqlBuffer.append("sum(FPickingQty) as pickingQty,");
            sqlBuffer.append("sum(FBasePickingQty) as basePickingQty");
            sqlBuffer.append(" from ");
            sqlBuffer.append(srcDataTempTable);
            sqlBuffer.append(" group by ");
            sqlBuffer.append(this.genareteGroupKey());
            sqlBuffer.append(") as gather");
            this.generateGroupEqualsCondition(sqlBuffer, "gather", "src");
            sqlBuffer.append(") as result");
        }
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    private void dealEntryOperation(Context ctx, String tableName, PickingModeEnum mode) throws BOSException, EASBizException {
        String gatherTable = this.createTempTable_gather(ctx);
        try {
            this.insertDataIntoTempTable_gather(ctx, gatherTable, tableName);
            this.updateGatherSeq(gatherTable, ctx);
            this.resetOtherInfobyDividingCondtion(ctx, gatherTable);
            this.createMaterialReqBillEntry(ctx, gatherTable, mode);
            this.createPSMRRelation(ctx, tableName, gatherTable);
            this.createRelationEntry(ctx, tableName, gatherTable);
            this.writeBackPickedTotalQty(ctx, tableName, mode);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this._releaseTempTable(ctx, gatherTable);
        }
    }

    private void updateGatherSeq(String tableName, Context ctx) throws BOSException {
        if (this.isNeedGroup()) {
            return;
        }
        StringBuffer sql_gather = new StringBuffer();
        sql_gather.append(" select FMaterialReqBillID,FNumber,FID,FSeq from " + tableName + " order by FMaterialReqBillID,FNumber,FSeq");
        Connection conn = null;
        IRowSet rs = null;
        String updateQty = "update " + tableName + " set FSeq = ? where FMaterialReqBillID = ? and fnumber = ? and FSeq = ?";
        PreparedStatement batchStatement = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql_gather.toString());
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(updateQty);
            String str_MaterialReqBillID = null;
            int seq = 1;
            while (rs.next()) {
                String number = rs.getString("FNumber");
                int seqSource = rs.getInt("fseq");
                if (str_MaterialReqBillID == null) {
                    str_MaterialReqBillID = rs.getString("FMaterialReqBillID");
                } else if (!str_MaterialReqBillID.equals(rs.getString("FMaterialReqBillID"))) {
                    seq = 1;
                }
                batchStatement.setInt(1, seq++);
                batchStatement.setString(2, str_MaterialReqBillID);
                batchStatement.setString(3, number);
                batchStatement.setInt(4, seqSource);
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(batchStatement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    private void writeBackPickedTotalQty(Context ctx, String tableName, PickingModeEnum mode) throws BOSException {
        if (mode.equals((Object)PickingModeEnum.returnSlipSuite) || mode.equals((Object)PickingModeEnum.returnSlipUnSuite)) {
            return;
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("update T_MM_PickingSlipBillEntry as a set (FPICKEDTOTALQTY,FBASEPICKEDTOTALQTY) = ");
        sqlBuffer.append("(select a.FPICKEDTOTALQTY + b.FPickingQty,");
        sqlBuffer.append(" a.FBASEPICKEDTOTALQTY + b.FBasePickingQty");
        sqlBuffer.append(" from " + tableName + " as b ");
        sqlBuffer.append(" where a.FParentID = b.FID and a.FID = b.FEntryID ");
        sqlBuffer.append(" and  b.FBasePickingQty > 0 )");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    private void createRelationEntry(Context ctx, String tableName, String gatherTable) throws BOSException {
        StringBuffer sql_addRelationEntry = new StringBuffer();
        if (!this.isNeedGroup()) {
            sql_addRelationEntry.append("insert into t_bot_relationentry(FID,FSRCOBJECTID,FDESTOBJECTID,FSRCENTRYID,FDESTENTRYID,");
            sql_addRelationEntry.append("FSRCENTRYPROPNAME,FDESTENTRYPROPNAME,FSRCPROPERTYNAME,FDESTPROPERTYNAME,FVALUE,FKEYID)");
            sql_addRelationEntry.append("select newbosid('B99C354C'),t2.FID,t1.FMaterialReqBillID,t1.FEntryID, t1.FMaterialReqEntryID");
            sql_addRelationEntry.append(",'__src.entries','__dest.entries',null,'id',null,t2.FRelationID");
            sql_addRelationEntry.append(" from " + gatherTable + " t1  inner join " + tableName + " t2 on t1.FEntryID = t2.FEntryID and t1.FMaterialReqBillID = t2.FMaterialReqBillID");
        } else {
            sql_addRelationEntry.append(" insert into t_bot_relationentry(FID,FSRCOBJECTID,FDESTOBJECTID,FSRCENTRYID,FDESTENTRYID,");
            sql_addRelationEntry.append("FSRCENTRYPROPNAME,FDESTENTRYPROPNAME,FSRCPROPERTYNAME,FDESTPROPERTYNAME,FVALUE,FKEYID)");
            sql_addRelationEntry.append(" select newbosid('B99C354C'),t2.FID,t1.FMaterialReqBillID,t2.FEntryID,t1.FMaterialReqEntryID");
            sql_addRelationEntry.append(",'__src.entries','__dest.entries',null,'id',null,t2.FRelationID");
            sql_addRelationEntry.append(" from " + gatherTable + " t1 inner join " + tableName + " t2 ");
            this.generateGroupEqualsCondition(sql_addRelationEntry, "t1", "t2");
        }
        DbUtil.execute((Context)ctx, (String)sql_addRelationEntry.toString());
    }

    private void createPSMRRelation(Context ctx, String tableName, String gatherTable) throws BOSException {
        StringBuffer sql_PSMRRelation;
        block7: {
            block6: {
                sql_PSMRRelation = new StringBuffer();
                if (this.isNeedGroup()) break block6;
                sql_PSMRRelation.append("insert into T_MM_PSMRRelation(FID,FSrcEntryID,FTempEntryID,");
                sql_PSMRRelation.append("FPickingQty,FBasePickingQty,FUnitID,FBaseUnitID,FPriority)");
                sql_PSMRRelation.append("select newbosid('1A3CAE4B'),FEntryID,FID,");
                sql_PSMRRelation.append(" FPickingQty,FBasePickingQty,FUnitID,FBaseUnitID,1 ");
                sql_PSMRRelation.append("from " + gatherTable);
                break block7;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select t1.FMaterialReqEntryID, t2.FEntryID ");
            sql.append(" from " + gatherTable + " t1 inner join " + tableName + " t2 ");
            this.generateGroupEqualsCondition(sql, "t1", "t2");
            sql.append(" order by t1.FMaterialReqEntryID,t2.FNumber,t2.FReqDate");
            String sql_updateTempTable = "update " + tableName + " set FPriority =? where FEntryID = ?";
            int i = 1;
            String compareID = "";
            Connection conn = null;
            IRowSet rs = null;
            PreparedStatement batchStatement = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                batchStatement = conn.prepareStatement(sql_updateTempTable);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    String toID = rs.getString("FMaterialReqEntryID");
                    if (!compareID.equals(toID)) {
                        compareID = toID;
                        i = 1;
                    }
                    String fromID = rs.getString("FEntryID");
                    batchStatement.setInt(1, i++);
                    batchStatement.setString(2, fromID);
                    batchStatement.addBatch();
                }
                batchStatement.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, batchStatement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)batchStatement, (Connection)conn);
            sql_PSMRRelation.append(" insert into T_MM_PSMRRelation(FID,FSrcEntryID,FTempEntryID,");
            sql_PSMRRelation.append("FPickingQty,FBasePickingQty,FUnitID,FBaseUnitID,FPriority)");
            sql_PSMRRelation.append(" select newbosid('1A3CAE4B'),t2.FEntryID,t1.fid,");
            sql_PSMRRelation.append("t2.FPickingQty,t2.FBasePickingQty, ");
            sql_PSMRRelation.append("t2.FUnitID,t2.FBaseUnitID,t2.FPriority");
            sql_PSMRRelation.append(" from " + gatherTable + " t1 inner join " + tableName + " t2 ");
            this.generateGroupEqualsCondition(sql_PSMRRelation, "t1", "t2");
        }
        DbUtil.execute((Context)ctx, (String)sql_PSMRRelation.toString());
    }

    private void generateGroupEqualsCondition(StringBuffer sql, String gatherTable_asName, String srcTable_asName) {
        sql.append(" on 1=1");
        for (int i = 0; i < this.groupKeys.length; ++i) {
            if (!this.groupValues[i].booleanValue()) continue;
            sql.append(" and ISNULL(" + gatherTable_asName + "." + this.groupKeys[i] + ", 'XXX')=ISNULL(" + srcTable_asName + "." + this.groupKeys[i] + ", 'XXX')");
        }
    }

    private String genareteSelectGroupKey(String tableName) {
        StringBuffer groupKey = new StringBuffer();
        for (int i = 0; i < this.groupKeys.length; ++i) {
            if (!this.groupValues[i].booleanValue()) continue;
            groupKey.append(tableName + "." + this.groupKeys[i] + ",");
        }
        groupKey.replace(groupKey.length() - 1, groupKey.length(), "");
        return groupKey.toString();
    }

    private String genareteGroupKey() {
        StringBuffer groupKey = new StringBuffer();
        for (int i = 0; i < this.groupKeys.length; ++i) {
            if (!this.groupValues[i].booleanValue()) continue;
            groupKey.append(this.groupKeys[i] + ",");
        }
        groupKey.replace(groupKey.length() - 1, groupKey.length(), "");
        return groupKey.toString();
    }

    private void createMaterialReqBillEntry(Context ctx, String tableName, PickingModeEnum mode) throws BOSException {
        StringBuffer sql_addMaterialReqEntry = new StringBuffer();
        sql_addMaterialReqEntry.append("insert into T_IM_MaterialReqBillEntry(FID,FParentID,FMATERIALID,FUNITID,FBASEUNITID,");
        sql_addMaterialReqEntry.append("FCOMPANYORGUNITID,");
        sql_addMaterialReqEntry.append("FBASESTATUS,");
        sql_addMaterialReqEntry.append("FISSUEQTY,FBASEISSUEQTY,FQTY,FBASEQTY,FLOT,FWAREHOUSEID,FLOCATIONID,");
        sql_addMaterialReqEntry.append("FSupplyWarehouseID,");
        sql_addMaterialReqEntry.append("FPRODUCTLINEID,");
        sql_addMaterialReqEntry.append("FPRODUCTLINEWPID,FPICKINGDATE,FDEMANDDATE,");
        sql_addMaterialReqEntry.append("FTrackNumberID,");
        sql_addMaterialReqEntry.append("FSeq,");
        sql_addMaterialReqEntry.append("FORDERBILLID,FORDERNUMBER,FCoreBillID,FCoreBillNumber,FCoreBillTypeID,FIsReWork,FSALEORDERID,FSALEORDERNUM,FSTORAGEORGUNITID,");
        sql_addMaterialReqEntry.append("FCOSTCENTERORGUNITID,FADMINORGUNITID,");
        sql_addMaterialReqEntry.append("FSOURCEBILLTYPEID,FSOURCEBILLID,FSOURCEBILLENTRYID,FCostObjectID,FAssistUnitId,FAssistQty) \n");
        sql_addMaterialReqEntry.append("Select  t1.FMaterialReqEntryID,t1.FMaterialReqBillID,t1.FMaterialID,t1.FUnitID,t1.FBaseUnitID,");
        sql_addMaterialReqEntry.append("t1.FRequirementCompanyUnitID,");
        sql_addMaterialReqEntry.append("1,");
        if (mode.equals((Object)PickingModeEnum.pickingSlipSuite) || mode.equals((Object)PickingModeEnum.pickingSlipUnSuite)) {
            sql_addMaterialReqEntry.append("t1.FPickingQty,t1.FBasePickingQty,");
            sql_addMaterialReqEntry.append("t1.FPickingQty,t1.FBasePickingQty,");
        } else {
            sql_addMaterialReqEntry.append("-1*t1.FPickingQty,-1*t1.FBasePickingQty,");
            sql_addMaterialReqEntry.append("-1*t1.FPickingQty,-1*t1.FBasePickingQty,");
        }
        sql_addMaterialReqEntry.append("t1.FLotNo,t1.FRequirementWarehouseID,t1.FRequirementLocationID,t1.FSupplyWarehouseID,");
        sql_addMaterialReqEntry.append("t1.FProductLineID,");
        sql_addMaterialReqEntry.append("t1.FProductLineWPID,now(),t1.FPickingDate,");
        sql_addMaterialReqEntry.append("t1.FTrackNumberID,");
        sql_addMaterialReqEntry.append("t1.FSeq,");
        sql_addMaterialReqEntry.append("t1.fproductionorderid,t2.fnumber,t1.fproductionorderid,t2.fnumber,");
        sql_addMaterialReqEntry.append("'ejIZHXXTQliYCQJg9t4Re0Y+1VI=',");
        sql_addMaterialReqEntry.append("t1.FIsReWork, t1.fsaleorderid,t3.fnumber,t1.FStorageOrgUnitID,");
        sql_addMaterialReqEntry.append("t1.FCostCenterID, t1.FWorkshopID,");
        sql_addMaterialReqEntry.append("'3fY8szOQTQmfaNi+Tm5SJUY+1VI=',");
        sql_addMaterialReqEntry.append("t1.FParentID,");
        sql_addMaterialReqEntry.append("t1.FEntryID,");
        sql_addMaterialReqEntry.append("t1.FCostObjectID ");
        sql_addMaterialReqEntry.append(",").append("t4.FAssistUnit").append(" ");
        if (mode.equals((Object)PickingModeEnum.pickingSlipSuite) || mode.equals((Object)PickingModeEnum.pickingSlipUnSuite)) {
            sql_addMaterialReqEntry.append(",").append("ISNULL(ROUND(t1.FBasePickingQty/t5.FBaseConvsRate,t5.FQtyPrecision),0)");
        } else {
            sql_addMaterialReqEntry.append(",").append("ISNULL(ROUND(-1*t1.FBasePickingQty/t5.FBaseConvsRate,t5.FQtyPrecision),0)");
        }
        sql_addMaterialReqEntry.append(" from " + tableName + " t1 ");
        sql_addMaterialReqEntry.append(" left join t_mm_productionorder t2 on t1.fproductionorderid = t2.fid");
        sql_addMaterialReqEntry.append(" left join T_SD_SaleOrder t3 on t1.fsaleorderid = t3.fid");
        sql_addMaterialReqEntry.append(" left join T_BD_Material t4 on t4.fid = t1.FMaterialID");
        sql_addMaterialReqEntry.append(" left join t_bd_multiMeasureUnit t5 on t5.fmaterialId = t1.FMaterialID and t5.fMeasureUnitID = t4.FAssistUnit");
        DbUtil.execute((Context)ctx, (String)sql_addMaterialReqEntry.toString());
        StringBuffer sql_addMaterialReqPriceEntry = new StringBuffer();
        sql_addMaterialReqPriceEntry.append("insert into T_im_MaterialReqBillPriceInfo(FID,FParentID,FMATERIALID,FUNITID,FBASEUNITID,fmaterialreqentryid,fsourcebillentryid)");
        sql_addMaterialReqPriceEntry.append(" select newbosid('97A53E9B'), FMaterialReqBillID, FMaterialID , FUnitID, FBaseUnitID, FMaterialReqEntryID, FMaterialReqEntryID ");
        sql_addMaterialReqPriceEntry.append(" from " + tableName);
        DbUtil.execute((Context)ctx, (String)sql_addMaterialReqPriceEntry.toString());
    }

    private boolean isNeedGroup() {
        for (int i = 3; i < this.groupValues.length; ++i) {
            if (!this.groupValues[i].booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void _removeLines(Context ctx, String tableName, String[] ids) throws BOSException {
        StringBuffer refreshSql = new StringBuffer();
        String entryId = ids[0];
        BOSObjectType bosObjectType = new ObjectUuidPK(entryId).getObjectType();
        PickingSlipBillEntryInfo entry = new PickingSlipBillEntryInfo();
        if (bosObjectType.toString().equals(entry.getBOSType().toString())) {
            refreshSql.append("DELETE FROM " + tableName + " WHERE FEntryID IN (" + this.arrayToString(ids) + ")");
        } else {
            refreshSql.append("DELETE FROM " + tableName + " WHERE FUUID IN (" + this.arrayToString(ids) + ")");
        }
        DbUtil.execute((Context)ctx, (String)refreshSql.toString());
    }

    @Override
    protected List _doReturn_suite(Context ctx, String tempTable, Map otherParam, PickingModeEnum mode, FilterInfo dividingGroupCondition) throws BOSException, EASBizException {
        return this.doSuiteAction(ctx, tempTable, otherParam, mode, dividingGroupCondition);
    }

    @Override
    protected List _doReturn_unSuite(Context ctx, String tempTable, Map otherParam, PickingModeEnum mode, FilterInfo dividingGroupCondition) throws BOSException, EASBizException {
        return this.doUnSuiteAction(ctx, tempTable, otherParam, mode, dividingGroupCondition);
    }
}

