/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IStoreState;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.EquipmentCalendarEntryCollection;
import com.kingdee.eas.mm.basedata.EquipmentCalendarEntryFactory;
import com.kingdee.eas.mm.basedata.EquipmentCalendarEntryInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.LineStatusEnum;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryFactory;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryInfo;
import com.kingdee.eas.mm.basedata.ProductionFormulaEntryCollection;
import com.kingdee.eas.mm.basedata.ProductionFormulaEntryFactory;
import com.kingdee.eas.mm.basedata.ProductionFormulaEntryInfo;
import com.kingdee.eas.mm.basedata.ProductionFormulaFactory;
import com.kingdee.eas.mm.basedata.ProductionFormulaInfo;
import com.kingdee.eas.mm.basedata.ResourceInfo;
import com.kingdee.eas.mm.basedata.TimeUnitEnum;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.common.app.DBBatchUtil;
import com.kingdee.eas.mm.common.loadmass.MaterialSustituteVO;
import com.kingdee.eas.mm.common.loadmass.ProductionOrderF7Objects;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ParamUtil;
import com.kingdee.eas.mm.common.util.ProductionFormulaHelper;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.StoreCommonUtil;
import com.kingdee.eas.mm.control.BizTypeEnum;
import com.kingdee.eas.mm.control.FinishedRptCollection;
import com.kingdee.eas.mm.control.FinishedRptFacadeFactory;
import com.kingdee.eas.mm.control.FinishedRptFactory;
import com.kingdee.eas.mm.control.FinishedRptInfo;
import com.kingdee.eas.mm.control.IPickingSlipBill;
import com.kingdee.eas.mm.control.IProductionOrderFacade;
import com.kingdee.eas.mm.control.PickingSlipBillFactory;
import com.kingdee.eas.mm.control.PickingSlipBillInfo;
import com.kingdee.eas.mm.control.ProductionOrderCollection;
import com.kingdee.eas.mm.control.ProductionOrderEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderEntryInfo;
import com.kingdee.eas.mm.control.ProductionOrderException;
import com.kingdee.eas.mm.control.ProductionOrderFacadeFactory;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.control.ProductionOrderInfo;
import com.kingdee.eas.mm.control.ProductionOrderOutputEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderOutputEntryInfo;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.TaskDispBillCollection;
import com.kingdee.eas.mm.control.TaskDispBillFactory;
import com.kingdee.eas.mm.control.TaskDispBillInfo;
import com.kingdee.eas.mm.control.TransactionTypeEnum;
import com.kingdee.eas.mm.control.app.AbstractProductionOrderControllerBean;
import com.kingdee.eas.mm.control.app.PickingSlipBillControllerBean;
import com.kingdee.eas.mm.control.app.PrdLotServerUtils;
import com.kingdee.eas.mm.control.app.TaskDispLotServerUtils;
import com.kingdee.eas.mm.control.util.ProductionOrderHelper;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.planning.IReqPlanReceiveReqDataFacade;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.ReqPlanReceiveReqDataFacadeFactory;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.SCMLockInvDataVO;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProductionOrderControllerBean
extends AbstractProductionOrderControllerBean
implements IBatchExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.control.app.ProductionOrderControllerBean");
    private static final int DEFAULT_PRECISION = 0;
    public static final String RES_PRD_ORDER = "com.kingdee.eas.mm.control.ProductionOrderResource";
    public static final String RES_PRD_NEXT_ORDER = "com.kingdee.eas.mm.control.ProductionOrderNextResource";
    private static final String RELEASE_IMMEDIATE = String.valueOf(0);
    private static final String RELEASE_SHIFT = String.valueOf(1);
    private static final String RELEASE_NOT = String.valueOf(2);
    private static final String AUDIT_GEN = "0";
    private IParamControl iParamControl = null;
    private static final String GENCOST_NOT = "true";
    private boolean isAlterSubmit = false;
    private static final String RCVIN_HIGHT_LIMIT = "RCVIN_HIGHT_LIMIT";
    private static final String RCVIN_LOW_LIMIT = "RCVIN_LOW_LIMIT";
    private static final String RCV_DISPERSION_BASE = "RCV_DISPERSION_BASE";

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        ProductionOrderInfo billInfo = new ProductionOrderInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            billInfo.setBizDate(sf.parse(sf.format(curDate)));
        }
        catch (ParseException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        billInfo.setStartDate(curDate);
        billInfo.setEndDate(curDate);
        billInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        return billInfo;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String billTypeId;
        ProductionOrderInfo orderInfo = (ProductionOrderInfo)model;
        this.isAlterSubmit = orderInfo.isAlterSubmit();
        BillBaseStatusEnum statusBeforeSubmit = null;
        if (this.isAlterSubmit) {
            statusBeforeSubmit = this.getDataNewStatus(ctx, model).getBaseStatus();
        }
        if (StringUtils.isEmpty((String)orderInfo.getLotNo())) {
            PrdLotServerUtils.dealLotNo(ctx, orderInfo);
        }
        this.setNullToDefault(ctx, model);
        this.setyield(ctx, model);
        ActionCommonException bizExp = null;
        IObjectPK pk = null;
        try {
            this.checkPrdOrderSubmit(ctx, model);
        }
        catch (ActionCommonException e) {
            bizExp = e;
        }
        try {
            this.checkPrdOrderEntrySubmit(ctx, model);
        }
        catch (ActionCommonException e) {
            if (bizExp != null) {
                bizExp.setMessage(bizExp.getMessage() + e.getMessage());
            }
            bizExp = e;
        }
        try {
            this._submitScmVerify(ctx, model);
        }
        catch (EASBizException scmBizExp) {
            if (bizExp != null) {
                bizExp.setMessage(scmBizExp.getMessage() + "\n" + bizExp.getMessage());
                throw bizExp;
            }
            throw scmBizExp;
        }
        if (bizExp != null) {
            throw bizExp;
        }
        this.doBeforeAlterSubmit(ctx, orderInfo);
        pk = super._submit(ctx, (IObjectValue)orderInfo);
        if (this.isAlterSubmit) {
            this.updateReqPlanData(ctx, new IObjectPK[]{pk}, 701);
        } else {
            this.updateReqPlanData(ctx, new IObjectPK[]{pk}, 102);
        }
        if (orderInfo.getBillType() != null && !this.isAlterSubmit && "ejIZHXXTQliYCQJg9t4Re0Y+1VI=".equals(billTypeId = orderInfo.getBillType().getId().toString())) {
            String orgUnitID = orderInfo.getStorageOrgUnit().getId().toString();
            boolean isAutoAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 4, orgUnitID, billTypeId);
            if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
                isAutoAudit = true;
            }
            if (isAutoAudit) {
                this._audit(ctx, pk);
            }
        }
        this.doAfterAlterSubmit(ctx, pk, statusBeforeSubmit);
        return pk;
    }

    private void setyield(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ProductionOrderInfo info = (ProductionOrderInfo)model;
        BigDecimal yield = new BigDecimal("100");
        if (info.getFormula() != null) {
            ProductionFormulaInfo formula = (ProductionFormulaInfo)ProductionFormulaFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(info.getFormula().getId().toString()));
            yield = formula.getYield();
        } else if (info.getBom() != null) {
            BomInfo bom = (BomInfo)BomFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(info.getBom().getId().toString()));
            yield = bom.getYield();
        } else if (info.getMaterial() != null && info.getStorageOrgUnit() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getMaterial().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
            EntityViewInfo viewer = new EntityViewInfo();
            viewer.setFilter(filter);
            MaterialPlanCollection plan = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewer);
            if (plan.size() > 0) {
                yield = plan.get(0).getYield();
            }
        }
        info.setYield(yield);
    }

    private void setExpectOutputQty(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductionOrderInfo PrdOrderInfo = (ProductionOrderInfo)model;
        BigDecimal yield = PrdOrderInfo.getYield() != null ? PrdOrderInfo.getYield() : new BigDecimal("100");
        String materialId = PrdOrderInfo.getMaterial() != null ? PrdOrderInfo.getMaterial().getId().toString() : "";
        String unitId = PrdOrderInfo.getUnit() != null ? PrdOrderInfo.getUnit().getId().toString() : "";
        String baseUnitId = PrdOrderInfo.getBaseUnit() != null ? PrdOrderInfo.getBaseUnit().getId().toString() : "";
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialId, unitId);
        MultiMeasureUnitInfo baseMultiUnifInfo = multiUnit.getMultiUnit(materialId, baseUnitId);
        BigDecimal expectQty = PrdOrderInfo.getQty().multiply(yield).divide(new BigDecimal("100"), multiUnifInfo.getQtyPrecision(), 5);
        BigDecimal baseExpectQty = PrdOrderInfo.getBaseQty().multiply(yield).divide(new BigDecimal("100"), baseMultiUnifInfo.getQtyPrecision(), 5);
        PrdOrderInfo.setExpectOutputQty(expectQty);
        PrdOrderInfo.setBaseExpectOutputQty(baseExpectQty);
    }

    protected void _submitScmVerify(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SCMBillBaseInfo info = (SCMBillBaseInfo)model;
        this.check4AccountClosed(ctx, info);
        boolean isAddNew = this.isAddNew(ctx, model);
        String strCompanyID = this.getBizUnitOrgID(ctx, model);
        HashMap hs = this.getNumberRuleSet(ctx, info, strCompanyID);
        boolean isNotAddView = (Boolean)hs.get("isNotAddView");
        if (!isNotAddView) {
            this.scmCheckNumberBlank(ctx, (IObjectValue)info);
        }
        if (!isNotAddView) {
            this._checkNumberDup(ctx, null, model);
        }
        HashMap crossOrgMap = new HashMap();
        HashSet<String> crossOrgSet = new HashSet<String>();
        ProductionOrderStockEntryCollection stockCol = ((ProductionOrderInfo)info).getStockEntry();
        for (int j = 0; j < stockCol.size(); ++j) {
            List<String> seqList;
            ProductionOrderStockEntryInfo entry = stockCol.get(j);
            if (entry.getProvideType() != MaterialProvideTypeEnum.SPANORGPROVIDE && entry.getProvideType() != MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE) continue;
            String keyID = entry.getMaterial().getId().toString() + "_" + entry.getSupplyOrgUnit().getId().toString();
            if (crossOrgMap.containsKey(keyID)) {
                seqList = (List)crossOrgMap.get(keyID);
                seqList.add(String.valueOf(entry.getProvideType().getValue()));
            } else {
                seqList = new ArrayList();
                seqList.add(String.valueOf(entry.getProvideType().getValue()));
                crossOrgMap.put(keyID, seqList);
            }
            if (crossOrgSet.contains(keyID)) continue;
            crossOrgSet.add(keyID);
        }
        Set outSet = MMUtils.getCrossOrgMaterialSupplyOrgSet((Context)ctx, crossOrgSet);
        for (String materialOrg : outSet) {
            String[] array = materialOrg.split("_");
            String sqlMaterialName = "select fname_" + ProductionOrderControllerBean.getLocale() + " as name from T_BD_Material where fid='" + array[0] + "'";
            String sqlOrgName = "select fname_" + ProductionOrderControllerBean.getLocale() + " as name from T_ORG_Storage where fid='" + array[1] + "'";
            String materialName = "";
            String orgName = "";
            IRowSet rs_m = DbUtil.executeQuery((Context)ctx, (String)sqlMaterialName);
            IRowSet rs_o = DbUtil.executeQuery((Context)ctx, (String)sqlOrgName);
            try {
                while (rs_m != null && rs_m.next()) {
                    materialName = rs_m.getString("name");
                }
                while (rs_o != null && rs_o.next()) {
                    orgName = rs_o.getString("name");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            int k = 0;
            List tmpList = (List)crossOrgMap.get(materialOrg);
            if (k >= tmpList.size()) continue;
            String provideTypeName = MaterialProvideTypeEnum.getEnum((int)Integer.parseInt(tmpList.get(k).toString())).getAlias();
            throw new ProductionOrderException(ProductionOrderException.MATERIALSUPPLYORG, new Object[]{provideTypeName, materialName, orgName});
        }
        if (!isAddNew) {
            SCMBillBaseInfo aSCMBillBaseInfo = this.getDataNewStatus(ctx, (IObjectValue)info);
            this._checkAudit(ctx, (IObjectValue)aSCMBillBaseInfo, true);
        }
    }

    private static Locale getLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            return new Locale("L2");
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        this.setNullToDefault(ctx, model);
        this.setyield(ctx, model);
        pk = super._save(ctx, model);
        return pk;
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        ProductionOrderInfo prdInfo = null;
        try {
            prdInfo = (ProductionOrderInfo)this.getValue(ctx, pk);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (prdInfo != null) {
            if (prdInfo.getSourceBillId() != null) {
                if (prdInfo.getSourceBillType().getId().toString().equals("OC9YcwEhEADgAAApfwAAAUY+1VI=")) {
                    throw new CanNotDeleteException(EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderNextResource.PrdOrderNotDelete1"));
                }
                if (prdInfo.getSourceBillType().getId().toString().equals("9XXvbVGlRtym/0qtqeIXXrhE1B8=")) {
                    throw new CanNotDeleteException(EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderNextResource.PrdOrderNotDelete2"));
                }
            }
            if (prdInfo.getBaseStatus() != null && prdInfo.getBaseStatus().getValue() >= 4) {
                throw new CanNotDeleteException(EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource.PrdDel_Msg1"));
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        this.updateReqPlanData(ctx, new IObjectPK[]{pk}, 104);
    }

    protected void dealCostObje(Context ctx, String ids, boolean flag) throws BOSException, EASBizException {
        CostObjectCollection costColl = new CostObjectCollection();
        CostObjectInfo costInfo = null;
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        String sql_forCostAdd = "select fid,fnumber,FMaterialID,fStorageOrgUnitID,fLotNo,FBomID from t_mm_productionorder where fid in (" + ids + ")";
        ParamUtil paramUtil = new ParamUtil(ctx);
        try {
            IRowSet rowForCost = DbUtil.executeQuery((Context)ctx, (String)sql_forCostAdd);
            HashMap<String, CompanyOrgUnitInfo> costCompanyCatch = new HashMap<String, CompanyOrgUnitInfo>();
            boolean isGenCost = false;
            while (rowForCost.next()) {
                String fStorageOrgUnitID = rowForCost.getString("fStorageOrgUnitID");
                String fLotNo = rowForCost.getString("fLotNo");
                String fMaterial = rowForCost.getString("FMaterialID");
                String fbomid = rowForCost.getString("FBomID");
                paramUtil.setStorageOrgUnitID(fStorageOrgUnitID, false);
                boolean bl = isGenCost = GENCOST_NOT.equals(paramUtil.getAutoGenCostParam("false"));
                if (!isGenCost) continue;
                CompanyOrgUnitInfo costCompany = null;
                if (costCompanyCatch.get(fStorageOrgUnitID) != null) {
                    costCompany = (CompanyOrgUnitInfo)costCompanyCatch.get(fStorageOrgUnitID);
                } else {
                    costCompany = ProductionOrderControllerBean.getCompanyOrgByStorageOrg(ctx, fStorageOrgUnitID);
                    costCompanyCatch.put(fStorageOrgUnitID, costCompany);
                }
                if (fLotNo == null || !this.isAddCostObjectByBatch(ctx, fMaterial, costCompany)) continue;
                costInfo = new CostObjectInfo();
                costInfo.setCompany(costCompany);
                MaterialInfo materialInfo = new MaterialInfo();
                materialInfo.setId(BOSUuid.read((String)fMaterial));
                costInfo.setStdProductID(materialInfo);
                costInfo.setRelatedId(BOSUuid.read((String)fMaterial));
                costInfo.setBatchNumber(fLotNo);
                if (fbomid != null && !fbomid.equals("") && fbomid.length() != 0) {
                    costInfo.setBomID(fbomid);
                }
                costColl.add(costInfo);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (costColl.size() > 0) {
            if (flag) {
                iCostObject.addnewBybatch((IObjectCollection)costColl);
            } else {
                FilterInfo allFilter = new FilterInfo();
                FilterInfo filter = null;
                for (int i = 0; i < costColl.size(); ++i) {
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("batchNumber", (Object)costColl.get(i).getBatchNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)costColl.get(i).getCompany().getId().toString(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("StdProductID.id", (Object)costColl.get(i).getStdProductID().getId().toString(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("relatedId", (Object)costColl.get(i).getRelatedId(), CompareType.EQUALS));
                    filter.setMaskString("#0 and #1 and #2 and #3");
                    allFilter.mergeFilter(filter, "OR");
                }
                EntityViewInfo viewer = new EntityViewInfo();
                viewer.setFilter(allFilter);
                CostObjectCollection coc = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectCollection(viewer);
                IObjectPK[] pks = new IObjectPK[coc.size()];
                for (int i = 0; i < coc.size(); ++i) {
                    pks[i] = new ObjectUuidPK(coc.get(i).getId().toString());
                }
                iCostObject.deleteBatchData(pks);
            }
        }
    }

    private boolean isAddCostObjectByBatch(Context ctx, String materialID, CompanyOrgUnitInfo company) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT mateial.Id, mateial.number, mateial.name, mateial.status, status, accountType,calculateType,createCOByOrder ").append(" WHERE mateial.Id = '").append(materialID).append("' ").append(" AND mateial.status = '1' AND status = '1' ").append(" AND company.Id = '").append(company.getId().toString()).append("'");
        IMaterialCompanyInfo iMaterialCompanyInfo = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoCollection mciColl = iMaterialCompanyInfo.getMaterialCompanyInfoCollection(sql.toString());
        if (mciColl.size() == 0) {
            return false;
        }
        MaterialCompanyInfoInfo companyInfo = mciColl.get(0);
        boolean isAddCostObjectByBatch = companyInfo.getCalculateType().getValue() == 2 && companyInfo.getAccountType().getValue() == 5 || companyInfo.isCreateCOByOrder();
        return isAddCostObjectByBatch;
    }

    private EquipmentCalendarEntryCollection filterEquipmentCalendar(Context ctx, Date start, Date end, EquipmentCalendarEntryCollection equColls, boolean flag) {
        EquipmentCalendarEntryCollection colls = new EquipmentCalendarEntryCollection();
        for (int i = 0; i < equColls.size(); ++i) {
            if (flag) {
                if (equColls.get(i).getStartTime().getTime() < start.getTime() || equColls.get(i).getStartTime().getTime() > end.getTime()) continue;
                colls.add(equColls.get(i));
                continue;
            }
            if (equColls.get(i).getEndTime().getTime() < start.getTime() || equColls.get(i).getEndTime().getTime() > end.getTime() || equColls.get(i).getStartTime().getTime() >= start.getTime()) continue;
            colls.add(equColls.get(i));
        }
        return colls;
    }

    protected TaskDispBillCollection genTaskDispBill(Context ctx, ProductionOrderInfo prdInfo, MultiMeasureUnitCollection multiUnits, EquipmentCalendarEntryCollection equs) {
        TaskDispBillCollection resultColls = new TaskDispBillCollection();
        TaskDispBillInfo tdInfo = null;
        EquipmentCalendarEntryInfo ecInfo = null;
        BigDecimal total = new BigDecimal(AUDIT_GEN);
        for (int j = 0; j < equs.size(); ++j) {
            total = total.add(equs.get(j).getAbility());
        }
        BigDecimal totalQty = prdInfo.getQty();
        BigDecimal totalBaseQty = prdInfo.getBaseQty();
        for (int j = 0; j < equs.size() && !MMUtils.equalsZero((BigDecimal)totalQty); ++j) {
            ecInfo = equs.get(j);
            tdInfo = this.getTaskDispBillInfo(ctx, prdInfo);
            tdInfo.setShift(ecInfo.getClassTeamEntry());
            tdInfo.setStartDate(ecInfo.getStartTime());
            if (prdInfo.getEndDate().after(ecInfo.getEndTime())) {
                tdInfo.setEndDate(ecInfo.getEndTime());
            } else {
                tdInfo.setEndDate(prdInfo.getEndDate());
            }
            MultiMeasureUnitInfo multiUnit = null;
            MultiMeasureUnitInfo multiBaseUnit = null;
            for (int k = 0; k < multiUnits.size(); ++k) {
                if (multiUnits.get(k).getMaterial().getId().toString().equals(prdInfo.getMaterial().getId().toString()) && multiUnits.get(k).getMeasureUnit().getId().toString().equals(prdInfo.getUnit().getId().toString())) {
                    multiUnit = multiUnits.get(k);
                }
                if (multiUnits.get(k).getMaterial().getId().toString().equals(prdInfo.getMaterial().getId().toString()) && multiUnits.get(k).getMeasureUnit().getId().toString().equals(prdInfo.getBaseUnit().getId().toString())) {
                    multiBaseUnit = multiUnits.get(k);
                }
                if (multiUnit != null && multiBaseUnit != null) break;
            }
            BigDecimal qty = prdInfo.getQty().multiply(ecInfo.getAbility()).divide(total, multiUnit.getQtyPrecision(), 4);
            BigDecimal baseQty = prdInfo.getBaseQty().multiply(ecInfo.getAbility()).divide(total, multiBaseUnit.getQtyPrecision(), 4);
            if (j != equs.size() - 1) {
                totalQty = totalQty.subtract(qty);
                totalBaseQty = totalBaseQty.subtract(baseQty);
                tdInfo.setProductQty(qty);
                tdInfo.setBaseProductQty(baseQty);
            } else {
                tdInfo.setProductQty(totalQty);
                tdInfo.setBaseProductQty(totalBaseQty);
            }
            if (MMUtils.equalsZero((BigDecimal)tdInfo.getProductQty())) continue;
            resultColls.add(tdInfo);
        }
        return resultColls;
    }

    private TaskDispBillInfo getTaskDispBillInfo(Context ctx, ProductionOrderInfo pdtInfo) {
        TaskDispBillInfo taskDispInfo = new TaskDispBillInfo();
        taskDispInfo.setProductLine(pdtInfo.getProductLine());
        taskDispInfo.setMaterial(pdtInfo.getMaterial());
        taskDispInfo.setStorageOrgUnit(pdtInfo.getStorageOrgUnit());
        taskDispInfo.setCU(pdtInfo.getCU());
        taskDispInfo.setProductionOrder(pdtInfo);
        taskDispInfo.setTraceNo(pdtInfo.getTraceNo());
        taskDispInfo.setTrackNumber(pdtInfo.getTrackNumber());
        taskDispInfo.setBusinessType(pdtInfo.getMmBizType());
        taskDispInfo.setUnit(pdtInfo.getUnit());
        taskDispInfo.setBaseUnit(pdtInfo.getBaseUnit());
        taskDispInfo.setWorkShop(pdtInfo.getWorkShop());
        taskDispInfo.setSourceBillId(pdtInfo.getId().toString());
        taskDispInfo.setClassGroup(pdtInfo.getClassGroup());
        taskDispInfo.setPerson(pdtInfo.getPerson());
        taskDispInfo.setSaleOrder(pdtInfo.getSaleOrder());
        taskDispInfo.setRemark(pdtInfo.getRemark());
        taskDispInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        BillTypeInfo source = new BillTypeInfo();
        source.setId(BOSUuid.read((String)"ejIZHXXTQliYCQJg9t4Re0Y+1VI="));
        taskDispInfo.setSourceBillType(source);
        BillTypeInfo dest = new BillTypeInfo();
        dest.setId(BOSUuid.read((String)"Tgx4hbjrTRCki6pl2V5aLkY+1VI="));
        taskDispInfo.setBillType(dest);
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        taskDispInfo.setCreator(user);
        taskDispInfo.setCreateTime(new Timestamp(new Date().getTime()));
        taskDispInfo.setLastUpdateUser(user);
        taskDispInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        taskDispInfo.setBizDate(new Date());
        return taskDispInfo;
    }

    @Override
    protected boolean _genPicking(Context ctx, IObjectPK prdPk) throws BOSException, ProductionOrderException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{prdPk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchGenPicking(ctx, entrys);
        result.throwExceptions();
        return true;
    }

    @Override
    protected boolean _plsGenPrdOrd(Context ctx, IObjectPK[] plsPks) throws BOSException, ProductionOrderException, EASBizException {
        boolean retVal = true;
        return retVal;
    }

    @Override
    protected boolean _backFlush(Context ctx, IObjectPK prdPk) throws BOSException, ProductionOrderException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{prdPk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchBackFlush(ctx, entrys);
        result.throwExceptions();
        return true;
    }

    @Override
    protected boolean _discard(Context ctx, IObjectPK prdPk) throws BOSException, ProductionOrderException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{prdPk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchDiscard(ctx, entrys);
        result.throwExceptions();
        return true;
    }

    @Override
    protected boolean _finishWork(Context ctx, IObjectPK prdPk) throws BOSException, EASBizException {
        IRowSet rowSet;
        boolean retVal = true;
        if (prdPk == null) {
            return retVal;
        }
        StringBuffer statBuff = new StringBuffer();
        StringBuffer downBuff = new StringBuffer();
        StringBuffer errBuff = new StringBuffer();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(prdPk.getKeyValue(null).toString());
        int oldBaseStatus = 5;
        StringBuffer chkSql = new StringBuffer();
        chkSql.append(" select ");
        chkSql.append(" fNumber, fBasestatus, fStorageOrgUnitID ");
        chkSql.append(" from ");
        chkSql.append(" t_mm_productionOrder ");
        chkSql.append(" where ");
        chkSql.append(" fBasestatus <>").append(5);
        chkSql.append(" and fid ='");
        chkSql.append(prdPk.getKeyValue(null).toString());
        chkSql.append("'");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql.toString());
            while (rowSet.next()) {
                statBuff.append(rowSet.getString("fNumber")).append(",");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        chkSql = new StringBuffer();
        chkSql.append("select p.fnumber as orderNumber");
        chkSql.append(" from T_MM_TaskDispBill t inner join t_mm_productionorder p  ");
        chkSql.append(" on t.fproductionorderid = p.fid where  ");
        chkSql.append(" p.fid ='");
        chkSql.append(prdPk.getKeyValue(null).toString());
        chkSql.append("' and t.fbasestatus in (");
        chkSql.append("1,2,6");
        chkSql.append(" )");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql.toString());
            if (rowSet.next()) {
                String orderNumber = rowSet.getString("orderNumber");
                downBuff.append(orderNumber + ",");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        if (statBuff.length() > 0) {
            errBuff.append(this.getResourceMsg("FinishStatusChk", new String[]{statBuff.replace(statBuff.length() - 1, statBuff.length(), "").toString()}, ctx) + "\n");
        }
        if (downBuff.length() > 0) {
            errBuff.append(this.getResourceMsg2("FinishStatusChk1", new String[]{downBuff.replace(downBuff.length() - 1, downBuff.length(), "").toString()}, ctx));
        }
        if (errBuff.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.FINISHEDEXCEPTION, new Object[]{errBuff.toString()});
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update ");
        updateSql.append(" t_mm_productionOrder ");
        updateSql.append(" set ");
        updateSql.append(" fBasestatus=8");
        updateSql.append(",fActualEndDate=now()");
        updateSql.append(",FIsManualFinish=1");
        updateSql.append(" where ");
        updateSql.append(" fBasestatus=5");
        updateSql.append(" and fid ='" + prdPk.getKeyValue(null).toString() + "'");
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            stmt.addBatch(updateSql.toString());
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        ProductionOrderFacadeFactory.getLocalInstance(ctx).updatePLSStatus(idList, true);
        return retVal;
    }

    @Override
    protected boolean _freeze(Context ctx, IObjectPK prdPk) throws BOSException, EASBizException {
        boolean retVal = true;
        if (prdPk == null) {
            return retVal;
        }
        StringBuffer statBuff = new StringBuffer();
        StringBuffer outSourceBuff = new StringBuffer();
        StringBuffer errBuff = new StringBuffer();
        StringBuffer chkSql = new StringBuffer();
        chkSql.append(" select ");
        chkSql.append(" fNumber, ");
        chkSql.append(" fBasestatus, ");
        chkSql.append(" fOutSourceFlag ");
        chkSql.append(" from ");
        chkSql.append(" t_mm_productionOrder ");
        chkSql.append(" where ");
        chkSql.append(" fid ='");
        chkSql.append(prdPk.getKeyValue(null).toString());
        chkSql.append("'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql.toString());
            while (rowSet.next()) {
                String fnumber = rowSet.getString("fNumber");
                int fbasestatus = rowSet.getInt("fBasestatus");
                boolean isOutSource = rowSet.getBoolean("fOutSourceFlag");
                if (fbasestatus != 4) {
                    statBuff.append(fnumber).append(",");
                }
                if (!isOutSource) continue;
                outSourceBuff.append(fnumber).append(",");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        if (statBuff.length() > 0) {
            errBuff.append(this.getResourceMsg("FreezeStatusChk", new String[]{statBuff.replace(statBuff.length() - 1, statBuff.length(), "").toString()}, ctx));
        }
        if (outSourceBuff.length() > 0) {
            errBuff.append(this.getResourceMsg2("Freeze_Err2", new String[]{outSourceBuff.replace(outSourceBuff.length() - 1, outSourceBuff.length(), "").toString()}, ctx));
        }
        if (errBuff.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.FREEZEEXCEPTION, new Object[]{errBuff.toString()});
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update ");
        updateSql.append(" t_mm_productionOrder ");
        updateSql.append(" set ");
        updateSql.append(" fBasestatus=6");
        updateSql.append(" where ");
        updateSql.append(" fBasestatus=4");
        updateSql.append(" and fid ='" + prdPk.getKeyValue(null).toString() + "'");
        StringBuffer updTakeSql = new StringBuffer();
        updTakeSql.append(" update ");
        updTakeSql.append(" t_mm_taskDispBill ");
        updTakeSql.append(" set ");
        updTakeSql.append(" fBasestatus=6");
        updTakeSql.append(" where ");
        updTakeSql.append(" fBasestatus=4");
        updTakeSql.append(" and fProductionOrderID ='" + prdPk.getKeyValue(null).toString() + "'");
        StringBuffer updPickSql = new StringBuffer();
        updPickSql.append(" update ");
        updPickSql.append(" t_mm_pickingSlipBill ");
        updPickSql.append(" set ");
        updPickSql.append(" fBasestatus=6");
        updPickSql.append(" where ");
        updPickSql.append(" fBasestatus=4");
        updPickSql.append(" and fProductionOrderID ='" + prdPk.getKeyValue(null).toString() + "'");
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            stmt.addBatch(updateSql.toString());
            stmt.addBatch(updTakeSql.toString());
            stmt.addBatch(updPickSql.toString());
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return retVal;
    }

    @Override
    protected boolean _unFreeze(Context ctx, IObjectPK prdPk) throws BOSException, EASBizException {
        boolean retVal = true;
        if (prdPk == null) {
            return retVal;
        }
        StringBuffer statBuff = new StringBuffer();
        StringBuffer errBuff = new StringBuffer();
        StringBuffer chkSql = new StringBuffer();
        chkSql.append(" select ");
        chkSql.append(" fNumber ");
        chkSql.append(" from ");
        chkSql.append(" t_mm_productionOrder ");
        chkSql.append(" where ");
        chkSql.append(" fBasestatus <> 6");
        chkSql.append(" and fid ='");
        chkSql.append(prdPk.getKeyValue(null).toString());
        chkSql.append("'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql.toString());
            while (rowSet.next()) {
                statBuff.append(rowSet.getString("fNumber")).append(",");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        if (statBuff.length() > 0) {
            errBuff.append(this.getResourceMsg("unFreezeStatusChk", new String[]{statBuff.replace(statBuff.length() - 1, statBuff.length(), "").toString()}, ctx));
        }
        if (errBuff.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.FREEZEEXCEPTION, new Object[]{errBuff.toString()});
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update ");
        updateSql.append(" t_mm_productionOrder ");
        updateSql.append(" set ");
        updateSql.append(" fBasestatus=4");
        updateSql.append(" where ");
        updateSql.append(" fBasestatus=6");
        updateSql.append(" and fid ='" + prdPk.getKeyValue(null).toString() + "'");
        StringBuffer updTakeSql = new StringBuffer();
        updTakeSql.append(" update ");
        updTakeSql.append(" t_mm_taskDispBill ");
        updTakeSql.append(" set ");
        updTakeSql.append(" fBasestatus=4");
        updTakeSql.append(" where ");
        updTakeSql.append(" fBasestatus=6");
        updTakeSql.append(" and fProductionOrderID ='" + prdPk.getKeyValue(null).toString() + "'");
        StringBuffer updPickSql = new StringBuffer();
        updPickSql.append(" update ");
        updPickSql.append(" t_mm_pickingSlipBill ");
        updPickSql.append(" set ");
        updPickSql.append(" fBasestatus=4");
        updPickSql.append(" where ");
        updPickSql.append(" fBasestatus=6");
        updPickSql.append(" and fProductionOrderID ='" + prdPk.getKeyValue(null).toString() + "'");
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            stmt.addBatch(updateSql.toString());
            stmt.addBatch(updTakeSql.toString());
            stmt.addBatch(updPickSql.toString());
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return retVal;
    }

    @Override
    protected void _forceClose(Context ctx, IObjectPK prdPk) throws BOSException, EASBizException {
        ArrayList<StringBuffer> updateSqls = new ArrayList<StringBuffer>();
        StringBuffer updateSql = new StringBuffer();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(prdPk.getKeyValue(null).toString());
        this._checkForceClose(ctx, new IObjectPK[]{prdPk}, false);
        updateSql.append(" update ");
        updateSql.append(" t_mm_productionOrder ");
        updateSql.append(" set ");
        updateSql.append(" fBasestatus=7");
        updateSql.append(" where ");
        updateSql.append(" fid ='" + prdPk.getKeyValue(null).toString() + "'");
        updateSql.append(" and fBasestatus=8");
        updateSqls.add(updateSql);
        String[] idss = new String[idSet.size()];
        idSet.toArray(idss);
        LotFacadeFactory.getLocalInstance((Context)ctx).productionOrderCloseLot(idss);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            for (int i = 0; i < updateSqls.size(); ++i) {
                stmt.addBatch(updateSqls.get(i).toString());
            }
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        this.updateReqPlanData(ctx, new IObjectPK[]{prdPk}, 201);
    }

    @Override
    protected void _manuRecBillWriteBackStockTotalQty(Context ctx, String tempTableName, BizActionEnum bizActionEnum) throws BOSException, EASBizException {
    }

    private List checkAndUpdateStock(Context ctx, Map stockMap, boolean isEntry) throws BOSException, EASBizException {
        ArrayList<String> updateList = new ArrayList<String>();
        Map stocks = new HashMap();
        String orderId2 = null;
        String materialid = null;
        String storageOrgUnitid = null;
        BigDecimal stocktotalqty = new BigDecimal(AUDIT_GEN);
        BigDecimal basestocktotalqty = new BigDecimal(AUDIT_GEN);
        BigDecimal baseQty = new BigDecimal(AUDIT_GEN);
        Map limits = null;
        Map material = null;
        BigDecimal highLimit = new BigDecimal(AUDIT_GEN);
        StringBuffer updateSql = new StringBuffer();
        ArrayList<String> sqlList = new ArrayList<String>();
        for (String orderId2 : stockMap.keySet()) {
            stocks = (Map)stockMap.get(orderId2);
            materialid = (String)stocks.get("materialid");
            storageOrgUnitid = (String)stocks.get("storageOrgUnitid");
            stocktotalqty = (BigDecimal)stocks.get("stocktotalqty");
            basestocktotalqty = (BigDecimal)stocks.get("basestocktotalqty");
            baseQty = (BigDecimal)stocks.get("baseQty");
            limits = this.getFRCVInLimit(ctx, materialid, storageOrgUnitid);
            material = (Map)limits.get(materialid);
            if (material == null) continue;
            highLimit = (BigDecimal)material.get(RCVIN_HIGHT_LIMIT);
            BigDecimal bigDecimal = new BigDecimal("1");
            if (basestocktotalqty.subtract(baseQty.multiply(bigDecimal.add(highLimit))).doubleValue() > 0.0) {
                throw new ProductionOrderException(ProductionOrderException.OVERHIGHLIMIT);
            }
            updateList.add(orderId2);
            updateSql.setLength(0);
            updateSql.append("update T_MM_ProductionOrder set fstocktotalqty=").append(stocktotalqty).append(",fbasestocktotalqty=").append(basestocktotalqty).append(" where FID='").append(orderId2).append("'");
            sqlList.add(updateSql.toString());
        }
        DBBatchUtil.executeBatch((Context)ctx, sqlList);
        return updateList;
    }

    private Map getStockMap(IRowSet rows) throws BOSException {
        HashMap stockMap = new HashMap();
        HashMap<String, Object> stocks = new HashMap<String, Object>();
        String orderId = null;
        String materialid = null;
        String storageOrgUnitid = null;
        BigDecimal stocktotalqty = new BigDecimal(AUDIT_GEN);
        BigDecimal basestocktotalqty = new BigDecimal(AUDIT_GEN);
        BigDecimal baseQty = new BigDecimal(AUDIT_GEN);
        if (null != rows) {
            try {
                while (rows.next()) {
                    stocks = new HashMap();
                    orderId = rows.getString("id");
                    materialid = rows.getString("materialid");
                    storageOrgUnitid = rows.getString("storageOrgUnitid");
                    stocktotalqty = rows.getBigDecimal("stocktotalqty") == null || "0E-8".equals(rows.getBigDecimal("stocktotalqty").toString()) ? new BigDecimal(String.valueOf(0.0)) : rows.getBigDecimal("stocktotalqty");
                    basestocktotalqty = rows.getBigDecimal("basestocktotalqty") == null || "0E-8".equals(rows.getBigDecimal("basestocktotalqty").toString()) ? new BigDecimal(String.valueOf(0.0)) : rows.getBigDecimal("basestocktotalqty");
                    baseQty = rows.getBigDecimal("baseQty") == null ? new BigDecimal(String.valueOf(0.0)) : rows.getBigDecimal("baseQty");
                    stocks.put("stocktotalqty", stocktotalqty);
                    stocks.put("basestocktotalqty", basestocktotalqty);
                    stocks.put("baseQty", baseQty);
                    stocks.put("materialid", materialid);
                    stocks.put("storageOrgUnitid", storageOrgUnitid);
                    stockMap.put(orderId, stocks);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return stockMap;
    }

    private Map getFRCVInLimit(Context ctx, String materialId, String orgUnitId) throws BOSException {
        StringBuffer selectLimit = new StringBuffer();
        selectLimit.append("select FRCVInLowLimit, FRCVInHightLimit, FRCVDispersionBase from T_BD_MaterialPlan").append(" where FMaterialID='").append(materialId).append("' and FOrgUnit='").append(orgUnitId).append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)selectLimit.toString());
        HashMap result = new HashMap();
        if (null != rows) {
            try {
                while (rows.next()) {
                    HashMap<String, Number> materialFRCVInLowLimit = new HashMap<String, Number>();
                    BigDecimal lowLimtValue = rows.getBigDecimal("FRCVInLowLimit") == null ? new BigDecimal(String.valueOf(0.0)) : rows.getBigDecimal("FRCVInLowLimit");
                    lowLimtValue = lowLimtValue.setScale(4, 5).divide(new BigDecimal(String.valueOf(100)), 5);
                    BigDecimal hignLimitValue = rows.getBigDecimal("FRCVInHightLimit") == null ? new BigDecimal(String.valueOf(0.0)) : rows.getBigDecimal("FRCVInHightLimit");
                    hignLimitValue = hignLimitValue.setScale(4, 5).divide(new BigDecimal(String.valueOf(100)), 5);
                    Integer dispersionBase = new Integer(rows.getInt("FRCVDispersionBase"));
                    materialFRCVInLowLimit.put(RCVIN_HIGHT_LIMIT, hignLimitValue);
                    materialFRCVInLowLimit.put(RCVIN_LOW_LIMIT, lowLimtValue);
                    materialFRCVInLowLimit.put(RCV_DISPERSION_BASE, dispersionBase);
                    result.put(materialId, materialFRCVInLowLimit);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    protected void _mateRBillWriteBackSendOutTotalQty(Context ctx, String tempTableName, BizActionEnum bizActionEnum) throws BOSException, EASBizException {
    }

    @Override
    protected void _redMateRBillWriteBackUntreadTotalQty(Context ctx, String tempTableName, BizActionEnum bizActionEnum) throws BOSException, EASBizException {
    }

    private void isOrderClosed(Context ctx, String tempTableName, BizActionEnum bizActionEnum) throws BOSException, ProductionOrderException {
        String checkSql = "select top 1 fid from t_mm_productionorder where fbasestatus = 7 and fid in (select FSourceBillId from " + tempTableName + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
        try {
            if (rs.next()) {
                throw new ProductionOrderException(ProductionOrderException.SRCPOCLOSED, new Object[]{""});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private List getOrderId(Context ctx, String tempTableName) throws BOSException, SQLException {
        ArrayList<String> orderIds = new ArrayList<String>();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select distinct FSourceBillId from ");
        selectSql.append(tempTableName);
        selectSql.append(" where FSourceBillId is not NULL");
        IRowSet rowSetPick = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        while (rowSetPick.next()) {
            String id = rowSetPick.getString("FSourceBillId");
            orderIds.add(id);
        }
        return orderIds;
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchAudit(ctx, entrys);
        result.throwExceptions();
    }

    protected boolean _checkAudit(Context ctx, IObjectValue model, boolean isOk) throws EASBizException, BOSException {
        if (this.isAlterSubmit) {
            return true;
        }
        return super._checkAudit(ctx, model, isOk);
    }

    @Override
    protected List _getDeviceCalendar(Context ctx, String storageOrgUnitID, String productLineID, Date workDate) throws BOSException, ProductionOrderException {
        ArrayList<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTime(workDate == null ? new Date() : workDate);
        int year1 = nowCal.get(1);
        int month1 = nowCal.get(2) + 1;
        int day1 = nowCal.get(5);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sf.format(nowCal.getTime());
        String chkSql = "select e.fid from t_mm_equipmentcalendarentry f inner join t_mm_equipmentcalendar e on f.fparentid=e.fid  where e.fstorageorgunitid =? and f.fproductlineid=? and to_char(e.fworkdate,'yyyy-mm-dd')=? and (e.fWorkDay<>1 or f.fability=0 ) ";
        IRowSet chkRowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql, (Object[])new Object[]{storageOrgUnitID, productLineID, year1 + "-" + month1 + "-" + day1});
        if (chkRowSet != null && chkRowSet.size() > 0) {
            return dateList;
        }
        String sql = "select min(t1.fStartTime) as startDate,max(t1.fEndTime) as endDate from t_mm_equipmentCalendarEntry as t1 inner join t_mm_equipmentCalendar as t2 on t2.fid=t1.fParentID where t2.fStorageOrgUnitID=? and t1.fProductLineID=?  and to_char(t2.fworkdate,'yyyy-mm-dd')=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{storageOrgUnitID, productLineID, date});
        if (rowSet != null && rowSet.size() > 0) {
            try {
                while (rowSet.next()) {
                    java.sql.Date startDate = rowSet.getDate("startDate");
                    java.sql.Date endDate = rowSet.getDate("endDate");
                    if (startDate == null || endDate == null) {
                        throw new ProductionOrderException(ProductionOrderException.DEVICECALENDAREXCEPTION);
                    }
                    dateList.add(startDate);
                    dateList.add(endDate);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        } else {
            throw new ProductionOrderException(ProductionOrderException.DEVICECALENDAREXCEPTION);
        }
        return dateList;
    }

    private List getDeviceCalendarForPlan(Context ctx, String storageOrgUnitID, String productLineID, Date workDate) throws BOSException, ProductionOrderException {
        ArrayList<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTime(workDate == null ? new Date() : workDate);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sf.format(nowCal.getTime());
        String chkSql = "select e.fid from t_mm_equipmentcalendarentry f inner join t_mm_equipmentcalendar e on f.fparentid=e.fid  where e.fstorageorgunitid =? and f.fproductlineid=? and to_char(e.fworkdate,'yyyy-mm-dd')=? and (e.fWorkDay<>1 or f.fability=0 ) ";
        IRowSet chkRowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql, (Object[])new Object[]{storageOrgUnitID, productLineID, date});
        if (chkRowSet != null && chkRowSet.size() > 0) {
            return dateList;
        }
        String sql = "select min(t1.fStartTime) as startDate,max(t1.fEndTime) as endDate from t_mm_equipmentCalendarEntry as t1 inner join t_mm_equipmentCalendar as t2 on t2.fid=t1.fParentID where t2.fStorageOrgUnitID=? and t1.fProductLineID=?  and to_char(t2.fworkdate,'yyyy-mm-dd')=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{storageOrgUnitID, productLineID, date});
        if (rowSet != null && rowSet.size() > 0) {
            try {
                while (rowSet.next()) {
                    java.sql.Date startDate = rowSet.getDate("startDate");
                    java.sql.Date endDate = rowSet.getDate("endDate");
                    if (startDate == null || endDate == null) {
                        throw new ProductionOrderException(ProductionOrderException.DEVICECALENDAREXCEPTION);
                    }
                    dateList.add(startDate);
                    dateList.add(endDate);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        } else {
            throw new ProductionOrderException(ProductionOrderException.DEVICECALENDAREXCEPTION);
        }
        return dateList;
    }

    private void checkPrdOrderSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ParamUtil paramUtil;
        String relType;
        StringBuffer errBuff = new StringBuffer();
        ProductionOrderInfo productionOrderInfo = (ProductionOrderInfo)model;
        if (productionOrderInfo.getStorageOrgUnit() == null) {
            errBuff.append(this.getResourceMsg("StorageOrgNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getMmBizType() == null) {
            errBuff.append(this.getResourceMsg2("MMBizTypeNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getMaterial() == null) {
            errBuff.append(this.getResourceMsg("MaterialNotNull", ctx) + "\n");
        } else if (!productionOrderInfo.getMaterial().getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
            errBuff.append(this.getResourceMsg("MaterialInvalidStatus", ctx) + "\n");
        } else if (productionOrderInfo.getStorageOrgUnit() != null) {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("select");
            sqlBuff.append(" fid ");
            sqlBuff.append(" from ");
            sqlBuff.append(" T_BD_MaterialPlan ");
            sqlBuff.append(" where ");
            sqlBuff.append(" (FMaterialAttr=10030");
            sqlBuff.append(" or FMaterialAttr=10050)");
            sqlBuff.append(" and FStatus=1");
            sqlBuff.append(" and FMaterialID='" + productionOrderInfo.getMaterial().getId().toString() + "'");
            sqlBuff.append(" and FOrgUnit='" + productionOrderInfo.getStorageOrgUnit().getId().toString() + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            try {
                if (rowSet == null || !rowSet.next()) {
                    errBuff.append(this.getResourceMsg("PrdOrderMsg", ctx) + this.getResourceMsg("MaterialInvalidAttr", ctx) + "\n");
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
            }
        }
        if (productionOrderInfo.getBizDate() == null) {
            errBuff.append(this.getResourceMsg("BizDateNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getProductLine() == null) {
            errBuff.append(this.getResourceMsg("PrdLineNotNull", ctx) + "\n");
        } else if (!(productionOrderInfo.getStorageOrgUnit() == null || productionOrderInfo.getProductLine().getStorageOrgUnit().getId().equals((Object)productionOrderInfo.getStorageOrgUnit().getId()) && productionOrderInfo.getProductLine().getLineStatus().equals((Object)LineStatusEnum.Using))) {
            errBuff.append(this.getResourceMsg("PrdLineInvalid", ctx) + "\n");
        }
        if (!(productionOrderInfo.getFormula() == null || productionOrderInfo.getFormula().getMaterial() == null || productionOrderInfo.getMaterial() == null || productionOrderInfo.getProductLine() == null || productionOrderInfo.getFormula().getProductLine() == null || productionOrderInfo.getFormula().getMaterial().getId().equals((Object)productionOrderInfo.getMaterial().getId()) && productionOrderInfo.getFormula().getProductLine().getId().equals((Object)productionOrderInfo.getProductLine().getId()))) {
            errBuff.append(this.getResourceMsg("FormulaInvalid", ctx) + "\n");
        }
        if (productionOrderInfo.getUnit() == null) {
            errBuff.append(this.getResourceMsg("UnitNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getQty() == null || productionOrderInfo.getQty().doubleValue() <= 0.0) {
            errBuff.append(this.getResourceMsg("QtyInvalid", ctx) + "\n");
        } else if (productionOrderInfo.getMaterialPlan() != null && BatchPolicyEnum.STRAIGHTBATCH.equals((Object)productionOrderInfo.getMaterialPlan().getBatchPolicy())) {
            BigDecimal mulQty;
            if (productionOrderInfo.getMaterialPlan().getMaxBatchQty() != null && productionOrderInfo.getMaterialPlan().getMaxBatchQty().doubleValue() > 0.0) {
                BigDecimal maxQty = productionOrderInfo.getMaterialPlan().getMaxBatchQty();
                if (productionOrderInfo.getQty().doubleValue() > maxQty.doubleValue()) {
                    errBuff.append(this.getResourceMsg("QtyInvalid_Err2", new String[]{"" + maxQty.doubleValue()}, ctx) + "\n");
                }
            }
            if (productionOrderInfo.getMaterialPlan().isIsRoundUpMultiple() && (mulQty = productionOrderInfo.getMaterialPlan().getRoundUpMulitpleQty()) != null && mulQty.doubleValue() > 0.0) {
                double mulQtyDbl = mulQty.doubleValue();
                double qtyDbl = productionOrderInfo.getQty().doubleValue();
                if (qtyDbl % mulQtyDbl != 0.0) {
                    errBuff.append(this.getResourceMsg("QtyInvalid_Err3", new String[]{"" + mulQtyDbl}, ctx) + "\n");
                }
            }
        }
        if (productionOrderInfo.getStorageOrgUnit() != null && productionOrderInfo.getMaterial() != null) {
            MaterialPlanInfo plan;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)productionOrderInfo.getMaterial().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)productionOrderInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("manufactureStrategy.id");
            EntityViewInfo viewer = new EntityViewInfo();
            viewer.setFilter(filter);
            viewer.setSelector(sic);
            MaterialPlanCollection plans = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewer);
            if (plans.size() > 0 && (plan = plans.get(0)).getManufactureStrategy() != null && (plan.getManufactureStrategy().getId().toString().equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || plan.getManufactureStrategy().getId().toString().equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || plan.getManufactureStrategy().getId().toString().equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || plan.getManufactureStrategy().getId().toString().equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) && productionOrderInfo.getTrackNumber() == null) {
                errBuff.append(this.getResourceMsg2("TrackNumberNotNull", ctx) + "\n");
            }
        }
        if (productionOrderInfo.getStartDate() == null) {
            errBuff.append(this.getResourceMsg("StartDateNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getEndDate() == null) {
            errBuff.append(this.getResourceMsg("EndDateNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getStartDate() != null && productionOrderInfo.getEndDate() != null && productionOrderInfo.getEndDate().getTime() < productionOrderInfo.getStartDate().getTime()) {
            errBuff.append(this.getResourceMsg("EndDateInvalid", ctx) + "\n");
        }
        if (productionOrderInfo.getExpectEndDate() == null) {
            errBuff.append(this.getResourceMsg2("ExpectEndDateNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getStartDate() != null && productionOrderInfo.getExpectEndDate() != null && productionOrderInfo.getExpectEndDate().getTime() < productionOrderInfo.getStartDate().getTime()) {
            errBuff.append(this.getResourceMsg2("ExceptEndDateInvalid", ctx) + "\n");
        }
        if (!this.isAlterSubmit && errBuff.length() < 1) {
            StringBuffer sql_check2 = new StringBuffer();
            sql_check2.append("select count(t2.fid) shiftCount from t_mm_equipmentCalendarEntry t2 inner join t_mm_equipmentCalendar t3 on t3.fid=t2.fParentID where t2.FProductLineID=? and t3.FStorageOrgUnitID=? \n");
            sql_check2.append("and to_char(t3.fworkdate,'yyyy-MM-dd')=? and t3.FWorkDay=1 and t2.fability>0");
            IRowSet rowCheckSet = DbUtil.executeQuery((Context)ctx, (String)sql_check2.toString(), (Object[])new Object[]{productionOrderInfo.getProductLine().getId().toString(), productionOrderInfo.getStorageOrgUnit().getId().toString(), productionOrderInfo.getStartDate().toString()});
            try {
                boolean flag = false;
                boolean flag2 = false;
                if (rowCheckSet == null || rowCheckSet.size() < 1) {
                    flag = true;
                } else {
                    while (rowCheckSet.next()) {
                        if (rowCheckSet.getInt("shiftCount") >= 1) continue;
                        flag = true;
                    }
                }
                if (flag) {
                    errBuff.append(this.getResourceMsg("StartDateMustWorkDate", ctx) + "\n");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        if (errBuff.length() < 1 && RELEASE_SHIFT.equals(relType = (paramUtil = new ParamUtil(ctx, productionOrderInfo.getStorageOrgUnit().getId().toString())).getTaskDispTypeParam(RELEASE_NOT))) {
            StringBuffer sql_check = new StringBuffer();
            sql_check.append("select count(t2.fid) shiftCount from t_mm_equipmentCalendarEntry t2 inner join t_mm_equipmentCalendar t3 on t3.fid=t2.fParentID where (t2.fStartTime=? or t2.fEndTime=?) and t2.fProductLineID=? and t3.fStorageOrgUnitID=? \n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_check.toString(), (Object[])new Object[]{new Timestamp(productionOrderInfo.getStartDate().getTime()), new Timestamp(productionOrderInfo.getEndDate().getTime()), productionOrderInfo.getProductLine().getId().toString(), productionOrderInfo.getStorageOrgUnit().getId().toString()});
            try {
                boolean flag = false;
                if (rowSet == null || rowSet.size() < 1) {
                    flag = true;
                } else {
                    while (rowSet.next()) {
                        if (rowSet.getInt("shiftCount") >= 1) continue;
                        flag = true;
                    }
                }
                if (flag) {
                    errBuff.append(this.getResourceMsg("ReleaseDateVerify", ctx) + "\n");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        if (errBuff.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(errBuff.toString());
            throw bizExp;
        }
    }

    private String checkPrdOrderEntrySubmitForPLS(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductionOrderOutputEntryCollection outEntryColls;
        ProductionOrderStockEntryCollection stockEntryColls;
        StringBuffer errBuff = new StringBuffer();
        ProductionOrderInfo productionOrderInfo = (ProductionOrderInfo)model;
        ArrayList<String> cache = new ArrayList<String>();
        ProductionOrderEntryCollection wpEntryColls = productionOrderInfo.getWpEntry();
        if (wpEntryColls != null && !wpEntryColls.isEmpty()) {
            ProductionOrderEntryInfo orderEntryInfo = null;
            for (int i = 0; i < wpEntryColls.size(); ++i) {
                orderEntryInfo = wpEntryColls.get(i);
                if (StringUtils.isEmpty((String)orderEntryInfo.getPrdLineWPNumber())) {
                    errBuff.append(this.getResourceMsg("PrdOrderWP", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumNotNull", ctx) + "\n");
                }
                if (orderEntryInfo.getProductLineWP() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderWP", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNameNotNull", ctx) + "\n");
                    continue;
                }
                if (productionOrderInfo.getProductLine() == null || orderEntryInfo.getProductLineWP().getParent().getProductLine().getId().equals((Object)productionOrderInfo.getProductLine().getId())) continue;
                errBuff.append(this.getResourceMsg("PrdOrderWP", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNameInvalid", ctx) + "\n");
            }
        }
        if ((stockEntryColls = productionOrderInfo.getStockEntry()) == null || stockEntryColls.isEmpty()) {
            if (BizTypeEnum.rework != productionOrderInfo.getMmBizType() && BizTypeEnum.repair != productionOrderInfo.getMmBizType()) {
                errBuff.append(this.getResourceMsg("StockEntryNotNull", ctx) + "\n");
            }
        } else {
            ProductionOrderStockEntryInfo stockEntryInfo = null;
            for (int i = 0; i < stockEntryColls.size(); ++i) {
                stockEntryInfo = stockEntryColls.get(i);
                if (stockEntryInfo.getProductLineWP() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumNotNull", ctx) + "\n");
                } else if (!this.isPrdLineWPExist(stockEntryInfo.getProductLineWP(), wpEntryColls)) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumInvalid", ctx) + "\n");
                }
                if (stockEntryInfo.getMaterial() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("MaterialNotNull", ctx) + "\n");
                } else if (!stockEntryInfo.getMaterial().getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("MaterialInvalidStatus", ctx) + "\n");
                } else if (!this.verifyMaterialNoApproval(ctx, stockEntryInfo, productionOrderInfo.getStorageOrgUnit().getId().toString())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialNoApproval", ctx) + "\n");
                } else if (!this.verifyMaterialAttr(ctx, stockEntryInfo, productionOrderInfo.getStorageOrgUnit().getId().toString())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialInvalidAttr", ctx) + "\n");
                } else if (productionOrderInfo.getMmBizType().getValue() != 30 && productionOrderInfo.getMmBizType().getValue() != 20 && productionOrderInfo.getMaterial() != null && productionOrderInfo.getMaterial().getId().equals((Object)stockEntryInfo.getMaterial().getId())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialInvalid", ctx) + "\n");
                } else if (stockEntryInfo.getProductLineWP() != null && stockEntryInfo.getMaterial() != null && cache.contains(stockEntryInfo.getProductLineWP().getId().toString() + "$" + stockEntryInfo.getMaterial().getId().toString() + "$" + stockEntryInfo.getLotNo())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialExist", ctx) + "\n");
                }
                if (stockEntryInfo.getProductLineWP() != null && stockEntryInfo.getMaterial() != null && !cache.contains(stockEntryInfo.getProductLineWP().getId().toString() + "$" + stockEntryInfo.getMaterial().getId().toString() + "$" + stockEntryInfo.getLotNo())) {
                    cache.add(stockEntryInfo.getProductLineWP().getId().toString() + "$" + stockEntryInfo.getMaterial().getId().toString() + "$" + stockEntryInfo.getLotNo());
                }
                if (stockEntryInfo.getUnit() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("UnitNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getConsumeType() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("ConsumeTypeNotNull", ctx) + "\n");
                } else {
                    if (ConsumeTypeEnum.VariableAmount.equals((Object)stockEntryInfo.getConsumeType()) && (stockEntryInfo.getConsumeFixQty() == null || stockEntryInfo.getConsumeFixQty().doubleValue() <= 0.0)) {
                        errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("ConsumeFixQtyInvalid", ctx) + "\n");
                    }
                    if (ConsumeTypeEnum.Proportion.equals((Object)stockEntryInfo.getConsumeType()) && (stockEntryInfo.getProportion() == null || stockEntryInfo.getProportion().doubleValue() <= 0.0)) {
                        errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("ProportionInvalid", ctx) + "\n");
                    }
                }
                if (!(stockEntryInfo.getQty() != null && !(stockEntryInfo.getQty().doubleValue() <= 0.0) || stockEntryInfo.getLineSeq().indexOf("-") < 0 && stockEntryInfo.isReplaceFlag())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("QtyInvalid", ctx) + "\n");
                }
                if (stockEntryInfo.getStartDate() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryStartDateNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getEndDate() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntryEndDateNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getProvideType() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntryProvideTypeNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getSupplyOrgUnit() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntrySupplyOrgUnitNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.isIsBackFlush() && stockEntryInfo.getDefaultWarehouse() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryWarehouseNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getDefaultWarehouse() != null && stockEntryInfo.getDefaultWarehouse().isHasLocation() && (stockEntryInfo.getLocation() == null || "".equals(stockEntryInfo.getLocation()))) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("stockGather_location", ctx) + "\n");
                }
                if (stockEntryInfo.getDefaultWarehouse() == null || stockEntryInfo.getMoveOutWarehouse() == null || !stockEntryInfo.getDefaultWarehouse().getId().toString().equals(stockEntryInfo.getMoveOutWarehouse().getId().toString())) continue;
                errBuff.append(this.getResourceMsg("WarehouseHasTrue", ctx) + "\n" + this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntryWarehouseNotSame", ctx) + "\n");
            }
        }
        if ((outEntryColls = productionOrderInfo.getOutputEntry()) != null && !outEntryColls.isEmpty()) {
            ProductionOrderOutputEntryInfo outEntryInfo = null;
            ArrayList existedOutPutList = new ArrayList();
            for (int i = 0; i < outEntryColls.size(); ++i) {
                outEntryInfo = outEntryColls.get(i);
                if (outEntryInfo.getProductLineWP() == null) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumNotNull", ctx) + "\n");
                } else if (!this.isPrdLineWPExist(outEntryInfo.getProductLineWP(), wpEntryColls)) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumInvalid", ctx) + "\n");
                }
                if (outEntryInfo.getOutputType() == null) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("OutTypeNotNull", ctx) + "\n");
                }
                if (outEntryInfo.getMaterial() == null) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("MaterialNotNull", ctx) + "\n");
                }
                if (outEntryInfo.getUnit() == null) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("UnitNotNull", ctx) + "\n");
                }
                if (outEntryInfo.getQty() == null || outEntryInfo.getQty().doubleValue() <= 0.0) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("OutQtyNotNull", ctx) + "\n");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("wpId", outEntryInfo.getProductLineWP() != null ? outEntryInfo.getProductLineWP().getId() : null);
                map.put("opId", "" + outEntryInfo.getOutputType().getValue());
                map.put("mId", outEntryInfo.getMaterial() != null ? outEntryInfo.getMaterial().getId() : null);
                if (this.isSameRowExist(existedOutPutList, map)) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("OutPutExisted", ctx) + "\n");
                    continue;
                }
                existedOutPutList.add(map);
            }
        }
        if (errBuff.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(errBuff.toString());
        }
        return errBuff.toString();
    }

    private void checkPrdOrderSubmitForPlan(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ParamUtil paramUtil;
        String relType;
        StringBuffer errBuff = new StringBuffer();
        ProductionOrderInfo productionOrderInfo = (ProductionOrderInfo)model;
        if (productionOrderInfo.getStorageOrgUnit() != null) {
            StringBuffer sqlBuff = new StringBuffer();
            sqlBuff.append("select");
            sqlBuff.append(" fid ");
            sqlBuff.append(" from ");
            sqlBuff.append(" T_BD_MaterialPlan ");
            sqlBuff.append(" where ");
            sqlBuff.append(" (FMaterialAttr=10030");
            sqlBuff.append(" or FMaterialAttr=10050)");
            sqlBuff.append(" and FStatus=1");
            sqlBuff.append(" and FMaterialID='" + productionOrderInfo.getMaterial().getId().toString() + "'");
            sqlBuff.append(" and FOrgUnit='" + productionOrderInfo.getStorageOrgUnit().getId().toString() + "'");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            try {
                if (rowSet == null || !rowSet.next()) {
                    errBuff.append(this.getResourceMsg("PrdOrderMsg", ctx) + this.getResourceMsg("MaterialInvalidAttr", ctx) + "\n");
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
            }
        }
        if (productionOrderInfo.getProductLine() == null) {
            errBuff.append(this.getResourceMsg("PrdLineNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getUnit() == null) {
            errBuff.append(this.getResourceMsg("UnitNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getQty() == null || productionOrderInfo.getQty().doubleValue() <= 0.0) {
            errBuff.append(this.getResourceMsg("QtyInvalid", ctx) + "\n");
        } else if (productionOrderInfo.getMaterialPlan() != null && BatchPolicyEnum.STRAIGHTBATCH.equals((Object)productionOrderInfo.getMaterialPlan().getBatchPolicy())) {
            BigDecimal mulQty;
            BigDecimal minQty;
            BigDecimal bigDecimal = minQty = productionOrderInfo.getMaterialPlan().getMinBatchQty() == null ? new BigDecimal(0.0) : productionOrderInfo.getMaterialPlan().getMinBatchQty();
            if (productionOrderInfo.getQty().doubleValue() < minQty.doubleValue()) {
                errBuff.append(this.getResourceMsg("QtyInvalid_Err1", new String[]{"" + minQty.doubleValue()}, ctx) + "\n");
            }
            if (productionOrderInfo.getMaterialPlan().getMaxBatchQty() != null && productionOrderInfo.getMaterialPlan().getMaxBatchQty().doubleValue() > 0.0) {
                BigDecimal maxQty = productionOrderInfo.getMaterialPlan().getMaxBatchQty();
                if (productionOrderInfo.getQty().doubleValue() > maxQty.doubleValue()) {
                    errBuff.append(this.getResourceMsg("QtyInvalid_Err2", new String[]{"" + maxQty.doubleValue()}, ctx) + "\n");
                }
            }
            if (productionOrderInfo.getMaterialPlan().isIsRoundUpMultiple() && (mulQty = productionOrderInfo.getMaterialPlan().getRoundUpMulitpleQty()) != null && mulQty.doubleValue() > 0.0) {
                double mulQtyDbl = mulQty.doubleValue();
                double qtyDbl = productionOrderInfo.getQty().doubleValue();
                if (qtyDbl % mulQtyDbl != 0.0) {
                    errBuff.append(this.getResourceMsg("QtyInvalid_Err3", new String[]{"" + mulQtyDbl}, ctx) + "\n");
                }
            }
        }
        if (productionOrderInfo.getStartDate() == null) {
            errBuff.append(this.getResourceMsg("StartDateNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getEndDate() == null) {
            errBuff.append(this.getResourceMsg("EndDateNotNull", ctx) + "\n");
        }
        if (productionOrderInfo.getStartDate() != null && productionOrderInfo.getEndDate() != null && productionOrderInfo.getEndDate().getTime() < productionOrderInfo.getStartDate().getTime()) {
            errBuff.append(this.getResourceMsg("EndDateInvalid", ctx) + "\n");
        }
        PrdLotServerUtils.dealLotNo(ctx, productionOrderInfo);
        if (errBuff.length() < 1) {
            StringBuffer sql_check2 = new StringBuffer();
            sql_check2.append("select count(t2.fid) shiftCount from t_mm_equipmentCalendarEntry t2 inner join t_mm_equipmentCalendar t3 on t3.fid=t2.fParentID where t2.FProductLineID=? and t3.FStorageOrgUnitID=? \n");
            sql_check2.append("and to_char(t3.fworkdate,'yyyy-MM-dd')=? and t3.FWorkDay=1 and t2.fability>0");
            IRowSet rowCheckSet = DbUtil.executeQuery((Context)ctx, (String)sql_check2.toString(), (Object[])new Object[]{productionOrderInfo.getProductLine().getId().toString(), productionOrderInfo.getStorageOrgUnit().getId().toString(), productionOrderInfo.getStartDate().toString()});
            try {
                boolean flag = false;
                if (rowCheckSet == null || rowCheckSet.size() < 1) {
                    flag = true;
                } else {
                    while (rowCheckSet.next()) {
                        if (rowCheckSet.getInt("shiftCount") >= 1) continue;
                        flag = true;
                    }
                }
                if (flag) {
                    errBuff.append(this.getResourceMsg2("PlannedOrderDate_Chk", ctx) + "\n");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        if (errBuff.length() < 1 && RELEASE_SHIFT.equals(relType = (paramUtil = new ParamUtil(ctx, productionOrderInfo.getStorageOrgUnit().getId().toString())).getTaskDispTypeParam(RELEASE_NOT))) {
            StringBuffer sql_check = new StringBuffer();
            sql_check.append("select count(t2.fid) shiftCount from t_mm_equipmentCalendarEntry t2 inner join t_mm_equipmentCalendar t3 on t3.fid=t2.fParentID where (t2.fStartTime=? or t2.fEndTime=?) and t2.fProductLineID=? and t3.fStorageOrgUnitID=? \n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_check.toString(), (Object[])new Object[]{new Timestamp(productionOrderInfo.getStartDate().getTime()), new Timestamp(productionOrderInfo.getEndDate().getTime()), productionOrderInfo.getProductLine().getId().toString(), productionOrderInfo.getStorageOrgUnit().getId().toString()});
            try {
                boolean flag = false;
                if (rowSet == null || rowSet.size() < 1) {
                    flag = true;
                } else {
                    while (rowSet.next()) {
                        if (rowSet.getInt("shiftCount") >= 1) continue;
                        flag = true;
                    }
                }
                if (flag) {
                    errBuff.append(this.getResourceMsg("ReleaseDateVerify", ctx) + "\n");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (errBuff.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(errBuff.toString());
            throw bizExp;
        }
    }

    private void checkPrdOrderEntrySubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductionOrderOutputEntryCollection outEntryColls;
        ProductionOrderStockEntryCollection stockEntryColls;
        StringBuffer errBuff = new StringBuffer();
        ProductionOrderInfo productionOrderInfo = (ProductionOrderInfo)model;
        ArrayList<String> cache = new ArrayList<String>();
        ProductionOrderEntryCollection wpEntryColls = productionOrderInfo.getWpEntry();
        if (wpEntryColls != null && !wpEntryColls.isEmpty()) {
            ProductionOrderEntryInfo orderEntryInfo = null;
            for (int i = 0; i < wpEntryColls.size(); ++i) {
                orderEntryInfo = wpEntryColls.get(i);
                if (StringUtils.isEmpty((String)orderEntryInfo.getPrdLineWPNumber())) {
                    errBuff.append(this.getResourceMsg("PrdOrderWP", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumNotNull", ctx) + "\n");
                }
                if (orderEntryInfo.getProductLineWP() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderWP", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNameNotNull", ctx) + "\n");
                    continue;
                }
                if (productionOrderInfo.getProductLine() == null || orderEntryInfo.getProductLineWP().getParent().getProductLine().getId().equals((Object)productionOrderInfo.getProductLine().getId())) continue;
                errBuff.append(this.getResourceMsg("PrdOrderWP", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNameInvalid", ctx) + "\n");
            }
        }
        if ((stockEntryColls = productionOrderInfo.getStockEntry()) == null || stockEntryColls.isEmpty()) {
            if (BizTypeEnum.rework != productionOrderInfo.getMmBizType() && BizTypeEnum.repair != productionOrderInfo.getMmBizType()) {
                errBuff.append(this.getResourceMsg("StockEntryNotNull", ctx) + "\n");
            }
        } else {
            ProductionOrderStockEntryInfo stockEntryInfo = null;
            for (int i = 0; i < stockEntryColls.size(); ++i) {
                stockEntryInfo = stockEntryColls.get(i);
                if (stockEntryInfo.getProductLineWP() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumNotNull", ctx) + "\n");
                } else if (!this.isPrdLineWPExist(stockEntryInfo.getProductLineWP(), wpEntryColls)) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumInvalid", ctx) + "\n");
                }
                if (stockEntryInfo.getMaterial() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("MaterialNotNull", ctx) + "\n");
                } else if (!stockEntryInfo.getMaterial().getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("MaterialInvalidStatus", ctx) + "\n");
                } else if (!this.verifyMaterialNoApproval(ctx, stockEntryInfo, productionOrderInfo.getStorageOrgUnit().getId().toString())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialNoApproval", ctx) + "\n");
                } else if (!this.verifyMaterialAttr(ctx, stockEntryInfo, productionOrderInfo.getStorageOrgUnit().getId().toString())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialInvalidAttr", ctx) + "\n");
                } else if (productionOrderInfo.getMmBizType().getValue() != 30 && productionOrderInfo.getMmBizType().getValue() != 20 && productionOrderInfo.getMaterial() != null && productionOrderInfo.getMaterial().getId().equals((Object)stockEntryInfo.getMaterial().getId())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialInvalid", ctx) + "\n");
                } else if (stockEntryInfo.getProductLineWP() != null && stockEntryInfo.getMaterial() != null && cache.contains(stockEntryInfo.getProductLineWP().getId().toString() + "$" + stockEntryInfo.getMaterial().getId().toString() + "$" + stockEntryInfo.getLotNo())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialExist", ctx) + "\n");
                }
                if (stockEntryInfo.getProductLineWP() != null && stockEntryInfo.getMaterial() != null && !cache.contains(stockEntryInfo.getProductLineWP().getId().toString() + "$" + stockEntryInfo.getMaterial().getId().toString() + "$" + stockEntryInfo.getLotNo())) {
                    cache.add(stockEntryInfo.getProductLineWP().getId().toString() + "$" + stockEntryInfo.getMaterial().getId().toString() + "$" + stockEntryInfo.getLotNo());
                }
                if (stockEntryInfo.getUnit() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("UnitNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getConsumeType() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("ConsumeTypeNotNull", ctx) + "\n");
                } else {
                    if (ConsumeTypeEnum.VariableAmount.equals((Object)stockEntryInfo.getConsumeType()) && (stockEntryInfo.getConsumeFixQty() == null || stockEntryInfo.getConsumeFixQty().doubleValue() <= 0.0)) {
                        errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("ConsumeFixQtyInvalid", ctx) + "\n");
                    }
                    if (ConsumeTypeEnum.Proportion.equals((Object)stockEntryInfo.getConsumeType()) && (stockEntryInfo.getProportion() == null || stockEntryInfo.getProportion().doubleValue() <= 0.0)) {
                        errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("ProportionInvalid", ctx) + "\n");
                    }
                }
                if (!(stockEntryInfo.getQty() != null && !(stockEntryInfo.getQty().doubleValue() <= 0.0) || stockEntryInfo.getLineSeq().indexOf("-") < 0 && stockEntryInfo.isReplaceFlag())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("QtyInvalid", ctx) + "\n");
                }
                if (stockEntryInfo.getStartDate() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryStartDateNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getEndDate() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntryEndDateNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getProvideType() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntryProvideTypeNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getSupplyOrgUnit() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntrySupplyOrgUnitNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.isIsBackFlush() && stockEntryInfo.getDefaultWarehouse() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryWarehouseNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getDefaultWarehouse() != null && stockEntryInfo.getDefaultWarehouse().isHasLocation() && (stockEntryInfo.getLocation() == null || "".equals(stockEntryInfo.getLocation()))) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("stockGather_location", ctx) + "\n");
                }
                if (stockEntryInfo.getDefaultWarehouse() == null || stockEntryInfo.getMoveOutWarehouse() == null || !stockEntryInfo.getDefaultWarehouse().getId().toString().equals(stockEntryInfo.getMoveOutWarehouse().getId().toString())) continue;
                errBuff.append(this.getResourceMsg("WarehouseHasTrue", ctx) + "\n" + this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntryWarehouseNotSame", ctx) + "\n");
            }
        }
        if ((outEntryColls = productionOrderInfo.getOutputEntry()) != null && !outEntryColls.isEmpty()) {
            ProductionOrderOutputEntryInfo outEntryInfo = null;
            ArrayList existedOutPutList = new ArrayList();
            for (int i = 0; i < outEntryColls.size(); ++i) {
                outEntryInfo = outEntryColls.get(i);
                if (outEntryInfo.getProductLineWP() == null) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumNotNull", ctx) + "\n");
                } else if (!this.isPrdLineWPExist(outEntryInfo.getProductLineWP(), wpEntryColls)) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumInvalid", ctx) + "\n");
                }
                if (outEntryInfo.getOutputType() == null) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("OutTypeNotNull", ctx) + "\n");
                }
                if (outEntryInfo.getMaterial() == null) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("MaterialNotNull", ctx) + "\n");
                }
                if (outEntryInfo.getUnit() == null) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("UnitNotNull", ctx) + "\n");
                }
                if (outEntryInfo.getQty() == null || outEntryInfo.getQty().doubleValue() <= 0.0) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("OutQtyNotNull", ctx) + "\n");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("wpId", outEntryInfo.getProductLineWP() != null ? outEntryInfo.getProductLineWP().getId() : null);
                map.put("opId", "" + outEntryInfo.getOutputType().getValue());
                map.put("mId", outEntryInfo.getMaterial() != null ? outEntryInfo.getMaterial().getId() : null);
                if (this.isSameRowExist(existedOutPutList, map)) {
                    errBuff.append(this.getResourceMsg("PrdOutEntry", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("OutPutExisted", ctx) + "\n");
                    continue;
                }
                existedOutPutList.add(map);
            }
        }
        if (errBuff.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(errBuff.toString());
            throw bizExp;
        }
    }

    private void checkPrdOrderEntrySubmitForPlan(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StringBuffer errBuff = new StringBuffer();
        ProductionOrderInfo productionOrderInfo = (ProductionOrderInfo)model;
        ArrayList<String> cache = new ArrayList<String>();
        ProductionOrderEntryCollection wpEntryColls = productionOrderInfo.getWpEntry();
        if (wpEntryColls == null || wpEntryColls.isEmpty()) {
            errBuff.append(this.getResourceMsg("WPEntryNotNull", ctx) + "\n");
        } else {
            ProductionOrderEntryInfo orderEntryInfo = null;
            for (int i = 0; i < wpEntryColls.size(); ++i) {
                orderEntryInfo = wpEntryColls.get(i);
                if (StringUtils.isEmpty((String)orderEntryInfo.getPrdLineWPNumber())) {
                    errBuff.append(this.getResourceMsg("PrdOrderWP", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNumNotNull", ctx) + "\n");
                }
                if (orderEntryInfo.getProductLineWP() != null) continue;
                errBuff.append(this.getResourceMsg("PrdOrderWP", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("LineWPNameNotNull", ctx) + "\n");
            }
        }
        ProductionOrderStockEntryCollection stockEntryColls = productionOrderInfo.getStockEntry();
        if (stockEntryColls == null || stockEntryColls.isEmpty()) {
            errBuff.append(this.getResourceMsg("StockEntryNotNull", ctx) + "\n");
        } else {
            ProductionOrderStockEntryInfo stockEntryInfo = null;
            for (int i = 0; i < stockEntryColls.size(); ++i) {
                stockEntryInfo = stockEntryColls.get(i);
                if (stockEntryInfo.getLineSeq() == null) {
                    stockEntryInfo.setLineSeq(i + 1 + AUDIT_GEN);
                }
                if (!stockEntryInfo.getMaterial().getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("MaterialInvalidStatus", ctx) + "\n");
                } else if (!this.verifyMaterialNoApproval(ctx, stockEntryInfo, productionOrderInfo.getStorageOrgUnit().getId().toString())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialNoApproval", ctx) + "\n");
                } else if (!this.verifyMaterialAttr(ctx, stockEntryInfo, productionOrderInfo.getStorageOrgUnit().getId().toString())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialInvalidAttr", ctx) + "\n");
                } else if (stockEntryInfo.getProductLineWP() != null && stockEntryInfo.getMaterial() != null && cache.contains(stockEntryInfo.getProductLineWP().getId().toString() + "$" + stockEntryInfo.getMaterial().getId().toString() + "$" + stockEntryInfo.getLotNo())) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryMaterialExist", ctx) + "\n");
                }
                if (stockEntryInfo.getProductLineWP() != null && stockEntryInfo.getMaterial() != null && !cache.contains(stockEntryInfo.getProductLineWP().getId().toString() + "$" + stockEntryInfo.getMaterial().getId().toString() + "$" + stockEntryInfo.getLotNo())) {
                    cache.add(stockEntryInfo.getProductLineWP().getId().toString() + "$" + stockEntryInfo.getMaterial().getId().toString() + "$" + stockEntryInfo.getLotNo());
                }
                if (stockEntryInfo.getProvideType() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntryProvideTypeNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getSupplyOrgUnit() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntrySupplyOrgUnitNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.isIsBackFlush() && stockEntryInfo.getDefaultWarehouse() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("EntryWarehouseNotNull", ctx) + "\n");
                }
                if (stockEntryInfo.getDefaultWarehouse() != null && stockEntryInfo.getDefaultWarehouse().isHasLocation() && stockEntryInfo.getLocation() == null) {
                    errBuff.append(this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg("stockGather_location", ctx) + "\n");
                }
                if (stockEntryInfo.getDefaultWarehouse() == null || stockEntryInfo.getMoveOutWarehouse() == null || !stockEntryInfo.getDefaultWarehouse().getId().toString().equals(stockEntryInfo.getMoveOutWarehouse().getId().toString())) continue;
                errBuff.append(this.getResourceMsg("WarehouseHasTrue", ctx) + "\n" + this.getResourceMsg("PrdOrderStock", ctx) + this.getResourceMsg("ROW", new String[]{String.valueOf(i + 1)}, ctx) + this.getResourceMsg2("EntryWarehouseNotSame", ctx) + "\n");
            }
        }
        if (errBuff.length() > 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(errBuff.toString());
            throw bizExp;
        }
    }

    private boolean isPrdLineWPExist(ProductLineWPEntryInfo prdLineWP, ProductionOrderEntryCollection wpEntryColls) {
        boolean retVal = false;
        if (prdLineWP != null && wpEntryColls != null && !wpEntryColls.isEmpty()) {
            ProductionOrderEntryInfo wpEntryInfo = null;
            for (int i = 0; i < wpEntryColls.size(); ++i) {
                wpEntryInfo = wpEntryColls.get(i);
                if (wpEntryInfo.getProductLineWP() == null || !wpEntryInfo.getProductLineWP().getId().toString().equals(prdLineWP.getId().toString())) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    private boolean isSameRowExist(List existedOutPutList, Map map) {
        for (int i = 0; i < existedOutPutList.size(); ++i) {
            Map existed = (Map)existedOutPutList.get(i);
            if (!existed.equals(map)) continue;
            return true;
        }
        return false;
    }

    private boolean verifyMaterialNoApproval(Context ctx, ProductionOrderStockEntryInfo stockEntryInfo, String orgUnit) {
        boolean retVal = false;
        if (stockEntryInfo.getMaterialInventory() != null && UsedStatusEnum.APPROVED != stockEntryInfo.getMaterialInventory().getStatus()) {
            return retVal;
        }
        String materialID = stockEntryInfo.getMaterial().getId().toString();
        String sql = "select fid from T_BD_MaterialPlan where FStatus=1 and FMaterialID=? and FOrgUnit=?";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialID, orgUnit});
            if (rowSet != null && rowSet.next()) {
                retVal = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            retVal = false;
        }
        return retVal;
    }

    private boolean verifyMaterialAttr(Context ctx, ProductionOrderStockEntryInfo stockEntryInfo, String orgUnit) {
        boolean retVal = false;
        if (stockEntryInfo.getMaterialInventory() != null && MaterialAttributeEnum.FABRICATEDPART != stockEntryInfo.getMaterialInventory().getMaterialAttr() && MaterialAttributeEnum.EXTERNALPROCESSINPART != stockEntryInfo.getMaterialInventory().getMaterialAttr() && MaterialAttributeEnum.PURCHASEDPART != stockEntryInfo.getMaterialInventory().getMaterialAttr()) {
            return retVal;
        }
        String materialID = stockEntryInfo.getMaterial().getId().toString();
        String sql = "select fid,fMaterialChar from T_BD_MaterialPlan where (FMaterialAttr=10030 or FMaterialAttr=10050 or FMaterialAttr=10040) and FStatus=1 and FMaterialID=? and FOrgUnit=?";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialID, orgUnit});
            if (rowSet != null && rowSet.next()) {
                if (stockEntryInfo.getMaterialInventory() == null) {
                    MaterialPlanInfo materialPlanInfo = new MaterialPlanInfo();
                    materialPlanInfo.setId(BOSUuid.read((String)rowSet.getString("fid")));
                    stockEntryInfo.setMaterialInventory(materialPlanInfo);
                    int materialChar = rowSet.getInt("fMaterialChar");
                    stockEntryInfo.setMaterialChar(MaterialCharEnum.getEnum((int)materialChar));
                }
                retVal = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            retVal = false;
        }
        return retVal;
    }

    private String getResourceMsg(String key, Context ctx) {
        return ResourceManage.getResource((String)RES_PRD_ORDER, (String)key, (Locale)ctx.getLocale());
    }

    private String getResourceMsg(String key, String[] params, Context ctx) {
        String message = ResourceManage.getResource((String)RES_PRD_ORDER, (String)key, (Locale)ctx.getLocale());
        StringBuffer sb = new StringBuffer();
        String REGEX_L = "\\{";
        String REGEX_R = "\\}";
        for (int i = 0; i < params.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), params[i]);
        }
        return message;
    }

    private String getResourceMsg2(String key, Context ctx) {
        return ResourceManage.getResource((String)RES_PRD_NEXT_ORDER, (String)key, (Locale)ctx.getLocale());
    }

    private String getResourceMsg2(String key, String[] params, Context ctx) {
        String message = ResourceManage.getResource((String)RES_PRD_NEXT_ORDER, (String)key, (Locale)ctx.getLocale());
        StringBuffer sb = new StringBuffer();
        String REGEX_L = "\\{";
        String REGEX_R = "\\}";
        for (int i = 0; i < params.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), params[i]);
        }
        return message;
    }

    private void genPickingExecute(Context ctx, String ids, boolean isAuto) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)ids)) {
            return;
        }
        String creatorID = ctx.getCaller().toString();
        StringBuffer genHeaderBuff = new StringBuffer();
        genHeaderBuff.append(" insert into ");
        genHeaderBuff.append(" t_mm_pickingSlipBill ");
        genHeaderBuff.append("(");
        genHeaderBuff.append("fid");
        genHeaderBuff.append(",fSourceBillID");
        genHeaderBuff.append(",fSourceBillTypeID");
        genHeaderBuff.append(",fBillTypeID");
        genHeaderBuff.append(",fControlUnitID");
        genHeaderBuff.append(",fStorageOrgUnitID");
        genHeaderBuff.append(",fProductionOrderID");
        genHeaderBuff.append(",fWorkshopID");
        genHeaderBuff.append(",fProductLineID");
        genHeaderBuff.append(",fShiftID");
        genHeaderBuff.append(",fClassGroupID");
        genHeaderBuff.append(",fTraceNo");
        genHeaderBuff.append(",fReqSuite");
        genHeaderBuff.append(",fBaseReqSuite");
        genHeaderBuff.append(",fSaleOrderID");
        genHeaderBuff.append(",fMaterialID");
        genHeaderBuff.append(",fUnitID");
        genHeaderBuff.append(",fBizDate");
        genHeaderBuff.append(",fCreateTime");
        genHeaderBuff.append(",fCreatorID");
        genHeaderBuff.append(",FMODIFIERID");
        genHeaderBuff.append(",FMODIFICATIONTIME");
        genHeaderBuff.append(",fBaseStatus");
        genHeaderBuff.append(",FTrackNumberID");
        genHeaderBuff.append(",FMmBizType");
        genHeaderBuff.append(") ");
        genHeaderBuff.append(" select ");
        genHeaderBuff.append("newbosid('A06DF1E1')");
        genHeaderBuff.append(",ordT.fid");
        genHeaderBuff.append(",'ejIZHXXTQliYCQJg9t4Re0Y+1VI='");
        genHeaderBuff.append(",'3fY8szOQTQmfaNi+Tm5SJUY+1VI='");
        genHeaderBuff.append(",ordT.fControlUnitID");
        genHeaderBuff.append(",ordT.fStorageOrgUnitID");
        genHeaderBuff.append(",ordT.fid");
        genHeaderBuff.append(",ordT.fWorkShopID");
        genHeaderBuff.append(",ordT.fProductLineID");
        genHeaderBuff.append(",ordT.fClassTeamID");
        genHeaderBuff.append(",ordT.fClassGroupID");
        genHeaderBuff.append(",ordT.fTraceNo");
        genHeaderBuff.append(",ordT.fQty");
        genHeaderBuff.append(",ordT.fBaseQty");
        genHeaderBuff.append(",ordT.fSaleOrderID");
        genHeaderBuff.append(",ordT.fMaterialID");
        genHeaderBuff.append(",ordT.fUnitID");
        genHeaderBuff.append(",ordT.fBizDate");
        genHeaderBuff.append(",now()");
        genHeaderBuff.append(",'" + creatorID + "'");
        genHeaderBuff.append(",'" + creatorID + "'");
        genHeaderBuff.append(",now()");
        genHeaderBuff.append(",1");
        genHeaderBuff.append(",ordT.FTrackNumberID");
        genHeaderBuff.append(",ordT.FMmBizType");
        genHeaderBuff.append(" From ");
        genHeaderBuff.append(" t_mm_productionOrder AS ordT ");
        genHeaderBuff.append(" Where ");
        genHeaderBuff.append(" (ordT.fBasestatus=4");
        genHeaderBuff.append(" or ordT.fBasestatus=5");
        genHeaderBuff.append(" or (ordT.fBasestatus=8and ordT.FIsManualFinish = 0) ");
        genHeaderBuff.append(") and ordT.FIsPickSlip=0 ");
        genHeaderBuff.append(" and ordT.fid in (" + ids + ")");
        DbUtil.execute((Context)ctx, (String)genHeaderBuff.toString());
        StringBuffer genDetailBuff = new StringBuffer();
        genDetailBuff.append(" insert into ");
        genDetailBuff.append(" t_mm_pickingSlipBillEntry ");
        genDetailBuff.append("(");
        genDetailBuff.append("fid");
        genDetailBuff.append(",fParentID");
        genDetailBuff.append(",fSourceBillId");
        genDetailBuff.append(",fSourceBillNumber");
        genDetailBuff.append(",fSOURCEBILLENTRYID");
        genDetailBuff.append(",fSOURCEBILLENTRYSeq");
        genDetailBuff.append(",fSourceBillTypeID");
        genDetailBuff.append(",FLineType");
        genDetailBuff.append(",FLineStatus");
        genDetailBuff.append(",fSeq");
        genDetailBuff.append(",fProductLineWPID");
        genDetailBuff.append(",fMaterialID");
        genDetailBuff.append(",fMaterialPlanID");
        genDetailBuff.append(",fBaseUnitID");
        genDetailBuff.append(",fBaseReqQty");
        genDetailBuff.append(",fUnitID");
        genDetailBuff.append(",fReqQty");
        genDetailBuff.append(",fReqDate");
        genDetailBuff.append(",FProvideType");
        genDetailBuff.append(",FSupplyStorageOrgUnitID");
        genDetailBuff.append(",fPickingDate");
        genDetailBuff.append(",fWarehouseID");
        genDetailBuff.append(",fStoreAdminID");
        genDetailBuff.append(",fBaseStatus");
        genDetailBuff.append(",fRemark");
        genDetailBuff.append(",FLotNo");
        genDetailBuff.append(",FLocationID");
        genDetailBuff.append(")");
        genDetailBuff.append(" select ");
        genDetailBuff.append(" newbosid('5F932B11')");
        genDetailBuff.append(",pickT.fid");
        genDetailBuff.append(",ordT.fid");
        genDetailBuff.append(",ordT.fNumber");
        genDetailBuff.append(",stkT.fid");
        genDetailBuff.append(",stkT.fseq");
        genDetailBuff.append(",'ejIZHXXTQliYCQJg9t4Re0Y+1VI='");
        genDetailBuff.append(",1");
        genDetailBuff.append(",1");
        genDetailBuff.append(",stkT.fseq");
        genDetailBuff.append(",stkT.fProductLineWPID");
        genDetailBuff.append(",stkT.fMaterialID");
        genDetailBuff.append(",stkT.fMaterialInventoryID");
        genDetailBuff.append(",stkT.fBaseUnitID");
        genDetailBuff.append(",stkT.fBaseQty");
        genDetailBuff.append(",stkT.fUnitID");
        genDetailBuff.append(",stkT.fQty");
        genDetailBuff.append(",ordT.fStartDate");
        genDetailBuff.append(",stkT.FProvideType");
        genDetailBuff.append(",stkT.FSupplyStorageOrgUnitID");
        genDetailBuff.append(",ordT.fStartDate");
        genDetailBuff.append(",stkT.fDefaultWarehouseID");
        genDetailBuff.append(",select wh.fwhmanID from t_db_wareHouse as wh where wh.fid=stkT.fDefaultWarehouseID");
        genDetailBuff.append(",1");
        genDetailBuff.append(",stkT.fRemark");
        genDetailBuff.append(",stkT.FLotNo");
        genDetailBuff.append(",stkT.FLocationID");
        genDetailBuff.append(" from ");
        genDetailBuff.append(" t_mm_pickingSlipBill AS pickT ");
        genDetailBuff.append(" inner join t_mm_productionOrder as ordT on pickT.fSourceBillID = ordT.fid");
        genDetailBuff.append(" inner join t_mm_productionOrderSEntry as stkT on stkT.fParentID =ordT.fid and stkT.fIsBackFlush=0 and stkT.fQty>0 and stkT.FIssMode=11010");
        genDetailBuff.append(" where ");
        genDetailBuff.append(" pickT.fNumber is null ");
        genDetailBuff.append(" and ordT.fid in (" + ids + ")");
        DbUtil.execute((Context)ctx, (String)genDetailBuff.toString());
        StringBuffer sql_getPickDate = new StringBuffer();
        sql_getPickDate.append(" select distinct(s.fid) fid ,p.fworkdate fpickingdate,s.fPickingDate fCurPickingDate,to_char(ADD_MINUTES(s.fPickingDate,z.FPickingLeadTime*-1),'YYYY-MM-DD HH24:MI:SS') fpickingTime ");
        sql_getPickDate.append(" from t_mm_pickingSlipBillEntry s ");
        sql_getPickDate.append(" left join t_mm_pickingSlipBill u on s.fparentid = u.fid ");
        sql_getPickDate.append(" left join T_MM_ProductionOrderSEntry z on z.fid = s.fSOURCEBILLENTRYID ");
        sql_getPickDate.append(" left join (select ec.fstorageorgunitid fstorageorgunitid, ece.FProductLineID FProductLineID, ec.FWorkDate FWorkDate ");
        sql_getPickDate.append(" \t\t\tfrom t_mm_equipmentcalendar ec ");
        sql_getPickDate.append("\t\t\tinner join t_mm_equipmentcalendarentry ece on ec.fid = ece.FParentID ");
        sql_getPickDate.append("\t\t\t) p on \tu.fproductlineid = p.FProductLineID and p.fstorageorgunitid = u.fstorageorgunitid ");
        sql_getPickDate.append(" where u.fNumber is null and u.fSourceBillID in( " + ids + " )");
        sql_getPickDate.append(" and p.fworkdate=( ");
        sql_getPickDate.append("\t\t\t\t\tselect max(e.fworkdate) ");
        sql_getPickDate.append("\t\t\t\t\tfrom  t_mm_equipmentcalendarentry f inner join t_mm_equipmentcalendar e on f.fparentid=e.fid ");
        sql_getPickDate.append("\t\t\t\t\twhere  ");
        sql_getPickDate.append("\t\t\t\t\te.fstorageorgunitid = u.FStorageOrgUnitID and f.fproductlineid=u.fproductlineid  ");
        sql_getPickDate.append("\t\t\t\t\tand to_char(e.fworkdate,'yyyy-mm-dd')<= to_char(ADD_MINUTES(s.fPickingDate,z.FPickingLeadTime*-1),'yyyy-mm-dd') and YEAR(NOW())=YEAR(e.fworkdate) and e.FWorkDay=1 and f.fAbility>0 ");
        sql_getPickDate.append("\t\t\t\t ) ");
        IRowSet row1 = DbUtil.executeQuery((Context)ctx, (String)sql_getPickDate.toString());
        Connection conn1 = null;
        PreparedStatement updatePkDtPrpStmt = null;
        String updatePkDtSql = "update t_mm_pickingSlipBillEntry set fpickingdate=? where fid=? ";
        PreparedStatement updateNumPrpStmt = null;
        String updateNumSql = "update t_mm_pickingSlipBill set fnumber=? where fid=? ";
        PreparedStatement saveBotpPrpStmt = null;
        String saveBotpSql = "insert into t_bot_relation (FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values (newbosid('59302EC6'),'1F66774E','A06DF1E1',?,?,now(),?,1,null,0)";
        Statement writeBackStmt = null;
        String writeBackSql = "update t_mm_productionOrder set fIsPickSlip=1 where fid in (" + ids + ")";
        String sql = "select fid,fSourceBillID,fstorageorgunitid from t_mm_pickingSlipBill where fNumber is null and fSourceBillID in (" + ids + ")";
        IRowSet row2 = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            conn1 = EJBFactory.getConnection((Context)ctx);
            updatePkDtPrpStmt = conn1.prepareStatement(updatePkDtSql);
            updateNumPrpStmt = conn1.prepareStatement(updateNumSql);
            saveBotpPrpStmt = conn1.prepareStatement(saveBotpSql);
            while (row1.next()) {
                String entryId = row1.getString("fid");
                Timestamp fpickingdate = row1.getTimestamp("fpickingdate");
                Timestamp fCurPickingDate = row1.getTimestamp("fCurPickingDate");
                Timestamp fpickingTime = row1.getTimestamp("fpickingTime");
                Timestamp calPickingDate = null;
                if (fpickingdate != null && fCurPickingDate != null && fpickingTime != null) {
                    if (fpickingdate != null) {
                        calPickingDate = fpickingdate;
                    }
                    if (fCurPickingDate != null && calPickingDate == null) {
                        calPickingDate = fCurPickingDate;
                    }
                    if (fpickingTime != null && calPickingDate != null) {
                        calPickingDate.setHours(fpickingTime.getHours());
                        calPickingDate.setMinutes(fpickingTime.getMinutes());
                        calPickingDate.setSeconds(fpickingTime.getSeconds());
                    }
                }
                updatePkDtPrpStmt.setTimestamp(1, calPickingDate);
                updatePkDtPrpStmt.setString(2, entryId);
                updatePkDtPrpStmt.addBatch();
            }
            ArrayList<String> pickNumSet = new ArrayList<String>();
            PickingSlipBillInfo pickingInfo = new PickingSlipBillInfo();
            pickingInfo.setBizDate(new Date());
            pickingInfo.setCU(this.getControlUnit(ctx));
            while (row2.next()) {
                String pickId = row2.getString("fid");
                String number = null;
                if (codingRuleManager.isExist((IObjectValue)pickingInfo, row2.getString("fstorageorgunitid"))) {
                    number = codingRuleManager.getNumber((IObjectValue)pickingInfo, row2.getString("fstorageorgunitid"));
                    if (pickNumSet.contains(number)) {
                        throw new ProductionOrderException(ProductionOrderException.GENPICKINGEXCEPTION, new Object[]{this.getResourceMsg2("autoGenPickingNumCheck", ctx)});
                    }
                } else {
                    throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{this.getResourceMsg2("PICKINGSLIPBILL", ctx)});
                }
                pickNumSet.add(number);
                updateNumPrpStmt.setString(1, number);
                updateNumPrpStmt.setString(2, pickId);
                updateNumPrpStmt.addBatch();
                saveBotpPrpStmt.setString(1, row2.getString("fSourceBillID"));
                saveBotpPrpStmt.setString(2, pickId);
                saveBotpPrpStmt.setString(3, creatorID);
                saveBotpPrpStmt.addBatch();
            }
            updatePkDtPrpStmt.executeBatch();
            updateNumPrpStmt.executeBatch();
            saveBotpPrpStmt.executeBatch();
            writeBackStmt = conn1.createStatement();
            writeBackStmt.execute(writeBackSql);
            if (isAuto) {
                StringBuffer ckSql = new StringBuffer();
                ckSql.append(" select pick.fid as pickId,pick.fnumber as pickNum,p.fstorageorgunitid as prdOrgId,pick.fstorageOrgUnitId as pickOrgId  from t_mm_pickingSlipBill pick  ");
                ckSql.append(" inner join t_bot_relation r on  r.fdestObjectID = pick.fid ");
                ckSql.append(" inner join t_mm_productionorder p on pick.fproductionorderid = p.fid  and r.fsrcObjectID  = p.fid ");
                ckSql.append(" where r.fsrcEntityID = ? and r.fdestEntityID = ? and p.fid in (");
                ckSql.append(ids);
                ckSql.append(")");
                IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)ckSql.toString(), (Object[])new Object[]{new ProductionOrderInfo().getBOSType().toString(), new PickingSlipBillInfo().getBOSType().toString()});
                IPickingSlipBill iPicking = PickingSlipBillFactory.getLocalInstance(ctx);
                while (rs.next()) {
                    String value;
                    String pickId = rs.getString("pickId");
                    String prdOrgId = rs.getString("prdOrgId");
                    String pickOrgId = rs.getString("pickOrgId");
                    String pickNum = rs.getString("pickNum");
                    if (pickNum == null || "".equals(pickNum) || (value = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(prdOrgId), (String)"GenPickingAutoAudit")) == null || value.trim().equals("") || !value.trim().equals(GENCOST_NOT)) continue;
                    PickingSlipBillInfo pickInfo = (PickingSlipBillInfo)iPicking.getValue((IObjectPK)new ObjectUuidPK(pickId));
                    iPicking.submit((CoreBaseInfo)pickInfo);
                    ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
                    String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 4, pickOrgId, "3fY8szOQTQmfaNi+Tm5SJUY+1VI=");
                    if (strAutoAudit == null || strAutoAudit.trim().equals("") || strAutoAudit.trim().equals("1")) continue;
                    iPicking.audit((IObjectPK)new ObjectUuidPK(pickId));
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updatePkDtPrpStmt, null);
                SQLUtils.cleanup(updateNumPrpStmt, null);
                SQLUtils.cleanup(saveBotpPrpStmt, null);
                SQLUtils.cleanup(writeBackStmt, (Connection)conn1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updatePkDtPrpStmt, null);
        SQLUtils.cleanup((Statement)updateNumPrpStmt, null);
        SQLUtils.cleanup((Statement)saveBotpPrpStmt, null);
        SQLUtils.cleanup((Statement)writeBackStmt, (Connection)conn1);
    }

    protected boolean _checkUnAuditInParam(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ProductionOrderInfo productionOrderInfo = (ProductionOrderInfo)model;
        if (productionOrderInfo.getBillType() != null) {
            String billTypeId = productionOrderInfo.getBillType().getId().toString();
            String orgUnitID = productionOrderInfo.getStorageOrgUnit().getId().toString();
            boolean isCanUnAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId);
            if (strCanUnAudit != null && strCanUnAudit.trim().length() != 0 && strCanUnAudit.trim().toLowerCase().equals("1")) {
                isCanUnAudit = true;
            }
            if (!isCanUnAudit) {
                throw new SCMBillException(SCMBillException.CHECK_UNAUDIT_PARAM);
            }
        }
        return true;
    }

    @Override
    protected Map _getPrdOrdParam(Context ctx, String storageOrgUnitID, String[] paramKey) throws BOSException, EASBizException {
        HashMap<String, String> retVal = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)storageOrgUnitID) && paramKey != null && paramKey.length > 0) {
            for (int i = 0; i < paramKey.length; ++i) {
                try {
                    String value = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)paramKey[i]);
                    retVal.put(paramKey[i], value);
                    continue;
                }
                catch (Exception ex) {
                    logger.warn((Object)ex);
                }
            }
        }
        return retVal;
    }

    @Override
    protected String[] _getAuthorizedSlsOrgIDs(Context ctx, String materialID, String orgUnitID) throws BOSException, EASBizException {
        return this._getAuthorizedSlsOrgIDs(ctx, materialID, orgUnitID, OrgType.Storage);
    }

    @Override
    protected String[] _getAuthorizedSlsOrgIDs(Context ctx, String materialID, String orgUnitID, OrgType orgType) throws BOSException, EASBizException {
        String[] retVal = null;
        if (!StringUtils.isEmpty((String)orgUnitID)) {
            Set keySet;
            String kql;
            IRowSet rowSet;
            orgType = orgType == null ? OrgType.Storage : orgType;
            ArrayList<String> mSlsLst = new ArrayList<String>();
            ArrayList<String> rsLst = new ArrayList<String>();
            if (orgType.equals((Object)OrgType.Sale)) {
                rsLst.add(orgUnitID);
            }
            if (!StringUtils.isEmpty((String)materialID) && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(kql = "select distinct fOrgUnit from t_bd_materialSales where fStatus=? and fMaterialID=?"), (Object[])new Object[]{new Integer(1), materialID})) != null && rowSet.size() > 0) {
                try {
                    while (rowSet.next()) {
                        String orgID = rowSet.getString("fOrgUnit");
                        if (StringUtils.isEmpty((String)orgID) || mSlsLst.contains(orgID)) continue;
                        mSlsLst.add(orgID);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            StringBuffer relKql = new StringBuffer();
            relKql.append("select ");
            relKql.append(" t1.fFromUnitID fFromUnitID");
            relKql.append(",t1.fToUnitID fToUnitID");
            relKql.append(" from ");
            relKql.append(" t_org_unitRelation as t1 ");
            relKql.append(" inner join t_org_typeRelation as t2 on t1.fTypeRelationID=t2.fid ");
            relKql.append(" where ");
            relKql.append(" (");
            relKql.append("t1.fFromUnitID=? ");
            relKql.append(" and t2.fFromType=? ");
            relKql.append(" and t2.fToType=? ");
            relKql.append(")");
            relKql.append(" or ");
            relKql.append("(");
            relKql.append("t1.fToUnitID=? ");
            relKql.append(" and t2.fFromType=? ");
            relKql.append(" and t2.fToType=? ");
            relKql.append(" and t2.fExistReverseDelegate=1");
            relKql.append(")");
            IRowSet relRowSet = DbUtil.executeQuery((Context)ctx, (String)relKql.toString(), (Object[])new Object[]{orgUnitID, new Integer(orgType.getValue()), new Integer(2), orgUnitID, new Integer(2), new Integer(orgType.getValue())});
            if (relRowSet != null && relRowSet.size() > 0) {
                try {
                    while (relRowSet.next()) {
                        String fFromUnitID = relRowSet.getString("fFromUnitID");
                        String fToUnitID = relRowSet.getString("fToUnitID");
                        if (!StringUtils.isEmpty((String)fFromUnitID) && !orgUnitID.equals(fFromUnitID)) {
                            if (rsLst.contains(fFromUnitID) || !StringUtils.isEmpty((String)materialID) && !mSlsLst.contains(fFromUnitID)) continue;
                            rsLst.add(fFromUnitID);
                            continue;
                        }
                        if (orgUnitID.equals(fToUnitID) || rsLst.contains(fToUnitID) || !StringUtils.isEmpty((String)materialID) && !mSlsLst.contains(fToUnitID)) continue;
                        rsLst.add(fToUnitID);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            Map authSlsMap = null;
            if (rsLst != null && !rsLst.isEmpty()) {
                authSlsMap = this.checkFunctionPermission(ctx, ctx.getCaller(), rsLst, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.scm.sd.sale.client.SaleOrderListUI"), (IMetaDataPK)new MetaDataPK("ActionView"));
            }
            Set set = keySet = authSlsMap == null ? null : authSlsMap.keySet();
            if (keySet != null && !keySet.isEmpty()) {
                Iterator it = rsLst.iterator();
                while (it.hasNext()) {
                    String tmpID = it.next().toString();
                    if (!keySet.contains(tmpID)) continue;
                    it.remove();
                }
            }
            if (rsLst != null && !rsLst.isEmpty()) {
                retVal = new String[rsLst.size()];
                for (int i = 0; i < rsLst.size(); ++i) {
                    retVal[i] = rsLst.get(i).toString();
                }
            }
        }
        return retVal;
    }

    private Map checkFunctionPermission(Context ctx, IObjectPK userPK, List orgPKs, IMetaDataPK uiMedataPK, IMetaDataPK actionPK) throws BOSException {
        HashMap<String, Exception> result = new HashMap<String, Exception>();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        int size = orgPKs.size();
        for (int i = 0; i < size; ++i) {
            String orgId = (String)orgPKs.get(i);
            try {
                iPermission.checkFunctionPermission(userPK, (IObjectPK)new ObjectUuidPK(orgId), uiMedataPK, actionPK);
                continue;
            }
            catch (Exception e) {
                result.put(orgId, e);
            }
        }
        return result;
    }

    @Override
    protected ProductionOrderF7Objects _getInitF7Objects(Context ctx, IObjectValue materialInfo, IObjectValue measureUnitInfo, IObjectValue storageOrgInfo) throws BOSException, EASBizException {
        ProductionOrderF7Objects pos = new ProductionOrderF7Objects();
        MultiMeasureUnitInfo measureUnit = null;
        String[] slsIds = null;
        MaterialInventoryInfo materialInventory = null;
        if (materialInfo != null && measureUnitInfo != null) {
            measureUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(((MaterialInfo)materialInfo).getId().toString(), ((MeasureUnitInfo)measureUnitInfo).getId().toString());
        }
        if (materialInfo != null && storageOrgInfo != null) {
            slsIds = this._getAuthorizedSlsOrgIDs(ctx, ((MaterialInfo)materialInfo).getId().toString(), ((StorageOrgUnitInfo)storageOrgInfo).getId().toString());
        }
        if (materialInfo != null && storageOrgInfo != null) {
            materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(((MaterialInfo)materialInfo).getId().toString(), ((StorageOrgUnitInfo)storageOrgInfo).getId().toString());
        }
        pos.setMultimeasureUnitInfo(measureUnit);
        pos.setSlsIds(slsIds);
        pos.setMaterialInventory(materialInventory);
        return pos;
    }

    @Override
    protected String _getPickLeadTime(Context ctx, String formulaId, String parentMaterialId, String materialId, String lineWPId, int consumeType) throws BOSException, EASBizException {
        boolean verifyVal;
        if (!(StringUtils.isEmpty((String)parentMaterialId) || StringUtils.isEmpty((String)materialId) || consumeType != 30 || (verifyVal = this.getChildMaterialIdNoSameGroupWithParent(ctx, materialId, parentMaterialId)))) {
            return "false";
        }
        if (!(StringUtils.isEmpty((String)formulaId) || StringUtils.isEmpty((String)materialId) || StringUtils.isEmpty((String)lineWPId))) {
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            sql.append(" e.FPickingLeadTime FPickingLeadTime ");
            sql.append(" from ");
            sql.append("T_MM_ProductionFormulaEntry as e ");
            sql.append(" inner join T_MM_ProductionFormula as f on f.fid=e.fParentID ");
            sql.append(" where ");
            sql.append(" f.fid = ? ");
            sql.append(" and e.fmaterialid = ? ");
            sql.append(" and e.FProductLineWPID = ? ");
            sql.append(" and e.FProductType != ? ");
            sql.append(" and e.FProductType != ? ");
            sql.append(" and e.FPickingMode = ? ");
            int result = 0;
            boolean flag = false;
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{formulaId, materialId, lineWPId, new Integer(10720), new Integer(10730), new Integer(11010)});
                if (rs != null && rs.next()) {
                    flag = true;
                    result = rs.getInt("FPickingLeadTime");
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (flag) {
                return Integer.toString(result);
            }
        }
        return "";
    }

    private boolean getChildMaterialIdNoSameGroupWithParent(Context ctx, String paramIds, String parentMaterialId) throws BOSException {
        boolean retVal = true;
        String str = "";
        StringBuffer sb = new StringBuffer();
        sb.append("  select mmu.fmaterialid materialid,mug.fid materialgroupid ");
        sb.append("  from t_bd_measureunit mu,  t_bd_measureunitgroup mug, t_bd_multimeasureunit mmu ");
        sb.append("  where mu.fgroupid = mug.fid and mmu.fmeasureunitid = mu.fid and mmu.fisbasicunit = 1 ");
        sb.append("  and mmu.fmaterialid='");
        sb.append(paramIds);
        sb.append("'");
        sb.append("  and mug.fid != ( ");
        sb.append("    select mug.fid ");
        sb.append("    from t_bd_measureunit mu, t_bd_measureunitgroup mug,t_bd_multimeasureunit mmu ");
        sb.append("    where mu.fgroupid = mug.fid and mmu.fmeasureunitid = mu.fid and mmu.fisbasicunit = 1 ");
        sb.append("    and mmu.fmaterialid = '").append(parentMaterialId).append("') ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                str = rs.getString("materialid");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (!StringUtils.isEmpty((String)str)) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    protected Map _submitForPlan(Context ctx, ProductionOrderInfo model) throws BOSException, EASBizException {
        ProductionOrderInfo productionOrderInfo = model;
        productionOrderInfo.setMmBizType(BizTypeEnum.common);
        String storageOrgUnitId = productionOrderInfo.getStorageOrgUnit().getId().toString();
        String materialId = productionOrderInfo.getMaterial().getId().toString();
        String bomId = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select FBomInterID from T_MM_plannedorder where fid = '" + productionOrderInfo.getSourceBillId() + "'"), CompareType.INNER));
        ev.setFilter(filter);
        IBom ibom = BomFactory.getLocalInstance((Context)ctx);
        BomCollection bomCol = ibom.getBomCollection(ev);
        if (bomCol != null && bomCol.size() > 0) {
            BomInfo bomInfo = bomCol.get(0);
            productionOrderInfo.setBom(bomInfo);
            bomId = bomInfo.getId().toString();
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialId, productionOrderInfo.getUnit().getId().toString());
            MultiMeasureUnitInfo baseMultiUnifInfo = multiUnit.getMultiUnit(materialId, productionOrderInfo.getBaseUnit().getId().toString());
            BigDecimal expectQty = productionOrderInfo.getQty().multiply(bomInfo.getYield()).divide(new BigDecimal("100"), multiUnifInfo.getQtyPrecision(), 5);
            BigDecimal baseExpectQty = productionOrderInfo.getBaseQty().multiply(bomInfo.getYield()).divide(new BigDecimal("100"), baseMultiUnifInfo.getQtyPrecision(), 5);
            productionOrderInfo.setExpectOutputQty(expectQty);
            productionOrderInfo.setBaseExpectOutputQty(baseExpectQty);
        }
        StringBuffer sql_initProductLine = new StringBuffer();
        sql_initProductLine.append("select TOP 1 productLine.fid as id, productLine.FWorkshopID as wsId,mPlan.fid as mpId from T_MM_ProductLine as productLine");
        sql_initProductLine.append(" inner join T_BD_materialPlan as mPlan on mPlan.FProductLineID=productLine.fid");
        sql_initProductLine.append(" inner join T_BD_material as material on material.fid =mPlan.FMaterialId");
        sql_initProductLine.append(" where mPlan.fStatus=1 and mPlan.FOrgUnit='" + storageOrgUnitId + "'");
        sql_initProductLine.append(" and productLine.FStatus = 20 and material.fid = '" + materialId + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_initProductLine.toString());
        try {
            while (rowSet.next()) {
                MaterialPlanInfo mp = new MaterialPlanInfo();
                mp.setId(BOSUuid.read((String)rowSet.getString("mpId")));
                if (productionOrderInfo.getProductLine() == null) {
                    ProductLineInfo productLineInfo = new ProductLineInfo();
                    productLineInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                    productionOrderInfo.setProductLine(productLineInfo);
                    AdminOrgUnitInfo aou = new AdminOrgUnitInfo();
                    aou.setId(BOSUuid.read((String)rowSet.getString("wsId")));
                    productionOrderInfo.setWorkShop(aou);
                }
                productionOrderInfo.setMaterialPlan(mp);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            productionOrderInfo.setBizDate(sf.parse(sf.format(new Date())));
            Date startDate = productionOrderInfo.getStartDate();
            Date endDate = productionOrderInfo.getEndDate();
            try {
                List dateList = null;
                List dateList2 = null;
                if (productionOrderInfo.getProductLine() != null) {
                    dateList = this.getDeviceCalendarForPlan(ctx, storageOrgUnitId, productionOrderInfo.getProductLine().getId().toString(), startDate);
                    dateList2 = this.getDeviceCalendarForPlan(ctx, storageOrgUnitId, productionOrderInfo.getProductLine().getId().toString(), endDate);
                }
                if (dateList != null && dateList.size() == 2) {
                    productionOrderInfo.setStartDate((Date)dateList.get(0));
                } else {
                    productionOrderInfo.setStartDate(startDate);
                }
                if (dateList2 != null && dateList2.size() == 2) {
                    Date finishedDay = (Date)dateList2.get(1);
                    if (finishedDay != null && finishedDay.compareTo(endDate) == 1) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(endDate);
                        cal.set(11, 23);
                        cal.set(12, 59);
                        cal.set(13, 59);
                        productionOrderInfo.setEndDate(cal.getTime());
                    } else {
                        productionOrderInfo.setEndDate((Date)dateList2.get(1));
                    }
                } else {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(endDate);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    productionOrderInfo.setEndDate(cal.getTime());
                }
            }
            catch (ProductionOrderException e) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put(productionOrderInfo.getSourceBillId(), e.getMessage());
                return result;
            }
        }
        catch (ParseException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        productionOrderInfo.setExpectEndDate(productionOrderInfo.getEndDate());
        ProductLineWPEntryInfo pwpFirst = null;
        if (productionOrderInfo.getProductLine() != null && productionOrderInfo.getProductLine().getId() != null) {
            String productLineId = productionOrderInfo.getProductLine().getId().toString();
            StringBuffer sql_initProductLineWP = new StringBuffer();
            sql_initProductLineWP.append(" select productLineWPEntry.fid as id, ").append(" productLineWPEntry.FNumber as num, ").append(" productLineWPEntry.FIsWP as IsWP, ").append(" productLineWPEntry.FResourceID as ResourceID, ").append(" productLineWPEntry.FIsQCPoint as IsQCPoint, ").append(" productLineWPEntry.FPrepareTime as PrepareTime, ").append(" productLineWPEntry.FPrepTimeUnit as PrepTimeUnit, ").append(" productLineWPEntry.FWorkTime as WorkTime, ").append(" productLineWPEntry.FWorkTimeUnit as WorkTimeUnit, ").append(" productLineWPEntry.FWPDescription_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" as WPDescription ").append(" FROM T_MM_ProductLineWPEntry AS productLineWPEntry left join T_MM_ProductLineWP AS parent");
            sql_initProductLineWP.append(" on productLineWPEntry.FParentID = parent.fid left join T_MM_ProductLine AS productLine on parent.FProductLineID = productLine.fid");
            sql_initProductLineWP.append(" where parent.FStatus = 20 AND productLineWPEntry.FStatus = 10 and productLine.fid ='" + productLineId + "'");
            sql_initProductLineWP.append(" order by productLineWPEntry.FNumber");
            IRowSet rowSet3 = DbUtil.executeQuery((Context)ctx, (String)sql_initProductLineWP.toString());
            try {
                while (rowSet3.next()) {
                    String wpId = rowSet3.getString("id");
                    String wpNum = rowSet3.getString("num");
                    boolean iswp = rowSet3.getBoolean("IsWP");
                    String resourceID = rowSet3.getString("ResourceID");
                    boolean isQCPoint = rowSet3.getBoolean("IsQCPoint");
                    BigDecimal prepareTime = rowSet3.getBigDecimal("PrepareTime");
                    int prepTimeUnit = rowSet3.getInt("PrepTimeUnit");
                    BigDecimal workTime = rowSet3.getBigDecimal("WorkTime");
                    int workTimeUnit = rowSet3.getInt("WorkTimeUnit");
                    String wpDescription = rowSet3.getString("WPDescription");
                    ProductLineWPEntryInfo pwp = new ProductLineWPEntryInfo();
                    pwp.setId(BOSUuid.read((String)wpId));
                    ProductionOrderEntryInfo orderEntryInfo = new ProductionOrderEntryInfo();
                    orderEntryInfo.setPrdLineWPNumber(wpNum);
                    orderEntryInfo.setProductLineWP(pwp);
                    if (resourceID != null && resourceID.length() > 0) {
                        ResourceInfo resource = new ResourceInfo();
                        resource.setId(BOSUuid.read((String)resourceID));
                        orderEntryInfo.setResource(resource);
                    }
                    orderEntryInfo.setIsWP(iswp);
                    orderEntryInfo.setIsQCPoint(isQCPoint);
                    orderEntryInfo.setPrepareTime(prepareTime);
                    orderEntryInfo.setPrepTimeUnit(TimeUnitEnum.getEnum((int)prepTimeUnit));
                    orderEntryInfo.setWorkTime(workTime);
                    orderEntryInfo.setWorkTimeUnit(TimeUnitEnum.getEnum((int)workTimeUnit));
                    orderEntryInfo.setRemark(wpDescription);
                    productionOrderInfo.getWpEntry().add(orderEntryInfo);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (productionOrderInfo.getWpEntry().size() > 0) {
            pwpFirst = productionOrderInfo.getWpEntry().get(0).getProductLineWP();
        }
        ActionCommonException bizExp = null;
        IObjectPK pk = null;
        try {
            this._updateEntrysForBom(ctx, productionOrderInfo, bomId, pwpFirst);
        }
        catch (EASBizException e) {
            bizExp = new ActionCommonException(null);
            bizExp.setMessage(e.getMessage() + "\n");
        }
        try {
            this.checkPrdOrderSubmitForPlan(ctx, (IObjectValue)model);
        }
        catch (ActionCommonException e) {
            if (bizExp != null) {
                bizExp.setMessage(bizExp.getMessage() + e.getMessage());
            }
            bizExp = e;
        }
        try {
            this.checkPrdOrderEntrySubmitForPlan(ctx, (IObjectValue)model);
        }
        catch (ActionCommonException e) {
            if (bizExp != null) {
                bizExp.setMessage(bizExp.getMessage() + e.getMessage());
            }
            bizExp = e;
        }
        if (bizExp != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(productionOrderInfo.getSourceBillId(), bizExp.getMessage());
            return result;
        }
        pk = super._submit(ctx, (IObjectValue)model);
        if (pk != null) {
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcObjectID(productionOrderInfo.getSourceBillId());
            info.setSrcEntityID("B844D41F");
            info.setDestEntityID("1F66774E");
            info.setDestObjectID(pk.getKeyValue(null).toString());
            info.setOperatorID(ctx.getUserName());
            info.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
        }
        return null;
    }

    protected void buildEntrysForBom(Context ctx, ProductionOrderInfo productionOrderInfo, ProductLineWPEntryInfo pwp) throws BOSException, EASBizException {
        int i;
        ArrayList stockList = new ArrayList();
        ArrayList outputList = new ArrayList();
        Date startDate = productionOrderInfo.getStartDate();
        Date endDate = productionOrderInfo.getEndDate();
        BigDecimal baseQty = productionOrderInfo.getBaseQty();
        BigDecimal qty = productionOrderInfo.getQty();
        productionOrderInfo.getStockEntry().clear();
        productionOrderInfo.getOutputEntry().clear();
        if (productionOrderInfo.getBom() != null) {
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            HashMap unitCatch = new HashMap();
            BomInfo bomInfo = productionOrderInfo.getBom();
            this.bomExtend(bomInfo, productionOrderInfo.getTrackNumber(), productionOrderInfo.getMaterial().getId().toString(), "", baseQty, qty, baseQty, bomInfo.getProductBaseQty(), bomInfo.getProductQty(), pwp, startDate, endDate, stockList, outputList, productionOrderInfo.getStorageOrgUnit(), multiUnit, 0, unitCatch, ctx);
        }
        List copyStockList = this.clearRepetitionStock(stockList, productionOrderInfo);
        productionOrderInfo.getStockEntry().clear();
        productionOrderInfo.getOutputEntry().clear();
        for (i = 0; i < copyStockList.size(); ++i) {
            ProductionOrderStockEntryInfo stockEntry = (ProductionOrderStockEntryInfo)copyStockList.get(i);
            stockEntry.setLineSeq(i + 1 + AUDIT_GEN);
            productionOrderInfo.getStockEntry().add(stockEntry);
        }
        for (i = 0; i < outputList.size(); ++i) {
            ProductionOrderOutputEntryInfo outputEnty = (ProductionOrderOutputEntryInfo)outputList.get(i);
            productionOrderInfo.getOutputEntry().add(outputEnty);
        }
    }

    private void updateOldStockInfoMethed(Context ctx, ProductionOrderInfo productionOrderInfo, ProductLineWPEntryInfo pwp, Date startDate, Date endDate, ProductionOrderStockEntryCollection stockEntryColls, Map entryMapping) throws BOSException, EASBizException {
        HashMap<String, MultiMeasureUnitInfo> unitCatch = new HashMap<String, MultiMeasureUnitInfo>();
        StringBuffer sql_initUnit = new StringBuffer();
        sql_initUnit.append("select fqtyPrecision as pre,FBaseConvsRate as rate, fMaterialid,fMeasureUnitID from t_bd_multiMeasureUnit where");
        for (int i = 0; i < stockEntryColls.size(); ++i) {
            ProductionOrderStockEntryInfo entryInfo = stockEntryColls.get(i);
            sql_initUnit.append(" (fMaterialid ='" + entryInfo.getMaterial().getId().toString() + "' and fMeasureUnitID = '" + entryInfo.getUnit().getId().toString() + "')");
            sql_initUnit.append(" or (fMaterialid ='" + entryInfo.getMaterial().getId().toString() + "' and fMeasureUnitID = '" + entryInfo.getBaseUnit().getId().toString() + "')");
            if (i == stockEntryColls.size() - 1) continue;
            sql_initUnit.append(" or");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_initUnit.toString());
        try {
            while (rowSet.next()) {
                int precision = rowSet.getInt("pre");
                BigDecimal rate = rowSet.getBigDecimal("rate");
                String materialId = rowSet.getString("fMaterialid");
                String fMeasureUnitID = rowSet.getString("fMeasureUnitID");
                String key = materialId + fMeasureUnitID;
                MultiMeasureUnitInfo multiBaseUnifInfo = new MultiMeasureUnitInfo();
                multiBaseUnifInfo.setQtyPrecision(precision);
                multiBaseUnifInfo.setBaseConvsRate(rate);
                if (unitCatch.containsKey(key)) continue;
                unitCatch.put(key, multiBaseUnifInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ProductionOrderInfo clone = (ProductionOrderInfo)productionOrderInfo.clone();
        if (entryMapping.keySet().size() == 0) {
            this._buildEntrys(ctx, clone);
            ProductionOrderStockEntryCollection entrys = clone.getStockEntry();
            ProductionOrderStockEntryInfo tempEntryInfo = null;
            for (int i = 0; i < entrys.size(); ++i) {
                tempEntryInfo = entrys.get(i);
                entryMapping.put(tempEntryInfo.getMaterial().getId().toString(), tempEntryInfo);
            }
        }
        for (int i = 0; i < stockEntryColls.size(); ++i) {
            ProductionOrderStockEntryInfo entryInfo = stockEntryColls.get(i);
            entryInfo.setStartDate(startDate);
            entryInfo.setEndDate(endDate);
            entryInfo.setBaseSendOutTotalQty(new BigDecimal(0.0));
            entryInfo.setSendOutTotalQty(new BigDecimal(0.0));
            entryInfo.setUntreadTotalQty(new BigDecimal(0.0));
            entryInfo.setBaseUntreadTotalQty(new BigDecimal(0.0));
            entryInfo.setProductLineWP(pwp);
            MultiMeasureUnitInfo multiUnitInfo = (MultiMeasureUnitInfo)unitCatch.get(entryInfo.getMaterial().getId().toString() + entryInfo.getUnit().getId().toString());
            int precision = multiUnitInfo.getQtyPrecision();
            BigDecimal rate = multiUnitInfo.getBaseConvsRate();
            MultiMeasureUnitInfo baseMultiUnitInfo = (MultiMeasureUnitInfo)unitCatch.get(entryInfo.getMaterial().getId().toString() + entryInfo.getBaseUnit().getId().toString());
            int basePrecision = baseMultiUnitInfo.getQtyPrecision();
            entryInfo.put("multiUnit", multiUnitInfo);
            entryInfo.put("baseMultiUnit", baseMultiUnitInfo);
            BigDecimal qty = entryInfo.getQty().divide(new BigDecimal(1), precision, 4);
            if (qty.doubleValue() == 0.0) {
                qty = entryInfo.getQty().divide(new BigDecimal(1), precision, 0);
            }
            entryInfo.setQty(qty);
            entryInfo.setOrigialQty(qty);
            entryInfo.setStandardQty(qty);
            BigDecimal baseQty = qty.multiply(rate).setScale(basePrecision, 4);
            entryInfo.setBaseQty(baseQty);
            entryInfo.put("baseStandardQty", baseQty);
            MaterialInventoryInfo materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(entryInfo.getMaterial().getId().toString(), productionOrderInfo.getStorageOrgUnit().getId().toString());
            if (entryMapping.get(entryInfo.getMaterial().getId().toString()) != null) {
                ProductionOrderStockEntryInfo bomExtendRela = (ProductionOrderStockEntryInfo)entryMapping.get(entryInfo.getMaterial().getId().toString());
                entryInfo.setMaterialInventory(bomExtendRela.getMaterialInventory());
                entryInfo.setMaterialChar(bomExtendRela.getMaterialChar());
                entryInfo.setModel(bomExtendRela.getMaterial().getModel());
                entryInfo.setProportion(bomExtendRela.getProportion());
                entryInfo.setBaseConsumeFixQty(bomExtendRela.getBaseConsumeFixQty() == null ? new BigDecimal(0.0) : bomExtendRela.getBaseConsumeFixQty());
                entryInfo.setConsumeFixQty(bomExtendRela.getConsumeFixQty());
                entryInfo.setConsumeType(bomExtendRela.getConsumeType());
                entryInfo.setRemark(bomExtendRela.getRemark());
                if (entryInfo.getDefaultWarehouse() == null) {
                    entryInfo.setDefaultWarehouse(bomExtendRela.getDefaultWarehouse());
                }
                if (entryInfo.getLocation() == null) {
                    entryInfo.setLocation(bomExtendRela.getLocation());
                }
                if (entryInfo.isIsStock()) {
                    if (entryInfo.getMoveOutWarehouse() == null) {
                        entryInfo.setMoveOutWarehouse(bomExtendRela.getMoveOutWarehouse());
                    }
                    if (entryInfo.getMoveOutStorageOrgUnit() == null) {
                        entryInfo.setMoveOutStorageOrgUnit(bomExtendRela.getMoveOutStorageOrgUnit());
                    }
                }
            } else {
                MaterialPlanInfo materialPlanInfo = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanInfo("select * where material='" + entryInfo.getMaterial().getId().toString() + "' and OrgUnit='" + productionOrderInfo.getStorageOrgUnit().getId().toString() + "'");
                if (entryInfo.getDefaultWarehouse() == null) {
                    entryInfo.setDefaultWarehouse(materialInventory.getDefaultWarehouse());
                }
                if (entryInfo.isIsStock()) {
                    if (entryInfo.getMoveOutWarehouse() == null) {
                        entryInfo.setMoveOutWarehouse(materialPlanInfo.getFromWarehouse());
                    }
                    if (entryInfo.getMoveOutStorageOrgUnit() == null) {
                        entryInfo.setMoveOutStorageOrgUnit(materialPlanInfo.getFromInvOrg());
                    }
                }
                entryInfo.setConsumeType(ConsumeTypeEnum.VariableAmount);
                entryInfo.setProportion(new BigDecimal(AUDIT_GEN));
                BigDecimal bomParentBaseQty = productionOrderInfo.getBom().getProductBaseQty();
                BigDecimal bomParentQty = productionOrderInfo.getBom().getProductQty();
                double tempBaseQty = 0.0;
                double tempQty = 0.0;
                MaterialScrapRateExpressionEnum scrapRateExpression = materialPlanInfo.getScrapRateExpression();
                double scrapRate = materialPlanInfo.getScrapRate() == null ? 0.0 : materialPlanInfo.getScrapRate().doubleValue() / 100.0;
                double One = 1.0;
                if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                    tempBaseQty = entryInfo.getBaseQty().doubleValue() * (One - scrapRate);
                    tempQty = entryInfo.getQty().doubleValue() * (One - scrapRate);
                } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                    tempBaseQty = entryInfo.getBaseQty().doubleValue() / (One + scrapRate);
                    tempQty = entryInfo.getQty().doubleValue() / (One + scrapRate);
                }
                BigDecimal baseConsumeFixQty = new BigDecimal(tempBaseQty / productionOrderInfo.getBaseQty().doubleValue() * bomParentBaseQty.doubleValue()).setScale(basePrecision, 4);
                BigDecimal consumeFixQty = new BigDecimal(tempQty / productionOrderInfo.getQty().doubleValue() * bomParentQty.doubleValue()).setScale(precision, 4);
                entryInfo.setBaseConsumeFixQty(baseConsumeFixQty);
                entryInfo.setConsumeFixQty(consumeFixQty);
            }
            entryInfo.setLineSeq(i + 1 + AUDIT_GEN);
        }
    }

    private void updateNewStockInfoMethod(Context ctx, ProductionOrderInfo productionOrderInfo, ProductLineWPEntryInfo pwp, Date startDate, Date endDate, EntityViewInfo bomViewInfo, BomEntryCollection coll, ProductionOrderStockEntryCollection stockEntryColls) throws BOSException, EASBizException {
        HashMap<String, BomEntryInfo> firstLevel = new HashMap<String, BomEntryInfo>();
        HashMap<String, BomEntryInfo> allLevel = new HashMap<String, BomEntryInfo>();
        ArrayList<String> FirstLevelIds = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            BomEntryInfo bomEntryInfo = coll.get(i);
            if (MaterialProductEnum.RELATEDPRODUCT.equals((Object)bomEntryInfo.getOutputType()) || MaterialProductEnum.BYPRODUCT.equals((Object)bomEntryInfo.getOutputType()) || !MaterialIssueModeEnum.PRODUCEISSMODE.equals((Object)bomEntryInfo.getIssMode()) && !MaterialIssueModeEnum.STRAIGHT.equals((Object)bomEntryInfo.getIssMode()) && !MaterialIssueModeEnum.NOTISSMODE.equals((Object)bomEntryInfo.getIssMode())) continue;
            String id = bomEntryInfo.getId().toString();
            FirstLevelIds.add(id);
            firstLevel.put(id, bomEntryInfo);
        }
        HashSet<String> setId = new HashSet<String>();
        for (int i = 0; i < stockEntryColls.size(); ++i) {
            ProductionOrderStockEntryInfo entryInfo = stockEntryColls.get(i);
            String sourceEntryId = entryInfo.getSourceBillEntryId();
            if (sourceEntryId == null || FirstLevelIds.indexOf(sourceEntryId) >= 0) continue;
            setId.add(sourceEntryId.toString());
        }
        FilterInfo bomFilterInfo2 = new FilterInfo();
        bomFilterInfo2.getFilterItems().add(new FilterItemInfo("id", setId, CompareType.INCLUDE));
        EntityViewInfo bomViewInfo2 = new EntityViewInfo();
        bomViewInfo2.setSelector(bomViewInfo.getSelector());
        bomViewInfo2.setFilter(bomFilterInfo2);
        BomEntryCollection coll2 = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryCollection(bomViewInfo2);
        for (int i = 0; i < coll2.size(); ++i) {
            BomEntryInfo bomEntryInfo = coll2.get(i);
            String id = bomEntryInfo.getId().toString();
            allLevel.put(id, bomEntryInfo);
        }
        HashMap<String, MultiMeasureUnitInfo> unitCatch = new HashMap<String, MultiMeasureUnitInfo>();
        StringBuffer sql_initUnit = new StringBuffer();
        sql_initUnit.append("select fqtyPrecision as pre,FBaseConvsRate as rate, fMaterialid,fMeasureUnitID from t_bd_multiMeasureUnit where");
        for (int i = 0; i < stockEntryColls.size(); ++i) {
            ProductionOrderStockEntryInfo entryInfo = stockEntryColls.get(i);
            sql_initUnit.append(" (fMaterialid ='" + entryInfo.getMaterial().getId().toString() + "' and fMeasureUnitID = '" + entryInfo.getUnit().getId().toString() + "')");
            sql_initUnit.append(" or (fMaterialid ='" + entryInfo.getMaterial().getId().toString() + "' and fMeasureUnitID = '" + entryInfo.getBaseUnit().getId().toString() + "')");
            if (i == stockEntryColls.size() - 1) continue;
            sql_initUnit.append(" or");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_initUnit.toString());
        try {
            while (rowSet.next()) {
                int precision = rowSet.getInt("pre");
                BigDecimal rate = rowSet.getBigDecimal("rate");
                String materialId = rowSet.getString("fMaterialid");
                String fMeasureUnitID = rowSet.getString("fMeasureUnitID");
                String key = materialId + fMeasureUnitID;
                MultiMeasureUnitInfo multiBaseUnifInfo = new MultiMeasureUnitInfo();
                multiBaseUnifInfo.setQtyPrecision(precision);
                multiBaseUnifInfo.setBaseConvsRate(rate);
                if (unitCatch.containsKey(key)) continue;
                unitCatch.put(key, multiBaseUnifInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        double One = 1.0;
        for (int i = 0; i < stockEntryColls.size(); ++i) {
            ProductionOrderStockEntryInfo entryInfo = stockEntryColls.get(i);
            entryInfo.setStartDate(startDate);
            entryInfo.setEndDate(endDate);
            entryInfo.setBaseSendOutTotalQty(new BigDecimal(0.0));
            entryInfo.setSendOutTotalQty(new BigDecimal(0.0));
            entryInfo.setUntreadTotalQty(new BigDecimal(0.0));
            entryInfo.setBaseUntreadTotalQty(new BigDecimal(0.0));
            entryInfo.setProductLineWP(pwp);
            entryInfo.setLineSeq(i + 1 + AUDIT_GEN);
            MultiMeasureUnitInfo multiUnitInfo = (MultiMeasureUnitInfo)unitCatch.get(entryInfo.getMaterial().getId().toString() + entryInfo.getUnit().getId().toString());
            int precision = multiUnitInfo.getQtyPrecision();
            BigDecimal rate = multiUnitInfo.getBaseConvsRate();
            MultiMeasureUnitInfo baseMultiUnitInfo = (MultiMeasureUnitInfo)unitCatch.get(entryInfo.getMaterial().getId().toString() + entryInfo.getBaseUnit().getId().toString());
            int basePrecision = baseMultiUnitInfo.getQtyPrecision();
            entryInfo.put("multiUnit", multiUnitInfo);
            entryInfo.put("baseMultiUnit", baseMultiUnitInfo);
            BigDecimal qty = entryInfo.getQty().divide(new BigDecimal(1), precision, 4);
            if (qty.doubleValue() == 0.0) {
                qty = entryInfo.getQty().divide(new BigDecimal(1), precision, 0);
            }
            entryInfo.setQty(qty);
            entryInfo.setOrigialQty(qty);
            BigDecimal baseQty = qty.multiply(rate).setScale(basePrecision, 4);
            entryInfo.setBaseQty(baseQty);
            String key = entryInfo.getSourceBillEntryId().toString();
            BomEntryInfo bomEntryInfo = null;
            if (firstLevel.containsKey(key)) {
                bomEntryInfo = (BomEntryInfo)firstLevel.get(key);
                entryInfo.setConsumeType(bomEntryInfo.getConsumeType());
                entryInfo.setProportion(bomEntryInfo.getProportion());
                entryInfo.setBaseConsumeFixQty(bomEntryInfo.getConsumeFixBaseQty() == null ? new BigDecimal(0.0) : bomEntryInfo.getConsumeFixBaseQty());
                entryInfo.setConsumeFixQty(bomEntryInfo.getConsumeFixQty());
            } else {
                BigDecimal bomParentBaseQty = productionOrderInfo.getBom().getProductBaseQty();
                BigDecimal bomParentQty = productionOrderInfo.getBom().getProductQty();
                bomEntryInfo = (BomEntryInfo)allLevel.get(key);
                double scrapRateC = bomEntryInfo.getMaterialInventory().getScrapRate().doubleValue() / 100.0;
                MaterialScrapRateExpressionEnum scrapRateExpression = bomEntryInfo.getMaterialInventory().getScrapRateExpression();
                double tempQtyC = entryInfo.getQty().doubleValue();
                double tempBaseQtyC = entryInfo.getBaseQty().doubleValue();
                if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                    tempQtyC *= One - scrapRateC;
                    tempBaseQtyC *= One - scrapRateC;
                } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                    tempQtyC /= One + scrapRateC;
                    tempBaseQtyC /= One + scrapRateC;
                }
                entryInfo.setConsumeType(ConsumeTypeEnum.VariableAmount);
                BigDecimal consumeFixQty = new BigDecimal(tempQtyC / productionOrderInfo.getQty().doubleValue() * bomParentQty.doubleValue()).setScale(precision, 4);
                BigDecimal baseConsumeFixQty = new BigDecimal(tempBaseQtyC / productionOrderInfo.getBaseQty().doubleValue() * bomParentBaseQty.doubleValue()).setScale(basePrecision, 4);
                entryInfo.setConsumeFixQty(consumeFixQty);
                entryInfo.setBaseConsumeFixQty(baseConsumeFixQty);
            }
            this.updateStockEntryByBomEntry(ctx, entryInfo, bomEntryInfo, productionOrderInfo.getStorageOrgUnit());
        }
    }

    private void bomExtend(BomInfo bomInfo, TrackNumberInfo track, String parentMaterialId, String path, BigDecimal baseQty, BigDecimal billQty, BigDecimal billBaseQty, BigDecimal bomParentBaseQty, BigDecimal bomParentQty, ProductLineWPEntryInfo pwp, Date startDate, Date endDate, List stockList, List outputList, StorageOrgUnitInfo sou, IMultiMeasureUnit multiUnit, int deep, Map unitCatch, Context ctx) throws BOSException, EASBizException {
        if (outputList == null) {
            ++deep;
        }
        if (deep == 0) {
            path = parentMaterialId;
        }
        if (deep >= 9) {
            return;
        }
        FilterInfo bomFilterInfo = new FilterInfo();
        bomFilterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)bomInfo.getId().toString(), CompareType.EQUALS));
        bomFilterInfo.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)startDate, CompareType.LESS_EQUALS));
        bomFilterInfo.getFilterItems().add(new FilterItemInfo("disableDate", (Object)startDate, CompareType.GREATER));
        EntityViewInfo bomViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = this.getBomEntrySelector();
        bomViewInfo.setSelector(sic);
        bomViewInfo.setFilter(bomFilterInfo);
        bomViewInfo.getSorter().add(new SorterItemInfo("material.number"));
        BomEntryCollection coll = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryCollection(bomViewInfo);
        if (coll != null && !coll.isEmpty()) {
            String mId;
            int i;
            StringBuffer sql_initUnit = new StringBuffer();
            ArrayList<String> co1 = new ArrayList<String>();
            ArrayList<String> co2 = new ArrayList<String>();
            for (i = 0; i < coll.size(); ++i) {
                BomEntryInfo bomEntryInfo = coll.get(i);
                if ((MaterialProductEnum.RELATEDPRODUCT.equals((Object)bomEntryInfo.getOutputType()) || MaterialProductEnum.BYPRODUCT.equals((Object)bomEntryInfo.getOutputType()) || !MaterialIssueModeEnum.PRODUCEISSMODE.equals((Object)bomEntryInfo.getIssMode()) && !MaterialIssueModeEnum.STRAIGHT.equals((Object)bomEntryInfo.getIssMode()) && !MaterialIssueModeEnum.NOTISSMODE.equals((Object)bomEntryInfo.getIssMode())) && (outputList == null || !MaterialProductEnum.RELATEDPRODUCT.equals((Object)bomEntryInfo.getOutputType()) && !MaterialProductEnum.BYPRODUCT.equals((Object)bomEntryInfo.getOutputType()))) continue;
                bomInfo.getEntrys().add(bomEntryInfo);
                mId = bomEntryInfo.getMaterial().getId().toString();
                String buId = bomEntryInfo.getBaseUnit().getId().toString();
                String uId = bomEntryInfo.getUnit().getId().toString();
                String key1 = mId + buId;
                String key2 = mId + uId;
                if (!unitCatch.containsKey(key1)) {
                    co1.add(mId);
                    co2.add(buId);
                }
                if (unitCatch.containsKey(key2)) continue;
                co1.add(mId);
                co2.add(uId);
            }
            if (co1.size() > 0) {
                sql_initUnit.append("select FBaseConvsRate as rate, fqtyPrecision as pre,fMaterialid,fMeasureUnitID from t_bd_multiMeasureUnit where");
                int j = co1.size() - 1;
                for (i = 0; i <= j; ++i) {
                    mId = (String)co1.get(i);
                    String uId = (String)co2.get(i);
                    sql_initUnit.append(" (fMaterialid ='" + mId + "' and fMeasureUnitID = '" + uId + "')");
                    if (i == co1.size() - 1) continue;
                    sql_initUnit.append(" or");
                }
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_initUnit.toString());
                try {
                    while (rowSet.next()) {
                        int precision = rowSet.getInt("pre");
                        BigDecimal rate = rowSet.getBigDecimal("rate");
                        String materialId = rowSet.getString("fMaterialid");
                        String fMeasureUnitID = rowSet.getString("fMeasureUnitID");
                        String key = materialId + fMeasureUnitID;
                        MultiMeasureUnitInfo multiBaseUnifInfo = new MultiMeasureUnitInfo();
                        multiBaseUnifInfo.setQtyPrecision(precision);
                        multiBaseUnifInfo.setBaseConvsRate(rate);
                        unitCatch.put(key, multiBaseUnifInfo);
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            for (i = 0; i < coll.size(); ++i) {
                double tempQty;
                MultiMeasureUnitInfo multiBaseUnifInfo;
                int precision;
                SCMBillEntryBaseInfo entryInfo;
                MaterialIssueModeEnum issMode;
                double parentBaseQty;
                BomEntryInfo bomEntryInfo = coll.get(i);
                if (startDate != null && bomEntryInfo.getDisableDate() != null && startDate.after(bomEntryInfo.getDisableDate()) || endDate != null && bomEntryInfo.getEffectiveDate() != null && endDate.before(bomEntryInfo.getEffectiveDate())) continue;
                double d = parentBaseQty = bomEntryInfo.getParent().getProductBaseQty() == null ? 1.0 : bomEntryInfo.getParent().getProductBaseQty().doubleValue();
                if (parentBaseQty == 0.0) {
                    StringBuffer errBuff = new StringBuffer();
                    errBuff.append(this.getResourceMsg2("FormulaHasError", ctx) + "\n");
                    ActionCommonException bizExp = new ActionCommonException(null);
                    bizExp.setMessage(errBuff.toString());
                    throw bizExp;
                }
                ConsumeTypeEnum consumeType = bomEntryInfo.getConsumeType() == null ? ConsumeTypeEnum.VariableAmount : bomEntryInfo.getConsumeType();
                double consumeFixBaseQty = bomEntryInfo.getConsumeFixBaseQty() == null ? 0.0 : bomEntryInfo.getConsumeFixBaseQty().doubleValue();
                double proportion = bomEntryInfo.getProportion() == null ? 0.0 : bomEntryInfo.getProportion().doubleValue() / 100.0;
                double yield = bomEntryInfo.getParent().getYield() == null ? 1.0 : bomEntryInfo.getParent().getYield().doubleValue() / 100.0;
                double scrapRate = bomEntryInfo.getScrapRatio().doubleValue() / 100.0;
                double scrapRateC = bomEntryInfo.getMaterialInventory().getScrapRate().doubleValue() / 100.0;
                MaterialScrapRateExpressionEnum scrapRateExpression = bomEntryInfo.getMaterialInventory() == null || bomEntryInfo.getMaterialInventory().getScrapRateExpression() == null ? null : bomEntryInfo.getMaterialInventory().getScrapRateExpression();
                double One = 1.0;
                MaterialIssueModeEnum materialIssueModeEnum = issMode = bomEntryInfo.getIssMode() == null ? bomEntryInfo.getMaterialInventory().getIssMode() : bomEntryInfo.getIssMode();
                if (!MaterialProductEnum.RELATEDPRODUCT.equals((Object)bomEntryInfo.getOutputType()) && !MaterialProductEnum.BYPRODUCT.equals((Object)bomEntryInfo.getOutputType()) && (MaterialIssueModeEnum.PRODUCEISSMODE.equals((Object)issMode) || MaterialIssueModeEnum.STRAIGHT.equals((Object)issMode) || MaterialIssueModeEnum.NOTISSMODE.equals((Object)issMode))) {
                    entryInfo = new ProductionOrderStockEntryInfo();
                    precision = bomEntryInfo.getBaseUnit() == null || bomEntryInfo.getBaseUnit().getQtyPrecision() < 1 ? 0 : bomEntryInfo.getBaseUnit().getQtyPrecision();
                    multiBaseUnifInfo = (MultiMeasureUnitInfo)unitCatch.get(bomEntryInfo.getMaterial().getId().toString() + bomEntryInfo.getBaseUnit().getId().toString());
                    if (multiBaseUnifInfo != null) {
                        precision = multiBaseUnifInfo.getQtyPrecision() < 1 ? 0 : multiBaseUnifInfo.getQtyPrecision();
                    }
                    double tempStandardQty = 0.0;
                    if (ConsumeTypeEnum.VariableAmount.equals((Object)consumeType)) {
                        double tempQty2;
                        tempStandardQty = tempQty2 = baseQty.doubleValue() / parentBaseQty * consumeFixBaseQty;
                        if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                            tempQty2 /= One - scrapRate;
                        } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                            tempQty2 *= One + scrapRate;
                        }
                        entryInfo.setBaseQty(new BigDecimal(tempQty2).divide(new BigDecimal(1.0), precision, 4));
                    } else if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                        double tempQty3;
                        tempStandardQty = tempQty3 = baseQty.doubleValue() * proportion;
                        if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                            tempQty3 /= One - scrapRate;
                        } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                            tempQty3 *= One + scrapRate;
                        }
                        double parentCoef = bomEntryInfo.getParent().getBaseUnit().getCoefficient().doubleValue();
                        double childCoef = bomEntryInfo.getBaseUnit().getCoefficient().doubleValue();
                        double baseExchangeRate = new BigDecimal(1).doubleValue();
                        if (parentCoef != childCoef) {
                            baseExchangeRate = parentCoef / childCoef;
                        }
                        entryInfo.setBaseQty(new BigDecimal(tempQty3 * baseExchangeRate).setScale(precision, 4));
                        tempStandardQty *= baseExchangeRate;
                    }
                    if (MaterialAttributeEnum.PHANTOMPART == bomEntryInfo.getMaterialInventory().getMaterialAttr()) {
                        if (path.indexOf(bomEntryInfo.getMaterial().getId().toString()) >= 0) continue;
                        String nextPath = path + bomEntryInfo.getMaterial().getId().toString();
                        BomInfo subBomInfo = ProductionFormulaHelper.getDefaultBOM((Context)ctx, (Object)bomEntryInfo.getMaterialInventory(), (Object)bomEntryInfo.getMaterial(), null, (Object)track, (Object)sou);
                        if (subBomInfo == null) continue;
                        this.bomExtend(subBomInfo, track, parentMaterialId, nextPath, entryInfo.getBaseQty(), billQty, billBaseQty, bomParentBaseQty, bomParentQty, pwp, startDate, endDate, stockList, null, sou, multiUnit, deep, unitCatch, ctx);
                        continue;
                    }
                    MultiMeasureUnitInfo multiOtherUnifInfo = (MultiMeasureUnitInfo)unitCatch.get(bomEntryInfo.getMaterial().getId().toString() + bomEntryInfo.getUnit().getId().toString());
                    try {
                        if (entryInfo.getBaseQty() != null) {
                            BigDecimal baseExchangeRate1 = multiBaseUnifInfo.getBaseConvsRate();
                            BigDecimal baseExchangeRate2 = multiOtherUnifInfo.getBaseConvsRate();
                            if (baseExchangeRate1 == null) {
                                baseExchangeRate1 = new BigDecimal("1.00");
                            }
                            if (baseExchangeRate2 == null) {
                                baseExchangeRate2 = new BigDecimal("1.00");
                            }
                            BigDecimal targetQty = entryInfo.getBaseQty().divide(baseExchangeRate2, multiOtherUnifInfo.getQtyPrecision(), 4);
                            entryInfo.setQty(targetQty);
                            entryInfo.setStandardQty(new BigDecimal(tempStandardQty).setScale(precision, 4).divide(baseExchangeRate2, multiOtherUnifInfo.getQtyPrecision(), 4));
                            entryInfo.put("multiUnit", (Object)multiOtherUnifInfo);
                            entryInfo.put("baseMultiUnit", (Object)multiBaseUnifInfo);
                            entryInfo.put("baseStandardQty", (Object)new BigDecimal(tempStandardQty).setScale(precision, 4));
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    entryInfo.setIsStock(bomEntryInfo.isIsStockTransfer());
                    entryInfo.setIsBackFlush(bomEntryInfo.isIsBackFlush());
                    this.updateStockEntryByBomEntry(ctx, (ProductionOrderStockEntryInfo)entryInfo, bomEntryInfo, sou);
                    entryInfo.setProductLineWP(pwp);
                    entryInfo.setStartDate(startDate);
                    entryInfo.setEndDate(endDate);
                    if (outputList == null) {
                        entryInfo.setConsumeType(ConsumeTypeEnum.VariableAmount);
                        double tempQtyC = entryInfo.getQty().doubleValue();
                        double tempBaseQtyC = entryInfo.getBaseQty().doubleValue();
                        if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                            tempQtyC *= One - scrapRateC;
                            tempBaseQtyC *= One - scrapRateC;
                        } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                            tempQtyC /= One + scrapRateC;
                            tempBaseQtyC /= One + scrapRateC;
                        }
                        entryInfo.setConsumeFixQty(new BigDecimal(tempQtyC / billQty.doubleValue() * bomParentQty.doubleValue()).setScale(multiOtherUnifInfo.getQtyPrecision(), 4));
                        entryInfo.setBaseConsumeFixQty(new BigDecimal(tempBaseQtyC / billBaseQty.doubleValue() * bomParentBaseQty.doubleValue()).setScale(precision, 4));
                        entryInfo.setProportion(new BigDecimal(0.0));
                    } else {
                        entryInfo.setProportion(bomEntryInfo.getProportion());
                        entryInfo.setBaseConsumeFixQty(bomEntryInfo.getConsumeFixBaseQty() == null ? new BigDecimal(0.0) : bomEntryInfo.getConsumeFixBaseQty());
                        entryInfo.setConsumeFixQty(bomEntryInfo.getConsumeFixQty());
                        entryInfo.setConsumeType(consumeType);
                    }
                    entryInfo.setOrigialQty(entryInfo.getQty());
                    entryInfo.setUnReceiptQty(entryInfo.getQty());
                    entryInfo.setUnReceiptBaseQty(entryInfo.getBaseQty());
                    stockList.add(entryInfo);
                }
                if (outputList == null || !MaterialProductEnum.RELATEDPRODUCT.equals((Object)bomEntryInfo.getOutputType()) && !MaterialProductEnum.BYPRODUCT.equals((Object)bomEntryInfo.getOutputType())) continue;
                entryInfo = new ProductionOrderOutputEntryInfo();
                entryInfo.setSourceBillId(bomEntryInfo.getParent().getId().toString());
                entryInfo.setSourceBillNumber(bomEntryInfo.getParent().getNumber());
                entryInfo.setSourceBillEntryId(bomEntryInfo.getId().toString());
                entryInfo.setSourceBillEntrySeq(bomEntryInfo.getSeq());
                entryInfo.setSourceBillType(bomEntryInfo.getParent().getBillType());
                entryInfo.setMaterial(bomEntryInfo.getMaterial());
                entryInfo.setModel(bomEntryInfo.getMaterial().getModel());
                entryInfo.setUnit(bomEntryInfo.getUnit());
                entryInfo.setBaseUnit(bomEntryInfo.getBaseUnit());
                entryInfo.setOutputType(bomEntryInfo.getOutputType());
                entryInfo.setRemark(bomEntryInfo.getRemark());
                entryInfo.setMaterialPlan(bomEntryInfo.getMaterialInventory());
                entryInfo.setConsumeFixQty(bomEntryInfo.getConsumeFixQty());
                entryInfo.setBaseConsumeFixQty(bomEntryInfo.getConsumeFixBaseQty() == null ? new BigDecimal(0.0) : bomEntryInfo.getConsumeFixBaseQty());
                entryInfo.setProportion(bomEntryInfo.getProportion());
                entryInfo.setConsumeType(consumeType);
                entryInfo.setProductLineWP(pwp);
                precision = bomEntryInfo.getBaseUnit() == null || bomEntryInfo.getBaseUnit().getQtyPrecision() < 1 ? 0 : bomEntryInfo.getBaseUnit().getQtyPrecision();
                multiBaseUnifInfo = (MultiMeasureUnitInfo)unitCatch.get(entryInfo.getMaterial().getId().toString() + entryInfo.getBaseUnit().getId().toString());
                if (multiBaseUnifInfo != null) {
                    int n = precision = multiBaseUnifInfo.getQtyPrecision() < 1 ? 0 : multiBaseUnifInfo.getQtyPrecision();
                }
                if (ConsumeTypeEnum.VariableAmount.equals((Object)consumeType)) {
                    tempQty = baseQty.doubleValue() / yield / parentBaseQty * consumeFixBaseQty;
                    if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                        tempQty /= One - scrapRate;
                    } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                        tempQty *= One + scrapRate;
                    }
                    entryInfo.setBaseQty(new BigDecimal(tempQty).divide(new BigDecimal(1.0), precision, 4));
                } else if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                    tempQty = baseQty.doubleValue() / yield * proportion;
                    if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                        tempQty /= One - scrapRate;
                    } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                        tempQty *= One + scrapRate;
                    }
                    double parentCoef = bomEntryInfo.getParent().getBaseUnit().getCoefficient().doubleValue();
                    double childCoef = entryInfo.getBaseUnit().getCoefficient().doubleValue();
                    double baseExchangeRate = new BigDecimal(1).doubleValue();
                    if (parentCoef != childCoef) {
                        baseExchangeRate = parentCoef / childCoef;
                    }
                    entryInfo.setBaseQty(new BigDecimal(tempQty * baseExchangeRate).setScale(precision, 4));
                }
                if (entryInfo.getBaseQty() != null) {
                    MultiMeasureUnitInfo multiOtherUnifInfo = (MultiMeasureUnitInfo)unitCatch.get(bomEntryInfo.getMaterial().getId().toString() + bomEntryInfo.getUnit().getId().toString());
                    BigDecimal targetQty = entryInfo.getBaseQty().divide(multiOtherUnifInfo.getBaseConvsRate(), multiOtherUnifInfo.getQtyPrecision(), 4);
                    entryInfo.setQty(targetQty);
                }
                outputList.add(entryInfo);
            }
        }
    }

    protected void updateStockEntryByBomEntry(Context ctx, ProductionOrderStockEntryInfo pse, BomEntryInfo bomEntryInfo, StorageOrgUnitInfo sou) throws EASBizException, BOSException {
        WarehouseInfo warehouse;
        pse.setMaterial(bomEntryInfo.getMaterial());
        pse.setMaterialInventory(bomEntryInfo.getMaterialInventory());
        pse.setMaterialChar(bomEntryInfo.getMaterialChar());
        pse.setModel(bomEntryInfo.getMaterial().getModel());
        pse.setUnit(bomEntryInfo.getUnit());
        pse.setSourceBillId(bomEntryInfo.getParent().getId().toString());
        pse.setSourceBillNumber(bomEntryInfo.getParent().getNumber());
        pse.setSourceBillEntryId(bomEntryInfo.getId().toString());
        pse.setSourceBillEntrySeq(bomEntryInfo.getSeq());
        pse.setSourceBillType(bomEntryInfo.getParent().getBillType());
        pse.setBaseUnit(bomEntryInfo.getBaseUnit());
        if (pse.getProvideType() == MaterialProvideTypeEnum.NONE) {
            pse.setProvideType(bomEntryInfo.getProvideType());
        }
        if (pse.getSupplyOrgUnit() == null) {
            pse.setSupplyOrgUnit(bomEntryInfo.getSupplyOrgUnit());
        }
        if (pse.getIssMode() == null) {
            if (bomEntryInfo.getIssMode() != null) {
                pse.setIssMode(bomEntryInfo.getIssMode());
            } else {
                pse.setIssMode(bomEntryInfo.getMaterialInventory().getIssMode());
            }
        }
        if (pse.getDefaultWarehouse() == null) {
            pse.setDefaultWarehouse(bomEntryInfo.getDefaultWarehouse());
        }
        if (!bomEntryInfo.isIsBackFlush() && bomEntryInfo.getDefaultWarehouse() == null) {
            StorageOrgUnitInfo stoInfo = sou;
            if ((MaterialProvideTypeEnum.SPANORGPROVIDE == bomEntryInfo.getProvideType() || MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE == bomEntryInfo.getProvideType()) && (stoInfo = bomEntryInfo.getSupplyOrgUnit()) == null && bomEntryInfo.getMaterialInventory() != null) {
                stoInfo = bomEntryInfo.getMaterialInventory().getSupplyOrgUnit();
            }
        }
        pse.setRemark(bomEntryInfo.getRemark());
        if (pse.isIsStock()) {
            if (pse.getMoveOutStorageOrgUnit() == null) {
                pse.setMoveOutStorageOrgUnit(bomEntryInfo.getTransferOrgUnit());
            }
            if (pse.getMoveOutWarehouse() == null) {
                pse.setMoveOutWarehouse(bomEntryInfo.getTransferWarehouse());
            }
        }
        if (pse.getLocation() == null) {
            pse.setLocation(bomEntryInfo.getLocation());
        }
        if (pse.getLocation() == null && (warehouse = pse.getDefaultWarehouse()) != null && warehouse.isHasLocation() && pse.getLocation() == null) {
            pse.setLocation(MMUtils.getDefaultLocation((Context)ctx, (StorageOrgUnitInfo)sou, (MaterialInfo)bomEntryInfo.getMaterial(), (WarehouseInfo)warehouse));
        }
        pse.setBaseSendOutTotalQty(new BigDecimal(0.0));
        pse.setSendOutTotalQty(new BigDecimal(0.0));
        pse.setUntreadTotalQty(new BigDecimal(0.0));
        pse.setBaseUntreadTotalQty(new BigDecimal(0.0));
        pse.setUnReceiptQty(pse.getQty());
        pse.setUnReceiptBaseQty(pse.getBaseQty());
        this.updateStockEntryTransactionType(ctx, sou, pse);
    }

    protected SelectorItemCollection getBomEntrySelector() {
        SelectorItemCollection bomSelector = new SelectorItemCollection();
        bomSelector.add(new SelectorItemInfo("*"));
        bomSelector.add(new SelectorItemInfo("parent.id"));
        bomSelector.add(new SelectorItemInfo("parent.number"));
        bomSelector.add(new SelectorItemInfo("parent.billType.*"));
        bomSelector.add(new SelectorItemInfo("parent.productBaseQty"));
        bomSelector.add(new SelectorItemInfo("parent.yield"));
        bomSelector.add(new SelectorItemInfo("defaultWarehouse.id"));
        bomSelector.add(new SelectorItemInfo("defaultWarehouse.hasLocation"));
        bomSelector.add(new SelectorItemInfo("defaultWarehouse.name"));
        bomSelector.add(new SelectorItemInfo("defaultWarehouse.number"));
        bomSelector.add(new SelectorItemInfo("location.id"));
        bomSelector.add(new SelectorItemInfo("location.name"));
        bomSelector.add(new SelectorItemInfo("location.number"));
        bomSelector.add(new SelectorItemInfo("supplyOrgUnit.id"));
        bomSelector.add(new SelectorItemInfo("supplyOrgUnit.name"));
        bomSelector.add(new SelectorItemInfo("supplyOrgUnit.number"));
        bomSelector.add(new SelectorItemInfo("provideType"));
        bomSelector.add(new SelectorItemInfo("parent.baseUnit.id"));
        bomSelector.add(new SelectorItemInfo("parent.baseUnit.number"));
        bomSelector.add(new SelectorItemInfo("parent.baseUnit.name"));
        bomSelector.add(new SelectorItemInfo("parent.baseUnit.qtyPrecision"));
        bomSelector.add(new SelectorItemInfo("parent.baseUnit.coefficient"));
        bomSelector.add(new SelectorItemInfo("material.id"));
        bomSelector.add(new SelectorItemInfo("material.number"));
        bomSelector.add(new SelectorItemInfo("material.name"));
        bomSelector.add(new SelectorItemInfo("material.model"));
        bomSelector.add(new SelectorItemInfo("material.status"));
        bomSelector.add(new SelectorItemInfo("unit.id"));
        bomSelector.add(new SelectorItemInfo("unit.number"));
        bomSelector.add(new SelectorItemInfo("unit.name"));
        bomSelector.add(new SelectorItemInfo("baseUnit.id"));
        bomSelector.add(new SelectorItemInfo("baseUnit.number"));
        bomSelector.add(new SelectorItemInfo("baseUnit.name"));
        bomSelector.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        bomSelector.add(new SelectorItemInfo("baseUnit.coefficient"));
        bomSelector.add(new SelectorItemInfo("materialInventory.id"));
        bomSelector.add(new SelectorItemInfo("materialInventory.scrapRateExpression"));
        bomSelector.add(new SelectorItemInfo("materialInventory.scrapRate"));
        bomSelector.add(new SelectorItemInfo("materialInventory.materialChar"));
        bomSelector.add(new SelectorItemInfo("materialInventory.isQuotaControl"));
        bomSelector.add(new SelectorItemInfo("materialInventory.issInHightLimit"));
        bomSelector.add(new SelectorItemInfo("materialInventory.issInLowLimit"));
        bomSelector.add(new SelectorItemInfo("materialInventory.materialAttr"));
        bomSelector.add(new SelectorItemInfo("materialInventory.status"));
        bomSelector.add(new SelectorItemInfo("materialInventory.replaceMode"));
        bomSelector.add(new SelectorItemInfo("materialInventory.isBackFlush"));
        bomSelector.add(new SelectorItemInfo("materialInventory.issMode"));
        bomSelector.add(new SelectorItemInfo("materialInventory.manufactureStrategy.id"));
        bomSelector.add(new SelectorItemInfo("materialInventory.supplyOrgUnit.id"));
        bomSelector.add(new SelectorItemInfo("materialInventory.supplyOrgUnit.number"));
        bomSelector.add(new SelectorItemInfo("materialInventory.supplyOrgUnit.name"));
        bomSelector.add(new SelectorItemInfo("baseUnit.id"));
        bomSelector.add(new SelectorItemInfo("baseUnit.number"));
        bomSelector.add(new SelectorItemInfo("baseUnit.name"));
        bomSelector.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        bomSelector.add(new SelectorItemInfo("baseUnit.coefficient"));
        bomSelector.add(new SelectorItemInfo("transferWarehouse.id"));
        bomSelector.add(new SelectorItemInfo("transferWarehouse.name"));
        bomSelector.add(new SelectorItemInfo("transferWarehouse.number"));
        bomSelector.add(new SelectorItemInfo("transferOrgUnit.id"));
        bomSelector.add(new SelectorItemInfo("transferOrgUnit.name"));
        bomSelector.add(new SelectorItemInfo("transferOrgUnit.number"));
        bomSelector.add(new SelectorItemInfo("materialChar"));
        bomSelector.add(new SelectorItemInfo("isStockTransfer"));
        bomSelector.add(new SelectorItemInfo("isBackFlush"));
        return bomSelector;
    }

    private void _updateEntrysForBom(Context ctx, ProductionOrderInfo productionOrderInfo, String bomId, ProductLineWPEntryInfo pwp) throws BOSException, EASBizException {
        Date startDate = productionOrderInfo.getStartDate();
        Date endDate = productionOrderInfo.getEndDate();
        if (bomId != null) {
            FilterInfo bomFilterInfo = new FilterInfo();
            bomFilterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)bomId, CompareType.EQUALS));
            EntityViewInfo bomViewInfo = new EntityViewInfo();
            SelectorItemCollection sic = this.getBomEntrySelector();
            bomViewInfo.setSelector(sic);
            bomViewInfo.setFilter(bomFilterInfo);
            bomViewInfo.getSorter().add(new SorterItemInfo("material.number"));
            BomEntryCollection coll = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryCollection(bomViewInfo);
            ProductionOrderStockEntryCollection stockEntryColls = productionOrderInfo.getStockEntry();
            String planOrderId = productionOrderInfo.getSourceBillId();
            boolean isAgainExtend = false;
            if (planOrderId != null && !planOrderId.trim().equals("")) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("isAfreshExtend");
                PlannedOrderInfo planInfo = (PlannedOrderInfo)PlannedOrderFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(planOrderId), selector);
                if (planInfo.isIsAfreshExtend()) {
                    isAgainExtend = true;
                }
            }
            if (isAgainExtend) {
                productionOrderInfo.getWpEntry().clear();
                productionOrderInfo.getStockEntry().clear();
                productionOrderInfo.getOutputEntry().clear();
                this._buildEntrys(ctx, productionOrderInfo);
            } else {
                if (stockEntryColls == null || stockEntryColls.isEmpty()) {
                    return;
                }
                if (coll == null || coll.isEmpty()) {
                    return;
                }
                HashMap entryMapping = new HashMap();
                for (int i = 0; i < stockEntryColls.size(); ++i) {
                    ProductionOrderStockEntryCollection stockEntryCollection_tmp = new ProductionOrderStockEntryCollection();
                    stockEntryCollection_tmp.add(stockEntryColls.get(i));
                    if (stockEntryColls.get(i).getSourceBillEntryId() == null) {
                        this.updateOldStockInfoMethed(ctx, productionOrderInfo, pwp, startDate, endDate, stockEntryCollection_tmp, entryMapping);
                        continue;
                    }
                    this.updateNewStockInfoMethod(ctx, productionOrderInfo, pwp, startDate, endDate, bomViewInfo, coll, stockEntryCollection_tmp);
                }
                List copyStockList = this.clearRepetitionStock(Arrays.asList(stockEntryColls.toArray()), productionOrderInfo);
                if (copyStockList.size() == stockEntryColls.size()) {
                    return;
                }
                productionOrderInfo.getStockEntry().clear();
                int j = copyStockList.size() - 1;
                for (int i = 0; i <= j; ++i) {
                    ProductionOrderStockEntryInfo entryInfo = (ProductionOrderStockEntryInfo)copyStockList.get(i);
                    productionOrderInfo.getStockEntry().add(entryInfo);
                }
            }
        }
    }

    private void updateStockEntryTransactionType(Context ctx, StorageOrgUnitInfo orgUnit, ProductionOrderStockEntryInfo stockInfo) throws BOSException, EASBizException {
        if (orgUnit != null && stockInfo.isIsStock() && stockInfo.getMoveOutStorageOrgUnit() != null) {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo companyOrgUnit = null;
            OrgUnitCollection companyOrgCol = iUnitRel.getToUnit(orgUnit.getId().toString(), 4, 1);
            if (companyOrgCol != null && companyOrgCol.size() > 0) {
                companyOrgUnit = (CompanyOrgUnitInfo)companyOrgCol.get(0);
            }
            StorageOrgUnitInfo moveOutStorageOrgUnit = stockInfo.getMoveOutStorageOrgUnit();
            CompanyOrgUnitInfo moveOutCompanyOrgUnit = null;
            OrgUnitCollection moveOutCompanyOrgCol = iUnitRel.getToUnit(moveOutStorageOrgUnit.getId().toString(), 4, 1);
            if (moveOutCompanyOrgCol != null && moveOutCompanyOrgCol.size() > 0) {
                moveOutCompanyOrgUnit = (CompanyOrgUnitInfo)moveOutCompanyOrgCol.get(0);
            }
            if (orgUnit.getId().toString().equals(moveOutStorageOrgUnit.getId().toString())) {
                stockInfo.setTransactionType(TransactionTypeEnum.CROSSWAREHOUSETRANSFER);
            } else if (moveOutCompanyOrgUnit == null || companyOrgUnit == null) {
                stockInfo.setTransactionType(TransactionTypeEnum.NULL);
            } else if (!moveOutCompanyOrgUnit.equals((Object)companyOrgUnit)) {
                stockInfo.setTransactionType(TransactionTypeEnum.CROSSFUNDTRANSFER);
            } else if (moveOutCompanyOrgUnit.equals((Object)companyOrgUnit) && !orgUnit.getId().toString().equals(moveOutStorageOrgUnit.getId().toString())) {
                stockInfo.setTransactionType(TransactionTypeEnum.CROSSSTORAGETRANSFER);
            } else {
                stockInfo.setTransactionType(TransactionTypeEnum.NULL);
            }
        } else {
            stockInfo.setTransactionType(TransactionTypeEnum.NULL);
        }
    }

    protected void setNullToDefault(Context ctx, IObjectValue model) {
        if (model == null) {
            return;
        }
        String[] headDecimalFields = this.getHeadDecimalFields();
        if (headDecimalFields != null) {
            for (int i = 0; i < headDecimalFields.length; ++i) {
                if (model.get(headDecimalFields[i]) != null) continue;
                model.put(headDecimalFields[i], (Object)new BigDecimal(0.0));
            }
        }
    }

    protected String[] getHeadDecimalFields() {
        return new String[]{"priority"};
    }

    public static CompanyOrgUnitInfo getCompanyOrgByStorageOrg(Context ctx, String storageOrgId) {
        if (storageOrgId == null) {
            return null;
        }
        try {
            CompanyOrgUnitInfo ret = null;
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageOrgId, 4, 1);
            if (orgCol != null && orgCol.size() > 0) {
                ret = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SCMLockInvDataVO _getMaterialInventory(Context ctx, SCMLockInvDataVO dataVO, Date reqDate, boolean isForSustitute) throws BOSException, EASBizException {
        IInventory iInventory = InventoryFactory.getLocalInstance((Context)ctx);
        IWarehouse iWarehouse = null;
        ILocation iLocation = null;
        IStoreType iStoreType = null;
        IStoreState iStoreState = null;
        ISupplier iSupplier = null;
        ICustomer iCustomer = null;
        IMeasureUnit iMeasureUnit = null;
        IMultiMeasureUnit imultiUnit = null;
        IStorageOrgUnit iStorageOrgUnit = null;
        ITrackNumber iTrackNumber = null;
        if (!isForSustitute) {
            imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
            iLocation = LocationFactory.getLocalInstance((Context)ctx);
            iStoreType = StoreTypeFactory.getLocalInstance((Context)ctx);
            iStoreState = StoreStateFactory.getLocalInstance((Context)ctx);
            iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
            iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
            iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(dataVO.getViewInfo().getFilter());
        SelectorItemCollection invSic = new SelectorItemCollection();
        invSic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(invSic);
        InventoryCollection inventoryIdCol = iInventory.getInventoryCollection(viewInfo);
        StringBuffer strInvIDs = new StringBuffer();
        InventoryCollection aInventoryCollection = new InventoryCollection();
        if (inventoryIdCol.size() > 0) {
            int c = inventoryIdCol.size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    strInvIDs.append(",");
                }
                strInvIDs.append("'");
                strInvIDs.append(((InventoryInfo)inventoryIdCol.getObject(i)).getId().toString());
                strInvIDs.append("'");
            }
            Connection conn = null;
            PreparedStatement perStmt = null;
            ResultSet rs = null;
            StringBuffer sb = new StringBuffer();
            HashSet<String> invIdSet = new HashSet<String>();
            if (reqDate != null) {
                sb.append("Select A.FID From T_IM_Inventory A ");
                sb.append("LEFT OUTER JOIN T_BD_MaterialInventory B on A.FMaterialID = B.FMaterialID AND A.FStorageOrgUnitID = B.FOrgUnit ");
                sb.append("LEFT OUTER JOIN T_BD_MaterialPlan P on A.FMaterialID = P.FMaterialID AND A.FStorageOrgUnitID = P.FOrgUnit ");
                sb.append("LEFT OUTER JOIN T_IM_DateOfMinDurability C on A.FLot = C.FLot AND A.FStorageOrgUnitID = C.FStorageOrgUnitID AND A.FMaterialID= C.FMaterialID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanVersionSet D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetEntrys E on E.FParentID = D.FID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreType T on T.FParentID = D.FID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreState S on S.FParentID = D.FID ");
                sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") AND B.FIsPeriodValid = 1 AND C.FEXP>=?");
                sb.append(" AND D.FNumber = '" + StoreCommonUtil.PLANVERSION_901 + "' ");
                sb.append(" AND A.FStoreTypeID = T.FStoreTypeID AND A.FStoreStatusID = S.FStoreStateID ");
                sb.append(" AND T.FIsMrpRun = 1 AND S.FIsMrpRun = 1 ");
                sb.append(" AND (D.FWarehouseRange = 10 ").append(" OR (D.FWarehouseRange = 20 AND A.FWarehouseID = E.FWarehouseID))");
                sb.append(" AND ((P.FManufactureStrategyID in ('").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("')) or ").append(" (P.FManufactureStrategyID not in ('").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("') and A.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("'))");
                sb.append(" UNION ALL ");
                sb.append("Select A.FID From T_IM_Inventory A ");
                sb.append("LEFT OUTER JOIN T_BD_MaterialInventory B on A.FMaterialID = B.FMaterialID AND A.FStorageOrgUnitID = B.FOrgUnit ");
                sb.append("LEFT OUTER JOIN T_BD_MaterialPlan P on A.FMaterialID = P.FMaterialID AND A.FStorageOrgUnitID = P.FOrgUnit ");
                sb.append("LEFT OUTER JOIN T_MM_PlanVersionSet D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetEntrys E on E.FParentID = D.FID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreType T on T.FParentID = D.FID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreState S on S.FParentID = D.FID ");
                sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") AND B.FIsPeriodValid = 0 ");
                sb.append(" AND D.FNumber = '" + StoreCommonUtil.PLANVERSION_901 + "' ");
                sb.append(" AND A.FStoreTypeID = T.FStoreTypeID AND A.FStoreStatusID = S.FStoreStateID ");
                sb.append(" AND T.FIsMrpRun = 1 AND S.FIsMrpRun = 1 ");
                sb.append(" AND (D.FWarehouseRange = 10 ").append(" OR (D.FWarehouseRange = 20 AND A.FWarehouseID = E.FWarehouseID))");
                sb.append(" AND ((P.FManufactureStrategyID in ('").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("')) or ").append(" (P.FManufactureStrategyID not in ('").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("') and A.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("'))");
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    perStmt = conn.prepareStatement(sb.toString());
                    perStmt.setDate(1, new java.sql.Date(reqDate.getTime()));
                    rs = perStmt.executeQuery();
                    while (rs.next()) {
                        invIdSet.add(rs.getString("FID"));
                    }
                }
                catch (SQLException ex) {
                    throw new BOSException((Throwable)ex);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
                }
            }
            sb.append("Select A.FID From T_IM_Inventory A ");
            sb.append("LEFT OUTER JOIN T_BD_MaterialPlan P on A.FMaterialID = P.FMaterialID AND A.FStorageOrgUnitID = P.FOrgUnit ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSet D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetEntrys E on E.FParentID = D.FID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreType T on T.FParentID = D.FID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreState S on S.FParentID = D.FID ");
            sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") ");
            sb.append(" AND D.FNumber = '" + StoreCommonUtil.PLANVERSION_901 + "' ");
            sb.append(" AND A.FStoreTypeID = T.FStoreTypeID AND A.FStoreStatusID = S.FStoreStateID ");
            sb.append(" AND T.FIsMrpRun = 1 AND S.FIsMrpRun = 1 ");
            sb.append(" AND ((P.FManufactureStrategyID in ('").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("')) or ").append(" (P.FManufactureStrategyID not in ('").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("') and A.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("'))");
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                perStmt = conn.prepareStatement(sb.toString());
                rs = perStmt.executeQuery();
                while (rs.next()) {
                    invIdSet.add(rs.getString("FID"));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, perStmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", invIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SorterItemCollection sorters = new SorterItemCollection();
            SorterItemInfo sortInfo = new SorterItemInfo("material.id");
            sortInfo.setSortType(SortType.ASCEND);
            sorters.add(sortInfo);
            view.setSorter(sorters);
            aInventoryCollection = iInventory.getInventoryCollection(view);
        }
        HashMap<String, WarehouseInfo> wareHouseMap = new HashMap<String, WarehouseInfo>();
        HashMap<String, LocationInfo> locationMap = new HashMap<String, LocationInfo>();
        HashMap<String, StoreTypeInfo> storeTypeMap = new HashMap<String, StoreTypeInfo>();
        HashMap<String, StoreStateInfo> storeStateMap = new HashMap<String, StoreStateInfo>();
        HashMap<String, SupplierInfo> supplierMap = new HashMap<String, SupplierInfo>();
        HashMap<String, CustomerInfo> customerMap = new HashMap<String, CustomerInfo>();
        HashMap<String, MeasureUnitInfo> invUnitMap = new HashMap<String, MeasureUnitInfo>();
        HashMap<String, StorageOrgUnitInfo> storageMap = new HashMap<String, StorageOrgUnitInfo>();
        HashMap<String, MultiMeasureUnitInfo> mmuMap = new HashMap<String, MultiMeasureUnitInfo>();
        HashMap<String, TrackNumberInfo> trackNumberMap = new HashMap<String, TrackNumberInfo>();
        HashMap<String, Date> expMap = new HashMap<String, Date>();
        HashMap<String, InventoryInfo> inventoryMap = new HashMap<String, InventoryInfo>();
        String invID = null;
        ObjectUuidPK[] invIdList = new ObjectUuidPK[aInventoryCollection.size()];
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        int i = 0;
        int n = aInventoryCollection.size();
        while (true) {
            if (i >= n) {
                dataVO.setWareHouseMap(wareHouseMap);
                dataVO.setLocationMap(locationMap);
                dataVO.setStoreTypeMap(storeTypeMap);
                dataVO.setStorageMap(storageMap);
                dataVO.setStoreStateMap(storeStateMap);
                dataVO.setCustomerMap(customerMap);
                dataVO.setSupplierMap(supplierMap);
                dataVO.setInvUnitMap(invUnitMap);
                dataVO.setInvIdList((IObjectPK[])invIdList);
                dataVO.setInventoryMap(inventoryMap);
                dataVO.setMmuPrecisions(mmuMap);
                dataVO.setTrackNumberMap(trackNumberMap);
                dataVO.setExpMap(expMap);
                return dataVO;
            }
            InventoryInfo aInventoryInfo = (InventoryInfo)aInventoryCollection.getObject(i);
            invIdList[i] = new ObjectUuidPK(aInventoryInfo.getId());
            invID = aInventoryInfo.getId().toString();
            inventoryMap.put(invID, aInventoryInfo);
            if (!isForSustitute) {
                if (aInventoryInfo.getWarehouse() != null) {
                    wareHouseMap.put(invID, iWarehouse.getWarehouseInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getWarehouse().getId().toString()), sic));
                }
                if (aInventoryInfo.getLocation() != null) {
                    locationMap.put(invID, iLocation.getLocationInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getLocation().getId().toString()), sic));
                }
                if (aInventoryInfo.getStoretype() != null) {
                    storeTypeMap.put(invID, iStoreType.getStoreTypeInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getStoretype().getId().toString()), sic));
                }
                if (aInventoryInfo.getStorestatus() != null) {
                    storeStateMap.put(invID, iStoreState.getStoreStateInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getStorestatus().getId().toString()), sic));
                }
                if (aInventoryInfo.getSupplier() != null) {
                    supplierMap.put(invID, iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getSupplier().getId().toString()), sic));
                }
                if (aInventoryInfo.getCustomer() != null) {
                    customerMap.put(invID, iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getCustomer().getId().toString()), sic));
                }
                if (aInventoryInfo.getUnit() != null) {
                    invUnitMap.put(invID, iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getUnit().getId()), sic));
                }
                if (aInventoryInfo.getStorageOrgUnit() != null) {
                    storageMap.put(invID, iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getStorageOrgUnit().getId().toString()), sic));
                }
                if (aInventoryInfo.getMaterial() != null && aInventoryInfo.getUnit() != null) {
                    mmuMap.put(aInventoryInfo.getMaterial().getId().toString() + aInventoryInfo.getUnit().getId().toString(), imultiUnit.getMultiUnit(aInventoryInfo.getMaterial().getId().toString(), aInventoryInfo.getUnit().getId().toString()));
                }
                if (aInventoryInfo.getTrackNumber() != null) {
                    trackNumberMap.put(invID, iTrackNumber.getTrackNumberInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getTrackNumber().getId().toString()), sic));
                }
                if (aInventoryInfo.getExp() != null) {
                    expMap.put(invID, aInventoryInfo.getExp());
                }
            }
            ++i;
        }
    }

    @Override
    protected Collection _loadMaterialSustitute(Context ctx, String materialId, String storageOrgUnitId, Date startDate, Date endDate) throws BOSException, EASBizException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer getSustitute = new StringBuffer();
        getSustitute.append("select t1.FReplaceSeq,t1.FReplacePercent,t1.FReplaceQty, t1.FInvalidDate, t1.FValidDate,");
        getSustitute.append("t3.fid as subUnitId,t3.fNumber as subUnitNum, t3.");
        getSustitute.append(this.getFieldName(ctx));
        getSustitute.append(" as subUnitName ,t4.fid as subMaterialId, t4.FStatus as subMaterialStatus, t4.fNumber as subMaterialNum, t4.");
        getSustitute.append(this.getFieldName(ctx));
        getSustitute.append(" as subMaterialName,t4.FModel as subMaterialModel, ");
        getSustitute.append("t5.fid as subBaseUnitId, t5.FCoefficient as subBaseUnitCoeff, t5.FNumber as subBaseUnitNumber, t5.");
        getSustitute.append(this.getFieldName(ctx));
        getSustitute.append(" as subBaseUnitName, t6.FQtyPrecision, t6.FBaseConvsRate ");
        getSustitute.append("from T_MM_MaterialReplaceEntry t1");
        getSustitute.append(" inner join T_MM_MaterialReplace t2 on t1.FParentID=t2.fid");
        getSustitute.append(" inner join T_BD_MeasureUnit t3 on t1.FMeasureUnitID= t3.fid");
        getSustitute.append(" inner join T_BD_Material t4 on t1.FMaterialID= t4.fid");
        getSustitute.append(" inner join T_BD_MeasureUnit t5 on t4.FBaseUnit=t5.fid ");
        getSustitute.append(" inner join T_BD_MultiMeasureUnit t6 on t1.FMaterialID=t6.FMaterialID and t1.FMeasureUnitID = t6.FMeasureUnitID");
        getSustitute.append(" where t2.FMaterialID= '");
        getSustitute.append(materialId);
        getSustitute.append("' and t2.FStorageOrgUnitID='");
        getSustitute.append(storageOrgUnitId);
        getSustitute.append("' and t2.FStatus =");
        getSustitute.append(20);
        if (startDate != null) {
            getSustitute.append(" and to_char(t1.FValidDate,'YYYY-MM-DD') <='" + sf.format(startDate) + "'");
        }
        if (endDate != null) {
            getSustitute.append(" and to_char(t1.FInvalidDate,'YYYY-MM-DD') >='" + sf.format(endDate) + "'");
        }
        getSustitute.append(" order by t1.FReplaceSeq");
        IRowSet sustitute = DbUtil.executeQuery((Context)ctx, (String)getSustitute.toString());
        if (sustitute.size() <= 0) {
            return null;
        }
        StringBuffer getMaterial = new StringBuffer();
        getMaterial.append("select t9.fid, t11.FCoefficient, t12.FQtyPrecision, t12.FBaseConvsRate from T_MM_MaterialReplace t7");
        getMaterial.append(" inner join T_BD_MaterialPlan t8 on t7.FMaterialPlanID = t8.fid");
        getMaterial.append(" inner join T_BD_MeasureUnit t9 on t8.FProductUnitID=t9.fid");
        getMaterial.append(" inner join T_BD_Material t10 on t7.FMaterialID= t10.fid");
        getMaterial.append(" inner join T_BD_MeasureUnit t11 on t10.FBaseUnit=t11.fid ");
        getMaterial.append(" inner join T_BD_MultiMeasureUnit t12 on t7.FMaterialID=t12.FMaterialID and t9.fid = t12.FMeasureUnitID");
        getMaterial.append(" where t7.FMaterialID= '");
        getMaterial.append(materialId);
        getMaterial.append("' and t7.FStorageOrgUnitID='");
        getMaterial.append(storageOrgUnitId);
        getMaterial.append("' and t7.FStatus =");
        getMaterial.append(20);
        getMaterial.append(" and t8.FStatus=1");
        IRowSet parentMaterial = DbUtil.executeQuery((Context)ctx, (String)getMaterial.toString());
        ArrayList<MaterialSustituteVO> sustituteVOCollection = new ArrayList<MaterialSustituteVO>();
        try {
            BigDecimal parentCoeff = new BigDecimal(1);
            BigDecimal parentToBaseUnitRate = new BigDecimal(1);
            String parentUnitId = null;
            while (parentMaterial.next()) {
                parentCoeff = parentMaterial.getBigDecimal("FCoefficient");
                parentToBaseUnitRate = parentMaterial.getBigDecimal("FBaseConvsRate");
                parentUnitId = parentMaterial.getString("fid");
            }
            while (sustitute.next()) {
                MaterialSustituteVO sustituteVO = new MaterialSustituteVO();
                sustituteVO.setEffectiveDate((Date)sustitute.getDate("FValidDate"));
                sustituteVO.setInvalidDate((Date)sustitute.getDate("FInvalidDate"));
                MaterialInfo mi = new MaterialInfo();
                MeasureUnitInfo baseMui = new MeasureUnitInfo();
                baseMui.setId(BOSUuid.read((String)sustitute.getString("subBaseUnitId")));
                baseMui.setCoefficient(sustitute.getBigDecimal("subBaseUnitCoeff"));
                baseMui.setNumber(sustitute.getString("subBaseUnitNumber"));
                baseMui.setName(sustitute.getString("subBaseUnitName"));
                mi.setId(BOSUuid.read((String)sustitute.getString("subMaterialId")));
                mi.setNumber(sustitute.getString("subMaterialNum"));
                mi.setName(sustitute.getString("subMaterialName"));
                mi.setModel(sustitute.getString("subMaterialModel"));
                mi.setStatus(UsedStatusEnum.getEnum((int)sustitute.getInt("subMaterialStatus")));
                mi.setBaseUnit(baseMui);
                sustituteVO.setSubstituteMaterial(mi);
                MeasureUnitInfo mui = new MeasureUnitInfo();
                mui.setId(BOSUuid.read((String)sustitute.getString("subUnitId")));
                mui.setNumber(sustitute.getString("subUnitNum"));
                mui.setName(sustitute.getString("subUnitName"));
                mui.setQtyPrecision(sustitute.getInt("FQtyPrecision"));
                sustituteVO.setSubstituteUnit(mui);
                sustituteVO.setParentToBaseUnitRate(parentToBaseUnitRate);
                sustituteVO.setSubstituteProportion(sustitute.getBigDecimal("FReplacePercent"));
                sustituteVO.setSubstituteQty(sustitute.getBigDecimal("FReplaceQty"));
                sustituteVO.setSubstituteSeq(sustitute.getInt("FReplaceSeq"));
                sustituteVO.setToBaseUnitRate(sustitute.getBigDecimal("FBaseConvsRate"));
                if (sustitute.getBigDecimal("FReplaceQty").doubleValue() > 0.0) {
                    sustituteVO.setSubstituteQty(true);
                } else {
                    sustituteVO.setSubstituteQty(false);
                    BigDecimal childCoeff = sustitute.getBigDecimal("subBaseUnitCoeff");
                    sustituteVO.setToParentBaseUnitRate(childCoeff.divide(parentCoeff, 8, 4));
                }
                sustituteVO.setParentUnitId(parentUnitId);
                sustituteVOCollection.add(sustituteVO);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sustituteVOCollection;
    }

    private String getFieldName(Context ctx) {
        return "FName_" + ctx.getLocale();
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProductionOrderInfo orderInfo = (ProductionOrderInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)orderInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (orderInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)orderInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (orderInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)orderInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (orderInfo.getStorageOrgUnit() != null) {
            filterItem = new FilterItemInfo("storageOrgUnit.id", (Object)orderInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && orderInfo.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(orderInfo), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        return super._exists(ctx, filter);
    }

    @Override
    protected void _outSource(Context ctx, IObjectPK prdPk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{prdPk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchOutSource(ctx, entrys);
        result.throwExceptions();
    }

    @Override
    protected boolean _outSourceBillDelateWriteBack(Context ctx, IObjectPK[] prdPks, boolean isDeleteEntry) throws BOSException, EASBizException {
        boolean retVal = false;
        if (prdPks == null || prdPks.length < 1) {
            return retVal;
        }
        ArrayList<Object> listBillID = new ArrayList<Object>();
        for (int i = 0; i < prdPks.length; ++i) {
            listBillID.add(prdPks[i].getKeyValue(null));
        }
        String strIdLists = StringUtils.arrayToString((Object[])listBillID.toArray(), (String)"','");
        if (!isDeleteEntry) {
            String updateOrderSql = "update T_MM_ProductionOrder set FOutSourceFlag=0,fBasestatus=4 where fid in ('" + strIdLists + "')";
            DbUtil.execute((Context)ctx, (String)updateOrderSql);
        }
        if (isDeleteEntry) {
            StringBuffer delBotp = new StringBuffer();
            delBotp.append("delete from t_bot_relation where FSRCENTITYID='1F66774E'");
            delBotp.append(" and FDESTENTITYID='25428F2E'");
            delBotp.append(" and FSRCOBJECTID in ('" + strIdLists + "')");
            DbUtil.execute((Context)ctx, (String)delBotp.toString());
        }
        retVal = true;
        return retVal;
    }

    @Override
    protected boolean _outSourceBillSubmitWriteBack(Context ctx, IObjectPK prdPk) throws BOSException, EASBizException {
        boolean retVal = false;
        if (prdPk == null) {
            return retVal;
        }
        String pk = prdPk.getKeyValue(null).toString();
        String updateOrderSql = "update T_MM_ProductionOrder set fBasestatus=7 where fid ='" + pk + "'";
        DbUtil.execute((Context)ctx, (String)updateOrderSql);
        retVal = true;
        return false;
    }

    @Override
    protected void _pubFireVOChangeListener(Context ctx, List ids, boolean isLock) throws BOSException, EASBizException {
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String dcName = SysContext.getSysContext().getDcName() != null ? SysContext.getSysContext().getDcName() : "";
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            if (isLock) {
                if (iMutexServiceControl.requestObjIDForUpdate(id, SysContext.getSysContext().getUserName(), dcName)) continue;
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
            if (!iMutexServiceControl.requestObjIDForUpdate(id, SysContext.getSysContext().getUserName(), dcName)) continue;
            iMutexServiceControl.releaseObjIDForUpdate(id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getMaterialInventory(Context ctx, Date reqDate, SCMLockInvDataVO dataVO, boolean isIncludeExpMaterial) throws BOSException, EASBizException {
        IInventory iInventory = InventoryFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(dataVO.getViewInfo().getFilter());
        SelectorItemCollection invSic = new SelectorItemCollection();
        invSic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(invSic);
        InventoryCollection inventoryIdCol = iInventory.getInventoryCollection(viewInfo);
        StringBuffer strInvIDs = new StringBuffer();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Object[] objs = null;
        if (inventoryIdCol.size() <= 0) return result;
        int c = inventoryIdCol.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                strInvIDs.append(",");
            }
            strInvIDs.append("'");
            strInvIDs.append(((InventoryInfo)inventoryIdCol.getObject(i)).getId().toString());
            strInvIDs.append("'");
        }
        Connection conn = null;
        PreparedStatement perStmt = null;
        ResultSet rs = null;
        StringBuffer sb = new StringBuffer();
        HashSet<String> invIdSet = new HashSet<String>();
        if (isIncludeExpMaterial) {
            sb.append("Select A.FID,C.FExp From T_IM_Inventory A ");
            sb.append("LEFT OUTER JOIN T_BD_MaterialInventory B on A.FMaterialID = B.FMaterialID AND A.FStorageOrgUnitID = B.FOrgUnit ");
            sb.append("LEFT OUTER JOIN T_IM_DateOfMinDurability C on A.FLot = C.FLot AND A.FStorageOrgUnitID = C.FStorageOrgUnitID AND A.FMaterialID= C.FMaterialID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSet D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetEntrys E on E.FParentID = D.FID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreType T on T.FParentID = D.FID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreState S on S.FParentID = D.FID ");
            sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") AND B.FIsPeriodValid = 1 AND C.FEXP>=?");
            sb.append(" AND D.FNumber = '" + StoreCommonUtil.PLANVERSION_901 + "' ");
            sb.append(" AND A.FStoreTypeID = T.FStoreTypeID AND A.FStoreStatusID = S.FStoreStateID ");
            sb.append(" AND T.FIsMrpRun = 1 AND S.FIsMrpRun = 1 ");
            sb.append(" UNION ALL ");
            sb.append("Select A.FID,null From T_IM_Inventory A ");
            sb.append("LEFT OUTER JOIN T_BD_MaterialInventory B on A.FMaterialID = B.FMaterialID AND A.FStorageOrgUnitID = B.FOrgUnit ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSet D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetEntrys E on E.FParentID = D.FID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreType T on T.FParentID = D.FID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreState S on S.FParentID = D.FID ");
            sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") AND B.FIsPeriodValid = 0 ");
            sb.append(" AND D.FNumber = '" + StoreCommonUtil.PLANVERSION_901 + "' ");
            sb.append(" AND A.FStoreTypeID = T.FStoreTypeID AND A.FStoreStatusID = S.FStoreStateID ");
            sb.append(" AND T.FIsMrpRun = 1 AND S.FIsMrpRun = 1 ");
            sb.append(" AND (D.FWarehouseRange = 10 ").append(" OR (D.FWarehouseRange = 20 AND A.FWarehouseID = E.FWarehouseID))");
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                perStmt = conn.prepareStatement(sb.toString());
                perStmt.setDate(1, new java.sql.Date(reqDate.getTime()));
                rs = perStmt.executeQuery();
                while (rs.next()) {
                    invIdSet.add(rs.getString("FID"));
                    objs = new Object[2];
                    objs[0] = rs.getString("FID");
                    Timestamp ts = rs.getTimestamp(2);
                    objs[1] = ts;
                    result.add(objs);
                }
                return result;
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
            }
        }
        sb.append("Select A.FID,C.FExp From T_IM_Inventory A ");
        sb.append("LEFT OUTER JOIN T_MM_PlanVersionSet D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
        sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetEntrys E on E.FParentID = D.FID ");
        sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreType T on T.FParentID = D.FID ");
        sb.append("LEFT OUTER JOIN T_MM_PlanVersionSetStoreState S on S.FParentID = D.FID ");
        sb.append("LEFT OUTER JOIN T_BD_MaterialInventory B on A.FMaterialID = B.FMaterialID AND A.FStorageOrgUnitID = B.FOrgUnit ");
        sb.append("LEFT OUTER JOIN T_IM_DateOfMinDurability C on A.FLot = C.FLot AND A.FStorageOrgUnitID = C.FStorageOrgUnitID AND A.FMaterialID= C.FMaterialID ");
        sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") ");
        sb.append(" AND D.FNumber = '" + StoreCommonUtil.PLANVERSION_901 + "' ");
        sb.append(" AND A.FStoreTypeID = T.FStoreTypeID AND A.FStoreStatusID = S.FStoreStateID ");
        sb.append(" AND T.FIsMrpRun = 1 AND S.FIsMrpRun = 1 ");
        sb.append(" AND (D.FWarehouseRange = 10 ").append(" OR (D.FWarehouseRange = 20 AND A.FWarehouseID = E.FWarehouseID))");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            perStmt = conn.prepareStatement(sb.toString());
            rs = perStmt.executeQuery();
            while (rs.next()) {
                invIdSet.add(rs.getString("FID"));
                objs = new Object[2];
                objs[0] = rs.getString("FID");
                Timestamp ts = rs.getTimestamp(2);
                objs[1] = ts;
                result.add(objs);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, perStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
        return result;
    }

    @Override
    protected void _checkEndDate(Context ctx, Date endDate, String storageOrgUnitId, String productLineId) throws BOSException, EASBizException {
        StringBuffer sql_check = new StringBuffer();
        sql_check.append("select count(t2.fid) shiftCount from t_mm_equipmentCalendarEntry t2 inner join t_mm_equipmentCalendar t3 on t3.fid=t2.fParentID where t2.FProductLineID=? and t3.FStorageOrgUnitID=? \n");
        sql_check.append("and  t2.fstarttime<=? and t2.fendTime>=? and t3.FWorkDay=1 and t2.fability>0");
        IRowSet rowCheckSet2 = DbUtil.executeQuery((Context)ctx, (String)sql_check.toString(), (Object[])new Object[]{productLineId, storageOrgUnitId, new Timestamp(endDate.getTime()), new Timestamp(endDate.getTime())});
        boolean flag = false;
        if (rowCheckSet2 == null || rowCheckSet2.size() < 1) {
            flag = false;
        } else {
            try {
                while (rowCheckSet2.next()) {
                    if (rowCheckSet2.getInt("shiftCount") >= 1) continue;
                    flag = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (flag) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(this.getResourceMsg("EndDateMustWorkDate", ctx));
            throw bizExp;
        }
    }

    private List clearRepetitionStock(List stockList, ProductionOrderInfo productionOrderInfo) {
        ArrayList<ProductionOrderStockEntryInfo> copyStockList = new ArrayList<ProductionOrderStockEntryInfo>();
        ArrayList<String> copyStockMaterialId = new ArrayList<String>();
        BomInfo bomInfo = productionOrderInfo.getBom();
        if (stockList != null && stockList.size() > 0) {
            double One = 1.0;
            for (int i = 0; i < stockList.size(); ++i) {
                ProductionOrderStockEntryInfo stockEntryInfo = (ProductionOrderStockEntryInfo)stockList.get(i);
                String materialId = stockEntryInfo.getMaterial().getId().toString();
                if (copyStockMaterialId.indexOf(materialId) < 0) {
                    copyStockList.add(stockEntryInfo);
                    copyStockMaterialId.add(materialId);
                    continue;
                }
                BigDecimal baseOtherQty = stockEntryInfo.getBaseQty();
                ProductionOrderStockEntryInfo stockExistEntryInfo = (ProductionOrderStockEntryInfo)copyStockList.get(copyStockMaterialId.indexOf(materialId));
                BigDecimal baseExistQty = stockExistEntryInfo.getBaseQty();
                BigDecimal totleBaseQty = baseOtherQty.add(baseExistQty);
                MultiMeasureUnitInfo multiOtherUnifInfo = (MultiMeasureUnitInfo)stockExistEntryInfo.get("multiUnit");
                MultiMeasureUnitInfo multiBaseUnifInfo = (MultiMeasureUnitInfo)stockExistEntryInfo.get("baseMultiUnit");
                BigDecimal totleQty = totleBaseQty.divide(multiOtherUnifInfo.getBaseConvsRate(), multiOtherUnifInfo.getQtyPrecision(), 4);
                stockExistEntryInfo.setBaseQty(totleBaseQty);
                stockExistEntryInfo.setQty(totleQty);
                stockExistEntryInfo.setOrigialQty(totleQty);
                BigDecimal baseExistStandardQty = (BigDecimal)stockExistEntryInfo.get("baseStandardQty");
                BigDecimal baseStandardQty = (BigDecimal)stockEntryInfo.get("baseStandardQty");
                BigDecimal totlebaseStandardQty = baseExistStandardQty == null ? new BigDecimal(0) : baseExistStandardQty.add(baseStandardQty);
                BigDecimal totleStandardQty = totlebaseStandardQty.divide(multiOtherUnifInfo.getBaseConvsRate(), multiOtherUnifInfo.getQtyPrecision(), 4);
                stockExistEntryInfo.setQty(totleQty);
                stockExistEntryInfo.put("baseStandardQty", totlebaseStandardQty);
                stockExistEntryInfo.setStandardQty(totleStandardQty);
                double scrapRateC = stockEntryInfo.getMaterialInventory().getScrapRate().doubleValue() / 100.0;
                MaterialScrapRateExpressionEnum scrapRateExpression = stockEntryInfo.getMaterialInventory().getScrapRateExpression();
                double tempQtyC = totleQty.doubleValue();
                double tempBaseQtyC = totleBaseQty.doubleValue();
                if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                    tempQtyC *= One - scrapRateC;
                    tempBaseQtyC *= One - scrapRateC;
                } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                    tempQtyC /= One + scrapRateC;
                    tempBaseQtyC /= One + scrapRateC;
                }
                BigDecimal consumeQty = new BigDecimal(tempQtyC / productionOrderInfo.getQty().doubleValue() * bomInfo.getProductQty().doubleValue()).setScale(multiOtherUnifInfo.getQtyPrecision(), 4);
                stockExistEntryInfo.setConsumeFixQty(consumeQty);
                BigDecimal consumeBaseQty = new BigDecimal(tempBaseQtyC / productionOrderInfo.getBaseQty().doubleValue() * bomInfo.getProductBaseQty().doubleValue()).setScale(multiBaseUnifInfo.getQtyPrecision(), 4);
                stockExistEntryInfo.setBaseConsumeFixQty(consumeBaseQty);
                stockExistEntryInfo.setConsumeType(ConsumeTypeEnum.VariableAmount);
            }
        }
        return copyStockList;
    }

    @Override
    protected boolean _addNewByBatch(Context ctx, CoreBaseCollection collection) throws BOSException, EASBizException {
        boolean flag = true;
        Connection cn = null;
        IORMappingDAO idao = null;
        try {
            cn = this.getConnection(ctx);
            idao = this.getDAO(ctx, cn);
            if (collection != null && collection.size() > 0) {
                int addCount = collection.size();
                for (int i = 0; i < addCount; ++i) {
                    ProductionOrderInfo info = (ProductionOrderInfo)collection.getObject(i);
                    idao.addNewBatch((IObjectValue)info);
                }
            }
            idao.executeBatch();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return flag;
    }

    public void buildLotMaterial(Context ctx, FinishedRptInfo finishedRpt) throws BOSException {
        String tableName = null;
        try {
            StringBuffer createSQL = new StringBuffer();
            createSQL.append("Create Table T_MM_FinishedRpt_LOT_Mid (").append("FID VARCHAR(44),").append("FFinisheRptID VARCHAR(44),").append("FTaskDispBillID VARCHAR(44),").append("FProductionOrderID VARCHAR(44),").append("FStorageOrgUnitID VARCHAR(44),").append("FWorkshopID VARCHAR(44),").append("FProductLineID VARCHAR(44),").append("FClassGroupID VARCHAR(44),").append("FMaterialID VARCHAR(44),").append("FLotNo NVARCHAR(80),").append("FBussinessType INT,").append("FFinishDate DateTime);");
            tableName = this.createTempTable(ctx, createSQL.toString());
            StringBuffer headKSQL = new StringBuffer();
            headKSQL.append("insert into  ");
            headKSQL.append(tableName);
            headKSQL.append(" (FID,FFinisheRptID,FTaskdispbillid,FProductionorderid,FStorageOrgUnitID,FWorkshopID,FProductLineID,FClassGroupID,FMaterialID,FLotNo,FBussinessType,FFinishDate) ");
            headKSQL.append("select newbosid('").append("F936F7CF").append("'),");
            headKSQL.append("FParentID,");
            headKSQL.append("ftaskdispbillid,");
            headKSQL.append("fproductionorderid,");
            headKSQL.append("FStorageOrgUnitID,");
            headKSQL.append("FWorkshopID,");
            headKSQL.append("FProductLineID,");
            headKSQL.append("FClassGroupID,");
            headKSQL.append("FMaterialID,");
            headKSQL.append("FLotNo, ");
            headKSQL.append("FMmBizType, ");
            headKSQL.append("FFinishDate from (");
            headKSQL.append("select distinct ");
            headKSQL.append("h.ftaskdispbillid,");
            headKSQL.append("h.fproductionorderid,");
            headKSQL.append("h.FStorageOrgUnitID,");
            headKSQL.append("h.FWorkshopID,");
            headKSQL.append("h.FProductLineID,");
            headKSQL.append("h.FClassGroupID,");
            headKSQL.append("d.FMaterialID,");
            headKSQL.append("d.FLotNo,");
            headKSQL.append("d.FFinishDate,");
            headKSQL.append("p.FMmBizType,");
            headKSQL.append("d.fparentid,");
            headKSQL.append("d.fid  ");
            headKSQL.append("from T_MM_FinishedRpt h,T_MM_FinishedRptEntry d,T_MM_ProductionOrder p where d.FParentID = h.fid and h.FProductionOrderID = p.fid and h.fid = ? and d.FLotNo is not null and FOutputType = 10710) aa");
            DbUtil.execute((Context)ctx, (String)headKSQL.toString(), (Object[])new Object[]{finishedRpt.getId().toString()});
            headKSQL.setLength(0);
            headKSQL.append("insert into T_MM_BatchFile(FID,FSourceBillID,FProductionOrderId,FStorageOrgUnitID,FWorkshopID,FProductLineID,FClassGroupID,FMaterialID,FLotNo,FBussinessType,FBatchTime,FBaseStatus) ");
            headKSQL.append("select ");
            headKSQL.append("FID,");
            headKSQL.append("FFinisheRptID,");
            headKSQL.append("FProductionOrderID,");
            headKSQL.append("FStorageOrgUnitID,");
            headKSQL.append("FWorkshopID,");
            headKSQL.append("FProductLineID,");
            headKSQL.append("FClassGroupID,");
            headKSQL.append("FMaterialID,");
            headKSQL.append("FLotNo,");
            headKSQL.append("FBussinessType,");
            headKSQL.append("FFinishDate, ");
            headKSQL.append(2);
            headKSQL.append(" from ").append(tableName).append(" mid ");
            headKSQL.append("where mid.fid not in (select mid.fid from ").append(tableName).append(" mid ").append(",T_MM_BatchFile b where mid.FMaterialID =b.FMaterialID and mid.FLotNo = b.FLotNo and mid.FBussinessType = b.FBussinessType  )");
            DbUtil.execute((Context)ctx, (String)headKSQL.toString());
            headKSQL.setLength(0);
            headKSQL.append("insert into T_MM_BatchFileEntry(FID,FParentID,FStorageOrgUnitID,FMaterialID,FLotNo) ");
            headKSQL.append("select newbosid('").append("3AC6A9E3").append("'),");
            headKSQL.append("FParentID,");
            headKSQL.append("FStorageOrgUnitID,");
            headKSQL.append("FMaterialID,");
            headKSQL.append("FLotNo from (");
            headKSQL.append("select distinct ");
            headKSQL.append("b.fid as FParentID,");
            headKSQL.append("h.FStorageOrgUnitID,");
            headKSQL.append("d.FMaterialID,");
            headKSQL.append("dd.FLot FLotNo,");
            headKSQL.append("mid.fid fMidID ");
            headKSQL.append("from T_MM_PickingSlipBill h,T_MM_PickingSlipBillEntry d ,T_MM_PickingSlipLot dd, ").append(tableName).append(" mid ").append(",T_MM_BatchFile b  ");
            headKSQL.append("where dd.FPickingSlipEntryID = d.FID and mid.FMaterialID =b.FMaterialID and mid.FLotNo = b.FLotNo and d.FParentID = h.FID ");
            if (null == finishedRpt.getTaskDispBill()) {
                headKSQL.append("and mid.fproductionorderid = h.fproductionorderid");
            } else {
                headKSQL.append("and mid.ftaskdispbillid = h.ftaskdispid");
            }
            headKSQL.append(") p ");
            headKSQL.append("where p.fMidID not in(select p.fMidID from T_MM_BatchFileEntry  bb where bb.FLotNo = p.FLotNo and bb.FParentID = p.FParentID and bb.FMaterialID = p.FMaterialID) ");
            DbUtil.execute((Context)ctx, (String)headKSQL.toString());
        }
        catch (BOSException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (!StringUtils.isEmpty(tableName)) {
                    String sql = "delete from " + tableName;
                    DbUtil.execute((Context)ctx, (String)sql);
                    this.releaseTempTable(ctx, tableName);
                }
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)tableName)) {
            String sql = "delete from " + tableName;
            DbUtil.execute((Context)ctx, (String)sql);
            this.releaseTempTable(ctx, tableName);
        }
    }

    private void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    private String createTempTable(Context ctx, String createTableSQL) throws BOSException {
        String rtnTableName = "";
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            rtnTableName = pool.createTempTable(createTableSQL);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rtnTableName;
    }

    @Override
    protected List _getPickingIdList(Context ctx, List prdIdList) throws BOSException, EASBizException {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < prdIdList.size(); ++i) {
            if (i != 0) {
                ids.append(",");
            }
            ids.append("'");
            ids.append(prdIdList.get(i).toString());
            ids.append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select p.fid as fid  from t_mm_pickingslipbill p ");
        sql.append(" inner join t_bot_relation r on p.fid = r.FDestObjectID");
        sql.append(" inner join t_mm_productionorder prd on prd.fid = r.FSrcObjectID");
        sql.append(" where p.fproductionorderid = prd.fid and r.FSrcEntityID = ? and r.FDestEntityID = ? ");
        sql.append(" and prd.fid in (");
        sql.append(ids);
        sql.append(" )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new ProductionOrderInfo().getBOSType().toString(), new PickingSlipBillInfo().getBOSType().toString()});
        ArrayList<String> pickIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                String pickId = rs.getString("fid");
                pickIdList.add(pickId);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return pickIdList;
    }

    @Override
    protected void _checkCanPickingSlip(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList.size() <= 0) {
            return;
        }
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            if (i != 0) {
                ids.append(",");
            }
            ids.append("'");
            ids.append(idList.get(i).toString());
            ids.append("'");
        }
        String sql_statusCheck = "select fid,fnumber,fStorageOrgUnitID from t_mm_productionorder where fid in (" + ids + ")";
        IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck);
        StringBuffer dispatchNums = new StringBuffer();
        StringBuffer disPickNums = new StringBuffer();
        ArrayList<String> list1 = new ArrayList<String>();
        String relType = RELEASE_NOT;
        String enabledPick = GENCOST_NOT;
        String enabledReport = GENCOST_NOT;
        try {
            ParamUtil paramUtil = new ParamUtil(ctx);
            while (rowStatus.next()) {
                String fid;
                String fnumber = rowStatus.getString("fnumber");
                String fStorageOrgUnitID = rowStatus.getString("fStorageOrgUnitID");
                paramUtil.setStorageOrgUnitID(fStorageOrgUnitID, false);
                relType = paramUtil.getTaskDispTypeParam(RELEASE_NOT);
                enabledPick = paramUtil.getEnabledPickBillParam(GENCOST_NOT);
                enabledReport = paramUtil.getEnabledProductionReportParam(GENCOST_NOT);
                if (!GENCOST_NOT.equals(enabledPick)) {
                    disPickNums.append(fnumber).append(",");
                    continue;
                }
                if (GENCOST_NOT.equals(enabledReport)) {
                    if (!RELEASE_NOT.equals(relType)) {
                        dispatchNums.append(fnumber);
                        dispatchNums.append(",");
                        continue;
                    }
                    fid = rowStatus.getString("fid");
                    list1.add(fid);
                    continue;
                }
                fid = rowStatus.getString("fid");
                list1.add(fid);
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1);
            throw new BOSException((Throwable)e1);
        }
        StringBuffer errorStr = new StringBuffer();
        StringBuffer noPickNum = new StringBuffer();
        StringBuffer noAuditPick = new StringBuffer();
        if (list1.size() > 0) {
            String number;
            StringBuffer id1s = new StringBuffer();
            for (int i = 0; i < list1.size(); ++i) {
                if (i != 0) {
                    id1s.append(",");
                }
                id1s.append("'");
                id1s.append(list1.get(i).toString());
                id1s.append("'");
            }
            StringBuffer checkSql = new StringBuffer();
            checkSql.append("select fnumber from t_mm_productionorder where FIsPickSlip = 0 and fid in (");
            checkSql.append(id1s);
            checkSql.append(")");
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)checkSql.toString());
            try {
                while (rs.next()) {
                    number = rs.getString("fnumber");
                    noPickNum.append(number + ",");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            checkSql = new StringBuffer();
            checkSql.append("select fnumber from t_mm_productionorder  p ");
            checkSql.append(" where  exists (select pick.fid from t_mm_pickingslipbill pick inner join t_bot_relation r on r.FDestObjectID = pick.fid where r.FsrcObjectID = p.fid and r.FSrcEntityID = ? and r.FdestEntityID = ? and pick.fbasestatus <? )");
            checkSql.append(" and p.fid in (");
            checkSql.append(id1s);
            checkSql.append(")");
            rs = DBUtil.executeQuery((Context)ctx, (String)checkSql.toString(), (Object[])new Object[]{new ProductionOrderInfo().getBOSType().toString(), new PickingSlipBillInfo().getBOSType().toString(), new Integer(4)});
            try {
                while (rs.next()) {
                    number = rs.getString("fnumber");
                    noAuditPick.append(number + ",");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (disPickNums.length() > 0) {
            errorStr.append(this.getResourceMsg2("PickingSlipErr3", new String[]{disPickNums.replace(disPickNums.length() - 1, disPickNums.length(), "").toString()}, ctx) + "\n");
        }
        if (dispatchNums.length() > 0) {
            errorStr.append(this.getResourceMsg2("PickingSlipErr0", new String[]{dispatchNums.replace(dispatchNums.length() - 1, dispatchNums.length(), "").toString()}, ctx) + "\n");
        }
        if (noPickNum.length() > 0) {
            errorStr.append(this.getResourceMsg2("PickingSlipErr1", new String[]{noPickNum.replace(noPickNum.length() - 1, noPickNum.length(), "").toString()}, ctx) + "\n");
        }
        if (noAuditPick.length() > 0) {
            errorStr.append(this.getResourceMsg2("PickingSlipErr2", new String[]{noAuditPick.replace(noAuditPick.length() - 1, noAuditPick.length(), "").toString()}, ctx) + "\n");
        }
        if (errorStr.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.PICKINGSLIPERR, new Object[]{errorStr.toString()});
        }
    }

    @Override
    protected ProductionOrderInfo _buildEntrys(Context ctx, ProductionOrderInfo orderInfo) throws BOSException, EASBizException {
        this.getWPEntrys(ctx, orderInfo);
        if (orderInfo.getFormula() != null) {
            this.buildStockEntrys(ctx, orderInfo);
        } else {
            boolean qtyIsZero = false;
            if (orderInfo.getQty().doubleValue() == 0.0) {
                orderInfo.setQty(new BigDecimal(1));
                orderInfo.setBaseQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)orderInfo.getMaterial().getId().toString(), (MeasureUnitInfo)orderInfo.getUnit(), (MeasureUnitInfo)orderInfo.getBaseUnit(), (BigDecimal)new BigDecimal(1)));
                qtyIsZero = true;
            }
            ProductionOrderEntryInfo prdLineWPEntryFirst = null;
            ProductionOrderEntryCollection wpEntrys = orderInfo.getWpEntry();
            if (wpEntrys.size() > 0) {
                prdLineWPEntryFirst = wpEntrys.get(0);
                this.buildEntrysForBom(ctx, orderInfo, prdLineWPEntryFirst.getProductLineWP());
            }
            if (qtyIsZero) {
                ProductionOrderStockEntryCollection prdOrderStockColl = orderInfo.getStockEntry();
                for (int i = 0; prdOrderStockColl != null && i < prdOrderStockColl.size(); ++i) {
                    ProductionOrderStockEntryInfo prdOrderStockInfo = prdOrderStockColl.get(i);
                    prdOrderStockInfo.setQty(new BigDecimal(AUDIT_GEN));
                    prdOrderStockInfo.setBaseQty(new BigDecimal(AUDIT_GEN));
                    prdOrderStockInfo.setStandardQty(new BigDecimal(AUDIT_GEN));
                    prdOrderStockInfo.setOrigialQty(new BigDecimal(AUDIT_GEN));
                }
                ProductionOrderOutputEntryCollection _ = orderInfo.getOutputEntry();
                int count = _.size();
                for (int k = 0; k < count; ++k) {
                    ProductionOrderOutputEntryInfo __ = _.get(k);
                    __.setQty(SysConstant.BIGZERO);
                    __.setBaseQty(SysConstant.BIGZERO);
                }
            }
        }
        return orderInfo;
    }

    private static MaterialInventoryInfo getMaterialStockInfo(Context ctx, String orgId, String materialID) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("defaultWarehouse.id"));
        selectorItemCollection.add(new SelectorItemInfo("defaultWarehouse.name"));
        selectorItemCollection.add(new SelectorItemInfo("defaultWarehouse.number"));
        selectorItemCollection.add(new SelectorItemInfo("defaultWarehouse.hasLocation"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialInventoryCollection materialInvCollection = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(entityViewInfo);
        if (materialInvCollection != null && materialInvCollection.size() > 0) {
            MaterialInventoryInfo materialInventoryInfo = materialInvCollection.get(0);
            return materialInventoryInfo;
        }
        return null;
    }

    protected void buildStockEntrys(Context ctx, ProductionOrderInfo orderInfo) throws BOSException, EASBizException {
        String formulaID = orderInfo.getFormula().getId().toString();
        if (!StringUtils.isEmpty((String)formulaID)) {
            FilterInfo formulaFilterInfo = new FilterInfo();
            formulaFilterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)formulaID, CompareType.EQUALS));
            EntityViewInfo formulaViewInfo = new EntityViewInfo();
            formulaViewInfo.getSelector().add(new SelectorItemInfo("*"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("parent.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("parent.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("parent.billType.*"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("parent.productBaseQty"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("parent.yield"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("warehouse.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("warehouse.hasLocation"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("warehouse.name"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("warehouse.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("location.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("location.name"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("location.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("supplyStorageOrgUnit.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("supplyStorageOrgUnit.name"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("supplyStorageOrgUnit.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("provideType"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("parent.baseUnit.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("parent.baseUnit.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("parent.baseUnit.name"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("parent.baseUnit.qtyPrecision"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("parent.baseUnit.coefficient"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("material.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("material.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("material.name"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("material.model"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("material.status"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("unit.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("unit.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("unit.name"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("baseUnit.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("baseUnit.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("baseUnit.name"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("baseUnit.qtyPrecision"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("baseUnit.coefficient"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("moveOutWareHouse.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("moveOutWareHouse.name"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("moveOutWareHouse.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("sourceStorageOrgUnit.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("sourceStorageOrgUnit.name"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("sourceStorageOrgUnit.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("productLineWP.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("productLineWP.number"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("productLineWP.name"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialInventory.id"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialInventory.scrapRateExpression"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialInventory.scrapRate"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialInventory.materialChar"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialInventory.isQuotaControl"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialInventory.issInHightLimit"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialInventory.issInLowLimit"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialInventory.materialAttr"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialInventory.status"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialInventory.replaceMode"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("materialAttr"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("isBackFlush"));
            formulaViewInfo.getSelector().add(new SelectorItemInfo("isStock"));
            formulaViewInfo.setFilter(formulaFilterInfo);
            formulaViewInfo.getSorter().add(new SorterItemInfo("productLineWP.number"));
            ProductionFormulaEntryCollection coll = ProductionFormulaEntryFactory.getLocalInstance((Context)ctx).getProductionFormulaEntryCollection(formulaViewInfo);
            if (coll != null && !coll.isEmpty()) {
                MultiMeasureUnitInfo multiBaseUnifInfo = null;
                IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
                int lineseq = 0;
                for (int i = 0; i < coll.size(); ++i) {
                    double tempQty;
                    int precision;
                    SCMBillEntryBaseInfo entryInfo;
                    double parentBaseQty;
                    ProductionFormulaEntryInfo formulaEntryInfo = coll.get(i);
                    if (orderInfo.getStartDate() != null && formulaEntryInfo.getDisableDate() != null && orderInfo.getStartDate().after(formulaEntryInfo.getDisableDate()) || orderInfo.getEndDate() != null && formulaEntryInfo.getEffectiveDate() != null && orderInfo.getEndDate().before(formulaEntryInfo.getEffectiveDate())) continue;
                    double d = parentBaseQty = MMUtils.equalsZero((BigDecimal)formulaEntryInfo.getParent().getProductBaseQty()) ? 1.0 : formulaEntryInfo.getParent().getProductBaseQty().doubleValue();
                    if (parentBaseQty == 0.0) {
                        StringBuffer errBuff = new StringBuffer();
                        errBuff.append(this.getResourceMsg2("FormulaHasError", ctx) + "\n");
                        ActionCommonException bizExp = new ActionCommonException(null);
                        bizExp.setMessage(errBuff.toString());
                        throw bizExp;
                    }
                    ConsumeTypeEnum consumeType = formulaEntryInfo.getConsumeType() == null ? ConsumeTypeEnum.VariableAmount : formulaEntryInfo.getConsumeType();
                    double consumeFixBaseQty = formulaEntryInfo.getConsumeFixBaseQty() == null ? 0.0 : formulaEntryInfo.getConsumeFixBaseQty().doubleValue();
                    double proportion = formulaEntryInfo.getProportion() == null ? 0.0 : formulaEntryInfo.getProportion().doubleValue() / 100.0;
                    double yield = formulaEntryInfo.getParent().getYield() == null ? 1.0 : formulaEntryInfo.getParent().getYield().doubleValue() / 100.0;
                    double scrapRate = formulaEntryInfo.getMaterialInventory() == null || formulaEntryInfo.getMaterialInventory().getScrapRate() == null ? 0.0 : formulaEntryInfo.getMaterialInventory().getScrapRate().doubleValue() / 100.0;
                    MaterialScrapRateExpressionEnum scrapRateExpression = formulaEntryInfo.getMaterialInventory() == null || formulaEntryInfo.getMaterialInventory().getScrapRateExpression() == null ? null : formulaEntryInfo.getMaterialInventory().getScrapRateExpression();
                    double One = 1.0;
                    MaterialInfo material = formulaEntryInfo.getMaterial();
                    if (!MaterialProductEnum.RELATEDPRODUCT.equals((Object)formulaEntryInfo.getProductType()) && !MaterialProductEnum.BYPRODUCT.equals((Object)formulaEntryInfo.getProductType()) && (MaterialIssueModeEnum.PRODUCEISSMODE.equals((Object)formulaEntryInfo.getPickingMode()) || MaterialIssueModeEnum.STRAIGHT.equals((Object)formulaEntryInfo.getPickingMode()) || MaterialIssueModeEnum.NOTISSMODE.equals((Object)formulaEntryInfo.getPickingMode()))) {
                        entryInfo = new ProductionOrderStockEntryInfo();
                        entryInfo.setMaterial(material);
                        entryInfo.setUnit(formulaEntryInfo.getUnit());
                        entryInfo.setSourceBillId(formulaEntryInfo.getParent().getId().toString());
                        entryInfo.setSourceBillNumber(formulaEntryInfo.getParent().getNumber());
                        entryInfo.setSourceBillEntryId(formulaEntryInfo.getId().toString());
                        entryInfo.setSourceBillEntrySeq(formulaEntryInfo.getSeq());
                        entryInfo.setSourceBillType(formulaEntryInfo.getParent().getBillType());
                        entryInfo.setMaterialInventory(formulaEntryInfo.getMaterialInventory());
                        entryInfo.setBaseUnit(formulaEntryInfo.getBaseUnit());
                        entryInfo.setPickingLeadTime(formulaEntryInfo.getPickingLeadTime());
                        entryInfo.setIsBackFlush(formulaEntryInfo.isIsBackFlush());
                        entryInfo.setDefaultWarehouse(formulaEntryInfo.getWarehouse());
                        if (!formulaEntryInfo.isIsBackFlush() && formulaEntryInfo.getWarehouse() == null) {
                            MaterialInventoryInfo inv = ProductionOrderControllerBean.getMaterialStockInfo(ctx, orderInfo.getStorageOrgUnit().getId().toString(), material.getId().toString());
                            entryInfo.setDefaultWarehouse(inv.getDefaultWarehouse());
                        }
                        entryInfo.setBaseSendOutTotalQty(new BigDecimal(0.0));
                        entryInfo.setSendOutTotalQty(new BigDecimal(0.0));
                        entryInfo.setUntreadTotalQty(new BigDecimal(0.0));
                        entryInfo.setBaseUntreadTotalQty(new BigDecimal(0.0));
                        entryInfo.setProductLineWP(formulaEntryInfo.getProductLineWP());
                        entryInfo.setMaterialChar(formulaEntryInfo.getMaterialAttr());
                        entryInfo.setModel(material.getModel());
                        entryInfo.setStartDate(orderInfo.getStartDate());
                        entryInfo.setEndDate(orderInfo.getEndDate());
                        entryInfo.setIsStock(formulaEntryInfo.isIsStock());
                        entryInfo.setMoveOutWarehouse(formulaEntryInfo.getMoveOutWareHouse());
                        entryInfo.setMoveOutStorageOrgUnit(formulaEntryInfo.getSourceStorageOrgUnit());
                        entryInfo.setIssMode(formulaEntryInfo.getPickingMode());
                        entryInfo.setProportion(formulaEntryInfo.getProportion());
                        entryInfo.setBaseConsumeFixQty(formulaEntryInfo.getConsumeFixBaseQty() == null ? new BigDecimal(0.0) : formulaEntryInfo.getConsumeFixBaseQty());
                        entryInfo.setConsumeFixQty(formulaEntryInfo.getConsumeFixQty());
                        entryInfo.setConsumeType(consumeType);
                        entryInfo.setRemark(formulaEntryInfo.getRemark());
                        entryInfo.setProvideType(formulaEntryInfo.getProvideType());
                        entryInfo.setSupplyOrgUnit(formulaEntryInfo.getSupplyStorageOrgUnit());
                        precision = formulaEntryInfo.getBaseUnit() == null || formulaEntryInfo.getBaseUnit().getQtyPrecision() < 1 ? 0 : formulaEntryInfo.getBaseUnit().getQtyPrecision();
                        multiBaseUnifInfo = multiUnit.getMultiUnit(entryInfo.getMaterial().getId().toString(), entryInfo.getBaseUnit().getId().toString());
                        if (multiBaseUnifInfo != null) {
                            precision = multiBaseUnifInfo.getQtyPrecision() < 1 ? 0 : multiBaseUnifInfo.getQtyPrecision();
                        }
                        double tempStandardQty = 0.0;
                        if (ConsumeTypeEnum.VariableAmount.equals((Object)consumeType)) {
                            double tempQty2;
                            tempStandardQty = tempQty2 = orderInfo.getBaseQty().doubleValue() / parentBaseQty * consumeFixBaseQty;
                            if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                                tempQty2 /= One - scrapRate;
                            } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                                tempQty2 *= One + scrapRate;
                            }
                            entryInfo.setBaseQty(new BigDecimal(tempQty2).divide(new BigDecimal(1.0), precision, 4));
                        } else if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                            double tempQty3;
                            tempStandardQty = tempQty3 = orderInfo.getBaseQty().doubleValue() * proportion;
                            if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                                tempQty3 /= One - scrapRate;
                            } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                                tempQty3 *= One + scrapRate;
                            }
                            double parentCoef = formulaEntryInfo.getParent().getBaseUnit().getCoefficient().doubleValue();
                            double childCoef = entryInfo.getBaseUnit().getCoefficient().doubleValue();
                            double baseExchangeRate = new BigDecimal(1).doubleValue();
                            if (parentCoef != childCoef) {
                                baseExchangeRate = parentCoef / childCoef;
                            }
                            entryInfo.setBaseQty(new BigDecimal(tempQty3 * baseExchangeRate).setScale(precision, 4));
                            tempStandardQty *= baseExchangeRate;
                        }
                        try {
                            if (entryInfo.getBaseQty() != null) {
                                entryInfo.setQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (MeasureUnitInfo)entryInfo.getUnit(), (BigDecimal)entryInfo.getBaseQty()));
                            }
                            entryInfo.setStandardQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (MeasureUnitInfo)entryInfo.getUnit(), (BigDecimal)new BigDecimal(tempStandardQty).setScale(precision, 4)));
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        entryInfo.setMaterialInventory(formulaEntryInfo.getMaterialInventory());
                        entryInfo.setLocation(formulaEntryInfo.getLocation());
                        WarehouseInfo warehouse = entryInfo.getDefaultWarehouse();
                        if (warehouse != null && warehouse.isHasLocation() && formulaEntryInfo.getLocation() == null) {
                            entryInfo.setLocation(MMUtils.getDefaultLocation((Context)ctx, (StorageOrgUnitInfo)orderInfo.getStorageOrgUnit(), (MaterialInfo)entryInfo.getMaterial(), (WarehouseInfo)warehouse));
                        }
                        entryInfo.setLineSeq(lineseq + 1 + AUDIT_GEN);
                        entryInfo.setOrigialQty(entryInfo.getQty());
                        entryInfo.setUnReceiptQty(entryInfo.getQty());
                        entryInfo.setUnReceiptBaseQty(entryInfo.getBaseQty());
                        this.updateStockEntryTransactionType(ctx, orderInfo.getStorageOrgUnit(), (ProductionOrderStockEntryInfo)entryInfo);
                        orderInfo.getStockEntry().add((ProductionOrderStockEntryInfo)entryInfo);
                        ++lineseq;
                    }
                    if (!MaterialProductEnum.RELATEDPRODUCT.equals((Object)formulaEntryInfo.getProductType()) && !MaterialProductEnum.BYPRODUCT.equals((Object)formulaEntryInfo.getProductType())) continue;
                    entryInfo = new ProductionOrderOutputEntryInfo();
                    entryInfo.setSourceBillId(formulaEntryInfo.getParent().getId().toString());
                    entryInfo.setSourceBillNumber(formulaEntryInfo.getParent().getNumber());
                    entryInfo.setSourceBillEntryId(formulaEntryInfo.getId().toString());
                    entryInfo.setSourceBillEntrySeq(formulaEntryInfo.getSeq());
                    entryInfo.setSourceBillType(formulaEntryInfo.getParent().getBillType());
                    entryInfo.setMaterial(material);
                    entryInfo.setModel(material.getModel());
                    entryInfo.setUnit(formulaEntryInfo.getUnit());
                    entryInfo.setBaseUnit(formulaEntryInfo.getBaseUnit());
                    entryInfo.setOutputType(formulaEntryInfo.getProductType());
                    entryInfo.setProductLineWP(formulaEntryInfo.getProductLineWP());
                    entryInfo.setRemark(formulaEntryInfo.getRemark());
                    entryInfo.setMaterialPlan(formulaEntryInfo.getMaterialInventory());
                    entryInfo.setConsumeFixQty(formulaEntryInfo.getConsumeFixQty());
                    entryInfo.setBaseConsumeFixQty(formulaEntryInfo.getConsumeFixBaseQty() == null ? new BigDecimal(0.0) : formulaEntryInfo.getConsumeFixBaseQty());
                    entryInfo.setProportion(formulaEntryInfo.getProportion());
                    entryInfo.setConsumeType(consumeType);
                    precision = formulaEntryInfo.getBaseUnit() == null || formulaEntryInfo.getBaseUnit().getQtyPrecision() < 1 ? 0 : formulaEntryInfo.getBaseUnit().getQtyPrecision();
                    multiBaseUnifInfo = multiUnit.getMultiUnit(entryInfo.getMaterial().getId().toString(), entryInfo.getBaseUnit().getId().toString());
                    if (multiBaseUnifInfo != null) {
                        int n = precision = multiBaseUnifInfo.getQtyPrecision() < 1 ? 0 : multiBaseUnifInfo.getQtyPrecision();
                    }
                    if (ConsumeTypeEnum.VariableAmount.equals((Object)consumeType)) {
                        tempQty = orderInfo.getBaseQty().doubleValue() / yield / parentBaseQty * consumeFixBaseQty;
                        if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                            tempQty /= One - scrapRate;
                        } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                            tempQty *= One + scrapRate;
                        }
                        entryInfo.setBaseQty(new BigDecimal(tempQty).divide(new BigDecimal(1.0), precision, 4));
                    } else if (ConsumeTypeEnum.Proportion.equals((Object)consumeType)) {
                        tempQty = orderInfo.getBaseQty().doubleValue() / yield * proportion;
                        if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
                            tempQty /= One - scrapRate;
                        } else if (scrapRateExpression != null && scrapRateExpression.equals((Object)MaterialScrapRateExpressionEnum.MUTIPLE)) {
                            tempQty *= One + scrapRate;
                        }
                        double parentCoef = formulaEntryInfo.getParent().getBaseUnit().getCoefficient().doubleValue();
                        double childCoef = entryInfo.getBaseUnit().getCoefficient().doubleValue();
                        double baseExchangeRate = new BigDecimal(1).doubleValue();
                        if (parentCoef != childCoef) {
                            baseExchangeRate = parentCoef / childCoef;
                        }
                        entryInfo.setBaseQty(new BigDecimal(tempQty * baseExchangeRate).setScale(precision, 4));
                    }
                    try {
                        if (entryInfo.getBaseQty() != null) {
                            entryInfo.setQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (MeasureUnitInfo)entryInfo.getUnit(), (BigDecimal)entryInfo.getBaseQty()));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    orderInfo.getOutputEntry().add((ProductionOrderOutputEntryInfo)entryInfo);
                }
            }
        }
    }

    protected void getWPEntrys(Context ctx, ProductionOrderInfo orderInfo) throws BOSException, ProductionOrderException {
        if (orderInfo.getProductLine() == null) {
            return;
        }
        EntityViewInfo wpViewInfo = new EntityViewInfo();
        FilterInfo wpFilterInfo = new FilterInfo();
        wpFilterInfo.getFilterItems().add(new FilterItemInfo("parent.status", (Object)new Integer(20), CompareType.EQUALS));
        wpFilterInfo.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)orderInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        wpFilterInfo.getFilterItems().add(new FilterItemInfo("parent.productline.id", (Object)orderInfo.getProductLine().getId().toString(), CompareType.EQUALS));
        wpFilterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(10), CompareType.EQUALS));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("parent.id");
        selectors.add("parent.number");
        selectors.add("resource.id");
        selectors.add("resource.equNumber");
        selectors.add("resource.name");
        wpViewInfo.setSelector(selectors);
        wpViewInfo.setFilter(wpFilterInfo);
        wpViewInfo.getSorter().add(new SorterItemInfo("number"));
        ProductLineWPEntryCollection wpEntryColls = ProductLineWPEntryFactory.getLocalInstance((Context)ctx).getProductLineWPEntryCollection(wpViewInfo);
        ProductionOrderEntryInfo entryInfo = null;
        ProductLineWPEntryInfo wpEntryInfo = null;
        if (wpEntryColls != null) {
            if (wpEntryColls.size() <= 0) {
                throw new ProductionOrderException(ProductionOrderException.NOPRODUCTLINEWP);
            }
            if (wpEntryColls.size() > 0) {
                for (int i = 0; i < wpEntryColls.size(); ++i) {
                    wpEntryInfo = wpEntryColls.get(i);
                    entryInfo = new ProductionOrderEntryInfo();
                    entryInfo.setProductLineWP(wpEntryInfo);
                    entryInfo.setPrdLineWPNumber(wpEntryInfo.getNumber());
                    entryInfo.setIsWP(wpEntryInfo.isIsWP());
                    entryInfo.setIsQCPoint(wpEntryInfo.isIsQCPoint());
                    entryInfo.setIsReportPoint(wpEntryInfo.isIsReportPoint());
                    entryInfo.setIsStockPoint(wpEntryInfo.isIsStockPoint());
                    entryInfo.setResource(wpEntryInfo.getResource());
                    entryInfo.setPrepareTime(wpEntryInfo.getPrepareTime());
                    entryInfo.setWorkTime(wpEntryInfo.getWorkTime());
                    entryInfo.setResource(wpEntryInfo.getResource());
                    entryInfo.setPrepTimeUnit(wpEntryInfo.getPrepTimeUnit());
                    entryInfo.setWorkTimeUnit(wpEntryInfo.getWorkTimeUnit());
                    entryInfo.setRemark(wpEntryInfo.getWPDescription());
                    entryInfo.setSourceBillId(wpEntryInfo.getParent().getId().toString());
                    entryInfo.setSourceBillNumber(wpEntryInfo.getParent().getNumber());
                    entryInfo.setSourceBillEntryId(wpEntryInfo.getId().toString());
                    entryInfo.setSourceBillEntrySeq(wpEntryInfo.getSeq());
                    orderInfo.getWpEntry().add(entryInfo);
                }
            }
        }
    }

    @Override
    protected boolean _released(Context ctx, IObjectPK prdPK) throws BOSException, ProductionOrderException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{prdPK});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchReleased(ctx, entrys);
        result.throwExceptions();
        return true;
    }

    @Override
    protected Map _unRelease(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchUnRelease(ctx, entrys);
        result.throwExceptions();
        return null;
    }

    @Override
    protected void _unBackFlush(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchUnBackFlush(ctx, entrys);
        result.throwExceptions();
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String number;
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(pk.getKeyValue(null).toString());
        Iterator it = idSet.iterator();
        boolean count = false;
        String fStorageOrgUnitID = "";
        String sql = "select fnumber,fStorageOrgUnitID,fbasestatus from t_mm_productionorder where fid ='" + pk.getKeyValue(null).toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer stateErr = new StringBuffer();
        StringBuffer errStr = new StringBuffer();
        try {
            while (rs.next()) {
                int status = rs.getInt("fbasestatus");
                fStorageOrgUnitID = rs.getString("fStorageOrgUnitID");
                number = rs.getString("fnumber");
                if (status == 7) continue;
                stateErr.append(number + ",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = "select fnumber from t_mm_productionorder where fid ='" + pk.getKeyValue(null).toString() + "' and FOutSourceFlag = 1 ";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer outsourceStr = new StringBuffer();
        try {
            while (rs.next()) {
                number = rs.getString("fnumber");
                outsourceStr.append(number + ",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (stateErr.length() > 0) {
            errStr.append(this.getResourceMsg2("unCloseErr", new String[]{stateErr.replace(stateErr.length() - 1, stateErr.length(), "").toString()}, ctx) + "\n");
        }
        if (outsourceStr.length() > 0) {
            errStr.append(this.getResourceMsg2("unCloseErr2", new String[]{outsourceStr.replace(outsourceStr.length() - 1, outsourceStr.length(), "").toString()}, ctx) + "\n");
        }
        if (errStr.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.UNCLOSEERR, new Object[]{errStr.toString()});
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" update t_mm_productionorder set fbasestatus = 8 where fid ='" + pk.getKeyValue(null).toString() + "'");
        sqlList.add(sqlBuff.toString());
        DBBatchUtil.executeBatch((Context)ctx, sqlList);
        String[] idss = new String[idSet.size()];
        idSet.toArray(idss);
        LotFacadeFactory.getLocalInstance((Context)ctx).productionOrderUnCloseLot(idss);
        this.updateReqPlanData(ctx, new IObjectPK[]{pk}, 303);
    }

    @Override
    protected void _unFinishedWork(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IProductionOrderFacade ibiz;
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(pk.getKeyValue(null).toString());
        Iterator it = idSet.iterator();
        boolean count = false;
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(pk.getKeyValue(null).toString());
        StringBuffer errStr = new StringBuffer();
        String sql = "select fnumber from t_mm_productionorder where fid ='" + pk.getKeyValue(null).toString() + "' and FOutSourceFlag = 1 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer outsourceStr = new StringBuffer();
        try {
            while (rs.next()) {
                String number = rs.getString("fnumber");
                outsourceStr.append(number + ",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (outsourceStr.length() > 0) {
            errStr.append(this.getResourceMsg2("unFinishedWork3", new String[]{outsourceStr.replace(outsourceStr.length() - 1, outsourceStr.length(), "").toString()}, ctx) + "\n");
        }
        sql = "select fnumber from t_mm_productionorder where fid ='" + pk.getKeyValue(null).toString() + "' and (fbasestatus<>" + 8 + " or (fbasestatus = " + 8 + " and FIsManualFinish=0))";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer statusStr = new StringBuffer();
        try {
            while (rs.next()) {
                String number = rs.getString("fnumber");
                statusStr.append(number + ",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (statusStr.length() > 0) {
            errStr.append(this.getResourceMsg2("unFinishedWork", new String[]{statusStr.replace(statusStr.length() - 1, statusStr.length(), "").toString()}, ctx) + "\n");
        }
        if ((ibiz = ProductionOrderFacadeFactory.getLocalInstance(ctx)).isAutoFinished(pk.getKeyValue(null).toString())) {
            errStr.append(this.getResourceMsg2("unFinishedWork4", new String[]{""}, ctx) + "\n");
        }
        if (errStr.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.UNFINISHEDWORKERR, new Object[]{errStr.toString()});
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        sql = "update T_MM_TaskDispBill set fbasestatus = 4,FIsManualFinish = 0 where FProductionOrderID ='" + pk.getKeyValue(null).toString() + "' and FIsManualFinish = 1";
        sqlList.add(sql);
        sql = "update t_mm_productionorder set fbasestatus =5,FIsManualFinish = 0,FActualEndDate=null where fid ='" + pk.getKeyValue(null).toString() + "' and FOutSourceFlag = 0 and FIsManualFinish = 1 and fbasestatus = " + 8;
        sqlList.add(sql);
        DBBatchUtil.executeBatch((Context)ctx, sqlList);
        ProductionOrderFacadeFactory.getLocalInstance(ctx).updatePLSStatus(idList, false);
    }

    private void updateReqPlanData(Context ctx, IObjectPK[] prdPks, int bizAction) throws BOSException, EASBizException {
        if (prdPks != null && prdPks.length > 0) {
            String IDSet = StringUtils.arrayToString((Object[])prdPks, (String)"','");
            IReqPlanReceiveReqDataFacade reqPlanReceiveReqDataFacade = ReqPlanReceiveReqDataFacadeFactory.getLocalInstance((Context)ctx);
            reqPlanReceiveReqDataFacade.receiveReqPlanDate("ejIZHXXTQliYCQJg9t4Re0Y+1VI=", "'" + IDSet + "'", bizAction);
        }
    }

    @Override
    protected ProductionOrderInfo _plsBuildPrdInfo(Context ctx, ProductionOrderInfo orderInfo) throws BOSException, EASBizException {
        PrdLotServerUtils.dealLotNo(ctx, orderInfo);
        this._buildEntrys(ctx, orderInfo);
        this.checkPrdOrderEntrySubmit(ctx, (IObjectValue)orderInfo);
        return orderInfo;
    }

    @Override
    protected String _genPrdOrder(Context ctx, ProductionOrderInfo PrdOrderInfo) throws BOSException, EASBizException {
        this.setNullToDefault(ctx, (IObjectValue)PrdOrderInfo);
        this.setyield(ctx, (IObjectValue)PrdOrderInfo);
        this.setExpectOutputQty(ctx, (IObjectValue)PrdOrderInfo);
        PrdOrderInfo.setCreator(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
        PrdOrderInfo.setCreateTime(new Timestamp(new Date().getTime()));
        PrdOrderInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        BillTypeInfo billTypeInfo = SCMServerUtils.getBillType((String)"ejIZHXXTQliYCQJg9t4Re0Y+1VI=");
        billTypeInfo.setNumber("600");
        PrdOrderInfo.setBillType(billTypeInfo);
        PrdOrderInfo.setMmBizType(BizTypeEnum.common);
        PrdOrderInfo.setBizDate(new Date());
        if (PrdOrderInfo.getProductLine() != null) {
            PrdOrderInfo.setWorkShop(PrdOrderInfo.getProductLine().getWorkshop());
        }
        BOSUuid id = BOSUuid.create((BOSObjectType)PrdOrderInfo.getBOSType());
        PrdOrderInfo.setId(id);
        if (PrdOrderInfo.getBizDate() != null && PrdOrderInfo.getStorageOrgUnit() != null) {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)PrdOrderInfo, PrdOrderInfo.getStorageOrgUnit().getId().toString())) {
                String numbers = codingRuleManager.getNumber((IObjectValue)PrdOrderInfo, PrdOrderInfo.getStorageOrgUnit().getId().toString(), 1L);
                PrdOrderInfo.setNumber(numbers);
            } else {
                PrdOrderInfo.setNumber(PrdOrderInfo.getId().toString());
            }
        }
        this.checkPrdOrderSubmit(ctx, (IObjectValue)PrdOrderInfo);
        this._buildEntrys(ctx, PrdOrderInfo);
        this.dealPrdOrderInfoEntry(ctx, PrdOrderInfo);
        PrdLotServerUtils.dealLotNo(ctx, PrdOrderInfo);
        this._submit(ctx, (IObjectValue)PrdOrderInfo);
        return PrdOrderInfo.getId().toString();
    }

    private void dealPrdOrderInfoEntry(Context ctx, ProductionOrderInfo PrdOrderInfo) throws BOSException {
        if (PrdOrderInfo.getStockEntry() != null) {
            ProductionOrderStockEntryCollection prdOrderStockColl = PrdOrderInfo.getStockEntry();
            for (int i = 0; i < prdOrderStockColl.size(); ++i) {
                ProductionOrderStockEntryInfo prdOrderStockInfo;
                prdOrderStockInfo.setConsumeType((prdOrderStockInfo = prdOrderStockColl.get(i)).getConsumeType() == null ? ConsumeTypeEnum.VariableAmount : prdOrderStockInfo.getConsumeType());
                if (ConsumeTypeEnum.VariableAmount == prdOrderStockInfo.getConsumeType()) {
                    prdOrderStockInfo.setProportion(new BigDecimal(0));
                } else if (ConsumeTypeEnum.Proportion == prdOrderStockInfo.getConsumeType()) {
                    prdOrderStockInfo.setConsumeFixQty(new BigDecimal(0));
                }
                if (MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE == prdOrderStockInfo.getProvideType()) {
                    prdOrderStockInfo.setProvideType(MaterialProvideTypeEnum.SPANORGPROVIDE);
                }
                if (MaterialProvideTypeEnum.SPANORGPROVIDE == prdOrderStockInfo.getProvideType()) {
                    prdOrderStockInfo.setIsStock(false);
                    prdOrderStockInfo.setMoveOutStorageOrgUnit(null);
                    prdOrderStockInfo.setMoveOutWarehouse(null);
                }
                prdOrderStockInfo.setStartDate(PrdOrderInfo.getStartDate());
                prdOrderStockInfo.setEndDate(PrdOrderInfo.getEndDate());
                prdOrderStockInfo.setSendOutTotalQty(new BigDecimal(0));
                prdOrderStockInfo.setUntreadTotalQty(new BigDecimal(0));
                prdOrderStockInfo.setBaseSendOutTotalQty(new BigDecimal(0));
                prdOrderStockInfo.setBaseUntreadTotalQty(new BigDecimal(0));
                prdOrderStockInfo.setTotleReceiveQty(new BigDecimal(0));
                prdOrderStockInfo.setBaseTotleReceiveQty(new BigDecimal(0));
                prdOrderStockInfo.setReplaceFlag(false);
                if (!prdOrderStockInfo.isIsStock()) {
                    prdOrderStockInfo.setMoveOutStorageOrgUnit(null);
                    prdOrderStockInfo.setMoveOutWarehouse(null);
                }
                if (prdOrderStockInfo.getDefaultWarehouse() == null || !prdOrderStockInfo.getDefaultWarehouse().isHasLocation()) {
                    prdOrderStockInfo.setLocation(null);
                }
                prdOrderStockInfo.setLineSeq(i + 1 + AUDIT_GEN);
            }
        }
    }

    private boolean isLotNumber(Context ctx, String materialId, String storageOrgUnitId) throws BOSException {
        MaterialInventoryInfo invInfo;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        EntityViewInfo viewer = new EntityViewInfo();
        viewer.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isLotNumber");
        viewer.setSelector(selector);
        MaterialInventoryCollection inv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewer);
        return inv.size() > 0 && (invInfo = inv.get(0)).isIsLotNumber();
    }

    @Override
    protected void _updateRemark(Context ctx, String orderID, String remark) throws BOSException, EASBizException {
        if (orderID == null || remark == null) {
            return;
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_ProductionOrder ").append("set FRemark_").append(ProductionOrderControllerBean.getLocale()).append(" = ? ").append("where FID = ? ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{remark, orderID});
    }

    public BatchActionResults batchDiscard(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("DISCARD"));
    }

    public BatchActionResults batchGenPicking(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("GENPICKING"));
    }

    public BatchActionResults batchOutSource(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("OUTSOURCE"));
    }

    public BatchActionResults batchReleased(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("RELEASED"));
    }

    public BatchActionResults batchUnRelease(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("UNRELEASE"));
    }

    public BatchActionResults batchBackFlush(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("BACKFLUSH"));
    }

    public BatchActionResults batchUnBackFlush(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, new BatchActionEnum("UNBACKFLUSH"));
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.getToDoIdsArray().length > 0) {
            if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                this.doAudit(ctx, batchResults);
            } else if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
                this.doUnAudit(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("DISCARD")) {
                this.doDiscard(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("OUTSOURCE")) {
                this.doOutSource(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("GENPICKING")) {
                this.doGenPicking(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("BACKFLUSH")) {
                this.doBackFlush(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("UNBACKFLUSH")) {
                this.doUnBackFlush(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("RELEASED")) {
                this.doReleased(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("UNRELEASE")) {
                this.doUnRelease(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("GENMATERIALREQ")) {
                this.doGenMaterialReq(ctx, batchResults);
            } else if (batchAction.getBizAction().equalsIgnoreCase("GENMANUREC")) {
                this.doGenManuRec(ctx, batchResults);
            } else if (batchAction.equals((Object)BatchActionEnum.SAVE)) {
                this.dealLotNumber(ctx, batchResults);
            }
        }
    }

    private void doGenManuRec(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (ctx.get((Object)"BOTPMAPPING") != null && ctx.get((Object)"idList") != null) {
            Set toDoIds = batchResults.getToDoIdsSet();
            String[] srcIds = (String[])ctx.get((Object)"idList");
            String[] entrieNames = (String[])ctx.get((Object)"entryNames");
            List entriesKeys = (List)ctx.get((Object)"entriesKey");
            String botMapId = (String)ctx.get((Object)"BOTPMAPPING");
            try {
                IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                BTPTransformResult bTPTransformResult = iBTPManager.transformForBotp(batchResults.getToDoIdsArray(), entrieNames, entriesKeys, null, "FA1292B4", (IObjectPK)new ObjectUuidPK(botMapId), "1F66774E");
            }
            catch (BTPException e) {
                Iterator ite = toDoIds.iterator();
                while (ite.hasNext()) {
                    batchResults.addError(ite.next().toString(), (Exception)((Object)e));
                }
            }
        }
    }

    private void doGenMaterialReq(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (ctx.get((Object)"BOTPMAPPING") != null && ctx.get((Object)"idList") != null) {
            Set toDoIds = batchResults.getToDoIdsSet();
            String[] srcIds = (String[])ctx.get((Object)"idList");
            String[] entrieNames = (String[])ctx.get((Object)"entryNames");
            List entriesKeys = (List)ctx.get((Object)"entriesKey");
            String botMapId = (String)ctx.get((Object)"BOTPMAPPING");
            try {
                IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                BTPTransformResult bTPTransformResult = iBTPManager.transformForBotp(batchResults.getToDoIdsArray(), entrieNames, entriesKeys, null, "500AB75E", (IObjectPK)new ObjectUuidPK(botMapId), "1F66774E");
            }
            catch (BTPException e) {
                Iterator ite = toDoIds.iterator();
                while (ite.hasNext()) {
                    batchResults.addError(ite.next().toString(), (Exception)((Object)e));
                }
            }
        }
    }

    private void doUnAudit(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] prdPks = batchResults.getToDoIdsArray();
        String ids = this.stringArrayToStringBuffer(prdPks).toString();
        ArrayList<String> havSrcIDLst = new ArrayList<String>();
        IRowSet rowSet = null;
        StringBuffer kql = new StringBuffer();
        kql.append(" select ");
        kql.append(" ordT.fid fid");
        kql.append(",ordT.fNumber number");
        kql.append(",ordT.fBaseStatus baseStatus");
        kql.append(",ordT.fBillTypeID billType");
        kql.append(",ordT.fStorageOrgUnitID orgUnit");
        kql.append(",ordT.fSourceBillEntryID fSourceBillEntryID");
        kql.append(" from ");
        kql.append(" t_mm_productionOrder as ordT ");
        kql.append(" where ");
        kql.append(" ordT.fid in (");
        kql.append(ids);
        kql.append(")");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
        try {
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString("fSourceBillEntryID"))) continue;
                havSrcIDLst.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update ");
        updateSql.append(" t_mm_productionOrder ");
        updateSql.append(" set ");
        updateSql.append(" FBaseStatus=1");
        updateSql.append(",fauditorId=null");
        updateSql.append(",fauditTime=null");
        updateSql.append(" where fid in (" + ids + ")");
        StringBuffer writeBackSql = new StringBuffer();
        if (!havSrcIDLst.isEmpty()) {
            StringBuffer srcIDBuff = new StringBuffer();
            for (int sr = 0; sr < havSrcIDLst.size(); ++sr) {
                srcIDBuff.append("'");
                srcIDBuff.append(havSrcIDLst.get(sr).toString());
                srcIDBuff.append("'");
                srcIDBuff.append(",");
            }
            srcIDBuff = srcIDBuff.replace(srcIDBuff.length() - 1, srcIDBuff.length(), "");
            writeBackSql.append(" update ");
            writeBackSql.append(" t_mm_plsEntry ");
            writeBackSql.append(" set ");
            writeBackSql.append(" fBaseStatus=5");
            writeBackSql.append(" where ");
            writeBackSql.append(" fid in (");
            writeBackSql.append("select fSourceBillEntryID from t_mm_productionOrder where fid in (" + srcIDBuff.toString() + ")");
            writeBackSql.append(")");
        }
        Connection conn = null;
        Statement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.createStatement();
            batchStatement.addBatch(updateSql.toString());
            if (writeBackSql.length() > 0) {
                batchStatement.addBatch(writeBackSql.toString());
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        this.dealCostObje(ctx, ids, false);
        this.updateReqPlanData(ctx, batchResults.getToDoPkArray(), 109);
        FinishedRptFactory.getLocalInstance(ctx).writeBackReworkRepairQty(batchResults.getToDoIdsList(), false);
        LotFacadeFactory.getLocalInstance((Context)ctx).productionOrderDeleteLotSouce(prdPks);
    }

    private void doAudit(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] prdPks = batchResults.getToDoIdsArray();
        String ids = this.stringArrayToStringBuffer(prdPks).toString();
        ArrayList<String> havSrcIDLst = new ArrayList<String>();
        ArrayList<String> genPickIDLst = new ArrayList<String>();
        StringBuffer kql = new StringBuffer();
        kql.append(" select ");
        kql.append(" ordT.FNumber number");
        kql.append(",ordT.FQty qty");
        kql.append(",ordT.fSourceBillEntryID fSourceBillEntryID");
        kql.append(",ordT.fid fid");
        kql.append(",ordT.fStorageOrgUnitID fStorageOrgUnitID");
        kql.append(",ordT.FMmBizType FMmBizType");
        kql.append(",s.fparentid FParentID");
        kql.append(",sum(case when s.Fqty = 0 or s.FIsBackFlush = 1 or s.FIssMode != 11010  then 0 else 1 end) sum ");
        kql.append(" from ");
        kql.append(" T_MM_ProductionOrder AS ordT ");
        kql.append(" left join T_MM_ProductionOrderSEntry s");
        kql.append(" on ordT.fid = s.fparentid");
        kql.append(" where ");
        kql.append(" ordT.FID in (");
        kql.append(ids);
        kql.append(")");
        kql.append(" group by ordT.FNumber,ordT.FQty,ordT.fSourceBillEntryID, ordT.fid, ordT.fStorageOrgUnitID, ordT.FMmBizType, s.fparentid");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
        ParamUtil paramUtil = new ParamUtil(ctx);
        String relType = null;
        String autoGen = null;
        String genTime = null;
        String enabledPick = null;
        String enableReport = null;
        int mmbizeType = 0;
        try {
            while (rowSet.next()) {
                if (!StringUtils.isEmpty((String)rowSet.getString("fSourceBillEntryID"))) {
                    havSrcIDLst.add(rowSet.getString("fid"));
                }
                String fStorageOrgUnitID = rowSet.getString("fStorageOrgUnitID");
                paramUtil.setStorageOrgUnitID(fStorageOrgUnitID, false);
                relType = paramUtil.getTaskDispTypeParam(RELEASE_NOT);
                autoGen = paramUtil.getAutoGenPickBillParam("false");
                genTime = paramUtil.getAutoGenPickBillTimeParam(AUDIT_GEN);
                enabledPick = paramUtil.getEnabledPickBillParam(GENCOST_NOT);
                enableReport = paramUtil.getEnabledProductionReportParam(GENCOST_NOT);
                mmbizeType = rowSet.getInt("FMmBizType");
                if (!GENCOST_NOT.equals(enabledPick) || GENCOST_NOT.equals(enableReport) && !RELEASE_NOT.equals(relType) || !GENCOST_NOT.equals(autoGen) || rowSet.getInt("sum") <= 0 || !AUDIT_GEN.equals(genTime) || (20 == mmbizeType || 30 == mmbizeType) && rowSet.getString("FParentID") == null) continue;
                genPickIDLst.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        LotFacadeFactory.getLocalInstance((Context)ctx).productionOrderInsertLotSouce(prdPks);
        ArrayList<String> updateSqls = new ArrayList<String>();
        StringBuffer updateSql = new StringBuffer();
        for (int i = 0; i < prdPks.length; ++i) {
            updateSql.setLength(0);
            updateSql.append(" update ");
            updateSql.append(" t_mm_productionOrder ");
            updateSql.append(" set ");
            updateSql.append(" FBaseStatus=4");
            updateSql.append(",fauditorId='" + ctx.getCaller().toString() + "'");
            updateSql.append(",fauditTime = now()");
            updateSql.append(" where fid = '" + prdPks[i] + "'");
            updateSqls.add(updateSql.toString());
        }
        StringBuffer writeBackSql = new StringBuffer();
        if (havSrcIDLst != null && !havSrcIDLst.isEmpty()) {
            StringBuffer srcIDBuff = new StringBuffer();
            for (int sr = 0; sr < havSrcIDLst.size(); ++sr) {
                srcIDBuff.append("'");
                srcIDBuff.append(havSrcIDLst.get(sr).toString());
                srcIDBuff.append("'");
                srcIDBuff.append(",");
            }
            srcIDBuff = srcIDBuff.replace(srcIDBuff.length() - 1, srcIDBuff.length(), "");
            writeBackSql.append(" update ");
            writeBackSql.append(" t_mm_plsEntry ");
            writeBackSql.append(" set ");
            writeBackSql.append(" fBaseStatus=8");
            writeBackSql.append(" where ");
            writeBackSql.append(" fid in (");
            writeBackSql.append("select fSourceBillEntryID from t_mm_productionOrder where fid in (" + srcIDBuff.toString() + ")");
            writeBackSql.append(")");
        }
        Connection conn = null;
        Statement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.createStatement();
            for (int i = 0; i < updateSqls.size(); ++i) {
                batchStatement.addBatch(updateSqls.get(i).toString());
            }
            if (writeBackSql.length() > 0) {
                batchStatement.addBatch(writeBackSql.toString());
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        if (genPickIDLst != null && !genPickIDLst.isEmpty()) {
            StringBuffer genBuff = new StringBuffer();
            for (int i = 0; i < genPickIDLst.size(); ++i) {
                genBuff.append("'");
                genBuff.append(genPickIDLst.get(i).toString());
                genBuff.append("'");
                genBuff.append(",");
            }
            this.genPickingExecute(ctx, genBuff.substring(0, genBuff.length() - 1), true);
        }
        this.dealCostObje(ctx, ids, true);
        this.updateReqPlanData(ctx, batchResults.getToDoPkArray(), 103);
        FinishedRptFactory.getLocalInstance(ctx).writeBackReworkRepairQty(batchResults.getToDoIdsList(), true);
    }

    private void doUnRelease(Context ctx, BatchActionResults batchResults) throws BOSException {
        IObjectPK[] prdPks = batchResults.getToDoPkArray();
        String ids = this.pkArrayToString(prdPks);
        if (ids.length() > 0) {
            String sql = "delete from t_mm_taskdispbill where FProductionOrderID in (" + ids + ")";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "delete from t_bot_relation where FSrcEntityID = '" + new ProductionOrderInfo().getBOSType().toString() + "' and FDestEntityID = '" + new TaskDispBillInfo().getBOSType().toString() + "' and FSrcObjectID in (" + ids + ")";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "delete from t_mm_finishedrpt where FProductionOrderID in (" + ids + ")";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "delete from t_bot_relation where FSrcEntityID = '" + new ProductionOrderInfo().getBOSType().toString() + "' and FDestEntityID = '" + new FinishedRptInfo().getBOSType().toString() + "' and FSrcObjectID in (" + ids + ")";
            DbUtil.execute((Context)ctx, (String)sql);
            sql = "update t_mm_productionorder set fbasestatus = 4 where fid in (" + ids + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReleased(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException, SQLDataException, DataAccessException {
        IObjectPK[] prdPks = batchResults.getToDoPkArray();
        String strIdLists = this.pkArrayToString(prdPks);
        StringBuffer immeBuff = new StringBuffer();
        StringBuffer shiftBuff = new StringBuffer();
        StringBuffer noReleaseBuff = new StringBuffer();
        ArrayList<String> genPickIDLst = new ArrayList<String>();
        String relType = RELEASE_NOT;
        String genTime = AUDIT_GEN;
        String autoGen = GENCOST_NOT;
        String enabledPick = GENCOST_NOT;
        String enableReport = GENCOST_NOT;
        HashSet<String> shiftIds = new HashSet<String>();
        StringBuffer sql_statusCheck = new StringBuffer();
        sql_statusCheck.append("select ordT.fid,ordT.fnumber,ordT.FOutSourceFlag,ordT.fbasestatus,ordT.fclassTeamID,ordT.fStorageOrgUnitID,ordT.fIsPickSlip,ordT.fstartDate");
        sql_statusCheck.append(",sum(case when s.Fqty = 0 or s.FIsBackFlush = 1 or s.FIssMode != 11010  then 0 else 1 end) sum ");
        sql_statusCheck.append(" from t_mm_productionorder ordT");
        sql_statusCheck.append(" left join T_MM_ProductionOrderSEntry s");
        sql_statusCheck.append(" on ordT.fid = s.fparentid");
        sql_statusCheck.append(" where ordT.fid in (" + strIdLists + ")");
        sql_statusCheck.append(" group by ordT.fid,ordT.fnumber, ordT.FOutSourceFlag,ordT.FBaseStatus,ordT.fclassTeamID,ordT.fStorageOrgUnitID, ordT.fid, ordT.fStorageOrgUnitID, ordT.fIsPickSlip,ordT.fstartDate ");
        IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck.toString());
        try {
            ParamUtil paramUtil = new ParamUtil(ctx);
            while (rowStatus.next()) {
                String fid = rowStatus.getString("fid");
                String fclassTeamID = rowStatus.getString("fclassTeamID");
                String fStorageOrgUnitID = rowStatus.getString("fStorageOrgUnitID");
                boolean fIsPickSlip = rowStatus.getBoolean("fIsPickSlip");
                paramUtil.setStorageOrgUnitID(fStorageOrgUnitID, false);
                relType = paramUtil.getTaskDispTypeParam(RELEASE_NOT);
                genTime = paramUtil.getAutoGenPickBillTimeParam(AUDIT_GEN);
                autoGen = paramUtil.getAutoGenPickBillParam(GENCOST_NOT);
                enabledPick = paramUtil.getEnabledPickBillParam(GENCOST_NOT);
                enableReport = paramUtil.getEnabledProductionReportParam(GENCOST_NOT);
                if (!GENCOST_NOT.equals(enableReport) || RELEASE_NOT.equals(relType) || fIsPickSlip) {
                    noReleaseBuff.append("'");
                    noReleaseBuff.append(fid);
                    noReleaseBuff.append("'");
                    noReleaseBuff.append(",");
                    if (!GENCOST_NOT.equals(enabledPick) || !GENCOST_NOT.equals(autoGen) || rowStatus.getInt("sum") <= 0 || AUDIT_GEN.equals(genTime)) continue;
                    genPickIDLst.add(rowStatus.getString("fid"));
                    continue;
                }
                if (RELEASE_IMMEDIATE.equals(relType)) {
                    immeBuff.append("'");
                    immeBuff.append(fid);
                    immeBuff.append("'");
                    immeBuff.append(",");
                    continue;
                }
                if (!RELEASE_SHIFT.equals(relType)) continue;
                if (!StringUtils.isEmpty((String)fclassTeamID)) {
                    immeBuff.append("'");
                    immeBuff.append(fid);
                    immeBuff.append("'");
                    immeBuff.append(",");
                    continue;
                }
                shiftBuff.append("'");
                shiftBuff.append(fid);
                shiftBuff.append("'");
                shiftBuff.append(",");
                shiftIds.add(fid);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (immeBuff.length() > 0) {
            immeBuff = immeBuff.replace(immeBuff.length() - 1, immeBuff.length(), "");
        }
        if (shiftBuff.length() > 0) {
            shiftBuff = shiftBuff.replace(shiftBuff.length() - 1, shiftBuff.length(), "");
        }
        if (noReleaseBuff.length() > 0) {
            noReleaseBuff = noReleaseBuff.replace(noReleaseBuff.length() - 1, noReleaseBuff.length(), "");
        }
        if (noReleaseBuff.length() > 0) {
            String updateSql = " update t_mm_productionOrder set fbasestatus=5 where fid in (" + noReleaseBuff.toString() + ") ";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        if (immeBuff.length() > 0 || shiftBuff.length() > 0) {
            String creatorID = ctx.getCaller().toString();
            if (immeBuff.length() > 0) {
                StringBuffer sqlBuffer = new StringBuffer();
                sqlBuffer.append("Insert into t_mm_taskdispbill(FID,FPRODUCTLINEID,FMATERIALID,FSTORAGEORGUNITID,FCONTROLUNITID,FProductionOrderID,FTraceNo,FUnitID,FBaseUnitID,FWorkShopID,FSourceBillID,FSTARTDATE,FENDDATE,FProductQty,FBaseProductQty,FBaseStatus,FCREATETIME,FCREATORID,FSaleOrderID,FBizDate,FClassGroupID,FShiftID,FPersonID,FSourceBillTypeID,FBillTypeID,FBusinessType,FTrackNumberID,FRemark) \n");
                sqlBuffer.append("select newbosid('4D11B6D5'),r2.FPRODUCTLINEID,r2.fmaterialid,r2.fstorageorgunitid,r2.fcontrolunitid,r2.fid,r2.FTraceNo,r2.FUnitID,r2.FBaseUnitID,r2.FWorkShopID,r2.fid,r2.fstartdate,r2.fenddate,r2.fqty,r2.fbaseqty,1,now(),'" + creatorID + "',r2.FSaleOrderID,now(),r2.fClassGroupID,r2.fClassTeamID,r2.fPersonID,'" + "ejIZHXXTQliYCQJg9t4Re0Y+1VI=" + "','" + "Tgx4hbjrTRCki6pl2V5aLkY+1VI=" + "',r2.FMmBizType,r2.FTrackNumberID,r2.FRemark_").append(ProductionOrderControllerBean.getLocale()).append(" \n");
                sqlBuffer.append("from t_mm_productionorder r2 \n");
                sqlBuffer.append(" where fid in (" + immeBuff.toString() + ") \n");
                DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
            }
            if (shiftBuff.length() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", shiftIds, CompareType.INCLUDE));
                EntityViewInfo env = new EntityViewInfo();
                env.setFilter(filter);
                ProductionOrderCollection prdColls = ProductionOrderFactory.getLocalInstance(ctx).getProductionOrderCollection(env);
                ProductionOrderInfo prdInfo = null;
                filter = new FilterInfo();
                for (int i = 0; i < prdColls.size(); ++i) {
                    FilterInfo multiFilter = new FilterInfo();
                    prdInfo = prdColls.get(i);
                    multiFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)prdInfo.getMaterial().getId().toString(), CompareType.EQUALS));
                    multiFilter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)prdInfo.getUnit().getId().toString(), CompareType.EQUALS));
                    multiFilter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)prdInfo.getBaseUnit().getId().toString(), CompareType.EQUALS));
                    multiFilter.setMaskString("#0 and (#1 or #2)");
                    filter.mergeFilter(multiFilter, "OR");
                }
                env = new EntityViewInfo();
                env.setFilter(filter);
                MultiMeasureUnitCollection multiUnitColls = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(env);
                filter = new FilterInfo();
                for (int i = 0; i < prdColls.size(); ++i) {
                    FilterInfo ctFilter = new FilterInfo();
                    prdInfo = prdColls.get(i);
                    ctFilter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)prdInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
                    ctFilter.getFilterItems().add(new FilterItemInfo("parent.workDay", (Object)new Integer(1), CompareType.EQUALS));
                    ctFilter.getFilterItems().add(new FilterItemInfo("productLine.id", (Object)prdInfo.getProductLine().getId().toString(), CompareType.EQUALS));
                    ctFilter.getFilterItems().add(new FilterItemInfo("ability", (Object)new Integer(0), CompareType.GREATER));
                    ctFilter.getFilterItems().add(new FilterItemInfo("startTime", (Object)prdInfo.getStartDate(), CompareType.GREATER_EQUALS));
                    ctFilter.getFilterItems().add(new FilterItemInfo("startTime", (Object)prdInfo.getEndDate(), CompareType.LESS_EQUALS));
                    ctFilter.getFilterItems().add(new FilterItemInfo("endTime", (Object)prdInfo.getStartDate(), CompareType.GREATER_EQUALS));
                    ctFilter.getFilterItems().add(new FilterItemInfo("endTime", (Object)prdInfo.getEndDate(), CompareType.LESS_EQUALS));
                    ctFilter.getFilterItems().add(new FilterItemInfo("startTime", (Object)prdInfo.getEndDate(), CompareType.LESS));
                    ctFilter.setMaskString("#0 and #1 and  #2 and #3 and ((#4 and #5) or (#6 and #7 and #8))");
                    filter.mergeFilter(ctFilter, "OR");
                }
                env = new EntityViewInfo();
                env.setFilter(filter);
                EquipmentCalendarEntryCollection equColls = EquipmentCalendarEntryFactory.getLocalInstance((Context)ctx).getEquipmentCalendarEntryCollection(env);
                TaskDispBillCollection task = new TaskDispBillCollection();
                for (int i = 0; i < prdColls.size(); ++i) {
                    EquipmentCalendarEntryCollection entryColls;
                    prdInfo = prdColls.get(i);
                    TaskDispBillCollection afterTask = this.genTaskDispBill(ctx, prdInfo, multiUnitColls, entryColls = this.filterEquipmentCalendar(ctx, prdInfo.getStartDate(), prdInfo.getEndDate(), equColls, true));
                    if (afterTask != null && afterTask.size() > 0) {
                        task.addCollection(afterTask);
                        continue;
                    }
                    entryColls = this.filterEquipmentCalendar(ctx, prdInfo.getStartDate(), prdInfo.getEndDate(), equColls, false);
                    TaskDispBillCollection beforeTask = this.genTaskDispBill(ctx, prdInfo, multiUnitColls, entryColls);
                    task.addCollection(beforeTask);
                }
                Connection cn = null;
                try {
                    cn = this.getConnection(ctx);
                    IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new TaskDispBillInfo().getBOSType(), (Context)ctx, (Connection)cn);
                    for (int i = 0; i < task.size(); ++i) {
                        dao.addNewBatch((IObjectValue)task.get(i));
                    }
                    dao.executeBatch();
                }
                finally {
                    SQLUtils.cleanup((Connection)cn);
                }
            }
            String sql = "select fid,fsourcebillid,fstorageorgunitid,fmaterialid,fLotNo from t_mm_taskdispbill where fsourcebillid in (" + strIdLists + ")";
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
            Connection conn = null;
            Statement batchStatement = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                batchStatement = conn.createStatement();
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                ArrayList<String> orgList = new ArrayList<String>();
                HashMap<String, BigDecimal> orgNum = new HashMap<String, BigDecimal>();
                HashMap<String, String[]> bacthNum = new HashMap<String, String[]>();
                HashMap<String, BigDecimal> bacthNumSet = new HashMap<String, BigDecimal>();
                while (row.next()) {
                    String fstorageorgunitid = row.getString("fstorageorgunitid");
                    if (orgList.indexOf(fstorageorgunitid) < 0) {
                        orgList.add(fstorageorgunitid);
                        orgNum.put(fstorageorgunitid, new BigDecimal(1));
                        continue;
                    }
                    orgNum.put(fstorageorgunitid, ((BigDecimal)orgNum.get(fstorageorgunitid)).add(new BigDecimal(1)));
                }
                TaskDispBillInfo taskInfo = new TaskDispBillInfo();
                taskInfo.setBizDate(new Date());
                taskInfo.setCU(this.getControlUnit(ctx));
                for (int i = 0; i < orgList.size(); ++i) {
                    String orgId = (String)orgList.get(i);
                    String[] number = codingRuleManager.getBatchNumber((IObjectValue)taskInfo, orgId, ((BigDecimal)orgNum.get(orgId)).intValue());
                    bacthNum.put(orgId, number);
                }
                row.beforeFirst();
                while (row.next()) {
                    String fstorageorgunitid = row.getString("fstorageorgunitid");
                    String number = "";
                    if (bacthNumSet.get(fstorageorgunitid) == null) {
                        number = ((String[])bacthNum.get(fstorageorgunitid))[0];
                        bacthNumSet.put(fstorageorgunitid, new BigDecimal(1));
                    } else {
                        number = ((String[])bacthNum.get(fstorageorgunitid))[((BigDecimal)bacthNumSet.get(fstorageorgunitid)).intValue()];
                        bacthNumSet.put(fstorageorgunitid, ((BigDecimal)bacthNumSet.get(fstorageorgunitid)).add(new BigDecimal(1)));
                    }
                    String sql_updateNumber = "update t_mm_taskdispbill set fnumber = '" + number + "' where fid = '" + row.getString("fid") + "'";
                    batchStatement.addBatch(sql_updateNumber);
                }
                String sql_addRelation = "insert into t_bot_relation(FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE)  select newbosid('59302EC6'),'1F66774E','4D11B6D5',fsourcebillid,fid, now(),'" + ctx.getUserName() + "',1,null,0 from t_mm_taskdispbill where fsourcebillid in (" + strIdLists + ")";
                batchStatement.addBatch(sql_addRelation);
                String sql_updateStatus = "update t_mm_productionorder set fbasestatus = 5 where fid in (" + strIdLists + ")";
                batchStatement.addBatch(sql_updateStatus);
                batchStatement.executeBatch();
                FilterInfo taskFilter = new FilterInfo();
                HashSet<String> pdtIDSet = new HashSet<String>();
                for (int i = 0; i < prdPks.length; ++i) {
                    pdtIDSet.add(prdPks[i].toString());
                }
                taskFilter.getFilterItems().add(new FilterItemInfo("sourceBillId", pdtIDSet, CompareType.INCLUDE));
                EntityViewInfo taskView = new EntityViewInfo();
                taskView.setFilter(taskFilter);
                TaskDispBillCollection taskColls = TaskDispBillFactory.getLocalInstance(ctx).getTaskDispBillCollection(taskView);
                Connection cn = this.getConnection(ctx);
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new TaskDispBillInfo().getBOSType(), (Context)ctx, (Connection)cn);
                for (int i = 0; i < taskColls.size(); ++i) {
                    TaskDispBillInfo task = taskColls.get(i);
                    TaskDispLotServerUtils.getReleasedLot(ctx, task);
                    dao.updateBatch((IObjectPK)new ObjectUuidPK(task.getId().toString()), (IObjectValue)task);
                }
                dao.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(batchStatement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        }
        if (genPickIDLst != null && !genPickIDLst.isEmpty()) {
            StringBuffer genBuff = new StringBuffer();
            for (int i = 0; i < genPickIDLst.size(); ++i) {
                genBuff.append("'");
                genBuff.append(genPickIDLst.get(i).toString());
                genBuff.append("'");
                genBuff.append(",");
            }
            this.genPickingExecute(ctx, genBuff.substring(0, genBuff.length() - 1), true);
        }
    }

    private void doUnBackFlush(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] prdPks = batchResults.getToDoPkArray();
        String ids = this.pkArrayToString(prdPks);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; prdPks != null && i < prdPks.length; ++i) {
            idSet.add(prdPks[i].toString());
        }
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("productionOrder.id", idSet, CompareType.INCLUDE));
        env.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("productionOrder.*");
        sic.add("productionOrder.stockEntry.*");
        sic.add("productionOrder.stockEntry.material.*");
        sic.add("productionOrder.stockEntry.material.baseUnit.*");
        sic.add("productionOrder.stockEntry.unit.*");
        sic.add("entrys.outputType");
        sic.add("entrys.material.*");
        sic.add("entrys.material.baseUnit.*");
        sic.add("entrys.unit.*");
        sic.add("entrys.commitQty");
        sic.add("entrys.baseCommtQty");
        env.setSelector(sic);
        FinishedRptCollection finiColls = FinishedRptFactory.getLocalInstance(ctx).getFinishedRptCollection(env);
        FinishedRptFacadeFactory.getLocalInstance(ctx).unBackFlush((IObjectCollection)finiColls);
        ArrayList<String> sqlList = new ArrayList<String>();
        String sql = "delete from T_IM_MaterialReqBill where fsourcebillid in (" + ids + ")";
        sql = "update t_mm_productionorder set FBackFlushTotalQty = 0,FBaseBackFlushTotalQty = 0 where fid in (" + ids + ")";
        sqlList.add(sql);
        sql = "update T_MM_ProductionOrderSEntry set FBaseSendOutTotalQty = 0,FSendOutTotalQty = 0 where fparentid in (" + ids + ") and FIsBackFlush = 1 ";
        sqlList.add(sql);
        DBBatchUtil.executeBatch((Context)ctx, sqlList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBackFlush(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException, SQLDataException, DataAccessException {
        IObjectPK[] prdPks = batchResults.getToDoPkArray();
        String ids = this.pkArrayToString(prdPks);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; prdPks != null && i < prdPks.length; ++i) {
            idSet.add(prdPks[i].toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("productionOrder.id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("productionOrder.*");
        sic.add("productionOrder.productLine.*");
        sic.add("productionOrder.stockEntry.*");
        sic.add("productionOrder.stockEntry.material.*");
        sic.add("productionOrder.stockEntry.material.baseUnit.*");
        sic.add("productionOrder.stockEntry.unit.*");
        sic.add("productionOrder.stockEntry.defaultWarehouse.*");
        sic.add("productionOrder.stockEntry.location.*");
        sic.add("entrys.outputType");
        sic.add("entrys.material.*");
        sic.add("entrys.material.baseUnit.*");
        sic.add("entrys.unit.*");
        sic.add("entrys.commitQty");
        sic.add("entrys.baseCommtQty");
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        env.setSelector(sic);
        FinishedRptCollection finicolls = FinishedRptFactory.getLocalInstance(ctx).getFinishedRptCollection(env);
        for (int i = finicolls.size() - 1; i >= 0; --i) {
            if (!finicolls.get(i).isIsBackFlushed()) continue;
            finicolls.removeObject(i);
        }
        FinishedRptFacadeFactory.getLocalInstance(ctx).backFlush(finicolls);
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new ProductionOrderStockEntryInfo().getBOSType(), (Context)ctx, (Connection)cn);
            EntityViewInfo prdViewInfo = new EntityViewInfo();
            FilterInfo prdFilterInfo = new FilterInfo();
            prdFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INNER));
            prdViewInfo.setFilter(prdFilterInfo);
            prdViewInfo.getSelector().add(new SelectorItemInfo("id"));
            prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.baseQty"));
            prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.qty"));
            prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.isBackFlush"));
            ProductionOrderCollection prdColls = this.getProductionOrderCollection(ctx, prdViewInfo);
            for (int i = 0; i < prdColls.size(); ++i) {
                ProductionOrderStockEntryCollection entryColls = prdColls.get(i).getStockEntry();
                for (int j = 0; j < entryColls.size(); ++j) {
                    ProductionOrderStockEntryInfo entryInfo = entryColls.get(j);
                    if (!entryInfo.isIsBackFlush()) continue;
                    entryInfo.setSendOutTotalQty(entryInfo.getQty());
                    entryInfo.setBaseSendOutTotalQty(entryInfo.getBaseQty());
                    dao.updateBatch((IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), (IObjectValue)entryInfo);
                }
            }
            dao.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        StringBuffer updateOrderSql = new StringBuffer();
        updateOrderSql.append(" update ");
        updateOrderSql.append(" t_mm_productionOrder ");
        updateOrderSql.append(" set ");
        updateOrderSql.append(" fBackFlushTotalQty=fCommitTotalQty");
        updateOrderSql.append(",fBaseBackFlushTotalQty=fBaseCommitTotalQty");
        updateOrderSql.append(" where ");
        updateOrderSql.append(" fid in (" + ids + ")");
        ArrayList<String> updateSqlList = new ArrayList<String>();
        updateSqlList.add(updateOrderSql.toString());
        DBBatchUtil.executeBatch((Context)ctx, updateSqlList);
    }

    private void doGenPicking(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] prdPks = batchResults.getToDoPkArray();
        String ids = this.pkArrayToString(prdPks);
        this.genPickingExecute(ctx, ids, false);
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
            this.auditCheck(ctx, batchResults);
        } else if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            this.unAuditCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("DISCARD")) {
            this.discardCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("OUTSOURCE")) {
            this.outSourceCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("GENPICKING")) {
            this.pickingSlipCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("BACKFLUSH")) {
            this.backFlushCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("UNBACKFLUSH")) {
            this.unBackFlushCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("RELEASED")) {
            this.releaseCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("UNRELEASE")) {
            this.unReleaseCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("GENMATERIALREQ")) {
            this.genMaterialReqCheck(ctx, batchResults);
        } else if (batchAction.getBizAction().equalsIgnoreCase("GENMANUREC")) {
            this.genManuRecCheck(ctx, batchResults);
        }
    }

    private void genManuRecCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] allIDs = batchResults.getAllIDs();
        StringBuffer ids = this.stringArrayToStringBuffer(allIDs);
        StringBuffer kql = new StringBuffer();
        kql.append(" select ");
        kql.append(" ordT.fid fid");
        kql.append(",ordT.fNumber number");
        kql.append(",ordT.fStorageOrgUnitID orgUnit");
        kql.append(" from ");
        kql.append(" t_mm_productionOrder as ordT ");
        kql.append(" where ");
        kql.append(" ordT.fid in (");
        kql.append(ids);
        kql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
        try {
            ParamUtil paramUtil = new ParamUtil(ctx);
            while (rowSet.next()) {
                String orgUnit = rowSet.getString("orgUnit");
                paramUtil.setStorageOrgUnitID(orgUnit, false);
                if (!GENCOST_NOT.equals(paramUtil.getEnabledProductionReportParam(GENCOST_NOT))) continue;
                batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("CannotGenManuRec", ctx));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void genMaterialReqCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] allIDs = batchResults.getAllIDs();
        StringBuffer ids = this.stringArrayToStringBuffer(allIDs);
        StringBuffer kql = new StringBuffer();
        kql.append(" select ");
        kql.append(" ordT.fid fid");
        kql.append(",ordT.fNumber number");
        kql.append(",ordT.fStorageOrgUnitID orgUnit");
        kql.append(" from ");
        kql.append(" t_mm_productionOrder as ordT ");
        kql.append(" where ");
        kql.append(" ordT.fid in (");
        kql.append(ids);
        kql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
        try {
            ParamUtil paramUtil = new ParamUtil(ctx);
            while (rowSet.next()) {
                String orgUnit = rowSet.getString("orgUnit");
                paramUtil.setStorageOrgUnitID(orgUnit, false);
                if (!GENCOST_NOT.equals(paramUtil.getEnabledPickBillParam(GENCOST_NOT))) continue;
                batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("CannotGenMaterialReq", ctx));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void unAuditCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] allIDs = batchResults.getAllIDs();
        StringBuffer ids = this.stringArrayToStringBuffer(allIDs);
        String relType = null;
        String autoGen = null;
        String isAudit = null;
        String genTime = null;
        String isEnableReport = null;
        StringBuffer kql = new StringBuffer();
        kql.append(" select ");
        kql.append(" ordT.fid fid");
        kql.append(",ordT.fNumber number");
        kql.append(",ordT.fBaseStatus baseStatus");
        kql.append(",ordT.FOutSourceFlag outSourceFlag");
        kql.append(",ordT.fBillTypeID billType");
        kql.append(",ordT.fStorageOrgUnitID orgUnit");
        kql.append(" from ");
        kql.append(" t_mm_productionOrder as ordT ");
        kql.append(" where ");
        kql.append(" ordT.fid in (");
        kql.append(ids);
        kql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
        ParamUtil paramUtil = new ParamUtil(ctx);
        try {
            while (rowSet.next()) {
                String billType = rowSet.getString("billType");
                String orgUnit = rowSet.getString("orgUnit");
                if (!StringUtils.isEmpty((String)billType) && !StringUtils.isEmpty((String)orgUnit)) {
                    BillTypeInfo billTypeInfo = new BillTypeInfo();
                    billTypeInfo.setId(BOSUuid.read((String)billType));
                    StorageOrgUnitInfo orgUnitInfo = new StorageOrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)orgUnit));
                    ProductionOrderInfo orderInfo = new ProductionOrderInfo();
                    orderInfo.setBillType(billTypeInfo);
                    orderInfo.setStorageOrgUnit(orgUnitInfo);
                    this._checkUnAuditInParam(ctx, (IObjectValue)orderInfo);
                }
                paramUtil.setStorageOrgUnitID(orgUnit, false);
                if (rowSet.getInt("baseStatus") != 4) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("UnAuditStatusChk", ctx));
                    continue;
                }
                if (rowSet.getBoolean("outSourceFlag")) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("UnAudit_HasOutSource", ctx));
                    continue;
                }
                relType = paramUtil.getTaskDispTypeParam(RELEASE_NOT);
                isEnableReport = paramUtil.getEnabledProductionReportParam(GENCOST_NOT);
                if (GENCOST_NOT.equals(isEnableReport) && !RELEASE_NOT.equals(relType)) {
                    if (!SCMServerUtils.hasDestBill((Context)ctx, (String)rowSet.getString("fid"))) continue;
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("UnAudit_HasDestBill", ctx));
                    continue;
                }
                autoGen = paramUtil.getAutoGenPickBillParam("false");
                if (GENCOST_NOT.equals(autoGen) || !SCMServerUtils.hasDestBill((Context)ctx, (String)rowSet.getString("fid"))) continue;
                batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("UnAudit_HasDestBill", ctx));
            }
            kql.setLength(0);
            kql.append(" select distinct FProductionOrderID as orderId from T_MM_DDMRBTE where FProductionOrderID in (");
            kql.append(ids);
            kql.append(")");
            IRowSet rowSet11 = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
            while (rowSet11.next()) {
                String orderId = rowSet11.getString("orderId");
                batchResults.addError(rowSet11.getString("orderId"), this.getResourceMsg("UnAudit_HasDestBill", ctx));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        StringBuffer checkStockSql = new StringBuffer();
        checkStockSql.append(" select fid,fnumber from t_mm_productionorder ");
        checkStockSql.append(" where fid in (select FStockId from T_MM_StockEntryToBillEntry where FStockId in (");
        checkStockSql.append(ids);
        checkStockSql.append("))");
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)checkStockSql.toString());
        try {
            while (rowSet2.next()) {
                batchResults.addError(rowSet2.getString("fid"), this.getResourceMsg2("UnAudit_HasStockGather", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList<String> srcList = new ArrayList<String>();
        StringBuffer sqlToGetDestObjId = new StringBuffer("SELECT distinct FSRCOBJECTID FROM T_BOT_RELATION ");
        sqlToGetDestObjId.append(" WHERE FSRCOBJECTID in (").append(ids).append(") AND FDESTENTITYID in ('").append(new StockTransferBillInfo().getBOSType().toString()).append("','").append(new TransferOrderBillInfo().getBOSType().toString()).append("')").append(" AND FSRCENTITYID='").append(new ProductionOrderInfo().getBOSType().toString()).append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlToGetDestObjId.toString());
        try {
            while (rows.next()) {
                srcList.add(rows.getString("FSRCOBJECTID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < srcList.size(); ++i) {
            batchResults.addError(srcList.get(i).toString(), this.getResourceMsg2("UnAudit_HasStock", ctx));
        }
        String descAuditMsg = this.getResourceMsg2("UnAuditDesc1Fail", ctx);
        String descDeleteMsg = this.getResourceMsg2("UnAuditDesc2Fail", ctx);
        try {
            rowSet.beforeFirst();
            PickingSlipBillControllerBean slip = new PickingSlipBillControllerBean();
            while (rowSet.next()) {
                String orgUnit = rowSet.getString("orgUnit");
                paramUtil.setStorageOrgUnitID(orgUnit, false);
                String id = rowSet.getString("fid");
                relType = paramUtil.getTaskDispTypeParam(RELEASE_NOT);
                genTime = paramUtil.getAutoGenPickBillTimeParam(AUDIT_GEN);
                isEnableReport = paramUtil.getEnabledProductionReportParam(GENCOST_NOT);
                if (batchResults.getActionResult((Object)id) != null && ActionResultEnum.ERROR.equals((Object)batchResults.getActionResult((Object)id).getResult()) || GENCOST_NOT.equals(isEnableReport) && !RELEASE_NOT.equals(relType) || !AUDIT_GEN.equals(genTime) || !GENCOST_NOT.equals(autoGen = paramUtil.getAutoGenPickBillParam("false"))) continue;
                BOTRelationCollection collection = null;
                try {
                    collection = CommonUtils.getDownstreamBill((Context)ctx, (String)id, (SCMBillBaseInfo)new ProductionOrderInfo(), (SCMBillBaseInfo)new PickingSlipBillInfo());
                }
                catch (Exception e) {
                    collection = null;
                }
                if (collection == null) continue;
                BOTRelationInfo relation = collection.get(0);
                String pickId = relation.getDestObjectID();
                isAudit = paramUtil.getGenPickingAutoAuditParam("false");
                if (GENCOST_NOT.equals(isAudit)) {
                    try {
                        slip.unAudit(ctx, (IObjectPK)new ObjectUuidPK(pickId));
                    }
                    catch (EASBizException e) {
                        batchResults.addError(id, descAuditMsg);
                        continue;
                    }
                    catch (BOSException e1) {
                        batchResults.addError(id, descAuditMsg);
                        continue;
                    }
                }
                try {
                    slip.delete(ctx, (IObjectPK)new ObjectUuidPK(pickId));
                }
                catch (EASBizException e) {
                    batchResults.addError(id, descDeleteMsg);
                }
                catch (BOSException e1) {
                    batchResults.addError(id, descDeleteMsg);
                }
            }
        }
        catch (SQLException e2) {
            throw new BOSException((Throwable)e2);
        }
    }

    private void auditCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] allIDs = batchResults.getAllIDs();
        StringBuffer ids = this.stringArrayToStringBuffer(allIDs);
        StringBuffer kql = new StringBuffer();
        kql.append(" select ");
        kql.append(" p.fid as fid, p.FBaseStatus as FBaseStatus,");
        kql.append(" p.FTrackNumberID as FTrackNumberID, m.FManufactureStrategyID as FManufactureStrategyID");
        kql.append(" from ");
        kql.append(" T_MM_ProductionOrder p");
        kql.append(" left join t_bd_materialplan m on m.FMaterialID=p.FMaterialID");
        kql.append(" where ");
        kql.append(" p.FID in (");
        kql.append(ids);
        kql.append(")");
        kql.append(" and p.FStorageOrgUnitID = m.FOrgUnit");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
        try {
            while (rowSet.next()) {
                if (rowSet.getInt("FBaseStatus") != 2) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("AuditStatusChk", ctx));
                }
                String strategy = rowSet.getString("FManufactureStrategyID");
                if (rowSet.getString("FTrackNumberID") != null || strategy == null || !strategy.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") && !strategy.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") && !strategy.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") && !strategy.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) continue;
                batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("TrackNumberNotNull", ctx));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        PrdLotServerUtils.checkPrdLotInfo(ctx, ids.toString(), batchResults);
    }

    private void unReleaseCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String fid;
        String[] allIDs = batchResults.getAllIDs();
        StringBuffer ids = this.stringArrayToStringBuffer(allIDs);
        String relType = null;
        String genTime = null;
        String autoGen = null;
        String isAudit = null;
        String enableReport = null;
        String sql = "select fid,fnumber,fbasestatus from t_mm_productionorder where fid in (" + ids.toString() + ") and fbasestatus<>" + 5;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                fid = rs.getString("fid");
                batchResults.addError(fid, this.getResourceMsg2("unReleaseError", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = "select p.fid,p.fnumber as fnumber from t_mm_productionorder p where exists (select * from t_mm_taskdispbill t where  t.fproductionorderid = p.fid and t.fbasestatus >= 4) and p.fid in (" + ids + ")";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                fid = rs.getString("fid");
                batchResults.addError(fid, this.getResourceMsg2("unReleaseError1", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = "select p.fid, p.fnumber as fnumber from t_mm_productionorder p where not exists (select * from t_mm_taskdispbill t  where t.fproductionorderid = p.fid ) and exists (select * from t_mm_finishedrpt f where f.fproductionorderid = p.fid ) and p.fid in (" + ids + ")";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                fid = rs.getString("fid");
                batchResults.addError(fid, this.getResourceMsg2("unReleaseError2", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = "select p.fid, p.fnumber as fnumber from t_mm_productionorder p where exists (select * from T_IM_ManufactureRecBill m LEFT JOIN T_IM_ManufactureRecBillEntry entry on m.fid=entry.fparentid where entry.fsourcebillid = p.fid ) and p.fid in (" + ids + ")";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                fid = rs.getString("fid");
                batchResults.addError(fid, this.getResourceMsg2("unReleaseError4", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = "select p.fid, p.fnumber as fnumber from t_mm_productionorder p where exists (select * from T_IM_MaterialReqBill m LEFT JOIN T_IM_MaterialReqBillEntry entry on m.fid=entry.fparentid where entry.fsourcebillid = p.fid ) and p.fid in (" + ids + ")";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                fid = rs.getString("fid");
                batchResults.addError(fid, this.getResourceMsg2("unReleaseError5", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer kql = new StringBuffer();
        kql.append(" select ");
        kql.append(" fid, fnumber number, fStorageOrgUnitID orgUnit");
        kql.append(" from ");
        kql.append(" t_mm_productionOrder ");
        kql.append(" where ");
        kql.append(" fid in (");
        kql.append(ids);
        kql.append(")");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
        ParamUtil paramUtil = new ParamUtil(ctx);
        try {
            while (result.next()) {
                BOTRelationCollection collection;
                String orgUnit = result.getString("orgUnit");
                String id = result.getString("fid");
                paramUtil.setStorageOrgUnitID(orgUnit, false);
                relType = paramUtil.getTaskDispTypeParam(RELEASE_NOT);
                genTime = paramUtil.getAutoGenPickBillTimeParam(AUDIT_GEN);
                enableReport = paramUtil.getEnabledProductionReportParam(GENCOST_NOT);
                if (GENCOST_NOT.equals(enableReport) && !RELEASE_NOT.equals(relType) || AUDIT_GEN.equals(genTime) || GENCOST_NOT.equals(autoGen = paramUtil.getAutoGenPickBillParam("false")) || (collection = CommonUtils.getDownstreamBill((Context)ctx, (String)id, (SCMBillBaseInfo)new ProductionOrderInfo(), (SCMBillBaseInfo)new PickingSlipBillInfo())) == null) continue;
                batchResults.addError(id, this.getResourceMsg2("unReleaseError3", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String descAuditMsg = this.getResourceMsg2("UnReleaseDesc1Fail", ctx);
        String descDeleteMsg = this.getResourceMsg2("UnReleaseDesc2Fail", ctx);
        try {
            result.beforeFirst();
            ArrayList<String> idList = new ArrayList<String>();
            while (result.next()) {
                String orgUnit = result.getString("orgUnit");
                String id = result.getString("fid");
                paramUtil.setStorageOrgUnitID(orgUnit, false);
                relType = paramUtil.getTaskDispTypeParam(RELEASE_NOT);
                genTime = paramUtil.getAutoGenPickBillTimeParam(AUDIT_GEN);
                if (batchResults.getActionResult((Object)id) != null && ActionResultEnum.ERROR.equals((Object)batchResults.getActionResult((Object)id).getResult()) || GENCOST_NOT.equals(enableReport) && !RELEASE_NOT.equals(relType) || AUDIT_GEN.equals(genTime) || !GENCOST_NOT.equals(autoGen = paramUtil.getAutoGenPickBillParam("false"))) continue;
                idList.add(id);
            }
            ArrayList<String> srcList = new ArrayList<String>();
            ArrayList<String> destList = new ArrayList<String>();
            if (idList.size() > 0) {
                String[] idStr = new String[idList.size()];
                StringBuffer sqlToGetDestObjId = new StringBuffer("SELECT FSRCOBJECTID,FDESTOBJECTID FROM T_BOT_RELATION ");
                sqlToGetDestObjId.append(" WHERE FSRCOBJECTID in (").append(this.stringArrayToStringBuffer(idList.toArray(idStr))).append(") AND FDESTENTITYID='").append(new PickingSlipBillInfo().getBOSType().toString()).append("'").append(" AND FSRCENTITYID='").append(new ProductionOrderInfo().getBOSType().toString()).append("'");
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlToGetDestObjId.toString());
                try {
                    while (rows.next()) {
                        srcList.add(rows.getString("FSRCOBJECTID"));
                        destList.add(rows.getString("FDESTOBJECTID"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            PickingSlipBillControllerBean slip = new PickingSlipBillControllerBean();
            for (int i = 0; i < destList.size(); ++i) {
                isAudit = paramUtil.getGenPickingAutoAuditParam("false");
                if (GENCOST_NOT.equals(isAudit)) {
                    try {
                        slip.unAudit(ctx, (IObjectPK)new ObjectUuidPK(destList.get(i).toString()));
                    }
                    catch (EASBizException e) {
                        batchResults.addError(srcList.get(i).toString(), descAuditMsg);
                        continue;
                    }
                    catch (BOSException e1) {
                        batchResults.addError(srcList.get(i).toString(), descAuditMsg);
                        continue;
                    }
                }
                try {
                    slip.delete(ctx, (IObjectPK)new ObjectUuidPK(destList.get(i).toString()));
                    continue;
                }
                catch (EASBizException e) {
                    batchResults.addError(srcList.get(i).toString(), descDeleteMsg);
                    continue;
                }
                catch (BOSException e1) {
                    batchResults.addError(srcList.get(i).toString(), descDeleteMsg);
                }
            }
        }
        catch (SQLException e2) {
            throw new BOSException((Throwable)e2);
        }
    }

    private void releaseCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] allIDs = batchResults.getAllIDs();
        StringBuffer strIdLists = this.stringArrayToStringBuffer(allIDs);
        String relType = null;
        String genTime = null;
        String isPickEnable = null;
        String enableReport = null;
        StringBuffer sql_statusCheck = new StringBuffer();
        sql_statusCheck.append("select ordT.fid,ordT.FOutSourceFlag,ordT.fbasestatus,ordT.fStorageOrgUnitID,ordT.fIsPickSlip,ordT.fstartDate");
        sql_statusCheck.append(",ordT.FMmBizType FMmBizType,s.fparentid FParentID");
        sql_statusCheck.append(",sum(case when s.Fqty = 0 or s.FIsBackFlush = 1 or s.FIssMode != 11010  then 0 else 1 end) sum ");
        sql_statusCheck.append(" from t_mm_productionorder ordT");
        sql_statusCheck.append(" left join T_MM_ProductionOrderSEntry s");
        sql_statusCheck.append(" on ordT.fid = s.fparentid");
        sql_statusCheck.append(" where ordT.fid in (" + strIdLists + ")");
        sql_statusCheck.append(" group by ordT.fid,ordT.fnumber, ordT.FOutSourceFlag,ordT.FBaseStatus,ordT.fclassTeamID,ordT.fStorageOrgUnitID, ordT.fid, ordT.fStorageOrgUnitID, ordT.fIsPickSlip,ordT.fstartDate ");
        sql_statusCheck.append(" ,ordT.FMmBizType,s.fparentid");
        IRowSet rowStatus = DbUtil.executeQuery((Context)ctx, (String)sql_statusCheck.toString());
        ParamUtil paramUtil = new ParamUtil(ctx);
        int mmbizeType = 0;
        try {
            while (rowStatus.next()) {
                String fid = rowStatus.getString("fid");
                int fbasestatus = rowStatus.getInt("fbasestatus");
                boolean fIsOutSource = rowStatus.getBoolean("FOutSourceFlag");
                String fStorageOrgUnitID = rowStatus.getString("fStorageOrgUnitID");
                boolean fIsPickSlip = rowStatus.getBoolean("fIsPickSlip");
                paramUtil.setStorageOrgUnitID(fStorageOrgUnitID, false);
                relType = paramUtil.getTaskDispTypeParam(RELEASE_NOT);
                genTime = paramUtil.getAutoGenPickBillTimeParam(AUDIT_GEN);
                isPickEnable = paramUtil.getEnabledPickBillParam(GENCOST_NOT);
                enableReport = paramUtil.getEnabledProductionReportParam(GENCOST_NOT);
                mmbizeType = rowStatus.getInt("FMmBizType");
                if (fbasestatus != 4) {
                    batchResults.addError(fid, this.getResourceMsg("ReleaseStatusChk", ctx));
                }
                if (fIsOutSource) {
                    batchResults.addError(fid, this.getResourceMsg2("Release_Err2", ctx));
                }
                if (!GENCOST_NOT.equals(isPickEnable) || GENCOST_NOT.equals(enableReport) && !RELEASE_NOT.equals(relType) || !AUDIT_GEN.equals(genTime) || fIsPickSlip || rowStatus.getInt("sum") <= 0 || (20 == mmbizeType || 30 == mmbizeType) && rowStatus.getString("FParentID") == null) continue;
                batchResults.addError(fid, this.getResourceMsg2("Release_Err3", ctx));
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    private void unBackFlushCheck(Context ctx, BatchActionResults batchResults) throws BOSException, ProductionOrderException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        StorageOrgUnitInfo sou = ContextUtil.getCurrentStorageUnit((Context)ctx);
        ObjectUuidPK userId = new ObjectUuidPK(userInfo.getId());
        ObjectUuidPK orgId = new ObjectUuidPK(sou.getId());
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        try {
            iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "materialreq_delete");
        }
        catch (EASBizException e) {
            throw new ProductionOrderException(ProductionOrderException.NOMATERIALREQ_DELETE);
        }
        try {
            iPermission.checkFunctionPermission((IObjectPK)userId, (IObjectPK)orgId, "materialreq_unAudit");
        }
        catch (EASBizException e) {
            throw new ProductionOrderException(ProductionOrderException.NOMATERIALREQ_UNAUDIT);
        }
        String[] allIDs = batchResults.getAllIDs();
        StringBuffer ids = this.stringArrayToStringBuffer(allIDs);
        String sql = "select fid,fnumber from t_mm_productionorder where fid in (" + ids + ") and FBaseBackFlushTotalQty=0";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                batchResults.addError(rs.getString("fid"), this.getResourceMsg2("UnFlushErr", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void backFlushCheck(Context ctx, BatchActionResults batchResults) throws BOSException, ProductionOrderException {
        String[] allIDs = batchResults.getAllIDs();
        StringBuffer ids = this.stringArrayToStringBuffer(allIDs);
        EntityViewInfo prdViewInfo = new EntityViewInfo();
        FilterInfo prdFilterInfo = new FilterInfo();
        prdFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INNER));
        prdViewInfo.setFilter(prdFilterInfo);
        prdViewInfo.getSelector().add(new SelectorItemInfo("id"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("number"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("outSourceFlag"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("material.id"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit.id"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("productLine.id"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("traceNo"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("workShop.id"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("commitTotalQty"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("backFlushTotalQty"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("baseStatus"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.id"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.seq"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.baseQty"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.qty"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.isBackFlush"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.defaultWarehouse"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.material.id"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.unit.id"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.baseUnit.id"));
        prdViewInfo.getSelector().add(new SelectorItemInfo("stockEntry.productLineWP.id"));
        ProductionOrderCollection prdColls = this.getProductionOrderCollection(ctx, prdViewInfo);
        if (prdColls == null || prdColls.isEmpty()) {
            throw new ProductionOrderException(ProductionOrderException.FLUSHEXCEPTION, new Object[]{this.getResourceMsg("Flush_Err2", ctx)});
        }
        ProductionOrderInfo prdInfo = null;
        for (int i = 0; i < prdColls.size(); ++i) {
            prdInfo = prdColls.get(i);
            if (!prdInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.COMPLETE)) {
                batchResults.addError(prdInfo.getId().toString(), this.getResourceMsg("FlushStatusChk", ctx));
            } else if (prdInfo.isOutSourceFlag()) {
                batchResults.addError(prdInfo.getId().toString(), this.getResourceMsg2("Flush_Err2", ctx));
            } else {
                double flushQty;
                double commitQty = prdInfo.getCommitTotalQty() == null ? 0.0 : prdInfo.getCommitTotalQty().doubleValue();
                double d = flushQty = prdInfo.getBackFlushTotalQty() == null ? 0.0 : prdInfo.getBackFlushTotalQty().doubleValue();
                if (commitQty <= flushQty) {
                    batchResults.addError(prdInfo.getId().toString(), this.getResourceMsg("Flush_Err1", ctx));
                }
            }
            ProductionOrderStockEntryCollection sEntry = prdInfo.getStockEntry();
            int count = 0;
            boolean isCheck = true;
            for (int j = 0; j < sEntry.size(); ++j) {
                if (!sEntry.get(j).isIsBackFlush()) {
                    ++count;
                    continue;
                }
                if (!isCheck) continue;
                String materialId = sEntry.get(j).getMaterial().getId().toString();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)prdInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(1), CompareType.EQUALS));
                view.setFilter(filter);
                MaterialInventoryCollection invs = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(view);
                if (invs.size() <= 0) {
                    batchResults.addError(prdInfo.getId().toString(), this.getResourceMsg2("Flush_Err4", ctx));
                    isCheck = false;
                    continue;
                }
                MaterialInventoryInfo invInfo = invs.get(0);
                if (invInfo.isIsLotNumber() && invInfo.getIssuePriorityMode() == null) {
                    batchResults.addError(prdInfo.getId().toString(), this.getResourceMsg2("Flush_Err5", ctx));
                }
                isCheck = false;
            }
            if (count != sEntry.size()) continue;
            batchResults.addError(prdInfo.getId().toString(), this.getResourceMsg2("Flush_Err3", ctx));
        }
    }

    private void pickingSlipCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException, ProductionOrderException {
        StringBuffer ids = new StringBuffer();
        String[] allIDs = batchResults.getToDoIdsArray();
        if (allIDs == null || allIDs.length < 1) {
            return;
        }
        ids = this.stringArrayToStringBuffer(allIDs);
        StringBuffer chkSql = new StringBuffer();
        chkSql.append(" select ");
        chkSql.append(" t.FID");
        chkSql.append(",t.FBaseStatus");
        chkSql.append(",t.FIsPickSlip");
        chkSql.append(",t.FOutSourceFlag");
        chkSql.append(",t.fStorageOrgUnitID");
        chkSql.append(",t.FIsManualFinish");
        chkSql.append(",sum(case when s.Fqty = 0 or s.FIsBackFlush = 1 or s.FIssMode != 11010  then 0 else 1 end) sum ");
        chkSql.append(" from ");
        chkSql.append(" T_MM_ProductionOrder t");
        chkSql.append(" left join T_MM_ProductionOrderSEntry s");
        chkSql.append(" on t.fid = s.fparentid");
        chkSql.append(" where ");
        chkSql.append(" t.fid in (");
        chkSql.append(ids.toString());
        chkSql.append(")");
        chkSql.append(" group by  t.FID,t.FBaseStatus, t.FIsPickSlip,t.FOutSourceFlag, t.fStorageOrgUnitID,t.FIsManualFinish");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql.toString());
            ParamUtil paramUtil = new ParamUtil(ctx);
            while (rowSet.next()) {
                int status = rowSet.getInt(2);
                boolean isPick = rowSet.getBoolean(3);
                String fStorageOrgUnitID = rowSet.getString("fStorageOrgUnitID");
                int sum = rowSet.getInt("sum");
                int isManualFinish = rowSet.getInt("FIsManualFinish");
                boolean isOutSource = rowSet.getBoolean(4);
                paramUtil.setStorageOrgUnitID(fStorageOrgUnitID, false);
                String relType = paramUtil.getTaskDispTypeParam(RELEASE_NOT);
                String genTime = paramUtil.getAutoGenPickBillTimeParam(AUDIT_GEN);
                String enabledPick = paramUtil.getEnabledPickBillParam(GENCOST_NOT);
                String enabledReport = paramUtil.getEnabledProductionReportParam(GENCOST_NOT);
                if (!GENCOST_NOT.equals(enabledPick)) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("GenPicking_Err0", new String[]{""}, ctx));
                    continue;
                }
                if (GENCOST_NOT.equals(enabledReport) && !RELEASE_NOT.equals(relType)) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("GenPicking_Err1", ctx));
                    continue;
                }
                if (status != 4 && status != 5 && (status != 8 || isManualFinish == 1)) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("GenPickStatusChk", ctx));
                    continue;
                }
                if (isPick) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("GenPicking_Err2", ctx));
                    continue;
                }
                if (isOutSource) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("GenPicking_Err7", ctx));
                    continue;
                }
                if (sum <= 0) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("GenPicking_Err7", ctx));
                    continue;
                }
                if (status != 4 || AUDIT_GEN.equals(genTime)) continue;
                batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("GenPicking_Err9", ctx));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    private void doDiscard(Context ctx, BatchActionResults batchResults) throws BOSException {
        IObjectPK[] prdPks = batchResults.getToDoPkArray();
        StringBuffer statusLst = new StringBuffer();
        List billBaseStatus = EntryBaseStatusEnum.getEnumList();
        for (int i = 0; i < billBaseStatus.size(); ++i) {
            int value = ((EntryBaseStatusEnum)billBaseStatus.get(i)).getValue();
            if (value == 9 || value == 3) continue;
            statusLst.append(value);
            statusLst.append(",");
        }
        statusLst = statusLst.replace(statusLst.length() - 1, statusLst.length(), "");
        String ids = this.pkArrayToString(prdPks);
        StringBuffer chkSql = new StringBuffer();
        chkSql.append(" select ");
        chkSql.append(" fSourceBillEntryID");
        chkSql.append(",fid");
        chkSql.append(" from ");
        chkSql.append(" t_mm_productionOrder ");
        chkSql.append(" where ");
        chkSql.append(" fid in (");
        chkSql.append(ids.toString());
        chkSql.append(")");
        StringBuffer havSrcIDLst = new StringBuffer();
        Connection conn = null;
        Statement stmt = null;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql.toString());
            while (rowSet.next()) {
                if (StringUtils.isEmpty((String)rowSet.getString("fSourceBillEntryID"))) continue;
                havSrcIDLst.append("'");
                havSrcIDLst.append(rowSet.getString("fid"));
                havSrcIDLst.append("'");
                havSrcIDLst.append(",");
            }
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update ");
            updateSql.append(" t_mm_productionOrder ");
            updateSql.append(" set ");
            updateSql.append(" fBasestatus=3");
            updateSql.append(" where ");
            updateSql.append(" fBasestatus<4");
            updateSql.append(" and fid in (" + ids.toString() + ")");
            StringBuffer writePLSESql = new StringBuffer();
            StringBuffer writeMPSSql = new StringBuffer();
            StringBuffer writePLSSql = new StringBuffer();
            if (havSrcIDLst.length() > 0) {
                havSrcIDLst = havSrcIDLst.replace(havSrcIDLst.length() - 1, havSrcIDLst.length(), "");
                writePLSESql.append(" update ");
                writePLSESql.append(" t_mm_plsEntry ");
                writePLSESql.append(" set ");
                writePLSESql.append(" fBaseStatus=3");
                writePLSESql.append(" where ");
                writePLSESql.append(" fid in (");
                writePLSESql.append("select fSourceBillEntryID from t_mm_productionOrder where fid in (" + havSrcIDLst.toString() + ")");
                writePLSESql.append(")");
                writePLSSql.append("update T_MM_ProductionLineScheduling as t ");
                writePLSSql.append(" set ");
                writePLSSql.append(" fBaseStatus=7");
                writePLSSql.append(" where not exists(select t3.fid from t_mm_plsEntry as t3 where t3.FParent=t.fid ");
                writePLSSql.append(" and t3.fBaseStatus in (");
                writePLSSql.append(statusLst.toString());
                writePLSSql.append("))");
                writePLSSql.append(" and t.fid in (");
                writePLSSql.append(" select distinct(t1.fid)");
                writePLSSql.append(" from ");
                writePLSSql.append(" T_MM_ProductionLineScheduling t1");
                writePLSSql.append(" inner join t_mm_plsEntry as t2 on t2.FParent=t1.fid ");
                writePLSSql.append(" where ");
                writePLSSql.append(" t2.fid in (");
                writePLSSql.append("select fSourceBillEntryID from t_mm_productionOrder where fid in (" + havSrcIDLst.toString() + ")");
                writePLSSql.append("))");
                writeMPSSql.append(" update ");
                writeMPSSql.append(" t_mm_plannedOrder as p ");
                writeMPSSql.append(" set ");
                writeMPSSql.append("(fTotalReleaseQty,fBaseTotalReleaseQty,fScheduleQty,fBaseScheduleQty)=");
                writeMPSSql.append("(select ");
                writeMPSSql.append(" p.fTotalReleaseQty-s.fQty");
                writeMPSSql.append(",p.fBaseTotalReleaseQty-s.fBaseQty");
                writeMPSSql.append(",p.fScheduleQty-s.fQty");
                writeMPSSql.append(",p.fBaseScheduleQty-s.fBaseQty");
                writeMPSSql.append(" from (select fMpsPlanOrdID as fMpsPlanOrdID, sum(fQty) as fQty, sum(fBaseQty) as fBaseQty");
                writeMPSSql.append(" from t_mm_productionOrder where fid in (" + havSrcIDLst.toString() + ")");
                writeMPSSql.append(" group by fMpsPlanOrdID) s");
                writeMPSSql.append(" where s.fMpsPlanOrdID=p.fid");
                writeMPSSql.append(" and p.fBaseStatus<>7");
                writeMPSSql.append(")");
            }
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            stmt.addBatch(updateSql.toString());
            if (writePLSESql.length() > 0) {
                stmt.addBatch(writePLSESql.toString());
            }
            if (writeMPSSql.length() > 0) {
                stmt.addBatch(writeMPSSql.toString());
            }
            if (writePLSSql.length() > 0) {
                stmt.addBatch(writePLSSql.toString());
            }
            stmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        try {
            this.updateReqPlanData(ctx, prdPks, 108);
        }
        catch (Exception exc) {
            throw new BOSException((Throwable)exc);
        }
    }

    private void discardCheck(Context ctx, BatchActionResults batchResults) throws BOSException, ProductionOrderException {
        String[] allIDs = batchResults.getAllIDs();
        StringBuffer ids = this.stringArrayToStringBuffer(allIDs);
        StringBuffer chkSql = new StringBuffer();
        chkSql.append(" select ");
        chkSql.append(" fBasestatus ");
        chkSql.append(",fid");
        chkSql.append(" from ");
        chkSql.append(" t_mm_productionOrder ");
        chkSql.append(" where ");
        chkSql.append(" fid in (");
        chkSql.append(ids.toString());
        chkSql.append(")");
        boolean isExist = false;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql.toString());
        try {
            while (rowSet.next()) {
                isExist = true;
                int status = rowSet.getInt("fBasestatus");
                if (status == 3) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("DiscardStatusChk1", ctx));
                    continue;
                }
                if (status < 4) continue;
                batchResults.addError(rowSet.getString("fid"), this.getResourceMsg("DiscardStatusChk2", ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!isExist) {
            throw new ProductionOrderException(ProductionOrderException.DISCARDEXCEPTION, new Object[]{this.getResourceMsg("Discard_Err1", ctx)});
        }
    }

    private void outSourceCheck(Context ctx, BatchActionResults batchResults) throws BOSException {
        String[] allIDs = batchResults.getAllIDs();
        StringBuffer ids = this.stringArrayToStringBuffer(allIDs);
        StringBuffer chkSql = new StringBuffer();
        chkSql.append(" select ");
        chkSql.append(" t.FNumber");
        chkSql.append(",t.FBaseStatus");
        chkSql.append(",t.FIsPickSlip");
        chkSql.append(",t.FOutSourceFlag");
        chkSql.append(",t.Fid");
        chkSql.append(",tour.FToUnitID");
        chkSql.append(",tbmp.FStatus");
        chkSql.append(" from ");
        chkSql.append(" T_MM_ProductionOrder t");
        chkSql.append(" left join (select tou.FFromUnitID,tou.FToUnitID from T_ORG_UnitRelation tou left join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        chkSql.append(" where tot.FFromType = 4 and tot.FToType = 3");
        chkSql.append(" and tou.FIsDefault = 1) tour on tour.FFromUnitID = t.FStorageOrgUnitID");
        chkSql.append(" left join T_BD_MaterialPurchasing tbmp on t.fMaterialID = tbmp.fMaterialId and tbmp.forgUnit = tour.FToUnitID");
        chkSql.append(" where ");
        chkSql.append(" t.fid in (" + ids + ")");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql.toString());
            while (rowSet.next()) {
                int status = rowSet.getInt(2);
                boolean isPick = rowSet.getBoolean(3);
                boolean isOutSource = rowSet.getBoolean(4);
                String purOrgId = rowSet.getString(6);
                BigDecimal purstatus = rowSet.getBigDecimal(7);
                if (status != 4) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("OutSourceUIChk6", ctx));
                    continue;
                }
                if (isPick) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("OutSourceUIChk8", ctx));
                    continue;
                }
                if (isOutSource) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("OutSourceUIChk7", ctx));
                    continue;
                }
                if (purOrgId == null) {
                    batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("OutSourceUIChk9", ctx));
                    continue;
                }
                if (purstatus != null && purstatus.intValue() != 0) continue;
                batchResults.addError(rowSet.getString("fid"), this.getResourceMsg2("OutSourceUIChk10", ctx));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void doOutSource(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] prdPks = batchResults.getToDoPkArray();
        String strIdLists = this.pkArrayToString(prdPks);
        String creatorID = ctx.getCaller().toString();
        UserInfo userinfo = (UserInfo)ctx.get((Object)"UserInfo");
        String personid = userinfo.getPerson() == null ? "" : userinfo.getPerson().getId().toString();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("Insert into T_SM_PurRequest(FID,FNumber,FPersonID,FBizDate,fCreateTime,fCreatorID,FSourceBillID,FSourceBillTypeID,FBillTypeID,FBizTypeId,FPurchaseType,FIsUrgent,FDescription,FIsMergeBill,FTotalAmount,FBaseStatus,FCompanyOrgUnitID,FDemandTypeID) \n");
        sqlBuffer.append("select newbosid('25428F2E'),' ','" + personid + "',now(),now(),'" + creatorID + "',ordT.fid,");
        sqlBuffer.append("'");
        sqlBuffer.append("ejIZHXXTQliYCQJg9t4Re0Y+1VI=");
        sqlBuffer.append("','");
        sqlBuffer.append("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        sqlBuffer.append("','");
        sqlBuffer.append("1x7KMBq4mUmpj58T4jNPqiQHQ1w=");
        sqlBuffer.append("',1");
        sqlBuffer.append(",0");
        sqlBuffer.append(",ordT.FRemark_").append(ProductionOrderControllerBean.getLocale());
        sqlBuffer.append(",0");
        sqlBuffer.append(",0");
        sqlBuffer.append(",");
        sqlBuffer.append(1);
        sqlBuffer.append(",tou.FToUnitID");
        sqlBuffer.append(",'KmuTezpYRpyN6uBe04rD6qvcMAg='");
        sqlBuffer.append(" from T_MM_ProductionOrder ordT");
        sqlBuffer.append(" inner join T_ORG_UnitRelation tou on tou.FFromUnitID = ordT.FStorageOrgUnitID ");
        sqlBuffer.append(" inner join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        sqlBuffer.append(" where ordT.fid in (" + strIdLists + ")");
        sqlBuffer.append(" and tot.FFromType = 4");
        sqlBuffer.append(" and tot.FToType = 1");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
        StringBuffer genDetailBuff = new StringBuffer();
        genDetailBuff.append("insert into ");
        genDetailBuff.append(" T_SM_PurRequestEntry ");
        genDetailBuff.append("(");
        genDetailBuff.append("fid");
        genDetailBuff.append(",fParentID");
        genDetailBuff.append(",fSourceBillId");
        genDetailBuff.append(",fSourceBillNumber");
        genDetailBuff.append(",fseq");
        genDetailBuff.append(",FRowTypeID ");
        genDetailBuff.append(",FDestinationType");
        genDetailBuff.append(",fMaterialID");
        genDetailBuff.append(",fMaterialName");
        genDetailBuff.append(",fQty");
        genDetailBuff.append(",fBaseQty");
        genDetailBuff.append(",fUnitId");
        genDetailBuff.append(",fBaseUnitId");
        genDetailBuff.append(",FAssistUnitID");
        genDetailBuff.append(",FAssistQty");
        genDetailBuff.append(",FStorageOrgUnitID");
        genDetailBuff.append(",FAdminOrgUnitID");
        genDetailBuff.append(",FRequestQty");
        genDetailBuff.append(",FReceivedOrgUnitID");
        genDetailBuff.append(",FUseAdminOrgUnitID");
        genDetailBuff.append(",FPurchaseOrgUnitID");
        genDetailBuff.append(",FPurchasePersonID");
        genDetailBuff.append(",FMaterialBaseClass");
        genDetailBuff.append(",FProposePurchaseDate");
        genDetailBuff.append(",FRequirementDate");
        genDetailBuff.append(",FProposeDeliveryDate");
        genDetailBuff.append(",FTrackNumber");
        genDetailBuff.append(",FTrackNoID");
        genDetailBuff.append(",FSupplierID");
        genDetailBuff.append(",FOrderedQty");
        genDetailBuff.append(",FOrderedBaseQty");
        genDetailBuff.append(",FBaseStatus");
        genDetailBuff.append(",FProcessRequirement");
        genDetailBuff.append(",FSaleOrderNumber");
        genDetailBuff.append(",fcurrencyid");
        genDetailBuff.append(",fexchangerate)");
        genDetailBuff.append(" select ");
        genDetailBuff.append(" newbosid('2B7DD5E4')");
        genDetailBuff.append(",tsp.fid");
        genDetailBuff.append(",ordT.fid");
        genDetailBuff.append(",ordT.fNumber");
        genDetailBuff.append(",1");
        genDetailBuff.append(",'00000000-0000-0000-0000-0000000000017C7DC4A3'");
        genDetailBuff.append(",'10'");
        genDetailBuff.append(",ordT.fMaterialID");
        genDetailBuff.append(",tbm.");
        genDetailBuff.append(this.getFieldName(ctx));
        genDetailBuff.append(",ordT.fQty");
        genDetailBuff.append(",ordT.fBaseQty");
        genDetailBuff.append(",ordT.fUnitId");
        genDetailBuff.append(",ordT.fBaseUnitId");
        genDetailBuff.append(",tbm.FAssistUnit");
        genDetailBuff.append(",Round(ordT.fBaseQty/tbmu.fBaseConvsRate, tbmu.fQtyPrecision)");
        genDetailBuff.append(",ordT.FStorageOrgUnitID");
        genDetailBuff.append(",ordT.FWorkShopID");
        genDetailBuff.append(",ordT.fQty");
        genDetailBuff.append(",ordT.FStorageOrgUnitID");
        genDetailBuff.append(",ordT.FWorkShopID");
        genDetailBuff.append(",tou.FToUnitID");
        genDetailBuff.append(",tbmp.FPurPerson");
        genDetailBuff.append(",tbm.FMaterialGroupID");
        genDetailBuff.append(",ADD_days(ordT.fEndDate,ISNULL(tssi.FLeadtime, 0)*-1)");
        genDetailBuff.append(",ordT.fEndDate");
        genDetailBuff.append(",ordT.fEndDate");
        genDetailBuff.append(",ordT.FTraceNo");
        genDetailBuff.append(",ordT.FTrackNumberID");
        genDetailBuff.append(",tbmp.FSupplier");
        genDetailBuff.append(",0");
        genDetailBuff.append(",0");
        genDetailBuff.append(",1");
        genDetailBuff.append(",ordT.FOutSourceRequire_").append(ProductionOrderControllerBean.getLocale());
        genDetailBuff.append(",tss.FNumber");
        genDetailBuff.append(",org.fbasecurrencyid ");
        genDetailBuff.append(",1 ");
        genDetailBuff.append(" from t_mm_productionOrder as ordT");
        genDetailBuff.append(" inner join T_SM_PurRequest as tsp on tsp.fSourceBillId =ordT.fid");
        genDetailBuff.append(" inner join T_BD_Material as tbm on tbm.fid =ordT.fMaterialID");
        genDetailBuff.append(" inner join T_ORG_UnitRelation tou on tou.FFromUnitID = ordT.FStorageOrgUnitID ");
        genDetailBuff.append(" inner join T_ORG_TypeRelation tot on tot.Fid = tou.FTypeRelationID");
        genDetailBuff.append(" left join T_BD_MaterialPurchasing tbmp on tbmp.fMaterialId = tbm.Fid and tbmp.forgUnit = tou.FToUnitID");
        genDetailBuff.append(" left join T_SD_SaleOrder tss on tss.Fid = ordT.FSaleOrderID");
        genDetailBuff.append(" left join T_SM_SupplyInfo tssi on tssi.FPurchaseOrgID = tou.FToUnitID and tssi.FSupplierID = tbmp.FSupplier and FMaterialItemID = ordT.fMaterialID");
        genDetailBuff.append(" left join t_bd_multiMeasureUnit tbmu on tbmu.fMaterialID = ordT.fMaterialID and tbmu.fMeasureUnitID = tbm.FAssistUnit");
        genDetailBuff.append(" left join t_org_company org on org.fid = tsp.fcompanyorgunitid ");
        genDetailBuff.append(" where");
        genDetailBuff.append(" ordT.fid in (" + strIdLists + ")");
        genDetailBuff.append(" and tot.FFromType = 4");
        genDetailBuff.append(" and tot.FToType = 3");
        genDetailBuff.append(" and tou.FIsDefault = 1");
        DbUtil.execute((Context)ctx, (String)genDetailBuff.toString());
        StringBuffer genDetailBuffEntry = new StringBuffer();
        genDetailBuffEntry.append("insert into T_SM_PurRequestEntryML(Fid, FBaseQty, FQty, FAssistQty, FUnitQty, FLossRatio, FDemandDate, FParent1ID, FSeq, FMaterialId, FUnitId, FSourceBillId,FSourceBillNumber,FSourceBillEntryId,FSourceBillEntrySeq,FBaseUnitId,FAssistUnitId,FSourceBillTypeId)");
        genDetailBuffEntry.append("select newbosid('435FF683'), st.FBaseQty, st.FQty, ISNULL(ROUND(st.FQty*tbmu2.FBaseConvsRate/tbmu.FBaseConvsRate,tbmu.fQtyPrecision), 0), ROUND(st.FQty/po.FQty, tbmu2.fQtyPrecision), 0, po.FEndDate, pre.fid, st.FSeq, st.FMaterialId, st.FUnitId, po.fid, po.fNumber,st.fid,st.FSeq,st.FBaseUnitId,tbm.FAssistUnit,'");
        genDetailBuffEntry.append("ejIZHXXTQliYCQJg9t4Re0Y+1VI=");
        genDetailBuffEntry.append("' from T_MM_ProductionOrderSEntry st");
        genDetailBuffEntry.append(" inner join T_MM_ProductionOrder po on po.fid = st.FParentid");
        genDetailBuffEntry.append(" inner join T_SM_PurRequestEntry pre on pre.fSourceBillID = po.fid");
        genDetailBuffEntry.append(" inner join T_BD_Material as tbm on tbm.fid =st.fMaterialID");
        genDetailBuffEntry.append(" left join t_bd_multiMeasureUnit tbmu on tbmu.fMaterialID = st.fMaterialID and tbmu.fMeasureUnitID = st.FAssistUnitId");
        genDetailBuffEntry.append(" left join t_bd_multiMeasureUnit tbmu2 on tbmu2.fMaterialID = st.fMaterialID and tbmu2.fMeasureUnitID = st.FUnitId");
        genDetailBuffEntry.append(" where st.fParentid in (" + strIdLists + ")");
        genDetailBuffEntry.append(" and st.FQty > 0");
        DbUtil.execute((Context)ctx, (String)genDetailBuffEntry.toString());
        Connection conn1 = null;
        PreparedStatement updateNumPrpStmt = null;
        String updateNumSql = "update T_SM_PurRequest set fnumber=? where fid=? ";
        PreparedStatement saveBotpPrpStmt = null;
        String saveBotpSql = "insert into t_bot_relation (FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values (newbosid('59302EC6'),'1F66774E','25428F2E',?,?,now(),?,1,'YzcxRPbdTNKf1AeOoFXAvQRRIsQ=',0)";
        String sql = "select fid,fSourceBillID,FCompanyOrgUnitID from T_SM_PurRequest where (trim(fNumber) is null or fnumber='') and fSourceBillID in (" + strIdLists + ")";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            conn1 = EJBFactory.getConnection((Context)ctx);
            updateNumPrpStmt = conn1.prepareStatement(updateNumSql);
            saveBotpPrpStmt = conn1.prepareStatement(saveBotpSql);
            while (row.next()) {
                String outSourceId = row.getString("fid");
                String number = codingRuleManager.getNumber((IObjectValue)new PurRequestInfo(), row.getString("FCompanyOrgUnitID"));
                updateNumPrpStmt.setString(1, number);
                updateNumPrpStmt.setString(2, outSourceId);
                updateNumPrpStmt.addBatch();
                saveBotpPrpStmt.setString(1, row.getString("fSourceBillID"));
                saveBotpPrpStmt.setString(2, outSourceId);
                saveBotpPrpStmt.setString(3, creatorID);
                saveBotpPrpStmt.addBatch();
            }
            updateNumPrpStmt.executeBatch();
            saveBotpPrpStmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateNumPrpStmt, null);
                SQLUtils.cleanup(saveBotpPrpStmt, null);
                SQLUtils.cleanup((Connection)conn1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateNumPrpStmt, null);
        SQLUtils.cleanup((Statement)saveBotpPrpStmt, null);
        SQLUtils.cleanup((Connection)conn1);
        String updateOrderSql = "update T_MM_ProductionOrder set FOutSourceFlag=1 where fid in (" + strIdLists + ")";
        DbUtil.execute((Context)ctx, (String)updateOrderSql);
    }

    private StringBuffer stringArrayToStringBuffer(String[] allIDs) {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < allIDs.length; ++i) {
            ids.append("'");
            ids.append(allIDs[i]);
            ids.append("'");
            ids.append(",");
        }
        ids = ids.replace(ids.length() - 1, ids.length(), "");
        return ids;
    }

    private String pkArrayToString(IObjectPK[] prdPks) {
        String ids = StringUtils.arrayToString((Object[])prdPks, (String)"','");
        ids = "'" + ids + "'";
        return ids;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        ProductionOrderInfo obj = (ProductionOrderInfo)super._getValue(ctx, pk, selector);
        obj.setIsGenTaskBill(this.isGenTaskDispBill(ctx, pk));
        obj.setIsGenPickSlipBill(this.isGenPickingSlipBill(ctx, pk));
        return obj;
    }

    @Override
    protected IObjectValue _getAlteringValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProductionOrderInfo obj = (ProductionOrderInfo)this._getValue(ctx, pk, ProductionOrderHelper.getInnerSelectors());
        this.updateRelatedStockEntry(ctx, obj);
        return obj;
    }

    private boolean isGenTaskDispBill(Context ctx, IObjectPK pk) throws BOSException {
        boolean isGenTaskDisp = false;
        String sql = "select count(0) cnt from T_MM_TaskDispBill where FSourceBillID = '" + pk.toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            int rstSize;
            if (rs.next() && (rstSize = rs.getInt("cnt")) > 0) {
                isGenTaskDisp = true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isGenTaskDisp;
    }

    private boolean isGenPickingSlipBill(Context ctx, IObjectPK pk) throws BOSException {
        boolean isGenPickingSlip = false;
        String sql = "select count(0) cnt from T_MM_PickingSlipBill where FSourceBillID is not null and FProductionOrderID = '" + pk.toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            int rstSize;
            if (rs.next() && (rstSize = rs.getInt("cnt")) > 0) {
                isGenPickingSlip = true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isGenPickingSlip;
    }

    private void updateRelatedStockEntry(Context ctx, ProductionOrderInfo orderInfo) throws BOSException {
        String orderID = orderInfo.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select TB.ID as stockEntryID\n");
        sql.append(" From (\n");
        sql.append(" \tselect FID as ID\n");
        sql.append(" \tFrom T_MM_ProductionOrderSEntry\n");
        sql.append(" \tWhere FParentID = '" + orderID + "'\n");
        sql.append("\tAnd FSendOutTotalQty > 0\n");
        sql.append(" \tUnion\n");
        sql.append(" \tSelect botE.FSrcEntryID as ID\n");
        sql.append(" \tFrom T_BOT_RelationEntry botE \n");
        sql.append("\tinner join T_BOT_Relation bot on botE.FKeyID = bot.FID \n");
        sql.append(" \tWhere bot.FSrcObjectID = '" + orderID + "'\n");
        sql.append("\tand (bot.FDestEntityID = '5C2A1F0C'");
        sql.append("\t\tor bot.FDestEntityID='2239F30A'");
        sql.append("\t\tor bot.FDestEntityID='500AB75E')");
        sql.append(" \tUnion \n");
        sql.append(" \tSelect FStockEntryID as ID\n");
        sql.append(" \tFrom T_MM_DDMRBTE\n");
        sql.append(" \tWhere FProductionOrderID = '" + orderID + "'\n");
        sql.append(" ) as TB \n");
        ProductionOrderStockEntryCollection stEntryCols = orderInfo.getStockEntry();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String stockEntryID = rs.getString("stockEntryID");
                if (StringUtils.isEmpty((String)stockEntryID)) continue;
                stEntryCols.get(BOSUuid.read((String)stockEntryID)).setIsRelated(true);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void doBeforeAlterSubmit(Context ctx, ProductionOrderInfo orderInfo) throws EASBizException {
        BigDecimal rcvInHightLimit;
        BigDecimal rptInHightLimit;
        if (!this.isAlterSubmit) {
            return;
        }
        MaterialPlanInfo mi = orderInfo.getMaterialPlan();
        boolean isReportingLimit = mi.isIsReportingLimit();
        boolean isStorageLimit = mi.isIsStorageLimit();
        BigDecimal newDemanQty4Commit = orderInfo.getQty();
        BigDecimal newDemanQty4Receive = orderInfo.getQty();
        if (isReportingLimit && null != (rptInHightLimit = mi.getRptInHightLimit())) {
            newDemanQty4Commit = newDemanQty4Commit.multiply(new BigDecimal("1").add(rptInHightLimit.divide(new BigDecimal("100"), 8, 0)));
        }
        if (isStorageLimit && null != (rcvInHightLimit = mi.getRcvInHightLimit())) {
            newDemanQty4Receive = orderInfo.getCommitTotalQty().compareTo(SysConstant.BIGZERO) == 0 ? newDemanQty4Receive.multiply(new BigDecimal("1").add(rcvInHightLimit.divide(new BigDecimal("100"), 8, 0))) : orderInfo.getCommitTotalQty().multiply(new BigDecimal("1").add(rcvInHightLimit.divide(new BigDecimal("100"), 8, 0)));
        }
        if (newDemanQty4Commit.compareTo(orderInfo.getCommitTotalQty()) < 0) {
            throw new ProductionOrderException(ProductionOrderException.QTYCANNOTBELOWCOMPQTY);
        }
        BigDecimal tempQty = MMConstant.BIGDECIMAL_ZERO;
        if (orderInfo.getStockTotalQty() != null) {
            tempQty = tempQty.add(orderInfo.getStockTotalQty());
        }
        if (orderInfo.getTotalDDMQty() != null) {
            tempQty = tempQty.add(orderInfo.getTotalDDMQty());
        }
        if (orderInfo.getTotalReworkQty() != null) {
            tempQty = tempQty.add(orderInfo.getTotalReworkQty());
        }
        if (orderInfo.getTatalRepairQty() != null) {
            tempQty = tempQty.add(orderInfo.getTatalRepairQty());
        }
        if (orderInfo.getTotalRejectQty() != null) {
            tempQty = tempQty.add(orderInfo.getTotalRejectQty());
        }
        if (newDemanQty4Receive.compareTo(tempQty) < 0) {
            throw new ProductionOrderException(ProductionOrderException.QTYCANNOTBELOWNETSTOCKQTY);
        }
        ProductionOrderStockEntryCollection stockEntryCols = orderInfo.getStockEntry();
        StringBuffer expRowIndex = new StringBuffer();
        BigDecimal sInHightLimit = MMConstant.BIGDECIMAL_ZERO;
        BigDecimal sendOutTotalQty = MMConstant.BIGDECIMAL_ZERO;
        BigDecimal untreadTotalQty = MMConstant.BIGDECIMAL_ZERO;
        BigDecimal needQty = MMConstant.BIGDECIMAL_ZERO;
        BigDecimal outQty = MMConstant.BIGDECIMAL_ZERO;
        for (int i = 0; i < stockEntryCols.size(); ++i) {
            ProductionOrderStockEntryInfo stEntryInfo = stockEntryCols.get(i);
            if (!stEntryInfo.getMaterialInventory().isIsQuotaControl()) continue;
            sendOutTotalQty = stEntryInfo.getSendOutTotalQty() == null ? MMConstant.BIGDECIMAL_ZERO : stEntryInfo.getSendOutTotalQty();
            untreadTotalQty = stEntryInfo.getUntreadTotalQty() == null ? MMConstant.BIGDECIMAL_ZERO : stEntryInfo.getUntreadTotalQty();
            sInHightLimit = stEntryInfo.getMaterialInventory().getIssInHightLimit() == null ? MMConstant.BIGDECIMAL_ZERO : stEntryInfo.getMaterialInventory().getIssInHightLimit();
            outQty = sendOutTotalQty.subtract(untreadTotalQty).divide(new BigDecimal("1").add(sInHightLimit.divide(new BigDecimal("100"), 8, 0)), 8, 0);
            BigDecimal bigDecimal = needQty = stEntryInfo.getQty() == null ? MMConstant.BIGDECIMAL_ZERO : stEntryInfo.getQty();
            if (needQty.compareTo(outQty) >= 0) continue;
            expRowIndex.append(", " + (i + 1));
        }
        if (expRowIndex != null && expRowIndex.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.STENTRYQTYCANNOTCONDITION, new Object[]{expRowIndex.substring(1)});
        }
    }

    private void doAfterAlterSubmit(Context ctx, IObjectPK pk, BillBaseStatusEnum dbStatus) throws BOSException, EASBizException {
        if (!this.isAlterSubmit) {
            return;
        }
        IProductionOrderFacade ibiz = ProductionOrderFacadeFactory.getLocalInstance(ctx);
        if (ibiz.isAutoFinished(pk.toString())) {
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(pk.toString());
            ibiz.dealCanAutoFinished(idList);
        } else {
            String sql = "update T_MM_ProductionOrder set FBaseStatus = ? where FID = ?";
            Object[] params = new Object[]{};
            params = BillBaseStatusEnum.AUDITED.equals((Object)dbStatus) ? new Object[]{new Integer(4), pk.toString()} : new Object[]{new Integer(5), pk.toString()};
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
    }

    @Override
    protected boolean _checkForceClose(Context ctx, IObjectPK[] pks, boolean isNeedCheck) throws BOSException, EASBizException {
        boolean isForce = false;
        if (pks == null || pks.length < 1) {
            return isForce;
        }
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            ids.append("'");
            ids.append(pks[i].getKeyValue(null).toString());
            ids.append("'");
            ids.append(",");
        }
        ids.replace(ids.length() - 1, ids.length(), "");
        StringBuffer statBuff = new StringBuffer();
        StringBuffer dispBuff = new StringBuffer();
        StringBuffer finishBuff = new StringBuffer();
        StringBuffer pickBuff = new StringBuffer();
        StringBuffer errBuff = new StringBuffer();
        String fStorageOrgUnitID = "";
        StringBuffer chkSql = new StringBuffer();
        chkSql.append(" select ");
        chkSql.append(" fNumber ");
        chkSql.append(",fBaseStatus ");
        chkSql.append(",fCommitTotalQty ");
        chkSql.append(",fBackFlushTotalQty ");
        chkSql.append(",fStorageOrgUnitID ");
        chkSql.append(" from ");
        chkSql.append(" t_mm_productionOrder ");
        chkSql.append(" where ");
        chkSql.append(" fid in (");
        chkSql.append(ids.toString());
        chkSql.append(")");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)chkSql.toString());
            while (rowSet.next()) {
                fStorageOrgUnitID = rowSet.getString("fStorageOrgUnitID");
                if (rowSet.getInt("fBaseStatus") == 8) continue;
                statBuff.append(rowSet.getString("fNumber")).append(",");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        if (statBuff.length() > 0) {
            errBuff.append(this.getResourceMsg("CloseStatusChk", new String[]{statBuff.replace(statBuff.length() - 1, statBuff.length(), "").toString()}, ctx));
        }
        ParamUtil paramUtil = new ParamUtil(ctx);
        paramUtil.setStorageOrgUnitID(fStorageOrgUnitID, false);
        isForce = GENCOST_NOT.equals(paramUtil.getClosePermittedParam("false"));
        if (isNeedCheck || !isForce) {
            IRowSet fRowSet;
            if (RELEASE_IMMEDIATE.equals(paramUtil.getTaskDispTypeParam("")) || RELEASE_SHIFT.equals(paramUtil.getTaskDispTypeParam(""))) {
                StringBuffer chkDispSql = new StringBuffer();
                chkDispSql.append(" select ");
                chkDispSql.append(" DISTINCT ordT.fNumber fNumber ");
                chkDispSql.append(" from ");
                chkDispSql.append(" t_mm_taskDispBill as tT ");
                chkDispSql.append(" inner join t_mm_productionOrder as ordT on ordT.fid=tT.fProductionOrderID ");
                chkDispSql.append(" where ");
                chkDispSql.append(" tT.fbasestatus <>8");
                chkDispSql.append(" and ordT.fid in (" + ids.toString() + ")");
                try {
                    fRowSet = DbUtil.executeQuery((Context)ctx, (String)chkDispSql.toString());
                    while (fRowSet.next()) {
                        dispBuff.append(fRowSet.getString("fNumber")).append(",");
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            if (dispBuff.length() > 0) {
                errBuff.append(this.getResourceMsg("CloseChk1", new String[]{dispBuff.replace(dispBuff.length() - 1, dispBuff.length(), "").toString()}, ctx));
            }
            if (GENCOST_NOT.equals(paramUtil.getEnabledProductionReportParam(GENCOST_NOT))) {
                StringBuffer chkFinishSql = new StringBuffer();
                chkFinishSql.append(" select ");
                chkFinishSql.append(" DISTINCT ordT.fNumber fNumber ");
                chkFinishSql.append(" from ");
                chkFinishSql.append(" t_mm_finishedRpt as fT ");
                chkFinishSql.append(" inner join t_mm_productionOrder as ordT on ordT.fid=fT.fProductionOrderID ");
                chkFinishSql.append(" where ");
                chkFinishSql.append(" fT.fbasestatus <>90");
                chkFinishSql.append(" and fT.fbasestatus <>4");
                chkFinishSql.append(" and ordT.fid in (" + ids.toString() + ")");
                try {
                    fRowSet = DbUtil.executeQuery((Context)ctx, (String)chkFinishSql.toString());
                    while (fRowSet.next()) {
                        finishBuff.append(fRowSet.getString("fNumber")).append(",");
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            if (finishBuff.length() > 0) {
                errBuff.append(this.getResourceMsg("CloseChk2", new String[]{finishBuff.replace(finishBuff.length() - 1, finishBuff.length(), "").toString()}, ctx));
            }
            if (GENCOST_NOT.equals(paramUtil.getEnabledPickBillParam(GENCOST_NOT))) {
                StringBuffer chkPickSql = new StringBuffer();
                chkPickSql.append(" select ");
                chkPickSql.append(" DISTINCT ordT.fNumber ");
                chkPickSql.append(" from ");
                chkPickSql.append(" t_mm_pickingSlipBill as sT ");
                chkPickSql.append(" inner join t_mm_productionOrder as ordT on ordT.fid=sT.fProductionOrderID ");
                chkPickSql.append(" where ");
                chkPickSql.append(" sT.fbasestatus<> 90");
                chkPickSql.append(" and  sT.fbasestatus<> 4");
                chkPickSql.append(" and ordT.fid in (" + ids.toString() + ")");
                try {
                    fRowSet = DbUtil.executeQuery((Context)ctx, (String)chkPickSql.toString());
                    while (fRowSet.next()) {
                        pickBuff.append(fRowSet.getString("fNumber")).append(",");
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            if (pickBuff.length() > 0) {
                errBuff.append(this.getResourceMsg("CloseChk3", new String[]{pickBuff.replace(pickBuff.length() - 1, pickBuff.length(), "").toString()}, ctx));
            }
        }
        if (errBuff.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.CLOSEEXCEPTION, new Object[]{errBuff.toString()});
        }
        return isForce;
    }

    @Override
    protected void _genMaterialReq(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchGenMaterialReq(ctx, entrys);
        result.throwExceptions();
    }

    public BatchActionResults batchGenMaterialReq(Context ctx, BatchExecuteParamsEntry[] entrys) throws BOSException, EASBizException {
        return this.batchExecute(ctx, entrys, new BatchActionEnum("GENMATERIALREQ"));
    }

    @Override
    protected void _genManuRec(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchGenManuRec(ctx, entrys);
        result.throwExceptions();
    }

    public BatchActionResults batchGenManuRec(Context ctx, BatchExecuteParamsEntry[] entrys) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entrys, new BatchActionEnum("GENMANUREC"));
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.control.app.xml.prdOrderprocessconfig.xml";
    }

    private CtrlUnitInfo getControlUnit(Context ctx) throws EASBizException, BOSException {
        CtrlUnitInfo cuInfo = null;
        Object cu = ctx.get((Object)OrgType.ControlUnit);
        if (cu != null) {
            cuInfo = (CtrlUnitInfo)cu;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            sic.add("code");
            cuInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cuInfo.getId().toString()), sic);
        }
        return cuInfo;
    }

    private void dealLotNumber(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks == null || pks.length < 1) {
            return;
        }
        IObjectCollection col = batchResults.getObjCollection();
        ProductionOrderInfo poInfo = null;
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("lotNo"));
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            poInfo = (ProductionOrderInfo)col.getObject(i);
            if (poInfo == null || poInfo.getMaterial() == null || !StringUtils.isEmpty((String)poInfo.getLotNo())) continue;
            PrdLotServerUtils.dealLotNo(ctx, poInfo);
            if (StringUtils.isEmpty((String)poInfo.getLotNo())) continue;
            this.innerUpdatePartial(ctx, (IObjectValue)poInfo, sel);
        }
    }

    @Override
    protected String _plsCheckForPrdEntry(Context ctx, ProductionOrderInfo orderInfo) throws BOSException, EASBizException {
        String err = null;
        err = this.checkPrdOrderEntrySubmitForPLS(ctx, (IObjectValue)orderInfo);
        return err;
    }
}

