/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.control.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IStoreState;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.mm.common.loadmass.HashMapObject;
import com.kingdee.eas.mm.control.IStockGatherMove;
import com.kingdee.eas.mm.control.ProductionOrderException;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryCollection;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryFactory;
import com.kingdee.eas.mm.control.ProductionOrderStockEntryInfo;
import com.kingdee.eas.mm.control.StockGatherMoveEntryInfo;
import com.kingdee.eas.mm.control.StockGatherMoveFactory;
import com.kingdee.eas.mm.control.StockGatherMoveInfo;
import com.kingdee.eas.mm.control.app.AbstractStockGatherMoveControllerBean;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.SCMLockInvDataVO;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.im.inv.IInventory;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StockGatherMoveControllerBean
extends AbstractStockGatherMoveControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.control.app.StockGatherMoveControllerBean");
    public static final String RES_PRD_ORDER = "com.kingdee.eas.mm.control.ProductionOrderResource";
    public static final String RES_STOCKGATHER = "com.kingdee.eas.mm.control.StockGatherResource";

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        StockGatherMoveInfo billInfo = new StockGatherMoveInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        billInfo.setBizDate(curDate);
        billInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        return billInfo;
    }

    @Override
    protected Map _getStockProductionOrderByCondition(Context ctx, FilterInfo filterInfo, String billId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String moveInPlanDate = "";
        Iterator iter = filterInfo.getFilterItems().iterator();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        while (iter.hasNext()) {
            FilterItemInfo filterItem = (FilterItemInfo)iter.next();
            if (!"moveInPlanDate".equals(filterItem.getPropertyName())) continue;
            Timestamp ts = (Timestamp)filterItem.getCompareValue();
            moveInPlanDate = sdf.format(ts);
            break;
        }
        FilterInfo filter = this.getActualFilterInfo(ctx, filterInfo);
        EntityViewInfo env = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("parent.id");
        env.setSelector(sic);
        env.setFilter(filter);
        ProductionOrderStockEntryCollection sEntryColls = ProductionOrderStockEntryFactory.getLocalInstance(ctx).getProductionOrderStockEntryCollection(env);
        if (sEntryColls.size() <= 0) {
            return result;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append("select FStockId,FStockEntryId,count(*) as num from T_MM_StockEntryToBillEntry where ");
        for (int i = 0; i < sEntryColls.size(); ++i) {
            if (i == 0) {
                filterSql.append(" ( ");
            }
            if (i != 0) {
                filterSql.append(" or ");
            }
            filterSql.append("( FStockId = '" + sEntryColls.get(i).getParent().getId().toString() + "'");
            filterSql.append(" and ");
            filterSql.append(" FStockEntryId = '" + sEntryColls.get(i).getId().toString() + "')");
            if (i != sEntryColls.size() - 1) continue;
            filterSql.append(" ) ");
        }
        filterSql.append(" and ");
        filterSql.append(" FBillId != '" + billId + "'");
        filterSql.append(" group by FStockId,FStockEntryId");
        IRowSet tempRs = DbUtil.executeQuery((Context)ctx, (String)filterSql.toString());
        try {
            block10: while (tempRs.next()) {
                String FStockId = tempRs.getString("FStockId");
                String FStockEntryId = tempRs.getString("FStockEntryId");
                int num = tempRs.getInt("num");
                if (num == 0) continue;
                for (int i = 0; i < sEntryColls.size(); ++i) {
                    ProductionOrderStockEntryInfo entryInfo = sEntryColls.get(i);
                    if (!entryInfo.getParent().getId().toString().equals(FStockId) || !entryInfo.getId().toString().equals(FStockEntryId)) continue;
                    sEntryColls.remove(entryInfo);
                    continue block10;
                }
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (sEntryColls.size() <= 0) {
            return result;
        }
        StringBuffer gatherSql = new StringBuffer();
        gatherSql.append("select  c.FMaterialid as material");
        gatherSql.append(",c.funitid as unit");
        gatherSql.append(",c.fLotNo as lot");
        gatherSql.append(",c.Fdefaultwarehouseid as defaultWareHouse");
        gatherSql.append(",c.FMoveOutWarehouseID as moveOutWareHouse");
        gatherSql.append(",c.FMoveOutStorageOrgUnitID as moveOutStorageOrgUnit");
        gatherSql.append(",sum(c.fbaseQty) fbaseQty");
        gatherSql.append(",sum(c.fqty) fqty ");
        gatherSql.append(" from T_MM_ProductionOrderSEntry c ");
        gatherSql.append(" where c.fid in (");
        for (int i = 0; i < sEntryColls.size(); ++i) {
            if (i != 0) {
                gatherSql.append(",");
            }
            gatherSql.append("'" + sEntryColls.get(i).getId().toString() + "'");
        }
        gatherSql.append(")");
        gatherSql.append(" group by c.fMaterialid, c.Fdefaultwarehouseid,c.fLotNo, c.funitid,c.FMoveOutWarehouseID,c.FMoveOutStorageOrgUnitID");
        IRowSet gatermoveRs = DbUtil.executeQuery((Context)ctx, (String)gatherSql.toString());
        HashMap<String, BigDecimal[]> gatherMap = new HashMap<String, BigDecimal[]>();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (gatermoveRs.next()) {
                String material = gatermoveRs.getString("material");
                String unit = gatermoveRs.getString("unit");
                String lot = gatermoveRs.getString("lot");
                String defaultWareHouse = gatermoveRs.getString("defaultWareHouse");
                String moveOutWareHouse = gatermoveRs.getString("moveOutWareHouse");
                String moveOutStorageOrgUnit = gatermoveRs.getString("moveOutStorageOrgUnit");
                BigDecimal baseQty = gatermoveRs.getBigDecimal("fbaseQty");
                BigDecimal qty = gatermoveRs.getBigDecimal("fqty");
                if (defaultWareHouse == null) {
                    defaultWareHouse = "";
                }
                if (moveOutWareHouse == null) {
                    moveOutWareHouse = "";
                }
                if (moveOutStorageOrgUnit == null) {
                    moveOutStorageOrgUnit = "";
                }
                if (lot == null) {
                    lot = "";
                }
                if (baseQty == null) {
                    baseQty = new BigDecimal("0");
                }
                if (qty == null) {
                    qty = new BigDecimal("0");
                }
                if (!map.containsKey(material + "," + defaultWareHouse + "," + lot)) {
                    map.put(material + "," + defaultWareHouse + "," + lot, "1");
                }
                gatherMap.put(material + "," + unit + "," + lot + "," + defaultWareHouse + "," + moveOutWareHouse + "," + moveOutStorageOrgUnit, new BigDecimal[]{baseQty, qty});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer canBeUsedSql = new StringBuffer();
        canBeUsedSql.append("select tii.FWarehouseID as fWarehouseID");
        canBeUsedSql.append(",tii.FMaterialID as fMaterialID, tii.FLot as fLot");
        canBeUsedSql.append(",ISNULL( sum(tii.FBaseQty), 0) as FBaseQty");
        canBeUsedSql.append(" from T_IM_Inventory tii  left join T_DB_WAREHOUSE tdw on tii.FWarehouseID=tdw.FID ");
        canBeUsedSql.append(" LEFT OUTER JOIN T_MM_PlanRangeParam D on tii.FStorageOrgUnitID = D.FStorageOrgUnitID ");
        canBeUsedSql.append(" LEFT OUTER JOIN T_BD_MaterialInventory tbmi on tii.FMaterialID = tbmi.FMaterialID AND tii.FStorageOrgUnitID = tbmi.FOrgUnit ");
        canBeUsedSql.append(" LEFT OUTER JOIN T_MM_PlanRangeWarehs E on E.FParentID = D.FID ");
        canBeUsedSql.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability tidd on tii.FLot = tidd.FLot AND tii.FStorageOrgUnitID = tidd.FStorageOrgUnitID AND tii.FMaterialID= tidd.FMaterialID ");
        canBeUsedSql.append(" WHERE ");
        canBeUsedSql.append(" ( D.FID is null ");
        canBeUsedSql.append("   OR ( ");
        canBeUsedSql.append("((D.FIsNormal  =1 AND  tii.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6') ");
        canBeUsedSql.append(" OR (D.FIsSupplierBorrow =1 AND tii.FStoreTypeID = '181875d5-0105-1000-e000-0120c0a812fd97D461A6') ");
        canBeUsedSql.append(" OR (D.FIsSupplierStorage =1 AND tii.FStoreTypeID = '181875d5-0105-1000-e000-0114c0a812fd97D461A6')) ");
        canBeUsedSql.append(" AND ");
        canBeUsedSql.append("((D.FIsAvailable  =1 AND  tii.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5') ");
        canBeUsedSql.append(" OR (D.FIsProvisionalFreeze =1 AND tii.FStoreStatusID = '181875d5-1105-1000-e000-013dc0a812fd62A73FA5') ");
        canBeUsedSql.append(" OR (D.FIsOutGoodsCheck =1 AND tii.FStoreStatusID = '181875d5-0105-1000-e000-0134c0a812fd62A73FA5') ");
        canBeUsedSql.append(" OR (D.FIsCheckStorageFreeze =1 AND tii.FStoreStatusID = '181875d5-2105-1000-e000-013dc0a812fd62A73FA5')) ");
        canBeUsedSql.append(" AND ");
        canBeUsedSql.append("(D.FIsAllStorage = 1 ");
        canBeUsedSql.append(" OR (D.FIsAllStorage = 0 AND tii.FWarehouseID = E.FWarhouseID)) ");
        canBeUsedSql.append("   )) ");
        canBeUsedSql.append(" and tii.FStorageOrgUnitID = '");
        canBeUsedSql.append((String)((FilterItemInfo)filterInfo.getFilterItems().getObject(0)).getCompareValue());
        canBeUsedSql.append("'");
        canBeUsedSql.append(" AND ((tbmi.FIsPeriodValid = 1 AND to_char(tidd.FEXP,'yyyy-MM-dd')>='" + moveInPlanDate + "') or (tbmi.FIsPeriodValid != 1))");
        canBeUsedSql.append(" and tii.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6'");
        canBeUsedSql.append(" and tii.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5'");
        canBeUsedSql.append(" and tdw.FTransState in ('1','2')");
        Set keys = map.keySet();
        if (keys.size() > 0) {
            canBeUsedSql.append(" and  (");
            Iterator it = keys.iterator();
            int count = 0;
            while (it.hasNext()) {
                String key = it.next().toString();
                String[] obj = key.split(",");
                if (obj.length < 2) continue;
                if (count > 0) {
                    canBeUsedSql.append(" or ");
                }
                canBeUsedSql.append(" (tii.FMaterialID = '" + obj[0] + "'");
                canBeUsedSql.append(" and tii.FWarehouseID = '" + obj[1] + "'");
                if (obj.length > 2) {
                    canBeUsedSql.append(" and tii.FLot = '" + obj[2] + "'");
                } else {
                    canBeUsedSql.append(" and tii.FLot is null");
                }
                canBeUsedSql.append(") ");
                ++count;
            }
            if (count == 0) {
                canBeUsedSql.append(" 1 = 1");
            }
            canBeUsedSql.append(" )");
        }
        canBeUsedSql.append(" group by tii.FWarehouseID,tii.FMaterialID,tii.FLot ");
        IRowSet canBeUseRs = DbUtil.executeQuery((Context)ctx, (String)canBeUsedSql.toString());
        HashMap<String, BigDecimal> canBeUseMap = new HashMap<String, BigDecimal>();
        try {
            while (canBeUseRs.next()) {
                String fWarehouseID = canBeUseRs.getString("fWarehouseID");
                String fMaterialID = canBeUseRs.getString("fMaterialID");
                String flot = canBeUseRs.getString("flot");
                BigDecimal FBaseQty = canBeUseRs.getBigDecimal("FBaseQty");
                canBeUseMap.put(fWarehouseID + "," + fMaterialID + (flot == null ? "" : "," + flot), FBaseQty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer reSql = new StringBuffer();
        reSql.append(" select distinct c.FMaterialid as material,");
        reSql.append("e.FNumber as materialNumber,e.");
        reSql.append(this.getFieldName(ctx));
        reSql.append(" as materialName,");
        reSql.append(" e.Fmodel as model,");
        reSql.append(" c.Fbaseunitid as baseUnit,f.");
        reSql.append(this.getFieldName(ctx));
        reSql.append(" as baseUnitName,");
        reSql.append(" f.FqtyPrecision as basePrecision,");
        reSql.append(" 0 as baseQty,");
        reSql.append(" c.funitid as unit,");
        reSql.append(" e1.");
        reSql.append(this.getFieldName(ctx));
        reSql.append(" as unitName,");
        reSql.append(" c.flotNo as lotNo,");
        reSql.append(" e1.FQtyPrecision as unitPrecision,");
        reSql.append(" 0 as qty,");
        reSql.append(" 0 as moveBaseQty,");
        reSql.append(" 0 as moveQty,");
        reSql.append(" case when k.FTransferBatch is null then null else ROUND(k.FTransferBatch*l.fBaseConvsRate, f.FqtyPrecision) end as transBaseBatch,");
        reSql.append(" case when k.FTransferBatch is null then null else ROUND(k.FTransferBatch*l.fBaseConvsRate/e2.fBaseConvsRate, e1.FQtyPrecision) end as transBatch,");
        reSql.append(" 0 as baseCanbeUseQty,");
        reSql.append(" 0 as canbeUseQty,");
        reSql.append(" e2.fBaseConvsRate as unitConvsRate,");
        reSql.append(" c.Fdefaultwarehouseid as warehouse, ");
        reSql.append(" c.Fdefaultwarehouseid as warehouseId, ");
        reSql.append(" c.FMoveOutWarehouseID as moveOutWareHouse, ");
        reSql.append(" c.FMoveOutStorageOrgUnitID as moveOutStorageOrgUnit, ");
        reSql.append(" c.FMoveOutWarehouseID as moveOutWareHouseId, ");
        reSql.append(" c.FMoveOutStorageOrgUnitID as moveOutStorageOrgUnitID, ");
        reSql.append("'" + moveInPlanDate + "' as moveInPlanDate");
        reSql.append(" from T_MM_ProductionOrderSEntry c");
        reSql.append(" inner join T_BD_Material e on c.fMaterialid = e.fid");
        reSql.append(" left join T_BD_MeasureUnit e1 on e1.fid = c.funitid");
        reSql.append(" left join t_bd_multiMeasureUnit e2 on c.funitid = e2.fMeasureUnitID and e2.fMaterialid = c.fMaterialid");
        reSql.append(" left join T_BD_MeasureUnit f on c.fbaseunitid = f.fid");
        reSql.append(" left join T_BD_MaterialPlan k on c.fMaterialid = k.fMaterialid");
        reSql.append(" left join t_bd_multiMeasureUnit l on k.FProductUnitID = l.fMeasureUnitID where l.fMaterialid = c.fMaterialid and k.FOrgUnit='");
        reSql.append((String)((FilterItemInfo)filterInfo.getFilterItems().getObject(0)).getCompareValue());
        reSql.append("'");
        reSql.append(" and c.fid in (");
        for (int i = 0; i < sEntryColls.size(); ++i) {
            ProductionOrderStockEntryInfo entryInfo = sEntryColls.get(i);
            if (i != 0) {
                reSql.append(",");
            }
            reSql.append("'" + entryInfo.getId().toString() + "'");
        }
        reSql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)reSql.toString());
        HashSet<String> wareSet = new HashSet<String>();
        HashSet<String> stoSet = new HashSet<String>();
        try {
            WarehouseCollection col;
            IRowSetMetaData metaData = rs.getRowSetMetaData();
            DynamicRowSet dynamicRowSet = new DynamicRowSet(metaData.getColumnCount());
            String columnKey = null;
            int k = 0;
            while (rs.next()) {
                dynamicRowSet.moveToInsertRow();
                String material = rs.getString("material");
                String unit = rs.getString("unit");
                String defaultWareHouse = rs.getString("warehouseId");
                String moveOUtWareHouse = rs.getString("moveOutWareHouse");
                String moveOutStorageOrgUnit = rs.getString("moveOutStorageOrgUnit");
                String lotNo = rs.getString("lotNo");
                if (!StringUtil.isEmpty((String)defaultWareHouse)) {
                    wareSet.add(defaultWareHouse);
                }
                if (!StringUtil.isEmpty((String)moveOUtWareHouse)) {
                    wareSet.add(moveOUtWareHouse);
                }
                if (!StringUtil.isEmpty((String)moveOutStorageOrgUnit)) {
                    stoSet.add(moveOutStorageOrgUnit);
                }
                BigDecimal baseCVSRate = rs.getBigDecimal("unitConvsRate");
                int precision = rs.getInt("unitPrecision");
                BigDecimal[] qtys = null;
                String key = material + "," + unit;
                key = lotNo == null ? key + "," : key + "," + lotNo;
                key = defaultWareHouse == null ? key + "," : key + "," + defaultWareHouse;
                key = moveOUtWareHouse == null ? key + "," : key + "," + moveOUtWareHouse;
                key = moveOutStorageOrgUnit == null ? key + "," : key + "," + moveOutStorageOrgUnit;
                if (gatherMap.get(key) != null) {
                    qtys = (BigDecimal[])gatherMap.get(key);
                }
                BigDecimal canBeUseBaseQty = new BigDecimal("0");
                key = defaultWareHouse == null ? "," + material : defaultWareHouse + "," + material;
                if (lotNo != null) {
                    key = key + "," + lotNo;
                }
                if (canBeUseMap.get(key) != null) {
                    canBeUseBaseQty = (BigDecimal)canBeUseMap.get(key);
                }
                BigDecimal baseQty = new BigDecimal("0");
                BigDecimal qty = new BigDecimal("0");
                BigDecimal moveBaseQty = new BigDecimal("0");
                BigDecimal moveQty = new BigDecimal("0");
                if (qtys != null) {
                    baseQty = qtys[0];
                    qty = qtys[1];
                }
                if (qtys != null) {
                    moveBaseQty = qtys[0];
                    moveQty = qtys[1];
                }
                BigDecimal canBeUseQty = canBeUseBaseQty.divide(baseCVSRate, precision, 4);
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    columnKey = metaData.getColumnName(i);
                    dynamicRowSet.setColInfo(i, new ColInfo(columnKey, columnKey, 12, null));
                    if (columnKey.equalsIgnoreCase("baseQty")) {
                        dynamicRowSet.updateBigDecimal(columnKey, baseQty);
                        continue;
                    }
                    if (columnKey.equalsIgnoreCase("qty")) {
                        dynamicRowSet.updateBigDecimal(columnKey, qty);
                        continue;
                    }
                    if (columnKey.equalsIgnoreCase("moveBaseQty")) {
                        dynamicRowSet.updateBigDecimal(columnKey, moveBaseQty);
                        continue;
                    }
                    if (columnKey.equalsIgnoreCase("moveQty")) {
                        dynamicRowSet.updateBigDecimal(columnKey, moveQty);
                        continue;
                    }
                    if (columnKey.equalsIgnoreCase("baseCanbeUseQty")) {
                        dynamicRowSet.updateBigDecimal(columnKey, canBeUseBaseQty);
                        continue;
                    }
                    if (columnKey.equalsIgnoreCase("canbeUseQty")) {
                        dynamicRowSet.updateBigDecimal(columnKey, canBeUseQty);
                        continue;
                    }
                    dynamicRowSet.updateString(columnKey, rs.getString(columnKey));
                }
                dynamicRowSet.insertRow();
                ++k;
            }
            if (wareSet.size() > 0) {
                EntityViewInfo wareViewInfo = new EntityViewInfo();
                FilterInfo wareFilterInfo = new FilterInfo();
                wareFilterInfo.getFilterItems().add(new FilterItemInfo("id", wareSet, CompareType.INCLUDE));
                wareViewInfo.setFilter(wareFilterInfo);
                wareViewInfo.getSelector().add(new SelectorItemInfo("id"));
                wareViewInfo.getSelector().add(new SelectorItemInfo("number"));
                wareViewInfo.getSelector().add(new SelectorItemInfo("name"));
                col = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(wareViewInfo);
                result.put("wareHouse", col);
            }
            if (stoSet.size() > 0) {
                EntityViewInfo stoViewInfo = new EntityViewInfo();
                FilterInfo stoFilterInfo = new FilterInfo();
                stoFilterInfo.getFilterItems().add(new FilterItemInfo("id", stoSet, CompareType.INCLUDE));
                stoViewInfo.setFilter(stoFilterInfo);
                stoViewInfo.getSelector().add(new SelectorItemInfo("id"));
                stoViewInfo.getSelector().add(new SelectorItemInfo("number"));
                stoViewInfo.getSelector().add(new SelectorItemInfo("name"));
                col = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(stoViewInfo);
                result.put("StorageOrg", col);
            }
            if (k > 0) {
                dynamicRowSet.beforeFirst();
                result.put("result", dynamicRowSet);
            }
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public FilterInfo getActualFilterInfo(Context ctx, FilterInfo filter) {
        FilterInfo actFilter = new FilterInfo();
        for (FilterItemInfo filterItem : filter.getFilterItems()) {
            Date date;
            if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                actFilter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", filterItem.getCompareValue(), CompareType.EQUALS));
            }
            if ("workShopID".equals(filterItem.getPropertyName())) {
                actFilter.getFilterItems().add(new FilterItemInfo("parent.workShop.id", filterItem.getCompareValue(), CompareType.INCLUDE));
            }
            if ("productLineID".equals(filterItem.getPropertyName())) {
                actFilter.getFilterItems().add(new FilterItemInfo("parent.productLine.id", filterItem.getCompareValue(), CompareType.INCLUDE));
            }
            if ("materialNumFrom".equals(filterItem.getPropertyName())) {
                actFilter.getFilterItems().add(new FilterItemInfo("parent.material.number", filterItem.getCompareValue(), CompareType.GREATER_EQUALS));
            }
            if ("materialNumTo".equals(filterItem.getPropertyName())) {
                actFilter.getFilterItems().add(new FilterItemInfo("parent.material.number", filterItem.getCompareValue(), CompareType.LESS_EQUALS));
            }
            if ("startDateFrom".equals(filterItem.getPropertyName())) {
                date = (Date)filterItem.getCompareValue();
                actFilter.getFilterItems().add(new FilterItemInfo("parent.startDate", (Object)date, CompareType.GREATER_EQUALS));
            }
            if ("startDateTo".equals(filterItem.getPropertyName())) {
                date = (Date)filterItem.getCompareValue();
                actFilter.getFilterItems().add(new FilterItemInfo("parent.startDate", (Object)date, CompareType.LESS_EQUALS));
            }
            if ("endDateFrom".equals(filterItem.getPropertyName())) {
                date = (Date)filterItem.getCompareValue();
                actFilter.getFilterItems().add(new FilterItemInfo("parent.endDate", (Object)date, CompareType.GREATER_EQUALS));
            }
            if ("endDateTo".equals(filterItem.getPropertyName())) {
                date = (Date)filterItem.getCompareValue();
                actFilter.getFilterItems().add(new FilterItemInfo("parent.endDate", (Object)date, CompareType.LESS_EQUALS));
            }
            if ("productionOrderFrom".equals(filterItem.getPropertyName())) {
                actFilter.getFilterItems().add(new FilterItemInfo("parent.number", filterItem.getCompareValue(), CompareType.GREATER_EQUALS));
            }
            if ("productionOrderTo".equals(filterItem.getPropertyName())) {
                actFilter.getFilterItems().add(new FilterItemInfo("parent.number", filterItem.getCompareValue(), CompareType.LESS_EQUALS));
            }
            if ("isBackFlush".equals(filterItem.getPropertyName())) {
                switch ((Integer)filterItem.getCompareValue()) {
                    case 0: 
                    case 1: {
                        actFilter.getFilterItems().add(new FilterItemInfo("isBackFlush", (Object)new Integer(filterItem.getCompareValue().toString()), CompareType.EQUALS));
                        break;
                    }
                }
            }
            if ("defaultWareHouseId".equals(filterItem.getPropertyName())) {
                actFilter.getFilterItems().add(new FilterItemInfo("defaultWarehouse.id", filterItem.getCompareValue(), CompareType.INCLUDE));
            }
            if ("moveOutStorageOrgUnitId".equals(filterItem.getPropertyName())) {
                actFilter.getFilterItems().add(new FilterItemInfo("moveOutStorageOrgUnit.id", filterItem.getCompareValue(), CompareType.EQUALS));
            }
            if ("moveOutWareHouseId".equals(filterItem.getPropertyName())) {
                actFilter.getFilterItems().add(new FilterItemInfo("moveOutWarehouse.id", filterItem.getCompareValue(), CompareType.INCLUDE));
            }
            if (!"locationID".equals(filterItem.getPropertyName())) continue;
            actFilter.getFilterItems().add(new FilterItemInfo("location.id", filterItem.getCompareValue(), CompareType.EQUALS));
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(4));
        set.add(new Integer(5));
        actFilter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", set, CompareType.INCLUDE));
        actFilter.getFilterItems().add(new FilterItemInfo("translateID", null, CompareType.EQUALS));
        actFilter.getFilterItems().add(new FilterItemInfo("qty", (Object)new Integer(0), CompareType.GREATER));
        actFilter.getFilterItems().add(new FilterItemInfo("issMode", (Object)new Integer(11010), CompareType.EQUALS));
        actFilter.getFilterItems().add(new FilterItemInfo("isStock", (Object)Boolean.TRUE, CompareType.EQUALS));
        return actFilter;
    }

    private String getFieldName(Context ctx) {
        return "FName_" + ctx.getLocale();
    }

    @Override
    protected IObjectPK _saveAndInsertRelation(Context ctx, StockGatherMoveInfo model, BOTRelationCollection botRelationCollection, FilterInfo filterInfo, Object[] newEntry, IObjectPK[] existEntrys, String[] newEntrysSeq, String[] noWareHouseList, List clientMutex, Map clientMutexNum) throws BOSException, EASBizException {
        IObjectPK billPK = null;
        billPK = super._saveRelations(ctx, (IObjectValue)model, (IObjectCollection)botRelationCollection);
        this.insertOrUpdateRelation(ctx, filterInfo, newEntry, existEntrys, newEntrysSeq, billPK, noWareHouseList, false, clientMutex, clientMutexNum);
        return billPK;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String billTypeId;
        IObjectPK billPK = super._submit(ctx, model);
        StockGatherMoveInfo orderInfo = (StockGatherMoveInfo)model;
        if (orderInfo.getBillType() != null && (billTypeId = orderInfo.getBillType().getId().toString()).equals("PJSZtgEhEADgAAJ8fwAAAUY+1VI=")) {
            String orgUnitID = orderInfo.getStorageOrgUnit().getId().toString();
            boolean isAutoAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 4, orgUnitID, billTypeId);
            if (!StringUtils.isEmpty((String)strAutoAudit) && strAutoAudit.trim().toLowerCase().equals("1")) {
                isAutoAudit = true;
            }
            if (isAutoAudit) {
                this._audit(ctx, new IObjectPK[]{billPK});
            }
        }
        return billPK;
    }

    @Override
    protected IObjectPK _submitAndInsertRelation(Context ctx, StockGatherMoveInfo model, BOTRelationCollection botRelationCollection, FilterInfo filterInfo, Object[] newEntry, IObjectPK[] existEntrys, String[] newEntrysSeq, String[] noWareHouseList, List clientMutex, Map clientMutexNum) throws BOSException, EASBizException {
        IObjectPK billPK = null;
        billPK = super._submitRelations(ctx, (IObjectValue)model, (IObjectCollection)botRelationCollection);
        this.insertOrUpdateRelation(ctx, filterInfo, newEntry, existEntrys, newEntrysSeq, billPK, noWareHouseList, true, clientMutex, clientMutexNum);
        StringBuffer backWriteSql = new StringBuffer();
        backWriteSql.append("update T_MM_ProductionOrderSEntry as q set (FTranslateID,FTranslateEntrySeq,FMoveOutStorageOrgUnitID,FMoveOutWarehouseID, FLotNo) =");
        backWriteSql.append("(select distinct t.FNumber,k.FSeq,k.FMoveOutStorageOrgUnitID,k.FMoveOutWarehouseID,k.FLotNo from T_MM_StockGatherMove t ");
        backWriteSql.append(" inner join T_MM_StockGatherMoveEntry k on k.FParentId=t.fid");
        backWriteSql.append(" inner join T_MM_StockEntryToBillEntry s on s.FBillEntryId=k.fid");
        backWriteSql.append(" where t.fid ='");
        backWriteSql.append(billPK.toString());
        backWriteSql.append("'and s.FStockEntryId=q.fid)");
        backWriteSql.append(" where q.fid in (");
        backWriteSql.append(" select distinct FStockEntryId");
        backWriteSql.append(" from T_MM_StockEntryToBillEntry where FBillId ='");
        backWriteSql.append(billPK.toString());
        backWriteSql.append("'");
        backWriteSql.append(")");
        DbUtil.execute((Context)ctx, (String)backWriteSql.toString());
        return billPK;
    }

    private void insertOrUpdateRelation(Context ctx, FilterInfo filterInfo, Object[] newEntry, IObjectPK[] existEntrys, String[] newEntrysSeq, IObjectPK billPK, String[] noWareHouseList, boolean isSubmit, List clientMutex, Map clientMutexNum) throws BOSException, EASBizException {
        block7: {
            block6: {
                if (newEntry.length <= 0) break block6;
                StringBuffer delRelationSql = new StringBuffer();
                delRelationSql.append("delete from T_MM_StockEntryToBillEntry ");
                delRelationSql.append("where FBillId= ");
                delRelationSql.append("'" + billPK.toString() + "'");
                DbUtil.execute((Context)ctx, (String)delRelationSql.toString());
                Connection conn = null;
                Statement stmt = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.createStatement();
                    StringBuffer insertSql = null;
                    int j = newEntry.length;
                    for (int i = 0; i < j; ++i) {
                        insertSql = new StringBuffer();
                        StockGatherMoveEntryInfo psbeInfo = (StockGatherMoveEntryInfo)newEntry[i];
                        String wareHouseId = (String)psbeInfo.get("wareHouseId");
                        String moveOutStorageOrgUnitId = (String)psbeInfo.get("moveOutStorageOrgUnitId");
                        String moveOutWareHouseId = (String)psbeInfo.get("moveOutWareHouseId");
                        String lotNo = (String)psbeInfo.get("lotNo");
                        int seq = (Integer)psbeInfo.get("seq");
                        this.checkDataMutex(ctx, filterInfo, billPK, clientMutex, clientMutexNum, psbeInfo);
                        insertSql.append(" insert into T_MM_StockEntryToBillEntry (FBillId,FBillEntryId,FStockId,FStockEntryId) ");
                        insertSql.append("select c.FParentID,c.fid,d.fStockId,d.fStockEntryId ");
                        insertSql.append("from T_MM_StockGatherMoveEntry c inner join (");
                        insertSql.append(" select distinct a.fid as fStockId,b.fid as fStockEntryId, b.FMaterialid, b.Fdefaultwarehouseid, b.funitid, b.FMoveOutWarehouseID, b.FMoveOutStorageOrgUnitID,b.FLotNo");
                        insertSql.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
                        insertSql.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
                        insertSql.append(this.getFilterSql(filterInfo));
                        insertSql.append(" and not exists(select * from T_MM_StockEntryToBillEntry where FStockId=a.fid and FStockEntryId=b.fid and fbillid != '" + billPK.toString() + "')");
                        insertSql.append(") d on c.FMaterialid = d.FMaterialid and c.funitid = d.funitid ");
                        insertSql.append(wareHouseId == null ? " and d.Fdefaultwarehouseid is null" : " and c.FWarehouseID = d.Fdefaultwarehouseid");
                        insertSql.append(moveOutStorageOrgUnitId == null ? " and d.FMoveOutStorageOrgUnitID is null" : " and c.FMoveOutStorageOrgUnitID = d.FMoveOutStorageOrgUnitID");
                        insertSql.append(moveOutWareHouseId == null ? " and d.FMoveOutWarehouseID is null" : " and c.FMoveOutWarehouseID = d.FMoveOutWarehouseID");
                        insertSql.append(lotNo == null ? " and d.flotNo is null" : " and c.FLotNo = d.FLotNo");
                        insertSql.append(" and c.FParentID= '");
                        insertSql.append(billPK.toString());
                        insertSql.append("'");
                        insertSql.append(" and c.FSeq = " + seq);
                        stmt.addBatch(insertSql.toString());
                    }
                    stmt.executeBatch();
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)ex);
                        throw new BOSException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(stmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
                break block7;
            }
            if (isSubmit) {
                StringBuffer backWriteDelSql = new StringBuffer();
                backWriteDelSql.append("update T_MM_ProductionOrderSEntry as q set FTranslateID=null,FTranslateEntrySeq=0");
                backWriteDelSql.append(" where q.fid in (");
                backWriteDelSql.append(" select distinct FStockEntryId");
                backWriteDelSql.append(" from T_MM_StockEntryToBillEntry where FBillId='" + billPK.toString() + "'");
                backWriteDelSql.append(")");
                DbUtil.execute((Context)ctx, (String)backWriteDelSql.toString());
            }
            StringBuffer delPartRelationSql = new StringBuffer();
            delPartRelationSql.append("delete from T_MM_StockEntryToBillEntry ");
            delPartRelationSql.append("where FBillId= ");
            delPartRelationSql.append("'" + billPK.toString() + "'");
            delPartRelationSql.append(" and FBillEntryId not in (");
            delPartRelationSql.append("select fid from T_MM_StockGatherMoveEntry where FParentID=");
            delPartRelationSql.append("'" + billPK.toString() + "'");
            delPartRelationSql.append(")");
            DbUtil.execute((Context)ctx, (String)delPartRelationSql.toString());
        }
    }

    protected void checkDataMutex(Context ctx, FilterInfo filterInfo, IObjectPK billPK, List clientMutex, Map clientMutexNum, StockGatherMoveEntryInfo psbeInfo) throws BOSException, ActionCommonException {
        if (clientMutex.size() <= 0) {
            return;
        }
        String materialId = psbeInfo.getMaterial().getId().toString();
        String unitId = psbeInfo.getUnit().getId().toString();
        String wareHouseId = (String)psbeInfo.get("wareHouseId");
        String moveOutStorageOrgUnitId = (String)psbeInfo.get("moveOutStorageOrgUnitId");
        String moveOutWareHouseId = (String)psbeInfo.get("moveOutWareHouseId");
        String lotNo = (String)psbeInfo.get("lotNo");
        int seq = (Integer)psbeInfo.get("seq");
        StringBuffer addRelationCheckSql = new StringBuffer();
        addRelationCheckSql.append("select d.fStockId,d.fStockEntryId ");
        addRelationCheckSql.append(" from T_MM_StockGatherMoveEntry c inner join (");
        addRelationCheckSql.append(" select distinct a.fid as fStockId,b.fid as fStockEntryId, b.FMaterialid, b.funitid, b.Fdefaultwarehouseid,b.FMoveOutStorageOrgUnitID,b.FMoveOutWarehouseID, b.FLotNo");
        addRelationCheckSql.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        addRelationCheckSql.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
        addRelationCheckSql.append(this.getFilterSql(filterInfo));
        addRelationCheckSql.append(" and not exists(select * from T_MM_StockEntryToBillEntry where FStockId=a.fid and FStockEntryId=b.fid and fbillid != '" + billPK.toString() + "')");
        addRelationCheckSql.append(") d on c.FMaterialid = d.FMaterialid and c.funitid = d.funitid ");
        addRelationCheckSql.append(wareHouseId == null ? " and d.Fdefaultwarehouseid is null" : " and c.FWarehouseID = d.Fdefaultwarehouseid");
        addRelationCheckSql.append(moveOutStorageOrgUnitId == null ? " and d.FMoveOutStorageOrgUnitID is null" : " and c.FMoveOutStorageOrgUnitID = d.FMoveOutStorageOrgUnitID");
        addRelationCheckSql.append(moveOutWareHouseId == null ? " and d.FMoveOutWarehouseID is null" : " and c.FMoveOutWarehouseID = d.FMoveOutWarehouseID");
        addRelationCheckSql.append(lotNo == null ? " and d.flotNo is null" : " and c.FLotNo = d.FLotNo");
        addRelationCheckSql.append(" and c.FParentID= '");
        addRelationCheckSql.append(billPK.toString());
        addRelationCheckSql.append("'");
        addRelationCheckSql.append(" and c.FSeq = " + seq);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)addRelationCheckSql.toString());
        ActionCommonException bizExp = new ActionCommonException(null);
        if (rowSet.size() == 0) {
            bizExp.setMessage(this.getResourceMsg("stockGather_mutex"));
            throw bizExp;
        }
        int num = 0;
        try {
            while (rowSet.next()) {
                String orderId = rowSet.getString("fStockId");
                String stockId = rowSet.getString("fStockEntryId");
                String totleId = orderId + stockId;
                if (clientMutex.indexOf(totleId) < 0) {
                    bizExp.setMessage(this.getResourceMsg("stockGather_mutex"));
                    throw bizExp;
                }
                ++num;
            }
            String key = materialId + unitId + wareHouseId + moveOutWareHouseId + moveOutStorageOrgUnitId + lotNo;
            if (!new Integer(num).equals((Integer)clientMutexNum.get(key))) {
                bizExp.setMessage(this.getResourceMsg("stockGather_mutex"));
                throw bizExp;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        super._canDelete(ctx, pk, cn);
        StockGatherMoveInfo sgmInfo = null;
        try {
            sgmInfo = (StockGatherMoveInfo)this.getValue(ctx, pk);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (sgmInfo != null && sgmInfo.getBaseStatus() != null && sgmInfo.getBaseStatus().getValue() >= 4) {
            throw new CanNotDeleteException(ResourceBase.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource.PrdDel_Msg1", (Locale)ctx.getLocale()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer backWriteDelSql = new StringBuffer();
        backWriteDelSql.append("update T_MM_ProductionOrderSEntry as q set FTranslateID=null,FTranslateEntrySeq=0");
        backWriteDelSql.append(" where q.fid in (");
        backWriteDelSql.append(" select distinct FStockEntryId");
        backWriteDelSql.append(" from T_MM_StockEntryToBillEntry where FBillId ='");
        backWriteDelSql.append(pk.toString());
        backWriteDelSql.append("'");
        backWriteDelSql.append(")");
        DbUtil.execute((Context)ctx, (String)backWriteDelSql.toString());
        StringBuffer delRelationSql = new StringBuffer();
        delRelationSql.append("delete from T_MM_StockEntryToBillEntry ");
        delRelationSql.append(" where FBillId in ('" + pk.toString() + "')");
        DbUtil.execute((Context)ctx, (String)delRelationSql.toString());
        super._delete(ctx, pk);
    }

    private void getFilterSQL(FilterInfo filterInfo, StringBuffer sqlBuff) {
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            String locationId;
            int i;
            Iterator iterPli;
            Set workShopInfos;
            if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.FStorageOrgUnitID = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("workShopID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" (");
                workShopInfos = (Set)filterItem.getCompareValue();
                iterPli = workShopInfos.iterator();
                i = 1;
                while (iterPli.hasNext()) {
                    if (i == 1) {
                        sqlBuff.append(" a.FWorkShopID ='" + (String)iterPli.next() + "' ");
                    } else {
                        sqlBuff.append(" OR a.FWorkShopID ='" + (String)iterPli.next() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") and");
            }
            if ("defaultWareHouseId".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" (");
                workShopInfos = (Set)filterItem.getCompareValue();
                iterPli = workShopInfos.iterator();
                i = 1;
                while (iterPli.hasNext()) {
                    if (i == 1) {
                        sqlBuff.append(" b.FDefaultWarehouseID ='" + (String)iterPli.next() + "' ");
                    } else {
                        sqlBuff.append(" OR b.FDefaultWarehouseID ='" + (String)iterPli.next() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") and");
            }
            if ("moveOutStorageOrgUnitId".equals(filterItem.getPropertyName())) {
                String moveOutStorageOrgUnitId = (String)filterItem.getCompareValue();
                if (moveOutStorageOrgUnitId == null || moveOutStorageOrgUnitId.equals("")) {
                    sqlBuff.append(" b.FMoveOutStorageOrgUnitId is null and");
                } else {
                    sqlBuff.append(" b.FMoveOutStorageOrgUnitId = '");
                    sqlBuff.append(moveOutStorageOrgUnitId);
                    sqlBuff.append("' and");
                }
            }
            if ("moveOutWareHouseId".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" (");
                workShopInfos = (Set)filterItem.getCompareValue();
                iterPli = workShopInfos.iterator();
                i = 1;
                while (iterPli.hasNext()) {
                    if (i == 1) {
                        sqlBuff.append(" b.FMoveOutWarehouseID ='" + (String)iterPli.next() + "' ");
                    } else {
                        sqlBuff.append(" OR b.FMoveOutWarehouseID ='" + (String)iterPli.next() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") and");
            }
            if ("productLineID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" (");
                Set productLineInfos = (Set)filterItem.getCompareValue();
                iterPli = productLineInfos.iterator();
                i = 1;
                while (iterPli.hasNext()) {
                    if (i == 1) {
                        sqlBuff.append(" a.FProductLineID ='" + (String)iterPli.next() + "' ");
                    } else {
                        sqlBuff.append(" OR a.FProductLineID ='" + (String)iterPli.next() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") and");
            }
            if ("materialNumFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" c.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("materialNumTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" c.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'and");
            }
            if ("startDateFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fstartdate,'YYYY-MM-DD HH24:MI:SS') >= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("startDateTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fstartdate,'YYYY-MM-DD HH24:MI:SS') <= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("endDateFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fenddate,'YYYY-MM-DD HH24:MI:SS') >= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("endDateTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fenddate,'YYYY-MM-DD HH24:MI:SS') <= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("productionOrderFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("productionOrderTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("isBackFlush".equals(filterItem.getPropertyName())) {
                switch ((Integer)filterItem.getCompareValue()) {
                    case 1: {
                        sqlBuff.append(" b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        sqlBuff.append(" and");
                        break;
                    }
                    case 0: {
                        sqlBuff.append(" b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        sqlBuff.append(" and");
                        break;
                    }
                }
            }
            if (!"locationID".equals(filterItem.getPropertyName()) || (locationId = (String)filterItem.getCompareValue()) == null || "".equals(locationId)) continue;
            sqlBuff.append(" b.FLocationID = '");
            sqlBuff.append(locationId);
            sqlBuff.append("' and");
        }
        sqlBuff.append(" a.FbaseStatus in (");
        sqlBuff.append(4);
        sqlBuff.append(",");
        sqlBuff.append(5);
        sqlBuff.append(") and");
        sqlBuff.append(" b.FTranslateID is null and");
        sqlBuff.append(" b.FIsStock = 1 and");
        sqlBuff.append(" b.FQty > 0 and");
        sqlBuff.append(" b.FIssMode = 11010");
        sqlBuff.append(" and b.FIsStock = 1");
    }

    private String getFilterSql(FilterInfo filterInfo) {
        StringBuffer sqlBuff = new StringBuffer();
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            String locationId;
            int i;
            Iterator iterPli;
            if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.FStorageOrgUnitID = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
                sqlBuff.append(" and");
            }
            if ("workShopID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" (");
                Set workShopInfos = (Set)filterItem.getCompareValue();
                iterPli = workShopInfos.iterator();
                i = 1;
                while (iterPli.hasNext()) {
                    if (i == 1) {
                        sqlBuff.append(" a.FWorkShopID ='" + (String)iterPli.next() + "' ");
                    } else {
                        sqlBuff.append(" OR a.FWorkShopID ='" + (String)iterPli.next() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") and");
            }
            if ("productLineID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" (");
                Set productLineInfos = (Set)filterItem.getCompareValue();
                iterPli = productLineInfos.iterator();
                i = 1;
                while (iterPli.hasNext()) {
                    if (i == 1) {
                        sqlBuff.append(" a.FProductLineID ='" + (String)iterPli.next() + "' ");
                    } else {
                        sqlBuff.append(" OR a.FProductLineID ='" + (String)iterPli.next() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") and");
            }
            if ("materialNumFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" c.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
                sqlBuff.append(" and");
            }
            if ("materialNumTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" c.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
                sqlBuff.append(" and");
            }
            if ("startDateFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fstartdate,'YYYY-MM-DD HH24:MI:SS') >= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("startDateTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fstartdate,'YYYY-MM-DD HH24:MI:SS') <= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("endDateFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fenddate,'YYYY-MM-DD HH24:MI:SS') >= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("endDateTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fenddate,'YYYY-MM-DD HH24:MI:SS') <= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("productionOrderFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
                sqlBuff.append(" and");
            }
            if ("productionOrderTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'");
                sqlBuff.append(" and");
            }
            if ("isBackFlush".equals(filterItem.getPropertyName())) {
                switch ((Integer)filterItem.getCompareValue()) {
                    case 1: {
                        sqlBuff.append(" b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        sqlBuff.append(" and");
                        break;
                    }
                    case 0: {
                        sqlBuff.append(" b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        sqlBuff.append(" and");
                        break;
                    }
                }
            }
            if (!"locationID".equals(filterItem.getPropertyName()) || (locationId = (String)filterItem.getCompareValue()) == null || "".equals(locationId)) continue;
            sqlBuff.append(" b.FLocationID = '");
            sqlBuff.append(locationId);
            sqlBuff.append("' and");
        }
        sqlBuff.append(" a.FbaseStatus in (");
        sqlBuff.append(4);
        sqlBuff.append(",");
        sqlBuff.append(5);
        sqlBuff.append(") and");
        sqlBuff.append(" b.FTranslateID is null and");
        sqlBuff.append(" b.FIsStock = 1 and");
        sqlBuff.append(" b.FQty > 0 and");
        sqlBuff.append(" b.FIssMode = 11010");
        return sqlBuff.toString();
    }

    private void getFilterSQLForSourceView(FilterInfo filterInfo, StringBuffer sqlBuff) {
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            String locationId;
            int i;
            Iterator iterPli;
            if ("storageOrgUnitID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.FStorageOrgUnitID = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("workShopID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" (");
                Set workShopInfos = (Set)filterItem.getCompareValue();
                iterPli = workShopInfos.iterator();
                i = 1;
                while (iterPli.hasNext()) {
                    if (i == 1) {
                        sqlBuff.append(" a.FWorkShopID ='" + (String)iterPli.next() + "' ");
                    } else {
                        sqlBuff.append(" OR a.FWorkShopID ='" + (String)iterPli.next() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") and");
            }
            if ("productLineID".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" (");
                Set productLineInfos = (Set)filterItem.getCompareValue();
                iterPli = productLineInfos.iterator();
                i = 1;
                while (iterPli.hasNext()) {
                    if (i == 1) {
                        sqlBuff.append(" a.FProductLineID ='" + (String)iterPli.next() + "' ");
                    } else {
                        sqlBuff.append(" OR a.FProductLineID ='" + (String)iterPli.next() + "' ");
                    }
                    ++i;
                }
                sqlBuff.append(") and");
            }
            if ("materialNumFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" c.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("materialNumTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" c.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("'and");
            }
            if ("startDateFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fstartdate,'YYYY-MM-DD HH24:MI:SS') >= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("startDateTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fstartdate,'YYYY-MM-DD HH24:MI:SS') <= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("endDateFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fenddate,'YYYY-MM-DD HH24:MI:SS') >= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("endDateTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" to_char(a.Fenddate,'YYYY-MM-DD HH24:MI:SS') <= substring('");
                sqlBuff.append(filterItem.getCompareValue());
                sqlBuff.append("',0,19) and");
            }
            if ("productionOrderFrom".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.Fnumber >= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("productionOrderTo".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" a.Fnumber <= '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("isBackFlush".equals(filterItem.getPropertyName())) {
                switch ((Integer)filterItem.getCompareValue()) {
                    case 1: {
                        sqlBuff.append(" b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        sqlBuff.append(" and");
                        break;
                    }
                    case 0: {
                        sqlBuff.append(" b.FIsBackFlush = ");
                        sqlBuff.append(filterItem.getCompareValue());
                        sqlBuff.append(" and");
                        break;
                    }
                }
            }
            if ("materialId".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" b.FMaterialid = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("unitId".equals(filterItem.getPropertyName())) {
                sqlBuff.append(" b.FUnitID = '");
                sqlBuff.append((String)filterItem.getCompareValue());
                sqlBuff.append("' and");
            }
            if ("defaultWarehouseId".equals(filterItem.getPropertyName())) {
                String warehouseId = (String)filterItem.getCompareValue();
                if (warehouseId == null || warehouseId.equals("")) {
                    sqlBuff.append(" b.Fdefaultwarehouseid is null and");
                } else {
                    sqlBuff.append(" b.Fdefaultwarehouseid = '");
                    sqlBuff.append(warehouseId);
                    sqlBuff.append("' and");
                }
            }
            if ("moveOutStorageOrgUnitId".equals(filterItem.getPropertyName())) {
                String moveOutStorageOrgUnitId = (String)filterItem.getCompareValue();
                if (moveOutStorageOrgUnitId == null || moveOutStorageOrgUnitId.equals("")) {
                    sqlBuff.append(" b.FMoveOutStorageOrgUnitId is null and");
                } else {
                    sqlBuff.append(" b.FMoveOutStorageOrgUnitId = '");
                    sqlBuff.append(moveOutStorageOrgUnitId);
                    sqlBuff.append("' and");
                }
            }
            if ("moveOutWarehouseId".equals(filterItem.getPropertyName())) {
                String moveOutWarehouseId = (String)filterItem.getCompareValue();
                if (moveOutWarehouseId == null || moveOutWarehouseId.equals("")) {
                    sqlBuff.append(" b.FMoveOutWarehouseId is null and");
                } else {
                    sqlBuff.append(" b.FMoveOutWarehouseId = '");
                    sqlBuff.append(moveOutWarehouseId);
                    sqlBuff.append("' and");
                }
            }
            if ("lotNo".equals(filterItem.getPropertyName())) {
                String lotNo = (String)filterItem.getCompareValue();
                if (lotNo == null || lotNo.equals("")) {
                    sqlBuff.append(" b.FLotNo is null and");
                } else {
                    sqlBuff.append(" b.FLotNo = '");
                    sqlBuff.append(lotNo);
                    sqlBuff.append("' and");
                }
            }
            if (!"locationID".equals(filterItem.getPropertyName()) || (locationId = (String)filterItem.getCompareValue()) == null || "".equals(locationId)) continue;
            sqlBuff.append(" b.FLocationID = '");
            sqlBuff.append(locationId);
            sqlBuff.append("' and");
        }
        sqlBuff.append(" a.FbaseStatus in (");
        sqlBuff.append(4);
        sqlBuff.append(",");
        sqlBuff.append(5);
        sqlBuff.append(") and");
        sqlBuff.append(" b.FTranslateID is null and");
        sqlBuff.append(" b.FIsStock = 1 and");
        sqlBuff.append(" b.FQty > 0 and");
        sqlBuff.append(" b.FIssMode = 11010");
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] prdPks) throws BOSException, EASBizException {
        boolean result;
        String ids = null;
        ArrayList<String> idList = new ArrayList<String>();
        if (prdPks != null && prdPks.length > 0) {
            StringBuffer idBuff = new StringBuffer();
            for (int i = 0; i < prdPks.length; ++i) {
                idBuff.append("'");
                idBuff.append(prdPks[i].getKeyValue(null).toString());
                idBuff.append("'");
                idBuff.append(",");
                idList.add(prdPks[i].getKeyValue(null).toString());
            }
            ids = idBuff.replace(idBuff.length() - 1, idBuff.length(), "").toString();
        }
        if (result = this.checkStockGatherMoveAudit(ctx, ids)) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update ");
            updateSql.append(" T_MM_StockGatherMove ");
            updateSql.append(" set ");
            updateSql.append(" FBaseStatus=4");
            updateSql.append(",fauditorId='" + ctx.getCaller().toString() + "'");
            updateSql.append(",fauditTime = now()");
            updateSql.append(" where fid in (" + ids + ")");
            Connection conn = null;
            Statement batchStatement = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                batchStatement = conn.createStatement();
                batchStatement.addBatch(updateSql.toString());
                batchStatement.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(batchStatement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        }
    }

    private boolean checkStockGatherMoveAudit(Context ctx, String ids) throws BOSException, EASBizException, ProductionOrderException {
        boolean retVal = true;
        if (StringUtils.isEmpty((String)ids)) {
            throw new ProductionOrderException(ProductionOrderException.AUDITCHECKEXCEPTION, new Object[]{this.getResourceMsg2("StockGatherAuditEmpty")});
        }
        StringBuffer statBuff = new StringBuffer();
        StringBuffer errBuff = new StringBuffer();
        StringBuffer kql = new StringBuffer();
        kql.append(" select ");
        kql.append(" sgm.FNumber number");
        kql.append(",sgm.FBaseStatus baseStatus");
        kql.append(" from ");
        kql.append(" T_MM_StockGatherMove AS sgm ");
        kql.append(" where ");
        kql.append(" sgm.FID in (");
        kql.append(ids);
        kql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
        try {
            while (rowSet.next()) {
                if (rowSet.getInt("baseStatus") == 2) continue;
                statBuff.append(rowSet.getString("number")).append(",");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        if (statBuff.length() > 0) {
            errBuff.append(this.getResourceMsg2("StockGatherAuditStatus", new String[]{statBuff.replace(statBuff.length() - 1, statBuff.length(), "").toString()})).append("\n");
        }
        if (errBuff.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.AUDITCHECKEXCEPTION, new Object[]{errBuff.toString()});
        }
        return retVal;
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unAudit(ctx, new IObjectPK[]{pk});
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        boolean result;
        String ids = null;
        if (pks != null && pks.length > 0) {
            StringBuffer idBuff = new StringBuffer();
            for (int i = 0; i < pks.length; ++i) {
                idBuff.append("'");
                idBuff.append(pks[i].getKeyValue(null).toString());
                idBuff.append("'");
                idBuff.append(",");
            }
            ids = idBuff.replace(idBuff.length() - 1, idBuff.length(), "").toString();
        }
        if (result = this.checkStockGatherMoveUnAudit(ctx, ids)) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update ");
            updateSql.append(" T_MM_StockGatherMove ");
            updateSql.append(" set ");
            updateSql.append(" FBaseStatus=1");
            updateSql.append(",fauditorId=null");
            updateSql.append(",fauditTime=null");
            updateSql.append(" where fid in (" + ids + ")");
            StringBuffer backWriteDelSql = new StringBuffer();
            backWriteDelSql.append("update T_MM_ProductionOrderSEntry as q set FTranslateID=null,FTranslateEntrySeq=0");
            backWriteDelSql.append(" where q.fid in (");
            backWriteDelSql.append(" select distinct FStockEntryId");
            backWriteDelSql.append(" from T_MM_StockEntryToBillEntry where FBillId in (" + ids + ")");
            backWriteDelSql.append(")");
            Connection conn = null;
            Statement batchStatement = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                batchStatement = conn.createStatement();
                batchStatement.addBatch(updateSql.toString());
                batchStatement.addBatch(backWriteDelSql.toString());
                batchStatement.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(batchStatement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        }
    }

    private boolean checkStockGatherMoveUnAudit(Context ctx, String ids) throws BOSException, EASBizException, ProductionOrderException {
        boolean retVal = true;
        if (StringUtils.isEmpty((String)ids)) {
            throw new ProductionOrderException(ProductionOrderException.AUDITCHECKEXCEPTION, new Object[]{this.getResourceMsg2("stockGatherUnAuditEmpty")});
        }
        StringBuffer statBuff = new StringBuffer();
        StringBuffer downBuff = new StringBuffer();
        StringBuffer errBuff = new StringBuffer();
        StringBuffer kql = new StringBuffer();
        kql.append(" select ");
        kql.append(" sgm.fid fid");
        kql.append(",sgm.fNumber number");
        kql.append(",sgm.fBaseStatus baseStatus");
        kql.append(",sgm.fBillTypeID billType");
        kql.append(",sgm.fStorageOrgUnitID orgUnit");
        kql.append(" from ");
        kql.append(" T_MM_StockGatherMove as sgm ");
        kql.append(" where ");
        kql.append(" sgm.fid in (");
        kql.append(ids);
        kql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
        try {
            while (rowSet.next()) {
                String billType = rowSet.getString("billType");
                String orgUnit = rowSet.getString("orgUnit");
                if (!StringUtils.isEmpty((String)billType) && !StringUtils.isEmpty((String)orgUnit)) {
                    BillTypeInfo billTypeInfo = new BillTypeInfo();
                    billTypeInfo.setId(BOSUuid.read((String)billType));
                    StorageOrgUnitInfo orgUnitInfo = new StorageOrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)orgUnit));
                    StockGatherMoveInfo orderInfo = new StockGatherMoveInfo();
                    orderInfo.setBillType(billTypeInfo);
                    orderInfo.setStorageOrgUnit(orgUnitInfo);
                    this._checkUnAuditInParam(ctx, (IObjectValue)orderInfo);
                }
                if (rowSet.getInt("baseStatus") != 4) {
                    statBuff.append(rowSet.getString("number")).append(",");
                    continue;
                }
                if (!SCMServerUtils.hasDestBill((Context)ctx, (String)rowSet.getString("fid"))) continue;
                downBuff.append(rowSet.getString("number")).append(",");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        if (statBuff.length() > 0) {
            errBuff.append(this.getResourceMsg2("StockGatherUnAuditStatus", new String[]{statBuff.replace(statBuff.length() - 1, statBuff.length(), "").toString()})).append("\n");
        }
        if (downBuff.length() > 0) {
            errBuff.append(this.getResourceMsg2("StockGatherUnAudit_HasDestBill", new String[]{downBuff.replace(downBuff.length() - 1, downBuff.length(), "").toString()}));
        }
        if (errBuff.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.AUDITCHECKEXCEPTION, new Object[]{errBuff.toString()});
        }
        return retVal;
    }

    protected boolean _checkUnAuditInParam(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        StockGatherMoveInfo stockGatherMoveInfo = (StockGatherMoveInfo)model;
        if (stockGatherMoveInfo.getBillType() != null) {
            String billTypeId = stockGatherMoveInfo.getBillType().getId().toString();
            String orgUnitID = stockGatherMoveInfo.getStorageOrgUnit().getId().toString();
            boolean isCanUnAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId);
            if (strCanUnAudit != null && strCanUnAudit.trim().length() != 0 && strCanUnAudit.trim().toLowerCase().equals("1")) {
                isCanUnAudit = true;
            }
            if (!isCanUnAudit) {
                throw new SCMBillException(SCMBillException.CHECK_UNAUDIT_PARAM);
            }
        }
        return true;
    }

    @Override
    protected void _addStockTransfer(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StockTransferBillInfo stb = (StockTransferBillInfo)model;
        StorageOrgUnitInfo currentSou = stb.getReceiptStorageOrgUnit();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = codingRuleManager.getNumber((IObjectValue)new StockTransferBillInfo(), currentSou.getId().toString());
        stb.setNumber(number);
        IObjectPK id = StockTransferBillFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)stb);
        StringBuffer entryIds = new StringBuffer();
        StockTransferBillEntryCollection stockTransferBillEntryCollection = ((StockTransferBillInfo)model).getEntry();
        for (StockTransferBillEntryInfo stockTransferBillEntryInfo : stockTransferBillEntryCollection) {
            String entryId = ((BOSUuid)stockTransferBillEntryInfo.get("entryId")).toString();
            entryIds.append("'");
            entryIds.append(entryId);
            entryIds.append("'");
            entryIds.append(",");
        }
        entryIds = entryIds.replace(entryIds.length() - 1, entryIds.length(), "");
        StringBuffer backWriteSql = new StringBuffer();
        backWriteSql.append("update T_MM_StockGatherMoveEntry set FTransferBillNum='");
        backWriteSql.append(number);
        backWriteSql.append("' ");
        backWriteSql.append("where fid in (");
        backWriteSql.append(entryIds.toString());
        backWriteSql.append(")");
        DbUtil.execute((Context)ctx, (String)backWriteSql.toString());
        StringBuffer updateStatusSql = new StringBuffer();
        updateStatusSql.append("update T_MM_StockGatherMove set fbasestatus=");
        updateStatusSql.append(90);
        updateStatusSql.append(" where not exists(select fid from T_MM_StockGatherMoveEntry where FParentID='");
        updateStatusSql.append(stb.getSourceBillId().toString());
        updateStatusSql.append("' ");
        updateStatusSql.append("and FTransferBillNum is null) ");
        updateStatusSql.append("and fid ='");
        updateStatusSql.append(stb.getSourceBillId().toString());
        updateStatusSql.append("' ");
        DbUtil.execute((Context)ctx, (String)updateStatusSql.toString());
        StringBuffer botpSql = new StringBuffer();
        botpSql.append("insert into t_bot_relation(FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values(newbosid('59302EC6'),'55D94D5B','2239F30A','");
        botpSql.append(stb.getSourceBillId().toString());
        botpSql.append("','");
        botpSql.append(id.toString());
        botpSql.append("',now(),'");
        botpSql.append(ctx.getUserName() + "',1,null,0)");
        DbUtil.execute((Context)ctx, (String)botpSql.toString());
    }

    @Override
    protected void _addTransferOrder(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TransferOrderBillInfo to = (TransferOrderBillInfo)model;
        StorageOrgUnitInfo currentSou = to.getReceiptStorageOrgUnit();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = codingRuleManager.getNumber((IObjectValue)new TransferOrderBillInfo(), currentSou.getId().toString());
        to.setNumber(number);
        IObjectPK id = TransferOrderBillFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)to);
        StringBuffer entryIds = new StringBuffer();
        TransferOrderBillEntryCollection transferOrderBillEntryCollection = ((TransferOrderBillInfo)model).getEntry();
        for (TransferOrderBillEntryInfo transferOrderBillEntryInfo : transferOrderBillEntryCollection) {
            String entryId = ((BOSUuid)transferOrderBillEntryInfo.get("entryId")).toString();
            entryIds.append("'");
            entryIds.append(entryId);
            entryIds.append("'");
            entryIds.append(",");
        }
        entryIds = entryIds.replace(entryIds.length() - 1, entryIds.length(), "");
        StringBuffer backWriteSql = new StringBuffer();
        backWriteSql.append("update T_MM_StockGatherMoveEntry set FTransferBillNum='");
        backWriteSql.append(number);
        backWriteSql.append("' ");
        backWriteSql.append("where fid in (");
        backWriteSql.append(entryIds.toString());
        backWriteSql.append(")");
        DbUtil.execute((Context)ctx, (String)backWriteSql.toString());
        StringBuffer updateStatusSql = new StringBuffer();
        updateStatusSql.append("update T_MM_StockGatherMove set fbasestatus=");
        updateStatusSql.append(90);
        updateStatusSql.append(" where not exists(select fid from T_MM_StockGatherMoveEntry where FParentID='");
        updateStatusSql.append(to.getSourceBillId().toString());
        updateStatusSql.append("' ");
        updateStatusSql.append("and FTransferBillNum is null) ");
        updateStatusSql.append("and fid ='");
        updateStatusSql.append(to.getSourceBillId().toString());
        updateStatusSql.append("' ");
        DbUtil.execute((Context)ctx, (String)updateStatusSql.toString());
        StringBuffer botpSql = new StringBuffer();
        botpSql.append("insert into t_bot_relation(FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values(newbosid('59302EC6'),'55D94D5B','5C2A1F0C','");
        botpSql.append(to.getSourceBillId().toString());
        botpSql.append("','");
        botpSql.append(id.toString());
        botpSql.append("',now(),'");
        botpSql.append(ctx.getUserName() + "',1,null,0)");
        DbUtil.execute((Context)ctx, (String)botpSql.toString());
    }

    private boolean checkStockGatherMoveClose(Context ctx, String ids) throws BOSException, EASBizException, ProductionOrderException {
        boolean retVal = true;
        if (StringUtils.isEmpty((String)ids)) {
            throw new ProductionOrderException(ProductionOrderException.CLOSEEXCEPTION, new Object[]{this.getResourceMsg2("StockGatherCloseEmpty")});
        }
        StringBuffer statBuff = new StringBuffer();
        StringBuffer errBuff = new StringBuffer();
        StringBuffer kql = new StringBuffer();
        kql.append(" select ");
        kql.append(" sgm.FNumber number");
        kql.append(",sgm.FBaseStatus baseStatus");
        kql.append(" from ");
        kql.append(" T_MM_StockGatherMove AS sgm ");
        kql.append(" where ");
        kql.append(" sgm.FID in (");
        kql.append(ids);
        kql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)kql.toString());
        try {
            while (rowSet.next()) {
                if (rowSet.getInt("baseStatus") == 4) continue;
                statBuff.append(rowSet.getString("number")).append(",");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        if (statBuff.length() > 0) {
            errBuff.append(this.getResourceMsg2("StockGatherCloseStatus2", new String[]{statBuff.replace(statBuff.length() - 1, statBuff.length(), "").toString()})).append("\n");
        }
        if (errBuff.length() > 0) {
            throw new ProductionOrderException(ProductionOrderException.AUDITCHECKEXCEPTION, new Object[]{errBuff.toString()});
        }
        return retVal;
    }

    @Override
    protected void _forceClose(Context ctx, IObjectPK[] prdPks) throws BOSException, EASBizException {
        boolean result;
        String ids = null;
        ArrayList<String> idList = new ArrayList<String>();
        if (prdPks != null && prdPks.length > 0) {
            StringBuffer idBuff = new StringBuffer();
            for (int i = 0; i < prdPks.length; ++i) {
                idBuff.append("'");
                idBuff.append(prdPks[i].getKeyValue(null).toString());
                idBuff.append("'");
                idBuff.append(",");
                idList.add(prdPks[i].getKeyValue(null).toString());
            }
            ids = idBuff.replace(idBuff.length() - 1, idBuff.length(), "").toString();
        }
        if (result = this.checkStockGatherMoveClose(ctx, ids)) {
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" update ");
            updateSql.append(" T_MM_StockGatherMove ");
            updateSql.append(" set ");
            updateSql.append(" FBaseStatus=7");
            updateSql.append(" where fid in (" + ids + ")");
            StringBuffer backWriteDelSql = new StringBuffer();
            backWriteDelSql.append("update T_MM_ProductionOrderSEntry set FTranslateID=null,FTranslateEntrySeq=0");
            backWriteDelSql.append(" where fid in ");
            backWriteDelSql.append("(select distinct p.FStockEntryId from T_MM_StockEntryToBillEntry p inner join T_MM_StockGatherMoveEntry q on p.FBillEntryId=q.fid ");
            backWriteDelSql.append(" where q.fparentid in (" + ids + ")");
            backWriteDelSql.append(" and q.FTransferBillNum is null)");
            StringBuffer delRelationSql = new StringBuffer();
            delRelationSql.append("delete from T_MM_StockEntryToBillEntry where FBillEntryId in(select fid from T_MM_StockGatherMoveEntry");
            delRelationSql.append(" where fparentid in (" + ids + ")");
            delRelationSql.append(" and FTransferBillNum is null)");
            Connection conn = null;
            Statement batchStatement = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                batchStatement = conn.createStatement();
                batchStatement.addBatch(updateSql.toString());
                batchStatement.addBatch(backWriteDelSql.toString());
                batchStatement.addBatch(delRelationSql.toString());
                batchStatement.executeBatch();
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(batchStatement, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        }
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RES_PRD_ORDER, (String)key);
    }

    private String getResourceMsg2(String key) {
        return ResourceUtils.getMessage((String)RES_STOCKGATHER, (String)key);
    }

    private String getResourceMsg2(String key, String[] params) {
        return ResourceUtils.getMessage((String)RES_STOCKGATHER, (String)key, (String[])params);
    }

    @Override
    protected IRowSet _getLinkBuildEntryIds(Context ctx, IObjectPK pk, IObjectPK[] entryPks) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        String ids = null;
        ArrayList<String> idList = new ArrayList<String>();
        if (entryPks != null && entryPks.length > 0) {
            StringBuffer idBuff = new StringBuffer();
            for (int i = 0; i < entryPks.length; ++i) {
                idBuff.append("'");
                idBuff.append(entryPks[i].getKeyValue(null).toString());
                idBuff.append("'");
                idBuff.append(",");
                idList.add(entryPks[i].getKeyValue(null).toString());
            }
            ids = idBuff.replace(idBuff.length() - 1, idBuff.length(), "").toString();
        }
        StringBuffer getEntryId = new StringBuffer();
        getEntryId.append("select fid from T_MM_StockGatherMoveEntry where fparentid='");
        getEntryId.append(pk.toString());
        getEntryId.append("' and FTransferBillNum is not null");
        getEntryId.append(" and fid in (" + ids + ")");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)getEntryId.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SCMLockInvDataVO _getMaterialInventory(Context ctx, SCMLockInvDataVO dataVO, Date reqDate) throws BOSException, EASBizException {
        IInventory iInventory = InventoryFactory.getLocalInstance((Context)ctx);
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
        IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
        ILocation iLocation = LocationFactory.getLocalInstance((Context)ctx);
        IStoreType iStoreType = StoreTypeFactory.getLocalInstance((Context)ctx);
        IStoreState iStoreState = StoreStateFactory.getLocalInstance((Context)ctx);
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(dataVO.getViewInfo().getFilter());
        SelectorItemCollection invSic = new SelectorItemCollection();
        invSic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(invSic);
        InventoryCollection inventoryIdCol = iInventory.getInventoryCollection(viewInfo);
        StringBuffer strInvIDs = new StringBuffer();
        HashMap<String, java.sql.Date> expCach = new HashMap<String, java.sql.Date>();
        InventoryCollection aInventoryCollection = new InventoryCollection();
        if (inventoryIdCol.size() > 0) {
            int c = inventoryIdCol.size();
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    strInvIDs.append(",");
                }
                strInvIDs.append("'");
                strInvIDs.append(((InventoryInfo)inventoryIdCol.getObject(i)).getId().toString());
                strInvIDs.append("'");
            }
            Connection conn = null;
            PreparedStatement perStmt = null;
            ResultSet rs = null;
            StringBuffer sb = new StringBuffer();
            HashSet<String> invIdSet = new HashSet<String>();
            if (reqDate != null) {
                sb.append("Select A.FID, C.FEXP From T_IM_Inventory A ");
                sb.append("LEFT OUTER JOIN T_BD_MaterialInventory B on A.FMaterialID = B.FMaterialID AND A.FStorageOrgUnitID = B.FOrgUnit ");
                sb.append("LEFT OUTER JOIN T_IM_DateOfMinDurability C on A.FLot = C.FLot AND A.FStorageOrgUnitID = C.FStorageOrgUnitID AND A.FMaterialID= C.FMaterialID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanRangeParam D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanRangeWarehs E on E.FParentID = D.FID ");
                sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") AND B.FIsPeriodValid = 1 AND C.FEXP>=?");
                sb.append(" AND ( D.FID is null ");
                sb.append("   OR ( ");
                sb.append("((D.FIsNormal  =1 AND  A.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6') ");
                sb.append(" OR (D.FIsSupplierBorrow =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0120c0a812fd97D461A6') ");
                sb.append(" OR (D.FIsSupplierStorage =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0114c0a812fd97D461A6')) ");
                sb.append(" AND ");
                sb.append("((D.FIsAvailable  =1 AND  A.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsProvisionalFreeze =1 AND A.FStoreStatusID = '181875d5-1105-1000-e000-013dc0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsOutGoodsCheck =1 AND A.FStoreStatusID = '181875d5-0105-1000-e000-0134c0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsCheckStorageFreeze =1 AND A.FStoreStatusID = '181875d5-2105-1000-e000-013dc0a812fd62A73FA5')) ");
                sb.append(" AND ");
                sb.append("(D.FIsAllStorage = 1 ");
                sb.append(" OR (D.FIsAllStorage = 0 AND A.FWarehouseID = E.FWarhouseID)) ");
                sb.append("   )) ");
                sb.append(" UNION ALL ");
                sb.append("Select A.FID, null as FEXP From T_IM_Inventory A ");
                sb.append("LEFT OUTER JOIN T_BD_MaterialInventory B on A.FMaterialID = B.FMaterialID AND A.FStorageOrgUnitID = B.FOrgUnit ");
                sb.append("LEFT OUTER JOIN T_MM_PlanRangeParam D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
                sb.append("LEFT OUTER JOIN T_MM_PlanRangeWarehs E on E.FParentID = D.FID ");
                sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") AND B.FIsPeriodValid = 0 ");
                sb.append(" AND ( D.FID is null ");
                sb.append("   OR (");
                sb.append("((D.FIsNormal  =1 AND  A.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6') ");
                sb.append(" OR (D.FIsSupplierBorrow =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0120c0a812fd97D461A6') ");
                sb.append(" OR (D.FIsSupplierStorage =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0114c0a812fd97D461A6')) ");
                sb.append(" AND ");
                sb.append("((D.FIsAvailable  =1 AND  A.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsProvisionalFreeze =1 AND A.FStoreStatusID = '181875d5-1105-1000-e000-013dc0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsOutGoodsCheck =1 AND A.FStoreStatusID = '181875d5-0105-1000-e000-0134c0a812fd62A73FA5') ");
                sb.append(" OR (D.FIsCheckStorageFreeze =1 AND A.FStoreStatusID = '181875d5-2105-1000-e000-013dc0a812fd62A73FA5'))");
                sb.append(" AND ");
                sb.append("(D.FIsAllStorage = 1 ");
                sb.append(" OR (D.FIsAllStorage = 0 AND A.FWarehouseID = E.FWarhouseID))");
                sb.append("   )) ");
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    perStmt = conn.prepareStatement(sb.toString());
                    perStmt.setDate(1, new java.sql.Date(reqDate.getTime()));
                    rs = perStmt.executeQuery();
                    while (rs.next()) {
                        invIdSet.add(rs.getString("FID"));
                        expCach.put(rs.getString("FID"), rs.getDate("FEXP"));
                    }
                }
                catch (SQLException ex) {
                    throw new BOSException((Throwable)ex);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
                }
            }
            sb.append("Select A.FID, C.FEXP From T_IM_Inventory A ");
            sb.append("LEFT OUTER JOIN T_MM_PlanRangeParam D on A.FStorageOrgUnitID = D.FStorageOrgUnitID ");
            sb.append("LEFT OUTER JOIN T_MM_PlanRangeWarehs E on E.FParentID = D.FID ");
            sb.append("LEFT OUTER JOIN T_IM_DateOfMinDurability C on A.FLot = C.FLot AND A.FStorageOrgUnitID = C.FStorageOrgUnitID AND A.FMaterialID= C.FMaterialID ");
            sb.append("WHERE  A.FID in (" + strInvIDs.toString() + ") ");
            sb.append(" AND ( D.FID is null ");
            sb.append("   OR ( ");
            sb.append("((D.FIsNormal  =1 AND  A.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6') ");
            sb.append(" OR (D.FIsSupplierBorrow =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0120c0a812fd97D461A6') ");
            sb.append(" OR (D.FIsSupplierStorage =1 AND A.FStoreTypeID = '181875d5-0105-1000-e000-0114c0a812fd97D461A6')) ");
            sb.append(" AND ");
            sb.append("((D.FIsAvailable  =1 AND  A.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5') ");
            sb.append(" OR (D.FIsProvisionalFreeze =1 AND A.FStoreStatusID = '181875d5-1105-1000-e000-013dc0a812fd62A73FA5') ");
            sb.append(" OR (D.FIsOutGoodsCheck =1 AND A.FStoreStatusID = '181875d5-0105-1000-e000-0134c0a812fd62A73FA5') ");
            sb.append(" OR (D.FIsCheckStorageFreeze =1 AND A.FStoreStatusID = '181875d5-2105-1000-e000-013dc0a812fd62A73FA5')) ");
            sb.append(" AND ");
            sb.append("(D.FIsAllStorage = 1 ");
            sb.append(" OR (D.FIsAllStorage = 0 AND A.FWarehouseID = E.FWarhouseID)) ");
            sb.append("   )) ");
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                perStmt = conn.prepareStatement(sb.toString());
                rs = perStmt.executeQuery();
                while (rs.next()) {
                    invIdSet.add(rs.getString("FID"));
                    expCach.put(rs.getString("FID"), rs.getDate("FEXP"));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, perStmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)perStmt, (Connection)conn);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", invIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            aInventoryCollection = iInventory.getInventoryCollection(view);
        }
        HashMap<String, WarehouseInfo> wareHouseMap = new HashMap<String, WarehouseInfo>();
        HashMap<String, LocationInfo> locationMap = new HashMap<String, LocationInfo>();
        HashMap<String, StoreTypeInfo> storeTypeMap = new HashMap<String, StoreTypeInfo>();
        HashMap<String, StoreStateInfo> storeStateMap = new HashMap<String, StoreStateInfo>();
        HashMap<String, SupplierInfo> supplierMap = new HashMap<String, SupplierInfo>();
        HashMap<String, CustomerInfo> customerMap = new HashMap<String, CustomerInfo>();
        HashMap<String, MeasureUnitInfo> invUnitMap = new HashMap<String, MeasureUnitInfo>();
        HashMap<String, StorageOrgUnitInfo> storageMap = new HashMap<String, StorageOrgUnitInfo>();
        HashMap<String, MultiMeasureUnitInfo> mmuMap = new HashMap<String, MultiMeasureUnitInfo>();
        HashMap<String, InventoryInfo> inventoryMap = new HashMap<String, InventoryInfo>();
        String invID = null;
        ObjectUuidPK[] invIdList = new ObjectUuidPK[aInventoryCollection.size()];
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        int i = 0;
        int n = aInventoryCollection.size();
        while (true) {
            if (i >= n) {
                dataVO.setWareHouseMap(wareHouseMap);
                dataVO.setLocationMap(locationMap);
                dataVO.setStoreTypeMap(storeTypeMap);
                dataVO.setStorageMap(storageMap);
                dataVO.setStoreStateMap(storeStateMap);
                dataVO.setCustomerMap(customerMap);
                dataVO.setSupplierMap(supplierMap);
                dataVO.setInvUnitMap(invUnitMap);
                dataVO.setInvIdList((IObjectPK[])invIdList);
                dataVO.setInventoryMap(inventoryMap);
                dataVO.setMmuPrecisions(mmuMap);
                return dataVO;
            }
            InventoryInfo aInventoryInfo = (InventoryInfo)aInventoryCollection.getObject(i);
            invIdList[i] = new ObjectUuidPK(aInventoryInfo.getId());
            invID = aInventoryInfo.getId().toString();
            aInventoryInfo.setExp((Date)expCach.get(invID));
            inventoryMap.put(invID, aInventoryInfo);
            if (aInventoryInfo.getWarehouse() != null) {
                wareHouseMap.put(invID, iWarehouse.getWarehouseInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getWarehouse().getId().toString()), sic));
            }
            if (aInventoryInfo.getLocation() != null) {
                locationMap.put(invID, iLocation.getLocationInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getLocation().getId().toString()), sic));
            }
            if (aInventoryInfo.getStoretype() != null) {
                storeTypeMap.put(invID, iStoreType.getStoreTypeInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getStoretype().getId().toString()), sic));
            }
            if (aInventoryInfo.getStorestatus() != null) {
                storeStateMap.put(invID, iStoreState.getStoreStateInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getStorestatus().getId().toString()), sic));
            }
            if (aInventoryInfo.getSupplier() != null) {
                supplierMap.put(invID, iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getSupplier().getId().toString()), sic));
            }
            if (aInventoryInfo.getCustomer() != null) {
                customerMap.put(invID, iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getCustomer().getId().toString()), sic));
            }
            if (aInventoryInfo.getUnit() != null) {
                invUnitMap.put(invID, iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getUnit().getId()), sic));
            }
            if (aInventoryInfo.getStorageOrgUnit() != null) {
                storageMap.put(invID, iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(aInventoryInfo.getStorageOrgUnit().getId().toString()), sic));
            }
            if (aInventoryInfo.getMaterial() != null && aInventoryInfo.getUnit() != null) {
                mmuMap.put(aInventoryInfo.getMaterial().getId().toString() + aInventoryInfo.getUnit().getId().toString(), imultiUnit.getMultiUnit(aInventoryInfo.getMaterial().getId().toString(), aInventoryInfo.getUnit().getId().toString()));
            }
            ++i;
        }
    }

    @Override
    protected IRowSet _getSourceBillByCondition(Context ctx, FilterInfo filterInfo, String parentId) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select distinct a.fid as fid,a.FNumber as number,");
        sqlBuff.append(" e.FqtyPrecision as unitPrecision,");
        sqlBuff.append(" b.FQty as qty,");
        sqlBuff.append(" b.FSeq as seq,");
        sqlBuff.append(" b.FlineSeq as lineSeq,");
        sqlBuff.append(" to_char(b.FStartDate,'yyyy-MM-dd') as startDate,");
        sqlBuff.append(" to_char(b.FEndDate,'yyyy-MM-dd') as endDate");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID ");
        sqlBuff.append(" inner join T_BD_Material c on c.Fid = a.FMaterialid ");
        sqlBuff.append(" left join T_BD_MeasureUnit e on b.FUnitID = e.fid");
        sqlBuff.append(" Where ");
        this.getFilterSQLForSourceView(filterInfo, sqlBuff);
        sqlBuff.append(" and not exists(select * from T_MM_StockEntryToBillEntry where FStockId=a.fid and FStockEntryId=b.fid");
        if (parentId != null) {
            sqlBuff.append(" and FBillId != '" + parentId + "')");
        } else {
            sqlBuff.append(")");
        }
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }

    @Override
    protected IRowSet _getSourceBillByRelation(Context ctx, String parentId, String entryId) throws BOSException {
        IRowSet rowSet = null;
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select distinct a.fid as fid,a.FNumber as number,");
        sqlBuff.append(" e.FqtyPrecision as unitPrecision,");
        sqlBuff.append(" b.FQty as qty,");
        sqlBuff.append(" b.FSeq as seq,");
        sqlBuff.append(" b.FlineSeq as lineSeq,");
        sqlBuff.append(" to_char(b.FStartDate,'yyyy-MM-dd') as startDate,");
        sqlBuff.append(" to_char(b.FEndDate,'yyyy-MM-dd') as endDate");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID ");
        sqlBuff.append(" inner join ( ");
        sqlBuff.append("select distinct FStockId,FStockEntryId from T_MM_StockEntryToBillEntry");
        sqlBuff.append(" where FBillId='");
        sqlBuff.append(parentId);
        sqlBuff.append("' and FBillEntryId='");
        sqlBuff.append(entryId);
        sqlBuff.append("') p on a.fid = p.FStockId and b.fid = p.FStockEntryId");
        sqlBuff.append(" left join T_BD_MeasureUnit e on b.FUnitID = e.fid");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }

    @Override
    protected boolean _backWriteDeleteTransferBill(Context ctx, String billId, String sourceBillId, Collection sourceEntryIds, boolean isAllDelete) throws BOSException, EASBizException {
        boolean bRet = false;
        StringBuffer delctxRelationSql = new StringBuffer();
        Iterator it = sourceEntryIds.iterator();
        while (it.hasNext()) {
            String strBillEntryId = it.next().toString();
            delctxRelationSql.setLength(0);
            delctxRelationSql.append("update t_mm_mftorderstock set  FALRMOVEQTY = FALRMOVEQTY - \r\n ");
            delctxRelationSql.append("(select sum(fqty) from T_IM_StockTransferBillEntry where fsourcebillentryid = '" + strBillEntryId + "' and fparentid = '" + billId + "')\r\n ");
            delctxRelationSql.append("where fid = '" + strBillEntryId + "'");
            DbUtil.execute((Context)ctx, (String)delctxRelationSql.toString());
        }
        StringBuffer entryIds = new StringBuffer();
        Iterator it2 = sourceEntryIds.iterator();
        while (it2.hasNext()) {
            String strBillEntryId = it2.next().toString();
            entryIds.append("'");
            entryIds.append(strBillEntryId);
            entryIds.append("'");
            entryIds.append(",");
        }
        entryIds = entryIds.replace(entryIds.length() - 1, entryIds.length(), "");
        try {
            StringBuffer writeBackEntry = new StringBuffer();
            writeBackEntry.append("update T_MM_StockGatherMoveEntry set FTransferBillNum=null");
            writeBackEntry.append(" where fid in (");
            writeBackEntry.append(entryIds.toString());
            writeBackEntry.append(")");
            DbUtil.execute((Context)ctx, (String)writeBackEntry.toString());
            StringBuffer updateBill = new StringBuffer();
            updateBill.append("update T_MM_StockGatherMove set fbasestatus=");
            updateBill.append(4);
            updateBill.append(" where fid='");
            updateBill.append(sourceBillId);
            updateBill.append("' and fbasestatus=");
            updateBill.append(90);
            DbUtil.execute((Context)ctx, (String)updateBill.toString());
            StringBuffer writeBackStockEntry = new StringBuffer();
            writeBackStockEntry.append("update T_MM_ProductionOrderSEntry set FTranslateID=null,FTranslateEntrySeq=0");
            writeBackStockEntry.append(" where fid in ");
            writeBackStockEntry.append("(select distinct p.FStockEntryId from T_MM_StockEntryToBillEntry p inner join T_MM_StockGatherMoveEntry q on p.FBillEntryId=q.fid");
            writeBackStockEntry.append(" where q.fid in (" + entryIds + ")");
            writeBackStockEntry.append(")");
            writeBackStockEntry.append(" and exists(select fid from T_MM_StockGatherMove where fid ='" + sourceBillId);
            writeBackStockEntry.append("' and fbasestatus=");
            writeBackStockEntry.append(7);
            writeBackStockEntry.append(")");
            DbUtil.execute((Context)ctx, (String)writeBackStockEntry.toString());
            StringBuffer delPartRelationSql = new StringBuffer();
            delPartRelationSql.append("delete from T_MM_StockEntryToBillEntry ");
            delPartRelationSql.append("where FBillEntryId in  (" + entryIds + ")");
            delPartRelationSql.append(" and exists(select fid from T_MM_StockGatherMove where fid ='" + sourceBillId);
            delPartRelationSql.append("' and fbasestatus=");
            delPartRelationSql.append(7);
            delPartRelationSql.append(")");
            DbUtil.execute((Context)ctx, (String)delPartRelationSql.toString());
            bRet = true;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return bRet;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        StockGatherMoveInfo sgm = (StockGatherMoveInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)sgm.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (sgm.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)sgm.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (sgm.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)sgm.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (sgm.getStorageOrgUnit() != null) {
            filterItem = new FilterItemInfo("storageOrgUnit.id", (Object)sgm.getStorageOrgUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && sgm.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(sgm), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        return super._exists(ctx, filter);
    }

    @Override
    protected IRowSet _getClientMutexCatch(Context ctx, FilterInfo filterInfo, String billId) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select b.FParentID,");
        sqlBuff.append(" b.fid");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
        this.getFilterSQL(filterInfo, sqlBuff);
        sqlBuff.append(" and not exists(select * from T_MM_StockEntryToBillEntry where FStockId=a.fid and FStockEntryId=b.fid");
        if (billId != null) {
            sqlBuff.append(" and FBillId != '" + billId + "')");
        } else {
            sqlBuff.append(")");
        }
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }

    @Override
    protected IRowSet _getClientNumMutexCatch(Context ctx, FilterInfo filterInfo, String billId) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("select count(*) as num, b.fMaterialid,");
        sqlBuff.append(" b.Fdefaultwarehouseid,");
        sqlBuff.append(" b.funitid,");
        sqlBuff.append(" b.flotno,");
        sqlBuff.append(" b.FMoveOutWarehouseID,");
        sqlBuff.append(" b.FMoveOutStorageOrgUnitID");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID inner join T_BD_Material c on c.Fid = a.FMaterialid Where ");
        this.getFilterSQL(filterInfo, sqlBuff);
        sqlBuff.append(" and not exists(select * from T_MM_StockEntryToBillEntry where FStockId=a.fid and FStockEntryId=b.fid");
        if (billId != null) {
            sqlBuff.append(" and FBillId != '" + billId + "')");
        } else {
            sqlBuff.append(")");
        }
        sqlBuff.append(" group by b.fMaterialid,b.Fdefaultwarehouseid,b.funitid,b.flotno,b.FMoveOutWarehouseID,b.FMoveOutStorageOrgUnitID");
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }

    @Override
    protected int _totleAddNewAndBackWrite(Context ctx, HashMapObject collection, IObjectPK pk) throws BOSException, EASBizException {
        int successNum = 0;
        IStockGatherMove isgm = StockGatherMoveFactory.getLocalInstance(ctx);
        Enumeration collectionList = collection.keys();
        while (collectionList.hasMoreElements()) {
            String key = (String)collectionList.nextElement();
            HashMapObject detailMap = (HashMapObject)collection.get(key);
            String billType = (String)detailMap.get("billType");
            if (billType.equals("1")) {
                StockTransferBillInfo stockTransferBillInfo = (StockTransferBillInfo)detailMap.get("stockTransferBillInfo");
                isgm.addStockTransfer(stockTransferBillInfo);
                ++successNum;
                continue;
            }
            if (!billType.equals("0")) continue;
            TransferOrderBillInfo transferOrderBillInfo = (TransferOrderBillInfo)detailMap.get("transferOrderBillInfo");
            isgm.addTransferOrder(transferOrderBillInfo);
            ++successNum;
        }
        return successNum;
    }

    @Override
    protected Map _getProductStageQty(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select tps.FDefaultWarehouseID as warehouseID,tps.FMaterialid as materialid, tps.FLotNo as lotNo, ISNULL(sum(tps.FBaseQty - tps.FBaseSendOutTotalQty + tps.FBaseUntreadTotalQty),0) as baseTakeUpQty  from T_MM_ProductionOrderSEntry tps ");
        sqlBuff.append(" inner join T_MM_ProductionOrder tpo on tpo.Fid=tps.FParentId");
        sqlBuff.append(" inner join (");
        sqlBuff.append("select distinct b.FMaterialid as materialId,");
        sqlBuff.append("b.FDefaultWarehouseID as warehouseId ");
        sqlBuff.append(" from T_MM_ProductionOrder a inner join T_MM_ProductionOrderSEntry b");
        sqlBuff.append(" on a.fid = b.FParentID ");
        sqlBuff.append(" inner join T_BD_Material c");
        sqlBuff.append(" on c.Fid = a.FMaterialid Where ");
        this.getFilterSQL(filterInfo, sqlBuff);
        sqlBuff.append(") g on tps.FDefaultWarehouseID=g.warehouseId and tps.FMaterialid=g.materialId");
        sqlBuff.append(" where tpo.FBaseStatus in (");
        sqlBuff.append("4,");
        sqlBuff.append("5)");
        sqlBuff.append(" and tps.FTranslateID is not null");
        sqlBuff.append(" group by tps.FDefaultWarehouseID,tps.FMaterialid,tps.FLotNo");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            if (rowSet == null || rowSet.size() == 0) {
                return new HashMap();
            }
            HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
            while (rowSet.next()) {
                BigDecimal baseTakeUpQty = rowSet.getBigDecimal("baseTakeUpQty");
                String warehouseID = rowSet.getString("warehouseID");
                String materialid = rowSet.getString("materialid");
                String lotNo = rowSet.getString("lotNo");
                if (lotNo == null) {
                    lotNo = "";
                }
                result.put(materialid + warehouseID + lotNo, baseTakeUpQty);
            }
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _getInventoryForLog(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected void _getSourceForLog(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected Map _getInventoryQtys(Context ctx, FilterInfo filterInfo, String materialId, String wareHouseId, String lotNo, Date requireDate) throws BOSException, EASBizException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("select tii.FWarehouseID as fWarehouseID,tii.FMaterialID as fMaterialID, tii.FLot, ISNULL(sum(tii.FBaseQty), 0) as FBaseQty from T_IM_Inventory tii  left join T_DB_WAREHOUSE tdw on tii.FWarehouseID=tdw.FID");
        sqlBuff.append(" LEFT OUTER JOIN T_MM_PlanRangeParam D on tii.FStorageOrgUnitID = D.FStorageOrgUnitID ");
        sqlBuff.append(" LEFT OUTER JOIN T_MM_PlanRangeWarehs E on E.FParentID = D.FID ");
        if (requireDate != null) {
            sqlBuff.append(" LEFT OUTER JOIN T_BD_MaterialInventory tbmi on tii.FMaterialID = tbmi.FMaterialID AND tii.FStorageOrgUnitID = tbmi.FOrgUnit ");
            sqlBuff.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability tidd on tii.FLot = tidd.FLot AND tii.FStorageOrgUnitID = tidd.FStorageOrgUnitID AND tii.FMaterialID= tidd.FMaterialID ");
        }
        sqlBuff.append(" where ");
        sqlBuff.append(" ( D.FID is null ");
        sqlBuff.append("   OR ( ");
        sqlBuff.append("((D.FIsNormal  =1 AND  tii.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6') ");
        sqlBuff.append(" OR (D.FIsSupplierBorrow =1 AND tii.FStoreTypeID = '181875d5-0105-1000-e000-0120c0a812fd97D461A6') ");
        sqlBuff.append(" OR (D.FIsSupplierStorage =1 AND tii.FStoreTypeID = '181875d5-0105-1000-e000-0114c0a812fd97D461A6')) ");
        sqlBuff.append(" AND ");
        sqlBuff.append("((D.FIsAvailable  =1 AND  tii.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5') ");
        sqlBuff.append(" OR (D.FIsProvisionalFreeze =1 AND tii.FStoreStatusID = '181875d5-1105-1000-e000-013dc0a812fd62A73FA5') ");
        sqlBuff.append(" OR (D.FIsOutGoodsCheck =1 AND tii.FStoreStatusID = '181875d5-0105-1000-e000-0134c0a812fd62A73FA5') ");
        sqlBuff.append(" OR (D.FIsCheckStorageFreeze =1 AND tii.FStoreStatusID = '181875d5-2105-1000-e000-013dc0a812fd62A73FA5')) ");
        sqlBuff.append(" AND ");
        sqlBuff.append("(D.FIsAllStorage = 1 ");
        sqlBuff.append(" OR (D.FIsAllStorage = 0 AND tii.FWarehouseID = E.FWarhouseID)) ");
        sqlBuff.append("   )) ");
        sqlBuff.append(" and tii.FStorageOrgUnitID = '");
        sqlBuff.append((String)((FilterItemInfo)filterInfo.getFilterItems().getObject(0)).getCompareValue());
        sqlBuff.append("'");
        sqlBuff.append(" and tii.FStoreTypeID = '181875d5-0105-1000-e000-0111c0a812fd97D461A6'");
        sqlBuff.append(" and tii.FStoreStatusID = '181875d5-0105-1000-e000-012ec0a812fd62A73FA5'");
        sqlBuff.append(" and tdw.FTransState in ('1','2')");
        if (requireDate != null) {
            String expDate = sf.format(requireDate);
            sqlBuff.append(" and ((tbmi.FIsPeriodValid = 1 AND to_char(tidd.FEXP,'yyyy-MM-dd')>='" + expDate + "') or (tbmi.FIsPeriodValid != 1))");
        }
        sqlBuff.append(" and tii.FWarehouseID='" + wareHouseId + "'");
        sqlBuff.append(" and tii.FMaterialID ='" + materialId + "'");
        if (lotNo == null) {
            sqlBuff.append(" and tii.FLot = 'YNi0IQEOEADgBT3mfwAAAcznrtQ='");
        } else {
            sqlBuff.append(" and tii.FLot ='" + lotNo + "'");
        }
        sqlBuff.append(" group by tii.FWarehouseID,tii.FMaterialID, tii.FLot");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            String key = materialId + wareHouseId + (lotNo == null ? "" : lotNo);
            if (rowSet == null || rowSet.size() == 0) {
                HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
                result.put(key, new BigDecimal(0));
                return result;
            }
            HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
            while (rowSet.next()) {
                BigDecimal inventoryQty = rowSet.getBigDecimal("FBaseQty");
                result.put(key, inventoryQty);
            }
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getProductStageQtyS(Context ctx, String materialId, String wareHouseId, String lotNo) throws BOSException {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append(" select tps.FDefaultWarehouseID as warehouseID,tps.FMaterialid as materialid, tps.FLotNo as lotNo, ISNULL(sum(tps.FBaseQty - tps.FBaseSendOutTotalQty + tps.FBaseUntreadTotalQty), 0) as baseTakeUpQty  from T_MM_ProductionOrderSEntry tps ");
        sqlBuff.append(" inner join T_MM_ProductionOrder tpo on tpo.Fid=tps.FParentId");
        sqlBuff.append(" where tpo.FBaseStatus in (");
        sqlBuff.append("4,");
        sqlBuff.append("5)");
        sqlBuff.append(" and tps.FTranslateID is not null");
        sqlBuff.append(" and tps.FDefaultWarehouseID='" + wareHouseId + "'");
        sqlBuff.append(" and tps.FMaterialid='" + materialId + "'");
        if (lotNo == null) {
            sqlBuff.append(" and tps.FLotNo is null");
        } else {
            sqlBuff.append(" and tps.FLotNo ='" + lotNo + "'");
        }
        sqlBuff.append(" group by tps.FDefaultWarehouseID,tps.FMaterialid, tps.FLotNo");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            String key = materialId + wareHouseId + (lotNo == null ? "" : lotNo);
            if (rowSet == null || rowSet.size() == 0) {
                HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
                result.put(key, new BigDecimal(0));
                return result;
            }
            HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
            while (rowSet.next()) {
                BigDecimal baseTakeUpQty = rowSet.getBigDecimal("baseTakeUpQty");
                result.put(key, baseTakeUpQty);
            }
            return result;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

