/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.maf.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.IJZLogger;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.CodeJZTask;
import com.kingdee.eas.mm.maf.app.DbCleanServerUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;

public class PlannedOrderCleanTask
extends CodeJZTask {
    private IJZLogger logger = null;

    public boolean doTask(JZContext context) throws JZTaskException {
        try {
            String orgType = this.getOrgTypeRelationFId(4, 1, context);
            List storageOrgUnits = this.getFromOrgUnit(context.getOrgFId(), orgType, context);
            if (storageOrgUnits == null || storageOrgUnits.size() == 0) {
                return true;
            }
            String storageOrgUnitIds = DbCleanServerUtil.listToIds(storageOrgUnits);
            Timestamp endTime = context.getEndTime();
            KDConnection dbConn = context.getDbConn();
            this.deleteBOTRelation(dbConn, storageOrgUnitIds, endTime);
            this.deletePlanOrderChange(dbConn, storageOrgUnitIds, endTime);
            this.deletePlannedOrderEntry(dbConn, storageOrgUnitIds, endTime);
            this.deletePlannedOrderOutputsEntry(dbConn, storageOrgUnitIds, endTime);
            this.deletePlannedOrder(dbConn, storageOrgUnitIds, endTime);
        }
        catch (SQLException e) {
            throw new JZTaskException(e.toString(), 5);
        }
        return true;
    }

    private void deleteBOTRelation(KDConnection dbConn, String storageOrgUnitIds, Timestamp endTime) throws JZTaskException {
        StringBuffer deleteBOTRelationSql = new StringBuffer();
        deleteBOTRelationSql.append("delete from T_BOT_Relation ").append("where FSrcObjectID in ( ").append(" select FID from T_MM_PlannedOrder ").append("  where FStorageOrgUnitID in (").append(storageOrgUnitIds).append(") ").append("  and FEndDate < ? ").append("  and FBaseStatus = ? ").append(" ) ");
        PreparedStatement pst = null;
        try {
            pst = dbConn.prepareStatement(deleteBOTRelationSql.toString());
            pst.setTimestamp(1, endTime);
            pst.setInt(2, 7);
            pst.execute();
        }
        catch (SQLException e) {
            try {
                throw new JZTaskException(e.toString(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pst);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pst);
    }

    private void deletePlanOrderChange(KDConnection dbConn, String storageOrgUnitIds, Timestamp endTime) throws JZTaskException {
        StringBuffer deletePlanOrderChangeSql = new StringBuffer();
        deletePlanOrderChangeSql.append("delete from T_MM_PlanOrderChange ").append("where FPlanedOrderSrcID in ( ").append(" select FID from T_MM_PlannedOrder ").append("  where FStorageOrgUnitID in (").append(storageOrgUnitIds).append(") ").append("  and FEndDate < ? ").append("  and FBaseStatus = ? ").append(" ) ");
        PreparedStatement pst = null;
        try {
            pst = dbConn.prepareStatement(deletePlanOrderChangeSql.toString());
            pst.setTimestamp(1, endTime);
            pst.setInt(2, 7);
            pst.execute();
        }
        catch (SQLException e) {
            try {
                throw new JZTaskException(e.toString(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pst);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pst);
    }

    private void deletePlannedOrderEntry(KDConnection dbConn, String storageOrgUnitIds, Timestamp endTime) throws JZTaskException {
        StringBuffer deletePlannedOrderEntrySql = new StringBuffer();
        deletePlannedOrderEntrySql.append("delete from T_MM_PlannedOrderEntry ").append("where FParentId in ( ").append(" select FID from T_MM_PlannedOrder ").append("  where FStorageOrgUnitID in (").append(storageOrgUnitIds).append(") ").append("  and FEndDate < ? ").append("  and FBaseStatus = ? ").append(" ) ");
        PreparedStatement pst = null;
        try {
            pst = dbConn.prepareStatement(deletePlannedOrderEntrySql.toString());
            pst.setTimestamp(1, endTime);
            pst.setInt(2, 7);
            pst.execute();
        }
        catch (SQLException e) {
            try {
                throw new JZTaskException(e.toString(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pst);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pst);
    }

    private void deletePlannedOrderOutputsEntry(KDConnection dbConn, String storageOrgUnitIds, Timestamp endTime) throws JZTaskException {
        StringBuffer deletePlannedOrderOutputsEntrySql = new StringBuffer();
        deletePlannedOrderOutputsEntrySql.append("delete from T_MM_PlannedOrderOutputsEntry ").append("where FParentId in ( ").append(" select FID from T_MM_PlannedOrder ").append("  where FStorageOrgUnitID in (").append(storageOrgUnitIds).append(") ").append("  and FEndDate < ? ").append("  and FBaseStatus = ? ").append(" ) ");
        PreparedStatement pst = null;
        try {
            pst = dbConn.prepareStatement(deletePlannedOrderOutputsEntrySql.toString());
            pst.setTimestamp(1, endTime);
            pst.setInt(2, 7);
            pst.execute();
        }
        catch (SQLException e) {
            try {
                throw new JZTaskException(e.toString(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pst);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pst);
    }

    private void deletePlannedOrder(KDConnection dbConn, String storageOrgUnitIds, Timestamp endTime) throws JZTaskException {
        StringBuffer deletePlannedOrderSql = new StringBuffer();
        deletePlannedOrderSql.append("delete from T_MM_PlannedOrder ").append(" where FStorageOrgUnitID in (").append(storageOrgUnitIds).append(") ").append(" and FEndDate < ? ").append(" and FBaseStatus = ? ");
        PreparedStatement pst = null;
        try {
            pst = dbConn.prepareStatement(deletePlannedOrderSql.toString());
            pst.setTimestamp(1, endTime);
            pst.setInt(2, 7);
            pst.execute();
        }
        catch (SQLException e) {
            try {
                throw new JZTaskException(e.toString(), 5);
            }
            catch (Throwable throwable) {
                JZContext.closeStatment(pst);
                throw throwable;
            }
        }
        JZContext.closeStatment((Statement)pst);
    }
}

