/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.util.SOPUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class SOPPeriod
implements Serializable {
    private static final long serialVersionUID = -7588683658595420708L;
    private SOPEditModeEnum type = null;
    private Calendar beginDate = null;
    private Calendar endDate = null;
    private int number = 1;
    private int year = 2000;
    private int paramMonthStartDay = 0;

    public SOPEditModeEnum getType() {
        return this.type;
    }

    public void setType(SOPEditModeEnum type) {
        this.type = type;
    }

    public Calendar getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Calendar beginDate) {
        this.beginDate = beginDate;
        this.beginDate.set(10, 0);
        this.beginDate.set(12, 0);
        this.beginDate.set(13, 0);
        this.beginDate.set(14, 0);
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
        this.endDate.set(10, 0);
        this.endDate.set(12, 0);
        this.endDate.set(13, 0);
        this.endDate.set(14, 0);
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getParamMonthStartDay() {
        return this.paramMonthStartDay;
    }

    public void setParamMonthStartDay(int paramMonthStartDay) {
        this.paramMonthStartDay = paramMonthStartDay;
    }

    public String toString() {
        String s = null;
        s = 20 == this.type.getValue() ? ".M" : ".W";
        s = String.valueOf(this.year) + s + (this.number > 9 ? String.valueOf(this.number) : "0" + String.valueOf(this.number));
        return s;
    }

    public String toRangeString() {
        String s = String.valueOf(this.beginDate.get(2) + 1) + "." + String.valueOf(this.beginDate.get(5)) + "-" + String.valueOf(this.endDate.get(2) + 1) + "." + String.valueOf(this.endDate.get(5));
        return s;
    }

    public int toNumber() {
        return this.year * 100 + this.number;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof SOPPeriod) {
            SOPPeriod p1 = (SOPPeriod)obj;
            return p1.getNumber() == this.getNumber() && p1.getYear() == this.getYear();
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public SOPPeriod[] forwardPeriods(int m) {
        SOPPeriod[] periods = new SOPPeriod[m];
        periods[0] = this;
        SOPPeriod thePeriod = this;
        if (this.getType().getValue() == 20) {
            int number = 0;
            int theYear = 0;
            for (int i = 1; i < m; ++i) {
                SOPPeriod nextPeriod = new SOPPeriod();
                nextPeriod.setType(thePeriod.getType());
                number = thePeriod.getNumber() + 1;
                Calendar beginDate = SOPUtil.copyDate(thePeriod.getEndDate());
                beginDate.add(5, 1);
                Calendar endDate = SOPUtil.copyDate(beginDate);
                theYear = thePeriod.getYear();
                if (number > 12) {
                    number = 1;
                    theYear = thePeriod.getYear() + 1;
                }
                endDate.add(2, 1);
                endDate = SOPUtil.getMonthEndDay(endDate, this.paramMonthStartDay);
                nextPeriod.setYear(theYear);
                nextPeriod.setNumber(number);
                nextPeriod.setBeginDate(beginDate);
                nextPeriod.setEndDate(endDate);
                nextPeriod.setParamMonthStartDay(this.paramMonthStartDay);
                periods[i] = nextPeriod;
                thePeriod = nextPeriod;
            }
        } else {
            int iStartdayOfWeek = thePeriod.getBeginDate().get(7);
            for (int i = 1; i < m; ++i) {
                SOPPeriod nextPeriod = new SOPPeriod();
                nextPeriod.setType(thePeriod.getType());
                Calendar beginDate = SOPUtil.copyDate(thePeriod.getEndDate());
                beginDate.add(5, 1);
                Calendar endDate = SOPUtil.copyDate(beginDate);
                endDate.add(5, 6);
                beginDate.setFirstDayOfWeek(iStartdayOfWeek);
                int number = beginDate.get(3);
                int theYear = endDate.get(1);
                nextPeriod.setYear(theYear);
                nextPeriod.setNumber(number);
                nextPeriod.setBeginDate(beginDate);
                nextPeriod.setEndDate(endDate);
                periods[i] = nextPeriod;
                thePeriod = nextPeriod;
            }
        }
        return periods;
    }

    public SOPPeriod[] backwardPeriods(int m) {
        SOPPeriod[] periods = new SOPPeriod[m];
        periods[m - 1] = this;
        SOPPeriod thePeriod = this;
        if (this.getType().getValue() == 20) {
            int number = 0;
            int theYear = 0;
            for (int i = m - 2; i >= 0; --i) {
                SOPPeriod nextPeriod = new SOPPeriod();
                nextPeriod.setType(thePeriod.getType());
                number = thePeriod.getNumber() - 1;
                Calendar endDate = SOPUtil.copyDate(thePeriod.getBeginDate());
                endDate.add(5, -1);
                Calendar beginDate = SOPUtil.copyDate(endDate);
                if (number <= 0) {
                    number = 12;
                }
                if (this.paramMonthStartDay != 1) {
                    beginDate.add(2, -1);
                }
                beginDate = SOPUtil.getMonthStartDay(beginDate, this.paramMonthStartDay);
                theYear = thePeriod.getYear();
                if (number == 12) {
                    theYear = thePeriod.getYear() - 1;
                }
                nextPeriod.setYear(theYear);
                nextPeriod.setNumber(number);
                nextPeriod.setBeginDate(beginDate);
                nextPeriod.setEndDate(endDate);
                nextPeriod.setParamMonthStartDay(this.paramMonthStartDay);
                periods[i] = nextPeriod;
                thePeriod = nextPeriod;
            }
        } else {
            int iStartdayOfWeek = thePeriod.getBeginDate().get(7);
            for (int i = m - 2; i >= 0; --i) {
                SOPPeriod nextPeriod = new SOPPeriod();
                nextPeriod.setType(thePeriod.getType());
                Calendar endDate = SOPUtil.copyDate(thePeriod.getBeginDate());
                endDate.add(5, -1);
                int theYear = endDate.get(1);
                Calendar beginDate = SOPUtil.copyDate(endDate);
                beginDate.setFirstDayOfWeek(iStartdayOfWeek);
                beginDate.add(5, -6);
                int number = beginDate.get(3);
                nextPeriod.setYear(theYear);
                nextPeriod.setNumber(number);
                nextPeriod.setBeginDate(beginDate);
                nextPeriod.setEndDate(endDate);
                periods[i] = nextPeriod;
                thePeriod = nextPeriod;
            }
        }
        return periods;
    }

    public SOPPeriod[] periodRange(int m) throws BOSException, EASBizException {
        SOPPeriod[] periods = new SOPPeriod[m * 2 - 1];
        SOPPeriod[] left = this.backwardPeriods(m);
        SOPPeriod[] right = this.forwardPeriods(m);
        System.arraycopy(left, 0, periods, 0, left.length);
        System.arraycopy(right, 1, periods, m, right.length - 1);
        return periods;
    }

    public List forwardPeriods(Calendar toDate) {
        ArrayList<SOPPeriod> periodLst = new ArrayList<SOPPeriod>();
        periodLst.add(this);
        SOPPeriod thePeriod = this;
        if (this.getType().getValue() == 20) {
            int number = 0;
            int theYear = 0;
            while (true) {
                SOPPeriod nextPeriod = new SOPPeriod();
                nextPeriod.setType(thePeriod.getType());
                number = thePeriod.getNumber() + 1;
                Calendar beginDate = SOPUtil.copyDate(thePeriod.getEndDate());
                beginDate.add(5, 1);
                if (!beginDate.after(toDate)) {
                    Calendar endDate = SOPUtil.copyDate(beginDate);
                    theYear = thePeriod.getYear();
                    if (number > 12) {
                        number = 1;
                        theYear = thePeriod.getYear() + 1;
                    }
                    endDate.add(2, 1);
                    endDate = SOPUtil.getMonthEndDay(endDate, this.paramMonthStartDay);
                    nextPeriod.setYear(theYear);
                    nextPeriod.setNumber(number);
                    nextPeriod.setBeginDate(beginDate);
                    nextPeriod.setEndDate(endDate);
                    nextPeriod.setParamMonthStartDay(this.paramMonthStartDay);
                    periodLst.add(nextPeriod);
                    thePeriod = nextPeriod;
                    continue;
                }
                break;
            }
        } else {
            int iStartdayOfWeek = thePeriod.getBeginDate().get(7);
            while (true) {
                SOPPeriod nextPeriod = new SOPPeriod();
                nextPeriod.setType(thePeriod.getType());
                Calendar beginDate = SOPUtil.copyDate(thePeriod.getEndDate());
                beginDate.add(5, 1);
                if (beginDate.after(toDate)) break;
                Calendar endDate = SOPUtil.copyDate(beginDate);
                endDate.add(5, 6);
                beginDate.setFirstDayOfWeek(iStartdayOfWeek);
                int number = beginDate.get(3);
                int theYear = endDate.get(1);
                nextPeriod.setYear(theYear);
                nextPeriod.setNumber(number);
                nextPeriod.setBeginDate(beginDate);
                nextPeriod.setEndDate(endDate);
                periodLst.add(nextPeriod);
                thePeriod = nextPeriod;
            }
        }
        return periodLst;
    }

    public static SOPPeriod[] list2Array(List periodList) {
        SOPPeriod[] array = new SOPPeriod[periodList.size()];
        for (int i = 0; i < periodList.size(); ++i) {
            array[i] = (SOPPeriod)periodList.get(i);
        }
        return array;
    }

    private boolean compareDate(Date start, Date end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int startDay = Integer.parseInt(dateFormat.format(start).toString());
        int endDay = Integer.parseInt(dateFormat.format(end).toString());
        boolean result = false;
        if (endDay - startDay < 0) {
            result = true;
        }
        return result;
    }

    public List forwardPeriodsOther(Calendar toDate) {
        ArrayList<SOPPeriod> periodLst = new ArrayList<SOPPeriod>();
        periodLst.add(this);
        SOPPeriod thePeriod = this;
        if (this.getType().getValue() == 20) {
            int number = 0;
            int theYear = 0;
            while (true) {
                SOPPeriod nextPeriod = new SOPPeriod();
                nextPeriod.setType(thePeriod.getType());
                number = thePeriod.getNumber() + 1;
                Calendar beginDate = SOPUtil.copyDate(thePeriod.getEndDate());
                beginDate.add(5, 1);
                if (!this.compareDate(beginDate.getTime(), toDate.getTime())) {
                    Calendar endDate = SOPUtil.copyDate(beginDate);
                    theYear = thePeriod.getYear();
                    if (number > 12) {
                        number = 1;
                        theYear = thePeriod.getYear() + 1;
                    }
                    endDate.add(2, 1);
                    endDate = SOPUtil.getMonthEndDay(endDate, this.paramMonthStartDay);
                    nextPeriod.setYear(theYear);
                    nextPeriod.setNumber(number);
                    nextPeriod.setBeginDate(beginDate);
                    nextPeriod.setEndDate(endDate);
                    nextPeriod.setParamMonthStartDay(this.paramMonthStartDay);
                    periodLst.add(nextPeriod);
                    thePeriod = nextPeriod;
                    continue;
                }
                break;
            }
        } else {
            int iStartdayOfWeek = thePeriod.getBeginDate().get(7);
            while (true) {
                SOPPeriod nextPeriod = new SOPPeriod();
                nextPeriod.setType(thePeriod.getType());
                Calendar beginDate = SOPUtil.copyDate(thePeriod.getEndDate());
                beginDate.add(5, 1);
                if (this.compareDate(beginDate.getTime(), toDate.getTime())) break;
                Calendar endDate = SOPUtil.copyDate(beginDate);
                endDate.add(5, 6);
                beginDate.setFirstDayOfWeek(iStartdayOfWeek);
                int number = beginDate.get(3);
                int theYear = endDate.get(1);
                nextPeriod.setYear(theYear);
                nextPeriod.setNumber(number);
                nextPeriod.setBeginDate(beginDate);
                nextPeriod.setEndDate(endDate);
                periodLst.add(nextPeriod);
                thePeriod = nextPeriod;
            }
        }
        return periodLst;
    }
}

