/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.ClassTeamEntryCollection;
import com.kingdee.eas.mm.basedata.ClassTeamEntryInfo;
import com.kingdee.eas.mm.basedata.ClassTeamInfo;
import com.kingdee.eas.mm.basedata.EquipmentCalendarEntryCollection;
import com.kingdee.eas.mm.basedata.EquipmentCalendarEntryFactory;
import com.kingdee.eas.mm.basedata.EquipmentCalendarEntryInfo;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.PLSTypeEnum;
import com.kingdee.eas.mm.basedata.ProductLineDayYieldCollection;
import com.kingdee.eas.mm.basedata.ProductLineDayYieldFactory;
import com.kingdee.eas.mm.basedata.ProductLineDayYieldInfo;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.planning.LineCapabilityInfo;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalcCapabilityHandler {
    private Context ctx;
    private StorageOrgUnitInfo storageOrgUnitInfo;
    private String featureNum;
    private String voucherID;
    private Timestamp beginDate;
    private Timestamp endDate;
    private PLSModelInfo lineSchedulingModelInfo;
    private Map lineCaps;
    private Map productLineMap;

    public CalcCapabilityHandler(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, PLSModelInfo lineSchedulingModel, Timestamp beginDate, Timestamp endDate, String featureNum, Map productLineMap, String voucherID) {
        this.ctx = ctx;
        this.storageOrgUnitInfo = storageOrgUnitInfo;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.featureNum = featureNum;
        this.productLineMap = productLineMap;
        this.voucherID = voucherID;
        this.lineSchedulingModelInfo = lineSchedulingModel;
    }

    protected void calcLineCapability() throws BOSException, EASBizException {
        HashSet<String> idList_DayYieldCap = new HashSet<String>();
        HashSet<String> idList_ClassCap = new HashSet<String>();
        Set keySet = this.productLineMap.keySet();
        Iterator ite = keySet.iterator();
        while (ite.hasNext()) {
            ProductLineInfo productLine = (ProductLineInfo)this.productLineMap.get(ite.next());
            if (20 == productLine.getScheduleType().getValue()) {
                idList_DayYieldCap.add(productLine.getId().toString());
                continue;
            }
            String key = productLine.getId().toString() + "@" + productLine.getClassTeam().getId().toString();
            idList_ClassCap.add(key);
        }
        this.lineCaps = new HashMap();
        if (idList_DayYieldCap != null && idList_DayYieldCap.size() > 0) {
            this.getDayYieldCaps(idList_DayYieldCap);
        }
        if (idList_ClassCap != null && idList_ClassCap.size() > 0) {
            this.getClassCaps(idList_ClassCap);
        }
    }

    protected void getDayYieldCaps(Set idList) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("productLine.id", (Object)idList, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("workDate", (Object)this.beginDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("workDate", (Object)this.endDate, CompareType.LESS));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("productLine.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("productLine.unit.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("productLine.classTeam.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("productLine.classTeam.entrys.*"));
        viewInfo.setFilter(filterInfo);
        ProductLineDayYieldCollection dayYieldCol = ProductLineDayYieldFactory.getLocalInstance((Context)this.ctx).getProductLineDayYieldCollection(viewInfo);
        int n = dayYieldCol.size();
        for (int i = 0; i < n; ++i) {
            ProductLineDayYieldInfo productLineDayYield = dayYieldCol.get(i);
            String key = productLineDayYield.getProductLine().getId().toString();
            if (this.lineCaps.containsKey(key)) {
                ((List)this.lineCaps.get(key)).add(this.getLineCapInfoFromDayYield(productLineDayYield));
                continue;
            }
            ArrayList<LineCapabilityInfo> capList = new ArrayList<LineCapabilityInfo>();
            capList.add(this.getLineCapInfoFromDayYield(productLineDayYield));
            this.lineCaps.put(key, capList);
        }
    }

    protected void getClassCaps(Set idList) throws BOSException {
        int granularity = this.lineSchedulingModelInfo.getDayAbilityGranu().getValue();
        StringBuffer sb = new StringBuffer();
        for (String tempStr : idList) {
            String[] strs = tempStr.split("@");
            String productLineId = strs[0];
            String classTeamId = strs[1];
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("(productLine.id = '").append(productLineId).append("' AND classTeam.id = '").append(classTeamId).append("')");
        }
        String strBeginTime = PLSUtil.formatTimestamp(this.beginDate);
        String strEndTime = PLSUtil.formatTimestamp(this.endDate);
        StringBuffer oql = new StringBuffer();
        oql.append(" select *,parent.storageOrgUnit.*,parent.workDate,parent.workDay,productLine.*,classTeamEntry.* where ");
        oql.append(" parent.storageOrgUnit.id = '").append(this.storageOrgUnitInfo.getId().toString()).append("'");
        oql.append(" and startTime>=").append("{ts'").append(strBeginTime).append("'} ");
        oql.append(" and startTime<=").append("{ts'").append(strEndTime).append("'} ");
        oql.append(" and (").append(sb).append(")");
        EquipmentCalendarEntryCollection classCapCol = EquipmentCalendarEntryFactory.getLocalInstance((Context)this.ctx).getEquipmentCalendarEntryCollection(oql.toString());
        if (granularity == 20) {
            String key;
            HashMap map = new HashMap();
            int n = classCapCol.size();
            for (int i = 0; i < n; ++i) {
                List<EquipmentCalendarEntryInfo> list;
                EquipmentCalendarEntryInfo classCapInfo = classCapCol.get(i);
                key = classCapInfo.getProductLine().getId().toString() + "@" + PLSUtil.formatDate(classCapInfo.getParent().getWorkDate());
                if (map.containsKey(key)) {
                    list = (List)map.get(key);
                    list.add(classCapInfo);
                    map.put(key, list);
                    continue;
                }
                list = new ArrayList();
                list.add(classCapInfo);
                map.put(key, list);
            }
            Iterator ite = map.keySet().iterator();
            while (ite.hasNext()) {
                List list = (List)map.get(ite.next());
                LineCapabilityInfo lineCapabilityInfo = this.getLineCapInfoFromClassCap(list);
                key = lineCapabilityInfo.getProductLine().getId().toString();
                if (this.lineCaps.containsKey(key)) {
                    ((List)this.lineCaps.get(key)).add(lineCapabilityInfo);
                    continue;
                }
                ArrayList<LineCapabilityInfo> capList = new ArrayList<LineCapabilityInfo>();
                capList.add(lineCapabilityInfo);
                this.lineCaps.put(key, capList);
            }
        } else {
            int n = classCapCol.size();
            for (int i = 0; i < n; ++i) {
                EquipmentCalendarEntryInfo classCapInfo = classCapCol.get(i);
                String key = classCapInfo.getProductLine().getId().toString();
                if (this.lineCaps.containsKey(key)) {
                    ((List)this.lineCaps.get(key)).add(this.getLineCapInfoFromClassCap(classCapInfo));
                    continue;
                }
                ArrayList<LineCapabilityInfo> capList = new ArrayList<LineCapabilityInfo>();
                capList.add(this.getLineCapInfoFromClassCap(classCapInfo));
                this.lineCaps.put(key, capList);
            }
        }
    }

    protected LineCapabilityInfo getLineCapInfoFromClassCap(List classCapList) {
        LineCapabilityInfo lineCapabilityInfo = null;
        int n = classCapList.size();
        for (int i = 0; i < n; ++i) {
            EquipmentCalendarEntryInfo classCapInfo = (EquipmentCalendarEntryInfo)classCapList.get(i);
            if (lineCapabilityInfo == null) {
                lineCapabilityInfo = new LineCapabilityInfo();
                lineCapabilityInfo.setProductLine(classCapInfo.getProductLine());
                lineCapabilityInfo.setWorkDate(new Timestamp(classCapInfo.getParent().getWorkDate().getTime()));
                lineCapabilityInfo.setWorkDay(classCapInfo.getParent().getWorkDay());
                lineCapabilityInfo.setBeginTime(classCapInfo.getStartTime());
                lineCapabilityInfo.setEndTime(classCapInfo.getEndTime());
                lineCapabilityInfo.setHourCap(classCapInfo.getAbility());
                lineCapabilityInfo.setCapabilityType(PLSTypeEnum.SHIFTABILITY);
                lineCapabilityInfo.setIsLast(false);
                lineCapabilityInfo.setFeatureNum(this.featureNum);
                lineCapabilityInfo.setVoucherid(this.voucherID);
                continue;
            }
            if (classCapInfo.getStartTime().before(lineCapabilityInfo.getBeginTime())) {
                lineCapabilityInfo.setBeginTime(classCapInfo.getStartTime());
            }
            if (classCapInfo.getEndTime().after(lineCapabilityInfo.getEndTime())) {
                lineCapabilityInfo.setEndTime(classCapInfo.getEndTime());
            }
            lineCapabilityInfo.setHourCap(lineCapabilityInfo.getHourCap().add(classCapInfo.getAbility()));
        }
        return lineCapabilityInfo;
    }

    protected LineCapabilityInfo getLineCapInfoFromDayYield(ProductLineDayYieldInfo productLineDayYield) {
        LineCapabilityInfo lineCapabilityInfo = new LineCapabilityInfo();
        lineCapabilityInfo.setProductLine(productLineDayYield.getProductLine());
        Timestamp workDate = new Timestamp(productLineDayYield.getWorkDate().getTime());
        lineCapabilityInfo.setWorkDate(workDate);
        lineCapabilityInfo.setWorkDay(productLineDayYield.getWorkDay());
        Timestamp[] workTimes = this.getWorkTimes(workDate, productLineDayYield.getProductLine().getClassTeam());
        lineCapabilityInfo.setBeginTime(workTimes[0]);
        lineCapabilityInfo.setEndTime(workTimes[1]);
        lineCapabilityInfo.setYieldCap(productLineDayYield.getDayYield());
        lineCapabilityInfo.setCapabilityType(PLSTypeEnum.DAYABILITY);
        lineCapabilityInfo.setIsLast(false);
        lineCapabilityInfo.setFeatureNum(this.featureNum);
        lineCapabilityInfo.setVoucherid(this.voucherID);
        return lineCapabilityInfo;
    }

    protected Timestamp[] getWorkTimes(Timestamp workDate, ClassTeamInfo classTeam) {
        Timestamp[] workTimes = new Timestamp[2];
        ArrayList<Timestamp> list = new ArrayList<Timestamp>();
        boolean isSpan = false;
        ClassTeamEntryCollection entryCol = classTeam.getEntrys();
        if (entryCol != null && entryCol.size() > 0) {
            int m = entryCol.size();
            for (int j = 0; j < m; ++j) {
                Time endtime;
                ClassTeamEntryInfo entryInfo = entryCol.get(j);
                Time starttime = entryInfo.getStartTime();
                if (!starttime.before(endtime = entryInfo.getEndTime())) {
                    isSpan = true;
                }
                list.add(PLSUtil.constructDate(workDate, starttime, false));
                list.add(PLSUtil.constructDate(workDate, endtime, isSpan));
            }
            Arrays.sort(list.toArray());
            workTimes[0] = (Timestamp)list.get(0);
            workTimes[1] = (Timestamp)list.get(list.size() - 1);
        }
        return workTimes;
    }

    protected LineCapabilityInfo getLineCapInfoFromClassCap(EquipmentCalendarEntryInfo classCapInfo) {
        LineCapabilityInfo lineCapabilityInfo = new LineCapabilityInfo();
        lineCapabilityInfo.setProductLine(classCapInfo.getProductLine());
        lineCapabilityInfo.setClassTeam(classCapInfo.getClassTeamEntry());
        lineCapabilityInfo.setWorkDate(new Timestamp(classCapInfo.getParent().getWorkDate().getTime()));
        lineCapabilityInfo.setWorkDay(classCapInfo.getParent().getWorkDay());
        lineCapabilityInfo.setBeginTime(classCapInfo.getStartTime());
        lineCapabilityInfo.setEndTime(classCapInfo.getEndTime());
        lineCapabilityInfo.setHourCap(classCapInfo.getAbility());
        lineCapabilityInfo.setCapabilityType(PLSTypeEnum.SHIFTABILITY);
        lineCapabilityInfo.setIsLast(false);
        lineCapabilityInfo.setFeatureNum(this.featureNum);
        lineCapabilityInfo.setVoucherid(this.voucherID);
        return lineCapabilityInfo;
    }

    public Map getLineCaps() throws EASBizException, BOSException {
        if (this.lineCaps == null || this.lineCaps.size() == 0) {
            this.calcLineCapability();
        }
        return this.lineCaps;
    }
}

