/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.PLSTypeEnum;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryInfo;
import com.kingdee.eas.mm.basedata.TimeUnitEnum;
import com.kingdee.eas.mm.planning.LineCapabilityInfo;
import com.kingdee.eas.mm.planning.PLChooseEntryInfo;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.app.CalcCapabilityHandler;
import com.kingdee.eas.mm.planning.app.PLSRunner;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CapAnalyzeRunner
extends PLSRunner {
    protected ProductLinePAllotDefEntryCollection productLinePAllotDefEntryCollection;
    protected Map paramMap;
    protected Map capMap;
    protected Map planQtyMap;
    protected Map releasedQtyMap;
    protected Map productLineMap;
    protected Map lineUnitCaps;
    protected Timestamp beginDate;
    protected Timestamp endDate;
    protected String analyzeSrc;

    public CapAnalyzeRunner(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, Map map, String currVoucherID, PLSModelInfo pLSModelInfo) {
        this.ctx = ctx;
        this.storageOrgUnitInfo = storageOrgUnitInfo;
        this.paramMap = map;
        this.voucherID = currVoucherID;
        this.lineSchedulingModelInfo = pLSModelInfo;
    }

    @Override
    protected void prepareData() throws BOSException, EASBizException {
        super.prepareData();
        this.productLinePAllotDefEntryCollection = PLSUtil.getProductLinePAllotDefForServer(this.ctx, this.lineSchedulingModelInfo.getProductLineAllocate().getId().toString());
        this.analyzeSrc = (String)this.paramMap.get("analyzeSrc");
        this.beginDate = PLSUtil.setDateTime((Date)this.paramMap.get("beginDate"), 0);
        this.endDate = PLSUtil.setDateTime((Date)this.paramMap.get("endDate"), 1);
        List srcList = (List)this.paramMap.get("srcList");
        Set lineIdSet = this.getProductLines(srcList);
        this.productLineMap = PLSUtil.getProductLineMapForServer(this.ctx, lineIdSet);
        this.getLineUnitCaps(lineIdSet);
        this.capMap = new HashMap();
        CalcCapabilityHandler calcCapHandler = new CalcCapabilityHandler(this.ctx, this.storageOrgUnitInfo, this.lineSchedulingModelInfo, this.beginDate, this.endDate, this.featureNum, this.productLineMap, this.voucherID);
        Map lineCaps = calcCapHandler.getLineCaps();
        this.getCapMap(lineCaps);
        this.planQtyMap = new HashMap();
        this.releasedQtyMap = new HashMap();
        this.getPlanQty(lineIdSet);
        this.getReleasedQty(lineIdSet);
        this.getCurrQty(srcList);
    }

    @Override
    protected void running() throws BOSException, EASBizException {
        block6: {
            this.prepareData();
            this.returnList = new ArrayList();
            if (this.capMap == null || this.capMap.size() <= 0) break block6;
            Set keySet = this.capMap.keySet();
            if (this.analyzeSrc.equals("PLC")) {
                for (String productLineId : keySet) {
                    HashMap map = new HashMap();
                    map.put("productLine", this.productLineMap.get(productLineId));
                    map.put("cap", this.capMap.get(productLineId));
                    BigDecimal qty = PLSConstant.ZERO;
                    if (this.planQtyMap.containsKey(productLineId)) {
                        qty = qty.add((BigDecimal)this.planQtyMap.get(productLineId));
                    }
                    if (this.releasedQtyMap.containsKey(productLineId)) {
                        qty = qty.add((BigDecimal)this.releasedQtyMap.get(productLineId));
                    }
                    map.put("qty", qty);
                    this.returnList.add(map);
                }
            } else {
                for (String key : keySet) {
                    String[] keys = key.split("@");
                    String productLineId = keys[0];
                    String strDate = keys[1];
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("productLineId", productLineId);
                    map.put("strDate", strDate);
                    map.put("sumCap", (String)this.capMap.get(key));
                    map.put("planQty", (String)this.planQtyMap.get(key));
                    map.put("releasedQty", (String)this.releasedQtyMap.get(key));
                    this.returnList.add(map);
                }
            }
        }
    }

    private Set getProductLines(List srcList) {
        HashSet<String> productLineSet = new HashSet<String>();
        if (this.analyzeSrc.equals("PLC")) {
            int n = srcList.size();
            for (int i = 0; i < n; ++i) {
                PLChooseEntryInfo pLCInfo = (PLChooseEntryInfo)srcList.get(i);
                productLineSet.add(pLCInfo.getProductLine().getId().toString());
            }
        } else {
            int n = srcList.size();
            for (int i = 0; i < n; ++i) {
                PLSEntryInfo pLSInfo = (PLSEntryInfo)srcList.get(i);
                productLineSet.add(pLSInfo.getProductLine().getId().toString());
            }
        }
        return productLineSet;
    }

    protected void getCapMap(Map lineCaps) {
        Set keySet = lineCaps.keySet();
        if (this.analyzeSrc.equals("PLC")) {
            for (String productLineId : keySet) {
                if (!lineCaps.containsKey(productLineId)) continue;
                BigDecimal cap = this.capMap.containsKey(productLineId) ? (BigDecimal)this.capMap.get(productLineId) : PLSConstant.ZERO;
                ProductLineInfo productLine = (ProductLineInfo)this.productLineMap.get(productLineId);
                BigDecimal unitTimeCap = this.getUnitTimeCap(productLine);
                List capList = (List)lineCaps.get(productLineId);
                Iterator ite = capList.iterator();
                while (ite.hasNext()) {
                    LineCapabilityInfo lineCap = (LineCapabilityInfo)ite.next();
                    if (!lineCap.getWorkDay().equals((Object)WorkDateTypeEnum.WORKDAY)) {
                        ite.remove();
                        continue;
                    }
                    if (lineCap.getCapabilityType().equals((Object)PLSTypeEnum.DAYABILITY)) {
                        if (unitTimeCap.compareTo(PLSConstant.ZERO) <= 0) continue;
                        cap = cap.add(lineCap.getYieldCap().divide(unitTimeCap, 2, 5));
                        continue;
                    }
                    if (!lineCap.getCapabilityType().equals((Object)PLSTypeEnum.SHIFTABILITY)) continue;
                    cap = cap.add(lineCap.getHourCap());
                }
                this.capMap.put(productLineId, cap);
            }
        } else {
            for (String productLineId : keySet) {
                if (!lineCaps.containsKey(productLineId)) continue;
                ProductLineInfo productLine = (ProductLineInfo)this.productLineMap.get(productLineId);
                BigDecimal unitTimeCap = this.getUnitTimeCap(productLine);
                List capList = (List)lineCaps.get(productLineId);
                Iterator ite = capList.iterator();
                while (ite.hasNext()) {
                    LineCapabilityInfo lineCap = (LineCapabilityInfo)ite.next();
                    if (!lineCap.getWorkDay().equals((Object)WorkDateTypeEnum.WORKDAY)) {
                        ite.remove();
                        continue;
                    }
                    BigDecimal cap = PLSConstant.ZERO;
                    if (lineCap.getCapabilityType().equals((Object)PLSTypeEnum.DAYABILITY)) {
                        if (unitTimeCap.compareTo(PLSConstant.ZERO) > 0) {
                            cap = lineCap.getYieldCap().divide(unitTimeCap, 2, 5);
                        }
                    } else if (lineCap.getCapabilityType().equals((Object)PLSTypeEnum.SHIFTABILITY)) {
                        cap = lineCap.getHourCap();
                    }
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                    String strDate = sf.format(lineCap.getWorkDate());
                    String key = productLineId + "@" + strDate;
                    if (this.capMap.containsKey(key)) {
                        BigDecimal tempQty = (BigDecimal)this.capMap.get(key);
                        tempQty = tempQty.add(cap);
                        this.capMap.put(key, tempQty);
                        continue;
                    }
                    this.capMap.put(key, cap);
                }
            }
        }
    }

    private void getPlanQty(Set lineIdSet) throws BOSException, EASBizException {
        String strIDs = StringUtils.arrayToString((Object[])lineIdSet.toArray(), (String)"','");
        StringBuffer sqlBuffer = new StringBuffer();
        if (this.analyzeSrc.equals("PLC")) {
            sqlBuffer.append("select entrys.fmaterialid,entrys.fproductlineid,sum(entrys.fqty) as fplanQty ");
            sqlBuffer.append("from t_mm_plsentry entrys inner join t_mm_productionlinescheduling head on head.fid = entrys.fparent ");
            sqlBuffer.append("where head.fstorageorgunitid = ? ");
            sqlBuffer.append("and entrys.fissubplan = 0 and (entrys.fbasestatus = 2 or entrys.fbasestatus = 4) ");
            sqlBuffer.append("and entrys.fproductlineid in ('" + strIDs + "') ");
            sqlBuffer.append("and entrys.fbeginDate >= ? ");
            sqlBuffer.append("and entrys.fbeginDate <= ? ");
            sqlBuffer.append("and head.fid <> ? ");
            sqlBuffer.append("group by entrys.fmaterialid,entrys.fproductlineid");
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{this.storageOrgUnitInfo.getId().toString(), this.beginDate, this.endDate, this.voucherID});
            try {
                while (rowSet.next()) {
                    String materialID = rowSet.getString("fmaterialid");
                    String productLineID = rowSet.getString("fproductlineid");
                    BigDecimal planQty = rowSet.getBigDecimal("fplanQty");
                    if ((planQty = this.changeHourCap(materialID, productLineID, planQty)) == null) continue;
                    if (this.planQtyMap.containsKey(productLineID)) {
                        BigDecimal tempQty = (BigDecimal)this.planQtyMap.get(productLineID);
                        tempQty = tempQty.add(planQty);
                        this.planQtyMap.put(productLineID, tempQty);
                        continue;
                    }
                    this.planQtyMap.put(productLineID, planQty);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sqlBuffer.append("select entrys.fmaterialid,entrys.fproductlineid,TO_CHAR(entrys.fbeginDate, 'YYYY-MM-DD') as fbeginDate,sum(entrys.fqty) as fplanQty ");
        sqlBuffer.append("from t_mm_plsentry entrys inner join t_mm_productionlinescheduling head on head.fid = entrys.fparent ");
        sqlBuffer.append("where head.fstorageorgunitid = ? ");
        sqlBuffer.append("and entrys.fissubplan = 0 and (entrys.fbasestatus = 2 or entrys.fbasestatus = 4) ");
        sqlBuffer.append("and entrys.fproductlineid in ('" + strIDs + "') ");
        sqlBuffer.append("and entrys.fbeginDate >= ? ");
        sqlBuffer.append("and entrys.fbeginDate <= ? ");
        sqlBuffer.append("and head.fid <> ? ");
        sqlBuffer.append("group by entrys.fmaterialid,entrys.fproductlineid,TO_CHAR(entrys.fbeginDate, 'YYYY-MM-DD')");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{this.storageOrgUnitInfo.getId().toString(), this.beginDate, this.endDate, this.voucherID});
        try {
            while (rowSet.next()) {
                String materialID = rowSet.getString("fmaterialid");
                String productLineID = rowSet.getString("fproductlineid");
                String strDate = rowSet.getString("fbeginDate");
                BigDecimal planQty = rowSet.getBigDecimal("fplanQty");
                if ((planQty = this.changeHourCap(materialID, productLineID, planQty)) == null) continue;
                String key = productLineID + "@" + strDate;
                if (this.planQtyMap.containsKey(key)) {
                    BigDecimal tempQty = (BigDecimal)this.planQtyMap.get(key);
                    tempQty = tempQty.add(planQty);
                    this.planQtyMap.put(key, tempQty);
                    continue;
                }
                this.planQtyMap.put(key, planQty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void getReleasedQty(Set lineIdSet) throws BOSException, EASBizException {
        String strIDs = StringUtils.arrayToString((Object[])lineIdSet.toArray(), (String)"','");
        StringBuffer sqlBuffer = new StringBuffer();
        if (this.analyzeSrc.equals("PLC")) {
            sqlBuffer.append("select head.fmaterialid,head.fproductlineid,sum(head.fqty) as freleasedqty ");
            sqlBuffer.append("from t_mm_productionorder head ");
            sqlBuffer.append("where head.fstorageorgunitid = ? and head.fproductlineid in ('" + strIDs + "') ");
            sqlBuffer.append("and ((head.fsourcebilltypeid = 'OC9YcwEhEADgAAApfwAAAUY+1VI=' and head.fbasestatus = 2) or head.fbasestatus = 4 or head.fbasestatus = 5) ");
            sqlBuffer.append("and head.fstartDate >= ? ");
            sqlBuffer.append("and head.fstartDate <= ? ");
            sqlBuffer.append("and head.FSourceBillID <> ? ");
            sqlBuffer.append("group by head.fmaterialid,head.fproductlineid");
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{this.storageOrgUnitInfo.getId().toString(), this.beginDate, this.endDate, this.voucherID});
            try {
                while (rowSet.next()) {
                    String materialID = rowSet.getString("fmaterialid");
                    String productLineID = rowSet.getString("fproductlineid");
                    BigDecimal releasedQty = rowSet.getBigDecimal("freleasedqty");
                    if ((releasedQty = this.changeHourCap(materialID, productLineID, releasedQty)) == null) continue;
                    if (this.releasedQtyMap.containsKey(productLineID)) {
                        BigDecimal tempQty = (BigDecimal)this.releasedQtyMap.get(productLineID);
                        tempQty = tempQty.add(releasedQty);
                        this.releasedQtyMap.put(productLineID, tempQty);
                        continue;
                    }
                    this.releasedQtyMap.put(productLineID, releasedQty);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sqlBuffer.append("select head.fmaterialid,head.fproductlineid,TO_CHAR(head.fstartDate, 'YYYY-MM-DD') as fbeginDate,sum(head.fqty) as freleasedqty ");
        sqlBuffer.append("from t_mm_productionorder head ");
        sqlBuffer.append("where head.fstorageorgunitid = ? and head.fproductlineid in ('" + strIDs + "') ");
        sqlBuffer.append("and ((head.fsourcebilltypeid = 'OC9YcwEhEADgAAApfwAAAUY+1VI=' and head.fbasestatus = 2) or head.fbasestatus = 4 or head.fbasestatus = 5) ");
        sqlBuffer.append("and head.fstartDate >= ? ");
        sqlBuffer.append("and head.fstartDate <= ? ");
        sqlBuffer.append("group by head.fmaterialid,head.fproductlineid,TO_CHAR(head.fstartDate, 'YYYY-MM-DD')");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{this.storageOrgUnitInfo.getId().toString(), this.beginDate, this.endDate});
        try {
            while (rowSet.next()) {
                String materialID = rowSet.getString("fmaterialid");
                String productLineID = rowSet.getString("fproductlineid");
                String strDate = rowSet.getString("fbeginDate");
                BigDecimal releasedQty = rowSet.getBigDecimal("freleasedqty");
                if ((releasedQty = this.changeHourCap(materialID, productLineID, releasedQty)) == null) continue;
                String key = productLineID + "@" + strDate;
                if (this.releasedQtyMap.containsKey(key)) {
                    BigDecimal tempQty = (BigDecimal)this.releasedQtyMap.get(key);
                    tempQty = tempQty.add(releasedQty);
                    this.releasedQtyMap.put(key, tempQty);
                    continue;
                }
                this.releasedQtyMap.put(key, releasedQty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void getCurrQty(List srcList) throws BOSException, EASBizException {
        block6: {
            if (srcList == null || srcList.size() <= 0) break block6;
            if (this.analyzeSrc.equals("PLC")) {
                int n = srcList.size();
                for (int i = 0; i < n; ++i) {
                    PLChooseEntryInfo pLCInfo = (PLChooseEntryInfo)srcList.get(i);
                    String productLineID = pLCInfo.getProductLine().getId().toString();
                    String materialID = pLCInfo.getMaterial().getId().toString();
                    BigDecimal qty = pLCInfo.getQty();
                    qty = this.changeHourCap(materialID, productLineID, qty);
                    if (this.planQtyMap.containsKey(productLineID)) {
                        BigDecimal tempQty = (BigDecimal)this.planQtyMap.get(productLineID);
                        tempQty = tempQty.add(qty);
                        this.planQtyMap.put(productLineID, tempQty);
                        continue;
                    }
                    this.planQtyMap.put(productLineID, qty);
                }
            } else {
                int n = srcList.size();
                for (int i = 0; i < n; ++i) {
                    PLSEntryInfo pLSInfo = (PLSEntryInfo)srcList.get(i);
                    if (pLSInfo.isIsSubPlan() || !pLSInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.SUBMITED) && !pLSInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED) || pLSInfo.getBeginDate().compareTo(this.beginDate) < 0 && pLSInfo.getBeginDate().compareTo(this.endDate) > 0) continue;
                    String productLineID = pLSInfo.getProductLine().getId().toString();
                    String materialID = pLSInfo.getMaterial().getId().toString();
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                    String strDate = sf.format(pLSInfo.getBeginDate());
                    BigDecimal qty = pLSInfo.getQty();
                    qty = this.changeHourCap(materialID, productLineID, qty);
                    String key = productLineID + "@" + strDate;
                    if (this.planQtyMap.containsKey(key)) {
                        BigDecimal tempQty = (BigDecimal)this.planQtyMap.get(key);
                        tempQty = tempQty.add(qty);
                        this.planQtyMap.put(key, tempQty);
                        continue;
                    }
                    this.planQtyMap.put(key, qty);
                }
            }
        }
    }

    private BigDecimal changeHourCap(String materialID, String productLineID, BigDecimal qty) {
        String key = materialID + "@" + productLineID;
        BigDecimal lineUnitCap = (BigDecimal)this.lineUnitCaps.get(key);
        if (lineUnitCap != null) {
            qty = qty.divide(lineUnitCap, 2, 5);
            return qty;
        }
        return null;
    }

    protected void getLineUnitCaps(Set lineSet) {
        this.lineUnitCaps = new HashMap();
        for (int i = 0; i < this.productLinePAllotDefEntryCollection.size(); ++i) {
            ProductLinePAllotDefEntryInfo allotDefEntry = this.productLinePAllotDefEntryCollection.get(i);
            String materialID = allotDefEntry.getMaterial().getId().toString();
            ProductLinePAllotDefEntryRuleEntryCollection allotDefRuleEntryCol = allotDefEntry.getRuleEntrys();
            for (int j = 0; j < allotDefRuleEntryCol.size(); ++j) {
                ProductLinePAllotDefEntryRuleEntryInfo allotDefRuleEntry = allotDefRuleEntryCol.get(j);
                String productLineID = allotDefRuleEntry.getProductLine().getId().toString();
                if (!lineSet.contains(productLineID)) continue;
                double unitTimeQty = allotDefRuleEntry.getProductBatch().doubleValue() / allotDefRuleEntry.getBatchTime().doubleValue();
                if (allotDefRuleEntry.getBatchTimeUnit().equals((Object)TimeUnitEnum.MINUTE)) {
                    unitTimeQty *= 60.0;
                }
                String key = materialID + "@" + productLineID;
                this.lineUnitCaps.put(key, new BigDecimal(unitTimeQty));
            }
        }
    }

    protected BigDecimal getUnitTimeCap(ProductLineInfo productLine) {
        BigDecimal productBatch = productLine.getProductBatch();
        BigDecimal batchTime = productLine.getBatchTime();
        TimeUnitEnum batchTimeUnit = productLine.getBatchTimeUnit();
        int precision = productLine.getUnit().getQtyPrecision();
        double unitTimeCap = 0.0;
        unitTimeCap = batchTime.doubleValue() == 0.0 ? 1.0 : productBatch.doubleValue() / batchTime.doubleValue();
        if (batchTimeUnit.equals((Object)TimeUnitEnum.MINUTE)) {
            unitTimeCap *= 60.0;
        }
        return new BigDecimal(unitTimeCap).setScale(precision, 5);
    }
}

