/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.DapUserPermException;
import com.kingdee.eas.mm.planning.DayAbilityPlanUserPermEntryCollection;
import com.kingdee.eas.mm.planning.DayAbilityPlanUserPermEntryFactory;
import com.kingdee.eas.mm.planning.DayAbilityPlanUserPermEntryInfo;
import com.kingdee.eas.mm.planning.DayAbilityPlanUserPermInfo;
import com.kingdee.eas.mm.planning.IDayAbilityPlanUserPermEntry;
import com.kingdee.eas.mm.planning.app.AbstractDayAbilityPlanUserPermControllerBean;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DayAbilityPlanUserPermControllerBean
extends AbstractDayAbilityPlanUserPermControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.DayAbilityPlanUserPermControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkValidDataForSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("storageOrg.id"));
        sic.add(new SelectorItemInfo("storageOrg.number"));
        sic.add(new SelectorItemInfo("storageOrg.name"));
        sic.add(new SelectorItemInfo("user.id"));
        sic.add(new SelectorItemInfo("user.number"));
        sic.add(new SelectorItemInfo("user.name"));
        DayAbilityPlanUserPermInfo info = this.getDayAbilityPlanUserPermInfo(ctx, pk, sic);
        String retValue = " ";
        if (null != info.getStorageOrg()) {
            retValue = retValue + info.getStorageOrg().getNumber() + " ";
        }
        if (null != info.getUser()) {
            retValue = retValue + info.getUser().getNumber() + " ";
        }
        return retValue;
    }

    private void checkValidDataForSubmit(Context ctx, IObjectValue model) throws EASBizException {
        DayAbilityPlanUserPermInfo userPermInfo = (DayAbilityPlanUserPermInfo)model;
        StringBuffer msg = new StringBuffer();
        if (userPermInfo.getStorageOrg() == null) {
            msg.append(this.getResource(ctx, "MSG_STORAGEORG_NULL") + "\n");
        }
        if (userPermInfo.getUser() == null) {
            msg.append(this.getResource(ctx, "MSG_USER_NULL") + "\n");
        }
        if (userPermInfo.getEntries() == null || userPermInfo.getEntries().size() == 0) {
            msg.append(this.getResource(ctx, "MSG_ENTRY_NULL") + "\n");
        } else {
            Iterator iter = userPermInfo.getEntries().iterator();
            int rowIndex = 1;
            HashMap workshopMap = new HashMap();
            while (iter.hasNext()) {
                List<String> list;
                DayAbilityPlanUserPermEntryInfo userPermEntryInfo = (DayAbilityPlanUserPermEntryInfo)iter.next();
                if (userPermEntryInfo.getWorkshop() == null) {
                    msg.append(this.getResource(ctx, "MSG_WORKSHOP_NULL", new String[]{String.valueOf(rowIndex)}) + "\n");
                } else if (workshopMap.containsKey(userPermEntryInfo.getWorkshop().getId())) {
                    list = (List)workshopMap.get(userPermEntryInfo.getWorkshop().getId());
                    list.add(String.valueOf(rowIndex));
                } else {
                    list = new ArrayList<String>();
                    list.add(String.valueOf(rowIndex));
                    workshopMap.put(userPermEntryInfo.getWorkshop().getId(), list);
                }
                ++rowIndex;
            }
            for (Map.Entry entry : workshopMap.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                StringBuffer dupCols = new StringBuffer();
                List list = (List)entry.getValue();
                int m = list.size();
                for (int i = 0; i < m; ++i) {
                    if (i == 0) {
                        dupCols.append(list.get(i));
                        continue;
                    }
                    dupCols.append(", " + list.get(i));
                }
                msg.append(this.getResource(ctx, "MSG_WORKSHOP_DUP", new String[]{dupCols.toString()}) + "\n");
            }
        }
        if (msg.length() > 0) {
            throw new DapUserPermException(DapUserPermException.BLANK, new String[]{msg.toString()});
        }
    }

    private String getResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.mm.planning.DapUserPermResource", (String)key, (Locale)ctx.getLocale());
    }

    private String getResource(Context ctx, String key, String[] replacements) {
        String message = ResourceBase.getString((String)"com.kingdee.eas.mm.planning.DapUserPermResource", (String)key, (Locale)ctx.getLocale());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < replacements.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append("\\{").append(i).append("\\}").toString(), replacements[i]);
        }
        return message;
    }

    @Override
    protected Map _getAuthorizedWorkshop(Context ctx, String storageOrgId, String userPermType) throws BOSException {
        HashMap map = new HashMap();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("workshop.number"));
        viewInfo.setSelector(sic);
        FilterInfo filter = null;
        DayAbilityPlanUserPermEntryCollection userPermCol = null;
        DayAbilityPlanUserPermEntryInfo userPermEntryInfo = null;
        IDayAbilityPlanUserPermEntry idape = DayAbilityPlanUserPermEntryFactory.getLocalInstance(ctx);
        if (userPermType == null || userPermType.trim().length() == 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.storageOrg.id", (Object)storageOrgId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.user.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            userPermCol = idape.getDayAbilityPlanUserPermEntryCollection(viewInfo);
            HashSet<String> viewSet = new HashSet<String>();
            HashSet<String> modifySet = new HashSet<String>();
            Iterator it = userPermCol.iterator();
            while (it.hasNext()) {
                userPermEntryInfo = (DayAbilityPlanUserPermEntryInfo)it.next();
                if (userPermEntryInfo.isIsViewAble()) {
                    viewSet.add(userPermEntryInfo.getWorkshop().getNumber().toString());
                }
                if (!userPermEntryInfo.isIsModifyAble()) continue;
                modifySet.add(userPermEntryInfo.getWorkshop().getNumber().toString());
            }
            map.put("VIEW", viewSet);
            map.put("MODIFY", modifySet);
        } else if (userPermType.equals("VIEW")) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.storageOrg.id", (Object)storageOrgId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.user.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isViewAble", (Object)Boolean.TRUE, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            userPermCol = idape.getDayAbilityPlanUserPermEntryCollection(viewInfo);
            HashSet<String> viewSet = new HashSet<String>();
            Iterator it = userPermCol.iterator();
            while (it.hasNext()) {
                userPermEntryInfo = (DayAbilityPlanUserPermEntryInfo)it.next();
                viewSet.add(userPermEntryInfo.getWorkshop().getNumber().toString());
            }
            map.put("VIEW", viewSet);
        } else if (userPermType.equals("MODIFY")) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.storageOrg.id", (Object)storageOrgId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.user.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isModifyAble", (Object)Boolean.TRUE, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            userPermCol = idape.getDayAbilityPlanUserPermEntryCollection(viewInfo);
            HashSet<String> modifySet = new HashSet<String>();
            Iterator it = userPermCol.iterator();
            while (it.hasNext()) {
                userPermEntryInfo = (DayAbilityPlanUserPermEntryInfo)it.next();
                modifySet.add(userPermEntryInfo.getWorkshop().getNumber().toString());
            }
            map.put("MODIFY", modifySet);
        }
        return map;
    }
}

