/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.PLSExectionMSGInfo;
import com.kingdee.eas.mm.planning.PlanOrderEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.SrcTypeEnum;
import com.kingdee.eas.mm.planning.app.PLSRunner;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GenPlanTasksRunner
extends PLSRunner {
    protected Map paramMap;
    protected Map materialMap = new HashMap();
    protected Map unitMap = new HashMap();
    protected Map saleOrderMap = new HashMap();
    protected Map trackNumMap = new HashMap();
    protected final int MAXROW = 5000;

    public GenPlanTasksRunner(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, Map map, String currVoucherID, PLSModelInfo pLSModelInfo) {
        this.ctx = ctx;
        this.storageOrgUnitInfo = storageOrgUnitInfo;
        this.paramMap = map;
        this.voucherID = currVoucherID;
        this.lineSchedulingModelInfo = pLSModelInfo;
    }

    @Override
    public void prepareData() throws BOSException, EASBizException {
        super.prepareData();
    }

    @Override
    public void running() throws BOSException, EASBizException {
        this.prepareData();
        this.returnList = new ArrayList();
        int requireSrc = this.lineSchedulingModelInfo.getRequireSrc().getValue();
        if (10 == requireSrc) {
            this.genPlanTaskFromPlannedOrder();
        } else if (20 == requireSrc) {
            this.genPlanTaskFromRequirementPlan();
        }
        Collections.sort(this.returnList, PLSUtil.getPOComparator());
    }

    protected void genPlanTaskFromPlannedOrder() throws BOSException, EASBizException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuffer sqlBuffer = new StringBuffer();
        MaterialInfo materialNumFrom = (MaterialInfo)this.paramMap.get("materialNumFrom");
        MaterialInfo materialNumTo = (MaterialInfo)this.paramMap.get("materialNumTo");
        PlannedOrderInfo plannedOrderNumFrom = (PlannedOrderInfo)this.paramMap.get("plannedOrderNumFrom");
        PlannedOrderInfo plannedOrderNumTo = (PlannedOrderInfo)this.paramMap.get("plannedOrderNumTo");
        Timestamp beginDateFrom = (Timestamp)this.paramMap.get("beginDateFrom");
        Timestamp beginDateTo = (Timestamp)this.paramMap.get("beginDateTo");
        Timestamp endDateFrom = (Timestamp)this.paramMap.get("endDateFrom");
        Timestamp endDateTo = (Timestamp)this.paramMap.get("endDateTo");
        sqlBuffer.append("select top ").append(5000);
        sqlBuffer.append("t1.fid,t1.fnumber,t1.fstartdate,t1.fenddate,t1.fmaterialid,t1.fproductunitid,ISNULL(t1.fqty, 0) as fqty,ISNULL(t1.fscheduleqty, 0) as fscheduleqty,t1.FTRACKID,t1.FRelatingOrderID ");
        sqlBuffer.append("from t_mm_PlannedOrder t1 ");
        sqlBuffer.append("inner join t_bd_material t2 on t1.fmaterialid = t2.fid ");
        sqlBuffer.append("inner join t_bd_materialplan t5 on (t1.fmaterialid = t5.fmaterialid and t1.fstorageorgunitid = t5.forgunit) ");
        sqlBuffer.append("where t1.fbasestatus = 4 and t1.FOrderType = 10 and t5.fisproductlineplan=1 and t5.fplanningmode=2  and t2.FStatus = 1 and t5.FStatus = 1 ");
        sqlBuffer.append("and ISNULL(t1.fqty, 0) > ISNULL(t1.fscheduleqty, 0) ");
        if (this.storageOrgUnitInfo != null) {
            sqlBuffer.append("and t1.fstorageorgunitid = ? ");
            paramList.add(this.storageOrgUnitInfo.getId().toString());
        }
        if (plannedOrderNumFrom != null) {
            sqlBuffer.append("and t1.fnumber >= ? ");
            paramList.add(plannedOrderNumFrom.getNumber());
        }
        if (plannedOrderNumTo != null) {
            sqlBuffer.append("and t1.fnumber <= ? ");
            paramList.add(plannedOrderNumTo.getNumber());
        }
        if (materialNumFrom != null) {
            sqlBuffer.append("and t2.fnumber >= ? ");
            paramList.add(materialNumFrom.getNumber());
        }
        if (materialNumTo != null) {
            sqlBuffer.append("and t2.fnumber <= ? ");
            paramList.add(materialNumTo.getNumber());
        }
        if (beginDateFrom != null) {
            sqlBuffer.append("and t1.fstartdate >= ? ");
            paramList.add(beginDateFrom);
        }
        if (beginDateTo != null) {
            sqlBuffer.append("and t1.fstartdate <= ? ");
            paramList.add(beginDateTo);
        }
        if (endDateFrom != null) {
            sqlBuffer.append("and t1.fenddate >= ? ");
            paramList.add(endDateFrom);
        }
        if (endDateTo != null) {
            sqlBuffer.append("and t1.fenddate <= ? ");
            paramList.add(endDateTo);
        }
        sqlBuffer.append("order by t1.fstartdate ");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])paramList.toArray());
        if (rows.size() == 5000) {
            String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"OVERMAXCOUNT_DESC");
            int exceNum = 101;
            String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"OVERMAXCOUNT_DETAIL", (String[])new String[]{String.valueOf(5000), String.valueOf(5000)});
            PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
            this.exceptions.add(exceInfo);
        }
        try {
            while (rows.next()) {
                String materialId = rows.getString("fmaterialid");
                this.materialMap.put(materialId, null);
                String unitId = rows.getString("fproductunitid");
                this.unitMap.put(unitId, null);
                String trackNumId = rows.getString("FTRACKID");
                this.trackNumMap.put(trackNumId, null);
                String saleOrderId = rows.getString("FRelatingOrderID");
                if (saleOrderId == null) continue;
                this.saleOrderMap.put(saleOrderId, null);
            }
            this.materialMap = PLSUtil.getMaterialMapForServer(this.ctx, this.materialMap.keySet());
            this.unitMap = PLSUtil.getUnitMapForServer(this.ctx, this.unitMap.keySet());
            this.trackNumMap = PLSUtil.getTrackNumMapForServer(this.ctx, this.trackNumMap.keySet());
            this.saleOrderMap = PLSUtil.getSaleOrderMapForServer(this.ctx, this.saleOrderMap.keySet());
            rows.beforeFirst();
            while (rows.next()) {
                PlanOrderEntryInfo planOrderEntryInfo = this.getPlanOrderEntryFromPlannedOrder(rows);
                this.returnList.add(planOrderEntryInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void genPlanTaskFromRequirementPlan() throws BOSException, EASBizException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuffer sqlBuffer = new StringBuffer();
        MaterialInfo materialNumFrom = (MaterialInfo)this.paramMap.get("materialNumFrom");
        MaterialInfo materialNumTo = (MaterialInfo)this.paramMap.get("materialNumTo");
        Timestamp reqDateFrom = (Timestamp)this.paramMap.get("reqDateFrom");
        Timestamp reqDateTo = (Timestamp)this.paramMap.get("reqDateTo");
        sqlBuffer.append("select t1.fid,t1.fnumber,t1.FRequireDate,t1.fmaterialid,t1.funitid,t1.fbaseunitid,ISNULL(t1.fqty, 0) as fqty,ISNULL(t1.FScheduledQty, 0) as fscheduleqty, ");
        sqlBuffer.append("t1.FTraceNo,t1.FReqSource,t1.FSourceBillID,t5.FProduceLeadTime,t5.FForwardProcessTime,t5.FBackwardProcessTime,t1.FTRACKNumberID ");
        sqlBuffer.append("from t_mm_requirementplan t1 ");
        sqlBuffer.append("inner join t_bd_material t2 on t1.fmaterialid = t2.fid ");
        sqlBuffer.append("inner join t_bd_materialplan t5 on (t1.fmaterialid = t5.fmaterialid and t1.fstorageorgunitid = t5.forgunit) ");
        sqlBuffer.append("where t1.fstatus = 10 and t5.fisproductlineplan=1 and t5.fplanningmode=2 and t5.fmaterialattr =10030  and t2.FStatus = 1 and t5.FStatus = 1 ");
        sqlBuffer.append("and ISNULL(t1.fqty, 0) > ISNULL(t1.fscheduledQty, 0) ");
        if (this.storageOrgUnitInfo != null) {
            sqlBuffer.append("and t1.fstorageorgunitid = ? ");
            paramList.add(this.storageOrgUnitInfo.getId().toString());
        }
        if (materialNumFrom != null) {
            sqlBuffer.append("and t2.fnumber >= ? ");
            paramList.add(materialNumFrom.getNumber());
        }
        if (materialNumTo != null) {
            sqlBuffer.append("and t2.fnumber <= ? ");
            paramList.add(materialNumTo.getNumber());
        }
        if (reqDateFrom != null) {
            sqlBuffer.append("and t1.FRequireDate >= ? ");
            paramList.add(reqDateFrom);
        }
        if (reqDateTo != null) {
            sqlBuffer.append("and t1.FRequireDate <= ? ");
            paramList.add(reqDateTo);
        }
        sqlBuffer.append("order by t1.FRequireDate ");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])paramList.toArray());
        if (rows.size() == 5000) {
            String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"OVERMAXCOUNT_DESC");
            int exceNum = 101;
            String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"OVERMAXCOUNT_DETAIL", (String[])new String[]{String.valueOf(5000), String.valueOf(5000)});
            PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
            this.exceptions.add(exceInfo);
        }
        try {
            while (rows.next()) {
                String materialId = rows.getString("fmaterialid");
                this.materialMap.put(materialId, null);
                String unitId = rows.getString("funitid");
                this.unitMap.put(unitId, null);
                int reqSource = rows.getInt("FReqSource");
                if (20 == reqSource) {
                    String saleOrderID = rows.getString("FSourceBillID");
                    this.saleOrderMap.put(saleOrderID, null);
                }
                String trackNumId = rows.getString("FTRACKnumberID");
                this.trackNumMap.put(trackNumId, null);
            }
            this.materialMap = PLSUtil.getMaterialMapForServer(this.ctx, this.materialMap.keySet());
            this.unitMap = PLSUtil.getUnitMapForServer(this.ctx, this.unitMap.keySet());
            this.trackNumMap = PLSUtil.getTrackNumMapForServer(this.ctx, this.trackNumMap.keySet());
            this.saleOrderMap = PLSUtil.getSaleOrderMapForServer(this.ctx, this.saleOrderMap.keySet());
            rows.beforeFirst();
            while (rows.next()) {
                PlanOrderEntryInfo planOrderEntryInfo = this.getPlanOrderEntryFromRequirementPlan(this.ctx, rows);
                this.returnList.add(planOrderEntryInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected PlanOrderEntryInfo getPlanOrderEntryFromPlannedOrder(IRowSet rowSet) throws BOSException, EASBizException {
        PlanOrderEntryInfo planOrderEntryInfo = new PlanOrderEntryInfo();
        try {
            planOrderEntryInfo.setId(BOSUuid.create((String)"370DA4C2"));
            planOrderEntryInfo.setBeginDate(rowSet.getTimestamp("fstartDate"));
            planOrderEntryInfo.setEndDate(rowSet.getTimestamp("fenddate"));
            planOrderEntryInfo.setUnit((MeasureUnitInfo)this.unitMap.get(rowSet.getString("fproductunitid")));
            planOrderEntryInfo.setMaterial((MaterialInfo)this.materialMap.get(rowSet.getString("fmaterialid")));
            planOrderEntryInfo.setQty(rowSet.getBigDecimal("fqty"));
            planOrderEntryInfo.setSchedulingQty(rowSet.getBigDecimal("fscheduleqty"));
            planOrderEntryInfo.setNoSchedulingQty(planOrderEntryInfo.getQty().subtract(planOrderEntryInfo.getSchedulingQty()));
            planOrderEntryInfo.setSrcType(SrcTypeEnum.PLANORDER);
            planOrderEntryInfo.setSourceBillId(rowSet.getString("fid"));
            planOrderEntryInfo.setSourceBillNumber(rowSet.getString("fnumber"));
            planOrderEntryInfo.setTrackNumber((TrackNumberInfo)this.trackNumMap.get(rowSet.getString("FTRACKID")));
            if (rowSet.getString("FRelatingOrderID") != null) {
                planOrderEntryInfo.setSaleOrder((SaleOrderInfo)this.saleOrderMap.get(rowSet.getString("FRelatingOrderID")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return planOrderEntryInfo;
    }

    protected PlanOrderEntryInfo getPlanOrderEntryFromRequirementPlan(Context ctx, IRowSet rowSet) throws BOSException, EASBizException {
        PlanOrderEntryInfo planOrderEntryInfo = new PlanOrderEntryInfo();
        try {
            planOrderEntryInfo.setId(BOSUuid.create((String)"370DA4C2"));
            Timestamp requireDate = rowSet.getTimestamp("FRequireDate");
            int produceLeadTime = rowSet.getInt("FProduceLeadTime");
            int forwardProcessTime = rowSet.getInt("FForwardProcessTime");
            int backwardProcessTime = rowSet.getInt("FBackwardProcessTime");
            Timestamp startDate = new Timestamp(requireDate.getTime() - (long)(produceLeadTime + forwardProcessTime + backwardProcessTime) * 86400000L);
            planOrderEntryInfo.setBeginDate(startDate);
            planOrderEntryInfo.setEndDate(requireDate);
            planOrderEntryInfo.setUnit((MeasureUnitInfo)this.unitMap.get(rowSet.getString("funitid")));
            planOrderEntryInfo.setMaterial((MaterialInfo)this.materialMap.get(rowSet.getString("fmaterialid")));
            planOrderEntryInfo.setQty(rowSet.getBigDecimal("fqty"));
            planOrderEntryInfo.setSchedulingQty(rowSet.getBigDecimal("fscheduleqty"));
            planOrderEntryInfo.setNoSchedulingQty(planOrderEntryInfo.getQty().subtract(planOrderEntryInfo.getSchedulingQty()));
            planOrderEntryInfo.setSrcType(SrcTypeEnum.REQPLAN);
            planOrderEntryInfo.setSourceBillId(rowSet.getString("fid"));
            planOrderEntryInfo.setSourceBillNumber(rowSet.getString("fnumber"));
            planOrderEntryInfo.setTraceNo(rowSet.getString("FTraceNo"));
            planOrderEntryInfo.setTrackNumber((TrackNumberInfo)this.trackNumMap.get(rowSet.getString("FTRACKnumberID")));
            int reqSource = rowSet.getInt("FReqSource");
            if (20 == reqSource) {
                planOrderEntryInfo.setSaleOrder((SaleOrderInfo)this.saleOrderMap.get(rowSet.getString("FSourceBillID")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return planOrderEntryInfo;
    }
}

