/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.BPResult;
import com.kingdee.bos.framework.bp.DynamicBackground;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMFacadeFactory;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.IBOMFacade;
import com.kingdee.eas.mm.basedata.ILowLevelCode;
import com.kingdee.eas.mm.basedata.IOrderBomCompleteCheckFacade;
import com.kingdee.eas.mm.basedata.IPlanVersionSet;
import com.kingdee.eas.mm.basedata.LowLevelCodeFactory;
import com.kingdee.eas.mm.basedata.MaterialRangeEnum;
import com.kingdee.eas.mm.basedata.OrderBomCompleteCheckFacadeFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.MRPRunMaterialEntryInfo;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.app.AbstractMRPCalcFacadeControllerBean;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunStop;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunner;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunnerFactory;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MRPCalcFacadeControllerBean
extends AbstractMRPCalcFacadeControllerBean {
    private static final long serialVersionUID = -8020806782221820287L;
    private static final String FORWARD_PLANADJUST_TYPE = "FORWARD_PLANADJUST_TYPE";
    private static final String SUBPROPSEQ = "SUBPROPSEQ";
    private static final String SUB_ALT_PLAN_ORDER = "SubAltPlanOrder";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.MRPCalcFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _runMRP(Context ctx, IObjectValue params) throws BOSException, EASBizException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"begin run mrp...");
        }
        try {
            MRPRunner mrpRunner = MRPRunnerFactory.getMRPRunner(ctx, ((MRPRunLogInfo)params).getRunName().getValue());
            mrpRunner.run((MRPRunLogInfo)params);
        }
        finally {
            String storageOrgUnitID = ((MRPRunLogInfo)params).getStorageOrgUnit().getId().toString();
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutex.releaseObjIDForUpdate(storageOrgUnitID);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"end run mrp...");
        }
    }

    @Override
    protected void _backRun(Context ctx, IObjectValue mrpRunLog, boolean needCheckData) throws BOSException, EASBizException {
        MRPRunLogInfo logValue = (MRPRunLogInfo)mrpRunLog;
        this.checkParams(ctx, logValue);
        MRPStep.isMoreInfo = logValue.getIsOutputLog();
        if (MRPStep.isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
        MRPStep.instanceHome = System.getProperty("EAS_INSTANCE_HOME");
        this.setMrpLogNumber(ctx, logValue);
        String storageOrgUnitID = logValue.getStorageOrgUnit().getId().toString();
        this.requestMutex(ctx, storageOrgUnitID);
        if (needCheckData) {
            this.checkBOM(ctx, logValue, storageOrgUnitID, true, true);
        }
        Boolean isQueueEnabled = Boolean.FALSE;
        if (ctx.get((Object)"isStart") != null) {
            isQueueEnabled = (Boolean)ctx.get((Object)"isStart");
        }
        if (ctx.get((Object)"MRP_JOB_INST_ID") != null && isQueueEnabled.booleanValue()) {
            this._runMRP(ctx, mrpRunLog);
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"begin to back run mrp...");
            }
            BPOption bpOption = new BPOption();
            bpOption.setImmediately(true);
            DynamicBackground bd = new DynamicBackground(ctx);
            BPResult result = bd.invokeBackound(this.getBOSType(), "runMRP", new Class[]{MRPRunLogInfo.class}, new Object[]{mrpRunLog}, bpOption);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("end to back run mrp result is " + result.toString()));
            }
        }
    }

    private void setMrpLogNumber(Context ctx, MRPRunLogInfo objRunLog) throws EASBizException, BOSException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)objRunLog, objRunLog.getStorageOrgUnit().getId().toString());
        String strNumber = null;
        if (ruleStatus.isExist()) {
            strNumber = codingRuleManager.getNumber((IObjectValue)objRunLog, objRunLog.getStorageOrgUnit().getId().toString());
        }
        MrpRunEnum planType = objRunLog.getRunName();
        boolean isContainMRPMaterial = objRunLog.isIsContainsMRPMaterial();
        if (strNumber == null) {
            throw new MRPException(MRPException.MRP_RUN_LOG_RULE_NOT_EXIST);
        }
        if (planType.equals((Object)MrpRunEnum.MPS_GLOBAL) || planType.equals((Object)MrpRunEnum.MPS_Simulator)) {
            if (isContainMRPMaterial) {
                objRunLog.setNumber("MRP" + strNumber);
            } else {
                objRunLog.setNumber("MPS" + strNumber);
            }
        }
        if (planType.equals((Object)MrpRunEnum.COOPERATE_PLAN)) {
            objRunLog.setNumber("CMPS" + strNumber);
        } else {
            objRunLog.setNumber("MRP" + strNumber);
        }
    }

    private void requestMutex(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean bLock = mutex.requestObjIDForUpdate(storageOrgUnitID, ctx.getCaller().toString(), Uuid.create());
        MRPException excep = null;
        if (!bLock) {
            excep = new MRPException(MRPException.LOCK_ERROR, (Throwable)((Object)new MRPException(MRPException.LOCK_ERROR)));
            throw excep;
        }
    }

    private void checkBOM(Context ctx, MRPRunLogInfo logValue, String storageOrgUnitID, boolean needValidateBOM, boolean needReCalcLLC) throws BOSException, EASBizException {
        HashMap retMap = new HashMap();
        this.checkBomValidateAndLowLevelCode(ctx, storageOrgUnitID, retMap, needReCalcLLC, needValidateBOM);
        int iRet = 0;
        if (retMap.containsKey("ValidateBOM")) {
            iRet = (Integer)retMap.get("ValidateBOM");
            logValue.setBomNestingCheck(iRet == 10);
        }
        if (retMap.containsKey("ReCalcLLC")) {
            iRet = (Integer)retMap.get("ReCalcLLC");
            logValue.setIsCalculateLLC(iRet == 0);
        }
    }

    @Override
    protected Map _checkData(Context ctx, String storageOrgUnitID, MRPRunLogInfo mrpRunLogInfo) throws BOSException, EASBizException {
        HashMap retMap = new HashMap();
        this.checkIsOutFactoryCalendar(ctx, storageOrgUnitID, retMap, mrpRunLogInfo);
        this.checkBomCompletion(ctx, storageOrgUnitID, retMap, mrpRunLogInfo);
        this.checkBomValidateAndLowLevelCode(ctx, storageOrgUnitID, retMap, mrpRunLogInfo.isIsManageLLC(), mrpRunLogInfo.isIsCheckBOM());
        return retMap;
    }

    private void checkParams(Context ctx, MRPRunLogInfo logInfo) throws BOSException, EASBizException {
        if (logInfo == null || logInfo.getStorageOrgUnit() == null || logInfo.getStorageOrgUnit().getId() == null || logInfo.getPlanVersion() == null && logInfo.getCplanVersion() == null) {
            throw new MRPException(MRPException.PARAM_ERROR);
        }
        if (logInfo.getPlanVersion() != null && logInfo.getPlanVersion().getId() == null || logInfo.getCplanVersion() != null && logInfo.getCplanVersion().getId() == null) {
            throw new MRPException(MRPException.PARAM_ERROR);
        }
        if (logInfo.getPlanVersion() != null) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            selectors.add(new SelectorItemInfo("requirementUniteRule.*"));
            selectors.add(new SelectorItemInfo("billParam.*"));
            selectors.add(new SelectorItemInfo("reCompParam.*"));
            selectors.add(new SelectorItemInfo("storetype.*"));
            selectors.add(new SelectorItemInfo("storestate.*"));
            selectors.add(new SelectorItemInfo("entrys.*"));
            IPlanVersionSet planVersion = PlanVersionSetFactory.getLocalInstance((Context)ctx);
            PlanVersionSetInfo planVersionInfo = planVersion.getPlanVersionSetInfo((IObjectPK)new ObjectStringPK(logInfo.getPlanVersion().getId().toString()), selectors);
            logInfo.setPlanVersion(planVersionInfo);
        }
        String orgId = logInfo.getStorageOrgUnit().getId().toString();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus((IObjectValue)new PlannedOrderInfo(), logInfo.getStorageOrgUnit().getId().toString());
        if (!ruleStatus.isExist()) {
            throw new MRPException(MRPException.PLANORDERNUMBER_ERROR);
        }
        boolean bRet = FactoryCalendarFactory.getLocalInstance((Context)ctx).checkFactoryCalendar(orgId, new Date());
        if (!bRet) {
            throw new MRPException(MRPException.FACTORYCALENDAR_ERROR);
        }
    }

    @Override
    protected boolean _hasTrailPlanData(Context ctx, boolean isMpsPlan, boolean isMrpChecked, String strStorageUnitID) throws BOSException, EASBizException {
        boolean bRet = false;
        Map map = MRPDynamicTableManager.getStorageOrgTables(ctx, strStorageUnitID);
        for (Map.Entry entry : map.entrySet()) {
            String planVersionNumber = (String)entry.getKey();
            if (Integer.valueOf(planVersionNumber) >= Integer.valueOf("900")) continue;
            Map tblNameMap = (Map)entry.getValue();
            String strTblName = (String)tblNameMap.get("detail");
            String strPlanTypeCondition = isMpsPlan && isMrpChecked ? " t2.FPlanType=10 or t2.FPlanType=20 \n" : (isMpsPlan ? " t2.FPlanType=10 \n" : " t2.FPlanType=20 \n");
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT top 1 t1.FId FROM ").append(strTblName).append(" t1 \n").append("INNER JOIN T_MM_PLANVERSIONSET t2 ON t1.FPlanVersionID = t2.FID \n").append("WHERE ").append(strPlanTypeCondition).append("  AND t2.FNumber<>'").append("900").append("' \n").append("  AND t2.FNumber<>'").append("901").append("' \n");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                rs.next();
                if (rs.size() <= 0) continue;
                bRet = true;
                break;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _runMPSGlobalPlan(Context ctx, String storageOrgUnitNumber, boolean isContainedMRPMaterial, boolean isDelayOrder, boolean isCheckBOM, boolean isReCalculateLLC, String userNumber) throws BOSException, EASBizException {
        ObjectStringPK orgPK;
        ObjectStringPK userPk;
        StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgUnit(ctx, storageOrgUnitNumber);
        PlanVersionSetInfo planVersion = null;
        UserInfo caller = this.getCaller(ctx, userNumber);
        IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
        if (!perm.hasFunctionPermission((IObjectPK)(userPk = new ObjectStringPK(caller.getId().toString())), (IObjectPK)(orgPK = new ObjectStringPK(storageOrgUnit.getId().toString())), "mm_mps_planGlobal_execution")) {
            throw new MRPException(MRPException.BACKRUNUSERNOPERMISSION_ERROR);
        }
        planVersion = this.getPlanVersionSetInfo(ctx, "900", storageOrgUnit.getId().toString());
        MRPRunLogInfo runLogInfo = new MRPRunLogInfo();
        runLogInfo.setCreator(caller);
        runLogInfo.setStorageOrgUnit(storageOrgUnit);
        runLogInfo.setPlanVersion(planVersion);
        runLogInfo.setIsContainsMRPMaterial(isContainedMRPMaterial);
        runLogInfo.setIsDelayOrder(isDelayOrder);
        runLogInfo.setIsCheckBOM(isCheckBOM);
        runLogInfo.setIsManageLLC(isReCalculateLLC);
        runLogInfo.setIsMaterialReplace(planVersion.isIsReplaceCon());
        String number = "MPS" + this.getMRPLogNumber(ctx, runLogInfo, storageOrgUnit.getId().toString());
        runLogInfo.setNumber(number);
        runLogInfo.setRunName(MrpRunEnum.MPS_GLOBAL);
        runLogInfo.setId(BOSUuid.create((BOSObjectType)runLogInfo.getBOSType()));
        runLogInfo.setMateriaRange(MaterialRangeEnum.ALL);
        runLogInfo.setStartTime(Calendar.getInstance().getTime());
        runLogInfo.setPlanDate(new Date());
        this.checkParams(ctx, runLogInfo);
        String storageOrgUnitID = runLogInfo.getStorageOrgUnit().getId().toString();
        this.requestMutex(ctx, storageOrgUnitID);
        try {
            this.checkBOM(ctx, runLogInfo, storageOrgUnitID, isCheckBOM, isReCalculateLLC);
            this._runMRP(ctx, (IObjectValue)runLogInfo);
        }
        finally {
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutex.releaseObjIDForUpdate(storageOrgUnitID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _runMRPGlobalPlan(Context ctx, String storageOrgUnitNumber, boolean isDelayOrder, boolean isCheckBOM, boolean isReCalculateLLC, String userNumber) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgUnit(ctx, storageOrgUnitNumber);
        PlanVersionSetInfo planVersion = this.getPlanVersionSetInfo(ctx, "901", storageOrgUnit.getId().toString());
        UserInfo caller = this.getCaller(ctx, userNumber);
        String permItem = "mm_mrp_planGlobal_execution";
        if (!PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectStringPK(caller.getId().toString()), (IObjectPK)new ObjectStringPK(storageOrgUnit.getId().toString()), permItem)) {
            throw new MRPException(MRPException.BACKRUNUSERNOPERMISSION_ERROR);
        }
        MRPRunLogInfo runLogInfo = new MRPRunLogInfo();
        runLogInfo.setCreator(caller);
        runLogInfo.setStorageOrgUnit(storageOrgUnit);
        runLogInfo.setPlanVersion(planVersion);
        runLogInfo.setIsContainsMRPMaterial(false);
        runLogInfo.setIsDelayOrder(isDelayOrder);
        runLogInfo.setIsCheckBOM(isCheckBOM);
        runLogInfo.setIsManageLLC(isReCalculateLLC);
        runLogInfo.setIsMaterialReplace(planVersion.isIsReplaceCon());
        String number = "MRP" + this.getMRPLogNumber(ctx, runLogInfo, storageOrgUnit.getId().toString());
        runLogInfo.setNumber(number);
        runLogInfo.setRunName(MrpRunEnum.MRP_GLOBAL);
        runLogInfo.setId(BOSUuid.create((BOSObjectType)runLogInfo.getBOSType()));
        runLogInfo.setMateriaRange(MaterialRangeEnum.ALL);
        runLogInfo.setStartTime(Calendar.getInstance().getTime());
        runLogInfo.setPlanDate(new Date());
        this.checkParams(ctx, runLogInfo);
        String storageOrgUnitID = runLogInfo.getStorageOrgUnit().getId().toString();
        this.requestMutex(ctx, storageOrgUnitID);
        try {
            this.checkBOM(ctx, runLogInfo, storageOrgUnitID, isCheckBOM, isReCalculateLLC);
            this._runMRP(ctx, (IObjectValue)runLogInfo);
        }
        finally {
            IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            mutex.releaseObjIDForUpdate(storageOrgUnitID);
        }
    }

    private UserInfo getCaller(Context ctx, String userNumber) throws BOSException, EASBizException {
        if (userNumber == null || userNumber.length() == 0) {
            throw new MRPException(MRPException.BACKRUNUSER_ERROR);
        }
        UserInfo caller = UserFactory.getLocalInstance((Context)ctx).getUser(userNumber);
        if (caller == null) {
            throw new MRPException(MRPException.BACKRUNUSER_ERROR);
        }
        return caller;
    }

    public String getMRPLogNumber(Context ctx, MRPRunLogInfo runLogInfo, String storageOrgUnitID) throws BOSException, EASBizException {
        String number = MRPUtil.getBizNumber(ctx, (IObjectValue)runLogInfo, storageOrgUnitID);
        if (number == null) {
            throw new MRPException(MRPException.MRP_RUN_LOG_RULE_NOT_EXIST);
        }
        return number;
    }

    public StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String number) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = null;
        String sql = "select fid,fcontrolunitid from t_org_storage where fnumber = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number});
        try {
            if (rs.next()) {
                storageOrgUnit = new StorageOrgUnitInfo();
                storageOrgUnit.setId(BOSUuid.read((String)rs.getString("fid")));
                CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                ctrlUnitInfo.setId(BOSUuid.read((String)rs.getString("fcontrolunitid")));
                storageOrgUnit.setCU(ctrlUnitInfo);
                storageOrgUnit.setNumber(number);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (storageOrgUnit == null) {
            throw new MRPException(MRPException.STORAGEORGUNITNUMBER_ERROR);
        }
        return storageOrgUnit;
    }

    public PlanVersionSetInfo getPlanVersionSetInfo(Context ctx, String number, String orgid) throws BOSException, EASBizException {
        PlanVersionSetInfo planVersion = null;
        String sql = "select fid, FisReplaceCon from T_MM_PlanVersionSet where fnumber = ? and  FStorageorgunitid= ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number, orgid});
        try {
            if (rs.next()) {
                planVersion = new PlanVersionSetInfo();
                planVersion.setId(BOSUuid.read((String)rs.getString("fid")));
                planVersion.setNumber(number);
                planVersion.setIsReplaceCon(rs.getBoolean("FisReplaceCon"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (planVersion == null) {
            throw new MRPException(MRPException.PLANVERSION_ERROR);
        }
        return planVersion;
    }

    private String getPlanVersionId(Context ctx, String mrpRunLogId) throws BOSException, EASBizException {
        String planVersionId = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT  FPlanVersionId \n").append(" FROM T_MM_MrpRunLog \n").append(" WHERE FID = ? \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{mrpRunLogId});
        try {
            rs.next();
            planVersionId = rs.getString("FPlanVersionId");
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return planVersionId;
    }

    private String getPhysicalTableName(Context ctx, String strStorageUnitID, String strLogicName, String planVersionId) throws BOSException, EASBizException {
        return "";
    }

    private String getExceptMaterialSQL(Context ctx, String strStorageUnitID, String mrpRunLogID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String planVersionId = this.getPlanVersionId(ctx, mrpRunLogID);
        String strDetailTbl = this.getPhysicalTableName(ctx, strStorageUnitID, "detail", planVersionId);
        String strMatTbl = this.getPhysicalTableName(ctx, strStorageUnitID, "material", planVersionId);
        sb.append("SELECT count(*) ").append(" FROM ").append(" ( SELECT DISTINCT FMaterialID,FPlanVersionID,FException1,FException2,FException3,FRunLogID,FBillNumber \n").append("   FROM ").append(strDetailTbl).append(" \n").append("   WHERE (FException1<>0 or FException2<>0 or FException3<>0) ").append("     AND FRunLogID=? \n").append("  ) t1 \n").append(" INNER JOIN T_BD_Material t2 ON t1.FMaterialID= t2.FID\n").append(" INNER JOIN " + strMatTbl + " t3 ON t3.FPlanVersionID = t1.FPlanVersionID \n").append(" \t                           AND t3.FMaterialID = t1.FMaterialID \n").append(" \t                           AND t3.FRunLogID = t1.FRunLogID \n").append(" ORDER BY t2.FNumber \n");
        return sb.toString();
    }

    private String getOnHandLessThanSafeStockSQL(Context ctx, String strStorageUnitID, String mrpRunLogID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String planVersionId = this.getPlanVersionId(ctx, mrpRunLogID);
        String strMatTbl = this.getPhysicalTableName(ctx, strStorageUnitID, "material", planVersionId);
        sb.append("SELECT count(*) ").append(" FROM T_BD_Material t2 \n").append(" INNER JOIN " + strMatTbl + " t3 ON t3.FMaterialID = t2.FID \n").append(" WHERE t3.FRunLogID=? \n").append("   AND t3.FOnHand<t3.FSafeStock \n").append(" ORDER BY t2.FNumber; \n");
        return sb.toString();
    }

    private String getPlanOrderSQL(Context ctx, String strStorageUnitID, String mrpRunLogID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String planVersionId = this.getPlanVersionId(ctx, mrpRunLogID);
        String strDetailTbl = this.getPhysicalTableName(ctx, strStorageUnitID, "detail", planVersionId);
        String strMatTbl = this.getPhysicalTableName(ctx, strStorageUnitID, "material", planVersionId);
        sb.append("SELECT count(*)").append(" FROM " + strDetailTbl + " t1 \n").append(" INNER JOIN T_BD_Material t2 ON t1.FMaterialID= t2.FID\n").append(" INNER JOIN " + strMatTbl + " t3 ON t3.FPlanVersionID = t1.FPlanVersionID \n").append(" \t                           AND t3.FMaterialID = t1.FMaterialID \n").append(" \t                           AND t3.FRunLogID = t1.FRunLogID \n").append(" WHERE t1.FPlannedQty>0 AND t1.FBillID IS NOT NULL \n").append("   AND t1.FRunLogID=? \n").append(" ORDER BY t2.FNumber \n");
        return sb.toString();
    }

    @Override
    protected IRowSet _fetchPlanData(Context ctx, int dataType, String strStorageUnitID, String mrpRunLogID) throws BOSException, EASBizException {
        String strSQL = null;
        switch (dataType) {
            case 1: {
                strSQL = this.getExceptMaterialSQL(ctx, strStorageUnitID, mrpRunLogID);
                break;
            }
            case 2: {
                strSQL = this.getOnHandLessThanSafeStockSQL(ctx, strStorageUnitID, mrpRunLogID);
                break;
            }
            case 3: {
                strSQL = this.getPlanOrderSQL(ctx, strStorageUnitID, mrpRunLogID);
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL, (Object[])new Object[]{mrpRunLogID});
        return rs;
    }

    @Override
    protected Date _getNextWorkDay(Context ctx, String strStorageUnitId) throws BOSException, EASBizException {
        Calendar theDate;
        block5: {
            theDate = MRPUtil.createCalendar();
            int workDaySeqID = 0;
            StringBuffer sql = new StringBuffer();
            sql.append("select t0.fid,t0.fworkDateSeq,t0.fweekSeq,").append("\r\n").append("t0.fmonthSeq,t0.FNextWorkDaySeq,t0.FPreWorkDaySeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkdate = to_date('").append(MRPUtil.dateToString(theDate.getTime(), "yyyy-MM-dd")).append("') ").append("\r\n").append("and t1.fstorageorgunitid = ? and t1.FIsDefault=1 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{strStorageUnitId});
            try {
                if (rs.next()) {
                    workDaySeqID = rs.getInt("fworkDateSeq");
                    if (workDaySeqID == 0) {
                        workDaySeqID = rs.getInt("FNextWorkDaySeq");
                        sql.setLength(0);
                        sql.append("select t0.fid,t0.fworkdate,t0.fweekSeq,t0.fmonthSeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkDateSeq = ? ").append("\r\n").append("and t1.fstorageorgunitid = ? and t1.FIsDefault=1 ");
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(workDaySeqID), strStorageUnitId});
                        if (rs.next()) {
                            rs.getDate("fworkdate", theDate);
                        }
                    }
                    break block5;
                }
                throw new MRPException(MRPException.FACTORYCALENDAR_ERROR);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return theDate.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateExcepExitCalcStatus(Context ctx, String strStorageId) throws BOSException, EASBizException {
        boolean isItLocked;
        String[] sa = strStorageId.split("\n");
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashMap map = mutex.getObjIDForUpdateList();
        boolean bl = isItLocked = map != null;
        if (isItLocked) {
            HashMap hashMap = map;
            synchronized (hashMap) {
                isItLocked = map.containsKey(sa[0] + sa[1]);
            }
        }
        if (!isItLocked) {
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE T_MM_MRPRunLog \n").append(" SET FStatus = ").append(20).append(" WHERE FID IN \n").append(" ( SELECT a.FID FROM T_MM_MRPRunLog a,T_ORG_Storage b \n ").append("   WHERE a.FStorageOrgUnitID = b.FID \n").append("     AND a.FStatus = ").append(0).append("     AND a.FStorageOrgUnitID = ?); \n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{strStorageId});
        }
    }

    @Override
    protected int _getParamValueOfPlanAdjust(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)FORWARD_PLANADJUST_TYPE);
        return Integer.valueOf(paramValue);
    }

    @Override
    protected int _getParamValueOfPropSeq(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)SUBPROPSEQ);
        return Integer.valueOf(paramValue);
    }

    @Override
    protected boolean _getParamValueOfSubAltPlanOrder(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)SUB_ALT_PLAN_ORDER);
        return Boolean.valueOf(paramValue);
    }

    @Override
    protected void _stopMRP(Context ctx, String logNum, String orgId) throws BOSException, EASBizException {
        String sql = "select FCreatorID,FStatus from T_MM_MRPRunLog where FNumber = '" + logNum + "' and FStorageOrgUnitID = '" + orgId + "'";
        IRowSet set = SQLUtils.executeQuery((Context)ctx, (String)sql);
        try {
            if (set != null && set.next()) {
                int status = set.getInt("FStatus");
                String creator = set.getString("FCreatorID");
                UserInfo userinfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
                if (!userinfo.getId().toString().equals(creator)) {
                    sql = "select FNumber from t_pm_user where FID = '" + creator + "'";
                    set = SQLUtils.executeQuery((Context)ctx, (String)sql);
                    String number = "";
                    if (set != null && set.next()) {
                        number = set.getString("FNumber");
                    }
                    throw new MRPException(MRPException.CAN_STOP_RUNNING, new Object[]{number});
                }
                if (status == 20 || status == 10 || status == 30) {
                    throw new MRPException(MRPException.RUN_END);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        MRPRunStop.getInstance(ctx, orgId).setStop(ctx, true);
    }

    private void checkIsOutFactoryCalendar(Context ctx, String storageOrgUnitID, Map retMap, MRPRunLogInfo mrpRunLogInfo) throws BOSException, EASBizException {
        Date endDate;
        retMap.put("isOutFactoryCalendar", Boolean.FALSE);
        Date planDate = mrpRunLogInfo.getPlanDate();
        String planVersionId = mrpRunLogInfo.getPlanVersion().getId().toString();
        int horizonLength = 0;
        PlanVersionSetInfo pvInfo = this.getPlanVersionInfo(ctx, planVersionId);
        if (pvInfo != null && pvInfo.getPlanningHorizon() != null) {
            horizonLength = pvInfo.getPlanningHorizon().getHorizonLength();
        }
        if ((endDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storageOrgUnitID, planDate, 1, horizonLength - 1, 2)) == null) {
            retMap.put("isOutFactoryCalendar", Boolean.TRUE);
        }
    }

    private void checkBomCompletion(Context ctx, String storageOrgUnitID, Map retMap, MRPRunLogInfo mrpRunLogInfo) throws BOSException, EASBizException {
        retMap.put("isBomComplete", Boolean.TRUE);
        if (mrpRunLogInfo.isBomCompleteCheck()) {
            IOrderBomCompleteCheckFacade bomCompleteCheck = OrderBomCompleteCheckFacadeFactory.getLocalInstance((Context)ctx);
            String materialRangeSql = this.getMaterialRangeSql(storageOrgUnitID, mrpRunLogInfo);
            IRowSet bomCompleteRs = bomCompleteCheck.getBomCompleteCheckList(storageOrgUnitID, materialRangeSql.toString());
            IRowSet noMasterBomRs = bomCompleteCheck.getNoMasterBomMaterialList(storageOrgUnitID, materialRangeSql);
            if (bomCompleteRs.size() > 0 || noMasterBomRs.size() > 0) {
                retMap.put("isBomComplete", Boolean.FALSE);
                retMap.put("bomCompleteRs", bomCompleteRs);
                retMap.put("noMasterBomRs", noMasterBomRs);
            }
        }
    }

    private String getMaterialRangeSql(String storageOrgUnitID, MRPRunLogInfo mrpRunLogInfo) {
        StringBuffer sql = new StringBuffer();
        MrpRunEnum planType = mrpRunLogInfo.getRunName();
        if (MrpRunEnum.MPS_GLOBAL.equals((Object)planType)) {
            sql.append("select FMaterialID from t_bd_materialPlan where FOrgUnit='").append(storageOrgUnitID).append("' and (FPlanningMode=").append(2);
            if (mrpRunLogInfo.isIsContainsMRPMaterial()) {
                sql.append(" or FPlanningMode=").append(3);
            }
            sql.append(") and (FMaterialAttr=10030 or FMaterialAttr=10050 or FMaterialAttr=10040)");
        } else if (MrpRunEnum.MRP_GLOBAL.equals((Object)planType) || MrpRunEnum.MRP_Simulator.equals((Object)planType)) {
            sql.append("select FMaterialID from t_bd_materialPlan where FOrgUnit='").append(storageOrgUnitID).append("' and FPlanningMode=").append(3);
            sql.append("and (FMaterialAttr=10030 or FMaterialAttr=10050 or FMaterialAttr=10040)");
        } else if (MrpRunEnum.MPS_Simulator.equals((Object)planType)) {
            if (MaterialRangeEnum.ALL.equals((Object)mrpRunLogInfo.getMateriaRange()) || MaterialRangeEnum.PUR.equals((Object)mrpRunLogInfo.getMateriaRange())) {
                sql.append("select FMaterialID from t_bd_materialPlan where FOrgUnit='").append(storageOrgUnitID).append("' and (FPlanningMode=").append(2);
                if (mrpRunLogInfo.isIsContainsMRPMaterial()) {
                    sql.append(" or FPlanningMode=").append(3);
                }
                sql.append(") and (FMaterialAttr=10030 or FMaterialAttr=10050 or FMaterialAttr=10040)");
            } else {
                sql.append(sql.append(this.getMaterialIds(mrpRunLogInfo)));
            }
        } else if (MrpRunEnum.MPS_GROSS.equals((Object)planType)) {
            List requirements = (List)mrpRunLogInfo.get("requirementPlanIds");
            sql.append("select FMaterialID from T_MM_RequirementPlan where FID in(").append(SQLUtil.arrayToString((Object[])requirements.toArray())).append(")");
        } else if (MrpRunEnum.MPS_Material.equals((Object)planType) || MrpRunEnum.MRP_Material.equals((Object)planType)) {
            sql.append(this.getMaterialIds(mrpRunLogInfo));
        }
        return sql.toString();
    }

    private String getMaterialIds(MRPRunLogInfo mrpRunLogInfo) {
        StringBuffer materialIds = new StringBuffer();
        Object[] materialRangeIds = new String[mrpRunLogInfo.getMaterialEntry().size()];
        for (int i = 0; i < mrpRunLogInfo.getMaterialEntry().size(); ++i) {
            MRPRunMaterialEntryInfo info = mrpRunLogInfo.getMaterialEntry().get(i);
            materialRangeIds[i] = info.getMaterial().getId().toString();
        }
        materialIds.append(SQLUtil.arrayToString((Object[])materialRangeIds));
        return materialIds.toString();
    }

    private void checkBomValidateAndLowLevelCode(Context ctx, String storageOrgUnitID, Map retMap, boolean needReCalcLLC, boolean needValidateBOM) throws BOSException, EASBizException {
        if (needReCalcLLC) {
            ILowLevelCode lowLevelCodeCtrl = LowLevelCodeFactory.getLocalInstance((Context)ctx);
            int iRet = lowLevelCodeCtrl.reCalculateLowLevelCode(storageOrgUnitID);
            retMap.put("ReCalcLLC", new Integer(iRet));
        } else if (needValidateBOM) {
            IBOMFacade bomCtrl = BOMFacadeFactory.getLocalInstance((Context)ctx);
            int iRet = bomCtrl.bomCheck(storageOrgUnitID);
            retMap.put("ValidateBOM", new Integer(iRet));
        }
    }

    private PlanVersionSetInfo getPlanVersionInfo(Context ctx, String planVersionId) throws BOSException, EASBizException {
        PlanVersionSetInfo pvInfo = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("planningHorizon.horizonLength"));
        pvInfo = PlanVersionSetFactory.getLocalInstance((Context)ctx).getPlanVersionSetInfo((IObjectPK)new ObjectUuidPK(planVersionId), selector);
        return pvInfo;
    }

    @Override
    protected void _getRequirementPlan(Context ctx, StringBuffer sql, List paramList) throws BOSException {
    }
}

