/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.MRPRunLogStatusEnum;
import com.kingdee.eas.mm.planning.app.AbstractMRPRunLogControllerBean;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class MRPRunLogControllerBean
extends AbstractMRPRunLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.MRPRunLogControllerBean");
    private static final String isMaterialReplace = "IS_MATERAIL_SUBSTITUTE";

    private MRPRunLogInfo getMRPRunLogInfValue(Context ctx, String id) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        return (MRPRunLogInfo)this._getValue(ctx, (IObjectPK)pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected boolean _checkStatus(Context ctx, String id) throws BOSException {
        return false;
    }

    @Override
    protected boolean _calcEnd(Context ctx, String id, MRPRunLogStatusEnum status, String desc) throws BOSException {
        return false;
    }

    @Override
    protected boolean _getParamValueOfIsMaterailReplace(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)isMaterialReplace);
        return Boolean.valueOf(paramValue);
    }

    @Override
    protected MRPRunLogInfo _getMRPRunLog(Context ctx, String orgId, String planVersionID) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _getMaterials(Context ctx, String storageOrgUnitId, String runLogId, String planVersionId, boolean isFormal) throws BOSException, EASBizException {
        String tempTable = this.createMaterialTempTable(ctx);
        Map mrpTables = MRPDynamicTableManager.getMRPRunningTables(ctx, storageOrgUnitId, planVersionId, isFormal);
        String mrpMaterialTable = (String)mrpTables.get("material");
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable).append(" \n");
        sql.append("(KSQL_SEQ,FID,FMaterialNumber,FMaterialName,FMaterialModel,FPlanningMode,FMaterialAttr)\n");
        sql.append("select newbosid('B844D41F') as FID, ");
        sql.append("m.FMaterialNumber as FMaterialNumber, ");
        sql.append("t1.FName_").append(ctx.getLocale()).append(" as FMaterialName, t1.FModel as FMaterialModel, \n");
        sql.append("m.FPlanningMode as FPlanningMode,m.FMaterialAttr as FMaterialAttr\n");
        sql.append("from t_mm_MrpRunLog t \n");
        sql.append("inner join ").append(mrpMaterialTable).append(" m on m.FRunLogId=t.FID \n");
        sql.append("inner join t_bd_material t1 on m.FMaterialId=t1.FID \n");
        sql.append("where t.FID='").append(runLogId).append("' order by FMaterialNumber asc ");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        return tempTable;
    }

    private String createMaterialTempTable(Context ctx) throws BOSException {
        String tempTable = null;
        StringBuffer sql = new StringBuffer();
        sql.append("create table tempMaterial( \n");
        sql.append("FID VARCHAR(44) NOT NULL,\n");
        sql.append("KSQL_SEQ INT IDENTITY (1, 1),\n");
        sql.append("FMaterialNumber NVARCHAR(80),\n");
        sql.append("FMaterialName NVARCHAR(255),\n");
        sql.append("FMaterialModel NVARCHAR(255),\n");
        sql.append("FPlanningMode int not null default 0,\n");
        sql.append("FMaterialAttr int not null default 10060,\n");
        sql.append("CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) )");
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    @Override
    protected IRowSet _getMaterials(Context ctx, String tableName, int start, int rows) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ").append(tableName).append(" \n");
        sql.append("where KSQL_SEQ>").append(start);
        sql.append(" and KSQL_SEQ<=").append(start + rows);
        return SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _releaseTable(Context ctx, String tableName) throws BOSException, EASBizException {
        this.dropTable(ctx, tableName);
    }

    private void dropTable(Context ctx, String tableName) throws BOSException {
        if (tableName != null) {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(tableName);
        }
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        MRPRunLogInfo logInfo = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("status"));
        try {
            logInfo = (MRPRunLogInfo)this.getValue(ctx, pk, selector);
        }
        catch (Exception e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        if (logInfo != null && MRPRunLogStatusEnum.Running.equals((Object)logInfo.getStatus())) {
            throw new CanNotDeleteException(this.getReqResource("CANNOT_DELETE_RUNNING_LOG", new String[0]));
        }
    }

    private String getReqResource(String key, String[] params) {
        return ResourceUtils.getMessage((String)"com.kingdee.eas.mm.planning.MRPResource", (String)key, (String[])params);
    }

    @Override
    protected Date _getCurrentTime(Context ctx) throws BOSException {
        return Calendar.getInstance().getTime();
    }

    @Override
    protected byte[] _getLogFile(Context ctx) throws BOSException {
        String path = MRPStep.instanceHome;
        Logger logger = MMLogger.getLogger();
        logger.info((Object)("path===" + path));
        String path2 = GlobalFunction.getFilePathForServer();
        logger.info((Object)("path2===" + path2));
        File f = null;
        try {
            File[] files;
            File dir = new File(path + "/logs");
            for (File file : files = dir.listFiles()) {
                String fileName;
                if (!file.isFile() || !(fileName = file.getName()).equals("mrp.log")) continue;
                logger.info((Object)("fileMax===" + file.length()));
                f = file;
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        byte[] fileData = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            fileData = new byte[fis.available()];
            fis.read(fileData);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return fileData;
    }
}

