/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.BPResult;
import com.kingdee.bos.framework.bp.DynamicBackground;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.basedata.PlanningHorizonSetInfo;
import com.kingdee.eas.mm.common.MMCommonException;
import com.kingdee.eas.mm.planning.IMultiOrgPlanRunLog;
import com.kingdee.eas.mm.planning.MultiOrgPlanCalcStatusEnum;
import com.kingdee.eas.mm.planning.MultiOrgPlanEntryCollection;
import com.kingdee.eas.mm.planning.MultiOrgPlanEntryInfo;
import com.kingdee.eas.mm.planning.MultiOrgPlanInfo;
import com.kingdee.eas.mm.planning.MultiOrgPlanRunLogCollection;
import com.kingdee.eas.mm.planning.MultiOrgPlanRunLogDetailCollection;
import com.kingdee.eas.mm.planning.MultiOrgPlanRunLogDetailInfo;
import com.kingdee.eas.mm.planning.MultiOrgPlanRunLogFactory;
import com.kingdee.eas.mm.planning.MultiOrgPlanRunLogInfo;
import com.kingdee.eas.mm.planning.app.AbstractMultiOrgPlanControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MultiOrgPlanControllerBean
extends AbstractMultiOrgPlanControllerBean {
    private static final long serialVersionUID = 2261685662761449351L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.MultiOrgPlanControllerBean");
    private static final String MPS_GLOBAL = "900";
    private static final String MRP_GLOBAL = "901";
    private static final String RESOURCE = "com.kingdee.eas.mm.planning.MultiOrgPlanResource";
    private static final String REGEX_L = "\\{";
    private static final String REGEX_R = "\\}";

    private String getResource(Context ctx, String key) {
        Locale locale = ctx.getLocale();
        return ResourceBase.getString((String)RESOURCE, (String)key, (Locale)locale);
    }

    private String getMessage(Context ctx, String key, String[] parameters) {
        String message = this.getResource(ctx, key);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parameters.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), parameters[i]);
        }
        return message;
    }

    private String getBizNumber(Context ctx, IObjectValue bizObject, String orgID) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus(bizObject, orgID);
        String number = null;
        if (ruleStatus.isExist()) {
            number = codingRuleManager.getNumber(bizObject, orgID);
        }
        return number;
    }

    @Override
    protected HashMap _getPlanVerSet(Context ctx, StorageOrgUnitInfo[] storageOrgUnits) throws BOSException, EASBizException {
        Locale locale = ctx.getLocale();
        HashMap<String, PlanVersionSetInfo> map = null;
        if (storageOrgUnits == null || storageOrgUnits.length <= 0) {
            logger.error((Object)"Get plan version input StorageOrgUnit is NULL or empty!");
            return null;
        }
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < storageOrgUnits.length; ++i) {
            if (storageOrgUnits[i] == null) continue;
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append("'").append(storageOrgUnits[i].getId().toString()).append("'");
        }
        String planVerNumber = MPS_GLOBAL;
        if (ids.length() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("select ").append(" t0.FStorageOrgUnitID, t0.FID, t0.FName_").append(locale).append(", t0.FNumber, t1.FID, t1.FName_").append(locale).append(", t1.FNumber ").append(" from ").append(" T_MM_PlanVersionSet t0  ").append(" inner join T_MM_PlanningHorizonSet t1 on t0.FPlanningHorizonID=t1.FID ").append(" where ").append(" t0.FStorageOrgUnitID in ( ").append(ids).append(") ").append(" and t0.FStatus=").append(20).append(" and t0.FNumber='").append(planVerNumber).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                String storageorgId = null;
                String planVerSetId = null;
                String planVerSetName = null;
                String planVerSetNumber = null;
                String planHorizonSetId = null;
                String planHorizonSetName = null;
                String planHorizonSetNumber = null;
                PlanVersionSetInfo planVerSet = null;
                PlanningHorizonSetInfo planHorizonSet = null;
                while (rs.next()) {
                    storageorgId = rs.getString(1);
                    planVerSetId = rs.getString(2);
                    planVerSetName = rs.getString(3);
                    planVerSetNumber = rs.getString(4);
                    planHorizonSetId = rs.getString(5);
                    planHorizonSetName = rs.getString(6);
                    planHorizonSetNumber = rs.getString(7);
                    planVerSet = new PlanVersionSetInfo();
                    planVerSet.setId(BOSUuid.read((String)planVerSetId));
                    planVerSet.setName(planVerSetName, locale);
                    planVerSet.setNumber(planVerSetNumber);
                    planHorizonSet = new PlanningHorizonSetInfo();
                    planHorizonSet.setId(BOSUuid.read((String)planHorizonSetId));
                    planHorizonSet.setName(planHorizonSetName, locale);
                    planHorizonSet.setNumber(planHorizonSetNumber);
                    planVerSet.setPlanningHorizon(planHorizonSet);
                    if (map == null) {
                        map = new HashMap<String, PlanVersionSetInfo>();
                    }
                    map.put(storageorgId, planVerSet);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return map;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String sql;
        IRowSet rs;
        Locale locale = ctx.getLocale();
        String msg = null;
        MultiOrgPlanInfo info = (MultiOrgPlanInfo)model;
        if (info.getStorageOrgUnit() == null) {
            msg = this.getResource(ctx, "PLANING_ORG_ISNULL");
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
        }
        if ("".equals(info.getNumber().trim()) || info.getNumber() == null) {
            msg = this.getResource(ctx, "NUMBER_ISNULL");
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
        }
        if ("".equals(info.getName(locale).trim()) || info.getName(locale) == null) {
            msg = this.getResource(ctx, "NAME_ISNULL");
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
        }
        if (info.getId() == null && (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select 1 from T_MM_MultiOrgPlan t0 where (t0.Fnumber='" + info.getNumber() + "' or t0.FName_" + locale + "='" + info.getName(locale) + "')  and t0.FStorageOrgUnitId='" + info.getStorageOrgUnit().getId().toString() + "' "))).size() > 0) {
            msg = this.getResource(ctx, "NUMBER_OR_NAME_EXIST");
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
        }
        MultiOrgPlanEntryCollection entryCollection = (MultiOrgPlanEntryCollection)((Object)info.get("entry"));
        if (entryCollection == null) {
            msg = this.getResource(ctx, "EXEC_ORG_LESSTHAN_2");
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
        }
        if (entryCollection.size() < 2) {
            msg = this.getResource(ctx, "EXEC_ORG_LESSTHAN_2");
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
        }
        PlanVersionSetInfo temPlanVerSet = null;
        String storageOrgName = null;
        StringBuffer str = new StringBuffer();
        StringBuffer temp = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            temPlanVerSet = entryCollection.get(i).getPlanVersionSet();
            temp = new StringBuffer();
            if (entryCollection.get(i).getCalcSeq() == 0) {
                temp.append(this.getResource(ctx, "CALCSEQ_ISZERO"));
            }
            if (entryCollection.get(i).getStorageOrgUnit() == null) {
                temp.append(this.getResource(ctx, "EXEC_STORAGEORG_ISNULL"));
            } else if (temPlanVerSet == null) {
                storageOrgName = entryCollection.get(i).getStorageOrgUnit().getName(locale);
                temp.append(this.getMessage(ctx, "PLANVERSET_ISNULL", new String[]{storageOrgName}));
            }
            if (temp.length() <= 0) continue;
            if (str.length() > 0) {
                str.append("\n");
            }
            str.append(this.getMessage(ctx, "ENTRY", new String[]{new Integer(i + 1).toString()})).append(temp);
        }
        if (str.length() > 0) {
            msg = "\n" + str;
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
        }
        info.setBizDate(new Date());
        return super._save(ctx, (IObjectValue)info);
    }

    private void clearExceptionRunLog(Context ctx) throws BOSException, EASBizException {
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashMap mutexMap = mutex.getObjIDForUpdateList();
        StringBuffer oql = new StringBuffer();
        oql.append("select id,storageOrgUnit.id,percent where percent<>100");
        IMultiOrgPlanRunLog iMultiiOrgLog = MultiOrgPlanRunLogFactory.getLocalInstance(ctx);
        MultiOrgPlanRunLogCollection collection = iMultiiOrgLog.getMultiOrgPlanRunLogCollection(oql.toString());
        ArrayList<String> pkList = new ArrayList<String>();
        MultiOrgPlanRunLogInfo info = null;
        for (int i = 0; i < collection.size(); ++i) {
            String mutexId;
            info = collection.get(i);
            if (info.getStorageOrgUnit() == null || mutexMap.get(mutexId = "MULTIPLAN" + info.getStorageOrgUnit().getId().toString() + ctx.getAIS()) != null) continue;
            pkList.add(info.getId().toString());
        }
        if (pkList.size() <= 0) {
            return;
        }
        IObjectPK[] pkArray = new IObjectPK[pkList.size()];
        for (int i = 0; i < pkList.size(); ++i) {
            pkArray[i] = new ObjectStringPK(pkList.get(i).toString());
        }
        iMultiiOrgLog.deleteBatchData(pkArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _multiOrgPlanRun(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String msg = null;
        try {
            this.clearExceptionRunLog(ctx);
        }
        catch (Exception ex) {
            logger.info((Object)("Delete unnecessary multiOrgPlanLog error:" + ex));
        }
        MultiOrgPlanRunLogInfo runLog = new MultiOrgPlanRunLogInfo();
        StringBuffer oql = new StringBuffer();
        oql.append("select ").append(" id, number, name, storageOrgUnit.id, storageOrgUnit.name, storageOrgUnit.number, ").append(" planCalcType, isProcessMRP, isCalcLvlCode, isBomCheck, isAllowPlanPast,isMaterialReplace, ").append(" entry.id, entry.calcSeq, entry.storageOrgUnit.id, entry.storageOrgUnit.name, ").append(" entry.storageOrgUnit.number, entry.storageOrgUnit.CU, entry.planVersionSet.id,  ").append(" entry.planVersionSet.name, entry.planVersionSet.number, entry.planVersionSet.name,  ").append(" entry.parent ").append(" where ").append(" id='" + model.get("id").toString()).append("'").append(" order by entry.calcSeq asc");
        MultiOrgPlanInfo multiOrgPlanInfo = this.getMultiOrgPlanInfo(ctx, oql.toString());
        BOSUuid logId = BOSUuid.create((BOSObjectType)runLog.getBOSType());
        runLog.setId(logId);
        String number = this.getBizNumber(ctx, (IObjectValue)runLog, multiOrgPlanInfo.getStorageOrgUnit().getId().toString());
        if (number == null) {
            msg = this.getResource(ctx, "MRP_RUN_LOG_RULE_NOTEXIST");
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
        }
        UserInfo currUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        runLog.setPlanCalcNo(number);
        runLog.setStorageOrgUnit(multiOrgPlanInfo.getStorageOrgUnit());
        runLog.setMultiOrgPlan(multiOrgPlanInfo);
        runLog.setCreator(currUser);
        runLog.setStatus(MultiOrgPlanCalcStatusEnum.RUNNING);
        MultiOrgPlanRunLogDetailCollection collection = new MultiOrgPlanRunLogDetailCollection();
        MultiOrgPlanEntryCollection multiOrgPlanEntryCollection = multiOrgPlanInfo.getEntry();
        MultiOrgPlanEntryInfo multiOrgPlanEntryInfo = null;
        for (int i = 0; i < multiOrgPlanEntryCollection.size(); ++i) {
            multiOrgPlanEntryInfo = multiOrgPlanEntryCollection.get(i);
            MultiOrgPlanRunLogDetailInfo logDetail = new MultiOrgPlanRunLogDetailInfo();
            logDetail.setCalcSeq(multiOrgPlanEntryInfo.getCalcSeq());
            logDetail.setStorageOrgUnit(multiOrgPlanEntryInfo.getStorageOrgUnit());
            logDetail.setStatus(MultiOrgPlanCalcStatusEnum.WAITING);
            logDetail.setStartTime(Calendar.getInstance().getTime());
            logDetail.setMultiOrgRunLog(runLog);
            logDetail.setCreator(currUser);
            collection.add(logDetail);
        }
        runLog.put("logDetail", (Object)collection);
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String mutexId = "MULTIPLAN" + multiOrgPlanInfo.getStorageOrgUnit().getId().toString();
        boolean hasMutex = mutex.requestObjIDForUpdate(mutexId, ctx.getCaller().toString(), Uuid.create());
        if (!hasMutex) {
            msg = this.getResource(ctx, "MULTIPLAN_EXIST_RUN");
            throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
        }
        try {
            logger.info((Object)"MULTI_PLAN: Back run MultiOrgPlan.");
            BPOption bpOption = new BPOption();
            bpOption.setImmediately(true);
            DynamicBackground bd = new DynamicBackground();
            BPResult result = bd.invokeBackound(new BOSObjectType("8DB0EAE3"), "runMultiOrgPlan", new Class[]{IObjectValue.class}, new Object[]{runLog}, bpOption);
            logger.info((Object)("MULTI_PLAN: Back run MultiOrgPlan finished. Result: " + result.toString()));
        }
        catch (Exception e) {
            logger.error((Object)("Dynamic Back run MultiOrgPlan Error: " + e));
        }
        finally {
            mutex.releaseObjIDForUpdate(mutexId);
        }
        return logId.toString();
    }

    public BatchExecuteResult batchExecute(Context ctx, String name, Class[] parameterTypes, BatchExecuteParamsEntry[] entries) throws BaseException {
        BatchExecuteResult result = super.batchExecute(ctx, name, parameterTypes, entries);
        BatchExecuteResult ret = null;
        if (result.getBatchResult() != null) {
            ret = (BatchExecuteResult)result.getBatchResult();
            for (int i = 0; i < ret.getExceptions().length; ++i) {
                result.setException(i, ret.getExceptions()[i]);
            }
        }
        if (ret == null) {
            ret = result;
        }
        return ret;
    }

    protected BatchExecuteResult _batchDelete(Context ctx, BatchExecuteParamsEntry[] paramEntries) throws BOSException {
        IObjectPK pk = null;
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < paramEntries.length; ++i) {
            if (ids.length() > 0) {
                ids.append(",");
            }
            pk = (IObjectPK)paramEntries[i].get(0);
            ids.append("'").append(pk.toString()).append("'");
        }
        String sql = "select t0.FID from T_MM_MultiOrgPlan t0 left outer join T_MM_MultiOrgPlanRunLog t1 on t0.FID=t1.FMultiOrgPlanID where t1.FMultiOrgPlanID is null and t0.FID in (" + ids.toString() + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rs.next()) {
                idSet.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        BatchExecuteResult result = new BatchExecuteResult(paramEntries.length);
        for (int i = 0; i < result.size(); ++i) {
            try {
                pk = (IObjectPK)paramEntries[i].get(0);
                if (!idSet.contains(pk.toString())) {
                    boolean isExist = this.exists(ctx, pk);
                    String msg = null;
                    msg = isExist ? this.getResource(ctx, "MULTIPLAN_EXIST_RUNLOG") : this.getResource(ctx, "BILL_NOT_EXIST");
                    throw new MMCommonException(MMCommonException.BLANK, (Object[])new String[]{msg});
                }
                this.delete(ctx, pk);
                continue;
            }
            catch (Throwable th) {
                result.setException(i, th);
            }
        }
        return result;
    }

    @Override
    protected boolean _isMultiOrgPlanHasRunlog(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "select t1.fid from T_MM_MultiOrgPlanRunLog t1  where t1.FMultiOrgPlanID='" + id + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rs.size() > 0;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        return false;
    }
}

