/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.ProductionFormulaInfo;
import com.kingdee.eas.mm.common.util.ProductionFormulaHelper;
import com.kingdee.eas.mm.planning.IPLChooseEntry;
import com.kingdee.eas.mm.planning.IPlanOrderEntry;
import com.kingdee.eas.mm.planning.IProductionLineScheduling;
import com.kingdee.eas.mm.planning.PLChooseEntryFactory;
import com.kingdee.eas.mm.planning.PLSActionResult;
import com.kingdee.eas.mm.planning.PLSBatchDataVO;
import com.kingdee.eas.mm.planning.PLSEntryCollection;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.PlanOrderEntryFactory;
import com.kingdee.eas.mm.planning.ProductionLineSchedulingFactory;
import com.kingdee.eas.mm.planning.RunResult;
import com.kingdee.eas.mm.planning.SrcTypeEnum;
import com.kingdee.eas.mm.planning.app.AbstractPLSEntryControllerBean;
import com.kingdee.eas.mm.planning.app.PLSRunFacadeControllerBean;
import com.kingdee.eas.mm.planning.app.ProductionLineSchedulingControllerBean;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PLSEntryControllerBean
extends AbstractPLSEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.PLSEntryControllerBean");

    @Override
    protected boolean _checkExistSubPlan(Context ctx, IObjectPK[] pks, String status) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < pks.length; ++i) {
            idSet.add(pks[i].toString());
        }
        if (status != null && status.trim().length() > 0) {
            return this.checkSubPlanByStatus(ctx, idSet, new Integer(status));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mainPlanID", idSet, CompareType.INCLUDE));
        return this._exists(ctx, filter);
    }

    protected boolean checkSubPlanByStatus(Context ctx, Set idSet, int status) throws BOSException {
        boolean isExist = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mainPlanID", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        HashSet<String> childSet = null;
        PLSEntryCollection childPlanCol = this.getPLSEntryCollection(ctx, viewInfo);
        if (childPlanCol != null && childPlanCol.size() > 0) {
            childSet = new HashSet<String>();
            for (int i = 0; i < childPlanCol.size(); ++i) {
                if (status == childPlanCol.get(i).getBaseStatus().getValue()) {
                    return true;
                }
                childSet.add(childPlanCol.get(i).getId().toString());
            }
            isExist = this.checkSubPlanByStatus(ctx, childSet, status);
        }
        return isExist;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks, boolean isAuditAllSubPlan) throws BOSException, EASBizException {
        Set<String> idSet = new HashSet<String>();
        for (int i = 0; i < pks.length; ++i) {
            idSet.add(pks[i].toString());
        }
        if (isAuditAllSubPlan) {
            idSet = this.getAllSubPlan(ctx, idSet, idSet);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("lineNum"));
        sic.add(new SelectorItemInfo("parent.number"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(2), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        PLSEntryCollection auditCol = this.getPLSEntryCollection(ctx, viewInfo);
        HashSet<BOSUuid> auditIdSet = new HashSet<BOSUuid>();
        StringBuffer logInfo = new StringBuffer();
        int count = auditCol.size();
        for (int i = 0; i < count; ++i) {
            PLSEntryInfo info = auditCol.get(i);
            auditIdSet.add(info.getId());
            logInfo.append(info.getParent().getNumber() + " " + info.getLineNum());
            if (i >= count - 1) continue;
            logInfo.append(", ");
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"audit", (BOSObjectType)this.getBOSType(), null, (String)logInfo.toString(), (String)"mm_ProductionLineScheduling_auditRow");
        String strIds = this.parseToStringForInclude(auditIdSet);
        StringBuffer auditSql = new StringBuffer();
        auditSql.append(" update T_MM_PLSEntry set FBaseStatus = 4");
        auditSql.append(" ,FAuditorID = '" + ctx.getCaller().toString() + "'");
        auditSql.append(" ,FAuditTime = now()");
        auditSql.append(" where FID in (" + strIds + ")");
        DbUtil.execute((Context)ctx, (String)auditSql.toString());
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    @Override
    protected HashMap _release(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        HashMap<BOSUuid, PLSActionResult> resultMap = new HashMap<BOSUuid, PLSActionResult>();
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("status", "OK");
        HashMap<String, HashMap<String, Object>> retMap = new HashMap<String, HashMap<String, Object>>();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < pks.length; ++i) {
            idSet.add(pks[i].toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("lineNum"));
        sic.add(new SelectorItemInfo("parent.number"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4), CompareType.NOTEQUALS));
        viewInfo.setFilter(filter);
        PLSEntryCollection invalidCol = this.getPLSEntryCollection(ctx, viewInfo);
        PLSActionResult actionResult = null;
        PLSEntryInfo info = null;
        int count = invalidCol.size();
        for (int i = 0; i < count; ++i) {
            info = invalidCol.get(i);
            actionResult = new PLSActionResult();
            actionResult.setNumber(info.getParent().getNumber());
            actionResult.setLineNumber(info.getLineNum());
            actionResult.setMessage(this.getPLSResource(ctx, "Msg_NotAudited"));
            resultMap.put(info.getId(), actionResult);
            idSet.remove(info.getId().toString());
        }
        if (idSet.size() > 0) {
            ProductionLineSchedulingControllerBean pls;
            String errorInfo;
            Set releaseIdSet = this.getAllSubPlan(ctx, idSet, idSet);
            ArrayList<BOSUuid> toAuditIDList = new ArrayList<BOSUuid>();
            EntityViewInfo view = new EntityViewInfo();
            sic.add(new SelectorItemInfo("baseStatus"));
            sic.add(new SelectorItemInfo("qty"));
            sic.add(new SelectorItemInfo("sourceBillId"));
            sic.add(new SelectorItemInfo("srcType"));
            sic.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
            view.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)releaseIdSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            PLSEntryCollection releaseCol = this.getPLSEntryCollection(ctx, view);
            int count2 = releaseCol.size();
            for (int i = 0; i < count2; ++i) {
                info = releaseCol.get(i);
                if (info.getBaseStatus() != EntryBaseStatusEnum.SUBMITED) continue;
                toAuditIDList.add(info.getId());
            }
            if (toAuditIDList.size() > 0) {
                this._audit(ctx, this.convertListToObjectPK(toAuditIDList), false);
            }
            if ((errorInfo = (pls = new ProductionLineSchedulingControllerBean())._genProductionOrder(ctx, releaseCol.get(0).getParent().getStorageOrgUnit().getId().toString(), releaseIdSet)) != null && errorInfo.length() > 0) {
                statusMap.put("status", errorInfo);
                retMap.put("statusMap", statusMap);
                retMap.put("notAuditedMap", resultMap);
                return retMap;
            }
            StringBuffer logInfo = new StringBuffer();
            int count3 = releaseCol.size();
            for (int i = 0; i < count3; ++i) {
                info = releaseCol.get(i);
                logInfo.append(info.getParent().getNumber() + " " + info.getLineNum());
                if (i >= count3 - 1) continue;
                logInfo.append(", ");
            }
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"release", (BOSObjectType)this.getBOSType(), null, (String)logInfo.toString(), (String)"mm_ProductionLineScheduling_releasedRow");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
        retMap.put("statusMap", statusMap);
        retMap.put("notAuditedMap", resultMap);
        return retMap;
    }

    @Override
    protected HashMap _unRelease(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        HashMap<BOSUuid, PLSActionResult> resultMap = new HashMap<BOSUuid, PLSActionResult>();
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("status", "OK");
        HashMap<String, HashMap<String, Object>> retMap = new HashMap<String, HashMap<String, Object>>();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < pks.length; ++i) {
            idSet.add(pks[i].toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("lineNum"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.id"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(5), CompareType.NOTEQUALS));
        viewInfo.setFilter(filter);
        PLSEntryCollection invalidCol = this.getPLSEntryCollection(ctx, viewInfo);
        PLSActionResult actionResult = null;
        PLSEntryInfo info = null;
        int count = invalidCol.size();
        for (int i = 0; i < count; ++i) {
            info = invalidCol.get(i);
            actionResult = new PLSActionResult();
            actionResult.setNumber(info.getParent().getNumber());
            actionResult.setLineNumber(info.getLineNum());
            actionResult.setMessage(this.getPLSResource(ctx, "Msg_NotRelease"));
            resultMap.put(info.getId(), actionResult);
            idSet.remove(info.getId().toString());
        }
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("parent.number");
        sortInfo.setSortType(SortType.ASCEND);
        sorters.add(sortInfo);
        sortInfo = new SorterItemInfo("parent.id");
        sortInfo.setSortType(SortType.ASCEND);
        sorters.add(sortInfo);
        viewInfo.setSorter(sorters);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        PLSEntryCollection validCol = this.getPLSEntryCollection(ctx, viewInfo);
        HashMap bill = new HashMap();
        for (int i = 0; i < validCol.size(); ++i) {
            Set<String> idSubSet;
            info = validCol.get(i);
            String parentID = info.getParent().getId().toString();
            String id = info.getId().toString();
            if (!bill.containsKey(parentID)) {
                idSubSet = new HashSet<String>();
                idSubSet.add(id);
                bill.put(parentID, idSubSet);
                continue;
            }
            idSubSet = (Set)bill.get(parentID);
            idSubSet.add(id);
        }
        if (idSet.size() > 0) {
            PLSRunFacadeControllerBean plsf = new PLSRunFacadeControllerBean();
            for (Map.Entry entry : bill.entrySet()) {
                String key = (String)entry.getKey();
                Set idSubSet = (Set)entry.getValue();
                RunResult runResult = plsf._unReleasePLS(ctx, idSubSet, key);
            }
        } else {
            statusMap.put("status", "NG");
        }
        retMap.put("statusMap", statusMap);
        retMap.put("notReleaseMap", resultMap);
        return retMap;
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK[] pks, boolean isUnAuditAllSubPlan) throws BOSException, EASBizException {
        Set<String> idSet = new HashSet<String>();
        for (int i = 0; i < pks.length; ++i) {
            idSet.add(pks[i].toString());
        }
        if (isUnAuditAllSubPlan) {
            idSet = this.getAllSubPlan(ctx, idSet, idSet);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("lineNum"));
        sic.add(new SelectorItemInfo("parent.number"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        PLSEntryCollection unAuditCol = this.getPLSEntryCollection(ctx, viewInfo);
        HashSet<BOSUuid> toUnAuditIdSet = new HashSet<BOSUuid>();
        StringBuffer logInfo = new StringBuffer();
        int count = unAuditCol.size();
        for (int i = 0; i < count; ++i) {
            PLSEntryInfo info = unAuditCol.get(i);
            toUnAuditIdSet.add(info.getId());
            logInfo.append(info.getParent().getNumber() + " " + info.getLineNum());
            if (i >= count - 1) continue;
            logInfo.append(", ");
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"unAudit", (BOSObjectType)this.getBOSType(), null, (String)logInfo.toString(), (String)"mm_ProductionLineScheduling_unauditRow");
        String strIds = this.parseToStringForInclude(toUnAuditIdSet);
        StringBuffer unAuditSql = new StringBuffer();
        unAuditSql.append(" update T_MM_PLSEntry set FBaseStatus = 2");
        unAuditSql.append(" ,FAuditorID = null ");
        unAuditSql.append(" ,FAuditTime = null ");
        unAuditSql.append(" where FID in (" + strIds + ")");
        DbUtil.execute((Context)ctx, (String)unAuditSql.toString());
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    protected Set getAllSubPlan(Context ctx, Set parentPlan, Set subPlan) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mainPlanID", (Object)parentPlan, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        HashSet<String> childSet = null;
        PLSEntryCollection childPlanCol = this.getPLSEntryCollection(ctx, viewInfo);
        if (childPlanCol != null && childPlanCol.size() > 0) {
            childSet = new HashSet<String>();
            for (int i = 0; i < childPlanCol.size(); ++i) {
                if (subPlan.contains(childPlanCol.get(i).getId().toString())) continue;
                childSet.add(childPlanCol.get(i).getId().toString());
                subPlan.add(childPlanCol.get(i).getId().toString());
            }
            this.getAllSubPlan(ctx, childSet, subPlan);
        }
        return subPlan;
    }

    private String parseToStringForInclude(Set set) {
        StringBuffer ret = new StringBuffer();
        Iterator it = set.iterator();
        int index = 0;
        while (it.hasNext()) {
            if (index > 0) {
                ret.append(",");
            }
            ret.append("'");
            ret.append(it.next().toString());
            ret.append("'");
            ++index;
        }
        return ret.toString();
    }

    @Override
    protected Set _getDeleteAblePlans(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        HashSet<String> retSet = new HashSet<String>();
        String tempTable = this.createTempTableForDelete(ctx);
        Connection conn = null;
        PreparedStatement batchStatement = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into " + tempTable + "(FID,FLongNumber,FBaseStatus,FLevel) values(?,?,?,?)");
        String querySql = "select FID from " + tempTable;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(insertSql.toString());
            int count = pks.length;
            for (int i = 0; i < count; ++i) {
                int index = 1;
                batchStatement.setString(index++, pks[i].toString());
                batchStatement.setString(index++, pks[i].toString());
                batchStatement.setInt(index++, 2);
                batchStatement.setInt(index++, 1);
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
            this.getAndCheckDeleteAbleSubPlan(ctx, conn, tempTable, 1);
            ps = conn.prepareStatement(querySql);
            rs = ps.executeQuery();
            while (rs.next()) {
                retSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement);
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                this.releaseTempTable(ctx, tempTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement);
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        this.releaseTempTable(ctx, tempTable);
        return retSet;
    }

    private void getAndCheckDeleteAbleSubPlan(Context ctx, Connection conn, String tempTable, int expendLevel) throws BOSException {
        PreparedStatement addPs = null;
        PreparedStatement deletePs = null;
        PreparedStatement checkPs = null;
        ResultSet expendRs = null;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(" insert into " + tempTable + "(FID,FLongNumber,FBaseStatus,FLevel) ");
        sqlBuf.append(" select t1.FID,concat(concat(t2.FLongNumber,'!'),t1.FID),t1.FBaseStatus,t2.FLevel+1");
        sqlBuf.append(" from T_MM_PLSEntry as t1 ");
        sqlBuf.append(" inner join " + tempTable + " as t2 on t1.FMainPlanID = t2.FID ");
        sqlBuf.append(" where t2.FLevel = " + expendLevel);
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append(" delete from " + tempTable + " where FID in ");
        deleteSql.append("(select t1.FID from " + tempTable + " as t1 ");
        deleteSql.append(" inner join (select substring(FLongNumber,1,charIndex('!',FLongNumber)-1) as root from " + tempTable);
        deleteSql.append(" where FBaseStatus != 2");
        deleteSql.append(" )as t2 on charIndex(t2.root,t1.FLongNumber) != 0 )");
        String checkSql = " select FID from " + tempTable + " where FLevel = " + expendLevel + 1;
        boolean isNeedToExpend = false;
        try {
            addPs = conn.prepareStatement(sqlBuf.toString());
            deletePs = conn.prepareStatement(deleteSql.toString());
            deletePs.executeUpdate();
            checkPs = conn.prepareStatement(checkSql);
            expendRs = checkPs.executeQuery();
            if (expendRs.next()) {
                isNeedToExpend = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(addPs);
                SQLUtils.cleanup(deletePs);
                SQLUtils.cleanup(expendRs, checkPs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)addPs);
        SQLUtils.cleanup((Statement)deletePs);
        SQLUtils.cleanup((ResultSet)expendRs, (Statement)checkPs);
        if (isNeedToExpend) {
            this.getAndCheckDeleteAbleSubPlan(ctx, conn, tempTable, expendLevel++);
        }
    }

    private String createTempTableForDelete(Context ctx) throws BOSException {
        String tableName = "";
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table t_temp_plseDelete (");
        createSql.append("FID VARCHAR(44),");
        createSql.append("FLongNumber VARCHAR(2500),");
        createSql.append("FBaseStatus INT ,");
        createSql.append("FLevel INT )");
        try {
            tableName = this.createTempTable(ctx, createSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String createTempTable(Context ctx, String createTableSQL) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL);
    }

    protected void releaseTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    @Override
    protected HashMap _batchSubmit(Context ctx, IObjectCollection addedCol, IObjectCollection modifiedCol, IObjectCollection deletedCol) throws BOSException, EASBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Connection cn = null;
        PreparedStatement batchUpdate = null;
        PreparedStatement updatePLCQty_addnew = null;
        PreparedStatement updatePOSchedulingQtyStmt = null;
        PreparedStatement updatePONOSchedulingQtyStmt = null;
        PreparedStatement updateScheQty_update = null;
        PreparedStatement updateNoScheQty_update = null;
        PreparedStatement updateScheQty_delete = null;
        PreparedStatement updateNoScheQty_delete = null;
        HashSet<String> logSet = new HashSet<String>();
        HashMap<String, BigDecimal> writeBackMap_PO = new HashMap<String, BigDecimal>();
        IORMappingDAO idao = null;
        try {
            cn = this.getConnection(ctx);
            idao = this.getDAO(ctx, cn);
            boolean isNeedToExecuteBatch = false;
            if (addedCol != null && addedCol.size() > 0) {
                HashSet<String> mainPlanIdSet = new HashSet<String>();
                HashSet<String> plsIdSet = new HashSet<String>();
                StringBuffer updatePOSchedulingQty = new StringBuffer();
                updatePOSchedulingQty.append(" update T_MM_PlanOrderEntry ");
                updatePOSchedulingQty.append(" set FSchedulingQty = FSchedulingQty+?, FNoSchedulingQty = FNoSchedulingQty-? ");
                updatePOSchedulingQty.append(" where FID = ? ");
                StringBuffer updateSchedulingQty = new StringBuffer();
                updateSchedulingQty.append(" update T_MM_PLChooseEntry ");
                updateSchedulingQty.append(" set FSchedulingQty = FSchedulingQty+?,FNoSchedulingQty = FNoSchedulingQty-? ");
                updateSchedulingQty.append(" where FID = ? ");
                updatePLCQty_addnew = cn.prepareStatement(updateSchedulingQty.toString());
                updatePOSchedulingQtyStmt = cn.prepareStatement(updatePOSchedulingQty.toString());
                int addCount = addedCol.size();
                for (int i = 0; i < addCount; ++i) {
                    PLSEntryInfo info = (PLSEntryInfo)addedCol.getObject(i);
                    if (info.isIsSubPlan()) {
                        if (info.getMainPlanID() == null || mainPlanIdSet.contains(info.getMainPlanID())) continue;
                        mainPlanIdSet.add(info.getMainPlanID());
                        continue;
                    }
                    if (mainPlanIdSet.contains(info.getParent().getId().toString())) continue;
                    plsIdSet.add(info.getParent().getId().toString());
                }
                Map maxLineNumMap = this.getMaxLineNum(ctx, mainPlanIdSet, plsIdSet);
                int addCount2 = addedCol.size();
                for (int i = 0; i < addCount2; ++i) {
                    PLSEntryInfo info = (PLSEntryInfo)addedCol.getObject(i);
                    boolean isSubPlan = info.isIsSubPlan();
                    String keyID = isSubPlan ? info.getMainPlanID() : info.getParent().getId().toString();
                    String newLineNum = this.genNewLineNum(maxLineNumMap, keyID);
                    info.setLineNum(newLineNum);
                    idao.addNewBatch(addedCol.getObject(i));
                    if (!isSubPlan) {
                        updatePLCQty_addnew.setBigDecimal(1, info.getQty());
                        updatePLCQty_addnew.setBigDecimal(2, info.getQty());
                        updatePLCQty_addnew.setString(3, info.getPlcEntryId().toString());
                        updatePLCQty_addnew.addBatch();
                        updatePOSchedulingQtyStmt.setBigDecimal(1, info.getQty());
                        updatePOSchedulingQtyStmt.setBigDecimal(2, info.getQty());
                        updatePOSchedulingQtyStmt.setString(3, info.getSourceBillEntryId().toString());
                        updatePOSchedulingQtyStmt.addBatch();
                    }
                    logSet.add(info.getParent().getNumber());
                    if (info.getSrcType() == null || info.getSrcType() != SrcTypeEnum.PLANORDER) continue;
                    String sourceBillId = info.getSourceBillId().toString();
                    if (writeBackMap_PO.containsKey(sourceBillId)) {
                        BigDecimal qty = (BigDecimal)writeBackMap_PO.get(sourceBillId);
                        writeBackMap_PO.put(sourceBillId, qty.add(info.getQty()));
                        continue;
                    }
                    writeBackMap_PO.put(sourceBillId, info.getQty());
                }
                updatePLCQty_addnew.executeBatch();
                updatePOSchedulingQtyStmt.executeBatch();
                isNeedToExecuteBatch = true;
            }
            HashSet<String> parentIDSet = new HashSet<String>();
            HashSet<String> plcIDSet = new HashSet<String>();
            HashSet<String> poIDSet = new HashSet<String>();
            if (deletedCol != null && deletedCol.size() > 0) {
                ArrayList<String> idList = new ArrayList<String>();
                HashMap<String, String> numberMap = new HashMap<String, String>();
                PLSEntryInfo info = null;
                int deleteCount = deletedCol.size();
                for (int i = 0; i < deleteCount; ++i) {
                    info = (PLSEntryInfo)deletedCol.getObject(i);
                    idList.add(info.getId().toString());
                    numberMap.put(info.getId().toString(), info.getParent().getNumber());
                    parentIDSet.add(info.getParent().getId().toString());
                    plcIDSet.add(info.getPlcEntryId().toString());
                    poIDSet.add(info.getSourceBillEntryId().toString());
                }
                IObjectPK[] pks = this.convertListToObjectPK(idList);
                Set deleteAbleIds = this._getDeleteAblePlans(ctx, pks);
                if (!deleteAbleIds.containsAll(idList)) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.mm.planning.PLSBatchResource", (String)"Msg_Delete");
                    resultMap.put("DELETE", msg + "\n");
                }
                StringBuffer updateSchedulingQty = new StringBuffer();
                updateSchedulingQty.append(" update T_MM_PLChooseEntry  as t1 set (FSchedulingQty) = ");
                updateSchedulingQty.append(" (select t1.FSchedulingQty-t2.FQTY ");
                updateSchedulingQty.append("  from  T_MM_PLSEntry as t2 ");
                updateSchedulingQty.append(" where t1.FID = t2.FPlcEntryId and t2.FID = ?)");
                StringBuffer updateNoSchedulingQty = new StringBuffer();
                updateNoSchedulingQty.append(" update T_MM_PLChooseEntry  as t1 set (FNoSchedulingQty) = ");
                updateNoSchedulingQty.append(" (select t1.FNoSchedulingQty+t2.FQTY");
                updateNoSchedulingQty.append("  from  T_MM_PLSEntry as t2 ");
                updateNoSchedulingQty.append(" where t1.FID = t2.FPlcEntryId and t2.FID = ?)");
                updateScheQty_delete = cn.prepareStatement(updateSchedulingQty.toString());
                updateNoScheQty_delete = cn.prepareStatement(updateNoSchedulingQty.toString());
                StringBuffer updatePOSchedulingQty = new StringBuffer();
                updatePOSchedulingQty.append(" update T_MM_PlanOrderEntry  as t1 set (FSchedulingQty) = ");
                updatePOSchedulingQty.append(" (select to_number(t1.FSchedulingQty-t2.FQTY) ");
                updatePOSchedulingQty.append("  from  T_MM_PLSEntry as t2");
                updatePOSchedulingQty.append(" where t1.fid = t2.fsourcebillentryid and t2.FID = ?)");
                StringBuffer updatePONOSchedulingQty = new StringBuffer();
                updatePONOSchedulingQty.append(" update T_MM_PlanOrderEntry  as t1 set (FNoSchedulingQty) = ");
                updatePONOSchedulingQty.append(" (select to_number(t1.FNoSchedulingQty+t2.FQTY) ");
                updatePONOSchedulingQty.append("  from  T_MM_PLSEntry as t2");
                updatePONOSchedulingQty.append(" where t1.fid = t2.fsourcebillentryid and t2.FID = ?)");
                updatePOSchedulingQtyStmt = cn.prepareStatement(updatePOSchedulingQty.toString());
                updatePONOSchedulingQtyStmt = cn.prepareStatement(updatePONOSchedulingQty.toString());
                Iterator iter = deleteAbleIds.iterator();
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("srcType"));
                sic.add(new SelectorItemInfo("sourceBillId"));
                sic.add(new SelectorItemInfo("qty"));
                viewInfo.setSelector(sic);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)deleteAbleIds, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                PLSEntryCollection dc = this.getPLSEntryCollection(ctx, viewInfo);
                while (iter.hasNext()) {
                    String idStr = (String)iter.next();
                    updateScheQty_delete.setString(1, idStr);
                    updateScheQty_delete.addBatch();
                    updateNoScheQty_delete.setString(1, idStr);
                    updateNoScheQty_delete.addBatch();
                    updatePOSchedulingQtyStmt.setString(1, idStr);
                    updatePOSchedulingQtyStmt.addBatch();
                    updatePONOSchedulingQtyStmt.setString(1, idStr);
                    updatePONOSchedulingQtyStmt.addBatch();
                    idao.deleteBatch((IObjectPK)new ObjectUuidPK(idStr));
                    if (numberMap.containsKey(idStr)) {
                        logSet.add((String)numberMap.get(idStr));
                    }
                    if ((info = dc.get(BOSUuid.read((String)idStr))).getSrcType() == null || info.getSrcType() != SrcTypeEnum.PLANORDER) continue;
                    String sourceBillId = info.getSourceBillId().toString();
                    if (writeBackMap_PO.containsKey(sourceBillId)) {
                        BigDecimal qty = (BigDecimal)writeBackMap_PO.get(sourceBillId);
                        writeBackMap_PO.put(sourceBillId, qty.subtract(info.getQty()));
                        continue;
                    }
                    writeBackMap_PO.put(sourceBillId, info.getQty().negate());
                }
                updateScheQty_delete.executeBatch();
                updateNoScheQty_delete.executeBatch();
                updatePOSchedulingQtyStmt.executeBatch();
                updatePONOSchedulingQtyStmt.executeBatch();
                isNeedToExecuteBatch = true;
            }
            if (isNeedToExecuteBatch) {
                idao.executeBatch();
            }
            if (deletedCol.size() > 0) {
                this.cascadeRemove(parentIDSet, poIDSet, plcIDSet, ctx);
            }
            if (modifiedCol != null && modifiedCol.size() > 0) {
                PLSEntryInfo info = null;
                StringBuffer updateSql = new StringBuffer();
                updateSql.append(" update T_MM_PLSEntry set FBeginDate = ?,FEndDate = ?,FClassTeamID = ?,");
                updateSql.append(" FProOrder = ?,FQty = ?,FBaseQty = ?,FLastUpdateUserID = ?,FLastUpdateTime = now()");
                updateSql.append(" where FID = ?");
                batchUpdate = cn.prepareStatement(updateSql.toString());
                StringBuffer updateSchedulingQty = new StringBuffer();
                updateSchedulingQty.append(" update T_MM_PLChooseEntry  as t1 set (FSchedulingQty) = ");
                updateSchedulingQty.append(" (select to_number(t1.FSchedulingQty-t2.FQTY+?*1) as qty");
                updateSchedulingQty.append("  from  T_MM_PLSEntry as t2 ");
                updateSchedulingQty.append(" where t1.FID = t2.FPlcEntryId and t2.FID = ?)");
                StringBuffer updateNoSchedulingQty = new StringBuffer();
                updateNoSchedulingQty.append(" update T_MM_PLChooseEntry  as t1 set (FNoSchedulingQty) = ");
                updateNoSchedulingQty.append(" (select to_number(t1.FNoSchedulingQty+t2.FQTY-?*1) as qty");
                updateNoSchedulingQty.append("  from  T_MM_PLSEntry as t2 ");
                updateNoSchedulingQty.append(" where t1.FID = t2.FPlcEntryId and t2.FID = ?)");
                updateScheQty_update = cn.prepareStatement(updateSchedulingQty.toString());
                updateNoScheQty_update = cn.prepareStatement(updateNoSchedulingQty.toString());
                StringBuffer updatePOSchedulingQty = new StringBuffer();
                updatePOSchedulingQty.append(" update T_MM_PlanOrderEntry  as t1 set (FSchedulingQty) = ");
                updatePOSchedulingQty.append(" (select to_number(t1.FSchedulingQty-t2.FQTY+?*1) as qty");
                updatePOSchedulingQty.append("  from  T_MM_PLSEntry as t2");
                updatePOSchedulingQty.append(" where t1.fid = t2.fsourcebillentryid and t2.FID = ?)");
                StringBuffer updatePONOSchedulingQty = new StringBuffer();
                updatePONOSchedulingQty.append(" update T_MM_PlanOrderEntry  as t1 set (FNoSchedulingQty) = ");
                updatePONOSchedulingQty.append(" (select to_number(t1.FNoSchedulingQty+t2.FQTY-?*1) as qty");
                updatePONOSchedulingQty.append("  from  T_MM_PLSEntry as t2");
                updatePONOSchedulingQty.append(" where t1.fid = t2.fsourcebillentryid and t2.FID = ?)");
                updatePOSchedulingQtyStmt = cn.prepareStatement(updatePOSchedulingQty.toString());
                updatePONOSchedulingQtyStmt = cn.prepareStatement(updatePONOSchedulingQty.toString());
                HashSet<String> updateIdSet = new HashSet<String>();
                int updateCount = modifiedCol.size();
                for (int i = 0; i < updateCount; ++i) {
                    updateIdSet.add(((PLSEntryInfo)modifiedCol.getObject(i)).getId().toString());
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("srcType"));
                sic.add(new SelectorItemInfo("sourceBillId"));
                sic.add(new SelectorItemInfo("qty"));
                viewInfo.setSelector(sic);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", updateIdSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                PLSEntryCollection oldCol = this.getPLSEntryCollection(ctx, viewInfo);
                int updateCount2 = modifiedCol.size();
                for (int i = 0; i < updateCount2; ++i) {
                    info = (PLSEntryInfo)modifiedCol.getObject(i);
                    int index = 1;
                    batchUpdate.setTimestamp(index++, new Timestamp(info.getBeginDate().getTime()));
                    batchUpdate.setTimestamp(index++, new Timestamp(info.getEndDate().getTime()));
                    batchUpdate.setString(index++, info.getClassTeam() == null ? null : info.getClassTeam().getId().toString());
                    batchUpdate.setBigDecimal(index++, info.getProOrder());
                    batchUpdate.setBigDecimal(index++, info.getQty());
                    batchUpdate.setBigDecimal(index++, info.getBaseQty());
                    batchUpdate.setString(index++, ctx.getCaller().toString());
                    batchUpdate.setString(index++, info.getId().toString());
                    batchUpdate.addBatch();
                    updateScheQty_update.setBigDecimal(1, info.getQty());
                    updateScheQty_update.setString(2, info.getId().toString());
                    updateScheQty_update.addBatch();
                    updateNoScheQty_update.setBigDecimal(1, info.getQty());
                    updateNoScheQty_update.setString(2, info.getId().toString());
                    updateNoScheQty_update.addBatch();
                    updatePOSchedulingQtyStmt.setBigDecimal(1, info.getQty());
                    updatePOSchedulingQtyStmt.setString(2, info.getId().toString());
                    updatePOSchedulingQtyStmt.addBatch();
                    updatePONOSchedulingQtyStmt.setBigDecimal(1, info.getQty());
                    updatePONOSchedulingQtyStmt.setString(2, info.getId().toString());
                    updatePONOSchedulingQtyStmt.addBatch();
                    logSet.add(info.getParent().getNumber());
                    if (info.getSrcType() == null || info.getSrcType() != SrcTypeEnum.PLANORDER) continue;
                    String sourceBillId = info.getSourceBillId().toString();
                    if (writeBackMap_PO.containsKey(sourceBillId)) {
                        BigDecimal qty = (BigDecimal)writeBackMap_PO.get(sourceBillId);
                        writeBackMap_PO.put(sourceBillId, qty.subtract(oldCol.get(info.getId()).getQty()).add(info.getQty()));
                        continue;
                    }
                    writeBackMap_PO.put(sourceBillId, info.getQty().subtract(oldCol.get(info.getId()).getQty()));
                }
                updateScheQty_update.executeBatch();
                updateNoScheQty_update.executeBatch();
                updatePOSchedulingQtyStmt.executeBatch();
                updatePONOSchedulingQtyStmt.executeBatch();
                batchUpdate.executeBatch();
            }
            Iterator mapiter = writeBackMap_PO.entrySet().iterator();
            while (mapiter.hasNext()) {
                Map.Entry entry = mapiter.next();
                if (((BigDecimal)entry.getValue()).compareTo(new BigDecimal(0)) != 0) continue;
                mapiter.remove();
            }
            HashMap<String, HashMap<String, BigDecimal>> wbQtyMap = new HashMap<String, HashMap<String, BigDecimal>>();
            if (writeBackMap_PO != null && writeBackMap_PO.size() > 0) {
                wbQtyMap.put("po", writeBackMap_PO);
            }
            if (wbQtyMap != null && wbQtyMap.size() > 0) {
                IProductionLineScheduling ipls = ProductionLineSchedulingFactory.getLocalInstance(ctx);
                ipls.batchWriteBackBySchedule(wbQtyMap);
            }
            Iterator it = logSet.iterator();
            StringBuffer logInfo = new StringBuffer();
            int obIndex = 1;
            while (it.hasNext()) {
                if (obIndex++ != 1) {
                    logInfo.append(";");
                }
                logInfo.append((String)it.next());
            }
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)this.getBOSType(), null, (String)logInfo.toString(), (String)"mm_ProductionLineScheduling_update");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchUpdate);
                SQLUtils.cleanup(updatePLCQty_addnew);
                SQLUtils.cleanup(updateScheQty_update);
                SQLUtils.cleanup(updateNoScheQty_update);
                SQLUtils.cleanup(updateScheQty_delete);
                SQLUtils.cleanup(updateNoScheQty_delete);
                SQLUtils.cleanup(updatePOSchedulingQtyStmt);
                SQLUtils.cleanup(updatePONOSchedulingQtyStmt);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchUpdate);
        SQLUtils.cleanup((Statement)updatePLCQty_addnew);
        SQLUtils.cleanup(updateScheQty_update);
        SQLUtils.cleanup(updateNoScheQty_update);
        SQLUtils.cleanup(updateScheQty_delete);
        SQLUtils.cleanup(updateNoScheQty_delete);
        SQLUtils.cleanup((Statement)updatePOSchedulingQtyStmt);
        SQLUtils.cleanup(updatePONOSchedulingQtyStmt);
        SQLUtils.cleanup((Connection)cn);
        return resultMap;
    }

    private void cascadeRemove(Set parentIDSet, Set poIDSet, Set plcIDSet, Context ctx) throws BOSException, EASBizException, SQLException {
        StringBuffer querySQL = new StringBuffer();
        IRowSet rs = null;
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        String plcs = StringUtils.arrayToString((Object[])plcIDSet.toArray(), (String)"','");
        querySQL.setLength(0);
        querySQL.append(" select plc.fid as PLCID, to_int(count(pls.fid)) as PLSENTRYCOUNT");
        querySQL.append(" from T_MM_PLChooseEntry as plc left join T_MM_PLSENTRY as pls");
        querySQL.append(" on plc.fid = pls.fplcentryid");
        querySQL.append(" where plc.fid in ('" + plcs + "')");
        querySQL.append(" group by plc.fid");
        countMap.clear();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)querySQL.toString());
            while (rs.next()) {
                countMap.put(rs.getString("PLCID"), new Integer(rs.getInt("PLSENTRYCOUNT")));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        IPLChooseEntry iplc = PLChooseEntryFactory.getLocalInstance(ctx);
        for (String id : plcIDSet) {
            int count = (Integer)countMap.get(id);
            if (count != 0) continue;
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            iplc.delete((IObjectPK)pk);
        }
        String pos = StringUtils.arrayToString((Object[])poIDSet.toArray(), (String)"','");
        querySQL.setLength(0);
        querySQL.append(" select po.fid as POID, to_int(count(plc.fid)) as PLCENTRYCOUNT");
        querySQL.append(" from T_MM_PlanOrderEntry as po left join T_MM_PLChooseEntry as plc");
        querySQL.append(" on po.fid = plc.fsourcebillentryid");
        querySQL.append(" where po.fid in ('" + pos + "')");
        querySQL.append(" group by po.fid");
        countMap.clear();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)querySQL.toString());
            while (rs.next()) {
                countMap.put(rs.getString("POID"), new Integer(rs.getInt("PLCENTRYCOUNT")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        IPlanOrderEntry ipo = PlanOrderEntryFactory.getLocalInstance(ctx);
        for (String id : poIDSet) {
            int count = (Integer)countMap.get(id);
            if (count != 0) continue;
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            ipo.delete((IObjectPK)pk);
        }
        String prts = StringUtils.arrayToString((Object[])parentIDSet.toArray(), (String)"','");
        querySQL.setLength(0);
        querySQL.append(" select prt.fid as PID, to_int(count(po.fid)) as POENTRYCOUNT");
        querySQL.append(" from T_MM_ProductionLineScheduling as prt left join T_MM_PlanOrderEntry as po");
        querySQL.append(" on prt.fid = po.fparent");
        querySQL.append(" where prt.fid in ('" + prts + "')");
        querySQL.append(" group by prt.fid");
        countMap.clear();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)querySQL.toString());
            while (rs.next()) {
                countMap.put(rs.getString("PID"), new Integer(rs.getInt("POENTRYCOUNT")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        IProductionLineScheduling iprt = ProductionLineSchedulingFactory.getLocalInstance(ctx);
        for (String id : parentIDSet) {
            int count = (Integer)countMap.get(id);
            if (count != 0) continue;
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            iprt.delete((IObjectPK)pk);
        }
    }

    private String genNewLineNum(Map maxLineNumMap, String keyId) {
        String retStr = "";
        String maxLineNum = (String)maxLineNumMap.get(keyId);
        if (maxLineNum != null && maxLineNum.trim().length() > 0) {
            if (maxLineNum.indexOf("-") > 0) {
                int newNum = new Integer(maxLineNum.substring(maxLineNum.lastIndexOf("-") + 1)) + 1;
                retStr = newNum < 10 ? maxLineNum.substring(0, maxLineNum.lastIndexOf("-") + 1) + "0" + String.valueOf(newNum) : maxLineNum.substring(0, maxLineNum.lastIndexOf("-") + 1) + String.valueOf(newNum);
            } else {
                int num = new Integer(maxLineNum) + 1;
                retStr = String.valueOf(num);
                for (int i = retStr.length() + 1; i <= 3; ++i) {
                    retStr = "0" + retStr;
                }
            }
        } else {
            retStr = "001";
        }
        maxLineNumMap.remove(keyId);
        maxLineNumMap.put(keyId, retStr);
        return retStr;
    }

    private Map getMaxLineNum(Context ctx, Set mainPlanIdSet, Set plsIdSet) throws BOSException {
        int index;
        Iterator it;
        HashMap<String, String> retMap = new HashMap<String, String>();
        StringBuffer sqlBuf = new StringBuffer();
        if (mainPlanIdSet.size() > 0) {
            sqlBuf.append("select Max(FLineNum) as maxLineNum,FMainPlanID  as KeyID From T_MM_PLSEntry ");
            StringBuffer mainPlanIdStr = new StringBuffer();
            it = mainPlanIdSet.iterator();
            index = 0;
            while (it.hasNext()) {
                if (index++ != 0) {
                    mainPlanIdStr.append(",");
                }
                mainPlanIdStr.append("'");
                mainPlanIdStr.append((String)it.next());
                mainPlanIdStr.append("'");
            }
            sqlBuf.append(" where FIsSubPlan = 1 and FMainPlanID in (" + mainPlanIdStr + ") ");
            sqlBuf.append(" group by FMainPlanID");
        }
        if (plsIdSet.size() > 0) {
            if (mainPlanIdSet.size() > 0) {
                sqlBuf.append(" union ");
            }
            sqlBuf.append("select Max(FLineNum) as maxLineNum,FParent  as KeyID From T_MM_PLSEntry ");
            StringBuffer parentIdStr = new StringBuffer();
            it = plsIdSet.iterator();
            index = 0;
            while (it.hasNext()) {
                if (index++ != 0) {
                    parentIdStr.append(",");
                }
                parentIdStr.append("'");
                parentIdStr.append((String)it.next());
                parentIdStr.append("'");
            }
            sqlBuf.append(" where FParent in (" + parentIdStr + ") and FIsSubPlan = 0");
            sqlBuf.append(" group by FParent");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
            while (rs.next()) {
                retMap.put(rs.getString("KeyID"), rs.getString("maxLineNum"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return retMap;
    }

    @Override
    protected BigDecimal _getMaxProOrder(Context ctx, String productlineId, Date startDate) throws BOSException, EASBizException {
        BigDecimal retValue = new BigDecimal(0);
        String sql = "select max(FProOrder) as maxOrder from T_MM_PLSEntry where FProductLineID = ? and FBeginDate = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            int index = 1;
            ps.setString(index++, productlineId);
            ps.setTimestamp(index++, new Timestamp(startDate.getTime()));
            rs = ps.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1) == null ? new BigDecimal(0) : rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return retValue;
    }

    @Override
    protected PLSBatchDataVO _getPLSBatchDataVO(Context ctx, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        Map finishQtyMap;
        PLSBatchDataVO dataVo = new PLSBatchDataVO();
        PLSEntryCollection plsEntryCollection = this.getPLSEntryCollection(ctx, viewInfo);
        dataVo.setPlsEntryCollection(plsEntryCollection);
        ArrayList<String> mlist = new ArrayList<String>();
        ArrayList<String> ulist = new ArrayList<String>();
        ArrayList<String> idList = new ArrayList<String>();
        int n = plsEntryCollection.size();
        for (int i = 0; i < n; ++i) {
            PLSEntryInfo entryInfo = plsEntryCollection.get(i);
            if (entryInfo.getMaterial() != null && entryInfo.getUnit() != null) {
                mlist.add(entryInfo.getMaterial().getId().toString());
                ulist.add(entryInfo.getUnit().getId().toString());
                mlist.add(entryInfo.getMaterial().getId().toString());
                ulist.add(entryInfo.getBaseUnit().getId().toString());
            }
            if (!entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.PUTIN) && !entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.FINISH)) continue;
            idList.add(entryInfo.getId().toString());
        }
        if (idList.size() > 0 && (finishQtyMap = this.getFinishQty(ctx, idList)) != null && finishQtyMap.size() > 0) {
            int n2 = plsEntryCollection.size();
            for (int i = 0; i < n2; ++i) {
                Object o;
                PLSEntryInfo entryInfo = plsEntryCollection.get(i);
                String id = entryInfo.getId().toString();
                if (!finishQtyMap.containsKey(id) || (o = finishQtyMap.get(id)) == null || !(o instanceof BigDecimal)) continue;
                entryInfo.setEndQty((BigDecimal)o);
            }
        }
        this.loadBaseConvsRatePrecision(ctx, dataVo, mlist.toArray(new String[0]), ulist.toArray(new String[0]));
        return dataVo;
    }

    protected Map getFinishQty(Context ctx, List idList) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> finishQtyMap = new HashMap<String, BigDecimal>();
        String strIDs = StringUtils.arrayToString((Object[])idList.toArray(), (String)"','");
        String sql = "select t.fsourcebillentryid,t.fcommittotalqty from t_mm_productionorder t where t.fsourcebillentryid in ('" + strIDs + "')";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rows.next()) {
                String id = rows.getString("fsourcebillentryid");
                BigDecimal qty = rows.getBigDecimal("fcommittotalqty");
                finishQtyMap.put(id, qty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return finishQtyMap;
    }

    public void loadBaseConvsRatePrecision(Context ctx, PLSBatchDataVO dataVO, String[] materialIds, String[] unitIds) throws BOSException {
        FilterInfo filter = new FilterInfo();
        HashMap<String, MultiMeasureUnitInfo> mapConvsRateAndPrecision = new HashMap<String, MultiMeasureUnitInfo>();
        HashMap<String, Integer> mmuPrecisions = new HashMap<String, Integer>();
        HashMap<String, BigDecimal> mmuConvsRate = new HashMap<String, BigDecimal>();
        int length = materialIds.length;
        for (int i = 0; i < length; ++i) {
            if (materialIds[i] == null || unitIds[i] == null) continue;
            filter.appendFilterItem("material", (Object)materialIds[i]);
            filter.appendFilterItem("measureUnit", (Object)unitIds[i]);
            mapConvsRateAndPrecision.put(materialIds[i] + unitIds[i], null);
        }
        StringBuffer maskString = new StringBuffer();
        int size = filter.getFilterItems().size();
        for (int i = 0; i < size; i += 2) {
            maskString.append("(#").append(i).append(" and #").append(i + 1).append(")");
            if (i + 2 >= size) continue;
            maskString.append(" or ");
        }
        if (filter.getFilterItems().size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter.setMaskString(maskString.toString());
            view.setFilter(filter);
            view.getSelector().add("material");
            view.getSelector().add("measureUnit");
            view.getSelector().add("baseConvsRate");
            view.getSelector().add("qtyPrecision");
            MultiMeasureUnitCollection mmuCol = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
            int size2 = mmuCol.size();
            for (int i = 0; i < size2; ++i) {
                MultiMeasureUnitInfo mmuInfo = mmuCol.get(i);
                mapConvsRateAndPrecision.put(mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString(), mmuInfo);
                mmuPrecisions.put(mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString(), new Integer(mmuInfo.getQtyPrecision()));
                mmuConvsRate.put(mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString(), mmuInfo.getBaseConvsRate());
            }
        }
        dataVO.setMmuPrecisions(mmuPrecisions);
        dataVO.setMmuConvsRate(mmuConvsRate);
    }

    public IObjectPK[] convertListToObjectPK(ArrayList idList) {
        int num = idList.size();
        ObjectUuidPK[] objectPk = new ObjectUuidPK[num];
        for (int i = 0; i < num; ++i) {
            objectPk[i] = new ObjectUuidPK(idList.get(i).toString());
        }
        return objectPk;
    }

    private String getPLSResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLSBatchResource", (String)key, (Locale)ctx.getLocale());
    }

    @Override
    protected HashMap _getScheDiffInfo(Context ctx, String id) throws BOSException, EASBizException {
        HashMap retMap = new HashMap();
        HashMap<String, Object> materialMap = null;
        IRowSet rs = null;
        StringBuffer sqlBuf = new StringBuffer();
        String locale = ctx.getLocale().toString();
        sqlBuf.append(" select PO.FMaterialID,PO.FNoSchedulingQty,PLC.FPlanQty,PLE.FSchedulingQty,PLE.FEndQty,");
        sqlBuf.append(" MATERIAL.FNumber as MaterialNum,MATERIAL.FModel as MaterialModel,");
        sqlBuf.append(" MATERIAL.FName_" + locale + " as MaterialName");
        sqlBuf.append(" from ");
        sqlBuf.append(" (select t1.FMaterialID,SUM(t1.FNoSchedulingQty) as FNoSchedulingQty ");
        sqlBuf.append(" from T_MM_PlanOrderEntry as t1");
        sqlBuf.append(" where t1.FParent = '" + id + "'");
        sqlBuf.append(" group by t1.FMaterialID) as PO");
        sqlBuf.append(" left outer join ");
        sqlBuf.append(" (select t2.FMaterialID,SUM(t2.FQty) as FPlanQty ");
        sqlBuf.append(" from T_MM_PLChooseEntry as t2");
        sqlBuf.append(" where t2.FParent = '" + id + "'");
        sqlBuf.append(" group by t2.FMaterialID) as PLC");
        sqlBuf.append(" on PO.FMaterialID = PLC.FMaterialID ");
        sqlBuf.append(" left outer join ");
        sqlBuf.append(" (select t3.FMaterialID,isnull(SUM(t3.FQty),0) as FSchedulingQty,isnull(SUM(t4.fcommittotalqty),0) as FEndQty");
        sqlBuf.append(" from T_MM_PLSEntry as t3 left outer join t_mm_productionorder as t4 on t3.FID = t4.fsourcebillentryid ");
        sqlBuf.append(" where t3.FParent = '" + id + "'");
        sqlBuf.append(" group by t3.FMaterialID) as PLE");
        sqlBuf.append(" on PO.FMaterialID = PLE.FMaterialID ");
        sqlBuf.append(" left outer join T_BD_MATERIAL  as MATERIAL on PO.FMaterialID = MATERIAL.FID");
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
        try {
            while (rs.next()) {
                materialMap = new HashMap<String, Object>();
                materialMap.put("material", rs.getString("materialName"));
                materialMap.put("materialName", rs.getString("MaterialName"));
                materialMap.put("model", rs.getString("MaterialModel"));
                materialMap.put("noSchedulingQty", PLSEntryControllerBean.fmtZero(rs.getBigDecimal("FNoSchedulingQty")));
                materialMap.put("planQty", PLSEntryControllerBean.fmtZero(rs.getBigDecimal("FPlanQty")));
                materialMap.put("schedulingQty", PLSEntryControllerBean.fmtZero(rs.getBigDecimal("FSchedulingQty")));
                materialMap.put("endQty", PLSEntryControllerBean.fmtZero(rs.getBigDecimal("FEndQty")));
                retMap.put(rs.getString("FMaterialID"), materialMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return retMap;
    }

    private static BigDecimal fmtZero(BigDecimal bd) {
        String bigString = bd.toString();
        if (bigString.startsWith("0E-")) {
            return new BigDecimal("0");
        }
        return bd;
    }

    @Override
    protected Object[] _checkFormula(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        Object[] rtn = new Object[2];
        Object[] rtnUnRelease = new Object[2];
        ArrayList<String> materials = new ArrayList<String>();
        IObjectPK[] releasePks = null;
        ObjectUuidPK releasePk = null;
        ArrayList<String> releasePkList = new ArrayList<String>();
        for (int l = 0; l < pks.length; ++l) {
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(pks[l].toString());
            ArrayList materialNums = new ArrayList();
            ArrayList unReleasePks = new ArrayList();
            List mats = null;
            List unRel = null;
            rtnUnRelease = this.checkFormula(ctx, idSet, true, materialNums, unReleasePks);
            if (rtnUnRelease != null) {
                mats = (List)rtnUnRelease[0];
                unRel = (List)rtnUnRelease[1];
            }
            if (rtnUnRelease == null || mats == null || mats.size() < 1 || unRel == null || unRel.size() < 1) {
                rtnUnRelease = this.checkFormula(ctx, idSet, false, materialNums, unReleasePks);
            }
            if (rtnUnRelease != null) {
                mats = (List)rtnUnRelease[0];
                unRel = (List)rtnUnRelease[1];
            }
            if (rtnUnRelease == null || mats == null || mats.size() < 1 || unRel == null || unRel.size() < 1) {
                releasePkList.add(pks[l].toString());
            }
            if (rtnUnRelease == null || mats == null) continue;
            for (int i = 0; i < mats.size(); ++i) {
                materials.add(mats.get(i).toString());
            }
        }
        if (releasePkList != null && releasePkList.size() > 0) {
            releasePks = new IObjectPK[releasePkList.size()];
            for (int i = 0; i < releasePkList.size(); ++i) {
                releasePk = new ObjectUuidPK(releasePkList.get(i).toString());
                releasePks[i] = releasePk;
            }
        }
        rtn[0] = materials;
        rtn[1] = releasePks;
        return rtn;
    }

    private Object[] checkFormula(Context ctx, Set idSet, boolean isTop, List materialNums, List unReleasePks) throws BOSException, EASBizException {
        Object[] rtn = new Object[2];
        if (idSet == null || idSet.size() < 1) {
            return rtn;
        }
        StringBuffer ids = new StringBuffer();
        Object[] allIDs = new Object[idSet.size()];
        allIDs = idSet.toArray(allIDs);
        for (int i = 0; i < allIDs.length; ++i) {
            ids.append("'").append(allIDs[i].toString()).append("'").append(",");
        }
        ids = ids.replace(ids.length() - 1, ids.length(), "");
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.FID as id, entry.FParent as parentID, entry.FMaterialID as materialID, m.FNumber as materialNum, entry.FProductLineID as productLineID,").append(" entry.FTrackNumberID as trackNumberID, s.FStorageOrgUnitID as storageOrgUnitID, PLSM.FExpandStrategy as expandStrategy ").append(" from T_MM_PLSEntry entry left join T_MM_ProductionLineScheduling s on entry.FParent = s.FID ").append(" left join T_MM_PLSModel PLSM on s.FPLSModelID = PLSM.FID ").append(" left join T_BD_Material m on entry.FMaterialID = m.FID");
        if (isTop) {
            sql.append(" where entry.FID in (").append(ids).append(")");
        } else {
            sql.append(" where entry.FMainPlanID in (").append(ids).append(")");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            HashSet<String> childSet = new HashSet<String>();
            while (rowSet.next()) {
                String id = rowSet.getString("id");
                String parentID = rowSet.getString("parentID");
                String materialID = rowSet.getString("materialID");
                String materialNum = rowSet.getString("materialNum");
                String productLineID = rowSet.getString("productLineID");
                String trackNumberID = rowSet.getString("trackNumberID");
                String storageOrgUnitID = rowSet.getString("storageOrgUnitID");
                int expandStrategyFlag = rowSet.getInt("expandStrategy");
                ProductionFormulaInfo formula = ProductionFormulaHelper.getFormulaByTrackNumber((Context)ctx, (String)materialID, (String)productLineID, (String)storageOrgUnitID, (String)trackNumberID);
                if (20 == expandStrategyFlag && (formula == null || formula.getId() == null)) {
                    if (!materialNums.contains(materialNum)) {
                        materialNums.add(materialNum);
                    }
                    if (!unReleasePks.contains(id)) {
                        unReleasePks.add(id);
                    }
                    if (unReleasePks.contains(parentID)) continue;
                    unReleasePks.add(parentID);
                    continue;
                }
                childSet.add(id);
            }
            this.checkFormula(ctx, childSet, false, materialNums, unReleasePks);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        rtn[0] = materialNums;
        rtn[1] = unReleasePks;
        return rtn;
    }
}

