/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.ClassTeamEntryInfo;
import com.kingdee.eas.mm.basedata.ExpandStrategyEnum;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryInfo;
import com.kingdee.eas.mm.basedata.ProductionFormulaInfo;
import com.kingdee.eas.mm.basedata.SonLineExpandModeEnum;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.DBBatchUtil;
import com.kingdee.eas.mm.common.util.ProductionFormulaHelper;
import com.kingdee.eas.mm.common.util.ProductionStrategyHelper;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.common.util.StoreCommonUtil;
import com.kingdee.eas.mm.planning.LineCapabilityInfo;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.PLSExectionMSGInfo;
import com.kingdee.eas.mm.planning.SrcTypeEnum;
import com.kingdee.eas.mm.planning.app.CalcCapabilityHandler;
import com.kingdee.eas.mm.planning.app.PLSRunner;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PLSExpandRunner
extends PLSRunner {
    protected List srcList;
    protected Timestamp beginDate;
    protected Timestamp endDate;
    protected Map proOrderMap;
    protected ProductLinePAllotDefEntryCollection productLinePAllotDefEntryCollection;
    protected Map allocateMap;
    protected Map stockBaseQtyMap;
    protected Map yieldsByBOM;
    protected Map yieldsByFormula;
    protected Map lineLotMap;
    protected Map outputPeriod;
    protected Map trackNumberMap;
    protected Map lineNumMap;
    protected Map mmuPrecisions;
    protected Map mmuConvsRate;
    protected Map materialPlanInfos;
    protected Map materialMap;
    protected Map productLineMap;
    protected Map lineCaps;
    protected Map classTeams;
    protected String tempTableName;
    protected String tempBomTableName;
    protected String tempInitTableName;
    protected int batchControl;
    protected Map unitMap;
    protected Map formulaMap;
    protected boolean isToLow;
    protected CalcCapabilityHandler calcCapHandler;
    protected boolean isPrepare;

    public PLSExpandRunner(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, List pLSEntryList, String currVoucherID, Map proOrders, Timestamp beginDate, Timestamp endDate, PLSModelInfo pLSModelInfo) {
        this.ctx = ctx;
        this.storageOrgUnitInfo = storageOrgUnitInfo;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.voucherID = currVoucherID;
        this.srcList = pLSEntryList;
        this.proOrderMap = proOrders;
        this.lineSchedulingModelInfo = pLSModelInfo;
    }

    @Override
    protected void prepareData() throws BOSException, EASBizException {
        super.prepareData();
        this.trackNumberMap = new HashMap();
        this.formulaMap = new HashMap();
        int n = this.srcList.size();
        for (int i = 0; i < n; ++i) {
            PLSEntryInfo pLSEntry = (PLSEntryInfo)this.srcList.get(i);
            TrackNumberInfo trackNumberInfo = pLSEntry.getTrackNumber();
            String poEntryId = pLSEntry.getSourceBillEntryId();
            if (!this.trackNumberMap.containsKey(poEntryId)) {
                this.trackNumberMap.put(poEntryId, trackNumberInfo);
            }
            String productLineId = pLSEntry.getProductLine() == null ? "" : pLSEntry.getProductLine().getId().toString();
            String trackNumId = trackNumberInfo == null ? "" : trackNumberInfo.getId().toString();
            String formulaKey = pLSEntry.getMaterial().getId().toString() + "@" + productLineId + "@" + trackNumId;
            if (this.formulaMap.containsKey(formulaKey)) continue;
            this.formulaMap.put(formulaKey, pLSEntry.getFormula());
        }
        this.batchControl = this.lineSchedulingModelInfo.getBatchControl().getValue();
        this.productLinePAllotDefEntryCollection = PLSUtil.getProductLinePAllotDefForServer(this.ctx, this.lineSchedulingModelInfo.getProductLineAllocate().getId().toString());
        this.getAllocateMap();
        Set idSet = this.getNeededMaterialIds();
        if (idSet == null || idSet.size() <= 0) {
            this.isPrepare = false;
            return;
        }
        this.isPrepare = true;
        this.materialMap = PLSUtil.getMaterialMapForServer(this.ctx, idSet);
        if (this.materialMap != null && this.materialMap.size() > 0) {
            Set keySet = this.materialMap.keySet();
            int i = 0;
            int n2 = this.materialMap.size();
            MaterialInfo[] materialInfos = new MaterialInfo[n2];
            Iterator ite = keySet.iterator();
            while (ite.hasNext()) {
                materialInfos[i++] = (MaterialInfo)this.materialMap.get(ite.next());
            }
            SCMEntryDataVO voResult = PLSUtil.loadComplexDataForServer(this.ctx, this.storageOrgUnitInfo, materialInfos);
            if (voResult != null) {
                this.materialPlanInfos = voResult.getMaterialPlanInfos();
                if (this.materialPlanInfos != null) {
                    MeasureUnitInfo[] unitInfos = new MeasureUnitInfo[n2];
                    MeasureUnitInfo[] baseUnitInfos = new MeasureUnitInfo[n2];
                    HashSet<String> unitIds = new HashSet<String>();
                    for (int j = 0; j < n2; ++j) {
                        String mpKey = materialInfos[j].getId().toString() + this.storageOrgUnitInfo.getId().toString();
                        MaterialPlanInfo mpInfo = (MaterialPlanInfo)this.materialPlanInfos.get(mpKey);
                        unitInfos[j] = mpInfo.getProductUnit();
                        baseUnitInfos[j] = materialInfos[j].getBaseUnit();
                        unitIds.add(mpInfo.getProductUnit().getId().toString());
                        unitIds.add(materialInfos[j].getBaseUnit().getId().toString());
                    }
                    voResult = PLSUtil.getMmuPrecisionForServer(this.ctx, this.storageOrgUnitInfo, materialInfos, unitInfos, baseUnitInfos);
                    if (voResult != null) {
                        this.mmuConvsRate = voResult.getMmuConvsRate();
                        this.mmuPrecisions = voResult.getMmuPrecisions();
                    }
                    this.unitMap = PLSUtil.getUnitMapForServer(this.ctx, unitIds);
                }
            }
        }
        if (this.lineSchedulingModelInfo.getExpandStrategy().equals((Object)ExpandStrategyEnum.ByBOMExpand)) {
            this.getYieldByBOM(idSet);
        } else {
            this.getYieldByFormula(idSet);
        }
        this.getLineLots(idSet);
        this.beginDate = PLSUtil.getDateByLeadTime(this.beginDate, 2, -1);
        this.endDate = PLSUtil.getDateByLeadTime(this.endDate, 2, 1);
        this.calcCapHandler = new CalcCapabilityHandler(this.ctx, this.storageOrgUnitInfo, this.lineSchedulingModelInfo, this.beginDate, this.endDate, this.featureNum, this.productLineMap, this.voucherID);
        this.lineCaps = this.calcCapHandler.getLineCaps();
        boolean isCalcStock = this.lineSchedulingModelInfo.isIsSonLinePlanCalcStock();
        if (isCalcStock) {
            this.getStockQty(idSet);
        }
        this.isToLow = this.lineSchedulingModelInfo.getSonLineExpandMode().equals((Object)SonLineExpandModeEnum.WholeTierExpand) ? false : (this.lineSchedulingModelInfo.getSonLineExpandMode().equals((Object)SonLineExpandModeEnum.WholeToLowTierExpand) ? true : true);
    }

    @Override
    protected void running() throws BOSException, EASBizException {
        this.prepareData();
        if (this.isPrepare) {
            if (this.lineSchedulingModelInfo.getExpandStrategy().equals((Object)ExpandStrategyEnum.ByBOMExpand)) {
                this.bomExpand();
            } else if (this.lineSchedulingModelInfo.getExpandStrategy().equals((Object)ExpandStrategyEnum.ByProductionFormulaExpand)) {
                this.formulaExpand();
            }
        }
    }

    protected Set getNeededMaterialIds() throws EASBizException, BOSException {
        Set idSet = new HashSet();
        if (this.lineSchedulingModelInfo.getExpandStrategy().equals((Object)ExpandStrategyEnum.ByBOMExpand)) {
            HashSet<String> materialIDSet = new HashSet<String>();
            HashSet<String> materialTrackIdSet = new HashSet<String>();
            int n = this.srcList.size();
            for (int i = 0; i < n; ++i) {
                PLSEntryInfo pLSEntry = (PLSEntryInfo)this.srcList.get(i);
                String materialID = pLSEntry.getMaterial().getId().toString();
                String trackNumberID = pLSEntry.getTrackNumber() == null || pLSEntry.getTrackNumber().getId() == null ? "" : pLSEntry.getTrackNumber().getId().toString();
                String plcEntryId = pLSEntry.getPlcEntryId();
                materialIDSet.add(materialID);
                materialTrackIdSet.add(materialID + "@" + plcEntryId + "@" + trackNumberID);
            }
            this.tempInitTableName = this.createTempTable(this.createInitTableSQL());
            this.tempBomTableName = this.createTempTable(this.createBomTableSQL());
            this.initTempBomTable(materialTrackIdSet);
            idSet = this.getMaterialIdsByBomExpand(materialIDSet);
        } else if (this.lineSchedulingModelInfo.getExpandStrategy().equals((Object)ExpandStrategyEnum.ByProductionFormulaExpand)) {
            HashSet<String> keySet = new HashSet<String>();
            int n = this.srcList.size();
            for (int i = 0; i < n; ++i) {
                PLSEntryInfo pLSEntry = (PLSEntryInfo)this.srcList.get(i);
                String materialID = pLSEntry.getMaterial().getId().toString();
                String productLineID = pLSEntry.getProductLine().getId().toString();
                String plcEntryId = pLSEntry.getPlcEntryId();
                String trackNumberID = pLSEntry.getTrackNumber() == null || pLSEntry.getTrackNumber().getId() == null ? "" : pLSEntry.getTrackNumber().getId().toString();
                keySet.add(materialID + "@" + productLineID + "@" + plcEntryId + "@" + trackNumberID);
            }
            if (this.lineSchedulingModelInfo.isIsSonLinePlanCalcStock()) {
                this.tempBomTableName = this.createTempTable(this.createBomTableSQL());
            }
            idSet = this.getMaterialIdsByFormulaExpand(keySet);
        }
        return idSet;
    }

    private void initTempBomTable(Set materialTrackIdSet) throws BOSException {
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuffer sqlBuffer = new StringBuffer();
        for (String key : materialTrackIdSet) {
            String[] idStr = key.split("@");
            String trackNumberID = null;
            String materialID = idStr[0];
            String plcEntryId = idStr[1];
            if (idStr.length == 3) {
                trackNumberID = idStr[2];
            }
            sqlBuffer.setLength(0);
            sqlBuffer.append("insert into ").append(this.tempInitTableName).append(" (FMaterialID,FTrackID,FPLCEntryId) ").append(" values ('").append(materialID).append("',").append(trackNumberID == null ? null : "'" + trackNumberID + "'").append(",'").append(plcEntryId).append("')");
            sqlList.add(sqlBuffer.toString());
            sqlBuffer.setLength(0);
            sqlBuffer.append("insert into ").append(this.tempBomTableName).append(" (FMaterialID,FAttr,FTrackID,FStrategyID,FParentBomID,FParentID,FPLCEntryId) ").append(" (select FMaterialID,FMaterialattr,").append(trackNumberID == null ? null : "'" + trackNumberID + "'").append(",FManufactureStrategyID,null,null,'").append(plcEntryId).append("' from t_bd_materialplan where FMaterialID='").append(materialID).append("' and FOrgUnit='").append(this.storageOrgUnitInfo.getId().toString()).append("')");
            sqlList.add(sqlBuffer.toString());
        }
        if (sqlList.size() > 0) {
            DBBatchUtil.executeBatch((Context)this.ctx, sqlList);
        }
    }

    protected void getYieldByBOM(Set idSet) throws BOSException {
        this.yieldsByBOM = new HashMap();
        String idStr = StringUtils.arrayToString((Object[])idSet.toArray(), (String)"','");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select bom.fstorageorgunitid,bom.fmaterialid,bom.FYield as FYield from t_mm_bom bom ");
        sqlBuffer.append(" where bom.fid in (select FParentBomID from " + this.tempBomTableName + ") ");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
        try {
            while (rows.next()) {
                String storageorgUnitId = rows.getString("fstorageorgunitid");
                String materialId = rows.getString("fmaterialid");
                BigDecimal yield = rows.getBigDecimal("FYield");
                String key = storageorgUnitId + materialId;
                this.yieldsByBOM.put(key, yield);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void getYieldByFormula(Set idSet) throws BOSException {
        this.yieldsByFormula = new HashMap();
        if (this.formulaMap.size() < 1) {
            return;
        }
        StringBuffer ids = new StringBuffer();
        ProductionFormulaInfo formula = null;
        Object[] formulas = this.formulaMap.values().toArray();
        for (int i = 0; i < formulas.length; ++i) {
            formula = (ProductionFormulaInfo)formulas[i];
            if (formula == null || formula.getId() == null) continue;
            ids.append("'").append(formula.getId().toString()).append("',");
        }
        if (ids.length() > 0) {
            ids = ids.deleteCharAt(ids.length() - 1);
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select formula.FSTORAGEORGUNITID,formula.FPRODUCTLINEID,formula.fmaterialid,formula.FYield as FYield from T_MM_PRODUCTIONFORMULA formula ");
        sqlBuffer.append(" where formula.fid in (" + ids.toString() + ") ");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
        try {
            while (rows.next()) {
                String storageorgUnitId = rows.getString("FSTORAGEORGUNITID");
                String productLineId = rows.getString("FPRODUCTLINEID");
                String materialId = rows.getString("fmaterialid");
                BigDecimal yield = rows.getBigDecimal("FYield");
                String key = storageorgUnitId + productLineId + materialId;
                this.yieldsByFormula.put(key, yield);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void getAllocateMap() throws BOSException, EASBizException {
        this.productLineMap = new HashMap();
        this.allocateMap = new HashMap();
        int n = this.productLinePAllotDefEntryCollection.size();
        for (int i = 0; i < n; ++i) {
            ProductLinePAllotDefEntryInfo entryInfo = this.productLinePAllotDefEntryCollection.get(i);
            if (!entryInfo.getMaterialPlan().getPlanningMode().equals((Object)PlanningModeEnum.MRP) || !entryInfo.getMaterialPlan().getMaterialAttr().equals((Object)MaterialAttributeEnum.FABRICATEDPART) || !entryInfo.getMaterialPlan().isIsProductLinePlan()) continue;
            MaterialInfo material = entryInfo.getMaterial();
            ProductLinePAllotDefEntryRuleEntryInfo ruleEntryInfo = entryInfo.getRuleEntrys().get(0);
            ProductLineInfo productLine = ruleEntryInfo.getProductLine();
            if (!productLine.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"LINDINALLOTDEFNOAUDIT_DESC");
                int exceNum = 202;
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"LINDINALLOTDEFNOAUDIT_DETAIL", (String[])new String[]{material.getNumber(), material.getName(), productLine.getNumber(), productLine.getName()});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
            }
            this.allocateMap.put(entryInfo.getMaterial().getId().toString(), productLine);
            this.productLineMap.put(productLine.getId().toString(), productLine);
        }
    }

    protected void getStockQty(Set idSet) throws BOSException, EASBizException {
        this.initStockQty(idSet);
        this.calcQtyFromProductionOrder(idSet);
        this.calcQtyFromPLS(idSet);
    }

    protected Set getMaterialIdsByBomExpand(Set materialIDSet) throws BOSException, EASBizException {
        HashSet<String> returnSet = new HashSet<String>();
        try {
            String idStr = StringUtils.arrayToString((Object[])materialIDSet.toArray(), (String)"','");
            StringBuffer sqlBuffer = new StringBuffer();
            ArrayList<String> sqlList = new ArrayList<String>();
            sqlBuffer.append("update ").append(this.tempBomTableName).append(" bomt set FTrackID=(select init.FTrackID from ").append(this.tempInitTableName).append(" init where init.FPLCEntryId=bomt.FPLCEntryId) where FTrackID is null");
            sqlList.add(sqlBuffer.toString());
            sqlBuffer.setLength(0);
            sqlBuffer.append("insert into ").append(this.tempBomTableName);
            sqlBuffer.append(" (FMaterialID,FAttr,FTrackID,FStrategyID,FParentBomID,FParentID,FPLCEntryId) ");
            sqlBuffer.append(" (");
            sqlBuffer.append(" select distinct bomentry.fmaterialid,materialplan.fmaterialattr,bomt.FTrackID,materialplan.FManufactureStrategyID,").append("bom.fid,bom.fmaterialid,bomt.FPLCEntryId ");
            sqlBuffer.append(" from t_mm_bom bom inner join t_mm_bomentry bomentry on bom.fid = bomentry.fparentid ");
            sqlBuffer.append(" inner join t_bd_materialplan materialplan on bomentry.fmaterialinventoid = materialplan.fid ");
            sqlBuffer.append(" left join T_MM_OrderBOMPT ordertrack on ordertrack.forderid = bom.fid");
            sqlBuffer.append(" left join ").append(this.tempBomTableName).append(" bomt on bomt.FMaterialID = bom.fmaterialid");
            sqlBuffer.append(" where bom.fmaterialid in ('" + idStr + "') and bom.fstorageorgunitid = '" + this.storageOrgUnitInfo.getId().toString() + "'");
            sqlBuffer.append(" and ((materialplan.fmaterialattr = 10030 and materialplan.fplanningmode = 3 and materialplan.fisproductlineplan = 1) or (materialplan.fmaterialattr = 10020)) ");
            sqlBuffer.append(" and bom.fbomType = 45 and bom.fusageType = 10 and bom.fbasestatus = 4 and materialplan.fstatus = 1 ");
            sqlBuffer.append(" and bomt.FTrackID is not null and bomt.FStrategyID in ('").append("fpPxtypCS/ihJ30GjB/UJtg0uEU=").append("','").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYbemEdG9ngQKjAYj0V1dg0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("') and ordertrack.FTrackID=bomt.FTrackID");
            sqlBuffer.append(")");
            sqlList.add(sqlBuffer.toString());
            DBBatchUtil.executeBatch((Context)this.ctx, sqlList);
            sqlBuffer.setLength(0);
            sqlBuffer.append("insert into ").append(this.tempBomTableName);
            sqlBuffer.append(" (FMaterialID,FAttr,FTrackID,FStrategyID,FParentBomID,FParentID,FPLCEntryId) ");
            sqlBuffer.append(" (");
            sqlBuffer.append(" select distinct bomentry.fmaterialid,materialplan.fmaterialattr,null,materialplan.FManufactureStrategyID,").append("bom.fid,bom.fmaterialid,bomt.FPLCEntryId ");
            sqlBuffer.append(" from t_mm_bom bom inner join t_mm_bomentry bomentry on bom.fid = bomentry.fparentid ");
            sqlBuffer.append(" inner join t_bd_materialplan materialplan on bomentry.fmaterialinventoid = materialplan.fid ");
            sqlBuffer.append(" left join ").append(this.tempBomTableName).append(" bomt on bomt.FMaterialID = bom.fmaterialid");
            sqlBuffer.append(" where bom.fmaterialid in ('" + idStr + "') and bom.fstorageorgunitid = '" + this.storageOrgUnitInfo.getId().toString() + "'");
            sqlBuffer.append(" and ((materialplan.fmaterialattr = 10030 and materialplan.fplanningmode = 3 and materialplan.fisproductlineplan = 1) or (materialplan.fmaterialattr = 10020)) ");
            sqlBuffer.append(" and bom.fbomType = 40 and bom.fusageType = 10 and bom.fbasestatus = 4 and materialplan.fstatus = 1 ");
            sqlBuffer.append(" and bomentry.feffectivedate <= now() and bomentry.fdisabledate >=  now() ");
            sqlBuffer.append(" and bomentry.fmaterialid not in (select FMaterialID from ").append(this.tempBomTableName).append(" bomtemp where bomtemp.fmaterialid = bomentry.fmaterialid and bomtemp.FPLCEntryId = bomt.FPLCEntryId) ");
            sqlBuffer.append(" and bom.fmaterialid not in (select FParentID from ").append(this.tempBomTableName).append(" bomtemp2 where bomtemp2.FPLCEntryId = bomt.FPLCEntryId and FParentBomID is not null)) ");
            DbUtil.execute((Context)this.ctx, (String)sqlBuffer.toString());
            sqlBuffer.setLength(0);
            sqlBuffer.append("select FMaterialID,FAttr from ").append(this.tempBomTableName).append(" where FParentID in ('").append(idStr).append("')");
            IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
            if (rows.size() > 0) {
                HashSet<String> idSet = new HashSet<String>();
                while (rows.next()) {
                    String materialID = rows.getString("FMaterialID");
                    int materialAttr = rows.getInt("FAttr");
                    if (10020 == materialAttr) {
                        idSet.add(materialID);
                        continue;
                    }
                    idSet.add(materialID);
                    returnSet.add(materialID);
                }
                Set tempSet = this.getMaterialIdsByBomExpand(idSet);
                Iterator ite = tempSet.iterator();
                while (ite.hasNext()) {
                    returnSet.add((String)ite.next());
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnSet;
    }

    protected Set getMaterialIdsByFormulaExpand(Set keySet) throws BOSException, EASBizException {
        HashSet<String> returnSet = new HashSet<String>();
        try {
            for (String key : keySet) {
                String[] idStr = key.split("@");
                String materialID = idStr[0];
                String productLineID = idStr[1];
                String plcEntryID = idStr[2];
                String trackNumberID = "";
                if (idStr.length == 4) {
                    trackNumberID = idStr[3];
                }
                String formulaKey = materialID + "@" + productLineID + "@" + trackNumberID;
                MaterialInfo material = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                ProductLineInfo productLine = ProductLineFactory.getLocalInstance((Context)this.ctx).getProductLineInfo((IObjectPK)new ObjectUuidPK(productLineID));
                TrackNumberInfo trackNumber = trackNumberID == "" ? null : TrackNumberFactory.getLocalInstance((Context)this.ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackNumberID));
                ProductionFormulaInfo formula = null;
                if (this.formulaMap.get(formulaKey) != null) {
                    formula = (ProductionFormulaInfo)this.formulaMap.get(formulaKey);
                }
                if (formula == null) {
                    formula = ProductionFormulaHelper.getDefaultFormula((Context)this.ctx, null, (Object)material, (Object)productLine, (Object)trackNumber, (Object)this.storageOrgUnitInfo, null);
                }
                if (formula != null) {
                    StringBuffer sqlBuffer = new StringBuffer();
                    sqlBuffer.append(" select distinct formulaentry.fmaterialid ");
                    sqlBuffer.append(" from T_MM_PRODUCTIONFORMULA formula inner join T_MM_PRODUCTIONFORMULAENTRY formulaentry on formula.fid = formulaentry.fparentid ");
                    sqlBuffer.append(" inner join t_bd_materialplan materialplan on formulaentry.FMATERIALINVENTOYID = materialplan.fid ");
                    sqlBuffer.append(" where formula.fid = '" + formula.getId().toString() + "' ");
                    sqlBuffer.append(" and materialplan.fmaterialattr = 10030 and materialplan.fplanningmode = 3 and materialplan.fisproductlineplan = 1 ");
                    sqlBuffer.append(" and materialplan.fstatus = 1 ");
                    sqlBuffer.append(" and formulaentry.feffectivedate <= now() and formulaentry.fdisabledate >=  now() ");
                    IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
                    if (rows.size() > 0) {
                        HashSet<String> idSet = new HashSet<String>();
                        while (rows.next()) {
                            String mateID = rows.getString("fmaterialid");
                            returnSet.add(mateID);
                            this.formulaMap.put(formulaKey, formula);
                            String proLineID = "";
                            ProductLineInfo productLineInfo = (ProductLineInfo)this.allocateMap.get(mateID);
                            if (productLineInfo == null || productLineInfo.getId() == null) {
                                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOINALLOTDEF_DESC");
                                int exceNum = 201;
                                MaterialInfo subMaterial = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(mateID));
                                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOINALLOTDEF_DETAIL", (String[])new String[]{subMaterial.getNumber(), subMaterial.getName()});
                                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                                this.exceptions.add(exceInfo);
                                continue;
                            }
                            proLineID = productLineInfo.getId().toString();
                            idSet.add(mateID + "@" + proLineID + "@" + plcEntryID + "@" + trackNumberID);
                        }
                        Set tempSet = this.getMaterialIdsByFormulaExpand(idSet);
                        Iterator it = tempSet.iterator();
                        while (it.hasNext()) {
                            returnSet.add((String)it.next());
                        }
                    }
                }
                if (this.tempBomTableName == null) continue;
                StringBuffer insertSql = new StringBuffer();
                insertSql.append("insert into ").append(this.tempBomTableName).append(" (FMaterialID,FTrackID,FStrategyID,FProductLineID,FFormulaID) ").append(" (select FMaterialID,").append("".equals(trackNumberID) ? null : "'" + trackNumberID + "'").append(",FManufactureStrategyID,'").append(productLineID).append("',").append(formula == null ? null : "'" + formula.getId().toString() + "'").append(" from t_bd_materialplan where FMaterialID='").append(materialID).append("' and FOrgUnit='").append(this.storageOrgUnitInfo.getId().toString()).append("'").append(" and not exists (").append(" select FMaterialID from ").append(this.tempBomTableName).append(" where FMaterialID='").append(materialID).append("' and FTrackID ").append("".equals(trackNumberID) ? "is null" : "='" + trackNumberID + "'").append("))");
                DbUtil.execute((Context)this.ctx, (String)insertSql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnSet;
    }

    protected void initStockQty(Set materialIDSet) throws BOSException, EASBizException {
        this.stockBaseQtyMap = new HashMap();
        HashSet<String> storeTypeSet = new HashSet<String>();
        HashSet<String> storeStatusSet = new HashSet<String>();
        try {
            ResultSet rs = StoreCommonUtil.getPlanVersionSetStoretypeAndStorestate((Context)this.ctx, (String)StoreCommonUtil.PLANVERSION_901, (String)this.storageOrgUnitInfo.getId().toString());
            while (rs.next()) {
                storeTypeSet.add(rs.getString("fstoretype"));
                storeStatusSet.add(rs.getString("fstorestate"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String idStr = StringUtils.arrayToString((Object[])materialIDSet.toArray(), (String)"','");
        String storeTypeID = StringUtils.arrayToString((Object[])storeTypeSet.toArray(), (String)"','");
        String storeStatusID = StringUtils.arrayToString((Object[])storeStatusSet.toArray(), (String)"','");
        StringBuffer sqlBuffer = new StringBuffer();
        if (this.tempBomTableName != null) {
            sqlBuffer.append("select inv.fmaterialid,bomt.FTrackId as trackId,sum(inv.fbaseqty-inv.flockbaseqty) as baseQty ");
            sqlBuffer.append("from T_IM_INVENTORY inv ");
            sqlBuffer.append("left join ").append(this.tempBomTableName).append(" bomt on inv.fmaterialid=bomt.fmaterialid ");
            sqlBuffer.append("where inv.fmaterialid in ('" + idStr + "') ");
            sqlBuffer.append("and inv.FStorageOrgUnitID='").append(this.storageOrgUnitInfo.getId().toString()).append("' ");
            sqlBuffer.append("and inv.fstoretypeid in ('" + storeTypeID + "') ");
            sqlBuffer.append("and inv.fstorestatusid in ('" + storeStatusID + "') ");
            sqlBuffer.append(" and ((bomt.FTrackID is not null and bomt.FStrategyID in ('").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("') and inv.FTrackNumberID=bomt.FTrackID) ").append(" or (bomt.FStrategyID not in ('").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("') and inv.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("')) ");
            sqlBuffer.append("group by inv.fmaterialid,bomt.FTrackId ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
        try {
            while (rows.next()) {
                String materialId = rows.getString("fmaterialid");
                String trackId = "";
                if (rows.getObject("trackId") != null) {
                    trackId = rows.getString("trackId");
                }
                BigDecimal baseQty = rows.getBigDecimal("baseQty");
                this.stockBaseQtyMap.put(materialId + "@" + trackId, baseQty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void calcQtyFromProductionOrder(Set materialIDSet) throws BOSException, EASBizException {
        String idStr = StringUtils.arrayToString((Object[])materialIDSet.toArray(), (String)"','");
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select entrys.fmaterialid,bomt.FtrackId as trackId,sum(entrys.fbaseqty-entrys.fbasesendouttotalqty+entrys.FBaseUntreadTotalQty) as  fbaseqty ");
            sb.append("from t_mm_productionordersentry entrys inner join t_mm_productionorder head on head.fid = entrys.fparentid ");
            sb.append("left join ").append(this.tempBomTableName).append(" bomt on bomt.FMaterialID=entrys.FMaterialID ");
            sb.append("where entrys.fmaterialid in ('" + idStr + "') ");
            sb.append("and ((head.fSourceBillTypeid = 'OC9YcwEhEADgAAApfwAAAUY+1VI=' and head.fbasestatus = 2) or head.fbasestatus = 4 or head.fbasestatus = 5) ");
            sb.append("group by entrys.fmaterialid,bomt.FTrackId ");
            IRowSet sbRows = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            while (sbRows.next()) {
                String materialId = sbRows.getString("fmaterialid");
                String trackId = "";
                if (sbRows.getObject("trackId") != null) {
                    trackId = sbRows.getString("trackId");
                }
                BigDecimal baseQty = sbRows.getBigDecimal("fbaseqty");
                String stockKey = materialId + "@" + trackId;
                if (!this.stockBaseQtyMap.containsKey(stockKey)) continue;
                BigDecimal stockBaseQty = (BigDecimal)this.stockBaseQtyMap.get(stockKey);
                this.stockBaseQtyMap.put(stockKey, stockBaseQty.subtract(baseQty));
            }
            StringBuffer ssb = new StringBuffer();
            ssb.append("select head.fmaterialid,bomt.FtrackId as trackId,sum(head.fbaseqty*bom.fyield/100-head.fbasestocktotalqty) as  fbaseqty ");
            ssb.append("from t_mm_productionorder head inner join t_mm_bom bom on head.fmaterialid = bom.fmaterialid  and bom.fstorageorgunitid = head.fstorageorgunitid ");
            ssb.append("left join ").append(this.tempBomTableName).append(" bomt on bomt.FParentID = head.fmaterialid ");
            ssb.append("where head.fmaterialid in ('" + idStr + "') ");
            ssb.append("and ((head.fSourceBillTypeid = 'OC9YcwEhEADgAAApfwAAAUY+1VI=' and head.fbasestatus = 2)  or head.fbasestatus = 4 or head.fbasestatus = 5) ");
            ssb.append("and bom.FID=bomt.FParentBomID ");
            ssb.append("group by head.fmaterialid,bomt.FTrackId ");
            IRowSet ssbRows = DbUtil.executeQuery((Context)this.ctx, (String)ssb.toString());
            while (ssbRows.next()) {
                String materialId = ssbRows.getString("fmaterialid");
                String trackId = "";
                if (ssbRows.getObject("trackId") != null) {
                    trackId = ssbRows.getString("trackId");
                }
                BigDecimal baseQty = ssbRows.getBigDecimal("fbaseqty");
                String stockKey = materialId + "@" + trackId;
                if (!this.stockBaseQtyMap.containsKey(stockKey)) continue;
                BigDecimal stockBaseQty = (BigDecimal)this.stockBaseQtyMap.get(stockKey);
                this.stockBaseQtyMap.put(stockKey, stockBaseQty.add(baseQty));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void calcQtyFromPLS(Set materialIDSet) throws BOSException, EASBizException {
        try {
            BigDecimal baseQty;
            String materialID;
            String storageOrgUnitID;
            HashMap orgMap;
            IRowSet rows;
            StringBuffer sqlBuffer;
            Map<String, BigDecimal> calcQtyMap = new HashMap();
            if (this.lineSchedulingModelInfo.getExpandStrategy().equals((Object)ExpandStrategyEnum.ByBOMExpand)) {
                sqlBuffer = new StringBuffer();
                sqlBuffer.append("select head.fstorageorgunitid,entrys.fmaterialid,sum(entrys.fbaseqty) as  fbaseqty ");
                sqlBuffer.append("from t_mm_plsentry entrys inner join t_mm_productionlinescheduling head on head.fid = entrys.fparent ");
                sqlBuffer.append("where entrys.fisexpand = 1 and (entrys.fbasestatus = 2 or entrys.fbasestatus = 4) ");
                sqlBuffer.append("and head.fstorageorgunitid='").append(this.storageOrgUnitInfo.getId().toString()).append("' ");
                sqlBuffer.append("and head.fid <> '" + this.voucherID + "' ");
                sqlBuffer.append("group by head.fstorageorgunitid,entrys.fmaterialid ");
                rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
                orgMap = new HashMap();
                while (rows.next()) {
                    Map<String, BigDecimal> materialMap;
                    storageOrgUnitID = rows.getString("fstorageorgunitid");
                    materialID = rows.getString("fmaterialid");
                    baseQty = rows.getBigDecimal("fbaseqty");
                    if (orgMap.containsKey(storageOrgUnitID)) {
                        materialMap = (Map)orgMap.get(storageOrgUnitID);
                        materialMap.put(materialID, baseQty);
                        orgMap.put(storageOrgUnitID, materialMap);
                        continue;
                    }
                    materialMap = new HashMap();
                    materialMap.put(materialID, baseQty);
                    orgMap.put(storageOrgUnitID, materialMap);
                }
                calcQtyMap = this.calcQtyByBomExpand(orgMap, materialIDSet);
            } else if (this.lineSchedulingModelInfo.getExpandStrategy().equals((Object)ExpandStrategyEnum.ByProductionFormulaExpand)) {
                sqlBuffer = new StringBuffer();
                sqlBuffer.append("select head.fstorageorgunitid,entrys.fproductlineid,entrys.fmaterialid,sum(entrys.fbaseqty) as  fbaseqty ");
                sqlBuffer.append("from t_mm_plsentry entrys inner join t_mm_productionlinescheduling head on head.fid = entrys.fparent ");
                sqlBuffer.append("where entrys.fisexpand = 1 and (entrys.fbasestatus = 2 or entrys.fbasestatus = 4) ");
                sqlBuffer.append("and head.fstorageorgunitid='").append(this.storageOrgUnitInfo.getId().toString()).append("' ");
                sqlBuffer.append("and head.fid <> '" + this.voucherID + "' ");
                sqlBuffer.append("group by head.fstorageorgunitid,entrys.fproductlineid,entrys.fmaterialid ");
                rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
                orgMap = new HashMap();
                while (rows.next()) {
                    Map<String, BigDecimal> tempMap;
                    storageOrgUnitID = rows.getString("fstorageorgunitid");
                    materialID = rows.getString("fmaterialid");
                    String productLineID = rows.getString("fproductlineid");
                    BigDecimal baseQty2 = rows.getBigDecimal("fbaseqty");
                    String key = productLineID + "@" + materialID;
                    if (orgMap.containsKey(storageOrgUnitID)) {
                        tempMap = (Map)orgMap.get(storageOrgUnitID);
                        tempMap.put(key, baseQty2);
                        orgMap.put(storageOrgUnitID, tempMap);
                        continue;
                    }
                    tempMap = new HashMap();
                    tempMap.put(key, baseQty2);
                    orgMap.put(storageOrgUnitID, tempMap);
                }
                calcQtyMap = this.calcQtyByFormulaExpand(orgMap, materialIDSet);
            }
            sqlBuffer = new StringBuffer();
            sqlBuffer.append("select entrys.fmaterialid,sum(entrys.fbaseqty) as  fbaseqty ");
            sqlBuffer.append("from t_mm_plsentry entrys inner join t_mm_productionlinescheduling head on head.fid = entrys.fparent ");
            sqlBuffer.append("where entrys.fissubplan = 1 and (entrys.fbasestatus = 2 or entrys.fbasestatus = 4) ");
            sqlBuffer.append("and head.fid <> '" + this.voucherID + "' ");
            sqlBuffer.append("group by entrys.fmaterialid ");
            rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
            while (rows.next()) {
                String materialID2 = rows.getString("fmaterialid");
                BigDecimal baseQty3 = rows.getBigDecimal("fbaseqty");
                if (!calcQtyMap.containsKey(materialID2)) continue;
                BigDecimal tempQty = (BigDecimal)calcQtyMap.get(materialID2);
                tempQty = tempQty.subtract(baseQty3);
                calcQtyMap.put(materialID2, tempQty);
            }
            if (calcQtyMap != null && calcQtyMap.size() > 0) {
                Set keySet = calcQtyMap.keySet();
                for (String stockKey : keySet) {
                    baseQty = (BigDecimal)calcQtyMap.get(stockKey);
                    if (!this.stockBaseQtyMap.containsKey(stockKey)) continue;
                    BigDecimal stockBaseQty = (BigDecimal)this.stockBaseQtyMap.get(stockKey);
                    this.stockBaseQtyMap.put(stockKey, stockBaseQty.subtract(baseQty));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Map calcQtyByBomExpand(Map orgMap, Set materialIDSet) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        try {
            if (orgMap != null && orgMap.size() > 0) {
                Map tempMap;
                Set keySet = orgMap.keySet();
                HashMap<String, Map<String, BigDecimal>> phantomPartMap = new HashMap<String, Map<String, BigDecimal>>();
                for (String storageOrgUnitID : keySet) {
                    Map materialMap = (Map)orgMap.get(storageOrgUnitID);
                    String idStr = StringUtils.arrayToString((Object[])materialMap.keySet().toArray(), (String)"','");
                    StringBuffer sqlBuffer = new StringBuffer();
                    sqlBuffer.append(" select bom.fmaterialid as parentMaterialID,bomt.FtrackId as trackId,bom.fproductbaseqty as parentBaseQty,materialplan.fmaterialattr as materialAttr, ");
                    sqlBuffer.append(" bomentry.fmaterialid as childMaterialID,bomentry.fbaseproductrate as baseProductRate,");
                    sqlBuffer.append(" bomentry.fproportion as proportion,bomentry.fconsumefixbaseqty as consumeFixBaseQty,bomentry.fconsumetype as consumeType ");
                    sqlBuffer.append(" from t_mm_bom bom inner join t_mm_bomentry bomentry on bom.fid = bomentry.fparentid ");
                    sqlBuffer.append(" inner join t_bd_materialplan materialplan on bomentry.fmaterialinventoid = materialplan.fid ");
                    sqlBuffer.append(" left join ").append(this.tempBomTableName).append(" bomt on bomt.FParentID = bom.fmaterialid");
                    sqlBuffer.append(" where bom.fmaterialid in ('" + idStr + "') and bom.fstorageorgunitid = '" + storageOrgUnitID + "'");
                    sqlBuffer.append(" and bomt.FParentBomID=bom.FID");
                    IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
                    if (rows.size() <= 0) continue;
                    while (rows.next()) {
                        String parentMaterialID = rows.getString("parentMaterialID");
                        BigDecimal parentBaseQty = rows.getBigDecimal("parentBaseQty");
                        String childMaterialID = rows.getString("childMaterialID");
                        String trackId = "";
                        if (rows.getObject("trackId") != null) {
                            trackId = rows.getString("trackId");
                        }
                        BigDecimal baseProductRate = rows.getBigDecimal("baseProductRate");
                        BigDecimal proportion = rows.getBigDecimal("proportion");
                        BigDecimal consumeFixBaseQty = rows.getBigDecimal("consumeFixBaseQty");
                        int consumeType = rows.getInt("consumeType");
                        int materialAttr = rows.getInt("materialAttr");
                        String stockKey = childMaterialID + "@" + trackId;
                        BigDecimal baseQty = (BigDecimal)materialMap.get(parentMaterialID);
                        BigDecimal childBaseQty = consumeType == 20 ? baseQty.multiply(consumeFixBaseQty.divide(parentBaseQty, 8, 4)) : baseQty.multiply(proportion.divide(PLSConstant.HUNDRED, 8, 4)).multiply(baseProductRate);
                        if (10020 == materialAttr) {
                            Map<String, BigDecimal> tempMap2;
                            if (phantomPartMap.containsKey(storageOrgUnitID)) {
                                tempMap2 = (Map)phantomPartMap.get(storageOrgUnitID);
                                if (tempMap2.containsKey(childMaterialID)) {
                                    BigDecimal tempQty = (BigDecimal)tempMap2.get(childMaterialID);
                                    tempQty = tempQty.add(childBaseQty);
                                    tempMap2.put(childMaterialID, tempQty);
                                } else {
                                    tempMap2.put(childMaterialID, childBaseQty);
                                }
                                phantomPartMap.put(storageOrgUnitID, tempMap2);
                                continue;
                            }
                            tempMap2 = new HashMap();
                            tempMap2.put(childMaterialID, childBaseQty);
                            phantomPartMap.put(storageOrgUnitID, tempMap2);
                            continue;
                        }
                        if (!materialIDSet.contains(childMaterialID)) continue;
                        BigDecimal yield = PLSConstant.HUNDRED;
                        String key = storageOrgUnitID + childMaterialID;
                        if (this.yieldsByBOM.containsKey(key)) {
                            yield = (BigDecimal)this.yieldsByBOM.get(key);
                        }
                        yield = yield.divide(PLSConstant.HUNDRED, 8, 4);
                        childBaseQty = childBaseQty.divide(yield, 8, 4);
                        if (returnMap.containsKey(stockKey)) {
                            BigDecimal tempQty = (BigDecimal)returnMap.get(stockKey);
                            tempQty = tempQty.add(childBaseQty);
                            returnMap.put(stockKey, tempQty);
                            continue;
                        }
                        returnMap.put(stockKey, childBaseQty);
                    }
                }
                if (phantomPartMap != null && phantomPartMap.size() > 0 && (tempMap = this.calcQtyByBomExpand(phantomPartMap, materialIDSet)) != null && tempMap.size() > 0) {
                    Set tempKeySet = tempMap.keySet();
                    for (String stockKey : tempKeySet) {
                        BigDecimal baseQty = (BigDecimal)tempMap.get(stockKey);
                        if (!returnMap.containsKey(stockKey)) continue;
                        BigDecimal tempQty = (BigDecimal)returnMap.get(stockKey);
                        tempQty = tempQty.add(baseQty);
                        returnMap.put(stockKey, tempQty);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }

    protected Map calcQtyByFormulaExpand(Map orgMap, Set materialIDSet) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        try {
            if (orgMap != null && orgMap.size() > 0) {
                for (String storageOrgUnitID : orgMap.keySet()) {
                    Map tempMap = (Map)orgMap.get(storageOrgUnitID);
                    Set keySet = tempMap.keySet();
                    for (String key : keySet) {
                        String[] idStr = key.split("@");
                        String materialID = idStr[1];
                        String productLineID = idStr[0];
                        StringBuffer sqlBuffer = new StringBuffer();
                        sqlBuffer.append(" select formula.fproductbaseqty as parentBaseQty, bomt.FtrackId as trackId,");
                        sqlBuffer.append(" formulaentry.fmaterialid as childMaterialID,formulaentry.fbaseproductrate as baseProductRate, ");
                        sqlBuffer.append(" formulaentry.fproportion as proportion,formulaentry.fconsumefixbaseqty as consumeFixBaseQty,formulaentry.fconsumetype as consumeType ");
                        sqlBuffer.append(" from T_MM_PRODUCTIONFORMULA formula inner join T_MM_PRODUCTIONFORMULAENTRY formulaentry on formula.fid = formulaentry.fparentid ");
                        sqlBuffer.append(" inner join t_bd_materialplan materialplan on formulaentry.FMATERIALINVENTOYID = materialplan.fid ");
                        sqlBuffer.append(" left join ").append(this.tempBomTableName).append(" bomt on bomt.FMaterialID = formula.fmaterialid ");
                        sqlBuffer.append(" where formula.FSTORAGEORGUNITID = '" + storageOrgUnitID + "' ");
                        sqlBuffer.append(" and formula.fmaterialid = '" + materialID + "' and formula.FPRODUCTLINEID = '" + productLineID + "' ");
                        sqlBuffer.append(" and materialplan.fmaterialattr = 10030 and materialplan.fplanningmode = 3 and materialplan.fisproductlineplan = 1 ");
                        sqlBuffer.append(" and formulaentry.feffectivedate <= now() and formulaentry.fdisabledate >=  now() ");
                        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
                        if (rows.size() <= 0) continue;
                        while (rows.next()) {
                            BigDecimal parentBaseQty = rows.getBigDecimal("parentBaseQty");
                            String childMaterialID = rows.getString("childMaterialID");
                            String trackId = "";
                            if (rows.getObject("trackId") != null) {
                                trackId = rows.getString("trackId");
                            }
                            BigDecimal baseProductRate = rows.getBigDecimal("baseProductRate");
                            BigDecimal proportion = rows.getBigDecimal("proportion");
                            BigDecimal consumeFixBaseQty = rows.getBigDecimal("consumeFixBaseQty");
                            int consumeType = rows.getInt("consumeType");
                            String stockKey = childMaterialID + "@" + trackId;
                            if (!materialIDSet.contains(childMaterialID)) continue;
                            BigDecimal baseQty = (BigDecimal)tempMap.get(key);
                            BigDecimal childBaseQty = consumeType == 20 ? baseQty.multiply(consumeFixBaseQty.divide(parentBaseQty, 8, 4)) : baseQty.multiply(proportion.divide(PLSConstant.HUNDRED, 8, 4)).multiply(baseProductRate);
                            if (returnMap.containsKey(stockKey)) {
                                BigDecimal yield = PLSConstant.HUNDRED;
                                String yKey = storageOrgUnitID + childMaterialID;
                                if (this.yieldsByFormula.containsKey(yKey)) {
                                    yield = (BigDecimal)this.yieldsByFormula.get(yKey);
                                }
                                yield = yield.divide(PLSConstant.HUNDRED, 8, 4);
                                childBaseQty = childBaseQty.divide(yield, 8, 4);
                                BigDecimal tempQty = (BigDecimal)returnMap.get(stockKey);
                                tempQty = tempQty.add(childBaseQty);
                                returnMap.put(stockKey, tempQty);
                                continue;
                            }
                            returnMap.put(stockKey, childBaseQty);
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }

    protected void bomExpand() throws BOSException, EASBizException {
        this.tempTableName = this.createTempTable(this.createTableSQL());
        this.bomExpandFristStep();
        if (this.isToLow) {
            for (int level = 2; level <= 50 && this.bomExpandStep(level); ++level) {
            }
        }
        this.getPLSEntryInfoList();
        this.releaseTempTable();
    }

    protected void bomExpandFristStep() throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into ").append(this.tempTableName);
            stringBuffer.append(" (fPLSEntryid,fProductLineID,fWorkDate,fBeginTime,fEndTime,fClassTeamID,fMaterialID,fUnitID,fBaseUnitID,fQty,fBaseQty, ");
            stringBuffer.append(" fLevel,fparentID,fStorageOrgUnitID,flineNum,fproOrder,fplcEntryId,fpoEntryId) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
            batchStatement = conn.prepareStatement(stringBuffer.toString());
            HashMap pLSMap = new HashMap();
            int n = this.srcList.size();
            for (int i = 0; i < n; ++i) {
                List<PLSEntryInfo> tempList;
                PLSEntryInfo pLSEntry = (PLSEntryInfo)this.srcList.get(i);
                String key = pLSEntry.getMaterial().getId().toString();
                if (!pLSMap.containsKey(key)) {
                    tempList = new ArrayList<PLSEntryInfo>();
                    tempList.add(pLSEntry);
                    pLSMap.put(key, tempList);
                    continue;
                }
                tempList = (List)pLSMap.get(key);
                tempList.add(pLSEntry);
                pLSMap.put(key, tempList);
            }
            String idStr = StringUtils.arrayToString((Object[])pLSMap.keySet().toArray(), (String)"','");
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append(" select bom.fmaterialid as parentMaterialID,bom.funitid as parentUnitID,bom.fbaseunitid as parentBaseUnitID,bom.fproductqty as parentQty,");
            sqlBuffer.append(" bom.fproductbaseqty as parentBaseQty,materialplan.fmaterialattr as materialAttr,bomentry.FScrapRatio,materialplan.FScrapRateExpression,");
            sqlBuffer.append(" bomentry.fmaterialid as childMaterialID,bomentry.funitid as childUnitID,bomentry.fbaseunitid as childBaseUnitID,bomentry.fproductrate as productRate,");
            sqlBuffer.append(" bomentry.fbaseproductrate as baseProductRate,bomentry.fbaserate as baseRate,bomentry.fproportion as proportion,bomentry.fconsumefixqty as consumeFixQty,");
            sqlBuffer.append(" bomentry.fconsumefixbaseqty as consumeFixBaseQty,bomentry.fconsumetype as consumeType,bomentry.fleadtime as leadTime,materialplan.fissleadtime as issLeadTime ");
            sqlBuffer.append(" ,bomt.FPLCEntryId as PLCEntryId");
            sqlBuffer.append(" from t_mm_bom bom inner join t_mm_bomentry bomentry on bom.fid = bomentry.fparentid ");
            sqlBuffer.append(" inner join t_bd_materialplan materialplan on bomentry.fmaterialinventoid = materialplan.fid ");
            sqlBuffer.append(" left join ").append(this.tempBomTableName).append(" bomt on bomt.FMaterialId=bomentry.fmaterialid ");
            sqlBuffer.append(" where bom.fid = bomt.FParentBomID ");
            IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
            while (rows.next()) {
                String pLCEntryId = rows.getString("PLCEntryId");
                String parentMaterialID = rows.getString("parentMaterialID");
                String parentUnitID = rows.getString("parentUnitID");
                String parentBaseUnitID = rows.getString("parentBaseUnitID");
                BigDecimal parentQty = rows.getBigDecimal("parentQty");
                BigDecimal parentBaseQty = rows.getBigDecimal("parentBaseQty");
                String childMaterialID = rows.getString("childMaterialID");
                String childUnitID = rows.getString("childUnitID");
                String childBaseUnitID = rows.getString("childBaseUnitID");
                BigDecimal productRate = rows.getBigDecimal("productRate");
                BigDecimal baseProductRate = rows.getBigDecimal("baseProductRate");
                BigDecimal baseRate = rows.getBigDecimal("baseRate");
                BigDecimal proportion = rows.getBigDecimal("proportion");
                BigDecimal consumeFixQty = rows.getBigDecimal("consumeFixQty");
                BigDecimal consumeFixBaseQty = rows.getBigDecimal("consumeFixBaseQty");
                int consumeType = rows.getInt("consumeType");
                int leadTime = rows.getInt("leadTime");
                int issLeadTime = rows.getInt("issLeadTime");
                int materialAttr = rows.getInt("materialAttr");
                BigDecimal scrapRatio = rows.getBigDecimal("FScrapRatio");
                int scrapRateExpression = rows.getInt("FScrapRateExpression");
                List tempList = (List)pLSMap.get(parentMaterialID);
                if (tempList == null) continue;
                for (PLSEntryInfo pLSEntry : tempList) {
                    String parentID = pLSEntry.getId().toString();
                    BigDecimal qty = pLSEntry.getQty();
                    BigDecimal baseQty = pLSEntry.getBaseQty();
                    Timestamp varDate = pLSEntry.getBeginDate();
                    String lineNum = pLSEntry.getLineNum();
                    String plcEntryId = pLSEntry.getPlcEntryId();
                    String poEntryId = pLSEntry.getSourceBillEntryId();
                    if (!plcEntryId.equals(pLCEntryId)) continue;
                    if (10020 == materialAttr) {
                        BigDecimal childBaseQty;
                        BigDecimal childQty;
                        if (consumeType == 20) {
                            childQty = qty.multiply(consumeFixQty.divide(parentQty, 8, 4));
                            childBaseQty = baseQty.multiply(consumeFixBaseQty.divide(parentBaseQty, 8, 4));
                        } else {
                            childBaseQty = baseQty.multiply(proportion.divide(PLSConstant.HUNDRED, 8, 4).multiply(baseProductRate));
                            childQty = childBaseQty.multiply(baseRate);
                        }
                        Calendar ca = Calendar.getInstance();
                        ca.setTime(varDate);
                        ca.add(5, leadTime);
                        ca.add(12, issLeadTime * PLSConstant.MINUSONE.intValue());
                        varDate = new Timestamp(ca.getTimeInMillis());
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("ctx", this.ctx);
                        map.put("parentID", parentID);
                        map.put("childQty", childQty);
                        map.put("childBaseQty", childBaseQty);
                        map.put("varDate", varDate);
                        map.put("storageOrgUnitInfo", this.storageOrgUnitInfo);
                        map.put("materialID", childMaterialID);
                        map.put("lineNum", lineNum);
                        map.put("plcEntryId", plcEntryId);
                        map.put("poEntryId", poEntryId);
                        map.put("phantomPartLevel", new Integer(1));
                        List list = this.phantomPartBomExpend(map);
                        int n2 = list.size();
                        for (int i = 0; i < n2; ++i) {
                            Map paraMap = (Map)list.get(i);
                            paraMap.put("allocateMap", this.allocateMap);
                            paraMap.put("level", new Integer(1));
                            this.insertBOMTempData(paraMap, batchStatement);
                        }
                        continue;
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("ctx", this.ctx);
                    map.put("parentID", parentID);
                    map.put("qty", qty);
                    map.put("baseQty", baseQty);
                    map.put("parentQty", parentQty);
                    map.put("parentBaseQty", parentBaseQty);
                    map.put("varDate", varDate);
                    map.put("storageOrgUnitInfo", this.storageOrgUnitInfo);
                    map.put("childMaterialID", childMaterialID);
                    map.put("level", new Integer(1));
                    map.put("childUnitID", childUnitID);
                    map.put("childBaseUnitID", childBaseUnitID);
                    map.put("baseRate", baseRate);
                    map.put("baseProductRate", baseProductRate);
                    map.put("proportion", proportion);
                    map.put("consumeFixQty", consumeFixQty);
                    map.put("consumeFixBaseQty", consumeFixBaseQty);
                    map.put("consumeType", new Integer(consumeType));
                    map.put("leadTime", new Integer(leadTime));
                    map.put("issLeadTime", new Integer(issLeadTime));
                    map.put("lineNum", lineNum);
                    map.put("plcEntryId", plcEntryId);
                    map.put("poEntryId", poEntryId);
                    map.put("scrapRatio", scrapRatio);
                    map.put("scrapRateExpression", new Integer(scrapRateExpression));
                    this.insertBOMTempData(map, batchStatement);
                }
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    protected boolean bomExpandStep(int level) throws BOSException, EASBizException {
        boolean bl;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select tempTable.fPLSEntryid as parentID,tempTable.fBeginTime as beginTime,tempTable.fEndTime as endTime,tempTable.fQty as productQty,tempTable.fpoEntryId as poEntryId, ");
        sqlBuffer.append(" tempTable.fBaseQty as productBaseQty,tempTable.fLineNum as lineNum,tempTable.fplcEntryId as plcEntryId,bom.fmaterialid as parentMaterialID,bom.funitid as parentUnitID, ");
        sqlBuffer.append(" bom.fbaseunitid as parentBaseUnitID,bom.fproductqty as parentQty,bom.fproductbaseqty as parentBaseQty,materialplan.fmaterialattr as materialAttr, ");
        sqlBuffer.append(" bomentry.FScrapRatio,materialplan.FScrapRateExpression,bomentry.fmaterialid as childMaterialID,bomentry.funitid as childUnitID, ");
        sqlBuffer.append(" bomentry.fbaseunitid as childBaseUnitID,bomentry.fproductrate as productRate,bomentry.fbaseproductrate as baseProductRate,bomentry.fbaserate as baseRate, ");
        sqlBuffer.append(" bomentry.fproportion as proportion,bomentry.fconsumefixqty as consumeFixQty,bomentry.fconsumefixbaseqty as consumeFixBaseQty,bomentry.fconsumetype as consumeType, ");
        sqlBuffer.append(" bomentry.fleadtime as leadTime,materialplan.fissleadtime as issLeadTime ");
        sqlBuffer.append(" from " + this.tempTableName + " tempTable inner join t_mm_bom bom on bom.fmaterialid = tempTable.fMaterialID and tempTable.fstorageorgunitid = bom.fstorageorgunitid ");
        sqlBuffer.append(" inner join t_mm_bomentry bomentry on bom.fid = bomentry.fparentid ");
        sqlBuffer.append(" inner join t_bd_materialplan materialplan on bomentry.fmaterialinventoid = materialplan.fid ");
        sqlBuffer.append(" left join ").append(this.tempBomTableName).append(" bomt on bomt.FMaterialId=bomentry.fmaterialid ");
        sqlBuffer.append(" where bom.fid = bomt.FParentBomID and bomt.FPLCEntryId=tempTable.fPLCEntryid");
        sqlBuffer.append(" and tempTable.fLevel = ? ");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{new Integer(level - 1)});
        if (rows.size() == 0) {
            return false;
        }
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into ").append(this.tempTableName);
            stringBuffer.append(" (fPLSEntryid,fProductLineID,fWorkDate,fBeginTime,fEndTime,fClassTeamID,fMaterialID,fUnitID,fBaseUnitID,fQty,fBaseQty, ");
            stringBuffer.append(" fLevel,fparentID,fStorageOrgUnitID,flineNum,fproOrder,fplcEntryId,fpoEntryId) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
            batchStatement = conn.prepareStatement(stringBuffer.toString());
            while (rows.next()) {
                String parentID = rows.getString("parentID");
                Timestamp beginTime = rows.getTimestamp("beginTime");
                Timestamp endTime = rows.getTimestamp("endTime");
                BigDecimal qty = rows.getBigDecimal("productQty");
                BigDecimal baseQty = rows.getBigDecimal("productBaseQty");
                String parentMaterialID = rows.getString("parentMaterialID");
                String parentUnitID = rows.getString("parentUnitID");
                String parentBaseUnitID = rows.getString("parentBaseUnitID");
                BigDecimal parentQty = rows.getBigDecimal("parentQty");
                BigDecimal parentBaseQty = rows.getBigDecimal("parentBaseQty");
                String childMaterialID = rows.getString("childMaterialID");
                String childUnitID = rows.getString("childUnitID");
                String childBaseUnitID = rows.getString("childBaseUnitID");
                BigDecimal productRate = rows.getBigDecimal("productRate");
                BigDecimal baseProductRate = rows.getBigDecimal("baseProductRate");
                BigDecimal baseRate = rows.getBigDecimal("baseRate");
                BigDecimal proportion = rows.getBigDecimal("proportion");
                BigDecimal consumeFixQty = rows.getBigDecimal("consumeFixQty");
                BigDecimal consumeFixBaseQty = rows.getBigDecimal("consumeFixBaseQty");
                int consumeType = rows.getInt("consumeType");
                int leadTime = rows.getInt("leadTime");
                int issLeadTime = rows.getInt("issLeadTime");
                String lineNum = rows.getString("lineNum");
                String plcEntryId = rows.getString("plcEntryId");
                String poEntryId = rows.getString("poEntryId");
                int materialAttr = rows.getInt("materialAttr");
                BigDecimal scrapRatio = rows.getBigDecimal("FScrapRatio");
                int scrapRateExpression = rows.getInt("FScrapRateExpression");
                if (10020 == materialAttr) {
                    BigDecimal childBaseQty;
                    BigDecimal childQty;
                    if (consumeType == 20) {
                        childQty = qty.multiply(consumeFixQty.divide(parentQty, 8, 4));
                        childBaseQty = baseQty.multiply(consumeFixBaseQty.divide(parentBaseQty, 8, 4));
                    } else {
                        childBaseQty = baseQty.multiply(proportion.divide(PLSConstant.HUNDRED, 8, 4).multiply(baseProductRate));
                        childQty = childBaseQty.multiply(baseRate);
                    }
                    Calendar ca = Calendar.getInstance();
                    ca.setTime(beginTime);
                    ca.add(5, leadTime);
                    ca.add(12, issLeadTime * PLSConstant.MINUSONE.intValue());
                    Timestamp varDate = new Timestamp(ca.getTimeInMillis());
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("ctx", this.ctx);
                    map.put("parentID", parentID);
                    map.put("childQty", childQty);
                    map.put("childBaseQty", childBaseQty);
                    map.put("varDate", varDate);
                    map.put("storageOrgUnitInfo", this.storageOrgUnitInfo);
                    map.put("materialID", childMaterialID);
                    map.put("lineNum", lineNum);
                    map.put("plcEntryId", plcEntryId);
                    map.put("poEntryId", poEntryId);
                    map.put("phantomPartLevel", new Integer(1));
                    List list = this.phantomPartBomExpend(map);
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        Map paraMap = (Map)list.get(i);
                        paraMap.put("allocateMap", this.allocateMap);
                        paraMap.put("level", new Integer(level));
                        this.insertBOMTempData(paraMap, batchStatement);
                    }
                    continue;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("ctx", this.ctx);
                map.put("parentID", parentID);
                map.put("qty", qty);
                map.put("baseQty", baseQty);
                map.put("parentQty", parentQty);
                map.put("parentBaseQty", parentBaseQty);
                map.put("varDate", beginTime);
                map.put("storageOrgUnitInfo", this.storageOrgUnitInfo);
                map.put("childMaterialID", childMaterialID);
                map.put("level", new Integer(level));
                map.put("childUnitID", childUnitID);
                map.put("childBaseUnitID", childBaseUnitID);
                map.put("baseRate", baseRate);
                map.put("baseProductRate", baseProductRate);
                map.put("proportion", proportion);
                map.put("consumeFixQty", consumeFixQty);
                map.put("consumeFixBaseQty", consumeFixBaseQty);
                map.put("consumeType", new Integer(consumeType));
                map.put("leadTime", new Integer(leadTime));
                map.put("issLeadTime", new Integer(issLeadTime));
                map.put("lineNum", lineNum);
                map.put("plcEntryId", plcEntryId);
                map.put("poEntryId", poEntryId);
                map.put("scrapRatio", scrapRatio);
                map.put("scrapRateExpression", new Integer(scrapRateExpression));
                this.insertBOMTempData(map, batchStatement);
            }
            batchStatement.executeBatch();
            bl = true;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        return bl;
    }

    protected List phantomPartBomExpend(Map map) throws BOSException, EASBizException {
        ArrayList returnList = new ArrayList();
        try {
            Context ctx = (Context)map.get("ctx");
            String parentID = (String)map.get("parentID");
            String materialID = (String)map.get("materialID");
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)map.get("storageOrgUnitInfo");
            BigDecimal qty = (BigDecimal)map.get("childQty");
            BigDecimal baseQty = (BigDecimal)map.get("childBaseQty");
            Timestamp varDate = (Timestamp)map.get("varDate");
            String lineNum = (String)map.get("lineNum");
            String plcEntryId = (String)map.get("plcEntryId");
            String poEntryId = (String)map.get("poEntryId");
            int phantomPartLevel = (Integer)map.get("phantomPartLevel");
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append(" select bom.fmaterialid as parentMaterialID,bom.funitid as parentUnitID,bom.fbaseunitid as parentBaseUnitID,bom.fproductqty as parentQty,");
            sqlBuffer.append(" bom.fproductbaseqty as parentBaseQty,materialplan.fmaterialattr as materialAttr,bomentry.FScrapRatio,materialplan.FScrapRateExpression,");
            sqlBuffer.append(" bomentry.fmaterialid as childMaterialID,bomentry.funitid as childUnitID,bomentry.fbaseunitid as childBaseUnitID,bomentry.fproductrate as productRate,");
            sqlBuffer.append(" bomentry.fbaseproductrate as baseProductRate,bomentry.fbaserate as baseRate,bomentry.fproportion as proportion,bomentry.fconsumefixqty as consumeFixQty,");
            sqlBuffer.append(" bomentry.fconsumefixbaseqty as consumeFixBaseQty,bomentry.fconsumetype as consumeType,bomentry.fleadtime as leadTime,materialplan.fissleadtime as issLeadTime ");
            sqlBuffer.append(" from t_mm_bom bom inner join t_mm_bomentry bomentry on bom.fid = bomentry.fparentid ");
            sqlBuffer.append(" inner join t_bd_materialplan materialplan on bomentry.fmaterialinventoid = materialplan.fid ");
            sqlBuffer.append(" left join ").append(this.tempBomTableName).append(" bomt on bomt.FMaterialId=bomentry.fmaterialid");
            sqlBuffer.append(" where bom.fmaterialid = '" + materialID + "'");
            sqlBuffer.append(" and bomt.FPLCEntryId='").append(plcEntryId).append("'").append(" and bomt.FParentBomID=bom.FID");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            while (rows.next()) {
                BigDecimal childBaseQty;
                BigDecimal childQty;
                String parentMaterialID = rows.getString("parentMaterialID");
                String parentUnitID = rows.getString("parentUnitID");
                String parentBaseUnitID = rows.getString("parentBaseUnitID");
                BigDecimal parentQty = rows.getBigDecimal("parentQty");
                BigDecimal parentBaseQty = rows.getBigDecimal("parentBaseQty");
                String childMaterialID = rows.getString("childMaterialID");
                String childUnitID = rows.getString("childUnitID");
                String childBaseUnitID = rows.getString("childBaseUnitID");
                BigDecimal productRate = rows.getBigDecimal("productRate");
                BigDecimal baseProductRate = rows.getBigDecimal("baseProductRate");
                BigDecimal baseRate = rows.getBigDecimal("baseRate");
                BigDecimal proportion = rows.getBigDecimal("proportion");
                BigDecimal consumeFixQty = rows.getBigDecimal("consumeFixQty");
                BigDecimal consumeFixBaseQty = rows.getBigDecimal("consumeFixBaseQty");
                int consumeType = rows.getInt("consumeType");
                int leadTime = rows.getInt("leadTime");
                int issLeadTime = rows.getInt("issLeadTime");
                int materialAttr = rows.getInt("materialAttr");
                BigDecimal scrapRatio = rows.getBigDecimal("FScrapRatio");
                int scrapRateExpression = rows.getInt("FScrapRateExpression");
                if (10020 != materialAttr) {
                    HashMap<String, Object> paraMap = new HashMap<String, Object>();
                    paraMap.put("ctx", ctx);
                    paraMap.put("parentID", parentID);
                    paraMap.put("qty", qty);
                    paraMap.put("baseQty", baseQty);
                    paraMap.put("parentQty", parentQty);
                    paraMap.put("parentBaseQty", parentBaseQty);
                    paraMap.put("varDate", varDate);
                    paraMap.put("storageOrgUnitInfo", storageOrgUnitInfo);
                    paraMap.put("childMaterialID", childMaterialID);
                    paraMap.put("childUnitID", childUnitID);
                    paraMap.put("childBaseUnitID", childBaseUnitID);
                    paraMap.put("baseRate", baseRate);
                    paraMap.put("baseProductRate", baseProductRate);
                    paraMap.put("proportion", proportion);
                    paraMap.put("consumeFixQty", consumeFixQty);
                    paraMap.put("consumeFixBaseQty", consumeFixBaseQty);
                    paraMap.put("consumeType", new Integer(consumeType));
                    paraMap.put("leadTime", new Integer(leadTime));
                    paraMap.put("issLeadTime", new Integer(issLeadTime));
                    paraMap.put("lineNum", lineNum);
                    paraMap.put("plcEntryId", plcEntryId);
                    paraMap.put("poEntryId", poEntryId);
                    paraMap.put("scrapRatio", scrapRatio);
                    paraMap.put("scrapRateExpression", new Integer(scrapRateExpression));
                    returnList.add(paraMap);
                    continue;
                }
                if (phantomPartLevel >= 10) continue;
                ++phantomPartLevel;
                if (consumeType == 20) {
                    childQty = qty.multiply(consumeFixQty.divide(parentQty, 8, 4));
                    childBaseQty = baseQty.multiply(consumeFixBaseQty.divide(parentBaseQty, 8, 4));
                } else {
                    childBaseQty = baseQty.multiply(proportion.divide(PLSConstant.HUNDRED, 8, 4).multiply(baseProductRate));
                    childQty = childBaseQty.multiply(baseRate);
                }
                Calendar ca = Calendar.getInstance();
                ca.setTime(varDate);
                ca.add(5, leadTime);
                ca.add(12, issLeadTime * PLSConstant.MINUSONE.intValue());
                varDate = new Timestamp(ca.getTimeInMillis());
                HashMap<String, Object> paraMap = new HashMap<String, Object>();
                paraMap.put("ctx", ctx);
                paraMap.put("parentID", parentID);
                paraMap.put("childQty", childQty);
                paraMap.put("childBaseQty", childBaseQty);
                paraMap.put("varDate", varDate);
                paraMap.put("storageOrgUnitInfo", storageOrgUnitInfo);
                paraMap.put("materialID", childMaterialID);
                paraMap.put("lineNum", lineNum);
                paraMap.put("plcEntryId", plcEntryId);
                paraMap.put("poEntryId", poEntryId);
                paraMap.put("phantomPartLevel", new Integer(phantomPartLevel));
                List resultList = this.phantomPartBomExpend(paraMap);
                int n = resultList.size();
                for (int i = 0; i < n; ++i) {
                    returnList.add(resultList.get(i));
                }
            }
            return returnList;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void insertBOMTempData(Map map, PreparedStatement batchStatement) throws BOSException, EASBizException {
        String parentID = (String)map.get("parentID");
        String childMaterialID = (String)map.get("childMaterialID");
        String childUnitID = (String)map.get("childUnitID");
        String childBaseUnitID = (String)map.get("childBaseUnitID");
        int level = (Integer)map.get("level");
        int consumeType = (Integer)map.get("consumeType");
        int leadTime = (Integer)map.get("leadTime");
        int issLeadTime = (Integer)map.get("issLeadTime");
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)map.get("storageOrgUnitInfo");
        BigDecimal qty = (BigDecimal)map.get("qty");
        BigDecimal baseQty = (BigDecimal)map.get("baseQty");
        BigDecimal parentQty = (BigDecimal)map.get("parentQty");
        BigDecimal parentBaseQty = (BigDecimal)map.get("parentBaseQty");
        BigDecimal baseRate = (BigDecimal)map.get("baseRate");
        BigDecimal baseProductRate = (BigDecimal)map.get("baseProductRate");
        BigDecimal proportion = (BigDecimal)map.get("proportion");
        BigDecimal consumeFixQty = (BigDecimal)map.get("consumeFixQty");
        BigDecimal consumeFixBaseQty = (BigDecimal)map.get("consumeFixBaseQty");
        Timestamp varDate = (Timestamp)map.get("varDate");
        String lineNum = (String)map.get("lineNum");
        String plcEntryId = (String)map.get("plcEntryId");
        String poEntryId = (String)map.get("poEntryId");
        BigDecimal scrapRatio = (BigDecimal)map.get("scrapRatio");
        int scrapRateExpression = (Integer)map.get("scrapRateExpression");
        ProductLineInfo productLineInfo = (ProductLineInfo)this.allocateMap.get(childMaterialID);
        if (productLineInfo != null) {
            BigDecimal period;
            String yiedlKey;
            BigDecimal yield;
            BigDecimal productBaseQty;
            BigDecimal productQty;
            if (consumeType == 20) {
                productQty = qty.multiply(consumeFixQty.divide(parentQty, 8, 4));
                productBaseQty = baseQty.multiply(consumeFixBaseQty.divide(parentBaseQty, 8, 4));
            } else {
                productBaseQty = baseQty.multiply(proportion.divide(PLSConstant.HUNDRED, 8, 4)).divide(baseProductRate, 8, 4);
                productQty = productBaseQty.multiply(baseRate);
            }
            BigDecimal childQty = productQty;
            BigDecimal childBaseQty = productBaseQty;
            if (scrapRateExpression == 10610) {
                childQty = childQty.divide(PLSConstant.ONE.subtract(scrapRatio.divide(PLSConstant.HUNDRED, 8, 4)), 8, 4);
                childBaseQty = childBaseQty.divide(PLSConstant.ONE.subtract(scrapRatio.divide(PLSConstant.HUNDRED, 8, 4)), 8, 4);
            } else if (scrapRateExpression == 10620) {
                childQty = childQty.multiply(PLSConstant.ONE.add(scrapRatio.divide(PLSConstant.HUNDRED, 8, 4)));
                childBaseQty = childBaseQty.multiply(PLSConstant.ONE.add(scrapRatio.divide(PLSConstant.HUNDRED, 8, 4)));
            }
            boolean isCalcStock = this.lineSchedulingModelInfo.isIsSonLinePlanCalcStock();
            BigDecimal stockBaseQty = null;
            String trackId = "";
            if (this.trackNumberMap.get(poEntryId) != null) {
                TrackNumberInfo track = (TrackNumberInfo)this.trackNumberMap.get(poEntryId);
                trackId = track.getId() == null ? "" : track.getId().toString();
            }
            String stockKey = childMaterialID + "@" + trackId;
            if (this.stockBaseQtyMap != null) {
                stockBaseQty = (BigDecimal)this.stockBaseQtyMap.get(stockKey);
            }
            if (isCalcStock && stockBaseQty != null && stockBaseQty.compareTo(PLSConstant.ZERO) > 0) {
                if (childBaseQty.compareTo(stockBaseQty) > 0) {
                    BigDecimal stockQty = PLSUtil.getConstraintQty(this.getExchangePrecisionQty(childMaterialID, childBaseUnitID, childUnitID, stockBaseQty));
                    childQty = childQty.subtract(stockQty);
                    childBaseQty = childBaseQty.subtract(stockBaseQty);
                    this.stockBaseQtyMap.put(stockKey, PLSConstant.ZERO);
                } else {
                    this.stockBaseQtyMap.put(stockKey, stockBaseQty.subtract(childBaseQty));
                    return;
                }
            }
            yield = (yield = (BigDecimal)this.yieldsByBOM.get(yiedlKey = storageOrgUnitInfo.getId().toString() + childMaterialID)) != null ? yield.divide(PLSConstant.HUNDRED, 8, 4) : PLSConstant.ONE;
            childQty = childQty.divide(yield, 8, 4);
            childBaseQty = childBaseQty.divide(yield, 8, 4);
            String mpKey = childMaterialID + "@" + productLineInfo.getId().toString();
            if (20 == this.batchControl) {
                BigDecimal lot = (BigDecimal)this.lineLotMap.get(mpKey);
                if (lot != null && childQty.doubleValue() % lot.doubleValue() != 0.0) {
                    childQty = childQty.divide(lot, 0, 0).multiply(lot);
                }
                childBaseQty = PLSUtil.getConstraintQty(this.getExchangePrecisionQty(childMaterialID, childUnitID, childBaseUnitID, childQty));
            }
            if ((period = (BigDecimal)this.outputPeriod.get(mpKey)) == null) {
                period = new BigDecimal("0");
            }
            Calendar ca = Calendar.getInstance();
            ca.setTime(varDate);
            ca.add(5, leadTime);
            ca.add(12, issLeadTime * PLSConstant.MINUSONE.intValue());
            long periodTime = period.multiply(new BigDecimal(3600000)).longValue();
            long requireDate = ca.getTimeInMillis() - periodTime;
            varDate = new Timestamp(requireDate);
            LineCapabilityInfo lineCapInfo = this.getLineCapInfo(productLineInfo, varDate);
            if (lineCapInfo == null) {
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOLINECAP_DESC");
                int exceNum = 203;
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOLINECAP_DETAIL", (String[])new String[]{PLSUtil.formatTimestamp(varDate), productLineInfo.getNumber(), productLineInfo.getName()});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
                return;
            }
            Timestamp workDate = PLSUtil.setDateTime(varDate, 0);
            Timestamp beginTime = lineCapInfo.getBeginTime();
            Timestamp endTime = lineCapInfo.getEndTime();
            String classTeamID = null;
            if (lineCapInfo.getClassTeam() != null) {
                if (this.classTeams == null) {
                    this.classTeams = new HashMap();
                }
                classTeamID = lineCapInfo.getClassTeam().getId().toString();
                this.classTeams.put(classTeamID, lineCapInfo.getClassTeam());
            }
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            String vDate = sf.format(workDate);
            String productLineID = productLineInfo.getId().toString();
            String key = vDate + productLineID;
            BigDecimal proOrder = null;
            if (this.proOrderMap.containsKey(key)) {
                proOrder = (BigDecimal)this.proOrderMap.get(key);
            }
            proOrder = proOrder == null ? PLSConstant.TEN : proOrder.divide(PLSConstant.TEN, 0, 3).multiply(PLSConstant.TEN);
            this.proOrderMap.put(key, proOrder);
            String newLineNum = null;
            if (this.lineNumMap == null) {
                this.lineNumMap = new HashMap();
            }
            if (this.lineNumMap.containsKey(lineNum)) {
                int num = (Integer)this.lineNumMap.get(lineNum);
                newLineNum = this.getLineNum(lineNum, ++num);
                this.lineNumMap.put(lineNum, new Integer(num));
            } else {
                newLineNum = lineNum + "-01";
                this.lineNumMap.put(lineNum, new Integer(1));
            }
            try {
                childQty = PLSUtil.getConstraintQty(childQty);
                childBaseQty = PLSUtil.getConstraintQty(childBaseQty);
                batchStatement.setString(1, BOSUuid.create((String)"72079370").toString());
                batchStatement.setString(2, productLineInfo.getId().toString());
                batchStatement.setTimestamp(3, workDate);
                batchStatement.setTimestamp(4, beginTime);
                batchStatement.setTimestamp(5, endTime);
                batchStatement.setString(6, classTeamID);
                batchStatement.setString(7, childMaterialID);
                batchStatement.setString(8, childUnitID);
                batchStatement.setString(9, childBaseUnitID);
                batchStatement.setBigDecimal(10, childQty);
                batchStatement.setBigDecimal(11, childBaseQty);
                batchStatement.setInt(12, level);
                batchStatement.setString(13, parentID);
                batchStatement.setString(14, storageOrgUnitInfo.getId().toString());
                batchStatement.setString(15, newLineNum);
                batchStatement.setBigDecimal(16, proOrder);
                batchStatement.setString(17, plcEntryId);
                batchStatement.setString(18, poEntryId);
                batchStatement.addBatch();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOINALLOTDEF_DESC");
            int exceNum = 201;
            MaterialInfo material = (MaterialInfo)this.materialMap.get(childMaterialID);
            String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOINALLOTDEF_DETAIL", (String[])new String[]{material.getNumber(), material.getName()});
            PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
            this.exceptions.add(exceInfo);
        }
    }

    protected void formulaExpand() throws BOSException, EASBizException {
        this.tempTableName = this.createTempTable(this.createTableSQL());
        this.formulaExpandFristStep();
        this.getPLSEntryInfoList();
        this.releaseTempTable();
    }

    protected void formulaExpandFristStep() throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into ").append(this.tempTableName);
            stringBuffer.append(" (fPLSEntryid,fProductLineID,fWorkDate,fBeginTime,fEndTime,fClassTeamID,fMaterialID,fUnitID,fBaseUnitID,fQty,fBaseQty, ");
            stringBuffer.append(" fLevel,fparentID,fStorageOrgUnitID,flineNum,fproOrder,fplcEntryId,fpoEntryId) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
            batchStatement = conn.prepareStatement(stringBuffer.toString());
            HashMap pLSMap = new HashMap();
            int n = this.srcList.size();
            for (int i = 0; i < n; ++i) {
                List<PLSEntryInfo> tempList;
                PLSEntryInfo pLSEntry = (PLSEntryInfo)this.srcList.get(i);
                String trackNumId = pLSEntry.getTrackNumber() == null ? "" : pLSEntry.getTrackNumber().getId().toString();
                String key = pLSEntry.getMaterial().getId().toString() + "@" + pLSEntry.getProductLine().getId().toString() + "@" + trackNumId;
                if (!pLSMap.containsKey(key)) {
                    tempList = new ArrayList<PLSEntryInfo>();
                    tempList.add(pLSEntry);
                    pLSMap.put(key, tempList);
                    continue;
                }
                tempList = (List)pLSMap.get(key);
                tempList.add(pLSEntry);
                pLSMap.put(key, tempList);
            }
            for (String key : pLSMap.keySet()) {
                String[] idStr = key.split("@");
                String materialID = idStr[0];
                String productLineID = idStr[1];
                String trackNumID = "";
                if (idStr.length == 3) {
                    trackNumID = idStr[2];
                }
                if (this.formulaMap.get(key) == null) continue;
                ProductionFormulaInfo formula = (ProductionFormulaInfo)this.formulaMap.get(key);
                StringBuffer sqlBuffer = new StringBuffer();
                sqlBuffer.append(" select formula.fmaterialid as parentMaterialID,formula.funitid as parentUnitID,formula.fbaseunitid as parentBaseUnitID,formula.fproductqty as parentQty, ");
                sqlBuffer.append(" formula.fproductbaseqty as parentBaseQty,materialplan.FScrapRate,materialplan.FScrapRateExpression,formulaentry.fmaterialid as childMaterialID, ");
                sqlBuffer.append(" formulaentry.funitid as childUnitID,formulaentry.fbaseunitid as childBaseUnitID,formulaentry.fbaseproductrate as baseProductRate, ");
                sqlBuffer.append(" formulaentry.fbaserate as baseRate,formulaentry.fproportion as proportion,formulaentry.fconsumefixqty as consumeFixQty, ");
                sqlBuffer.append(" formulaentry.fconsumefixbaseqty as consumeFixBaseQty,formulaentry.fconsumetype as consumeType, ");
                sqlBuffer.append(" formulaentry.fleadtime as leadTime,materialplan.fissleadtime as issLeadTime,formula.fproductlineid as productlineid");
                sqlBuffer.append(" from T_MM_PRODUCTIONFORMULA formula inner join T_MM_PRODUCTIONFORMULAENTRY formulaentry on formula.fid = formulaentry.fparentid ");
                sqlBuffer.append(" inner join t_bd_materialplan materialplan on formulaentry.FMATERIALINVENTOYID = materialplan.fid ");
                sqlBuffer.append(" where formula.fid = '" + formula.getId().toString() + "' ");
                sqlBuffer.append(" and materialplan.fstatus = 1 ");
                sqlBuffer.append(" and materialplan.fmaterialattr = 10030 and materialplan.fplanningmode = 3 and materialplan.fisproductlineplan = 1 ");
                sqlBuffer.append(" and formulaentry.feffectivedate <= now() and formulaentry.fdisabledate >=  now() ");
                IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
                while (rows.next()) {
                    String parentMaterialID = rows.getString("parentMaterialID");
                    String productlineId = rows.getString("productlineid");
                    String parentUnitID = rows.getString("parentUnitID");
                    String parentBaseUnitID = rows.getString("parentBaseUnitID");
                    BigDecimal parentQty = rows.getBigDecimal("parentQty");
                    BigDecimal parentBaseQty = rows.getBigDecimal("parentBaseQty");
                    String childMaterialID = rows.getString("childMaterialID");
                    String childUnitID = rows.getString("childUnitID");
                    String childBaseUnitID = rows.getString("childBaseUnitID");
                    BigDecimal baseProductRate = rows.getBigDecimal("baseProductRate");
                    BigDecimal baseRate = rows.getBigDecimal("baseRate");
                    BigDecimal proportion = rows.getBigDecimal("proportion");
                    BigDecimal consumeFixQty = rows.getBigDecimal("consumeFixQty");
                    BigDecimal consumeFixBaseQty = rows.getBigDecimal("consumeFixBaseQty");
                    int consumeType = rows.getInt("consumeType");
                    int leadTime = rows.getInt("leadTime");
                    int issLeadTime = rows.getInt("issLeadTime");
                    BigDecimal scrapRatio = rows.getBigDecimal("FScrapRate");
                    int scrapRateExpression = rows.getInt("FScrapRateExpression");
                    List tempList = (List)pLSMap.get(parentMaterialID + "@" + productlineId + "@" + trackNumID);
                    int n2 = tempList.size();
                    for (int i = 0; i < n2; ++i) {
                        PLSEntryInfo pLSEntry = (PLSEntryInfo)tempList.get(i);
                        String parentID = pLSEntry.getId().toString();
                        BigDecimal qty = pLSEntry.getQty();
                        BigDecimal baseQty = pLSEntry.getBaseQty();
                        Timestamp varDate = pLSEntry.getBeginDate();
                        String lineNum = pLSEntry.getLineNum();
                        String plcEntryId = pLSEntry.getPlcEntryId();
                        String poEntryId = pLSEntry.getSourceBillEntryId();
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("ctx", this.ctx);
                        map.put("parentID", parentID);
                        map.put("qty", qty);
                        map.put("baseQty", baseQty);
                        map.put("parentQty", parentQty);
                        map.put("parentBaseQty", parentBaseQty);
                        map.put("varDate", varDate);
                        map.put("storageOrgUnitInfo", this.storageOrgUnitInfo);
                        map.put("childMaterialID", childMaterialID);
                        map.put("level", new Integer(1));
                        map.put("childUnitID", childUnitID);
                        map.put("childBaseUnitID", childBaseUnitID);
                        map.put("baseRate", baseRate);
                        map.put("baseProductRate", baseProductRate);
                        map.put("proportion", proportion);
                        map.put("consumeFixQty", consumeFixQty);
                        map.put("consumeFixBaseQty", consumeFixBaseQty);
                        map.put("consumeType", new Integer(consumeType));
                        map.put("leadTime", new Integer(leadTime));
                        map.put("issLeadTime", new Integer(issLeadTime));
                        map.put("lineNum", lineNum);
                        map.put("plcEntryId", plcEntryId);
                        map.put("poEntryId", poEntryId);
                        map.put("scrapRatio", scrapRatio);
                        map.put("scrapRateExpression", new Integer(scrapRateExpression));
                        Map paMap = this.insertFormulaTempData(map, batchStatement);
                        if (paMap == null || !this.isToLow) continue;
                        this.formulaExpandStep(batchStatement, paMap);
                    }
                }
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    protected void formulaExpandStep(PreparedStatement batchStatement, Map paraMap) throws BOSException, EASBizException {
        try {
            String parentID = (String)paraMap.get("parentID");
            Timestamp varDate = (Timestamp)paraMap.get("varDate");
            String materialID = (String)paraMap.get("materialID");
            String productLineID = (String)paraMap.get("productLineID");
            BigDecimal qty = (BigDecimal)paraMap.get("qty");
            BigDecimal baseQty = (BigDecimal)paraMap.get("baseQty");
            String lineNum = (String)paraMap.get("lineNum");
            String plcEntryId = (String)paraMap.get("plcEntryId");
            String poEntryId = (String)paraMap.get("poEntryId");
            int level = (Integer)paraMap.get("level");
            String trackNumberID = this.trackNumberMap.get(poEntryId) == null ? "" : ((TrackNumberInfo)this.trackNumberMap.get(poEntryId)).getId().toString();
            String key = materialID + "@" + productLineID + "@" + trackNumberID;
            if (++level > 50) {
                return;
            }
            if (this.formulaMap.get(key) != null) {
                ProductionFormulaInfo formula = (ProductionFormulaInfo)this.formulaMap.get(key);
                StringBuffer sqlBuffer = new StringBuffer();
                sqlBuffer.append(" select formula.fmaterialid as parentMaterialID,formula.funitid as parentUnitID,formula.fbaseunitid as parentBaseUnitID,formula.fproductqty as parentQty, ");
                sqlBuffer.append(" formula.fproductbaseqty as parentBaseQty,materialplan.FScrapRate,materialplan.FScrapRateExpression,formulaentry.fmaterialid as childMaterialID, ");
                sqlBuffer.append(" formulaentry.funitid as childUnitID,formulaentry.fbaseunitid as childBaseUnitID,formulaentry.fbaseproductrate as baseProductRate, ");
                sqlBuffer.append(" formulaentry.fbaserate as baseRate,formulaentry.fproportion as proportion,formulaentry.fconsumefixqty as consumeFixQty, ");
                sqlBuffer.append(" formulaentry.fconsumefixbaseqty as consumeFixBaseQty,formulaentry.fconsumetype as consumeType, ");
                sqlBuffer.append(" formulaentry.fleadtime as leadTime,materialplan.fissleadtime as issLeadTime ");
                sqlBuffer.append(" from T_MM_PRODUCTIONFORMULA formula inner join T_MM_PRODUCTIONFORMULAENTRY formulaentry on formula.fid = formulaentry.fparentid ");
                sqlBuffer.append(" inner join t_bd_materialplan materialplan on formulaentry.FMATERIALINVENTOYID = materialplan.fid ");
                sqlBuffer.append(" where formula.fid = '" + formula.getId().toString() + "' ");
                sqlBuffer.append(" and materialplan.fstatus = 1 ");
                sqlBuffer.append(" and materialplan.fmaterialattr = 10030 and materialplan.fplanningmode = 3 and materialplan.fisproductlineplan = 1 ");
                sqlBuffer.append(" and formulaentry.feffectivedate <= now() and formulaentry.fdisabledate >=  now() ");
                IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
                while (rows.next()) {
                    String parentMaterialID = rows.getString("parentMaterialID");
                    String parentUnitID = rows.getString("parentUnitID");
                    String parentBaseUnitID = rows.getString("parentBaseUnitID");
                    BigDecimal parentQty = rows.getBigDecimal("parentQty");
                    BigDecimal parentBaseQty = rows.getBigDecimal("parentBaseQty");
                    String childMaterialID = rows.getString("childMaterialID");
                    String childUnitID = rows.getString("childUnitID");
                    String childBaseUnitID = rows.getString("childBaseUnitID");
                    BigDecimal baseProductRate = rows.getBigDecimal("baseProductRate");
                    BigDecimal baseRate = rows.getBigDecimal("baseRate");
                    BigDecimal proportion = rows.getBigDecimal("proportion");
                    BigDecimal consumeFixQty = rows.getBigDecimal("consumeFixQty");
                    BigDecimal consumeFixBaseQty = rows.getBigDecimal("consumeFixBaseQty");
                    int consumeType = rows.getInt("consumeType");
                    int leadTime = rows.getInt("leadTime");
                    int issLeadTime = rows.getInt("issLeadTime");
                    BigDecimal scrapRatio = rows.getBigDecimal("FScrapRate");
                    int scrapRateExpression = rows.getInt("FScrapRateExpression");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("ctx", this.ctx);
                    map.put("parentID", parentID);
                    map.put("qty", qty);
                    map.put("baseQty", baseQty);
                    map.put("parentQty", parentQty);
                    map.put("parentBaseQty", parentBaseQty);
                    map.put("varDate", varDate);
                    map.put("storageOrgUnitInfo", this.storageOrgUnitInfo);
                    map.put("childMaterialID", childMaterialID);
                    map.put("level", new Integer(level));
                    map.put("childUnitID", childUnitID);
                    map.put("childBaseUnitID", childBaseUnitID);
                    map.put("baseRate", baseRate);
                    map.put("baseProductRate", baseProductRate);
                    map.put("proportion", proportion);
                    map.put("consumeFixQty", consumeFixQty);
                    map.put("consumeFixBaseQty", consumeFixBaseQty);
                    map.put("consumeType", new Integer(consumeType));
                    map.put("leadTime", new Integer(leadTime));
                    map.put("issLeadTime", new Integer(issLeadTime));
                    map.put("lineNum", lineNum);
                    map.put("plcEntryId", plcEntryId);
                    map.put("poEntryId", poEntryId);
                    map.put("scrapRatio", scrapRatio);
                    map.put("scrapRateExpression", new Integer(scrapRateExpression));
                    Map paMap = this.insertFormulaTempData(map, batchStatement);
                    if (paMap == null) continue;
                    this.formulaExpandStep(batchStatement, paMap);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Map insertFormulaTempData(Map map, PreparedStatement batchStatement) throws BOSException, EASBizException {
        String parentID = (String)map.get("parentID");
        String childMaterialID = (String)map.get("childMaterialID");
        String childUnitID = (String)map.get("childUnitID");
        String childBaseUnitID = (String)map.get("childBaseUnitID");
        int level = (Integer)map.get("level");
        int consumeType = (Integer)map.get("consumeType");
        int leadTime = (Integer)map.get("leadTime");
        int issLeadTime = (Integer)map.get("issLeadTime");
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)map.get("storageOrgUnitInfo");
        BigDecimal qty = (BigDecimal)map.get("qty");
        BigDecimal baseQty = (BigDecimal)map.get("baseQty");
        BigDecimal parentQty = (BigDecimal)map.get("parentQty");
        BigDecimal parentBaseQty = (BigDecimal)map.get("parentBaseQty");
        BigDecimal baseRate = (BigDecimal)map.get("baseRate");
        BigDecimal baseProductRate = (BigDecimal)map.get("baseProductRate");
        BigDecimal proportion = (BigDecimal)map.get("proportion");
        BigDecimal consumeFixQty = (BigDecimal)map.get("consumeFixQty");
        BigDecimal consumeFixBaseQty = (BigDecimal)map.get("consumeFixBaseQty");
        Timestamp varDate = (Timestamp)map.get("varDate");
        String lineNum = (String)map.get("lineNum");
        String plcEntryId = (String)map.get("plcEntryId");
        String poEntryId = (String)map.get("poEntryId");
        BigDecimal scrapRatio = (BigDecimal)map.get("scrapRatio");
        int scrapRateExpression = (Integer)map.get("scrapRateExpression");
        ProductLineInfo productLineInfo = (ProductLineInfo)this.allocateMap.get(childMaterialID);
        if (productLineInfo != null) {
            BigDecimal period;
            String yiedlKey;
            BigDecimal yield;
            BigDecimal productBaseQty;
            BigDecimal productQty;
            if (consumeType == 20) {
                productQty = qty.multiply(consumeFixQty.divide(parentQty, 8, 4));
                productBaseQty = baseQty.multiply(consumeFixBaseQty.divide(parentBaseQty, 8, 4));
            } else {
                productBaseQty = baseQty.multiply(proportion.divide(PLSConstant.HUNDRED, 8, 4)).divide(baseProductRate, 8, 4);
                productQty = productBaseQty.multiply(baseRate);
            }
            BigDecimal childQty = productQty;
            BigDecimal childBaseQty = productBaseQty;
            if (scrapRateExpression == 10610) {
                childQty = childQty.divide(PLSConstant.ONE.subtract(scrapRatio.divide(PLSConstant.HUNDRED, 8, 4)), 8, 4);
                childBaseQty = childBaseQty.divide(PLSConstant.ONE.subtract(scrapRatio.divide(PLSConstant.HUNDRED, 8, 4)), 8, 4);
            } else if (scrapRateExpression == 10620) {
                childQty = childQty.multiply(PLSConstant.ONE.add(scrapRatio.divide(PLSConstant.HUNDRED, 8, 4)));
                childBaseQty = childBaseQty.multiply(PLSConstant.ONE.add(scrapRatio.divide(PLSConstant.HUNDRED, 8, 4)));
            }
            boolean isCalcStock = this.lineSchedulingModelInfo.isIsSonLinePlanCalcStock();
            BigDecimal stockBaseQty = null;
            String trackId = "";
            if (this.trackNumberMap.get(poEntryId) != null) {
                TrackNumberInfo track = (TrackNumberInfo)this.trackNumberMap.get(poEntryId);
                trackId = track.getId() == null ? "" : track.getId().toString();
            }
            String stockKey = childMaterialID + "@" + trackId;
            if (this.stockBaseQtyMap != null) {
                stockBaseQty = (BigDecimal)this.stockBaseQtyMap.get(stockKey);
            }
            if (isCalcStock && stockBaseQty != null && stockBaseQty.compareTo(PLSConstant.ZERO) > 0) {
                if (childBaseQty.compareTo(stockBaseQty) > 0) {
                    BigDecimal stockQty = PLSUtil.getConstraintQty(this.getExchangePrecisionQty(childMaterialID, childBaseUnitID, childUnitID, stockBaseQty));
                    childQty = childQty.subtract(stockQty);
                    childBaseQty = childBaseQty.subtract(stockBaseQty);
                    this.stockBaseQtyMap.put(stockKey, PLSConstant.ZERO);
                } else {
                    this.stockBaseQtyMap.put(stockKey, stockBaseQty.subtract(childBaseQty));
                    return null;
                }
            }
            yield = (yield = (BigDecimal)this.yieldsByFormula.get(yiedlKey = storageOrgUnitInfo.getId().toString() + childMaterialID)) != null ? yield.divide(PLSConstant.HUNDRED, 8, 4) : PLSConstant.ONE;
            childQty = childQty.divide(yield, 8, 4);
            childBaseQty = childBaseQty.divide(yield, 8, 4);
            String mpKey = childMaterialID + "@" + productLineInfo.getId().toString();
            if (20 == this.batchControl) {
                BigDecimal lot = (BigDecimal)this.lineLotMap.get(mpKey);
                if (lot != null && childQty.doubleValue() % lot.doubleValue() != 0.0) {
                    childQty = childQty.divide(lot, 0, 0).multiply(lot);
                }
                childBaseQty = PLSUtil.getConstraintQty(this.getExchangePrecisionQty(childMaterialID, childUnitID, childBaseUnitID, childQty));
            }
            if ((period = (BigDecimal)this.outputPeriod.get(mpKey)) == null) {
                period = new BigDecimal("0");
            }
            Calendar ca = Calendar.getInstance();
            ca.setTime(varDate);
            ca.add(5, leadTime);
            ca.add(12, issLeadTime * PLSConstant.MINUSONE.intValue());
            long periodTime = period.multiply(new BigDecimal(3600000)).longValue();
            long requireDate = ca.getTimeInMillis() - periodTime;
            varDate = new Timestamp(requireDate);
            LineCapabilityInfo lineCapInfo = this.getLineCapInfo(productLineInfo, varDate);
            if (lineCapInfo == null) {
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOLINECAP_DESC");
                int exceNum = 203;
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOLINECAP_DETAIL", (String[])new String[]{PLSUtil.formatTimestamp(varDate), productLineInfo.getNumber(), productLineInfo.getName()});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
                return null;
            }
            Timestamp workDate = PLSUtil.setDateTime(varDate, 0);
            Timestamp beginTime = lineCapInfo.getBeginTime();
            Timestamp endTime = lineCapInfo.getEndTime();
            String classTeamID = null;
            if (lineCapInfo.getClassTeam() != null) {
                if (this.classTeams == null) {
                    this.classTeams = new HashMap();
                }
                classTeamID = lineCapInfo.getClassTeam().getId().toString();
                this.classTeams.put(classTeamID, lineCapInfo.getClassTeam());
            }
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            String vDate = sf.format(workDate);
            String productLineID = productLineInfo.getId().toString();
            String key = vDate + productLineID;
            BigDecimal proOrder = null;
            if (this.proOrderMap.containsKey(key)) {
                proOrder = (BigDecimal)this.proOrderMap.get(key);
            }
            proOrder = proOrder == null ? PLSConstant.TEN : proOrder.divide(PLSConstant.TEN, 0, 3).multiply(PLSConstant.TEN);
            this.proOrderMap.put(key, proOrder);
            String newLineNum = null;
            if (this.lineNumMap == null) {
                this.lineNumMap = new HashMap();
            }
            if (this.lineNumMap.containsKey(lineNum)) {
                int num = (Integer)this.lineNumMap.get(lineNum);
                newLineNum = this.getLineNum(lineNum, ++num);
                this.lineNumMap.put(lineNum, new Integer(num));
            } else {
                newLineNum = lineNum + "-01";
                this.lineNumMap.put(lineNum, new Integer(1));
            }
            try {
                childQty = PLSUtil.getConstraintQty(childQty);
                childBaseQty = PLSUtil.getConstraintQty(childBaseQty);
                String id = BOSUuid.create((String)"72079370").toString();
                batchStatement.setString(1, id);
                batchStatement.setString(2, productLineInfo.getId().toString());
                batchStatement.setTimestamp(3, workDate);
                batchStatement.setTimestamp(4, beginTime);
                batchStatement.setTimestamp(5, endTime);
                batchStatement.setString(6, classTeamID);
                batchStatement.setString(7, childMaterialID);
                batchStatement.setString(8, childUnitID);
                batchStatement.setString(9, childBaseUnitID);
                batchStatement.setBigDecimal(10, childQty);
                batchStatement.setBigDecimal(11, childBaseQty);
                batchStatement.setInt(12, level);
                batchStatement.setString(13, parentID);
                batchStatement.setString(14, storageOrgUnitInfo.getId().toString());
                batchStatement.setString(15, newLineNum);
                batchStatement.setBigDecimal(16, proOrder);
                batchStatement.setString(17, plcEntryId);
                batchStatement.setString(18, poEntryId);
                batchStatement.addBatch();
                HashMap<String, Object> paMap = new HashMap<String, Object>();
                paMap.put("parentID", id);
                paMap.put("varDate", varDate);
                paMap.put("materialID", childMaterialID);
                paMap.put("productLineID", productLineInfo.getId().toString());
                paMap.put("qty", childQty);
                paMap.put("baseQty", childBaseQty);
                paMap.put("lineNum", lineNum);
                paMap.put("plcEntryId", plcEntryId);
                paMap.put("poEntryId", poEntryId);
                paMap.put("level", new Integer(level));
                return paMap;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOINALLOTDEF_DESC");
        int exceNum = 201;
        MaterialInfo material = (MaterialInfo)this.materialMap.get(childMaterialID);
        String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOINALLOTDEF_DETAIL", (String[])new String[]{material.getNumber(), material.getName()});
        PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
        this.exceptions.add(exceInfo);
        return null;
    }

    protected void getLineLots(Set idSet) {
        this.lineLotMap = new HashMap();
        this.outputPeriod = new HashMap();
        for (int i = 0; i < this.productLinePAllotDefEntryCollection.size(); ++i) {
            ProductLinePAllotDefEntryInfo allotDefEntry = this.productLinePAllotDefEntryCollection.get(i);
            if (allotDefEntry == null || !idSet.contains(allotDefEntry.getMaterial().getId().toString())) continue;
            ProductLinePAllotDefEntryRuleEntryCollection allotDefRuleEntryCol = allotDefEntry.getRuleEntrys();
            String materialID = allotDefEntry.getMaterial().getId().toString();
            for (int j = 0; j < allotDefRuleEntryCol.size(); ++j) {
                ProductLinePAllotDefEntryRuleEntryInfo allotDefRuleEntry = allotDefRuleEntryCol.get(j);
                String productLineID = allotDefRuleEntry.getProductLine().getId().toString();
                String key = materialID + "@" + productLineID;
                if (allotDefRuleEntry.isIsByLot()) {
                    this.lineLotMap.put(key, allotDefRuleEntry.getProductBatch());
                }
                if (this.outputPeriod.containsKey(key)) continue;
                this.outputPeriod.put(key, allotDefRuleEntry.getOutPutPeriod());
            }
        }
    }

    protected String getLineNum(String lineNum, int num) throws BOSException, EASBizException {
        if (num < 10) {
            return lineNum + "-0" + String.valueOf(num);
        }
        return lineNum + "-" + String.valueOf(num);
    }

    protected String createTableSQL() throws BOSException, EASBizException {
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table t_temp_plsObject (");
        createSql.append("fPLSEntryid VARCHAR(44),");
        createSql.append("fMaterialID  VARCHAR(44),");
        createSql.append("fUnitID  VARCHAR(44),");
        createSql.append("fBaseUnitID  VARCHAR(44),");
        createSql.append("fparentID  VARCHAR(44),");
        createSql.append("fClassTeamID  VARCHAR(44),");
        createSql.append("fProductLineID  VARCHAR(44),");
        createSql.append("fQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("fBaseQty NUMERIC(21,8) DEFAULT 0,");
        createSql.append("fWorkDate DATETIME,");
        createSql.append("fBeginTime DATETIME,");
        createSql.append("fEndTime DATETIME,");
        createSql.append("fLevel INT,");
        createSql.append("fStorageOrgUnitID  VARCHAR(44),");
        createSql.append("flineNum  VARCHAR(255),");
        createSql.append("fproOrder NUMERIC(21,8),");
        createSql.append("fplcEntryId VARCHAR(44),");
        createSql.append("fpoEntryId VARCHAR(44))");
        return createSql.toString();
    }

    protected String createBomTableSQL() throws BOSException, EASBizException {
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table t_temp_bom (");
        createSql.append("FMaterialID VARCHAR(44),");
        createSql.append("FAttr INT,");
        createSql.append("FTrackID  VARCHAR(44),");
        createSql.append("FStrategyID  VARCHAR(44),");
        createSql.append("FParentBomID  VARCHAR(44),");
        createSql.append("FParentID  VARCHAR(44),");
        createSql.append("FLevel INT,");
        createSql.append("FProductLineID  VARCHAR(44),");
        createSql.append("FFormulaID  VARCHAR(44),");
        createSql.append("FPLCEntryId VARCHAR(44))");
        return createSql.toString();
    }

    private String createInitTableSQL() {
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table t_temp_Init (");
        createSql.append("FMaterialID VARCHAR(44),");
        createSql.append("FTrackID  VARCHAR(44),");
        createSql.append("FPLCEntryId VARCHAR(44))");
        return createSql.toString();
    }

    protected String createTempTable(String createTableSQL) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        try {
            return pool.createTempTable(createTableSQL);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void releaseTempTable() {
        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
        pool.releaseTable(this.tempTableName);
        if (this.tempBomTableName != null) {
            pool.releaseTable(this.tempBomTableName);
        }
        if (this.tempInitTableName != null) {
            pool.releaseTable(this.tempInitTableName);
        }
    }

    protected BigDecimal getExchangePrecisionQty(String materialId, String beforeUnitId, String afterUnitId, BigDecimal qty) throws BOSException, EASBizException {
        BigDecimal targetQty = null;
        if (beforeUnitId.equals(afterUnitId)) {
            targetQty = qty;
        } else {
            MultiMeasureUnitInfo multiUnifInfo;
            BigDecimal afterBaseRate;
            MultiMeasureUnitInfo multiUnifInfo2;
            BigDecimal beforeBaseRate = (BigDecimal)this.mmuConvsRate.get(materialId + beforeUnitId);
            if (beforeBaseRate == null && (multiUnifInfo2 = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx).getMultiUnit(materialId, beforeUnitId)) != null) {
                beforeBaseRate = multiUnifInfo2.getBaseConvsRate();
            }
            if ((afterBaseRate = (BigDecimal)this.mmuConvsRate.get(materialId + afterUnitId)) == null && (multiUnifInfo = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx).getMultiUnit(materialId, afterUnitId)) != null) {
                afterBaseRate = multiUnifInfo.getBaseConvsRate();
            }
            if (beforeBaseRate == null) {
                beforeBaseRate = PLSConstant.ONE;
            }
            if (afterBaseRate == null) {
                afterBaseRate = PLSConstant.ONE;
            }
            BigDecimal baseQty = qty.multiply(beforeBaseRate);
            targetQty = baseQty.divide(afterBaseRate, 8, 4);
        }
        return targetQty;
    }

    protected LineCapabilityInfo getLineCapInfo(ProductLineInfo productLine, Timestamp varDate) {
        if (this.lineCaps != null && this.lineCaps.size() > 0) {
            String key = productLine.getId().toString();
            List list = (List)this.lineCaps.get(key);
            if (list == null) {
                return null;
            }
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    LineCapabilityInfo capInfo1 = (LineCapabilityInfo)o1;
                    LineCapabilityInfo capInfo2 = (LineCapabilityInfo)o2;
                    return capInfo2.getBeginTime().compareTo(capInfo1.getBeginTime());
                }
            });
            for (LineCapabilityInfo capInfo : list) {
                if (varDate.compareTo(capInfo.getBeginTime()) < 0 || varDate.compareTo(capInfo.getEndTime()) > 0) continue;
                if (capInfo.getWorkDay().equals((Object)WorkDateTypeEnum.WORKDAY)) {
                    return capInfo;
                }
                varDate = PLSUtil.getDateByLeadTime(varDate, 5, -1);
            }
        }
        return null;
    }

    protected void getPLSEntryInfoList() throws BOSException, EASBizException {
        this.returnList = new ArrayList();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select FPLSEntryid,FQty,FBaseQty,fWorkDate,FBeginTime,FEndTime,FParentID,FProOrder,FLineNum,FClassTeamID,");
        sqlBuffer.append("FMaterialID,FBaseUnitID,FUnitID,FProductLineID,FStorageOrgUnitID,fplcEntryId,fpoEntryId from " + this.tempTableName);
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString());
        try {
            while (rows.next()) {
                String id = rows.getString("FPLSEntryid");
                String storageOrgUnitId = rows.getString("FStorageOrgUnitID");
                String productLineId = rows.getString("FProductLineID");
                Timestamp workDate = rows.getTimestamp("fWorkDate");
                Timestamp beginTime = rows.getTimestamp("FBeginTime");
                Timestamp endTime = rows.getTimestamp("FEndTime");
                String mainPlanId = rows.getString("FParentID");
                BigDecimal proOrder = rows.getBigDecimal("FProOrder");
                String lineNum = rows.getString("FLineNum");
                String classTeamId = rows.getString("FClassTeamID");
                String materialId = rows.getString("FMaterialID");
                String unitId = rows.getString("FUnitID");
                String baseUnitId = rows.getString("FBaseUnitID");
                BigDecimal qty = rows.getBigDecimal("FQty");
                BigDecimal baseQty = rows.getBigDecimal("FBaseQty");
                String plcEntryId = rows.getString("fplcEntryId");
                String poEntryId = rows.getString("fpoEntryId");
                PLSEntryInfo pLSEntryInfo = new PLSEntryInfo();
                pLSEntryInfo.setId(BOSUuid.read((String)id));
                ProductLineInfo productLine = (ProductLineInfo)this.productLineMap.get(productLineId);
                pLSEntryInfo.setProductLine(productLine);
                pLSEntryInfo.setWorkShop(productLine.getWorkshop());
                pLSEntryInfo.setBeginDate(beginTime);
                pLSEntryInfo.setEndDate(endTime);
                String mpKey = materialId + "@" + productLineId;
                BigDecimal period = (BigDecimal)this.outputPeriod.get(mpKey);
                if (period == null) {
                    period = new BigDecimal("0");
                }
                long outputTime = endTime.getTime() + period.multiply(new BigDecimal(3600000)).longValue();
                pLSEntryInfo.setOutputDate(new Timestamp(outputTime));
                MaterialInfo material = (MaterialInfo)this.materialMap.get(materialId);
                pLSEntryInfo.setMaterial(material);
                pLSEntryInfo.setUnit((MeasureUnitInfo)this.unitMap.get(unitId));
                pLSEntryInfo.setQty(qty);
                pLSEntryInfo.setBaseUnit((MeasureUnitInfo)this.unitMap.get(baseUnitId));
                pLSEntryInfo.setBaseQty(baseQty);
                pLSEntryInfo.setLineNum(lineNum);
                pLSEntryInfo.setVarDate(workDate);
                pLSEntryInfo.setRequiredDate(workDate);
                pLSEntryInfo.setSrcType(SrcTypeEnum.MANUAL);
                pLSEntryInfo.setIsSubPlan(true);
                if (this.isToLow) {
                    pLSEntryInfo.setIsExpand(true);
                } else {
                    pLSEntryInfo.setIsExpand(false);
                }
                pLSEntryInfo.setProOrder(proOrder);
                if (classTeamId != null) {
                    ClassTeamEntryInfo classTeam = (ClassTeamEntryInfo)this.classTeams.get(classTeamId);
                    pLSEntryInfo.setClassTeam(classTeam);
                }
                pLSEntryInfo.setMainPlanID(mainPlanId);
                pLSEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                pLSEntryInfo.setEndQty(PLSConstant.ZERO);
                pLSEntryInfo.setPlcEntryId(plcEntryId);
                pLSEntryInfo.setSourceBillEntryId(poEntryId);
                if (ProductionStrategyHelper.isATOorMTO((Context)this.ctx, null, (MaterialInfo)material, (StorageOrgUnitInfo)this.storageOrgUnitInfo)) {
                    pLSEntryInfo.setTrackNumber((TrackNumberInfo)this.trackNumberMap.get(poEntryId));
                }
                String trackNumId = pLSEntryInfo.getTrackNumber() == null ? "" : pLSEntryInfo.getTrackNumber().getId().toString();
                String key = materialId + "@" + productLineId + "@" + trackNumId;
                if (!this.formulaMap.containsKey(key)) {
                    this.formulaMap.put(key, ProductionFormulaHelper.getDefaultFormula((Context)this.ctx, null, (Object)material, (Object)productLine, (Object)pLSEntryInfo.getTrackNumber(), (Object)this.storageOrgUnitInfo, null));
                }
                if (this.formulaMap.get(key) != null) {
                    pLSEntryInfo.setFormula((ProductionFormulaInfo)this.formulaMap.get(key));
                }
                this.returnList.add(pLSEntryInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

