/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.IReqPlanReceiveReqDataFacade;
import com.kingdee.eas.mm.planning.PlanOrderChangeInfo;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.planning.ReqPlanReceiveReqDataFacadeFactory;
import com.kingdee.eas.mm.planning.SOPException;
import com.kingdee.eas.mm.planning.app.AbstractPlanOrderChangeControllerBean;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PlanOrderChangeControllerBean
extends AbstractPlanOrderChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.PlanOrderChangeControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((PlanOrderChangeInfo)model).setChangeTime(new Date());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller(), selector);
        PersonInfo person = user.getPerson();
        ((PlanOrderChangeInfo)model).setChangeUser(person);
        return super._save(ctx, model);
    }

    @Override
    protected void _writeBackPlannedOrder(Context ctx, Map param) throws BOSException, EASBizException {
        BigDecimal totalReleaseQty;
        String plannedOrderChangeId = (String)param.get("PLANEDORDERCHANGEID");
        String planedOrderId = (String)param.get("PLANEDORDERID");
        StringBuffer updateSql = new StringBuffer();
        String clr = "\r\n";
        updateSql.setLength(0);
        updateSql.append(" update T_MM_PlannedOrder as t0 ").append(clr).append(" set (FQty,FBaseQty,FFinalProductsQty,FStartDate,FEndDate,FAvilableDate,FLastUpdateTime,FLastUpdateUserID,FmodificationTime,FModifierId,FTrackId) =  ").append(clr).append(" (select round(decimal(t3.FChangeQty * 1,21,8),t1.FQtyPrecision), ").append(clr).append(" round(decimal(t3.FChangeQty * t1.FBaseConvsRate,21,8),t2.FQtyPrecision), ").append(clr).append(" round(decimal(t3.FChangeQty*(t0.FFinalProductsRate/100),21,8),t1.FQtyPrecision),").append(clr).append(" t3.FStartDateChange,t3.FEndDateChange,t3.FAvilableDateChange,getdate(), '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'").append(clr).append(",getdate(), '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'").append(clr).append(" ,t3.TrackNumberChangeID").append(" from t_bd_multimeasureunit t1,t_bd_multimeasureunit t2,T_MM_PlanOrderChange t3 ").append(clr).append(" where t0.FMaterialID = t1.FMaterialID and t0.FProductUnitID = t1.fmeasureunitid ").append(clr).append(" and t0.FMaterialID = t2.FMaterialID and t0.FUnitID = t2.fmeasureunitid").append(clr).append(" and t3.fid='").append(plannedOrderChangeId).append("'").append(clr).append(" and t0.FID='").append(planedOrderId).append("'").append(")");
        ArrayList<Object> paramLst = new ArrayList<Object>();
        paramLst.clear();
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])paramLst.toArray());
        Date startDate = (Date)param.get("STARTDATE");
        Date startChangeDate = (Date)param.get("STARTCHANGEDATE");
        BigDecimal qty = (BigDecimal)param.get("QTY");
        BigDecimal changeQty = (BigDecimal)param.get("CHANGEQTY");
        String storageOrgUnitId = (String)param.get("STORAGEORGUNITID");
        if ((PlannedOrderTypeEnum)((Object)param.get("PLANEDORDERTYPE")) == PlannedOrderTypeEnum.FABRICATED || (PlannedOrderTypeEnum)((Object)param.get("PLANEDORDERTYPE")) == PlannedOrderTypeEnum.STOCKTRANSFER) {
            IRowSet row;
            StringBuffer querySql = new StringBuffer();
            if (this.equalDate(startChangeDate, startDate)) {
                querySql.setLength(0);
                querySql.append(" select caentry.FWorkDateSeq ").append(" from T_MM_FactoryCalendar ca ").append(" inner join T_MM_FactoryCalendarEntry caentry on ca.FID = caentry.FParentID ").append(" where ca.FStorageOrgUnitID = ? ").append(" and caentry.FWorkDate in (?,?) order by caentry.FWorkDateSeq");
                paramLst.clear();
                paramLst.add(storageOrgUnitId);
                paramLst.add(startDate);
                paramLst.add(startChangeDate);
                row = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])paramLst.toArray());
                int[] startWorkDateSeq = new int[2];
                int i = 0;
                try {
                    while (row.next()) {
                        startWorkDateSeq[i] = row.getInt("FWorkDateSeq");
                        ++i;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                int datenum = startWorkDateSeq[1] - startWorkDateSeq[0];
                if (this.lessDate(startDate, startChangeDate)) {
                    datenum = -datenum;
                }
                updateSql.setLength(0);
                updateSql.append("update T_MM_PlannedOrderEntry as t8 set (FReqDate) = ").append(clr).append(" ( ").append(clr).append(" select t7.FWorkDate from ").append(clr).append(" (select  t5.FPlannedOrderEntryId, t6.FWorkDate from ").append(clr).append(" (select  t3.FPlannedOrderEntryId,(t4.FWorkDateSeq+to_number(").append(new Integer(datenum)).append(")) fworddateChangeSeq  from ").append(clr).append(" (select ").append(clr).append(" t1.fid FPlannedOrderEntryId, t1.FReqDate FReqDate, t1.FDemandQty FDemandQty, t2.fid FPlannedOrderId, t2.fnumber fnumber ").append(clr).append(" from T_MM_PlannedOrderEntry t1 inner join T_MM_PlannedOrder t2 on t1.FParentID = t2.fid ").append(clr).append(" where t2.fid = ? ) t3 inner join ").append(clr).append(" (select caentry.FWorkDateSeq, caentry.FWorkDate ").append(clr).append(" from T_MM_FactoryCalendar ca ").append(clr).append(" inner join T_MM_FactoryCalendarEntry caentry on ca.FID = caentry.FParentID ").append(clr).append(" where ca.FStorageOrgUnitID = ? ) t4 ").append(clr).append(" on t3.FReqDate = t4.FWorkDate) t5 inner join").append(clr).append(" (select  caentry.FWorkDateSeq, caentry.FWorkDate ").append(clr).append(" from T_MM_FactoryCalendar ca ").append(clr).append(" inner join T_MM_FactoryCalendarEntry caentry on ca.FID = caentry.FParentID ").append(clr).append(" where ca.FStorageOrgUnitID = ?) t6 ").append(clr).append(" on t5.fworddateChangeSeq = t6.FWorkDateSeq) as t7 ").append(clr).append(" where t8.fid=t7.FPlannedOrderEntryId ").append(clr).append(" ) ").append(clr);
                paramLst.clear();
                paramLst.add(planedOrderId);
                paramLst.add(storageOrgUnitId);
                paramLst.add(storageOrgUnitId);
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])paramLst.toArray());
            }
            if (changeQty.compareTo(qty) != 0) {
                int defaultPrec = 20;
                BigDecimal changeRate = changeQty.divide(qty, defaultPrec, 3);
                BigDecimal changeBaseRate = changeQty.divide(qty, defaultPrec, 3);
                querySql.setLength(0);
                querySql.append(" select t3.fid fid,t3.FDemandQty FDemandQty, t3.FBaseDemandQty FBaseDemandQty, ").append(clr).append(" t1.FQtyPrecision FQtyPrecision, t2.FQtyPrecision FBaseQtyPrecision, ").append(clr).append(" t3.FUnitQty FUnitQty ").append(clr).append(" from T_MM_PlannedOrderEntry t3,T_MM_PlannedOrder t0,t_bd_multimeasureunit t2,t_bd_multimeasureunit t1 ").append(clr).append(" where t3.FParentID = t0.fid ").append(clr).append(" and t3.FMaterialID = t1.FMaterialID and t3.FUnitID = t1.fmeasureunitid ").append(clr).append(" and t3.FMaterialID = t2.FMaterialID and t3.FBaseUnitID = t2.fmeasureunitid ").append(clr).append(" and t0.FID = ? ");
                paramLst.clear();
                paramLst.add(planedOrderId);
                row = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])paramLst.toArray());
                ArrayList<String> plannedOrderEntryIds = new ArrayList<String>();
                HashMap<String, BigDecimal> demandQtyMap = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> baseDemandQtyMap = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> standardQtyMap = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> scrapQtyMap = new HashMap<String, BigDecimal>();
                int qtyPrecision = 0;
                int baseQtyPrecision = 0;
                BigDecimal demandQty = null;
                BigDecimal standardQty = null;
                try {
                    while (row.next()) {
                        qtyPrecision = row.getInt("FQtyPrecision");
                        baseQtyPrecision = row.getInt("FBaseQtyPrecision");
                        demandQty = row.getBigDecimal("FDemandQty").multiply(changeRate).setScale(qtyPrecision, 2);
                        plannedOrderEntryIds.add(row.getString("fid"));
                        demandQtyMap.put(row.getString("fid"), demandQty);
                        baseDemandQtyMap.put(row.getString("fid"), row.getBigDecimal("FBaseDemandQty").multiply(changeBaseRate).setScale(baseQtyPrecision, 2));
                        standardQty = changeQty.multiply(row.getBigDecimal("FUnitQty")).setScale(qtyPrecision, 2);
                        standardQtyMap.put(row.getString("fid"), standardQty);
                        scrapQtyMap.put(row.getString("fid"), demandQty.subtract(standardQty));
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (plannedOrderEntryIds.size() > 0) {
                    Connection conn = null;
                    PreparedStatement stmt = null;
                    try {
                        conn = EJBFactory.getConnection((Context)ctx);
                        updateSql.setLength(0);
                        updateSql.append(" update T_MM_PlannedOrderEntry as t3 set FDemandQty=?,FBaseDemandQty=?").append(clr).append(",FStandardQty=?,FScrapQty=?  where t3.fid = ? ").append(clr);
                        String sql_t = updateSql.toString();
                        stmt = conn.prepareStatement(sql_t);
                        String poEntryId = null;
                        int n = plannedOrderEntryIds.size();
                        for (int j = 0; j < n; ++j) {
                            poEntryId = (String)plannedOrderEntryIds.get(j);
                            stmt.setBigDecimal(1, (BigDecimal)demandQtyMap.get(poEntryId));
                            stmt.setBigDecimal(2, (BigDecimal)baseDemandQtyMap.get(poEntryId));
                            stmt.setBigDecimal(3, (BigDecimal)standardQtyMap.get(poEntryId));
                            stmt.setBigDecimal(4, (BigDecimal)scrapQtyMap.get(poEntryId));
                            stmt.setString(5, poEntryId);
                            stmt.addBatch();
                        }
                        stmt.executeBatch();
                    }
                    catch (SQLException e1) {
                        try {
                            throw new SOPException(SOPException.AVERAGE_EXCEPTION);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(stmt, (Connection)conn);
                            throw throwable;
                        }
                    }
                    SQLUtils.cleanup((Statement)stmt, (Connection)conn);
                }
            }
        }
        if ((totalReleaseQty = (BigDecimal)param.get("TOTALQTY")).compareTo(changeQty) == 0) {
            updateSql.setLength(0);
            updateSql.append(" update T_MM_PlannedOrder set FBaseStatus =  ?").append(clr).append(" where fid = ? ").append(clr);
            paramLst.clear();
            paramLst.add(new Integer(BillBaseStatusEnum.CLOSED.getValue()));
            paramLst.add(planedOrderId);
            DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])paramLst.toArray());
        }
        this.afterPlanOrderChange(ctx, param);
        try {
            this.updateReqPlanData(ctx, planedOrderId, BizActionEnum.ALTER, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _isValidateCalendar(Context ctx, String orgUnitId, Date paramDate) throws BOSException, EASBizException {
        Object result = null;
        String sqlTableName = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = sdf.format(paramDate);
        boolean iDay = false;
        StringBuffer querySql = new StringBuffer();
        querySql.setLength(0);
        querySql.append(" select caentry.FWorkDateSeq ").append(" from T_MM_FactoryCalendar ca ").append(" inner join T_MM_FactoryCalendarEntry caentry on ca.FID = caentry.FParentID ").append(" where ca.FStorageOrgUnitID = ? ").append(" and caentry.FWorkDate = to_date(?||' 00:00:00')");
        ArrayList<String> paramLst = new ArrayList<String>();
        paramLst.clear();
        paramLst.add(orgUnitId);
        paramLst.add(sDate);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])paramLst.toArray());
        if (rs == null) {
            return false;
        }
        try {
            if (rs.next()) {
                return rs.getInt("FWorkDateSeq") > 0;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected Set _getVisibleOrgIDs(Context ctx, String id) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        String[] stoIds = id.split(",");
        StringBuffer idStr = new StringBuffer();
        idStr.append("'null'");
        for (int i = 0; i < stoIds.length; ++i) {
            if (stoIds[i] == null) continue;
            idStr.append(",'").append(stoIds[i].trim()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FToUnitID FToUnitID from T_ORG_UnitRelation t \n");
        sql.append("  inner join T_ORG_TypeRelation r on t.FTypeRelationID=r.FID \n");
        sql.append("where t.FFromUnitID in (").append(idStr).append(") \n");
        sql.append("and r.FFromType=").append(4);
        sql.append(" and r.FToType=").append(0);
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                idSet.add(rs.getString("FToUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return idSet;
    }

    private Set getVisibleOrgIDs(Context ctx, BOSObjectType objectType, IObjectPK ctrlUnitPK) throws EASBizException, BOSException {
        HashSet<String> set = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        CtrlUnitInfo cui = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(ctrlUnitPK, sic);
        String longNumber = cui.getLongNumber();
        int level = cui.getLevel();
        set.add(cui.getId().toString());
        StringBuffer sql = new StringBuffer(500);
        sql.append("select cu1.FID,cu1.FLevel,cu1.FLongNumber from T_ORG_CtrlUnit cu1 ,").append("T_ORG_CtrlUnit cu2 where SUBSTRING(cu2.FLongNumber,0,LENGTH(cu1.FLongNumber) + 1 )").append(" = cu1.FLongNumber || '!' and cu2.FLongNumber = ? order by cu1.FLevel asc");
        Object[] params = new String[]{longNumber};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        int baselevel = -1;
        int currentlevel = -1;
        String ctrlUnitID = "";
        String parentCtrlUnitID = "";
        try {
            while (rs.next()) {
                ctrlUnitID = rs.getString("FID").trim();
                set.add(ctrlUnitID);
            }
        }
        catch (SQLException e) {
            throw new DataBaseDException(DataBaseDException.GET_FILTER_FAIL, (Throwable)e);
        }
        return set;
    }

    private boolean equalDate(Date start, Date end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int startDay = Integer.parseInt(dateFormat.format(start).toString());
        int endDay = Integer.parseInt(dateFormat.format(end).toString());
        boolean result = false;
        if (endDay - startDay != 0) {
            result = true;
        }
        return result;
    }

    private boolean lessDate(Date start, Date end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int startDay = Integer.parseInt(dateFormat.format(start).toString());
        int endDay = Integer.parseInt(dateFormat.format(end).toString());
        boolean result = false;
        if (endDay - startDay < 0) {
            result = true;
        }
        return result;
    }

    private void updateReqPlanData(Context ctx, String idStr, BizActionEnum bizAction, boolean isForSimulateTransfer) throws Exception {
        IReqPlanReceiveReqDataFacade reqPlanReceiveReqDataFacade = ReqPlanReceiveReqDataFacadeFactory.getLocalInstance(ctx);
        reqPlanReceiveReqDataFacade.receiveReqPlanDate("9XXvbVGlRtym/0qtqeIXXrhE1B8=", "'" + idStr + "'", bizAction);
    }

    private String createTmpReqPlanDataTable(Context ctx) throws Exception {
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append(" CREATE TABLE tmpReqPlanData (");
        createTableSQL.append(" fID varchar(44),");
        createTableSQL.append(" FSrcBillID varchar(44),");
        createTableSQL.append(" FSrcBILLTYPEID varchar(44),");
        createTableSQL.append(" FSrcEntryID varchar(44),");
        createTableSQL.append(" fStorageOrgUnitID varchar(44),");
        createTableSQL.append(" fEntryStorageOrgUnitID varchar(44),");
        createTableSQL.append(" fBillID varchar(44),");
        createTableSQL.append(" FEntryID varchar(44),");
        createTableSQL.append(" fSeq INT DEFAULT 0 NOT NULL,");
        createTableSQL.append(" fNumber NVARCHAR(80),");
        createTableSQL.append(" FBILLTYPEID varchar(44),");
        createTableSQL.append(" fRequireDate DateTime,");
        createTableSQL.append(" fMaterialID varchar(44),");
        createTableSQL.append(" fUnitID varchar(44),");
        createTableSQL.append(" fBaseUnitID varchar(44),");
        createTableSQL.append(" fQty NUMERIC(21,8) not null default 0,");
        createTableSQL.append(" fBaseQty NUMERIC(21,8) not null default 0,");
        createTableSQL.append(" fOriginType INT,");
        createTableSQL.append(" fOperationType INT,");
        createTableSQL.append(" fCreatorID varchar(44),");
        createTableSQL.append(" fCreateTime DateTime,");
        createTableSQL.append(" fFailTimes INT DEFAULT 0 NOT NULL,");
        createTableSQL.append(" fProjectID varchar(44),");
        createTableSQL.append(" fTrackNumberID varchar(44),");
        createTableSQL.append(" fIsDirectTransport INT)");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL.toString());
    }

    protected void afterPlanOrderChange(Context ctx, Map param) throws BOSException, EASBizException {
    }
}

