/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetCollection;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.planning.PlannedOrderCommSchedulingMaterialData;
import com.kingdee.eas.mm.planning.PlannedOrderReleaseEnum;
import com.kingdee.eas.mm.planning.PlanningParamValueCollection;
import com.kingdee.eas.mm.planning.PlanningParamValueFactory;
import com.kingdee.eas.mm.planning.PlanningParamValueInfo;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.app.AbstractPlannedOrderCommSchedulingFacadeControllerBean;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunningTablesInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlannedOrderCommSchedulingFacadeControllerBean
extends AbstractPlannedOrderCommSchedulingFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.PlannedOrderCommSchedulingFacadeControllerBean");
    private static final String TABLE_NAME = "t_mm_comshceduling";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String periodTempName = params.getString("periodTempName");
        String tempTable = params.getString("tempTable");
        int editModeEnumType = 0;
        String mDateComBox = params.getString("mDate");
        String mWeekCombox = params.getString("mWeek");
        String mMonthCombox = params.getString("mMonth");
        if (mDateComBox != null && mDateComBox.equals("true")) {
            editModeEnumType = 0;
        }
        if (mWeekCombox != null && mWeekCombox.equals("true")) {
            editModeEnumType = 10;
        }
        if (mMonthCombox != null && mMonthCombox.equals("true")) {
            editModeEnumType = 20;
        }
        boolean moni = params.getBoolean("moni");
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd");
        Date planDateFrom = null;
        Date planDateTo = null;
        try {
            planDateFrom = time.parse(params.getString("planDateFrom").substring(0, 11));
            planDateTo = time.parse(params.getString("planDateTo").substring(0, 11));
        }
        catch (ParseException e1) {
            throw new BOSException((Throwable)e1);
        }
        OrgUnitInfo storageOrgUnitInfo = null;
        if (params.getObject("storageOrgUnitId") != null) {
            storageOrgUnitInfo = (OrgUnitInfo)params.getObject("storageOrgUnitId");
        } else {
            storageOrgUnitInfo = new OrgUnitInfo();
            storageOrgUnitInfo.setId(BOSUuid.read((String)params.getString("storageOrgUnit.id")));
        }
        String[] sql = null;
        String middletalbe = null;
        try {
            sql = this.getMRPrunTableDate(ctx, params, storageOrgUnitInfo, moni);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        tempTable = this.createTempTable(ctx);
        String materialTempTable = this.createTempTableMaterial(ctx);
        middletalbe = sql[4];
        String insertSql = "insert  into " + tempTable + " (FMATERIALID,FBILLDATE,qty,ftype,fperiodnumber) ";
        DbUtil.execute((Context)ctx, (String)(insertSql + sql[0]));
        DbUtil.execute((Context)ctx, (String)(insertSql + sql[1]));
        DbUtil.execute((Context)ctx, (String)(insertSql + sql[2]));
        DbUtil.execute((Context)ctx, (String)(insertSql + sql[3]));
        StringBuffer insertMaterial = new StringBuffer();
        insertMaterial.append("insert into ");
        insertMaterial.append(materialTempTable);
        insertMaterial.append(" (KSQL_SEQ,FMaterialID,FBaseConvsRate,FQtyPrecision,FModel,fnumber,FMaterialName,FUnitName,FPlanStrategy) ");
        insertMaterial.append("select distinct t.FMaterialID,t6.FBaseConvsRate,t6.FQtyPrecision,t2.FModel,t2.FNumber as fnumber,");
        insertMaterial.append(" t2.FName_").append(ctx.getLocale()).append(" FMaterialName,");
        insertMaterial.append(" t4.FName_").append(ctx.getLocale()).append(" FUnitName,");
        insertMaterial.append(" t3.FManufactureStrategyID FPlanStrategy ");
        insertMaterial.append(" from ");
        insertMaterial.append(tempTable);
        insertMaterial.append(" t LEFT OUTER JOIN T_BD_Material t2  on t.FMaterialID =t2.fid  ");
        insertMaterial.append("LEFT OUTER JOIN T_BD_MaterialPlan  t3  on t.FMaterialID =t3.FMaterialID  and  t3.forgunit = '");
        insertMaterial.append(storageOrgUnitInfo.getId().toString());
        insertMaterial.append("' LEFT OUTER JOIN T_BD_MeasureUnit t4 on  t3.FProductUnitID =t4.fid  ");
        insertMaterial.append("LEFT OUTER JOIN t_bd_multimeasureunit t6  on  t.FMaterialID =t6.fmaterialid and t3.FProductUnitID= t6.fmeasureunitid  ");
        insertMaterial.append("order by fnumber ");
        DbUtil.execute((Context)ctx, (String)insertMaterial.toString());
        this._dropPoolTempTable(ctx, middletalbe);
        List periodList = null;
        HashMap workdates = null;
        if (editModeEnumType != 0) {
            periodList = this.getBySOPFacadePeriod(ctx, storageOrgUnitInfo.getId().toString(), planDateFrom, planDateTo, editModeEnumType);
            periodTempName = this.createProidTempTable(ctx, storageOrgUnitInfo.getId().toString(), planDateFrom, planDateTo, periodList, periodTempName);
        } else {
            periodList = this.getDateFormToDate(planDateFrom, planDateTo);
            workdates = (HashMap)this.getFactoryCalendar(ctx, storageOrgUnitInfo.getId().toString(), planDateFrom, planDateTo);
        }
        if (editModeEnumType != 0) {
            StringBuffer updataSQL = new StringBuffer();
            updataSQL.append(" update ").append(tempTable).append(" as x  set (fperiodnumber) = ").append("( select y.fnumber from   ").append(periodTempName).append(" y where     to_date(x.fbilldate||' 00:00:00') >= to_date(y.fstartdate||' 00:00:00') ").append(" and to_date(x.fbilldate").append("||' 00:00:00')<= to_date(y.fenddate||' 00:00:00')  ) ");
            DbUtil.execute((Context)ctx, (String)(" update " + tempTable + " set  fperiodnumber = 0 "));
            DbUtil.execute((Context)ctx, (String)updataSQL.toString());
        }
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FStorageOrgUnitID");
        col.setWidth(80);
        col.setAligment(1);
        header.addColumn(col);
        col = new RptTableColumn("fmaterialid");
        col.setWidth(80);
        col.setAligment(1);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialAttr");
        col.setWidth(80);
        col.setAligment(1);
        header.addColumn(col);
        col = new RptTableColumn("FPlanningMode");
        col.setWidth(80);
        col.setAligment(1);
        header.addColumn(col);
        col = new RptTableColumn("fnumber");
        col.setWidth(80);
        col.setAligment(0);
        header.addColumn(col);
        col = new RptTableColumn("name");
        col.setWidth(80);
        col.setAligment(0);
        header.addColumn(col);
        col = new RptTableColumn("FModel");
        col.setWidth(80);
        col.setAligment(0);
        header.addColumn(col);
        col = new RptTableColumn("uname");
        col.setWidth(80);
        col.setAligment(0);
        header.addColumn(col);
        col = new RptTableColumn("FQtyPrecision");
        col.setWidth(80);
        col.setAligment(1);
        header.addColumn(col);
        col = new RptTableColumn("periodQty");
        col.setWidth(80);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("ftype");
        col.setWidth(80);
        col.setAligment(0);
        header.addColumn(col);
        col = new RptTableColumn("suma");
        col.setWidth(80);
        col.setAligment(2);
        header.addColumn(col);
        if (editModeEnumType != 0) {
            for (int i = 0; i < periodList.size(); ++i) {
                SOPPeriod temp = (SOPPeriod)periodList.get(i);
                col = new RptTableColumn(temp.toNumber() + "");
                col.setWidth(80);
                col.setAligment(1);
                header.addColumn(col);
            }
        } else {
            SimpleDateFormat time1 = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < periodList.size(); ++i) {
                Date temp = (Date)periodList.get(i);
                col = new RptTableColumn(time1.format(temp));
                col.setWidth(80);
                col.setAligment(1);
                header.addColumn(col);
            }
        }
        this.setLabels(header, ctx, periodList, editModeEnumType);
        String totalSql = this.createTotalSql(ctx, params, storageOrgUnitInfo, moni);
        totalSql = totalSql + " as t0";
        String totalTablename = this.createTempTable(totalSql.toString(), null, ctx);
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append("update ").append(materialTempTable).append(" as t0 set(FQty) = ");
        sqlUpdate.append("(select PERIODQTY from ");
        sqlUpdate.append(totalTablename);
        sqlUpdate.append("  t1 where t0.FMaterialID = t1.fMaterialId) ");
        DbUtil.execute((Context)ctx, (String)sqlUpdate.toString());
        this._dropPoolTempTable(ctx, totalTablename);
        RptParams result = new RptParams();
        if (editModeEnumType == 0) {
            result.setObject("workdate", (Object)workdates);
        }
        this.selectResult(ctx, materialTempTable, tempTable, result, 0, 13, storageOrgUnitInfo.getId().toString());
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setObject("periodList", (Object)periodList);
        result.setObject("period", (Object)new Integer(editModeEnumType));
        result.setString("periodTempName", periodTempName);
        return result;
    }

    private String createTotalSql(Context ctx, RptParams params, OrgUnitInfo storageOrgUnitInfo, boolean moni) throws BOSException, EASBizException {
        Date planDateFrom;
        Map table = this.getMRPTable(ctx, params, storageOrgUnitInfo, moni);
        String mrpDetail = (String)table.get("detail");
        String mrpMateril = (String)table.get("material");
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd");
        try {
            planDateFrom = time.parse(params.getString("planDateFrom").substring(0, 11));
        }
        catch (ParseException e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select fmaterialid,round(decimal( (fplannOrderCoByProductQty+fplannedOrderQty+frequirementPlanQty +fparentPlanOrderQty+fouterOrderQty + ");
        sql.append("isnull(FOnHand,0)-isnull(FSafeStock,0))/to_number(FConvertRate),21,8),FProdQtyPrc) as periodQty  ");
        sql.append("from ( select  mrpMaterial.fMaterialId,");
        sql.append("case when mrpMaterial.FPlanStrategy='").append("NUnM+gEcEADgAA3ewKgL09g0uEU=");
        sql.append("' then 0 else mrpMaterial.FSafeStock end as FSafeStock,");
        sql.append("mrpMaterial.FConvertRate, ");
        sql.append("(case when mrpMaterial.FPlanStrategy='").append("NUnM+gEcEADgAA3ewKgL09g0uEU=").append("' then 0 \n");
        sql.append("when mrpMaterial.FPlanStrategy in ('");
        sql.append("NUnM+gEcEADgAA3gwKgL09g0uEU=").append("','").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','");
        sql.append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("'");
        sql.append(") then stockSum.fstorck  \n");
        sql.append(" else  mrpMaterial.fonhand end) as FOnHand , \n");
        sql.append("mrpMaterial.FProdQtyPrc, isnull(periodStock.fplannedOrderQty,0) fplannedOrderQty, ");
        sql.append("isnull(periodStock.fplannOrderCoByProductQty,0) fplannOrderCoByProductQty ,isnull(periodStock.frequirementPlanQty,0) frequirementPlanQty,");
        sql.append("isnull(periodStock.fparentPlanOrderQty,0) fparentPlanOrderQty,isnull(periodStock.fouterOrderQty,0) fouterOrderQty, ");
        sql.append(" mrpMaterial.FPlanStrategy FPlanStrategy ");
        sql.append("from ").append(mrpMateril).append(" mrpMaterial  ");
        sql.append(" left outer join  ");
        sql.append("(select   fmaterialid , ");
        sql.append(" sum( case when mrpDetail.fmrpitem = 250   or   mrpDetail.fmrpitem = 240   or   mrpDetail.fmrpitem = 235  ");
        sql.append(" or  mrpDetail.fmrpitem = 230 or  mrpDetail.fmrpitem = 207   or  mrpDetail.fmrpitem = 209  ");
        sql.append(" or  mrpDetail.fmrpitem = 210  or   mrpDetail.fmrpitem = 220  or   mrpDetail.fmrpitem = 200 ");
        sql.append(" or  mrpDetail.fmrpitem = 205  or  mrpDetail.fmrpitem = 270  or  mrpDetail.fmrpitem = 260  then mrpDetail.FSR else 0 end) as fplannedOrderQty,");
        sql.append("sum(case when mrpDetail.fmrpitem = 251 then mrpDetail.fdependent else 0 end ) as fplannOrderCoByProductQty,");
        sql.append("sum(case when mrpDetail.fmrpitem = 300 or mrpDetail.fmrpitem = 310 or mrpDetail.fmrpitem = 320 or ");
        sql.append(" mrpDetail.fmrpitem = 400  or mrpDetail.fmrpitem = 331 or  ");
        sql.append(" mrpDetail.fmrpitem = 330  or mrpDetail.fmrpitem = 390  then mrpDetail.findependent else 0  end ) as frequirementPlanQty,");
        sql.append(" sum(case when mrpDetail.fmrpitem = 340    ");
        sql.append(" then mrpDetail.fdependent - mrpDetail.fsr else 0 end ) as fparentPlanOrderQty,");
        sql.append(" sum(case when mrpDetail.fmrpitem = 365   or  mrpDetail.fmrpitem = 350  or mrpDetail.fmrpitem = 360 ");
        sql.append(" or mrpDetail.fmrpitem = 370  or  mrpDetail.fmrpitem = 380 ");
        sql.append(" then mrpDetail.fdependent else 0 end ) as fouterOrderQty  from ");
        sql.append(mrpDetail);
        sql.append(" mrpDetail where  mrpDetail.FSupplyType<10930 and fbilldate < to_date('").append(time.format(planDateFrom)).append("'||' 00:00:00')");
        sql.append("group by mrpDetail.fMaterialId ) as periodStock   ");
        sql.append("on mrpMaterial.fmaterialid  = periodStock.fmaterialid ");
        sql.append(" left outer join (select fMaterialId, sum(case when fmrpitem = 110 then FAvaliable else 0 end) as fstorck \n");
        sql.append(" from ").append(mrpDetail).append(" detail group by detail.fMaterialId) as stockSum ");
        sql.append(" on mrpMaterial.fmaterialid = stockSum.fmaterialid )");
        return sql.toString();
    }

    private String getBegginPerionStock(Context ctx, RptParams params, OrgUnitInfo storageOrgUnitInfo, boolean moni) throws EASBizException, BOSException {
        Date planDateFrom;
        Map table = this.getMRPTable(ctx, params, storageOrgUnitInfo, moni);
        String mrpDetail = (String)table.get("detail");
        String mrpMateril = (String)table.get("material");
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd");
        try {
            planDateFrom = time.parse(params.getString("planDateFrom").substring(0, 11));
        }
        catch (ParseException e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer commonSql = new StringBuffer();
        commonSql.append(" select fmaterialid,round(decimal(");
        commonSql.append(" (fplannOrderCoByProductQty+fplannedOrderQty+frequirementPlanQty");
        commonSql.append(" +fparentPlanOrderQty+fouterOrderQty + isnull(");
        commonSql.append("(case when mrpMaterial.FPlanStrategy in ('");
        commonSql.append("NUnM+gEcEADgAA3gwKgL09g0uEU=").append("','").append("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=").append("','");
        commonSql.append("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=").append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=").append("'");
        commonSql.append(") then periodStock.fstorck  \n");
        commonSql.append(" else  to_number(fonhand) end), 0)\n");
        commonSql.append("-isnull(FSafeStock,0))/FConvertRate,21,8),FProdQtyPrc) as periodQty ");
        commonSql.append(" from ( select  mrpMaterial.fMaterialId,");
        commonSql.append("mrpMaterial.FOnHand,mrpMaterial.FSafeStock,mrpMaterial.FConvertRate, ");
        commonSql.append("mrpMaterial.FProdQtyPrc, isnull(periodStock.fplannedOrderQty,0) fplannedOrderQty,");
        commonSql.append("isnull(periodStock.fplannOrderCoByProductQty,0) fplannOrderCoByProductQty ,");
        commonSql.append("isnull(periodStock.frequirementPlanQty,0) frequirementPlanQty,");
        commonSql.append("isnull(periodStock.fparentPlanOrderQty,0) fparentPlanOrderQty,");
        commonSql.append("isnull(periodStock.fouterOrderQty,0) fouterOrderQty ");
        commonSql.append("from ");
        commonSql.append(mrpMateril);
        commonSql.append(" mrpMaterial  left outer join (select ");
        commonSql.append(" sum(case when fmrpitem = 110 then FAvaliable else 0 end)  as fstorck , \n");
        commonSql.append(" fmaterialid ,sum( case when mrpDetail.fmrpitem = 250   or   mrpDetail.fmrpitem = 240   or   mrpDetail.fmrpitem = 235   ");
        commonSql.append(" or  mrpDetail.fmrpitem = 230 or  mrpDetail.fmrpitem = 207   or  mrpDetail.fmrpitem = 209  ");
        commonSql.append(" or  mrpDetail.fmrpitem = 210  or   mrpDetail.fmrpitem = 220  or   mrpDetail.fmrpitem = 200 ");
        commonSql.append(" or  mrpDetail.fmrpitem = 205  or  mrpDetail.fmrpitem = 270  or  mrpDetail.fmrpitem = 260  then mrpDetail.FSR else 0 end) as fplannedOrderQty,");
        commonSql.append("sum(case when mrpDetail.fmrpitem = 251 then mrpDetail.fdependent else 0 end ) as fplannOrderCoByProductQty,");
        commonSql.append("sum(case when mrpDetail.fmrpitem = 300 or mrpDetail.fmrpitem = 310 or mrpDetail.fmrpitem = 320 or ");
        commonSql.append(" mrpDetail.fmrpitem = 400  or mrpDetail.fmrpitem = 331 or  ");
        commonSql.append(" mrpDetail.fmrpitem = 330  or mrpDetail.fmrpitem = 390  then mrpDetail.findependent else 0  end ) as frequirementPlanQty,");
        commonSql.append(" sum(case when mrpDetail.fmrpitem = 340    ");
        commonSql.append(" then mrpDetail.fdependent - mrpDetail.fsr else 0 end ) as fparentPlanOrderQty,");
        commonSql.append(" sum(case when mrpDetail.fmrpitem = 365   or  mrpDetail.fmrpitem = 350  or mrpDetail.fmrpitem = 360 ");
        commonSql.append(" or mrpDetail.fmrpitem = 370  or  mrpDetail.fmrpitem = 380 ");
        commonSql.append(" then mrpDetail.fdependent else 0 end ) as fouterOrderQty  from ");
        commonSql.append(mrpDetail);
        commonSql.append(" mrpDetail where fbilldate < to_date('").append(time.format(planDateFrom)).append("'||' 00:00:00')");
        commonSql.append("  group by mrpDetail.fMaterialId");
        commonSql.append(" ) as periodStock  ");
        commonSql.append("  on mrpMaterial.fmaterialid  = periodStock.fmaterialid )");
        return commonSql.toString();
    }

    private void selectResult(Context ctx, String materialTempTable, String tempTable, RptParams params, int from, int len, String orgId) throws BOSException, EASBizException {
        params.setString("materialTable", materialTempTable);
        StringBuffer sql = new StringBuffer();
        sql.append(" select FMaterialID,FBaseConvsRate,FQtyPrecision,FModel,fnumber,FMaterialName,FUnitName,");
        sql.append(" FQty,FPlanStrategy from ");
        sql.append(materialTempTable);
        sql.append(" where KSQL_SEQ >= ");
        sql.append(from + 1);
        sql.append(" AND KSQL_SEQ <= ");
        sql.append(from + len);
        IRowSet rsMaterial = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, PlannedOrderCommSchedulingMaterialData> materialDatas = new HashMap<String, PlannedOrderCommSchedulingMaterialData>();
        PlannedOrderCommSchedulingMaterialData data = null;
        StringBuffer filter = new StringBuffer();
        ArrayList<String> materialIDs = new ArrayList<String>();
        try {
            while (rsMaterial != null && rsMaterial.next()) {
                data = new PlannedOrderCommSchedulingMaterialData();
                String materialID = rsMaterial.getString("FMaterialID");
                materialIDs.add(materialID);
                data.setMaterialID(materialID);
                data.setBaseConvsRate(rsMaterial.getBigDecimal("FBaseConvsRate"));
                data.setQtyPrecision(rsMaterial.getInt("FQtyPrecision"));
                data.setModel(rsMaterial.getString("FModel"));
                data.setName(rsMaterial.getString("FMaterialName"));
                data.setNumber(rsMaterial.getString("FNumber"));
                data.setUnitName(rsMaterial.getString("FUnitName"));
                data.setOrgID(orgId);
                data.setOnHandQty(rsMaterial.getBigDecimal("FQty"));
                data.setPlanStrategyId(rsMaterial.getString("FPlanStrategy"));
                materialDatas.put(materialID, data);
                filter.append("'");
                filter.append(rsMaterial.getString("FMaterialID"));
                filter.append("',");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (filter == null || filter.length() == 0) {
            return;
        }
        sql.setLength(0);
        sql.append("select fmaterialid, Qty,ftype,FPERIODNUMBER,FBillDate from ");
        sql.append(tempTable);
        sql.append(" where fmaterialid in (");
        sql.append(filter.substring(0, filter.length() - 1));
        sql.append(") order by fmaterialid");
        IRowSet rsDatas = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rsDatas != null && rsDatas.next()) {
                String materialID = rsDatas.getString("fmaterialid");
                int type = rsDatas.getInt("ftype");
                BigDecimal qty = rsDatas.getBigDecimal("Qty");
                BigDecimal peroid = rsDatas.getBigDecimal("FPERIODNUMBER");
                String billDate = rsDatas.getString("FBillDate");
                data = (PlannedOrderCommSchedulingMaterialData)materialDatas.get(materialID);
                if (peroid.compareTo(new BigDecimal("0")) == 0) {
                    data.add(type, billDate, qty);
                    continue;
                }
                String key = String.valueOf(peroid.intValue());
                data.add(type, key, qty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList materialdata = new ArrayList();
        for (int i = 0; i < materialIDs.size(); ++i) {
            materialdata.add(materialDatas.get(materialIDs.get(i)));
        }
        params.setObject("result", materialdata);
    }

    private void setLabels(RptTableHeader header, Context ctx, List periodList, int sSOPEditModeEnum) {
        Object[][] labels = null;
        SimpleDateFormat time = new SimpleDateFormat("yyyy.MM.dd");
        if (sSOPEditModeEnum == 0) {
            SimpleDateFormat time1 = new SimpleDateFormat("yyyy-MM-dd");
            labels = new Object[1][12 + periodList.size()];
            labels[0][0] = this.getResouce("ORGUNITID", ctx);
            labels[0][1] = this.getResouce("MATERIAID", ctx);
            labels[0][2] = this.getResouce("PLANNEDORDER", ctx);
            labels[0][3] = this.getResouce("MATERIAIDNATTON", ctx);
            labels[0][4] = this.getResouce("MATERIANUMBER", ctx);
            labels[0][5] = this.getResouce("MATERIANAME", ctx);
            labels[0][6] = this.getResouce("MATERIANORDERGUI", ctx);
            labels[0][7] = this.getResouce("MATERIAUNIT", ctx);
            labels[0][8] = this.getResouce("MATERQINGDU", ctx);
            labels[0][9] = this.getResouce("42_qichukucn", ctx);
            labels[0][10] = this.getResouce("41_liebie", ctx);
            labels[0][11] = this.getResouce("MATERRHEJI", ctx);
            for (int i = 0; i < periodList.size(); ++i) {
                Date temp = (Date)periodList.get(i);
                labels[0][12 + i] = time1.format(temp);
            }
        }
        if (sSOPEditModeEnum == 10) {
            labels = new Object[2][12 + periodList.size()];
            labels[0][0] = this.getResouce("ORGUNITID", ctx);
            labels[0][1] = this.getResouce("MATERIAID", ctx);
            labels[0][2] = this.getResouce("PLANNEDORDER", ctx);
            labels[0][3] = this.getResouce("MATERIAIDNATTON", ctx);
            labels[0][4] = this.getResouce("MATERIANUMBER", ctx);
            labels[0][5] = this.getResouce("MATERIANAME", ctx);
            labels[0][6] = this.getResouce("MATERIANORDERGUI", ctx);
            labels[0][7] = this.getResouce("MATERIAUNIT", ctx);
            labels[0][8] = this.getResouce("MATERQINGDU", ctx);
            labels[0][9] = this.getResouce("42_qichukucn", ctx);
            labels[0][10] = this.getResouce("41_liebie", ctx);
            labels[0][11] = this.getResouce("MATERRHEJI", ctx);
            labels[1][0] = this.getResouce("ORGUNITID", ctx);
            labels[1][1] = this.getResouce("MATERIAID", ctx);
            labels[1][2] = this.getResouce("PLANNEDORDER", ctx);
            labels[1][3] = this.getResouce("MATERIAIDNATTON", ctx);
            labels[1][4] = this.getResouce("MATERIANUMBER", ctx);
            labels[1][5] = this.getResouce("MATERIANAME", ctx);
            labels[1][6] = this.getResouce("MATERIANORDERGUI", ctx);
            labels[1][7] = this.getResouce("MATERIAUNIT", ctx);
            labels[1][8] = this.getResouce("MATERQINGDU", ctx);
            labels[1][9] = this.getResouce("42_qichukucn", ctx);
            labels[1][10] = this.getResouce("41_liebie", ctx);
            labels[1][11] = this.getResouce("MATERRHEJI", ctx);
            for (int i = 0; i < periodList.size(); ++i) {
                SOPPeriod temp = (SOPPeriod)periodList.get(i);
                labels[0][12 + i] = temp.toString();
                labels[1][12 + i] = time.format(temp.getBeginDate().getTime()) + "-" + time.format(temp.getEndDate().getTime());
            }
        }
        if (sSOPEditModeEnum == 20) {
            labels = new Object[2][12 + periodList.size()];
            labels[0][0] = this.getResouce("ORGUNITID", ctx);
            labels[0][1] = this.getResouce("MATERIAID", ctx);
            labels[0][2] = this.getResouce("PLANNEDORDER", ctx);
            labels[0][3] = this.getResouce("MATERIAIDNATTON", ctx);
            labels[0][4] = this.getResouce("MATERIANUMBER", ctx);
            labels[0][5] = this.getResouce("MATERIANAME", ctx);
            labels[0][6] = this.getResouce("MATERIANORDERGUI", ctx);
            labels[0][7] = this.getResouce("MATERIAUNIT", ctx);
            labels[0][8] = this.getResouce("MATERQINGDU", ctx);
            labels[0][9] = this.getResouce("42_qichukucn", ctx);
            labels[0][10] = this.getResouce("41_liebie", ctx);
            labels[0][11] = this.getResouce("MATERRHEJI", ctx);
            labels[1][0] = this.getResouce("ORGUNITID", ctx);
            labels[1][1] = this.getResouce("MATERIAID", ctx);
            labels[1][2] = this.getResouce("PLANNEDORDER", ctx);
            labels[1][3] = this.getResouce("MATERIAIDNATTON", ctx);
            labels[1][4] = this.getResouce("MATERIANUMBER", ctx);
            labels[1][5] = this.getResouce("MATERIANAME", ctx);
            labels[1][6] = this.getResouce("MATERIANORDERGUI", ctx);
            labels[1][7] = this.getResouce("MATERIAUNIT", ctx);
            labels[1][8] = this.getResouce("MATERQINGDU", ctx);
            labels[1][9] = this.getResouce("42_qichukucn", ctx);
            labels[1][10] = this.getResouce("41_liebie", ctx);
            labels[1][11] = this.getResouce("MATERRHEJI", ctx);
            for (int i = 0; i < periodList.size(); ++i) {
                SOPPeriod temp = (SOPPeriod)periodList.get(i);
                labels[0][12 + i] = temp.toString();
                labels[1][12 + i] = time.format(temp.getBeginDate().getTime()) + "-" + time.format(temp.getEndDate().getTime());
            }
        }
        header.setLabels(labels, true);
    }

    protected List getBySOPFacadePeriod(Context ctx, String storageOrgUnitInfo, Date planDateFrom, Date planDateTo, int sSOPEditModeEnum) throws BOSException, EASBizException {
        Calendar planDateFromcal = Calendar.getInstance();
        planDateFromcal.setTime(planDateFrom);
        Calendar planDateTocal = Calendar.getInstance();
        planDateTocal.setTime(planDateTo);
        ISOPFacade iSOPFacade = SOPFacadeFactory.getLocalInstance(ctx);
        SOPPeriod sOPPeriodFrom = iSOPFacade.getPeriod(planDateFrom, SOPEditModeEnum.getEnum(sSOPEditModeEnum), storageOrgUnitInfo);
        List periodList = sOPPeriodFrom.forwardPeriodsOther(planDateTocal);
        return periodList;
    }

    private String createTempTable(Context ctx) throws BOSException {
        String tempName = "";
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append("create table ");
        createTableSQL.append(TABLE_NAME);
        createTableSQL.append("(");
        createTableSQL.append("fmaterialid VARCHAR(44),");
        createTableSQL.append("fbilldate NVARCHAR(80),");
        createTableSQL.append("qty NUMERIC(21,8),");
        createTableSQL.append("ftype  INT DEFAULT 0 NOT NULL ,");
        createTableSQL.append("FPERIODNUMBER  NUMERIC(21,8)");
        createTableSQL.append(")");
        try {
            tempName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSQL.toString());
            this.createIndex(ctx, tempName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempName;
    }

    private String createTempTableMaterial(Context ctx) throws BOSException {
        String tempName = "";
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append("create table ");
        createTableSQL.append("t_mm_comshcedulingmaterial");
        createTableSQL.append("(");
        createTableSQL.append("KSQL_SEQ INT IDENTITY (1, 1) not null,");
        createTableSQL.append("fmaterialid VARCHAR(44),");
        createTableSQL.append("FBaseConvsRate NUMERIC(21,8),");
        createTableSQL.append("FQtyPrecision int,");
        createTableSQL.append("FModel NVARCHAR(255) ,");
        createTableSQL.append("fnumber NVARCHAR(80),");
        createTableSQL.append("FMaterialName NVARCHAR(255),");
        createTableSQL.append("FUnitName NVARCHAR(255),");
        createTableSQL.append("FQty NUMERIC(21,8) not null default 0,");
        createTableSQL.append("FPlanStrategy VARCHAR(44) ");
        createTableSQL.append(")");
        try {
            tempName = TempTablePool.getInstance((Context)ctx).createTempTable(createTableSQL.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempName;
    }

    protected String createProidTempTable(Context ctx, String storageOrgUnitInfo, Date planDateFrom, Date planDateTo, List periodList, String tempName) throws BOSException, EASBizException {
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd");
        if (tempName == null) {
            StringBuffer periodTempNameSQL = new StringBuffer();
            periodTempNameSQL.append("CREATE TABLE TEMP_periodTempName(").append("fnumber int,fstartdate VARCHAR(44),fenddate VARCHAR(44), fdatetype VARCHAR(44))");
            try {
                tempName = TempTablePool.getInstance((Context)ctx).createTempTable(periodTempNameSQL.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            this.cleanTeampDate(ctx, tempName);
        }
        String insertPeriodTempName = "insert into " + tempName + " (fnumber,fstartdate,fenddate,fdatetype) values(?,?,?,?)";
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            conn = this.getConnection(ctx);
            batchStatement = conn.prepareStatement(insertPeriodTempName);
            for (int i = 0; i < periodList.size(); ++i) {
                SOPPeriod temp = (SOPPeriod)periodList.get(i);
                batchStatement.setInt(1, temp.toNumber());
                batchStatement.setString(2, time.format(temp.getBeginDate().getTime()));
                batchStatement.setString(3, time.format(temp.getEndDate().getTime()));
                batchStatement.setString(4, temp.getType().toString());
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(batchStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((Statement)batchStatement);
        return tempName;
    }

    protected List getDateFormToDate(Date planDateFrom, Date planDateTo) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        Calendar planDateFromcal = Calendar.getInstance();
        planDateFromcal.setTime(planDateFrom);
        Calendar planDateTocal = Calendar.getInstance();
        planDateTocal.setTime(planDateTo);
        Calendar temp = Calendar.getInstance();
        temp.setTime(planDateFrom);
        while (planDateTocal.after(temp)) {
            dateList.add(temp.getTime());
            temp.add(5, 1);
        }
        dateList.add(planDateTo);
        return dateList;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        String materialTable = params.getString("materialTable");
        OrgUnitInfo storageOrgUnitInfo = null;
        if (params.getObject("storageOrgUnitId") != null) {
            storageOrgUnitInfo = (OrgUnitInfo)params.getObject("storageOrgUnitId");
        } else {
            storageOrgUnitInfo = new OrgUnitInfo();
            storageOrgUnitInfo.setId(BOSUuid.read((String)params.getString("storageOrgUnit.id")));
        }
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        this.selectResult(ctx, materialTable, tempTable, result, from, len, storageOrgUnitInfo.getId().toString());
        return result;
    }

    private String getProdNumberFromTempTable(Context ctx, String tableName, Date date) throws BOSException, SQLException {
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.append("select temp.fnumber from ");
        sql.append(tableName);
        sql.append(" temp  where  to_date(temp.fstartdate||' 00:00:00') <= to_date('");
        sql.append(time.format(date));
        sql.append("'||' 00:00:00')  and  to_date('" + time.format(date));
        sql.append("'||' 00:00:00')<= to_date(temp.fenddate||' 00:00:00')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fnumber = null;
        while (rs.next()) {
            fnumber = rs.getString("fnumber");
        }
        return fnumber;
    }

    protected String _getPeroidNumber(Context ctx, String tableName, Date date) throws BOSException, EASBizException {
        String number = null;
        try {
            number = this.getProdNumberFromTempTable(ctx, tableName, date);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return number;
    }

    protected String selectTempTableSql(Context ctx, String tempTable, int editModeEnumType, String dateType, String[] cSql, String storageOrgUnitId) throws BOSException, EASBizException {
        StringBuffer selectSonSql = new StringBuffer();
        StringBuffer selectSql = new StringBuffer();
        selectSonSql.append("select t.FStorageOrgUnitID,t6.FBaseConvsRate,t.fmaterialid,");
        selectSonSql.append("ftype,t2.FModel,t3.FMaterialAttr,t3.FPlanningMode,t2.fnumber,");
        selectSonSql.append("t2.fname_").append(ctx.getLocale());
        selectSonSql.append(" name,t4.fname_");
        selectSonSql.append(ctx.getLocale());
        selectSonSql.append(" uname,t6.FQtyPrecision,round(decimal((");
        selectSonSql.append(cSql[5]);
        selectSonSql.append(")/t6.FBaseConvsRate,21,8),t6.FQtyPrecision ) as suma ,");
        selectSonSql.append(cSql[1]);
        selectSonSql.append(" from ( select  '");
        selectSonSql.append(storageOrgUnitId);
        selectSonSql.append("' FStorageOrgUnitID, fmaterialid,ftype,");
        selectSonSql.append(cSql[0]);
        selectSonSql.append(" from  ");
        selectSonSql.append(tempTable);
        selectSonSql.append(" where 1=1 ");
        selectSonSql.append(" ");
        selectSonSql.append(editModeEnumType != 0 ? " and fperiodnumber >0 " : " ");
        selectSonSql.append(" group by fmaterialid,ftype  ) t");
        selectSonSql.append(" LEFT OUTER JOIN T_BD_Material t2  on t.FMaterialID =t2.fid  ");
        selectSonSql.append(" LEFT OUTER JOIN T_BD_MaterialPlan  t3 ");
        selectSonSql.append(" on t.FMaterialID =t3.FMaterialID  and  t3.forgunit = t.FStorageOrgUnitID ");
        selectSonSql.append("  LEFT OUTER JOIN T_BD_MeasureUnit t4 on  t3.FProductUnitID =t4.fid  ");
        selectSonSql.append("  LEFT OUTER JOIN t_bd_multimeasureunit t6 ");
        selectSonSql.append(" on  t.FMaterialID =t6.fmaterialid and t3.FProductUnitID= t6.fmeasureunitid ");
        selectSql.append("select t.FStorageOrgUnitID, t.fmaterialid,ftype,isnull(b.periodQty,0) as periodQty ,t.FModel");
        selectSql.append(",t.FMaterialAttr,t.FPlanningMode,t.fnumber,t.name,t.uname,t.FQtyPrecision,t.suma,");
        selectSql.append(cSql[4]).append(" from ( ");
        selectSql.append(selectSonSql);
        selectSql.append(" ) t left outer join ( ");
        selectSql.append(cSql[3]).append(" x ) b on t.fmaterialid = b.fmaterialid ");
        selectSql.append(" order by t.fnumber,t.ftype");
        logger.info((Object)("---plannedOrderCommSch---Sql--" + selectSql.toString() + "------"));
        return selectSql.toString();
    }

    private String[] createIndex(Context ctx, String tempTableName) throws Exception {
        String[] indexName = new String[3];
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        indexName[0] = pool.createIndex(tempTableName, "fmaterialid", false, false);
        indexName[1] = pool.createIndex(tempTableName, "fbilldate", false, false);
        indexName[2] = pool.createIndex(tempTableName, "FTYPE", false, false);
        return indexName;
    }

    protected String[] createSelectSQL(Context ctx, RptParams params, List periodList, int editModeEnumType, String dataType, OrgUnitInfo storageOrgUnitInfo, boolean moni) throws EASBizException, BOSException, ParseException {
        if (periodList == null) {
            return null;
        }
        StringBuffer sql1 = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        StringBuffer sql3 = new StringBuffer();
        String sql4 = this.getBegginPerionStock(ctx, params, storageOrgUnitInfo, moni);
        StringBuffer sql5 = new StringBuffer();
        StringBuffer sql6 = new StringBuffer();
        if (editModeEnumType != 0) {
            for (int i = 0; i < periodList.size(); ++i) {
                SOPPeriod temp = (SOPPeriod)periodList.get(i);
                if (i == periodList.size() - 1) {
                    sql1.append(" sum(case when fperiodnumber = ").append(temp.toNumber()).append("  then qty else 0 end) a").append(temp.toNumber()).append("  ");
                    sql2.append(" round(decimal(t.a").append(temp.toNumber()).append("/t6.FBaseConvsRate,21,8),t6.FQtyPrecision)  as a").append(temp.toNumber());
                    sql3.append("t.a").append(temp.toNumber());
                    sql5.append("  t.a").append(temp.toNumber()).append("  as a").append(temp.toNumber());
                    sql6.append("a").append(temp.toNumber());
                    continue;
                }
                sql1.append(" sum(case when fperiodnumber = ").append(temp.toNumber()).append("  then qty else 0 end) a").append(temp.toNumber()).append(", ");
                sql2.append(" round(decimal(t.a").append(temp.toNumber()).append("/t6.FBaseConvsRate,21,8),t6.FQtyPrecision)  as a").append(temp.toNumber()).append(",");
                sql3.append("t.a").append(temp.toNumber()).append(",");
                sql5.append("  t.a").append(temp.toNumber()).append(" as a").append(temp.toNumber()).append(",");
                sql6.append("a").append(temp.toNumber()).append("+");
            }
        } else {
            SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < periodList.size(); ++i) {
                Date temp = (Date)periodList.get(i);
                if (i == periodList.size() - 1) {
                    sql1.append(" sum(case when ").append(dataType).append(" = '").append(time.format(temp)).append("'  then qty else 0 end) a").append(i).append("  ");
                    sql2.append(" round(decimal(t.a").append(i).append("/t6.FBaseConvsRate,21,8),t6.FQtyPrecision)  as a").append(i);
                    sql3.append("t.a").append(i);
                    sql5.append(" t.a").append(i).append(" as a").append(i);
                    sql6.append("a").append(i);
                    continue;
                }
                sql1.append(" sum(case when ").append(dataType).append(" = '").append(time.format(temp)).append("'  then qty else 0 end) a").append(i).append(", ");
                sql2.append(" round(decimal(t.a").append(i).append("/t6.FBaseConvsRate,21,8),t6.FQtyPrecision)  as a").append(i).append(",");
                sql3.append("t.a").append(i).append(",");
                sql5.append("  t.a").append(i).append(" as a").append(i).append(",");
                sql6.append("a").append(i).append("+");
            }
        }
        String[] s = new String[]{sql1.toString(), sql2.toString(), sql3.toString(), sql4.toString(), sql5.toString(), sql6.toString()};
        return s;
    }

    protected void insertValueToTempTable(Context ctx, String tempTableName, String selectSql) throws BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into  ").append(tempTableName).append("(fperiodnumber,fmaterialid,FStorageOrgUnitID,FProductUnitID,FPlanningMode").append(",FMaterialAttr, qty,FQtyPrecision,  fstartdate,fenddate,fplanner  ) ").append(selectSql);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private Map getFactoryCalendar(Context ctx, String storageOrgUnitId, Date startDate, Date endDate) throws EASBizException, BOSException {
        HashMap factroyDates = (HashMap)FactoryCalendarFactory.getLocalInstance((Context)ctx).isWorkDay(storageOrgUnitId, startDate, endDate);
        return factroyDates;
    }

    private String getResouce(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.mm.planning.ProduceExecuteResource", (String)key, (Context)ctx);
    }

    private Map getPlannedOrderMaterialSystemParam(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_SETS.getValue(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        v.setFilter(filter);
        v.getSelector().add(new SelectorItemInfo("paramValue"));
        v.getSelector().add(new SelectorItemInfo("id"));
        v.getSelector().add(new SelectorItemInfo("number"));
        PlanningParamValueCollection collParam = PlanningParamValueFactory.getLocalInstance(ctx).getPlanningParamValueCollection(v);
        HashMap<String, String> releaseParams = new HashMap<String, String>();
        if (collParam == null) {
            throw new PlanOrderException(PlanOrderException.CHECKBLANK);
        }
        if (collParam.size() > 0) {
            int iSize = collParam.size();
            for (int i = 0; i < iSize; ++i) {
                PlanningParamValueInfo info = collParam.get(i);
                if (info.getNumber().equalsIgnoreCase(PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_FABRICATEDPART.getValue())) {
                    releaseParams.put("PARAMFABRICATED", info.getParamValue());
                    continue;
                }
                if (info.getNumber().equalsIgnoreCase(PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_PURCHASEDPART.getValue())) {
                    releaseParams.put("PARAMPURCHASE", info.getParamValue());
                    continue;
                }
                if (!info.getNumber().equalsIgnoreCase(PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_EXTERNALPROCESSINPART.getValue())) continue;
                releaseParams.put("PARAMSTOCKTRANSFER", info.getParamValue());
            }
        }
        return releaseParams;
    }

    @Override
    protected Map _getPlannedorderMaterialSystemParam(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        return this.getPlannedOrderMaterialSystemParam(ctx, orgUnitId);
    }

    private String[] getMRPrunTableDate(Context ctx, RptParams params, OrgUnitInfo storageOrgUnitInfo, boolean moni) throws EASBizException, BOSException, ParseException {
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd");
        Date planDateFrom = time.parse(params.getString("planDateFrom").substring(0, 11));
        Date planDateTo = time.parse(params.getString("planDateTo").substring(0, 11));
        String dateType = null;
        String startDateCombox = params.getString("startDate");
        dateType = startDateCombox != null && startDateCombox.equals("true") ? "fstartdate" : "fenddate";
        StringBuffer depatementSql = new StringBuffer();
        String depatementFrom = params.getString("depatementFrom");
        String depatementTo = params.getString("depatementTo");
        if (depatementFrom != null && depatementTo != null) {
            depatementSql.append(" and t5.fnumber >='").append(depatementFrom).append("' and  t5.fnumber<='").append(depatementTo).append("' ");
        }
        if (depatementFrom != null && depatementTo == null) {
            depatementSql.append(" and t5.fnumber >='").append(depatementFrom).append("' ");
        }
        if (depatementFrom == null && depatementTo != null) {
            depatementSql.append(" and  t5.fnumber<='").append(depatementTo).append("' ");
        }
        String personFrom = params.getString("personFrom");
        String personTo = params.getString("personTo");
        StringBuffer personFilter = new StringBuffer();
        if (personFrom != null && personTo != null) {
            personFilter.append(" and  PLANNER.fnumber >= '").append(personFrom).append("'  and ").append(" PLANNER.fnumber <= '").append(personTo).append("' ");
        }
        if (personFrom != null && personTo == null) {
            personFilter.append(" and  PLANNER.fnumber >= '").append(personFrom).append("' ");
        }
        if (personFrom == null && personTo != null) {
            personFilter.append(" and ").append(" PLANNER.fnumber <= '").append(personTo).append("' ");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuffer materialSql = new StringBuffer();
        String fmaterialType = params.getString("fmaterialType");
        String pmaterialType = params.getString("pmaterialType");
        String purmaterial = params.getString("purmaterialType");
        if (purmaterial != null && purmaterial.equals("true")) {
            list.add(new Integer(10040));
        }
        if (fmaterialType != null && fmaterialType.equals("true")) {
            list.add(new Integer(10030));
        }
        if (pmaterialType != null && pmaterialType.equals("true")) {
            list.add(new Integer(10050));
        }
        if (list.size() > 0) {
            materialSql.append(" and b.FMaterialAttr  in (").append(this.arrayToString(list.toArray())).append(") ");
            list.clear();
        }
        StringBuffer planTypeSql = new StringBuffer();
        String mrpCombox = params.getString("mrpCombox");
        String mpsCombox = params.getString("mpsCombox");
        if (mrpCombox != null && mrpCombox.equals("true")) {
            list.add(new Integer(3));
        }
        if (mpsCombox != null && mpsCombox.equals("true")) {
            list.add(new Integer(2));
        }
        if (list.size() > 0) {
            planTypeSql.append(" and b.FPlanningMode in (").append(this.arrayToString(list.toArray())).append(") ");
            list.clear();
        }
        String materialFrom = params.getString("materialFrom");
        String materialTo = params.getString("materialTo");
        StringBuffer materialNumberSql = new StringBuffer();
        StringBuffer materialNumberPlanSql = new StringBuffer();
        StringBuffer moniSql = new StringBuffer();
        StringBuffer plannNumberSql = new StringBuffer();
        String plannNumber = params.getString("plannNumber");
        if (moni) {
            plannNumberSql.append(" and ((p.FIsSimulant =0 and t6.fnumber <>'").append(plannNumber).append("')  or t6.fnumber ='").append(plannNumber).append("')");
        } else {
            moniSql.append("  and p.FIsSimulant =0   ");
        }
        if (materialFrom != null) {
            materialNumberSql.append(" and b.FMaterialNumber >='").append(materialFrom).append("' ");
            materialNumberPlanSql.append(" and c.FNumber >='").append(materialFrom).append("' ");
        }
        if (materialTo != null) {
            materialNumberSql.append(" and b.FMaterialNumber <='").append(materialTo).append("' ");
            materialNumberPlanSql.append(" and c.FNumber <='").append(materialTo).append("' ");
        }
        String storageOrgUnitInfoId = storageOrgUnitInfo.getId().toString();
        Map table = this.getMRPTable(ctx, params, storageOrgUnitInfo, moni);
        String mrpDetail = (String)table.get("detail");
        String mrpMateril = (String)table.get("material");
        StringBuffer commonSql = new StringBuffer();
        commonSql.append(" select fmaterialid,fbilldate,sum(supplyqty) as supplyqty,sum(requirementqty) as requirementqty, sum(userqty) userqty,sum(plannedqty) plannedqty from ( ");
        commonSql.append(" select temp.fmaterialid, temp.fbilldate, ");
        commonSql.append(" ABS(temp.fplannedOrderQty+temp.fplannOrderCoByProductQty)   as supplyqty , ");
        commonSql.append(" ABS(temp.frequirementPlanQty+temp.fparentPlanOrderQty+temp.fouterOrderQty)  as requirementqty, ");
        commonSql.append(" temp.fplannOrderCoByProductQty+ temp.fplannedOrderQty+temp.frequirementPlanQty");
        commonSql.append(" +temp.fparentPlanOrderQty+temp.fouterOrderQty  as userqty, 0 as plannedqty ");
        commonSql.append("   from  (  select  mrpDetail.fMaterialId as fmaterialid,fbilldate, ");
        commonSql.append(" sum(case when mrpDetail.fmrpitem = 250 and mrpDetail.FDesc64 is not null and mrpDetail.FIsSurplusDivert=1 then 0 ");
        commonSql.append(" when mrpDetail.fmrpitem = 250   or   mrpDetail.fmrpitem = 240   or   mrpDetail.fmrpitem = 235   ");
        commonSql.append(" or  mrpDetail.fmrpitem = 230 or  mrpDetail.fmrpitem = 207   or  mrpDetail.fmrpitem = 209  ");
        commonSql.append(" or  mrpDetail.fmrpitem = 210  or   mrpDetail.fmrpitem = 220  or   mrpDetail.fmrpitem = 200 ");
        commonSql.append(" or  mrpDetail.fmrpitem = 205  or  mrpDetail.fmrpitem = 270  or  mrpDetail.fmrpitem = 260  then mrpDetail.FSR else 0 end) as fplannedOrderQty,");
        commonSql.append("sum(case when mrpDetail.fmrpitem = 251 then mrpDetail.fdependent else 0 end ) as fplannOrderCoByProductQty,");
        commonSql.append("sum(case when mrpDetail.fmrpitem = 300 or mrpDetail.fmrpitem = 310 or mrpDetail.fmrpitem = 320 or ");
        commonSql.append(" mrpDetail.fmrpitem = 400  or mrpDetail.fmrpitem = 331 or  ");
        commonSql.append(" mrpDetail.fmrpitem = 330  or mrpDetail.fmrpitem = 390  then mrpDetail.findependent else 0  end ) as frequirementPlanQty,");
        commonSql.append(" sum(case when mrpDetail.fmrpitem = 340    ");
        commonSql.append(" then mrpDetail.fdependent - mrpDetail.fsr else 0 end ) as fparentPlanOrderQty,");
        commonSql.append(" sum(case when mrpDetail.fmrpitem = 365   or  mrpDetail.fmrpitem = 350  or mrpDetail.fmrpitem = 360 ");
        commonSql.append(" or mrpDetail.fmrpitem = 370  or  mrpDetail.fmrpitem = 380 ");
        commonSql.append(" then mrpDetail.fdependent else 0 end ) as fouterOrderQty ");
        commonSql.append(" from (SELECT a.fid, a.fMaterialId,a.fmrpitem,to_char(a.fbilldate,'YYYY-MM-DD') as fbilldate,a.FAllocation,a.findependent, ");
        commonSql.append(" a.fdependent,a.fplanversionid,a.fsr,a.FDesc64,b.FIsSurplusDivert from ");
        commonSql.append(mrpDetail);
        commonSql.append("  a  LEFT OUTER JOIN  ").append(mrpMateril).append(" b on a.fmaterialid = b.fmaterialid ");
        commonSql.append(" LEFT OUTER JOIN T_BD_Person  PLANNER  ON b.FPlanner = PLANNER.FID ");
        commonSql.append(" LEFT OUTER JOIN T_ORG_Admin t5 on  b.FManufactureDepartment = t5.fid ");
        commonSql.append("where a.FSupplyType<10930 and a.fbilldate >= to_date('").append(time.format(planDateFrom)).append("'||' 00:00:00') ");
        commonSql.append(" and a.fbilldate <= to_date('").append(time.format(planDateTo)).append("'||' 00:00:00') ");
        commonSql.append(planTypeSql);
        commonSql.append(materialSql);
        commonSql.append(materialNumberSql);
        commonSql.append(depatementSql);
        commonSql.append(personFilter);
        commonSql.append(" and (((a.FSID is null or a.FSID=a.FID) and b.FIsSurplusDivert=0) ");
        commonSql.append(" or b.FIsSurplusDivert=1) ");
        commonSql.append(" ) mrpDetail ");
        commonSql.append(" group by mrpDetail.fMaterialId ,mrpDetail.fbilldate ) as TEMP ");
        commonSql.append("  union  all  ( select Plannedorder.FMaterialID as fmaterialid,Plannedorder.fbilldate  as fbilldate,");
        commonSql.append("0 supplyqty,0 requirementqty,0 userqty,");
        commonSql.append("  sum(Plannedorder.FBaseQty)-sum(Plannedorder.FBaseTotalReleaseQty) as plannedqty ");
        commonSql.append(" from ( select p.FMaterialID,to_char(p.");
        commonSql.append(dateType);
        commonSql.append(",'YYYY-MM-DD') AS fbilldate,p.FBaseQty,p.FBaseTotalReleaseQty ");
        commonSql.append("from t_mm_plannedorder  p ");
        commonSql.append(" LEFT OUTER JOIN T_BD_Person  PLANNER  ON p.FPlanner = PLANNER.FID ");
        commonSql.append(" LEFT OUTER JOIN T_ORG_Admin t5 on  p.FAdminOrgUnitID =t5.fid   ");
        commonSql.append(" LEFT OUTER JOIN T_MM_PlanVersionSet t6 on p.FSchemeID = t6.fid ");
        commonSql.append(" inner JOIN T_BD_MaterialPlan b on p.FMaterialID =b.FMaterialID  and  p.FStorageOrgUnitID= b.forgunit");
        commonSql.append(" inner JOIN T_BD_Material C on p.FMaterialID =C.FID ");
        commonSql.append("  where p.fenddate is not null  and  p.FMaterialID is not null  and p.fbasestatus in (1,2,4) ");
        commonSql.append(" and  p.FSTORAGEORGUNITID = '").append(storageOrgUnitInfoId).append("'");
        commonSql.append(" and p.");
        commonSql.append(dateType);
        commonSql.append(" >= to_date('").append(time.format(planDateFrom)).append("'||' 00:00:00') ");
        commonSql.append(" and p.");
        commonSql.append(dateType);
        commonSql.append(" <= to_date('").append(time.format(planDateTo)).append("'||' 00:00:00') ");
        commonSql.append(planTypeSql);
        commonSql.append(materialSql);
        commonSql.append(materialNumberPlanSql);
        commonSql.append(depatementSql);
        commonSql.append(personFilter);
        commonSql.append(moniSql);
        commonSql.append(plannNumberSql);
        commonSql.append(" and (p.FBaseQty>p.FBaseTotalReleaseQty ) )Plannedorder  group by Plannedorder.fmaterialid,Plannedorder.fbilldate");
        commonSql.append("   ) ) t ");
        commonSql.append("where (t.supplyqty !=0  or t.requirementqty !=0 or t.userqty !=0 or t.plannedqty !=0)  ");
        commonSql.append(" group by t.fmaterialid,t.fbilldate");
        String tablename = this.createTempTable(commonSql.toString(), null, ctx);
        boolean hidePO = params.getBoolean("hidePO");
        String whereSql = "";
        if (hidePO) {
            whereSql = " where  decimal(ceiling((t1.plannedqty/to_number(isnull(t4.fBaseConvsRate,1))) * power(10,isnull(t4.FQtyPrecision,4)))  /power(10,isnull(t4.FQtyPrecision,4)), 21,8) <> 0 ";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select t1.fmaterialid,t1.fbilldate,");
        sql.append(" round(t1.supplyqty/to_number(isnull(t4.fBaseConvsRate,1)),isnull(t4.FQtyPrecision,4)) as FQty,");
        sql.append(2);
        sql.append(" as ftype, 0 fperiodnumber from ").append(tablename).append(" as  t1  ");
        sql.append(" LEFT OUTER JOIN T_BD_MaterialPlan  t3  on  t1.FMaterialID =t3.FMaterialID and t3.forgunit = '");
        sql.append(storageOrgUnitInfo.getId().toString());
        sql.append("' LEFT OUTER JOIN t_bd_multimeasureunit t4  on  t1.FMaterialID =t4.fmaterialid and t3.FProductUnitID= t4.fmeasureunitid  ");
        sql.append(whereSql);
        StringBuffer sql2 = new StringBuffer();
        sql2.append(" select t1.fmaterialid,t1.fbilldate,");
        sql2.append(" round(t1.requirementqty/to_number(isnull(t4.fBaseConvsRate,1)),isnull(t4.FQtyPrecision,4)) as FQty,");
        sql2.append(1);
        sql2.append(" as ftype, 0 fperiodnumber from ").append(tablename).append(" as  t1  ");
        sql2.append(" LEFT OUTER JOIN T_BD_MaterialPlan  t3  on  t1.FMaterialID =t3.FMaterialID and t3.forgunit = '");
        sql2.append(storageOrgUnitInfo.getId().toString());
        sql2.append("' LEFT OUTER JOIN t_bd_multimeasureunit t4  on  t1.FMaterialID =t4.fmaterialid and t3.FProductUnitID= t4.fmeasureunitid  ");
        sql2.append(whereSql);
        StringBuffer sql3 = new StringBuffer();
        sql3.append(" select t1.fmaterialid,t1.fbilldate,");
        sql3.append(" round(t1.userqty/to_number(isnull(t4.fBaseConvsRate,1)),isnull(t4.FQtyPrecision,4)) as FQty,");
        sql3.append(3);
        sql3.append(" as ftype, 0 fperiodnumber from ").append(tablename).append(" as  t1  ");
        sql3.append(" LEFT OUTER JOIN T_BD_MaterialPlan  t3  on  t1.FMaterialID =t3.FMaterialID and t3.forgunit = '");
        sql3.append(storageOrgUnitInfo.getId().toString());
        sql3.append("' LEFT OUTER JOIN t_bd_multimeasureunit t4  on  t1.FMaterialID =t4.fmaterialid and t3.FProductUnitID= t4.fmeasureunitid  ");
        sql3.append(whereSql);
        StringBuffer sql4 = new StringBuffer();
        sql4.append(" select t1.fmaterialid,t1.fbilldate,");
        sql4.append(" decimal(ceiling((t1.plannedqty/to_number(isnull(t4.fBaseConvsRate,1))) * power(10,isnull(t4.FQtyPrecision,4))) ");
        sql4.append(" /power(10,isnull(t4.FQtyPrecision,4)), 21,8) as FQty,");
        sql4.append(4);
        sql4.append(" as ftype, 0 fperiodnumber from ").append(tablename).append(" as  t1  ");
        sql4.append(" LEFT OUTER JOIN T_BD_MaterialPlan  t3  on  t1.FMaterialID =t3.FMaterialID and t3.forgunit = '");
        sql4.append(storageOrgUnitInfo.getId().toString());
        sql4.append("' LEFT OUTER JOIN t_bd_multimeasureunit t4  on  t1.FMaterialID =t4.fmaterialid and t3.FProductUnitID= t4.fmeasureunitid  ");
        sql4.append(whereSql);
        String[] nsql = new String[]{sql.toString(), sql2.toString(), sql3.toString(), sql4.toString(), tablename};
        return nsql;
    }

    private Map getMRPTable(Context ctx, RptParams params, OrgUnitInfo storageOrgUnitInfo, boolean moni) throws EASBizException, BOSException {
        String plannNumber = params.getString("plannNumber");
        String storageOrgUnitInfoId = storageOrgUnitInfo.getId().toString();
        PlanVersionSetInfo plannversion = null;
        PlanVersionSetCollection pvsCollection = PlanVersionSetFactory.getLocalInstance((Context)ctx).getPlanVersionSetCollection(" where storageOrgUnit.id='" + storageOrgUnitInfoId + "' and number='" + plannNumber + "'");
        if (pvsCollection == null || pvsCollection.size() <= 0) {
            throw new MRPException(MRPException.PLANVERSION_ERROR);
        }
        plannversion = pvsCollection.get(0);
        String planVersionSetId = plannversion.getId().toString();
        boolean result = !moni;
        HashMap<String, String> table = new HashMap<String, String>();
        List list = MRPDynamicTableManager.getTableName(ctx, storageOrgUnitInfoId, planVersionSetId, result);
        table.put("material", ((MRPRunningTablesInfo)list.get(0)).getTableName());
        table.put("detail", ((MRPRunningTablesInfo)list.get(1)).getTableName());
        return table;
    }

    private String createPhysicsTable(Context ctx, RptParams params) {
        StringBuffer createTableSQL = new StringBuffer();
        createTableSQL.append("create table ");
        createTableSQL.append(TABLE_NAME);
        createTableSQL.append("(");
        createTableSQL.append("fmaterialid VARCHAR(44),");
        createTableSQL.append("fbilldate DATETIME,");
        createTableSQL.append("qty ");
        createTableSQL.append("periodQty  NUMERIC(21,8) not null default 0,");
        createTableSQL.append("FPlanVersionID VARCHAR(44) NOT NULL,");
        createTableSQL.append(")");
        return "";
    }

    public String arrayToString(Object[] ids) {
        StringBuffer idStr = new StringBuffer("");
        if (ids != null && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                if (i != ids.length - 1) {
                    idStr.append(ids[i].toString()).append(",");
                    continue;
                }
                idStr.append(ids[i].toString());
            }
        }
        return idStr.toString();
    }

    @Override
    protected void _cleanTempTable(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids != null && ids.size() > 0) {
            ICommRptBase comm = CommRptBaseFactory.getLocalInstance((Context)ctx);
            String temp = null;
            for (int i = 0; i < ids.size(); ++i) {
                temp = (String)ids.get(i);
                comm.dropPoolTempTable(temp);
            }
        }
    }
}

