/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.ThrowModeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILotRule;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.app.LotFrameManu;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.BOMExtendFacadeFactory;
import com.kingdee.eas.mm.basedata.PlanVersionSetCollection;
import com.kingdee.eas.mm.basedata.PlanVersionSetFactory;
import com.kingdee.eas.mm.common.app.CommonUtils;
import com.kingdee.eas.mm.common.app.MMLogger;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.planning.IPlannedOrder;
import com.kingdee.eas.mm.planning.IReqPlanReceiveReqDataFacade;
import com.kingdee.eas.mm.planning.PlanOrderException;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderEntryCollection;
import com.kingdee.eas.mm.planning.PlannedOrderEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.PlannedOrderReleaseEnum;
import com.kingdee.eas.mm.planning.PlannedOrderSourceEnum;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.planning.PlanningParamFactory;
import com.kingdee.eas.mm.planning.PlanningParamValueCollection;
import com.kingdee.eas.mm.planning.PlanningParamValueFactory;
import com.kingdee.eas.mm.planning.PlanningParamValueInfo;
import com.kingdee.eas.mm.planning.ReqPlanReceiveReqDataFacadeFactory;
import com.kingdee.eas.mm.planning.app.AbstractPlannedOrderControllerBean;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlannedOrderControllerBean
extends AbstractPlannedOrderControllerBean
implements IBatchExecute {
    private static final long serialVersionUID = 1487153954597223460L;
    private static final String CLR = "  \r\n";
    private List<String> tempTableList = new ArrayList<String>();
    protected static final Logger logger = MMLogger.getLogger();
    private static Logger logger2 = MMLogger.getLogger();

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk;
        PlannedOrderInfo info;
        block9: {
            info = (PlannedOrderInfo)model;
            if (info.getUnit() == null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                viewInfo.getSelector().add(new SelectorItemInfo("Unit.id"));
                viewInfo.getSelector().add(new SelectorItemInfo("Unit.Number"));
                viewInfo.getSelector().add(new SelectorItemInfo("Unit.Name"));
                viewInfo.getSelector().add(new SelectorItemInfo("productUnit.id"));
                viewInfo.getSelector().add(new SelectorItemInfo("productUnit.Number"));
                viewInfo.getSelector().add(new SelectorItemInfo("productUnit.Name"));
                IPlannedOrder iplannedorder = PlannedOrderFactory.getLocalInstance(ctx);
                CoreBaseCollection planCol = iplannedorder.getCollection(viewInfo);
                if (planCol != null && planCol.size() > 0) {
                    PlannedOrderInfo planUnit = (PlannedOrderInfo)planCol.get(0);
                    logger.info((Object)"doing,begin....");
                    logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"65_PlannedOrderControllerBean", (Locale)ctx.getLocale()) + (info.getNumber() == null ? "" : info.getNumber().toString()) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"66_PlannedOrderControllerBean", (Locale)ctx.getLocale()) + info.getQty() + " (id:" + planUnit.getProductUnit().getId() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"67_PlannedOrderControllerBean", (Locale)ctx.getLocale()) + info.getBaseQty() + " (id:" + planUnit.getUnit().getId() + ")"));
                    logger.info((Object)"doing,end.");
                }
            } else {
                String number = " The number of new bill is null! ";
                if (info.getNumber() != null && info.getNumber().length() > 0) {
                    number = info.getNumber().toString();
                }
                logger.info((Object)"doing,begin....");
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"65_PlannedOrderControllerBean", (Locale)ctx.getLocale()) + (info.getNumber() == null ? "" : info.getNumber().toString()) + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"66_PlannedOrderControllerBean", (Locale)ctx.getLocale()) + info.getQty() + " (id:" + info.getProductUnit().getId() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"67_PlannedOrderControllerBean", (Locale)ctx.getLocale()) + info.getBaseQty() + " (id:" + info.getUnit().getId() + ")"));
                logger.info((Object)"doing,end.");
            }
            pk = null;
            info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            PlannedOrderEntryCollection entries = info.getEntries();
            PlannedOrderEntryInfo entry = null;
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                entry = entries.get(i);
                entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            }
            if ((PlannedOrderTypeEnum.PURCHASE.equals((Object)info.getOrderType()) || PlannedOrderTypeEnum.STOCKTRANSFER.equals((Object)info.getOrderType()) && !info.getStorageOrgUnit().getId().toString().equals(info.getProductionOrgUnit().getId().toString())) && info.getId() != null) {
                this.updateReqPlanData(ctx, "'" + info.getId().toString() + "'", BizActionEnum.DELETE);
            }
            try {
                pk = super._submit(ctx, model);
            }
            catch (SQLAccessException e) {
                if (e.getCause() == null || !(e.getCause() instanceof DataLimitExceedException)) break block9;
                throw new BOSException(EASResource.getString((String)"dataBaseError"));
            }
        }
        String orgUnitID = info.getStorageOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, info, orgUnitID, 4)) {
            this.auditAndLog(ctx, pk, info.getBOSType(), info.getNumber(), "mm_planorder_audit");
        }
        return pk;
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        PlannedOrderInfo info = PlannedOrderFactory.getLocalInstance(ctx).getPlannedOrderInfo((IObjectPK)pk);
        this.checkBeforSubmit(ctx, info);
        info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        PlannedOrderEntryCollection entries = info.getEntries();
        PlannedOrderEntryInfo entry = null;
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            entry = entries.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        }
        String updateSql = "update T_MM_PlannedOrder set FBaseStatus = 2 where fid ='" + id + "'";
        SQLUtils.execute((Context)ctx, (String)updateSql);
        String orgUnitID = info.getStorageOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, info, orgUnitID, 4)) {
            this.auditAndLog(ctx, (IObjectPK)pk, info.getBOSType(), info.getNumber(), "mm_planorder_audit");
        }
    }

    public BatchActionResults batchSubmitRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        PlannedOrderInfo objValue;
        boolean isFromEditUI = false;
        if (entries != null && entries.length == 1 && (objValue = (PlannedOrderInfo)entries[0].get(0)).getStorageOrgUnit() != null) {
            isFromEditUI = true;
        }
        ArrayList<String> deletedOrderIds = new ArrayList<String>();
        if (!isFromEditUI) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            int size = entries.length;
            for (int i = 0; i < size; ++i) {
                IObjectValue objValue2 = (IObjectValue)entries[i].get(0);
                keys.add(objValue2.getString("id"));
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("baseStatus"));
            viewInfo.getSelector().add(new SelectorItemInfo("orderType"));
            viewInfo.getSelector().add(new SelectorItemInfo("bom.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("startDate"));
            viewInfo.getSelector().add(new SelectorItemInfo("endDate"));
            viewInfo.getSelector().add(new SelectorItemInfo("transactionType"));
            viewInfo.getSelector().add(new SelectorItemInfo("sourceType"));
            viewInfo.getSelector().add(new SelectorItemInfo("qty"));
            viewInfo.getSelector().add(new SelectorItemInfo("baseQty"));
            viewInfo.getSelector().add(new SelectorItemInfo("productUnit"));
            viewInfo.getSelector().add(new SelectorItemInfo("scheme"));
            viewInfo.getSelector().add(new SelectorItemInfo("bizDate"));
            viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("productionOrgUnit.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("material.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("material.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("project.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("trackNumber.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("billType.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.material.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.unitQty"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.reqDate"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.storageOrgUnit.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.unitQty"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.backFlush"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.defaultWarehouse.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.isStockTransfer"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.transferOrgUnit.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.demandQty"));
            viewInfo.getSelector().add(new SelectorItemInfo("entries.isReplaced"));
            CoreBaseCollection billCol = this.getCollection(ctx, viewInfo);
            Object poInfo = null;
            int size2 = entries.length;
            for (int i = 0; i < size2; ++i) {
                IObjectValue objValue3 = (IObjectValue)entries[i].get(0);
                poInfo = billCol.get((Object)BOSUuid.read((String)objValue3.getString("id")));
                if (poInfo == null) {
                    deletedOrderIds.add(objValue3.getString("id"));
                    poInfo = new PlannedOrderInfo();
                    poInfo.setId(BOSUuid.read((String)objValue3.getString("id")));
                }
                entries[i].set(0, poInfo);
            }
        }
        BatchActionResults executeResults = this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
        EASBizException existExcep = new EASBizException(EASBizException.CHECKEXIST);
        String deletedOrderId = null;
        for (int j = 0; j < deletedOrderIds.size(); ++j) {
            deletedOrderId = (String)deletedOrderIds.get(j);
            executeResults.getActionResult((Object)deletedOrderId).setException((Exception)((Object)existExcep));
            executeResults.getActionResult((Object)deletedOrderId).setMessage(existExcep.getMessage());
        }
        return executeResults;
    }

    @Override
    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected void _delete(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchDelete(ctx, entrys);
        result.throwExceptions();
    }

    public BatchActionResults batchDelete(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.DELETE);
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return "com.kingdee.eas.mm.planning.app.bizprocess.xml.PLbizProcess";
    }

    protected String getBillTypeId() {
        return "9XXvbVGlRtym/0qtqeIXXrhE1B8=";
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        try {
            if (batchResults.getToDoIdsArray().length > 0) {
                if (batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                    this.afterAudit(ctx, batchResults);
                } else if (batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
                    this.afterUnAudit(ctx, batchResults);
                } else if (batchAction.equals((Object)BatchActionEnum.DELETE)) {
                    this.afterDelete(ctx, batchResults);
                } else if (BatchActionEnum.SUBMIT.equals((Object)batchAction)) {
                    this.afterSubmit(ctx, batchResults);
                }
            }
        }
        catch (Exception er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
        finally {
            this.releaseTempTables(ctx);
        }
    }

    protected void afterSubmit(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String poIds = "select fid from t_mm_plannedorder where FSourceType=20 and fid in(" + SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray()) + ")";
        this.updateReqPlanData(ctx, poIds, BizActionEnum.SUBMIT);
    }

    protected void afterAudit(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        long time1 = System.currentTimeMillis();
        this.afterAuditUpdateReqPlan(ctx, batchResults);
        long time2 = System.currentTimeMillis();
        logger2.error((Object)("#############\u8ba1\u5212\u8ba2\u5355\u5ba1\u68383\uff1a" + (time2 - time1)));
        this.processLot(ctx, batchResults.getToDoIdsArray());
        long time3 = System.currentTimeMillis();
        logger2.error((Object)("#############\u8ba1\u5212\u8ba2\u5355\u5ba1\u68383\uff1a" + (time3 - time2)));
        LotFacadeFactory.getLocalInstance((Context)ctx).plannedorderInsertLotSource(batchResults.getToDoIdsArray());
        long time4 = System.currentTimeMillis();
        logger2.error((Object)("#############\u8ba1\u5212\u8ba2\u5355\u5ba1\u68383\uff1a" + (time4 - time3)));
    }

    private String insertdata(Context ctx, String[] ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table purorder (fid varchar(44) ");
        sql.append(",CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" insert into ").append(table);
        sql.append(" (fid) values (?)");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                stmt.setString(1, ids[i]);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return table;
    }

    private void processLot(Context ctx, String[] ids) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        String tmpTable = this.insertdata(ctx, ids);
        try {
            StringBuffer setLotSql = new StringBuffer();
            setLotSql.append("select T.FID planOrderID, T.FStorageOrgUnitID StoID, STO.FNumber StoNumber, ").append("T.FNumber PONumber, T.FMaterialID MaterialID, MATERIAL.FNumber MaterialNumber ").append("from t_mm_plannedOrder T ").append(" inner join ").append(tmpTable).append(" as tmp on tmp.fid = T.fid ").append("left outer join T_ORG_Storage STO on T.FStorageOrgUnitID = STO.FID ").append("left outer join T_BD_Material MATERIAL on T.FMaterialID = MATERIAL.FID ").append("left outer join T_MM_LotParamValue LotParam on T.FStorageOrgUnitID=LotParam.FOrgUnitID ").append("left outer join T_BD_MaterialInventory MI ").append("on T.FStorageOrgUnitID=MI.FOrgUnit and T.FmaterialID=MI.FMaterialID ").append(" where  LotParam.FManufacturePlan=").append(1).append(" and MI.FIsLotNumber=").append(1).append(" and T.FLot is null").append(" order by PONumber asc");
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)setLotSql.toString());
            setLotSql.setLength(0);
            LotFrameManu lotFrameManu = new LotFrameManu();
            ILotRule lotRule = LotRuleFactory.getLocalInstance((Context)ctx);
            LotFrame lotFrame = null;
            setLotSql.append("update t_mm_plannedOrder set flot=? ").append(" where fid= ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(setLotSql.toString());
            while (rs.next()) {
                lotFrame = lotRule.getLotFrame(rs.getString("MaterialID"), rs.getString("StoID"));
                if (lotFrame == null) continue;
                long currentSerial = BatchFileFactory.getLocalInstance((Context)ctx).updateLotRuleAssign(rs.getString("MaterialID"), rs.getString("StoID"));
                lotFrame.setCurrentSerial(currentSerial);
                lotFrameManu.setBizDate(new Date());
                lotFrameManu.setSeq(lotFrame.getSeq());
                lotFrameManu.setSysDate(lotFrame.getSysDate());
                lotFrameManu.setCurrentSerial(lotFrame.getCurrentSerial());
                lotFrameManu.setMainBizOrg(rs.getString("StoNumber"));
                lotFrameManu.setMaterial(rs.getString("MaterialNumber"));
                lotFrameManu.setLotRule(lotFrame.getLotRule());
                stmt.setString(1, lotFrameManu.getLotNumber());
                stmt.setString(2, rs.getString("planOrderID"));
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.util.db.SQLUtils.cleanup(stmt, conn);
                if (tmpTable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
                }
                throw throwable;
            }
        }
        com.kingdee.util.db.SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        if (tmpTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
        }
    }

    private void processLot(Context ctx, String planOrderIds) throws BOSException, EASBizException {
        StringBuffer setLotSql = new StringBuffer();
        setLotSql.append("select T.FID planOrderID, T.FStorageOrgUnitID StoID, STO.FNumber StoNumber, ").append("T.FNumber PONumber, T.FMaterialID MaterialID, MATERIAL.FNumber MaterialNumber ").append("from t_mm_plannedOrder T ").append("left outer join T_ORG_Storage STO on T.FStorageOrgUnitID = STO.FID ").append("left outer join T_BD_Material MATERIAL on T.FMaterialID = MATERIAL.FID ").append("left outer join T_MM_LotParamValue LotParam on T.FStorageOrgUnitID=LotParam.FOrgUnitID ").append("left outer join T_BD_MaterialInventory MI ").append("on T.FStorageOrgUnitID=MI.FOrgUnit and T.FmaterialID=MI.FMaterialID ").append("where T.FID in (").append(planOrderIds).append(") and LotParam.FManufacturePlan=").append(1).append(" and MI.FIsLotNumber=").append(1).append(" and T.FLot is null").append(" order by PONumber asc");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)setLotSql.toString());
        try {
            LotFrameManu lotFrameManu = new LotFrameManu();
            ILotRule lotRule = LotRuleFactory.getLocalInstance((Context)ctx);
            LotFrame lotFrame = null;
            while (rs.next()) {
                lotFrame = lotRule.getLotFrame(rs.getString("MaterialID"), rs.getString("StoID"));
                if (lotFrame == null) continue;
                long currentSerial = BatchFileFactory.getLocalInstance((Context)ctx).updateLotRuleAssign(rs.getString("MaterialID"), rs.getString("StoID"));
                lotFrame.setCurrentSerial(currentSerial);
                lotFrameManu.setBizDate(new Date());
                lotFrameManu.setSeq(lotFrame.getSeq());
                lotFrameManu.setSysDate(lotFrame.getSysDate());
                lotFrameManu.setCurrentSerial(lotFrame.getCurrentSerial());
                lotFrameManu.setMainBizOrg(rs.getString("StoNumber"));
                lotFrameManu.setMaterial(rs.getString("MaterialNumber"));
                lotFrameManu.setLotRule(lotFrame.getLotRule());
                setLotSql.setLength(0);
                setLotSql.append("update t_mm_plannedOrder set flot='").append(lotFrameManu.getLotNumber()).append("' where fid='").append(rs.getString("planOrderID")).append("' ");
                SQLUtils.execute((Context)ctx, (String)setLotSql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void afterUnAudit(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        this.afterUnAuditUpdateReqPlan(ctx, batchResults);
        LotFacadeFactory.getLocalInstance((Context)ctx).plannedorderDeleteLotSource(batchResults.getToDoIdsArray());
    }

    private void afterDelete(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String idSql = this.batchExecuteSql(ctx, batchResults.getToDoIdsArray());
        String billSql = "select fid,fnumber,fstorageorgunitid forgid from T_MM_PLANNEDORDER where fid in (" + idSql + ")";
        CommonUtils.batchRecycleNumber((Context)ctx, (String)billSql, (IObjectValue)new PlannedOrderInfo());
        String poIds = "select fid from t_mm_plannedorder where FSourceType=20 and fid in(" + idSql + ")";
        this.updateReqPlanData(ctx, poIds, BizActionEnum.DELETE);
        String[] sqls = new String[]{"DELETE FROM T_MM_PLANNEDORDER WHERE FID in (" + idSql + ")", "DELETE FROM T_MM_PLANNEDORDERENTRY WHERE FPARENTID in (" + idSql + ")", "DELETE FROM T_MM_PlannedOrderOutputsEntry WHERE FPARENTID in (" + idSql + ")"};
        SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
    }

    private String batchExecuteSql(Context ctx, String[] ids) throws BOSException {
        if (ids.length <= 20) {
            return SQLUtil.arrayToString((Object[])ids);
        }
        StringBuffer createSql = new StringBuffer();
        String tempTableName = null;
        createSql.append("create table temptable ( FBillID varchar(44) ); ");
        tempTableName = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)createSql.toString());
        String[] insertSqls = new String[ids.length];
        StringBuffer insertSql = new StringBuffer();
        for (String BillId : ids) {
            insertSql.append(" insert into ").append(tempTableName).append("(FBillID) values ('").append(BillId).append("');");
            insertSqls[i] = insertSql.toString();
            insertSql.setLength(0);
        }
        DBUtil.executeBatch((Context)ctx, (String[])insertSqls);
        this.tempTableList.add(tempTableName);
        return "select FBillID from " + tempTableName;
    }

    private void releaseTempTables(Context ctx) throws BOSException {
        for (int i = 0; i < this.tempTableList.size(); ++i) {
            KsqlUtil.releaseTempTable((Context)ctx, (String)this.tempTableList.get(i));
        }
        this.tempTableList.clear();
    }

    @Override
    protected void _audit(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)objPK);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchAudit(ctx, entrys);
        result.throwExceptions();
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
        entry.add((Object)pk);
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchUnAudit(ctx, entrys);
        result.throwExceptions();
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        try {
            StringBuffer params = new StringBuffer();
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(pks[i].toString());
                params.append("'");
            }
            String checkSql = "select  FBomNumber ,FBaseStatus ,FSchemeID ,FProductionOrgUnitID ,FOrderType  from T_MM_PlannedOrder where fid in(" + params.toString() + ") ";
            IRowSet checkSet = SQLUtils.executeQuery((Context)ctx, (String)checkSql);
            if (checkSet.next()) {
                if (checkSet.getInt(2) != 2) {
                    throw new PlanOrderException(PlanOrderException.PLNOTSUBMIT_EXCEPTION);
                }
                if (checkSet.getInt(5) == 10 && checkSet.getString(1) == null) {
                    throw new PlanOrderException(PlanOrderException.BOMNUMBERNULL);
                }
                if (checkSet.getString(3) == null) {
                    throw new PlanOrderException(PlanOrderException.PLANNUMNULL);
                }
                if (checkSet.getString(4) == null) {
                    throw new PlanOrderException(PlanOrderException.PRODUNULL);
                }
            }
            String updateSql = "update T_MM_PlannedOrder set FBaseStatus = 4,FAuditorId='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',FAuditTime = getDate() where fid in(" + params.toString() + ")";
            SQLUtils.execute((Context)ctx, (String)updateSql);
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        try {
            StringBuffer params = new StringBuffer();
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(pks[i].toString());
                params.append("'");
            }
            String checkSql = "select top 1 FNumber from T_MM_PlannedOrder where fid in(" + params.toString() + ") and ((FScheduleQty>0 or FtotalReleaseQty>0) or FBaseStatus in (0,1,2,7))";
            IRowSet checkSet = SQLUtils.executeQuery((Context)ctx, (String)checkSql);
            if (checkSet.next() && checkSet.getString(1) != null) {
                throw new PlanOrderException(PlanOrderException.UNAUDIT_ERR_EXCEPTION);
            }
            checkSql = "select top 1 fid from T_BOT_RELATION where FSrcObjectID in(" + params.toString() + ") ";
            checkSet = SQLUtils.executeQuery((Context)ctx, (String)checkSql);
            if (checkSet.next() && checkSet.getString(1) != null) {
                throw new PlanOrderException(PlanOrderException.UNAUDIT_ERR_EXCEPTION);
            }
            String updateSql = "update T_MM_PlannedOrder set FBaseStatus = 1,FAuditorId=null,FAuditTime = null where fid in(" + params.toString() + ")";
            SQLUtils.execute((Context)ctx, (String)updateSql);
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
    }

    @Override
    protected void _closed(Context ctx, IObjectPK pk) throws BOSException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._closed(ctx, pks);
    }

    @Override
    protected void _closed(Context ctx, IObjectPK[] pks) throws BOSException {
        try {
            String[] ids = new String[pks.length];
            StringBuffer params = new StringBuffer();
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(pks[i].toString());
                params.append("'");
                ids[i] = pks[i].toString();
            }
            String idSql = this.batchExecuteSql(ctx, ids);
            String checkSql = "select FNumber from T_MM_PlannedOrder where fid in(" + idSql + ") and FBaseStatus<>4";
            IRowSet checkSet = SQLUtils.executeQuery((Context)ctx, (String)checkSql);
            if (checkSet.getRow() > 0) {
                throw new PlanOrderException(PlanOrderException.CLOSEDERROR_EXCEPTION);
            }
            String updateSql = "update T_MM_PlannedOrder set FBaseStatus = " + BillBaseStatusEnum.CLOSED.getValue() + " where fid in(" + idSql + ")";
            SQLUtils.execute((Context)ctx, (String)updateSql);
            this.updateReqPlanData(ctx, idSql, BizActionEnum.DELETE);
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseTempTables(ctx);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PlannedOrderInfo info = (PlannedOrderInfo)model;
        if (!this.isAddNew(ctx, (IObjectValue)info)) {
            this.checkSave(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        }
        info.setBizDate(info.getBizDate());
        SCMServerUtils.eliminateNULLValue((Context)ctx, (IObjectValue)info);
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        PlannedOrderEntryCollection entries = info.getEntries();
        PlannedOrderEntryInfo entry = null;
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            entry = entries.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        info.setBizType(null);
        return super._save(ctx, model);
    }

    protected void checkSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PlannedOrderInfo planorderInfo = this.getPlannedOrderInfo(ctx, pk);
        if (planorderInfo.getBaseStatus().getValue() != 0 && planorderInfo.getBaseStatus().getValue() != 1) {
            throw new PlanOrderException(PlanOrderException.SUBMITED_SAVE_INFORMATION);
        }
        super._canUpdate(ctx, pk);
    }

    protected boolean _checkSubmit(Context ctx, IObjectValue model, boolean isOk) throws EASBizException, BOSException {
        return true;
    }

    private boolean checkBeforSubmit(Context ctx, PlannedOrderInfo info) throws EASBizException, BOSException {
        boolean isConfig;
        MaterialPlanInfo planInfo;
        boolean bCheckPass = false;
        int iPlanningMode = 0;
        IRowSet rs = null;
        String sql = null;
        if (info.getBaseStatus().getValue() != 1 && info.getBaseStatus().getValue() != 2 && info.getBaseStatus().getValue() != 0) {
            throw new PlanOrderException(PlanOrderException.PLANNEDORDER_STATUS);
        }
        if (this.isCheckEntry(info)) {
            if (info.getBom() == null) {
                throw new PlanOrderException(PlanOrderException.BOMNUMBERNULL);
            }
            if (info.getEntries().size() == 0) {
                throw new PlanOrderException(PlanOrderException.PLANNEDOR_ENTRY_IS_NULL);
            }
        }
        this.checkFactoryCalendar(ctx, info);
        sql = "select t1.FThrowMode, t1.FMaterialAttr,t1.FPlanningMode from T_BD_MaterialPlan t1  where t1.FOrgUnit='" + info.getStorageOrgUnit().getId().toString() + "' and t1.FMaterialID='" + info.getMaterial().getId().toString() + "'";
        int iMaterialAttr = 0;
        rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
        if (rs.size() == 0) {
            throw new PlanOrderException(PlanOrderException.MATPLAN_NOTEXISTS);
        }
        try {
            rs.next();
            iMaterialAttr = rs.getInt("FMaterialAttr");
            iPlanningMode = rs.getInt("FPlanningMode");
            bCheckPass = PlanningParamFactory.getLocalInstance(ctx).checkReleaseParam(info.getStorageOrgUnit().getId().toString(), iMaterialAttr, info.getOrderType().getValue());
            if (!bCheckPass) {
                throw new PlanOrderException(PlanOrderException.RELEASELIMIT_EXCEPTION);
            }
            if (PlannedOrderTypeEnum.FABRICATED.equals((Object)info.getOrderType()) && 0 == rs.getInt("FThrowMode") && info.getTransactionType() == null) {
                throw new PlanOrderException(PlanOrderException.TRANSACTIONTYPE_NULL_EXCEPTION);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        if (!PlanningModeEnum.getEnum((int)iPlanningMode).equals((Object)PlanningModeEnum.MPS) && !PlanningModeEnum.getEnum((int)iPlanningMode).equals((Object)PlanningModeEnum.MRP)) {
            throw new PlanOrderException(PlanOrderException.MPSMRPITEM_INPUTONLY_EXCEPTION);
        }
        if (info.getQty().compareTo(new BigDecimal("0.00")) <= 0 || info.getBaseQty().compareTo(new BigDecimal("0.00")) <= 0) {
            throw new PlanOrderException(PlanOrderException.ZERO_QTY_EXCEPTION);
        }
        boolean isInput = true;
        if (info.getSourceType() != null && info.getSourceType().equals((Object)PlannedOrderSourceEnum.SYSTEMINPUT)) {
            isInput = false;
        }
        if ((planInfo = this.getPlanInfo(ctx, info)) != null && (isConfig = planInfo.isIsConfigable()) && isInput && info.getProject() == null && info.getTrackNumber() == null) {
            throw new PlanOrderException(PlanOrderException.PROJECT_NOT_NULL, new Object[]{info.getMaterial().getName()});
        }
        if (isInput) {
            this.checkProjAndTrackByMaterialPlanInfo(info, planInfo);
        }
        if (PlannedOrderTypeEnum.FABRICATED.equals((Object)info.getOrderType()) && info.getAdminOrgUnit() == null) {
            throw new PlanOrderException(PlanOrderException.MANUFACTUREORGUNIT_CANNOT_NULL);
        }
        PlannedOrderEntryInfo poEntryInfo = null;
        WarehouseInfo warehouse = null;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            poEntryInfo = info.getEntries().get(i);
            warehouse = poEntryInfo.getDefaultWarehouse();
            if (poEntryInfo.isBackFlush() && warehouse != null && warehouse.isHasLocation() && poEntryInfo.getLocation() == null) {
                throw new PlanOrderException(PlanOrderException.LOCATION_CANNOT_NULL);
            }
            if (poEntryInfo.isIsReplaced() || poEntryInfo.getDemandQty() != null && new BigDecimal("0.00").compareTo(poEntryInfo.getDemandQty()) != 0) continue;
            throw new PlanOrderException(PlanOrderException.DEMAND_QTY_CANNOT_NULL);
        }
        return bCheckPass;
    }

    private boolean isCheckEntry(PlannedOrderInfo info) {
        return info.getOrderType().getValue() == 10 || info.getOrderType().getValue() == 30 && info.getStorageOrgUnit().getId().toString().equals(info.getProductionOrgUnit().getId().toString());
    }

    private void checkProjAndTrackByMaterialPlanInfo(PlannedOrderInfo plannedorderInfo, MaterialPlanInfo planInfo) throws PlanOrderException {
        ManufactureStrategyInfo strategyInfo = planInfo.getManufactureStrategy();
        if (this.isTrackNumberRequired(strategyInfo) && plannedorderInfo.getTrackNumber() == null) {
            throw new PlanOrderException(PlanOrderException.TRACKNUMBER_CANNOT_NULL);
        }
        if (this.isProjectRequired(strategyInfo)) {
            if (plannedorderInfo.getProject() == null) {
                throw new PlanOrderException(PlanOrderException.PROJECTNUMBER_CANNOT_NULL);
            }
            if (IsolatedRuleEnum.ITEM_TRACKNO.equals((Object)planInfo.getIsolatedRule()) && plannedorderInfo.getTrackNumber() == null) {
                throw new PlanOrderException(PlanOrderException.TRACKNUMBER_CANNOT_NULL);
            }
        }
    }

    private boolean isTrackNumberRequired(ManufactureStrategyInfo strategyInfo) {
        String strategyId = strategyInfo.getId().toString();
        return "fpPxtypCS/ihJ30GjB/UJtg0uEU=".equals(strategyId) || "qAXoUB/tBg/gQKjAYj0WQ9g0uEU=".equals(strategyId) || "qAYbemEdG9ngQKjAYj0V1dg0uEU=".equals(strategyId) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(strategyId);
    }

    private boolean isProjectRequired(ManufactureStrategyInfo strategyInfo) {
        String strategyId = strategyInfo.getId().toString();
        return "GE2FIa4GQ6uhdx0RDGuibtg0uEU=".equals(strategyId) || "qAXoUB/uBg/gQKjAYj0WQ9g0uEU=".equals(strategyId);
    }

    @Override
    protected IRowSet _getBomChild(Context ctx, Map paramMap) throws BOSException, EASBizException {
        int iDaySeq = 0;
        String sqlTableName = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = sdf.format(paramMap.get("FDate"));
        String sql = "select t1.FworkDate,t1.FworkDateSeq from T_MM_FactoryCalendarEntry t1 LEFT JOIN T_MM_FactoryCalendar t2 ON t1.FParentID=t2.FID where t1.FworkDate=to_date('" + sDate + "') and t2.FStorageOrgUnitID='" + paramMap.get("FStorageorgUnitID").toString() + "' and t2.FIsDefault=1";
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
        if (rs == null || rs.size() == 0) {
            return null;
        }
        try {
            rs.next();
            iDaySeq = rs.getInt("FworkDateSeq");
        }
        catch (SQLException ex) {
            throw new PlanOrderException(PlanOrderException.BOM_EXPAND_ERROR);
        }
        rs = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        sql = "CREATE TABLE TempBomExpand (FStorageorgUnitID varchar(44),FMaterialID varchar(44),FDate DateTime,FDaySeq int,FBaseQty Decimal(21,8),FTraceID varchar(44),fbomid varchar(44),FTRACKNUMBERID varchar(44),FPROJECTID varchar(44),fid  varchar(44), FBOMENTRYID varchar(44));";
        try {
            sqlTableName = pool.createTempTable(sql);
        }
        catch (Exception e1) {
            throw new PlanOrderException(PlanOrderException.BOM_EXPAND_ERROR);
        }
        BigDecimal baseQty = (BigDecimal)paramMap.get("FBaseQty");
        BigDecimal defaultQty = new BigDecimal("0.00");
        if (baseQty.compareTo(defaultQty) == 0) {
            baseQty = defaultQty;
        }
        sql = paramMap.get("FBOMID") != null ? "Insert Into " + sqlTableName + " (FStorageorgUnitID,FMaterialID,FDate,FDaySeq,FBaseQty,FTraceID,FTRACKNUMBERID,FPROJECTID,fbomid) values('" + paramMap.get("FStorageorgUnitID").toString() + "','" + paramMap.get("FMaterialID").toString() + "',to_date('" + sDate + "'|| ' 00:00:00')," + Integer.toString(iDaySeq) + "," + baseQty.toPlainString() + ", newbosid('B844D41F') ,'" + paramMap.get("FTRACKNUMBERID").toString() + "','" + paramMap.get("FPROJECTID").toString() + "','" + paramMap.get("FBOMID").toString() + "');" : "Insert Into " + sqlTableName + " (FStorageorgUnitID,FMaterialID,FDate,FDaySeq,FBaseQty,FTraceID,FTRACKNUMBERID,FPROJECTID) values('" + paramMap.get("FStorageorgUnitID").toString() + "','" + paramMap.get("FMaterialID").toString() + "',to_date('" + sDate + "'|| ' 00:00:00')," + Integer.toString(iDaySeq) + "," + baseQty.toPlainString() + ",newbosid('B844D41F'),'" + paramMap.get("FTRACKNUMBERID").toString() + "','" + paramMap.get("FPROJECTID").toString() + "')";
        try {
            SQLUtils.execute((Context)ctx, (String)sql);
        }
        catch (BOSException bosExp) {
            if (bosExp.getCause() != null && bosExp.getCause() instanceof SQLException) {
                SQLException sqle = (SQLException)bosExp.getCause();
                throw new SQLAccessException(sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
            }
            throw bosExp;
        }
        String tableResult = null;
        try {
            tableResult = BOMExtendFacadeFactory.getLocalInstance((Context)ctx).getBOMExpandResult(sqlTableName, true);
            if (tableResult == null) {
                IRowSet sqle = null;
                return sqle;
            }
            Locale locale = ctx.getLocale();
            sql = "select t1.FBomEntryBillID,t1.FChildMaterialID,t2.FNumber,t2.Fname_l1,t2.Fname_l2,t2.Fname_l3,t2.Fmodel,t2.FBaseUnit,TM1.FNumber as FBaseUnitNumber,TM1.FName_l1 as FBaseUnitName_l1,TM1.FName_l2 as FBaseUnitName_l2,TM1.FName_l3 as FBaseUnitName_l3,t3.FProductUnitID as FPdtUnit,TM2.FNumber as FPdtNumber,TM2.FName_l1 as FPdtUnitName_l1,TM2.FName_l2 as FPdtUnitName_l2,TM2.FName_l3 as FPdtUnitName_l3,T5.FBaseConvsRate,T5.FQtyPrecision,t1.FBaseQty,t1.FDate,FSTORAGEORGUNITID=t1.FSupplyStorageOrgUnitID,t4.fnumber as OrgUnitNUmber,t4.FName_l1 as OrgUnitName_l1,T4.FName_l2 as OrgUnitName_l2,T4.FName_l3 as OrgUnitName_l3, t3.FIsQuotaControl,t3.FIssInHightLimit,t3.FIssInLowLimit,t1.FOutputType,be.FNETWEIGHT FNETWEIGHT,be.FBlkSize FBlkSize,be.FSpecifiedLength FSpecifiedLength , isnull(be.fprovidetype,t3.fprovidetype) AS FProvideType,t1.FUnitQty,t1.FScrapRatio, t1.fScrapRateExpression ,w.fid as DefaultWarehouseID,w.fnumber as DefaultWarehouseNumber,w.fname_" + locale + " as DefaultWarehouseName,w.fhasLocation as DefaultWareHasLocation,loca.fid as LocationID,loca.fnumber as LocationNumber,loca.fname_" + locale + " as LocationName,t1.FIsBackFlush,t1.FIsStockTransfer,s.fid as TransferOrgUnitID,s.fnumber as TransferOrgUnitNumber,s.fname_" + locale + " as TransferOrgUnitName,ware.fid as TransferWarehouseID,ware.fnumber as TransferWarehouseNumber,ware.fname_" + locale + " as TransferWarehouseName,t1.FIssMode,case when t1.fScrapRatio=0 then t1.FProductQty else t1.fPerfectProductQty end as fPerfectProductQty,case when t1.fScrapRatio=0 then t1.FBaseQty else t1.fPerfectBaseQty end as fPerfectBaseQty,t1.FProductQty from " + tableResult + " t1 inner join T_mm_bomentry be on t1.FBOMENTRYID=be.fid  inner join T_BD_material t2 on t1.FChildMaterialID=t2.FID  left join T_BD_MeasureUnit TM1 on t2.FBaseUnit=TM1.FID  inner join T_BD_materialPlan t3 on T2.FID=t3.FMaterialID and t1.FSTORAGEORGUNITID=t3.FOrgUnit  left join T_BD_MeasureUnit TM2 on t1.FProductUnitID=TM2.FID  left join T_Org_Storage T4 on T4.FID=T1.FSupplyStorageOrgUnitID left join T_BD_MultiMeasureUnit T5 on T1.FProductUnitID=T5.FMeasureUnitID and T5.FMaterialID=T1.FChildMaterialID  left join T_DB_WAREHOUSE w on w.fid = t1.FDefaultWarehouseID left join T_DB_LOCATION as loca on loca.fid = t1.FLocationID left join T_ORG_Storage as s on s.fid = t1.FTransferOrgUnitID left join T_DB_WAREHOUSE ware on ware.fid = t1.FTransferWarehouseID where t1.FSTORAGEORGUNITID='" + paramMap.get("FStorageorgUnitID").toString() + "'";
            rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException bosExp) {
            if (bosExp.getCause() != null && bosExp.getCause() instanceof SQLException) {
                SQLException sqle = (SQLException)bosExp.getCause();
                throw new SQLAccessException(sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
            }
            throw bosExp;
        }
        catch (PlanOrderException ex) {
            throw new PlanOrderException(PlanOrderException.BOM_EXPAND_ERROR);
        }
        finally {
            if (sqlTableName != null) {
                pool.releaseTable(sqlTableName);
            }
            if (tableResult != null) {
                pool.releaseTable(tableResult);
            }
        }
        return rs;
    }

    @Override
    protected void _batchWriteBackBySchedule(Context ctx, Map haspMap) throws BOSException, EASBizException {
        this.callBatchWriteBackBySchedule(ctx, haspMap, "FScheduleQty", "FBaseScheduleQty", "+");
    }

    private void callBatchWriteBackBySchedule(Context ctx, Map haspMap, String sUpdateField, String sBaseUpdateField, String sType) throws BOSException, EASBizException {
        String sql = "";
        sql = sUpdateField.equalsIgnoreCase("FTOTALRELEASEQTY") ? "Update T_MM_PlannedOrder set " + sUpdateField + "=isnull(" + sUpdateField + ",0)" + sType + "?," + sBaseUpdateField + "=isnull(" + sBaseUpdateField + ",0)" + sType + "?,FBaseStatus=case when isnull(" + sUpdateField + ",0)" + sType + "?>=FQty then 7 else 4 end where FID=?" : "Update T_MM_PlannedOrder set " + sUpdateField + "=isnull(" + sUpdateField + ",0)" + sType + "?," + sBaseUpdateField + "=isnull(" + sBaseUpdateField + ",0)" + sType + "? where FID=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        PlannedOrderInfo plInfo = null;
        BigDecimal bigCoefficient = null;
        BigDecimal bigQty = null;
        String sFID = null;
        int iCount = 0;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", haspMap.keySet(), CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("productUnit.id"));
        PlannedOrderCollection poCollection = PlannedOrderFactory.getLocalInstance(ctx).getPlannedOrderCollection(viewInfo);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            for (int i = 0; i < poCollection.size(); ++i) {
                plInfo = poCollection.get(i);
                sFID = plInfo.getId().toString();
                bigQty = (BigDecimal)haspMap.get(sFID);
                bigCoefficient = SCMUtils.getExchangeRateQty((Context)ctx, (MaterialInfo)plInfo.getMaterial(), (MeasureUnitInfo)plInfo.getProductUnit());
                stmt.setBigDecimal(1, bigQty);
                stmt.setBigDecimal(2, bigQty.multiply(bigCoefficient));
                if (sUpdateField.equalsIgnoreCase("FTOTALRELEASEQTY")) {
                    stmt.setBigDecimal(3, bigQty);
                    stmt.setString(4, sFID);
                } else {
                    stmt.setString(3, sFID);
                }
                stmt.addBatch();
                if (++iCount != 100) continue;
                iCount = 0;
                stmt.executeBatch();
            }
            if (iCount > 0) {
                stmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        if (sUpdateField.equalsIgnoreCase("FTOTALRELEASEQTY")) {
            this.writeBackPlannedEntry(ctx, haspMap);
        }
    }

    @Override
    protected void _batchWriteBackByRelease(Context ctx, Map haspMap) throws BOSException, EASBizException {
        this.callBatchWriteBackBySchedule(ctx, haspMap, "FtotalReleaseQty", "FBaseTotalReleaseQty", "+");
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StorageOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((PlannedOrderInfo)model).getStorageOrgUnit()) != null && unitInfo.getId() != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    protected void checkFactoryCalendar(Context ctx, PlannedOrderInfo info) throws BOSException, PlanOrderException {
        String sql = "select b.FDateType from T_MM_FactoryCalendar A Inner join T_MM_FactoryCalendarEntry B on a.fid=b.FParentID where a.FStorageOrgUnitID='" + info.getStorageOrgUnit().getId().toString() + "' and a.FIsDefault=1 ";
        int iDateType = -1;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = sdf.format(info.getStartDate());
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        String sDate1 = sdf1.format(info.getEndDate());
        IRowSet rs = null;
        rs = SQLUtils.executeQuery((Context)ctx, (String)(sql + " and b.FWorkDate=to_date('" + sDate + "')"));
        if (rs != null && rs.size() > 0) {
            try {
                rs.next();
                iDateType = rs.getInt("FDateType");
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
            if (iDateType != WorkDateTypeEnum.HALFWORKDAY.getValue() && iDateType != WorkDateTypeEnum.WORKDAY.getValue()) {
                throw new PlanOrderException(PlanOrderException.STARTDATE_NOTWORK_EXCEPTION);
            }
        } else {
            throw new PlanOrderException(PlanOrderException.FACTORYCALENDAR_NOTEXISTS_EXCEPTION);
        }
        rs = null;
        rs = SQLUtils.executeQuery((Context)ctx, (String)(sql + " and b.FWorkDate=to_date('" + sDate1 + "')"));
        if (rs != null && rs.size() > 0) {
            try {
                rs.next();
                iDateType = rs.getInt("FDateType");
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
            if (iDateType != WorkDateTypeEnum.HALFWORKDAY.getValue() && iDateType != WorkDateTypeEnum.WORKDAY.getValue()) {
                throw new PlanOrderException(PlanOrderException.ENDDATE_NOTWORK_EXCEPTION);
            }
        } else {
            throw new PlanOrderException(PlanOrderException.FACTORYCALENDAR_NOTEXISTS_EXCEPTION);
        }
    }

    @Override
    protected Date _getValidateCalendar(Context ctx, String orgUnitID, Date paramDate, int iDays) throws BOSException, EASBizException {
        Date result;
        block7: {
            if (paramDate == null) {
                paramDate = new Date();
            }
            result = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String sDate = sdf.format(paramDate);
            int iDay = 0;
            String sql = "select FWorkDate,FDateType,FNextWorkDaySeq from T_MM_FactoryCalendarEntry t1 LEFT JOIN T_MM_FactoryCalendar t2 ON t1.FParentID=t2.FID where t1.FWorkDateSeq=(select case when s1.FWorkDateSeq>0 then s1.FWorkDateSeq else s1.FNextWorkDaySeq end+" + Integer.toString(iDays) + " as FWorkDateSeq from T_MM_FactoryCalendarEntry s1 LEFT JOIN T_MM_FactoryCalendar s2 ON s1.FParentID=s2.FID where s2.FStorageOrgUnitID='" + orgUnitID + "' and s2.FIsDefault=1 and s1.FworkDate=to_date('" + sDate + "') ) and t2.FStorageOrgUnitID='" + orgUnitID + "' and t2.FIsDefault = 1";
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
            if (rs == null) {
                return null;
            }
            try {
                if (rs.next()) {
                    paramDate = rs.getDate("FWorkDate");
                    iDay = rs.getInt("FDateType");
                    if (iDay == 1 || iDay == 4) {
                        result = paramDate;
                    } else {
                        iDay = rs.getInt("FNextWorkDaySeq");
                        rs = null;
                        sql = "select FWorkDate from T_MM_FactoryCalendarEntry t1 LEFT JOIN T_MM_FactoryCalendar t2 ON t1.FParentID=t2.FID where t1.FworkDateSeq=" + Integer.toString(iDay) + " and t2.FStorageOrgUnitID='" + orgUnitID + "' and t2.FIsDefault = 1 ";
                        rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
                        rs.next();
                        result = rs.getDate("FWorkDate");
                    }
                    break block7;
                }
                throw new PlanOrderException(PlanOrderException.FACTORYCALENDAR_NOTEXISTS_EXCEPTION);
            }
            catch (SQLException ex) {
                throw new PlanOrderException(PlanOrderException.FACTORYCALENDAR_NOTEXISTS_EXCEPTION);
            }
        }
        return result;
    }

    @Override
    protected IRowSet _getSchemeInfo(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.FSchemeID,t2.FNumber,t2.FName_");
        sql.append(ctx.getLocale().toString()).append(" as FName, ").append(CLR);
        sql.append("sum(case when t1.FBaseStatus=4 then 1 else 0 end) as FPLAuditCount,").append(CLR);
        sql.append("sum(case when t1.FBaseStatus=2 then 1 else 0 end) as FPLsubmitCount ").append(CLR);
        sql.append("from T_MM_PlannedOrder t1 ").append(CLR);
        sql.append("inner join T_MM_PlanVersionSet t2 ");
        sql.append(" on t1.FSchemeID=t2.fid and (t1.FBaseStatus=2 or t1.FBaseStatus=4) ").append(CLR);
        sql.append("where t1.FStorageOrgUnitID='").append(storageOrgUnitID);
        sql.append("' and t1.FisSimulant=1 ").append(CLR);
        sql.append("group by t1.FSchemeID,t2.FNumber,t2.FName_").append(ctx.getLocale().toString());
        sql.append(" order by t2.Fnumber");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    @Override
    protected Map _simulantTransform(Context ctx, String storageOrgUnitID, List planVersionSetIds) throws BOSException, EASBizException {
        HashMap errorMap = new HashMap();
        try {
            this.requestMutex(ctx, storageOrgUnitID);
            List planOrderIdsToTransform = this.getPlanOrderIdsToTransform(ctx, storageOrgUnitID, planVersionSetIds);
            this.checkMaterialIsAudit(ctx, planOrderIdsToTransform, errorMap);
            if (planOrderIdsToTransform.size() == 0) {
                HashMap hashMap = errorMap;
                return hashMap;
            }
            String planOrderIds = SQLUtil.arrayToString((Object[])planOrderIdsToTransform.toArray());
            this.transformPlanOrder(ctx, planOrderIds);
            this.updateReqPlanData(ctx, planOrderIds, BizActionEnum.ALTER);
            this.deletePlanOrderByMaterial(ctx, storageOrgUnitID, planOrderIds);
            this.deletePOInCurrentPlanVersions(ctx, storageOrgUnitID, planVersionSetIds);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseMutex(ctx, storageOrgUnitID);
        }
        return errorMap;
    }

    private List getPlanOrderIdsToTransform(Context ctx, String storageOrgUnitId, List planVersionSetIds) throws BOSException {
        LinkedList<String> planOrderIdsToTransform = new LinkedList<String>();
        String planVersionSetIdsString = SQLUtil.arrayToString((Object[])planVersionSetIds.toArray());
        StringBuffer updateIdsBuffer = new StringBuffer();
        updateIdsBuffer.append("select fid from T_MM_PlannedOrder where FSchemeID in (").append(planVersionSetIdsString).append(")");
        updateIdsBuffer.append(" and fstorageorgunitid='").append(storageOrgUnitId).append("'");
        updateIdsBuffer.append(" and FBaseStatus= ").append(4);
        updateIdsBuffer.append(" and FisSimulant=1 ");
        IRowSet planOrderIdsSet = SQLUtils.executeQuery((Context)ctx, (String)updateIdsBuffer.toString());
        try {
            while (planOrderIdsSet.next()) {
                planOrderIdsToTransform.add(planOrderIdsSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return planOrderIdsToTransform;
    }

    private void deletePOInCurrentPlanVersions(Context ctx, String storageOrgUnitId, List planVersionSetIds) throws BOSException {
        String planVersionSetIdsString = SQLUtil.arrayToString((Object[])planVersionSetIds.toArray());
        StringBuffer planOrdersToDelete = new StringBuffer();
        planOrdersToDelete.append(" select fid from t_mm_plannedorder where fstorageorgunitid='").append(storageOrgUnitId).append("' and fschemeid in (").append(planVersionSetIdsString).append(") and FisSimulant=1 and FBaseStatus in (0, 1, 2) ");
        this.deletePlanOrder(ctx, planOrdersToDelete.toString());
    }

    private void transformPlanOrder(Context ctx, String planOrderIds) throws BOSException {
        StringBuffer updatePlanOrderSql = new StringBuffer();
        updatePlanOrderSql.append("update T_MM_PlannedOrder set FisSimulant=0 ").append("where FID in (").append(planOrderIds).append(") ");
        SQLUtils.execute((Context)ctx, (String)updatePlanOrderSql.toString());
    }

    private void deletePlanOrderByMaterial(Context ctx, String storageOrgUnitId, String planOrderIds) throws BOSException {
        StringBuffer planOrdersToDelete = new StringBuffer();
        planOrdersToDelete.append(" select fid from t_mm_plannedorder where fstorageorgunitid='").append(storageOrgUnitId).append("' and FMaterialId in ").append("  (select distinct FmaterialId from t_mm_plannedorder where fid in (").append(planOrderIds).append("))").append(" and FisSimulant=0 and FbaseStatus in (0, 1, 2) ");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)planOrdersToDelete.toString());
        ArrayList<String> ids = new ArrayList<String>();
        try {
            while (rs.next()) {
                ids.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (ids.size() > 0) {
            String planOrderId = SQLUtil.arrayToString((Object[])ids.toArray());
            try {
                this.updateReqPlanData(ctx, planOrderId, BizActionEnum.DELETE);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        this.deletePlanOrder(ctx, planOrdersToDelete.toString());
    }

    private void deletePlanOrder(Context ctx, String planOrdersToDelete) throws BOSException {
        StringBuffer deletePlanOrderEntrySql = new StringBuffer();
        deletePlanOrderEntrySql.append(" delete from t_mm_plannedorderentry where fparentid in (").append(planOrdersToDelete).append(") ");
        SQLUtils.execute((Context)ctx, (String)deletePlanOrderEntrySql.toString());
        StringBuffer deletePlanOrderSql = new StringBuffer();
        deletePlanOrderSql.append("delete from t_mm_plannedorder where fid in (").append(planOrdersToDelete).append(") ");
        SQLUtils.execute((Context)ctx, (String)deletePlanOrderSql.toString());
    }

    private boolean checkBaseMaterial(Context ctx, PlannedOrderInfo plInfo) throws EASBizException, BOSException {
        boolean isMapppingFlow = false;
        CompanyOrgUnitInfo comOrgIn = PlannedOrderControllerBean.getCompanyInfo(ctx, plInfo.getStorageOrgUnit().getId());
        if (comOrgIn == null) {
            throw new PlanOrderException(PlanOrderException.COMPANYISNULL_IN_EXCEPTION);
        }
        CompanyOrgUnitInfo comOrgOut = PlannedOrderControllerBean.getCompanyInfo(ctx, plInfo.getProductionOrgUnit().getId());
        if (comOrgOut == null) {
            throw new PlanOrderException(PlanOrderException.COMPANYISNULL_OUT_EXCEPTION);
        }
        PurchaseOrgUnitInfo pouInfo = this.getPurOrgsInfo(ctx, plInfo);
        if (pouInfo == null || pouInfo.getId() == null) {
            throw new PlanOrderException(PlanOrderException.PURATTR_NULL);
        }
        if (plInfo.getOrderType().equals((Object)PlannedOrderTypeEnum.FABRICATED)) {
            String materialID = plInfo.getMaterial().getId().toString();
            MaterialPlanInfo comInfo = null;
            MaterialPlanCollection colls = null;
            FilterInfo matFilter = new FilterInfo();
            matFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
            matFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)plInfo.getStorageOrgUnit().getId()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(matFilter);
            colls = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewInfo);
            comInfo = colls.get(0);
            boolean flag = comInfo.isIsProductLinePlan();
            if (comInfo.getThrowMode() == ThrowModeEnum.FLOW) {
                isMapppingFlow = true;
            }
            if (flag) {
                throw new PlanOrderException(PlanOrderException.EXPORT_ORDER_ISPRODUCTLIN);
            }
        }
        PlanOrderException subExceptionItem = null;
        PlanOrderException apprSubExceptionItem = null;
        if (plInfo.getOrderType() != null && plInfo.getOrderType().getValue() == 20) {
            subExceptionItem = new PlanOrderException(PlanOrderException.PURATTR_NULL);
            this.checkBaseMaterialTable(ctx, plInfo.getMaterial().getId().toString(), "and FOrgUnit='" + pouInfo.getId().toString() + "'", "t_bd_materialpurchasing", subExceptionItem, subExceptionItem);
            return isMapppingFlow;
        }
        if (plInfo.getOrderType() != null && plInfo.getOrderType().getValue() == 30 && plInfo.getStorageOrgUnit().getId().equals((Object)plInfo.getProductionOrgUnit().getId())) {
            subExceptionItem = new PlanOrderException(PlanOrderException.PURATTR_NULL);
            this.checkBaseMaterialTable(ctx, plInfo.getMaterial().getId().toString(), "and FOrgUnit='" + pouInfo.getId().toString() + "'", "t_bd_materialpurchasing", subExceptionItem, subExceptionItem);
            return isMapppingFlow;
        }
        if (plInfo.getOrderType() != null && plInfo.getOrderType().getValue() == 30 && !plInfo.getStorageOrgUnit().getId().equals((Object)plInfo.getProductionOrgUnit().getId())) {
            if (comOrgIn.equals((Object)comOrgOut)) {
                subExceptionItem = new PlanOrderException(PlanOrderException.RELEASE_CHK_MAT_EXCEPTION1, new Object[]{plInfo.getMaterial().getNumber()});
                this.checkBaseMaterialTable(ctx, plInfo.getMaterial().getId().toString(), "and FOrgUnit='" + plInfo.getStorageOrgUnit().getId().toString() + "'", "t_bd_materialInventory", subExceptionItem, null);
                subExceptionItem = new PlanOrderException(PlanOrderException.RELEASE_CHK_MAT_EXCEPTION2, new Object[]{plInfo.getMaterial().getNumber()});
                this.checkBaseMaterialTable(ctx, plInfo.getMaterial().getId().toString(), "and FOrgUnit='" + plInfo.getProductionOrgUnit().getId().toString() + "'", "t_bd_materialInventory", subExceptionItem, null);
                subExceptionItem = new PlanOrderException(PlanOrderException.RELEASE_CHK_FIN_EXCEPTION1, new Object[]{plInfo.getMaterial().getNumber()});
                apprSubExceptionItem = new PlanOrderException(PlanOrderException.RELEASE_CHK_MAT_EXCEPTION6, new Object[]{plInfo.getMaterial().getName(), plInfo.getMaterial().getNumber()});
                this.checkBaseMaterialTable(ctx, plInfo.getMaterial().getId().toString(), "and FCompanyID='" + comOrgIn.getId().toString() + "'", "t_bd_materialcompanyinfo", subExceptionItem, apprSubExceptionItem);
            } else {
                subExceptionItem = new PlanOrderException(PlanOrderException.RELEASE_CHK_MAT_EXCEPTION3, new Object[]{plInfo.getMaterial().getNumber()});
                this.checkBaseMaterialTable(ctx, plInfo.getMaterial().getId().toString(), "and FOrgUnit='" + plInfo.getStorageOrgUnit().getId().toString() + "'", "t_bd_materialInventory", subExceptionItem, null);
                subExceptionItem = new PlanOrderException(PlanOrderException.RELEASE_CHK_MAT_EXCEPTION2, new Object[]{plInfo.getMaterial().getNumber()});
                this.checkBaseMaterialTable(ctx, plInfo.getMaterial().getId().toString(), "and FOrgUnit='" + plInfo.getProductionOrgUnit().getId().toString() + "'", "t_bd_materialInventory", subExceptionItem, null);
                subExceptionItem = new PlanOrderException(PlanOrderException.RELEASE_CHK_MAT_EXCEPTION3, new Object[]{plInfo.getMaterial().getNumber()});
                apprSubExceptionItem = new PlanOrderException(PlanOrderException.RELEASE_CHK_MAT_EXCEPTION5, new Object[]{comOrgIn.getNumber(), plInfo.getMaterial().getName(), plInfo.getMaterial().getNumber()});
                this.checkBaseMaterialTable(ctx, plInfo.getMaterial().getId().toString(), "and FCompanyID='" + comOrgIn.getId().toString() + "'", "t_bd_materialcompanyinfo", subExceptionItem, apprSubExceptionItem);
                subExceptionItem = new PlanOrderException(PlanOrderException.RELEASE_CHK_MAT_EXCEPTION4, new Object[]{plInfo.getMaterial().getNumber()});
                apprSubExceptionItem = new PlanOrderException(PlanOrderException.RELEASE_CHK_MAT_EXCEPTION5, new Object[]{comOrgOut.getNumber(), plInfo.getMaterial().getName(), plInfo.getMaterial().getNumber()});
                this.checkBaseMaterialTable(ctx, plInfo.getMaterial().getId().toString(), "and FCompanyID='" + comOrgOut.getId().toString() + "'", "t_bd_materialcompanyinfo", subExceptionItem, apprSubExceptionItem);
            }
        }
        return isMapppingFlow;
    }

    private void checkBaseMaterialTable(Context ctx, String matID, String otherFilter, String sTableName, PlanOrderException subExceptionItem, PlanOrderException apprSubExceptionItem) throws BOSException, EASBizException {
        String sql = "select FStatus from " + sTableName + " where FMaterialID='" + matID + "' " + otherFilter;
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql);
        if (rs == null) {
            throw subExceptionItem;
        }
        if (rs.size() == 0) {
            throw subExceptionItem;
        }
        if (sTableName.equalsIgnoreCase("t_bd_materialcompanyinfo")) {
            try {
                if (rs.next() && rs.getInt("FStatus") != 1) {
                    throw apprSubExceptionItem;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (sTableName.equalsIgnoreCase("t_bd_materialpurchasing")) {
            try {
                if (rs.next() && rs.getInt("FStatus") != 1) {
                    throw apprSubExceptionItem;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, BOSUuid souId) throws EASBizException, BOSException {
        if (souId == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(souId.toString(), 4, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(souId.toString(), 4, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    private PurchaseOrgUnitInfo getPurOrgsInfo(Context ctx, PlannedOrderInfo info) throws EASBizException, BOSException {
        String stroageOrgUnitID;
        PurchaseOrgUnitInfo purOrg = null;
        String materialID = info.getMaterial().getId().toString();
        String FPurOrgID = this.getDefaultPurOrgID(ctx, materialID, stroageOrgUnitID = info.getStorageOrgUnit().getId().toString());
        if (FPurOrgID != null) {
            purOrg = new PurchaseOrgUnitInfo();
            purOrg.setId(BOSUuid.read((String)FPurOrgID));
            return purOrg;
        }
        return SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getPurchaseByStorageOrg(stroageOrgUnitID);
    }

    @Override
    protected void _validateMaterial(Context ctx, IObjectValue plannedOrderInfo) throws BOSException, EASBizException {
        this.checkBaseMaterial(ctx, (PlannedOrderInfo)plannedOrderInfo);
    }

    @Override
    protected Map _getInitDataAfterMainOrgChange(Context ctx, String storageOrgUnitID, String materialID, String measureUnitID) throws EASBizException, BOSException {
        HashMap<String, Cloneable> mapResult = new HashMap<String, Cloneable>();
        HashSet<String> idSet = new HashSet<String>();
        OrgUnitCollection orgCol = null;
        IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        orgCol = iUtilRel.getToUnit(storageOrgUnitID, 4, 0);
        for (int i = 0; i < orgCol.size(); ++i) {
            idSet.add(orgCol.get(i).getId().toString());
        }
        mapResult.put("ADMINORGIDSET", idSet);
        HashMap<String, String> releaseParams = new HashMap<String, String>();
        releaseParams.put("PARAMFABRICATED", "4");
        releaseParams.put("PARAMPURCHASE", "2");
        releaseParams.put("PARAMSTOCKTRANSFER", "1");
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_SETS.getValue(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitID, CompareType.EQUALS));
        v.setFilter(filter);
        PlanningParamValueCollection collParam = PlanningParamValueFactory.getLocalInstance(ctx).getPlanningParamValueCollection(v);
        if (collParam == null) {
            throw new PlanOrderException(PlanOrderException.CHECKBLANK);
        }
        if (collParam.size() > 0) {
            int iSize = collParam.size();
            for (int i = 0; i < iSize; ++i) {
                PlanningParamValueInfo info = collParam.get(i);
                if (info.getNumber().equalsIgnoreCase(PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_FABRICATEDPART.getValue())) {
                    releaseParams.put("PARAMFABRICATED", info.getParamValue());
                    continue;
                }
                if (info.getNumber().equalsIgnoreCase(PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_PURCHASEDPART.getValue())) {
                    releaseParams.put("PARAMPURCHASE", info.getParamValue());
                    continue;
                }
                if (!info.getNumber().equalsIgnoreCase(PlannedOrderReleaseEnum.PLANNEDORDER_RELEASE_EXTERNALPROCESSINPART.getValue())) continue;
                releaseParams.put("PARAMSTOCKTRANSFER", info.getParamValue());
            }
        }
        mapResult.put("RELEASEPARAMS", releaseParams);
        MaterialPlanInfo comInfo = null;
        if (!"".equals(materialID)) {
            MaterialPlanCollection colls = null;
            FilterInfo matFilter = new FilterInfo();
            matFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
            matFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitID));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(matFilter);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("materialAttr"));
            colls = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewInfo);
            comInfo = colls.get(0);
        }
        mapResult.put("MATERIALPLAN", (Cloneable)comInfo);
        PlanVersionSetCollection planVersionSetCol = this.getPlanVersionSetCollection(ctx, storageOrgUnitID);
        mapResult.put("planVersionSetCol", (Cloneable)planVersionSetCol);
        if (!"".equals(materialID) && !"".equals(measureUnitID)) {
            MultiMeasureUnitInfo measureUnitInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialID, measureUnitID);
            mapResult.put("measureUnitInfo", (Cloneable)measureUnitInfo);
        }
        return mapResult;
    }

    private PlanVersionSetCollection getPlanVersionSetCollection(Context ctx, String ids) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)ids));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"900"));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"901"));
        filterInfo.setMaskString("#0 and (#1 or #2)");
        viewInfo.setFilter(filterInfo);
        PlanVersionSetCollection planVersionSetCol = PlanVersionSetFactory.getLocalInstance((Context)ctx).getPlanVersionSetCollection(viewInfo);
        return planVersionSetCol;
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults.hasToDos()) {
            if (BatchActionEnum.SUBMIT.equals((Object)batchAction)) {
                this.submitBatchCheck(ctx, batchResults);
            } else if (BatchActionEnum.AUDIT.equals((Object)batchAction)) {
                long time00 = System.currentTimeMillis();
                this.auditBatchCheck(ctx, batchResults);
                long time01 = System.currentTimeMillis();
                logger2.error((Object)("#############\u8ba1\u5212\u8ba2\u5355\u5ba1\u6838\u68c0\u67e5\u603b\u65f6\u95f4\uff1a" + (time01 - time00)));
            } else if (BatchActionEnum.UNAUDIT.equals((Object)batchAction)) {
                this.unAuditBatchCheck(ctx, batchResults);
            }
        }
    }

    private void submitBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        PlannedOrderCollection plannedOrders = (PlannedOrderCollection)batchResults.getObjCollection();
        PlannedOrderInfo poInfo = null;
        String poId = null;
        for (int i = 0; i < plannedOrders.size(); ++i) {
            poInfo = plannedOrders.get(i);
            poId = poInfo.getId() == null ? "NEWID" : poInfo.getId().toString();
            try {
                this.checkBeforSubmit(ctx, poInfo);
                continue;
            }
            catch (EASBizException easException) {
                batchResults.addError(poId, easException.getMessage());
            }
        }
    }

    private void auditBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        long time1 = System.currentTimeMillis();
        String errorMsg = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)batchResults.getToDoIdsSet(), CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("lot"));
        viewInfo.getSelector().add(new SelectorItemInfo("isCannotRelease"));
        viewInfo.getSelector().add(new SelectorItemInfo("orderType"));
        viewInfo.getSelector().add(new SelectorItemInfo("productionOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("bom.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("entries.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("outputEntries.id"));
        PlannedOrderCollection poCollection = PlannedOrderFactory.getLocalInstance(ctx).getPlannedOrderCollection(viewInfo);
        long time2 = System.currentTimeMillis();
        logger2.error((Object)("#############\u8ba1\u5212\u8ba2\u5355\u5ba1\u6838\u68c0\u67e51\uff1a" + (time2 - time1)));
        PlannedOrderInfo plannedOrderInfo = null;
        String id = null;
        for (int i = 0; i < poCollection.size(); ++i) {
            LotFrame lotFrame;
            plannedOrderInfo = poCollection.get(i);
            id = plannedOrderInfo.getId().toString();
            StorageOrgUnitInfo storageOrgUnitInfo = plannedOrderInfo.getStorageOrgUnit();
            MaterialInfo materialInfo = plannedOrderInfo.getMaterial();
            Map lotParam = LotFacadeFactory.getLocalInstance((Context)ctx).plannedorderGetLot(storageOrgUnitInfo.getId().toString(), materialInfo.getId().toString(), false);
            if (lotParam != null && (lotFrame = (LotFrame)lotParam.get("lotRule")) == null && ((Boolean)lotParam.get("manufactureOrderPlan")).booleanValue() && plannedOrderInfo.getOrderType() != PlannedOrderTypeEnum.PURCHASE && (plannedOrderInfo.getLot() == null || "".equals(plannedOrderInfo.getLot().trim()))) {
                errorMsg = this.getReqResource("LOT_CANNOT_NULL", new String[0]);
                batchResults.addError(id, errorMsg);
            }
            if (plannedOrderInfo.isIsCannotRelease()) {
                errorMsg = this.getReqResource("PLANORDER_CANNOT_RELEASE", new String[0]);
                batchResults.addError(id, errorMsg);
            }
            if (!this.isCheckEntry(plannedOrderInfo)) continue;
            if (plannedOrderInfo.getBom() == null) {
                errorMsg = new PlanOrderException(PlanOrderException.BOMNUMBERNULL).getMessage();
                batchResults.addError(id, errorMsg);
                continue;
            }
            if (plannedOrderInfo.getEntries().size() != 0) continue;
            errorMsg = this.getReqResource("PLANNEDOR_ENTRY_IS_NULL", new String[0]);
            batchResults.addError(id, errorMsg);
        }
        long time3 = System.currentTimeMillis();
        logger2.error((Object)("#############\u8ba1\u5212\u8ba2\u5355\u5ba1\u6838\u68c0\u67e52\uff1a" + (time3 - time2)));
        try {
            this.checkMaterialIsAudit(ctx, batchResults);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        long time4 = System.currentTimeMillis();
        logger2.error((Object)("#############\u8ba1\u5212\u8ba2\u5355\u5ba1\u6838\u68c0\u67e53\uff1a" + (time4 - time3)));
    }

    private void unAuditBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        StringBuffer sqlBuffer = new StringBuffer();
        String msg = null;
        sqlBuffer.append("select T.FID POID, T.FStorageOrgUnitID StorageOrgUnitID ").append("from T_MM_PlannedOrder T ").append("where T.FID in (").append(idStr).append(") ");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        try {
            while (rs.next()) {
                boolean isUnAudit = false;
                String strAutoAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, rs.getString("StorageOrgUnitID"), this.getBillTypeId());
                if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equals("1")) {
                    isUnAudit = true;
                }
                if (isUnAudit) continue;
                msg = this.getReqResource("PARAM_UNAUDIT_NOT_ALLOEWED", new String[0]);
                batchResults.addError(rs.getString("POID"), msg);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void writeBackPlannedEntry(Context ctx, Map haspMap) throws BOSException {
        Iterator it = haspMap.keySet().iterator();
        StringBuffer sbs = new StringBuffer();
        while (it.hasNext()) {
            sbs.append("'").append(it.next().toString()).append("',");
        }
        String ids = sbs.toString();
        ids = ids.substring(0, ids.lastIndexOf(","));
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_MM_PlannedOrderEntry as entry set (freleaseQty,freleaseBaseQty) = (").append(" select round(decimal(t0.FTotalReleaseQty * t1.fdemandQty /t0.FQty ,21,8),t2.FQtyPrecision), ").append("        round(decimal(t0.FTotalReleaseQty * t1.fdemandQty /t0.FQty * t2.FBaseConvsRate ,21,8),t2.FQtyPrecision) ").append(" from T_MM_PlannedOrder as t0 , T_MM_PlannedOrderEntry as t1 , t_bd_multimeasureunit t2").append(" where t0.fid = t1.fparentid and  t1.FMaterialID = t2.FMaterialID and t1.FUnitID = t2.fmeasureunitid ").append(" and t0.FID in (").append(ids).append(") and entry.fid = t1.fid)");
        SQLUtils.execute((Context)ctx, (String)sb.toString());
    }

    private String getDefaultPurOrgID(Context ctx, String materialID, String storageOrgUnitID) throws BOSException {
        if (materialID == null || storageOrgUnitID == null) {
            return null;
        }
        String purOrgID = null;
        String sql = "select FPurOrgID from T_BD_MaterialPlan where fmaterialid = '" + materialID + "' and forgunit=  '" + storageOrgUnitID + "' ";
        IRowSet purid = SQLUtils.executeQuery((Context)ctx, (String)sql);
        try {
            while (purid.next()) {
                purOrgID = purid.getString("FPurOrgID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return purOrgID;
    }

    private MaterialPlanInfo getPlanInfo(Context ctx, PlannedOrderInfo planInfo) throws BOSException {
        MaterialPlanInfo comInfo = null;
        MaterialPlanCollection colls = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)planInfo.getMaterial().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)planInfo.getStorageOrgUnit().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("isConfigable"));
        viewInfo.getSelector().add(new SelectorItemInfo("isolatedRule"));
        viewInfo.getSelector().add(new SelectorItemInfo("planner.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("planner.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("manufactureStrategy.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("supplyOrgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("supplyOrgUnit.name"));
        colls = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewInfo);
        comInfo = colls.get(0);
        return comInfo;
    }

    @Override
    protected BatchActionResults _batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws BOSException, EASBizException {
        return this.batchAudit(ctx, entries);
    }

    private void afterAuditUpdateReqPlan(Context ctx, BatchActionResults batchResults) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        try {
            this.updateReqPlanData(ctx, idStr, BizActionEnum.AUDIT);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void afterUnAuditUpdateReqPlan(Context ctx, BatchActionResults batchResults) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        try {
            this.updateReqPlanData(ctx, idStr, BizActionEnum.UNAUDIT);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMaterialIsAudit(Context ctx, BatchActionResults batchResults) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        String tmptable = this.insertdata(ctx, batchResults.getToDoIdsArray());
        try {
            sql.append("select \n");
            sql.append("tmp.fid as poId ,tmp.entryMaterialId as mId, tmp.materialName as mName,\n");
            sql.append("M2.fstatus as mStatus, mp2.fstatus as mpStatus,\n");
            sql.append("mi2.fstatus as miStatus, ");
            sql.append("tmp.supplyOrgUnit,tmp.orgUnit,storage.fname_").append(PlannedOrderControllerBean.getLocale()).append(" as storageName, \n");
            sql.append("tmp.ProvideType as entryProvideType \n");
            sql.append("from (select \n");
            sql.append("poEntry.fmaterialId as entryMaterialId,po.fid as fid,\n");
            sql.append("poEntry.FStorageOrgUnitID as supplyOrgUnit, poEntry.FProvideType as ProvideType, \n");
            sql.append("m.fnumber as materialNum,m.fname_").append(PlannedOrderControllerBean.getLocale()).append(" as materialName, mp.ForgUnit as orgUnit\n");
            sql.append("from T_mm_plannedorder po\n");
            sql.append(" inner join ").append(tmptable);
            sql.append(" as tmp on tmp.fid = po.fid ");
            sql.append("inner join T_mm_plannedorderentry  poEntry on poEntry.fParentId = po.fId\n");
            sql.append(" and (poEntry.FProvideType = ").append(10930);
            sql.append(" or poEntry.FProvideType = ").append(10940).append(") ");
            sql.append(" inner join T_BD_Material M on poEntry.fmaterialId = M.fid\n");
            sql.append("inner join T_bd_materialplan MP on poEntry.fmaterialId = MP.fmaterialId\n");
            sql.append("and po.FStorageOrgUnitID = mp.ForgUnit\n");
            sql.append(" where  po.FisSimulant=0 ");
            sql.append(" and (po.FProductionOrgUnitID = po.FStorageOrgUnitID ").append(" or (po.FProductionOrgUnitID != po.FStorageOrgUnitID ").append(" and po.FOrderType=").append(10).append("))");
            sql.append(") as tmp\n");
            sql.append("left outer join T_BD_Material M2 on tmp.materialNum = M2.fnumber\n");
            sql.append("left outer join T_BD_MaterialInventory MI2 on MI2.ForgUnit = tmp.supplyOrgUnit and M2.fid = MI2.fmaterialId\n");
            sql.append("left outer join T_bd_materialplan mp2 on mp2.ForgUnit = tmp.supplyOrgUnit and M2.fid = mp2.fmaterialId\n");
            sql.append("inner join T_ORG_Storage storage on storage.fid = tmp.supplyOrgUnit\n");
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (1 == rs.getInt("mpStatus") && 1 == rs.getInt("miStatus") && 1 == rs.getInt("mStatus")) continue;
                String provideTypeName = MaterialProvideTypeEnum.getEnum((int)rs.getInt("entryProvideType")).getAlias();
                String msgInfo = this.getReqResource("MID_AUDIT_CHECK", new String[]{provideTypeName, rs.getString("mName"), rs.getString("storageName")});
                batchResults.addError(rs.getString("poId"), msgInfo);
            }
        }
        finally {
            if (tmptable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tmptable);
            }
        }
    }

    private void checkMaterialIsAudit(Context ctx, List planOrderIds, Map results) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        String idStr = SQLUtil.arrayToString((Object[])planOrderIds.toArray());
        sql.append("select tmp.Number as poNumber, \n");
        sql.append("tmp.fid as poId ,tmp.entryMaterialId as mId, tmp.materialName as mName,\n");
        sql.append("M2.fstatus as mStatus, mp2.fstatus as mpStatus,\n");
        sql.append("mi2.fstatus as miStatus, ");
        sql.append("tmp.supplyOrgUnit,tmp.orgUnit,storage.fname_").append(PlannedOrderControllerBean.getLocale()).append(" as storageName, \n");
        sql.append("tmp.ProvideType as entryProvideType \n");
        sql.append("from (select po.FNumber as Number, \n");
        sql.append("poEntry.fmaterialId as entryMaterialId,po.fid as fid,\n");
        sql.append("poEntry.FStorageOrgUnitID as supplyOrgUnit, poEntry.FProvideType as ProvideType, \n");
        sql.append("m.fnumber as materialNum,m.fname_").append(PlannedOrderControllerBean.getLocale()).append(" as materialName, mp.ForgUnit as orgUnit\n");
        sql.append("from T_mm_plannedorder po\n");
        sql.append("inner join T_mm_plannedorderentry  poEntry on poEntry.fParentId = po.fId\n");
        sql.append(" and poEntry.FProvideType in ( ").append(10930);
        sql.append(",").append(10940).append(") ");
        sql.append(" inner join T_BD_Material M on poEntry.fmaterialId = M.fid\n");
        sql.append("inner join T_bd_materialplan MP on poEntry.fmaterialId = MP.fmaterialId\n");
        sql.append("and po.FStorageOrgUnitID = mp.ForgUnit\n");
        sql.append(" where po.fid in (").append(idStr).append(")");
        sql.append(" and (po.FProductionOrgUnitID = po.FStorageOrgUnitID ").append(" or (po.FProductionOrgUnitID != po.FStorageOrgUnitID ").append(" and po.FOrderType=").append(10).append("))");
        sql.append(") as tmp\n");
        sql.append("left outer join T_BD_Material M2 on tmp.materialNum = M2.fnumber\n");
        sql.append("left outer join T_BD_MaterialInventory MI2 on MI2.ForgUnit = tmp.supplyOrgUnit and M2.fid = MI2.fmaterialId\n");
        sql.append("left outer join T_bd_materialplan mp2 on mp2.ForgUnit = tmp.supplyOrgUnit and M2.fid = mp2.fmaterialId\n");
        sql.append("inner join T_ORG_Storage storage on storage.fid = tmp.supplyOrgUnit\n");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            if (1 == rs.getInt("mpStatus") && 1 == rs.getInt("miStatus") && 1 == rs.getInt("mStatus")) continue;
            String provideTypeName = MaterialProvideTypeEnum.getEnum((int)rs.getInt("entryProvideType")).getAlias();
            String msgInfo = this.getReqResource("MID_AUDIT_CHECK", new String[]{provideTypeName, rs.getString("mName"), rs.getString("storageName")});
            results.put(rs.getString("poNumber"), msgInfo);
            planOrderIds.remove(rs.getString("poId"));
        }
    }

    private String getReqResource(String key, String[] params) {
        return ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.PlannedOrderResource", (String)key, (String[])params);
    }

    private static Locale getLocale() {
        try {
            return ContextUtils.getContextFromSession().getLocale();
        }
        catch (Throwable e) {
            return new Locale("L2");
        }
    }

    private void updateReqPlanData(Context ctx, String idStr, BizActionEnum bizAction) throws BOSException, EASBizException {
        IReqPlanReceiveReqDataFacade reqPlanReceiveReqDataFacade = ReqPlanReceiveReqDataFacadeFactory.getLocalInstance(ctx);
        reqPlanReceiveReqDataFacade.receiveReqPlanDate("9XXvbVGlRtym/0qtqeIXXrhE1B8=", idStr, bizAction);
    }

    @Override
    protected Map _transformInBatch(Context ctx, String storageOrgUnitId, List planOrderIdsToTransform, String schemeId, boolean isDeleteSimulantPlanOrder) throws BOSException, EASBizException {
        HashMap errorMap = new HashMap();
        try {
            this.requestMutex(ctx, storageOrgUnitId);
            this.checkMaterialIsAudit(ctx, planOrderIdsToTransform, errorMap);
            if (planOrderIdsToTransform.size() == 0) {
                HashMap hashMap = errorMap;
                return hashMap;
            }
            String planOrderIds = SQLUtil.arrayToString((Object[])planOrderIdsToTransform.toArray());
            this.transformPlanOrder(ctx, planOrderIds);
            this.updateReqPlanData(ctx, planOrderIds, BizActionEnum.ALTER);
            this.deletePlanOrderByMaterial(ctx, storageOrgUnitId, planOrderIds);
            if (isDeleteSimulantPlanOrder) {
                this.deletePOInCurrentPlanVersion(ctx, storageOrgUnitId, schemeId);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseMutex(ctx, storageOrgUnitId);
        }
        return errorMap;
    }

    private void deletePOInCurrentPlanVersion(Context ctx, String storageOrgUnitId, String schemeId) throws BOSException {
        StringBuffer planOrdersToDelete = new StringBuffer();
        planOrdersToDelete.append(" select fid from t_mm_plannedorder where FStorageOrgUnitID='").append(storageOrgUnitId).append("' ").append(" and FSchemeId ='").append(schemeId).append("' ").append("and FisSimulant=1 ");
        this.deletePlanOrder(ctx, planOrdersToDelete.toString());
    }

    private void requestMutex(Context ctx, String storageOrgUnitId) throws BOSException, EASBizException {
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean bLock = mutex.requestObjIDForUpdate(storageOrgUnitId, ctx.getCaller().toString(), Uuid.create());
        if (!bLock) {
            throw new PlanOrderException(PlanOrderException.SIMULANT_TRANSFER_LOCKED);
        }
    }

    private void releaseMutex(Context ctx, String storageOrgUnitId) throws BOSException {
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutex.releaseObjIDForUpdate(storageOrgUnitId);
    }

    @Override
    protected List _getValidateCalendar(Context ctx, String storageOrgUnitId, List dateParams) throws BOSException, EASBizException {
        LinkedList<Date> endDates = new LinkedList<Date>();
        Map dateParam = null;
        Date srcDate = null;
        Date endDate = null;
        int offset = 0;
        for (int i = 0; i < dateParams.size(); ++i) {
            dateParam = (Map)dateParams.get(i);
            srcDate = (Date)dateParam.get("srcDate");
            offset = (Integer)dateParam.get("offset");
            endDate = this._getValidateCalendar(ctx, storageOrgUnitId, srcDate, offset);
            endDates.add(endDate);
        }
        return endDates;
    }

    @Override
    protected void _planOrderSplit(Context ctx, String storageOrgUnitId, String planOrderId, List splitParams) throws BOSException, EASBizException {
        BigDecimal remainQty = (BigDecimal)((Map)splitParams.get(0)).get("remainQty");
        try {
            IPlannedOrder poInstance = PlannedOrderFactory.getLocalInstance(ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("outputEntries.*");
            selector.add("entries.*");
            selector.add("entries.unit.id");
            selector.add("entries.unit.qtyPrecision");
            PlannedOrderInfo info = poInstance.getPlannedOrderInfo((IObjectPK)new ObjectUuidPK(planOrderId), selector);
            CoreBaseCollection poCollection = this.createPlanOrder(ctx, storageOrgUnitId, info, splitParams);
            this.updateGenPlanOrder(ctx, info);
            this.updateLot(ctx, planOrderId);
            this.updateSrcPlanOrder(ctx, info, poCollection, remainQty);
            ArrayList<String> splitPlanOrderIds = new ArrayList<String>();
            PlannedOrderInfo poInfo = null;
            for (int i = 0; i < poCollection.size(); ++i) {
                poInfo = (PlannedOrderInfo)poCollection.get(i);
                splitPlanOrderIds.add(poInfo.getId().toString());
            }
            this.afterPlanOrderSplit(ctx, storageOrgUnitId, planOrderId, splitPlanOrderIds);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private CoreBaseCollection createPlanOrder(Context ctx, String storageOrgUnitId, PlannedOrderInfo info, List splitParams) throws BOSException, EASBizException {
        BigDecimal poQty = info.getQty();
        IPlannedOrder poInstance = PlannedOrderFactory.getLocalInstance(ctx);
        CoreBaseCollection poCollection = new CoreBaseCollection();
        PlannedOrderInfo newPoInfo = null;
        PlannedOrderEntryCollection newPoEntryCollection = null;
        PlannedOrderEntryInfo newPoEntry = null;
        Map planOrderParam = null;
        BigDecimal newPoQty = null;
        BigDecimal newPoEntryDemandQty = null;
        BigDecimal newPoEntryScrapQty = null;
        BigDecimal newPoEntryStandardQty = null;
        BigDecimal remainQty = (BigDecimal)((Map)splitParams.get(0)).get("remainQty");
        boolean isCompelteSplit = new BigDecimal("0.00").compareTo(remainQty) == 0;
        Timestamp createTime = new Timestamp(new Date().getTime());
        String creatorId = ctx.getCaller().toString();
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)creatorId));
        PlannedOrderEntryInfo srcEntryInfo = null;
        BigDecimal sumDemandQty = new BigDecimal("0.00");
        BigDecimal sumStandardQty = new BigDecimal("0.00");
        for (int i = 0; i < splitParams.size(); ++i) {
            planOrderParam = (Map)splitParams.get(i);
            newPoInfo = (PlannedOrderInfo)info.clone();
            newPoInfo.setSourceBillId(info.getId().toString());
            newPoInfo.setId(BOSUuid.create((BOSObjectType)newPoInfo.getBOSType()));
            newPoInfo.setNumber((String)planOrderParam.get("number"));
            newPoInfo.setQty((BigDecimal)planOrderParam.get("qty"));
            newPoInfo.setBaseQty((BigDecimal)planOrderParam.get("baseQty"));
            newPoInfo.setStartDate((Date)planOrderParam.get("startDate"));
            newPoInfo.setEndDate((Date)planOrderParam.get("endDate"));
            newPoInfo.setAvilableDate((Date)planOrderParam.get("availableDate"));
            newPoInfo.setCreator(user);
            newPoInfo.setCreateTime(createTime);
            newPoQty = newPoInfo.getQty();
            newPoInfo.setFinalProductsQty((BigDecimal)planOrderParam.get("finalProductsQty"));
            newPoEntryCollection = newPoInfo.getEntries();
            int prodQtyPrec = 8;
            for (int j = 0; j < newPoEntryCollection.size(); ++j) {
                newPoEntry = newPoEntryCollection.get(j);
                srcEntryInfo = this.getSrcPlanOrderEntry(info, newPoEntry.getId());
                prodQtyPrec = srcEntryInfo.getUnit().getQtyPrecision();
                newPoEntry.setId(BOSUuid.create((BOSObjectType)newPoEntry.getBOSType()));
                newPoEntry.setParent(newPoInfo);
                if (i == splitParams.size() - 1 && splitParams.size() > 1 && isCompelteSplit) {
                    newPoEntryDemandQty = srcEntryInfo.getDemandQty().subtract((BigDecimal)srcEntryInfo.get("sumDemandQty"));
                    newPoEntryStandardQty = srcEntryInfo.getStandardQty().subtract((BigDecimal)srcEntryInfo.get("sumStandardQty"));
                } else {
                    newPoEntryDemandQty = newPoEntry.getDemandQty();
                    newPoEntryDemandQty = newPoQty.multiply(newPoEntryDemandQty).divide(poQty, 8, 4).setScale(prodQtyPrec, 2);
                    newPoEntryStandardQty = newPoQty.multiply(newPoEntry.getUnitQty()).setScale(prodQtyPrec, 2);
                    if (i == 0) {
                        sumDemandQty = new BigDecimal("0.00");
                        sumStandardQty = new BigDecimal("0.00");
                    } else {
                        sumDemandQty = (BigDecimal)srcEntryInfo.get("sumDemandQty");
                        sumStandardQty = (BigDecimal)srcEntryInfo.get("sumStandardQty");
                    }
                    sumDemandQty = sumDemandQty.add(newPoEntryDemandQty);
                    sumStandardQty = sumStandardQty.add(newPoEntryStandardQty);
                    srcEntryInfo.put("sumDemandQty", sumDemandQty);
                    srcEntryInfo.put("sumStandardQty", sumStandardQty);
                }
                newPoEntry.setDemandQty(newPoEntryDemandQty);
                newPoEntry.setStandardQty(newPoEntryStandardQty);
                newPoEntryScrapQty = newPoEntryDemandQty.subtract(newPoEntry.getStandardQty());
                newPoEntry.setScrapQty(newPoEntryScrapQty);
            }
            poCollection.add((CoreBaseInfo)newPoInfo);
        }
        Result result = poInstance.save(poCollection);
        if (result.getResult() != 1) {
            throw new PlanOrderException(PlanOrderException.SPLIT_FALIED);
        }
        return poCollection;
    }

    private PlannedOrderEntryInfo getSrcPlanOrderEntry(PlannedOrderInfo poInfo, BOSUuid entryUuid) {
        PlannedOrderEntryInfo poEntryIfno = null;
        PlannedOrderEntryInfo temp = null;
        PlannedOrderEntryCollection poEntries = poInfo.getEntries();
        for (int i = 0; i < poEntries.size(); ++i) {
            temp = poEntries.get(i);
            if (!temp.getId().equals((Object)entryUuid)) continue;
            poEntryIfno = temp;
            break;
        }
        return poEntryIfno;
    }

    private void updateGenPlanOrder(Context ctx, PlannedOrderInfo info) throws EASBizException, BOSException {
        String planOrderIds = "select FID from T_MM_PlannedOrder where FSourceBillId='" + info.getId().toString() + "' and fbaseStatus <> '" + 4 + "' and fbaseStatus <> '" + 7 + "'";
        this.updatePlanOrderEntryBaseDemandQty(ctx, planOrderIds);
        this.updatePlanOrderEntryReqDate(ctx, planOrderIds);
        this.updateReqData(ctx, planOrderIds, info);
    }

    private void updateReqData(Context ctx, String planOrderIds, PlannedOrderInfo info) throws EASBizException, BOSException {
        if (BillBaseStatusEnum.SUBMITED.equals((Object)info.getBaseStatus())) {
            StringBuffer sql = new StringBuffer();
            sql.append("update t_mm_plannedOrder set fbaseStatus=").append(2);
            sql.append(" where fid in (").append(planOrderIds).append(") ");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
            if (info.getCalcID() != null) {
                this.updateReqPlanData(ctx, planOrderIds, BizActionEnum.SUBMIT);
            }
        }
    }

    private void updatePlanOrderBaseQty(Context ctx, String planOrderIds) throws BOSException {
        StringBuffer updatePlanOrderSql = new StringBuffer();
        updatePlanOrderSql.append("update T_MM_PlannedOrder as PO").append("\n").append("set FBaseQty=").append("\n").append(" select round(decimal(PO.FQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision) ").append("    from t_bd_multimeasureunit t1, t_bd_multimeasureunit t2 ").append("    where PO.FMaterialId=t1.FmaterialId and PO.FProductUnitId=t1.FmeasureUnitId ").append("    and PO.FMaterialId=t2.FmaterialId and PO.FUnitId=t2.FmeasureUnitId ").append("\n").append("where PO.FID in (").append(planOrderIds).append(") ");
        SQLUtils.execute((Context)ctx, (String)updatePlanOrderSql.toString());
    }

    private void updatePlanOrderEntryBaseDemandQty(Context ctx, String planOrderIds) throws BOSException {
        StringBuffer updatePlanOrderEntrySql = new StringBuffer();
        updatePlanOrderEntrySql.append("update T_MM_PlannedOrderEntry as Entry").append("\n").append("set FBaseDemandQty= ").append("\n").append("    (select ").append("\n").append("    round(decimal(Entry.FDemandQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision) ").append("    from t_bd_multimeasureunit t1, t_bd_multimeasureunit t2 ").append("    where Entry.FMaterialID=t1.FMaterialID and Entry.FUnitID=t1.fmeasureunitid \n ").append("\t and Entry.FMaterialID=t2.FMaterialID and Entry.FBaseUnitID=t2.fmeasureunitid) \n ").append("where Entry.FParentId in ").append("(").append(planOrderIds).append(") ");
        SQLUtils.execute((Context)ctx, (String)updatePlanOrderEntrySql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlanOrderEntryReqDate(Context ctx, String planOrderIds) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("create table calcDate(");
        sb.append("fid varchar(44)");
        sb.append(",fstorageorgunitid varchar(44)");
        sb.append(",fdate DATETIME");
        sb.append(",fWorkDateSeq int default 0 not null ");
        sb.append(",FLeadtime int default 0 not null");
        sb.append(",fReqDate DATETIME");
        sb.append(")");
        String tableName = MMUtils.createTmpTable((Context)ctx, (String)sb.toString());
        try {
            sb.setLength(0);
            sb.append("insert into ").append(tableName);
            sb.append("(fid, fstorageorgunitid, fdate, FLeadtime)");
            sb.append(" select Entry.fid, po.fstorageorgunitid, po.FStartDate, bomentry.FLeadtime");
            sb.append(" from T_MM_PlannedOrder as po");
            sb.append(" inner join T_MM_PlannedOrderEntry as Entry on Entry.fparentId = po.fid");
            sb.append(" inner join t_mm_bomentry as bomentry on bomentry.fid = Entry.fsourcebillentryid");
            sb.append(" where Entry.FParentId in");
            sb.append("       (").append(planOrderIds).append(") ");
            int executeNum = SQLUtils.execute((Context)ctx, (String)sb.toString());
            if (executeNum < 1) {
                return;
            }
            sb.setLength(0);
            sb.append("update ").append(tableName).append(" as tmp ");
            sb.append(" set fWorkDateSeq = ");
            sb.append("     (select ");
            sb.append(" \t    case when fce.FWorkDateSeq <= 0 and fce.FPreWorkDaySeq > 0 ");
            sb.append("                 then fce.FPreWorkDaySeq ");
            sb.append("              when fce.FWorkDateSeq <= 0 and fce.FPreWorkDaySeq <= 0 and fce.FNextWorkDaySeq > 0 ");
            sb.append("                 then fce.FNextWorkDaySeq ");
            sb.append("              else fce.FWorkDateSeq ");
            sb.append("         end as FCalcWorkDateSeq");
            sb.append("     from t_mm_Factorycalendar as fc");
            sb.append("     inner join t_mm_Factorycalendarentry as fce on fce.fparentId = fc.fid ");
            sb.append("     where to_char(tmp.fdate,'yyyy-mm-dd') = to_char(fce.fworkdate,'yyyy-mm-dd')");
            sb.append("       and fc.fstorageorgunitid = tmp.fstorageorgunitid and fc.FIsDefault = 1 ");
            sb.append("     )");
            executeNum = SQLUtils.execute((Context)ctx, (String)sb.toString());
            if (executeNum < 1) {
                return;
            }
            sb.setLength(0);
            sb.append("update ").append(tableName).append(" as tmp ");
            sb.append(" set fReqDate = ");
            sb.append("               (");
            sb.append("                select fce.fworkdate ");
            sb.append("                from t_mm_Factorycalendar as fc");
            sb.append("                inner join t_mm_Factorycalendarentry as fce on fce.fparentId = fc.fid");
            sb.append("                where tmp.fstorageorgunitid = fc.fstorageorgunitid ");
            sb.append("                  and fce.fworkdateseq = tmp.fworkdateseq + tmp.FLeadtime");
            sb.append("                  and fce.fdatetype = ").append(1);
            sb.append("                  and fc.fstorageorgunitid = tmp.fstorageorgunitid and fc.FIsDefault=1 ");
            sb.append("                )");
            executeNum = SQLUtils.execute((Context)ctx, (String)sb.toString());
            if (executeNum < 1) {
                return;
            }
            sb.setLength(0);
            sb.append(" update T_MM_PlannedOrderEntry as Entry ");
            sb.append(" set freqdate = ");
            sb.append("               (");
            sb.append("               select tmp.fReqDate");
            sb.append("               from ").append(tableName).append(" as tmp ");
            sb.append("               where tmp.fid = Entry.fid");
            sb.append("               )");
            sb.append(" where Entry.FParentId in");
            sb.append("       (").append(planOrderIds).append(") ");
            sb.append("  and Entry.fsourcebillentryid is not null");
            executeNum = SQLUtils.execute((Context)ctx, (String)sb.toString());
        }
        finally {
            MMUtils.releaseTmpTable((Context)ctx, (String)tableName);
        }
    }

    private void updateSrcPlanOrder(Context ctx, PlannedOrderInfo info, CoreBaseCollection poCollection, BigDecimal remainQty) throws BOSException, EASBizException {
        String planOrderId = info.getId().toString();
        StringBuffer updatePlanOrderSql = new StringBuffer();
        if (remainQty.compareTo(new BigDecimal("0.00")) == 0) {
            updatePlanOrderSql.append("update T_MM_PlannedOrder as PO ").append("\n").append("set FBaseStatus=7 ").append("\n").append("where PO.FID='").append(planOrderId).append("' ");
            SQLUtils.execute((Context)ctx, (String)updatePlanOrderSql.toString());
            String idStr = "'" + planOrderId + "'";
            this.updateReqPlanData(ctx, idStr, BizActionEnum.DELETE);
        } else {
            BigDecimal qty = info.getQty();
            BigDecimal calcProductsQty = MMConstant.BIGDECIMAL_ZERO;
            PlannedOrderInfo poInfo = null;
            for (int i = 0; i < poCollection.size(); ++i) {
                poInfo = (PlannedOrderInfo)poCollection.get(i);
                calcProductsQty = calcProductsQty.add(poInfo.getFinalProductsQty());
            }
            info.setFinalProductsQty(info.getFinalProductsQty().subtract(calcProductsQty));
            PlannedOrderEntryCollection entryCollection = info.getEntries();
            PlannedOrderEntryInfo poEntry = null;
            BigDecimal demandQty = null;
            BigDecimal standardQty = null;
            BigDecimal poEntryScrapQty = null;
            for (int j = 0; j < entryCollection.size(); ++j) {
                poEntry = entryCollection.get(j);
                demandQty = poEntry.getDemandQty();
                demandQty = remainQty.multiply(demandQty).divide(qty, 8, 4);
                poEntry.setDemandQty(demandQty);
                standardQty = remainQty.multiply(poEntry.getUnitQty());
                poEntry.setStandardQty(standardQty);
                poEntryScrapQty = demandQty.subtract(poEntry.getStandardQty());
                poEntry.setScrapQty(poEntryScrapQty);
            }
            PlannedOrderFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(planOrderId), (CoreBaseInfo)info);
            updatePlanOrderSql.append("update T_MM_PlannedOrder as PO ").append("\n").append("set FQty=decimal(").append(remainQty.setScale(8, 4).toPlainString()).append(",21,8) \n").append("where PO.FID='").append(planOrderId).append("' ");
            SQLUtils.execute((Context)ctx, (String)updatePlanOrderSql.toString());
            String planOrderIdStr = "'" + planOrderId + "'";
            this.updatePlanOrderBaseQty(ctx, planOrderIdStr);
            this.updatePlanOrderEntryBaseDemandQty(ctx, planOrderIdStr);
            if (BillBaseStatusEnum.SUBMITED.equals((Object)info.getBaseStatus())) {
                String idStr = "'" + planOrderId + "'";
                this.updateReqPlanData(ctx, idStr, BizActionEnum.SUBMIT);
            }
        }
    }

    private void updateLot(Context ctx, String srcPlanOrderId) throws BOSException, EASBizException {
        String planOrderIds = "select FID from T_MM_PlannedOrder where FSourceBillId='" + srcPlanOrderId + "'";
        this.processLot(ctx, planOrderIds);
    }

    @Override
    protected void _deletePlanOrder(Context ctx, String storageOrgUnitId, List planVersionSetIds) throws BOSException {
        String planVersionSetIdsString = SQLUtil.arrayToString((Object[])planVersionSetIds.toArray());
        StringBuffer planOrdersToDelete = new StringBuffer();
        planOrdersToDelete.append(" select fid from t_mm_plannedorder where fstorageorgunitid='").append(storageOrgUnitId).append("' and FschemeId in (").append(planVersionSetIdsString).append(") and FIssimulant=1 ");
        this.deletePlanOrder(ctx, planOrdersToDelete.toString());
    }

    @Override
    protected PlannedOrderEntryCollection _setPlannedOrderEntryDefaultValue(Context ctx, String storageOrgUnitId, PlannedOrderEntryCollection poEntryColl) throws BOSException, EASBizException {
        PlannedOrderEntryCollection entryColl = poEntryColl;
        if (entryColl == null || entryColl.size() == 0) {
            return entryColl;
        }
        PlannedOrderEntryInfo entryInfo = null;
        MaterialProvideTypeEnum provideType = null;
        String materialId = null;
        HashSet<String> materialIdSet = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo.getMaterial() == null || !MMUtils.isNotEmptyString((String)(materialId = entryInfo.getMaterial().getId().toString()))) continue;
            materialIdSet.add(materialId);
        }
        IMaterialPlan imp = MaterialPlanFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        view.setFilter(filterInfo);
        view.setSelector(this.getMaterialPlanSelector());
        MaterialPlanCollection planColl = imp.getMaterialPlanCollection(view);
        MaterialPlanInfo planInfo = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo.getMaterial() == null || (planInfo = this.getMaterialPlanInfoByMaterialId(planColl, materialId = entryInfo.getMaterial().getId().toString())) == null) continue;
            entryInfo.setBackFlush(planInfo.isIsBackFlush());
            entryInfo.setIsStockTransfer(planInfo.isIsStockAllot());
            entryInfo.setProvideType(planInfo.getProvideType());
            entryInfo.setStorageOrgUnit(planInfo.getSupplyOrgUnit());
            entryInfo.setTransferOrgUnit(planInfo.getFromInvOrg());
            entryInfo.setTransferWarehouse(planInfo.getFromWarehouse());
            entryInfo.setIssMode(planInfo.getIssMode());
            entryInfo.setScrapRate(planInfo.getScrapRate());
            entryInfo.put("scrapRateExpression", planInfo.getScrapRateExpression());
        }
        filterInfo = new FilterInfo();
        String orgId = null;
        FilterInfo condition = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null) continue;
            provideType = entryInfo.getProvideType();
            condition = new FilterInfo();
            orgId = MaterialProvideTypeEnum.CURRENTORGPROVIDE.equals((Object)provideType) || MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE.equals((Object)provideType) ? storageOrgUnitId : entryInfo.getStorageOrgUnit().getId().toString();
            condition.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
            condition.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
            filterInfo.mergeFilter(condition, "or");
        }
        IMaterialInventory imi = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        view.setFilter(filterInfo);
        view.setSelector(this.getMaterialInventorySelector());
        MaterialInventoryCollection invenColl = imi.getMaterialInventoryCollection(view);
        MaterialInventoryInfo invenInfo = null;
        String key = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null) continue;
            provideType = entryInfo.getProvideType();
            condition = new FilterInfo();
            orgId = MaterialProvideTypeEnum.CURRENTORGPROVIDE.equals((Object)provideType) || MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE.equals((Object)provideType) ? storageOrgUnitId : entryInfo.getStorageOrgUnit().getId().toString();
            key = orgId + entryInfo.getMaterial().getId().toString();
            invenInfo = this.getMaterialInventoryInfo(invenColl, key);
            if (invenInfo == null) continue;
            entryInfo.setDefaultWarehouse(invenInfo.getDefaultWarehouse());
            entryInfo.setLocation(null);
        }
        return entryColl;
    }

    private MaterialPlanInfo getMaterialPlanInfoByMaterialId(MaterialPlanCollection planColl, String materialId) {
        MaterialPlanInfo planInfo = null;
        for (int i = 0; i < planColl.size() && !(planInfo = planColl.get(i)).getMaterial().getId().toString().equals(materialId); ++i) {
        }
        return planInfo;
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(MaterialInventoryCollection invenColl, String key) {
        MaterialInventoryInfo invenInfo = null;
        String orgAndMaterial = null;
        for (int i = 0; i < invenColl.size() && !key.equals(orgAndMaterial = (invenInfo = invenColl.get(i)).getOrgUnit().getId().toString() + invenInfo.getMaterial().getId().toString()); ++i) {
        }
        return invenInfo;
    }

    private SelectorItemCollection getMaterialPlanSelector() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("orgUnit.id");
        coll.add("material.id");
        coll.add("isBackFlush");
        coll.add("isStockAllot");
        coll.add("issMode");
        coll.add("fromInvOrg.id");
        coll.add("fromInvOrg.name");
        coll.add("fromInvOrg.number");
        coll.add("fromWarehouse.id");
        coll.add("fromWarehouse.name");
        coll.add("fromWarehouse.number");
        coll.add("supplyOrgUnit.id");
        coll.add("supplyOrgUnit.name");
        coll.add("supplyOrgUnit.number");
        coll.add("provideType");
        coll.add("scrapRate");
        coll.add("scrapRateExpression");
        return coll;
    }

    private SelectorItemCollection getMaterialInventorySelector() {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        coll.add("orgUnit.id");
        coll.add("material.id");
        coll.add("defaultWarehouse.id");
        coll.add("defaultWarehouse.name");
        coll.add("defaultWarehouse.number");
        coll.add("defaultWarehouse.hasLocation");
        return coll;
    }

    protected void afterPlanOrderSplit(Context ctx, String storageOrgUnitId, String planOrderId, List splitPlanOrderIds) throws BOSException, EASBizException {
    }
}

