/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.LineSchedulingModelCollection;
import com.kingdee.eas.mm.basedata.LineSchedulingModelFactory;
import com.kingdee.eas.mm.basedata.LineSchedulingModelInfo;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.PLSTypeEnum;
import com.kingdee.eas.mm.basedata.ProductLineCollection;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefInfo;
import com.kingdee.eas.mm.basedata.TimeUnitEnum;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.CapUnitEnum;
import com.kingdee.eas.mm.planning.ExceptionTypeEnum;
import com.kingdee.eas.mm.planning.PLChooseEntryInfo;
import com.kingdee.eas.mm.planning.PLSEntryCollection;
import com.kingdee.eas.mm.planning.PLSEntryFactory;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.PLSExectionMSGFactory;
import com.kingdee.eas.mm.planning.PLSExectionMSGInfo;
import com.kingdee.eas.mm.planning.PlanOrderEntryCollection;
import com.kingdee.eas.mm.planning.PlanOrderEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderCollection;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.mm.planning.ProductionLineSchedulingFactory;
import com.kingdee.eas.mm.planning.ProductionLineSchedulingInfo;
import com.kingdee.eas.mm.planning.RunResult;
import com.kingdee.eas.mm.planning.SchedulingException;
import com.kingdee.eas.mm.planning.SrcTypeEnum;
import com.kingdee.eas.mm.planning.app.AbstractProductionLineSchedulingControllerBean;
import com.kingdee.eas.mm.planning.app.PLSRunFacadeControllerBean;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProductionLineSchedulingControllerBean
extends AbstractProductionLineSchedulingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.ProductionLineSchedulingControllerBean");
    public static final String RES_SCHEDULING = "com.kingdee.eas.mm.planning.ProductionLineSchedulingResource";
    private final BigDecimal ZERO = new BigDecimal("0");
    private final BigDecimal MINUONE = new BigDecimal("-1");
    private LineSchedulingModelInfo lineSchedulingModelInfo = null;
    private Map unitTimeQtyMap = new HashMap();
    Map unitMap = new HashMap();
    private String currVoucherID = null;

    @Override
    protected IObjectValue _createNewData(Context ctx, IObjectValue currentMainOrg) throws BOSException, EASBizException {
        OrgUnitCollection col;
        ProductionLineSchedulingInfo billInfo = new ProductionLineSchedulingInfo();
        billInfo.setId(BOSUuid.create((String)"6B821276"));
        OrgUnitInfo[] mainOrgs = SCMServiceFactory.getLocalInstance((Context)ctx).getAuthorizedBizOrgUnits(ctx.getCaller(), OrgType.Storage, "mm_ProductionLineScheduling_addnew");
        StorageOrgUnitInfo storageOrgUnit = null;
        if (mainOrgs != null && mainOrgs.length > 0) {
            storageOrgUnit = (StorageOrgUnitInfo)mainOrgs[0];
            if (currentMainOrg != null) {
                for (int i = 0; i < mainOrgs.length; ++i) {
                    if (!((StorageOrgUnitInfo)currentMainOrg).getId().toString().equals(((StorageOrgUnitInfo)mainOrgs[i]).getId().toString())) continue;
                    storageOrgUnit = (StorageOrgUnitInfo)currentMainOrg;
                    break;
                }
            }
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        billInfo.setCreator(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
        billInfo.setStorageOrgUnit(storageOrgUnit);
        if (storageOrgUnit != null && (col = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(storageOrgUnit.getId().toString(), 4, 0)) != null && col.size() > 0) {
            OrgUnitInfo info = col.get(0);
            billInfo.setBizDepartment((AdminOrgUnitInfo)info);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Timestamp curDate = new Timestamp(cal.getTimeInMillis());
        billInfo.setBeginDate(curDate);
        billInfo.setEndDate(curDate);
        billInfo.setBizDate(curDate);
        billInfo.setCreateTime(curDate);
        return billInfo;
    }

    private void createUnitTimeQtyMap(ProductLinePAllotDefInfo productLinePAllotDefInfo) throws BOSException, EASBizException {
        if (productLinePAllotDefInfo != null) {
            this.unitTimeQtyMap = new HashMap();
            ProductLinePAllotDefEntryCollection allotDefEntryCol = productLinePAllotDefInfo.getEntrys();
            if (allotDefEntryCol != null && allotDefEntryCol.size() > 0) {
                for (int i = 0; i < allotDefEntryCol.size(); ++i) {
                    ProductLinePAllotDefEntryInfo allotDefEntry = allotDefEntryCol.get(i);
                    String materialID = allotDefEntry.getMaterial().getId().toString();
                    ProductLinePAllotDefEntryRuleEntryCollection allotDefRuleEntryCol = allotDefEntry.getRuleEntrys();
                    if (allotDefRuleEntryCol != null && allotDefRuleEntryCol.size() > 0) {
                        for (int j = 0; j < allotDefRuleEntryCol.size(); ++j) {
                            ProductLinePAllotDefEntryRuleEntryInfo allotDefRuleEntry = allotDefRuleEntryCol.get(j);
                            String productLineID = allotDefRuleEntry.getProductLine().getId().toString();
                            double unitTimeQty = allotDefRuleEntry.getProductBatch().doubleValue() / allotDefRuleEntry.getBatchTime().doubleValue();
                            if (allotDefRuleEntry.getBatchTimeUnit().equals((Object)TimeUnitEnum.MINUTE)) {
                                unitTimeQty *= 60.0;
                            }
                            String key = materialID + "@" + productLineID;
                            this.unitTimeQtyMap.put(key, new BigDecimal(unitTimeQty));
                        }
                        continue;
                    }
                    throw new SchedulingException(SchedulingException.NOALLOTDEFENTRY, new Object[]{productLinePAllotDefInfo.getName()});
                }
            }
        }
    }

    private LineSchedulingModelInfo getLineSchedulingModel(Context ctx, StorageOrgUnitInfo storageOrgUnit, boolean isCreateUnitTimeQtyMap) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnit.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("priorityModel.id"));
        selectorItemCollection.add(new SelectorItemInfo("priorityModel.number"));
        selectorItemCollection.add(new SelectorItemInfo("priorityModel.name"));
        selectorItemCollection.add(new SelectorItemInfo("priorityModel.description"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.id"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.number"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.name"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.entrys.*"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.entrys.material.number"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.entrys.material.name"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.entrys.ruleEntrys.*"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.entrys.ruleEntrys.productLine.*"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.entrys.ruleEntrys.productLine.unit.*"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.entrys.ruleEntrys.productLine.workshop.number"));
        selectorItemCollection.add(new SelectorItemInfo("productLineAllocate.entrys.ruleEntrys.productLine.workshop.name"));
        entityViewInfo.setSelector(selectorItemCollection);
        LineSchedulingModelCollection lineSchedulingModelCollection = LineSchedulingModelFactory.getLocalInstance((Context)ctx).getLineSchedulingModelCollection(entityViewInfo);
        if (lineSchedulingModelCollection != null && lineSchedulingModelCollection.size() > 0) {
            if (isCreateUnitTimeQtyMap) {
                this.createUnitTimeQtyMap(lineSchedulingModelCollection.get(0).getProductLineAllocate());
            }
            return lineSchedulingModelCollection.get(0);
        }
        throw new SchedulingException(SchedulingException.NOMODEL, new Object[]{storageOrgUnit.getName()});
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductionLineSchedulingInfo oldPLS;
        ProductionLineSchedulingInfo pLSInfo = (ProductionLineSchedulingInfo)model;
        PreparedStatement batchStatement = null;
        Connection conn = null;
        try {
            if (this.isAddNew(ctx, (IObjectValue)pLSInfo)) {
                String fid = pLSInfo.getId().toString();
                String creatorID = ctx.getCaller().toString();
                String saveBotpSql = "insert into t_bot_relation (FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values (newbosid('59302EC6'),?,'6B821276',?,?,now(),?,1,null,0)";
                PlanOrderEntryCollection entryCollection = pLSInfo.getPlanOrderEntry();
                conn = EJBFactory.getConnection((Context)ctx);
                batchStatement = conn.prepareStatement(saveBotpSql);
                for (int i = 0; i < entryCollection.size(); ++i) {
                    PlanOrderEntryInfo info = entryCollection.get(i);
                    if (info.getSrcType().equals((Object)SrcTypeEnum.PLANORDER)) {
                        batchStatement.setString(1, "B844D41F");
                    } else {
                        if (!info.getSrcType().equals((Object)SrcTypeEnum.REQPLAN)) continue;
                        batchStatement.setString(1, "D86AF5B7");
                    }
                    batchStatement.setString(2, info.getSourceBillId());
                    batchStatement.setString(3, fid.toString());
                    batchStatement.setString(4, creatorID);
                    batchStatement.addBatch();
                }
                batchStatement.executeBatch();
                PLSEntryCollection pLSEntryCol = pLSInfo.getPLSEntry();
                HashMap wbQtyMap = new HashMap();
                HashMap<String, BigDecimal> hMap_PO = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> hMap_REQ = new HashMap<String, BigDecimal>();
                int n = pLSEntryCol.size();
                for (int i = 0; i < n; ++i) {
                    BigDecimal tempQty;
                    PLSEntryInfo pLSEntry = pLSEntryCol.get(i);
                    if (pLSEntry.isIsSubPlan()) continue;
                    int srcType = pLSEntry.getSrcType().getValue();
                    BigDecimal qty = pLSEntry.getQty();
                    String sourceBillId = pLSEntry.getSourceBillId();
                    if (20 == srcType) {
                        if (hMap_PO.containsKey(sourceBillId)) {
                            tempQty = (BigDecimal)hMap_PO.get(sourceBillId);
                            hMap_PO.put(sourceBillId, tempQty.add(qty));
                            continue;
                        }
                        hMap_PO.put(sourceBillId, qty);
                        continue;
                    }
                    if (30 != srcType) continue;
                    if (hMap_REQ.containsKey(sourceBillId)) {
                        tempQty = (BigDecimal)hMap_REQ.get(sourceBillId);
                        hMap_REQ.put(sourceBillId, tempQty.add(qty));
                        continue;
                    }
                    hMap_REQ.put(sourceBillId, qty);
                }
                if (hMap_PO != null && hMap_PO.size() > 0) {
                    wbQtyMap.put("po", hMap_PO);
                }
                if (hMap_REQ != null && hMap_REQ.size() > 0) {
                    wbQtyMap.put("req", hMap_REQ);
                }
                this._batchWriteBackBySchedule(ctx, wbQtyMap);
            } else {
                oldPLS = ProductionLineSchedulingFactory.getLocalInstance(ctx).getProductionLineSchedulingInfo((IObjectPK)new ObjectUuidPK(pLSInfo.getId()));
                HashMap<String, EntryBaseStatusEnum> map = new HashMap<String, EntryBaseStatusEnum>();
                PLSEntryCollection col = oldPLS.getPLSEntry();
                HashMap wbQtyMap = new HashMap();
                HashMap<String, BigDecimal> hMap_PO = new HashMap<String, BigDecimal>();
                HashMap<String, BigDecimal> hMap_REQ = new HashMap<String, BigDecimal>();
                int n = col.size();
                for (int i = 0; i < n; ++i) {
                    BigDecimal tempQty;
                    PLSEntryInfo pLSEntry = col.get(i);
                    if (pLSEntry.getBaseStatus().equals((Object)EntryBaseStatusEnum.PUTIN) || pLSEntry.getBaseStatus().equals((Object)EntryBaseStatusEnum.FINISH) || pLSEntry.getBaseStatus().equals((Object)EntryBaseStatusEnum.DELETED)) {
                        map.put(pLSEntry.getId().toString(), pLSEntry.getBaseStatus());
                    }
                    if (pLSEntry.isIsSubPlan()) continue;
                    int srcType = pLSEntry.getSrcType().getValue();
                    BigDecimal qty = pLSEntry.getQty();
                    String sourceBillId = pLSEntry.getSourceBillId();
                    if (20 == srcType) {
                        if (hMap_PO.containsKey(sourceBillId)) {
                            tempQty = (BigDecimal)hMap_PO.get(sourceBillId);
                            hMap_PO.put(sourceBillId, tempQty.add(qty.multiply(this.MINUONE)));
                            continue;
                        }
                        hMap_PO.put(sourceBillId, qty.multiply(this.MINUONE));
                        continue;
                    }
                    if (30 != srcType) continue;
                    if (hMap_REQ.containsKey(sourceBillId)) {
                        tempQty = (BigDecimal)hMap_REQ.get(sourceBillId);
                        hMap_REQ.put(sourceBillId, tempQty.add(qty.multiply(this.MINUONE)));
                        continue;
                    }
                    hMap_REQ.put(sourceBillId, qty.multiply(this.MINUONE));
                }
                boolean isChanged = false;
                UserInfo currUser = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
                Timestamp currTime = new Timestamp(new Date().getTime());
                PLSEntryCollection pLSEntryCol = pLSInfo.getPLSEntry();
                int n2 = pLSEntryCol.size();
                for (int i = 0; i < n2; ++i) {
                    BigDecimal tempQty;
                    PLSEntryInfo pLSEntry = pLSEntryCol.get(i);
                    pLSEntry.setLastUpdateUser(currUser);
                    pLSEntry.setLastUpdateTime(currTime);
                    String key = pLSEntry.getId().toString();
                    if (map.containsKey(key)) {
                        EntryBaseStatusEnum baseStatus = (EntryBaseStatusEnum)map.get(key);
                        if (!pLSEntry.getBaseStatus().equals((Object)baseStatus)) {
                            pLSEntry.setBaseStatus(baseStatus);
                            if (!isChanged) {
                                isChanged = true;
                            }
                        }
                    }
                    if (pLSEntry.isIsSubPlan()) continue;
                    int srcType = pLSEntry.getSrcType().getValue();
                    BigDecimal qty = pLSEntry.getQty();
                    String sourceBillId = pLSEntry.getSourceBillId();
                    if (20 == srcType) {
                        if (hMap_PO.containsKey(sourceBillId)) {
                            tempQty = (BigDecimal)hMap_PO.get(sourceBillId);
                            hMap_PO.put(sourceBillId, tempQty.add(qty));
                            continue;
                        }
                        hMap_PO.put(sourceBillId, qty);
                        continue;
                    }
                    if (30 != srcType) continue;
                    if (hMap_REQ.containsKey(sourceBillId)) {
                        tempQty = (BigDecimal)hMap_REQ.get(sourceBillId);
                        hMap_REQ.put(sourceBillId, tempQty.add(qty));
                        continue;
                    }
                    hMap_REQ.put(sourceBillId, qty);
                }
                if (hMap_PO != null && hMap_PO.size() > 0) {
                    wbQtyMap.put("po", hMap_PO);
                }
                if (hMap_REQ != null && hMap_REQ.size() > 0) {
                    wbQtyMap.put("req", hMap_REQ);
                }
                this._batchWriteBackBySchedule(ctx, wbQtyMap);
                if (isChanged) {
                    boolean isClosed = true;
                    PLSEntryCollection coll = pLSInfo.getPLSEntry();
                    int n3 = coll.size();
                    for (int i = 0; i < n3; ++i) {
                        PLSEntryInfo pLSEntry = pLSEntryCol.get(i);
                        if (pLSEntry.getBaseStatus().equals((Object)EntryBaseStatusEnum.FINISH) || pLSEntry.getBaseStatus().equals((Object)EntryBaseStatusEnum.DELETED)) continue;
                        isClosed = false;
                        break;
                    }
                    if (isClosed) {
                        pLSInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
                    } else {
                        pLSInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                    }
                }
            }
            oldPLS = super._submit(ctx, (IObjectValue)pLSInfo);
        }
        catch (BOSException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        return oldPLS;
    }

    @Override
    protected String _genProductionOrder(Context ctx, String orgID, Set idSet) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnitInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("parent.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("parent.storageOrgUnit.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("material.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("unit.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("baseUnit.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("productLine.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("parent.pLSModel.*"));
        PLSEntryCollection col = PLSEntryFactory.getLocalInstance(ctx).getPLSEntryCollection(entityViewInfo);
        ArrayList<PLSEntryInfo> pLSEntryList = new ArrayList<PLSEntryInfo>();
        String voucherId = null;
        PLSModelInfo pLSModelInfo = null;
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            PLSEntryInfo plsEntryInfo = col.get(i);
            pLSEntryList.add(plsEntryInfo);
            if (voucherId == null) {
                voucherId = plsEntryInfo.getParent().getId().toString();
            }
            if (pLSModelInfo != null) continue;
            pLSModelInfo = plsEntryInfo.getParent().getPLSModel();
        }
        PLSRunFacadeControllerBean plsf = new PLSRunFacadeControllerBean();
        RunResult runResult = plsf._genProductionOrder(ctx, (IObjectValue)storageOrgUnitInfo, pLSEntryList, voucherId, pLSModelInfo);
        if (runResult.hasException()) {
            return runResult.getExceptions();
        }
        return null;
    }

    @Override
    protected void _batchWriteBackBySchedule(Context ctx, Map wbQtyMap) throws BOSException, EASBizException {
        Map hMap_PO = new HashMap();
        Map hMap_REQ = new HashMap();
        if (wbQtyMap != null && wbQtyMap.size() > 0) {
            hMap_PO = (Map)wbQtyMap.get("po");
            hMap_REQ = (Map)wbQtyMap.get("req");
            if (hMap_PO != null && hMap_PO.size() > 0) {
                PlannedOrderFactory.getLocalInstance(ctx).batchWriteBackBySchedule(hMap_PO);
            }
            if (hMap_REQ != null && hMap_REQ.size() > 0) {
                this.batchWriteBackFromReqPlan(ctx, hMap_REQ);
            }
        }
    }

    private void batchWriteBackFromReqPlan(Context ctx, Map haspMap) throws BOSException, EASBizException {
        String sql = "";
        sql = "Update t_mm_requirementplan set fscheduledqty = isnull(fscheduledqty,0) + ? where FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        int iCount = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            for (String sFID : haspMap.keySet()) {
                BigDecimal scheduledQty = (BigDecimal)haspMap.get(sFID);
                stmt.setBigDecimal(1, scheduledQty);
                stmt.setString(2, sFID);
                stmt.addBatch();
                if (++iCount != 100) continue;
                iCount = 0;
                stmt.executeBatch();
            }
            if (iCount > 0) {
                stmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProductionLineSchedulingInfo info = (ProductionLineSchedulingInfo)this.getValue(ctx, pk);
        PLSEntryCollection plsCol = info.getPLSEntry();
        HashMap wbQtyMap = new HashMap();
        HashMap<String, BigDecimal> hMap_PO = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> hMap_REQ = new HashMap<String, BigDecimal>();
        int n = plsCol.size();
        for (int i = 0; i < n; ++i) {
            BigDecimal tempQty;
            PLSEntryInfo plsInfo = plsCol.get(i);
            if (plsInfo.isIsSubPlan()) continue;
            int srcType = plsInfo.getSrcType().getValue();
            BigDecimal qty = plsInfo.getQty();
            String sourceBillId = plsInfo.getSourceBillId();
            if (20 == srcType) {
                if (hMap_PO.containsKey(sourceBillId)) {
                    tempQty = (BigDecimal)hMap_PO.get(sourceBillId);
                    hMap_PO.put(sourceBillId, tempQty.add(qty.multiply(this.MINUONE)));
                    continue;
                }
                hMap_PO.put(sourceBillId, qty.multiply(this.MINUONE));
                continue;
            }
            if (30 != srcType) continue;
            if (hMap_REQ.containsKey(sourceBillId)) {
                tempQty = (BigDecimal)hMap_REQ.get(sourceBillId);
                hMap_REQ.put(sourceBillId, tempQty.add(qty.multiply(this.MINUONE)));
                continue;
            }
            hMap_REQ.put(sourceBillId, qty.multiply(this.MINUONE));
        }
        if (hMap_PO != null && hMap_PO.size() > 0) {
            wbQtyMap.put("po", hMap_PO);
        }
        if (hMap_REQ != null && hMap_REQ.size() > 0) {
            wbQtyMap.put("req", hMap_REQ);
        }
        this._batchWriteBackBySchedule(ctx, wbQtyMap);
        super._deleteNoCheck(ctx, pk);
    }

    protected Map _getFinishQty(Context ctx, List idList) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> finishQtyMap = new HashMap<String, BigDecimal>();
        String strIDs = StringUtils.arrayToString((Object[])idList.toArray(), (String)"','");
        String sql = "select t.fsourcebillentryid,t.fcommittotalqty from t_mm_productionorder t where t.fsourcebillentryid in ('" + strIDs + "')";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rows.next()) {
                String id = rows.getString("fsourcebillentryid");
                BigDecimal qty = rows.getBigDecimal("fcommittotalqty");
                finishQtyMap.put(id, qty);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return finishQtyMap;
    }

    protected Map getPlannedOrderInfo(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, PlannedOrderInfo> plannedOrderMap = new HashMap<String, PlannedOrderInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        PlannedOrderCollection plannedOrders = PlannedOrderFactory.getLocalInstance(ctx).getPlannedOrderCollection(entityViewInfo);
        int n = plannedOrders.size();
        for (int i = 0; i < n; ++i) {
            PlannedOrderInfo plannedOrder = plannedOrders.get(i);
            plannedOrderMap.put(plannedOrder.getId().toString(), plannedOrder);
        }
        return plannedOrderMap;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        PLSEntryCollection pLSEntryCollection;
        String id;
        SCMBillEntryBaseInfo info;
        int i;
        int n;
        PlanOrderEntryCollection planOrderEntryCollection;
        ProductionLineSchedulingInfo plsInfo = (ProductionLineSchedulingInfo)super._getValue(ctx, pk, selector);
        boolean isLoadScheduledQty = false;
        boolean isLoadEndQty = false;
        if (selector != null && selector.size() > 0) {
            int n2 = selector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                SelectorItemInfo selectorItemInfo = selector.get(i2);
                if (!isLoadScheduledQty && "planOrderEntry.*".equals(selectorItemInfo.getPropertyName())) {
                    isLoadScheduledQty = true;
                }
                if (!isLoadEndQty && "pLSEntry.*".equals(selectorItemInfo.getPropertyName())) {
                    isLoadEndQty = true;
                }
                if (isLoadScheduledQty && isLoadEndQty) break;
            }
        }
        if (isLoadScheduledQty && (planOrderEntryCollection = plsInfo.getPlanOrderEntry()) != null && planOrderEntryCollection.size() > 0) {
            Map plannedOrders;
            HashSet<String> idSet = new HashSet<String>();
            n = planOrderEntryCollection.size();
            for (int i3 = 0; i3 < n; ++i3) {
                PlanOrderEntryInfo info2 = planOrderEntryCollection.get(i3);
                if (!info2.getSrcType().equals((Object)SrcTypeEnum.PLANORDER)) continue;
                idSet.add(info2.getSourceBillId());
            }
            if (idSet.size() > 0 && (plannedOrders = this.getPlannedOrderInfo(ctx, idSet)) != null && plannedOrders.size() > 0) {
                int n3 = planOrderEntryCollection.size();
                for (i = 0; i < n3; ++i) {
                    info = planOrderEntryCollection.get(i);
                    id = info.getSourceBillId();
                    if (!info.getSrcType().equals((Object)SrcTypeEnum.PLANORDER) || !plannedOrders.containsKey(id)) continue;
                    PlannedOrderInfo plannedOrder = (PlannedOrderInfo)plannedOrders.get(id);
                    info.setQty(plannedOrder.getQty());
                    info.setSchedulingQty(plannedOrder.getScheduleQty());
                    info.setNoSchedulingQty(plannedOrder.getQty().subtract(plannedOrder.getScheduleQty()));
                    info.setBeginDate(new Timestamp(plannedOrder.getStartDate().getTime()));
                    info.setEndDate(new Timestamp(plannedOrder.getEndDate().getTime()));
                }
            }
        }
        if (isLoadEndQty && (pLSEntryCollection = plsInfo.getPLSEntry()) != null && pLSEntryCollection.size() > 0) {
            Map finishQtyMap;
            ArrayList<String> idList = new ArrayList<String>();
            n = pLSEntryCollection.size();
            for (int i4 = 0; i4 < n; ++i4) {
                PLSEntryInfo info3 = pLSEntryCollection.get(i4);
                if (!info3.getBaseStatus().equals((Object)EntryBaseStatusEnum.PUTIN) && !info3.getBaseStatus().equals((Object)EntryBaseStatusEnum.FINISH)) continue;
                idList.add(info3.getId().toString());
            }
            if (idList.size() > 0 && (finishQtyMap = this._getFinishQty(ctx, idList)) != null && finishQtyMap.size() > 0) {
                int n4 = pLSEntryCollection.size();
                for (i = 0; i < n4; ++i) {
                    Object o;
                    info = pLSEntryCollection.get(i);
                    id = info.getId().toString();
                    if (!finishQtyMap.containsKey(id) || (o = finishQtyMap.get(id)) == null || !(o instanceof BigDecimal)) continue;
                    info.setEndQty((BigDecimal)o);
                }
            }
        }
        return plsInfo;
    }

    @Override
    protected Map _plcCapAnalyze(Context ctx, Map paramMap) throws BOSException, EASBizException {
        double cap;
        double unitTimeCap;
        Set keySet;
        ProductLineInfo productLine;
        String voucherID;
        this.currVoucherID = voucherID = (String)paramMap.get("voucherID");
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)paramMap.get("storageOrgUnit");
        Timestamp beginDate = (Timestamp)paramMap.get("beginDate");
        Timestamp endDate = (Timestamp)paramMap.get("endDate");
        if (beginDate != null) {
            beginDate = PLSUtil.setDateTime(beginDate, 0);
        }
        if (endDate != null) {
            endDate = PLSUtil.setDateTime(endDate, 1);
        }
        Set productLines = (Set)paramMap.get("productLines");
        String ids = StringUtils.arrayToString((Object[])productLines.toArray(), (String)"','");
        List pLCList = (List)paramMap.get("pLCList");
        CapUnitEnum capUnit = (CapUnitEnum)((Object)paramMap.get("capUnit"));
        HashMap<String, BigDecimal> capMap = new HashMap<String, BigDecimal>();
        HashMap<String, ProductLineInfo> lineMap = new HashMap<String, ProductLineInfo>();
        HashMap<String, ProductLineInfo> lineMap_classCap = new HashMap<String, ProductLineInfo>();
        HashMap<String, ProductLineInfo> lineMap_dayYield = new HashMap<String, ProductLineInfo>();
        if (productLines != null && productLines.size() > 0) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)productLines, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("*"));
            selectorItemCollection.add(new SelectorItemInfo("unit.*"));
            selectorItemCollection.add(new SelectorItemInfo("workshop.id"));
            selectorItemCollection.add(new SelectorItemInfo("workshop.name"));
            entityViewInfo.setSelector(selectorItemCollection);
            ProductLineCollection lineCol = ProductLineFactory.getLocalInstance((Context)ctx).getProductLineCollection(entityViewInfo);
            if (lineCol != null && lineCol.size() > 0) {
                int n = lineCol.size();
                for (int i = 0; i < n; ++i) {
                    productLine = lineCol.get(i);
                    lineMap.put(productLine.getId().toString(), productLine);
                    if (PLSTypeEnum.DAYABILITY.equals((Object)productLine.getScheduleType())) {
                        lineMap_dayYield.put(productLine.getId().toString(), productLine);
                        continue;
                    }
                    lineMap_classCap.put(productLine.getId().toString(), productLine);
                }
            }
        }
        Map dayYieldMap = new HashMap();
        if (lineMap_dayYield != null && lineMap_dayYield.size() > 0) {
            Set idSet = lineMap_dayYield.keySet();
            String strIDs = StringUtils.arrayToString((Object[])idSet.toArray(), (String)"','");
            dayYieldMap = this.getSumDayCap(ctx, strIDs, storageOrgUnit.getId().toString(), beginDate, endDate);
        }
        Map classCapMap = new HashMap();
        if (lineMap_classCap != null && lineMap_classCap.size() > 0) {
            Set idSet = lineMap_classCap.keySet();
            String strIDs = StringUtils.arrayToString((Object[])idSet.toArray(), (String)"','");
            classCapMap = this.getSumClassCap(ctx, strIDs, storageOrgUnit.getId().toString(), beginDate, endDate);
        }
        if (capUnit.equals((Object)CapUnitEnum.HOUR)) {
            if (dayYieldMap != null && dayYieldMap.size() > 0) {
                keySet = dayYieldMap.keySet();
                for (String key : keySet) {
                    BigDecimal dayYield = (BigDecimal)dayYieldMap.get(key);
                    productLine = (ProductLineInfo)lineMap_dayYield.get(key);
                    unitTimeCap = this.getUnitTimeCap(productLine);
                    cap = dayYield.doubleValue() / unitTimeCap;
                    capMap.put(productLine.getId().toString(), new BigDecimal(cap));
                }
            }
            if (classCapMap != null && classCapMap.size() > 0) {
                keySet = classCapMap.keySet();
                for (String key : keySet) {
                    BigDecimal cap2 = (BigDecimal)classCapMap.get(key);
                    capMap.put(key, cap2);
                }
            }
        } else {
            if (dayYieldMap != null && dayYieldMap.size() > 0) {
                keySet = dayYieldMap.keySet();
                for (String key : keySet) {
                    BigDecimal cap3 = (BigDecimal)dayYieldMap.get(key);
                    capMap.put(key, cap3);
                }
            }
            if (classCapMap != null && classCapMap.size() > 0) {
                keySet = classCapMap.keySet();
                for (String key : keySet) {
                    BigDecimal hourCap = (BigDecimal)classCapMap.get(key);
                    productLine = (ProductLineInfo)lineMap_classCap.get(key);
                    unitTimeCap = this.getUnitTimeCap(productLine);
                    cap = hourCap.doubleValue() * unitTimeCap;
                    capMap.put(productLine.getId().toString(), new BigDecimal(cap));
                }
            }
        }
        if (this.lineSchedulingModelInfo == null) {
            this.lineSchedulingModelInfo = this.getLineSchedulingModel(ctx, storageOrgUnit, true);
        }
        Map<ProductLineInfo, BigDecimal> qtyMap = new HashMap();
        for (int i = 0; i < pLCList.size(); ++i) {
            BigDecimal sumQty;
            PLChooseEntryInfo pLCInfo = (PLChooseEntryInfo)pLCList.get(i);
            MaterialInfo material = pLCInfo.getMaterial();
            String productLineID = pLCInfo.getProductLine().getId().toString();
            ProductLineInfo productLine2 = (ProductLineInfo)lineMap.get(productLineID);
            MeasureUnitInfo unit = pLCInfo.getUnit();
            BigDecimal qty = pLCInfo.getQty();
            double tempQty = qty.doubleValue();
            if (!productLine2.getUnit().getId().equals((Object)unit.getId())) {
                if (productLine2.getUnit().getMeasureUnitGroup().getId().equals((Object)unit.getMeasureUnitGroup().getId())) {
                    double beforeCoef = unit.getCoefficient().doubleValue();
                    double afterCoef = productLine2.getUnit().getCoefficient().doubleValue();
                    tempQty *= beforeCoef / afterCoef;
                } else {
                    String exceDesc = ResourceUtils.getMessageForServer((String)RES_SCHEDULING, (String)"Desc_CanNotChange");
                    int exceNum = 205;
                    StringBuffer info = new StringBuffer();
                    info.append(ResourceUtils.getMessageForServer((String)RES_SCHEDULING, (String)"Exception_CanNotChange", (String[])new String[]{productLine2.getName(), productLine2.getUnit().getName(), unit.getName()}));
                    String exceDetail = info.toString();
                    PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.currVoucherID);
                    PLSExectionMSGFactory.getRemoteInstance().addnew((CoreBaseInfo)exceInfo);
                }
            }
            if (capUnit.equals((Object)CapUnitEnum.HOUR)) {
                String key = material.getId().toString() + "@" + productLine2.getId().toString();
                if (this.unitTimeQtyMap != null && this.unitTimeQtyMap.size() > 0 && this.unitTimeQtyMap.containsKey(key)) {
                    BigDecimal unitTimeCap2 = (BigDecimal)this.unitTimeQtyMap.get(key);
                    tempQty /= unitTimeCap2.doubleValue();
                } else {
                    double unitTimeCap3 = this.getUnitTimeCap(productLine2);
                    tempQty /= unitTimeCap3;
                }
            }
            if (qtyMap.containsKey(productLine2)) {
                sumQty = (BigDecimal)qtyMap.get(productLine2);
                sumQty = sumQty.add(new BigDecimal(tempQty));
                qtyMap.put(productLine2, sumQty);
                continue;
            }
            sumQty = new BigDecimal(tempQty);
            qtyMap.put(productLine2, sumQty);
        }
        qtyMap = this.getPlanQtyForPLC(ctx, ids, storageOrgUnit.getId().toString(), beginDate, endDate, lineMap, qtyMap, capUnit);
        qtyMap = this.getReleasedQtyForPLC(ctx, ids, storageOrgUnit.getId().toString(), beginDate, endDate, lineMap, qtyMap, capUnit);
        HashMap<String, Map<String, BigDecimal>> returnMap = new HashMap<String, Map<String, BigDecimal>>();
        returnMap.put("capMap", capMap);
        returnMap.put("qtyMap", qtyMap);
        return returnMap;
    }

    private Map getPlanQtyForPLC(Context ctx, String strIDs, String storageOrgUnitID, Timestamp beginDate, Timestamp endDate, Map lineMap, Map qtyMap, CapUnitEnum capUnit) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select entrys.fmaterialid,entrys.fproductlineid,entrys.funitID,unit.fgroupID,unit.fcoefficient,sum(entrys.fqty) as fplanQty ");
        sqlBuffer.append("from t_mm_plsentry entrys inner join t_mm_productionlinescheduling head on head.fid = entrys.fparent inner join t_bd_measureunit unit on entrys.funitID = unit.fid ");
        sqlBuffer.append("where head.fstorageorgunitid = ? ");
        sqlBuffer.append("and entrys.fissubplan = 0 and (entrys.fbasestatus = 2 or entrys.fbasestatus = 4) ");
        sqlBuffer.append("and entrys.fproductlineid in ('" + strIDs + "') ");
        sqlBuffer.append("and entrys.fbeginDate >= ? ");
        sqlBuffer.append("and entrys.fbeginDate <= ? ");
        sqlBuffer.append("and head.fid <> ? ");
        sqlBuffer.append("group by entrys.fmaterialid,entrys.fproductlineid,entrys.funitID,unit.fgroupID,unit.fcoefficient");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{storageOrgUnitID, beginDate, endDate, this.currVoucherID});
        try {
            while (rowSet.next()) {
                String materialID = rowSet.getString("fmaterialid");
                String productLineID = rowSet.getString("fproductlineid");
                String unitID = rowSet.getString("funitID");
                String fgroupID = rowSet.getString("fgroupID");
                BigDecimal coefficient = rowSet.getBigDecimal("fcoefficient");
                BigDecimal planQty = rowSet.getBigDecimal("fplanQty");
                ProductLineInfo productLine = (ProductLineInfo)lineMap.get(productLineID);
                planQty = this.changeHourCap(ctx, productLine, materialID, unitID, fgroupID, coefficient, planQty, capUnit);
                if (qtyMap.containsKey(productLine)) {
                    BigDecimal tempQty = (BigDecimal)qtyMap.get(productLine);
                    tempQty = tempQty.add(planQty);
                    qtyMap.put(productLine, tempQty);
                    continue;
                }
                qtyMap.put(productLine, planQty);
            }
            return qtyMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map getReleasedQtyForPLC(Context ctx, String strIDs, String storageOrgUnitID, Timestamp beginDate, Timestamp endDate, Map lineMap, Map qtyMap, CapUnitEnum capUnit) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select head.fmaterialid,head.fproductlineid,head.funitID,unit.fgroupID,unit.fcoefficient,sum(head.fqty) as freleasedqty ");
        sqlBuffer.append("from t_mm_productionorder head inner join t_bd_measureunit unit on head.funitID = unit.fid ");
        sqlBuffer.append("where head.fstorageorgunitid = ? and head.fproductlineid in ('" + strIDs + "') ");
        sqlBuffer.append("and ((head.fsourcebilltypeid = 'OC9YcwEhEADgAAApfwAAAUY+1VI=' and head.fbasestatus = 2) or head.fbasestatus = 4 or head.fbasestatus = 5) ");
        sqlBuffer.append("and head.fstartDate >= ? ");
        sqlBuffer.append("and head.fstartDate >= ? ");
        sqlBuffer.append("and head.FSourceBillID <> ? ");
        sqlBuffer.append("group by head.fmaterialid,head.fproductlineid,head.funitID,unit.fgroupID,unit.fcoefficient");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{storageOrgUnitID, beginDate, endDate, this.currVoucherID});
        try {
            while (rowSet.next()) {
                String materialID = rowSet.getString("fmaterialid");
                String productLineID = rowSet.getString("fproductlineid");
                String unitID = rowSet.getString("funitID");
                String groupID = rowSet.getString("fgroupID");
                BigDecimal coefficient = rowSet.getBigDecimal("fcoefficient");
                BigDecimal releasedQty = rowSet.getBigDecimal("freleasedqty");
                ProductLineInfo productLine = (ProductLineInfo)lineMap.get(productLineID);
                releasedQty = this.changeHourCap(ctx, productLine, materialID, unitID, groupID, coefficient, releasedQty, capUnit);
                if (qtyMap.containsKey(productLine)) {
                    BigDecimal tempQty = (BigDecimal)qtyMap.get(productLine);
                    tempQty = tempQty.add(releasedQty);
                    qtyMap.put(productLine, tempQty);
                    continue;
                }
                qtyMap.put(productLine, releasedQty);
            }
            return qtyMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private double getUnitTimeCap(ProductLineInfo productLine) throws BOSException, EASBizException {
        BigDecimal productBatch = productLine.getProductBatch();
        BigDecimal batchTime = productLine.getBatchTime();
        TimeUnitEnum batchTimeUnit = productLine.getBatchTimeUnit();
        double unitTimeCap = productBatch.doubleValue() / batchTime.doubleValue();
        if (batchTimeUnit.equals((Object)TimeUnitEnum.MINUTE)) {
            unitTimeCap *= 60.0;
        }
        return unitTimeCap;
    }

    private Map getSumDayCap(Context ctx, String strIDs, String storageOrgUnitID, Timestamp beginDate, Timestamp endDate) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select t.fproductlineid,sum(t.fdayyield) as sumCap from T_MM_ProductLineDayYield t ");
        sqlBuffer.append("where t.fworkday = 1 and t.fstorageorgunitid = ? ");
        sqlBuffer.append("and t.fproductlineid in ('" + strIDs + "') ");
        sqlBuffer.append("and t.fworkdate >= ? ");
        sqlBuffer.append("and t.fworkdate <= ? ");
        sqlBuffer.append("group by t.fproductlineid ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{storageOrgUnitID, beginDate, endDate});
        try {
            while (rowSet.next()) {
                String productLineID = rowSet.getString("fproductlineid");
                BigDecimal sumCap = rowSet.getBigDecimal("sumCap");
                if (map.containsKey(productLineID)) continue;
                map.put(productLineID, sumCap);
            }
            this.writeNoCapExceptionInfo(ctx, strIDs, map, beginDate, endDate, true);
            return map;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map getSumClassCap(Context ctx, String strIDs, String storageOrgUnitID, Timestamp beginDate, Timestamp endDate) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select entrys.fproductlineid,sum(entrys.fability) as sumCap ");
        sqlBuffer.append("from t_mm_equipmentcalendar head left join t_mm_equipmentcalendarentry entrys on entrys.fparentid = head.fid ");
        sqlBuffer.append("where head.fworkday = 1 and entrys.fability>0 and head.fstorageorgunitid = ? ");
        sqlBuffer.append("and entrys.fproductlineid in ('" + strIDs + "') ");
        sqlBuffer.append("and head.fworkdate >= ? ");
        sqlBuffer.append("and head.fworkdate <= ? ");
        sqlBuffer.append("group by entrys.fproductlineid ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{storageOrgUnitID, beginDate, endDate});
        try {
            while (rowSet.next()) {
                String productLineID = rowSet.getString("fproductlineid");
                BigDecimal sumCap = rowSet.getBigDecimal("sumCap");
                if (map.containsKey(productLineID)) continue;
                map.put(productLineID, sumCap);
            }
            this.writeNoCapExceptionInfo(ctx, strIDs, map, beginDate, endDate, false);
            return map;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _plsCapAnalyze(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ProductLineInfo productLine;
        String voucherID;
        HashMap<String, Cloneable> returnMap = new HashMap<String, Cloneable>();
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)paramMap.get("storageOrgUnit");
        this.currVoucherID = voucherID = (String)paramMap.get("voucherID");
        Timestamp beginDate = (Timestamp)paramMap.get("beginDate");
        Timestamp endDate = (Timestamp)paramMap.get("endDate");
        if (beginDate != null) {
            beginDate = PLSUtil.setDateTime(beginDate, 0);
        }
        if (endDate != null) {
            endDate = PLSUtil.setDateTime(endDate, 1);
        }
        Set workShops = (Set)paramMap.get("workShops");
        Set productLines = (Set)paramMap.get("productLines");
        List pLSList = (List)paramMap.get("pLSList");
        HashMap<String, ProductLineInfo> lineMap = new HashMap<String, ProductLineInfo>();
        HashMap qtyMap = new HashMap();
        HashSet<String> dateSet = new HashSet<String>();
        HashSet<ProductLineInfo> lineSet = new HashSet<ProductLineInfo>();
        if (productLines != null && productLines.size() > 0) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)productLines, CompareType.INCLUDE));
            if (workShops != null && workShops.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("workshop.id", (Object)workShops, CompareType.INCLUDE));
            }
            entityViewInfo.setFilter(filterInfo);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("*"));
            selectorItemCollection.add(new SelectorItemInfo("unit.*"));
            selectorItemCollection.add(new SelectorItemInfo("workshop.id"));
            selectorItemCollection.add(new SelectorItemInfo("workshop.name"));
            entityViewInfo.setSelector(selectorItemCollection);
            ProductLineCollection lineCol = ProductLineFactory.getLocalInstance((Context)ctx).getProductLineCollection(entityViewInfo);
            if (lineCol != null && lineCol.size() > 0) {
                int n = lineCol.size();
                for (int i = 0; i < n; ++i) {
                    productLine = lineCol.get(i);
                    lineMap.put(productLine.getId().toString(), productLine);
                }
            }
        }
        if (this.lineSchedulingModelInfo == null) {
            this.lineSchedulingModelInfo = this.getLineSchedulingModel(ctx, storageOrgUnit, true);
        }
        Map capMap = this.getHourCapMap(ctx, paramMap);
        String strIDs = StringUtils.arrayToString((Object[])lineMap.keySet().toArray(), (String)"','");
        HashMap<String, Map<String, BigDecimal>> planQtyMap = this.getPlanQtyForPLS(ctx, strIDs, storageOrgUnit.getId().toString(), beginDate, endDate, lineMap);
        if (pLSList != null && pLSList.size() > 0) {
            if (planQtyMap == null) {
                planQtyMap = new HashMap<String, Map<String, BigDecimal>>();
            }
            int n = pLSList.size();
            for (int i = 0; i < n; ++i) {
                Map<String, BigDecimal> tempMap;
                PLSEntryInfo pLSInfo = (PLSEntryInfo)pLSList.get(i);
                if (!pLSInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.SUBMITED) && !pLSInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) continue;
                productLine = pLSInfo.getProductLine();
                String productLineID = productLine.getId().toString();
                String materialID = pLSInfo.getMaterial().getId().toString();
                String unitID = pLSInfo.getUnit().getId().toString();
                String groupID = pLSInfo.getUnit().getMeasureUnitGroup().getId().toString();
                BigDecimal coefficient = pLSInfo.getUnit().getCoefficient();
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                String strWorkDate = sf.format(pLSInfo.getVarDate());
                BigDecimal planQty = pLSInfo.getQty();
                planQty = this.changeHourCap(ctx, productLine, materialID, unitID, groupID, coefficient, planQty, CapUnitEnum.HOUR);
                if (planQtyMap.containsKey(productLineID)) {
                    tempMap = (Map)planQtyMap.get(productLineID);
                    if (tempMap.containsKey(strWorkDate)) {
                        BigDecimal tempQty = (BigDecimal)tempMap.get(strWorkDate);
                        tempQty = tempQty.add(planQty);
                        tempMap.put(strWorkDate, tempQty);
                        planQtyMap.put(productLineID, tempMap);
                        continue;
                    }
                    tempMap.put(strWorkDate, planQty);
                    planQtyMap.put(productLineID, tempMap);
                    continue;
                }
                tempMap = new HashMap();
                tempMap.put(strWorkDate, planQty);
                planQtyMap.put(productLineID, tempMap);
            }
        }
        Map releasedQtyMap = this.getReleasedQtyForPLS(ctx, strIDs, storageOrgUnit.getId().toString(), beginDate, endDate, lineMap);
        if (lineMap != null && lineMap.size() > 0) {
            Set keySet = lineMap.keySet();
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            for (String key : keySet) {
                ProductLineInfo productLine2 = (ProductLineInfo)lineMap.get(key);
                HashMap<String, BigDecimal[]> tempMap = new HashMap<String, BigDecimal[]>();
                Timestamp currDate = beginDate;
                while (currDate.before(endDate)) {
                    BigDecimal[] datas;
                    Map map;
                    String strDate = sf.format(currDate);
                    if (capMap.containsKey(key) && (map = (Map)capMap.get(key)).containsKey(strDate)) {
                        BigDecimal cap = (BigDecimal)map.get(strDate);
                        if (tempMap.containsKey(strDate)) {
                            datas = (BigDecimal[])tempMap.get(strDate);
                            datas[0] = cap;
                            tempMap.put(strDate, datas);
                        } else {
                            datas = new BigDecimal[]{cap, this.ZERO, this.ZERO};
                            tempMap.put(strDate, datas);
                        }
                        dateSet.add(strDate);
                    }
                    if (planQtyMap.containsKey(key) && (map = (Map)planQtyMap.get(key)).containsKey(strDate)) {
                        BigDecimal planQty = (BigDecimal)map.get(strDate);
                        if (tempMap.containsKey(strDate)) {
                            datas = (BigDecimal[])tempMap.get(strDate);
                            datas[1] = planQty;
                            tempMap.put(strDate, datas);
                        } else {
                            datas = new BigDecimal[]{this.ZERO, planQty, this.ZERO};
                            tempMap.put(strDate, datas);
                        }
                        dateSet.add(strDate);
                    }
                    if (releasedQtyMap.containsKey(key) && (map = (Map)releasedQtyMap.get(key)).containsKey(strDate)) {
                        BigDecimal releasedQty = (BigDecimal)map.get(strDate);
                        if (tempMap.containsKey(strDate)) {
                            datas = (BigDecimal[])tempMap.get(strDate);
                            datas[2] = releasedQty;
                            tempMap.put(strDate, datas);
                        } else {
                            datas = new BigDecimal[]{this.ZERO, this.ZERO, releasedQty};
                            tempMap.put(strDate, datas);
                        }
                        dateSet.add(strDate);
                    }
                    currDate = new Timestamp(currDate.getTime() + 86400000L);
                }
                qtyMap.put(key, tempMap);
                lineSet.add(productLine2);
            }
            returnMap.put("qtyMap", qtyMap);
            returnMap.put("dateSet", dateSet);
            returnMap.put("lineSet", lineSet);
        }
        return returnMap;
    }

    private Map getPlanQtyForPLS(Context ctx, String strIDs, String storageOrgUnitID, Timestamp beginDate, Timestamp endDate, Map lineMap) throws BOSException, EASBizException {
        HashMap<String, Map<String, BigDecimal>> planQtyMap = new HashMap<String, Map<String, BigDecimal>>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select entrys.fmaterialid,entrys.fproductlineid,TO_CHAR(entrys.fbeginDate, 'YYYY-MM-DD') as fbeginDate,entrys.funitID,unit.fgroupID,unit.fcoefficient,sum(entrys.fqty) as fplanQty ");
        sqlBuffer.append("from t_mm_plsentry entrys inner join t_mm_productionlinescheduling head on head.fid = entrys.fparent inner join t_bd_measureunit unit on entrys.funitID = unit.fid ");
        sqlBuffer.append("where head.fstorageorgunitid = ? ");
        sqlBuffer.append("and entrys.fissubplan = 0 and (entrys.fbasestatus = 2 or entrys.fbasestatus = 4) ");
        sqlBuffer.append("and entrys.fproductlineid in ('" + strIDs + "') ");
        sqlBuffer.append("and entrys.fbeginDate >= ? ");
        sqlBuffer.append("and entrys.fbeginDate <= ? ");
        sqlBuffer.append("and head.fid <> ? ");
        sqlBuffer.append("group by entrys.fmaterialid,entrys.fproductlineid,TO_CHAR(entrys.fbeginDate, 'YYYY-MM-DD'),entrys.funitID,unit.fgroupID,unit.fcoefficient");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{storageOrgUnitID, beginDate, endDate, this.currVoucherID});
        try {
            while (rowSet.next()) {
                Map<String, BigDecimal> tempMap;
                String materialID = rowSet.getString("fmaterialid");
                String productLineID = rowSet.getString("fproductlineid");
                String strWorkDate = rowSet.getString("fbeginDate");
                String unitID = rowSet.getString("funitID");
                String fgroupID = rowSet.getString("fgroupID");
                BigDecimal coefficient = rowSet.getBigDecimal("fcoefficient");
                BigDecimal planQty = rowSet.getBigDecimal("fplanQty");
                ProductLineInfo productLine = (ProductLineInfo)lineMap.get(productLineID);
                planQty = this.changeHourCap(ctx, productLine, materialID, unitID, fgroupID, coefficient, planQty, CapUnitEnum.HOUR);
                if (planQtyMap.containsKey(productLineID)) {
                    tempMap = (Map)planQtyMap.get(productLineID);
                    if (tempMap.containsKey(strWorkDate)) {
                        BigDecimal tempQty = (BigDecimal)tempMap.get(strWorkDate);
                        tempQty = tempQty.add(planQty);
                        tempMap.put(strWorkDate, tempQty);
                        planQtyMap.put(productLineID, tempMap);
                        continue;
                    }
                    tempMap.put(strWorkDate, planQty);
                    planQtyMap.put(productLineID, tempMap);
                    continue;
                }
                tempMap = new HashMap();
                tempMap.put(strWorkDate, planQty);
                planQtyMap.put(productLineID, tempMap);
            }
            return planQtyMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map getReleasedQtyForPLS(Context ctx, String strIDs, String storageOrgUnitID, Timestamp beginDate, Timestamp endDate, Map lineMap) throws BOSException, EASBizException {
        HashMap<String, Map<String, BigDecimal>> map = new HashMap<String, Map<String, BigDecimal>>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select head.fmaterialid,head.fproductlineid,TO_CHAR(head.fstartDate, 'YYYY-MM-DD') as fbeginDate,head.funitID,unit.fgroupID,unit.fcoefficient,sum(head.fqty) as freleasedqty ");
        sqlBuffer.append("from t_mm_productionorder head inner join t_bd_measureunit unit on head.funitID = unit.fid ");
        sqlBuffer.append("where head.fstorageorgunitid = ? and head.fproductlineid in ('" + strIDs + "') ");
        sqlBuffer.append("and ((head.fsourcebilltypeid = 'OC9YcwEhEADgAAApfwAAAUY+1VI=' and head.fbasestatus = 2) or head.fbasestatus = 4 or head.fbasestatus = 5) ");
        sqlBuffer.append("and head.fstartDate >= ? ");
        sqlBuffer.append("and head.fstartDate <= ? ");
        sqlBuffer.append("group by head.fmaterialid,head.fproductlineid,TO_CHAR(head.fstartDate, 'YYYY-MM-DD'),head.funitID,unit.fgroupID,unit.fcoefficient");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{storageOrgUnitID, beginDate, endDate});
        try {
            while (rowSet.next()) {
                Map<String, BigDecimal> tempMap;
                String materialID = rowSet.getString("fmaterialid");
                String productLineID = rowSet.getString("fproductlineid");
                String strWorkDate = rowSet.getString("fbeginDate");
                String unitID = rowSet.getString("funitID");
                String groupID = rowSet.getString("fgroupID");
                BigDecimal coefficient = rowSet.getBigDecimal("fcoefficient");
                BigDecimal releasedQty = rowSet.getBigDecimal("freleasedqty");
                ProductLineInfo productLine = (ProductLineInfo)lineMap.get(productLineID);
                releasedQty = this.changeHourCap(ctx, productLine, materialID, unitID, groupID, coefficient, releasedQty, CapUnitEnum.HOUR);
                if (map.containsKey(productLineID)) {
                    tempMap = (Map)map.get(productLineID);
                    if (tempMap.containsKey(strWorkDate)) {
                        BigDecimal tempQty = (BigDecimal)tempMap.get(strWorkDate);
                        tempQty = tempQty.add(releasedQty);
                        tempMap.put(strWorkDate, tempQty);
                        map.put(productLineID, tempMap);
                        continue;
                    }
                    tempMap.put(strWorkDate, releasedQty);
                    map.put(productLineID, tempMap);
                    continue;
                }
                tempMap = new HashMap();
                tempMap.put(strWorkDate, releasedQty);
                map.put(productLineID, tempMap);
            }
            return map;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map getHourCapMap(Context ctx, Map paramMap) throws BOSException, EASBizException {
        Set dateKeys;
        Set keySet;
        HashMap<String, Map<String, BigDecimal>> returnMap = new HashMap<String, Map<String, BigDecimal>>();
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)paramMap.get("storageOrgUnit");
        Timestamp beginDate = (Timestamp)paramMap.get("beginDate");
        Timestamp endDate = (Timestamp)paramMap.get("endDate");
        if (beginDate != null) {
            beginDate = PLSUtil.setDateTime(beginDate, 0);
        }
        if (endDate != null) {
            endDate = PLSUtil.setDateTime(endDate, 1);
        }
        Set productLines = (Set)paramMap.get("productLines");
        HashMap<String, ProductLineInfo> lineMap_classCap = new HashMap<String, ProductLineInfo>();
        HashMap<String, ProductLineInfo> lineMap_dayYield = new HashMap<String, ProductLineInfo>();
        if (productLines != null && productLines.size() > 0) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)productLines, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("*"));
            selectorItemCollection.add(new SelectorItemInfo("unit.*"));
            selectorItemCollection.add(new SelectorItemInfo("workshop.id"));
            selectorItemCollection.add(new SelectorItemInfo("workshop.name"));
            entityViewInfo.setSelector(selectorItemCollection);
            ProductLineCollection lineCol = ProductLineFactory.getLocalInstance((Context)ctx).getProductLineCollection(entityViewInfo);
            if (lineCol != null && lineCol.size() > 0) {
                int n = lineCol.size();
                for (int i = 0; i < n; ++i) {
                    ProductLineInfo productLine = lineCol.get(i);
                    if (PLSTypeEnum.DAYABILITY.equals((Object)productLine.getScheduleType())) {
                        lineMap_dayYield.put(productLine.getId().toString(), productLine);
                        continue;
                    }
                    lineMap_classCap.put(productLine.getId().toString(), productLine);
                }
            }
        }
        Map dayYieldMap = new HashMap();
        if (lineMap_dayYield != null && lineMap_dayYield.size() > 0) {
            Set idSet = lineMap_dayYield.keySet();
            String strIDs = StringUtils.arrayToString((Object[])idSet.toArray(), (String)"','");
            dayYieldMap = this.getDayCap(ctx, strIDs, storageOrgUnit.getId().toString(), beginDate, endDate);
        }
        Map classCapMap = new HashMap();
        if (lineMap_classCap != null && lineMap_classCap.size() > 0) {
            Set idSet = lineMap_classCap.keySet();
            String strIDs = StringUtils.arrayToString((Object[])idSet.toArray(), (String)"','");
            classCapMap = this.getClassCap(ctx, strIDs, storageOrgUnit.getId().toString(), beginDate, endDate);
        }
        if (dayYieldMap != null && dayYieldMap.size() > 0) {
            keySet = dayYieldMap.keySet();
            for (String key : keySet) {
                Map capMap = (Map)dayYieldMap.get(key);
                if (capMap == null || capMap.size() <= 0) continue;
                dateKeys = capMap.keySet();
                for (String datekey : dateKeys) {
                    Map<String, BigDecimal> tempMap;
                    BigDecimal dayYield = (BigDecimal)capMap.get(datekey);
                    ProductLineInfo productLine = (ProductLineInfo)lineMap_dayYield.get(key);
                    double unitTimeCap = this.getUnitTimeCap(productLine);
                    double cap = dayYield.doubleValue() / unitTimeCap;
                    if (returnMap.containsKey(key)) {
                        tempMap = (Map)returnMap.get(key);
                        if (tempMap.containsKey(datekey)) continue;
                        tempMap.put(datekey, new BigDecimal(cap).setScale(2, 4));
                        returnMap.put(key, tempMap);
                        continue;
                    }
                    tempMap = new HashMap();
                    tempMap.put(datekey, new BigDecimal(cap).setScale(2, 4));
                    returnMap.put(key, tempMap);
                }
            }
        }
        if (classCapMap != null && classCapMap.size() > 0) {
            keySet = classCapMap.keySet();
            for (String key : keySet) {
                Map capMap = (Map)classCapMap.get(key);
                if (capMap == null || capMap.size() <= 0) continue;
                dateKeys = capMap.keySet();
                for (String datekey : dateKeys) {
                    Map<String, BigDecimal> tempMap;
                    BigDecimal cap = (BigDecimal)capMap.get(datekey);
                    if (returnMap.containsKey(key)) {
                        tempMap = (Map)returnMap.get(key);
                        if (tempMap.containsKey(datekey)) continue;
                        tempMap.put(datekey, cap);
                        returnMap.put(key, tempMap);
                        continue;
                    }
                    tempMap = new HashMap();
                    tempMap.put(datekey, cap);
                    returnMap.put(key, tempMap);
                }
            }
        }
        return returnMap;
    }

    private Map getDayCap(Context ctx, String strIDs, String storageOrgUnitID, Timestamp beginDate, Timestamp endDate) throws BOSException, EASBizException {
        HashMap<String, Map<String, BigDecimal>> map = new HashMap<String, Map<String, BigDecimal>>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select t.fproductlineid,TO_CHAR(t.fworkdate, 'YYYY-MM-DD') as fworkdate,sum(t.fdayyield) as sumCap from T_MM_ProductLineDayYield t ");
        sqlBuffer.append("where t.fworkday = 1 and t.fstorageorgunitid = ? ");
        sqlBuffer.append("and t.fproductlineid in ('" + strIDs + "') ");
        sqlBuffer.append("and t.fworkdate >= ? ");
        sqlBuffer.append("and t.fworkdate <= ? ");
        sqlBuffer.append("group by t.fproductlineid,TO_CHAR(t.fworkdate, 'YYYY-MM-DD') ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{storageOrgUnitID, beginDate, endDate});
        try {
            while (rowSet.next()) {
                Map<String, BigDecimal> tempMap;
                String productLineID = rowSet.getString("fproductlineid");
                String strWorkDate = rowSet.getString("fworkdate");
                BigDecimal sumCap = rowSet.getBigDecimal("sumCap");
                if (map.containsKey(productLineID)) {
                    tempMap = (Map)map.get(productLineID);
                    if (tempMap.containsKey(strWorkDate)) continue;
                    tempMap.put(strWorkDate, sumCap);
                    map.put(productLineID, tempMap);
                    continue;
                }
                tempMap = new HashMap();
                tempMap.put(strWorkDate, sumCap);
                map.put(productLineID, tempMap);
            }
            this.writeNoCapExceptionInfo(ctx, strIDs, map, beginDate, endDate, true);
            return map;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map getClassCap(Context ctx, String strIDs, String storageOrgUnitID, Timestamp beginDate, Timestamp endDate) throws BOSException, EASBizException {
        HashMap<String, Map<String, BigDecimal>> map = new HashMap<String, Map<String, BigDecimal>>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select entrys.fproductlineid,TO_CHAR(head.fworkdate, 'YYYY-MM-DD') as fworkdate,sum(entrys.fability) as sumCap ");
        sqlBuffer.append("from t_mm_equipmentcalendar head left join t_mm_equipmentcalendarentry entrys on entrys.fparentid = head.fid ");
        sqlBuffer.append("where head.fworkday = 1 and entrys.fability>0 and head.fstorageorgunitid = ? ");
        sqlBuffer.append("and entrys.fproductlineid in ('" + strIDs + "') ");
        sqlBuffer.append("and head.fworkdate >= ? ");
        sqlBuffer.append("and head.fworkdate <= ? ");
        sqlBuffer.append("group by entrys.fproductlineid,TO_CHAR(head.fworkdate, 'YYYY-MM-DD') ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{storageOrgUnitID, beginDate, endDate});
        try {
            while (rowSet.next()) {
                Map<String, BigDecimal> tempMap;
                String productLineID = rowSet.getString("fproductlineid");
                String strWorkDate = rowSet.getString("fworkdate");
                BigDecimal sumCap = rowSet.getBigDecimal("sumCap");
                if (map.containsKey(productLineID)) {
                    tempMap = (Map)map.get(productLineID);
                    if (tempMap.containsKey(strWorkDate)) continue;
                    tempMap.put(strWorkDate, sumCap);
                    map.put(productLineID, tempMap);
                    continue;
                }
                tempMap = new HashMap();
                tempMap.put(strWorkDate, sumCap);
                map.put(productLineID, tempMap);
            }
            this.writeNoCapExceptionInfo(ctx, strIDs, map, beginDate, endDate, false);
            return map;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BigDecimal changeHourCap(Context ctx, ProductLineInfo productLine, String materialID, String unitID, String groupID, BigDecimal coefficient, BigDecimal qty, CapUnitEnum capUnit) throws BOSException, EASBizException {
        double tempQty = qty.doubleValue();
        if (!productLine.getUnit().getId().toString().equals(unitID)) {
            if (productLine.getUnit().getMeasureUnitGroup().getId().toString().equals(groupID)) {
                double beforeCoef = coefficient.doubleValue();
                double afterCoef = productLine.getUnit().getCoefficient().doubleValue();
                tempQty *= beforeCoef / afterCoef;
            } else {
                MeasureUnitInfo unitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)unitID)));
                String exceDesc = ResourceUtils.getMessageForServer((String)RES_SCHEDULING, (String)"Desc_CanNotChange");
                int exceNum = 205;
                StringBuffer info = new StringBuffer();
                info.append(ResourceUtils.getMessageForServer((String)RES_SCHEDULING, (String)"Exception_CanNotChange", (String[])new String[]{productLine.getName(), productLine.getUnit().getName(), unitInfo.getName()}));
                String exceDetail = info.toString();
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.currVoucherID);
                PLSExectionMSGFactory.getRemoteInstance().addnew((CoreBaseInfo)exceInfo);
            }
        }
        if (capUnit.equals((Object)CapUnitEnum.HOUR)) {
            String key = materialID + "@" + productLine.getId().toString();
            if (this.unitTimeQtyMap != null && this.unitTimeQtyMap.size() > 0 && this.unitTimeQtyMap.containsKey(key)) {
                BigDecimal unitTimeCap = (BigDecimal)this.unitTimeQtyMap.get(key);
                tempQty /= unitTimeCap.doubleValue();
            } else {
                double unitTimeCap = this.getUnitTimeCap(productLine);
                tempQty /= unitTimeCap;
            }
        }
        return new BigDecimal(tempQty).setScale(2, 4);
    }

    private void writeNoCapExceptionInfo(Context ctx, String strIDs, Map map, Timestamp beginDate, Timestamp endDate, boolean isDayCap) throws BOSException, EASBizException {
        String[] ids = strIDs.split("','");
        HashSet<String> noCapIDs = new HashSet<String>();
        if (ids != null && ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                if (map.containsKey(ids[i])) continue;
                noCapIDs.add(ids[i]);
            }
        }
        if (noCapIDs != null && noCapIDs.size() > 0) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", noCapIDs, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            selectorItemCollection.add(new SelectorItemInfo("number"));
            selectorItemCollection.add(new SelectorItemInfo("name"));
            entityViewInfo.setSelector(selectorItemCollection);
            ProductLineCollection lineCol = ProductLineFactory.getLocalInstance((Context)ctx).getProductLineCollection(entityViewInfo);
            if (lineCol != null && lineCol.size() > 0) {
                ArrayList<ProductLineInfo> nameList = new ArrayList<ProductLineInfo>();
                for (int i = 0; i < lineCol.size(); ++i) {
                    ProductLineInfo productLine = lineCol.get(i);
                    nameList.add(productLine);
                }
                String strName = StringUtils.arrayToString((Object[])nameList.toArray(), (String)",");
                DateFormat dtformat = BOSLocaleUtil.getDateFormat();
                String bDate = dtformat.format(beginDate);
                String eDate = dtformat.format(endDate);
                PLSExectionMSGInfo exInfo = new PLSExectionMSGInfo();
                exInfo.setExceType(ExceptionTypeEnum.WARNING);
                StringBuffer info = new StringBuffer();
                if (isDayCap) {
                    exInfo.setExceDesc(ResourceUtils.getMessageForServer((String)RES_SCHEDULING, (String)"Desc_NoDayYield"));
                    info.append(ResourceUtils.getMessageForServer((String)RES_SCHEDULING, (String)"Exception_NoDayYield", (String[])new String[]{strName, bDate, eDate}));
                } else {
                    exInfo.setExceDesc(ResourceUtils.getMessageForServer((String)RES_SCHEDULING, (String)"Desc_NoClassCap"));
                    info.append(ResourceUtils.getMessageForServer((String)RES_SCHEDULING, (String)"Exception_NoClassCap", (String[])new String[]{strName, bDate, eDate}));
                }
                exInfo.setDetailInfo(info.toString());
                exInfo.setVoucherId(this.currVoucherID);
                PLSExectionMSGFactory.getRemoteInstance().addnew((CoreBaseInfo)exInfo);
            }
        }
    }
}

