/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.planning.app.AbstractRefinedPurPlanControllerBean;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RefinedPurPlanControllerBean
extends AbstractRefinedPurPlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.RefinedPurPlanControllerBean");
    private static final String ROW_KEY_SPLIT = "-";

    @Override
    protected ArrayList _getMaxHeaderList(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        ArrayList<String> headerList = new ArrayList<String>();
        StringBuffer sqlBuff = new StringBuffer();
        try {
            String whereSql = this.getWhereSQL(filterInfo);
            sqlBuff.append("select to_char(a.FRefinedPurDate,'yyyy-MM-dd') as FRefinedPurDate ");
            sqlBuff.append("from T_MM_RefinedPurPlan a ");
            sqlBuff.append("inner join T_BD_Material b on a.FMaterialID = b.fid where ");
            sqlBuff.append(whereSql);
            sqlBuff.append(" group by to_char(a.FRefinedPurDate,'yyyy-MM-dd') order by to_char(a.FRefinedPurDate,'yyyy-MM-dd') asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            while (rowSet.next()) {
                String refinedPurDate = rowSet.getString("FRefinedPurDate");
                headerList.add(refinedPurDate);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return headerList;
    }

    @Override
    protected HashMap _getRefinedPurPlanGroup(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        StringBuffer sqlBuff = new StringBuffer();
        HashMap<String, HashMap> mapDatas = new HashMap<String, HashMap>();
        try {
            String whereSql = this.getWhereSQL(filterInfo);
            sqlBuff.append("select p.FID,p.FStorageOrgUnitID,");
            sqlBuff.append("p.FMaterialID,");
            sqlBuff.append("e." + this.getFieldName(ctx) + " as materialName,");
            sqlBuff.append("e.Fnumber,");
            sqlBuff.append("e.Fmodel,");
            sqlBuff.append("p.FUnitId,");
            sqlBuff.append("c." + this.getFieldName(ctx) + " as unit,");
            sqlBuff.append("to_char(p.FRefinedPurDate,'yyyy-MM-dd') as FRefinedPurDate,");
            sqlBuff.append("p.FGRuqQty,");
            sqlBuff.append("p.FSafetyQty,");
            sqlBuff.append("p.FCurStoreQty,");
            sqlBuff.append("p.FRuqQty,");
            sqlBuff.append("p.FInitSupplyQty,");
            sqlBuff.append("p.FSupplyQty,");
            sqlBuff.append("p.FPreUseQty,");
            sqlBuff.append("p.FPlanPurQty,");
            sqlBuff.append("p.FAdvisePurQty,");
            sqlBuff.append("to_char(p.FAdvisePurDate,'yyyy-MM-dd') as FAdvisePurDate,");
            sqlBuff.append("p.FIsPutIn from ");
            sqlBuff.append("(select a.FID,a.FPlanVersionID,a.FStorageOrgUnitID,");
            sqlBuff.append("a.FMaterialID,a.FRefinedPurDate,a.FGRuqQty,a.FSafetyQty,");
            sqlBuff.append("a.FCurStoreQty,a.FRuqQty,a.FInitSupplyQty,a.FSupplyQty,a.FPreUseQty,");
            sqlBuff.append("a.FAdvisePurQty,a.FPlanPurQty,a.FAdvisePurDate,a.FIsPutIn,a.FUnitId ");
            sqlBuff.append("from T_MM_RefinedPurPlan a inner join T_BD_Material b on a.FMaterialID = b.fid where ");
            sqlBuff.append(whereSql);
            sqlBuff.append(" ) p ");
            sqlBuff.append("left join T_BD_MeasureUnit c on p.FUnitId = c.fid ");
            sqlBuff.append("left join T_BD_Material e on p.FMaterialID = e.fid");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            while (rowSet.next()) {
                ArrayList<Object> entryDataList;
                ArrayList entryList;
                HashMap rPlanMap;
                String id = rowSet.getString("FID");
                String storageOrgUnitId = rowSet.getString("FStorageOrgUnitID");
                String materialId = rowSet.getString("FMaterialID");
                String materialName = rowSet.getString("materialName");
                String number = rowSet.getString("Fnumber");
                String model = rowSet.getString("Fmodel");
                String unitId = rowSet.getString("FUnitId");
                String unit = rowSet.getString("unit");
                BigDecimal safetyQty = rowSet.getBigDecimal("FSafetyQty");
                BigDecimal curStoreQty = rowSet.getBigDecimal("FCurStoreQty");
                String refinedPurDate = rowSet.getString("FRefinedPurDate");
                BigDecimal gRuqQty = rowSet.getBigDecimal("FGRuqQty");
                BigDecimal ruqQty = rowSet.getBigDecimal("FRuqQty");
                BigDecimal initSupplyQty = rowSet.getBigDecimal("FInitSupplyQty");
                BigDecimal supplyQty = rowSet.getBigDecimal("FSupplyQty");
                BigDecimal preUseQty = rowSet.getBigDecimal("FPreUseQty");
                BigDecimal advisePurQty = rowSet.getBigDecimal("FAdvisePurQty");
                BigDecimal planPurQty = rowSet.getBigDecimal("FPlanPurQty");
                String advisePurDate = rowSet.getString("FAdvisePurDate");
                int isPutIn = rowSet.getInt("FIsPutIn");
                String groupKey = storageOrgUnitId + ROW_KEY_SPLIT + materialId;
                if (mapDatas.containsKey(groupKey)) {
                    rPlanMap = (HashMap)mapDatas.get(groupKey);
                    entryList = (ArrayList)rPlanMap.get("entryList");
                    entryDataList = new ArrayList();
                    entryDataList.add(gRuqQty);
                    entryDataList.add(ruqQty);
                    entryDataList.add(initSupplyQty);
                    entryDataList.add(supplyQty);
                    entryDataList.add(preUseQty);
                    entryDataList.add(planPurQty);
                    entryDataList.add(advisePurQty);
                    entryDataList.add(advisePurDate);
                    entryDataList.add(new Integer(isPutIn));
                    entryDataList.add(id);
                    entryDataList.add(refinedPurDate);
                    entryList.add(entryDataList);
                    continue;
                }
                rPlanMap = new HashMap();
                entryList = new ArrayList();
                entryDataList = new ArrayList<Object>();
                rPlanMap.put("storageOrgUnitId", storageOrgUnitId);
                rPlanMap.put("materialId", materialId);
                rPlanMap.put("materialName", materialName);
                rPlanMap.put("number", number);
                rPlanMap.put("model", model);
                rPlanMap.put("unitId", unitId);
                rPlanMap.put("unit", unit);
                rPlanMap.put("safetyQty", safetyQty);
                rPlanMap.put("curStoreQty", curStoreQty);
                entryDataList.add(gRuqQty);
                entryDataList.add(ruqQty);
                entryDataList.add(initSupplyQty);
                entryDataList.add(supplyQty);
                entryDataList.add(preUseQty);
                entryDataList.add(planPurQty);
                entryDataList.add(advisePurQty);
                entryDataList.add(advisePurDate);
                entryDataList.add(new Integer(isPutIn));
                entryDataList.add(id);
                entryDataList.add(refinedPurDate);
                entryList.add(entryDataList);
                rPlanMap.put("entryList", entryList);
                mapDatas.put(groupKey, rPlanMap);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return mapDatas;
    }

    private String getWhereSQL(FilterInfo filterInfo) {
        StringBuffer whereSql = new StringBuffer();
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            if ("planVersionId".equals(filterItem.getPropertyName())) {
                whereSql.append(" a.FPlanVersionID = '");
                whereSql.append((String)filterItem.getCompareValue());
                whereSql.append("' and");
            }
            if ("storageOrgUnitId".equals(filterItem.getPropertyName())) {
                whereSql.append(" a.FStorageOrgUnitID = '");
                whereSql.append((String)filterItem.getCompareValue());
                whereSql.append("' and");
            }
            if ("materialFrom".equals(filterItem.getPropertyName())) {
                whereSql.append(" b.Fnumber >= '");
                whereSql.append((String)filterItem.getCompareValue());
                whereSql.append("' and");
            }
            if (!"materialTo".equals(filterItem.getPropertyName())) continue;
            whereSql.append(" b.Fnumber <= '");
            whereSql.append((String)filterItem.getCompareValue());
            whereSql.append("'and");
        }
        whereSql.append(" 1=1 ");
        return whereSql.toString();
    }

    private String getFieldName(Context ctx) {
        return "FName_" + ctx.getLocale();
    }

    @Override
    protected IObjectValue _getMaterialPlan(Context ctx, String materialId) throws BOSException, EASBizException {
        MaterialPlanInfo retMaterialPlanInfo = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(selectorItemCollection);
        MaterialPlanCollection materialPlanCollection = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(entityViewInfo);
        if (materialPlanCollection != null && materialPlanCollection.size() > 0) {
            retMaterialPlanInfo = materialPlanCollection.get(0);
        }
        return retMaterialPlanInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateRefinedPurPlan(Context ctx, ArrayList refinedPurPlanList) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            String strSql = " update T_MM_RefinedPurPlan set FPlanPurQty=?,FAdvisePurDate=? where Fid=? ";
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(strSql);
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < refinedPurPlanList.size(); ++i) {
                HashMap updateMap = (HashMap)refinedPurPlanList.get(i);
                batchStatement.setBigDecimal(1, (BigDecimal)updateMap.get("planPurQty"));
                String strAdvisePurDate = (String)updateMap.get("advisePurDate");
                if (strAdvisePurDate == null || strAdvisePurDate.equals("")) {
                    batchStatement.setDate(2, null);
                } else {
                    batchStatement.setDate(2, new Date(sf.parse(strAdvisePurDate).getTime()));
                }
                batchStatement.setString(3, (String)updateMap.get("id"));
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (Exception e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _batchPutIn(Context ctx, CoreBaseCollection purRequestCols, ArrayList refinedPurPlanList) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            PurRequestFactory.getLocalInstance((Context)ctx).addnew(purRequestCols);
            String strSql = " update T_MM_RefinedPurPlan set FIsPutIn=1 where Fid=? ";
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(strSql);
            for (int i = 0; i < refinedPurPlanList.size(); ++i) {
                HashMap updateMap = (HashMap)refinedPurPlanList.get(i);
                String id = (String)updateMap.get("id");
                batchStatement.setString(1, id);
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (Exception e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }
}

