/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.common.app.DBBatchUtil;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.planning.IReqPlanExceptionRecord;
import com.kingdee.eas.mm.planning.ReqCntactException;
import com.kingdee.eas.mm.planning.ReqPlanCntactFacadeFactory;
import com.kingdee.eas.mm.planning.ReqPlanException;
import com.kingdee.eas.mm.planning.ReqPlanExceptionRecordFactory;
import com.kingdee.eas.mm.planning.ReqPlanExceptionRecordInfo;
import com.kingdee.eas.mm.planning.ReqPlanExceptionTypeEnum;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.app.AbstractReqPlanCntactFacadeControllerBean;
import com.kingdee.eas.mm.planning.app.ReqPlanUpdateDataVO;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ReqPlanCntactFacadeControllerBean
extends AbstractReqPlanCntactFacadeControllerBean {
    private static final long serialVersionUID = -8089383003628909650L;
    private static Logger logger = Logger.getLogger((String)ReqPlanCntactFacadeControllerBean.class.getName());
    private static final Format dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final String REQPLAN_RESOURCE_PATH = "com.kingdee.eas.mm.planning.ReqPlanResource";
    private static final int CON_WRITEOFFPID = 1;
    private static final int CON_WRITEOFFSID = 2;
    private static final int CON_WRITEOFFPIO = 3;
    private static final int CON_WRITEOFFSRC = 4;
    private static final String PARAM_STARTDATE = "StartDate";
    private static final String PARAM_ENDDATE = "EndDate";
    private static final String PARAM_DelBeforRequire = "DelBeforRequire";
    private static final int UPPER_ROWNUMBER = 10000;
    private static String MM_REQPLAN_CNT_MUTEXLOCK = "MM_ReqPlan_Cnt_MutexLock";
    private static String COOPERATE_PLAN_ORDER_BILL_TYPE_ID = "tMCsjuu0TMO+jMoUTkrsSkY+1VI=";
    private Map paramMap = new HashMap();
    public static final int BATCH = 100;
    public static final String TEMPLATE_REGEX = "TEMPLATEPARAM";

    @Override
    protected void _cntactAndCollect(Context ctx, String[] storageOrgUnitIDs, boolean ignoreFailedMutex) throws BOSException, EASBizException {
        ArrayList<String> lockedIDList = new ArrayList<String>();
        IRowSet reqTmpRow = null;
        if (storageOrgUnitIDs == null) {
            List list = this.getStorageOrgUnitsFromReqPlanTmp(ctx);
            storageOrgUnitIDs = list.toArray(new String[0]);
        }
        if (storageOrgUnitIDs.length == 0) {
            return;
        }
        ArrayList<Uuid> mutexUuids = new ArrayList<Uuid>();
        try {
            int m = storageOrgUnitIDs.length;
            for (int i = 0; i < m; ++i) {
                Uuid mutexUuid = Uuid.create();
                IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                boolean requestFlag = mutexService.requestMutex(ReqPlanCntactFacadeControllerBean.setMutexParameter(mutexUuid, storageOrgUnitIDs[i]));
                if (requestFlag) {
                    mutexUuids.add(mutexUuid);
                    lockedIDList.add(storageOrgUnitIDs[i]);
                    continue;
                }
                if (!ignoreFailedMutex) {
                    throw new ReqCntactException(ReqCntactException.REQUESTMUTEXFAIL);
                }
                this.writeExceptionLocal(ctx, storageOrgUnitIDs[i], ReqPlanExceptionTypeEnum.ALARM, ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"dealRequirePlan", (Locale)ctx.getLocale()), ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"mutexFail", (Locale)ctx.getLocale()), "");
            }
            if (lockedIDList.size() == 0) {
                return;
            }
            String lockedOrgIds = StringUtils.arrayToString((Object[])lockedIDList.toArray(), (String)"','");
            StringBuffer queryBuffer = new StringBuffer();
            queryBuffer.append("SELECT TOP  10000").append(" tmp.fID,").append("tmp.FOriginType,").append("tmp.FStorageOrgUnitID,").append("tmp.FSourceBillID,").append("tmp.FSourceEntryID,").append("tmp.FOperationType,").append("tmp.FBillTypeID,").append("tmp.FSourceBillTypeID,").append("tmp.FMaterialID,").append("mp.FProductUnitID as FUnitID,").append("tmp.FBaseUnitID,").append("round(tmp.FBaseQty/isnull(mu.fBaseConvsRate,1),isnull(mu.FQtyPrecision,4)) as FQty,").append("tmp.FBaseQty,").append("tmp.FSrcNumber,").append("tmp.FSrcSeq,").append("tmp.FRequireDate,").append("tmp.FSourceSUID,").append("tmp.FSrcOfSourceBillID,").append("tmp.FSrcOfSourceEntryID,").append("tmp.FCreateTime,").append("tmp.FCreatorID,").append("tmp.FTrackNumberID,").append("tmp.FProjectID,").append("case when mp.FIssMode = ").append(11050).append(" then 1 else 0 end as FIsDirectTransport, ").append("mp.FPlanningMode,").append("mp.fManufactureStrategyID,").append("mp.fOffsetMode,").append("mp.fForwardDaysOffset,").append("mp.fBackwardDaysOffset,").append("mp.FPlanner,").append("mp.FDutyDepartment,").append("org.FControlUnitID ").append("FROM T_MM_ReqPlanTmp as tmp ").append("left outer join t_org_storage as org on tmp.FStorageOrgUnitID = org.FID ").append("left outer join t_bd_materialplan as mp ").append("\ton tmp.FStorageOrgUnitID = mp.FOrgUnit and tmp.FMaterialID = mp.fMaterialID ").append("left outer join t_bd_multiMeasureUnit mu ").append("\ton mp.FMaterialID = mu.FMaterialID and mp.FProductUnitID = mu.FMeasureUnitID ").append("WHERE tmp.fStorageOrgUnitID in('" + lockedOrgIds + "')");
            String sorter = " order by tmp.fCreateTime ASC";
            StringBuffer queryWithTimeFilter = new StringBuffer();
            queryWithTimeFilter.append(queryBuffer).append(" and tmp.fCreateTime >= ?").append(sorter);
            StringBuffer queryWithOutTimeFilter = new StringBuffer();
            queryWithOutTimeFilter.append(queryBuffer).append(sorter);
            int count = 0;
            boolean hasTraversedAll = false;
            ReqPlanUpdateDataVO dataVO = null;
            Timestamp lastTraversedTime = null;
            while (!hasTraversedAll) {
                LinkedList<String> succeedRecords = new LinkedList<String>();
                LinkedList<String> failRecords = new LinkedList<String>();
                LinkedList<String> allRecords = new LinkedList<String>();
                reqTmpRow = lastTraversedTime != null ? DbUtil.executeQuery((Context)ctx, (String)queryWithTimeFilter.toString(), (Object[])new Object[]{lastTraversedTime}) : DbUtil.executeQuery((Context)ctx, (String)queryWithOutTimeFilter.toString());
                if (reqTmpRow.size() < 10000) {
                    hasTraversedAll = true;
                }
                while (reqTmpRow.next()) {
                    dataVO = new ReqPlanUpdateDataVO();
                    dataVO.setId(reqTmpRow.getString("FID"));
                    dataVO.setStorageOrgUnitID(reqTmpRow.getString("FStorageOrgUnitID"));
                    dataVO.setOriginType(reqTmpRow.getInt("FOriginType"));
                    dataVO.setBizAction(reqTmpRow.getInt("FOperationType"));
                    dataVO.setMaterialID(reqTmpRow.getString("FMaterialID"));
                    dataVO.setUnitID(reqTmpRow.getString("FUnitID"));
                    dataVO.setBaseUnitID(reqTmpRow.getString("FBaseUnitID"));
                    dataVO.setQty(reqTmpRow.getBigDecimal("FQty"));
                    dataVO.setBaseQty(reqTmpRow.getBigDecimal("FBaseQty"));
                    dataVO.setRequireDate(reqTmpRow.getDate("FRequireDate"));
                    dataVO.setBillTypeID(reqTmpRow.getString("FBillTypeID"));
                    dataVO.setBillID(reqTmpRow.getString("FSourceBillID"));
                    dataVO.setBillNumber(reqTmpRow.getString("FSrcNumber"));
                    dataVO.setBillEntryID(reqTmpRow.getString("FSourceEntryID"));
                    dataVO.setBillEntrySeq(reqTmpRow.getInt("FSrcSeq"));
                    dataVO.setSrcBillTypeID(reqTmpRow.getString("FSourceBillTypeID"));
                    dataVO.setSrcBillID(reqTmpRow.getString("FSrcOfSourceBillID"));
                    dataVO.setSrcBillEntryID(reqTmpRow.getString("FSrcOfSourceEntryID"));
                    dataVO.setSrcOrgUnitID(reqTmpRow.getString("FSourceSUID"));
                    dataVO.setProjectID(reqTmpRow.getString("FProjectID"));
                    dataVO.setTrackNumberID(reqTmpRow.getString("FTrackNumberID"));
                    dataVO.setPlanningMode(reqTmpRow.getInt("FPlanningMode"));
                    dataVO.setManuStrategyID(reqTmpRow.getString("FManufactureStrategyID"));
                    dataVO.setOffsetMode(reqTmpRow.getInt("FOffsetMode"));
                    dataVO.setForwardDaysOffset(reqTmpRow.getInt("FForwardDaysOffset"));
                    dataVO.setBackwardDaysOffset(reqTmpRow.getInt("FBackwardDaysOffset"));
                    dataVO.setCuID(reqTmpRow.getString("FControlUnitID"));
                    dataVO.setCreateTime(reqTmpRow.getTimestamp("FCreateTime"));
                    dataVO.setCreatorID(reqTmpRow.getString("FCreatorID"));
                    dataVO.setDirectTransport(reqTmpRow.getInt("FIsDirectTransport"));
                    dataVO.setPlanner(reqTmpRow.getString("FPlanner") == null ? "" : reqTmpRow.getString("FPlanner"));
                    dataVO.setProductionDept(reqTmpRow.getString("FDutyDepartment") == null ? "" : reqTmpRow.getString("FDutyDepartment"));
                    lastTraversedTime = reqTmpRow.getTimestamp("fCreateTime");
                    boolean isSuccee = this.cntactRow(ctx, dataVO);
                    if (isSuccee) {
                        succeedRecords.add(dataVO.getId());
                    } else {
                        failRecords.add(dataVO.getId());
                    }
                    allRecords.add(dataVO.getId());
                    ++count;
                }
                this.deleteSucceedRecord(ctx, allRecords);
            }
            if (count > 0) {
                String[] suArray = lockedIDList.toArray(new String[0]);
                try {
                    this._collectReq(ctx, suArray);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            int size = mutexUuids.size();
            for (int i = 0; i < size; ++i) {
                IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                mutexService.releaseMutex((Uuid)mutexUuids.get(i));
            }
        }
    }

    protected boolean cntactRow(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        boolean isSuccee = true;
        int originType = dataVO.getOriginType();
        try {
            switch (originType) {
                case 10: {
                    this.passiveWriteOffPICReq(ctx, dataVO.getStorageOrgUnitID(), dataVO.getMaterialID());
                    break;
                }
                case 20: {
                    this.execSop(ctx, dataVO);
                    break;
                }
                case 30: {
                    this.execSIDs(ctx, dataVO);
                    break;
                }
                case 40: {
                    this.reductionAssign(ctx, dataVO);
                    break;
                }
                case 50: {
                    break;
                }
                case 60: {
                    this.execProjectTask(ctx, dataVO);
                    break;
                }
                case 70: {
                    this.execReqRequest(ctx, dataVO);
                    break;
                }
                case 80: {
                    this.execCentralPurPlan(ctx, dataVO);
                    break;
                }
                case 90: {
                    this.execMID(ctx, dataVO);
                    break;
                }
                case 91: {
                    this.execGCCD(ctx, dataVO);
                }
            }
        }
        catch (EASBizException e) {
            isSuccee = false;
            throw e;
        }
        catch (Exception e) {
            isSuccee = false;
            throw new BOSException((Throwable)e);
        }
        return isSuccee;
    }

    protected void batchTemplateMethod(Context ctx, List ids, String sqlTemplate) throws BOSException {
        if (null == ids || 0 == ids.size()) {
            return;
        }
        int toIndex = 0;
        List subList = null;
        String sql = null;
        ArrayList<String> sqlList = new ArrayList<String>();
        Pattern p = Pattern.compile(TEMPLATE_REGEX);
        for (int index = 0; index < ids.size(); index += 100) {
            toIndex = index + 100 > ids.size() ? ids.size() : index + 100;
            subList = ids.subList(index, toIndex);
            sql = p.matcher(sqlTemplate).replaceAll(StringUtils.arrayToString((Object[])subList.toArray(), (String)"','"));
            sqlList.add(sql);
        }
        DBBatchUtil.executeBatch((Context)ctx, sqlList);
    }

    protected void updateTmpFailTimes(Context ctx, List ids) throws BOSException {
        String sqlTemplate = "UPDATE t_mm_ReqPlanTmp set fFailTimes = fFailTimes+1 where fID in('TEMPLATEPARAM')";
        this.batchTemplateMethod(ctx, ids, sqlTemplate);
    }

    protected void deleteSucceedRecord(Context ctx, List ids) throws BOSException {
        String sqlTemplate = "DELETE FROM t_mm_ReqPlanTmp where fID in('TEMPLATEPARAM')";
        this.batchTemplateMethod(ctx, ids, sqlTemplate);
    }

    protected void deleteReqPlanTmpByOrgId(Context ctx, String storageOrgUnitIds) throws BOSException {
        String sqlTemplate = "DELETE FROM t_mm_ReqPlanTmp where FSTORAGEORGUNITID is null or FSTORAGEORGUNITID in('" + storageOrgUnitIds + "')";
        DbUtil.execute((Context)ctx, (String)sqlTemplate);
    }

    protected void passiveWriteOffPICReq(Context ctx, String storageOrgUnitID, String materialID) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet reqRow = null;
        StringBuffer sql_querySIDReq = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String paramValue = (String)this.paramMap.get(storageOrgUnitID + "MTDREQ_CONSUMEPICREQ");
            if (paramValue == null) {
                paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"MTDREQ_CONSUMEPICREQ");
            }
            boolean isMtdConsumePic = false;
            if (paramValue != null) {
                isMtdConsumePic = Boolean.valueOf(paramValue);
            }
            sql_querySIDReq.append("select p.fID,p.fSourceBillID,p.fsourceBillNum,p.fSourceEntryID,p.fBillTypeID,p.fStorageOrgUnitID,p.fMaterialID,p.fUnitID,p.fBaseUnitID");
            sql_querySIDReq.append(",m.fManufactureStrategyID,m.fOffSetMode,m.fForwardDaysOffset,m.fBackwardDaysOffset,p.fNotCntactQty,p.fBaseNotCntactQty,p.fRequireDate");
            sql_querySIDReq.append(", case when m.FIssMode = ").append(11050).append(" then 1 else 0 end as FIsDirectTransport ");
            sql_querySIDReq.append(" from t_mm_RequirementPlan p,t_bd_materialplan m ");
            sql_querySIDReq.append(" where p.fMaterialID = m.fMaterialID ");
            sql_querySIDReq.append(" and p.fStorageOrgUnitID = m.FOrgUnit");
            sql_querySIDReq.append(" and p.fStorageOrgUnitID = ?");
            if (materialID != null) {
                sql_querySIDReq.append(" and p.fMaterialID = '" + materialID + "'");
            }
            sql_querySIDReq.append(" and p.fStatus = ?");
            sql_querySIDReq.append(" and p.fNotCntactQty >0");
            if (isMtdConsumePic) {
                sql_querySIDReq.append(" and(p.fReqSource = ?");
                sql_querySIDReq.append(" and p.FReqTypeID = ?");
                sql_querySIDReq.append(" or  p.fReqSource = ?");
                sql_querySIDReq.append(" and p.FReqTypeID = ?)");
            } else {
                sql_querySIDReq.append(" and p.fReqSource= ?");
                sql_querySIDReq.append(" and p.FReqTypeID = ?");
            }
            sql_querySIDReq.append(" and exists (select 1 from t_mm_RequirementPlan as picR ");
            sql_querySIDReq.append("\twhere p.FStorageOrgUnitID = picR.FStorageOrgUnitID");
            sql_querySIDReq.append("\tand p.FMaterialID = picR.FMaterialID ");
            sql_querySIDReq.append("\tand picR.fReqTypeID = 'NcvxPgEcEADgAAiqwKgL09hs+cg='");
            sql_querySIDReq.append("\tand picR.fStatus =  10");
            sql_querySIDReq.append("\tand fQty > fCntactTotalQty)");
            sql_querySIDReq.append(" order by p.fRequireDate ,p.FReqTypeID ");
            String sql_t = sql_querySIDReq.toString();
            statement = conn.prepareStatement(sql_t);
            int rowIndex = 1;
            statement.setString(rowIndex++, storageOrgUnitID);
            statement.setInt(rowIndex++, 10);
            statement.setInt(rowIndex++, 20);
            statement.setString(rowIndex++, "NcvxPgEcEADgAAiswKgL09hs+cg=");
            if (isMtdConsumePic) {
                statement.setInt(rowIndex++, 40);
                statement.setString(rowIndex++, "NcvxPgEcEADgAAiwwKgL09hs+cg=");
            }
            reqRow = statement.executeQuery();
            while (reqRow.next()) {
                if (reqRow.getString("fManufactureStrategyID") == null || reqRow.getString("fManufactureStrategyID").trim().length() <= 0 || reqRow.getInt("fOffsetMode") <= 0) continue;
                ReqPlanUpdateDataVO newDataVO = new ReqPlanUpdateDataVO();
                newDataVO.setId(reqRow.getString("fID"));
                newDataVO.setBillID(reqRow.getString("fSourceBillID"));
                newDataVO.setBillNumber(reqRow.getString("fsourceBillNum"));
                newDataVO.setBillEntryID(reqRow.getString("fSourceEntryID"));
                newDataVO.setBillTypeID(reqRow.getString("fBillTypeID"));
                newDataVO.setStorageOrgUnitID(reqRow.getString("fStorageOrgUnitID"));
                newDataVO.setMaterialID(reqRow.getString("fMaterialID"));
                newDataVO.setUnitID(reqRow.getString("fUnitID"));
                newDataVO.setBaseUnitID(reqRow.getString("fBaseUnitID"));
                newDataVO.setQty(reqRow.getBigDecimal("fNotCntactQty"));
                newDataVO.setBaseQty(reqRow.getBigDecimal("fBaseNotCntactQty"));
                newDataVO.setRequireDate(reqRow.getDate("fRequireDate"));
                newDataVO.setOffsetMode(reqRow.getInt("fOffsetMode"));
                newDataVO.setForwardDaysOffset(reqRow.getInt("fForwardDaysOffset"));
                newDataVO.setBackwardDaysOffset(reqRow.getInt("fBackwardDaysOffset"));
                newDataVO.setDirectTransport(reqRow.getInt("FIsDirectTransport"));
                this.writeOffPICReq(ctx, newDataVO);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(reqRow, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)reqRow, (Statement)statement, (Connection)conn);
    }

    protected void writeOffPICReq(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String strWhere;
        String strFrom;
        String strSelect;
        String reqID = dataVO.getId();
        String billID = dataVO.getBillID();
        String billNum = dataVO.getBillNumber();
        String billEntryID = dataVO.getBillEntryID();
        String billTypeID = dataVO.getBillTypeID();
        String orgUnitID = dataVO.getStorageOrgUnitID();
        String materialID = dataVO.getMaterialID();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        int offsetMode = dataVO.getOffsetMode();
        int forwardDaysOffset = dataVO.getForwardDaysOffset();
        int backwardDaysOffset = dataVO.getBackwardDaysOffset();
        BigDecimal notCntQty = dataVO.getQty();
        BigDecimal baseNotCntQty = dataVO.getBaseQty();
        Date reqDate = dataVO.getRequireDate();
        String sql_queryReq = this.getCntFilter(ctx, orgUnitID, reqDate, offsetMode, forwardDaysOffset, backwardDaysOffset, strSelect = "select fID,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fRequireDate ", strFrom = " from t_mm_RequirementPlan ", strWhere = " where fStorageOrgUnitID = '" + orgUnitID + "' and fMaterialID = '" + materialID + "' and fReqTypeID = '" + "NcvxPgEcEADgAAiqwKgL09hs+cg=" + "' and fStatus =  " + 10 + " and fQty>fCntactTotalQty");
        if (sql_queryReq.trim().length() == 0) {
            return;
        }
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)sql_queryReq);
        try {
            int seq = 1;
            String sql_updatePIC = "update T_MM_RequirementPlan set fCntactTotalQty= fQty,fBaseCntactTotalQty= fBaseQty,fStatus = 20 where fID = ?";
            StringBuffer sql_recordWriteOffRelation = new StringBuffer();
            sql_recordWriteOffRelation.append("insert into T_MM_ReqCounteractRelation ");
            sql_recordWriteOffRelation.append("(FID,FSourceID,FSourceEntryID,FDestID,FBillTypeID,FQty,FBaseQty,FUnitID,FBaseUnitID,FSeq,FSourceNumber)");
            sql_recordWriteOffRelation.append(" values(?,?,?,?,?,?,?,?,?,?,?)");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            ArrayList<String[]> paramList2 = new ArrayList<String[]>();
            Object[] params = null;
            while (reqRow.next()) {
                String pidReqID = reqRow.getString("fID");
                BigDecimal picQty = reqRow.getBigDecimal("fQty");
                BigDecimal basePicQty = reqRow.getBigDecimal("fBaseQty");
                BigDecimal picCntactQty = reqRow.getBigDecimal("fCntactTotalQty");
                BigDecimal basePicCntactQty = reqRow.getBigDecimal("fBaseCntactTotalQty");
                if (notCntQty.compareTo(picQty.subtract(picCntactQty)) > 0) {
                    paramList2.add(new String[]{pidReqID});
                    params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, pidReqID, billTypeID, picQty.subtract(picCntactQty), basePicQty.subtract(basePicCntactQty), unitID, baseUnitID, new Integer(seq++), billNum};
                    notCntQty = notCntQty.subtract(picQty.subtract(picCntactQty));
                    baseNotCntQty = baseNotCntQty.subtract(basePicQty.subtract(basePicCntactQty));
                    paramList.add(params);
                    continue;
                }
                String sql_updatePIC2 = "update T_MM_RequirementPlan set fCntactTotalQty= fCntactTotalQty+" + notCntQty + " ,fBaseCntactTotalQty= fBaseCntactTotalQty+" + baseNotCntQty;
                if (notCntQty.compareTo(picQty.subtract(picCntactQty)) == 0) {
                    sql_updatePIC2 = sql_updatePIC2 + " ,fStatus = 20";
                }
                sql_updatePIC2 = sql_updatePIC2 + " where fID = '" + pidReqID + "'";
                DbUtil.execute((Context)ctx, (String)sql_updatePIC2);
                params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, pidReqID, billTypeID, notCntQty, baseNotCntQty, unitID, baseUnitID, new Integer(seq++), billNum};
                paramList.add(params);
                notCntQty = new BigDecimal("0.00");
                baseNotCntQty = new BigDecimal("0.00");
                break;
            }
            if (seq > 1) {
                DbUtil.executeBatch((Context)ctx, (String)sql_updatePIC, paramList2);
                DbUtil.executeBatch((Context)ctx, (String)sql_recordWriteOffRelation.toString(), paramList);
                String sql_updateSID = "update T_MM_RequirementPlan set fNotCntactQty = ?,fBaseNotCntactQty = ? where fID = ?";
                DbUtil.execute((Context)ctx, (String)sql_updateSID, (Object[])new Object[]{notCntQty, baseNotCntQty, reqID});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getCntFilter(Context ctx, String storageOrgUnitID, Date reqDate, int offset, int forwardDaysOffset, int backwardDaysOffset, String strSelect, String strFrom, String strWhere) throws BOSException, EASBizException {
        StringBuffer sql_queryReq = new StringBuffer();
        String startDate = "";
        String endDate = "";
        switch (offset) {
            case 10320: {
                Date tmpStDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storageOrgUnitID, reqDate, 2, forwardDaysOffset, 2);
                startDate = tmpStDate == null ? dateFormat.format(reqDate) : dateFormat.format(tmpStDate);
                sql_queryReq.append("select * from (");
                sql_queryReq.append(strSelect).append("\n ,case when fReqSource = ").append(30).append(" then 2 else 1 end as fOrder ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >='").append(startDate);
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') <='").append(dateFormat.format(reqDate) + "') as A ");
                sql_queryReq.append(" \n ORDER BY fOrder DESC,fRequireDate DESC");
                break;
            }
            case 10330: {
                Date tmpEdDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storageOrgUnitID, reqDate, 1, backwardDaysOffset, 2);
                endDate = tmpEdDate == null ? dateFormat.format(reqDate) : dateFormat.format(tmpEdDate);
                sql_queryReq.append("select * from (");
                sql_queryReq.append(strSelect).append("\n ,case when fReqSource = ").append(30).append(" then 1 else 2 end as fOrder");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >='").append(dateFormat.format(reqDate));
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') <='").append(endDate).append("') as A ");
                sql_queryReq.append(" \n ORDER BY fOrder ASC,fRequireDate ASC");
                break;
            }
            case 10340: {
                Date tmpStDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storageOrgUnitID, reqDate, 2, forwardDaysOffset, 2);
                startDate = tmpStDate == null ? dateFormat.format(reqDate) : dateFormat.format(tmpStDate);
                Date tmpEdDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storageOrgUnitID, reqDate, 1, backwardDaysOffset, 2);
                endDate = tmpEdDate == null ? dateFormat.format(reqDate) : dateFormat.format(tmpEdDate);
                sql_queryReq.append("select * from (");
                sql_queryReq.append(strSelect).append("\n ,case when fReqSource = ").append(30).append(" then 2 else 1 end as fOrder1 ");
                sql_queryReq.append(" \n ,fRequireDate - to_date('").append(startDate).append("') as fOrder2 ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >='").append(startDate);
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') <='").append(dateFormat.format(reqDate)).append("' ");
                sql_queryReq.append(" \n union all ");
                sql_queryReq.append(strSelect).append("\n ,case when fReqSource = ").append(30).append(" then 2 else 1 end as fOrder1 ");
                sql_queryReq.append(" \n ,to_date('").append(dateFormat.format(reqDate)).append("')-fRequireDate  as fOrder2 ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >'").append(dateFormat.format(reqDate));
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') <='").append(endDate + "') as A ");
                sql_queryReq.append(" \n ORDER BY fOrder1 DESC,fOrder2 DESC");
                break;
            }
            case 10350: {
                Date tmpStDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storageOrgUnitID, reqDate, 2, forwardDaysOffset, 2);
                startDate = tmpStDate == null ? dateFormat.format(reqDate) : dateFormat.format(tmpStDate);
                Date tmpEdDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(storageOrgUnitID, reqDate, 1, backwardDaysOffset, 2);
                endDate = tmpEdDate == null ? dateFormat.format(reqDate) : dateFormat.format(tmpEdDate);
                sql_queryReq.append("select * from (");
                sql_queryReq.append(strSelect).append("\n ,case when fReqSource = ").append(30).append(" then 1 else 2 end as fOrder1 ");
                sql_queryReq.append("\n,fRequireDate - to_date('").append(endDate).append("') as fOrder2 ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >='").append(dateFormat.format(reqDate));
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') <= '").append(endDate + "' ");
                sql_queryReq.append(" \n union all ");
                sql_queryReq.append(strSelect).append("\n ,case when fReqSource = ").append(30).append(" then 1 else 2 end as fOrder1 ");
                sql_queryReq.append("\n ,to_date('").append(dateFormat.format(reqDate)).append("')-fRequireDate as fOrder2 ");
                sql_queryReq.append(strFrom).append(strWhere);
                sql_queryReq.append(" \n and to_char(fRequireDate,'yyyy-mm-dd') >= '").append(startDate);
                sql_queryReq.append("' \n and to_char(fRequireDate,'yyyy-mm-dd') < '").append(dateFormat.format(reqDate) + "') as A ");
                sql_queryReq.append(" \n ORDER BY fOrder1 ASC,fOrder2 ASC");
                break;
            }
        }
        return sql_queryReq.toString();
    }

    protected void execSIDs(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String billTypeID = dataVO.getBillTypeID();
        String billID = dataVO.getBillID();
        String billEntryID = dataVO.getBillEntryID();
        int bizAction = dataVO.getBizAction();
        int billEntryseq = dataVO.getBillEntrySeq();
        String num = dataVO.getBillNumber();
        String orgUnitID = dataVO.getStorageOrgUnitID();
        String materialID = dataVO.getMaterialID();
        String baseUntID = dataVO.getBaseUnitID();
        String creatorId = dataVO.getCreatorID();
        Timestamp createTime = dataVO.getCreateTime();
        String cuID = dataVO.getCuID();
        String trackNumberID = dataVO.getTrackNumberID();
        String projectID = dataVO.getProjectID();
        Date requireDate = dataVO.getRequireDate();
        int planningMode = dataVO.getPlanningMode();
        String manuStrategyID = dataVO.getManuStrategyID();
        String unitID = dataVO.getUnitID();
        BigDecimal qty = dataVO.getQty();
        BigDecimal baseQty = dataVO.getBaseQty();
        int directTransport = dataVO.getDirectTransport();
        boolean isAudit = false;
        int isTrackNumFromSrc = 0;
        try {
            if (manuStrategyID == null || manuStrategyID.trim().length() == 0) {
                return;
            }
            switch (bizAction) {
                case 103: {
                    isAudit = true;
                    break;
                }
                case 109: {
                    if (billID == null || billID.trim().length() <= 0 || billTypeID == null || billTypeID.trim().length() <= 0) break;
                    this.reverseWriteOffReq(ctx, orgUnitID, billID, billEntryID, true);
                    this.passiveWriteOffPICReq(ctx, orgUnitID, materialID);
                    break;
                }
                case 701: {
                    this.reverseWriteOffReq(ctx, null, billID, billEntryID, false);
                    isAudit = true;
                    break;
                }
                case 702: 
                case 703: {
                    break;
                }
                case 704: {
                    isAudit = true;
                }
            }
            if (isAudit) {
                ReqPlanUpdateDataVO newDataVO = (ReqPlanUpdateDataVO)dataVO.clone();
                if (trackNumberID == null || trackNumberID.trim().length() == 0) {
                    String paramValue;
                    if ((projectID == null || projectID.trim().length() == 0) && (paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(orgUnitID), (String)"TRACKNUMBER_GENERATEMODE")) != null && paramValue.equals("1")) {
                        ITrackNumber itrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                        CtrlUnitInfo cu = new CtrlUnitInfo();
                        cu.setId(BOSUuid.read((String)cuID));
                        boolean hasCodingRule = itrackNumber.hasCodingRuler(cu);
                        if (hasCodingRule) {
                            TrackNumberCollection trackNumberCol = itrackNumber.autoGenerateNum(null, 1, cu);
                            trackNumberID = trackNumberCol.get(0).getId().toString();
                        }
                    }
                } else {
                    isTrackNumFromSrc = 1;
                }
                String sql_ifExist = "select FID,FBaseCntactTotalQty from T_MM_RequirementPlan where fSourceBillID = ? and fSourceEntryID = ? and fBillTypeID = ?";
                IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql_ifExist, (Object[])new Object[]{billID, billEntryID, billTypeID});
                StringBuffer sqlBuf_insertReq = new StringBuffer();
                sqlBuf_insertReq.append("insert into T_MM_RequirementPlan ");
                sqlBuf_insertReq.append("(FID,FNumber,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,");
                sqlBuf_insertReq.append("fReqSource,fReqTypeID,fManuStrategyID,fRequireDate,");
                sqlBuf_insertReq.append("fQty,fBaseQty,fNotCntactQty,fBaseNotCntactQty,fSourceBillID,fSourceBillNum,fBillTypeID,");
                sqlBuf_insertReq.append("fSourceEntryID,fSourceEntrySeq,fStatus,fPlanMode,fCreatorID,FCreateTime,");
                sqlBuf_insertReq.append("fControlUnitID,FTrackNumberID,FProjectID,FIsTrackNumFromSrc");
                sqlBuf_insertReq.append(",fIsDirectTransport,FPlannerID,FProductionDeptID )");
                sqlBuf_insertReq.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                if (row.next()) {
                    StringBuffer sql_update = new StringBuffer();
                    sql_update.append("UPDATE T_MM_RequirementPlan ");
                    sql_update.append("SET FQty = ?,FBaseQty = ?,FNotCntactQty = ?,FBaseNotCntactQty = ?,FRequireDate = ?,");
                    sql_update.append("    FStatus = (case when FBaseCntactTotalQty < ? and fclosetype <> 20 then 10");
                    sql_update.append(" else 20 end)");
                    sql_update.append("where FID =?");
                    DbUtil.execute((Context)ctx, (String)sql_update.toString(), (Object[])new Object[]{qty, baseQty, qty, baseQty, requireDate, baseQty, row.getString("FID")});
                    newDataVO.setId(row.getString("FID"));
                } else {
                    String newId = BOSUuid.create((String)"D86AF5B7").toString();
                    String[] billNumber = this.getNumbers(ctx, orgUnitID, 1);
                    Object[] insertParams = new Object[]{newId, billNumber[0], orgUnitID, orgUnitID, materialID, unitID, baseUntID, new Integer(20), "NcvxPgEcEADgAAiswKgL09hs+cg=", manuStrategyID, requireDate, qty, baseQty, qty, baseQty, billID, num, billTypeID, billEntryID, new Integer(billEntryseq), new Integer(10), new Integer(planningMode), creatorId, createTime, cuID, trackNumberID, projectID, new Integer(isTrackNumFromSrc), new Integer(directTransport), dataVO.getPlanner(), dataVO.getProductionDept()};
                    ReqPlanCntactFacadeControllerBean.execute(ctx, sqlBuf_insertReq.toString(), insertParams);
                    newDataVO.setId(newId);
                }
                this.writeOffPICReq(ctx, newDataVO);
                if (bizAction == 701) {
                    this.passiveWriteOffPICReq(ctx, orgUnitID, materialID);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void execMTD(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        block26: {
            String storageOrgUnitID = dataVO.getStorageOrgUnitID();
            String sourceSUID = dataVO.getSrcOrgUnitID();
            String sourceBillID = dataVO.getBillID();
            String sourceEntryID = dataVO.getBillEntryID();
            String materialID = dataVO.getMaterialID();
            String unitID = dataVO.getUnitID();
            String baseUntID = dataVO.getBaseUnitID();
            BigDecimal qty = dataVO.getQty();
            BigDecimal baseQty = dataVO.getBaseQty();
            int operationType = dataVO.getBizAction();
            String billTypeID = dataVO.getBillTypeID();
            String srcBillType = dataVO.getSrcBillTypeID();
            String cuID = dataVO.getCuID();
            Date reqDate = dataVO.getRequireDate();
            String num = dataVO.getBillNumber();
            int seq = dataVO.getBillEntrySeq();
            String creatorID = dataVO.getCreatorID();
            Timestamp fcreateTime = dataVO.getCreateTime();
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = sf.format(fcreateTime);
            String trackNumberID = dataVO.getTrackNumberID();
            String projectID = dataVO.getProjectID();
            int planningMode = dataVO.getPlanningMode();
            String manuStrategyID = dataVO.getManuStrategyID();
            String fNewID = BOSUuid.create((String)"D86AF5B7").toString();
            String paramValue = (String)this.paramMap.get(storageOrgUnitID + "MTDREQ_CONSUMEPICREQ");
            boolean isMtdConsumePic = false;
            if (paramValue != null && "NUnM+gEcEADgAA3gwKgL09g0uEU=".equals(manuStrategyID)) {
                isMtdConsumePic = Boolean.valueOf(paramValue);
            }
            int isTrackNumFromSrc = 0;
            if (trackNumberID != null && trackNumberID.trim().length() > 0) {
                isTrackNumFromSrc = 1;
            }
            try {
                ReqPlanUpdateDataVO newDataVO = (ReqPlanUpdateDataVO)dataVO.clone();
                if ("9XXvbVGlRtym/0qtqeIXXrhE1B8=".equals(srcBillType)) {
                    switch (operationType) {
                        case 102: {
                            String sql = "select FID,FCntactTotalQty,FBaseCntactTotalQty from T_MM_RequirementPlan where fSourceBillID = '" + sourceBillID + "' and fSourceEntryID = '" + sourceEntryID + "' and fBillTypeID = '" + billTypeID + "'";
                            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                            if (rowSet != null && rowSet.next()) {
                                if (isMtdConsumePic) {
                                    this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
                                }
                                String sql_update = "update T_MM_RequirementPlan set fQty = " + qty + ",fBaseQty = " + baseQty + ",fNotCntactQty = " + qty + ",fBaseNotCntactQty = " + baseQty + " where FID ='" + rowSet.getString("FID") + "'";
                                DbUtil.execute((Context)ctx, (String)sql_update);
                                if (isMtdConsumePic) {
                                    newDataVO.setId(rowSet.getString("FID"));
                                    this.writeOffPICReq(ctx, newDataVO);
                                    this.passiveWriteOffPICReq(ctx, storageOrgUnitID, materialID);
                                    break;
                                }
                            } else {
                                String[] billNumber = this.getNumbers(ctx, storageOrgUnitID, 1);
                                sql = " insert into T_MM_RequirementPlan (fID,fNumber,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,fReqSource,fReqTypeID,fManuStrategyID,fRequireDate,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fNotCntactQty,fBaseNotCntactQty,fSourceBillID,fSourceBillNum,fSourceEntryID,fSourceEntrySeq,fBillTypeID,fStatus,fCreatorID,FCreateTime,fPlanMode,fControlUnitID,FTrackNumberID,FProjectID,FIsTrackNumFromSrc,FIsDirectTransport,FPlannerID,FProductionDeptID) values('" + fNewID + "','" + billNumber[0] + "','" + storageOrgUnitID + "',?,'" + materialID + "','" + unitID + "','" + baseUntID + "'," + 40 + ",'" + "NcvxPgEcEADgAAiwwKgL09hs+cg=" + "','" + manuStrategyID + "',to_date('" + dateFormat.format(reqDate) + "')," + qty + "," + baseQty + ",0,0," + qty + "," + baseQty + ",'" + sourceBillID + "','" + num + "',?," + seq + ",'" + billTypeID + "'," + 10 + ",'" + creatorID + "',{ts'" + createTime + "'}," + planningMode + ",'" + cuID + "',?,?,?,?,?,?)";
                                ReqPlanCntactFacadeControllerBean.execute(ctx, sql, new Object[]{sourceSUID, sourceEntryID, trackNumberID, projectID, new Integer(isTrackNumFromSrc), new Integer(dataVO.getDirectTransport()), dataVO.getPlanner(), dataVO.getProductionDept()});
                                if (isMtdConsumePic) {
                                    newDataVO.setId(fNewID);
                                    this.writeOffPICReq(ctx, newDataVO);
                                    break;
                                }
                            }
                            break block26;
                        }
                        case 104: {
                            if (isMtdConsumePic) {
                                this.reverseWriteOffReq(ctx, storageOrgUnitID, sourceBillID, sourceEntryID, true);
                                this.passiveWriteOffPICReq(ctx, storageOrgUnitID, materialID);
                                break;
                            }
                            String condition = "fSourceBillID = '" + sourceBillID + "' and fSourceEntryID = '" + sourceEntryID + "' and fBillTypeID = '" + billTypeID + "'";
                            List billNumberLst = this.getReqPlanNumbers(ctx, condition);
                            String sql_delReq = "delete from t_mm_RequirementPlan  where " + condition;
                            DbUtil.execute((Context)ctx, (String)sql_delReq);
                            this.recycleNumber(ctx, storageOrgUnitID, billNumberLst);
                        }
                    }
                    break block26;
                }
                if (srcBillType != null && srcBillType.trim().length() != 0 && !"B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(srcBillType) && !"510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(srcBillType)) break block26;
                switch (operationType) {
                    case 103: {
                        String sql = "select fID from T_MM_RequirementPlan where fSourceBillID = '" + sourceBillID + "' and fSourceEntryID = '" + sourceEntryID + "' and fBillTypeID = '" + billTypeID + "'";
                        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
                        if (row != null && row.next()) break;
                        String[] billNumber = this.getNumbers(ctx, storageOrgUnitID, 1);
                        sql = "insert into T_MM_RequirementPlan  \n (fID,fNumber,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,fReqSource,fReqTypeID,fManuStrategyID,fRequireDate\n ,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fNotCntactQty,fBaseNotCntactQty ,fSourceBillID,fSourceBillNum,fSourceEntryID,fSourceEntrySeq,fBillTypeID,fStatus,fCreatorID,FCreateTime,fPlanMode,fControlUnitID,FTrackNumberID,FProjectID,FIsTrackNumFromSrc,FIsDirectTransport,FPlannerID,FProductionDeptID)  values('" + fNewID + "','" + billNumber[0] + "','" + storageOrgUnitID + "',?, \n '" + materialID + "','" + unitID + "','" + baseUntID + "'," + 40 + ",'" + "NcvxPgEcEADgAAiwwKgL09hs+cg=" + "','" + manuStrategyID + "',to_date('" + dateFormat.format(reqDate) + "')," + qty + "," + baseQty + ",0,0," + qty + "," + baseQty + ", \n '" + sourceBillID + "',\n '" + num + "',?," + seq + ",'" + billTypeID + "'," + 10 + ",'" + creatorID + "',{ts'" + createTime + "'}," + planningMode + ",'" + cuID + "',?,?,?,?,?,?)";
                        ReqPlanCntactFacadeControllerBean.execute(ctx, sql, new Object[]{sourceSUID, sourceEntryID, trackNumberID, projectID, new Integer(isTrackNumFromSrc), new Integer(dataVO.getDirectTransport()), dataVO.getPlanner(), dataVO.getProductionDept()});
                        if (isMtdConsumePic) {
                            newDataVO.setId(fNewID);
                            this.writeOffPICReq(ctx, newDataVO);
                        }
                        break;
                    }
                    case 109: {
                        if (isMtdConsumePic) {
                            this.reverseWriteOffReq(ctx, storageOrgUnitID, sourceBillID, sourceEntryID, true);
                            this.passiveWriteOffPICReq(ctx, storageOrgUnitID, materialID);
                            break;
                        }
                        String condition = "fSourceBillID = '" + sourceBillID + "' and fSourceEntryID = '" + sourceEntryID + "' and fBillTypeID = '" + billTypeID + "'";
                        List billNumberLst = this.getReqPlanNumbers(ctx, condition);
                        String sql_delReq = "delete from t_mm_RequirementPlan  where " + condition;
                        DbUtil.execute((Context)ctx, (String)sql_delReq);
                        this.recycleNumber(ctx, storageOrgUnitID, billNumberLst);
                        break;
                    }
                    case 701: {
                        String sql_ifExist;
                        IRowSet rs;
                        if (isMtdConsumePic) {
                            this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
                        }
                        if ((rs = DbUtil.executeQuery((Context)ctx, (String)(sql_ifExist = "select FBaseCntactTotalQty from T_MM_RequirementPlan where fSourceBillID = ? and fSourceEntryID = ? and fBillTypeID = ?"), (Object[])new Object[]{sourceBillID, sourceEntryID, billTypeID})).next() && rs.getBigDecimal("FBaseCntactTotalQty").compareTo(new BigDecimal("0")) > 0) {
                            StringBuffer sql_update = new StringBuffer();
                            sql_update.append("UPDATE T_MM_RequirementPlan ");
                            sql_update.append("SET FQty = ?,FBaseQty = ?,FNotCntactQty = ?,FBaseNotCntactQty = ?,FRequireDate = ?,");
                            sql_update.append("    FStatus = (case when FBaseCntactTotalQty < ? and fclosetype <> 20 then 10");
                            sql_update.append(" else 20 end)");
                            sql_update.append("where FID =?");
                            DbUtil.execute((Context)ctx, (String)sql_update.toString(), (Object[])new Object[]{qty, baseQty, qty, baseQty, reqDate, baseQty, rs.getString("FID")});
                            newDataVO.setId(rs.getString("FID"));
                        } else {
                            String alterCondition = "fSourceBillID = '" + sourceBillID + "' and fSourceEntryID = '" + sourceEntryID + "' and fBillTypeID = '" + billTypeID + "'";
                            List billNumberLst = this.getReqPlanNumbers(ctx, alterCondition);
                            String alterbillNumber = (String)billNumberLst.get(0);
                            String sql_alterdelReq = "delete from t_mm_RequirementPlan  where " + alterCondition;
                            DbUtil.execute((Context)ctx, (String)sql_alterdelReq);
                            String sql = "insert into T_MM_RequirementPlan  \n (fID,fNumber,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,fReqSource,fReqTypeID,fManuStrategyID,fRequireDate\n ,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fNotCntactQty,fBaseNotCntactQty \n ,fSourceBillID,fSourceBillNum,fSourceEntryID,fSourceEntrySeq,fBillTypeID,fStatus,fCreatorID,FCreateTime,fPlanMode,fControlUnitID,fPlanVersionID,FTrackNumberID,FProjectID,FIsTrackNumFromSrc,FIsDirectTransport,FPlannerID,FProductionDeptID) \n values('" + fNewID + "','" + alterbillNumber + "','" + storageOrgUnitID + "',?, \n '" + materialID + "','" + unitID + "','" + baseUntID + "'," + 40 + ",'" + "NcvxPgEcEADgAAiwwKgL09hs+cg=" + "','" + manuStrategyID + "',to_date('" + dateFormat.format(reqDate) + "')," + qty + "," + baseQty + ",0,0," + qty + "," + baseQty + ", \n '" + sourceBillID + "',\n '" + num + "',?," + seq + ",'" + billTypeID + "'," + 10 + ",'" + creatorID + "',{ts'" + createTime + "'}," + planningMode + ",'" + cuID + "',?,?,?,?)";
                            ReqPlanCntactFacadeControllerBean.execute(ctx, sql, new Object[]{ctx, sql, new Object[]{sourceSUID, sourceEntryID, trackNumberID, projectID, new Integer(isTrackNumFromSrc), new Integer(dataVO.getDirectTransport()), dataVO.getPlanner(), dataVO.getProductionDept()}});
                            newDataVO.setId(fNewID);
                        }
                        if (!isMtdConsumePic) break;
                        this.writeOffPICReq(ctx, newDataVO);
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (CloneNotSupportedException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void reductionAssign(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        logger.info((Object)("##########reductionAssign###before" + System.currentTimeMillis()));
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        String srcStorageOrgUnitID = dataVO.getSrcOrgUnitID();
        String billTypeID = dataVO.getBillTypeID();
        String billID = dataVO.getBillID();
        String billEntryID = dataVO.getBillEntryID();
        String manuStrategyID = dataVO.getManuStrategyID();
        int operationType = dataVO.getBizAction();
        String srcBillTypeID = dataVO.getSrcBillTypeID();
        String srcBillEntryID = dataVO.getSrcBillEntryID();
        int reductType = 0;
        try {
            if (manuStrategyID == null || manuStrategyID.trim().length() == 0) {
                return;
            }
            if (dataVO.getQty().compareTo(new BigDecimal(0)) < 0) {
                if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) {
                    this.execMID(ctx, dataVO);
                    return;
                }
                this.rubricWriteOffReq(ctx, dataVO);
            } else {
                if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equalsIgnoreCase(billTypeID) || "Eg5BUQEVEADgAAABwKgOEEY+1VI=".equalsIgnoreCase(billTypeID)) {
                    if (srcStorageOrgUnitID.trim().equals(storageOrgUnitID.trim()) || COOPERATE_PLAN_ORDER_BILL_TYPE_ID.equals(srcBillTypeID)) {
                        return;
                    }
                    this.execMTD(ctx, dataVO);
                    return;
                }
                if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) {
                    this.execMID(ctx, dataVO);
                    return;
                }
                if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equalsIgnoreCase(billTypeID)) {
                    if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equalsIgnoreCase(srcBillTypeID)) {
                        if ("NUnM+gEcEADgAA3gwKgL09g0uEU=".equals(manuStrategyID) || "fpPxtypCS/ihJ30GjB/UJtg0uEU=".equals(manuStrategyID)) {
                            reductType = 2;
                        } else if ("fpPxtypCS/ihJ30GjB/UJtg0uEU=".equals(manuStrategyID) && this.getIsCntPID(ctx, storageOrgUnitID, manuStrategyID, billTypeID)) {
                            reductType = 1;
                        } else if ("GE2FIa4GQ6uhdx0RDGuibtg0uEU=".equals(manuStrategyID) && this.getIsCntPID(ctx, storageOrgUnitID, manuStrategyID, billTypeID)) {
                            reductType = 3;
                        }
                    } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equalsIgnoreCase(srcBillTypeID)) {
                        Map srcMap = this.getSourceBillInfo(ctx, srcBillTypeID, srcBillEntryID);
                        reductType = 4;
                        if (srcMap.get("SourceBillTypeID") != null && COOPERATE_PLAN_ORDER_BILL_TYPE_ID.equals(srcMap.get("SourceBillTypeID"))) {
                            dataVO.setSrcBillTypeID(COOPERATE_PLAN_ORDER_BILL_TYPE_ID);
                            dataVO.setSrcBillID((String)srcMap.get("SourceBillID"));
                            dataVO.setSrcBillEntryID((String)srcMap.get("SourceBillEntryID"));
                        }
                    } else if (("fpPxtypCS/ihJ30GjB/UJtg0uEU=".equals(manuStrategyID) || "GE2FIa4GQ6uhdx0RDGuibtg0uEU=".equals(manuStrategyID)) && this.getIsCntPID(ctx, storageOrgUnitID, manuStrategyID, billTypeID)) {
                        reductType = 3;
                    } else if ("NUnM+gEcEADgAA3cwKgL09g0uEU=".equals(manuStrategyID) && this.getIsCntPID(ctx, storageOrgUnitID, manuStrategyID, billTypeID)) {
                        reductType = 1;
                    }
                } else if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equalsIgnoreCase(billTypeID)) {
                    Map srcMap = new HashMap();
                    if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equalsIgnoreCase(srcBillTypeID)) {
                        srcMap = this.getSourceBillInfo(ctx, srcBillTypeID, srcBillEntryID);
                    }
                    reductType = 4;
                    if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equalsIgnoreCase(srcBillTypeID) && srcMap.get("SourceBillTypeID") != null && srcMap.get("SourceBillTypeID").equals(COOPERATE_PLAN_ORDER_BILL_TYPE_ID)) {
                        dataVO.setSrcBillTypeID(COOPERATE_PLAN_ORDER_BILL_TYPE_ID);
                        dataVO.setSrcBillID((String)srcMap.get("SourceBillID"));
                        dataVO.setSrcBillEntryID((String)srcMap.get("SourceBillEntryID"));
                    }
                } else if (this.getIsCntPID(ctx, storageOrgUnitID, manuStrategyID, billTypeID)) {
                    reductType = "GE2FIa4GQ6uhdx0RDGuibtg0uEU=".equals(manuStrategyID) || "fpPxtypCS/ihJ30GjB/UJtg0uEU=".equals(manuStrategyID) ? 3 : 1;
                }
                if (reductType == 1) {
                    if (operationType == 103) {
                        this.writeOffPIDReq(ctx, dataVO);
                    } else if (operationType == 109) {
                        this.reverseWriteOffReq(ctx, storageOrgUnitID, billID, billEntryID, true);
                    }
                } else if (reductType == 3) {
                    if (operationType == 103) {
                        this.writeOffPIOReq(ctx, dataVO);
                    } else if (operationType == 109) {
                        this.reverseWriteOffReq(ctx, storageOrgUnitID, billID, billEntryID, true);
                    }
                } else if (reductType == 2) {
                    this.writeOffSIDReq(ctx, dataVO);
                } else if (reductType == 4) {
                    if (operationType == 103) {
                        this.writeOffReqTransBySrcBill(ctx, dataVO);
                    } else if (operationType == 109) {
                        this.reverseWriteOffReq(ctx, storageOrgUnitID, billID, billEntryID, true);
                    }
                }
            }
            logger.info((Object)("##########reductionAssign###end" + System.currentTimeMillis()));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean getIsCntPID(Context ctx, String storageOrgUnitID, String manuStrtgID, String billTypeID) throws BOSException, SQLException, EASBizException {
        boolean rtn = false;
        String sql_qryCntSet = "select fIsCounteractPID from T_MM_CounteractSet  where fStorageOrgUnitID = '" + storageOrgUnitID + "' and fManuStrategyID = '" + manuStrtgID + "' and fBillTypeID = '" + billTypeID + "'";
        IRowSet cntRow = DbUtil.executeQuery((Context)ctx, (String)sql_qryCntSet);
        if (cntRow.next()) {
            rtn = cntRow.getBoolean("fIsCounteractPID");
        } else {
            String sql_dftCntSet = "select fIsCounteractPID from T_MM_CounteractSet  where fStorageOrgUnitID is null and fManuStrategyID = '" + manuStrtgID + "' and fBillTypeID = '" + billTypeID + "'";
            IRowSet dftcntRow = DbUtil.executeQuery((Context)ctx, (String)sql_dftCntSet);
            if (dftcntRow.next()) {
                rtn = dftcntRow.getBoolean("fIsCounteractPID");
            }
        }
        return rtn;
    }

    private Map getSourceBillInfo(Context ctx, String billTypeID, String entryID) throws BOSException, SQLException {
        HashMap<String, String> hsMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FSourceBillTypeID,FSourceBillID,FSourceBillEntryID FROM ");
        if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equalsIgnoreCase(billTypeID)) {
            sql.append(" t_im_stocktransferbillentry");
        } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equalsIgnoreCase(billTypeID)) {
            sql.append(" t_im_transferorderbillentry");
        } else {
            return hsMap;
        }
        sql.append(" WHERE FID = '" + entryID + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            hsMap.put("SourceBillTypeID", rs.getString("FSourceBillTypeID"));
            hsMap.put("SourceBillID", rs.getString("FSourceBillID"));
            hsMap.put("SourceBillEntryID", rs.getString("FSourceBillEntryID"));
        }
        return hsMap;
    }

    protected void writeOffPIDReq(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        String billID = dataVO.getBillID();
        String billNum = dataVO.getBillNumber();
        String billEntryID = dataVO.getBillEntryID();
        String billTypeID = dataVO.getBillTypeID();
        String materialID = dataVO.getMaterialID();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        BigDecimal cntQty = dataVO.getQty();
        BigDecimal baseCntQty = dataVO.getBaseQty();
        String manuStrategyID = dataVO.getManuStrategyID();
        int offsetMode = dataVO.getOffsetMode();
        int forwardDaysOffset = dataVO.getForwardDaysOffset();
        int backwardDaysOffset = dataVO.getBackwardDaysOffset();
        Date reqDate = dataVO.getRequireDate();
        String sql_select = "  select FID,fRequireDate,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fMaterialID ";
        String sql_from = " from T_MM_RequirementPlan ";
        String sql_where = "  where fStorageOrgUnitID = '" + storageOrgUnitID + "' and fMaterialID = '" + materialID + "' and fManuStrategyID = '" + manuStrategyID + "' and fReqTypeID = '" + "NcvxPgEcEADgAAiowKgL09hs+cg=" + "' and fStatus =  " + 10 + " and fQty>fCntactTotalQty";
        String strOrderBy = " order by fRequireDate";
        String sql_queryReq = "";
        String reductionMode = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"ReductionMode");
        if ("0".equals(reductionMode)) {
            sql_queryReq = sql_select + sql_from + sql_where + strOrderBy + " ASC ";
        } else if ("1".equals(reductionMode)) {
            sql_queryReq = this.getCntFilter(ctx, storageOrgUnitID, reqDate, offsetMode, forwardDaysOffset, backwardDaysOffset, sql_select, sql_from, sql_where);
        } else if ("2".equals(reductionMode)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(reqDate);
            sql_where = sql_where + " and year(fRequireDate) = " + calendar.get(1) + "  and month(fRequireDate) = " + (calendar.get(2) + 1);
            sql_queryReq = sql_select + sql_from + sql_where + strOrderBy;
        }
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)sql_queryReq);
        int seq = 1;
        try {
            while (reqRow.next()) {
                Object[] params;
                String sql_updatePIC;
                String pidReqID = reqRow.getString("FID");
                BigDecimal pidQty = reqRow.getBigDecimal("fQty");
                BigDecimal basePidQty = reqRow.getBigDecimal("fBaseQty");
                BigDecimal pidCntactQty = reqRow.getBigDecimal("fCntactTotalQty");
                BigDecimal basePidCntactQty = reqRow.getBigDecimal("fBaseCntactTotalQty");
                StringBuffer sql_recordWriteOffRelation = new StringBuffer();
                sql_recordWriteOffRelation.append("insert into T_MM_ReqCounteractRelation ");
                sql_recordWriteOffRelation.append("(FID,FSourceID,FSourceEntryID,FDestID,FBillTypeID,FQty,FBaseQty,FUnitID,FBaseUnitID,FSeq,FSourceNumber)");
                sql_recordWriteOffRelation.append(" values(?,?,?,?,?,?,?,?,?,?,?)");
                if (cntQty.compareTo(pidQty.subtract(pidCntactQty)) >= 0) {
                    sql_updatePIC = "update T_MM_RequirementPlan set fCntactTotalQty = fQty,fBaseCntactTotalQty= fBaseQty,fStatus = 20 where fID = '" + pidReqID + "'";
                    DbUtil.execute((Context)ctx, (String)sql_updatePIC);
                    params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, pidReqID, billTypeID, pidQty.subtract(pidCntactQty), basePidQty.subtract(basePidCntactQty), unitID, baseUnitID, new Integer(seq++), billNum};
                    DbUtil.execute((Context)ctx, (String)sql_recordWriteOffRelation.toString(), (Object[])params);
                    ++seq;
                    cntQty = cntQty.subtract(pidQty.subtract(pidCntactQty));
                    baseCntQty = baseCntQty.subtract(basePidQty.subtract(basePidCntactQty));
                    continue;
                }
                sql_updatePIC = "update T_MM_RequirementPlan set fCntactTotalQty= fCntactTotalQty+" + cntQty + ",fBaseCntactTotalQty= fBaseCntactTotalQty+" + baseCntQty + " where fID = '" + pidReqID + "'";
                DbUtil.execute((Context)ctx, (String)sql_updatePIC);
                params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, pidReqID, billTypeID, cntQty, baseCntQty, unitID, baseUnitID, new Integer(seq++), billNum};
                DbUtil.execute((Context)ctx, (String)sql_recordWriteOffRelation.toString(), (Object[])params);
                break;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void writeOffPIOReq(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        String billID = dataVO.getBillID();
        String billNum = dataVO.getBillNumber();
        String billEntryID = dataVO.getBillEntryID();
        String billTypeID = dataVO.getBillTypeID();
        String materialID = dataVO.getMaterialID();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        BigDecimal cntQty = dataVO.getQty();
        BigDecimal baseCntQty = dataVO.getBaseQty();
        String manuStrategyID = dataVO.getManuStrategyID();
        String projectID = dataVO.getProjectID();
        String trackNumberID = dataVO.getTrackNumberID();
        StringBuffer sql_getWriteOffPIOReq = new StringBuffer();
        sql_getWriteOffPIOReq.append(" SELECT fID,fRequireDate,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fMaterialID ");
        sql_getWriteOffPIOReq.append(" FROM T_MM_RequirementPlan ");
        sql_getWriteOffPIOReq.append(" WHERE FStorageOrgUnitID = '" + storageOrgUnitID + "'");
        sql_getWriteOffPIOReq.append("\tand FMaterialID = '" + materialID + "'");
        sql_getWriteOffPIOReq.append("\tand FManuStrategyID = '" + manuStrategyID + "'");
        sql_getWriteOffPIOReq.append("\tand FReqTypeID = 's0fDJAEoEADgAABCfwAAAdhs+cg='");
        sql_getWriteOffPIOReq.append("\tand FStatus =  10");
        sql_getWriteOffPIOReq.append("\tand FQty > FCntactTotalQty ");
        if (projectID != null && projectID.trim().length() > 0) {
            sql_getWriteOffPIOReq.append("\tand FProjectID = '" + projectID + "'");
        } else {
            sql_getWriteOffPIOReq.append("\tand FProjectID is null ");
        }
        if (trackNumberID != null && trackNumberID.trim().length() > 0) {
            sql_getWriteOffPIOReq.append("\tand FTrackNumberID = '" + trackNumberID + "'");
        } else {
            sql_getWriteOffPIOReq.append("\tand FTrackNumberID is null ");
        }
        sql_getWriteOffPIOReq.append(" ORDER BY fRequireDate");
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)sql_getWriteOffPIOReq.toString());
        int seq = 1;
        try {
            while (reqRow.next()) {
                Object[] params;
                String sql_updatePIC;
                String pidReqID = reqRow.getString("fID");
                BigDecimal pidQty = reqRow.getBigDecimal("fQty");
                BigDecimal basePidQty = reqRow.getBigDecimal("fBaseQty");
                BigDecimal pidCntactQty = reqRow.getBigDecimal("fCntactTotalQty");
                BigDecimal basePidCntactQty = reqRow.getBigDecimal("fBaseCntactTotalQty");
                StringBuffer sql_recordWriteOffRelation = new StringBuffer();
                sql_recordWriteOffRelation.append("insert into T_MM_ReqCounteractRelation ");
                sql_recordWriteOffRelation.append("(FID,FSourceID,FSourceEntryID,FDestID,FBillTypeID,FQty,FBaseQty,FUnitID,FBaseUnitID,FSeq,FSourceNumber)");
                sql_recordWriteOffRelation.append(" values(?,?,?,?,?,?,?,?,?,?,?)");
                if (cntQty.compareTo(pidQty.subtract(pidCntactQty)) >= 0) {
                    sql_updatePIC = "update T_MM_RequirementPlan set fCntactTotalQty = fQty,fBaseCntactTotalQty= fBaseQty,fStatus = 20 where fID = '" + pidReqID + "'";
                    DbUtil.execute((Context)ctx, (String)sql_updatePIC);
                    params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, pidReqID, billTypeID, pidQty.subtract(pidCntactQty), basePidQty.subtract(basePidCntactQty), unitID, baseUnitID, new Integer(seq++), billNum};
                    DbUtil.execute((Context)ctx, (String)sql_recordWriteOffRelation.toString(), (Object[])params);
                    cntQty = cntQty.subtract(pidQty.subtract(pidCntactQty));
                    baseCntQty = baseCntQty.subtract(basePidQty.subtract(basePidCntactQty));
                    ++seq;
                    continue;
                }
                sql_updatePIC = "update T_MM_RequirementPlan set fCntactTotalQty= fCntactTotalQty+" + cntQty + ",fBaseCntactTotalQty= fBaseCntactTotalQty+" + baseCntQty + " where fID = '" + pidReqID + "'";
                DbUtil.execute((Context)ctx, (String)sql_updatePIC);
                params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, pidReqID, billTypeID, cntQty, baseCntQty, unitID, baseUnitID, new Integer(seq++), billNum};
                DbUtil.execute((Context)ctx, (String)sql_recordWriteOffRelation.toString(), (Object[])params);
                break;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void rubricWriteOffReq(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        Connection conn = null;
        Statement batchStatement = null;
        String billTypeID = dataVO.getBillTypeID();
        String billID = dataVO.getBillID();
        String billNum = dataVO.getBillNumber();
        String billEntryID = dataVO.getBillEntryID();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        BigDecimal qty = dataVO.getQty();
        BigDecimal baseQty = dataVO.getBaseQty();
        String srcOfSourceBillID = dataVO.getSrcBillID();
        String srcOfSourceEntryID = dataVO.getSrcBillEntryID();
        qty = qty.abs();
        baseQty = baseQty.abs();
        String sql_getCntRelation = "SELECT FID,FDestID,FQty,FBaseQty,FSeq  FROM  T_MM_ReqCounteractRelation  WHERE FSourceID = ? and FSourceEntryID = ?   ORDER BY FSeq DESC";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql_getCntRelation, (Object[])new Object[]{srcOfSourceBillID, srcOfSourceEntryID});
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.createStatement();
            int seq = 1;
            while (row.next()) {
                Object[] params;
                String destID = row.getString("FDestID");
                BigDecimal cntactQty = row.getBigDecimal("FQty");
                BigDecimal cntactBaseQty = row.getBigDecimal("FBaseQty");
                StringBuffer sql_recordWriteOffRelation = new StringBuffer();
                sql_recordWriteOffRelation.append("insert into T_MM_ReqCounteractRelation");
                sql_recordWriteOffRelation.append("(FID,FSourceID,FSourceEntryID,FDestID,FBillTypeID,FQty,FBaseQty,FUnitID,FBaseUnitID,FSeq,FSourceNumber)");
                sql_recordWriteOffRelation.append(" values(?,?,?,?,?,?,?,?,?,?,?)");
                if (qty.compareTo(cntactQty) >= 0) {
                    String sql_uptReqPlan = "update T_MM_Requirementplan set fCntactTotalQty = fCntactTotalQty - " + cntactQty + ",fBaseCntactTotalQty = fBaseCntactTotalQty - " + cntactBaseQty + ",fStatus = case when(fQty - fCntactTotalQty + " + cntactQty + ")>0 then " + 10 + " else " + 20 + " end where fID = '" + destID + "'";
                    batchStatement.addBatch(sql_uptReqPlan);
                    params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, row.getString("FDestID"), billTypeID, cntactQty.negate(), cntactBaseQty.negate(), unitID, baseUnitID, new Integer(seq++), billNum};
                    DbUtil.execute((Context)ctx, (String)sql_recordWriteOffRelation.toString(), (Object[])params);
                    qty = qty.subtract(cntactQty);
                    baseQty = baseQty.subtract(cntactBaseQty);
                    continue;
                }
                String sql_uptReqplan = "update T_MM_RequirementPlan set fCntactTotalQty = fCntactTotalQty - " + qty + ",fBaseCntactTotalQty = fBaseCntactTotalQty - " + baseQty + ",fStatus = case when(fQty - fCntactTotalQty + " + qty + ")>0 then " + 10 + " else " + 20 + " end where fID = '" + destID + "'";
                batchStatement.addBatch(sql_uptReqplan);
                params = new Object[]{BOSUuid.create((String)"D02F7535").toString(), billID, billEntryID, row.getString("FDestID"), billTypeID, qty.negate(), qty.negate(), unitID, baseUnitID, new Integer(seq++), billNum};
                DbUtil.execute((Context)ctx, (String)sql_recordWriteOffRelation.toString(), (Object[])params);
                break;
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    protected void reverseWriteOffReq(Context ctx, String storageOrgUnitID, String billID, String billEntryID, boolean isDeleteReq) throws BOSException, EASBizException {
        StringBuffer sql_updateCntactQty = new StringBuffer();
        sql_updateCntactQty.append(" UPDATE T_MM_RequirementPlan as p SET (FCntactTotalQty,FBaseCntactTotalQty,FStatus) = ");
        sql_updateCntactQty.append("(SELECT case when p.FCntactTotalQty -t1.fqty < 0 then 0 else p.FCntactTotalQty -t1.fqty end, ");
        sql_updateCntactQty.append(" case when p.FBaseCntactTotalQty - t1.fbaseqty < 0 then 0 else p.FBaseCntactTotalQty -t1.fbaseqty end, ");
        sql_updateCntactQty.append(" case when p.fQty - (p.FCntactTotalQty -t1.fqty)>0 and fclosetype <> 20 then 10 else 20 end ");
        sql_updateCntactQty.append(" FROM");
        sql_updateCntactQty.append("   (select r.FDestID, sum(r.fBaseQty) as fbaseqty , sum(r.fQty) as fqty ");
        sql_updateCntactQty.append("    from T_MM_ReqCounteractRelation as r ");
        sql_updateCntactQty.append("    WHERE r.fSourceID = '" + billID + "' and r.fSourceEntryID = '" + billEntryID + "'");
        sql_updateCntactQty.append("    group by  r.FDestID) as t1 ");
        sql_updateCntactQty.append("  WHERE t1.FDestID = p.fid )");
        try {
            DbUtil.execute((Context)ctx, (String)sql_updateCntactQty.toString());
            String sql_delCntRela = "delete from T_MM_ReqCounteractRelation where FSourceID = ? and FSourceEntryID = ?";
            DbUtil.execute((Context)ctx, (String)sql_delCntRela, (Object[])new Object[]{billID, billEntryID});
            if (isDeleteReq) {
                String condition = "fSourceBillID = '" + billID + "' and fSourceEntryID = '" + billEntryID + "'";
                List billNumberLst = this.getReqPlanNumbers(ctx, condition);
                String sql_delReq = "delete from t_mm_RequirementPlan  where " + condition;
                DbUtil.execute((Context)ctx, (String)sql_delReq);
                this.recycleNumber(ctx, storageOrgUnitID, billNumberLst);
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void writeOffSIDReq(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String orgUnitID = dataVO.getStorageOrgUnitID();
        String billTypeID = dataVO.getBillTypeID();
        String billNum = dataVO.getBillNumber();
        String billID = dataVO.getBillID();
        String billEntryID = dataVO.getBillEntryID();
        int seq = dataVO.getBillEntrySeq();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        BigDecimal qty = dataVO.getQty();
        BigDecimal baseQty = dataVO.getBaseQty();
        String srcBillTypeID = dataVO.getSrcBillTypeID();
        String srcBillID = dataVO.getSrcBillID();
        String srcBillEntryID = dataVO.getSrcBillEntryID();
        int operationType = dataVO.getBizAction();
        try {
            String sql_qrySaleOrderEntry;
            IRowSet row;
            if (srcBillID != null && srcBillID.trim().length() > 0 && srcBillEntryID != null && srcBillEntryID.trim().length() > 0 && (row = DbUtil.executeQuery((Context)ctx, (String)(sql_qrySaleOrderEntry = " select case when s.fTotalIssueQty>s.fQty  then round((s.fQty*mu1.fBaseConvsRate/mu2.fBaseConvsRate),mu2.FQtyPrecision) else round((s.fTotalIssueQty*mu1.fBaseConvsRate/mu2.fBaseConvsRate),mu2.FQtyPrecision)  end as fQty ,case when (s.fTotalIssueQty+s.fLockQty)>s.fQty   then s.fBaseQty   else s.fLockBaseQty+s.fTotalIssueBaseQty   end as fBaseQty from t_sd_SaleOrderEntry s,t_bd_MaterialPlan m,t_bd_multiMeasureUnit mu1,t_bd_multiMeasureUnit mu2 where s.fStorageOrgUnitID = '" + orgUnitID + "' and s.fParentID = '" + srcBillID + "' and s.fID = '" + srcBillEntryID + "' and s.fMaterialID = m.fMaterialID  and s.fStorageOrgUnitID = m.FOrgUnit and s.fMaterialID = mu1.fMaterialID and s.fUnitID = mu1.fMeasureUnitID  and m.fMaterialID = mu2.fMaterialID and m.fProductUnitID = mu2.fMeasureUnitID"))).next()) {
                BigDecimal totalQty = row.getBigDecimal("fQty");
                BigDecimal totalBaseQty = row.getBigDecimal("fBaseQty");
                String sql_getReqRecord = "select FID from t_mm_requirementplan  where fSourceBillID = '" + srcBillID + "' and fSourceEntryID = '" + srcBillEntryID + "' and fBillTypeID = '" + srcBillTypeID + "'";
                IRowSet cntRow = DbUtil.executeQuery((Context)ctx, (String)sql_getReqRecord);
                if (cntRow.next()) {
                    String FReqPlanID = cntRow.getString("FID");
                    StringBuffer sql_uptReqPlan = new StringBuffer();
                    sql_uptReqPlan.append("update t_mm_RequirementPlan set fCntactTotalQty = ?,fBaseCntactTotalQty=?,");
                    sql_uptReqPlan.append(" fStatus = ");
                    sql_uptReqPlan.append(" (case when(fQty-(?))>0 and  fclosetype <> 20 then ? else ? end)");
                    sql_uptReqPlan.append(" where FID = ?");
                    DbUtil.execute((Context)ctx, (String)sql_uptReqPlan.toString(), (Object[])new Object[]{totalQty, totalBaseQty, totalQty, new Integer(10), new Integer(20), FReqPlanID});
                    if (operationType == 103) {
                        String sql_insertCntactRelation = "insert into T_MM_ReqCounteractRelation(fID,fSourceID,fSourceEntryID,fDestID,fBillTypeID,fQty,fBaseQty,fUnitID,fBaseUnitID,fSeq,FSourceNumber ) values(newbosid('D02F7535'),'" + billID + "','" + billEntryID + "','" + FReqPlanID + "','" + billTypeID + "'," + qty + "," + baseQty + ",'" + unitID + "','" + baseUnitID + "'," + seq + ",'" + billNum + "')";
                        DbUtil.execute((Context)ctx, (String)sql_insertCntactRelation);
                    } else if (operationType == 109) {
                        String sql_deleteCntactRelation = " delete from T_MM_ReqCounteractRelation  where fSourceID = '" + billID + "' \nand fSourceEntryID = '" + billEntryID + "' \n and fBillTypeID = '" + billTypeID + "'\n";
                        DbUtil.execute((Context)ctx, (String)sql_deleteCntactRelation);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void writeOffReqTransBySrcBill(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String billTypeID = dataVO.getBillTypeID();
        String billNum = dataVO.getBillNumber();
        String billID = dataVO.getBillID();
        String billEntryID = dataVO.getBillEntryID();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        BigDecimal qty = dataVO.getQty();
        BigDecimal baseQty = dataVO.getBaseQty();
        String srcBillTypeID = dataVO.getSrcBillTypeID();
        String srcBillID = dataVO.getSrcBillID();
        String srcBillEntryID = dataVO.getSrcBillEntryID();
        try {
            String sql_getReqRecord;
            IRowSet cntRow;
            if (srcBillID != null && srcBillID.trim().length() > 0 && srcBillEntryID != null && srcBillEntryID.trim().length() > 0 && (cntRow = DbUtil.executeQuery((Context)ctx, (String)(sql_getReqRecord = "select FID from t_mm_requirementplan  where fSourceBillID = '" + srcBillID + "' and fSourceEntryID = '" + srcBillEntryID + "' and fBillTypeID = '" + srcBillTypeID + "'"))).next()) {
                String FReqPlanID = cntRow.getString("FID");
                String sql_uptReqPlan = "update t_mm_RequirementPlan set fCntactTotalQty = fCntactTotalQty + ?,fBaseCntactTotalQty = fBaseCntactTotalQty + ?, FStatus = (case when fQty > fCntactTotalQty + ? and fclosetype <> 20  then 10 else 20 end) where FID = '" + FReqPlanID + "'";
                DbUtil.execute((Context)ctx, (String)sql_uptReqPlan, (Object[])new Object[]{qty, baseQty, qty});
                String sql_insertCntactRelation = "insert into T_MM_ReqCounteractRelation(fID,fSourceID,fSourceEntryID,fDestID,fBillTypeID,fQty,fBaseQty,fUnitID,fBaseUnitID,fSeq,FSourceNumber ) values(newbosid('D02F7535'),'" + billID + "','" + billEntryID + "','" + FReqPlanID + "','" + billTypeID + "'," + qty + "," + baseQty + ",'" + unitID + "','" + baseUnitID + "'," + 1 + ",'" + billNum + "')";
                DbUtil.execute((Context)ctx, (String)sql_insertCntactRelation);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void execSop(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        String fID = dataVO.getId();
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        String cuID = dataVO.getCuID();
        if (!this.isCodeRuleExist(ctx, storageOrgUnitID)) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        String creatorId = dataVO.getCreatorID();
        Timestamp fcreateTime = dataVO.getCreateTime();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String createTime = sf.format(fcreateTime);
        StringBuffer sql_queryPara = new StringBuffer();
        StringBuffer sql_delReq = new StringBuffer();
        StringBuffer sql_delcondition = new StringBuffer();
        StringBuffer sql_uptReqOfSOP = new StringBuffer();
        StringBuffer sql_instReqFrmSOP = new StringBuffer();
        String strStartDate = "";
        String strEndDate = "";
        String ifDelete = "";
        sql_queryPara.append("select fParamName,fParamValue from  T_MM_ReqPlanTmpParam");
        sql_queryPara.append(" where FParent ='").append(fID).append("'");
        IRowSet paraRow = DbUtil.executeQuery((Context)ctx, (String)sql_queryPara.toString());
        try {
            List billNumberLst;
            while (paraRow.next()) {
                if (PARAM_STARTDATE.equalsIgnoreCase(paraRow.getString("fParamName").trim())) {
                    strStartDate = paraRow.getString("fParamValue").trim();
                    continue;
                }
                if (PARAM_ENDDATE.equalsIgnoreCase(paraRow.getString("fParamName").trim())) {
                    strEndDate = paraRow.getString("fParamValue").trim();
                    continue;
                }
                if (!PARAM_DelBeforRequire.equalsIgnoreCase(paraRow.getString("fParamName").trim())) continue;
                ifDelete = paraRow.getString("fParamValue").trim();
            }
            String paramValue = (String)this.paramMap.get(storageOrgUnitID + "SOP_TRANSFER_AVERAGE");
            if (paramValue == null) {
                paramValue = "false";
            }
            if (paramValue.equalsIgnoreCase("true") || paramValue.equals("1")) {
                sql_delReq.append("delete from t_mm_RequirementPlan where ");
                sql_delcondition.append(" fid in(");
                sql_delcondition.append(" select rp.fid from T_MM_SopTransDataDetail as sop,T_MM_RequirementPlan as rp");
                sql_delcondition.append(" where sop.FParentID = '" + fID + "'");
                sql_delcondition.append(" and rp.FStorageOrgUnitID = '" + storageOrgUnitID + "'");
                sql_delcondition.append(" and sop.fMaterialID = rp.fMaterialID");
                sql_delcondition.append(" and sop.fQty = 0 and rp.fCntactTotalQty = 0");
                sql_delcondition.append(" and sop.fDate = rp.fRequireDate ");
                sql_delcondition.append(" and rp. fReqSource =").append("30)");
                billNumberLst = this.getReqPlanNumbers(ctx, sql_delcondition.toString());
                DbUtil.execute((Context)ctx, (String)sql_delReq.append(sql_delcondition).toString());
                this.recycleNumber(ctx, storageOrgUnitID, billNumberLst);
                sql_uptReqOfSOP.append("Update T_MM_RequirementPlan as a ");
                sql_uptReqOfSOP.append("set (fQty,fBaseQty,fStatus)= ");
                sql_uptReqOfSOP.append("(select");
                sql_uptReqOfSOP.append(" case when M.fQty > a.fCntactTotalQty then M.fQty else a.fCntactTotalQty end,");
                sql_uptReqOfSOP.append(" case when M.fBaseQty > a.fBaseCntactTotalQty then M.fBaseQty else a.fBaseCntactTotalQty end,");
                sql_uptReqOfSOP.append(" case when M.fQty > a.fCntactTotalQty then ");
                sql_uptReqOfSOP.append(10);
                sql_uptReqOfSOP.append(" else ");
                sql_uptReqOfSOP.append(20);
                sql_uptReqOfSOP.append(" end");
                sql_uptReqOfSOP.append(" from T_MM_SopTransDataDetail as M ");
                sql_uptReqOfSOP.append(" where M.FParentID = '" + fID + "'");
                sql_uptReqOfSOP.append(" and a.fStorageOrgUnitID = '" + storageOrgUnitID + "'");
                sql_uptReqOfSOP.append(" and M.fStorageOrgUnitID = '" + storageOrgUnitID + "'");
                sql_uptReqOfSOP.append(" and a.fMaterialID = M.fMaterialID");
                sql_uptReqOfSOP.append(" and M.fDate = a.fRequireDate");
                sql_uptReqOfSOP.append(" and a.fReqSource=").append(30);
                sql_uptReqOfSOP.append(")");
                DbUtil.execute((Context)ctx, (String)sql_uptReqOfSOP.toString());
                sql_instReqFrmSOP.append("insert into T_MM_RequirementPlan ");
                sql_instReqFrmSOP.append("(fID,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,fReqSource,fReqTypeID,fManuStrategyID,fRequireDate");
                sql_instReqFrmSOP.append(",fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fStatus,fPlanMode,fControlUnitID,FCreatorID,FCreateTime,FSourceBillID,FIsDirectTransport");
                sql_instReqFrmSOP.append(",FPlannerID,FProductionDeptID) ");
                sql_instReqFrmSOP.append("select newbosid('D86AF5B7'),m.fStorageOrgUnitID,'").append(dataVO.getSrcOrgUnitID()).append("',m.fMaterialID,m.fUnitID,m.fBaseUnitID");
                sql_instReqFrmSOP.append(",30");
                sql_instReqFrmSOP.append(",case when p.fManufactureStrategyID='").append("NUnM+gEcEADgAA3gwKgL09g0uEU=");
                sql_instReqFrmSOP.append("'then '").append("NcvxPgEcEADgAAiqwKgL09hs+cg=").append("' else  '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("' end");
                sql_instReqFrmSOP.append(",p.fManufactureStrategyID,TO_DATE(SUBSTRING(TO_CHAR(m.fDate, 'YYYY-MM-DD'),1,10) || ' 00:00:00'),m.fQty");
                sql_instReqFrmSOP.append(",m.fBaseQty,0,0,");
                sql_instReqFrmSOP.append(10).append(",p.FPlanningMode,'" + cuID + "'");
                sql_instReqFrmSOP.append(",'" + creatorId + "',{ts'" + createTime + "'}");
                sql_instReqFrmSOP.append(",'" + fID + "'");
                sql_instReqFrmSOP.append(", case when p.FIssMode = 11050 then 1 else 0 end");
                sql_instReqFrmSOP.append(", p.FPlanner");
                sql_instReqFrmSOP.append(", p.FDutyDepartment");
                sql_instReqFrmSOP.append(" from T_MM_SopTransDataDetail as m,");
                sql_instReqFrmSOP.append("t_bd_materialplan as p");
                sql_instReqFrmSOP.append(" where m.FParentID = '" + fID + "'");
                sql_instReqFrmSOP.append(" and m.fQty > 0 ");
                sql_instReqFrmSOP.append(" and m.fMaterialID = p.fMaterialID and m.fStorageOrgUnitID = p.FOrgUnit ");
                sql_instReqFrmSOP.append(" and p.fManufactureStrategyID is not null ");
                sql_instReqFrmSOP.append(" and not exists (select 1");
                sql_instReqFrmSOP.append(" from T_MM_RequirementPlan as r");
                sql_instReqFrmSOP.append(" where r.fStorageOrgUnitID = '" + storageOrgUnitID + "'");
                sql_instReqFrmSOP.append(" and r.fReqSource = ").append(30);
                sql_instReqFrmSOP.append(" and r.fMaterialID = m.fMaterialID");
                sql_instReqFrmSOP.append(" and to_char(r.fRequireDate,'yyyy-mm-dd')= to_char(m.fDate,'yyyy-mm-dd')");
                sql_instReqFrmSOP.append(")");
                DbUtil.execute((Context)ctx, (String)sql_instReqFrmSOP.toString());
            } else {
                sql_delReq.append("delete from t_mm_RequirementPlan where");
                sql_delcondition.append("  fStorageOrgUnitID = '" + storageOrgUnitID + "'");
                sql_delcondition.append(" and fRequireDate >= to_date('").append(strStartDate + "')");
                sql_delcondition.append(" and fRequireDate<= to_date('").append(strEndDate).append("')");
                sql_delcondition.append(" and fReqSource = ").append(30);
                sql_delcondition.append(" and fMaterialID in (select distinct fMaterialID from T_MM_SopTransDataDetail");
                sql_delcondition.append(" where FParentID = '" + fID + "') ");
                sql_delcondition.append(" and fCntactTotalQty = 0");
                billNumberLst = this.getReqPlanNumbers(ctx, sql_delcondition.toString());
                DbUtil.execute((Context)ctx, (String)sql_delReq.append(sql_delcondition).toString());
                this.recycleNumber(ctx, storageOrgUnitID, billNumberLst);
                if ("true".equalsIgnoreCase(ifDelete)) {
                    StringBuffer sqlBuffer_updateQtyAndStatus = new StringBuffer();
                    sqlBuffer_updateQtyAndStatus.append(" update T_MM_RequirementPlan as rp set FQTY = fCntactTotalQty,");
                    sqlBuffer_updateQtyAndStatus.append(" FBaseQty = fBaseCntactTotalQty,FStatus = 20");
                    sqlBuffer_updateQtyAndStatus.append(" where fStorageOrgUnitID = '").append(storageOrgUnitID).append("' and fRequireDate >= to_date('").append(strStartDate + "')");
                    sqlBuffer_updateQtyAndStatus.append(" and fRequireDate<= to_date('").append(strEndDate).append("')");
                    sqlBuffer_updateQtyAndStatus.append(" and fReqSource = ").append(30);
                    sqlBuffer_updateQtyAndStatus.append(" and fMaterialID in (select distinct fMaterialID from T_MM_SopTransDataDetail");
                    sqlBuffer_updateQtyAndStatus.append(" where FParentID = '" + fID + "') ");
                    DbUtil.execute((Context)ctx, (String)sqlBuffer_updateQtyAndStatus.toString());
                    String Tmp_MaterialQty = "";
                    String createSql = "create table rsTmpTable(fStorageOrgUnitID VARCHAR(44),FMaterialID VARCHAR(44),FPeriod VARCHAR(44),  FQty NUMERIC(21,8) DEFAULT 0 NOT NULL,FBaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL)";
                    Tmp_MaterialQty = KsqlUtil.createTempTable((Context)ctx, (String)createSql);
                    StringBuffer sql_getCntQty = new StringBuffer();
                    sql_getCntQty.append(" insert into " + Tmp_MaterialQty + "(FStorageOrgUnitID,FMaterialID,FPeriod,FQty,FBaseQty)");
                    sql_getCntQty.append(" select sop.FStorageOrgUnitID,sop.FMaterialID,sop.FPeriod,");
                    sql_getCntQty.append(" isnull(sum(rp.FCntactTotalQty),0) as FCntactTotalQty,isnull(sum(rp.FBaseCntactTotalQty),0) as FBaseCntactTotalQty ");
                    sql_getCntQty.append(" from T_MM_SopTransDataDetail as sop left outer join T_MM_RequirementPlan  as rp ");
                    sql_getCntQty.append("      on sop.FStorageOrgUnitID = rp.FStorageOrgUnitID and sop.FMaterialID = rp.FMaterialID");
                    sql_getCntQty.append("      and rp.FReqSource = ").append(30);
                    sql_getCntQty.append(" where FParentID = '" + fID + "'");
                    sql_getCntQty.append("      and to_char(rp.FRequireDate,'YYYY-MM-DD') >= to_char(sop.FPeriodStartDate,'YYYY-MM-DD')");
                    sql_getCntQty.append("      and to_char(rp.FRequireDate,'YYYY-MM-DD') <= to_char(sop.FPeriodEndDate,'YYYY-MM-DD')");
                    sql_getCntQty.append(" group by sop.FStorageOrgUnitID,sop.FMaterialID,sop.FPeriod");
                    DbUtil.execute((Context)ctx, (String)sql_getCntQty.toString());
                    sql_instReqFrmSOP.append("insert into T_MM_RequirementPlan ");
                    sql_instReqFrmSOP.append("(fID,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,fReqSource,fReqTypeID,fManuStrategyID,fRequireDate");
                    sql_instReqFrmSOP.append(",fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fStatus,fPlanMode,fControlUnitID,FCreatorID,FCreateTime,FSourceBillID,FIsDirectTransport ");
                    sql_instReqFrmSOP.append(",FPlannerID,FProductionDeptID )");
                    sql_instReqFrmSOP.append("select newbosid('D86AF5B7'),m.fStorageOrgUnitID,'").append(dataVO.getSrcOrgUnitID()).append("',m.fMaterialID,m.fUnitID,m.fBaseUnitID");
                    sql_instReqFrmSOP.append(",30");
                    sql_instReqFrmSOP.append(",case when p.fManufactureStrategyID='").append("NUnM+gEcEADgAA3gwKgL09g0uEU=");
                    sql_instReqFrmSOP.append("'then '").append("NcvxPgEcEADgAAiqwKgL09hs+cg=").append("' else  '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("' end");
                    sql_instReqFrmSOP.append(",p.fManufactureStrategyID,TO_DATE(SUBSTRING(TO_CHAR(m.fDate, 'YYYY-MM-DD'),1,10) || ' 00:00:00'),m.FQty-isnull(qtyTmp.fQty,0)");
                    sql_instReqFrmSOP.append(",m.FBaseQty-isnull(qtyTmp.FBaseQty,0),0,0,");
                    sql_instReqFrmSOP.append(10).append(",p.FPlanningMode,'" + cuID + "'");
                    sql_instReqFrmSOP.append(",'" + creatorId + "',{ts'" + createTime + "'}");
                    sql_instReqFrmSOP.append(",'" + fID + "'");
                    sql_instReqFrmSOP.append(",case when p.FIssMode = 11050 then 1 else 0 end");
                    sql_instReqFrmSOP.append(", p.FPlanner");
                    sql_instReqFrmSOP.append(", p.FDutyDepartment");
                    sql_instReqFrmSOP.append(" from T_MM_SopTransDataDetail as m ");
                    sql_instReqFrmSOP.append(" left outer join " + Tmp_MaterialQty + " qtyTmp ");
                    sql_instReqFrmSOP.append(" on m.FStorageOrgUnitID = qtyTmp.FStorageOrgUnitID and m.FMaterialID = qtyTmp.FMaterialID");
                    sql_instReqFrmSOP.append(" and m.FPeriod = qtyTmp.FPeriod ");
                    sql_instReqFrmSOP.append(" inner join t_bd_materialplan as p");
                    sql_instReqFrmSOP.append(" on m.fMaterialID = p.fMaterialID and m.fStorageOrgUnitID = p.FOrgUnit ");
                    sql_instReqFrmSOP.append(" where m.FParentID = '" + fID + "'");
                    sql_instReqFrmSOP.append(" and p.fManufactureStrategyID is not null ");
                    sql_instReqFrmSOP.append(" and not exists (select 1");
                    sql_instReqFrmSOP.append(" from T_MM_RequirementPlan as r");
                    sql_instReqFrmSOP.append(" where r.fStorageOrgUnitID = '" + storageOrgUnitID + "'");
                    sql_instReqFrmSOP.append(" and r.fReqSource = ").append(30);
                    sql_instReqFrmSOP.append(" and r.fMaterialID = m.fMaterialID");
                    sql_instReqFrmSOP.append(" and to_char(r.fRequireDate,'yyyy-mm-dd')= to_char(m.fDate,'yyyy-mm-dd')");
                    sql_instReqFrmSOP.append(" )");
                    sql_instReqFrmSOP.append(" and (m.FQty-isnull(qtyTmp.fQty,0))> 0");
                    DbUtil.execute((Context)ctx, (String)sql_instReqFrmSOP.toString());
                    sql_uptReqOfSOP.append("Update T_MM_RequirementPlan as a ");
                    sql_uptReqOfSOP.append("set (fQty,fBaseQty,fStatus)= ");
                    sql_uptReqOfSOP.append("(select");
                    sql_uptReqOfSOP.append(" case when M.fQty-isnull(qtyTmp.FQty,0)+ a.FCntactTotalQty > a.fCntactTotalQty ").append(" then M.fQty-isnull(qtyTmp.FQty,0)+ a.FCntactTotalQty else a.fCntactTotalQty end,");
                    sql_uptReqOfSOP.append(" case when M.fBaseQty-isnull(qtyTmp.FBaseQty,0)+ a.fBaseCntactTotalQty > a.fBaseCntactTotalQty ").append(" then M.fBaseQty-isnull(qtyTmp.FBaseQty,0)+ a.fBaseCntactTotalQty else a.fBaseCntactTotalQty end,");
                    sql_uptReqOfSOP.append(" case when M.fQty-isnull(qtyTmp.FQty,0)+ a.FCntactTotalQty > a.fCntactTotalQty then ");
                    sql_uptReqOfSOP.append(10);
                    sql_uptReqOfSOP.append(" else ");
                    sql_uptReqOfSOP.append(20);
                    sql_uptReqOfSOP.append(" end");
                    sql_uptReqOfSOP.append(" from T_MM_SopTransDataDetail as M ");
                    sql_uptReqOfSOP.append(" inner join " + Tmp_MaterialQty + " qtyTmp ");
                    sql_uptReqOfSOP.append(" on m.FStorageOrgUnitID = qtyTmp.FStorageOrgUnitID and m.FMaterialID = qtyTmp.FMaterialID");
                    sql_uptReqOfSOP.append(" and m.FPeriod = qtyTmp.FPeriod ");
                    sql_uptReqOfSOP.append(" where M.FParentID = '" + fID + "'");
                    sql_uptReqOfSOP.append(" and a.fStorageOrgUnitID = '" + storageOrgUnitID + "'");
                    sql_uptReqOfSOP.append(" and a.fMaterialID = M.fMaterialID");
                    sql_uptReqOfSOP.append(" and M.fDate = a.fRequireDate");
                    sql_uptReqOfSOP.append(" and isnull(qtyTmp.fQty,0) > 0");
                    sql_uptReqOfSOP.append(" and a.fReqSource=").append(30);
                    sql_uptReqOfSOP.append(")");
                    DbUtil.execute((Context)ctx, (String)sql_uptReqOfSOP.toString());
                    KsqlUtil.releaseTempTable((Context)ctx, (String)Tmp_MaterialQty);
                } else {
                    sql_uptReqOfSOP.append("Update T_MM_RequirementPlan as a ");
                    sql_uptReqOfSOP.append("set (fQty,fBaseQty,fStatus)= ");
                    sql_uptReqOfSOP.append("(select");
                    sql_uptReqOfSOP.append(" case when M.fQty > a.fCntactTotalQty then M.fQty else a.fCntactTotalQty end,");
                    sql_uptReqOfSOP.append(" case when M.fBaseQty > a.fBaseCntactTotalQty then M.fBaseQty else a.fBaseCntactTotalQty end,");
                    sql_uptReqOfSOP.append(" case when M.fQty > a.fCntactTotalQty then ");
                    sql_uptReqOfSOP.append(10);
                    sql_uptReqOfSOP.append(" else ");
                    sql_uptReqOfSOP.append(20);
                    sql_uptReqOfSOP.append(" end");
                    sql_uptReqOfSOP.append(" from T_MM_SopTransDataDetail as M ");
                    sql_uptReqOfSOP.append(" where M.FParentID = '" + fID + "'");
                    sql_uptReqOfSOP.append(" and a.fStorageOrgUnitID = '" + storageOrgUnitID + "'");
                    sql_uptReqOfSOP.append(" and a.fMaterialID = M.fMaterialID");
                    sql_uptReqOfSOP.append(" and M.fDate = a.fRequireDate");
                    sql_uptReqOfSOP.append(" and a.fReqSource=").append(30);
                    sql_uptReqOfSOP.append(" )");
                    DbUtil.execute((Context)ctx, (String)sql_uptReqOfSOP.toString());
                    sql_instReqFrmSOP.append("insert into T_MM_RequirementPlan ");
                    sql_instReqFrmSOP.append("(fID,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,fReqSource,fReqTypeID,fManuStrategyID,fRequireDate");
                    sql_instReqFrmSOP.append(",fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fStatus,fPlanMode,fControlUnitID,FCreatorID,FCreateTime,FSourceBillID,FIsDirectTransport ,FPlannerID,FProductionDeptID ) ");
                    sql_instReqFrmSOP.append("select newbosid('D86AF5B7'),m.fStorageOrgUnitID,'").append(dataVO.getSrcOrgUnitID()).append("',m.fMaterialID,m.fUnitID,m.fBaseUnitID");
                    sql_instReqFrmSOP.append(",30");
                    sql_instReqFrmSOP.append(",case when p.fManufactureStrategyID='").append("NUnM+gEcEADgAA3gwKgL09g0uEU=");
                    sql_instReqFrmSOP.append("'then '").append("NcvxPgEcEADgAAiqwKgL09hs+cg=").append("' else  '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("' end");
                    sql_instReqFrmSOP.append(",p.fManufactureStrategyID,TO_DATE(SUBSTRING(TO_CHAR(m.fDate, 'YYYY-MM-DD'),1,10) || ' 00:00:00'),m.fQty");
                    sql_instReqFrmSOP.append(",m.fBaseQty,0,0,");
                    sql_instReqFrmSOP.append(10).append(",p.FPlanningMode,'" + cuID + "'");
                    sql_instReqFrmSOP.append(",'" + creatorId + "',{ts'" + createTime + "'}");
                    sql_instReqFrmSOP.append(",'" + fID + "'");
                    sql_instReqFrmSOP.append(",case when p.FIssMode = 11050 then 1 else 0 end");
                    sql_instReqFrmSOP.append(", p.FPlanner");
                    sql_instReqFrmSOP.append(", p.FDutyDepartment");
                    sql_instReqFrmSOP.append(" from T_MM_SopTransDataDetail as m,");
                    sql_instReqFrmSOP.append("t_bd_materialplan as p");
                    sql_instReqFrmSOP.append(" where m.FParentID = '" + fID + "'");
                    sql_instReqFrmSOP.append(" and m.fQty > 0 ");
                    sql_instReqFrmSOP.append(" and m.fMaterialID = p.fMaterialID and m.fStorageOrgUnitID = p.FOrgUnit ");
                    sql_instReqFrmSOP.append(" and p.fManufactureStrategyID is not null ");
                    sql_instReqFrmSOP.append(" and not exists (select 1");
                    sql_instReqFrmSOP.append(" from T_MM_RequirementPlan as r");
                    sql_instReqFrmSOP.append(" where r.fStorageOrgUnitID = '" + storageOrgUnitID + "'");
                    sql_instReqFrmSOP.append(" and r.fReqSource = ").append(30);
                    sql_instReqFrmSOP.append(" and r.fMaterialID = m.fMaterialID");
                    sql_instReqFrmSOP.append(" and to_char(r.fRequireDate,'yyyy-mm-dd')= to_char(m.fDate,'yyyy-mm-dd')");
                    sql_instReqFrmSOP.append(")");
                    DbUtil.execute((Context)ctx, (String)sql_instReqFrmSOP.toString());
                }
            }
            String sql_getNewRecordID = "Select FID FROM T_MM_RequirementPlan where FSourceBillid = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_getNewRecordID, (Object[])new Object[]{fID});
            if (rs.size() > 0) {
                int count = 0;
                String[] billNumber = this.getNumbers(ctx, storageOrgUnitID, rs.size());
                String sql_updateNumber = " update T_MM_RequirementPlan set FNumber = ?,FSourceBillid = null  where FID = ?";
                conn = EJBFactory.getConnection((Context)ctx);
                batchStatement = conn.prepareStatement(sql_updateNumber);
                while (rs.next()) {
                    batchStatement.setString(1, billNumber[count++]);
                    batchStatement.setString(2, rs.getString("FID"));
                    batchStatement.addBatch();
                }
                batchStatement.executeBatch();
                SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
            }
            String getMaterialSql = "select fmaterialId from  T_MM_SopTransDataDetail where FParentID = '" + fID + "'";
            IRowSet materialRs = DbUtil.executeQuery((Context)ctx, (String)getMaterialSql);
            while (materialRs.next()) {
                this.passiveWriteOffPICReq(ctx, storageOrgUnitID, materialRs.getString("fmaterialId"));
            }
            String sql_deleteSOPDetail = " delete from  T_MM_SopTransDataDetail where FParentID = ?";
            DbUtil.execute((Context)ctx, (String)sql_deleteSOPDetail, (Object[])new Object[]{fID});
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    protected void execProjectTask(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        int oprType = dataVO.getBizAction();
        String sourceBillID = dataVO.getBillID();
        String fID = dataVO.getId();
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        String cuID = dataVO.getCuID();
        if (oprType == 801) {
            StringBuffer sql_closeSub = new StringBuffer();
            sql_closeSub.append(" update T_MM_RequirementPlan set FStatus = 20,FCloseType = 30");
            sql_closeSub.append(" where FID in(");
            sql_closeSub.append(" select rp.FID from T_MM_RequirementPlan as rp,T_MM_ReqPlanTmpParam as rpp");
            sql_closeSub.append(" where rp.FSourceBillID = rpp.fParamValue ");
            sql_closeSub.append(" and rpp.FParent = '" + sourceBillID + "'");
            sql_closeSub.append(" and rp.FStatus = 10)");
            DbUtil.execute((Context)ctx, (String)sql_closeSub.toString());
            DbUtil.execute((Context)ctx, (String)("delete from T_MM_ReqPlanTmpParam where FParent = '" + sourceBillID + "'"));
            String[] billNumber = this.getNumbers(ctx, storageOrgUnitID, 1);
            StringBuffer sqlBuf_insertReq = new StringBuffer();
            sqlBuf_insertReq.append("insert into T_MM_RequirementPlan ");
            sqlBuf_insertReq.append("(fID,FNumber,fStorageOrgUnitID,fSourceSUID,");
            sqlBuf_insertReq.append("fMaterialID,fUnitID,fBaseUnitID,fReqSource,");
            sqlBuf_insertReq.append("fManuStrategyID,fReqTypeID,");
            sqlBuf_insertReq.append("fRequireDate,fQty,fBaseQty,");
            sqlBuf_insertReq.append("fSourceBillID,fSourceBillNum,fStatus,");
            sqlBuf_insertReq.append("fPlanMode,fCreatorID,FCreateTime,fControlUnitID,");
            sqlBuf_insertReq.append("FTrackNumberID,FProjectID,FIsTrackNumFromSrc ,FIsDirectTransport");
            sqlBuf_insertReq.append(",FPlannerID,FProductionDeptID,FBillTypeID)");
            sqlBuf_insertReq.append(" select newbosid('D86AF5B7'),'" + billNumber[0] + "',tmp.fStorageOrgUnitID,tmp.fStorageOrgUnitID,");
            sqlBuf_insertReq.append(" tmp.fMaterialID,p.fProductUnitID,tmp.fBaseUnitID,60,p.fManufactureStrategyID,");
            sqlBuf_insertReq.append(" case when p.fManufactureStrategyID = '").append("fpPxtypCS/ihJ30GjB/UJtg0uEU='");
            sqlBuf_insertReq.append(" or p.fManufactureStrategyID = '").append("GE2FIa4GQ6uhdx0RDGuibtg0uEU='");
            sqlBuf_insertReq.append(" then '").append("s0fDJAEoEADgAABCfwAAAdhs+cg=").append("' else  '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("' end,");
            sqlBuf_insertReq.append("tmp.fRequireDate,");
            sqlBuf_insertReq.append("round(decimal(tmp.fBaseQty/mu.fBaseConvsRate,21,8),mu.FQtyPrecision) as fQty,");
            sqlBuf_insertReq.append("tmp.fBaseQty,");
            sqlBuf_insertReq.append("tmp.FSourceBillID,tmp.fSrcNumber,10,");
            sqlBuf_insertReq.append("p.FPlanningMode,tmp.fCreatorID,tmp.FCreateTime,'" + cuID + "',");
            sqlBuf_insertReq.append("tmp.FTrackNumberID,tmp.FProjectID, ");
            sqlBuf_insertReq.append("case when tmp.FTrackNumberID is null then 0 else 1 end ");
            sqlBuf_insertReq.append("," + dataVO.getDirectTransport());
            sqlBuf_insertReq.append(", '" + dataVO.getPlanner()).append("'");
            sqlBuf_insertReq.append(", '" + dataVO.getProductionDept()).append("'");
            sqlBuf_insertReq.append(", 'cV8Sqe5UQ3eI+vH675lGxUY+1VI='");
            sqlBuf_insertReq.append(" from T_MM_ReqPlanTmp as tmp,");
            sqlBuf_insertReq.append("t_bd_materialplan p,");
            sqlBuf_insertReq.append("t_bd_multiMeasureUnit mu ");
            sqlBuf_insertReq.append("where  tmp.FID = '" + fID + "' ");
            sqlBuf_insertReq.append("and p.fManufactureStrategyID is not null ");
            sqlBuf_insertReq.append("and tmp.fBaseQty > 0 ");
            sqlBuf_insertReq.append("and tmp.fStorageOrgUnitID = p.FOrgUnit ");
            sqlBuf_insertReq.append("and tmp.fMaterialID = p.fMaterialID ");
            sqlBuf_insertReq.append("and p.fMaterialID = mu.fMaterialID ");
            sqlBuf_insertReq.append("and p.fProductUnitID = mu.fMeasureUnitID ");
            DbUtil.execute((Context)ctx, (String)sqlBuf_insertReq.toString());
        } else if (oprType == 802) {
            StringBuffer sql_activeSub = new StringBuffer();
            sql_activeSub.append(" update T_MM_RequirementPlan set FStatus = 10,FCloseType = 0");
            sql_activeSub.append(" where FID in(");
            sql_activeSub.append(" select rp.FID from T_MM_RequirementPlan as rp,T_MM_ReqPlanTmpParam as rpp");
            sql_activeSub.append(" where rp.FSourceBillID = rpp.fParamValue ");
            sql_activeSub.append(" and rpp.FParent = '" + sourceBillID + "'");
            sql_activeSub.append(" and rp.FStatus = 20");
            sql_activeSub.append(" and rp.FCloseType = 30)");
            DbUtil.execute((Context)ctx, (String)sql_activeSub.toString());
            DbUtil.execute((Context)ctx, (String)("delete from T_MM_ReqPlanTmpParam where FParent = '" + sourceBillID + "'"));
            String sql_delCntRela = "delete from T_MM_ReqCounteractRelation  where fSourceID in (select fid from T_MM_RequirementPlan where fSourceBillID = '" + sourceBillID + "')";
            DbUtil.execute((Context)ctx, (String)sql_delCntRela);
            String condition = "fSourceBillID = '" + sourceBillID + "'";
            List billNumberLst = this.getReqPlanNumbers(ctx, condition);
            String sql_delReq = "delete from t_mm_RequirementPlan  where " + condition;
            DbUtil.execute((Context)ctx, (String)sql_delReq);
            this.recycleNumber(ctx, storageOrgUnitID, billNumberLst);
        } else if (oprType == 201) {
            StringBuffer sql_closeTaskReq = new StringBuffer();
            sql_closeTaskReq.append(" update T_MM_RequirementPlan as rp set FStatus = 20");
            sql_closeTaskReq.append(" FCloseType = 30");
            sql_closeTaskReq.append(" where (FReqSource = ? and FSourceBillID = ? ");
            sql_closeTaskReq.append(" or FReqSource = ? and FCoreBillID = ?) ");
            sql_closeTaskReq.append(" and FStatus = 10");
            sql_closeTaskReq.append(" and exists ");
            sql_closeTaskReq.append("(select 1 from T_BD_MaterialPlan as mp ");
            sql_closeTaskReq.append(" where rp.FMaterialID= mp.FMaterialID and rp.FStorageOrgUnitID = mp.FOrgUnit ");
            sql_closeTaskReq.append(" and (mp.FManufactureStrategyID='fpPxtypCS/ihJ30GjB/UJtg0uEU='");
            sql_closeTaskReq.append(" or mp.FManufactureStrategyID='GE2FIa4GQ6uhdx0RDGuibtg0uEU='))");
            DbUtil.execute((Context)ctx, (String)sql_closeTaskReq.toString(), (Object[])new Object[]{new Integer(80), sourceBillID, new Integer(60), sourceBillID});
        } else if (oprType == 303) {
            StringBuffer sql_closeTaskReq = new StringBuffer();
            sql_closeTaskReq.append(" update T_MM_RequirementPlan set FStatus = 20");
            sql_closeTaskReq.append(" FCloseType = 30");
            sql_closeTaskReq.append(" where (FReqSource = ? and FSourceBillID = ? ");
            sql_closeTaskReq.append(" or FReqSource = ? and FCoreBillID = ?) ");
            sql_closeTaskReq.append(" and FStatus = 20");
            sql_closeTaskReq.append(" and FCloseType = 30");
            sql_closeTaskReq.append(" and FBaseQty != FCntactTotalQty ");
            sql_closeTaskReq.append(" and exists ");
            sql_closeTaskReq.append("(select 1 from T_BD_MaterialPlan as mp ");
            sql_closeTaskReq.append(" where rp.FMaterialID= mp.FMaterialID and rp.FStorageOrgUnitID = mp.FOrgUnit ");
            sql_closeTaskReq.append(" and (mp.FManufactureStrategyID='fpPxtypCS/ihJ30GjB/UJtg0uEU='");
            sql_closeTaskReq.append(" or mp.FManufactureStrategyID='GE2FIa4GQ6uhdx0RDGuibtg0uEU='))");
            DbUtil.execute((Context)ctx, (String)sql_closeTaskReq.toString(), (Object[])new Object[]{new Integer(80), sourceBillID, new Integer(60), sourceBillID});
        }
    }

    protected void execCentralPurPlan(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String fID = dataVO.getId();
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        String cuID = dataVO.getCuID();
        String[] billNumber = this.getNumbers(ctx, storageOrgUnitID, 1);
        StringBuffer sqlBuf_insertReq = new StringBuffer();
        sqlBuf_insertReq.append("insert into T_MM_RequirementPlan ");
        sqlBuf_insertReq.append("(fID,fnumber,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,");
        sqlBuf_insertReq.append("fReqSource,fReqTypeID,fManuStrategyID,fRequireDate,fQty,fBaseQty,");
        sqlBuf_insertReq.append("fSourceBillID,fSourceBillNum,FCoreBillID,fStatus,");
        sqlBuf_insertReq.append("fPlanMode,fCreatorID,FCreateTime,fControlUnitID,");
        sqlBuf_insertReq.append("FTrackNumberID,FProjectID,FIsTrackNumFromSrc,FIsDirectTransport ");
        sqlBuf_insertReq.append(",FPlannerID,FProductionDeptID)");
        sqlBuf_insertReq.append(" select newbosid('D86AF5B7'),'" + billNumber[0] + "',tmp.fStorageOrgUnitID,tmp.fStorageOrgUnitID,tmp.fMaterialID,p.fProductUnitID,tmp.fBaseUnitID,");
        sqlBuf_insertReq.append(80);
        sqlBuf_insertReq.append(",case when p.fManufactureStrategyID='").append("NUnM+gEcEADgAA3gwKgL09g0uEU='");
        sqlBuf_insertReq.append(" then 'NcvxPgEcEADgAAiqwKgL09hs+cg='");
        sqlBuf_insertReq.append(" when p.fManufactureStrategyID='").append("fpPxtypCS/ihJ30GjB/UJtg0uEU='");
        sqlBuf_insertReq.append(" or p.fManufactureStrategyID='").append("GE2FIa4GQ6uhdx0RDGuibtg0uEU='");
        sqlBuf_insertReq.append(" then '").append("s0fDJAEoEADgAABCfwAAAdhs+cg=").append("' else  '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("' end,");
        sqlBuf_insertReq.append("p.fManufactureStrategyID,tmp.fRequireDate,");
        sqlBuf_insertReq.append("tmp.fQty,");
        sqlBuf_insertReq.append("tmp.fBaseQty,");
        sqlBuf_insertReq.append("tmp.FSourceBillID,tmp.fSrcNumber,tmp.FSrcOfSourceBillID,10,");
        sqlBuf_insertReq.append("p.FPlanningMode,tmp.fCreatorID,tmp.FCreateTime,'" + cuID + "',");
        sqlBuf_insertReq.append("tmp.FTrackNumberID,tmp.FProjectID, ");
        sqlBuf_insertReq.append("case when tmp.FTrackNumberID is null then 0 else 1 end ");
        sqlBuf_insertReq.append("," + dataVO.getDirectTransport());
        sqlBuf_insertReq.append(", '" + dataVO.getPlanner()).append("'");
        sqlBuf_insertReq.append(", '" + dataVO.getProductionDept()).append("'");
        sqlBuf_insertReq.append(" from T_MM_ReqPlanTmp as tmp,");
        sqlBuf_insertReq.append("t_bd_materialplan p ");
        sqlBuf_insertReq.append("where  tmp.FID = '" + fID + "' ");
        sqlBuf_insertReq.append("and p.fManufactureStrategyID is not null ");
        sqlBuf_insertReq.append("and tmp.fStorageOrgUnitID = p.FOrgUnit ");
        sqlBuf_insertReq.append("and tmp.fMaterialID = p.fMaterialID ");
        DbUtil.execute((Context)ctx, (String)sqlBuf_insertReq.toString());
    }

    protected void execReqRequest(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        int oprType = dataVO.getBizAction();
        String fID = dataVO.getId();
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        String materialID = dataVO.getMaterialID();
        Date reqDate = dataVO.getRequireDate();
        BigDecimal baseQty = dataVO.getBaseQty();
        String cuID = dataVO.getCuID();
        if (oprType == 103) {
            StringBuffer checkExist = new StringBuffer();
            checkExist.append(" select FID from T_MM_RequirementPlan ");
            checkExist.append(" where FReqSource = 70");
            checkExist.append(" and fmaterialid = '" + materialID + "'");
            checkExist.append(" and to_char(fRequireDate,'yyyy-mm-dd') = '" + dateFormat.format(reqDate) + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkExist.toString());
            try {
                if (rs.next()) {
                    StringBuffer sqlBuf_updateReq = new StringBuffer();
                    sqlBuf_updateReq.append(" update T_MM_RequirementPlan as a");
                    sqlBuf_updateReq.append(" set (fQty,fBaseQty,fStatus)= ");
                    sqlBuf_updateReq.append(" (select a.fQty+round(decimal(" + baseQty + "/mu.fBaseConvsRate,21,8),mu.FQtyPrecision),");
                    sqlBuf_updateReq.append(" a.fBaseQty+" + baseQty);
                    sqlBuf_updateReq.append(",case when a.fBaseQty+" + baseQty + "> a.FBaseCntactTotalQty then ");
                    sqlBuf_updateReq.append(10);
                    sqlBuf_updateReq.append(" else ").append(20);
                    sqlBuf_updateReq.append(" end ");
                    sqlBuf_updateReq.append(" from t_bd_multiMeasureUnit as mu ");
                    sqlBuf_updateReq.append(" where  a.FID = '" + rs.getString("FID") + "' ");
                    sqlBuf_updateReq.append(" and a.fMaterialID = mu.fMaterialID ");
                    sqlBuf_updateReq.append(" and a.funitid = mu.fMeasureUnitID )");
                    DbUtil.execute((Context)ctx, (String)sqlBuf_updateReq.toString());
                }
                String[] billNumber = this.getNumbers(ctx, storageOrgUnitID, 1);
                StringBuffer sqlBuf_insertReq = new StringBuffer();
                sqlBuf_insertReq.append("insert into T_MM_RequirementPlan ");
                sqlBuf_insertReq.append("(fID,fNumber,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,");
                sqlBuf_insertReq.append("fReqSource,fReqTypeID,fManuStrategyID,");
                sqlBuf_insertReq.append("fRequireDate,fQty,fBaseQty,");
                sqlBuf_insertReq.append("fSourceBillID,fSourceBillNum,fStatus,");
                sqlBuf_insertReq.append("fPlanMode,fCreatorID,FCreateTime,fControlUnitID,FIsDirectTransport ");
                sqlBuf_insertReq.append(",FPlannerID,FProductionDeptID)");
                sqlBuf_insertReq.append(" select newbosid('D86AF5B7'),'" + billNumber[0] + "',tmp.fStorageOrgUnitID,tmp.fStorageOrgUnitID,tmp.fMaterialID,p.fProductUnitID,tmp.fBaseUnitID,");
                sqlBuf_insertReq.append("70,'NcvxPgEcEADgAAiowKgL09hs+cg=',p.fManufactureStrategyID,");
                sqlBuf_insertReq.append("tmp.fRequireDate,");
                sqlBuf_insertReq.append("round(decimal(tmp.fBaseQty/mu.fBaseConvsRate,21,8),mu.FQtyPrecision) as fQty,");
                sqlBuf_insertReq.append("tmp.fBaseQty,");
                sqlBuf_insertReq.append("tmp.FSourceBillID,tmp.fSrcNumber,10,");
                sqlBuf_insertReq.append("p.FPlanningMode,tmp.fCreatorID,tmp.FCreateTime,'" + cuID + "' ");
                sqlBuf_insertReq.append("," + dataVO.getDirectTransport());
                sqlBuf_insertReq.append(", '" + dataVO.getPlanner()).append("'");
                sqlBuf_insertReq.append(", '" + dataVO.getProductionDept()).append("'");
                sqlBuf_insertReq.append(" from T_MM_ReqPlanTmp as tmp,");
                sqlBuf_insertReq.append("t_bd_materialplan p,");
                sqlBuf_insertReq.append("t_bd_multiMeasureUnit mu ");
                sqlBuf_insertReq.append("where  tmp.FID = '" + fID + "' ");
                sqlBuf_insertReq.append("and p.fManufactureStrategyID is not null ");
                sqlBuf_insertReq.append("and tmp.fStorageOrgUnitID = p.FOrgUnit ");
                sqlBuf_insertReq.append("and tmp.fMaterialID = p.fMaterialID ");
                sqlBuf_insertReq.append("and p.fMaterialID = mu.fMaterialID ");
                sqlBuf_insertReq.append("and p.fProductUnitID = mu.fMeasureUnitID ");
                DbUtil.execute((Context)ctx, (String)sqlBuf_insertReq.toString());
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else if (oprType == 109) {
            StringBuffer checkExist = new StringBuffer();
            checkExist.append(" select FID,fBaseQty,fBaseCntactTotalQty from T_MM_RequirementPlan ");
            checkExist.append(" where FReqSource = 70");
            checkExist.append(" and fmaterialid = '" + materialID + "'");
            checkExist.append(" and to_char(fRequireDate,'yyyy-mm-dd') = '" + dateFormat.format(reqDate) + "'");
            checkExist.append(" and fStatus = 10");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkExist.toString());
            try {
                if (rs.next()) {
                    if (rs.getBigDecimal("fBaseCntactTotalQty").compareTo(new BigDecimal(0)) == 0 || rs.getBigDecimal("fBaseQty").subtract(baseQty).compareTo(rs.getBigDecimal("fBaseCntactTotalQty")) >= 0) {
                        StringBuffer sqlBuf_updateReq = new StringBuffer();
                        sqlBuf_updateReq.append(" update T_MM_RequirementPlan as a");
                        sqlBuf_updateReq.append(" set (fQty,fBaseQty)= ");
                        sqlBuf_updateReq.append(" (select a.fQty-round(decimal(" + baseQty + "/mu.fBaseConvsRate,21,8),mu.FQtyPrecision),");
                        sqlBuf_updateReq.append(" a.fBaseQty - " + baseQty);
                        sqlBuf_updateReq.append(" from t_bd_multiMeasureUnit as mu ");
                        sqlBuf_updateReq.append(" where  a.FID = '" + rs.getString("FID") + "' ");
                        sqlBuf_updateReq.append(" and a.fMaterialID = mu.fMaterialID ");
                        sqlBuf_updateReq.append(" and a.funitid = mu.fMeasureUnitID ");
                        sqlBuf_updateReq.append(" and a.fid = '" + rs.getString("FID") + "')");
                        DbUtil.execute((Context)ctx, (String)sqlBuf_updateReq.toString());
                        String condition = "FID = '" + rs.getString("FID") + "' and fQty <= 0";
                        List billNumberLst = this.getReqPlanNumbers(ctx, condition);
                        if (billNumberLst.size() > 0) {
                            String sql_delReq = "delete from t_mm_RequirementPlan  where " + condition;
                            DbUtil.execute((Context)ctx, (String)sql_delReq);
                            this.recycleNumber(ctx, storageOrgUnitID, billNumberLst);
                        }
                    } else {
                        StringBuffer sqlBuf_updateReq = new StringBuffer();
                        sqlBuf_updateReq.append(" update T_MM_RequirementPlan ");
                        sqlBuf_updateReq.append(" set fQty = fCntactTotalQty,fBaseQty = fBaseCntactTotalQty,fStatus = 20");
                        sqlBuf_updateReq.append(" where fid = '" + rs.getString("FID") + "'");
                        DbUtil.execute((Context)ctx, (String)sqlBuf_updateReq.toString());
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _collectReq(Context ctx, String[] storageOrgUnitIDs) throws BOSException, EASBizException {
        Connection conn = null;
        Statement batchStatement = null;
        String suFilter = "";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.createStatement();
            StringBuffer sql_delReqCollect = new StringBuffer();
            sql_delReqCollect.append("delete from T_MM_RequirementCollect ");
            if (storageOrgUnitIDs.length > 0) {
                String suIDs = StringUtils.arrayToString((Object[])storageOrgUnitIDs, (String)"','");
                suIDs = "'" + suIDs + "'";
                suFilter = " and fStorageOrgUnitID in(" + suIDs + ")";
                sql_delReqCollect.append(" where 1 = 1 ").append(suFilter);
            }
            batchStatement.addBatch(sql_delReqCollect.toString());
            String sql_insert = "insert into T_MM_RequirementCollect(fID,fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,fQty,fBaseQty,fReqDate,fprojectid,ftracknumberid,fPlanResource)";
            String sql_select = " select newbosid('1D1143DC'),fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID";
            String sql_from = "select fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,TO_DATE(SUBSTRING(TO_CHAR(fRequireDate, 'YYYY-MM-DD'),1,10) || ' 00:00:00') as fRequireDate, fprojectid, ftracknumberid from t_mm_requirementplan";
            String sql_selectPre = sql_select + ",sum(fQty),sum(fBaseQty),fRequireDate,fprojectid,ftracknumberid";
            String sql_selectAft = sql_select + ",sum(case when fQty < fCntactTotalQty then 0 else (fQty-fCntactTotalQty) end ),sum(case when fBaseQty < fBaseCntactTotalQty then 0 else (fBaseQty-fBaseCntactTotalQty) end ),fRequireDate,fprojectid,ftracknumberid";
            String sql_where = " where fStatus =  10" + suFilter;
            String sql_groupby = " group by fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,fRequireDate,fprojectid,ftracknumberid";
            String sql_insertReq = sql_insert + sql_selectPre + "," + 30 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "NcvxPgEcEADgAAiqwKgL09hs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectAft + "," + 40 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "NcvxPgEcEADgAAiqwKgL09hs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectPre + "," + 50 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "NcvxPgEcEADgAAiowKgL09hs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectAft + "," + 60 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "NcvxPgEcEADgAAiowKgL09hs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectPre + "," + 62 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "s0fDJAEoEADgAABCfwAAAdhs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectAft + "," + 64 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "s0fDJAEoEADgAABCfwAAAdhs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectPre + "," + 10 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "NcvxPgEcEADgAAiswKgL09hs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectAft + "," + 20 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "NcvxPgEcEADgAAiswKgL09hs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectPre + "," + 90 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "NcvxPgEcEADgAAiwwKgL09hs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectAft + "," + 100 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "NcvxPgEcEADgAAiwwKgL09hs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectPre + "," + 101 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "NcvxPgEcEADgAAiuwKgL09hs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectAft + "," + 102 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "NcvxPgEcEADgAAiuwKgL09hs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectPre + "," + 103 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "sdRQaQEoEADgAAvafwAAAdhs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = sql_insert + sql_selectAft + "," + 104 + " from (" + sql_from + sql_where + " and fReqTypeID = '" + "sdRQaQEoEADgAAvafwAAAdhs+cg=" + "') as a" + sql_groupby;
            batchStatement.addBatch(sql_insertReq);
            sql_insertReq = "insert into T_MM_RequirementCollect(fID,fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,fQty,fBaseQty,fReqDate,fprojectid,ftracknumberid,fPlanResource) select newbosid('1D1143DC'),fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,sum(fQty),sum(fBaseQty),fReqDate,fprojectid,ftracknumberid,110 from T_MM_RequirementCollect where 1 = 1 " + suFilter + " and (fPlanResource = " + 40 + " or fPlanResource = " + 60 + " or fPlanResource = " + 20 + " or fPlanResource = " + 100 + " or fPlanResource = " + 102 + " or fPlanResource = " + 104 + " or fPlanResource = " + 64 + ") group by fStorageOrgUnitID,fMaterialID,FMANUSTRATEGYID,fUnitID,fBaseUnitID,fReqDate,fprojectid,ftracknumberid";
            batchStatement.addBatch(sql_insertReq);
            logger.info((Object)("#############before" + System.currentTimeMillis()));
            batchStatement.executeBatch();
            logger.info((Object)("#############after" + System.currentTimeMillis()));
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
    }

    @Override
    protected void _cntactAndCollectAll(Context ctx, boolean ignoreFailedMutex) throws BOSException, EASBizException {
        ReqPlanCntactFacadeFactory.getLocalInstance(ctx).cntactAndCollect(null, ignoreFailedMutex);
    }

    private List getStorageOrgUnitsFromReqPlanTmp(Context ctx) throws BOSException {
        String sql = "SELECT DISTINCT fStorageOrgUnitID from T_MM_ReqPlanTmp";
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> storageOrgUnits = new ArrayList<String>();
        try {
            while (null != row && row.next()) {
                storageOrgUnits.add(row.getString("fStorageOrgUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)row);
        }
        return storageOrgUnits;
    }

    @Override
    protected void _immdiateCounteract(Context ctx, List orgIDList) throws BOSException, EASBizException {
        logger.info((Object)("##########_immdiateCounteract###before" + System.currentTimeMillis()));
        HashSet<String> autoUpdateOrgSet = new HashSet<String>();
        if (orgIDList.size() == 0) {
            return;
        }
        Iterator iter = orgIDList.iterator();
        StringBuffer paramSql = new StringBuffer();
        String value = "fvalue_l2";
        Locale locale = ContextUtils.getLocaleFromEnv();
        if ("US".equalsIgnoreCase(locale.getCountry())) {
            value = "fvalue_l1 ";
        } else if ("TW".equalsIgnoreCase(locale.getCountry())) {
            value = "fvalue_l2 ";
        } else if ("CN".equalsIgnoreCase(locale.getCountry())) {
            value = "fvalue_l3 ";
        }
        String storageIdStr = SQLUtil.arrayToString((Object[])orgIDList.toArray());
        paramSql.append("select  item.forgunitid as orgId, param.fnumber as number,item." + value + " as value from T_BAS_Paramitem item  \n");
        paramSql.append("inner join T_BAS_Param param on item.fkeyid=param.fid \n");
        paramSql.append("where item.forgunitid in (").append(storageIdStr).append(") \n");
        paramSql.append(" and  param.fnumber in ('MTDREQ_CONSUMEPICREQ','REQ_DATAUPDATEMODE','MIDREQ_CONSUMEPICREQ','ReductionMode'\n");
        paramSql.append(",'").append("SOP_TRANSFER_AVERAGE").append("')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)paramSql.toString());
        try {
            while (rs.next()) {
                this.paramMap.put(rs.getString("orgId") + rs.getString("number"), rs.getString("value"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        while (iter.hasNext()) {
            String updateMode;
            String orgId = (String)iter.next();
            if (orgId == null || !"0".equals(updateMode = (String)this.paramMap.get(orgId + "REQ_DATAUPDATEMODE"))) continue;
            autoUpdateOrgSet.add(orgId);
        }
        if (autoUpdateOrgSet.size() > 0) {
            this._cntactAndCollect(ctx, autoUpdateOrgSet.toArray(new String[autoUpdateOrgSet.size()]), true);
        }
        logger.info((Object)("##########_immdiateCounteract###after" + System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _batchDealCounteract(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        IMutexServiceControl mutexService;
        Uuid mutexUuid = null;
        try {
            mutexUuid = Uuid.create();
            mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean requestFlag = mutexService.requestMutex(ReqPlanCntactFacadeControllerBean.setMutexParameter(mutexUuid, storageOrgUnitID));
            if (!requestFlag) {
                throw new ReqCntactException(ReqCntactException.REQUESTMUTEXFAIL);
            }
            this.passiveWriteOffPICReq(ctx, storageOrgUnitID, null);
        }
        finally {
            if (mutexUuid != null) {
                mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                mutexService.releaseMutex(mutexUuid);
            }
        }
    }

    private void writeExceptionLocal(Context ctx, String storageOrgUnitID, ReqPlanExceptionTypeEnum errType, String description, String exceptionDesr, String detailInfo) throws BOSException, EASBizException {
        if (storageOrgUnitID == null) {
            return;
        }
        ReqPlanExceptionRecordInfo rqExcpInfo = new ReqPlanExceptionRecordInfo();
        StorageOrgUnitInfo soInfo = new StorageOrgUnitInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("cu.id"));
        selectors.add(new SelectorItemInfo("cu.number"));
        selectors.add(new SelectorItemInfo("cu.name"));
        viewInfo.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)storageOrgUnitID, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitCollection orgCol = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(viewInfo);
        if (orgCol.size() > 0) {
            soInfo = orgCol.get(0);
            rqExcpInfo.setStorageOrgUnit(soInfo);
            rqExcpInfo.setCU(soInfo.getCU());
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            rqExcpInfo.setErrorDate(new Timestamp(calendar.getTimeInMillis()));
            rqExcpInfo.setExceptionType(errType);
            rqExcpInfo.setDescription(description);
            rqExcpInfo.setExceptionDescription(exceptionDesr);
            rqExcpInfo.setDetailInfo(detailInfo);
            IReqPlanExceptionRecord iReqPlanEr = ReqPlanExceptionRecordFactory.getLocalInstance(ctx);
            iReqPlanEr.submit((CoreBaseInfo)rqExcpInfo);
        }
    }

    private List getReqPlanNumbers(Context ctx, String whereCondition) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select fNumber from t_mm_requirementplan where " + whereCondition;
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (row.next()) {
                result.add(row.getString("fNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private boolean isCodeRuleExist(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID != null) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RequirementPlanInfo reqInfo = new RequirementPlanInfo();
            return iCodingRuleManager.isExist((IObjectValue)reqInfo, storageOrgUnitID);
        }
        return false;
    }

    private void recycleNumber(Context ctx, String storageOrgUnitID, List recNumbers) throws BOSException, EASBizException {
        RequirementPlanInfo reqInfo;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo crInfo = iCodingRuleManager.getCodingRule((IObjectValue)(reqInfo = new RequirementPlanInfo()), storageOrgUnitID);
        if (crInfo == null) {
            return;
        }
        if (iCodingRuleManager.isExist((IObjectValue)reqInfo, storageOrgUnitID) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)reqInfo, storageOrgUnitID)) {
            iCodingRuleManager.recycleBatchNumber((IObjectValue)reqInfo, storageOrgUnitID, recNumbers.toArray(new String[recNumbers.size()]));
        }
    }

    private String[] getNumbers(Context ctx, String storageOrgUnitID, int count) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RequirementPlanInfo reqInfo = new RequirementPlanInfo();
        Calendar cal = Calendar.getInstance();
        reqInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        String[] nums = null;
        if (codingRuleManager.getCodingRule((IObjectValue)reqInfo, storageOrgUnitID) == null) {
            this.writeExceptionLocal(ctx, storageOrgUnitID, ReqPlanExceptionTypeEnum.ALARM, ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"ACTION_GETNUMBERS", (Locale)ctx.getLocale()), ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"EXCEPTION_NOCODEINGRULE", (Locale)ctx.getLocale()), "");
            throw new ReqPlanException(ReqPlanException.NOCODINGRULE);
        }
        nums = codingRuleManager.getBatchNumber((IObjectValue)reqInfo, storageOrgUnitID, count);
        return nums;
    }

    public static MutexParameter setMutexParameter(Uuid mutexUuid, String orgUnitID) {
        MutexParameter mutexParam = new MutexParameter();
        mutexParam.setRequestId(mutexUuid);
        mutexParam.setOrgUnitID(BOSUuid.read((String)orgUnitID));
        mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        mutexParam.setMutexName(MM_REQPLAN_CNT_MUTEXLOCK);
        return mutexParam;
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) {
                    ps.setNull(i + 1, 12);
                    continue;
                }
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("222 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private Map getScraptBillSourceInfo(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String srcBillTypeID = dataVO.getSrcBillTypeID();
        String srcBillID = dataVO.getSrcBillID();
        String srcBillEntryID = dataVO.getSrcBillEntryID();
        String materialId = dataVO.getMaterialID();
        String productionOrderBillId = "orderBillId";
        String productionOrderBillEntryId = "orderBillEntryId";
        String productionOrderBillTypeId = "orderBillTypeId";
        StringBuffer sql = new StringBuffer();
        if ("ejIZHXXTQliYCQJg9t4Re0Y+1VI=".equals(srcBillTypeID) || "B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(srcBillTypeID) || "YnsvoPSeRzCK0b/jEufQpkY+1VI=".equals(srcBillTypeID)) {
            map.put(productionOrderBillId, srcBillID);
            map.put(productionOrderBillEntryId, srcBillEntryID);
            map.put(productionOrderBillTypeId, srcBillTypeID);
        } else if ("3fY8szOQTQmfaNi+Tm5SJUY+1VI=".equals(srcBillTypeID)) {
            sql.append("select pickingSlip.fSourceBillTypeId as fSourceBillTypeId,").append("\t   pickingSlip.FSourceBillID as FSourceBillID,").append("       pickingSlipEntry.FSourceBillEntryID as FSourceBillEntryID ").append("from T_MM_PickingSlipBill pickingSlip ").append("     inner join T_MM_PickingSlipBillentry pickingSlipEntry ").append("     on pickingSlipEntry.fparentId = pickingSlip.fid ").append("where pickingSlip.fid = '").append(srcBillID).append("'").append("      and  pickingSlipEntry.fmaterialId ='").append(materialId).append("'").append("      and  pickingSlip.fSourceBillTypeId ='").append("ejIZHXXTQliYCQJg9t4Re0Y+1VI=").append("'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.next()) {
                    map.put(productionOrderBillId, rs.getString("FSourceBillID"));
                    map.put(productionOrderBillEntryId, rs.getString("FSourceBillEntryID"));
                    map.put(productionOrderBillTypeId, rs.getString("fSourceBillTypeId"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return map;
    }

    private int writeOffMIDReq(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, SQLException {
        int bizDirection;
        String billID = dataVO.getBillID();
        StringBuffer sql = new StringBuffer();
        sql.append("select recIssuseType.FBizDirection as FBizDirection from T_IM_MaterialReqBill materialReqBill ");
        sql.append("inner join T_SCM_TransactionType transactionType on materialReqBill.fTransactionTypeId = transactionType.fid ");
        sql.append("inner join T_IM_RecIssueType recIssuseType on transactionType.FRITypeID = recIssuseType.FID ");
        sql.append("where materialReqBill.fid = '").append(billID).append("' ");
        IRowSet transactionTypeRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (transactionTypeRs.next() && (bizDirection = transactionTypeRs.getInt("FBizDirection")) == -1 && dataVO.getQty().compareTo(MMConstant.BIGDECIMAL_ZERO) > 0) {
            dataVO.setQty(dataVO.getQty().negate());
            dataVO.setBaseQty(dataVO.getBaseQty().negate());
        }
        Map map = this.getScraptBillSourceInfo(ctx, dataVO);
        return this.writeOffReq(ctx, dataVO, map);
    }

    private int writeOffReq(Context ctx, ReqPlanUpdateDataVO dataVO, Map map) throws BOSException, SQLException {
        BigDecimal qty = dataVO.getQty();
        if (MMConstant.BIGDECIMAL_ZERO.compareTo(qty) == 0) {
            return 0;
        }
        String billTypeID = dataVO.getBillTypeID();
        String billNum = dataVO.getBillNumber();
        String billID = dataVO.getBillID();
        String billEntryID = dataVO.getBillEntryID();
        String unitID = dataVO.getUnitID();
        String baseUnitID = dataVO.getBaseUnitID();
        BigDecimal baseQty = dataVO.getBaseQty();
        String productionOrderBillId = "orderBillId";
        String productionOrderBillEntryId = "orderBillEntryId";
        String srcBillID = (String)map.get(productionOrderBillId);
        String srcBillEntryID = (String)map.get(productionOrderBillEntryId);
        int returnCount = 0;
        StringBuffer sql = new StringBuffer();
        if (srcBillID != null && srcBillID.trim().length() > 0 && srcBillEntryID != null && srcBillEntryID.trim().length() > 0) {
            sql.append("select FID from t_mm_requirementplan ").append(" where fSourceBillID = '").append(srcBillID).append("' and fSourceEntryID = '").append(srcBillEntryID).append("'");
            IRowSet cntRow = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (cntRow.next()) {
                String FReqPlanID = cntRow.getString("FID");
                sql.setLength(0);
                sql.append(" update t_mm_RequirementPlan set ").append(" fCntactTotalQty = fCntactTotalQty + ?,").append(" fBaseCntactTotalQty = fBaseCntactTotalQty + ?,").append(" FStatus = (case when fQty > fCntactTotalQty + ? and fclosetype <> 20 ").append(" then ").append(10).append(" else ").append(20).append(" end)").append(" where FID = '").append(FReqPlanID).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{qty, baseQty, qty});
                String sql_insertCntactRelation = "insert into T_MM_ReqCounteractRelation(fID,fSourceID,fSourceEntryID,fDestID,fBillTypeID,fQty,fBaseQty,fUnitID,fBaseUnitID,fSeq,FSourceNumber ) values(newbosid('D02F7535'),'" + billID + "','" + billEntryID + "','" + FReqPlanID + "','" + billTypeID + "'," + qty + "," + baseQty + ",'" + unitID + "','" + baseUnitID + "'," + 1 + ",'" + billNum + "')";
                returnCount = MRPUtil.executeUpdate(ctx, sql_insertCntactRelation);
            }
        }
        return returnCount;
    }

    private void reverseWriteOffMIDReq(Context ctx, ReqPlanUpdateDataVO dataVO) throws EASBizException, BOSException {
        String billId = dataVO.getBillID();
        String billEntryId = dataVO.getBillEntryID();
        StringBuffer sql_updateCntactQty = new StringBuffer();
        sql_updateCntactQty.append("UPDATE T_MM_RequirementPlan as p ");
        sql_updateCntactQty.append("SET (FCntactTotalQty,FBaseCntactTotalQty,FStatus) = (");
        sql_updateCntactQty.append("SELECT p.FCntactTotalQty - r.fQty,");
        sql_updateCntactQty.append("\tp.FBaseCntactTotalQty - r.fBaseQty,");
        sql_updateCntactQty.append("\tcase when p.fQty - (p.FCntactTotalQty - r.fQty)>0  and fclosetype <> 20");
        sql_updateCntactQty.append(" then 10");
        sql_updateCntactQty.append(" else 20 end ");
        sql_updateCntactQty.append("FROM  T_MM_ReqCounteractRelation as r ");
        sql_updateCntactQty.append("WHERE r.fSourceID = '" + billId + "' and r.fSourceEntryID = '" + billEntryId + "'");
        sql_updateCntactQty.append("\tand r.FDestID = p.fID)");
        try {
            DbUtil.execute((Context)ctx, (String)sql_updateCntactQty.toString());
            String sql_delCntRela = "delete from T_MM_ReqCounteractRelation where FSourceID = ? and FSourceEntryID = ?";
            DbUtil.execute((Context)ctx, (String)sql_delCntRela, (Object[])new Object[]{billId, billEntryId});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private int updateReqPlanStatus(Context ctx, ReqPlanUpdateDataVO dataVO, ReqPlanStatusEnum reqPlanStatus) throws BOSException {
        String sourceBillID = dataVO.getBillID();
        String sourceBillEntryID = dataVO.getBillEntryID();
        StringBuffer sqlBuf_updateReq = new StringBuffer();
        sqlBuf_updateReq.append(" update T_MM_RequirementPlan ");
        sqlBuf_updateReq.append(" set fStatus = ").append(reqPlanStatus.getValue());
        sqlBuf_updateReq.append(" where fSourceBillID='").append(sourceBillID).append("'");
        sqlBuf_updateReq.append(" and FSourceEntryID ='").append(sourceBillEntryID).append("'");
        return MRPUtil.executeUpdate(ctx, sqlBuf_updateReq.toString());
    }

    private int updateReqPlanCreator(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException {
        String sourceBillID = dataVO.getBillID();
        String sourceBillEntryID = dataVO.getBillEntryID();
        StringBuffer sqlBuf_updateReq = new StringBuffer();
        sqlBuf_updateReq.append(" update T_MM_RequirementPlan ");
        sqlBuf_updateReq.append(" set fCreatorID = '").append(dataVO.getCreatorID()).append("'");
        sqlBuf_updateReq.append(" where fSourceBillID='").append(sourceBillID).append("'");
        sqlBuf_updateReq.append(" and FSourceEntryID ='").append(sourceBillEntryID).append("'");
        return MRPUtil.executeUpdate(ctx, sqlBuf_updateReq.toString());
    }

    private int insertReqPlanByDataVo(Context ctx, ReqPlanUpdateDataVO dataVO, int requireSourceValue, String requireTypeId) throws BOSException, EASBizException {
        String fID = dataVO.getId();
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        String cuID = dataVO.getCuID();
        StringBuffer sqlBuf_insertReq = new StringBuffer();
        String[] billNumber = this.getNumbers(ctx, storageOrgUnitID, 1);
        sqlBuf_insertReq.append("insert into T_MM_RequirementPlan ");
        sqlBuf_insertReq.append("(fID,").append("FNumber,").append("fStorageOrgUnitID,").append("fSourceSUID,").append("fMaterialID,").append("fUnitID,").append("fBaseUnitID,").append("fReqSource,").append("fManuStrategyID,").append("fReqTypeID,").append("fRequireDate,").append("fQty,").append("fBaseQty,").append(" FBillTypeID,").append("fSourceBillID,").append("FSourceEntryID,").append("fSourceBillNum,").append("FSourceEntrySeq,").append("fStatus,").append("fPlanMode,").append("fCreatorID,").append("FCreateTime,").append("fControlUnitID,").append("FTrackNumberID,").append("FProjectID,").append("FIsDirectTransport,").append("FPlannerID,").append("FProductionDeptID,").append("FIsTrackNumFromSrc )");
        sqlBuf_insertReq.append(" select newbosid('D86AF5B7'),'").append(billNumber[0]).append("',").append("tmp.fStorageOrgUnitID,").append("tmp.fSourceSUID,").append(" tmp.fMaterialID,").append("p.fProductUnitID,").append("tmp.fBaseUnitID,").append(requireSourceValue).append(",").append("p.fManufactureStrategyID,").append("'").append(requireTypeId).append("', ").append("tmp.fRequireDate,").append("round(decimal(tmp.fBaseQty/mu.fBaseConvsRate,21,8),mu.FQtyPrecision) as fQty,").append("tmp.fBaseQty,").append(" tmp.fBillTypeID,").append("tmp.FSourceBillID,").append("tmp.FSourceEntryID,").append("tmp.fSrcNumber,").append("tmp.fsrcSeq,").append(10).append(",").append("p.FPlanningMode,").append("tmp.fCreatorID,").append("tmp.FCreateTime,'").append(cuID).append("',").append("tmp.FTrackNumberID,").append("tmp.FProjectID, ").append(dataVO.getDirectTransport()).append(",").append(" '").append(dataVO.getPlanner()).append("',").append(" '").append(dataVO.getProductionDept()).append("',").append("case when tmp.FTrackNumberID is null then 0 else 1 end ");
        sqlBuf_insertReq.append("from T_MM_ReqPlanTmp as tmp ");
        sqlBuf_insertReq.append(" inner join t_bd_materialplan p on tmp.fStorageOrgUnitID = p.forgUnit ");
        sqlBuf_insertReq.append(" and tmp.fMaterialID = p.fMaterialID");
        sqlBuf_insertReq.append(" inner join t_bd_multiMeasureUnit mu on mu.fMaterialID = p.fMaterialID ");
        sqlBuf_insertReq.append(" and p.fProductUnitID = mu.fMeasureUnitID");
        sqlBuf_insertReq.append(" where tmp.fBaseQty > 0");
        sqlBuf_insertReq.append(" and p.forgUnit = '").append(storageOrgUnitID).append("'");
        sqlBuf_insertReq.append(" and p.fManufactureStrategyID is not null");
        sqlBuf_insertReq.append(" and p.FPlanningMode in (").append(2).append(",").append(3).append(")");
        sqlBuf_insertReq.append(" and p.fstatus =").append(1);
        sqlBuf_insertReq.append(" and  tmp.FID = '").append(fID).append("' ");
        return MRPUtil.executeUpdate(ctx, sqlBuf_insertReq.toString());
    }

    private int updateReqPlanByDataVo(Context ctx, ReqPlanUpdateDataVO dataVO, int requireSourceValue, String requireTypeId) throws BOSException, EASBizException {
        String sourceBillID = dataVO.getBillID();
        String sourceBillEntryID = dataVO.getBillEntryID();
        String fID = dataVO.getId();
        String cuID = dataVO.getCuID();
        StringBuffer sqlBuf_insertReq = new StringBuffer();
        sqlBuf_insertReq.append(" update T_MM_RequirementPlan req set");
        sqlBuf_insertReq.append("(fStorageOrgUnitID,").append("fSourceSUID,").append("fMaterialID,").append("fUnitID,").append("fBaseUnitID,").append("fReqSource,").append("fManuStrategyID,").append("fReqTypeID,").append("fRequireDate,").append("fQty,").append("fBaseQty,").append("FBillTypeID,").append("fSourceBillID,").append("FSourceEntryID,").append("fSourceBillNum,").append("FSourceEntrySeq,").append("fStatus,").append("fPlanMode,").append("FLastUpdateUserID,").append("FLastUpdateTime,").append("fControlUnitID,").append("FTrackNumberID,").append("FProjectID,").append("FIsDirectTransport,").append("FPlannerID,").append("FProductionDeptID,").append("FIsTrackNumFromSrc ) = ");
        sqlBuf_insertReq.append(" (select tmp.fStorageOrgUnitID,").append("tmp.fSourceSUID,").append(" tmp.fMaterialID,").append("p.fProductUnitID,").append("tmp.fBaseUnitID,").append(requireSourceValue).append(",p.fManufactureStrategyID,").append("'").append(requireTypeId).append("', ").append("tmp.fRequireDate,").append("round(decimal(tmp.fBaseQty/mu.fBaseConvsRate,21,8),mu.FQtyPrecision) as fQty,").append("tmp.fBaseQty,").append("tmp.fBillTypeID,").append("tmp.FSourceBillID,").append("tmp.FSourceEntryID,").append("tmp.fSrcNumber,").append("tmp.fsrcSeq,").append(10).append(",").append("p.FPlanningMode,").append("tmp.fCreatorID,").append("tmp.FCreateTime,'").append(cuID).append("',").append("tmp.FTrackNumberID,").append("tmp.FProjectID, ").append(dataVO.getDirectTransport()).append(",").append(" '").append(dataVO.getPlanner()).append("',").append(" '").append(dataVO.getProductionDept()).append("',").append("case when tmp.FTrackNumberID is null then 0 else 1 end ").append(" from T_MM_ReqPlanTmp as tmp ").append(" inner join t_bd_materialplan p ").append(" on tmp.fStorageOrgUnitID = p.forgUnit ").append(" and tmp.fMaterialID = p.fMaterialID").append(" inner join t_bd_multiMeasureUnit mu ").append(" on mu.fMaterialID = p.fMaterialID ").append(" and p.fProductUnitID = mu.fMeasureUnitID").append(" where tmp.fBaseQty > 0").append(" and p.fManufactureStrategyID is not null").append(" and  tmp.FID = '").append(fID).append("') ");
        sqlBuf_insertReq.append(" where req.fSourceBillID='").append(sourceBillID).append("'").append(" and req.FSourceEntryID ='").append(sourceBillEntryID).append("'");
        return MRPUtil.executeUpdate(ctx, sqlBuf_insertReq.toString());
    }

    private int deleteReqRequestByDataVo(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        String sourceBillID = dataVO.getBillID();
        String sourceBillEntryID = dataVO.getBillEntryID();
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_MM_RequirementPlan where fSourceBillID='").append(sourceBillID).append("'");
        sql.append(" and FSourceEntryID ='").append(sourceBillEntryID).append("'");
        String condition = "fSourceBillID = '" + sourceBillID + "' and fSourceEntryID = '" + sourceBillEntryID + "'";
        List billNumberLst = this.getReqPlanNumbers(ctx, condition);
        int deleteCount = MRPUtil.executeUpdate(ctx, sql.toString());
        this.recycleNumber(ctx, storageOrgUnitID, billNumberLst);
        return deleteCount;
    }

    protected void execMID(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        if (dataVO.getStorageOrgUnitID() == null || dataVO.getQty() == null || dataVO.getBillTypeID() == null || dataVO.getMaterialID() == null) {
            return;
        }
        String srcBillTypeID = dataVO.getBillTypeID();
        if ("9XXvbVGlRtym/0qtqeIXXrhE1B8=".equals(srcBillTypeID)) {
            this.execPlanOrderMID(ctx, dataVO);
        } else if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(srcBillTypeID)) {
            try {
                this.execMaterialReqMID(ctx, dataVO);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else if ("ejIZHXXTQliYCQJg9t4Re0Y+1VI=".equals(srcBillTypeID) || "B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(srcBillTypeID)) {
            this.execProductionOrderMID(ctx, dataVO);
        } else if ("YnsvoPSeRzCK0b/jEufQpkY+1VI=".equals(srcBillTypeID)) {
            this.execDMScrapSupplyMtl(ctx, dataVO);
        } else if ("WB3X6gEqEADgAAB5fwAAAUY+1VI=".equals(srcBillTypeID)) {
            this.execDirectDeveryBill(ctx, dataVO);
        }
    }

    private void execPlanOrderMID(Context ctx, ReqPlanUpdateDataVO dataVO) throws EASBizException, BOSException {
        int oprType = dataVO.getBizAction();
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        String sourceBillID = dataVO.getBillID();
        String sourceEntryID = dataVO.getBillEntryID();
        String paramValue = (String)this.paramMap.get(storageOrgUnitID + "MIDREQ_CONSUMEPICREQ");
        boolean isMidConsumePic = false;
        if (paramValue != null) {
            isMidConsumePic = Boolean.valueOf(paramValue);
        }
        if (this.getDirectTransportFlagByDataVO(ctx, dataVO)) {
            dataVO.setDirectTransport(1);
        } else {
            dataVO.setDirectTransport(0);
        }
        this.setDeptAndPlannerFromPO(ctx, dataVO);
        if (oprType == 103) {
            this.insertReqPlanByDataVo(ctx, dataVO, 50, "NcvxPgEcEADgAAiuwKgL09hs+cg=");
            if (isMidConsumePic) {
                this.writeOffPICReq(ctx, dataVO);
            }
        } else if (oprType == 109) {
            if (isMidConsumePic) {
                this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
            }
            this.deleteReqRequestByDataVo(ctx, dataVO);
        } else if (oprType == 801) {
            if (dataVO.getBaseQty().compareTo(new BigDecimal("0.0")) == 0) {
                if (isMidConsumePic) {
                    this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
                }
                this.deleteReqRequestByDataVo(ctx, dataVO);
            } else {
                this.updateReqPlanByDataVo(ctx, dataVO, 50, "NcvxPgEcEADgAAiuwKgL09hs+cg=");
                if (isMidConsumePic) {
                    this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
                    this.writeOffPICReq(ctx, dataVO);
                }
            }
        } else if (oprType == 201) {
            if (isMidConsumePic) {
                this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
            }
            this.deleteReqRequestByDataVo(ctx, dataVO);
        } else if (oprType == 701) {
            this.updateReqPlanByDataVo(ctx, dataVO, 50, "NcvxPgEcEADgAAiuwKgL09hs+cg=");
            if (isMidConsumePic) {
                this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
                this.writeOffPICReq(ctx, dataVO);
            }
        }
    }

    private void setDeptAndPlannerFromPO(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException {
        String billId = dataVO.getBillID();
        String sql = "select FAdminOrgUnitID,FPlanner from T_MM_PlannedOrder where fid ='" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                String deptId = rs.getString("FAdminOrgUnitID");
                String plannerId = rs.getString("FPlanner");
                if (plannerId != null) {
                    dataVO.setPlanner(plannerId);
                }
                if (deptId != null) {
                    dataVO.setProductionDept(deptId);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private boolean getDirectTransportFlagByDataVO(Context ctx, ReqPlanUpdateDataVO dataVO) throws EASBizException, BOSException {
        boolean isDirectTransport = false;
        String sourceEntryID = dataVO.getBillEntryID();
        StringBuffer sql = new StringBuffer();
        sql.append("select").append(" FProvideType").append(" from t_mm_plannedorderentry where ").append(" fid='").append(sourceEntryID).append("'");
        try {
            int provideType;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next() && 10940 == (provideType = rs.getInt("FProvideType"))) {
                isDirectTransport = true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return isDirectTransport;
    }

    private void execProductionOrderMID(Context ctx, ReqPlanUpdateDataVO dataVO) throws EASBizException, BOSException {
        int updateCount;
        Map midDataFlagMap;
        int oprType = dataVO.getBizAction();
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        String sourceBillID = dataVO.getBillID();
        String sourceEntryID = dataVO.getBillEntryID();
        String srcSourceBillTypeId = dataVO.getSrcBillTypeID();
        String paramValue = (String)this.paramMap.get(storageOrgUnitID + "MIDREQ_CONSUMEPICREQ");
        boolean isMidConsumePic = false;
        if (paramValue != null) {
            isMidConsumePic = Boolean.valueOf(paramValue);
        }
        if (((Boolean)(midDataFlagMap = this.getMIDDataFlagMap(ctx, dataVO)).get("isDirectTransport")).booleanValue()) {
            dataVO.setDirectTransport(1);
        }
        if (oprType == 801 && "9XXvbVGlRtym/0qtqeIXXrhE1B8=".equals(srcSourceBillTypeId) && (updateCount = this.updateReqPlanCreator(ctx, dataVO)) == 0) {
            this.insertReqPlanByDataVo(ctx, dataVO, 50, "NcvxPgEcEADgAAiuwKgL09hs+cg=");
            if (isMidConsumePic) {
                this.writeOffPICReq(ctx, dataVO);
            }
        }
        if (oprType == 103 || "9XXvbVGlRtym/0qtqeIXXrhE1B8=".equals(srcSourceBillTypeId) && (oprType == 102 || oprType == 701) || oprType == 9903) {
            if (((Boolean)midDataFlagMap.get("isMIDData")).booleanValue() && dataVO.getBaseQty().compareTo(new BigDecimal("0.0")) > 0) {
                updateCount = this.updateReqPlanByDataVo(ctx, dataVO, 50, "NcvxPgEcEADgAAiuwKgL09hs+cg=");
                if (updateCount == 0) {
                    this.insertReqPlanByDataVo(ctx, dataVO, 50, "NcvxPgEcEADgAAiuwKgL09hs+cg=");
                    if (isMidConsumePic) {
                        this.writeOffPICReq(ctx, dataVO);
                    }
                } else if (isMidConsumePic) {
                    this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
                    this.writeOffPICReq(ctx, dataVO);
                }
            } else {
                if (isMidConsumePic) {
                    this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
                }
                this.deleteReqRequestByDataVo(ctx, dataVO);
            }
            this.deleteReqRequestByOrderId(ctx, dataVO);
            this.updateStatusDependQty(ctx, sourceBillID, sourceEntryID);
        }
        if (oprType == 109 || oprType == 104 || oprType == 108) {
            if (isMidConsumePic) {
                this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
            }
            this.deleteReqRequestByDataVo(ctx, dataVO);
        }
        if (oprType == 9904) {
            if ("B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(srcSourceBillTypeId)) {
                if (isMidConsumePic) {
                    this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
                }
                this.deleteReqRequestByDataVo(ctx, dataVO);
            } else {
                this.updateReqPlanByDataVo(ctx, dataVO, 50, "NcvxPgEcEADgAAiuwKgL09hs+cg=");
                if (isMidConsumePic) {
                    this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
                    this.writeOffPICReq(ctx, dataVO);
                }
            }
        }
        if (oprType == 201 || oprType == 9901) {
            this.updateReqPlanStatus(ctx, dataVO, ReqPlanStatusEnum.CLOSED);
        }
        if (oprType == 303 || oprType == 9902) {
            StringBuffer sqlBuf_updateReq = new StringBuffer();
            sqlBuf_updateReq.append(" update T_MM_RequirementPlan ");
            sqlBuf_updateReq.append(" set fStatus =  case when FBaseQty>FBaseCntactTotalQty then ").append(10).append(" else ").append(20).append(" end");
            sqlBuf_updateReq.append(" where fSourceBillID='").append(sourceBillID).append("'");
            sqlBuf_updateReq.append(" and FSourceEntryID ='").append(sourceEntryID).append("'");
            MRPUtil.executeUpdate(ctx, sqlBuf_updateReq.toString());
        }
    }

    private int updateStatusDependQty(Context ctx, String sourceBillID, String sourceEntryID) throws BOSException {
        StringBuffer sqlBuf_updateReq = new StringBuffer();
        sqlBuf_updateReq.append(" update T_MM_RequirementPlan ");
        sqlBuf_updateReq.append(" set fStatus =  case when FBaseQty>FBaseCntactTotalQty then ").append(10).append(" else ").append(20).append(" end");
        sqlBuf_updateReq.append(" where fSourceBillID='").append(sourceBillID).append("'");
        sqlBuf_updateReq.append(" and FSourceEntryID ='").append(sourceEntryID).append("'");
        return MRPUtil.executeUpdate(ctx, sqlBuf_updateReq.toString());
    }

    private Map getMIDDataFlagMap(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException {
        String billTypeId = dataVO.getBillTypeID();
        String billEntryId = dataVO.getBillEntryID();
        StringBuffer sql = new StringBuffer();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if ("ejIZHXXTQliYCQJg9t4Re0Y+1VI=".equals(billTypeId)) {
            sql.append(" select FProvideType,fid from T_MM_ProductionOrderSEntry").append(" where fid = '").append(billEntryId).append("'");
        }
        if ("B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(billTypeId)) {
            sql.append(" select FProvideType,fid from T_MM_MFTOrderStock").append(" where fid = '").append(billEntryId).append("'");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                int provideType = rs.getInt("FProvideType");
                if (10930 == provideType) {
                    map.put("isMIDData", true);
                    map.put("isDirectTransport", false);
                } else if (10940 == provideType) {
                    map.put("isMIDData", true);
                    map.put("isDirectTransport", true);
                } else {
                    map.put("isMIDData", false);
                    map.put("isDirectTransport", false);
                }
            } else {
                map.put("isMIDData", false);
                map.put("isDirectTransport", false);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return map;
    }

    private int deleteReqRequestByOrderId(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException {
        String orderId = dataVO.getBillID();
        String orderEntryId = dataVO.getBillEntryID();
        String orderTypeId = dataVO.getBillTypeID();
        String orgUnitId = dataVO.getStorageOrgUnitID();
        String headerTable = "t_mm_manufactureorder";
        String entryTable = "t_mm_mftorderstock";
        if ("ejIZHXXTQliYCQJg9t4Re0Y+1VI=".equals(orderTypeId)) {
            headerTable = "T_MM_ProductionOrder";
            entryTable = "T_MM_ProductionOrderSEntry";
        }
        StringBuffer sql = new StringBuffer();
        if ("B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(orderTypeId)) {
            sql.append("delete from t_mm_requirementPlan  ");
            sql.append("where fSourceBillID = '").append(orderId).append("'");
            sql.append("     and FSourceEntryID in ( ");
            sql.append("select mft.fid from t_mm_mftorderstock mft ");
            sql.append(" left outer join t_bd_materialplan mp ");
            sql.append(" on mft.fmaterialid = mp.fmaterialId and mp.forgUnit ='").append(orgUnitId).append("'");
            sql.append("where mp.fid is null  and mft.fid =  '").append(orderEntryId).append("')");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        sql.setLength(0);
        sql.append("delete from t_mm_requirementPlan  ");
        sql.append("where fSourceBillID = '").append(orderId).append("'");
        sql.append("     and FSourceEntryID not in ( ");
        sql.append("        select entry.fid from ").append(entryTable).append(" entry  ");
        sql.append("        inner join ").append(headerTable).append(" t_header on t_header.fid = entry.FParentID ");
        sql.append("        and t_header.fid ='").append(orderId).append("'");
        sql.append("     ) ");
        return MRPUtil.executeUpdate(ctx, sql.toString());
    }

    private void execMaterialReqMID(Context ctx, ReqPlanUpdateDataVO dataVO) throws EASBizException, BOSException, SQLException {
        int oprType = dataVO.getBizAction();
        if (oprType == 103) {
            this.writeOffMIDReq(ctx, dataVO);
        } else if (oprType == 109) {
            this.reverseWriteOffMIDReq(ctx, dataVO);
        }
    }

    private void execDMScrapSupplyMtl(Context ctx, ReqPlanUpdateDataVO dataVO) throws EASBizException, BOSException {
        String storageOrgUnitID = dataVO.getStorageOrgUnitID();
        int oprType = dataVO.getBizAction();
        String sourceBillID = dataVO.getBillID();
        String sourceEntryID = dataVO.getBillEntryID();
        String paramValue = (String)this.paramMap.get(storageOrgUnitID + "MIDREQ_CONSUMEPICREQ");
        boolean isMidConsumePic = false;
        if (paramValue != null) {
            isMidConsumePic = Boolean.valueOf(paramValue);
        }
        if (oprType == 103) {
            this.insertReqPlanByDataVo(ctx, dataVO, 50, "NcvxPgEcEADgAAiuwKgL09hs+cg=");
            if (isMidConsumePic) {
                this.writeOffPICReq(ctx, dataVO);
            }
        } else if (oprType == 109) {
            if (isMidConsumePic) {
                this.reverseWriteOffReq(ctx, null, sourceBillID, sourceEntryID, false);
            }
            this.deleteReqRequestByDataVo(ctx, dataVO);
        }
    }

    private void execDirectDeveryBill(Context ctx, ReqPlanUpdateDataVO dataVO) throws EASBizException, BOSException {
        int oprType = dataVO.getBizAction();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderBillId", dataVO.getSrcBillID());
        map.put("orderBillEntryId", dataVO.getSrcBillEntryID());
        map.put("orderBillTypeId", dataVO.getSrcBillTypeID());
        if (oprType == 103) {
            try {
                this.writeOffReq(ctx, dataVO, map);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else if (oprType == 109) {
            this.reverseWriteOffMIDReq(ctx, dataVO);
        }
    }

    protected void execGCCD(Context ctx, ReqPlanUpdateDataVO dataVO) throws BOSException, EASBizException {
        int oprType = dataVO.getBizAction();
        String srcBillTypeID = dataVO.getBillTypeID();
        if (COOPERATE_PLAN_ORDER_BILL_TYPE_ID.endsWith(srcBillTypeID)) {
            if (oprType == 801) {
                this.insertReqPlanByDataVo(ctx, dataVO, 90, "sdRQaQEoEADgAAvafwAAAdhs+cg=");
            } else if (oprType == 201) {
                this.updateReqPlanStatus(ctx, dataVO, ReqPlanStatusEnum.CLOSED);
            } else if (oprType == 303) {
                this.updateReqPlanStatus(ctx, dataVO, ReqPlanStatusEnum.ACTIVE);
            }
        }
    }
}

