/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.ReqPlanException;
import com.kingdee.eas.mm.planning.ReqPlanWriteOffFacadeFactory;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.app.AbstractReqPlanSOPFacadeControllerBean;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class ReqPlanSOPFacadeControllerBean
extends AbstractReqPlanSOPFacadeControllerBean {
    private static final long serialVersionUID = -4757289695417153036L;
    private static Logger logger = Logger.getLogger((String)ReqPlanSOPFacadeControllerBean.class.getName());
    public static final Format df = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    protected void _requireFromSOP(Context ctx, String storageOrgUnitID, String tempTableName, Date beginDate, Date endDate, boolean delBeforRequire) throws BOSException, EASBizException {
        int i;
        List storageOrgUnitIDs = this.getstorageOrgUnitIDs(ctx, tempTableName);
        for (i = 0; i < storageOrgUnitIDs.size(); ++i) {
            if (this.isCodeRuleExist(ctx, storageOrgUnitIDs.get(i).toString())) continue;
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        for (i = 0; i < storageOrgUnitIDs.size(); ++i) {
            this.receiveDataNew(ctx, storageOrgUnitIDs.get(i).toString(), tempTableName, beginDate, endDate, delBeforRequire);
        }
    }

    private List getstorageOrgUnitIDs(Context ctx, String tempTableName) throws BOSException {
        ArrayList<String> storageOrgUnitIDs = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select FSupplyStorageID ,min(fid) from ").append(tempTableName);
        sb.append(" where fqty>0  group by FSupplyStorageID ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        int i = 0;
        try {
            while (rs.next()) {
                storageOrgUnitIDs.add(rs.getString("FSupplyStorageID"));
                ++i;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return storageOrgUnitIDs;
    }

    private boolean isCodeRuleExist(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID != null) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RequirementPlanInfo reqInfo = new RequirementPlanInfo();
            return iCodingRuleManager.isExist((IObjectValue)reqInfo, storageOrgUnitID);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveDataNew(Context ctx, String storageOrgUnitID, String tempTableName, Date beginDate, Date endDate, boolean delBeforRequire) throws BOSException, EASBizException {
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), (String)"SOP_TRANSFER_AVERAGE");
        String Tmp_MaterialQty = null;
        String beginDateStr = df.format(beginDate);
        String endDateStr = df.format(endDate);
        try {
            if (paramValue.equalsIgnoreCase("true") || paramValue.equals("1")) {
                this.deletePlan(ctx, tempTableName, beginDateStr, endDateStr, true);
                this.insertPlan(ctx, tempTableName, beginDateStr, endDateStr);
            } else {
                this.deletePlan(ctx, tempTableName, beginDateStr, endDateStr, false);
                if (delBeforRequire) {
                    String createSql = "create table rsTmpTable(fStorageOrgUnitID VARCHAR(44),FMaterialID VARCHAR(44),FPeriod VARCHAR(44),  FQty NUMERIC(21,8) DEFAULT 0 NOT NULL,FBaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL)";
                    Tmp_MaterialQty = KsqlUtil.createTempTable((Context)ctx, (String)createSql);
                    this.insertPlanForAverage(ctx, tempTableName, beginDateStr, endDateStr, storageOrgUnitID, Tmp_MaterialQty);
                } else {
                    this.insertPlan(ctx, tempTableName, beginDateStr, endDateStr);
                }
            }
            this.updateReqplanNumber(ctx, storageOrgUnitID, tempTableName);
            if (storageOrgUnitID != null) {
                ReqPlanWriteOffFacadeFactory.getLocalInstance(ctx).batchDealCounteract(storageOrgUnitID);
            }
        }
        catch (Throwable throwable) {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tempTableName);
            KsqlUtil.releaseTempTable((Context)ctx, Tmp_MaterialQty);
            throw throwable;
        }
        KsqlUtil.releaseTempTable((Context)ctx, (String)tempTableName);
        KsqlUtil.releaseTempTable((Context)ctx, (String)Tmp_MaterialQty);
    }

    private void deletePlan(Context ctx, String tempTableName, String beginDate, String endDate, boolean isAverage) throws BOSException {
        StringBuffer sql_delReq = new StringBuffer();
        sql_delReq.append("delete from t_mm_RequirementPlan where ");
        sql_delReq.append(" fid in(");
        sql_delReq.append(" select rp.fid from T_MM_RequirementPlan as rp");
        sql_delReq.append(" inner join ").append(tempTableName).append(" as sop ");
        sql_delReq.append(" on rp.FStorageOrgUnitID = sop.FSupplyStorageID and sop.fMaterialID = rp.fMaterialID");
        if (isAverage) {
            sql_delReq.append(" where (sop.fQty = 0 and  rp.fCntactTotalQty = 0)");
            sql_delReq.append(" and sop.fDate = rp.fRequireDate ");
        } else {
            sql_delReq.append(" where   rp.fCntactTotalQty = 0 ");
            sql_delReq.append(" and fRequireDate >= to_date('").append(beginDate + "')");
            sql_delReq.append(" and fRequireDate<= to_date('").append(endDate).append("')");
        }
        sql_delReq.append(" and rp. fReqSource =").append("30)");
        DbUtil.execute((Context)ctx, (String)sql_delReq.toString());
    }

    private void insertPlan(Context ctx, String tempTableName, String beginDate, String endDate) throws BOSException {
        StringBuffer sql_uptReqOfSOP = new StringBuffer();
        StringBuffer sql_instReqFrmSOP = new StringBuffer();
        sql_uptReqOfSOP.append("Update T_MM_RequirementPlan as a ");
        sql_uptReqOfSOP.append("set (fQty,fBaseQty,fStatus)= ");
        sql_uptReqOfSOP.append("(select");
        sql_uptReqOfSOP.append(" case when M.fQty > a.fCntactTotalQty then M.fQty else a.fCntactTotalQty end,");
        sql_uptReqOfSOP.append(" case when M.fBaseQty > a.fBaseCntactTotalQty then M.fBaseQty else a.fBaseCntactTotalQty end,");
        sql_uptReqOfSOP.append(" case when M.fQty > a.fCntactTotalQty then ");
        sql_uptReqOfSOP.append(10);
        sql_uptReqOfSOP.append(" else ");
        sql_uptReqOfSOP.append(20);
        sql_uptReqOfSOP.append(" end");
        sql_uptReqOfSOP.append(" from ").append(tempTableName).append(" as M ");
        sql_uptReqOfSOP.append(" where  a.fStorageOrgUnitID = m.FSupplyStorageID ");
        sql_uptReqOfSOP.append(" and  a.fMaterialID = M.fMaterialID");
        sql_uptReqOfSOP.append(" and M.fDate = a.fRequireDate");
        sql_uptReqOfSOP.append(" and a.fReqSource=").append(30);
        sql_uptReqOfSOP.append(")");
        DbUtil.execute((Context)ctx, (String)sql_uptReqOfSOP.toString());
        sql_instReqFrmSOP.append("insert into T_MM_RequirementPlan ");
        sql_instReqFrmSOP.append("(fID,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,fReqSource,fReqTypeID,fManuStrategyID,fRequireDate");
        sql_instReqFrmSOP.append(",fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fStatus,fPlanMode,fControlUnitID,FCreatorID,FCreateTime,FSourceBillID");
        sql_instReqFrmSOP.append(",FPlannerID,FProductionDeptID) ");
        sql_instReqFrmSOP.append(" select newbosid('D86AF5B7'),m.FSupplyStorageID ,m.fStorageOrgUnitID,m.fMaterialID,m.fUnitID,m.fBaseUnitID");
        sql_instReqFrmSOP.append(",30");
        sql_instReqFrmSOP.append(",case when p.FIsComReqConsume =1 then '").append("NcvxPgEcEADgAAiowKgL09hs+cg=");
        sql_instReqFrmSOP.append("'  when p.fManufactureStrategyID in ('").append("NUnM+gEcEADgAA3gwKgL09g0uEU=");
        sql_instReqFrmSOP.append("','").append("qAYbemEdG9ngQKjAYj0V1dg0uEU=");
        sql_instReqFrmSOP.append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=");
        sql_instReqFrmSOP.append("','").append("qAYfaBzUrmLgQKjAYj0f3dg0uEU=");
        sql_instReqFrmSOP.append("')then '").append("NcvxPgEcEADgAAiqwKgL09hs+cg=").append("' else  '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("' end");
        sql_instReqFrmSOP.append(",p.fManufactureStrategyID,TO_DATE(SUBSTRING(TO_CHAR(m.fDate, 'YYYY-MM-DD'),1,10) || ' 00:00:00'),m.fQty");
        sql_instReqFrmSOP.append(",m.fBaseQty,0,0,");
        sql_instReqFrmSOP.append(10).append(",p.FPlanningMode,org.FControlUnitID ");
        sql_instReqFrmSOP.append(",'" + ctx.getCaller().toString() + "',now()");
        sql_instReqFrmSOP.append(",m.fid");
        sql_instReqFrmSOP.append(", p.FPlanner");
        sql_instReqFrmSOP.append(", p.FDutyDepartment");
        sql_instReqFrmSOP.append(" from ").append(tempTableName).append(" as m   ");
        sql_instReqFrmSOP.append(" inner join  t_bd_materialplan as p on m.fMaterialID = p.fMaterialID");
        sql_instReqFrmSOP.append(" left outer join t_org_storage as org on m.FSupplyStorageID = org.FID ");
        sql_instReqFrmSOP.append(" where ");
        sql_instReqFrmSOP.append("  m.FSupplyStorageID = p.FOrgUnit ");
        sql_instReqFrmSOP.append(" and p.fManufactureStrategyID is not null ");
        sql_instReqFrmSOP.append(" and \tm.fQty > 0 ");
        sql_instReqFrmSOP.append(" and not exists (select 1");
        sql_instReqFrmSOP.append(" from T_MM_RequirementPlan as r");
        sql_instReqFrmSOP.append(" where r.fStorageOrgUnitID =  m.FSupplyStorageID");
        sql_instReqFrmSOP.append(" and r.fReqSource = ").append(30);
        sql_instReqFrmSOP.append(" and r.fMaterialID = m.fMaterialID");
        sql_instReqFrmSOP.append(" and to_char(r.fRequireDate,'yyyy-mm-dd')= to_char(m.fDate,'yyyy-mm-dd')");
        sql_instReqFrmSOP.append(")");
        DbUtil.execute((Context)ctx, (String)sql_instReqFrmSOP.toString());
    }

    private void insertPlanForAverage(Context ctx, String tempTableName, String beginDate, String endDate, String storageOrgUnitID, String Tmp_MaterialQty) throws BOSException {
        StringBuffer sql_uptReqOfSOP = new StringBuffer();
        StringBuffer sql_instReqFrmSOP = new StringBuffer();
        StringBuffer sqlBuffer_updateQtyAndStatus = new StringBuffer();
        sqlBuffer_updateQtyAndStatus.append(" update T_MM_RequirementPlan as rp set FQTY = fCntactTotalQty,");
        sqlBuffer_updateQtyAndStatus.append(" FBaseQty = fBaseCntactTotalQty,FStatus = 20");
        sqlBuffer_updateQtyAndStatus.append(" where fStorageOrgUnitID = '").append(storageOrgUnitID);
        sqlBuffer_updateQtyAndStatus.append("' and fRequireDate >= to_date('").append(beginDate + "')");
        sqlBuffer_updateQtyAndStatus.append(" and fRequireDate<= to_date('").append(endDate).append("')");
        sqlBuffer_updateQtyAndStatus.append(" and fReqSource = ").append(30);
        sqlBuffer_updateQtyAndStatus.append(" and fBaseCntactTotalQty >0 ");
        sqlBuffer_updateQtyAndStatus.append(" and fMaterialID in (select distinct fMaterialID from ").append(tempTableName).append(")");
        DbUtil.execute((Context)ctx, (String)sqlBuffer_updateQtyAndStatus.toString());
        StringBuffer sql_getCntQty = new StringBuffer();
        sql_getCntQty.append(" insert into " + Tmp_MaterialQty + "(FStorageOrgUnitID,FMaterialID,FPeriod,FQty,FBaseQty)");
        sql_getCntQty.append(" select sop.FStorageOrgUnitID,sop.FMaterialID,sop.FPeriod,");
        sql_getCntQty.append("  isnull(sum(rp.FCntactTotalQty),0) as FCntactTotalQty,");
        sql_getCntQty.append(" isnull(sum(rp.FBaseCntactTotalQty),0) as FBaseCntactTotalQty ");
        sql_getCntQty.append(" from ").append(tempTableName).append(" as sop ");
        sql_getCntQty.append(" inner join T_MM_RequirementPlan  as rp ");
        sql_getCntQty.append("      on sop.FSupplyStorageID = rp.FStorageOrgUnitID and sop.FMaterialID = rp.FMaterialID");
        sql_getCntQty.append("      where rp.FReqSource = ").append(30);
        sql_getCntQty.append("      and to_char(rp.FRequireDate,'YYYY-MM-DD') >= to_char(sop.FPeriodStartDate,'YYYY-MM-DD')");
        sql_getCntQty.append("      and to_char(rp.FRequireDate,'YYYY-MM-DD') <= to_char(sop.FPeriodEndDate,'YYYY-MM-DD')");
        sql_getCntQty.append(" group by sop.FStorageOrgUnitID,sop.FMaterialID,sop.FPeriod");
        DbUtil.execute((Context)ctx, (String)sql_getCntQty.toString());
        sql_instReqFrmSOP.append("insert into T_MM_RequirementPlan ");
        sql_instReqFrmSOP.append("(fID,fStorageOrgUnitID,fSourceSUID,fMaterialID,fUnitID,fBaseUnitID,fReqSource,fReqTypeID,fManuStrategyID,fRequireDate");
        sql_instReqFrmSOP.append(",fQty,fBaseQty,fCntactTotalQty,fBaseCntactTotalQty,fStatus,fPlanMode,fControlUnitID,FCreatorID,FCreateTime,FSourceBillID ");
        sql_instReqFrmSOP.append(",FPlannerID,FProductionDeptID )");
        sql_instReqFrmSOP.append("select newbosid('D86AF5B7'),m.FSupplyStorageID ,m.fStorageOrgUnitID,m.fMaterialID,m.fUnitID,m.fBaseUnitID");
        sql_instReqFrmSOP.append(",30");
        sql_instReqFrmSOP.append(",case when p.FIsComReqConsume =1 then '").append("NcvxPgEcEADgAAiowKgL09hs+cg=");
        sql_instReqFrmSOP.append("'  when p.fManufactureStrategyID in ('").append("NUnM+gEcEADgAA3gwKgL09g0uEU=");
        sql_instReqFrmSOP.append("','").append("qAYbemEdG9ngQKjAYj0V1dg0uEU=");
        sql_instReqFrmSOP.append("','").append("qAYfaBzTrmLgQKjAYj0f3dg0uEU=");
        sql_instReqFrmSOP.append("','").append("qAYfaBzUrmLgQKjAYj0f3dg0uEU=");
        sql_instReqFrmSOP.append("')then '").append("NcvxPgEcEADgAAiqwKgL09hs+cg=").append("' else  '").append("NcvxPgEcEADgAAiowKgL09hs+cg=").append("' end");
        sql_instReqFrmSOP.append(",p.fManufactureStrategyID,TO_DATE(SUBSTRING(TO_CHAR(m.fDate, 'YYYY-MM-DD'),1,10) || ' 00:00:00'),m.FQty-isnull(qtyTmp.fQty,0)");
        sql_instReqFrmSOP.append(",m.FBaseQty-isnull(qtyTmp.FBaseQty,0),0,0,");
        sql_instReqFrmSOP.append(10).append(",p.FPlanningMode,org.FControlUnitID ");
        sql_instReqFrmSOP.append(",'" + ctx.getCaller().toString() + "',now()");
        sql_instReqFrmSOP.append(",m.fid");
        sql_instReqFrmSOP.append(", p.FPlanner");
        sql_instReqFrmSOP.append(", p.FDutyDepartment");
        sql_instReqFrmSOP.append(" from ").append(tempTableName).append(" as m   ");
        sql_instReqFrmSOP.append(" inner join  t_bd_materialplan as p on m.fMaterialID = p.fMaterialID and m.FSupplyStorageID = p.FOrgUnit");
        sql_instReqFrmSOP.append(" inner  join t_org_storage as org on m.FSupplyStorageID = org.FID ");
        sql_instReqFrmSOP.append(" left  join " + Tmp_MaterialQty + " as  qtyTmp ");
        sql_instReqFrmSOP.append(" on m.FSupplyStorageID = qtyTmp.FStorageOrgUnitID and m.FMaterialID = qtyTmp.FMaterialID");
        sql_instReqFrmSOP.append(" and m.FPeriod = qtyTmp.FPeriod ");
        sql_instReqFrmSOP.append(" where p.fManufactureStrategyID is not null ");
        sql_instReqFrmSOP.append(" and not exists (select 1");
        sql_instReqFrmSOP.append(" from T_MM_RequirementPlan as r");
        sql_instReqFrmSOP.append(" where r.fStorageOrgUnitID = '" + storageOrgUnitID + "'");
        sql_instReqFrmSOP.append(" and r.fReqSource = ").append(30);
        sql_instReqFrmSOP.append(" and r.fMaterialID = m.fMaterialID");
        sql_instReqFrmSOP.append(" and to_char(r.fRequireDate,'yyyy-mm-dd')= to_char(m.fDate,'yyyy-mm-dd')");
        sql_instReqFrmSOP.append(" )");
        sql_instReqFrmSOP.append(" and (m.FQty-isnull(qtyTmp.fQty,0))> 0");
        DbUtil.execute((Context)ctx, (String)sql_instReqFrmSOP.toString());
        sql_uptReqOfSOP.append("Update T_MM_RequirementPlan as a ");
        sql_uptReqOfSOP.append("set (fQty,fBaseQty,fStatus)= ");
        sql_uptReqOfSOP.append("(select");
        sql_uptReqOfSOP.append(" case when M.fQty-isnull(qtyTmp.FQty,0)+ a.FCntactTotalQty > a.fCntactTotalQty ").append(" then M.fQty-isnull(qtyTmp.FQty,0)+ a.FCntactTotalQty else a.fCntactTotalQty end,");
        sql_uptReqOfSOP.append(" case when M.fBaseQty-isnull(qtyTmp.FBaseQty,0)+ a.fBaseCntactTotalQty > a.fBaseCntactTotalQty ").append(" then M.fBaseQty-isnull(qtyTmp.FBaseQty,0)+ a.fBaseCntactTotalQty else a.fBaseCntactTotalQty end,");
        sql_uptReqOfSOP.append(" case when M.fQty-isnull(qtyTmp.FQty,0)+ a.FCntactTotalQty > a.fCntactTotalQty then ");
        sql_uptReqOfSOP.append(10);
        sql_uptReqOfSOP.append(" else ");
        sql_uptReqOfSOP.append(20);
        sql_uptReqOfSOP.append(" end");
        sql_uptReqOfSOP.append(" from ").append(tempTableName).append(" as m   ");
        sql_uptReqOfSOP.append(" left join " + Tmp_MaterialQty + " qtyTmp ");
        sql_uptReqOfSOP.append(" on m.FSupplyStorageID = qtyTmp.FStorageOrgUnitID and m.FMaterialID = qtyTmp.FMaterialID");
        sql_uptReqOfSOP.append(" and m.FPeriod = qtyTmp.FPeriod ");
        sql_uptReqOfSOP.append(" where a.fStorageOrgUnitID = m.FSupplyStorageID");
        sql_uptReqOfSOP.append(" and a.fMaterialID = M.fMaterialID");
        sql_uptReqOfSOP.append(" and M.fDate = a.fRequireDate");
        sql_uptReqOfSOP.append(" and isnull(qtyTmp.fQty,0) > 0");
        sql_uptReqOfSOP.append(" and a.fReqSource=").append(30);
        sql_uptReqOfSOP.append(")");
        DbUtil.execute((Context)ctx, (String)sql_uptReqOfSOP.toString());
        KsqlUtil.releaseTempTable((Context)ctx, (String)Tmp_MaterialQty);
    }

    private void updateReqplanNumber(Context ctx, String storageOrgUnitID, String tempTableName) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            StringBuffer sql_getNewRecordID = new StringBuffer();
            sql_getNewRecordID.append("Select r.FID FROM T_MM_RequirementPlan as r ");
            sql_getNewRecordID.append(" inner join ").append(tempTableName).append(" as t on t.fid = r.FSourceBillid ");
            sql_getNewRecordID.append(" where r.fnumber is null and  r.fStorageOrgUnitID = t.FSupplyStorageID ");
            sql_getNewRecordID.append(" and  t.FSupplyStorageID = '").append(storageOrgUnitID).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_getNewRecordID.toString());
            if (rs.size() > 0) {
                int count = 0;
                String[] billNumber = this.getNumbers(ctx, storageOrgUnitID, rs.size());
                String sql_updateNumber = " update T_MM_RequirementPlan set FNumber = ?,FSourceBillid =null  where FID = ? ";
                conn = EJBFactory.getConnection((Context)ctx);
                batchStatement = conn.prepareStatement(sql_updateNumber);
                while (rs.next()) {
                    batchStatement.setString(1, billNumber[count++]);
                    batchStatement.setString(2, rs.getString("FID"));
                    batchStatement.addBatch();
                }
                batchStatement.executeBatch();
                SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(batchStatement, conn);
        }
    }

    private String[] getNumbers(Context ctx, String storageOrgUnitID, int count) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RequirementPlanInfo reqInfo = new RequirementPlanInfo();
        Calendar cal = Calendar.getInstance();
        reqInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        String[] nums = null;
        if (codingRuleManager.getCodingRule((IObjectValue)reqInfo, storageOrgUnitID) == null) {
            throw new ReqPlanException(ReqPlanException.NOCODINGRULE);
        }
        nums = codingRuleManager.getBatchNumber((IObjectValue)reqInfo, storageOrgUnitID, count);
        return nums;
    }
}

