/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.app.AbstractReqplanTotalFacadeControllerBean;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReqplanTotalFacadeControllerBean
extends AbstractReqplanTotalFacadeControllerBean {
    private static final long serialVersionUID = 1465505086514454108L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptRowSet rsSelect;
        String temp;
        HashMap workdates;
        int periodNumber;
        List dayPeriodList;
        List monthPeriodList;
        List weekPeriodList;
        String periodTempName;
        block13: {
            periodTempName = params.getString("periodTempName");
            String tempTable = params.getString("tempTable");
            int from = params.getInt("from");
            int lengh = params.getInt("lengh");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(ReqplanTotalFacadeControllerBean.getTime(null, "Start"));
            calendar.add(2, 1);
            Date planDateFrom = calendar.getTime();
            calendar.setTime(ReqplanTotalFacadeControllerBean.getTime(null, "end"));
            calendar.add(2, 1);
            Date planDateTo = calendar.getTime();
            if (params.getObject("planDateFrom") != null) {
                planDateFrom = (Date)params.getObject("planDateFrom");
            }
            if (params.getObject("planDateTo") != null) {
                planDateTo = (Date)params.getObject("planDateTo");
            }
            String storageOrgUnitid = null;
            if (params.getObject("storageOrgUnitId") != null) {
                OrgUnitInfo storageOrgUnitInfo = (OrgUnitInfo)params.getObject("storageOrgUnitId");
                storageOrgUnitid = storageOrgUnitInfo.getId().toString();
            } else {
                storageOrgUnitid = params.getString("storageOrgUnit.id");
            }
            int dayShowDays = 0;
            int weekShowDays = 0;
            if (params.getObject("dayShowDays") != null) {
                dayShowDays = new Integer((String)params.getObject("dayShowDays"));
            }
            if (params.getObject("weekShowDays") != null) {
                weekShowDays = new Integer((String)params.getObject("weekShowDays"));
            }
            HashMap periodListMap = this.getPeriodList(ctx, storageOrgUnitid, planDateFrom, planDateTo, dayShowDays, weekShowDays);
            weekPeriodList = (List)periodListMap.get("weekPeriodList");
            monthPeriodList = (List)periodListMap.get("monthPeriodList");
            dayPeriodList = (List)periodListMap.get("dayPeriodList");
            periodNumber = (Integer)periodListMap.get("periodNumber");
            workdates = (HashMap)this.getFactoryCalendar(ctx, storageOrgUnitid, planDateFrom, planDateTo);
            temp = null;
            rsSelect = null;
            try {
                tempTable = this.createTable(ctx, params);
                periodTempName = this.insertPeriodTmp(ctx, weekPeriodList, monthPeriodList, planDateFrom, planDateTo, dayShowDays, periodTempName);
                this.dealQtyByperiod(ctx, tempTable, periodTempName);
                temp = this.createTempQeryTable(ctx, tempTable, periodTempName);
                rsSelect = this.executeQuery(ctx, temp, from, lengh, periodNumber);
            }
            catch (Exception e) {
                if (e.getCause() instanceof SQLException) {
                    Exception e1 = JDBCExceptionHandler.convertException((SQLException)((SQLException)e.getCause()));
                    if (e1 instanceof DataLimitExceedException) {
                        throw new DataLimitExceedException((Throwable)e1);
                    }
                    break block13;
                }
                throw new BOSException((Throwable)e);
            }
            finally {
                this.cleanTempTable(ctx, periodTempName);
                this.cleanTempTable(ctx, tempTable);
            }
        }
        RptParams result = new RptParams();
        result.setString("tempTable", temp);
        result.setObject("rowset", (Object)rsSelect);
        result.setObject("dayPeriodList", (Object)dayPeriodList);
        result.setObject("weekPeriodList", (Object)weekPeriodList);
        result.setObject("monthPeriodList", (Object)monthPeriodList);
        result.setString("periodTempName", periodTempName);
        result.setInt("periodNumber", periodNumber);
        result.setObject("workdate", (Object)workdates);
        return result;
    }

    private void dealQtyByperiod(Context ctx, String tempTable, String periodTempName) throws BOSException {
        StringBuffer updataSQL = new StringBuffer();
        updataSQL.append(" update ").append(tempTable).append(" as x  set (fperiodnumber) = ").append("( select y.fnumber from   ").append(periodTempName).append(" as y where    to_date(x.FReqDate||' 00:00:00') >= to_date(y.fstartdate||' 00:00:00') ").append(" and to_date(x.FReqDate||' 00:00:00') <= to_date(y.fenddate||' 00:00:00')  ) ");
        DbUtil.execute((Context)ctx, (String)updataSQL.toString());
    }

    protected RptRowSet executeQuery(Context ctx, String temp, int from, int length, int periodNumber) throws BOSException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select * from ").append(temp);
        selectSql.append(" where KSQL_seq2 >");
        selectSql.append(new Integer(from).toString());
        selectSql.append(" and KSQL_seq2 <=");
        selectSql.append(new Integer(from + length).toString());
        selectSql.append(" order by KSQL_seq2 ");
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            RptRowSet rptRowSet = DBUtil.executeQuery((String)selectSql.toString(), (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + selectSql.toString()));
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private String createTable(Context ctx, RptParams params) throws BOSException {
        String tempName;
        StringBuffer tempNameSQL = new StringBuffer();
        tempNameSQL.append("CREATE TABLE TEMP_ReqPlanTotalTempName(").append("fid VARCHAR(44),").append("fnumber NVARCHAR(80),").append("fmaterialid VARCHAR(44),").append("fmaterialname NVARCHAR(255),").append("fmodel NVARCHAR(255),").append("funitname NVARCHAR(255),").append("FReqPlanType VARCHAR(44),").append("fperiodnumber VARCHAR(44),").append("FReqDate VARCHAR(44),").append("FQty NUMERIC(21,8) DEFAULT 0 NOT NULL,").append("fbaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL,").append("FsumQty NUMERIC(21,8) DEFAULT 0 NOT NULL,").append("FQtyPrecision int DEFAULT 4 NOT NULL )");
        try {
            tempName = TempTablePool.getInstance((Context)ctx).createTempTable(tempNameSQL.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String sql = this.getSelectSql(ctx, params);
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" insert into ").append(tempName).append(" (fid,fnumber,fmaterialid,fmaterialname,").append(" fmodel,funitname,FReqPlanType,fperiodnumber,FReqDate,FQty,fbaseQty,FQtyPrecision)  ").append(sql);
        DbUtil.execute((Context)ctx, (String)selectSql.toString());
        selectSql.setLength(0);
        selectSql.append(" insert into ").append(tempName);
        selectSql.append(" (fid,fnumber,fmaterialid,fmaterialname,");
        selectSql.append(" fmodel,funitname,fperiodnumber,FReqDate,FQty,fbaseQty,FQtyPrecision,FReqPlanType)  ");
        selectSql.append("( select  newbosid('12345678') as fid,fnumber,fmaterialid,fmaterialname,fmodel,");
        selectSql.append(" funitname,fperiodnumber,FReqDate,sum(FQty),sum(fbaseQty),FQtyPrecision,'");
        selectSql.append(this.getResouce("TotalPlan", ctx)).append("' as FReqPlanType ");
        selectSql.append(" from ").append(tempName);
        selectSql.append(" group by fnumber,fmaterialid,fmaterialname,fmodel,funitname,");
        selectSql.append(" fperiodnumber,FReqDate,FQtyPrecision");
        selectSql.append(")");
        DbUtil.execute((Context)ctx, (String)selectSql.toString());
        selectSql.setLength(0);
        selectSql.append(" delete from ").append(tempName).append(" where FReqPlanType <> '").append(this.getResouce("TotalPlan", ctx)).append("'");
        if (params.getBoolean("IsOnlyShowTotal")) {
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
        }
        return tempName;
    }

    private String getSelectSql(Context ctx, RptParams params) throws BOSException {
        String format = "yyyy-MM-dd";
        StringBuffer sql_where = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ReqplanTotalFacadeControllerBean.getTime(null, "Start"));
        calendar.add(2, 1);
        Date planDateFrom = calendar.getTime();
        calendar.setTime(ReqplanTotalFacadeControllerBean.getTime(null, "end"));
        calendar.add(2, 1);
        Date planDateTo = calendar.getTime();
        if (params.getObject("planDateFrom") != null) {
            planDateFrom = (Date)params.getObject("planDateFrom");
        }
        if (params.getObject("planDateTo") != null) {
            planDateTo = (Date)params.getObject("planDateTo");
            calendar.setTime(planDateTo);
            calendar.add(6, 1);
            planDateTo = calendar.getTime();
        }
        if (!params.getBoolean("IsOnlyShowTotal") && params.getObject("reqType.number") != null) {
            sql_where.append(" and rt.fnumber in ").append(MMUtils.setToString((Set)((HashSet)params.getObject("reqType.number"))));
        }
        if (params.getObject("material.materialGroup.number") != null) {
            sql_where.append(" and Mg.fnumber in ").append(MMUtils.setToString((Set)((HashSet)params.getObject("material.materialGroup.number"))));
        }
        if (params.getObject("material.number") != null) {
            sql_where.append(" and M.fnumber in ").append(MMUtils.setToString((Set)((HashSet)params.getObject("material.number"))));
        }
        if (params.getObject("trackNumber.number") != null) {
            sql_where.append(" and t.fnumber in ").append(MMUtils.setToString((Set)((HashSet)params.getObject("trackNumber.number"))));
        }
        if (params.getObject("project.number") != null) {
            sql_where.append(" and p.fnumber in ").append(MMUtils.setToString((Set)((HashSet)params.getObject("project.number"))));
        }
        if (params.getObject("planner.number") != null) {
            sql_where.append(" and person.fnumber in ").append(MMUtils.setToString((Set)((HashSet)params.getObject("planner.number"))));
        }
        if (params.getString("productionDeptFrom") != null) {
            sql_where.append(" and admin.fnumber >= '").append(params.getString("productionDeptFrom")).append("'");
        }
        if (params.getString("productionDeptTo") != null) {
            sql_where.append(" and admin.fnumber <= '").append(params.getString("productionDeptTo")).append("'");
        }
        if (params.getObject("status") != null) {
            sql_where.append(" and r.fstatus = ").append(new Integer((String)params.getObject("status")));
        }
        if (params.getString("sourcebillid") != null) {
            sql_where.append(" and r.FSourceBillID = '").append(params.getString("sourcebillid")).append("'");
        } else {
            sql_where.append("  and r.FRequireDate <to_date('").append(MMUtils.dateToString((Date)planDateTo, (String)format));
            sql_where.append("') and r.FRequireDate >=to_date('").append(MMUtils.dateToString((Date)planDateFrom, (String)format));
            sql_where.append("') ");
        }
        if (params.getString("id") != null) {
            sql_where.append(" and r.fid = '").append(params.getString("id")).append("'");
        }
        if (params.getObject("reqSource") != null) {
            sql_where.append(" and r.freqSource = ").append(new Integer((String)params.getObject("reqSource")));
        }
        if (params.getString("sourceBillNumFrom") != null) {
            sql_where.append(" and r.fsourceBillNum >= '").append(params.getString("sourceBillNumFrom")).append("'");
        }
        if (params.getString("sourceBillNumTo") != null) {
            sql_where.append(" and r.fsourceBillNum <= '").append(params.getString("sourceBillNumTo")).append("'");
        }
        String StorageOrgUnitID = params.getString("storageOrgUnit.id");
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" (select newbosid('12345678') as fid,m.fnumber,m.fid as fmaterialid,m.fname_").append(ctx.getLocale());
        selectSql.append(" as fmaterialname,m.fmodel,unit.fname_").append(ctx.getLocale()).append(" as funitname,");
        selectSql.append("  rt.fnumber as  FReqPlanType  ");
        selectSql.append(" ,'' as fperiodnumber,to_char(r.FRequireDate,'yyyy-mm-dd') as FRequireDate  , round(decimal(r.fbaseQty/(isnull(mmu.FBaseConvsRate,1)),21,8),isnull(mmu.FQtyPrecision,4)) as qty ,r.fbaseQty , ");
        selectSql.append(" isnull(mmu.FQtyPrecision,0)  ");
        selectSql.append(" from T_MM_RequirementPlan as r ");
        selectSql.append(" LEFT OUTER JOIN T_BD_Material AS M ON r.FMaterialID=M.FID ");
        selectSql.append(" LEFT OUTER JOIN T_BD_MaterialPlan AS mp ON mp.FMaterialID=M.FID and mp.forgunit =  r.FStorageOrgUnitID ");
        selectSql.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS Unit ON mp.FProductUnitID=Unit.FID ");
        selectSql.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS mmu ON mmu.FMaterialID=m.FID and mmu.FMeasureUnitID = mp.FProductUnitID");
        selectSql.append(" LEFT OUTER JOIN T_BD_MaterialGroup AS mg ON m.FMaterialGroupID=Mg.FID ");
        selectSql.append(" LEFT OUTER JOIN T_MM_Project AS p ON r.FProjectID=p.FID ");
        selectSql.append(" LEFT OUTER JOIN T_MM_TrackNumber AS t ON r.FTrackNumberID=t.FID ");
        selectSql.append(" LEFT OUTER JOIN T_BD_Person AS person ON r.FPlannerID=person.FID ");
        selectSql.append(" LEFT OUTER JOIN T_ORG_Admin AS admin ON r.FProductionDeptID=admin.FID ");
        selectSql.append(" LEFT OUTER JOIN T_MM_RequirementType AS rt ON r.FReqTypeID=rt.FID ");
        selectSql.append(" where r.FStorageOrgUnitID = '").append(StorageOrgUnitID).append("'");
        selectSql.append(sql_where.toString());
        selectSql.append(" order by m.fnumber )");
        return selectSql.toString();
    }

    private String createTempQeryTable(Context ctx, String tempTable, String periodTempName) throws BOSException, EASBizException {
        String tempName;
        String rowTemp = null;
        StringBuffer tempNameSQL = new StringBuffer();
        StringBuffer tempSQL = new StringBuffer();
        tempNameSQL.append("CREATE TABLE TEMP_ReqPlanTotalTempName(").append("KSQL_SEQ INT IDENTITY (1, 1) not null,").append("KSQL_SEQ2 INT ,").append("fnumber NVARCHAR(80),").append("fmaterialid VARCHAR(44),").append("fmaterialname NVARCHAR(255),").append("fmodel NVARCHAR(255),").append("funitname NVARCHAR(255),").append("FReqPlanType VARCHAR(44),").append("fperiodnumber VARCHAR(44),").append("FQtyPrecision int DEFAULT 4 NOT NULL, ").append("FsumQty NUMERIC(21,8) DEFAULT 0 NOT NULL,").append("FQty NUMERIC(21,8) DEFAULT 0 NOT NULL,").append("fbaseQty NUMERIC(21,8) DEFAULT 0 NOT NULL)");
        tempSQL.append("CREATE TABLE TEMP_ReqPlanTotalTempName(").append("KSQL_SEQ INT IDENTITY (1, 1) not null,").append("fnumber NVARCHAR(80),").append("fmaterialid VARCHAR(44),").append("FReqPlanType VARCHAR(44))");
        try {
            tempName = TempTablePool.getInstance((Context)ctx).createTempTable(tempNameSQL.toString());
            rowTemp = TempTablePool.getInstance((Context)ctx).createTempTable(tempSQL.toString());
            StringBuffer selectSql = new StringBuffer();
            selectSql.append(" insert into ").append(tempName);
            selectSql.append(" (KSQL_SEQ,KSQL_SEQ2,fnumber,fmaterialid,fmaterialname,");
            selectSql.append(" fmodel,funitname,FReqPlanType,fperiodnumber,FQtyPrecision,FQty,fbaseQty)  ");
            selectSql.append("( select 0,t.fnumber,t.fmaterialid,t.fmaterialname,t.fmodel, t.funitname,");
            selectSql.append(" t.FReqPlanType,t.fperiodnumber,t.FQtyPrecision,");
            selectSql.append(" sum(t.fqty),sum(t.fbaseqty) ");
            selectSql.append(" from ").append(tempTable).append(" as t ");
            selectSql.append(" inner join  ").append(periodTempName).append(" as p on t.fperiodnumber = p.fnumber ");
            selectSql.append(" group by t.fnumber,t.fmaterialid,t.fmaterialname,t.fmodel, t.funitname,");
            selectSql.append(" t.FReqPlanType,t.fperiodnumber, p.fnumber,t.FQtyPrecision,p.fdatetype ");
            selectSql.append(" order by t.fnumber,t.FReqPlanType,p.fdatetype,t.fperiodnumber)");
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" insert into ").append(rowTemp);
            selectSql.append(" (KSQL_SEQ,fnumber,fmaterialid,FReqPlanType)");
            selectSql.append(" ( select min(fnumber), fmaterialid, FReqPlanType from ").append(tempName);
            selectSql.append(" group by fmaterialid,FReqPlanType ,fnumber order by fnumber, FReqPlanType ) ");
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" update ").append(tempName).append(" as t set (KSQL_SEQ2 ) = ");
            selectSql.append(" (select KSQL_SEQ from ").append(rowTemp);
            selectSql.append(" as t1 where t.fmaterialid = t1.fmaterialid and t.FReqPlanType = t1.FReqPlanType)");
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" update ").append(tempName).append(" as t set (FsumQty)  = ");
            selectSql.append("  (select t1.fqty from ");
            selectSql.append(" (select  sum(fqty ) as fqty ,fmaterialid,FReqPlanType from ").append(tempName);
            selectSql.append(" group by fmaterialid, freqPlanType) as t1 ");
            selectSql.append(" where  t.fmaterialid = t1.fmaterialid and t.FReqPlanType = t1.FReqPlanType) ");
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                this._cleanTempTable(ctx, rowTemp);
                throw throwable;
            }
        }
        this._cleanTempTable(ctx, rowTemp);
        return tempName;
    }

    private Map getFactoryCalendar(Context ctx, String storageOrgUnitId, Date startDate, Date endDate) throws EASBizException, BOSException {
        HashMap factroyDates = (HashMap)FactoryCalendarFactory.getLocalInstance((Context)ctx).isWorkDay(storageOrgUnitId, startDate, endDate);
        return factroyDates;
    }

    protected String selectTempTableSql(Context ctx, String tempTable, String cSql, String storageOrgUnitId) throws BOSException, EASBizException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" select t.fmaterialID,t.fnumber,fmaterialname,t.fmodel,t.funitname,");
        selectSql.append(" t.FReqPlanType,t.fperiodnumber,t.FQty,t.baseQty,FsumQty");
        selectSql.append(cSql);
        selectSql.append(" from ").append(tempTable).append(" as t ");
        return selectSql.toString();
    }

    @Override
    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String temp = params.getString("tempTable");
        int periodNumber = params.getInt("periodNumber");
        RptRowSet rsSelect = this.executeQuery(ctx, temp, from, len, periodNumber);
        params.setObject("rowset", (Object)rsSelect);
        return params;
    }

    protected String createSelectSQL(Context ctx, List weekPeriodList, List monthPeriodList, OrgUnitInfo storageOrgUnitInfo, Date planDateFrom, Date planDateTo, int dayShowDays) throws EASBizException, BOSException {
        SOPPeriod temp;
        int i;
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy.MM.dd");
        Calendar theDate = Calendar.getInstance();
        for (i = 0; i < dayShowDays; ++i) {
            theDate.setTime(planDateFrom);
            sql.append(", sum(case when fperiodnumber = '").append(timeFormat.format(theDate.getTime())).append("'  then qty else 0 end) a").append(timeFormat.format(theDate.getTime()));
            theDate.add(5, 1);
            if (theDate.after(planDateTo)) break;
        }
        if (weekPeriodList != null) {
            for (i = 0; i < weekPeriodList.size(); ++i) {
                temp = (SOPPeriod)weekPeriodList.get(i);
                sql.append(", sum(case when fperiodnumber = '").append(temp.toNumber()).append("'  then qty else 0 end) a").append(temp.toNumber());
            }
        }
        if (monthPeriodList != null) {
            for (i = 0; i < monthPeriodList.size(); ++i) {
                temp = (SOPPeriod)monthPeriodList.get(i);
                sql.append(", sum(case when fperiodnumber = '").append(temp.toNumber()).append("'  then qty else 0 end) a").append(temp.toNumber());
            }
        }
        return sql.toString();
    }

    private String getResouce(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.mm.planning.ReqPlanTotalResource", (String)key, (Context)ctx);
    }

    @Override
    protected void _cleanTempTable(Context ctx, String temp) throws BOSException, EASBizException {
        ICommRptBase comm = CommRptBaseFactory.getLocalInstance((Context)ctx);
        if (temp != null) {
            comm.dropPoolTempTable(temp);
        }
    }

    protected HashMap getPeriodList(Context ctx, String storageOrgUnitID, Date planDateFrom, Date planDateTo, int dayShowDays, int weekShowDays) throws BOSException, EASBizException {
        List weekPeriodList = null;
        List monthPeriodList = null;
        List dayPeriodList = null;
        HashMap<String, Object> periodListMap = new HashMap<String, Object>();
        Date dayPlanDateTo = planDateFrom;
        Date weekPlanDateFrom = planDateFrom;
        Date weekPlanDateTo = planDateFrom;
        Date monthPlanDateFrom = planDateFrom;
        int periodNumber = 0;
        Calendar theDate = Calendar.getInstance();
        theDate.setTime(planDateFrom);
        if (dayShowDays > 0) {
            theDate.add(6, dayShowDays);
            dayPlanDateTo = theDate.getTime();
            if (dayPlanDateTo.after(planDateTo)) {
                dayPeriodList = this.getDateFormToDate(planDateFrom, planDateTo);
                periodListMap.put("dayPeriodList", dayPeriodList);
                periodListMap.put("periodNumber", new Integer(periodNumber += dayPeriodList.size()));
                return periodListMap;
            }
            dayPeriodList = this.getDateFormToDate(planDateFrom, dayPlanDateTo);
            periodNumber += dayPeriodList.size();
            periodListMap.put("dayPeriodList", dayPeriodList);
        }
        if (weekShowDays > 0) {
            weekPlanDateFrom = theDate.getTime();
            theDate.add(6, weekShowDays - 1);
            weekPlanDateTo = theDate.getTime();
            if (weekPlanDateTo.after(planDateTo)) {
                weekPeriodList = this.getBySOPFacadePeriod(ctx, storageOrgUnitID, weekPlanDateFrom, planDateTo, 10);
                periodListMap.put("weekPeriodList", weekPeriodList);
                periodListMap.put("periodNumber", new Integer(periodNumber += weekPeriodList.size()));
                return periodListMap;
            }
            weekPeriodList = this.getBySOPFacadePeriod(ctx, storageOrgUnitID, weekPlanDateFrom, weekPlanDateTo, 10);
            periodListMap.put("weekPeriodList", weekPeriodList);
            periodNumber += weekPeriodList.size();
            weekPeriodList = this.getBySOPFacadePeriod(ctx, storageOrgUnitID, weekPlanDateFrom, weekPlanDateTo, 10);
            theDate.add(6, 1);
        }
        if ((monthPlanDateFrom = theDate.getTime()).after(planDateTo)) {
            periodListMap.put("periodNumber", new Integer(periodNumber));
            return periodListMap;
        }
        monthPeriodList = this.getBySOPFacadePeriod(ctx, storageOrgUnitID, monthPlanDateFrom, planDateTo, 20);
        periodListMap.put("monthPeriodList", monthPeriodList);
        periodListMap.put("periodNumber", new Integer(periodNumber += monthPeriodList.size()));
        return periodListMap;
    }

    protected List getDateFormToDate(Date planDateFrom, Date planDateTo) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        Calendar planDateFromcal = Calendar.getInstance();
        planDateFromcal.setTime(planDateFrom);
        Calendar planDateTocal = Calendar.getInstance();
        planDateTocal.setTime(planDateTo);
        Calendar temp = Calendar.getInstance();
        temp.setTime(planDateFrom);
        while (planDateTocal.after(temp)) {
            dateList.add(temp.getTime());
            temp.add(6, 1);
        }
        return dateList;
    }

    private String insertPeriodTmp(Context ctx, List weekPeriodList, List monthPeriodList, Date planDateFrom, Date planDateTo, int dayShowDays, String tempName) throws EASBizException, BOSException {
        if (tempName == null) {
            StringBuffer periodTempNameSQL = new StringBuffer();
            periodTempNameSQL.append("CREATE TABLE TEMP_periodTempName(");
            periodTempNameSQL.append("fnumber VARCHAR(44),fstartdate VARCHAR(44),");
            periodTempNameSQL.append("fenddate VARCHAR(44), fdatetype int )");
            try {
                tempName = TempTablePool.getInstance((Context)ctx).createTempTable(periodTempNameSQL.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            this.cleanTempTable(ctx, tempName);
        }
        this.createProidTempTable(ctx, planDateFrom, planDateTo, null, tempName, dayShowDays, 1);
        if (weekPeriodList != null && weekPeriodList.size() > 0) {
            this.createProidTempTable(ctx, planDateFrom, null, weekPeriodList, tempName, dayShowDays, 2);
        }
        if (monthPeriodList != null && monthPeriodList.size() > 0) {
            this.createProidTempTable(ctx, planDateFrom, null, monthPeriodList, tempName, dayShowDays, 3);
        }
        return tempName;
    }

    protected List getBySOPFacadePeriod(Context ctx, String storageOrgUnitInfo, Date planDateFrom, Date planDateTo, int sSOPEditModeEnum) throws BOSException, EASBizException {
        Calendar planDateFromcal = Calendar.getInstance();
        planDateFromcal.setTime(planDateFrom);
        Calendar planDateTocal = Calendar.getInstance();
        planDateTocal.setTime(planDateTo);
        ISOPFacade iSOPFacade = SOPFacadeFactory.getLocalInstance(ctx);
        SOPPeriod sOPPeriodFrom = iSOPFacade.getPeriod(planDateFrom, SOPEditModeEnum.getEnum(sSOPEditModeEnum), storageOrgUnitInfo);
        List periodList = sOPPeriodFrom.forwardPeriodsOther(planDateTocal);
        ((SOPPeriod)periodList.get(0)).setBeginDate(planDateFromcal);
        ((SOPPeriod)periodList.get(periodList.size() - 1)).setEndDate(planDateTocal);
        return periodList;
    }

    protected void createProidTempTable(Context ctx, Date planDateFrom, Date planDateTo, List periodList, String tempName, int dayShowDays, int type) throws BOSException, EASBizException {
        Calendar theDate = Calendar.getInstance();
        theDate.setTime(planDateFrom);
        SimpleDateFormat time = new SimpleDateFormat("yyyy.MM.dd");
        String insertPeriodTempName = "insert into " + tempName + " (fnumber,fstartdate,fenddate,fdatetype) values(?,?,?,?)";
        Connection conn = null;
        PreparedStatement batchStatement = null;
        try {
            conn = this.getConnection(ctx);
            batchStatement = conn.prepareStatement(insertPeriodTempName);
            if (periodList != null) {
                for (int i = 0; i < periodList.size(); ++i) {
                    SOPPeriod temp = (SOPPeriod)periodList.get(i);
                    batchStatement.setString(1, temp.toString());
                    batchStatement.setString(2, time.format(temp.getBeginDate().getTime()));
                    batchStatement.setString(3, time.format(temp.getEndDate().getTime()));
                    batchStatement.setInt(4, type);
                    batchStatement.addBatch();
                }
            } else {
                for (int i = 0; i < dayShowDays; ++i) {
                    batchStatement.setString(1, time.format(theDate.getTime()));
                    batchStatement.setString(2, time.format(theDate.getTime()));
                    batchStatement.setString(3, time.format(theDate.getTime()));
                    batchStatement.setInt(4, type);
                    batchStatement.addBatch();
                    theDate.add(6, 1);
                    if (!theDate.getTime().after(planDateTo)) {
                        continue;
                    }
                    break;
                }
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(batchStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((Statement)batchStatement);
    }

    @Override
    protected int _periodNumber(Context ctx, String storageOrgUnitID, Date planDateFrom, Date planDateTo, int dayShowDays, int weekShowDays) throws BOSException, EASBizException {
        int periodNumber = 0;
        HashMap periodListMap = this.getPeriodList(ctx, storageOrgUnitID, planDateFrom, planDateTo, dayShowDays, weekShowDays);
        List dayPeriodList = (List)periodListMap.get("dayPeriodList");
        List weekPeriodList = (List)periodListMap.get("weekPeriodList");
        List monthPeriodList = (List)periodListMap.get("monthPeriodList");
        if (dayPeriodList != null && dayPeriodList.size() > 0) {
            periodNumber += dayPeriodList.size();
        }
        if (weekPeriodList != null && weekPeriodList.size() > 0) {
            periodNumber += weekPeriodList.size();
        }
        if (monthPeriodList != null && monthPeriodList.size() > 0) {
            periodNumber += monthPeriodList.size();
        }
        return periodNumber;
    }

    public static Timestamp getTime(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        } else {
            calendar.setTime(new Date());
        }
        if (s.equalsIgnoreCase("Start")) {
            calendar.add(2, -1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else if (s.equalsIgnoreCase("end")) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 999);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }
}

