/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BasedataException;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.planning.IRequirementPlan;
import com.kingdee.eas.mm.planning.IRequirementPlanHis;
import com.kingdee.eas.mm.planning.ReqPlanException;
import com.kingdee.eas.mm.planning.ReqPlanStatusEnum;
import com.kingdee.eas.mm.planning.RequirementPlanCntDtlVo;
import com.kingdee.eas.mm.planning.RequirementPlanFactory;
import com.kingdee.eas.mm.planning.RequirementPlanHisCollection;
import com.kingdee.eas.mm.planning.RequirementPlanHisFactory;
import com.kingdee.eas.mm.planning.RequirementPlanHisInfo;
import com.kingdee.eas.mm.planning.RequirementPlanInfo;
import com.kingdee.eas.mm.planning.app.AbstractRequirementPlanFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RequirementPlanFacadeControllerBean
extends AbstractRequirementPlanFacadeControllerBean {
    private static final long serialVersionUID = 7308222780880268253L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.RequirementPlanFacadeControllerBean");
    private static final String REQPLAN_RESOURCE_PATH = "com.kingdee.eas.mm.planning.ReqPlanResource";

    private RequirementPlanHisInfo changeReqPlanHisInfo(RequirementPlanInfo info) {
        RequirementPlanHisInfo hisInfo = new RequirementPlanHisInfo();
        hisInfo.setName(info.getName());
        hisInfo.setNumber(info.getNumber());
        hisInfo.setRequireDate(info.getRequireDate());
        hisInfo.setReqSource(info.getReqSource());
        hisInfo.setReqType(info.getReqType());
        hisInfo.setQty(info.getQty());
        hisInfo.setBaseQty(info.getBaseQty());
        hisInfo.setCntactTotalQty(info.getCntactTotalQty());
        hisInfo.setBaseCntactTotalQty(info.getBaseCntactTotalQty());
        hisInfo.setNotCntactQty(info.getNotCntactQty());
        hisInfo.setBaseNotCntactQty(info.getBaseNotCntactQty());
        hisInfo.setSourceBillID(info.getSourceBillID());
        hisInfo.setSourceBillNum(info.getSourceBillNum());
        hisInfo.setSourceEntryID(info.getSourceEntryID());
        hisInfo.setSourceEntrySeq(info.getSourceEntrySeq());
        hisInfo.setTraceNo(info.getTraceNo());
        hisInfo.setManuStrategy(info.getManuStrategy());
        hisInfo.setStatus(info.getStatus());
        hisInfo.setStorageOrgUnit(info.getStorageOrgUnit());
        hisInfo.setSourceSU(info.getSourceSU());
        hisInfo.setMaterial(info.getMaterial());
        hisInfo.setUnit(info.getUnit());
        hisInfo.setBaseUnit(info.getBaseUnit());
        hisInfo.setBillType(info.getBillType());
        hisInfo.setCreator(info.getCreator());
        hisInfo.setTrackNumber(info.getTrackNumber());
        hisInfo.setProject(info.getProject());
        hisInfo.setIsDirectTransport(info.isIsDirectTransport());
        hisInfo.setPlanner(info.getPlanner());
        hisInfo.setProductionDept(info.getProductionDept());
        hisInfo.setCalculateTime(info.getCalculateTime());
        return hisInfo;
    }

    @Override
    protected void _moveToHis(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        IRequirementPlan iRequirementPlan = RequirementPlanFactory.getLocalInstance(ctx);
        IRequirementPlanHis iRequirementPlanHis = RequirementPlanHisFactory.getLocalInstance(ctx);
        ObjectUuidPK id = new ObjectUuidPK(model.getId().toString());
        this.verifyCntactTotalQtyBeforeDelete(ctx, (IObjectPK)id);
        iRequirementPlan.delete((IObjectPK)id);
        iRequirementPlanHis.addnew(model);
        RequirementPlanInfo info = (RequirementPlanInfo)model;
        if (info != null) {
            String storageOrgUnitId = info.getStorageOrgUnit().getId().toString();
            this.insertReqPlantem(ctx, storageOrgUnitId);
        }
    }

    protected void verifyCntactTotalQtyBeforeDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRequirementPlan iRequirementPlan = RequirementPlanFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("reqType.id"));
        sic.add(new SelectorItemInfo("reqType.number"));
        sic.add(new SelectorItemInfo("reqType.name"));
        CoreBaseInfo info = iRequirementPlan.getValue(pk, sic);
        RequirementPlanInfo reqPlanInfo = (RequirementPlanInfo)info;
        if (reqPlanInfo.getCntactTotalQty().compareTo(new BigDecimal(0.0)) > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"materialIsNull", (Locale)ctx.getLocale())).append(":");
            sb.append(reqPlanInfo.getMaterial().getNumber());
            sb.append(",");
            sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"RequireDate", (Locale)ctx.getLocale())).append(":");
            sb.append(reqPlanInfo.getRequireDate());
            sb.append(",");
            sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"reqTypeIsNull", (Locale)ctx.getLocale())).append(":");
            sb.append(reqPlanInfo.getReqType().getName());
            sb.append(",");
            sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"reqSource", (Locale)ctx.getLocale())).append(":");
            sb.append(reqPlanInfo.getReqSource().getAlias());
            sb.append(ResourceManage.getResource((String)REQPLAN_RESOURCE_PATH, (String)"cntQtymorethan0", (Locale)ctx.getLocale()));
            throw new BasedataException(BasedataException.BLANK, (Object[])new String[]{sb.toString()});
        }
    }

    protected void verifyStatusBeforeDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRequirementPlan iRequirementPlan = RequirementPlanFactory.getLocalInstance(ctx);
        CoreBaseInfo info = iRequirementPlan.getValue(pk);
        RequirementPlanInfo reqPlanInfo = (RequirementPlanInfo)info;
        if (reqPlanInfo.getStatus().equals((Object)ReqPlanStatusEnum.ACTIVE)) {
            throw new ReqPlanException(ReqPlanException.STATUSACTIVE);
        }
    }

    private void insertReqPlantem(Context ctx, String storageOrgUnitId) throws BOSException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("Insert into T_MM_Reqplantmp(FID,FSTORAGEORGUNITID,FORIGINTYPE,FFAILTIMES,FCREATETIME,FCREATORID) \n");
        sqlBuffer.append(" values (");
        sqlBuffer.append("NewBOSID('D02F7535'),'");
        sqlBuffer.append(storageOrgUnitId);
        sqlBuffer.append("',");
        sqlBuffer.append(50);
        sqlBuffer.append(",");
        sqlBuffer.append(0);
        sqlBuffer.append(",");
        sqlBuffer.append("now()");
        sqlBuffer.append(",'");
        sqlBuffer.append(ctx.getCaller().toString());
        sqlBuffer.append("')");
        DbUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    @Override
    protected List _applyBatchDataMutex(Context ctx, List idList) throws BOSException, EASBizException {
        LinkedList<String> rs = new LinkedList<String>();
        if (null == idList || 0 == idList.size()) {
            return rs;
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Iterator iterator = idList.iterator();
        String objectId = null;
        boolean locked = false;
        while (iterator.hasNext()) {
            objectId = (String)iterator.next();
            locked = mutex.requestObjIDForUpdate(objectId, ctx.getUserName());
            if (!locked) continue;
            rs.add(objectId);
        }
        return rs;
    }

    @Override
    protected void _releaseBatchDataMutex(Context ctx, List idList) throws BOSException, EASBizException {
        if (null == idList || 0 == idList.size()) {
            return;
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutex.batchReleaseObjIDForUpdate(idList);
    }

    @Override
    protected Map _getMultiUnitScale(Context ctx, String[] materialIds, String[] measureUnitIds) throws BOSException, EASBizException {
        HashMap<String, Integer> mmuPrecisions = new HashMap<String, Integer>();
        if (materialIds == null || measureUnitIds == null) {
            return mmuPrecisions;
        }
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        int size = materialIds.length;
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                maskString.append(" or ");
            }
            maskString.append("(#").append(2 * i).append(" and #").append(2 * i + 1).append(")");
            filter.appendFilterItem("material", (Object)materialIds[i]);
            filter.appendFilterItem("measureUnit", (Object)measureUnitIds[i]);
        }
        if (filter.getFilterItems().size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter.setMaskString(maskString.toString());
            view.setFilter(filter);
            view.getSelector().add("material");
            view.getSelector().add("measureUnit");
            view.getSelector().add("baseConvsRate");
            view.getSelector().add("qtyPrecision");
            MultiMeasureUnitCollection mmuCol = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
            int size2 = mmuCol.size();
            for (int i = 0; i < size2; ++i) {
                MultiMeasureUnitInfo mmuInfo = mmuCol.get(i);
                mmuPrecisions.put(mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString(), new Integer(mmuInfo.getQtyPrecision()));
            }
        }
        return mmuPrecisions;
    }

    @Override
    protected void _moveToHis(Context ctx, EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        IRequirementPlan iRequirementPlan = RequirementPlanFactory.getLocalInstance(ctx);
        IRequirementPlanHis iRequirementPlanHis = RequirementPlanHisFactory.getLocalInstance(ctx);
        CoreBaseCollection reqPlanCollection = iRequirementPlan.getCollection(entityViewInfo);
        IObjectPK[] pks = new IObjectPK[reqPlanCollection.size()];
        RequirementPlanHisCollection reqPlanHisCollection = new RequirementPlanHisCollection();
        for (int i = 0; i < reqPlanCollection.size(); ++i) {
            RequirementPlanInfo info = (RequirementPlanInfo)reqPlanCollection.get(i);
            String id = info.getId().toString();
            pks[i] = new ObjectUuidPK(id);
            RequirementPlanHisInfo reqPlanHisInfo = this.changeReqPlanHisInfo(info);
            reqPlanHisCollection.add(reqPlanHisInfo);
        }
        iRequirementPlan.delete(pks);
        iRequirementPlanHis.addnew(reqPlanCollection);
        RequirementPlanInfo info = (RequirementPlanInfo)reqPlanCollection.get(0);
        if (info != null) {
            String storageOrgUnitId = info.getStorageOrgUnit().getId().toString();
            this.insertReqPlantem(ctx, storageOrgUnitId);
        }
    }

    @Override
    protected List _getCntDtlData(Context ctx, String destID) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement batchStatement = null;
        ResultSet reqRow = null;
        ArrayList<RequirementPlanCntDtlVo> list = new ArrayList<RequirementPlanCntDtlVo>();
        StringBuffer sb = new StringBuffer();
        sb.append("select rc.FBillTypeID, ");
        sb.append(" bt.FName_");
        sb.append(ctx.getLocale());
        sb.append(" as FBillTypeName,rc.FSourceNumber,rc.FSourceID");
        sb.append(",rc.FSourceEntryID,rc.FQty,mulUnit.FQtyPrecision ");
        sb.append(" from T_MM_ReqCounteractRelation rc inner join t_scm_billtype bt on rc.FBillTypeID = bt.fID ");
        sb.append(" inner join t_mm_requirementplan rp on rc.FDestID = rp.fID ");
        sb.append(" inner join t_bd_multimeasureunit mulUnit on mulUnit.FMaterialID = rp.FMaterialID ");
        sb.append(" and rc.FUnitID = mulUnit.FMeasureUnitID");
        sb.append(" where rc.FDestID = ?");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.prepareStatement(sb.toString());
            batchStatement.setString(1, destID);
            reqRow = batchStatement.executeQuery();
            while (reqRow.next()) {
                RequirementPlanCntDtlVo billVO = new RequirementPlanCntDtlVo();
                billVO.setBillID(reqRow.getString("FSourceID"));
                billVO.setEntryID(reqRow.getString("FSourceEntryID"));
                billVO.setBillTypeID(reqRow.getString("FBillTypeID"));
                billVO.setBillTypeName(reqRow.getString("FBillTypeName"));
                billVO.setContactQty(reqRow.getBigDecimal("FQty"));
                billVO.setNumber(reqRow.getString("FSourceNumber"));
                billVO.setQtyPrecision(reqRow.getInt("FQtyPrecision"));
                list.add(billVO);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(reqRow, batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)reqRow, (Statement)batchStatement, (Connection)conn);
        return list;
    }
}

