/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.CheckTypeEnum;
import com.kingdee.eas.mm.planning.SOPCheckFormulaCollection;
import com.kingdee.eas.mm.planning.SOPCheckFormulaException;
import com.kingdee.eas.mm.planning.SOPCheckFormulaFactory;
import com.kingdee.eas.mm.planning.SOPCheckFormulaInfo;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPlanVersionInfo;
import com.kingdee.eas.mm.planning.app.AbstractSOPCheckFormulaControllerBean;
import com.kingdee.eas.mm.planning.util.FormulaParserUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SOPCheckFormulaControllerBean
extends AbstractSOPCheckFormulaControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.SOPCheckFormulaControllerBean");
    public static final String RESOURCE = "com.kingdee.eas.mm.planning.SOPCheckFormulaResource";

    @Override
    protected List _checkSopData(Context ctx, IObjectValue orgUnit, SOPPeriod[] periods, Map dataMap, IObjectValue sopVersion) throws BOSException, EASBizException {
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)orgUnit;
        ArrayList list = new ArrayList();
        StringBuffer sb = new StringBuffer();
        Set keySet = dataMap.keySet();
        if (keySet.size() == 0) {
            sb.append("formula like '%").append(" ").append("%'");
        }
        for (String materialId : keySet) {
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append("formula like '%").append(materialId).append("%'");
        }
        String oql = "where storageOrgUnit.id = '" + storageOrgUnit.getId().toString() + "' and status = 20 and (" + sb.toString() + ")";
        SOPCheckFormulaCollection formulas = SOPCheckFormulaFactory.getLocalInstance(ctx).getSOPCheckFormulaCollection(oql);
        if (formulas != null && formulas.size() > 0) {
            Map map;
            int i;
            HashSet materialNums = new HashSet();
            int n = formulas.size();
            for (i = 0; i < n; ++i) {
                SOPCheckFormulaInfo formulaInfo = formulas.get(i);
                this.getMaterialsFromFormula(formulaInfo.getFormula(), keySet, materialNums);
            }
            if (materialNums.size() > 0 && (map = SOPFacadeFactory.getLocalInstance(ctx).getSopData(storageOrgUnit, periods, materialNums, (SOPPlanVersionInfo)sopVersion)) != null && map.size() > 0) {
                for (String materialNum : map.keySet()) {
                    dataMap.put(materialNum, map.get(materialNum));
                }
            }
            n = periods.length;
            for (i = 0; i < n; ++i) {
                String displayPeriod = null;
                displayPeriod = periods[i].getType().equals((Object)SOPEditModeEnum.WEEKLY) ? periods[i].toRangeString() : periods[i].toString();
                int m = formulas.size();
                for (int j = 0; j < m; ++j) {
                    SOPCheckFormulaInfo formulaInfo = formulas.get(j);
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    BigDecimal answer = this.calcFormula(formulaInfo.getFormula(), dataMap, i);
                    answer = answer.setScale(4, 4);
                    if (formulaInfo.getCheckType().equals((Object)CheckTypeEnum.LESSEQUALS)) {
                        BigDecimal diffRate = answer.multiply(new BigDecimal("100.00")).divide(formulaInfo.getCheckValue(), 2, 4);
                        if (answer.compareTo(formulaInfo.getCheckValue()) > 0) {
                            StringBuffer bs = new StringBuffer();
                            bs.append(formulaInfo.getCalcFormulaDesc()).append("=").append(String.valueOf(answer)).append(">").append(String.valueOf(formulaInfo.getCheckValue())).append("\uff0c");
                            bs.append(ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_GREATER", (String[])new String[]{String.valueOf(answer.subtract(formulaInfo.getCheckValue()))}));
                            map2.put("period", displayPeriod);
                            map2.put("checkResult", ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_NOTPASS"));
                            map2.put("formulaNumber", formulaInfo.getNumber());
                            map2.put("formulaName", formulaInfo.getName());
                            map2.put("answer", String.valueOf(answer));
                            map2.put("checkType", formulaInfo.getCheckType().getAlias());
                            map2.put("checkValue", String.valueOf(formulaInfo.getCheckValue()));
                            map2.put("tolerances", null);
                            map2.put("diffRate", String.valueOf(diffRate) + "%");
                            map2.put("detailInfo", bs.toString());
                        } else {
                            map2.put("period", displayPeriod);
                            map2.put("checkResult", ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_PASS"));
                            map2.put("formulaNumber", formulaInfo.getNumber());
                            map2.put("formulaName", formulaInfo.getName());
                            map2.put("answer", String.valueOf(answer));
                            map2.put("checkType", formulaInfo.getCheckType().getAlias());
                            map2.put("checkValue", String.valueOf(formulaInfo.getCheckValue()));
                            map2.put("tolerances", null);
                            map2.put("diffRate", String.valueOf(diffRate) + "%");
                            map2.put("detailInfo", null);
                        }
                    } else if (formulaInfo.getCheckType().equals((Object)CheckTypeEnum.TRUNC)) {
                        BigDecimal moreQty = formulaInfo.getCheckValue().multiply(answer.divide(formulaInfo.getCheckValue(), 0, 2));
                        BigDecimal lessQty = formulaInfo.getCheckValue().multiply(answer.divide(formulaInfo.getCheckValue(), 0, 3));
                        BigDecimal diffRate = null;
                        diffRate = moreQty.subtract(answer).compareTo(answer.subtract(lessQty)) < 0 ? moreQty.subtract(answer).multiply(new BigDecimal("100.00")).divide(formulaInfo.getCheckValue(), 2, 4) : answer.subtract(lessQty).multiply(new BigDecimal("100.00")).divide(formulaInfo.getCheckValue(), 2, 4);
                        if (diffRate.compareTo(formulaInfo.getTolerances()) > 0) {
                            StringBuffer bs = new StringBuffer();
                            bs.append(formulaInfo.getCalcFormulaDesc()).append("=").append(String.valueOf(answer));
                            bs.append(ResourceUtils.getMessageForServer((String)RESOURCE, (String)"FORMULADESC_ROUND", (String[])new String[]{String.valueOf(formulaInfo.getCheckValue())})).append("\uff0c");
                            bs.append(ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_ADJUST"));
                            map2.put("period", displayPeriod);
                            map2.put("checkResult", ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_NOTPASS"));
                            map2.put("formulaNumber", formulaInfo.getNumber());
                            map2.put("formulaName", formulaInfo.getName());
                            map2.put("answer", String.valueOf(answer));
                            map2.put("checkType", formulaInfo.getCheckType().getAlias());
                            map2.put("checkValue", String.valueOf(formulaInfo.getCheckValue()));
                            map2.put("tolerances", String.valueOf(formulaInfo.getTolerances()) + "%");
                            map2.put("diffRate", String.valueOf(diffRate) + "%");
                            map2.put("detailInfo", bs.toString());
                        } else {
                            map2.put("period", displayPeriod);
                            map2.put("checkResult", ResourceUtils.getMessageForServer((String)RESOURCE, (String)"CHECK_PASS"));
                            map2.put("formulaNumber", formulaInfo.getNumber());
                            map2.put("formulaName", formulaInfo.getName());
                            map2.put("answer", String.valueOf(answer));
                            map2.put("checkType", formulaInfo.getCheckType().getAlias());
                            map2.put("checkValue", String.valueOf(formulaInfo.getCheckValue()));
                            map2.put("tolerances", String.valueOf(formulaInfo.getTolerances()) + "%");
                            map2.put("diffRate", String.valueOf(diffRate) + "%");
                            map2.put("detailInfo", null);
                        }
                    }
                    list.add(map2);
                }
            }
            return list;
        }
        return null;
    }

    private BigDecimal calcFormula(String formula, Map dataMap, int index) throws BOSException {
        StringBuffer sb = new StringBuffer(formula);
        while (sb.length() > 0) {
            int begin = sb.indexOf("[");
            int end = sb.indexOf("]");
            if (begin < 0 || end < 0) break;
            String s = sb.substring(begin, end + 1);
            BigDecimal qty = null;
            String key = s.substring(1, s.length() - 1);
            if (dataMap != null && dataMap.containsKey(key)) {
                BigDecimal[] qtys = (BigDecimal[])dataMap.get(key);
                qty = qtys[index];
            }
            if (qty == null || qty.compareTo(new BigDecimal("0.0")) == 0) {
                qty = new BigDecimal("0.0");
            }
            sb = sb.replace(begin, end + 1, String.valueOf(qty));
        }
        FormulaParserUtil fp = new FormulaParserUtil(sb.toString());
        return new BigDecimal(fp.getResult(false));
    }

    private void getMaterialsFromFormula(String formula, Set keySet, Set materialNums) throws BOSException, EASBizException {
        int m = formula.length();
        for (int j = 0; j < m; ++j) {
            int begin = formula.indexOf("[", j);
            int end = formula.indexOf("]", j);
            if (begin < 0 || end < 0) break;
            String s = formula.substring(begin, end + 1);
            String key = s.substring(1, s.length() - 1);
            if (!keySet.contains(key)) {
                materialNums.add(key);
            }
            j = end;
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SOPCheckFormulaInfo formulaInfo = (SOPCheckFormulaInfo)model;
        this.setNewNumber(ctx, formulaInfo);
        this._checkNumberBlank(ctx, (IObjectValue)formulaInfo);
        this._checkNameBlank(ctx, (IObjectValue)formulaInfo);
        this._checkNameDup(ctx, (IObjectValue)formulaInfo);
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SOPCheckFormulaInfo info = this.getSOPCheckFormulaInfo(ctx, pk);
        if (info.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
            throw new SOPCheckFormulaException(SOPCheckFormulaException.DATAFORAPPROVED);
        }
        super._delete(ctx, pk);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        SOPCheckFormulaInfo formulaInfo = (SOPCheckFormulaInfo)model;
        FilterInfo filterInfo = super.getFilterForDefaultCU(ctx, (IObjectValue)formulaInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)formulaInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
        return filterInfo;
    }

    private void setNewNumber(Context ctx, DataBaseInfo caller) throws BOSException, EASBizException {
        if (caller.getNumber() != null) {
            return;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = iCodingRuleManager.getCurrentAppOUID((IObjectValue)caller);
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = this.getNextCompanyId(ctx);
        }
        if (orgId == null || orgId.trim().length() == 0) {
            return;
        }
        if (iCodingRuleManager.isExist((IObjectValue)caller, orgId)) {
            if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, orgId) && !iCodingRuleManager.isUserSelect((IObjectValue)caller, orgId)) {
                caller.setNumber(iCodingRuleManager.getNumber((IObjectValue)caller, orgId));
            } else if (iCodingRuleManager.isAddView((IObjectValue)caller, orgId)) {
                if (iCodingRuleManager.isModifiable((IObjectValue)caller, orgId)) {
                    iCodingRuleManager.checkModifiedNumber((IObjectValue)caller, orgId, caller.getNumber().toString());
                }
            } else {
                caller.setNumber(iCodingRuleManager.getNumber((IObjectValue)caller, orgId));
            }
        }
    }

    protected void recycleNumberFromCodingRule(Context ctx, DataBaseInfo caller, String orgId) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist((IObjectValue)caller, orgId)) {
            if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, orgId)) {
                iCodingRuleManager.recycleNumber((IObjectValue)caller, orgId, caller.getNumber());
            }
        } else {
            String root = this.getNextCompanyId(ctx);
            if (root != null && root.trim().length() > 0 && iCodingRuleManager.isExist((IObjectValue)caller, root) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)caller, root)) {
                iCodingRuleManager.recycleNumber((IObjectValue)caller, root, caller.getNumber());
            }
        }
    }

    @Override
    protected void _approve(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer bs = new StringBuffer();
        SOPCheckFormulaInfo info = (SOPCheckFormulaInfo)this.getValue(ctx, pk);
        String id = info.getId().toString();
        Object[] number = new String[]{info.getNumber()};
        if (info.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
            throw new SOPCheckFormulaException(SOPCheckFormulaException.DATAAPPROVED, number);
        }
        if (bs != null && bs.length() == 0) {
            String sql = "update t_mm_SOPCheckFormula set fstatus = 20 where fid = ?";
            try {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _unapprove(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer bs = new StringBuffer();
        SOPCheckFormulaInfo info = (SOPCheckFormulaInfo)this.getValue(ctx, pk);
        String id = info.getId().toString();
        Object[] number = new String[]{info.getNumber()};
        if (info.getStatus().equals((Object)BDStatusEnum.UNAPPROVE)) {
            throw new SOPCheckFormulaException(SOPCheckFormulaException.DATAUNAPPROVED, number);
        }
        if (bs != null && bs.length() == 0) {
            String sql = "update t_mm_SOPCheckFormula set fstatus = 10 where fid = ?";
            try {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SOPCheckFormulaInfo formulaInfo = (SOPCheckFormulaInfo)model;
        this.setNewNumber(ctx, formulaInfo);
        this._checkNumberBlank(ctx, (IObjectValue)formulaInfo);
        this._checkNameBlank(ctx, (IObjectValue)formulaInfo);
        this._checkNameDup(ctx, (IObjectValue)formulaInfo);
        return super._submit(ctx, model);
    }
}

