/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.SOPException;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPProductPlanPolicyEnum;
import com.kingdee.eas.mm.planning.app.AbstractSOPProductPlanPolicyFacadeControllerBean;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SOPProductPlanPolicyFacadeControllerBean
extends AbstractSOPProductPlanPolicyFacadeControllerBean {
    private static final long serialVersionUID = 56464641L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.SOPProductPlanPolicyFacadeControllerBean");
    private static final String precision = "precision";
    private static final String SUM_SALE_PLAN = "SUM_SALE_PLAN";
    private static final String START_INVERTORY = "START_INVERTORY";
    private static final String PLAN_POLICY = "productPlanPolicy";

    @Override
    protected Map _Policy(Context ctx, Map params) throws BOSException, EASBizException {
        Map productPlan = new HashMap();
        SOPProductPlanPolicyEnum policy = (SOPProductPlanPolicyEnum)((Object)params.get(PLAN_POLICY));
        if (policy.equals((Object)SOPProductPlanPolicyEnum.EQUAL_TO_SALE)) {
            productPlan = this.equalToSalePolicy(ctx, params);
        } else if (policy.equals((Object)SOPProductPlanPolicyEnum.NO_STORAGE)) {
            productPlan = this.noInventoryPolicy(ctx, params);
        } else if (policy.equals((Object)SOPProductPlanPolicyEnum.TARGET_STORAGE)) {
            productPlan = this.targetInventoryPolicy(ctx, params);
        } else if (policy.equals((Object)SOPProductPlanPolicyEnum.AVERAGE_PLAN)) {
            productPlan = this.averagePlanPolicy(ctx, params);
        }
        productPlan.put("planTypeIdx", params.get("planTypeIdx"));
        productPlan.put("indexset", params.get("indexset"));
        return productPlan;
    }

    private Map equalToSalePolicy(Context ctx, Map params) throws EASBizException, BOSException {
        List mSalesArray = (List)params.get("saleplan");
        ArrayList Inventory = (ArrayList)params.get(START_INVERTORY);
        ArrayList mProductArray = new ArrayList();
        ArrayList mInventoryArray = new ArrayList();
        HashMap map = new HashMap();
        int length = mSalesArray.size();
        for (int i = 0; i < length; ++i) {
            BigDecimal iInventory = new BigDecimal(Inventory.toArray()[i].toString());
            ArrayList<BigDecimal> inventory = new ArrayList<BigDecimal>();
            ArrayList<Object> productPlan = new ArrayList<Object>();
            List salesPlan = (List)mSalesArray.toArray()[i];
            int size = salesPlan.size();
            for (int j = 0; j < size; ++j) {
                productPlan.add(salesPlan.toArray()[j]);
                inventory.add(iInventory);
            }
            mProductArray.add(productPlan);
            mInventoryArray.add(inventory);
        }
        map.put("productArray", mProductArray);
        map.put("InventoryArray", mInventoryArray);
        return map;
    }

    private Map noInventoryPolicy(Context ctx, Map params) throws EASBizException, BOSException {
        ArrayList mSalesArray = (ArrayList)params.get("saleplan");
        ArrayList Inventory = (ArrayList)params.get(START_INVERTORY);
        ArrayList mProductArray = new ArrayList();
        ArrayList mInventoryArray = new ArrayList();
        int length = mSalesArray.size();
        for (int i = 0; i < length; ++i) {
            ArrayList<BigDecimal> productPlan = new ArrayList<BigDecimal>();
            ArrayList<BigDecimal> inventory = new ArrayList<BigDecimal>();
            List salesPlan = (List)mSalesArray.toArray()[i];
            BigDecimal iInventory = new BigDecimal(Inventory.toArray()[i].toString());
            int size = salesPlan.size();
            for (int j = 0; j < size; ++j) {
                BigDecimal iProductPlan = new BigDecimal("0.00");
                BigDecimal iSalesPlan = new BigDecimal(salesPlan.toArray()[j].toString());
                if (iSalesPlan.compareTo(iInventory) > 0) {
                    iProductPlan = iSalesPlan.subtract(iInventory);
                    productPlan.add(iProductPlan);
                } else {
                    productPlan.add(new BigDecimal("0"));
                }
                iInventory = iInventory.add(iProductPlan).subtract(iSalesPlan);
                inventory.add(new BigDecimal("0"));
            }
            mProductArray.add(productPlan);
            mInventoryArray.add(inventory);
        }
        HashMap map = new HashMap();
        map.put("productArray", mProductArray);
        map.put("inventoryArray", mInventoryArray);
        return map;
    }

    private Map targetInventoryPolicy(Context ctx, Map params) throws EASBizException, BOSException {
        ArrayList mSalesArray = (ArrayList)params.get("saleplan");
        ArrayList mTargetInventory = (ArrayList)params.get("targetinv");
        ArrayList Inventory = (ArrayList)params.get(START_INVERTORY);
        ArrayList mProductArray = new ArrayList();
        ArrayList mInventoryArray = new ArrayList();
        int length = mSalesArray.size();
        for (int i = 0; i < length; ++i) {
            ArrayList<BigDecimal> productPlan = new ArrayList<BigDecimal>();
            ArrayList<BigDecimal> inventory = new ArrayList<BigDecimal>();
            List salesPlan = (List)mSalesArray.toArray()[i];
            List targetInventory = (List)mTargetInventory.toArray()[i];
            BigDecimal iInventory = new BigDecimal(Inventory.toArray()[i].toString());
            int size = salesPlan.size();
            for (int j = 0; j < size; ++j) {
                BigDecimal iTargetInventory;
                BigDecimal iProductPlan = new BigDecimal("0.00");
                BigDecimal iSalesPlan = new BigDecimal(salesPlan.toArray()[j].toString());
                if (iSalesPlan.add(iTargetInventory = new BigDecimal(targetInventory.toArray()[j].toString())).compareTo(iInventory) > 0) {
                    iProductPlan = iSalesPlan.subtract(iInventory).add(iTargetInventory);
                    productPlan.add(iProductPlan);
                } else {
                    productPlan.add(new BigDecimal("0.00"));
                }
                iInventory = iInventory.add(iProductPlan).subtract(iSalesPlan);
                inventory.add(iInventory);
            }
            mProductArray.add(productPlan);
            mInventoryArray.add(inventory);
        }
        HashMap map = new HashMap();
        map.put("productArray", mProductArray);
        map.put("inventoryArray", mInventoryArray);
        return map;
    }

    private Map averagePlanPolicy(Context ctx, Map params) throws EASBizException, BOSException {
        ArrayList mSalesArray = (ArrayList)params.get("saleplan");
        ArrayList sumSalesPlans = (ArrayList)params.get(SUM_SALE_PLAN);
        ArrayList precisionList = (ArrayList)params.get(precision);
        ArrayList Inventory = (ArrayList)params.get(START_INVERTORY);
        SOPPeriod startPeriod = (SOPPeriod)params.get("StartSOPPeriod");
        String storageOrgUnitId = params.get("currentorgID").toString();
        ArrayList sale = (ArrayList)mSalesArray.toArray()[0];
        Map m = this.getWorkDay(ctx, startPeriod, sale.size(), storageOrgUnitId);
        List workDay = (List)m.get("workDay");
        BigDecimal sumWorkDay = new BigDecimal(m.get("sumWorkDay").toString());
        if (sumWorkDay.compareTo(new BigDecimal(0)) == 0) {
            throw new SOPException(SOPException.SUM_WORKDAY_CAN_NOT_BE_ZERO);
        }
        ArrayList mProductArray = new ArrayList();
        ArrayList mInventoryArray = new ArrayList();
        int length = mSalesArray.size();
        for (int i = 0; i < length; ++i) {
            ArrayList<BigDecimal> productPlan = new ArrayList<BigDecimal>();
            ArrayList<BigDecimal> inventory = new ArrayList<BigDecimal>();
            BigDecimal sumproductPlan = new BigDecimal("0.00");
            BigDecimal iworkDay = new BigDecimal("0.00");
            BigDecimal iProductPlan = new BigDecimal("0.00");
            BigDecimal iSalesPlan = new BigDecimal("0.00");
            BigDecimal iInventory = new BigDecimal(Inventory.toArray()[i].toString());
            List salesPlan = (List)mSalesArray.toArray()[i];
            int precision = Integer.parseInt(precisionList.toArray()[i].toString());
            BigDecimal sumSalesPlan = new BigDecimal(sumSalesPlans.toArray()[i].toString());
            BigDecimal aProductPlan = sumSalesPlan.divide(sumWorkDay, precision + 2, 4);
            int size = salesPlan.size();
            for (int j = 0; j < size - 1; ++j) {
                iworkDay = iworkDay.add(new BigDecimal(workDay.toArray()[j].toString()));
                iProductPlan = aProductPlan.multiply(iworkDay).subtract(sumproductPlan).setScale(precision, 4);
                sumproductPlan = sumproductPlan.add(iProductPlan).setScale(precision, 4);
                productPlan.add(iProductPlan);
                iSalesPlan = new BigDecimal(salesPlan.toArray()[j].toString());
                iInventory = iInventory.add(iProductPlan).subtract(iSalesPlan);
                inventory.add(iInventory);
            }
            BigDecimal last = sumSalesPlan.subtract(sumproductPlan);
            last = last.setScale(precision, 4);
            int days = (Integer)workDay.get(workDay.size() - 1);
            if (days <= 0) {
                last = new BigDecimal("0.00");
            }
            productPlan.add(last);
            inventory.add(iInventory);
            mProductArray.add(productPlan);
            mInventoryArray.add(inventory);
        }
        HashMap map = new HashMap();
        map.put("productArray", mProductArray);
        map.put("inventoryArray", mInventoryArray);
        return map;
    }

    private Map getWorkDay(Context ctx, SOPPeriod PeriodFrom, int numOfPeriod, String storageOrgUnitId) throws BOSException, EASBizException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        int sumWorkDay = 0;
        Date endDate = PeriodFrom.getEndDate().getTime();
        int numWorkDay = 0;
        ArrayList<Integer> workDay = new ArrayList<Integer>();
        SOPPeriod[] Periods = PeriodFrom.forwardPeriods(numOfPeriod);
        String clr = "\r\n";
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t0.FWorkDate ").append(clr).append("  FROM t_mm_Factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append(clr).append(" WHERE t0.fparentid = t1.fid ").append(clr).append(" AND t1.fstorageorgunitid = ? ").append(clr).append(" AND t0.FWorkDateSeq > 0");
        Date startDate = Periods[0].getBeginDate().getTime();
        Date now = new Date();
        boolean b = this.compareDate(startDate, now);
        for (int i = 0; i < numOfPeriod; ++i) {
            startDate = Periods[i].getBeginDate().getTime();
            endDate = Periods[i].getEndDate().getTime();
            if (i == 0 && b) {
                startDate = new Date();
            }
            StringBuffer sqltemp = new StringBuffer();
            sqltemp.append(sql);
            sqltemp.append(" AND t0.fworkdate >= to_date('").append(MRPUtil.dateToString(startDate, "yyyy-MM-dd")).append("')").append(clr);
            sqltemp.append(" AND t0.fworkdate <=to_date('").append(MRPUtil.dateToString(endDate, "yyyy-MM-dd")).append("')").append(clr);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqltemp.toString(), (Object[])new Object[]{storageOrgUnitId});
            numWorkDay = rs.size();
            sumWorkDay += numWorkDay;
            workDay.add(new Integer(numWorkDay));
            numWorkDay = 0;
        }
        map.put("workDay", workDay);
        map.put("sumWorkDay", new Integer(sumWorkDay));
        return map;
    }

    private boolean compareDate(Date start, Date end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        int startDay = Integer.parseInt(dateFormat.format(start).toString());
        int endDay = Integer.parseInt(dateFormat.format(end).toString());
        boolean result = false;
        if (endDay - startDay > 0) {
            result = true;
        }
        return result;
    }

    public static String getResource(Context ctx, String strKey) {
        return ResourceBase.getString((String)"com.kingdee.eas.mm.planning.SOPException", (String)strKey, (Locale)ctx.getLocale());
    }
}

