/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.AbilityImpropriateEnum;
import com.kingdee.eas.mm.basedata.ClassTeamEntryCollection;
import com.kingdee.eas.mm.basedata.ClassTeamEntryInfo;
import com.kingdee.eas.mm.basedata.ClassTeamInfo;
import com.kingdee.eas.mm.basedata.PLSModelInfo;
import com.kingdee.eas.mm.basedata.PLSTypeEnum;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryInfo;
import com.kingdee.eas.mm.basedata.TimeUnitEnum;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.planning.LineCapabilityInfo;
import com.kingdee.eas.mm.planning.PLChooseEntryInfo;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.PLSExectionMSGInfo;
import com.kingdee.eas.mm.planning.app.CalcCapabilityHandler;
import com.kingdee.eas.mm.planning.app.PLSRunner;
import com.kingdee.eas.mm.planning.util.PLSUtil;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchedulingRunner
extends PLSRunner {
    protected List srcList;
    protected List pLSList;
    protected Timestamp beginDate;
    protected Timestamp endDate;
    protected ProductLinePAllotDefEntryCollection productLinePAllotDefEntryCollection;
    protected Map mmuPrecisions;
    protected Map mmuConvsRate;
    protected Map materialPlanInfos;
    protected Map lineCaps;
    protected Map lineUnitCaps;
    protected Map lineGroupMap;
    protected Map proOrderMap;
    protected Map productLineMap;
    protected Map unitMap;
    protected Map lineLotMap;
    protected CalcCapabilityHandler calcCapHandler;
    protected Map outputPeriod;

    public SchedulingRunner(Context context, StorageOrgUnitInfo storageOrgUnit, List pLCEntryList, String currVoucherID, Map proOrders, Timestamp beginDate, Timestamp endDate, List pLSEntryList, PLSModelInfo pLSModelInfo) {
        this.ctx = context;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.voucherID = currVoucherID;
        this.storageOrgUnitInfo = storageOrgUnit;
        this.srcList = pLCEntryList;
        this.pLSList = pLSEntryList;
        this.proOrderMap = proOrders;
        this.lineSchedulingModelInfo = pLSModelInfo;
    }

    private void getOutputPeriod() {
        this.outputPeriod = new HashMap();
        if (this.productLinePAllotDefEntryCollection != null && this.productLinePAllotDefEntryCollection.size() > 0) {
            for (ProductLinePAllotDefEntryInfo entryInfo : this.productLinePAllotDefEntryCollection) {
                String materialId = entryInfo.getMaterial().getId().toString();
                ProductLinePAllotDefEntryRuleEntryCollection ruleEntryCollection = entryInfo.getRuleEntrys();
                for (ProductLinePAllotDefEntryRuleEntryInfo ruleEntryInfo : ruleEntryCollection) {
                    String productlineId = ruleEntryInfo.getProductLine().getId().toString();
                    String key = materialId + "@" + productlineId;
                    if (this.outputPeriod.containsKey(key)) continue;
                    this.outputPeriod.put(key, ruleEntryInfo.getOutPutPeriod());
                }
            }
        }
    }

    @Override
    protected void prepareData() throws BOSException, EASBizException {
        super.prepareData();
        this.productLinePAllotDefEntryCollection = PLSUtil.getProductLinePAllotDefForServer(this.ctx, this.lineSchedulingModelInfo.getProductLineAllocate().getId().toString());
        this.getOutputPeriod();
        int abilityType = this.lineSchedulingModelInfo.getAbilityImpropriate().getValue();
        boolean isDateBefAbility = this.lineSchedulingModelInfo.isIsDateBefAbility();
        if (abilityType == 40) {
            isDateBefAbility = false;
        }
        Timestamp curDate = new Timestamp(new Date().getTime());
        this.beginDate = isDateBefAbility || this.beginDate.before(curDate) ? curDate : PLSUtil.setDateTime(this.beginDate, 0);
        this.endDate = PLSUtil.setDateTime(this.endDate, 1);
        this.unitMap = new HashMap();
        HashSet<String> materialSet = new HashSet<String>();
        int n = this.srcList.size();
        MaterialInfo[] materialInfos = new MaterialInfo[n];
        MeasureUnitInfo[] unitInfos = new MeasureUnitInfo[n];
        MeasureUnitInfo[] baseUnitInfos = new MeasureUnitInfo[n];
        this.lineGroupMap = new HashMap();
        for (int i = 0; i < n; ++i) {
            List<PLChooseEntryInfo> taskList;
            PLChooseEntryInfo pLCEntryInfo = (PLChooseEntryInfo)this.srcList.get(i);
            materialSet.add(pLCEntryInfo.getMaterial().getId().toString());
            materialInfos[i] = pLCEntryInfo.getMaterial();
            unitInfos[i] = pLCEntryInfo.getUnit();
            baseUnitInfos[i] = pLCEntryInfo.getBaseUnit();
            String key = pLCEntryInfo.getProductLine().getId().toString();
            if (this.lineGroupMap.containsKey(key)) {
                taskList = (List)this.lineGroupMap.get(key);
                taskList.add(pLCEntryInfo);
                this.lineGroupMap.put(key, taskList);
            } else {
                taskList = new ArrayList<PLChooseEntryInfo>();
                taskList.add(pLCEntryInfo);
                this.lineGroupMap.put(key, taskList);
            }
            this.unitMap.put(pLCEntryInfo.getUnit().getId().toString(), pLCEntryInfo.getUnit());
        }
        SCMEntryDataVO voResult = PLSUtil.loadComplexDataForServer(this.ctx, this.storageOrgUnitInfo, materialInfos);
        if (voResult != null) {
            this.materialPlanInfos = voResult.getMaterialPlanInfos();
            voResult = PLSUtil.getMmuPrecisionForServer(this.ctx, this.storageOrgUnitInfo, materialInfos, unitInfos, baseUnitInfos);
            if (voResult != null) {
                this.mmuConvsRate = voResult.getMmuConvsRate();
                this.mmuPrecisions = voResult.getMmuPrecisions();
            }
        }
        this.getProOrder(this.lineGroupMap.keySet());
        this.productLineMap = PLSUtil.getProductLineMapForServer(this.ctx, this.lineGroupMap.keySet());
        this.getLineUnitCaps(materialSet, this.lineGroupMap.keySet());
        this.getLineLots(materialSet, this.lineGroupMap.keySet());
        this.calcCapHandler = new CalcCapabilityHandler(this.ctx, this.storageOrgUnitInfo, this.lineSchedulingModelInfo, this.beginDate, this.endDate, this.featureNum, this.productLineMap, this.voucherID);
        this.lineCaps = this.calcCapHandler.getLineCaps();
        this.removeHolidayLineCaps();
        this.updateLineCapsWithoutVoucher();
        this.updateLineCaps();
    }

    @Override
    protected void running() throws BOSException, EASBizException {
        this.prepareData();
        int granularity = this.lineSchedulingModelInfo.getDayAbilityGranu().getValue();
        this.returnList = new ArrayList();
        Set keySet = this.lineGroupMap.keySet();
        for (String productLineId : keySet) {
            ProductLineInfo productLine = (ProductLineInfo)this.productLineMap.get(productLineId);
            List capList = (List)this.lineCaps.get(productLineId);
            if (capList == null || capList.size() == 0) {
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOUSEABLECAP_DESC");
                int exceNum = 204;
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOUSEABLECAP_DETAIL", (String[])new String[]{productLine.getNumber(), productLine.getName()});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
                continue;
            }
            List taskList = (List)this.lineGroupMap.get(productLineId);
            Collections.sort(taskList, PLSUtil.getPLCComparator());
            Collections.sort(capList, PLSUtil.getLineCapComparator());
            Iterator taskIte = taskList.iterator();
            block1: while (taskIte.hasNext()) {
                PLChooseEntryInfo pLCEntryInfo = (PLChooseEntryInfo)taskIte.next();
                String materialId = pLCEntryInfo.getMaterial().getId().toString();
                BigDecimal taskQty = pLCEntryInfo.getQty();
                BigDecimal needHour = null;
                String ucKey = materialId + "@" + productLineId;
                BigDecimal unitCap = (BigDecimal)this.lineUnitCaps.get(ucKey);
                if (unitCap == null) continue;
                if (productLine.getScheduleType().equals((Object)PLSTypeEnum.SHIFTABILITY)) {
                    needHour = taskQty.divide(unitCap, 8, 4);
                }
                Iterator capIte = capList.iterator();
                while (capIte.hasNext()) {
                    LineCapabilityInfo lineCap = (LineCapabilityInfo)capIte.next();
                    BigDecimal hourCap = lineCap.getHourCap();
                    BigDecimal yieldCap = lineCap.getYieldCap();
                    if (granularity == 10 && productLine.getScheduleType().equals((Object)PLSTypeEnum.SHIFTABILITY)) {
                        String mpKey = materialId + this.storageOrgUnitInfo.getId().toString();
                        MaterialPlanInfo mpInfo = (MaterialPlanInfo)this.materialPlanInfos.get(mpKey);
                        int remainTime = mpInfo.getRemainTimeNoPlan();
                        if (needHour.compareTo(lineCap.getHourCap()) > 0 && (double)remainTime >= lineCap.getHourCap().doubleValue() * 60.0) {
                            capIte.remove();
                            continue;
                        }
                    }
                    PLSEntryInfo pLSEntry = this.getPLSEntryFromPLChooseEntry(pLCEntryInfo);
                    pLSEntry.setVarDate(lineCap.getWorkDate());
                    String key = productLineId + "@" + PLSUtil.formatDate(lineCap.getWorkDate());
                    BigDecimal proOrder = null;
                    proOrder = (BigDecimal)this.proOrderMap.get(key);
                    if (proOrder == null) {
                        pLSEntry.setProOrder(PLSConstant.TEN);
                        this.proOrderMap.put(key, PLSConstant.TEN);
                    } else {
                        BigDecimal maxProOrder = PLSConstant.ONE.add(proOrder.divide(PLSConstant.TEN, 0, 3)).multiply(PLSConstant.TEN);
                        pLSEntry.setProOrder(maxProOrder);
                        this.proOrderMap.put(key, maxProOrder);
                    }
                    pLSEntry.setBeginDate(lineCap.getBeginTime());
                    pLSEntry.setEndDate(lineCap.getEndTime());
                    pLSEntry.setClassTeam(lineCap.getClassTeam());
                    BigDecimal period = (BigDecimal)this.outputPeriod.get(ucKey);
                    if (period == null) {
                        period = new BigDecimal("0");
                    }
                    long outputTime = lineCap.getEndTime().getTime() + period.multiply(new BigDecimal(3600000)).longValue();
                    pLSEntry.setOutputDate(new Timestamp(outputTime));
                    if (pLSEntry.getVarDate().after(pLSEntry.getRequiredDate())) {
                        pLSEntry.setDelayTime(PLSUtil.calcDateSpan(pLSEntry.getRequiredDate(), pLSEntry.getVarDate()));
                    }
                    if (lineCap.getCapabilityType().equals((Object)PLSTypeEnum.DAYABILITY)) {
                        if ((yieldCap = yieldCap.multiply(this.getExchangeRate(pLSEntry.getMaterial().getId().toString(), productLine.getUnit(), pLSEntry.getUnit()))).compareTo(taskQty) <= 0) {
                            pLSEntry.setQty(yieldCap);
                            this.calcOtherData(pLSEntry);
                            this.returnList.add(pLSEntry);
                            taskQty = taskQty.subtract(yieldCap);
                            if (taskQty.compareTo(PLSConstant.ZERO) == 0) {
                                taskIte.remove();
                                capIte.remove();
                                continue block1;
                            }
                            capIte.remove();
                            continue;
                        }
                        pLSEntry.setQty(taskQty);
                        yieldCap = yieldCap.subtract(taskQty);
                        lineCap.setYieldCap(yieldCap);
                        this.calcOtherData(pLSEntry);
                        this.returnList.add(pLSEntry);
                        taskIte.remove();
                        continue block1;
                    }
                    if (!lineCap.getCapabilityType().equals((Object)PLSTypeEnum.SHIFTABILITY)) continue;
                    if (hourCap.compareTo(needHour) <= 0) {
                        BigDecimal needHourCopy = needHour;
                        pLSEntry.setQty(hourCap.multiply(unitCap));
                        this.calcOtherData(pLSEntry);
                        this.returnList.add(pLSEntry);
                        BigDecimal realProductHour = pLSEntry.getQty().divide(unitCap, 8, 4);
                        if (needHour.compareTo(PLSConstant.ZERO) == 0) {
                            taskIte.remove();
                            capIte.remove();
                            continue block1;
                        }
                        if (realProductHour.compareTo(needHourCopy) >= 0) {
                            taskIte.remove();
                            capIte.remove();
                            continue block1;
                        }
                        capIte.remove();
                        needHour = needHourCopy.subtract(realProductHour);
                        continue;
                    }
                    pLSEntry.setQty(needHour.multiply(unitCap));
                    this.calcOtherData(pLSEntry);
                    this.returnList.add(pLSEntry);
                    needHour = pLSEntry.getQty().divide(unitCap, 8, 4);
                    taskIte.remove();
                    if (hourCap.compareTo(needHour) > 0) {
                        hourCap = hourCap.subtract(needHour);
                        lineCap.setHourCap(hourCap);
                        continue block1;
                    }
                    capIte.remove();
                    continue block1;
                }
            }
        }
        Set keys = this.lineGroupMap.keySet();
        for (String lineID : keys) {
            List plcs = (List)this.lineGroupMap.get(lineID);
            if (plcs == null || plcs.size() <= 0) continue;
            int count = plcs.size();
            for (int i = 0; i < count; ++i) {
                PLChooseEntryInfo plc = (PLChooseEntryInfo)plcs.get(i);
                ProductLineInfo line = (ProductLineInfo)this.productLineMap.get(lineID);
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"SOME_PLC_UNSCHEDULED_DESC");
                int exceNum = 206;
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"SOME_PLC_UNSCHEDULED_DETAIL", (String[])new String[]{line.getNumber(), line.getName(), plc.getMaterial().getName()});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
            }
        }
    }

    protected void calcOtherData(PLSEntryInfo pLSEntry) throws EASBizException, BOSException {
        String key;
        BigDecimal lot;
        int batchControl = this.lineSchedulingModelInfo.getBatchControl().getValue();
        if (20 == batchControl && (lot = (BigDecimal)this.lineLotMap.get(key = pLSEntry.getMaterial().getId().toString() + "@" + pLSEntry.getProductLine().getId().toString())) != null && pLSEntry.getQty().doubleValue() % lot.doubleValue() != 0.0) {
            pLSEntry.setQty(pLSEntry.getQty().divide(lot, 0, 0).multiply(lot));
        }
        String materialId = pLSEntry.getMaterial().getId().toString();
        String beforeUnitId = pLSEntry.getUnit().getId().toString();
        String afterUnitId = pLSEntry.getBaseUnit().getId().toString();
        pLSEntry.setBaseQty(PLSUtil.getConstraintQty(this.getExchangePrecisionQty(materialId, beforeUnitId, afterUnitId, pLSEntry.getQty())));
    }

    protected BigDecimal getExchangePrecisionQty(String materialId, String beforeUnitId, String afterUnitId, BigDecimal qty) throws BOSException, EASBizException {
        BigDecimal targetQty = null;
        if (beforeUnitId.equals(afterUnitId)) {
            targetQty = qty;
        } else {
            BigDecimal beforeBaseRate = (BigDecimal)this.mmuConvsRate.get(materialId + beforeUnitId);
            BigDecimal afterBaseRate = (BigDecimal)this.mmuConvsRate.get(materialId + afterUnitId);
            if (beforeBaseRate == null) {
                beforeBaseRate = PLSConstant.ONE;
            }
            if (afterBaseRate == null) {
                afterBaseRate = PLSConstant.ONE;
            }
            BigDecimal baseQty = qty.multiply(beforeBaseRate);
            targetQty = baseQty.divide(afterBaseRate, 8, 4);
        }
        return targetQty;
    }

    protected void getProOrder(Set idSet) throws BOSException, EASBizException {
        if (this.proOrderMap == null) {
            this.proOrderMap = new HashMap();
        }
        String strIDs = StringUtils.arrayToString((Object[])idSet.toArray(), (String)"','");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" select fproductLineID,TO_CHAR(fvarDate, 'YYYY-MM-DD') as fvarDate,max(fproOrder) as proOrder from t_mm_plsentry ");
        sqlBuffer.append(" where fvarDate >= ? and fvarDate <= ? ");
        sqlBuffer.append(" and fproductLineID in ('" + strIDs + "') ");
        if (this.voucherID != null) {
            sqlBuffer.append("and fparent <> '" + this.voucherID + "' ");
        }
        sqlBuffer.append(" group by fproductLineID,TO_CHAR(fvarDate, 'YYYY-MM-DD') ");
        IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{this.beginDate, this.endDate});
        try {
            while (rows.next()) {
                String fproductLineID = rows.getString("fproductLineID");
                String varDate = rows.getString("fvarDate");
                BigDecimal proOrder = rows.getBigDecimal("proOrder");
                String key = fproductLineID + "@" + varDate;
                if (this.proOrderMap.containsKey(key)) {
                    BigDecimal order = (BigDecimal)this.proOrderMap.get(key);
                    if (proOrder.compareTo(order) <= 0) continue;
                    this.proOrderMap.put(key, proOrder);
                    continue;
                }
                this.proOrderMap.put(key, proOrder);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Timestamp[] getWorkTimes(Timestamp workDate, ClassTeamInfo classTeam) {
        Timestamp[] workTimes = new Timestamp[2];
        ArrayList<Timestamp> list = new ArrayList<Timestamp>();
        boolean isSpan = false;
        ClassTeamEntryCollection entryCol = classTeam.getEntrys();
        if (entryCol != null && entryCol.size() > 0) {
            int m = entryCol.size();
            for (int j = 0; j < m; ++j) {
                Time endtime;
                ClassTeamEntryInfo entryInfo = entryCol.get(j);
                Time starttime = entryInfo.getStartTime();
                if (!starttime.before(endtime = entryInfo.getEndTime())) {
                    isSpan = true;
                }
                list.add(PLSUtil.constructDate(workDate, starttime, false));
                list.add(PLSUtil.constructDate(workDate, endtime, isSpan));
            }
            Arrays.sort(list.toArray());
            workTimes[0] = (Timestamp)list.get(0);
            workTimes[1] = (Timestamp)list.get(list.size() - 1);
        }
        return workTimes;
    }

    protected void removeHolidayLineCaps() {
        Set keySet = this.lineCaps.keySet();
        for (String productLineId : keySet) {
            if (!this.lineCaps.containsKey(productLineId)) continue;
            List capList = (List)this.lineCaps.get(productLineId);
            Iterator ite = capList.iterator();
            while (ite.hasNext()) {
                LineCapabilityInfo lineCap = (LineCapabilityInfo)ite.next();
                if (lineCap.getWorkDay().equals((Object)WorkDateTypeEnum.WORKDAY)) continue;
                ite.remove();
            }
        }
    }

    protected void updateLineCapsWithoutVoucher() throws EASBizException, BOSException {
        int granularity = this.lineSchedulingModelInfo.getDayAbilityGranu().getValue();
        if (granularity == 20) {
            Set idList = this.productLineMap.keySet();
            String strIDs = StringUtils.arrayToString((Object[])idList.toArray(), (String)"','");
            this.updateByWorkDay(strIDs);
        } else if (granularity == 10) {
            String strIDs;
            HashSet<String> idList_DayYieldCap = new HashSet<String>();
            HashSet<String> idList_ClassCap = new HashSet<String>();
            Iterator ite = this.productLineMap.keySet().iterator();
            while (ite.hasNext()) {
                ProductLineInfo productLine = (ProductLineInfo)this.productLineMap.get(ite.next());
                if (20 == productLine.getScheduleType().getValue()) {
                    idList_DayYieldCap.add(productLine.getId().toString());
                    continue;
                }
                idList_ClassCap.add(productLine.getId().toString());
            }
            if (idList_DayYieldCap != null && idList_DayYieldCap.size() > 0) {
                strIDs = StringUtils.arrayToString((Object[])idList_DayYieldCap.toArray(), (String)"','");
                this.updateByWorkDay(strIDs);
            }
            if (idList_ClassCap != null && idList_ClassCap.size() > 0) {
                strIDs = StringUtils.arrayToString((Object[])idList_ClassCap.toArray(), (String)"','");
                this.updateByClassTeam(strIDs);
            }
        }
    }

    protected void updateLineCaps() throws EASBizException, BOSException {
        if (this.pLSList != null && this.pLSList.size() > 0) {
            HashMap<String, Timestamp> maxBeginTimeMap = new HashMap<String, Timestamp>();
            int n = this.pLSList.size();
            for (int i = 0; i < n; ++i) {
                PLSEntryInfo pLSEntry = (PLSEntryInfo)this.pLSList.get(i);
                String key = pLSEntry.getProductLine().getId().toString();
                if (maxBeginTimeMap.containsKey(key)) {
                    Timestamp maxBeginTime = (Timestamp)maxBeginTimeMap.get(key);
                    if (!pLSEntry.getBeginDate().after(maxBeginTime)) continue;
                    maxBeginTimeMap.put(key, pLSEntry.getBeginDate());
                    continue;
                }
                maxBeginTimeMap.put(key, pLSEntry.getBeginDate());
            }
            Set keySet = maxBeginTimeMap.keySet();
            for (String productLineId : keySet) {
                Timestamp maxBeginTime = (Timestamp)maxBeginTimeMap.get(productLineId);
                if (!this.lineCaps.containsKey(productLineId)) continue;
                List capList = (List)this.lineCaps.get(productLineId);
                Iterator ite = capList.iterator();
                while (ite.hasNext()) {
                    LineCapabilityInfo lineCap = (LineCapabilityInfo)ite.next();
                    if (lineCap.getCapabilityType().equals((Object)PLSTypeEnum.DAYABILITY)) {
                        Timestamp workDate = PLSUtil.setDateTime(maxBeginTime, 0);
                        if (lineCap.getWorkDate().before(workDate)) {
                            ite.remove();
                            continue;
                        }
                        if (lineCap.getWorkDate().compareTo(workDate) != 0) continue;
                        BigDecimal usedYield = this.getUsedYield(productLineId, lineCap.getWorkDate());
                        if (lineCap.getYieldCap().compareTo(usedYield) <= 0) {
                            ite.remove();
                            continue;
                        }
                        lineCap.setYieldCap(lineCap.getYieldCap().subtract(usedYield));
                        continue;
                    }
                    if (!lineCap.getCapabilityType().equals((Object)PLSTypeEnum.SHIFTABILITY)) continue;
                    BigDecimal usedHour = PLSConstant.ZERO;
                    int granularity = this.lineSchedulingModelInfo.getDayAbilityGranu().getValue();
                    if (granularity == 20) {
                        Timestamp workDate = PLSUtil.setDateTime(maxBeginTime, 0);
                        if (lineCap.getWorkDate().before(workDate)) {
                            ite.remove();
                            continue;
                        }
                        if (lineCap.getWorkDate().compareTo(workDate) == 0) {
                            usedHour = this.getUsedHour(productLineId, lineCap.getWorkDate());
                        }
                    } else if (granularity == 10) {
                        if (lineCap.getBeginTime().before(maxBeginTime)) {
                            ite.remove();
                            continue;
                        }
                        if (lineCap.getBeginTime().compareTo(maxBeginTime) <= 0 && lineCap.getEndTime().compareTo(maxBeginTime) >= 0) {
                            usedHour = this.getUsedHour(productLineId, lineCap.getBeginTime(), lineCap.getEndTime());
                        }
                    }
                    if (lineCap.getHourCap().compareTo(usedHour) <= 0) {
                        ite.remove();
                        continue;
                    }
                    lineCap.setHourCap(lineCap.getHourCap().subtract(usedHour));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateByWorkDay(String strIDs) throws BOSException, EASBizException {
        Timestamp workDate;
        HashMap<String, AbilityImpropriateEnum> modeMap;
        HashMap<String, Timestamp> dateMap;
        block19: {
            IRowSet orderRows;
            block20: {
                int abilityImpropriate = this.lineSchedulingModelInfo.getAbilityImpropriate().getValue();
                dateMap = new HashMap<String, Timestamp>();
                modeMap = new HashMap<String, AbilityImpropriateEnum>();
                try {
                    String productLineId;
                    IRowSet rows;
                    StringBuffer sqlBuffer;
                    if (abilityImpropriate == 10) {
                        sqlBuffer = new StringBuffer();
                        sqlBuffer.append("select FPRODUCTLINEID,max(fvardate) as workDate from T_MM_PLSENTRY ");
                        sqlBuffer.append("where FISSUBPLAN = 0 and FPRODUCTLINEID in ('" + strIDs + "') and (fbasestatus = 2 or fbasestatus = 4) and fvardate >= ? and fparent <> ? ");
                        sqlBuffer.append("group by FPRODUCTLINEID ");
                        rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{this.beginDate, this.voucherID});
                        while (rows.next()) {
                            productLineId = rows.getString("FPRODUCTLINEID");
                            workDate = rows.getTimestamp("workDate");
                            dateMap.put(productLineId, workDate);
                            modeMap.put(productLineId, AbilityImpropriateEnum.AbilityPlan);
                        }
                        break block19;
                    }
                    if (abilityImpropriate == 20) {
                        sqlBuffer = new StringBuffer();
                        sqlBuffer.append("select fproductlineid,max(fstartdate) as beginTime from t_mm_productionorder ");
                        sqlBuffer.append("where fproductlineid in ('" + strIDs + "') and fstartdate >= ? and (fbasestatus = 2 or fbasestatus = 4 or fbasestatus = 5) ");
                        sqlBuffer.append("group by fproductlineid ");
                        rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{this.beginDate});
                        while (rows.next()) {
                            productLineId = rows.getString("fproductlineid");
                            Timestamp beginTime = rows.getTimestamp("beginTime");
                            dateMap.put(productLineId, PLSUtil.setDateTime(beginTime, 0));
                            modeMap.put(productLineId, AbilityImpropriateEnum.ProductionOrder);
                        }
                        break block19;
                    }
                    if (abilityImpropriate == 30) {
                        StringBuffer plsSB = new StringBuffer();
                        plsSB.append("select FPRODUCTLINEID,max(fvardate) as workDate from T_MM_PLSENTRY ");
                        plsSB.append("where FISSUBPLAN = 0 and FPRODUCTLINEID in ('" + strIDs + "') and (fbasestatus = 2 or fbasestatus = 4) and fvardate >= ? and fparent <> ? ");
                        plsSB.append("group by FPRODUCTLINEID ");
                        IRowSet plsRows = DbUtil.executeQuery((Context)this.ctx, (String)plsSB.toString(), (Object[])new Object[]{this.beginDate, this.voucherID});
                        while (plsRows.next()) {
                            productLineId = plsRows.getString("FPRODUCTLINEID");
                            workDate = plsRows.getTimestamp("workDate");
                            dateMap.put(productLineId, workDate);
                            modeMap.put(productLineId, AbilityImpropriateEnum.APAndPOrder);
                        }
                        StringBuffer orderSB = new StringBuffer();
                        orderSB.append("select fproductlineid,max(fstartdate) as beginTime from t_mm_productionorder ");
                        orderSB.append("where fproductlineid in ('" + strIDs + "') and fstartdate >= ? and (fbasestatus = 2 or fbasestatus = 4 or fbasestatus = 5) ");
                        orderSB.append("group by fproductlineid ");
                        orderRows = DbUtil.executeQuery((Context)this.ctx, (String)orderSB.toString(), (Object[])new Object[]{this.beginDate});
                        break block20;
                    }
                    if (abilityImpropriate == 40) break block19;
                    break block19;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            while (orderRows.next()) {
                String productLineId = orderRows.getString("fproductlineid");
                Timestamp beginTime = orderRows.getTimestamp("beginTime");
                beginTime = PLSUtil.setDateTime(beginTime, 0);
                if (dateMap.containsKey(productLineId)) {
                    Timestamp workDate2 = (Timestamp)dateMap.get(productLineId);
                    if (!beginTime.after(workDate2)) continue;
                    dateMap.put(productLineId, beginTime);
                    continue;
                }
                dateMap.put(productLineId, beginTime);
                modeMap.put(productLineId, AbilityImpropriateEnum.APAndPOrder);
            }
        }
        if (dateMap != null && dateMap.size() > 0) {
            Set keySet = dateMap.keySet();
            for (String productLineId : keySet) {
                Iterator ite;
                if (this.lineCaps.containsKey(productLineId)) {
                    workDate = (Timestamp)dateMap.get(productLineId);
                    ite = ((List)this.lineCaps.get(productLineId)).iterator();
                } else {
                    String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOLINECAP_DESC");
                    int exceNum = 203;
                    ProductLineInfo productLine = (ProductLineInfo)this.productLineMap.get(productLineId);
                    String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOLINECAPLIST_DETAIL", (String[])new String[]{productLine.getNumber(), productLine.getName(), PLSUtil.formatDate(this.beginDate), PLSUtil.formatDate(this.endDate)});
                    PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                    this.exceptions.add(exceInfo);
                    continue;
                }
                while (ite.hasNext()) {
                    LineCapabilityInfo lineCap = (LineCapabilityInfo)ite.next();
                    if (lineCap.getWorkDate().before(workDate)) {
                        ite.remove();
                        continue;
                    }
                    if (lineCap.getWorkDate().compareTo(workDate) != 0) continue;
                    int mode = ((AbilityImpropriateEnum)modeMap.get(productLineId)).getValue();
                    if (lineCap.getCapabilityType().equals((Object)PLSTypeEnum.DAYABILITY)) {
                        BigDecimal usedYield = this.getUsedYield(productLineId, lineCap.getWorkDate(), mode);
                        if (lineCap.getYieldCap().compareTo(usedYield) <= 0) {
                            ite.remove();
                            continue;
                        }
                        lineCap.setYieldCap(lineCap.getYieldCap().subtract(usedYield));
                        continue;
                    }
                    if (!lineCap.getCapabilityType().equals((Object)PLSTypeEnum.SHIFTABILITY)) continue;
                    BigDecimal usedHour = this.getUsedHour(productLineId, lineCap.getWorkDate(), mode);
                    if (lineCap.getHourCap().compareTo(usedHour) <= 0) {
                        ite.remove();
                        continue;
                    }
                    lineCap.setHourCap(lineCap.getHourCap().subtract(usedHour));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateByClassTeam(String strIDs) throws BOSException, EASBizException {
        Timestamp beginTime;
        HashMap<String, AbilityImpropriateEnum> modeMap;
        HashMap<String, Timestamp> dateMap;
        block17: {
            IRowSet orderRows;
            block18: {
                int abilityImpropriate = this.lineSchedulingModelInfo.getAbilityImpropriate().getValue();
                dateMap = new HashMap<String, Timestamp>();
                modeMap = new HashMap<String, AbilityImpropriateEnum>();
                try {
                    String productLineId;
                    IRowSet rows;
                    StringBuffer sqlBuffer;
                    if (abilityImpropriate == 10) {
                        sqlBuffer = new StringBuffer();
                        sqlBuffer.append("select FPRODUCTLINEID,max(fbegindate) as beginTime from T_MM_PLSENTRY ");
                        sqlBuffer.append("where FISSUBPLAN = 0 and FPRODUCTLINEID in ('" + strIDs + "') and (fbasestatus = 2 or fbasestatus = 4) and fbegindate >= ?  and fparent <> ? ");
                        sqlBuffer.append("group by FPRODUCTLINEID ");
                        rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{this.beginDate, this.voucherID});
                        while (rows.next()) {
                            productLineId = rows.getString("FPRODUCTLINEID");
                            beginTime = rows.getTimestamp("beginTime");
                            dateMap.put(productLineId, beginTime);
                            modeMap.put(productLineId, AbilityImpropriateEnum.AbilityPlan);
                        }
                        break block17;
                    }
                    if (abilityImpropriate == 20) {
                        sqlBuffer = new StringBuffer();
                        sqlBuffer.append("select fproductlineid,max(fstartdate) as beginTime from t_mm_productionorder ");
                        sqlBuffer.append("where fproductlineid in ('" + strIDs + "') and fstartdate >= ? and (fbasestatus = 2 or fbasestatus = 4 or fbasestatus = 5) ");
                        sqlBuffer.append("group by fproductlineid ");
                        rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{this.beginDate});
                        while (rows.next()) {
                            productLineId = rows.getString("fproductlineid");
                            beginTime = rows.getTimestamp("beginTime");
                            dateMap.put(productLineId, beginTime);
                            modeMap.put(productLineId, AbilityImpropriateEnum.ProductionOrder);
                        }
                        break block17;
                    }
                    if (abilityImpropriate == 30) {
                        sqlBuffer = new StringBuffer();
                        sqlBuffer.append("select FPRODUCTLINEID,max(fbegindate) as beginTime from T_MM_PLSENTRY ");
                        sqlBuffer.append("where FISSUBPLAN = 0 and FPRODUCTLINEID in ('" + strIDs + "') and (fbasestatus = 2 or fbasestatus = 4) and fbegindate >= ?  and fparent <> ? ");
                        sqlBuffer.append("group by FPRODUCTLINEID ");
                        rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{this.beginDate, this.voucherID});
                        while (rows.next()) {
                            productLineId = rows.getString("FPRODUCTLINEID");
                            beginTime = rows.getTimestamp("beginTime");
                            dateMap.put(productLineId, beginTime);
                            modeMap.put(productLineId, AbilityImpropriateEnum.APAndPOrder);
                        }
                        StringBuffer orderSB = new StringBuffer();
                        orderSB.append("select fproductlineid,max(fstartdate) as beginTime from t_mm_productionorder ");
                        orderSB.append("where fproductlineid in ('" + strIDs + "') and fstartdate >= ? and (fbasestatus = 2 or fbasestatus = 4 or fbasestatus = 5) ");
                        orderSB.append("group by fproductlineid ");
                        orderRows = DbUtil.executeQuery((Context)this.ctx, (String)orderSB.toString(), (Object[])new Object[]{this.beginDate});
                        break block18;
                    }
                    if (abilityImpropriate == 40) break block17;
                    break block17;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            while (orderRows.next()) {
                String productLineId = orderRows.getString("fproductlineid");
                Timestamp beginTime2 = orderRows.getTimestamp("beginTime");
                if (dateMap.containsKey(productLineId)) {
                    Timestamp workDate = (Timestamp)dateMap.get(productLineId);
                    if (!beginTime2.after(workDate)) continue;
                    dateMap.put(productLineId, beginTime2);
                    continue;
                }
                dateMap.put(productLineId, beginTime2);
                modeMap.put(productLineId, AbilityImpropriateEnum.APAndPOrder);
            }
        }
        if (dateMap != null && dateMap.size() > 0) {
            Set keySet = dateMap.keySet();
            for (String productLineId : keySet) {
                Iterator ite;
                if (this.lineCaps.containsKey(productLineId)) {
                    beginTime = (Timestamp)dateMap.get(productLineId);
                    ite = ((List)this.lineCaps.get(productLineId)).iterator();
                } else {
                    String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOLINECAP_DESC");
                    int exceNum = 203;
                    ProductLineInfo productLine = (ProductLineInfo)this.productLineMap.get(productLineId);
                    String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"NOLINECAPLIST_DETAIL", (String[])new String[]{productLine.getNumber(), productLine.getName(), PLSUtil.formatDate(this.beginDate), PLSUtil.formatDate(this.endDate)});
                    PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                    this.exceptions.add(exceInfo);
                    continue;
                }
                while (ite.hasNext()) {
                    LineCapabilityInfo lineCap = (LineCapabilityInfo)ite.next();
                    if (!lineCap.getEndTime().after(beginTime)) {
                        ite.remove();
                        continue;
                    }
                    if (lineCap.getBeginTime().compareTo(beginTime) > 0 || lineCap.getEndTime().compareTo(beginTime) < 0) continue;
                    int mode = ((AbilityImpropriateEnum)modeMap.get(productLineId)).getValue();
                    BigDecimal usedHour = this.getUsedHour(productLineId, lineCap.getBeginTime(), lineCap.getEndTime(), mode);
                    if (lineCap.getHourCap().compareTo(usedHour) <= 0) {
                        ite.remove();
                        continue;
                    }
                    lineCap.setHourCap(lineCap.getHourCap().subtract(usedHour));
                }
            }
        }
    }

    protected BigDecimal getUsedYield(String productLineId, Timestamp workDate, int abilityImpropriate) throws BOSException, EASBizException {
        ProductLineInfo productLine;
        BigDecimal sumQty;
        String materialid;
        String unitId;
        IRowSet rows;
        StringBuffer sqlBuffer;
        BigDecimal usedYield = PLSConstant.ZERO;
        boolean isCalcPLSData = false;
        boolean isCalcOrderData = false;
        if (abilityImpropriate == 10) {
            isCalcPLSData = true;
        } else if (abilityImpropriate == 20) {
            isCalcOrderData = true;
        } else if (abilityImpropriate == 30) {
            isCalcPLSData = true;
            isCalcOrderData = true;
        }
        if (isCalcPLSData) {
            sqlBuffer = new StringBuffer();
            sqlBuffer.append("select funitid,fmaterialid,sum(fqty) as sumQty from T_MM_PLSENTRY ");
            sqlBuffer.append("where FISSUBPLAN = 0 and FPRODUCTLINEID = ? and fvardate = ? and fparent <> ? and (fbasestatus = 2 or fbasestatus = 4) ");
            sqlBuffer.append("group by funitid,fmaterialid");
            rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{productLineId, workDate, this.voucherID});
            try {
                while (rows.next()) {
                    unitId = rows.getString("funitid");
                    materialid = rows.getString("fmaterialid");
                    sumQty = rows.getBigDecimal("sumQty");
                    productLine = (ProductLineInfo)this.productLineMap.get(productLineId);
                    usedYield = usedYield.add(sumQty.multiply(this.getExchangeRate(materialid, unitId, productLine.getUnit())));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (isCalcOrderData) {
            sqlBuffer = new StringBuffer();
            sqlBuffer.append(" select funitid,fmaterialid,sum(fqty) as sumQty from t_mm_productionorder ");
            sqlBuffer.append(" where fproductlineid = ? and fstartdate >= ? and fstartdate < ? and (fbasestatus = 2 or fbasestatus = 4 or fbasestatus = 5) ");
            sqlBuffer.append(" group by funitid,fmaterialid ");
            rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{productLineId, workDate, PLSUtil.setDateTime(workDate, 1)});
            try {
                while (rows.next()) {
                    unitId = rows.getString("funitid");
                    materialid = rows.getString("fmaterialid");
                    sumQty = rows.getBigDecimal("sumQty");
                    productLine = (ProductLineInfo)this.productLineMap.get(productLineId);
                    usedYield = usedYield.add(sumQty.multiply(this.getExchangeRate(materialid, unitId, productLine.getUnit())));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return usedYield;
    }

    protected BigDecimal getUsedYield(String productLineId, Timestamp workDate) throws BOSException, EASBizException {
        BigDecimal usedYield = PLSConstant.ZERO;
        int n = this.pLSList.size();
        for (int i = 0; i < n; ++i) {
            PLSEntryInfo pLSEntry = (PLSEntryInfo)this.pLSList.get(i);
            if (!productLineId.equals(pLSEntry.getProductLine().getId().toString()) || PLSUtil.setTimestamp(pLSEntry.getBeginDate()).compareTo(workDate) != 0) continue;
            ProductLineInfo productLine = (ProductLineInfo)this.productLineMap.get(productLineId);
            usedYield = usedYield.add(pLSEntry.getQty().multiply(this.getExchangeRate(pLSEntry.getMaterial().getId().toString(), pLSEntry.getUnit(), productLine.getUnit())));
        }
        return usedYield;
    }

    protected BigDecimal getUsedHour(String productLineId, Timestamp workDate, int abilityImpropriate) throws BOSException, EASBizException {
        String materialId;
        IRowSet rows;
        StringBuffer sqlBuffer;
        BigDecimal usedHour = PLSConstant.ZERO;
        boolean isCalcPLSData = false;
        boolean isCalcOrderData = false;
        if (abilityImpropriate == 10) {
            isCalcPLSData = true;
        } else if (abilityImpropriate == 20) {
            isCalcOrderData = true;
        } else if (abilityImpropriate == 30) {
            isCalcPLSData = true;
            isCalcOrderData = true;
        }
        if (isCalcPLSData) {
            sqlBuffer = new StringBuffer();
            sqlBuffer.append("select fmaterialid,sum(fqty) as sumQty from T_MM_PLSENTRY ");
            sqlBuffer.append("where FISSUBPLAN = 0 and (fbasestatus = 2 or fbasestatus = 4) ");
            sqlBuffer.append("and FPRODUCTLINEID = ? and fvardate = ? and fparent <> ? ");
            sqlBuffer.append("group by fmaterialid,funitid ");
            rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{productLineId, workDate, this.voucherID});
            try {
                while (rows.next()) {
                    materialId = rows.getString("fmaterialid");
                    BigDecimal sumQty = rows.getBigDecimal("sumQty");
                    String key = materialId + "@" + productLineId;
                    BigDecimal unitCap = (BigDecimal)this.lineUnitCaps.get(key);
                    if (unitCap == null) continue;
                    usedHour = usedHour.add(sumQty.divide(unitCap, 8, 4));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (isCalcOrderData) {
            sqlBuffer = new StringBuffer();
            sqlBuffer.append("select fmaterialid,funitid,sum(fqty) as sumQty from t_mm_productionorder ");
            sqlBuffer.append("where fproductlineid = ? and fstartdate >= ? and fstartdate < ? and (fbasestatus = 2 or fbasestatus = 4 or fbasestatus = 5) ");
            sqlBuffer.append("group by fmaterialid,funitid ");
            rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{productLineId, workDate, PLSUtil.setDateTime(workDate, 1)});
            try {
                while (rows.next()) {
                    materialId = rows.getString("fmaterialid");
                    String unitId = rows.getString("funitid");
                    BigDecimal sumQty = rows.getBigDecimal("sumQty");
                    String key = materialId + "@" + productLineId;
                    BigDecimal unitCap = (BigDecimal)this.lineUnitCaps.get(key);
                    if (unitCap == null) continue;
                    unitCap = unitCap.multiply(this.getExchangeRate(materialId, this.getProductUnit(materialId), unitId));
                    usedHour = usedHour.add(sumQty.divide(unitCap, 8, 4));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return usedHour;
    }

    protected BigDecimal getUsedHour(String productLineId, Timestamp workDate) throws BOSException, EASBizException {
        BigDecimal usedHour = PLSConstant.ZERO;
        int n = this.pLSList.size();
        for (int i = 0; i < n; ++i) {
            String key;
            BigDecimal unitCap;
            PLSEntryInfo pLSEntry = (PLSEntryInfo)this.pLSList.get(i);
            if (!productLineId.equals(pLSEntry.getProductLine().getId().toString()) || PLSUtil.setTimestamp(pLSEntry.getBeginDate()).compareTo(workDate) != 0 || (unitCap = (BigDecimal)this.lineUnitCaps.get(key = pLSEntry.getMaterial().getId().toString() + "@" + productLineId)) == null) continue;
            usedHour = usedHour.add(pLSEntry.getQty().divide(unitCap, 8, 4));
        }
        return usedHour;
    }

    protected BigDecimal getUsedHour(String productLineId, Timestamp beginTime, Timestamp endTime, int abilityImpropriate) throws BOSException, EASBizException {
        String materialId;
        IRowSet rows;
        StringBuffer sqlBuffer;
        BigDecimal usedHour = PLSConstant.ZERO;
        boolean isCalcPLSData = false;
        boolean isCalcOrderData = false;
        if (abilityImpropriate == 10) {
            isCalcPLSData = true;
        } else if (abilityImpropriate == 20) {
            isCalcOrderData = true;
        } else if (abilityImpropriate == 30) {
            isCalcPLSData = true;
            isCalcOrderData = true;
        }
        if (isCalcPLSData) {
            sqlBuffer = new StringBuffer();
            sqlBuffer.append("select fmaterialid,sum(fqty) as sumQty from T_MM_PLSENTRY ");
            sqlBuffer.append("where FISSUBPLAN = 0 and (fbasestatus = 2 or fbasestatus = 4) ");
            sqlBuffer.append("and FPRODUCTLINEID = ? and fbegindate >= ? and fbegindate <= ? and fparent <> ? ");
            sqlBuffer.append("group by fmaterialid,funitid ");
            rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{productLineId, beginTime, endTime, this.voucherID});
            try {
                while (rows.next()) {
                    materialId = rows.getString("fmaterialid");
                    BigDecimal sumQty = rows.getBigDecimal("sumQty");
                    String key = materialId + "@" + productLineId;
                    BigDecimal unitCap = (BigDecimal)this.lineUnitCaps.get(key);
                    if (unitCap == null) continue;
                    usedHour = usedHour.add(sumQty.divide(unitCap, 8, 4));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (isCalcOrderData) {
            sqlBuffer = new StringBuffer();
            sqlBuffer.append("select fmaterialid,funitid,sum(fqty) as sumQty from t_mm_productionorder ");
            sqlBuffer.append("where fproductlineid = ? and fstartdate >= ? and fstartdate <= ? and (fbasestatus = 2 or fbasestatus = 4 or fbasestatus = 5) ");
            sqlBuffer.append("group by fmaterialid,funitid ");
            rows = DbUtil.executeQuery((Context)this.ctx, (String)sqlBuffer.toString(), (Object[])new Object[]{productLineId, beginTime, endTime});
            try {
                while (rows.next()) {
                    materialId = rows.getString("fmaterialid");
                    String unitId = rows.getString("funitid");
                    BigDecimal sumQty = rows.getBigDecimal("sumQty");
                    String key = materialId + "@" + productLineId;
                    BigDecimal unitCap = (BigDecimal)this.lineUnitCaps.get(key);
                    if (unitCap == null) continue;
                    unitCap = unitCap.multiply(this.getExchangeRate(materialId, this.getProductUnit(materialId), unitId));
                    usedHour = usedHour.add(sumQty.divide(unitCap, 8, 4));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return usedHour;
    }

    protected BigDecimal getUsedHour(String productLineId, Timestamp beginTime, Timestamp endTime) throws BOSException, EASBizException {
        BigDecimal usedHour = PLSConstant.ZERO;
        int n = this.pLSList.size();
        for (int i = 0; i < n; ++i) {
            String key;
            BigDecimal unitCap;
            PLSEntryInfo pLSEntry = (PLSEntryInfo)this.pLSList.get(i);
            if (!productLineId.equals(pLSEntry.getProductLine().getId().toString()) || pLSEntry.getBeginDate().compareTo(beginTime) < 0 || pLSEntry.getBeginDate().compareTo(endTime) > 0 || (unitCap = (BigDecimal)this.lineUnitCaps.get(key = pLSEntry.getMaterial().getId().toString() + "@" + productLineId)) == null) continue;
            usedHour = usedHour.add(pLSEntry.getQty().divide(unitCap, 8, 4));
        }
        return usedHour;
    }

    protected MeasureUnitInfo getProductUnit(String materialId) {
        String key = materialId + this.storageOrgUnitInfo.getId().toString();
        MaterialPlanInfo mpInfo = (MaterialPlanInfo)this.materialPlanInfos.get(key);
        if (mpInfo != null && mpInfo.getProductUnit() != null) {
            return mpInfo.getProductUnit();
        }
        return null;
    }

    protected BigDecimal getExchangeRate(String materialId, MeasureUnitInfo beforeUnit, MeasureUnitInfo afterUnit) throws BOSException, EASBizException {
        BigDecimal baseExchangeRate = PLSConstant.ONE;
        MultiMeasureUnitInfo beforeMultiMeasureUnitInfo = null;
        MultiMeasureUnitInfo afterMultiMeasureUnitInfo = null;
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        if (beforeUnit != null) {
            beforeMultiMeasureUnitInfo = imultiUnit.getMultiUnit(materialId, beforeUnit.getId().toString());
        }
        if (afterUnit != null) {
            afterMultiMeasureUnitInfo = imultiUnit.getMultiUnit(materialId, afterUnit.getId().toString());
        }
        if (beforeMultiMeasureUnitInfo != null && afterMultiMeasureUnitInfo != null) {
            baseExchangeRate = beforeMultiMeasureUnitInfo.getBaseConvsRate().divide(afterMultiMeasureUnitInfo.getBaseConvsRate(), 8, 4);
        } else if (!beforeUnit.getId().toString().equals(afterUnit.getId().toString())) {
            if (afterUnit.getMeasureUnitGroup().getId().equals((Object)beforeUnit.getMeasureUnitGroup().getId())) {
                baseExchangeRate = beforeUnit.getCoefficient().divide(afterUnit.getCoefficient(), 8, 4);
            } else {
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"CANNOTCHANGEUNIT_DESC");
                int exceNum = 205;
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"CANNOTCHANGEUNIT_DEDAIL", (String[])new String[]{beforeUnit.getNumber(), beforeUnit.getName(), afterUnit.getNumber(), afterUnit.getName()});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
            }
        }
        return baseExchangeRate;
    }

    protected BigDecimal getExchangeRate(String materialId, String beforeUnitId, MeasureUnitInfo afterUnit) throws EASBizException, BOSException {
        BigDecimal baseExchangeRate = PLSConstant.ONE;
        MultiMeasureUnitInfo beforeMultiMeasureUnitInfo = null;
        MultiMeasureUnitInfo afterMultiMeasureUnitInfo = null;
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        beforeMultiMeasureUnitInfo = imultiUnit.getMultiUnit(materialId, beforeUnitId);
        if (afterUnit != null) {
            afterMultiMeasureUnitInfo = imultiUnit.getMultiUnit(materialId, afterUnit.getId().toString());
        }
        if (beforeMultiMeasureUnitInfo != null && afterMultiMeasureUnitInfo != null) {
            baseExchangeRate = beforeMultiMeasureUnitInfo.getBaseConvsRate().divide(afterMultiMeasureUnitInfo.getBaseConvsRate(), 8, 4);
        } else if (!beforeUnitId.equals(afterUnit.getId().toString())) {
            MeasureUnitInfo beforeUnit = (MeasureUnitInfo)this.unitMap.get(beforeUnitId);
            if (beforeUnit == null) {
                beforeUnit = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(beforeUnitId));
                this.unitMap.put(beforeUnitId, beforeUnit);
            }
            if (afterUnit.getMeasureUnitGroup().getId().equals((Object)beforeUnit.getMeasureUnitGroup().getId())) {
                baseExchangeRate = beforeUnit.getCoefficient().divide(afterUnit.getCoefficient(), 8, 4);
            } else {
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"CANNOTCHANGEUNIT_DESC");
                int exceNum = 205;
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"CANNOTCHANGEUNIT_DEDAIL", (String[])new String[]{beforeUnit.getNumber(), beforeUnit.getName(), afterUnit.getNumber(), afterUnit.getName()});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
            }
        }
        return baseExchangeRate;
    }

    protected BigDecimal getExchangeRate(String materialId, MeasureUnitInfo beforeUnit, String afterUnitId) throws EASBizException, BOSException {
        BigDecimal baseExchangeRate = PLSConstant.ONE;
        MultiMeasureUnitInfo beforeMultiMeasureUnitInfo = null;
        MultiMeasureUnitInfo afterMultiMeasureUnitInfo = null;
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        if (beforeUnit != null) {
            beforeMultiMeasureUnitInfo = imultiUnit.getMultiUnit(materialId, beforeUnit.getId().toString());
        }
        afterMultiMeasureUnitInfo = imultiUnit.getMultiUnit(materialId, afterUnitId);
        if (beforeMultiMeasureUnitInfo != null && afterMultiMeasureUnitInfo != null) {
            baseExchangeRate = beforeMultiMeasureUnitInfo.getBaseConvsRate().divide(afterMultiMeasureUnitInfo.getBaseConvsRate(), 8, 4);
        } else if (!afterUnitId.equals(beforeUnit.getId().toString())) {
            MeasureUnitInfo afterUnit = (MeasureUnitInfo)this.unitMap.get(afterUnitId);
            if (afterUnit == null) {
                afterUnit = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(afterUnitId));
                this.unitMap.put(afterUnitId, afterUnit);
            }
            if (afterUnit.getMeasureUnitGroup().getId().equals((Object)beforeUnit.getMeasureUnitGroup().getId())) {
                baseExchangeRate = beforeUnit.getCoefficient().divide(afterUnit.getCoefficient(), 8, 4);
            } else {
                String exceDesc = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"CANNOTCHANGEUNIT_DESC");
                int exceNum = 205;
                String exceDetail = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.planning.SchedulingExceptionResource", (String)"CANNOTCHANGEUNIT_DEDAIL", (String[])new String[]{beforeUnit.getNumber(), beforeUnit.getName(), afterUnit.getNumber(), afterUnit.getName()});
                PLSExectionMSGInfo exceInfo = new PLSExectionMSGInfo(exceNum, exceDesc, exceDetail, this.voucherID);
                this.exceptions.add(exceInfo);
            }
        }
        return baseExchangeRate;
    }

    protected void getLineUnitCaps(Set materialSet, Set lineSet) {
        this.lineUnitCaps = new HashMap();
        for (int i = 0; i < this.productLinePAllotDefEntryCollection.size(); ++i) {
            ProductLinePAllotDefEntryInfo allotDefEntry = this.productLinePAllotDefEntryCollection.get(i);
            String materialID = allotDefEntry.getMaterial().getId().toString();
            if (!materialSet.contains(materialID)) continue;
            ProductLinePAllotDefEntryRuleEntryCollection allotDefRuleEntryCol = allotDefEntry.getRuleEntrys();
            for (int j = 0; j < allotDefRuleEntryCol.size(); ++j) {
                ProductLinePAllotDefEntryRuleEntryInfo allotDefRuleEntry = allotDefRuleEntryCol.get(j);
                String productLineID = allotDefRuleEntry.getProductLine().getId().toString();
                if (!lineSet.contains(productLineID)) continue;
                double unitTimeQty = allotDefRuleEntry.getProductBatch().doubleValue() / allotDefRuleEntry.getBatchTime().doubleValue();
                if (allotDefRuleEntry.getBatchTimeUnit().equals((Object)TimeUnitEnum.MINUTE)) {
                    unitTimeQty *= 60.0;
                }
                String key = materialID + "@" + productLineID;
                this.lineUnitCaps.put(key, new BigDecimal(unitTimeQty));
            }
        }
    }

    protected void getLineLots(Set materialSet, Set lineSet) {
        this.lineLotMap = new HashMap();
        for (int i = 0; i < this.productLinePAllotDefEntryCollection.size(); ++i) {
            ProductLinePAllotDefEntryInfo allotDefEntry = this.productLinePAllotDefEntryCollection.get(i);
            ProductLinePAllotDefEntryRuleEntryCollection allotDefRuleEntryCol = allotDefEntry.getRuleEntrys();
            String materialID = allotDefEntry.getMaterial().getId().toString();
            if (!materialSet.contains(materialID)) continue;
            for (int j = 0; j < allotDefRuleEntryCol.size(); ++j) {
                ProductLinePAllotDefEntryRuleEntryInfo allotDefRuleEntry = allotDefRuleEntryCol.get(j);
                String productLineID = allotDefRuleEntry.getProductLine().getId().toString();
                if (!lineSet.contains(productLineID) || !allotDefRuleEntry.isIsByLot()) continue;
                String key = materialID + "@" + productLineID;
                this.lineLotMap.put(key, allotDefRuleEntry.getProductBatch());
            }
        }
    }

    protected PLSEntryInfo getPLSEntryFromPLChooseEntry(PLChooseEntryInfo pLCEntry) throws BOSException, EASBizException {
        PLSEntryInfo pLSEntry = new PLSEntryInfo();
        pLSEntry.setId(BOSUuid.create((String)"72079370"));
        pLSEntry.setProductLine(pLCEntry.getProductLine());
        pLSEntry.setWorkShop(pLCEntry.getWorkShop());
        pLSEntry.getProductLine().setWorkshop(pLCEntry.getWorkShop());
        pLSEntry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        pLSEntry.setMaterial(pLCEntry.getMaterial());
        pLSEntry.setUnit(pLCEntry.getUnit());
        pLSEntry.setBaseUnit(pLSEntry.getMaterial().getBaseUnit());
        pLSEntry.setRequiredDate(pLCEntry.getEndDate());
        pLSEntry.setSourceBillNumber(pLCEntry.getSourceBillNumber());
        pLSEntry.setSourceBillId(pLCEntry.getSourceBillId());
        pLSEntry.setSrcType(pLCEntry.getSrcType());
        pLSEntry.setTraceNo(pLCEntry.getTraceNo());
        pLSEntry.setTrackNumber(pLCEntry.getTrackNumber());
        pLSEntry.setSaleOrder(pLCEntry.getSaleOrder());
        pLSEntry.setPlcEntryId(pLCEntry.getId().toString());
        pLSEntry.setSourceBillEntryId(pLCEntry.getSourceBillEntryId());
        pLSEntry.setIsSubPlan(false);
        pLSEntry.setIsExpand(false);
        pLSEntry.setEndQty(PLSConstant.ZERO);
        pLSEntry.setLastUpdateTime(new Timestamp(new Date().getTime()));
        UserInfo currUser = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo(this.ctx.getCaller());
        pLSEntry.setLastUpdateUser(currUser);
        return pLSEntry;
    }
}

