/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPException;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SopBillInfo;
import com.kingdee.eas.mm.planning.SopDayPlanInfo;
import com.kingdee.eas.mm.planning.app.SOPFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SopPlanAlgorithm {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.SopPlanAlgorithm");
    private String storageOrgUnitId;
    private String planVersionId;
    private Map rateMap = new HashMap();
    private Map precisionMap = new HashMap();
    private PreparedStatement stmtInsertDayPlan;
    private PreparedStatement stmtDeleteDayPlan;
    private PreparedStatement stmtDeletePlan;
    private Connection conn;
    private Map p2pMap = new HashMap();
    private Map n2pMap = new HashMap();
    private Map tp2spMap = new HashMap();
    private int tptpFrom;
    private int tptpTo;
    private Calendar tpDayFrom;
    private Calendar tpDayTo;
    private Map mat2tptpQty = new HashMap();
    private Map matId2BillId = new HashMap();
    private Map updatedMap = new HashMap();
    private Map workDays = new HashMap();
    private BigDecimal passedSales;
    private BigDecimal passedProdTheory;
    private BigDecimal passedProd;
    private Calendar curDate;
    private int curDateNumber;
    private SOPFacadeControllerBean sopfacade;
    private ISOPFacade isopfacade;
    private SOPPeriod[] range;
    private Context ctx;
    private static String clr = "\r\n";
    private boolean log4debug = true;
    private SOPEditModeEnum editMode;
    private SOPEditModeEnum srcEditMode;
    private static BigDecimal ZERO = new BigDecimal("0");

    public SopPlanAlgorithm(SOPFacadeControllerBean bean, Context ctx, Connection conn, SOPPeriod[] range, SOPEditModeEnum editMode) {
        this.range = range;
        if (editMode.getValue() == 20) {
            this.editMode = SOPEditModeEnum.WEEKLY;
            this.srcEditMode = SOPEditModeEnum.MONTHLY;
        } else {
            this.editMode = SOPEditModeEnum.MONTHLY;
            this.srcEditMode = SOPEditModeEnum.WEEKLY;
        }
        this.ctx = ctx;
        this.conn = conn;
        this.sopfacade = bean;
    }

    public SopPlanAlgorithm(ISOPFacade bean, Context ctx, Connection conn, SOPPeriod[] range, SOPEditModeEnum editMode) {
        this.range = range;
        if (editMode.getValue() == 20) {
            this.editMode = SOPEditModeEnum.WEEKLY;
            this.srcEditMode = SOPEditModeEnum.MONTHLY;
        } else {
            this.editMode = SOPEditModeEnum.MONTHLY;
            this.srcEditMode = SOPEditModeEnum.WEEKLY;
        }
        this.ctx = ctx;
        this.conn = conn;
        this.isopfacade = bean;
    }

    public String getPlanVersionId() {
        return this.planVersionId;
    }

    public void setPlanVersionId(String planVersionId) {
        this.planVersionId = planVersionId;
    }

    public String getStorageOrgUnitId() {
        return this.storageOrgUnitId;
    }

    public void setStorageOrgUnitId(String storageOrgUnitId) {
        this.storageOrgUnitId = storageOrgUnitId;
    }

    public Map getRateMap() {
        return this.rateMap;
    }

    public void setRateMap(Map rateMap) {
        this.rateMap = rateMap;
    }

    public Map getPrecisionMap() {
        return this.precisionMap;
    }

    public void setPrecisionMap(Map precisionMap) {
        this.precisionMap = precisionMap;
    }

    private void batchInsertSopDayPlan(String billId, ArrayList workDays, BigDecimal[] sales, BigDecimal[] prodTheorys, BigDecimal[] prods, BigDecimal[] targetInvs) throws SQLException {
        int qtyPrecision = (Integer)this.precisionMap.get(billId);
        BigDecimal rate = (BigDecimal)this.rateMap.get(billId);
        for (int i = 0; i < sales.length; ++i) {
            this.stmtInsertDayPlan.setString(1, billId);
            this.stmtInsertDayPlan.setBigDecimal(2, sales[i]);
            this.stmtInsertDayPlan.setBigDecimal(3, prodTheorys[i]);
            this.stmtInsertDayPlan.setBigDecimal(4, prods[i]);
            this.stmtInsertDayPlan.setBigDecimal(5, targetInvs[i]);
            this.stmtInsertDayPlan.setInt(6, SopPlanAlgorithm.getNumberFromCalendar((Calendar)workDays.get(i)));
            this.stmtInsertDayPlan.setBigDecimal(7, sales[i].multiply(rate).setScale(qtyPrecision, 4));
            this.stmtInsertDayPlan.setBigDecimal(8, prodTheorys[i].multiply(rate).setScale(qtyPrecision, 4));
            this.stmtInsertDayPlan.setBigDecimal(9, prods[i].multiply(rate).setScale(qtyPrecision, 4));
            this.stmtInsertDayPlan.setBigDecimal(10, targetInvs[i].multiply(rate).setScale(qtyPrecision, 4));
            this.stmtInsertDayPlan.addBatch();
        }
    }

    private int getNumberFromDate(java.util.Date d) {
        Calendar date = Calendar.getInstance();
        date.setTime(d);
        return SopPlanAlgorithm.getNumberFromCalendar(date);
    }

    private String getInsertSopDayPlanSql() {
        String clr = "\r\n";
        String bosType = new SopDayPlanInfo().getBOSType().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_MM_SopDayPlan (FId,FParentId,FSalesQty,FProdTheoryQty,FProductionQty,FTargetInvQty,FPeriodNumber,FBaseSalesQty,FBaseProdTheoryQty,FBaseProductionQty,FBaseTargetInvQty) ").append(clr).append(" VALUES(NEWBOSID('").append(bosType).append("'),?,?,?,?,?,?,?,?,?,?);");
        return sql.toString();
    }

    private void batchInsertSopPlan(String billId, ArrayList periods, BigDecimal[] targetInvs) throws SQLException {
        logger.info((Object)("insert target sop plan for periods, " + SopPlanAlgorithm.logPeriodRange(periods)));
        String bosType = new SopDayPlanInfo().getBOSType().toString();
        BigDecimal rate = (BigDecimal)this.rateMap.get(billId);
        int qtyPrecision = (Integer)this.precisionMap.get(billId);
        for (int i = 0; i < periods.size(); ++i) {
            SOPPeriod period = (SOPPeriod)periods.get(i);
            String number = Integer.toString(period.toNumber());
            String key = billId + number;
            if (this.updatedMap.get(key) != null) continue;
            StringBuffer sql = new StringBuffer();
            sql.append(" INSERT INTO T_MM_SOPPlan (").append(" FID,FEditMode,FSalesQty,FProdTheoryQty,FProductionQty,FTargetInvQty,FParentId,FPeriodNumber,FYear,FPeriod ").append(",FBaseSalesQty,FBaseProdTheoryQty,FBaseProductionQty,FBaseTargetInvQty)").append(clr).append(" SELECT NEWBOSID('").append(bosType).append("'),").append(this.editMode.getValue()).append(",isnull(SUM(FSalesQty),0),isnull(SUM(FProdTheoryQty),0),isnull(SUM(FProductionQty),0), ").append(targetInvs[i].setScale(qtyPrecision, 4)).append(",'").append(billId).append("',").append(period.toNumber()).append(",").append(period.getYear()).append(",").append(period.getNumber()).append(",isnull(round(SUM(FSalesQty)*" + rate + "," + qtyPrecision + "),0)").append(",isnull(round(SUM(FProdTheoryQty)*" + rate + "," + qtyPrecision + "),0)").append(",isnull(round(SUM(FProductionQty)*" + rate + "," + qtyPrecision + "),0),").append(targetInvs[i].multiply(rate).setScale(qtyPrecision, 4)).append(clr).append(" FROM T_MM_SOPDayPlan").append(clr).append(" WHERE FParentId = '").append(billId).append("'").append(clr).append("   AND FPeriodNumber>= ").append(SopPlanAlgorithm.getNumberFromCalendar(period.getBeginDate())).append(clr).append("   AND FPeriodNumber<= ").append(SopPlanAlgorithm.getNumberFromCalendar(period.getEndDate())).append(";").append(clr);
            this.updatedMap.put(key, sql.toString());
        }
    }

    private void fetchQtyInPassTime(String billId, int dateFrom, int dateTo, int dateCur) throws BOSException, SQLException {
        IRowSet rs = null;
        if (dateFrom < dateCur && dateTo >= dateCur) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT SUM(FSalesQty) FSalesSum, SUM(FProdTheoryQty) FProdTheorySum, SUM(FProductionQty) FProdSum ").append(" FROM T_MM_SOPDayPlan").append(clr).append(" WHERE FParentId = ? ").append(clr).append("   AND FPeriodNumber>= ?").append(clr).append("   AND FPeriodNumber< ?").append(clr);
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{billId, new Integer(dateFrom), new Integer(dateCur)});
        }
        if (rs != null && rs.next()) {
            this.passedSales = rs.getBigDecimal("FSalesSum");
            this.passedProdTheory = rs.getBigDecimal("FProdTheorySum");
            this.passedProd = rs.getBigDecimal("FProdSum");
        }
        if (this.passedSales == null) {
            this.passedSales = ZERO;
        }
        if (this.passedProdTheory == null) {
            this.passedProdTheory = ZERO;
        }
        if (this.passedProd == null) {
            this.passedProd = ZERO;
        }
        if (this.log4debug) {
            logger.info((Object)("fetch sales & production plan in passed time , from " + dateFrom + " to " + dateTo + " salesSum = " + this.passedSales + ", prodTheorySum = " + this.passedProdTheory + ", prodSum = " + this.passedProd));
        }
    }

    private String getInsertSopPlanSql() {
        String bosType = new SopDayPlanInfo().getBOSType().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_MM_SOPPlan (").append(" FID,FEditMode,FSalesQty,FProductionQty,FTargetInvQty,FParentId,FPeriodNumber,FYear,FPeriod) ").append(clr).append(" SELECT NEWBOSID('").append(bosType).append("'),").append(this.editMode.getValue()).append("        ,SUM(FSalesQty),SUM(FProductionQty), ?,?,?,?,?").append(clr).append(" FROM T_MM_SOPDayPlan").append(clr).append(" WHERE FParentId = ? ").append(clr).append("   AND FPeriodNumber>= ? ").append(clr).append("   AND FPeriodNumber<= ?; ").append(clr);
        return sql.toString();
    }

    private IRowSet getTargetInv(String[] matIdArray, Map storageMatIds) throws BOSException, SQLException {
        String bosType = new SopDayPlanInfo().getBOSType().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT b.FSupplyStorageOrgUnitID||b.FMaterialID || to_char(FPeriodNumber) FKey,FTargetInvQty ").append(clr).append(" FROM T_MM_SOPBill b, T_MM_SOPPlan e ").append(clr).append(" WHERE b.FID = e.FParentId  ").append(clr).append("   AND b.FStorageOrgUnitId = ? ").append(clr).append("   AND b.FPlanVersionId = ? ").append(clr).append("   AND e.FEditMode = ? ").append(clr).append("   AND e.FPeriodNumber >= ? ").append(clr).append("   AND e.FPeriodNumber <= ? ").append(clr).append("   and ( ");
        for (int i = 0; i < matIdArray.length; ++i) {
            String storageId = (String)storageMatIds.get(matIdArray[i] + "storage");
            String materialId = (String)storageMatIds.get(matIdArray[i] + "material");
            if (i != matIdArray.length - 1) {
                sql.append(" (b.FSupplyStorageOrgUnitID= '" + storageId + "' and b.FMaterialID ='" + materialId + "') or ");
                continue;
            }
            sql.append(" (b.FSupplyStorageOrgUnitID= '" + storageId + "' and b.FMaterialID ='" + materialId + "') ");
        }
        sql.append(" )");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.storageOrgUnitId, this.planVersionId, new Integer(this.srcEditMode.getValue()), new Integer(this.tptpFrom), new Integer(this.tptpTo)});
        return rs;
    }

    private boolean isPeriodOverlapped(SOPPeriod p1, SOPPeriod p2, boolean notIncludeIfP2LaterThanP1) {
        if (SopPlanAlgorithm.compareCalendarIgnoreTime(p1.getBeginDate(), p2.getEndDate()) <= 0 && SopPlanAlgorithm.compareCalendarIgnoreTime(p1.getEndDate(), p2.getBeginDate()) >= 0) {
            return !notIncludeIfP2LaterThanP1 || SopPlanAlgorithm.compareCalendarIgnoreTime(p2.getEndDate(), p1.getEndDate()) <= 0;
        }
        return false;
    }

    private void constructP2PMap() throws EASBizException, BOSException {
        this.p2pMap.clear();
        SOPPeriod periodFrom = this.sopfacade._getPeriod(this.ctx, this.range[0].getBeginDate().getTime(), this.editMode, this.storageOrgUnitId);
        List periodList = periodFrom.forwardPeriods(this.range[this.range.length - 1].getEndDate());
        logger.info((Object)("[constructP2PMap] periodList:" + periodList));
        for (SOPPeriod period : periodList) {
            for (int i = 0; i < this.range.length; ++i) {
                if (!this.isPeriodOverlapped(this.range[i], period, false)) continue;
                String key = Integer.toString(this.range[i].toNumber());
                ArrayList<SOPPeriod> bufferredList = (ArrayList<SOPPeriod>)this.p2pMap.get(key);
                if (bufferredList == null) {
                    bufferredList = new ArrayList<SOPPeriod>();
                    this.p2pMap.put(key, bufferredList);
                }
                bufferredList.add(period);
            }
        }
        logger.info((Object)("[constructP2PMap] p2p content:" + this.p2pMap.toString()));
    }

    private void constructP2PMap1() throws EASBizException, BOSException {
        this.p2pMap.clear();
        SOPPeriod periodFrom1 = null;
        periodFrom1 = this.sopfacade != null ? this.sopfacade._getPeriod(this.ctx, this.range[0].getBeginDate().getTime(), this.editMode, this.storageOrgUnitId) : this.isopfacade.getPeriod(this.range[0].getBeginDate().getTime(), this.editMode, this.storageOrgUnitId);
        List targetPeriods = periodFrom1.forwardPeriods(this.range[this.range.length - 1].getEndDate());
        SOPPeriod[] tp1 = SOPPeriod.list2Array(targetPeriods);
        this.tpDayFrom = tp1[0].getBeginDate();
        this.tpDayTo = tp1[tp1.length - 1].getEndDate();
        SOPPeriod periodFrom2 = null;
        periodFrom2 = this.sopfacade != null ? this.sopfacade._getPeriod(this.ctx, tp1[0].getBeginDate().getTime(), this.srcEditMode, this.storageOrgUnitId) : this.isopfacade.getPeriod(tp1[0].getBeginDate().getTime(), this.srcEditMode, this.storageOrgUnitId);
        List targetPeriods2 = periodFrom2.forwardPeriods(tp1[tp1.length - 1].getEndDate());
        this.tptpFrom = ((SOPPeriod)targetPeriods2.get(0)).toNumber();
        this.tptpTo = ((SOPPeriod)targetPeriods2.get(targetPeriods2.size() - 1)).toNumber();
        if (this.log4debug) {
            logger.info((Object)("[constructP2PMap] targetPeriods :" + targetPeriods));
        }
        this.constructP2PMap2(this.p2pMap, this.range, targetPeriods, false);
        if (this.log4debug) {
            logger.info((Object)("[constructP2PMap] p2p:" + this.p2pMap.toString()));
        }
        if (this.log4debug) {
            logger.info((Object)("[constructP2PMap] targetPeriods2 :" + targetPeriods2));
        }
        boolean notIncludeIfP2LaterThanP1 = this.srcEditMode.getValue() == 20;
        this.constructP2PMap2(this.tp2spMap, tp1, targetPeriods2, notIncludeIfP2LaterThanP1);
        if (this.log4debug) {
            logger.info((Object)("[constructP2PMap] tp2spMap:" + this.tp2spMap.toString()));
        }
    }

    private void constructP2PMap2(Map ppMap, SOPPeriod[] srcPeriods, List targetPeriods, boolean notIncludeIfP2LaterThanP1) {
        for (SOPPeriod period : targetPeriods) {
            for (int i = 0; i < srcPeriods.length; ++i) {
                SOPPeriod srcPeriod = srcPeriods[i];
                if (!this.isPeriodOverlapped(period, srcPeriod, notIncludeIfP2LaterThanP1)) continue;
                String key = Integer.toString(srcPeriod.toNumber());
                ArrayList<SOPPeriod> bufferredList = (ArrayList<SOPPeriod>)ppMap.get(key);
                if (bufferredList == null) {
                    bufferredList = new ArrayList<SOPPeriod>();
                    ppMap.put(key, bufferredList);
                }
                bufferredList.add(period);
            }
        }
    }

    private void deleteHolidayPlan() throws BOSException {
        Calendar dayFrom = this.tpDayFrom;
        if (SopPlanAlgorithm.compareCalendarIgnoreTime(dayFrom, this.curDateNumber) < 0) {
            dayFrom = this.curDate;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" DELETE FROM T_MM_SOPDayPlan ").append(clr).append(" WHERE EXISTS( ").append(clr).append("   SELECT 1 FROM  ").append(clr).append("   ( SELECT YEAR(t0.FWorkDate)*10000+MONTH(t0.FWorkDate)*100+DAYOFMONTH(t0.FWorkDate) FPeriodNumber ").append(clr).append("     FROM t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1  ").append(clr).append("     WHERE t0.fparentid = t1.fid  ").append(clr).append("       AND t0.fworkdate > ? ").append(clr).append("       AND t0.fworkdate < ? ").append(clr).append("       AND t1.fstorageorgunitid =  ? ").append(clr).append("       AND t0.FWorkDateSeq <= 0 ").append(clr).append("   ) b, T_MM_SopBill c ").append(clr).append("   WHERE T_MM_SOPDayPlan.FParentId = c.FId ").append(clr).append("     AND c.FStorageOrgUnitId = ? ").append(clr).append("     AND c.FPlanVersionId = ? ").append(clr).append("     AND T_MM_SOPDayPlan.FPeriodNumber = b.FPeriodNumber) ").append(clr);
        dayFrom.add(5, -1);
        this.tpDayTo.add(5, 1);
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{new Date(dayFrom.getTimeInMillis()), new Date(this.tpDayTo.getTimeInMillis()), this.storageOrgUnitId, this.storageOrgUnitId, this.planVersionId});
        if (this.log4debug) {
            this.log(false, "\nSOP: deleteHolidayPlan between (" + SopPlanAlgorithm.getNumberFromCalendar(dayFrom) + "," + SopPlanAlgorithm.getNumberFromCalendar(this.tpDayTo));
        }
    }

    public void addTargetInv2Map(String[] matIdList, IRowSet newData, Map storageMatIds, boolean isFromSyncSopPlan) throws BOSException, SQLException {
        IRowSet rs = this.getTargetInv(matIdList, storageMatIds);
        while (rs.next()) {
            BigDecimal targetInv = rs.getBigDecimal("FTargetInvQty");
            String key = rs.getString("FKey");
            this.mat2tptpQty.put(key, targetInv);
        }
        newData.beforeFirst();
        while (newData.next()) {
            int periodNumber;
            String matId;
            if (isFromSyncSopPlan) {
                String materialId = newData.getString("FMaterialId");
                String storageId = newData.getString("FStorageId");
                matId = storageId + materialId;
                periodNumber = newData.getInt("FPeriodNumber");
            } else {
                matId = matIdList[newData.getInt("FMatIndex")];
                periodNumber = newData.getInt("FYear") * 100 + newData.getInt("FMonth");
            }
            BigDecimal targetInv = newData.getBigDecimal("FTargetInvQty");
            this.mat2tptpQty.put(matId + periodNumber, targetInv);
            if (!this.log4debug) continue;
            logger.info((Object)("[addTargetinv2Map] update target inv:" + matId + periodNumber + " = " + targetInv.toString()));
        }
        newData.beforeFirst();
    }

    private void addTargetInv2Map(List matIdList, IRowSet newData, Map storageMatIds) throws BOSException, SQLException {
        String[] array = new String[matIdList.size()];
        for (int i = 0; i < matIdList.size(); ++i) {
            array[i] = (String)matIdList.get(i);
        }
        this.addTargetInv2Map(array, newData, storageMatIds, true);
    }

    private void constructN2PMap() {
        this.n2pMap.clear();
        for (int i = 0; i < this.range.length; ++i) {
            this.n2pMap.put(Integer.toString(this.range[i].toNumber()), this.range[i]);
        }
        if (this.log4debug) {
            logger.info((Object)("[constructN2PMap] n2p content:" + this.n2pMap.toString()));
        }
    }

    private String getDeleteSopPlanSql(boolean dayPlan, SOPEditModeEnum editMode) {
        String tblName = dayPlan ? "T_MM_SOPDayPlan " : "T_MM_SOPPLan ";
        StringBuffer sql = new StringBuffer();
        sql.append(" DELETE FROM ").append(tblName).append(clr).append(" WHERE FPeriodNumber >= ? ").append(clr).append("   AND FPeriodNumber <= ? ").append(clr);
        if (!dayPlan) {
            sql.append("   AND FEditMode = ").append(editMode.getValue()).append(clr);
        }
        sql.append("   AND FParentId in ").append(clr).append("    (SELECT FId ").append(clr).append("       FROM T_MM_SOPBill ").append(clr).append("     \tWHERE FStorageOrgUnitId = ? ").append(clr).append("     \t  AND FPlanVersionId = ? ").append(clr).append("     \t  AND FSupplyStorageOrgUnitID = ? ").append(clr).append("     \t  AND FMaterialId = ? ").append(clr).append("     );").append(clr);
        return sql.toString();
    }

    public void DeleteSopPlan(String storageId, String materialId, int beginPeriod, int endPeriod, SOPEditModeEnum editMode) throws BOSException {
        String sql = this.getDeleteSopPlanSql(false, editMode);
        PreparedStatement dstmt = null;
        try {
            dstmt = this.conn.prepareStatement(sql.toString());
            dstmt.setInt(1, beginPeriod);
            dstmt.setInt(2, endPeriod);
            dstmt.setString(3, this.storageOrgUnitId);
            dstmt.setString(4, this.planVersionId);
            dstmt.setString(5, storageId);
            dstmt.setString(6, materialId);
            dstmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(dstmt, null);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)dstmt, null);
    }

    public SOPEditModeEnum getEditMode() {
        return this.srcEditMode;
    }

    public void setEditMode(SOPEditModeEnum editMode) {
        if (editMode.getValue() == 20) {
            this.editMode = SOPEditModeEnum.WEEKLY;
            this.srcEditMode = SOPEditModeEnum.MONTHLY;
        } else {
            this.editMode = SOPEditModeEnum.MONTHLY;
            this.srcEditMode = SOPEditModeEnum.WEEKLY;
        }
    }

    private void batchDeleteSopPlan(boolean dayPlan, String storageId, String matId, int periodFrom, int periodTo) throws SQLException {
        PreparedStatement stmt;
        if (dayPlan) {
            stmt = this.stmtDeleteDayPlan;
            if (periodFrom < this.curDateNumber) {
                periodFrom = this.curDateNumber;
            }
        } else {
            stmt = this.stmtDeletePlan;
        }
        stmt.setInt(1, periodFrom);
        stmt.setInt(2, periodTo);
        stmt.setString(3, this.storageOrgUnitId);
        stmt.setString(4, this.planVersionId);
        stmt.setString(5, storageId);
        stmt.setString(6, matId);
        stmt.addBatch();
    }

    public static int getNumberFromCalendar(Calendar date) {
        return date.get(1) * 10000 + (date.get(2) + 1) * 100 + date.get(5);
    }

    private static int compareCalendarIgnoreTime(Calendar d1, Calendar d2) {
        int d2Int;
        int d1Int = d1.get(1) * 10000 + (d1.get(2) + 1) * 100 + d1.get(5);
        return d1Int > (d2Int = d2.get(1) * 10000 + (d2.get(2) + 1) * 100 + d2.get(5)) ? 1 : (d1Int == d2Int ? 0 : -1);
    }

    private static int compareCalendarIgnoreTime(Calendar d1, int d2Int) {
        int d1Int = d1.get(1) * 10000 + (d1.get(2) + 1) * 100 + d1.get(5);
        return d1Int > d2Int ? 1 : (d1Int == d2Int ? 0 : -1);
    }

    private void getWorkDays() throws BOSException, SQLException {
        if (this.range == null) {
            return;
        }
        String clr = "\r\n";
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT t0.FWorkDate ").append(clr).append("  FROM t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append(clr).append(" WHERE t0.fparentid = t1.fid ").append(clr).append("   AND t0.fworkdate > ? ").append(clr).append("   AND t0.fworkdate < ? ").append(clr).append("   AND t1.fstorageorgunitid = ? ").append(clr).append("   AND t0.FWorkDateSeq > 0;");
        Calendar begin = (Calendar)this.range[0].getBeginDate().clone();
        begin.add(5, -1);
        Calendar end = (Calendar)this.range[this.range.length - 1].getEndDate().clone();
        end.add(5, 1);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{new Date(begin.getTimeInMillis()), new Date(end.getTimeInMillis()), this.storageOrgUnitId});
        this.workDays.clear();
        block0: while (rs.next()) {
            Calendar date = Calendar.getInstance();
            date.setTime(rs.getDate("FWorkDate"));
            for (int i = 0; i < this.range.length; ++i) {
                if (SopPlanAlgorithm.compareCalendarIgnoreTime(date, this.range[i].getBeginDate()) < 0 || SopPlanAlgorithm.compareCalendarIgnoreTime(date, this.range[i].getEndDate()) > 0) continue;
                if (SopPlanAlgorithm.compareCalendarIgnoreTime(date, this.curDateNumber) < 0) continue block0;
                String key = Integer.toString(this.range[i].toNumber());
                ArrayList<Calendar> dateArray = (ArrayList<Calendar>)this.workDays.get(key);
                if (dateArray == null) {
                    dateArray = new ArrayList<Calendar>();
                    this.workDays.put(key, dateArray);
                }
                dateArray.add(date);
                continue block0;
            }
        }
        if (this.log4debug) {
            this.log(false, "\nSOP: getWorkDays between (" + SopPlanAlgorithm.getNumberFromCalendar(begin) + "," + SopPlanAlgorithm.getNumberFromCalendar(end) + "), days = " + rs.size());
        }
    }

    public BigDecimal[] average(BigDecimal data, int count, int precision) {
        int i;
        BigDecimal zero;
        if (data.compareTo(ZERO) < 0) {
            data = ZERO;
        }
        BigDecimal[] array = new BigDecimal[count];
        BigDecimal sum = zero = ZERO.setScale(precision, 4);
        if (count == 0) {
            return array;
        }
        BigDecimal avg = data.divide(new BigDecimal(count), 10, 4);
        for (i = 0; i < count - 1; ++i) {
            BigDecimal curData = avg.multiply(new BigDecimal(i + 1));
            if ((curData = curData.subtract(sum)).compareTo(zero) <= 0) {
                curData = zero;
            }
            curData = curData.setScale(precision, 4);
            sum = sum.add(curData);
            array[i] = curData;
            if (sum.compareTo(data) < 0) continue;
            ++i;
            break;
        }
        while (i < count - 1) {
            array[i] = zero;
            ++i;
        }
        array[i] = data.compareTo(sum) <= 0 ? zero : data.subtract(sum);
        return array;
    }

    private BigDecimal[] averageTargetInv(BigDecimal data, int count, int precision) {
        BigDecimal[] array = new BigDecimal[count];
        for (int i = 0; i < count; ++i) {
            array[i] = data;
        }
        return array;
    }

    private BigDecimal[] getSyncTargetInvs(BigDecimal data, String storageId, String matId, int precision, ArrayList targetPeriods) {
        BigDecimal[] targetInvs = new BigDecimal[targetPeriods.size()];
        for (int i = 0; i < targetPeriods.size(); ++i) {
            SOPPeriod period = (SOPPeriod)targetPeriods.get(i);
            targetInvs[i] = this.getSyncTargetInv(data, storageId, matId, precision, period);
        }
        return targetInvs;
    }

    private BigDecimal getSyncTargetInv(BigDecimal data, String storageId, String matId, int precision, SOPPeriod period) {
        String pn = Integer.toString(period.toNumber());
        BigDecimal targetInv = ZERO;
        if (this.srcEditMode.getValue() == 10) {
            ArrayList weeks = (ArrayList)this.tp2spMap.get(pn);
            if (weeks != null && weeks.size() > 0) {
                SOPPeriod firstWeek = (SOPPeriod)weeks.get(0);
                SOPPeriod lastWeek = (SOPPeriod)weeks.get(weeks.size() - 1);
                BigDecimal firstWeekQty = ZERO;
                if (firstWeek != null) {
                    firstWeekQty = (BigDecimal)this.mat2tptpQty.get(storageId + matId + Integer.toString(firstWeek.toNumber()));
                }
                BigDecimal lastWeekQty = ZERO;
                if (lastWeek != null) {
                    lastWeekQty = (BigDecimal)this.mat2tptpQty.get(storageId + matId + Integer.toString(lastWeek.toNumber()));
                }
                if (firstWeekQty == null) {
                    firstWeekQty = ZERO;
                }
                if (lastWeekQty == null) {
                    lastWeekQty = ZERO;
                }
                targetInv = firstWeekQty.add(lastWeekQty).divide(new BigDecimal("2"), precision, 4);
                if (this.log4debug) {
                    this.log(false, "\nSOP:getSyncTargetInv,editing week plan, matId = " + storageId + matId + ", sync to month " + SopPlanAlgorithm.logPeriodDate(period) + ", first week = " + SopPlanAlgorithm.logPeriodDate(firstWeek) + ", last week = " + SopPlanAlgorithm.logPeriodDate(lastWeek) + " targetInv = (" + firstWeekQty.toString() + "+" + lastWeekQty.toString() + ")/2=" + targetInv.toString());
                }
            }
        } else {
            ArrayList months = (ArrayList)this.tp2spMap.get(pn);
            BigDecimal monthQty = ZERO;
            SOPPeriod month = null;
            if (months != null) {
                month = months.size() == 2 ? (SOPPeriod)months.get(1) : (SOPPeriod)months.get(0);
                monthQty = (BigDecimal)this.mat2tptpQty.get(storageId + matId + month.toNumber());
                if (monthQty == null) {
                    monthQty = ZERO;
                }
            }
            targetInv = monthQty.setScale(precision, 4);
            if (this.log4debug) {
                this.log(false, "\nSOP:getSyncTargetInv,editing monthly plan, matId = " + storageId + matId + ", sync to week " + SopPlanAlgorithm.logPeriodDate(period) + " target inv = " + targetInv.toString() + ", from " + SopPlanAlgorithm.logPeriodDate(month));
            }
        }
        return targetInv;
    }

    public String updateSopBillAndGetBillId(String storageId, String materialId, BigDecimal bop) throws BOSException, SQLException {
        return this.updateSopBillAndGetBillId(storageId, materialId, bop, true);
    }

    public String updateSopBillAndGetBillId(String storageId, String materialId, BigDecimal bop, boolean tryAfterInsert) throws BOSException, SQLException {
        String billId = (String)this.matId2BillId.get(this.planVersionId + storageId + materialId);
        if (billId == null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FID FROM T_MM_SopBill ").append(clr).append(" WHERE FStorageOrgUnitId = ? ").append(clr).append("   AND FPlanVersionId = ? ").append(clr).append("   AND FMaterialId = ? ").append(clr).append(" and FSupplyStorageOrgUnitID = ? ;").append(clr);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.storageOrgUnitId, this.planVersionId, materialId, storageId});
            if (rs.size() == 0) {
                if (bop == null) {
                    bop = new BigDecimal("0");
                }
                this.insertSopBillId(storageId, materialId, bop);
                if (tryAfterInsert) {
                    rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.storageOrgUnitId, this.planVersionId, materialId, storageId});
                    rs.next();
                    billId = rs.getString("FID");
                }
            } else {
                rs.next();
                billId = rs.getString("FID");
                if (bop != null) {
                    this.updateMaterialBop(billId, bop);
                }
            }
            this.matId2BillId.put(this.planVersionId + storageId + materialId, billId);
        }
        return billId;
    }

    public void updateMaterialBop(String billId, BigDecimal bop) throws BOSException, SQLException {
        BigDecimal baseBop;
        StringBuffer sql = new StringBuffer();
        StringBuffer tbSql = new StringBuffer();
        int qtyPrecision = 0;
        BigDecimal rate = new BigDecimal(0.0);
        if (this.precisionMap == null || this.precisionMap.get(billId) == null) {
            tbSql.append(" select sb.fid fid,round(mu.FBaseConvsRate/mu2.FBaseConvsRate,8) rate,u2.fqtyPrecision qtyPrecision from t_mm_sopbill sb ");
            tbSql.append(" inner join t_bd_material m on m.fid=sb.fmaterialid ");
            tbSql.append(" inner join t_bd_materialplan mp on mp.fmaterialid=sb.fmaterialid and sb.FStorageOrgUnitID=mp.forgunit ");
            tbSql.append(" inner join t_bd_multimeasureunit mu on mu.fmaterialid= mp.fmaterialid\tand sb.FAssistUnitID =mu.FMeasureUnitId ");
            tbSql.append(" inner join T_BD_MultiMeasureUnit mu2 on  sb.FBaseUnitID = mu2.FMeasureUnitId and mp.FMaterialId = mu2.FMaterialId");
            tbSql.append(" inner join t_bd_measureunit u2 on u2.fid=sb.fbaseunitid ");
            tbSql.append(" where sb.fid=? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)tbSql.toString(), (Object[])new Object[]{billId});
            while (rowSet.next()) {
                String fid = rowSet.getString("fid");
                String precision = rowSet.getString("qtyPrecision");
                String sRate = rowSet.getString("rate");
                rate = new BigDecimal(sRate);
                qtyPrecision = Integer.parseInt(precision);
                this.precisionMap.put(fid, new Integer(precision));
                this.rateMap.put(fid, rate);
            }
        } else {
            qtyPrecision = (Integer)this.precisionMap.get(billId);
            rate = (BigDecimal)this.rateMap.get(billId);
        }
        if ((baseBop = bop.multiply(rate).setScale(qtyPrecision, 4)).compareTo(new BigDecimal("10000000000000")) > 0 || baseBop.compareTo(new BigDecimal("-10000000000000")) < 0) {
            try {
                throw new SOPException(SOPException.VALUE_TOO_LARGE, new String[]{this.getResource("BOP")});
            }
            catch (SOPException e) {
                throw new BOSException((Throwable)((Object)e));
            }
        }
        sql.append(" UPDATE T_MM_SopBill ").append(clr).append("    SET FBopDate = ?, FBop = ? ,FBaseBop=?").append(clr).append(" WHERE FId = ?; ").append(clr);
        Calendar date = Calendar.getInstance();
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{new Date(date.getTimeInMillis()), bop, baseBop, billId});
    }

    private void insertSopBillId(String storageid, String materialId, BigDecimal bop) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        StringBuffer addSql = new StringBuffer();
        StringBuffer idsql = new StringBuffer();
        String baseUnit = null;
        BigDecimal rate = null;
        String measureUnit = null;
        BigDecimal baseBop = null;
        Integer qtyPrecision = null;
        String sopBillBostype = new SopBillInfo().getBOSType().toString();
        addSql.append(" select m.fbaseunit baseUnit,mu.fbaseConvsRate rate,u.fid measureUnit,u2.fqtyPrecision qtyPrecision from t_bd_material m inner join T_BD_MaterialPlan mp on mp.FMaterialId=m.fid ");
        addSql.append(" inner join T_BD_MultiMeasureUnit mu on  mp.FProductunitid = mu.FMeasureUnitId and mp.FMaterialId = mu.FMaterialId ");
        addSql.append(" inner join T_BD_MeasureUnit u on mu.FMeasureUnitId = u.FId");
        addSql.append(" inner join T_BD_MeasureUnit u2 on m.Fbaseunit = u2.FId");
        addSql.append(" where mp.FOrgUnit=? and mp.FMaterialId= ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)addSql.toString(), (Object[])new Object[]{this.storageOrgUnitId, materialId});
        try {
            while (rowSet.next()) {
                baseUnit = rowSet.getString("baseUnit");
                rate = new BigDecimal(rowSet.getString("rate"));
                qtyPrecision = new Integer(rowSet.getString("qtyPrecision"));
                measureUnit = rowSet.getString("measureUnit");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        baseBop = rate.multiply(bop);
        if (baseBop.compareTo(new BigDecimal("10000000000000")) > 0) {
            try {
                throw new SOPException(SOPException.VALUE_TOO_LARGE, new String[]{this.getResource("BOP")});
            }
            catch (SOPException e) {
                throw new BOSException((Throwable)((Object)e));
            }
        }
        sql.append("INSERT INTO T_MM_SOPBill(FID,FPlanVersionID,FStorageOrgUnitID,FMaterialID,FBopDate,FBop,FSupplyStorageOrgUnitID,FBaseBop,FBaseUnitID,FAssistUnitID) ").append(clr).append(" VALUES(NEWBOSID('").append(sopBillBostype).append("'),?,?,?,?,?,?,?,?,?);").append(clr);
        Calendar date = Calendar.getInstance();
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.planVersionId, this.storageOrgUnitId, materialId, new Date(date.getTimeInMillis()), bop, storageid, baseBop, baseUnit, measureUnit});
        idsql.append(" select fid from t_mm_sopbill where FPlanVersionID=? and FStorageOrgUnitID=? and FMaterialID=? and FSupplyStorageOrgUnitID=?");
        IRowSet set = DbUtil.executeQuery((Context)this.ctx, (String)idsql.toString(), (Object[])new Object[]{this.planVersionId, this.storageOrgUnitId, materialId, storageid});
        while (set.next()) {
            String id = set.getString("fid");
            this.rateMap.put(id, rate);
            this.precisionMap.put(id, qtyPrecision);
        }
    }

    private void log(boolean isError, String info) {
        if (isError) {
            logger.error((Object)info);
        } else {
            logger.info((Object)info);
        }
    }

    public void syncOnePeriodPlan(int periodNumber, String storageId, String matId, String billId, int precision, BigDecimal sale, BigDecimal prodTheory, BigDecimal prod, BigDecimal targetInv) throws BOSException, SQLException {
        SOPPeriod period = (SOPPeriod)this.n2pMap.get(Integer.toString(periodNumber));
        ArrayList targetPeriods = (ArrayList)this.p2pMap.get(Integer.toString(period.toNumber()));
        ArrayList days = (ArrayList)this.workDays.get(Integer.toString(period.toNumber()));
        if (days == null) {
            if (this.log4debug) {
                this.log(false, "\nSOP: the period " + period.toNumber() + " contains NO work days");
            }
            return;
        }
        if (this.log4debug) {
            this.log(false, "\nSOP: begin to sync sop plan for matid=" + storageId + matId + " period " + Integer.toString(period.toNumber()));
        }
        if (this.log4debug) {
            this.log(false, "\nSOP: the period contains work days(" + days.size() + ") " + SopPlanAlgorithm.dateRange2String(days));
        }
        if (days == null) {
            logger.error((Object)("\nSOP: Period " + period.toString() + ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"13_SopPlanAlgorithm", (Locale)this.ctx.getLocale())));
            return;
        }
        int beginDateNumber = SopPlanAlgorithm.getNumberFromCalendar(period.getBeginDate());
        int endDateNumber = SopPlanAlgorithm.getNumberFromCalendar(period.getEndDate());
        this.batchDeleteSopPlan(true, storageId, matId, beginDateNumber, endDateNumber);
        if (this.log4debug) {
            this.log(false, "\nSOP: delete & insert sop day plan between " + beginDateNumber + " to " + endDateNumber);
        }
        this.fetchQtyInPassTime(billId, beginDateNumber, endDateNumber, this.curDateNumber);
        if (sale == null) {
            sale = ZERO;
        }
        BigDecimal salesToBeAveraged = sale.subtract(this.passedSales);
        BigDecimal[] sales = this.average(salesToBeAveraged, days.size(), precision);
        if (this.log4debug) {
            this.log(false, "\nSOP: salesQty - passedSales = " + sale + "-" + this.passedSales + " = " + salesToBeAveraged + " is averaged to " + SopPlanAlgorithm.bigDecimalArrayToString(sales));
        }
        if (prodTheory == null) {
            prodTheory = ZERO;
        }
        BigDecimal prodTheoryToBeAveraged = prodTheory.subtract(this.passedProdTheory);
        BigDecimal[] prodTheorys = this.average(prodTheoryToBeAveraged, days.size(), precision);
        if (this.log4debug) {
            this.log(false, "\nSOP: prodTheoryQty  - passedTheoryProd = " + prodTheory + "-" + this.passedProdTheory + " = " + prodTheoryToBeAveraged + " is averaged to " + SopPlanAlgorithm.bigDecimalArrayToString(prodTheorys));
        }
        if (prod == null) {
            prod = ZERO;
        }
        BigDecimal prodToBeAveraged = prod.subtract(this.passedProd);
        BigDecimal[] prods = this.average(prodToBeAveraged, days.size(), precision);
        if (this.log4debug) {
            this.log(false, "\nSOP: prodQty  - passedProd = " + prod + "-" + this.passedProd + " = " + prodToBeAveraged + " is averaged to " + SopPlanAlgorithm.bigDecimalArrayToString(prods));
        }
        if (targetInv == null) {
            targetInv = ZERO;
        }
        BigDecimal[] invs = this.averageTargetInv(targetInv, days.size(), precision);
        this.batchInsertSopDayPlan(billId, days, sales, prodTheorys, prods, invs);
        this.batchDeleteSopPlan(false, storageId, matId, ((SOPPeriod)targetPeriods.get(0)).toNumber(), ((SOPPeriod)targetPeriods.get(targetPeriods.size() - 1)).toNumber());
        BigDecimal[] targetInvs = this.getSyncTargetInvs(targetInv, storageId, matId, precision, targetPeriods);
        if (this.log4debug) {
            this.log(false, "\nSOP: target inv qty = " + SopPlanAlgorithm.bigDecimalArrayToString(invs) + " is averaged to " + SopPlanAlgorithm.bigDecimalArrayToString(targetInvs));
        }
        this.batchInsertSopPlan(billId, targetPeriods, targetInvs);
    }

    public void syncSopPlan(List matIds, Map storageMatIds) throws BOSException, SQLException {
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> materialList = new ArrayList<String>();
        ArrayList<String> storageList = new ArrayList<String>();
        SOPEditModeEnum sourceEditMode = this.editMode == SOPEditModeEnum.MONTHLY ? SOPEditModeEnum.WEEKLY : SOPEditModeEnum.MONTHLY;
        for (i = 0; i < matIds.size(); ++i) {
            String ids = (String)matIds.get(i);
            String storageid = (String)storageMatIds.get(ids + "storage");
            String materialId = (String)storageMatIds.get(ids + "material");
            storageList.add(storageid);
            materialList.add(materialId);
        }
        sql.append(" SELECT b.FID FBillId, b.FSupplyStorageOrgUnitID FStorageId,b.FMaterialId FMaterialId, mu.FQtyPrecision, p.FPeriodNumber, p.FSalesQty, p.FProdTheoryQty,p.FProductionQty, p.FTargetInvQty \n").append(" FROM T_MM_SOPPlan p, T_MM_SopBill b, T_BD_Material m, T_BD_MultiMeasureUnit mu, T_BD_MeasureUnit u \n").append(" WHERE b.FMaterialId = m.FID \n").append("   AND m.FBaseUnit = u.FId \n").append("   AND m.FBaseUnit = mu.FMeasureUnitId \n").append("   AND m.FId = mu.FMaterialId \n").append("   AND b.FId = p.FParentId \n").append("   AND b.FStorageOrgUnitId = ? \n").append("   AND b.FPlanVersionId = ? \n").append("   AND p.FEditMode = ? ").append("   AND p.FPeriodNumber >= ? ").append("   AND p.FPeriodNumber <= ? ").append("   AND (");
        for (i = 0; i < matIds.size(); ++i) {
            sql.append("( b.FSupplyStorageOrgUnitID='" + storageList.get(i) + "'and b.FMaterialId='" + materialList.get(i) + "')");
            if (i != matIds.size() - 1) {
                sql.append(" or ");
                continue;
            }
            sql.append(" ) ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{this.storageOrgUnitId, this.planVersionId, new Integer(sourceEditMode.getValue()), new Integer(this.range[0].toNumber()), new Integer(this.range[this.range.length - 1].toNumber())});
        this.addTargetInv2Map(matIds, rs, storageMatIds);
        rs.beforeFirst();
        while (rs.next()) {
            String matId = rs.getString("FMaterialId");
            String storageId = rs.getString("FStorageId");
            String billId = rs.getString("FBillId");
            int periodNumber = rs.getInt("FPeriodNumber");
            int precision = rs.getInt("FQtyPrecision");
            BigDecimal sales = rs.getBigDecimal("FSalesQty");
            BigDecimal prodTheory = rs.getBigDecimal("FProdTheoryQty");
            BigDecimal prod = rs.getBigDecimal("FProductionQty");
            BigDecimal targetInv = rs.getBigDecimal("FTargetInvQty");
            this.syncOnePeriodPlan(periodNumber, storageId, matId, billId, precision, sales, prodTheory, prod, targetInv);
        }
        this.executeBatch();
        this.updatedMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws BOSException, SQLException {
        Statement istmt = this.conn.createStatement();
        try {
            this.stmtDeleteDayPlan.executeBatch();
            this.stmtInsertDayPlan.executeBatch();
            this.stmtDeletePlan.executeBatch();
            Iterator it = this.updatedMap.entrySet().iterator();
            while (it.hasNext()) {
                String sql = (String)it.next().getValue();
                istmt.addBatch(sql);
            }
            if (this.updatedMap.entrySet().size() > 0) {
                istmt.executeBatch();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            SQLUtils.cleanup((Statement)this.stmtDeleteDayPlan, null);
            SQLUtils.cleanup((Statement)this.stmtInsertDayPlan, null);
            SQLUtils.cleanup((Statement)this.stmtDeletePlan, (Connection)this.conn);
            SQLUtils.cleanup((Statement)istmt, (Connection)this.conn);
        }
    }

    public static String getInPredicateFromList(List idList) {
        StringBuffer ids = new StringBuffer();
        Iterator it = idList.iterator();
        while (it.hasNext()) {
            ids.append(",'").append((String)it.next()).append("'");
        }
        if (ids.length() > 0) {
            ids.setCharAt(0, '(');
            ids.append(")");
        }
        return ids.toString();
    }

    public static String getInPredicateFromArray(String[] idArray) {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < idArray.length; ++i) {
            ids.append(",'").append(idArray[i]).append("'");
        }
        if (ids.length() > 0) {
            ids.setCharAt(0, '(');
            ids.append(")");
        }
        return ids.toString();
    }

    public void init() throws EASBizException, BOSException, SQLException {
        logger.info((Object)("target editmode = " + this.editMode.toString()));
        logger.info((Object)("input range = " + SopPlanAlgorithm.logPeriodRange(this.range)));
        this.curDate = Calendar.getInstance();
        this.curDate.set(10, 0);
        this.curDate.set(12, 0);
        this.curDate.set(13, 0);
        this.curDate.set(14, 0);
        this.curDateNumber = SopPlanAlgorithm.getNumberFromCalendar(this.curDate);
        this.constructP2PMap1();
        this.constructN2PMap();
        this.getWorkDays();
        this.deleteHolidayPlan();
        this.initPreparedStmt();
    }

    private void initPreparedStmt() throws SQLException {
        this.stmtInsertDayPlan = this.conn.prepareStatement(this.getInsertSopDayPlanSql());
        this.stmtDeleteDayPlan = this.conn.prepareStatement(this.getDeleteSopPlanSql(true, this.editMode));
        this.stmtDeletePlan = this.conn.prepareStatement(this.getDeleteSopPlanSql(false, this.editMode));
    }

    public void setConn(Connection conn) throws SQLException {
        this.conn = conn;
        this.initPreparedStmt();
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public static String dateRange2String(ArrayList list) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Calendar date = (Calendar)list.get(i);
            str.append(SopPlanAlgorithm.getNumberFromCalendar(date)).append("; ");
        }
        return str.toString();
    }

    public static String logPeriodRange(ArrayList list) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            SOPPeriod date = (SOPPeriod)list.get(i);
            str.append(SopPlanAlgorithm.logPeriodDate(date));
        }
        return str.toString();
    }

    public static String logPeriodRange(SOPPeriod[] range) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < range.length; ++i) {
            SOPPeriod date = range[i];
            str.append(SopPlanAlgorithm.logPeriodDate(date));
        }
        return str.toString();
    }

    public static String bigDecimalArrayToString(BigDecimal[] data) {
        StringBuffer str = new StringBuffer();
        str.append("(");
        for (int i = 0; i < data.length; ++i) {
            str.append(data[i].toString()).append(",");
        }
        str.append(")");
        return str.toString();
    }

    public static String logPeriodDate(SOPPeriod period) {
        if (period == null) {
            return "(null);";
        }
        return period.toString() + "(" + SopPlanAlgorithm.getNumberFromCalendar(period.getBeginDate()) + "," + SopPlanAlgorithm.getNumberFromCalendar(period.getEndDate()) + "); ";
    }

    private String getResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)sKey);
    }

    class MaterialPeriodPlan {
        int periodNumber;
        BigDecimal targetInv;

        public MaterialPeriodPlan(int periodNumber, BigDecimal targetInv) {
            this.periodNumber = periodNumber;
            this.targetInv = targetInv;
        }

        public BigDecimal getTargetInv() {
            return this.targetInv;
        }

        public void setTargetInv(BigDecimal targetInv) {
            this.targetInv = targetInv;
        }

        public int getPeriodNumber() {
            return this.periodNumber;
        }

        public void setPeriodNumber(int periodNumber) {
            this.periodNumber = periodNumber;
        }
    }
}

