/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.batchPolicy;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicy;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicyResult;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicyVO;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import java.math.BigDecimal;

public class DirectBatchPolicy
implements BatchPolicy {
    private static BigDecimal zero = new BigDecimal("0.00");
    private MRPCalcParam runParam;

    public MRPCalcParam getRunParam() {
        return this.runParam;
    }

    public void setRunParam(MRPCalcParam runParam) {
        this.runParam = runParam;
    }

    @Override
    public void initRunParam(MRPCalcParam runParam) {
        this.setRunParam(runParam);
    }

    @Override
    public BatchPolicyResult[] batchComputing(BatchPolicyVO batchPolocyVO) throws EASBizException {
        int partition;
        BigDecimal batchIncQty;
        BigDecimal zero = new BigDecimal("0");
        if (batchPolocyVO.getNetRequirementQty() == null || batchPolocyVO.getNetRequirementQty().compareTo(zero) >= 0) {
            return null;
        }
        BatchPolicyResult[] results = null;
        BigDecimal reqQty = batchPolocyVO.getNetRequirementQty().abs();
        BigDecimal yieldRate = batchPolocyVO.getYield();
        if (yieldRate == null) {
            yieldRate = new BigDecimal("100.00");
        }
        if ((yieldRate = yieldRate.divide(new BigDecimal("100.00"), 4, 2)).compareTo(MRPConstant.ZERO) > 0 && batchPolocyVO.getMaterialAttriBute() == 10030 || batchPolocyVO.getMaterialAttriBute() == 10050) {
            reqQty = reqQty.divide(yieldRate, batchPolocyVO.getQtyPrc(), 2);
        }
        if ((batchIncQty = batchPolocyVO.getBatchIncQty()) == null) {
            batchIncQty = zero;
        }
        BigDecimal roundUpMultiple = batchPolocyVO.getRoundUpMultipleQty();
        reqQty = reqQty.add(batchIncQty);
        if (roundUpMultiple != null && roundUpMultiple.compareTo(zero) != 0) {
            reqQty = reqQty.divide(roundUpMultiple, 0, 0).multiply(roundUpMultiple).setScale(batchPolocyVO.getQtyPrc(), 0);
        }
        results = (partition = batchPolocyVO.getPartitionQty()) == 0 ? this.calNoSplitSetting(batchPolocyVO, reqQty) : this.calSplitSetting(batchPolocyVO, reqQty);
        return results;
    }

    private BatchPolicyResult[] calNoSplitSetting(BatchPolicyVO batchPolocyVO, BigDecimal reqQty) throws EASBizException {
        BigDecimal maxBatchQty = batchPolocyVO.getMaxBatchQty();
        BigDecimal minBatchQty = batchPolocyVO.getMinBatchQty();
        BigDecimal zero = new BigDecimal("0");
        if (maxBatchQty == null || maxBatchQty.compareTo(zero) == 0) {
            maxBatchQty = new BigDecimal(Integer.MAX_VALUE);
        }
        if (minBatchQty == null || minBatchQty.compareTo(zero) == 0) {
            minBatchQty = zero;
        }
        BatchPolicyResult[] results = null;
        int peroid = batchPolocyVO.getCurrentPeriod();
        if (reqQty.compareTo(minBatchQty) <= 0) {
            results = new BatchPolicyResult[]{new BatchPolicyResult()};
            results[0].setPeriod(peroid);
            if (this.runParam.getPlanType() != MrpRunEnum.MPS_GROSS) {
                results[0].setQty(minBatchQty);
            } else {
                results[0].setQty(reqQty);
            }
            results[0].setOrderLine(batchPolocyVO.getOrderLine());
        } else if (reqQty.compareTo(maxBatchQty) >= 0) {
            if (maxBatchQty == null || maxBatchQty.compareTo(zero) == 0) {
                maxBatchQty = reqQty;
            }
            int num = reqQty.divide(maxBatchQty, 0, 0).intValue();
            this.throwMaxBatchException(num, batchPolocyVO);
            results = new BatchPolicyResult[num];
            for (int i = 0; i < num; ++i) {
                results[i] = new BatchPolicyResult();
                results[i].setPeriod(peroid);
                results[i].setOrderLine(batchPolocyVO.getOrderLine());
                if (num == i + 1) {
                    results[i].setQty(reqQty.subtract(maxBatchQty.multiply(new BigDecimal(i))));
                    continue;
                }
                results[i].setQty(maxBatchQty);
            }
        } else {
            results = new BatchPolicyResult[]{new BatchPolicyResult()};
            results[0].setPeriod(peroid);
            results[0].setQty(reqQty);
            results[0].setOrderLine(batchPolocyVO.getOrderLine());
        }
        return results;
    }

    private BatchPolicyResult[] calSplitSetting(BatchPolicyVO batchPolocyVO, BigDecimal reqQty) throws EASBizException {
        BigDecimal minBatchQty = batchPolocyVO.getMinBatchQty();
        if (minBatchQty == null || minBatchQty.compareTo(zero) == 0) {
            minBatchQty = reqQty;
        }
        if (this.runParam.getPlanType() == MrpRunEnum.MPS_GROSS) {
            minBatchQty = reqQty;
        }
        int num = reqQty.divide(minBatchQty, 0, 0).intValue();
        this.throwMaxBatchException(num, batchPolocyVO);
        BatchPolicyResult[] results = null;
        results = new BatchPolicyResult[num];
        int peroid = batchPolocyVO.getCurrentPeriod();
        int peroidOffset = 0;
        boolean isLastDay = false;
        for (int i = 0; i < num; ++i) {
            results[i] = new BatchPolicyResult();
            results[i].setPeriod(peroid);
            results[i].setPeriodOffset(peroidOffset);
            results[i].setOrderLine(batchPolocyVO.getOrderLine());
            if (i != 0) {
                results[i].setException(63);
            }
            if (batchPolocyVO.getPartitionQty() > 0) {
                isLastDay = num == i + 1 && i != 0;
            } else {
                boolean bl = isLastDay = i == 0 && reqQty.compareTo(minBatchQty) > 0;
            }
            if (isLastDay) {
                results[i].setQty(reqQty.subtract(minBatchQty.multiply(new BigDecimal(num - 1))));
            } else {
                results[i].setQty(minBatchQty);
            }
            peroid += batchPolocyVO.getPartitionQty();
            peroidOffset += batchPolocyVO.getPartitionQty();
        }
        return results;
    }

    private void throwMaxBatchException(int num, BatchPolicyVO batchPolocyVO) throws EASBizException {
        if (num > 100) {
            throw new MRPException(MRPException.BATCH_OUT, new Object[]{batchPolocyVO.getMaterialNumber()});
        }
    }
}

