/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.batchPolicy;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicyResult;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicyVO;
import com.kingdee.eas.mm.planning.app.batchPolicy.PeriodBatchPolicy;
import java.math.BigDecimal;

public class FixedPeriodicbatchPolicy
extends PeriodBatchPolicy {
    private int calSatrtPeroid = -1;
    private int currentPeroid = -1;
    private int cycle = -1;

    @Override
    public BatchPolicyResult[] batchComputing(BatchPolicyVO batchPolocyVO) throws EASBizException {
        int peroidOffset;
        this.setCaculated(false);
        if (batchPolocyVO.getCurrentPeriod() > 0) {
            this.currentPeroid = batchPolocyVO.getCurrentPeriod();
        }
        this.setEndDay(batchPolocyVO.isEndDay());
        BatchPolicyResult[] results = null;
        if (this.calSatrtPeroid == -1) {
            this.calSatrtPeroid = batchPolocyVO.getStartPeroid();
        }
        if (this.cycle == -1) {
            this.cycle = batchPolocyVO.getCycle();
        }
        if (batchPolocyVO.getOrderLine() != null) {
            this.setOrderLine(batchPolocyVO.getOrderLine());
        } else {
            batchPolocyVO.setOrderLine(this.getOrderLine());
        }
        this.setNetRequirementQty(batchPolocyVO.getNetRequirementQty());
        if (this.getLastNetRequirementQty() == null) {
            this.setLastNetRequirementQty(this.getNetRequirementQty());
        }
        if (this.isEndDay()) {
            return this.calBatchQty(batchPolocyVO, this.getLastNetRequirementQty());
        }
        if (batchPolocyVO.getCurrentPeriod() < this.calSatrtPeroid) {
            this.setStartPeroid(this.currentPeroid);
            return this.calBatchQty(batchPolocyVO, this.getNetRequirementQty());
        }
        if (this.getStartPeroid() < this.calSatrtPeroid) {
            this.setStartPeroid(false);
        }
        if ((peroidOffset = this.currentPeroid - this.calSatrtPeroid) + 1 > this.cycle) {
            this.setLastNetRequirementQty(this.getNetRequirementQty());
            int temp = (this.currentPeroid - this.calSatrtPeroid + 1) % this.cycle;
            if (temp == 0) {
                this.setStartPeroid(false);
                BatchPolicyResult[] currPolicyResults = this.calBatchQty(batchPolocyVO, this.getLastNetRequirementQty());
                results = currPolicyResults;
            } else {
                this.setStartPeroid(false);
            }
        } else if (peroidOffset + 1 == this.cycle) {
            results = this.calBatchQty(batchPolocyVO, this.getNetRequirementQty());
        } else {
            this.setLastNetRequirementQty(this.getNetRequirementQty());
        }
        return results;
    }

    public int setStartPeroid(boolean afterCreateOrder) {
        int temp = (this.currentPeroid - this.calSatrtPeroid + 1) % this.cycle;
        if (temp == 0 && !afterCreateOrder) {
            this.setStartPeroid(this.currentPeroid - temp + 1 - this.cycle);
        } else {
            this.setStartPeroid(this.currentPeroid - temp + 1);
        }
        return temp;
    }

    @Override
    protected void reset() {
        this.setEndDay(false);
        if (this.currentPeroid < this.calSatrtPeroid) {
            this.setNetRequirementQty(null);
            return;
        }
        int peroidOff = this.currentPeroid - this.getStartPeroid() + 1;
        int temp = peroidOff % this.cycle;
        if (temp == 0 && peroidOff == this.cycle) {
            this.setLastNetRequirementQty(this.ZERO);
        } else if (this.getLastNetRequirementQty() != null) {
            if (this.getNetRequirementQty().compareTo(this.ZERO) == 0) {
                this.setLastNetRequirementQty(this.ZERO);
            } else if (this.getNetRequirementQty().compareTo(this.ZERO) > 0) {
                this.setLastNetRequirementQty(this.getNetRequirementQty());
            } else if (this.getNetRequirementQty().compareTo(this.ZERO) < 0) {
                this.setLastNetRequirementQty(this.getNetRequirementQty().subtract(this.getLastNetRequirementQty()));
            } else {
                this.setLastNetRequirementQty(this.getNetRequirementQty());
            }
        } else {
            this.setLastNetRequirementQty(this.getNetRequirementQty());
        }
        this.setStartPeroid(true);
        this.setNetRequirementQty(null);
    }

    @Override
    protected boolean updateCounter(BatchPolicyVO batchPolocyVO) {
        boolean isUpdate = this.isNeedUpdateCounter();
        if (isUpdate) {
            ++this.counter;
            return true;
        }
        return false;
    }

    public BatchPolicyResult[] createPO4LastCycle(BatchPolicyVO batchPolocyVO) throws EASBizException {
        BatchPolicyResult[] results = null;
        if (this.calSatrtPeroid == -1 || this.getStartPeroid() == -1 || this.isCaculated()) {
            return results;
        }
        if (batchPolocyVO.getCurrentPeriod() - this.getStartPeroid() + 1 > this.cycle) {
            this.currentPeroid = batchPolocyVO.getCurrentPeriod();
            batchPolocyVO.setOrderLine(this.getOrderLine());
            this.setNetRequirementQty(batchPolocyVO.getNetRequirementQty());
            BigDecimal reqQty = this.getLastNetRequirementQty();
            reqQty = reqQty.add(this.ZERO);
            results = this.calBatchQty(batchPolocyVO, reqQty);
            if (results != null && results.length > 0) {
                BigDecimal qty = this.ZERO;
                for (int i = 0; i < results.length; ++i) {
                    qty = qty.add(results[i].getQty());
                }
                BigDecimal yield = batchPolocyVO.getYield();
                if (yield != null) {
                    yield = yield.divide(new BigDecimal(100), 4, 2);
                    qty = qty.multiply(yield).setScale(batchPolocyVO.getQtyPrc(), 3);
                }
                qty = qty.add(reqQty);
                this.setLastNetRequirementQty(this.getLastNetRequirementQty().add(qty));
            }
        }
        return results;
    }
}

