/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.batchPolicy;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicy;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicyResult;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicyVO;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import java.math.BigDecimal;

public class FixedbatchPolicy
implements BatchPolicy {
    private int startPeroid = -1;
    private MRPCalcParam runParam;

    public MRPCalcParam getRunParam() {
        return this.runParam;
    }

    public void setRunParam(MRPCalcParam runParam) {
        this.runParam = runParam;
    }

    protected FixedbatchPolicy() {
    }

    @Override
    public void initRunParam(MRPCalcParam runParam) {
        this.setRunParam(runParam);
    }

    @Override
    public BatchPolicyResult[] batchComputing(BatchPolicyVO batchPolocyVO) throws EASBizException {
        BigDecimal batchNum;
        BigDecimal batchQty;
        BigDecimal batchIncQty;
        BigDecimal zero = new BigDecimal("0");
        if (batchPolocyVO.getNetRequirementQty() == null || batchPolocyVO.getNetRequirementQty().compareTo(zero) >= 0) {
            return null;
        }
        this.startPeroid = batchPolocyVO.getCurrentPeriod();
        BigDecimal reqQty = batchPolocyVO.getNetRequirementQty().abs();
        BigDecimal yieldRate = batchPolocyVO.getYield();
        if (yieldRate == null) {
            yieldRate = new BigDecimal("100.00");
        }
        if ((yieldRate = yieldRate.divide(new BigDecimal(100), 4, 2)).compareTo(MRPConstant.ZERO) > 0 && batchPolocyVO.getMaterialAttriBute() == 10030) {
            reqQty = reqQty.divide(yieldRate, batchPolocyVO.getQtyPrc(), 2);
        }
        if ((batchIncQty = batchPolocyVO.getBatchIncQty()) == null) {
            batchIncQty = zero;
        }
        if ((batchQty = batchPolocyVO.getFixationBatchQty()) == null || batchQty.compareTo(zero) == 0) {
            batchIncQty = zero;
            batchQty = reqQty;
        }
        reqQty = reqQty.add(batchIncQty).divide(batchQty, 0, 0).multiply(batchQty).setScale(batchPolocyVO.getQtyPrc(), 0);
        BigDecimal roundUp = batchPolocyVO.getRoundUpMultipleQty();
        if (roundUp == null || roundUp.compareTo(zero) == 0) {
            roundUp = batchQty;
        }
        if ((batchNum = reqQty.divide(roundUp, 0, 0)).intValue() > 100) {
            throw new MRPException(MRPException.BATCH_OUT, new Object[]{batchPolocyVO.getMaterialNumber()});
        }
        int partition = batchPolocyVO.getPartitionQty();
        BatchPolicyResult[] result = new BatchPolicyResult[batchNum.intValue()];
        int peroid = this.startPeroid;
        int peroidOffset = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = new BatchPolicyResult();
            result[i].setQty(roundUp);
            result[i].setPeriod(peroid);
            result[i].setPeriodOffset(peroidOffset);
            if (partition != 0 && i != 0) {
                result[i].setException(63);
            }
            peroid += partition;
            peroidOffset += partition;
        }
        return result;
    }
}

