/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.AdjustStrategyEnum;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ExpandInfo;
import com.kingdee.eas.mm.basedata.ExpandInfoCollection;
import com.kingdee.eas.mm.basedata.IBOMExtend2Facade;
import com.kingdee.eas.mm.basedata.MaterialRangeEnum;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPClassifyEnum;
import com.kingdee.eas.mm.planning.MRPElementEnum;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MRPRunMaterialEntryCollection;
import com.kingdee.eas.mm.planning.MRPRunMaterialEntryInfo;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicy;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicyFactory;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicyResult;
import com.kingdee.eas.mm.planning.app.batchPolicy.BatchPolicyVO;
import com.kingdee.eas.mm.planning.app.batchPolicy.FixedPeriodicbatchPolicy;
import com.kingdee.eas.mm.planning.app.batchPolicy.PeriodBatchPolicy;
import com.kingdee.eas.mm.planning.app.mrp.MRPAjustResult;
import com.kingdee.eas.mm.planning.app.mrp.MRPBillParamInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.eas.mm.planning.app.mrp.MRPDate;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPFetchDetailDataUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPFetchMaterialDataUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPHierarchyCodeGenerator;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialDataInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialStatisticsInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialTableDAO;
import com.kingdee.eas.mm.planning.app.mrp.MRPNetReqSaver;
import com.kingdee.eas.mm.planning.app.mrp.MRPPlanStrategyUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPProgressUpdater;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPSeqUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MRPAjustMent
extends MRPStep
implements Callable {
    protected List materialIDLst;
    protected MRPNetReqSaver dataSaver;
    protected int materialCount = 0;
    protected int detailLineCount = 0;
    protected MRPFetchMaterialDataUtil materiaDataUtil;
    protected MRPFetchDetailDataUtil detailDataUtil = new MRPFetchDetailDataUtil();
    IBOMExtend2Facade findBOMFacade = null;
    protected List adetail = null;
    protected HashMap preQty = new HashMap();
    protected boolean hasException = false;
    protected int delay_seq = 0;
    protected int advace_seq = 0;
    protected String key = null;
    protected Set materialException = new HashSet();
    protected Set underSafeStockIds = new HashSet();
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPAjustMent");
    protected MRPMaterialDataInfo materialDataInfo4Stock = null;
    protected MRPAjustResult result = new MRPAjustResult();

    public MRPAjustMent(List materialIDLst, MRPCalcParam runParam) throws MRPException, BOSException {
        if (isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
        this.materialIDLst = materialIDLst;
        this.runParam = runParam;
        this.dataSaver = new MRPNetReqSaver(runParam);
        this.materiaDataUtil = new MRPFetchMaterialDataUtil(runParam);
        this.materiaDataUtil.setPreQty(this.preQty);
        this.materiaDataUtil.setDataSaver(this.dataSaver);
    }

    @Override
    protected String getStepDesc() throws MRPException, BOSException {
        return this.getStepDesc(this.runParam) + "," + MRPResource.getString(this.runParam.getCtx(), "SYM_MATERIAL") + MRPResource.getString(this.runParam.getCtx(), "SYM_NUMBER") + ":" + String.valueOf(this.materialCount) + ": detail line count : " + String.valueOf(this.dataAmount);
    }

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        return MRPResource.getString(runParam.getCtx(), "SP_CALCMATERIALS");
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        this.findBOMFacade = BOMExtend2FacadeFactory.getLocalInstance((Context)runParam.getCtx());
        this.cycCalc();
        this.result.setDataAmount(this.dataAmount);
        return this.result;
    }

    protected void cycCalc() throws BOSException, EASBizException {
        this.materialCount = this.materialIDLst.size();
        int times = this.materialIDLst.size() / 500;
        if (this.materialIDLst.size() % 500 > 0) {
            ++times;
        }
        List subList = null;
        int[] periods = null;
        MRPMaterialDataInfo materialDataInfo = null;
        HashMap unMaterials = null;
        for (int i = 1; i <= times; ++i) {
            subList = i < times ? this.materialIDLst.subList(500 * (i - 1), 500 * i) : this.materialIDLst.subList(500 * (i - 1), this.materialIDLst.size());
            periods = this.materiaDataUtil.setMaterialIdList(subList);
            unMaterials = (HashMap)this.materiaDataUtil.getMaterials().clone();
            this.detailDataUtil.setMaterialIds(subList, this.materiaDataUtil);
            for (int j = 0; j < periods.length; ++j) {
                int period = periods[j];
                while (this.materiaDataUtil.hasNextMaterial(period)) {
                    materialDataInfo = this.materiaDataUtil.getNextMaterial(period);
                    this.createMaterialDataInfo(materialDataInfo);
                    this.oneDayCalc(materialDataInfo, period);
                }
                this.dataSaver.execute(true);
            }
            this.afterCalcLoopHook();
            this.dataAmount += this.detailDataUtil.getDetailCount();
            this.detailDataUtil.clear();
            HashMap materials = this.materiaDataUtil.getMaterials();
            Iterator itMaterials = materials.entrySet().iterator();
            while (itMaterials.hasNext()) {
                PeriodBatchPolicy periodPolicy;
                materialDataInfo = (MRPMaterialDataInfo)itMaterials.next().getValue();
                if (materialDataInfo.getBatchPolicy() != 4 && materialDataInfo.getBatchPolicy() != 3 || (periodPolicy = (PeriodBatchPolicy)this.getBatchPolicy(materialDataInfo)).isCaculated()) continue;
                logger.debug((Object)"end cycle create planOder. ");
                this.batchCal(materialDataInfo, 0, MRPConstant.ZERO, MRPConstant.ZERO, true, MRPConstant.ZERO, null, true);
            }
            this.dataSaver.execute(true);
            this.delay_seq = 0;
            MRPProgressUpdater.updateMaterialCalcProgress(this.runParam, subList.size());
            this.preQty.clear();
            HashMap map = this.materiaDataUtil.getMaterials();
            for (int j = 0; j < subList.size(); ++j) {
                materialDataInfo = (MRPMaterialDataInfo)map.get(subList.get(j));
                if (materialDataInfo.getIsNewOrder() < 1 && materialDataInfo.getHasExceptions() < 1 && materialDataInfo.getHasStockExp() < 1) continue;
                this.dataSaver.addUpdateMaterialList(materialDataInfo);
            }
            this.createPlanedorderForStock(subList, unMaterials);
        }
        this.materialException.clear();
        this.underSafeStockIds.clear();
        this.dataSaver.executeUpdateMaterial();
        this.detailDataUtil.releaseTemptable(this.runParam);
    }

    protected void afterCalcLoopHook() throws EASBizException, BOSException {
    }

    protected void oneDayCalc(MRPMaterialDataInfo materialDataInfo, int period) throws BOSException, EASBizException {
        MRPMaterialStatisticsInfo materialStatisticsInfo = null;
        ArrayList detailDatas = null;
        BigDecimal pab_t_1 = null;
        BigDecimal dayNet_qty = null;
        BigDecimal onHand = null;
        while (this.materiaDataUtil.hasNextStatisticData(materialDataInfo.getMaterialID(), period)) {
            materialStatisticsInfo = this.materiaDataUtil.getNextStatisticData(materialDataInfo.getMaterialID(), period);
            if (materialStatisticsInfo.getRQty().compareTo(MRPConstant.ZERO) == 0 && materialStatisticsInfo.getSQty().compareTo(MRPConstant.ZERO) == 0) continue;
            detailDatas = (ArrayList)this.detailDataUtil.getOneMaterialDetialData(this.runParam, period, materialDataInfo.getMaterialID(), materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber(), materialStatisticsInfo.getSeq());
            if (detailDatas == null || detailDatas.size() == 0) {
                if (materialStatisticsInfo.getRQty().compareTo(MRPConstant.ZERO) == 0 && materialStatisticsInfo.getSQty().compareTo(MRPConstant.ZERO) == 0) continue;
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"28_MRPAjustMent", (Locale)this.runParam.getCtx().getLocale()));
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"29_MRPAjustMent", (Locale)this.runParam.getCtx().getLocale()) + materialStatisticsInfo.toString()));
                continue;
            }
            this.key = materialDataInfo.getMaterialID() + materialStatisticsInfo.getProjectNumber() + materialStatisticsInfo.getTrackNumber();
            if (this.preQty.get(this.key) == null) {
                BigDecimal firstQty = this.calcStockQty(materialDataInfo, materialStatisticsInfo);
                this.preQty.put(this.key, firstQty);
            }
            if (!materialDataInfo.getPlanStrategy().equals("NUnM+gEcEADgAA3ewKgL09g0uEU=") && (onHand = materialDataInfo.getOnHandQty(materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber())).compareTo(MRPConstant.ZERO) > 0 && materialStatisticsInfo.getRQty().compareTo(MRPConstant.ZERO) < 0) {
                if (onHand.add(materialStatisticsInfo.getRQty()).compareTo(MRPConstant.ZERO) > 0) {
                    materialStatisticsInfo.setOnHand(materialStatisticsInfo.getRQty().abs());
                    materialDataInfo.setOnHandQty(onHand.add(materialStatisticsInfo.getRQty()), materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber());
                } else {
                    materialStatisticsInfo.setOnHand(onHand);
                    materialDataInfo.setOnHandQty(MRPConstant.ZERO, materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber());
                }
                this.dataSaver.addDUpdateList(materialStatisticsInfo);
            }
            BigDecimal preAvailableQty = null;
            preAvailableQty = (BigDecimal)this.preQty.get(this.key);
            if (materialDataInfo.getBatchPolicy() == 3 && period > this.runParam.getPlanDate().getPeriod()) {
                preAvailableQty = this.createPO4LastCycle(materialDataInfo, preAvailableQty, period, this.isMerge(materialDataInfo));
                this.preQty.put(this.key, preAvailableQty);
            }
            if ((pab_t_1 = (dayNet_qty = materialStatisticsInfo.getRQty().add(materialStatisticsInfo.getSQty()).add(materialStatisticsInfo.getOnHand()).add(materialStatisticsInfo.getPreQty())).add(preAvailableQty)).compareTo(MRPConstant.ZERO) < 0) {
                materialDataInfo.setHasExceptions(1);
                this.advance(materialDataInfo, materialStatisticsInfo, detailDatas, period);
                this.adetail = null;
                continue;
            }
            if (pab_t_1.compareTo(MRPConstant.ZERO) > 0) {
                this.delayCancle(materialDataInfo, materialStatisticsInfo, detailDatas, period);
                if (materialDataInfo.getBatchPolicy() != 4 && materialDataInfo.getBatchPolicy() != 3) continue;
                BigDecimal tempPreQty = this.batchCal(materialDataInfo, period, dayNet_qty, materialStatisticsInfo.getRQty(), false, (BigDecimal)this.preQty.get(this.key), (MRPDetailInfo)detailDatas.get(0), this.isMerge(materialDataInfo));
                this.preQty.put(this.key, tempPreQty);
                continue;
            }
            if (pab_t_1.compareTo(MRPConstant.ZERO) != 0) continue;
            if (detailDatas.size() > 0) {
                MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(0);
                this.batchGenExceptions(materialDataInfo, materialStatisticsInfo, detailDatas);
                if (materialDataInfo.getBatchPolicy() == 4 || materialDataInfo.getBatchPolicy() == 3) {
                    this.batchCal(materialDataInfo, period, dayNet_qty, materialStatisticsInfo.getRQty(), false, pab_t_1, detailInfo, this.isMerge(materialDataInfo));
                }
            }
            this.preQty.put(this.key, MRPConstant.ZERO);
        }
    }

    private void beforeBalance(MRPMaterialDataInfo materialDataInfo, int period, MRPMaterialStatisticsInfo materialStatisticsInfo, ArrayList detailDatas) throws BOSException, MRPException, EASBizException {
        MRPDetailInfo rdetailInfo;
        int i;
        ArrayList<MRPDetailInfo> rDetails = new ArrayList<MRPDetailInfo>();
        ArrayList<MRPDetailInfo> sDetails = new ArrayList<MRPDetailInfo>();
        for (i = 0; i < detailDatas.size(); ++i) {
            MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(i);
            if (!(detailInfo.getMrpItem() != MRPElementEnum.R_SID && detailInfo.getMrpItem() != MRPElementEnum.R_PlannedOrder && detailInfo.getMrpItem() != MRPElementEnum.R_ManufauctureOrder && detailInfo.getMrpItem() != MRPElementEnum.R_ProductOrder && detailInfo.getMrpItem() != MRPElementEnum.R_OUTERORDER && detailInfo.getMrpItem() != MRPElementEnum.R_OUTERPURREQORDER || detailInfo.getSaleOrderID() == null && detailInfo.getSaleOrderNumber() == null)) {
                rDetails.add(detailInfo);
            }
            if (detailInfo.getMrpItem() != MRPElementEnum.S_ProductOrder && detailInfo.getMrpItem() != MRPElementEnum.S_ManufactureOrder && detailInfo.getMrpItem() != MRPElementEnum.S_OUTERPURREQUEST && detailInfo.getMrpItem() != MRPElementEnum.S_OUTERORDER && detailInfo.getMrpItem() != MRPElementEnum.S_PurOrder && detailInfo.getMrpItem() != MRPElementEnum.S_PurRequest && detailInfo.getMrpItem() != MRPElementEnum.S_PlannedOrder || detailInfo.getSaleOrderID() == null && detailInfo.getSaleOrderNumber() == null) continue;
            sDetails.add(detailInfo);
        }
        if (rDetails.size() > 0) {
            for (i = rDetails.size() - 1; i >= 0; --i) {
                rdetailInfo = (MRPDetailInfo)rDetails.get(i);
                for (int j = 0; j < sDetails.size(); ++j) {
                    MRPDetailInfo sdetailInfo = (MRPDetailInfo)sDetails.get(j);
                    if (!rdetailInfo.getSaleOrderNumber().equals(sdetailInfo.getSaleOrderNumber()) || rdetailInfo.getSaleOrderEntryNum() != sdetailInfo.getSaleOrderEntryNum()) continue;
                    rdetailInfo.setMatch(true);
                    sdetailInfo.setMatch(true);
                }
            }
        }
        for (i = rDetails.size() - 1; i >= 0; --i) {
            rdetailInfo = (MRPDetailInfo)rDetails.get(i);
            if (!rdetailInfo.isMatch()) continue;
            rDetails.remove(i);
            rdetailInfo.setMatch(false);
        }
        for (i = sDetails.size() - 1; i >= 0; --i) {
            MRPDetailInfo sdetailInfo = (MRPDetailInfo)sDetails.get(i);
            if (!sdetailInfo.isMatch()) continue;
            sDetails.remove(i);
            sdetailInfo.setMatch(false);
        }
        if (rDetails.size() > 0 || sDetails.size() > 0) {
            Object[] result = this.detailDataUtil.getAdvanceDetailsDataForSaleMatch(this.runParam, materialDataInfo.getMaterialID(), materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber(), period);
            if (rDetails.size() > 0) {
                List sDetailsSource = (List)result[1];
                for (int i2 = 0; i2 < rDetails.size(); ++i2) {
                    Iterator advancedDetails = sDetailsSource.iterator();
                    MRPDetailInfo rdetailInfo2 = (MRPDetailInfo)rDetails.get(i2);
                    while (advancedDetails.hasNext()) {
                        MRPDetailInfo sdetailInfo = (MRPDetailInfo)advancedDetails.next();
                        if (!rdetailInfo2.getSaleOrderNumber().equals(sdetailInfo.getSaleOrderNumber()) || rdetailInfo2.getSaleOrderEntryNum() != sdetailInfo.getSaleOrderEntryNum()) continue;
                        MRPMaterialStatisticsInfo srcStatisticsInfo = this.materiaDataUtil.getStatisticsInfo(sdetailInfo);
                        srcStatisticsInfo.setSQty(srcStatisticsInfo.getSQty().subtract(sdetailInfo.getSurplusQty()));
                        this.dataSaver.addAUpdateList(srcStatisticsInfo);
                        this.genExceptions(materialDataInfo, sdetailInfo, sdetailInfo.getSurplusQty());
                        materialStatisticsInfo.setSQty(materialStatisticsInfo.getSQty().add(sdetailInfo.getSurplusQty()));
                        sdetailInfo.setSID(sdetailInfo.getID());
                        sdetailInfo.setAjustFlag(2);
                        sdetailInfo.setSperiod(sdetailInfo.getPeriod());
                        sdetailInfo.setPeriod(rdetailInfo2.getPeriod());
                        sdetailInfo.setRePlanDATE(rdetailInfo2.getBillDate());
                        if (sdetailInfo.getAjustFlag() == 2 && this.runParam.getExceptionUtil().setException(sdetailInfo, 60)) {
                            this.statisticException(sdetailInfo);
                        }
                        this.detailDataUtil.clearDetailInMemory(sdetailInfo);
                        advancedDetails.remove();
                        ArrayList<MRPDetailInfo> updateDatas = new ArrayList<MRPDetailInfo>();
                        updateDatas.add(sdetailInfo);
                        this.dataSaver.executeUpdate(updateDatas);
                        this.dataSaver.execute(true);
                        detailDatas.add(0, sdetailInfo);
                    }
                }
            }
            if (sDetails.size() > 0) {
                int ajut_period = 0;
                List rDetailsDest = (List)result[0];
                for (int i3 = 0; i3 < rDetailsDest.size(); ++i3) {
                    Iterator delayDetails = sDetails.iterator();
                    MRPDetailInfo rdetailInfo3 = (MRPDetailInfo)rDetailsDest.get(i3);
                    MRPMaterialStatisticsInfo destStatisticsInfo = null;
                    if (ajut_period != rdetailInfo3.getPeriod() || ajut_period == 0) {
                        destStatisticsInfo = this.materiaDataUtil.getStatisticsInfo(rdetailInfo3);
                        ajut_period = rdetailInfo3.getPeriod();
                    }
                    while (delayDetails.hasNext()) {
                        MRPDetailInfo sdetailInfo = (MRPDetailInfo)delayDetails.next();
                        if (!rdetailInfo3.getSaleOrderNumber().equals(sdetailInfo.getSaleOrderNumber()) || rdetailInfo3.getSaleOrderEntryNum() != sdetailInfo.getSaleOrderEntryNum()) continue;
                        sdetailInfo.setSID(sdetailInfo.getID());
                        sdetailInfo.setAjustFlag(3);
                        sdetailInfo.setSperiod(sdetailInfo.getPeriod());
                        sdetailInfo.setPeriod(rdetailInfo3.getPeriod());
                        sdetailInfo.setRePlanDATE(rdetailInfo3.getBillDate());
                        if (sdetailInfo.getAjustFlag() == 3 && this.runParam.getExceptionUtil().setException(sdetailInfo, 61)) {
                            this.statisticException(materialDataInfo);
                        }
                        sdetailInfo.setMatch(true);
                        delayDetails.remove();
                        ArrayList<MRPDetailInfo> updateDatas = new ArrayList<MRPDetailInfo>();
                        updateDatas.add(sdetailInfo);
                        this.dataSaver.executeUpdate(updateDatas);
                        BigDecimal surplusQty = sdetailInfo.getScheduledReceiptQty().subtract(sdetailInfo.getAjustQty());
                        destStatisticsInfo.setSQty(destStatisticsInfo.getSQty().add(surplusQty));
                        this.dataSaver.addAUpdateList(destStatisticsInfo);
                        this.dataSaver.execute(true);
                        this.genExceptions(materialDataInfo, sdetailInfo, sdetailInfo.getSurplusQty());
                        materialStatisticsInfo.setSQty(materialStatisticsInfo.getSQty().subtract(surplusQty));
                    }
                }
            }
            for (int i4 = detailDatas.size() - 1; i4 >= 0; --i4) {
                MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(i4);
                if (!detailInfo.isMatch()) continue;
                detailDatas.remove(i4);
            }
        }
    }

    private BigDecimal calcStockQty(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo materialStatisticsInfo) throws EASBizException, BOSException {
        BigDecimal firstQty = MRPConstant.ZERO;
        if (materialDataInfo.getPlanStrategy().equalsIgnoreCase("NUnM+gEcEADgAA3ewKgL09g0uEU=")) {
            this.setSafeStock(materialDataInfo, materialStatisticsInfo, MRPConstant.ZERO);
        } else {
            BigDecimal onHandQty = materialDataInfo.getOnHandQty(materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber());
            if (onHandQty.compareTo(MRPConstant.ZERO) < 0) {
                if (!this.isDefaultProjectAndTrackNumber(materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber())) {
                    firstQty = !(materialDataInfo.getPlanStrategy().equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") || materialDataInfo.getPlanStrategy().equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=") || materialDataInfo.getPlanStrategy().equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=")) ? MRPConstant.ZERO : onHandQty;
                } else {
                    firstQty = onHandQty;
                    materialDataInfo.setOnHandQty(MRPConstant.ZERO, materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber());
                }
            }
            this.setException4Stock(this.materialDataInfo4Stock, materialStatisticsInfo);
        }
        return firstQty;
    }

    protected boolean isMerge(MRPMaterialDataInfo materialDataInfo) {
        if (this.runParam.isCooperatePlan()) {
            return materialDataInfo.isMergeSign();
        }
        return materialDataInfo.isMergeSign() || this.runParam.getPlanVersion().getRequirementUniteRule() != null;
    }

    protected void setSafeStock(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo materialStatisticsInfo, BigDecimal safeStockQty) {
        if (MRPPlanStrategyUtil.isInvPlanStrategy(materialDataInfo.getPlanStrategy())) {
            if (this.runParam.getProjectNumber().equals(materialStatisticsInfo.getProjectNumber()) && this.runParam.getTrackNumber().equals(materialStatisticsInfo.getTrackNumber())) {
                materialDataInfo.setSafeStockQty(safeStockQty);
            }
        } else {
            materialDataInfo.setSafeStockQty(safeStockQty);
        }
    }

    protected void delayCancle(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, ArrayList detailDatas, int period) throws BOSException, EASBizException {
        MRPDetailInfo detailInfo = null;
        BigDecimal delayQty = null;
        BigDecimal totaldelayQty = new BigDecimal("0.0");
        BigDecimal surplusQty = null;
        List delayStatisticsInfos = null;
        delayStatisticsInfos = this.materiaDataUtil.getDeLayPerid(this.runParam, statisticsInfo.getMaterialID(), statisticsInfo.getProjectNumber(), statisticsInfo.getTrackNumber(), period, 0);
        BigDecimal rQty = statisticsInfo.getRQty().add(statisticsInfo.getOnHand()).add((BigDecimal)this.preQty.get(this.key)).add(statisticsInfo.getPreQty());
        BigDecimal sQty = ((BigDecimal)this.preQty.get(this.key)).add(statisticsInfo.getPreQty());
        for (int i = 0; i < detailDatas.size(); ++i) {
            detailInfo = (MRPDetailInfo)detailDatas.get(i);
            surplusQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
            sQty = sQty.add(surplusQty);
            if (detailInfo.getMrpItem().equals((Object)MRPElementEnum.S_SUBSTITUTE) || detailInfo.getSID() != null || detailInfo.isNewOrder()) {
                rQty = rQty.add(surplusQty);
                continue;
            }
            if (MRPClassifyEnum.Requirement.equals((Object)detailInfo.getMrpClassify()) || MRPClassifyEnum.Inventory.equals((Object)detailInfo.getMrpClassify())) {
                sQty = sQty.add(detailInfo.getIndependentQty()).add(detailInfo.getDependentQty());
                continue;
            }
            if ((rQty = rQty.add(surplusQty)).compareTo(MRPConstant.ZERO) > 0) {
                delayQty = rQty.compareTo(surplusQty) < 0 ? rQty : surplusQty;
                delayQty = this.afterDelayCancle(materialDataInfo, delayStatisticsInfos, detailInfo, delayQty);
                totaldelayQty = totaldelayQty.add(delayQty);
                sQty = sQty.subtract(delayQty);
                this.genExceptions(materialDataInfo, detailInfo, sQty);
                continue;
            }
            if (detailInfo.getAjustFlag() > 0) {
                this.genExceptions(materialDataInfo, detailInfo, sQty);
                continue;
            }
            this.genExceptions(materialDataInfo, detailInfo, MRPConstant.ZERO);
        }
        BigDecimal pab = statisticsInfo.getSQty().subtract(totaldelayQty).add(statisticsInfo.getOnHand()).add((BigDecimal)this.preQty.get(this.key)).add(statisticsInfo.getRQty()).add(statisticsInfo.getPreQty());
        this.preQty.put(this.key, pab);
    }

    protected void advance(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, ArrayList detailDatas, int period) throws BOSException, EASBizException {
        MRPDetailInfo detailInfo = (MRPDetailInfo)detailDatas.get(0);
        int index = 0;
        BigDecimal pab_t_1 = statisticsInfo.getRQty().add(statisticsInfo.getSQty()).add(statisticsInfo.getOnHand()).add(statisticsInfo.getPreQty());
        if (this.preQty.get(this.key) != null) {
            pab_t_1 = pab_t_1.add((BigDecimal)this.preQty.get(this.key));
        }
        index = this.batchGenExceptions(materialDataInfo, statisticsInfo, detailDatas);
        int size = detailDatas.size();
        if (size <= 0) {
            materialDataInfo.setOnHandQty(pab_t_1, statisticsInfo.getProjectNumber(), statisticsInfo.getTrackNumber());
            this.preQty.put(this.key, MRPConstant.ZERO);
            this.advanceForStock(materialDataInfo, statisticsInfo, detailInfo, period);
            materialDataInfo.setOnHandQty(MRPConstant.ZERO, statisticsInfo.getProjectNumber(), statisticsInfo.getTrackNumber());
        } else if (materialDataInfo.getBatchPolicy() == 1 || materialDataInfo.getBatchPolicy() == 2) {
            if (this.isMerge(materialDataInfo)) {
                pab_t_1 = pab_t_1.subtract(statisticsInfo.getRQty());
                while (detailDatas.size() > 0) {
                    detailInfo = this.getNextMergeRequire(materialDataInfo.getPlanStrategy(), detailDatas, materialDataInfo.getIsolatedRule());
                    pab_t_1 = pab_t_1.add(detailInfo.getNetReqQty());
                    this.doAdvance(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period, true);
                    pab_t_1 = detailInfo.getNetReqQty();
                    if (this.isHasNetReq(pab_t_1)) {
                        pab_t_1 = this.batchCal(materialDataInfo, period, statisticsInfo.getRQty().add(statisticsInfo.getSQty()), statisticsInfo.getRQty(), false, pab_t_1, detailInfo, true);
                    }
                    this.preQty.put(this.key, pab_t_1);
                }
            } else {
                pab_t_1 = statisticsInfo.getSQty().add(statisticsInfo.getOnHand()).add(statisticsInfo.getPreQty());
                if (this.preQty.get(this.key) != null) {
                    pab_t_1 = pab_t_1.add((BigDecimal)this.preQty.get(this.key));
                }
                for (int i = index; i < size; ++i) {
                    detailInfo = (MRPDetailInfo)detailDatas.get(i);
                    pab_t_1 = pab_t_1.add(detailInfo.getIndependentQty().add(detailInfo.getDependentQty()));
                    detailInfo.setNetReqQty(pab_t_1);
                    if (pab_t_1.compareTo(MRPConstant.ZERO) >= 0) continue;
                    if (this.runParam.getSubFisrt() == 1) {
                        this.doAdvance(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period, true);
                        pab_t_1 = detailInfo.getNetReqQty();
                        if (this.isHasNetReq(pab_t_1) && detailInfo.getMrpItem().equals((Object)MRPElementEnum.R_PlannedOrder)) {
                            this.doSubstitute(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period);
                            pab_t_1 = detailInfo.getNetReqQty();
                        }
                    } else {
                        if (detailInfo.getMrpItem().equals((Object)MRPElementEnum.R_PlannedOrder)) {
                            this.doSubstitute(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period);
                            pab_t_1 = detailInfo.getNetReqQty();
                        }
                        if (this.isHasNetReq(pab_t_1)) {
                            this.doAdvance(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period, true);
                            pab_t_1 = detailInfo.getNetReqQty();
                        }
                    }
                    if (!this.isHasNetReq(pab_t_1)) continue;
                    pab_t_1 = this.batchCal(materialDataInfo, period, statisticsInfo.getRQty().add(statisticsInfo.getSQty()), statisticsInfo.getRQty(), false, pab_t_1, detailInfo, false);
                }
                this.preQty.put(this.key, pab_t_1);
            }
        } else {
            pab_t_1 = statisticsInfo.getSQty().add(statisticsInfo.getOnHand()).add(statisticsInfo.getPreQty());
            if (this.preQty.get(this.key) != null) {
                pab_t_1 = pab_t_1.add((BigDecimal)this.preQty.get(this.key));
            }
            for (int i = index; i < size; ++i) {
                detailInfo = (MRPDetailInfo)detailDatas.get(i);
                pab_t_1 = pab_t_1.add(detailInfo.getIndependentQty().add(detailInfo.getDependentQty()));
                detailInfo.setNetReqQty(pab_t_1);
                if (pab_t_1.compareTo(MRPConstant.ZERO) >= 0) continue;
                if (this.runParam.getSubFisrt() == 1) {
                    this.doAdvance(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period, true);
                    pab_t_1 = detailInfo.getNetReqQty();
                    if (!this.isHasNetReq(pab_t_1) || this.isMerge(materialDataInfo) || !detailInfo.getMrpItem().equals((Object)MRPElementEnum.R_PlannedOrder)) continue;
                    this.doSubstitute(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period);
                    pab_t_1 = detailInfo.getNetReqQty();
                    continue;
                }
                if (detailInfo.getMrpItem().equals((Object)MRPElementEnum.R_PlannedOrder) && !this.isMerge(materialDataInfo)) {
                    this.doSubstitute(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period);
                    pab_t_1 = detailInfo.getNetReqQty();
                }
                if (!this.isHasNetReq(pab_t_1)) continue;
                this.doAdvance(materialDataInfo, statisticsInfo, detailInfo, pab_t_1, period, true);
                pab_t_1 = detailInfo.getNetReqQty();
            }
            if (this.isHasNetReq(pab_t_1)) {
                pab_t_1 = this.batchCal(materialDataInfo, period, statisticsInfo.getRQty().add(statisticsInfo.getSQty()), statisticsInfo.getRQty(), false, pab_t_1, detailInfo, true);
            }
            this.preQty.put(this.key, pab_t_1);
        }
    }

    protected boolean doAdvance(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, MRPDetailInfo detailInfo, BigDecimal pab_t_1, int period, boolean isMergeSign) throws BOSException, EASBizException {
        if (!this.isNeedAjust(period)) {
            detailInfo.setNetReqQty(pab_t_1);
            return false;
        }
        int size = 0;
        MRPDetailInfo detailInfoTmp = null;
        AdjustStrategyEnum strategyEnum = null;
        if (this.adetail == null) {
            this.adetail = this.detailDataUtil.getAdvanceDetailsData(this.runParam, materialDataInfo.getMaterialID(), statisticsInfo.getProjectNumber(), statisticsInfo.getTrackNumber(), period);
        }
        detailInfo.setNetReqQty(pab_t_1);
        if (this.adetail.size() == 0) {
            detailInfo.setNetReqQty(pab_t_1);
            return false;
        }
        size = this.adetail.size();
        BigDecimal aQty = null;
        int ajut_period = 0;
        boolean i = false;
        MRPMaterialStatisticsInfo materialStatisticsInfo = null;
        Iterator advancedDetails = this.adetail.iterator();
        while (advancedDetails.hasNext()) {
            detailInfoTmp = (MRPDetailInfo)advancedDetails.next();
            if (ajut_period != detailInfoTmp.getPeriod() || ajut_period == 0) {
                materialStatisticsInfo = this.materiaDataUtil.getStatisticsInfo(detailInfoTmp);
                ajut_period = detailInfoTmp.getPeriod();
            }
            if ((strategyEnum = this.runParam.getAdjustStrategy(detailInfoTmp.getBillType())) == null || (aQty = this.calcAjustQty(materialDataInfo, detailInfo, detailInfoTmp, pab_t_1, strategyEnum)) == null) continue;
            materialStatisticsInfo.setSQty(materialStatisticsInfo.getSQty().subtract(aQty));
            if (pab_t_1.add(aQty).compareTo(MRPConstant.ZERO) < 0) {
                this.afterAjust(materialStatisticsInfo, detailInfo, detailInfoTmp, aQty);
                pab_t_1 = pab_t_1.add(aQty);
                if (detailInfoTmp.getSurplusQty().compareTo(MRPConstant.ZERO) <= 0) {
                    advancedDetails.remove();
                }
                this.genExceptions(materialDataInfo, detailInfoTmp, pab_t_1);
                continue;
            }
            pab_t_1 = pab_t_1.add(aQty);
            detailInfo.setNetReqQty(pab_t_1);
            this.afterAjust(materialStatisticsInfo, detailInfo, detailInfoTmp, aQty);
            this.dataSaver.addAUpdateList(materialStatisticsInfo);
            if (detailInfoTmp.getSurplusQty().compareTo(MRPConstant.ZERO) <= 0) {
                advancedDetails.remove();
            }
            this.genExceptions(materialDataInfo, detailInfoTmp, pab_t_1);
            return true;
        }
        detailInfo.setNetReqQty(pab_t_1);
        this.dataSaver.addAUpdateList(materialStatisticsInfo);
        return false;
    }

    protected BigDecimal calcAjustQty(MRPMaterialDataInfo materialDataInfo, MRPDetailInfo rdetailInfo, MRPDetailInfo adetailInfo, BigDecimal pab_t_1, AdjustStrategyEnum strategyEnum) {
        BigDecimal aQty = null;
        BigDecimal surplusQty = adetailInfo.getSurplusQty();
        if (adetailInfo.getPeriod() - rdetailInfo.getPeriod() > this.runParam.getPlanVersion().getTolerOfForward()) {
            adetailInfo.setNextajustFlag(2);
            if (pab_t_1.add(surplusQty).compareTo(MRPConstant.ZERO) < 0) {
                if (strategyEnum.getValue() == 20) {
                    aQty = this.runParam.getPlanVersion().isIsConsiderBatch() && surplusQty.compareTo(adetailInfo.getScheduledReceiptQty()) < 0 ? this.getBatchAjustQty(materialDataInfo, adetailInfo, pab_t_1) : surplusQty;
                } else {
                    if (adetailInfo.getAjustQty().compareTo(MRPConstant.ZERO) > 0 || adetailInfo.getScheduledReceiptQty().compareTo(surplusQty) > 0) {
                        return null;
                    }
                    aQty = surplusQty;
                }
            } else if (strategyEnum.getValue() == 20) {
                if (this.runParam.getPlanVersion().isIsConsiderBatch()) {
                    aQty = this.getBatchAjustQty(materialDataInfo, adetailInfo, pab_t_1);
                    if (aQty == null || surplusQty.compareTo(adetailInfo.getScheduledReceiptQty()) == 0 && surplusQty.compareTo(aQty) < 0) {
                        aQty = surplusQty;
                    }
                } else {
                    aQty = pab_t_1.multiply(new BigDecimal("-1.0"));
                }
            } else {
                if (adetailInfo.getAjustQty().compareTo(MRPConstant.ZERO) > 0 || adetailInfo.getScheduledReceiptQty().compareTo(surplusQty) > 0) {
                    return null;
                }
                aQty = surplusQty;
            }
        } else {
            adetailInfo.setNextajustFlag(1);
            aQty = pab_t_1.add(surplusQty).compareTo(MRPConstant.ZERO) < 0 ? surplusQty : pab_t_1.multiply(new BigDecimal("-1.0"));
        }
        return aQty;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigDecimal calcDelayQty(MRPMaterialDataInfo materialDataInfo, MRPDetailInfo delaydetailInfo, BigDecimal surplusQty, AdjustStrategyEnum strategyEnum, int delayPeriod) {
        void var6_15;
        Object var6_6 = null;
        int period = delaydetailInfo.getSperiod();
        if (period <= 0) {
            period = delaydetailInfo.getPeriod();
        }
        if (strategyEnum == null || delaydetailInfo.getIsAjust() < 1) {
            return null;
        }
        if (surplusQty.compareTo(delaydetailInfo.getScheduledReceiptQty()) < 0) {
            if (delayPeriod - period <= this.runParam.getPlanVersion().getTolerOfDisplacemt()) {
                BigDecimal bigDecimal = surplusQty;
                delaydetailInfo.setNextajustFlag(5);
                return var6_15;
            } else {
                if (strategyEnum.getValue() != 20) return null;
                if (this.runParam.getPlanVersion().isIsConsiderBatch()) {
                    BigDecimal bigDecimal;
                    if (delaydetailInfo.getAjustFlag() == 5) {
                        BigDecimal bigDecimal2 = surplusQty;
                        delaydetailInfo.setNextajustFlag(3);
                        return bigDecimal2;
                    }
                    if (delaydetailInfo.getAjustFlag() > 0) {
                        surplusQty = delaydetailInfo.getScheduledReceiptQty().subtract(delaydetailInfo.getAjustQty()).subtract(surplusQty);
                    }
                    if ((bigDecimal = this.getBatchAjustQty(materialDataInfo, delaydetailInfo, surplusQty)) == null) {
                        return null;
                    }
                    if (delaydetailInfo.getAjustFlag() > 0) {
                        if (bigDecimal.compareTo(delaydetailInfo.getScheduledReceiptQty().subtract(delaydetailInfo.getAjustQty())) > 0) {
                            Object var6_10 = null;
                        } else {
                            BigDecimal bigDecimal3 = delaydetailInfo.getScheduledReceiptQty().subtract(delaydetailInfo.getAjustQty()).subtract(bigDecimal);
                        }
                    }
                } else {
                    BigDecimal bigDecimal = surplusQty;
                }
                delaydetailInfo.setNextajustFlag(3);
            }
            return var6_15;
        } else {
            BigDecimal bigDecimal = surplusQty;
            if (delayPeriod - period <= this.runParam.getPlanVersion().getTolerOfDisplacemt()) {
                delaydetailInfo.setNextajustFlag(5);
                return var6_15;
            } else {
                delaydetailInfo.setNextajustFlag(3);
            }
        }
        return var6_15;
    }

    protected void afterAjust(MRPMaterialStatisticsInfo materialStatisticsInfo, MRPDetailInfo rdetailInfo, MRPDetailInfo adetailInfo, BigDecimal aQty) throws EASBizException, BOSException {
        ++this.advace_seq;
        if (aQty.add(adetailInfo.getAjustQty()).compareTo(adetailInfo.getScheduledReceiptQty()) < 0) {
            MRPDetailInfo info = (MRPDetailInfo)adetailInfo.clone();
            info.setID(BOSUuid.create((String)"F94043EF").toString());
            info.setPeriod(rdetailInfo.getPeriod());
            info.setSperiod(adetailInfo.getPeriod());
            info.setRePlanDATE(rdetailInfo.getBillDate());
            info.setSID(adetailInfo.getID());
            info.setScheduledReceiptQty(aQty);
            info.setAjustQty(MRPConstant.ZERO);
            info.setAjustFlag(adetailInfo.getNextajustFlag());
            info.setPriority(99999);
            adetailInfo.setAjustQty(adetailInfo.getAjustQty().add(aQty));
            adetailInfo.setSurplusQty(adetailInfo.getSurplusQty().subtract(aQty));
            if (info.getAjustFlag() == 2 && this.runParam.getExceptionUtil().setException(info, 60)) {
                this.statisticException(info);
            }
            if (adetailInfo.getSID() == null) {
                adetailInfo.setAjustFlag(0);
            }
            this.dataSaver.addInsertList(info);
        } else {
            adetailInfo.setSID(adetailInfo.getID());
            adetailInfo.setAjustFlag(adetailInfo.getNextajustFlag());
            adetailInfo.setSperiod(adetailInfo.getPeriod());
            adetailInfo.setPeriod(rdetailInfo.getPeriod());
            adetailInfo.setRePlanDATE(rdetailInfo.getBillDate());
            adetailInfo.setSurplusQty(MRPConstant.ZERO);
            if (adetailInfo.getAjustFlag() == 2 && this.runParam.getExceptionUtil().setException(adetailInfo, 60)) {
                this.statisticException(adetailInfo);
            }
            this.detailDataUtil.clearDetailInMemory(adetailInfo);
        }
        ArrayList<MRPDetailInfo> updateDatas = new ArrayList<MRPDetailInfo>();
        updateDatas.add(adetailInfo);
        this.dataSaver.executeUpdate(updateDatas);
    }

    private BigDecimal afterDelayCancle(MRPMaterialDataInfo materialDataInfo, List delayPeriods, MRPDetailInfo detailInfo, BigDecimal delayQty) throws BOSException, EASBizException {
        BigDecimal actualDelayQtySum = MRPConstant.ZERO;
        MRPMaterialStatisticsInfo delayS = null;
        int size = delayPeriods.size();
        Iterator delayPeriodIter = delayPeriods.iterator();
        while (delayPeriodIter.hasNext()) {
            delayS = (MRPMaterialStatisticsInfo)delayPeriodIter.next();
            BigDecimal pab = delayS.getSQty().add(delayS.getRQty()).add(delayS.getOnHand());
            BigDecimal canDelayQty = this.calcDelayQty(materialDataInfo, detailInfo, delayQty, this.runParam.getAdjustStrategy(detailInfo.getBillType()), delayS.getPeriod());
            if (canDelayQty == null) {
                return actualDelayQtySum;
            }
            BigDecimal reqNeedQty = this.getBatchAjustQty4Cancel(materialDataInfo, detailInfo, pab.abs());
            BigDecimal minQty = MRPConstant.ZERO;
            if (this.runParam.getAdjustStrategy(detailInfo.getBillType()).getValue() == 10 && canDelayQty.compareTo(detailInfo.getScheduledReceiptQty()) == 0 && detailInfo.getNextajustFlag() != 5) {
                minQty = canDelayQty;
                reqNeedQty = canDelayQty;
                if (detailInfo.getNextajustFlag() == 3 && this.runParam.getExceptionUtil().setException(detailInfo, 61)) {
                    this.statisticException(materialDataInfo);
                }
                if (detailInfo.getSperiod() <= 0) {
                    detailInfo.setSperiod(detailInfo.getPeriod());
                }
                detailInfo.setPeriod(delayS.getPeriod());
                detailInfo.setRePlanDATE(null);
                detailInfo.setSID(detailInfo.getID());
                detailInfo.setAjustFlag(detailInfo.getNextajustFlag());
                detailInfo.setAjustQty(MRPConstant.ZERO);
            } else {
                minQty = detailInfo.getNextajustFlag() == 5 ? (pab.abs().compareTo(canDelayQty) > 0 ? canDelayQty : pab.abs()) : (reqNeedQty.compareTo(canDelayQty) > 0 ? canDelayQty : reqNeedQty);
                MRPDetailInfo info = (MRPDetailInfo)detailInfo.clone();
                info.setID(BOSUuid.create((String)"F94043EF").toString());
                if (info.getSperiod() <= 0) {
                    info.setSperiod(info.getPeriod());
                }
                info.setPeriod(delayS.getPeriod());
                info.setRePlanDATE(null);
                info.setSID(detailInfo.getID());
                info.setScheduledReceiptQty(minQty);
                info.setAjustQty(MRPConstant.ZERO);
                if (detailInfo.getNextajustFlag() == 3 && this.runParam.getExceptionUtil().setException(info, 61)) {
                    this.statisticException(materialDataInfo);
                }
                info.setPriority(99999);
                info.setAjustFlag(detailInfo.getNextajustFlag());
                if (detailInfo.getSID() == null) {
                    detailInfo.setAjustFlag(0);
                }
                detailInfo.setAjustQty(detailInfo.getAjustQty().add(minQty));
                this.dataSaver.addInsertList(info);
            }
            delayS.setSQty(delayS.getSQty().add(minQty));
            this.dataSaver.addUpdateList(detailInfo);
            this.dataSaver.addDUpdateList(delayS);
            actualDelayQtySum = actualDelayQtySum.add(minQty);
            BigDecimal periodAvailableQty = delayS.getRQty().add(delayS.getSQty()).add(delayS.getOnHand());
            if (periodAvailableQty.compareTo(MRPConstant.ZERO) >= 0) {
                delayPeriodIter.remove();
            }
            if ((delayQty = delayQty.subtract(minQty)).compareTo(MRPConstant.ZERO) > 0) continue;
            return actualDelayQtySum;
        }
        if (delayQty.compareTo(MRPConstant.ZERO) > 0 || size == 0) {
            actualDelayQtySum = actualDelayQtySum.add(this.cancelBill(materialDataInfo, detailInfo, delayQty));
        }
        return actualDelayQtySum;
    }

    protected BigDecimal cancelBill(MRPMaterialDataInfo materialDataInfo, MRPDetailInfo detailInfo, BigDecimal delayQty) throws BOSException, EASBizException {
        BigDecimal actualDelayQtySum = MRPConstant.ZERO;
        BigDecimal needDelayQty = this.calcCancelQty(materialDataInfo, detailInfo, delayQty);
        if (!(needDelayQty.compareTo(MRPConstant.ZERO) <= 0 || this.runParam.getAdjustStrategy(detailInfo.getBillType()).equals((Object)AdjustStrategyEnum.WHOLE_ADJUST) && needDelayQty.compareTo(detailInfo.getScheduledReceiptQty()) < 0)) {
            if (detailInfo.getAjustQty().compareTo(MRPConstant.ZERO) > 0) {
                MRPDetailInfo info = (MRPDetailInfo)detailInfo.clone();
                info.setID(BOSUuid.create((String)"F94043EF").toString());
                if (info.getSperiod() <= 0) {
                    info.setSperiod(info.getPeriod());
                }
                info.setPeriod(this.runParam.getMRPEndDate().getWorkDaySeqID());
                if (this.runParam.getExceptionUtil().setException(info, 62)) {
                    this.statisticException(materialDataInfo);
                }
                info.setRePlanDATE(null);
                info.setSID(detailInfo.getID());
                info.setAjustQty(MRPConstant.ZERO);
                info.setScheduledReceiptQty(MRPConstant.ZERO);
                info.setNetReqQty(needDelayQty);
                info.setAjustFlag(4);
                info.setPriority(99999);
                detailInfo.setAjustQty(detailInfo.getAjustQty().add(needDelayQty));
                this.dataSaver.addInsertList(info);
            } else {
                detailInfo.setAjustFlag(4);
                detailInfo.setAjustQty(detailInfo.getAjustQty().add(needDelayQty));
                detailInfo.setNetReqQty(needDelayQty);
                if (this.runParam.getExceptionUtil().setException(detailInfo, 62)) {
                    this.statisticException(materialDataInfo);
                }
                if (detailInfo.getSperiod() <= 0) {
                    detailInfo.setSperiod(detailInfo.getPeriod());
                }
                detailInfo.setPeriod(this.runParam.getMRPEndDate().getWorkDaySeqID());
                detailInfo.setSID(detailInfo.getID());
            }
            actualDelayQtySum = actualDelayQtySum.add(needDelayQty);
            this.dataSaver.addUpdateList(detailInfo);
        }
        return actualDelayQtySum;
    }

    protected BigDecimal calcCancelQty(MRPMaterialDataInfo materialDataInfo, MRPDetailInfo detailInfo, BigDecimal delayQty) {
        BigDecimal remainQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
        delayQty = this.getBatchAjustQty4Cancel(materialDataInfo, detailInfo, remainQty.subtract(delayQty));
        delayQty = remainQty.subtract(delayQty);
        return delayQty;
    }

    protected MRPDetailInfo createPlanOrder(MRPMaterialDataInfo materialDataInfo, BigDecimal pab_t_1, BigDecimal avaliableSupply, MRPDate orderDate, MRPDate replanDate, MRPDetailInfo theLineInfo, boolean isMergeSign) throws EASBizException, BOSException {
        MRPDetailInfo orderLineInfo = new MRPDetailInfo();
        materialDataInfo.setIsNewOrder(1);
        orderLineInfo.setID(BOSUuid.create((String)"F94043EF").toString());
        orderLineInfo.setMaterialID(materialDataInfo.getMaterialID());
        orderLineInfo.setPlanningMode(materialDataInfo.getPlanningMode());
        orderLineInfo.setMrpClassify(MRPClassifyEnum.Supply);
        orderLineInfo.setMrpItem(MRPElementEnum.S_PlannedOrder);
        orderLineInfo.setBillSeqNo(250);
        orderLineInfo.setParentBomID(theLineInfo.getParentBomID());
        orderLineInfo.setBillType("9XXvbVGlRtym/0qtqeIXXrhE1B8=");
        MRPBillParamInfo info = (MRPBillParamInfo)this.runParam.getBillParamMap().get("9XXvbVGlRtym/0qtqeIXXrhE1B8=");
        orderLineInfo.setPriority(info.getPriority());
        orderLineInfo.setBillID(BOSUuid.create((String)"B844D41F").toString());
        orderLineInfo.setBillDate(orderDate);
        orderLineInfo.setRePlanDATE(replanDate);
        orderLineInfo.setNewOrder(true);
        orderLineInfo.setBaseStatus(2);
        String orderNumber = this.getOrderNumber();
        orderLineInfo.setBillNumber(orderNumber);
        orderLineInfo.setAvaliableQty(avaliableSupply);
        orderLineInfo.setNetReqQty(avaliableSupply);
        orderLineInfo.setCanNotThrow(theLineInfo.isCanNotThrow());
        orderLineInfo.setPlannedQty(theLineInfo.getPlannedQty());
        orderLineInfo.setDirectTransport(theLineInfo.isDirectTransport());
        orderLineInfo.setMaterialAttr(materialDataInfo.getMaterialAttr());
        orderLineInfo.setBaseUnitID(materialDataInfo.getBaseUnitID());
        orderLineInfo.setProdUnitID(materialDataInfo.getProdUnitID());
        orderLineInfo.setManufactureDepartmentId(materialDataInfo.getManufactureDepartmentId());
        orderLineInfo.setPlanOrgUnitId(materialDataInfo.getPlanOrgUnitId());
        orderLineInfo.setProductTranTypeID(materialDataInfo.getProductTranTypeID());
        orderLineInfo.setConvertRate(materialDataInfo.getConvertRate());
        orderLineInfo.setPlanner(materialDataInfo.getPlanner());
        orderLineInfo.setLowsetCode(materialDataInfo.getLowsetCode());
        orderLineInfo.setPeriod(theLineInfo.getPeriod());
        MRPDate endDate = null;
        MRPDate beginDate = null;
        materialDataInfo.setIsNewOrder(1);
        int leadTime = -1 * (materialDataInfo.getReceiveLeadTime() + materialDataInfo.getProdLeadTime());
        leadTime = this.leadTimeTypeHandle(materialDataInfo, orderLineInfo, leadTime);
        leadTime = -1 * materialDataInfo.getReceiveLeadTime();
        endDate = orderDate.add(this.runParam, leadTime);
        endDate = this.runParam.getCalendarFactory().getDate(endDate.getWorkDaySeqID(), endDate.getSourceDate());
        leadTime = -1 * materialDataInfo.getProdLeadTime();
        leadTime = this.leadTimeTypeHandle(materialDataInfo, orderLineInfo, leadTime);
        if (materialDataInfo.getMaterialAttr() != 10040) {
            beginDate = endDate.add(this.runParam, leadTime);
            beginDate = this.runParam.getCalendarFactory().getDate(beginDate.getWorkDaySeqID(), beginDate.getSourceDate());
        } else {
            beginDate = this.getMRPDate(endDate, leadTime, true);
        }
        if (!this.runParam.getRunLogInfo().isIsDelayOrder()) {
            if (beginDate.before(this.runParam.getPlanDate())) {
                beginDate = this.runParam.getPlanDate();
                if (this.runParam.getExceptionUtil().setException(orderLineInfo, 63)) {
                    this.statisticException(materialDataInfo);
                }
            }
            if (endDate.before(this.runParam.getPlanDate())) {
                endDate = this.runParam.getPlanDate();
                if (this.runParam.getExceptionUtil().setException(orderLineInfo, 63)) {
                    this.statisticException(materialDataInfo);
                }
            }
            if (orderDate.before(this.runParam.getPlanDate())) {
                orderDate = this.runParam.getPlanDate();
                if (this.runParam.getExceptionUtil().setException(orderLineInfo, 63)) {
                    this.statisticException(materialDataInfo);
                }
                orderLineInfo.setPeriod(orderDate.getPeriod());
            }
        }
        orderLineInfo.setBillDate(orderDate);
        orderLineInfo.setPlanEndDate(endDate);
        orderLineInfo.setPlanBeginDate(beginDate);
        orderLineInfo.setTotalLine(isMergeSign);
        String supplyStorageOrgUnitID = materialDataInfo.getSupplyStorageOrgUnitID();
        orderLineInfo.setIsDeaultTNO(theLineInfo.getIsDeaultTNO());
        if (this.runParam.getProjectID().equals(theLineInfo.getBProjectID())) {
            orderLineInfo.setBProjectID(null);
        } else {
            orderLineInfo.setBProjectID(theLineInfo.getBProjectID());
        }
        orderLineInfo.setBTrackID(theLineInfo.getBTrackID());
        orderLineInfo.setProjectID(theLineInfo.getProjectID());
        orderLineInfo.setTrackID(theLineInfo.getTrackID());
        orderLineInfo.setProjectNumber(theLineInfo.getProjectNumber());
        orderLineInfo.setTrackNumber(theLineInfo.getTrackNumber());
        orderLineInfo.setBProjectNumber(theLineInfo.getBProjectNumber());
        orderLineInfo.setBTrackNumber(theLineInfo.getBTrackNumber());
        orderLineInfo.setBomID(theLineInfo.getBomID());
        orderLineInfo.setYield(theLineInfo.getYield());
        orderLineInfo.setYield4PlanOrder(theLineInfo.getYield4PlanOrder());
        BigDecimal qty = orderLineInfo.getPlannedQty().divide(materialDataInfo.getConvertRate(), materialDataInfo.getProdQtyPrc(), 2);
        orderLineInfo.setPlanOrderQty(qty);
        BigDecimal yield4PlanOrder = orderLineInfo.getYield4PlanOrder().divide(new BigDecimal("100.00"), 4, 3);
        BigDecimal finalProductsQty = qty.multiply(yield4PlanOrder);
        orderLineInfo.setFinalProductsQty(finalProductsQty.setScale(materialDataInfo.getProdQtyPrc(), 3));
        orderLineInfo.setBomType(theLineInfo.getBomType());
        if (!isMergeSign) {
            MRPHierarchyCodeGenerator hcGenerator;
            orderLineInfo.setSaleOrderID(theLineInfo.getSaleOrderID());
            orderLineInfo.setSaleOrderEntryID(theLineInfo.getSaleOrderEntryID());
            orderLineInfo.setSaleOrderNumber(theLineInfo.getSaleOrderNumber());
            orderLineInfo.setSaleOrderEntryNum(theLineInfo.getSaleOrderEntryNum());
            if (theLineInfo.getMrpItem().equals((Object)MRPElementEnum.R_SID) || theLineInfo.getMrpItem().equals((Object)MRPElementEnum.R_SID)) {
                orderLineInfo.setSrcBillID(theLineInfo.getSrcBillID());
                orderLineInfo.setSrcBillType(theLineInfo.getSrcBillType());
                orderLineInfo.setSrcBillEntryID(theLineInfo.getSrcBillEntryID());
                orderLineInfo.setSrcBillNumber(theLineInfo.getSrcBillNumber());
                orderLineInfo.setSrcBillRowSeq(theLineInfo.getBillRowSeq());
            } else {
                orderLineInfo.setSrcBillID(theLineInfo.getBillID());
                orderLineInfo.setSrcBillType(theLineInfo.getBillType());
                orderLineInfo.setSrcBillNumber(theLineInfo.getBillNumber());
                orderLineInfo.setSrcBillEntryID(theLineInfo.getBillEntryID());
            }
            orderLineInfo.setRequireMentID(theLineInfo.getRequireMentID());
            if (theLineInfo.getSupplyStorageOrgUnitID() != null && theLineInfo.getMrpItem().equals((Object)MRPElementEnum.R_PlannedOrder)) {
                supplyStorageOrgUnitID = theLineInfo.getSupplyStorageOrgUnitID();
            }
            if ((hcGenerator = this.runParam.getHierarchyCodeGenerator()) != null) {
                orderLineInfo.setHierarchyCode(hcGenerator.getHierarchyCode(theLineInfo));
            }
        }
        orderLineInfo.setSupplyStorageOrgUnitID(supplyStorageOrgUnitID);
        orderLineInfo.setScheduledReceiptQty(avaliableSupply);
        orderLineInfo.setSsrQty(avaliableSupply);
        if (theLineInfo.getException6() == 63 && this.runParam.getExceptionUtil().setException(orderLineInfo, theLineInfo.getException6())) {
            this.statisticException(materialDataInfo);
        }
        orderLineInfo.setBaseQtyPrc(materialDataInfo.getBaseQtyPrc());
        orderLineInfo.setProdQtyPrc(materialDataInfo.getProdQtyPrc());
        this.genExceptions(materialDataInfo, orderLineInfo, pab_t_1.add(orderLineInfo.getScheduledReceiptQty()));
        this.handleException64(orderLineInfo);
        MRPSeqUtil.setMRPSeq(orderLineInfo);
        this.dataSaver.addInsertList(orderLineInfo);
        this.dataSaver.addMrpPlanOrder(orderLineInfo);
        this.runParam.generateOrder();
        return orderLineInfo;
    }

    protected void handleException64(MRPDetailInfo orderLineInfo) throws BOSException, EASBizException {
        MRPDate billDate = orderLineInfo.getBillDate();
        MRPDate beginDate = orderLineInfo.getPlanBeginDate();
        MRPDate endDate = orderLineInfo.getPlanEndDate();
        boolean hasExe64 = false;
        StringBuffer msg = new StringBuffer();
        String suggestMsg = null;
        DateFormat dtformat = BOSLocaleUtil.getDateFormat();
        if (beginDate.getInCalendar() != 0) {
            if (suggestMsg == null) {
                suggestMsg = MRPResource.getString(this.runParam.getCtx(), "SUGGEST_CHANGED");
            }
            msg.append(MRPResource.getString(this.runParam.getCtx(), "SUGGEST_CHANGED_BEGINDATE"));
            msg.append(dtformat.format(beginDate.getSourceDate()));
            hasExe64 = true;
        }
        if (endDate.getInCalendar() != 0) {
            msg.append(" ");
            if (suggestMsg == null) {
                suggestMsg = MRPResource.getString(this.runParam.getCtx(), "SUGGEST_CHANGED");
            }
            msg.append(MRPResource.getString(this.runParam.getCtx(), "SUGGEST_CHANGED_ENDDATE"));
            msg.append(dtformat.format(endDate.getSourceDate()));
            hasExe64 = true;
        }
        if (billDate.getInCalendar() != 0) {
            msg.append(" ");
            if (suggestMsg == null) {
                suggestMsg = MRPResource.getString(this.runParam.getCtx(), "SUGGEST_CHANGED");
            }
            msg.append(MRPResource.getString(this.runParam.getCtx(), "SUGGEST_CHANGED_BILLDATE"));
            msg.append(dtformat.format(billDate.getSourceDate()));
            hasExe64 = true;
        }
        if (hasExe64) {
            MRPDetailInfo supplyDetailInfoCopy = this.splitBill(orderLineInfo);
            if (this.runParam.getExceptionUtil().setException(supplyDetailInfoCopy, 64)) {
                this.statisticException(orderLineInfo);
            }
            orderLineInfo.setDescription64(MessageFormat.format(suggestMsg, msg));
        }
    }

    private MRPDetailInfo splitBill(MRPDetailInfo splitedOrderInfo) throws EASBizException, BOSException {
        MRPDetailInfo supplyDetailInfoCopy = (MRPDetailInfo)splitedOrderInfo.clone();
        supplyDetailInfoCopy.setID(BOSUuid.create((String)"F94043EF").toString());
        supplyDetailInfoCopy.setRePlanDATE(null);
        supplyDetailInfoCopy.setSID(splitedOrderInfo.getID());
        MRPSeqUtil.setMRPSeq(supplyDetailInfoCopy);
        supplyDetailInfoCopy.setNewOrder(false);
        supplyDetailInfoCopy.setAjustFlag(-1);
        supplyDetailInfoCopy.clearException();
        this.dataSaver.addInsertList(supplyDetailInfoCopy);
        return supplyDetailInfoCopy;
    }

    private int leadTimeTypeHandle(MRPMaterialDataInfo materialDataInfo, MRPDetailInfo orderLineInfo, int leadTime) {
        if (MaterialLeadTimeTypeEnum.CHANGEBATCHTYPE.equals((Object)materialDataInfo.getLeadTimeType())) {
            BigDecimal plannedQty = orderLineInfo.getPlannedQty().divide(materialDataInfo.getConvertRate(), materialDataInfo.getBaseQtyPrc(), 2);
            int changeBatch = materialDataInfo.getChangeBatch();
            if (changeBatch == 0) {
                changeBatch = 1;
            }
            leadTime -= plannedQty.multiply(new BigDecimal(materialDataInfo.getChangeLeadTime())).divide(new BigDecimal(changeBatch), 0, 2).intValue();
        }
        leadTime = leadTime - materialDataInfo.getForwardProcessTime() - materialDataInfo.getBackwardProcessTime();
        return leadTime;
    }

    protected String getOrderNumber() throws EASBizException, BOSException {
        return this.runParam.getPONumber();
    }

    protected MRPDate getMRPDate(Calendar theDate) throws BOSException, MRPException {
        MRPDate mrpDate = new MRPDate();
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.FID,t0.FWeekSeq,t0.FMonthSeq,t0.FWorkDate,t0.FWorkDateSeq ").append(" from ").append(this.runParam.getCalendarTable()).append(" t0").append(" where t0.FSWorkDate =  '").append(MRPUtil.dateToString(theDate.getTime(), "yyyy-MM-dd")).append("' ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString());
        try {
            if (rs != null && rs.next()) {
                mrpDate.setCalendarID(rs.getString("FID"));
                Date wDate = rs.getDate("FWorkDate");
                Calendar calDate = Calendar.getInstance();
                calDate.setTimeInMillis(wDate.getTime());
                mrpDate.setDate(calDate);
                mrpDate.setWorkDaySeqID(rs.getInt("FWorkDateSeq"));
                mrpDate.setWeekSeqID(rs.getInt("FWeekSeq"));
                mrpDate.setMonthSeqID(rs.getInt("FMonthSeq"));
            } else {
                mrpDate = this.runParam.getMRPBeginDate();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return mrpDate;
    }

    private BigDecimal getBatchAjustQty(MRPMaterialDataInfo materialdataInfo, MRPDetailInfo detailInfo, BigDecimal aQty) {
        boolean isDelay = true;
        BigDecimal surplusQty = null;
        if (aQty.compareTo(MRPConstant.ZERO) < 0) {
            isDelay = false;
            surplusQty = detailInfo.getSurplusQty();
        } else {
            surplusQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
        }
        BigDecimal batchQty = aQty.abs();
        if (batchQty.compareTo(surplusQty) > 0) {
            batchQty = surplusQty;
        }
        switch (materialdataInfo.getBatchPolicy()) {
            case 1: {
                if (materialdataInfo.getFixationBatchQty() == null || materialdataInfo.getFixationBatchQty().compareTo(MRPConstant.ZERO) <= 0) break;
                BigDecimal batch = batchQty.divide(materialdataInfo.getFixationBatchQty(), 0, 2);
                batchQty = batch.multiply(materialdataInfo.getFixationBatchQty()).setScale(materialdataInfo.getBaseQtyPrc(), 2);
                if (isDelay) {
                    if (batchQty.compareTo(aQty) <= 0 || detailInfo.getAjustFlag() > 0) break;
                    batchQty = batchQty.subtract(materialdataInfo.getFixationBatchQty());
                    break;
                }
                if (batchQty.compareTo(surplusQty) <= 0) break;
                batchQty = batchQty.subtract(materialdataInfo.getFixationBatchQty());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (materialdataInfo.getMinBatchQty() != null && batchQty.compareTo(materialdataInfo.getMinBatchQty()) < 0 && this.runParam.getPlanType() != MrpRunEnum.MPS_GROSS) {
                    batchQty = materialdataInfo.getMinBatchQty();
                    if (isDelay) {
                        if (batchQty.compareTo(aQty) > 0 && detailInfo.getAjustFlag() <= 0) {
                            batchQty = batchQty.subtract(materialdataInfo.getMinBatchQty());
                        }
                    } else if (batchQty.compareTo(surplusQty) > 0) {
                        batchQty = batchQty.subtract(materialdataInfo.getMinBatchQty());
                    }
                }
                if (materialdataInfo.getRoundUpMultipleQty() == null || materialdataInfo.getRoundUpMultipleQty().compareTo(MRPConstant.ZERO) <= 0) break;
                BigDecimal batchM = batchQty.divide(materialdataInfo.getRoundUpMultipleQty(), 0, 2);
                batchQty = batchM.multiply(materialdataInfo.getRoundUpMultipleQty()).setScale(materialdataInfo.getBaseQtyPrc(), 2);
                if (isDelay) {
                    if (batchQty.compareTo(aQty) <= 0 || detailInfo.getAjustFlag() > 0) break;
                    batchQty = batchQty.subtract(materialdataInfo.getRoundUpMultipleQty());
                    break;
                }
                if (batchQty.compareTo(surplusQty) <= 0) break;
                batchQty = batchQty.subtract(materialdataInfo.getRoundUpMultipleQty());
            }
        }
        if (batchQty.compareTo(MRPConstant.ZERO) <= 0) {
            batchQty = null;
        }
        return batchQty;
    }

    private BigDecimal getBatchAjustQty4Cancel(MRPMaterialDataInfo materialdataInfo, MRPDetailInfo detailInfo, BigDecimal aQty) {
        if (aQty.compareTo(MRPConstant.ZERO) <= 0) {
            return MRPConstant.ZERO;
        }
        BigDecimal surplusQty = detailInfo.getScheduledReceiptQty().subtract(detailInfo.getAjustQty());
        BigDecimal batchQty = aQty.abs();
        if (batchQty.compareTo(surplusQty) > 0) {
            batchQty = surplusQty;
        }
        if (!this.runParam.getPlanVersion().isIsConsiderBatch()) {
            return batchQty;
        }
        switch (materialdataInfo.getBatchPolicy()) {
            case 1: {
                if (materialdataInfo.getFixationBatchQty() == null || materialdataInfo.getFixationBatchQty().compareTo(MRPConstant.ZERO) <= 0) break;
                BigDecimal batch = batchQty.divide(materialdataInfo.getFixationBatchQty(), 0, 2);
                batchQty = batch.multiply(materialdataInfo.getFixationBatchQty()).setScale(materialdataInfo.getBaseQtyPrc(), 2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (materialdataInfo.getMinBatchQty() != null && batchQty.compareTo(materialdataInfo.getMinBatchQty()) < 0 && this.runParam.getPlanType() != MrpRunEnum.MPS_GROSS) {
                    batchQty = materialdataInfo.getMinBatchQty();
                }
                if (materialdataInfo.getRoundUpMultipleQty() == null || materialdataInfo.getRoundUpMultipleQty().compareTo(MRPConstant.ZERO) <= 0) break;
                BigDecimal batchM = batchQty.divide(materialdataInfo.getRoundUpMultipleQty(), 0, 2);
                batchQty = batchM.multiply(materialdataInfo.getRoundUpMultipleQty()).setScale(materialdataInfo.getBaseQtyPrc(), 2);
            }
        }
        return batchQty;
    }

    protected void calcProjectAvailableBalance(boolean isYieldproduct, MRPDetailInfo detailInfo, MRPMaterialDataInfo materialDataInfo) {
        BigDecimal plannedQty = detailInfo.getPlannedQty();
        if (isYieldproduct && plannedQty.compareTo(MRPConstant.ZERO) > 0) {
            BigDecimal yieldRate = detailInfo.getYield();
            if (yieldRate == null) {
                yieldRate = materialDataInfo.getYield();
            }
            if ((yieldRate = yieldRate.divide(new BigDecimal(100), 4, 2)).compareTo(MRPConstant.ZERO) > 0) {
                plannedQty = plannedQty.multiply(yieldRate).setScale(materialDataInfo.getBaseQtyPrc(), 2);
            }
        }
        detailInfo.setScheduledReceiptQty(plannedQty);
        detailInfo.setSsrQty(plannedQty);
    }

    private int batchGenExceptions(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo materialStatisticsInfo, ArrayList datas) throws EASBizException, BOSException {
        MRPDetailInfo detailInfo = null;
        BigDecimal pab_t_1 = materialStatisticsInfo.getOnHand();
        if (this.preQty.get(this.key) != null) {
            pab_t_1 = pab_t_1.add((BigDecimal)this.preQty.get(this.key));
        }
        Iterator iterator = datas.iterator();
        while (iterator.hasNext()) {
            detailInfo = (MRPDetailInfo)iterator.next();
            if (!MRPClassifyEnum.Supply.equals((Object)detailInfo.getMrpClassify())) {
                return 0;
            }
            iterator.remove();
            pab_t_1 = pab_t_1.add(detailInfo.getScheduledReceiptQty()).subtract(detailInfo.getAjustQty());
            if (detailInfo.getAjustFlag() == 5 && detailInfo.getAjustFlag() == 3) continue;
            this.genExceptions(materialDataInfo, detailInfo, pab_t_1);
            if (detailInfo.getAjustFlag() > 0) continue;
            this.dataSaver.addUpdateList(detailInfo);
        }
        return 0;
    }

    protected void genExceptions(MRPMaterialDataInfo materialDataInfo, MRPDetailInfo detailInfo, BigDecimal pab_t_1) throws EASBizException, BOSException {
        MRPDate planDate = new MRPDate();
        Calendar curDate = MRPUtil.createCalendar();
        curDate.setTime(this.runParam.getRunLogInfo().getPlanDate());
        curDate.set(11, 0);
        curDate.set(12, 0);
        curDate.set(13, 0);
        curDate.set(14, 0);
        planDate.setDate(curDate);
        if (detailInfo.getBillDate() != null) {
            detailInfo.setDelay(detailInfo.getBillDate().before(this.runParam.getPlanDate()));
        }
        MRPDate theDate = null;
        switch (detailInfo.getMrpItem().getValue()) {
            case 200: 
            case 205: 
            case 250: {
                theDate = detailInfo.getPlanBeginDate();
                break;
            }
            case 210: 
            case 220: 
            case 240: 
            case 270: {
                theDate = detailInfo.getBillDate();
            }
        }
        if (theDate != null && theDate.before(planDate)) {
            if (((Boolean)this.runParam.getException().get(String.valueOf(11))).booleanValue() && !detailInfo.isNewOrder() && this.runParam.getExceptionUtil().setException(detailInfo, 11)) {
                this.hasException = true;
            }
            if (detailInfo.isNewOrder() && ((Boolean)this.runParam.getException().get(String.valueOf(10))).booleanValue() && this.runParam.getExceptionUtil().setException(detailInfo, 10)) {
                this.hasException = true;
            }
        }
        theDate = null;
        switch (detailInfo.getMrpItem().getValue()) {
            case 200: 
            case 205: 
            case 250: {
                theDate = detailInfo.getPlanEndDate();
                break;
            }
            case 210: 
            case 220: 
            case 270: {
                theDate = detailInfo.getBillDate();
            }
        }
        if (theDate != null && theDate.before(planDate)) {
            if (((Boolean)this.runParam.getException().get(String.valueOf(21))).booleanValue() && !detailInfo.isNewOrder() && this.runParam.getExceptionUtil().setException(detailInfo, 21)) {
                this.hasException = true;
            }
            if (detailInfo.isNewOrder() && ((Boolean)this.runParam.getException().get(String.valueOf(20))).booleanValue() && this.runParam.getExceptionUtil().setException(detailInfo, 20)) {
                this.hasException = true;
            }
        }
        if (materialDataInfo.getQtyMax().compareTo(MRPConstant.ZERO) >= 0) {
            BigDecimal p = pab_t_1;
            if ("NUnM+gEcEADgAA3cwKgL09g0uEU=".equals(materialDataInfo.getPlanStrategy()) || "NUnM+gEcEADgAA3gwKgL09g0uEU=".equals(materialDataInfo.getPlanStrategy()) || "qAYfaBzUrmLgQKjAYj0f3dg0uEU=".equals(materialDataInfo.getPlanStrategy())) {
                p = p.add(materialDataInfo.getSafeStockQty());
            }
            if (p.compareTo(materialDataInfo.getQtyMax()) > 0 && ((Boolean)this.runParam.getException().get(String.valueOf(40))).booleanValue() && detailInfo.getAjustFlag() == 0) {
                MRPDetailInfo stockDetailInfo = new MRPDetailInfo();
                stockDetailInfo.setID(materialDataInfo.getInvDetailId(this.runParam, detailInfo.getProjectNumber(), detailInfo.getTrackNumber()));
                if (this.runParam.getExceptionUtil().setException(stockDetailInfo, 40)) {
                    this.hasException = true;
                }
                this.dataSaver.addUpdateStockException(stockDetailInfo);
            }
        }
        if ((materialDataInfo.getMaterialAttr() == 10030 || materialDataInfo.getMaterialAttr() == 10020) && detailInfo.getBomID() == null && detailInfo.isNewOrder()) {
            if (materialDataInfo.getPlanStrategy().equalsIgnoreCase("NUnM+gEcEADgAA3cwKgL09g0uEU=") || materialDataInfo.getPlanStrategy().equalsIgnoreCase("NUnM+gEcEADgAA3ewKgL09g0uEU=") || materialDataInfo.getPlanStrategy().equalsIgnoreCase("NUnM+gEcEADgAA3gwKgL09g0uEU=") || materialDataInfo.getPlanStrategy().equalsIgnoreCase("qAYfaBzUrmLgQKjAYj0f3dg0uEU=")) {
                if (((Boolean)this.runParam.getException().get(String.valueOf(30))).booleanValue() && this.runParam.getExceptionUtil().setException(detailInfo, 30)) {
                    this.hasException = true;
                }
            } else if (((Boolean)this.runParam.getException().get(String.valueOf(31))).booleanValue() && this.runParam.getExceptionUtil().setException(detailInfo, 31)) {
                this.hasException = true;
            }
        }
        if ((materialDataInfo.getMaterialAttr() == 10030 || materialDataInfo.getMaterialAttr() == 10020) && detailInfo.isNewOrder() && (materialDataInfo.getPlanStrategy().equalsIgnoreCase("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || materialDataInfo.getPlanStrategy().equalsIgnoreCase("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || materialDataInfo.getPlanStrategy().equalsIgnoreCase("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || materialDataInfo.getPlanStrategy().equalsIgnoreCase("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=") || materialDataInfo.getPlanStrategy().equalsIgnoreCase("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || materialDataInfo.getPlanStrategy().equalsIgnoreCase("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) && detailInfo.getBomType() != 45 && ((Boolean)this.runParam.getException().get(String.valueOf(31))).booleanValue() && this.runParam.getExceptionUtil().setException(detailInfo, 31)) {
            this.hasException = true;
        }
        if (detailInfo.isNewOrder() && ((Boolean)this.runParam.getException().get(String.valueOf(70))).booleanValue() && this.runParam.getExceptionUtil().setException(detailInfo, 70)) {
            this.hasException = true;
        }
        if (detailInfo.isNewOrder() && detailInfo.getException6() == 63) {
            this.hasException = true;
        }
        if (this.hasException && !detailInfo.isNewOrder()) {
            this.dataSaver.addUpdateList(detailInfo);
        }
        if (this.hasException) {
            this.statisticException(materialDataInfo);
        }
        this.hasException = false;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    public Object call() throws Exception {
        return this.execute(this.runParam);
    }

    private void advanceForStock(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, MRPDetailInfo detailData, int period) throws EASBizException, BOSException {
        MRPMaterialStatisticsInfo info = (MRPMaterialStatisticsInfo)statisticsInfo.clone();
        info.setPeriod(this.runParam.getPlanDate().getPeriod());
        info.setSQty(MRPConstant.ZERO);
        info.setRQty(MRPConstant.ZERO);
        info.setPreQty(MRPConstant.ZERO);
        info.setOnHand(MRPConstant.ZERO);
        info.setProjectNumber(this.runParam.getProjectNumber());
        info.setTrackNumber(this.runParam.getTrackNumber());
        MRPDetailInfo detailInfo = this.createStockReqDataInfo(materialDataInfo);
        if (period >= this.runParam.getPlanDate().getPeriod()) {
            detailInfo.setBillDate(this.runParam.getPlanDate());
        }
        detailInfo.setPeriod(period);
        info.setRQty(detailInfo.getDependentQty());
        BomInfo bom = this.findBOMFacade.getBomByTrcAndPrjID(materialDataInfo.getMaterialID(), null, null, this.runParam.getStorageOrgUnitID());
        if (bom != null) {
            detailInfo.setBomID(bom.getId().toString());
            detailInfo.setYield(bom.getYield());
            detailInfo.setBomType(bom.getBomType().getValue());
        } else {
            detailInfo.setBomID(null);
        }
        ArrayList<MRPDetailInfo> detailDatas = new ArrayList<MRPDetailInfo>();
        detailDatas.add(detailInfo);
        this.advance(materialDataInfo, info, detailDatas, period);
        this.adetail = null;
    }

    private BigDecimal subtractSafeStockQty(MRPMaterialDataInfo info, String projectNumber, String trackNumber) {
        if (!(!info.getPlanStrategy().equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") && !info.getPlanStrategy().equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=") && !info.getPlanStrategy().equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || projectNumber.equals(this.runParam.getProjectNumber()) && trackNumber.equals(this.runParam.getTrackNumber()))) {
            return info.getOnHandQty(projectNumber, trackNumber);
        }
        return info.getOnHandQty(projectNumber, trackNumber).subtract(info.getSafeStockQty());
    }

    protected void doSubstitute(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo statisticsInfo, MRPDetailInfo detailInfo, BigDecimal pab_t_1, int period) throws EASBizException, BOSException {
        detailInfo.setNetReqQty(pab_t_1);
    }

    protected void createPlanedorderForStock(List materialList, Map unMaterials) throws EASBizException, BOSException {
        List materialDataInfos = MRPMaterialTableDAO.getNoDataProjectNumberAndTrackNumber(this.runParam, materialList);
        if (materialDataInfos.size() == 0) {
            return;
        }
        MRPDetailInfo theLineInfo = new MRPDetailInfo();
        theLineInfo.setProjectNumber(this.runParam.getProjectNumber());
        theLineInfo.setProjectID(this.runParam.getProjectID());
        theLineInfo.setBProjectNumber(this.runParam.getProjectNumber());
        theLineInfo.setBProjectID(this.runParam.getProjectID());
        theLineInfo.setTrackNumber(this.runParam.getTrackNumber());
        theLineInfo.setTrackID(this.runParam.getTrackID());
        theLineInfo.setBTrackNumber(this.runParam.getTrackNumber());
        theLineInfo.setBTrackID(this.runParam.getTrackID());
        theLineInfo.setPeriod(this.runParam.getPlanDate().getPeriod());
        theLineInfo.setBillDate(this.runParam.getPlanDate());
        theLineInfo.setMrpItem(MRPElementEnum.I_CurInv);
        theLineInfo.setMrpClassify(MRPClassifyEnum.Inventory);
        theLineInfo.setIsDeaultTNO(1);
        BomInfo bom = null;
        boolean hasstockEXP = (Boolean)this.runParam.getException().get(String.valueOf(41));
        boolean isMergeSign = false;
        MRPMaterialStatisticsInfo info = null;
        ExpandInfoCollection expandInfoCollection = new ExpandInfoCollection();
        for (int i = 0; i < materialDataInfos.size(); ++i) {
            info = (MRPMaterialStatisticsInfo)materialDataInfos.get(i);
            ExpandInfo expandInfo = new ExpandInfo("MATERIAL");
            expandInfo.setExpandTraceId(info.getId());
            expandInfo.setId(info.getMaterialID());
            expandInfo.setProjectId(info.getProjectId());
            expandInfo.setTrackId(info.getTrackNumberId());
            expandInfoCollection.add(expandInfo);
        }
        Map bomInfoMap = this.findBOMFacade.getBomByTrcAndPrjID(this.runParam.getStorageOrgUnitID(), expandInfoCollection);
        MRPMaterialDataInfo materialDataInfo = null;
        for (int i = 0; i < materialDataInfos.size(); ++i) {
            MRPDetailInfo stockDetailInfo;
            info = (MRPMaterialStatisticsInfo)materialDataInfos.get(i);
            materialDataInfo = (MRPMaterialDataInfo)unMaterials.get(info.getMaterialID());
            BigDecimal onHandQty = materialDataInfo.getOnHandQty(info.getProjectNumber(), info.getTrackNumber());
            BigDecimal safeStockQty = materialDataInfo.getSafeStockQty();
            bom = (BomInfo)bomInfoMap.get(info.getId());
            if (bom != null) {
                theLineInfo.setBomID(bom.getId().toString());
                theLineInfo.setBomType(bom.getBomType().getValue());
                theLineInfo.setYield(bom.getYield());
            }
            theLineInfo.setMaterialID(info.getMaterialID());
            theLineInfo.setProjectNumber(info.getProjectNumber());
            theLineInfo.setProjectID(info.getProjectId());
            theLineInfo.setBProjectNumber(info.getProjectNumber());
            theLineInfo.setBProjectID(info.getProjectId());
            theLineInfo.setTrackNumber(info.getTrackNumber());
            theLineInfo.setTrackID(info.getTrackNumberId());
            theLineInfo.setBTrackNumber(info.getTrackNumber());
            theLineInfo.setBTrackID(info.getTrackNumberId());
            if (!this.isDefaultProjectAndTrackNumber(info.getProjectNumber(), info.getTrackNumber())) {
                theLineInfo.setIsDeaultTNO(2);
            }
            if (onHandQty.compareTo(MRPConstant.ZERO) >= 0) {
                if (materialDataInfo.getQtyMax().compareTo(MRPConstant.ZERO) < 0 || onHandQty.compareTo(materialDataInfo.getQtyMax()) <= 0 || !((Boolean)this.runParam.getException().get(String.valueOf(40))).booleanValue()) continue;
                stockDetailInfo = new MRPDetailInfo();
                stockDetailInfo.setID(materialDataInfo.getInvDetailId(this.runParam, theLineInfo.getProjectNumber(), theLineInfo.getTrackNumber()));
                if (this.runParam.getExceptionUtil().setException(stockDetailInfo, 40)) {
                    this.statisticException(materialDataInfo);
                }
                this.dataSaver.addUpdateStockException(stockDetailInfo);
                continue;
            }
            if (hasstockEXP && this.runParam.isSafeStock() && this.runParam.isIsAvailablStock()) {
                if (!this.underSafeStockIds.contains(materialDataInfo.getMaterialID())) {
                    this.underSafeStockIds.add(materialDataInfo.getMaterialID());
                    if (this.isContainMaterial(materialDataInfo)) {
                        logger.debug((Object)("under safeStock material Number: " + materialDataInfo.getMaterialNumber()));
                        this.runParam.underSafeQty();
                    }
                }
                stockDetailInfo = new MRPDetailInfo();
                stockDetailInfo.setID(materialDataInfo.getInvDetailId(this.runParam, theLineInfo.getProjectNumber(), theLineInfo.getTrackNumber()));
                if (this.runParam.getExceptionUtil().setException(stockDetailInfo, 41)) {
                    this.statisticException(materialDataInfo);
                }
                stockDetailInfo.setDescription64(String.valueOf(41));
                this.dataSaver.addUpdateStockException(stockDetailInfo);
            }
            Log.info((Object)("nodata material number " + materialDataInfo.getMaterialNumber() + " level :" + this.runParam.getLevel()));
            isMergeSign = this.isMerge(materialDataInfo);
            theLineInfo.setPlannedQty(safeStockQty.subtract(onHandQty));
            if (materialDataInfo.getBatchPolicy() == 4 || materialDataInfo.getBatchPolicy() == 3) {
                materialDataInfo.setiBatchPolicy(BatchPolicyFactory.createInstance(2, this.runParam));
                materialDataInfo.setPartitionQty(0);
            }
            this.batchCal(materialDataInfo, theLineInfo.getPeriod(), onHandQty, onHandQty, true, onHandQty, theLineInfo, isMergeSign);
        }
        this.dataSaver.execute(true);
    }

    protected MRPDetailInfo getNextMergeRequire(String planStrategy, ArrayList detailDatas, IsolatedRuleEnum isolateRule) {
        MRPDetailInfo newDetailInfo;
        MRPDetailInfo detailInfo;
        MRPDetailInfo lastDetailInfo = detailInfo = (MRPDetailInfo)detailDatas.get(0);
        boolean isDirectTransport = detailInfo.isDirectTransport();
        BigDecimal rqty = MRPConstant.ZERO;
        int group = detailInfo.getPriority();
        Iterator iterator = detailDatas.iterator();
        if ("qAYbemEdG9ngQKjAYj0V1dg0uEU=".equals(planStrategy) || "qAYfaBzTrmLgQKjAYj0f3dg0uEU=".equals(planStrategy) || "qAYfaBzUrmLgQKjAYj0f3dg0uEU=".equals(planStrategy)) {
            boolean isCanNotThrow = detailInfo.isCanNotThrow();
            while (iterator.hasNext()) {
                detailInfo = (MRPDetailInfo)iterator.next();
                if (!isDirectTransport) {
                    isDirectTransport = detailInfo.isDirectTransport();
                }
                if (group == detailInfo.getPriority() && isCanNotThrow == detailInfo.isCanNotThrow()) {
                    rqty = rqty.add(detailInfo.getDependentQty()).add(detailInfo.getIndependentQty());
                    lastDetailInfo = detailInfo;
                    iterator.remove();
                    continue;
                }
                break;
            }
        } else {
            while (iterator.hasNext()) {
                detailInfo = (MRPDetailInfo)iterator.next();
                if (!isDirectTransport) {
                    isDirectTransport = detailInfo.isDirectTransport();
                }
                if (group == detailInfo.getPriority()) {
                    rqty = rqty.add(detailInfo.getDependentQty()).add(detailInfo.getIndependentQty());
                    lastDetailInfo = detailInfo;
                    iterator.remove();
                    continue;
                }
                break;
            }
        }
        if (this.isNotProjectNoIsolation(planStrategy, newDetailInfo = (MRPDetailInfo)lastDetailInfo.clone())) {
            newDetailInfo.setBProjectID(this.runParam.getProjectID());
            newDetailInfo.setBProjectNumber(this.runParam.getProjectNumber());
        }
        if (this.isNotTrackNoIsolation(planStrategy, isolateRule, newDetailInfo)) {
            newDetailInfo.setBTrackID(this.runParam.getTrackID());
            newDetailInfo.setBTrackNumber(this.runParam.getTrackNumber());
        }
        newDetailInfo.setDirectTransport(isDirectTransport);
        newDetailInfo.setDependentQty(rqty);
        newDetailInfo.setIndependentQty(MRPConstant.ZERO);
        newDetailInfo.setNetReqQty(rqty);
        return newDetailInfo;
    }

    protected boolean isNotTrackNoIsolation(String planStrategy, IsolatedRuleEnum isolationRule, MRPDetailInfo newDetailInfo) {
        return !MRPPlanStrategyUtil.isTrackNoIsolation(planStrategy, isolationRule);
    }

    protected boolean isNotProjectNoIsolation(String planStrategy, MRPDetailInfo newDetailInfo) {
        return !MRPPlanStrategyUtil.isProjectNoIsolation(planStrategy);
    }

    protected BatchPolicyVO createBatchPolicyVO(MRPMaterialDataInfo materialDataInfo, int peroid, BigDecimal dayNetReqQty, BigDecimal dayReqQty, boolean isEndDay, BigDecimal netRequirementQty, MRPDetailInfo theLineInfo) {
        BatchPolicyVO data = new BatchPolicyVO();
        data.setMaterialNumber(materialDataInfo.getMaterialNumber());
        data.setCurrentPeriod(peroid);
        data.setSurPlusQty(dayNetReqQty);
        data.setDayReqQty(dayReqQty);
        data.setEndDay(isEndDay);
        data.setNetRequirementQty(netRequirementQty);
        data.setOrderLine(theLineInfo);
        data.setBatchIncQty(materialDataInfo.getBatchIncQty());
        data.setCycle(materialDataInfo.getCycle());
        data.setFixationBatchQty(materialDataInfo.getFixationBatchQty());
        data.setMaxBatchQty(materialDataInfo.getMaxBatchQty());
        data.setMinBatchQty(materialDataInfo.getMinBatchQty());
        data.setRoundUpMultipleQty(materialDataInfo.getRoundUpMultipleQty());
        if (theLineInfo != null) {
            if (10030 == materialDataInfo.getMaterialAttr() || 10050 == materialDataInfo.getMaterialAttr()) {
                BigDecimal yield = theLineInfo.getYield();
                if (yield == null) {
                    yield = new BigDecimal("100.00");
                }
                theLineInfo.setYield4PlanOrder(yield);
                if (this.runParam.isYieldproduct()) {
                    theLineInfo.setYield(yield);
                } else {
                    theLineInfo.setYield(new BigDecimal("100.00"));
                }
            } else {
                theLineInfo.setYield4PlanOrder(new BigDecimal("100.00"));
                theLineInfo.setYield(new BigDecimal("100.00"));
            }
        }
        data.setQtyPrc(materialDataInfo.getBaseQtyPrc());
        data.setPartitionQty(materialDataInfo.getPartitionQty());
        data.setStartPeroid(this.runParam.getPlanDate().getPeriod());
        data.setMaterialAttriBute(materialDataInfo.getMaterialAttr());
        return data;
    }

    private BigDecimal createPO4LastCycle(MRPMaterialDataInfo materialDataInfo, BigDecimal netReqQty, int period, boolean isMergeSign) throws EASBizException, BOSException {
        BatchPolicyVO batchPolicyVO = this.createBatchPolicyVO(materialDataInfo, period, netReqQty, netReqQty, false, netReqQty, null);
        FixedPeriodicbatchPolicy fixPeriodPilocy = (FixedPeriodicbatchPolicy)this.getBatchPolicy(materialDataInfo);
        BatchPolicyResult[] results = fixPeriodPilocy.createPO4LastCycle(batchPolicyVO);
        return this.getAvailQtyOnCreatePO(batchPolicyVO, materialDataInfo, netReqQty, results, null, isMergeSign);
    }

    protected BatchPolicy getBatchPolicy(MRPMaterialDataInfo materialDataInfo) {
        if (materialDataInfo.getiBatchPolicy() == null) {
            int policy = materialDataInfo.getBatchPolicy();
            if (materialDataInfo.isSurplusDivert()) {
                policy = 2;
            }
            materialDataInfo.setiBatchPolicy(BatchPolicyFactory.createInstance(policy, this.runParam));
        }
        return materialDataInfo.getiBatchPolicy();
    }

    private BigDecimal getAvailQtyOnCreatePO(BatchPolicyVO batchPolicyVO, MRPMaterialDataInfo materialDataInfo, BigDecimal netReqQty, BatchPolicyResult[] results, MRPDetailInfo theLineInfo, boolean isMergeSign) throws EASBizException, BOSException {
        if (results == null) {
            return netReqQty;
        }
        BigDecimal availableQty = netReqQty;
        MRPDetailInfo orderLine = null;
        MRPDate replanDate = null;
        BigDecimal yield = batchPolicyVO.getYield();
        BigDecimal avaliableSupply = null;
        int sPeroid = -1;
        for (int i = 0; i < results.length; ++i) {
            orderLine = (MRPDetailInfo)results[i].getOrderLine();
            if (orderLine == null) {
                orderLine = theLineInfo;
            }
            orderLine.setPeriod(results[i].getPeriod());
            orderLine.setPlannedQty(results[i].getQty());
            if (results[i].getException() != -1 && this.runParam.getExceptionUtil().setException(orderLine, results[i].getException())) {
                this.statisticException(materialDataInfo);
            }
            MRPDate date = this.runParam.getCalendarFactory().getDate(orderLine.getPeriod());
            if (i == 0) {
                replanDate = date;
            }
            if (sPeroid == -1) {
                sPeroid = date.getPeriod();
            }
            if (this.runParam.isCooperatePlan() || materialDataInfo.getMaterialAttr() == 10040) {
                Calendar tDate = MRPUtil.copyDate(replanDate.getDate());
                tDate.add(5, results[i].getPeriodOffset());
                date = this.runParam.getCalendarFactory().getDate(tDate.getTime(), true);
                date.setWorkDaySeqID(date.getPeriod());
            }
            yield = batchPolicyVO.getYield();
            if (!this.runParam.isCooperatePlan() && this.runParam.getPlanVersion().isIsYieldproduct() && yield != null) {
                yield = yield.divide(new BigDecimal("100.00"), 4, 3);
                BigDecimal temp = results[i].getQty();
                if (batchPolicyVO.getMaterialAttriBute() == 10030) {
                    temp = results[i].getQty().multiply(yield).setScale(8, 3);
                }
                avaliableSupply = temp.setScale(batchPolicyVO.getQtyPrc(), 3);
            } else {
                avaliableSupply = results[i].getQty().setScale(batchPolicyVO.getQtyPrc(), 3);
            }
            orderLine.setSperiod(orderLine.getPeriod());
            orderLine.setPeriod(sPeroid);
            this.createPlanOrder(materialDataInfo, netReqQty, avaliableSupply, date, replanDate, orderLine, isMergeSign);
            availableQty = availableQty.add(avaliableSupply);
        }
        return availableQty;
    }

    protected BigDecimal batchCal(MRPMaterialDataInfo materialDataInfo, int peroid, BigDecimal dayNetReqQty, BigDecimal dayReqQty, boolean isEndDay, BigDecimal netRequirementQty, MRPDetailInfo theLineInfo, boolean isMergeSign) throws EASBizException, BOSException {
        BatchPolicyVO batchPolicyVO = this.createBatchPolicyVO(materialDataInfo, peroid, dayNetReqQty, dayReqQty, isEndDay, netRequirementQty, theLineInfo);
        BatchPolicyResult[] results = this.getBatchPolicy(materialDataInfo).batchComputing(batchPolicyVO);
        return this.getAvailQtyOnCreatePO(batchPolicyVO, materialDataInfo, netRequirementQty, results, theLineInfo, isMergeSign);
    }

    private MRPDate getMRPDate(MRPDate orderDate, int leadTime, boolean isBackwards) throws BOSException {
        MRPDate result = new MRPDate();
        MRPDate date = MRPUtil.copyDate(orderDate);
        Calendar tDate = date.getDate();
        tDate.add(5, leadTime);
        result = this.runParam.getCalendarFactory().getDate(tDate.getTime(), isBackwards);
        date.setDate(tDate);
        if (date.getInCalendar() != 0) {
            tDate = Calendar.getInstance();
            tDate.setTime(date.getSourceDate());
            tDate.add(5, leadTime);
            date.setSourceDate(tDate.getTime());
        }
        if (date.getInCalendar() != 0) {
            result.setInCalendar(date.getInCalendar());
            result.setSourceDate(date.getSourceDate());
        }
        return result;
    }

    private boolean isNeedAjust(int period) {
        boolean isNeedAjust = true;
        if (!this.runParam.isCalNetting()) {
            return false;
        }
        int periodAdjust = this.runParam.getPlanDate().getPeriod() + this.runParam.getPlanVersion().getAdjustPeriod();
        if (period > periodAdjust) {
            isNeedAjust = false;
        }
        return isNeedAjust;
    }

    private MRPDetailInfo createStockReqDataInfo(MRPMaterialDataInfo materialDataInfo) {
        MRPDetailInfo stockReqDetailInfo = new MRPDetailInfo();
        stockReqDetailInfo.setBillDate(this.runParam.getPlanDate());
        stockReqDetailInfo.setPeriod(this.runParam.getPlanDate().getPeriod());
        stockReqDetailInfo.setScheduledReceiptQty(MRPConstant.ZERO);
        stockReqDetailInfo.setMrpClassify(MRPClassifyEnum.Requirement);
        stockReqDetailInfo.setMrpItem(MRPElementEnum.I_CurInv);
        stockReqDetailInfo.setBillNumber("");
        stockReqDetailInfo.setScheduledReceiptQty(MRPConstant.ZERO);
        stockReqDetailInfo.setIndependentQty(MRPConstant.ZERO);
        stockReqDetailInfo.setDependentQty(materialDataInfo.getOnHandQty(this.runParam.getProjectNumber(), this.runParam.getTrackNumber()));
        stockReqDetailInfo.setProjectNumber(this.runParam.getProjectNumber());
        stockReqDetailInfo.setTrackNumber(this.runParam.getTrackNumber());
        stockReqDetailInfo.setProjectID(this.runParam.getProjectID());
        stockReqDetailInfo.setTrackID(this.runParam.getTrackID());
        stockReqDetailInfo.setIsDeaultTNO(1);
        stockReqDetailInfo.setBProjectNumber(this.runParam.getProjectNumber());
        stockReqDetailInfo.setBTrackNumber(this.runParam.getTrackNumber());
        stockReqDetailInfo.setBProjectID(this.runParam.getProjectID());
        stockReqDetailInfo.setBTrackID(this.runParam.getTrackID());
        return stockReqDetailInfo;
    }

    private void setException4Stock(MRPMaterialDataInfo materialDataInfo, MRPMaterialStatisticsInfo materialStatisticsInfo) throws EASBizException, BOSException {
        BigDecimal p;
        if (materialDataInfo.getQtyMax().compareTo(MRPConstant.ZERO) >= 0 && (p = materialDataInfo.getOnHandQty(materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber())).compareTo(materialDataInfo.getQtyMax()) > 0 && ((Boolean)this.runParam.getException().get(String.valueOf(40))).booleanValue()) {
            MRPDetailInfo detailInfo = new MRPDetailInfo();
            detailInfo.setID(materialDataInfo.getInvDetailId(this.runParam, materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber()));
            if (this.runParam.getExceptionUtil().setException(detailInfo, 40)) {
                this.statisticException(materialDataInfo);
            }
            this.dataSaver.addUpdateStockException(detailInfo);
        }
        if (this.subtractSafeStockQty(materialDataInfo, materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber()).compareTo(MRPConstant.ZERO) < 0 && this.runParam.isSafeStock() && this.runParam.isIsAvailablStock()) {
            if (!this.underSafeStockIds.contains(materialDataInfo.getMaterialID())) {
                this.underSafeStockIds.add(materialDataInfo.getMaterialID());
                if (this.isContainMaterial(materialDataInfo)) {
                    logger.debug((Object)("under safeStock material Number: " + materialDataInfo.getMaterialNumber()));
                    this.runParam.underSafeQty();
                }
            }
            if (((Boolean)this.runParam.getException().get(String.valueOf(41))).booleanValue()) {
                MRPDetailInfo detailInfo = new MRPDetailInfo();
                detailInfo.setID(materialDataInfo.getInvDetailId(this.runParam, materialStatisticsInfo.getProjectNumber(), materialStatisticsInfo.getTrackNumber()));
                if (this.runParam.getExceptionUtil().setException(detailInfo, 41)) {
                    this.statisticException(materialDataInfo);
                }
                detailInfo.setDescription64(String.valueOf(41));
                this.dataSaver.addUpdateStockException(detailInfo);
            }
        }
    }

    private boolean isDefaultProjectAndTrackNumber(String projectNumber, String trackNumber) {
        return this.runParam.getProjectNumber().equals(projectNumber) && this.runParam.getTrackNumber().equals(trackNumber);
    }

    protected void createMaterialDataInfo(MRPMaterialDataInfo materialDataInfo) {
        if (this.materialDataInfo4Stock == null || !this.materialDataInfo4Stock.getMaterialID().equals(materialDataInfo.getMaterialID())) {
            this.materialDataInfo4Stock = (MRPMaterialDataInfo)materialDataInfo.clone();
            this.materialDataInfo4Stock.setOnHandQtyMap(null);
            Iterator onHandIter = materialDataInfo.getOnHandQtyMap().keySet().iterator();
            String key = null;
            BigDecimal stockQty = null;
            while (onHandIter.hasNext()) {
                key = (String)onHandIter.next();
                stockQty = (BigDecimal)materialDataInfo.getOnHandQtyMap().get(key);
                this.materialDataInfo4Stock.getOnHandQtyMap().put(key, stockQty);
            }
        }
    }

    protected boolean isHasNetReq(BigDecimal reqQty) {
        return reqQty.compareTo(MRPConstant.ZERO) < 0;
    }

    protected boolean isContainMaterial(MRPMaterialDataInfo materialDataInfo) {
        boolean isContainMaterial = false;
        if (MaterialRangeEnum.ALL.equals((Object)this.runParam.getRunLogInfo().getMateriaRange())) {
            return this.isContainMaterialByPlanMode(materialDataInfo);
        }
        if (MaterialRangeEnum.PUR.equals((Object)this.runParam.getRunLogInfo().getMateriaRange())) {
            if (materialDataInfo.getMaterialAttr() == 10040) {
                return this.isContainMaterialByPlanMode(materialDataInfo);
            }
        } else if (MrpRunEnum.MPS_Simulator.equals((Object)this.runParam.getRunLogInfo().getRunName()) || MrpRunEnum.MRP_Simulator.equals((Object)this.runParam.getRunLogInfo().getRunName())) {
            MRPRunMaterialEntryCollection mtlCol = this.runParam.getRunLogInfo().getMaterialEntry();
            MRPRunMaterialEntryInfo materialInfo = null;
            for (int i = 0; i < mtlCol.size(); ++i) {
                materialInfo = mtlCol.get(i);
                if (!materialDataInfo.getMaterialID().equals(materialInfo.getMaterial().getId().toString())) continue;
                return true;
            }
        } else {
            return true;
        }
        return isContainMaterial;
    }

    private boolean isContainMaterialByPlanMode(MRPMaterialDataInfo materialDataInfo) {
        boolean isContainMaterial = false;
        if (MrpRunEnum.MPS_GLOBAL.equals((Object)this.runParam.getRunLogInfo().getRunName()) || MrpRunEnum.MPS_Simulator.equals((Object)this.runParam.getRunLogInfo().getRunName())) {
            if (materialDataInfo.getPlanningMode() == 2) {
                return true;
            }
            if (materialDataInfo.getPlanningMode() == 3 && this.runParam.getRunLogInfo().isIsContainsMRPMaterial()) {
                return true;
            }
        }
        if ((MrpRunEnum.MRP_GLOBAL.equals((Object)this.runParam.getRunLogInfo().getRunName()) || MrpRunEnum.MRP_Simulator.equals((Object)this.runParam.getRunLogInfo().getRunName())) && materialDataInfo.getPlanningMode() == 3) {
            return true;
        }
        return isContainMaterial;
    }

    protected void statisticException(MRPMaterialDataInfo materialDataInfo) {
        if (this.isContainMaterial(materialDataInfo) && !this.materialException.contains(materialDataInfo.getMaterialID())) {
            this.materialException.add(materialDataInfo.getMaterialID());
            materialDataInfo.setHasExceptions(1);
            this.runParam.generateException();
        }
    }

    protected void statisticException(MRPDetailInfo detailInfo) {
        this.statisticException(this.materiaDataUtil.getMaterialInfo(detailInfo.getMaterialID()));
    }
}

