/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.AdjustStrategyEnum;
import com.kingdee.eas.mm.basedata.CollabPlanVersionInfo;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.planning.IMRPCalcFacade;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.MRPRunLogInfo;
import com.kingdee.eas.mm.planning.MRPRunMaterialEntryInfo;
import com.kingdee.eas.mm.planning.MrpRunEnum;
import com.kingdee.eas.mm.planning.app.mrp.MRPBillParamInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalendarFactory;
import com.kingdee.eas.mm.planning.app.mrp.MRPDate;
import com.kingdee.eas.mm.planning.app.mrp.MRPExceptionUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPHierarchyCodeGenerator;
import com.kingdee.eas.mm.planning.app.mrp.MRPPONumberGenerator;
import com.kingdee.eas.mm.planning.app.mrp.MRPRunStop;
import com.kingdee.eas.mm.planning.app.mrp.MRPSubstituteHelper;
import com.kingdee.util.LocaleUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MRPCalcParam {
    private String materialTableName;
    private String mrpCalcDetailTableName;
    private String mrpCalcExceptionTableName;
    private String invDetailTableName;
    private MRPRunLogInfo runLog;
    private MRPDate planDate;
    private MRPDate beginDate;
    private MRPDate endDate;
    private MRPDate beginDate4Require;
    private MRPDate beginDate4Supply;
    private Date runStartTime;
    private int level = 0;
    private int materialCount = 0;
    private int expMaterialCount = 0;
    private int underSaftQtyMaterialCount = 0;
    private int genOrderCount = 0;
    private int calculatedCount = 0;
    private int materailUpdateProgress = 0;
    private String currentStep = null;
    private MRPPONumberGenerator poNumberGen = null;
    private Context ctx;
    private int alwPeriod = 0;
    private int adjustPeriod = 0;
    private String statisticsTable = null;
    private int advanceType = 0;
    private String trackNumber = "     ";
    private String trackID = "iZWLs5RwQe6CEVd5I2L2lghumD0=";
    private String projectNumber = "     ";
    private String projectID = "F7InW/cZQ1iofHY+Qq1KnACyBQ4=";
    private HashMap exception = null;
    private int subFisrt = 1;
    private boolean isModifyOrder = false;
    private String productTranTypeID = null;
    private String calendarTable = null;
    private int maxCalendarWorkDaySeq = -1;
    private boolean isNeedUpdateResultTable = true;
    private List billParamInfoList;
    private boolean isNeedDeleteOperate = true;
    private String[] materialRangeIds;
    private Map billParamMap;
    private MRPCalendarFactory calendarFactory = null;
    private MRPHierarchyCodeGenerator hierarchyCodeGenerator = null;
    private MRPExceptionUtil exceptionUtil;
    private String mrpPlanOrder = null;
    private String mrpPlanOrderEntry = null;
    private MRPSubstituteHelper substituteHelper = null;
    public IMRPCalcFacade extendFacade = null;

    public IMRPCalcFacade getExtendFacade() {
        return this.extendFacade;
    }

    public void setExtendFacade(IMRPCalcFacade extendFacade) {
        this.extendFacade = extendFacade;
    }

    public MRPHierarchyCodeGenerator getHierarchyCodeGenerator() {
        return this.hierarchyCodeGenerator;
    }

    public void setHierarchyCodeGenerator(MRPHierarchyCodeGenerator hierarchyCodeGenerator) {
        this.hierarchyCodeGenerator = hierarchyCodeGenerator;
    }

    public int getSubFisrt() {
        return this.subFisrt;
    }

    public void setSubFisrt(int subFisrt) {
        this.subFisrt = subFisrt;
    }

    public String getCalendarTable() {
        return this.calendarTable;
    }

    public void setCalendarTable(String calendarTable) {
        this.calendarTable = calendarTable;
    }

    public String getTrackNumber() {
        return this.trackNumber;
    }

    public void setTrackNumber(String trackNumber) {
        this.trackNumber = trackNumber;
    }

    public String getTrackID() {
        return this.trackID;
    }

    public void setTrackID(String trackID) {
        this.trackID = trackID;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public void setProjectID(String projectID) {
        this.projectID = projectID;
    }

    public int getAdvanceType() {
        return this.advanceType;
    }

    public void setAdvanceType(int advanceType) {
        this.advanceType = advanceType;
    }

    public int getAlwPeriod() {
        return this.alwPeriod;
    }

    public void setAlwPeriod(int alwPeriod) {
        this.alwPeriod = alwPeriod;
    }

    public int getAdjustPeriod() {
        return this.adjustPeriod;
    }

    public void setAdjustPeriod(int adjustPeriod) {
        this.adjustPeriod = adjustPeriod;
    }

    public String getStatisticsTable() {
        return this.statisticsTable;
    }

    public void setStatisticsTable(String statisticsTable) {
        this.statisticsTable = statisticsTable;
    }

    public HashMap getException() {
        return this.exception;
    }

    public void setException(HashMap exception) {
        this.exception = exception;
    }

    public String getMaterialTableName() {
        return this.materialTableName;
    }

    public void setMaterialTableName(String materialTableName) {
        this.materialTableName = materialTableName;
    }

    public String getMrpCalcDetailTableName() {
        return this.mrpCalcDetailTableName;
    }

    public void setMrpCalcDetailTableName(String mrpCalcDetailTableName) {
        this.mrpCalcDetailTableName = mrpCalcDetailTableName;
    }

    public MRPRunLogInfo getRunLogInfo() {
        return this.runLog;
    }

    public void setRunLogInfo(MRPRunLogInfo runLog) {
        this.runLog = runLog;
    }

    public Context getCtx() throws BOSException, MRPException {
        if (MRPRunStop.getInstance(this.ctx, this.getStorageOrgUnitID()).isStop(this.ctx)) {
            throw new MRPException(MRPException.STOP_MRP);
        }
        return this.ctx;
    }

    public Context getCtx(boolean isEnd) {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public String getLocString() throws BOSException {
        return LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
    }

    public void setPlanDate(MRPDate planDate) {
        this.planDate = planDate;
    }

    public MRPDate getPlanDate() {
        return this.planDate;
    }

    public Date getBeginDate() {
        return this.getMRPBeginDate().getDate().getTime();
    }

    public Date getBeginDate(int type) {
        if (type == 0) {
            return this.getBeginDate4Require().getDate().getTime();
        }
        if (type == 1) {
            return this.getBeginDate4Supply().getDate().getTime();
        }
        return null;
    }

    public MRPDate getMRPBeginDate() {
        if (this.beginDate == null) {
            this.beginDate = new MRPDate();
            this.beginDate.setDate(Calendar.getInstance());
        }
        return this.beginDate;
    }

    public MRPDate getMRPBeginDate(int type) {
        if (type == 0) {
            return this.getBeginDate4Require();
        }
        if (type == 1) {
            return this.getBeginDate4Supply();
        }
        return null;
    }

    public void setMRPBeginDate(MRPDate beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.getMRPEndDate().getDate().getTime();
    }

    public MRPDate getMRPEndDate() {
        if (this.endDate == null) {
            this.endDate = new MRPDate();
            this.endDate.setDate(Calendar.getInstance());
        }
        return this.endDate;
    }

    public void setMRPEndDate(MRPDate endDate) {
        this.endDate = endDate;
        if (this.endDate != null && this.endDate.getDate() != null) {
            Calendar eDate = this.endDate.getDate();
            eDate.set(10, 23);
            eDate.set(12, 59);
            eDate.set(13, 59);
            eDate.set(14, 0);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isGloabalPlan() {
        return this.getRunLogInfo().getRunName().equals((Object)MrpRunEnum.MPS_GLOBAL) || this.getRunLogInfo().getRunName().equals((Object)MrpRunEnum.MRP_GLOBAL);
    }

    public boolean isMaterialPlan() {
        return this.getRunLogInfo().getRunName().equals((Object)MrpRunEnum.MPS_Material) || this.getRunLogInfo().getRunName().equals((Object)MrpRunEnum.MRP_Material);
    }

    public boolean isCooperatePlan() {
        return this.getRunLogInfo().getRunName().equals((Object)MrpRunEnum.COOPERATE_PLAN);
    }

    public boolean isTransform() {
        if (this.getRunLogInfo().getRunName().equals((Object)MrpRunEnum.MPS_Simulator) || this.getRunLogInfo().getRunName().equals((Object)MrpRunEnum.MRP_Simulator)) {
            return this.getRunLogInfo().isIsTransformPlannedOrder();
        }
        return true;
    }

    public MrpRunEnum getPlanType() {
        return this.getRunLogInfo().getRunName();
    }

    public String getStorageOrgUnitID() {
        return this.getRunLogInfo().getStorageOrgUnit().getId().toString();
    }

    public PlanVersionSetInfo getPlanVersion() {
        return this.getRunLogInfo().getPlanVersion();
    }

    public CollabPlanVersionInfo getCPlanVersion() {
        return this.getRunLogInfo().getCplanVersion();
    }

    public String getPlanVersionNumber() {
        if (this.isCooperatePlan()) {
            return this.getRunLogInfo().getCplanVersion().getNumber();
        }
        return this.getRunLogInfo().getPlanVersion().getNumber();
    }

    public boolean isCalNetting() {
        if (this.isCooperatePlan()) {
            return true;
        }
        return this.getPlanVersion().isIsCalNetting();
    }

    public boolean isSafeStock() {
        if (this.isCooperatePlan()) {
            return true;
        }
        return this.getPlanVersion().isIsSafeStock();
    }

    public boolean isWastageRate() {
        if (this.isCooperatePlan()) {
            return false;
        }
        return this.getPlanVersion().isIsWastageRate();
    }

    public boolean isYieldproduct() {
        if (this.isCooperatePlan()) {
            return false;
        }
        return this.getPlanVersion().isIsYieldproduct();
    }

    public boolean isIsAvailablStock() {
        if (this.isCooperatePlan()) {
            return this.getRunLogInfo().getCplanVersion().getEntrys().get(0).isIsCareAvailStock();
        }
        return this.getPlanVersion().isIsCurInv();
    }

    public boolean isCareScheduleRec() {
        if (this.isCooperatePlan()) {
            return this.getRunLogInfo().getCplanVersion().getEntrys().get(0).isIsCareScheduleRec();
        }
        return this.isCalNetting();
    }

    public boolean isReplaceCon() {
        if (this.isCooperatePlan() || this.isMaterialPlan()) {
            return false;
        }
        return this.getPlanVersion().isIsReplaceCon();
    }

    public String getPlanVersionID() {
        if (this.getRunLogInfo().getCplanVersion() != null) {
            return this.getRunLogInfo().getCplanVersion().getId().toString();
        }
        return this.getRunLogInfo().getPlanVersion().getId().toString();
    }

    public String getRunLogID() {
        return this.getRunLogInfo().getId().toString();
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public void setMaterialCount(int materialCount) {
        this.materialCount = materialCount;
    }

    public synchronized boolean needUpdateCalcProgress() {
        boolean ret = false;
        ++this.calculatedCount;
        int p = this.calculatedCount * 100 / this.materialCount / 5;
        if (p > this.materailUpdateProgress) {
            this.materailUpdateProgress = p;
            ret = true;
        }
        return ret;
    }

    public synchronized boolean needUpdateCalcProgress(int count) {
        boolean ret = false;
        this.calculatedCount += count;
        int p = this.calculatedCount * 100 / this.materialCount / 5;
        if (p > this.materailUpdateProgress) {
            this.materailUpdateProgress = p;
            ret = true;
        }
        return ret;
    }

    public synchronized void generateException() {
        ++this.expMaterialCount;
    }

    public synchronized void underSafeQty() {
        ++this.underSaftQtyMaterialCount;
    }

    public synchronized void generateOrder() {
        ++this.genOrderCount;
    }

    public synchronized void setGenOrderCount(int genOrderCount) {
        this.genOrderCount = genOrderCount;
    }

    public int getExpMaterialCount() {
        return this.expMaterialCount;
    }

    public int getUnderSaftQtyMaterialCount() {
        return this.underSaftQtyMaterialCount;
    }

    public synchronized int getGenOrderCount() {
        return this.genOrderCount;
    }

    public String getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(String currentStep) {
        this.currentStep = currentStep;
    }

    public Date getRunStartTime() {
        return this.runStartTime;
    }

    public void setRunStartTime(Date runStartTime) {
        this.runStartTime = runStartTime;
    }

    public String getMrpCalcExceptionTableName() {
        return this.mrpCalcExceptionTableName;
    }

    public void setMrpCalcExceptionTableName(String mrpCalcExceptionTableName) {
        this.mrpCalcExceptionTableName = mrpCalcExceptionTableName;
    }

    protected boolean isModifyOrder() {
        return this.isModifyOrder;
    }

    protected void setModifyOrder(boolean isModifyOrder) {
        this.isModifyOrder = isModifyOrder;
    }

    public synchronized String getPONumber() throws EASBizException, BOSException {
        if (this.poNumberGen == null) {
            this.poNumberGen = new MRPPONumberGenerator(this);
        }
        return this.poNumberGen.getNumber();
    }

    public synchronized void recyclePONumber() throws EASBizException, BOSException {
        if (this.poNumberGen != null) {
            this.poNumberGen.recycleNumbers();
        }
    }

    public String getProductTranTypeID() {
        return this.productTranTypeID;
    }

    public void setProductTranTypeID(String productTranTypeID) {
        this.productTranTypeID = productTranTypeID;
    }

    public boolean isEnabelBill(String billType) {
        MRPBillParamInfo info = (MRPBillParamInfo)this.billParamMap.get(billType);
        return info != null;
    }

    public boolean isEnabelBillBiztype(String billType, String bizType) {
        MRPBillParamInfo info = (MRPBillParamInfo)this.billParamMap.get(billType);
        for (int i = 0; i < info.getBizTypeIdArray().length; ++i) {
            if (!info.getBizTypeIdArray()[i].equals(bizType)) continue;
            return true;
        }
        return false;
    }

    public AdjustStrategyEnum getAdjustStrategy(String billTypeId) {
        MRPBillParamInfo info = (MRPBillParamInfo)this.billParamMap.get(billTypeId);
        if (info.getAdjustStrategy() == null) {
            info.setAdjustStrategy(AdjustStrategyEnum.NULL);
        }
        return info.getAdjustStrategy();
    }

    public boolean isNeedUpdateResultTable() {
        return this.isNeedUpdateResultTable;
    }

    public void setNeedUpdateResultTable(boolean isNeedUpdateResultTable) {
        this.isNeedUpdateResultTable = isNeedUpdateResultTable;
    }

    public List getBillParamInfoList() {
        return this.billParamInfoList;
    }

    public void setBillParamInfoList(List billParamInfoList) {
        this.billParamInfoList = billParamInfoList;
    }

    public boolean isNeedDeleteOperate() {
        return this.isNeedDeleteOperate;
    }

    public void setNeedDeleteOperate(boolean isNeedDeleteOperate) {
        this.isNeedDeleteOperate = isNeedDeleteOperate;
    }

    public String getInvDetailTableName() {
        return this.invDetailTableName;
    }

    public void setInvDetailTableName(String invDetailTableName) {
        this.invDetailTableName = invDetailTableName;
    }

    public String[] getMaterialRangeIds() {
        if (this.materialRangeIds != null) {
            return this.materialRangeIds;
        }
        this.materialRangeIds = new String[this.getRunLogInfo().getMaterialEntry().size()];
        for (int i = 0; i < this.getRunLogInfo().getMaterialEntry().size(); ++i) {
            MRPRunMaterialEntryInfo info = this.getRunLogInfo().getMaterialEntry().get(i);
            this.materialRangeIds[i] = info.getMaterial().getId().toString();
        }
        return this.materialRangeIds;
    }

    public Map getBillParamMap() {
        return this.billParamMap;
    }

    public void setBillParamMap(Map billParamMap) {
        this.billParamMap = billParamMap;
    }

    public MRPDate getBeginDate4Require() {
        return this.beginDate4Require;
    }

    public void setBeginDate4Require(MRPDate beginDate4Require) {
        this.beginDate4Require = beginDate4Require;
    }

    public MRPDate getBeginDate4Supply() {
        return this.beginDate4Supply;
    }

    public void setBeginDate4Supply(MRPDate beginDate4Supply) {
        this.beginDate4Supply = beginDate4Supply;
    }

    public int getMaxCalendarWorkDaySeq() {
        return this.maxCalendarWorkDaySeq;
    }

    public void setMaxCalendarWorkDaySeq(int maxCalendarWorkDaySeq) {
        this.maxCalendarWorkDaySeq = maxCalendarWorkDaySeq;
    }

    public MRPCalendarFactory getCalendarFactory() {
        return this.calendarFactory;
    }

    public void setCalendarFactory(MRPCalendarFactory calendarFactory) {
        this.calendarFactory = calendarFactory;
    }

    public MRPExceptionUtil getExceptionUtil() {
        return this.exceptionUtil;
    }

    public void setExceptionUtil(MRPExceptionUtil exceptionUtil) {
        this.exceptionUtil = exceptionUtil;
    }

    public String getMrpPlanOrder() {
        return this.mrpPlanOrder;
    }

    public void setMrpPlanOrder(String mrpPlanOrder) {
        this.mrpPlanOrder = mrpPlanOrder;
    }

    public String getMrpPlanOrderEntry() {
        return this.mrpPlanOrderEntry;
    }

    public void setMrpPlanOrderEntry(String mrpPlanOrderEntry) {
        this.mrpPlanOrderEntry = mrpPlanOrderEntry;
    }

    public MRPSubstituteHelper getSubstituteHelper() {
        return this.substituteHelper;
    }

    public void setSubstituteHelper(MRPSubstituteHelper substituteHelper) {
        this.substituteHelper = substituteHelper;
    }

    public String getCreatorID() {
        return this.getRunLogInfo().getCreator().getId().toString();
    }
}

