/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.app.mrp.MRPDate;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MRPCalendarFactory {
    private Context ctx = null;
    private int firstYear = 10000;
    private int lastYear = -1;
    private int maxWorkDaySeq = 0;
    private int firstWorkDaySeq = -1;
    private int lastWorkDaySeq = -1;
    private Map workDaySeqs = null;
    private Date[] workDays = null;
    private Map freedateMap = null;
    private Map freedateBackwardsMap = null;
    private String orgId = null;
    private Date maxDate = null;
    private Date minDate = null;

    public MRPCalendarFactory(Context ctx, String orgId) throws BOSException {
        this.ctx = ctx;
        this.orgId = orgId;
        this.workDaySeqs = new HashMap();
        this.workDays = new Date[0];
        this.freedateMap = new HashMap();
        this.freedateBackwardsMap = new HashMap();
        this.initData(true);
    }

    private synchronized void initData(boolean isNext) throws BOSException {
        IRowSet rows;
        StringBuffer sql = new StringBuffer();
        if (this.maxWorkDaySeq == 0) {
            sql.append("select max(t0.FWorkDateSeq) from t_mm_factorycalendarentry t0 inner join ");
            sql.append("t_mm_factoryCalendar t1 on t0.FParentID = t1.FID ");
            sql.append("where t1.FStorageOrgUnitID = '");
            sql.append(this.orgId);
            sql.append("' and t1.FIsDefault=1");
            rows = SQLUtils.executeQuery((Context)this.ctx, (String)sql.toString());
            try {
                if (rows.next()) {
                    this.maxWorkDaySeq = rows.getInt(1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sql.setLength(0);
        sql.append("select t0.FWorkDate, t0.FWorkDateSeq, t0.FNextWorkDaySeq, t0.FPreWorkDaySeq, t0.FYearSeq ");
        sql.append("from t_mm_factorycalendarentry t0 inner join ");
        sql.append("t_mm_factoryCalendar t1 on t0.FParentID = t1.FID ");
        sql.append("where t1.FStorageOrgUnitID = '");
        sql.append(this.orgId);
        sql.append("' and t1.FIsDefault=1 and ");
        if (this.firstYear == 10000) {
            sql.append(" year(t0.FWorkDate) =  ").append(Calendar.getInstance().get(1));
        } else if (isNext) {
            sql.append(" t0.FYearSeq = ").append(this.lastYear);
        } else {
            sql.append(" t0.FYearSeq = ").append(this.firstYear);
        }
        sql.append(" order by t0.FSeq");
        rows = SQLUtils.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            java.sql.Date date = null;
            int workSeq = -1;
            int nextSeq = -1;
            int preSeq = -1;
            ArrayList<java.sql.Date> currentDates = new ArrayList<java.sql.Date>();
            while (rows.next()) {
                date = rows.getDate("FWorkDate");
                workSeq = rows.getInt("FWorkDateSeq");
                nextSeq = rows.getInt("FNextWorkDaySeq");
                preSeq = rows.getInt("FPreWorkDaySeq");
                if (this.firstYear == 10000) {
                    this.lastYear = this.firstYear = rows.getInt("FYearSeq");
                }
                if (workSeq != 0) {
                    if (workSeq > this.lastWorkDaySeq) {
                        this.lastWorkDaySeq = workSeq;
                    }
                    if (workSeq < this.firstWorkDaySeq || this.firstWorkDaySeq == -1) {
                        this.firstWorkDaySeq = workSeq;
                    }
                    this.workDaySeqs.put(date, new Integer(workSeq));
                    currentDates.add(date);
                } else {
                    int temp = nextSeq == 0 ? preSeq : nextSeq;
                    this.freedateMap.put(date, new Integer(temp));
                    int preWorkDaySeq = preSeq == 0 ? nextSeq : preSeq;
                    this.freedateBackwardsMap.put(date, new Integer(preWorkDaySeq));
                }
                if (workSeq == this.maxWorkDaySeq) {
                    this.maxDate = date;
                }
                if (workSeq != 1) continue;
                this.minDate = date;
            }
            Date[] temps = this.workDays;
            this.workDays = new Date[temps.length + currentDates.size()];
            if (isNext) {
                System.arraycopy(temps, 0, this.workDays, 0, temps.length);
                System.arraycopy(currentDates.toArray(), 0, this.workDays, temps.length, currentDates.size());
            } else {
                System.arraycopy(currentDates.toArray(), 0, this.workDays, 0, currentDates.size());
                System.arraycopy(temps, 0, this.workDays, currentDates.size(), temps.length);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private int getWorkDayIndex(int workDaySeq) {
        return workDaySeq - this.firstWorkDaySeq;
    }

    public MRPDate getDate(int workDaySeq) throws BOSException {
        return this.getDate(workDaySeq, null);
    }

    public synchronized MRPDate getDate(int workDaySeq, Date sourceDate) throws BOSException {
        Calendar calendar = Calendar.getInstance();
        MRPDate date = new MRPDate();
        date.setPeriod(workDaySeq);
        date.setWorkDaySeqID(workDaySeq);
        if (workDaySeq > this.lastWorkDaySeq) {
            while (workDaySeq > this.lastWorkDaySeq && this.maxWorkDaySeq > this.lastWorkDaySeq) {
                this.getNextYearCalendar();
            }
        }
        if (workDaySeq < this.firstWorkDaySeq) {
            while (workDaySeq < this.firstWorkDaySeq && this.firstWorkDaySeq > 1) {
                this.getPreYearCalendar();
            }
        }
        if (workDaySeq > this.maxWorkDaySeq) {
            Date time = this.workDays[this.workDays.length - 1];
            calendar.setTime(time);
            date.setDate(calendar);
            date.setInCalendar(1);
            date.setPeriod(this.maxWorkDaySeq);
            date.setWorkDaySeqID(this.maxWorkDaySeq);
            this.calcOldDate(date, workDaySeq - this.maxWorkDaySeq + 1, sourceDate);
            return date;
        }
        if (workDaySeq <= 0 || workDaySeq - this.firstWorkDaySeq < 0) {
            workDaySeq = workDaySeq <= 0 ? workDaySeq - 1 : workDaySeq - this.firstWorkDaySeq;
            calendar.setTime(this.workDays[0]);
            date.setDate(calendar);
            date.setInCalendar(-1);
            date.setPeriod(1);
            date.setWorkDaySeqID(1);
            this.calcOldDate(date, workDaySeq, sourceDate);
            return date;
        }
        int index = this.getWorkDayIndex(workDaySeq);
        calendar.setTime(this.workDays[index]);
        date.setDate(calendar);
        if (sourceDate != null) {
            date.setSourceDate(sourceDate);
            date.setInCalendar(-1);
        }
        return date;
    }

    public synchronized MRPDate getDate(Date date, boolean isBackwards) throws BOSException {
        int seq = this.getWorkDaySeq(date, isBackwards);
        Date tempDate = null;
        if (seq == 0 || seq == this.maxWorkDaySeq + 1) {
            tempDate = date;
            seq = seq == 0 ? 1 : this.maxWorkDaySeq;
        }
        return this.getDate(seq, tempDate);
    }

    private void calcOldDate(MRPDate date, int offset, Date sourceDate) {
        if (sourceDate != null) {
            date.setSourceDate(sourceDate);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date.getDate().getTime());
        calendar.add(5, offset);
        date.setSourceDate(calendar.getTime());
    }

    public synchronized int getWorkDaySeq(Date date, boolean isBackwards) throws BOSException {
        Date reqDate = this.setDate(date);
        Integer seq = null;
        seq = isBackwards ? (Integer)this.freedateBackwardsMap.get(reqDate) : (Integer)this.freedateMap.get(reqDate);
        if (seq == null) {
            seq = (Integer)this.workDaySeqs.get(reqDate);
        }
        if (seq != null) {
            return seq;
        }
        if (this.maxDate != null && reqDate.after(this.workDays[this.workDays.length - 1])) {
            return this.maxWorkDaySeq + 1;
        }
        if (this.minDate != null && reqDate.before(this.workDays[0])) {
            return 0;
        }
        if (reqDate.after(this.workDays[this.workDays.length - 1])) {
            this.getNextYearCalendar();
            return this.getWorkDaySeq(date, isBackwards);
        }
        this.getPreYearCalendar();
        return this.getWorkDaySeq(date, isBackwards);
    }

    private synchronized void getNextYearCalendar() throws BOSException {
        if (this.lastWorkDaySeq >= this.maxWorkDaySeq) {
            return;
        }
        ++this.lastYear;
        this.initData(true);
    }

    private synchronized void getPreYearCalendar() throws BOSException {
        if (this.firstWorkDaySeq <= 0) {
            return;
        }
        --this.firstYear;
        if (this.firstYear <= 0) {
            return;
        }
        this.initData(false);
    }

    private Date setDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

