/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.ReqPlanForMRP;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import java.util.ArrayList;

public abstract class MRPClearPlanOrder
extends MRPStep {
    protected int dataAmount = 0;

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        return MRPResource.getString(runParam.getCtx(), "SP_CLEARRUNNINGTABLE");
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        this.reqPlanHandle();
        return null;
    }

    protected void reqPlanHandle() throws BOSException, MRPException {
        if (!this.runParam.isTransform() || this.runParam.isCooperatePlan()) {
            return;
        }
        ReqPlanForMRP reqPlan = new ReqPlanForMRP();
        TempTablePool pool = TempTablePool.getInstance((Context)this.runParam.getCtx());
        String tableName = null;
        try {
            tableName = pool.createTempTable(reqPlan.getTalbeStringForMRP());
            MRPUtil.executeUpdate(this.runParam.getCtx(), this.getReqConsumeStr(tableName), this.getParamArray());
            if (!MRPDynamicTableManager.isEmptyTable(this.runParam.getCtx(), tableName)) {
                reqPlan.receiveData(this.runParam.getCtx(), tableName, ReqPlanForMRP.actionTypeDelete, this.runParam.getStorageOrgUnitID());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!MMUtils.isEmptyString(tableName)) {
                pool.releaseTable(tableName);
            }
        }
    }

    protected String getReqConsumeStr(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tableName).append(" select newbosid('12345678'),t1.fid,t1.FNumber,t2.fid,t2.FMaterialID,").append("t2.FProvideType,t2.FissMode,t2.FStorageOrgUnitID,").append("'").append(this.runParam.getStorageOrgUnitID()).append("',").append("t2.FDemandQty,t2.FbaseDemandQty,t2.FUnitId,t2.FBaseUnitId,1,").append("t2.FReqDate,t2.FSeq,t1.FProjectId, t1.FTrackId ").append("from t_mm_plannedorder t1 inner join t_mm_plannedorderentry t2").append(" on t1.Fid = t2.FParentId ");
        sql.append(" inner join ").append(this.runParam.getMaterialTableName()).append(" t3 on t1.FMaterialId = t3.FMaterialId ");
        sql.append(" inner join t_bd_materialPlan t4  on t2.FMaterialId = t4.FMaterialId ").append(" and t4.FOrgUnit='").append(this.runParam.getStorageOrgUnitID()).append("' ");
        sql.append(" where t1.FBaseStatus in (1,2) and t1.FStorageOrgUnitID = ? and t1.FIsSimulant=0 ").append("and t4.FisComReqConsume = 1 and ");
        sql.append(" t4.FProvideType in (").append(10910).append(",").append(10920).append(") ");
        return sql.toString();
    }

    protected Object[] getParamArray() {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(this.runParam.getStorageOrgUnitID());
        return paramList.toArray();
    }

    @Override
    protected int getDataAmount() {
        return this.dataAmount;
    }

    protected void setDataAmount(int dataAmount) {
        this.dataAmount = dataAmount;
    }
}

