/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.mm.basedata.PlanTypeEnum;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPDynamicTableManager;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class MRPClearRunningTable
extends MRPStep {
    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        return MRPResource.getString(runParam.getCtx(), "SP_CLEARRUNNINGTABLE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        Statement statement;
        Connection conn;
        block23: {
            conn = null;
            statement = null;
            String sql = "";
            String runPlanMode = "MRP";
            String inTempTableName = null;
            if ("MRP".equals(runPlanMode)) {
                sql = "select * into mrptemp1 from " + runParam.getMrpCalcDetailTableName() + " where FPlanningMode = 2";
                try {
                    CreateTempTableResult result = MRPUtil.executeCreateAsSelectInto(runParam.getCtx(), sql, null);
                    inTempTableName = result.getTempTable();
                }
                catch (Exception e1) {
                    throw new BOSException((Throwable)e1);
                }
            }
            try {
                block25: {
                    block24: {
                        String planVer;
                        Map.Entry entry;
                        conn = EJBFactory.getConnection((Context)runParam.getCtx());
                        statement = conn.createStatement();
                        if (!runParam.isGloabalPlan()) break block24;
                        Map mrpTables = MRPDynamicTableManager.getStorageOrgTables(runParam.getCtx(), runParam.getStorageOrgUnitID());
                        Iterator it = mrpTables.entrySet().iterator();
                        if ("ALL".equals(runPlanMode)) {
                            while (it.hasNext()) {
                                entry = it.next();
                                Map value = (Map)entry.getValue();
                                sql = "truncate table " + value.get("material");
                                statement.addBatch(sql);
                                sql = "truncate table " + value.get("detail");
                                statement.addBatch(sql);
                            }
                        }
                        if ("MPS".equals(runPlanMode)) {
                            while (it.hasNext()) {
                                entry = it.next();
                                planVer = (String)entry.getKey();
                                Map value = (Map)entry.getValue();
                                if (planVer.equals("901")) {
                                    sql = "delete from " + value.get("material") + " where FPlanningMode = 2 ";
                                    statement.addBatch(sql);
                                    sql = "delete from " + value.get("detail") + " where FPlanningMode = 2 ";
                                    statement.addBatch(sql);
                                    continue;
                                }
                                sql = "truncate table " + value.get("material");
                                statement.addBatch(sql);
                                sql = "truncate table " + value.get("detail");
                                statement.addBatch(sql);
                            }
                            break block25;
                        } else if ("MRP".equals(runPlanMode)) {
                            while (it.hasNext()) {
                                entry = it.next();
                                planVer = (String)entry.getKey();
                                if (planVer.equals("900")) continue;
                                Map value = (Map)entry.getValue();
                                sql = planVer.equals("901") ? "delete from " + value.get("material") + " where FPlanningMode = 3 " : "truncate table " + value.get("material");
                                statement.addBatch(sql);
                                sql = "truncate table " + value.get("detail");
                                statement.addBatch(sql);
                            }
                        }
                        break block25;
                    }
                    if ("ALL".equals(runPlanMode)) {
                        sql = "truncate table " + runParam.getMaterialTableName();
                        statement.addBatch(sql);
                        sql = "truncate table " + runParam.getMrpCalcDetailTableName();
                        statement.addBatch(sql);
                    } else if ("MPS".equals(runPlanMode)) {
                        sql = "truncate table " + runParam.getMaterialTableName();
                        statement.addBatch(sql);
                        sql = "truncate table " + runParam.getMrpCalcDetailTableName();
                        statement.addBatch(sql);
                    } else if ("MRP".equals(runPlanMode)) {
                        sql = "delete from " + runParam.getMaterialTableName() + " where FPlanningMode=3 ";
                        statement.addBatch(sql);
                        sql = "truncate table " + runParam.getMrpCalcDetailTableName();
                        statement.addBatch(sql);
                    }
                }
                if (inTempTableName != null && !runParam.isCooperatePlan()) {
                    sql = "insert into " + runParam.getMrpCalcDetailTableName() + " select * from " + inTempTableName;
                    statement.addBatch(sql);
                }
                statement.executeBatch();
                if (inTempTableName == null) break block23;
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    if (inTempTableName != null) {
                        TempTablePool pool = TempTablePool.getInstance((Context)runParam.getCtx());
                        pool.releaseTable(inTempTableName);
                    }
                    SQLUtils.cleanup((Statement)statement, (Connection)conn);
                    throw throwable;
                }
            }
            TempTablePool pool = TempTablePool.getInstance((Context)runParam.getCtx());
            pool.releaseTable(inTempTableName);
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
        if (!runParam.isCooperatePlan()) {
            this.deletePlanOrder();
        }
        return null;
    }

    private void deletePlanOrder() throws EASBizException, BOSException {
        StringBuffer sqlDel = new StringBuffer();
        StringBuffer sqlDelEntry = new StringBuffer();
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (this.runParam.isGloabalPlan()) {
            if (this.runParam.getPlanVersion().getPlanType().equals((Object)PlanTypeEnum.MRP) && this.runParam.getRunLogInfo().isIsContainsMRPMaterial()) {
                sqlDel.append("delete t_mm_plannedorder ").append("where FBaseStatus in(1,2) ").append("and FStorageOrgUnitID = ? ").append("and FSchemeID is not null ");
                sqlDelEntry.append("delete t_mm_plannedorderentry ").append("where FParentid in ( ").append("select fid from t_mm_plannedorder ").append("where FBaseStatus in(1,2) ").append("and FStorageOrgUnitID = ? ").append("and FSchemeID is not null ").append(") ");
                paramList.add(this.runParam.getStorageOrgUnitID());
            } else if (this.runParam.getPlanVersion().getPlanType().equals((Object)PlanTypeEnum.MPS)) {
                sqlDel.append("delete t_mm_plannedorder ").append("where FBaseStatus in(1,2) ").append("and FMaterialID in (select t3.FMaterialID from T_BD_MaterialPlan t3 where t3.FOrgUnit= ? and t3.FPlanningMode = ?) ").append("and FStorageOrgUnitID = ? ").append("and FSchemeID is not null ");
                sqlDelEntry.append("delete t_mm_plannedorderentry ").append("where FParentid in ( ").append("select fid from t_mm_plannedorder ").append("where FBaseStatus in(1,2) ").append("and FMaterialID in (select t3.FMaterialID from T_BD_MaterialPlan t3 where t3.FOrgUnit= ? and t3.FPlanningMode = ?) ").append("and FStorageOrgUnitID = ? ").append("and FSchemeID is not null ").append(") ");
                paramList.add(this.runParam.getStorageOrgUnitID());
                paramList.add(new Integer(2));
                paramList.add(this.runParam.getStorageOrgUnitID());
            } else {
                sqlDel.append("delete t_mm_plannedorder ").append("where FSchemeID in (select t1.FID from T_MM_PlanVersionSet t1 where t1.fnumber < '900' or t1.fnumber = ?) ").append("and FBaseStatus in(1,2) ").append("and FMaterialID in (select t3.FMaterialID from T_BD_MaterialPlan t3 where t3.FOrgUnit= ? and t3.FPlanningMode = ?) ").append("and FStorageOrgUnitID = ? ");
                sqlDelEntry.append("delete t_mm_plannedorderentry ").append("where FParentid in ( ").append("select fid from t_mm_plannedorder ").append("where FSchemeID in (select t1.FID from T_MM_PlanVersionSet t1 where t1.fnumber < '900' or t1.fnumber = ?) ").append("and FBaseStatus in(1,2) ").append("and FMaterialID in (select t3.FMaterialID from T_BD_MaterialPlan t3 where t3.FOrgUnit= ? and t3.FPlanningMode = ?) ").append("and FStorageOrgUnitID = ? ").append(") ");
                paramList.add("901");
                paramList.add(this.runParam.getStorageOrgUnitID());
                paramList.add(new Integer(3));
                paramList.add(this.runParam.getStorageOrgUnitID());
            }
        } else if (this.runParam.getPlanVersion().getPlanType().equals((Object)PlanTypeEnum.MRP) && this.runParam.getRunLogInfo().isIsContainsMRPMaterial()) {
            sqlDel.append("delete t_mm_plannedorder ").append("where FBaseStatus in(1,2) ").append("and FStorageOrgUnitID = ? ").append("and FSchemeID = ? ");
            sqlDelEntry.append("delete t_mm_plannedorderentry ").append("where FParentid in (").append("select fid from t_mm_plannedorder ").append("where FBaseStatus in(1,2) ").append("and FStorageOrgUnitID = ? ").append("and FSchemeID = ? ").append(") ");
            paramList.add(this.runParam.getStorageOrgUnitID());
            paramList.add(this.runParam.getPlanVersionID());
        } else {
            sqlDel.append("delete t_mm_plannedorder ").append("where FBaseStatus in(1,2) ").append("and FMaterialID in (select t3.FMaterialID from T_BD_MaterialPlan t3 where t3.FOrgUnit= ? and t3.FPlanningMode = ?) ").append("and FStorageOrgUnitID = ? ").append("and FSchemeID = ? ");
            sqlDelEntry.append("delete t_mm_plannedorderentry ").append("where FParentid in ( ").append("select fid from t_mm_plannedorder ").append("where FBaseStatus in(1,2) ").append("and FMaterialID in (select t3.FMaterialID from T_BD_MaterialPlan t3 where t3.FOrgUnit= ? and t3.FPlanningMode = ?) ").append("and FStorageOrgUnitID = ? ").append("and FSchemeID = ? ").append(") ");
            paramList.add(this.runParam.getStorageOrgUnitID());
            if (this.runParam.getPlanVersion().getPlanType().equals((Object)PlanTypeEnum.MPS)) {
                paramList.add(new Integer(2));
            } else {
                paramList.add(new Integer(3));
            }
            paramList.add(this.runParam.getStorageOrgUnitID());
            paramList.add(this.runParam.getPlanVersionID());
        }
        if (!this.runParam.getPlanType().equals(PlanTypeEnum.CMRP)) {
            int deleteentryCount = MRPUtil.executeUpdate(this.runParam.getCtx(), sqlDelEntry.toString(), paramList.toArray());
            int deleteCount = MRPUtil.executeUpdate(this.runParam.getCtx(), sqlDel.toString(), paramList.toArray());
            this.logInfo("delete plan order count:" + String.valueOf(deleteCount) + ". delete plan order entry count:" + String.valueOf(deleteentryCount));
        }
    }

    private void deleteCPlanOrder() throws EASBizException, BOSException {
        StringBuffer sqlDel = new StringBuffer();
        StringBuffer sqlDelEntry = new StringBuffer();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(this.runParam.getStorageOrgUnitID());
        sqlDel.append("delete T_MM_CooperatePlanOrder ").append("where FBaseStatus in(1,2) ").append("and FStorageOrgUnitID = ? ").append("and FCoPlanVersionID is not null ");
        sqlDelEntry.append("delete T_MM_CooperatePlanOrderEntry ").append("where FParentid in ( ").append("select fid from T_MM_CooperatePlanOrder ").append("where FBaseStatus in(1,2) ").append("and FStorageOrgUnitID = ? ").append("and FCoPlanVersionID is not null ").append(") ");
        int deleteentryCount = MRPUtil.executeUpdate(this.runParam.getCtx(), sqlDelEntry.toString(), paramList.toArray());
        int deleteCount = MRPUtil.executeUpdate(this.runParam.getCtx(), sqlDel.toString(), paramList.toArray());
        this.logInfo("delete cplan order count:" + String.valueOf(deleteCount) + ". delete cplan order entry count:" + String.valueOf(deleteentryCount));
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }
}

