/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import java.util.Calendar;
import java.util.Date;

public class MRPDate {
    private Calendar date;
    private String calendarID;
    private int workDaySeqID = 0;
    private int weekSeqID = 0;
    private int monthSeqID = 0;
    private int period = 0;
    private int inCalendar = 0;
    private Date sourceDate;

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public Calendar getDate() {
        return this.date;
    }

    public int getWorkDaySeqID() {
        return this.workDaySeqID;
    }

    public int getWeekSeqID() {
        return this.weekSeqID;
    }

    public int getMonthSeqID() {
        return this.monthSeqID;
    }

    public String getCalendarID() {
        return this.calendarID;
    }

    public void setCalendarID(String calendarID) {
        this.calendarID = calendarID;
    }

    public void setDate(Calendar date) {
        this.date = date;
        this.date.set(11, 0);
        this.date.set(12, 0);
        this.date.set(13, 0);
        this.date.set(14, 0);
    }

    public void setWorkDaySeqID(int workDaySeqID) {
        this.workDaySeqID = workDaySeqID;
    }

    public void setWeekSeqID(int weekSeqID) {
        this.weekSeqID = weekSeqID;
    }

    public void setMonthSeqID(int monthSeqID) {
        this.monthSeqID = monthSeqID;
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    public MRPDate dateCopy() {
        Calendar d2 = MRPUtil.createCalendar();
        d2.set(this.date.get(1), this.date.get(2), this.date.get(5));
        MRPDate newDate = new MRPDate();
        newDate.setDate(d2);
        newDate.setWorkDaySeqID(this.workDaySeqID);
        newDate.setWeekSeqID(this.weekSeqID);
        newDate.setMonthSeqID(this.monthSeqID);
        return newDate;
    }

    public boolean equals(Object object) {
        MRPDate date2;
        if (object != null && object instanceof MRPDate && (date2 = (MRPDate)object) != null) {
            if (date2.getWorkDaySeqID() != 0 && this.getWorkDaySeqID() != 0) {
                return date2.getWorkDaySeqID() == this.getWorkDaySeqID();
            }
            if (this.getDate() != null && date2.getDate() != null) {
                return MRPUtil.dateEquals(this.date, date2.getDate());
            }
        }
        return false;
    }

    public boolean before(MRPDate d2) {
        if (d2 != null) {
            if (d2.getWorkDaySeqID() != 0 && this.getWorkDaySeqID() != 0) {
                return this.getWorkDaySeqID() < d2.getWorkDaySeqID();
            }
            if (this.getDate() != null && d2.getDate() != null) {
                return this.getDate().before(d2.getDate());
            }
        }
        return false;
    }

    public boolean after(MRPDate d2) {
        if (d2 != null) {
            if (d2.getWorkDaySeqID() != 0 && this.getWorkDaySeqID() != 0) {
                return this.getWorkDaySeqID() > d2.getWorkDaySeqID();
            }
            if (this.getDate() != null && d2.getDate() != null) {
                return this.date.after(d2.getDate());
            }
        }
        return false;
    }

    public MRPDate add(MRPCalcParam runParam, int days) {
        Calendar calendar = Calendar.getInstance();
        MRPDate retDate = new MRPDate();
        if (this.workDaySeqID + days <= 0) {
            retDate.setWorkDaySeqID(1);
            retDate.setInCalendar(-1);
            calendar.setTime(this.date.getTime());
            calendar.add(5, days);
            retDate.setSourceDate(calendar.getTime());
        } else {
            retDate.setWorkDaySeqID(this.workDaySeqID + days);
        }
        if (this.inCalendar != 0) {
            calendar.setTime(this.sourceDate);
            calendar.add(5, days);
            retDate.setSourceDate(calendar.getTime());
            retDate.setInCalendar(this.inCalendar);
        }
        return retDate;
    }

    public int getInCalendar() {
        return this.inCalendar;
    }

    public void setInCalendar(int inCalendar) {
        this.inCalendar = inCalendar;
    }

    public Date getSourceDate() {
        return this.sourceDate;
    }

    public void setSourceDate(Date sourceDate) {
        this.sourceDate = sourceDate;
    }
}

