/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.LinkedList;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.GetSubstitueMaterial;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPConstant;
import com.kingdee.eas.mm.planning.app.mrp.MRPDetailInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialDataInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialStatisticsInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPMaterialTableDAO;
import com.kingdee.eas.mm.planning.app.mrp.MRPNetReqSaver;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.app.mrp.MRPSubstituteHelper;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import edu.emory.mathcs.backport.java.util.Collections;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MRPFetchMaterialDataUtil
implements GetSubstitueMaterial {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.planning.app.mrp.MRPFetchMaterialDataUtil");
    private HashMap correlativeReqTypeMap;
    protected HashMap preQty;
    private List materialIdList;
    private HashMap materials;
    private MRPCalcParam runParam;
    private List statisticsBufferList;
    private int lastSeq;
    private MRPMaterialStatisticsInfo lastStatisticsInfo;
    private boolean hasGetAllData;
    private List delayStatisticsInfos;
    private int lastDelayPeriod;
    private MRPNetReqSaver dataSaver;

    MRPFetchMaterialDataUtil(MRPCalcParam runParam) {
        if (MRPStep.isMoreInfo.booleanValue()) {
            logger.setLevel(Level.INFO);
        } else {
            logger.setLevel(Level.ERROR);
        }
        this.correlativeReqTypeMap = new HashMap();
        this.preQty = new HashMap();
        this.materialIdList = null;
        this.materials = new HashMap();
        this.runParam = null;
        this.statisticsBufferList = new ArrayList();
        this.lastSeq = 0;
        this.hasGetAllData = false;
        this.runParam = runParam;
    }

    public void setDataSaver(MRPNetReqSaver dataSaver) {
        this.dataSaver = dataSaver;
    }

    public int[] setMaterialIdList(List idList) throws EASBizException, BOSException {
        this.materialIdList = idList;
        this.statisticsBufferList.clear();
        this.lastSeq = 0;
        this.hasGetAllData = false;
        this.materials = MRPMaterialTableDAO.getLevelMaterialInfo(this.runParam, idList);
        return this.getCalcPeriod(idList);
    }

    public int[] getCalcPeriod(List idList) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FPeriod from ").append(this.runParam.getStatisticsTable()).append(" where ");
        for (int i = 0; i < idList.size(); ++i) {
            sql.append(" FMaterialID = ?");
            if (i == idList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(" order by FPeriod ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])idList.toArray());
        int[] periods = new int[rs.size()];
        try {
            int i = 0;
            while (rs.next()) {
                periods[i++] = rs.getInt("FPeriod");
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return periods;
    }

    public List getDeLayPerid(MRPCalcParam runParam, String materialID, String projectNumber, String trackNumber, int period, int lastSeq) throws BOSException, MRPException {
        java.util.LinkedList<MRPMaterialStatisticsInfo> delayPeriod = new java.util.LinkedList<MRPMaterialStatisticsInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from  ").append(runParam.getStatisticsTable()).append(" s ").append(" where s.FMaterialID = ? and s.Fperiod > ? and s.FOnHand+s.FSqty+s.FRQty<0").append(" and s.FProjectNumber = ? and s.FTrackNumber = ? and s.KSQL_SEQ>?").append(" order by  s.KSQL_SEQ");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{materialID, new Integer(period), projectNumber, trackNumber, new Integer(lastSeq)});
        try {
            MRPMaterialStatisticsInfo statisticsInfo = null;
            while (rs.next()) {
                statisticsInfo = this.getStatisticsInfoInMemory(rs.getInt("KSQL_seq"));
                if (statisticsInfo == null) {
                    statisticsInfo = MRPMaterialStatisticsInfo.readrs(rs);
                }
                delayPeriod.add(statisticsInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return delayPeriod;
    }

    public List getDeLayPerid(MRPCalcParam runParam, String materialID, int period) throws BOSException, MRPException {
        java.util.LinkedList<MRPMaterialStatisticsInfo> delayPeriod = new java.util.LinkedList<MRPMaterialStatisticsInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("select top 50 * from  ").append(runParam.getStatisticsTable()).append(" s ").append(" where s.FMaterialID = ? and s.Fperiod > ? and s.FOnHand+s.FSqty+s.FRQty<0").append(" order by  s.KSQL_SEQ");
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{materialID, new Integer(period)});
        try {
            MRPMaterialStatisticsInfo statisticsInfo = null;
            while (rs.next()) {
                statisticsInfo = this.getStatisticsInfoInMemory(rs.getInt("KSQL_seq"));
                if (statisticsInfo == null) {
                    statisticsInfo = MRPMaterialStatisticsInfo.readrs(rs);
                }
                delayPeriod.add(statisticsInfo);
            }
            if (rs.size() >= 50) {
                sql.setLength(0);
                sql.append("select * from ").append(runParam.getStatisticsTable()).append(" s ").append(" where s.FMaterialID = ? and s.Fperiod = ? and s.FOnHand+s.FSqty+s.FRQty<0").append(" and s.KSQL_SEQ>? ").append(" order by s.KSQL_SEQ");
                rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{materialID, new Integer(statisticsInfo.getPeriod()), new Integer(statisticsInfo.getSeq())});
                while (rs.next()) {
                    statisticsInfo = this.getStatisticsInfoInMemory(rs.getInt("KSQL_seq"));
                    if (statisticsInfo == null) {
                        statisticsInfo = MRPMaterialStatisticsInfo.readrs(rs);
                    }
                    delayPeriod.add(statisticsInfo);
                }
            }
            if (statisticsInfo != null) {
                this.lastDelayPeriod = statisticsInfo.getPeriod();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return delayPeriod;
    }

    public Object[] getOneDayDelayS(MRPCalcParam runParam, MRPMaterialDataInfo materialDataInfo, int period, boolean needFresh) throws BOSException, MRPException {
        LinkedList oneDayDelayS = new LinkedList();
        MRPMaterialStatisticsInfo delayS2 = null;
        if (needFresh || this.delayStatisticsInfos == null || this.lastDelayPeriod == 0 || this.lastDelayPeriod <= period) {
            this.delayStatisticsInfos = this.getDeLayPerid(runParam, materialDataInfo.getMaterialID(), period);
        }
        int delayPeriod = 0;
        for (MRPMaterialStatisticsInfo delayS2 : this.delayStatisticsInfos) {
            if (delayPeriod == 0) {
                delayPeriod = delayS2.getPeriod();
            } else if (delayPeriod != delayS2.getPeriod()) break;
            oneDayDelayS.add(delayS2);
        }
        this.delayStatisticsInfos.removeAll((Collection<?>)oneDayDelayS);
        Object[] obj = new Object[]{new Integer(delayPeriod), oneDayDelayS};
        return obj;
    }

    public MRPMaterialStatisticsInfo getStatisticsInfoInMemory(int period, String materialID, String projectNumber, String trackNumber) {
        MRPMaterialStatisticsInfo statisticsInfo = null;
        for (int i = 0; i < this.statisticsBufferList.size(); ++i) {
            statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(i);
            if (statisticsInfo.getPeriod() != period || !statisticsInfo.getMaterialID().equals(materialID) || !statisticsInfo.getProjectNumber().equals(projectNumber) || !statisticsInfo.getTrackNumber().equals(trackNumber)) continue;
            return statisticsInfo;
        }
        return null;
    }

    public MRPMaterialStatisticsInfo getStatisticsInfo(MRPDetailInfo detailInfo) throws MRPException, BOSException {
        MRPMaterialStatisticsInfo statisticsInfo = this.getStatisticsInfoInMemory(detailInfo.getPeriod(), detailInfo.getMaterialID(), detailInfo.getProjectNumber(), detailInfo.getTrackNumber());
        if (statisticsInfo == null) {
            this.fillBuffer(detailInfo.getSeq());
            statisticsInfo = this.getStatisticsInfoInMemory(detailInfo.getPeriod(), detailInfo.getMaterialID(), detailInfo.getProjectNumber(), detailInfo.getTrackNumber());
        }
        return statisticsInfo;
    }

    public MRPMaterialStatisticsInfo getStatisticsInfoInMemory(int seq) {
        MRPMaterialStatisticsInfo statisticsInfo = null;
        for (int i = 0; i < this.statisticsBufferList.size(); ++i) {
            statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(i);
            if (statisticsInfo.getSeq() != seq) continue;
            return statisticsInfo;
        }
        return null;
    }

    public void updateStatisticsInfoInMemory(MRPMaterialStatisticsInfo info) {
        MRPMaterialStatisticsInfo statisticsInfo = null;
        for (int i = 0; i < this.statisticsBufferList.size(); ++i) {
            statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(i);
            if (statisticsInfo.getSeq() != info.getSeq()) continue;
            this.statisticsBufferList.set(i, info);
            break;
        }
    }

    public MRPMaterialStatisticsInfo getNextStatisticData(String materialID, int period) throws BOSException {
        MRPMaterialStatisticsInfo statisticsInfo = null;
        if (this.statisticsBufferList.size() > 0) {
            statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(0);
            if (materialID.equals(statisticsInfo.getMaterialID()) && period == statisticsInfo.getPeriod()) {
                this.statisticsBufferList.remove(0);
            } else {
                statisticsInfo = null;
            }
        }
        return statisticsInfo;
    }

    public boolean hasNextMaterial(int period) throws BOSException, MRPException {
        return this.hasNextStatisticData(null, period);
    }

    public MRPMaterialDataInfo getNextMaterial(int period) throws BOSException {
        MRPMaterialStatisticsInfo statisticsInfo;
        MRPMaterialDataInfo materialInfo = null;
        if (this.statisticsBufferList.size() > 0 && period == (statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(0)).getPeriod()) {
            materialInfo = this.getMaterialInfo(statisticsInfo.getMaterialID());
        }
        return materialInfo;
    }

    public boolean hasNextStatisticData(String materialID, int period) throws BOSException, MRPException {
        boolean bret = false;
        if (this.statisticsBufferList.size() <= 0 && !this.hasGetAllData) {
            this.fillBuffer();
        }
        MRPMaterialStatisticsInfo statisticsInfo = null;
        if (this.statisticsBufferList.size() > 0) {
            statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(0);
        }
        if (statisticsInfo != null) {
            bret = materialID != null ? materialID.equals(statisticsInfo.getMaterialID()) && period == statisticsInfo.getPeriod() : period == statisticsInfo.getPeriod();
        }
        return bret;
    }

    private void fillBuffer() throws BOSException, MRPException {
        try {
            this.dataSaver.execute(true);
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(2000).append("  * from ").append(this.runParam.getStatisticsTable()).append(" where ( ");
        for (int i = 0; i < this.materialIdList.size(); ++i) {
            sql.append(" FMaterialID = ?");
            if (i == this.materialIdList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(" ) AND KSQL_seq> ? ").append(" order by KSQL_seq ");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.addAll(this.materialIdList);
        params.add(new Integer(this.lastSeq));
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])params.toArray());
        if (rs.size() > 0) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"32_MRPFetchMaterialDataUtil", (Locale)this.runParam.getCtx().getLocale()) + String.valueOf(rs.size())));
            try {
                MRPMaterialStatisticsInfo statisticsInfo = null;
                while (rs.next()) {
                    statisticsInfo = MRPMaterialStatisticsInfo.readrs(rs);
                    this.statisticsBufferList.add(statisticsInfo);
                }
                this.lastSeq = statisticsInfo.getSeq();
                this.lastStatisticsInfo = statisticsInfo;
                this.hasGetAllData = rs.size() < 2000;
                rs = null;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        } else {
            this.hasGetAllData = true;
        }
    }

    private void fillBuffer(int newLastSeq) throws BOSException, MRPException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ").append(this.runParam.getStatisticsTable()).append(" where ( ");
        for (int i = 0; i < this.materialIdList.size(); ++i) {
            sql.append(" FMaterialID = ?");
            if (i == this.materialIdList.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append(" ) AND KSQL_seq> ? and KSQL_seq<=?").append(" order by KSQL_seq ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(this.materialIdList);
        params.add(new Integer(this.lastSeq));
        params.add(new Integer(newLastSeq));
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])params.toArray());
        try {
            if (rs.size() > 0) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"33_MRPFetchMaterialDataUtil", (Locale)this.runParam.getCtx().getLocale()) + String.valueOf(rs.size())));
            }
            MRPMaterialStatisticsInfo statisticsInfo = null;
            while (rs.next()) {
                statisticsInfo = MRPMaterialStatisticsInfo.readrs(rs);
                this.statisticsBufferList.add(statisticsInfo);
            }
            this.lastSeq = statisticsInfo.getSeq();
            sql.setLength(0);
            sql.append("select * from ").append(this.runParam.getStatisticsTable()).append(" where ");
            sql.append(" KSQL_seq> ? and FPeriod=? and FMaterialId=?").append(" order by KSQL_seq ");
            params.clear();
            params.add(new Integer(this.lastSeq));
            params.add(new Integer(statisticsInfo.getPeriod()));
            params.add(statisticsInfo.getMaterialID());
            rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])params.toArray());
            if (rs.size() > 0) {
                logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.mm.planning.PLANNINGAutoGenerateResource", (String)"33_MRPFetchMaterialDataUtil", (Locale)this.runParam.getCtx().getLocale()) + String.valueOf(rs.size())));
            }
            while (rs.next()) {
                statisticsInfo = MRPMaterialStatisticsInfo.readrs(rs);
                this.statisticsBufferList.add(statisticsInfo);
            }
            this.lastSeq = statisticsInfo.getSeq();
            this.lastStatisticsInfo = statisticsInfo;
            rs = null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public List getNextSeq(int fromSeq) {
        int detailCount = 0;
        ArrayList<Integer> seqList = new ArrayList<Integer>();
        seqList.add(new Integer(fromSeq));
        MRPMaterialStatisticsInfo statisticsInfo = null;
        for (int i = 0; i < this.statisticsBufferList.size(); ++i) {
            statisticsInfo = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(i);
            if (statisticsInfo.getSeq() <= fromSeq) continue;
            if ((detailCount += statisticsInfo.getDetailCount()) >= 2000 || this.materialIdList.size() * 2 + seqList.size() >= 2000) break;
            seqList.add(new Integer(statisticsInfo.getSeq()));
        }
        return seqList;
    }

    public void fetchCorrelativeReqType(MRPCalcParam runParam, List idList) throws BOSException, MRPException {
        this.correlativeReqTypeMap.clear();
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fmaterialid,t2.fcorrelativereqtype from t_bd_materialplan t1,t_mm_requirementuniterule t2 where t1.frequniteruleid = t2.fid and t1.forgunit='").append(runParam.getStorageOrgUnitID()).append("'");
        for (int i = 0; i < idList.size(); ++i) {
            if (i == 0) {
                sql.append("  and (");
            }
            sql.append(" t1.FMaterialID = ?");
            if (i != idList.size() - 1) {
                sql.append(" OR ");
                continue;
            }
            sql.append(") ");
        }
        IRowSet rs = SQLUtils.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])idList.toArray());
        try {
            while (rs.next()) {
                this.correlativeReqTypeMap.put(rs.getString(1), new Integer(rs.getInt(2)));
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public int getCorrelativeReqType(String materialId) {
        Integer reqType = (Integer)this.correlativeReqTypeMap.get(materialId);
        return reqType == null ? 0 : reqType;
    }

    public MRPMaterialDataInfo getOneMaterialSData(String materialID) {
        return this.getMaterialInfo(materialID);
    }

    public MRPMaterialDataInfo getMaterialInfo(String materialID) {
        MRPMaterialDataInfo materialDataInfo = null;
        if (this.materials != null) {
            materialDataInfo = (MRPMaterialDataInfo)this.materials.get(materialID);
        }
        return materialDataInfo;
    }

    private String[] matchingStrategy(MRPMaterialDataInfo materialDataInfo, MRPMaterialDataInfo submaterialDataInfo, MRPCalcParam runParam, String projectNumber, String trackNumber) {
        boolean[] isolationRule = this.isolationRule(materialDataInfo);
        boolean[] subIsolationRule = this.isolationRule(submaterialDataInfo);
        String subProjectNumber = isolationRule[0] && subIsolationRule[0] ? projectNumber : runParam.getProjectNumber();
        String subTrackNumber = isolationRule[1] && subIsolationRule[1] ? trackNumber : runParam.getTrackNumber();
        return new String[]{subProjectNumber, subTrackNumber};
    }

    private boolean[] isolationRule(MRPMaterialDataInfo materialDataInfo) {
        boolean isProjectNumberIsolation = false;
        boolean isTrackNumberIsolation = false;
        String planStrategy = materialDataInfo.getPlanStrategy();
        if (planStrategy.equalsIgnoreCase("NUnM+gEcEADgAA3cwKgL09g0uEU=") || planStrategy.equalsIgnoreCase("NUnM+gEcEADgAA3ewKgL09g0uEU=") || planStrategy.equalsIgnoreCase("NUnM+gEcEADgAA3gwKgL09g0uEU=") || planStrategy.equalsIgnoreCase("qAYfaBzUrmLgQKjAYj0f3dg0uEU=")) {
            isProjectNumberIsolation = false;
            isTrackNumberIsolation = false;
        } else if (planStrategy.equalsIgnoreCase("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || planStrategy.equalsIgnoreCase("qAYfaBzTrmLgQKjAYj0f3dg0uEU=") || planStrategy.equalsIgnoreCase("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || planStrategy.equalsIgnoreCase("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=")) {
            isProjectNumberIsolation = false;
            isTrackNumberIsolation = true;
        } else if (planStrategy.equalsIgnoreCase("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || planStrategy.equalsIgnoreCase("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
            if (IsolatedRuleEnum.ITEM_TRACKNO.equals((Object)materialDataInfo.getIsolatedRule())) {
                isProjectNumberIsolation = true;
                isTrackNumberIsolation = true;
            } else {
                isProjectNumberIsolation = true;
                isTrackNumberIsolation = false;
            }
        }
        return new boolean[]{isProjectNumberIsolation, isTrackNumberIsolation};
    }

    protected void setPreQty(HashMap preQty) {
        this.preQty = preQty;
    }

    public HashMap getAvailableQtyByMaterial(String[] materialIds, String parentMaterialid, String projectNumber, String trackNumber, int period) throws EASBizException, BOSException {
        MRPMaterialDataInfo materialDataInfo = (MRPMaterialDataInfo)this.materials.get(parentMaterialid);
        MRPMaterialDataInfo submaterialDataInfo = null;
        MRPMaterialStatisticsInfo statisticsInfo = null;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        String projectNumberSub = null;
        String trackNumberSub = null;
        BigDecimal scrapRate = null;
        Integer scrapExp = null;
        MRPSubstituteHelper helper = new MRPSubstituteHelper(this.runParam.getCtx());
        helper.setStorageOrgUnitId(this.runParam.getStorageOrgUnitID());
        Map planInfos = helper.getMaterialPlanInfos(materialIds);
        for (int i = 0; i < materialIds.length; ++i) {
            if (this.materials.get(materialIds[i]) != null) {
                submaterialDataInfo = (MRPMaterialDataInfo)this.materials.get(materialIds[i]);
                String[] projectAndTrackNo = this.matchingStrategy(materialDataInfo, submaterialDataInfo, this.runParam, projectNumber, trackNumber);
                projectNumberSub = projectAndTrackNo[0];
                trackNumberSub = projectAndTrackNo[1];
                String materialId = submaterialDataInfo.getMaterialID();
                statisticsInfo = this.getStatisticsInfo(materialId, period, projectNumberSub, trackNumberSub);
                String key = submaterialDataInfo.getMaterialID() + projectNumberSub + trackNumberSub;
                BigDecimal pab = (BigDecimal)this.preQty.get(key);
                if (pab == null) {
                    pab = MRPConstant.ZERO;
                }
                logger.info((Object)(submaterialDataInfo.getMaterialNumber() + " replace " + materialDataInfo.getMaterialNumber()));
                pab = pab.add(this.calculateQty4Substitute(materialDataInfo, submaterialDataInfo, statisticsInfo));
                logger.info((Object)(submaterialDataInfo.getMaterialNumber() + " available qty: " + pab));
                scrapRate = (BigDecimal)planInfos.get(materialIds[i] + "scrapRate");
                scrapExp = (Integer)planInfos.get(materialIds[i] + "scrapRateExpression");
                pab = MRPUtil.calculateStandardQty(pab, scrapRate, scrapExp, submaterialDataInfo.getBaseQtyPrc(), this.runParam.isWastageRate());
                logger.info((Object)(submaterialDataInfo.getMaterialNumber() + " available standarQty: " + pab));
                map.put(materialIds[i], pab);
                continue;
            }
            map.put(materialIds[i], null);
        }
        return map;
    }

    public MRPMaterialStatisticsInfo getStatisticsInfo(String materialId, int period, String projectNumber, String trackNumber) throws BOSException, EASBizException {
        MRPMaterialStatisticsInfo statisticsInfo = null;
        for (int j = 0; j < this.statisticsBufferList.size(); ++j) {
            MRPMaterialStatisticsInfo statisticsInfoTemp = (MRPMaterialStatisticsInfo)this.statisticsBufferList.get(j);
            if (statisticsInfoTemp.getPeriod() != period || !statisticsInfoTemp.getMaterialID().equals(materialId) || !statisticsInfoTemp.getProjectNumber().equals(projectNumber) || !statisticsInfoTemp.getTrackNumber().equals(trackNumber)) continue;
            statisticsInfo = statisticsInfoTemp;
            break;
        }
        if (statisticsInfo == null && !this.hasGetAllData && this.lastStatisticsInfo.getPeriod() == period) {
            StringBuffer sql = new StringBuffer();
            sql.append("select KSQL_SEQ from ").append(this.runParam.getStatisticsTable()).append(" where FPeriod=? and FMaterialId=? and FProjectNumber=? and FTrackNumber=?");
            IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(period), materialId, projectNumber, trackNumber});
            try {
                if (rs.next()) {
                    int seq = rs.getInt("KSQL_SEQ");
                    this.fillBuffer(seq);
                    statisticsInfo = this.lastStatisticsInfo;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException();
            }
        }
        if (statisticsInfo == null) {
            statisticsInfo = new MRPMaterialStatisticsInfo();
            statisticsInfo.setId(BOSUuid.create((String)"F94043EF").toString());
            statisticsInfo.setPeriod(period);
            statisticsInfo.setMaterialID(materialId);
            statisticsInfo.setProjectNumber(projectNumber);
            statisticsInfo.setTrackNumber(trackNumber);
            statisticsInfo.setIsDeaultTNO(2);
            if (this.runParam.getTrackNumber().equals(trackNumber)) {
                statisticsInfo.setIsDeaultTNO(1);
            }
            MRPMaterialDataInfo materialInfo = (MRPMaterialDataInfo)this.materials.get(materialId);
            statisticsInfo.setPlanStrategy(materialInfo.getPlanStrategy());
            statisticsInfo.setSubstituteGroup(materialInfo.getSubstituteGroup());
            statisticsInfo.setMaterialNumber(materialInfo.getMaterialNumber());
            statisticsInfo.setCalcSeq(materialInfo.getCalcSeq());
            this.statisticsBufferList.add(statisticsInfo);
            Collections.sort((List)this.statisticsBufferList);
            this.dataSaver.addInsertList(statisticsInfo);
        }
        return statisticsInfo;
    }

    public List getSuitableReplaceMaterial(Context ctx, String materialId, String bomId, Date reqDate, int period, BigDecimal reqQty, BigDecimal avaQty, String storageOrgUnitId, String projectNumber, String trackNumber, BigDecimal unitQty) throws BOSException, EASBizException {
        return null;
    }

    public void materialReplaceGrouping(Context ctx, String materialTable, String storageOrgUnitId) throws BOSException {
    }

    public void setRunParam(MRPCalcParam runParam) {
        this.runParam = runParam;
    }

    public HashMap getMaterials() {
        return this.materials;
    }

    private BigDecimal calculateQty4Substitute(MRPMaterialDataInfo materialInfo, MRPMaterialDataInfo subMaterialInfo, MRPMaterialStatisticsInfo statisticsInfo) throws MRPException, BOSException {
        BigDecimal qty = MRPConstant.ZERO;
        BigDecimal onHandQty = MRPConstant.ZERO;
        BigDecimal scheduledQty = MRPConstant.ZERO;
        BigDecimal reqQty = MRPConstant.ZERO;
        String projectNumber = statisticsInfo.getProjectNumber();
        String trackNumber = statisticsInfo.getTrackNumber();
        ArrayList<String> groupMTS = new ArrayList<String>();
        ArrayList<String> group10 = new ArrayList<String>();
        ArrayList<String> group20 = new ArrayList<String>();
        ArrayList<String> group10And20 = new ArrayList<String>();
        groupMTS.add("NUnM+gEcEADgAA3cwKgL09g0uEU=");
        groupMTS.add("NUnM+gEcEADgAA3ewKgL09g0uEU=");
        groupMTS.add("NUnM+gEcEADgAA3gwKgL09g0uEU=");
        groupMTS.add("qAYfaBzUrmLgQKjAYj0f3dg0uEU=");
        group10.add("GE2FIa4GQ6uhdx0RDGuibtg0uEU=");
        group10.add("fpPxtypCS/ihJ30GjB/UJtg0uEU=");
        group10.add("qAYbemEdG9ngQKjAYj0V1dg0uEU=");
        group20.add("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
        group20.add("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=");
        group20.add("qAYfaBzTrmLgQKjAYj0f3dg0uEU=");
        group10And20.addAll(group10);
        group10And20.addAll(group20);
        String materialPlanStrategy = materialInfo.getPlanStrategy();
        String subMaterialPlanStrategy = subMaterialInfo.getPlanStrategy();
        if ((groupMTS.contains(subMaterialPlanStrategy) || group20.contains(subMaterialPlanStrategy)) && group10And20.contains(materialPlanStrategy)) {
            onHandQty = subMaterialInfo.getOnHandQty(projectNumber, trackNumber);
            scheduledQty = statisticsInfo.getSQty();
            reqQty = statisticsInfo.getRQty();
        } else if (groupMTS.contains(subMaterialPlanStrategy) && groupMTS.contains(materialPlanStrategy)) {
            onHandQty = subMaterialInfo.getOnHandQty(projectNumber, trackNumber);
            scheduledQty = statisticsInfo.getSQty();
            reqQty = statisticsInfo.getRQty();
        } else if (group10.contains(subMaterialPlanStrategy) && (groupMTS.contains(materialPlanStrategy) || group10And20.contains(materialPlanStrategy))) {
            onHandQty = subMaterialInfo.getOnHandQty(projectNumber, trackNumber);
            scheduledQty = statisticsInfo.getSQty();
            reqQty = this.getReqQty(subMaterialInfo.getMaterialID(), statisticsInfo.getPeriod());
        } else if (group20.contains(subMaterialPlanStrategy) && groupMTS.contains(materialPlanStrategy)) {
            onHandQty = subMaterialInfo.getOnHandQty(projectNumber, trackNumber);
        }
        qty = qty.add(onHandQty).add(scheduledQty).add(reqQty).add(statisticsInfo.getPreQty());
        return qty;
    }

    private BigDecimal getReqQty(String materialId, int period) throws MRPException, BOSException {
        BigDecimal reqQty = MRPConstant.ZERO;
        StringBuffer sql = new StringBuffer();
        sql.append("select isNull(sum(FRQty), 0) FSumRQty from ").append(this.runParam.getStatisticsTable()).append(" where FMaterialId=? and FPeriod=? group by FMaterialId ");
        IRowSet rs = SQLUtils.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{materialId, new Integer(period)});
        try {
            if (rs.next()) {
                reqQty = rs.getBigDecimal("FSumRQty");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
        return reqQty;
    }
}

