/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.app.mrp;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.planning.MRPException;
import com.kingdee.eas.mm.planning.app.mrp.MRPBillParamInfo;
import com.kingdee.eas.mm.planning.app.mrp.MRPCalcParam;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetCPlanOrder;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetData;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetDependentReq;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetMOStock;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetManufactureOrder;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetOuterOrder;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetOuterOrderEntry;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetOuterPurReqEntry;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetOuterPurReqOrder;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetPlanOrder;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetPlannedOrderOutputs;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetProdOrder;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetProdStock;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetPurContractBillData;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetPurOrderBillData;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetPurRequestBillData;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetRequirementPlanData;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetStockTransferBillData;
import com.kingdee.eas.mm.planning.app.mrp.MRPGetTransferOrderBillData;
import com.kingdee.eas.mm.planning.app.mrp.MRPResource;
import com.kingdee.eas.mm.planning.app.mrp.MRPSeqUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPStep;
import com.kingdee.eas.mm.planning.customization.CustomizationConfigBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MRPGetBillData
extends MRPStep {
    protected List billList = null;
    private int level = -1;

    protected void registBill() {
        if (this.billList == null) {
            this.billList = new ArrayList();
            this.registBill(this.runParam, this.billList);
        }
    }

    protected void registBill(MRPCalcParam runParam, List billList) {
        billList.add(new MRPGetRequirementPlanData());
        if (!runParam.isCareScheduleRec()) {
            return;
        }
        if (runParam.getBillParamMap() == null) {
            this.initSupplyDatas(runParam);
        } else {
            Iterator it = runParam.getBillParamMap().keySet().iterator();
            MRPBillParamInfo paramInfo = null;
            while (it.hasNext()) {
                String billTypeId = (String)it.next();
                paramInfo = (MRPBillParamInfo)runParam.getBillParamMap().get(billTypeId);
                if (!paramInfo.isParticipate()) continue;
                if (billTypeId.equals("50957179-0105-1000-e003-3152c0a812fd463ED552")) {
                    billList.add(new MRPGetStockTransferBillData());
                    continue;
                }
                if (billTypeId.equals("Eg5BUQEVEADgAAABwKgOEEY+1VI=")) {
                    billList.add(new MRPGetTransferOrderBillData());
                    continue;
                }
                if (billTypeId.equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
                    billList.add(new MRPGetPurOrderBillData());
                    continue;
                }
                if (billTypeId.equals("510b6503-0105-1000-e000-010bc0a813fd463ED552")) {
                    billList.add(new MRPGetPurContractBillData());
                    continue;
                }
                if (billTypeId.equals("510b6503-0105-1000-e000-0107c0a812fd463ED552")) {
                    billList.add(new MRPGetPurRequestBillData());
                    continue;
                }
                if (billTypeId.equals("9XXvbVGlRtym/0qtqeIXXrhE1B8=")) {
                    billList.add(new MRPGetPlanOrder());
                    billList.add(new MRPGetDependentReq());
                    continue;
                }
                if (billTypeId.equals("ejIZHXXTQliYCQJg9t4Re0Y+1VI=")) {
                    billList.add(new MRPGetProdOrder());
                    billList.add(new MRPGetProdStock());
                    continue;
                }
                if (billTypeId.equals("B2aZSVXaSx6qxdfekgCmrEY+1VI=")) {
                    billList.add(new MRPGetManufactureOrder());
                    billList.add(new MRPGetMOStock());
                    continue;
                }
                if (billTypeId.equals("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=")) {
                    billList.add(new MRPGetOuterOrder());
                    billList.add(new MRPGetOuterOrderEntry());
                    continue;
                }
                if (billTypeId.equals("BUztSVXaSxu9edfekgCmrEY+1VI=")) {
                    billList.add(new MRPGetOuterPurReqOrder());
                    billList.add(new MRPGetOuterPurReqEntry());
                    continue;
                }
                if (!billTypeId.equals("tMCsjuu0TMO+jMoUTkrsSkY+1VI=")) continue;
                billList.add(new MRPGetCPlanOrder());
            }
        }
        CustomizationConfigBase configBase = new CustomizationConfigBase();
        boolean isSupportCoByProduct = configBase.getCoByProductCustomFlag();
        if (isSupportCoByProduct) {
            billList.add(new MRPGetPlannedOrderOutputs());
        }
    }

    private void ajustWorkDate() throws BOSException, EASBizException {
        MRPSeqUtil.updateRequirementDate(this.runParam);
        MRPSeqUtil.updateSupplyDate(this.runParam);
    }

    private void initSupplyDatas(MRPCalcParam runParam) {
    }

    @Override
    protected String getStepDesc(MRPCalcParam runParam) throws MRPException, BOSException {
        String msg = MRPResource.getString(runParam.getCtx(), "SP_BILLDATA");
        if (this.level != -1) {
            msg = MRPResource.getString(runParam.getCtx(), "NO") + String.valueOf(runParam.getLevel()) + MRPResource.getString(runParam.getCtx(), "LEVEL") + "," + msg;
        }
        return msg;
    }

    @Override
    protected Object innerExecute(MRPCalcParam runParam) throws EASBizException, BOSException {
        if (runParam.isMaterialPlan() && this.level == -1) {
            this.setLevel(runParam.getLevel());
        }
        this.registBill();
        for (MRPGetData step : this.billList) {
            step.setLevel(this.level);
            step.execute(runParam);
            this.dataAmount += step.getDataAmount();
        }
        if (this.dataAmount > 0) {
            logger.info((Object)"ajustWorkDate begin");
            this.ajustWorkDate();
            logger.info((Object)"ajustWorkDate end");
        }
        return null;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public List getSubSteps(MRPCalcParam runParam) {
        this.initMRPBillParam(runParam);
        this.runParam = runParam;
        this.registBill();
        return this.billList;
    }
}

